#version 300 es
// brush_opacity
// features: ["ALPHA_PASS"]

struct RectWithEndpoint {
  vec2 p0;
  vec2 p1;
};
uniform highp mat4 uTransform;
in highp vec2 aPosition;
uniform lowp sampler2D sColor0;
uniform highp sampler2D sRenderTasks;
uniform highp sampler2D sGpuCache;
flat out highp vec4 vTransformBounds;
uniform highp sampler2D sTransformPalette;
flat out highp vec4 vClipMaskUvBounds;
out highp vec2 vClipMaskUv;
uniform highp sampler2D sPrimitiveHeadersF;
uniform highp isampler2D sPrimitiveHeadersI;
in highp ivec4 aData;
out highp vec2 v_local_pos;
out highp vec2 v_uv;
flat out highp vec4 v_uv_sample_bounds;
flat out highp float v_perspective;
flat out highp float v_opacity;
void main ()
{
  int instance_picture_task_address_1;
  int instance_clip_address_2;
  int instance_segment_index_3;
  int instance_flags_4;
  instance_picture_task_address_1 = (aData.y >> 16);
  instance_clip_address_2 = (aData.y & 65535);
  instance_segment_index_3 = (aData.z & 65535);
  instance_flags_4 = (aData.z >> 16);
  float ph_z_5;
  ivec2 tmpvar_6;
  tmpvar_6.x = int((2u * (
    uint(aData.x)
   % 512u)));
  tmpvar_6.y = int((uint(aData.x) / 512u));
  vec4 tmpvar_7;
  tmpvar_7 = texelFetch (sPrimitiveHeadersF, tmpvar_6, 0);
  vec4 tmpvar_8;
  tmpvar_8 = texelFetch (sPrimitiveHeadersF, (tmpvar_6 + ivec2(1, 0)), 0);
  vec2 tmpvar_9;
  vec2 tmpvar_10;
  tmpvar_9 = tmpvar_7.xy;
  tmpvar_10 = tmpvar_7.zw;
  ivec2 tmpvar_11;
  tmpvar_11.x = int((2u * (
    uint(aData.x)
   % 512u)));
  tmpvar_11.y = int((uint(aData.x) / 512u));
  ivec4 tmpvar_12;
  tmpvar_12 = texelFetch (sPrimitiveHeadersI, tmpvar_11, 0);
  ivec4 tmpvar_13;
  tmpvar_13 = texelFetch (sPrimitiveHeadersI, (tmpvar_11 + ivec2(1, 0)), 0);
  ph_z_5 = float(tmpvar_12.x);
  mat4 transform_m_14;
  bool transform_is_axis_aligned_15;
  transform_is_axis_aligned_15 = ((tmpvar_12.z >> 24) == 0);
  int tmpvar_16;
  tmpvar_16 = (tmpvar_12.z & 16777215);
  ivec2 tmpvar_17;
  tmpvar_17.x = int((8u * (
    uint(tmpvar_16)
   % 128u)));
  tmpvar_17.y = int((uint(tmpvar_16) / 128u));
  transform_m_14[0] = texelFetch (sTransformPalette, tmpvar_17, 0);
  transform_m_14[1] = texelFetch (sTransformPalette, (tmpvar_17 + ivec2(1, 0)), 0);
  transform_m_14[2] = texelFetch (sTransformPalette, (tmpvar_17 + ivec2(2, 0)), 0);
  transform_m_14[3] = texelFetch (sTransformPalette, (tmpvar_17 + ivec2(3, 0)), 0);
  ivec2 tmpvar_18;
  tmpvar_18.x = int((2u * (
    uint(instance_picture_task_address_1)
   % 512u)));
  tmpvar_18.y = int((uint(instance_picture_task_address_1) / 512u));
  vec4 tmpvar_19;
  tmpvar_19 = texelFetch (sRenderTasks, tmpvar_18, 0);
  vec4 tmpvar_20;
  tmpvar_20 = texelFetch (sRenderTasks, (tmpvar_18 + ivec2(1, 0)), 0);
  RectWithEndpoint area_task_rect_21;
  float area_device_pixel_scale_22;
  vec2 area_screen_origin_23;
  if ((instance_clip_address_2 >= 32767)) {
    area_task_rect_21 = RectWithEndpoint(vec2(0.0, 0.0), vec2(0.0, 0.0));
    area_device_pixel_scale_22 = 0.0;
    area_screen_origin_23 = vec2(0.0, 0.0);
  } else {
    ivec2 tmpvar_24;
    tmpvar_24.x = int((2u * (
      uint(instance_clip_address_2)
     % 512u)));
    tmpvar_24.y = int((uint(instance_clip_address_2) / 512u));
    vec4 tmpvar_25;
    tmpvar_25 = texelFetch (sRenderTasks, tmpvar_24, 0);
    vec4 tmpvar_26;
    tmpvar_26 = texelFetch (sRenderTasks, (tmpvar_24 + ivec2(1, 0)), 0);
    area_task_rect_21.p0 = tmpvar_25.xy;
    area_task_rect_21.p1 = tmpvar_25.zw;
    area_device_pixel_scale_22 = tmpvar_26.x;
    area_screen_origin_23 = tmpvar_26.yz;
  };
  vec2 vi_local_pos_27;
  vec4 vi_world_pos_28;
  vec2 segment_rect_p0_29;
  vec2 segment_rect_p1_30;
  int tmpvar_31;
  tmpvar_31 = (instance_flags_4 & 255);
  int tmpvar_32;
  tmpvar_32 = ((instance_flags_4 >> 8) & 255);
  if ((instance_segment_index_3 == 65535)) {
    segment_rect_p0_29 = tmpvar_9;
    segment_rect_p1_30 = tmpvar_10;
  } else {
    int tmpvar_33;
    tmpvar_33 = ((tmpvar_12.y + 3) + (instance_segment_index_3 * 2));
    ivec2 tmpvar_34;
    tmpvar_34.x = int((uint(tmpvar_33) % 1024u));
    tmpvar_34.y = int((uint(tmpvar_33) / 1024u));
    vec4 tmpvar_35;
    tmpvar_35 = texelFetch (sGpuCache, tmpvar_34, 0);
    segment_rect_p0_29 = (tmpvar_35.xy + tmpvar_7.xy);
    segment_rect_p1_30 = (tmpvar_35.zw + tmpvar_7.xy);
  };
  if (transform_is_axis_aligned_15) {
    vec2 tmpvar_36;
    tmpvar_36 = min (max (mix (segment_rect_p0_29, segment_rect_p1_30, aPosition), tmpvar_8.xy), tmpvar_8.zw);
    vec4 tmpvar_37;
    tmpvar_37.zw = vec2(0.0, 1.0);
    tmpvar_37.xy = tmpvar_36;
    vec4 tmpvar_38;
    tmpvar_38 = (transform_m_14 * tmpvar_37);
    vec4 tmpvar_39;
    tmpvar_39.xy = ((tmpvar_38.xy * tmpvar_20.x) + ((
      -(tmpvar_20.yz)
     + tmpvar_19.xy) * tmpvar_38.w));
    tmpvar_39.z = (ph_z_5 * tmpvar_38.w);
    tmpvar_39.w = tmpvar_38.w;
    gl_Position = (uTransform * tmpvar_39);
    vi_local_pos_27 = tmpvar_36;
    vi_world_pos_28 = tmpvar_38;
    vTransformBounds = vec4(-1e+16, -1e+16, 1e+16, 1e+16);
  } else {
    bvec4 tmpvar_40;
    tmpvar_40.x = bool((tmpvar_31 & 1));
    tmpvar_40.y = bool((tmpvar_31 & 2));
    tmpvar_40.z = bool((tmpvar_31 & 4));
    tmpvar_40.w = bool((tmpvar_31 & 8));
    vec4 tmpvar_41;
    tmpvar_41.xy = min (max (tmpvar_7.xy, tmpvar_8.xy), tmpvar_8.zw);
    tmpvar_41.zw = min (max (tmpvar_7.zw, tmpvar_8.xy), tmpvar_8.zw);
    vec4 tmpvar_42;
    tmpvar_42.xy = min (max (segment_rect_p0_29, tmpvar_8.xy), tmpvar_8.zw);
    tmpvar_42.zw = min (max (segment_rect_p1_30, tmpvar_8.xy), tmpvar_8.zw);
    vTransformBounds = mix(tmpvar_41, tmpvar_42, bvec4(tmpvar_40));
    vec4 tmpvar_43;
    tmpvar_43 = mix(vec4(0.0, 0.0, 0.0, 0.0), vec4(2.0, 2.0, 2.0, 2.0), bvec4(tmpvar_40));
    vec2 tmpvar_44;
    tmpvar_44 = mix ((segment_rect_p0_29 - tmpvar_43.xy), (segment_rect_p1_30 + tmpvar_43.zw), aPosition);
    vec4 tmpvar_45;
    tmpvar_45.zw = vec2(0.0, 1.0);
    tmpvar_45.xy = tmpvar_44;
    vec4 tmpvar_46;
    tmpvar_46 = (transform_m_14 * tmpvar_45);
    vec4 tmpvar_47;
    tmpvar_47.xy = ((tmpvar_46.xy * tmpvar_20.x) + ((tmpvar_19.xy - tmpvar_20.yz) * tmpvar_46.w));
    tmpvar_47.z = (ph_z_5 * tmpvar_46.w);
    tmpvar_47.w = tmpvar_46.w;
    gl_Position = (uTransform * tmpvar_47);
    vi_local_pos_27 = tmpvar_44;
    vi_world_pos_28 = tmpvar_46;
  };
  vec4 tmpvar_48;
  tmpvar_48.xy = area_task_rect_21.p0;
  tmpvar_48.zw = area_task_rect_21.p1;
  vClipMaskUvBounds = tmpvar_48;
  vClipMaskUv = ((vi_world_pos_28.xy * area_device_pixel_scale_22) + (vi_world_pos_28.w * (area_task_rect_21.p0 - area_screen_origin_23)));
  ivec2 tmpvar_49;
  tmpvar_49.x = int((uint(tmpvar_13.x) % 1024u));
  tmpvar_49.y = int((uint(tmpvar_13.x) / 1024u));
  vec4 tmpvar_50;
  tmpvar_50 = texelFetch (sGpuCache, tmpvar_49, 0);
  vec2 tmpvar_51;
  tmpvar_51 = vec2(textureSize (sColor0, 0));
  vec2 tmpvar_52;
  tmpvar_52 = ((vi_local_pos_27 - tmpvar_7.xy) / (tmpvar_7.zw - tmpvar_7.xy));
  highp int tmpvar_53;
  tmpvar_53 = (tmpvar_13.x + 2);
  ivec2 tmpvar_54;
  tmpvar_54.x = int((uint(tmpvar_53) % 1024u));
  tmpvar_54.y = int((uint(tmpvar_53) / 1024u));
  vec4 tmpvar_55;
  tmpvar_55 = mix (mix (texelFetch (sGpuCache, tmpvar_54, 0), texelFetch (sGpuCache, (tmpvar_54 + ivec2(1, 0)), 0), tmpvar_52.x), mix (texelFetch (sGpuCache, (tmpvar_54 + ivec2(2, 0)), 0), texelFetch (sGpuCache, (tmpvar_54 + ivec2(3, 0)), 0), tmpvar_52.x), tmpvar_52.y);
  vec2 tmpvar_56;
  tmpvar_56 = mix (tmpvar_50.xy, tmpvar_50.zw, (tmpvar_55.xy / tmpvar_55.w));
  float tmpvar_57;
  if (((tmpvar_32 & 1) != 0)) {
    tmpvar_57 = 1.0;
  } else {
    tmpvar_57 = 0.0;
  };
  v_uv = ((tmpvar_56 / tmpvar_51) * mix (vi_world_pos_28.w, 1.0, tmpvar_57));
  v_perspective = tmpvar_57;
  vec4 tmpvar_58;
  tmpvar_58.xy = (tmpvar_50.xy + vec2(0.5, 0.5));
  tmpvar_58.zw = (tmpvar_50.zw - vec2(0.5, 0.5));
  v_uv_sample_bounds = (tmpvar_58 / tmpvar_51.xyxy);
  v_opacity = min (max ((
    float(tmpvar_13.y)
   / 65536.0), 0.0), 1.0);
  v_local_pos = vi_local_pos_27;
}

