#version 300 es
// brush_image
// features: ["ADVANCED_BLEND", "ALPHA_PASS", "ANTIALIASING", "REPETITION", "TEXTURE_EXTERNAL"]

#extension GL_KHR_blend_equation_advanced : enable
#extension GL_OES_EGL_image_external_essl3 : enable
struct RectWithEndpoint {
  vec2 p0;
  vec2 p1;
};
uniform highp int uMode;
uniform highp mat4 uTransform;
in highp vec2 aPosition;
uniform lowp samplerExternalOES sColor0;
uniform highp sampler2D sRenderTasks;
uniform highp sampler2D sGpuCache;
flat out highp vec4 vTransformBounds;
uniform highp sampler2D sTransformPalette;
flat out highp vec4 vClipMaskUvBounds;
out highp vec2 vClipMaskUv;
uniform highp sampler2D sPrimitiveHeadersF;
uniform highp isampler2D sPrimitiveHeadersI;
in highp ivec4 aData;
out highp vec2 v_local_pos;
out highp vec2 v_uv;
flat out highp vec4 v_color;
flat out highp vec2 v_mask_swizzle;
flat out highp vec2 v_tile_repeat;
flat out highp vec4 v_uv_bounds;
flat out highp vec4 v_uv_sample_bounds;
flat out highp float v_perspective;
void main ()
{
  int instance_picture_task_address_1;
  int instance_clip_address_2;
  int instance_segment_index_3;
  int instance_flags_4;
  int instance_resource_address_5;
  instance_picture_task_address_1 = (aData.y >> 16);
  instance_clip_address_2 = (aData.y & 65535);
  instance_segment_index_3 = (aData.z & 65535);
  instance_flags_4 = (aData.z >> 16);
  instance_resource_address_5 = (aData.w & 16777215);
  float ph_z_6;
  ivec2 tmpvar_7;
  tmpvar_7.x = int((2u * (
    uint(aData.x)
   % 512u)));
  tmpvar_7.y = int((uint(aData.x) / 512u));
  vec4 tmpvar_8;
  tmpvar_8 = texelFetch (sPrimitiveHeadersF, tmpvar_7, 0);
  vec4 tmpvar_9;
  tmpvar_9 = texelFetch (sPrimitiveHeadersF, (tmpvar_7 + ivec2(1, 0)), 0);
  vec2 tmpvar_10;
  vec2 tmpvar_11;
  tmpvar_10 = tmpvar_8.xy;
  tmpvar_11 = tmpvar_8.zw;
  ivec2 tmpvar_12;
  tmpvar_12.x = int((2u * (
    uint(aData.x)
   % 512u)));
  tmpvar_12.y = int((uint(aData.x) / 512u));
  ivec4 tmpvar_13;
  tmpvar_13 = texelFetch (sPrimitiveHeadersI, tmpvar_12, 0);
  ivec4 tmpvar_14;
  tmpvar_14 = texelFetch (sPrimitiveHeadersI, (tmpvar_12 + ivec2(1, 0)), 0);
  ph_z_6 = float(tmpvar_13.x);
  mat4 transform_m_15;
  bool transform_is_axis_aligned_16;
  transform_is_axis_aligned_16 = ((tmpvar_13.z >> 24) == 0);
  int tmpvar_17;
  tmpvar_17 = (tmpvar_13.z & 16777215);
  ivec2 tmpvar_18;
  tmpvar_18.x = int((8u * (
    uint(tmpvar_17)
   % 128u)));
  tmpvar_18.y = int((uint(tmpvar_17) / 128u));
  transform_m_15[0] = texelFetch (sTransformPalette, tmpvar_18, 0);
  transform_m_15[1] = texelFetch (sTransformPalette, (tmpvar_18 + ivec2(1, 0)), 0);
  transform_m_15[2] = texelFetch (sTransformPalette, (tmpvar_18 + ivec2(2, 0)), 0);
  transform_m_15[3] = texelFetch (sTransformPalette, (tmpvar_18 + ivec2(3, 0)), 0);
  ivec2 tmpvar_19;
  tmpvar_19.x = int((2u * (
    uint(instance_picture_task_address_1)
   % 512u)));
  tmpvar_19.y = int((uint(instance_picture_task_address_1) / 512u));
  vec4 tmpvar_20;
  tmpvar_20 = texelFetch (sRenderTasks, tmpvar_19, 0);
  vec4 tmpvar_21;
  tmpvar_21 = texelFetch (sRenderTasks, (tmpvar_19 + ivec2(1, 0)), 0);
  RectWithEndpoint area_task_rect_22;
  float area_device_pixel_scale_23;
  vec2 area_screen_origin_24;
  if ((instance_clip_address_2 >= 32767)) {
    area_task_rect_22 = RectWithEndpoint(vec2(0.0, 0.0), vec2(0.0, 0.0));
    area_device_pixel_scale_23 = 0.0;
    area_screen_origin_24 = vec2(0.0, 0.0);
  } else {
    ivec2 tmpvar_25;
    tmpvar_25.x = int((2u * (
      uint(instance_clip_address_2)
     % 512u)));
    tmpvar_25.y = int((uint(instance_clip_address_2) / 512u));
    vec4 tmpvar_26;
    tmpvar_26 = texelFetch (sRenderTasks, tmpvar_25, 0);
    vec4 tmpvar_27;
    tmpvar_27 = texelFetch (sRenderTasks, (tmpvar_25 + ivec2(1, 0)), 0);
    area_task_rect_22.p0 = tmpvar_26.xy;
    area_task_rect_22.p1 = tmpvar_26.zw;
    area_device_pixel_scale_23 = tmpvar_27.x;
    area_screen_origin_24 = tmpvar_27.yz;
  };
  vec2 vi_local_pos_28;
  vec4 vi_world_pos_29;
  vec2 segment_rect_p0_30;
  vec2 segment_rect_p1_31;
  highp vec4 segment_data_32;
  int tmpvar_33;
  tmpvar_33 = (instance_flags_4 & 255);
  int tmpvar_34;
  tmpvar_34 = ((instance_flags_4 >> 8) & 255);
  if ((instance_segment_index_3 == 65535)) {
    segment_rect_p0_30 = tmpvar_10;
    segment_rect_p1_31 = tmpvar_11;
    segment_data_32 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    int tmpvar_35;
    tmpvar_35 = ((tmpvar_13.y + 3) + (instance_segment_index_3 * 2));
    ivec2 tmpvar_36;
    tmpvar_36.x = int((uint(tmpvar_35) % 1024u));
    tmpvar_36.y = int((uint(tmpvar_35) / 1024u));
    vec4 tmpvar_37;
    tmpvar_37 = texelFetch (sGpuCache, tmpvar_36, 0);
    segment_rect_p0_30 = (tmpvar_37.xy + tmpvar_8.xy);
    segment_rect_p1_31 = (tmpvar_37.zw + tmpvar_8.xy);
    segment_data_32 = texelFetch (sGpuCache, (tmpvar_36 + ivec2(1, 0)), 0);
  };
  if (transform_is_axis_aligned_16) {
    vec2 tmpvar_38;
    tmpvar_38 = min (max (mix (segment_rect_p0_30, segment_rect_p1_31, aPosition), tmpvar_9.xy), tmpvar_9.zw);
    vec4 tmpvar_39;
    tmpvar_39.zw = vec2(0.0, 1.0);
    tmpvar_39.xy = tmpvar_38;
    vec4 tmpvar_40;
    tmpvar_40 = (transform_m_15 * tmpvar_39);
    vec4 tmpvar_41;
    tmpvar_41.xy = ((tmpvar_40.xy * tmpvar_21.x) + ((
      -(tmpvar_21.yz)
     + tmpvar_20.xy) * tmpvar_40.w));
    tmpvar_41.z = (ph_z_6 * tmpvar_40.w);
    tmpvar_41.w = tmpvar_40.w;
    gl_Position = (uTransform * tmpvar_41);
    vi_local_pos_28 = tmpvar_38;
    vi_world_pos_29 = tmpvar_40;
    vTransformBounds = vec4(-1e+16, -1e+16, 1e+16, 1e+16);
  } else {
    bvec4 tmpvar_42;
    tmpvar_42.x = bool((tmpvar_33 & 1));
    tmpvar_42.y = bool((tmpvar_33 & 2));
    tmpvar_42.z = bool((tmpvar_33 & 4));
    tmpvar_42.w = bool((tmpvar_33 & 8));
    vec4 tmpvar_43;
    tmpvar_43.xy = min (max (tmpvar_8.xy, tmpvar_9.xy), tmpvar_9.zw);
    tmpvar_43.zw = min (max (tmpvar_8.zw, tmpvar_9.xy), tmpvar_9.zw);
    vec4 tmpvar_44;
    tmpvar_44.xy = min (max (segment_rect_p0_30, tmpvar_9.xy), tmpvar_9.zw);
    tmpvar_44.zw = min (max (segment_rect_p1_31, tmpvar_9.xy), tmpvar_9.zw);
    vTransformBounds = mix(tmpvar_43, tmpvar_44, bvec4(tmpvar_42));
    vec4 tmpvar_45;
    tmpvar_45 = mix(vec4(0.0, 0.0, 0.0, 0.0), vec4(2.0, 2.0, 2.0, 2.0), bvec4(tmpvar_42));
    vec2 tmpvar_46;
    tmpvar_46 = mix ((segment_rect_p0_30 - tmpvar_45.xy), (segment_rect_p1_31 + tmpvar_45.zw), aPosition);
    vec4 tmpvar_47;
    tmpvar_47.zw = vec2(0.0, 1.0);
    tmpvar_47.xy = tmpvar_46;
    vec4 tmpvar_48;
    tmpvar_48 = (transform_m_15 * tmpvar_47);
    vec4 tmpvar_49;
    tmpvar_49.xy = ((tmpvar_48.xy * tmpvar_21.x) + ((tmpvar_20.xy - tmpvar_21.yz) * tmpvar_48.w));
    tmpvar_49.z = (ph_z_6 * tmpvar_48.w);
    tmpvar_49.w = tmpvar_48.w;
    gl_Position = (uTransform * tmpvar_49);
    vi_local_pos_28 = tmpvar_46;
    vi_world_pos_29 = tmpvar_48;
  };
  vec4 tmpvar_50;
  tmpvar_50.xy = area_task_rect_22.p0;
  tmpvar_50.zw = area_task_rect_22.p1;
  vClipMaskUvBounds = tmpvar_50;
  vClipMaskUv = ((vi_world_pos_29.xy * area_device_pixel_scale_23) + (vi_world_pos_29.w * (area_task_rect_22.p0 - area_screen_origin_24)));
  highp int color_mode_51;
  highp vec2 f_52;
  highp vec2 stretch_size_53;
  vec2 local_rect_p0_54;
  vec2 local_rect_p1_55;
  highp vec2 uv1_56;
  highp vec2 uv0_57;
  vec4 image_data_color_58;
  ivec2 tmpvar_59;
  tmpvar_59.x = int((uint(tmpvar_13.y) % 1024u));
  tmpvar_59.y = int((uint(tmpvar_13.y) / 1024u));
  vec4 tmpvar_60;
  vec4 tmpvar_61;
  vec4 tmpvar_62;
  tmpvar_60 = texelFetch (sGpuCache, tmpvar_59, 0);
  tmpvar_61 = texelFetch (sGpuCache, (tmpvar_59 + ivec2(1, 0)), 0);
  tmpvar_62 = texelFetch (sGpuCache, (tmpvar_59 + ivec2(2, 0)), 0);
  image_data_color_58 = tmpvar_60;
  vec2 tmpvar_63;
  tmpvar_63 = vec2(textureSize (sColor0, 0));
  ivec2 tmpvar_64;
  tmpvar_64.x = int((uint(instance_resource_address_5) % 1024u));
  tmpvar_64.y = int((uint(instance_resource_address_5) / 1024u));
  vec4 tmpvar_65;
  tmpvar_65 = texelFetch (sGpuCache, tmpvar_64, 0);
  uv0_57 = tmpvar_65.xy;
  uv1_56 = tmpvar_65.zw;
  local_rect_p0_54 = tmpvar_10;
  local_rect_p1_55 = tmpvar_11;
  stretch_size_53 = tmpvar_62.xy;
  if ((tmpvar_62.x < 0.0)) {
    stretch_size_53 = (tmpvar_8.zw - tmpvar_8.xy);
  };
  if (((tmpvar_34 & 2) != 0)) {
    local_rect_p0_54 = segment_rect_p0_30;
    local_rect_p1_55 = segment_rect_p1_31;
    vec2 tmpvar_66;
    tmpvar_66 = (segment_rect_p1_31 - segment_rect_p0_30);
    stretch_size_53 = tmpvar_66;
    if (((tmpvar_34 & 128) != 0)) {
      vec2 tmpvar_67;
      tmpvar_67 = (tmpvar_65.zw - tmpvar_65.xy);
      uv0_57 = (tmpvar_65.xy + (segment_data_32.xy * tmpvar_67));
      uv1_56 = (tmpvar_65.xy + (segment_data_32.zw * tmpvar_67));
    };
    if (((tmpvar_34 & 128) != 0)) {
      highp vec2 vertical_uv_size_68;
      highp vec2 horizontal_uv_size_69;
      highp vec2 repeated_stretch_size_70;
      repeated_stretch_size_70 = tmpvar_66;
      vec2 tmpvar_71;
      tmpvar_71 = (uv1_56 - uv0_57);
      horizontal_uv_size_69 = tmpvar_71;
      vec2 tmpvar_72;
      tmpvar_72 = (uv1_56 - uv0_57);
      vertical_uv_size_68 = tmpvar_72;
      if (((tmpvar_34 & 64) != 0)) {
        repeated_stretch_size_70 = (segment_rect_p0_30 - tmpvar_8.xy);
        vertical_uv_size_68.x = (uv0_57.x - tmpvar_65.x);
        if (((vertical_uv_size_68.x < 0.001) || (repeated_stretch_size_70.x < 0.001))) {
          vertical_uv_size_68.x = (tmpvar_65.z - uv1_56.x);
          repeated_stretch_size_70.x = (tmpvar_8.z - segment_rect_p1_31.x);
        };
        horizontal_uv_size_69.y = (uv0_57.y - tmpvar_65.y);
        if (((horizontal_uv_size_69.y < 0.001) || (repeated_stretch_size_70.y < 0.001))) {
          horizontal_uv_size_69.y = (tmpvar_65.w - uv1_56.y);
          repeated_stretch_size_70.y = (tmpvar_8.w - segment_rect_p1_31.y);
        };
      };
      if (((tmpvar_34 & 4) != 0)) {
        stretch_size_53.x = (repeated_stretch_size_70.y * (tmpvar_71.x / horizontal_uv_size_69.y));
      };
      if (((tmpvar_34 & 8) != 0)) {
        stretch_size_53.y = (repeated_stretch_size_70.x * (tmpvar_72.y / vertical_uv_size_68.x));
      };
    } else {
      if (((tmpvar_34 & 4) != 0)) {
        stretch_size_53.x = (segment_data_32.z - segment_data_32.x);
      };
      if (((tmpvar_34 & 8) != 0)) {
        stretch_size_53.y = (segment_data_32.w - segment_data_32.y);
      };
    };
    if (((tmpvar_34 & 16) != 0)) {
      float tmpvar_73;
      tmpvar_73 = (segment_rect_p1_31.x - segment_rect_p0_30.x);
      stretch_size_53.x = (tmpvar_73 / max (1.0, roundEven(
        (tmpvar_73 / stretch_size_53.x)
      )));
    };
    if (((tmpvar_34 & 32) != 0)) {
      float tmpvar_74;
      tmpvar_74 = (segment_rect_p1_31.y - segment_rect_p0_30.y);
      stretch_size_53.y = (tmpvar_74 / max (1.0, roundEven(
        (tmpvar_74 / stretch_size_53.y)
      )));
    };
  };
  float tmpvar_75;
  if (((tmpvar_34 & 1) != 0)) {
    tmpvar_75 = 1.0;
  } else {
    tmpvar_75 = 0.0;
  };
  v_perspective = tmpvar_75;
  vec2 tmpvar_76;
  tmpvar_76 = min (uv0_57, uv1_56);
  vec2 tmpvar_77;
  tmpvar_77 = max (uv0_57, uv1_56);
  vec4 tmpvar_78;
  tmpvar_78.xy = (tmpvar_76 + vec2(0.5, 0.5));
  tmpvar_78.zw = (tmpvar_77 - vec2(0.5, 0.5));
  v_uv_sample_bounds = (tmpvar_78 / tmpvar_63.xyxy);
  vec2 tmpvar_79;
  tmpvar_79 = ((vi_local_pos_28 - local_rect_p0_54) / (local_rect_p1_55 - local_rect_p0_54));
  f_52 = tmpvar_79;
  int tmpvar_80;
  tmpvar_80 = (tmpvar_14.x & 65535);
  color_mode_51 = tmpvar_80;
  int tmpvar_81;
  tmpvar_81 = (tmpvar_14.x >> 16);
  if ((tmpvar_80 == 0)) {
    color_mode_51 = uMode;
  };
  if ((tmpvar_14.y == 1)) {
    highp int tmpvar_82;
    tmpvar_82 = (instance_resource_address_5 + 2);
    ivec2 tmpvar_83;
    tmpvar_83.x = int((uint(tmpvar_82) % 1024u));
    tmpvar_83.y = int((uint(tmpvar_82) / 1024u));
    vec4 tmpvar_84;
    tmpvar_84 = mix (mix (texelFetch (sGpuCache, tmpvar_83, 0), texelFetch (sGpuCache, (tmpvar_83 + ivec2(1, 0)), 0), tmpvar_79.x), mix (texelFetch (sGpuCache, (tmpvar_83 + ivec2(2, 0)), 0), texelFetch (sGpuCache, (tmpvar_83 + ivec2(3, 0)), 0), tmpvar_79.x), tmpvar_79.y);
    f_52 = (tmpvar_84.xy / tmpvar_84.w);
  };
  vec2 tmpvar_85;
  tmpvar_85 = ((local_rect_p1_55 - local_rect_p0_54) / stretch_size_53);
  v_uv = (mix (uv0_57, uv1_56, f_52) - tmpvar_76);
  v_uv = (v_uv / tmpvar_63);
  v_uv = (v_uv * tmpvar_85);
  if ((tmpvar_75 == 0.0)) {
    v_uv = (v_uv * vi_world_pos_29.w);
  };
  vec4 tmpvar_86;
  tmpvar_86.xy = tmpvar_76;
  tmpvar_86.zw = tmpvar_77;
  v_uv_bounds = (tmpvar_86 / tmpvar_63.xyxy);
  v_uv = (v_uv / (v_uv_bounds.zw - v_uv_bounds.xy));
  v_tile_repeat = tmpvar_85;
  float tmpvar_87;
  tmpvar_87 = (float(tmpvar_14.z) / 65535.0);
  bool tmpvar_88;
  bool tmpvar_89;
  tmpvar_89 = bool(0);
  tmpvar_88 = (0 == tmpvar_81);
  if (tmpvar_88) {
    image_data_color_58.w = (tmpvar_60.w * tmpvar_87);
    tmpvar_89 = bool(1);
  };
  tmpvar_88 = !(tmpvar_89);
  if (tmpvar_88) {
    image_data_color_58 = (image_data_color_58 * tmpvar_87);
    tmpvar_89 = bool(1);
  };
  bool tmpvar_90;
  bool tmpvar_91;
  tmpvar_91 = bool(0);
  tmpvar_90 = (1 == color_mode_51);
  tmpvar_90 = (tmpvar_90 || (7 == color_mode_51));
  if (tmpvar_90) {
    v_mask_swizzle = vec2(0.0, 1.0);
    v_color = image_data_color_58;
    tmpvar_91 = bool(1);
  };
  tmpvar_90 = (tmpvar_90 || (5 == color_mode_51));
  tmpvar_90 = (tmpvar_90 || (9 == color_mode_51));
  tmpvar_90 = (tmpvar_90 && !(tmpvar_91));
  if (tmpvar_90) {
    v_mask_swizzle = vec2(1.0, 0.0);
    v_color = image_data_color_58;
    tmpvar_91 = bool(1);
  };
  tmpvar_90 = (tmpvar_90 || (2 == color_mode_51));
  tmpvar_90 = (tmpvar_90 || (3 == color_mode_51));
  tmpvar_90 = (tmpvar_90 || (8 == color_mode_51));
  tmpvar_90 = (tmpvar_90 && !(tmpvar_91));
  if (tmpvar_90) {
    v_mask_swizzle = vec2(1.0, 0.0);
    v_color = image_data_color_58.wwww;
    tmpvar_91 = bool(1);
  };
  tmpvar_90 = (tmpvar_90 || (4 == color_mode_51));
  tmpvar_90 = (tmpvar_90 && !(tmpvar_91));
  if (tmpvar_90) {
    v_mask_swizzle = vec2(-1.0, 1.0);
    v_color = (image_data_color_58.wwww * tmpvar_61);
    tmpvar_91 = bool(1);
  };
  tmpvar_90 = (tmpvar_90 || (6 == color_mode_51));
  tmpvar_90 = (tmpvar_90 && !(tmpvar_91));
  if (tmpvar_90) {
    vec2 tmpvar_92;
    tmpvar_92.y = 0.0;
    tmpvar_92.x = image_data_color_58.w;
    v_mask_swizzle = tmpvar_92;
    v_color = image_data_color_58;
    tmpvar_91 = bool(1);
  };
  tmpvar_90 = (tmpvar_90 || (10 == color_mode_51));
  tmpvar_90 = (tmpvar_90 && !(tmpvar_91));
  if (tmpvar_90) {
    vec2 tmpvar_93;
    tmpvar_93.x = -(image_data_color_58.w);
    tmpvar_93.y = image_data_color_58.w;
    v_mask_swizzle = tmpvar_93;
    v_color = image_data_color_58;
    tmpvar_91 = bool(1);
  };
  tmpvar_90 = !(tmpvar_91);
  if (tmpvar_90) {
    v_mask_swizzle = vec2(0.0, 0.0);
    v_color = vec4(1.0, 1.0, 1.0, 1.0);
  };
  v_local_pos = vi_local_pos_28;
}

