#version 300 es
// brush_blend
// features: ["ALPHA_PASS"]

struct RectWithEndpoint {
  vec2 p0;
  vec2 p1;
};
uniform highp mat4 uTransform;
in highp vec2 aPosition;
uniform lowp sampler2D sColor0;
uniform highp sampler2D sRenderTasks;
uniform highp sampler2D sGpuCache;
flat out highp vec4 vTransformBounds;
uniform highp sampler2D sTransformPalette;
flat out highp vec4 vClipMaskUvBounds;
out highp vec2 vClipMaskUv;
uniform highp sampler2D sPrimitiveHeadersF;
uniform highp isampler2D sPrimitiveHeadersI;
in highp ivec4 aData;
out highp vec2 v_local_pos;
out highp vec2 v_uv;
flat out highp vec4 v_uv_sample_bounds;
flat out highp vec2 v_perspective_amount;
flat out highp int v_op;
flat out highp int v_table_address;
flat out highp mat4 v_color_mat;
flat out highp ivec4 v_funcs;
flat out highp vec4 v_color_offset;
void main ()
{
  int instance_picture_task_address_1;
  int instance_clip_address_2;
  int instance_segment_index_3;
  int instance_flags_4;
  instance_picture_task_address_1 = (aData.y >> 16);
  instance_clip_address_2 = (aData.y & 65535);
  instance_segment_index_3 = (aData.z & 65535);
  instance_flags_4 = (aData.z >> 16);
  float ph_z_5;
  ivec2 tmpvar_6;
  tmpvar_6.x = int((2u * (
    uint(aData.x)
   % 512u)));
  tmpvar_6.y = int((uint(aData.x) / 512u));
  vec4 tmpvar_7;
  tmpvar_7 = texelFetch (sPrimitiveHeadersF, tmpvar_6, 0);
  vec4 tmpvar_8;
  tmpvar_8 = texelFetch (sPrimitiveHeadersF, (tmpvar_6 + ivec2(1, 0)), 0);
  vec2 tmpvar_9;
  vec2 tmpvar_10;
  tmpvar_9 = tmpvar_7.xy;
  tmpvar_10 = tmpvar_7.zw;
  ivec2 tmpvar_11;
  tmpvar_11.x = int((2u * (
    uint(aData.x)
   % 512u)));
  tmpvar_11.y = int((uint(aData.x) / 512u));
  ivec4 tmpvar_12;
  tmpvar_12 = texelFetch (sPrimitiveHeadersI, tmpvar_11, 0);
  ivec4 tmpvar_13;
  tmpvar_13 = texelFetch (sPrimitiveHeadersI, (tmpvar_11 + ivec2(1, 0)), 0);
  ph_z_5 = float(tmpvar_12.x);
  mat4 transform_m_14;
  bool transform_is_axis_aligned_15;
  transform_is_axis_aligned_15 = ((tmpvar_12.z >> 24) == 0);
  int tmpvar_16;
  tmpvar_16 = (tmpvar_12.z & 16777215);
  ivec2 tmpvar_17;
  tmpvar_17.x = int((8u * (
    uint(tmpvar_16)
   % 128u)));
  tmpvar_17.y = int((uint(tmpvar_16) / 128u));
  transform_m_14[0] = texelFetch (sTransformPalette, tmpvar_17, 0);
  transform_m_14[1] = texelFetch (sTransformPalette, (tmpvar_17 + ivec2(1, 0)), 0);
  transform_m_14[2] = texelFetch (sTransformPalette, (tmpvar_17 + ivec2(2, 0)), 0);
  transform_m_14[3] = texelFetch (sTransformPalette, (tmpvar_17 + ivec2(3, 0)), 0);
  ivec2 tmpvar_18;
  tmpvar_18.x = int((2u * (
    uint(instance_picture_task_address_1)
   % 512u)));
  tmpvar_18.y = int((uint(instance_picture_task_address_1) / 512u));
  vec4 tmpvar_19;
  tmpvar_19 = texelFetch (sRenderTasks, tmpvar_18, 0);
  vec4 tmpvar_20;
  tmpvar_20 = texelFetch (sRenderTasks, (tmpvar_18 + ivec2(1, 0)), 0);
  RectWithEndpoint area_task_rect_21;
  float area_device_pixel_scale_22;
  vec2 area_screen_origin_23;
  if ((instance_clip_address_2 >= 32767)) {
    area_task_rect_21 = RectWithEndpoint(vec2(0.0, 0.0), vec2(0.0, 0.0));
    area_device_pixel_scale_22 = 0.0;
    area_screen_origin_23 = vec2(0.0, 0.0);
  } else {
    ivec2 tmpvar_24;
    tmpvar_24.x = int((2u * (
      uint(instance_clip_address_2)
     % 512u)));
    tmpvar_24.y = int((uint(instance_clip_address_2) / 512u));
    vec4 tmpvar_25;
    tmpvar_25 = texelFetch (sRenderTasks, tmpvar_24, 0);
    vec4 tmpvar_26;
    tmpvar_26 = texelFetch (sRenderTasks, (tmpvar_24 + ivec2(1, 0)), 0);
    area_task_rect_21.p0 = tmpvar_25.xy;
    area_task_rect_21.p1 = tmpvar_25.zw;
    area_device_pixel_scale_22 = tmpvar_26.x;
    area_screen_origin_23 = tmpvar_26.yz;
  };
  vec2 vi_local_pos_27;
  vec4 vi_world_pos_28;
  vec2 segment_rect_p0_29;
  vec2 segment_rect_p1_30;
  int tmpvar_31;
  tmpvar_31 = (instance_flags_4 & 255);
  int tmpvar_32;
  tmpvar_32 = ((instance_flags_4 >> 8) & 255);
  if ((instance_segment_index_3 == 65535)) {
    segment_rect_p0_29 = tmpvar_9;
    segment_rect_p1_30 = tmpvar_10;
  } else {
    int tmpvar_33;
    tmpvar_33 = ((tmpvar_12.y + 3) + (instance_segment_index_3 * 2));
    ivec2 tmpvar_34;
    tmpvar_34.x = int((uint(tmpvar_33) % 1024u));
    tmpvar_34.y = int((uint(tmpvar_33) / 1024u));
    vec4 tmpvar_35;
    tmpvar_35 = texelFetch (sGpuCache, tmpvar_34, 0);
    segment_rect_p0_29 = (tmpvar_35.xy + tmpvar_7.xy);
    segment_rect_p1_30 = (tmpvar_35.zw + tmpvar_7.xy);
  };
  if (transform_is_axis_aligned_15) {
    vec2 tmpvar_36;
    tmpvar_36 = min (max (mix (segment_rect_p0_29, segment_rect_p1_30, aPosition), tmpvar_8.xy), tmpvar_8.zw);
    vec4 tmpvar_37;
    tmpvar_37.zw = vec2(0.0, 1.0);
    tmpvar_37.xy = tmpvar_36;
    vec4 tmpvar_38;
    tmpvar_38 = (transform_m_14 * tmpvar_37);
    vec4 tmpvar_39;
    tmpvar_39.xy = ((tmpvar_38.xy * tmpvar_20.x) + ((
      -(tmpvar_20.yz)
     + tmpvar_19.xy) * tmpvar_38.w));
    tmpvar_39.z = (ph_z_5 * tmpvar_38.w);
    tmpvar_39.w = tmpvar_38.w;
    gl_Position = (uTransform * tmpvar_39);
    vi_local_pos_27 = tmpvar_36;
    vi_world_pos_28 = tmpvar_38;
    vTransformBounds = vec4(-1e+16, -1e+16, 1e+16, 1e+16);
  } else {
    bvec4 tmpvar_40;
    tmpvar_40.x = bool((tmpvar_31 & 1));
    tmpvar_40.y = bool((tmpvar_31 & 2));
    tmpvar_40.z = bool((tmpvar_31 & 4));
    tmpvar_40.w = bool((tmpvar_31 & 8));
    vec4 tmpvar_41;
    tmpvar_41.xy = min (max (tmpvar_7.xy, tmpvar_8.xy), tmpvar_8.zw);
    tmpvar_41.zw = min (max (tmpvar_7.zw, tmpvar_8.xy), tmpvar_8.zw);
    vec4 tmpvar_42;
    tmpvar_42.xy = min (max (segment_rect_p0_29, tmpvar_8.xy), tmpvar_8.zw);
    tmpvar_42.zw = min (max (segment_rect_p1_30, tmpvar_8.xy), tmpvar_8.zw);
    vTransformBounds = mix(tmpvar_41, tmpvar_42, bvec4(tmpvar_40));
    vec4 tmpvar_43;
    tmpvar_43 = mix(vec4(0.0, 0.0, 0.0, 0.0), vec4(2.0, 2.0, 2.0, 2.0), bvec4(tmpvar_40));
    vec2 tmpvar_44;
    tmpvar_44 = mix ((segment_rect_p0_29 - tmpvar_43.xy), (segment_rect_p1_30 + tmpvar_43.zw), aPosition);
    vec4 tmpvar_45;
    tmpvar_45.zw = vec2(0.0, 1.0);
    tmpvar_45.xy = tmpvar_44;
    vec4 tmpvar_46;
    tmpvar_46 = (transform_m_14 * tmpvar_45);
    vec4 tmpvar_47;
    tmpvar_47.xy = ((tmpvar_46.xy * tmpvar_20.x) + ((tmpvar_19.xy - tmpvar_20.yz) * tmpvar_46.w));
    tmpvar_47.z = (ph_z_5 * tmpvar_46.w);
    tmpvar_47.w = tmpvar_46.w;
    gl_Position = (uTransform * tmpvar_47);
    vi_local_pos_27 = tmpvar_44;
    vi_world_pos_28 = tmpvar_46;
  };
  vec4 tmpvar_48;
  tmpvar_48.xy = area_task_rect_21.p0;
  tmpvar_48.zw = area_task_rect_21.p1;
  vClipMaskUvBounds = tmpvar_48;
  vClipMaskUv = ((vi_world_pos_28.xy * area_device_pixel_scale_22) + (vi_world_pos_28.w * (area_task_rect_21.p0 - area_screen_origin_23)));
  ivec2 tmpvar_49;
  tmpvar_49.x = int((uint(tmpvar_13.x) % 1024u));
  tmpvar_49.y = int((uint(tmpvar_13.x) / 1024u));
  vec4 tmpvar_50;
  tmpvar_50 = texelFetch (sGpuCache, tmpvar_49, 0);
  vec2 tmpvar_51;
  tmpvar_51 = (1.0/(vec2(textureSize (sColor0, 0))));
  vec2 tmpvar_52;
  tmpvar_52 = ((vi_local_pos_27 - tmpvar_7.xy) / (tmpvar_7.zw - tmpvar_7.xy));
  highp int tmpvar_53;
  tmpvar_53 = (tmpvar_13.x + 2);
  ivec2 tmpvar_54;
  tmpvar_54.x = int((uint(tmpvar_53) % 1024u));
  tmpvar_54.y = int((uint(tmpvar_53) / 1024u));
  vec4 tmpvar_55;
  tmpvar_55 = mix (mix (texelFetch (sGpuCache, tmpvar_54, 0), texelFetch (sGpuCache, (tmpvar_54 + ivec2(1, 0)), 0), tmpvar_52.x), mix (texelFetch (sGpuCache, (tmpvar_54 + ivec2(2, 0)), 0), texelFetch (sGpuCache, (tmpvar_54 + ivec2(3, 0)), 0), tmpvar_52.x), tmpvar_52.y);
  vec2 tmpvar_56;
  tmpvar_56 = mix (tmpvar_50.xy, tmpvar_50.zw, (tmpvar_55.xy / tmpvar_55.w));
  float tmpvar_57;
  if (((tmpvar_32 & 1) != 0)) {
    tmpvar_57 = 1.0;
  } else {
    tmpvar_57 = 0.0;
  };
  v_uv = ((tmpvar_56 * tmpvar_51) * mix (vi_world_pos_28.w, 1.0, tmpvar_57));
  v_perspective_amount.x = tmpvar_57;
  vec4 tmpvar_58;
  tmpvar_58.xy = (tmpvar_50.xy + vec2(0.5, 0.5));
  tmpvar_58.zw = (tmpvar_50.zw - vec2(0.5, 0.5));
  v_uv_sample_bounds = (tmpvar_58 * tmpvar_51.xyxy);
  float tmpvar_59;
  tmpvar_59 = (float(tmpvar_13.z) / 65536.0);
  v_op = (tmpvar_13.y & 65535);
  v_perspective_amount.y = tmpvar_59;
  v_funcs.x = ((tmpvar_13.y >> 28) & 15);
  v_funcs.y = ((tmpvar_13.y >> 24) & 15);
  v_funcs.z = ((tmpvar_13.y >> 20) & 15);
  v_funcs.w = ((tmpvar_13.y >> 16) & 15);
  highp int tmpvar_60;
  tmpvar_60 = tmpvar_13.z;
  highp vec4 tmpvar_61;
  highp mat4 tmpvar_62;
  highp int tmpvar_63;
  float tmpvar_64;
  tmpvar_64 = (1.0 - tmpvar_59);
  if ((v_op == 1)) {
    vec4 tmpvar_65;
    tmpvar_65.w = 0.0;
    tmpvar_65.x = (0.2126 + (0.7874 * tmpvar_64));
    tmpvar_65.y = (0.2126 - (0.2126 * tmpvar_64));
    tmpvar_65.z = (0.2126 - (0.2126 * tmpvar_64));
    vec4 tmpvar_66;
    tmpvar_66.w = 0.0;
    tmpvar_66.x = (0.7152 - (0.7152 * tmpvar_64));
    tmpvar_66.y = (0.7152 + (0.2848 * tmpvar_64));
    tmpvar_66.z = (0.7152 - (0.7152 * tmpvar_64));
    vec4 tmpvar_67;
    tmpvar_67.w = 0.0;
    tmpvar_67.x = (0.0722 - (0.0722 * tmpvar_64));
    tmpvar_67.y = (0.0722 - (0.0722 * tmpvar_64));
    tmpvar_67.z = (0.0722 + (0.9278 * tmpvar_64));
    mat4 tmpvar_68;
    tmpvar_68[uint(0)] = tmpvar_65;
    tmpvar_68[1u] = tmpvar_66;
    tmpvar_68[2u] = tmpvar_67;
    tmpvar_68[3u] = vec4(0.0, 0.0, 0.0, 1.0);
    tmpvar_62 = tmpvar_68;
    tmpvar_61 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    if ((v_op == 2)) {
      float tmpvar_69;
      tmpvar_69 = cos(tmpvar_59);
      float tmpvar_70;
      tmpvar_70 = sin(tmpvar_59);
      vec4 tmpvar_71;
      tmpvar_71.w = 0.0;
      tmpvar_71.x = ((0.2126 + (0.7874 * tmpvar_69)) - (0.2126 * tmpvar_70));
      tmpvar_71.y = ((0.2126 - (0.2126 * tmpvar_69)) + (0.143 * tmpvar_70));
      tmpvar_71.z = ((0.2126 - (0.2126 * tmpvar_69)) - (0.7874 * tmpvar_70));
      vec4 tmpvar_72;
      tmpvar_72.w = 0.0;
      tmpvar_72.x = ((0.7152 - (0.7152 * tmpvar_69)) - (0.7152 * tmpvar_70));
      tmpvar_72.y = ((0.7152 + (0.2848 * tmpvar_69)) + (0.14 * tmpvar_70));
      tmpvar_72.z = ((0.7152 - (0.7152 * tmpvar_69)) + (0.7152 * tmpvar_70));
      vec4 tmpvar_73;
      tmpvar_73.w = 0.0;
      tmpvar_73.x = ((0.0722 - (0.0722 * tmpvar_69)) + (0.9278 * tmpvar_70));
      tmpvar_73.y = ((0.0722 - (0.0722 * tmpvar_69)) - (0.283 * tmpvar_70));
      tmpvar_73.z = ((0.0722 + (0.9278 * tmpvar_69)) + (0.0722 * tmpvar_70));
      mat4 tmpvar_74;
      tmpvar_74[uint(0)] = tmpvar_71;
      tmpvar_74[1u] = tmpvar_72;
      tmpvar_74[2u] = tmpvar_73;
      tmpvar_74[3u] = vec4(0.0, 0.0, 0.0, 1.0);
      tmpvar_62 = tmpvar_74;
      tmpvar_61 = vec4(0.0, 0.0, 0.0, 0.0);
    } else {
      if ((v_op == 4)) {
        vec4 tmpvar_75;
        tmpvar_75.w = 0.0;
        tmpvar_75.x = ((tmpvar_64 * 0.2126) + tmpvar_59);
        tmpvar_75.y = (tmpvar_64 * 0.2126);
        tmpvar_75.z = (tmpvar_64 * 0.2126);
        vec4 tmpvar_76;
        tmpvar_76.w = 0.0;
        tmpvar_76.x = (tmpvar_64 * 0.7152);
        tmpvar_76.y = ((tmpvar_64 * 0.7152) + tmpvar_59);
        tmpvar_76.z = (tmpvar_64 * 0.7152);
        vec4 tmpvar_77;
        tmpvar_77.w = 0.0;
        tmpvar_77.x = (tmpvar_64 * 0.0722);
        tmpvar_77.y = (tmpvar_64 * 0.0722);
        tmpvar_77.z = ((tmpvar_64 * 0.0722) + tmpvar_59);
        mat4 tmpvar_78;
        tmpvar_78[uint(0)] = tmpvar_75;
        tmpvar_78[1u] = tmpvar_76;
        tmpvar_78[2u] = tmpvar_77;
        tmpvar_78[3u] = vec4(0.0, 0.0, 0.0, 1.0);
        tmpvar_62 = tmpvar_78;
        tmpvar_61 = vec4(0.0, 0.0, 0.0, 0.0);
      } else {
        if ((v_op == 5)) {
          vec4 tmpvar_79;
          tmpvar_79.w = 0.0;
          tmpvar_79.x = (0.393 + (0.607 * tmpvar_64));
          tmpvar_79.y = (0.349 - (0.349 * tmpvar_64));
          tmpvar_79.z = (0.272 - (0.272 * tmpvar_64));
          vec4 tmpvar_80;
          tmpvar_80.w = 0.0;
          tmpvar_80.x = (0.769 - (0.769 * tmpvar_64));
          tmpvar_80.y = (0.686 + (0.314 * tmpvar_64));
          tmpvar_80.z = (0.534 - (0.534 * tmpvar_64));
          vec4 tmpvar_81;
          tmpvar_81.w = 0.0;
          tmpvar_81.x = (0.189 - (0.189 * tmpvar_64));
          tmpvar_81.y = (0.168 - (0.168 * tmpvar_64));
          tmpvar_81.z = (0.131 + (0.869 * tmpvar_64));
          mat4 tmpvar_82;
          tmpvar_82[uint(0)] = tmpvar_79;
          tmpvar_82[1u] = tmpvar_80;
          tmpvar_82[2u] = tmpvar_81;
          tmpvar_82[3u] = vec4(0.0, 0.0, 0.0, 1.0);
          tmpvar_62 = tmpvar_82;
          tmpvar_61 = vec4(0.0, 0.0, 0.0, 0.0);
        } else {
          if ((v_op == 7)) {
            ivec2 tmpvar_83;
            tmpvar_83.x = int((uint(tmpvar_13.z) % 1024u));
            tmpvar_83.y = int((uint(tmpvar_13.z) / 1024u));
            highp int tmpvar_84;
            tmpvar_84 = (tmpvar_13.z + 4);
            ivec2 tmpvar_85;
            tmpvar_85.x = int((uint(tmpvar_84) % 1024u));
            tmpvar_85.y = int((uint(tmpvar_84) / 1024u));
            mat4 tmpvar_86;
            tmpvar_86[uint(0)] = texelFetch (sGpuCache, tmpvar_83, 0);
            tmpvar_86[1u] = texelFetch (sGpuCache, (tmpvar_83 + ivec2(1, 0)), 0);
            tmpvar_86[2u] = texelFetch (sGpuCache, (tmpvar_83 + ivec2(2, 0)), 0);
            tmpvar_86[3u] = texelFetch (sGpuCache, (tmpvar_83 + ivec2(3, 0)), 0);
            tmpvar_62 = tmpvar_86;
            tmpvar_61 = texelFetch (sGpuCache, tmpvar_85, 0);
          } else {
            if ((v_op == 11)) {
              tmpvar_63 = tmpvar_60;
            } else {
              if ((v_op == 10)) {
                ivec2 tmpvar_87;
                tmpvar_87.x = int((uint(tmpvar_13.z) % 1024u));
                tmpvar_87.y = int((uint(tmpvar_13.z) / 1024u));
                tmpvar_61 = texelFetch (sGpuCache, tmpvar_87, 0);
              };
            };
          };
        };
      };
    };
  };
  v_color_offset = tmpvar_61;
  v_color_mat = tmpvar_62;
  v_table_address = tmpvar_63;
  v_local_pos = vi_local_pos_27;
}

