# Examples

- [`hello_world`](../examples/hello_world.rs) - Very small getting started app.
- [`todos`](../examples/todos.rs) - Provides a RESTful web server managing some Todos.
- [`key_value_store`](../examples/key_value_store.rs) - Slightly larger app with an in-memory key/value store.
- [`form`](../examples/form.rs) - Receiving data from an HTML `<form>`.
- [`multipart_form`](../examples/multipart_form.rs) - How to parse `multipart/form-data` forms.
- [`static_file_server`](../examples/static_file_server.rs) - Serving static files from a directory. Could for example be the baseline for a single page app.
- [`templates`](../examples/templates.rs) - Rending HTML templates using [askama](https://crates.io/crates/askama).
- [`testing`](../examples/testing.rs) - How to test axum apps.
- [`versioning`](../examples/versioning.rs) - How one might version an API.
- [`websocket`](../examples/websocket.rs) - How to build an app that handles WebSocket connections.
- [`error_handling_and_dependency_injection`](../examples/error_handling_and_dependency_injection.rs) - How to handle errors and dependency injection using trait objects.
- [`tokio_postgres`](../examples/tokio_postgres.rs) - How to use a tokio-postgres and bb8 to query a database.
- [`unix_domain_socket`](../examples/unix_domain_socket.rs) - How to run an Axum server over unix domain sockets.
- [`sessions`](../examples/sessions.rs) - Sessions and cookies using [`async-session`](https://crates.io/crates/async-session).
- [`tls_rustls`](../examples/tls_rustls.rs) - TLS with [`tokio-rustls`](https://crates.io/crates/tokio-rustls).
