# [aws_lambda_events](https://github.com/LegNeato/aws-lambda-events)

[![Build Status](https://travis-ci.org/LegNeato/aws-lambda-events.svg?branch=master)](https://travis-ci.org/LegNeato/aws-lambda-events)
[![Documentation](https://docs.rs/aws_lambda_events/badge.svg?version=0.5.0)](https://docs.rs/aws_lambda_events/0.5.0)

This crate provides strongly-typed [AWS Lambda event structs](https://docs.aws.amazon.com/lambda/latest/dg/invoking-lambda-function.html) in Rust.

## Installation

Include the crate in your `Cargo.toml`:

```toml
[dependencies]
aws_lambda_events = "^0.5.0"
```

## Usage

The crate itself has no AWS Lambda handler logic and instead exists to serialize
and deserialize AWS Lambda events into strongly-typed Rust structs.

The types
defined in this crate are usually used with handlers / runtimes provided by the [official Rust runtime](https://github.com/awslabs/aws-lambda-rust-runtime).

For a list of supported AWS Lambda events and services, see [the crate reference documentation](https://docs.rs/aws_lambda_events/0.5.0).

## How it works

This crate is automatically generated by [`aws_lambda_events_codegen`](https://github.com/LegNeato/aws-lambda-events/tree/master/aws_lambda_events_codegen). It parses event definitions from the [official Go SDK](https://github.com/aws/aws-lambda-go/tree/master/events) and thus is generally up-to-date. Additionally, tests with example events are generated to check correctness and any documentation comments are preserved and used in rustdoc.

## Dealing with `null` and empty strings in AWS Lambda input

The [official Lambda Go SDK](https://github.com/aws/aws-lambda-go/tree/master/events) sometimes marks a field as required when the underlying Lambda event json could actually be `null` or an empty string. Normally, this would cause a panic as Rust is much more strict.

This crate deals with this reality by marking all required json string fields as `Option<String>` in Rust. Json `null` or the empty string are deserialized into Rust structs as `None`.

## Conditional compilation of features

This crate divides all Lambda Events into features named after the service that the events are generated from. By default all events are enabled when you include this crate as a dependency to your project. If you only want to import specific events from this crate, you can disable the default features, and enable only the events that you need. This will make your project to compile a little bit faster, since rustc doesn't need to compile events that you're not going to use. Here's an example on how to do that:

```toml
[dependencies]
aws_lambda_events = { version = "^0.5", default-features = false, features = ["apigw", "alb"] }
```

## Contributing

All files in the `generated` directory should not be manually edited and are generated by [`aws_lambda_events_codegen`](https://github.com/LegNeato/aws-lambda-events/tree/master/aws_lambda_events_codegen). Any changes for files in `generated` must happen in [`aws_lambda_events_codegen`](https://github.com/LegNeato/aws-lambda-events/tree/master/aws_lambda_events_codegen).

We have no desire to manually write event definitions and contributions to that effect will not be accepted. If the [official Go SDK](https://github.com/aws/aws-lambda-go/tree/master/events) is missing an event definition, please file a bug on that project rather than submitting a fix here. Once the official Go SDK has included your changes this project will pick up the new event definitions.

Manual changes to wrap the generated event definitions or implement Rust-specific ergonomic improvements will be enthusiastically accepted.
