// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS X-Ray
///
/// Client for invoking operations on AWS X-Ray. Each operation on AWS X-Ray is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_xray::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_xray::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_xray::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchGetTraces`](crate::client::fluent_builders::BatchGetTraces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::BatchGetTraces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`trace_ids(Vec<String>)`](crate::client::fluent_builders::BatchGetTraces::trace_ids) / [`set_trace_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetTraces::set_trace_ids): <p>Specify the trace IDs of requests for which to retrieve segments.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::BatchGetTraces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::BatchGetTraces::set_next_token): <p>Pagination token.</p>
    /// - On success, responds with [`BatchGetTracesOutput`](crate::output::BatchGetTracesOutput) with field(s):
    ///   - [`traces(Option<Vec<Trace>>)`](crate::output::BatchGetTracesOutput::traces): <p>Full traces for the specified requests.</p>
    ///   - [`unprocessed_trace_ids(Option<Vec<String>>)`](crate::output::BatchGetTracesOutput::unprocessed_trace_ids): <p>Trace IDs of requests that haven't been processed.</p>
    ///   - [`next_token(Option<String>)`](crate::output::BatchGetTracesOutput::next_token): <p>Pagination token.</p>
    /// - On failure, responds with [`SdkError<BatchGetTracesError>`](crate::error::BatchGetTracesError)
    pub fn batch_get_traces(&self) -> fluent_builders::BatchGetTraces {
        fluent_builders::BatchGetTraces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGroup`](crate::client::fluent_builders::CreateGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_group_name): <p>The case-sensitive name of the new group. Default is a reserved name and names must be unique.</p>
    ///   - [`filter_expression(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::filter_expression) / [`set_filter_expression(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_filter_expression): <p>The filter expression defining criteria by which to group traces.</p>
    ///   - [`insights_configuration(InsightsConfiguration)`](crate::client::fluent_builders::CreateGroup::insights_configuration) / [`set_insights_configuration(Option<InsightsConfiguration>)`](crate::client::fluent_builders::CreateGroup::set_insights_configuration): <p>The structure containing configurations related to insights.</p>  <ul>   <li> <p>The InsightsEnabled boolean can be set to true to enable insights for the new group or false to disable insights for the new group.</p> </li>   <li> <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group. Notifications may only be enabled on a group with InsightsEnabled set to true.</p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateGroup::set_tags): <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>  <p>The following restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of user-applied tags per resource: 50</p> </li>   <li> <p>Maximum tag key length: 128 Unicode characters</p> </li>   <li> <p>Maximum tag value length: 256 Unicode characters</p> </li>   <li> <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @</p> </li>   <li> <p>Tag keys and values are case sensitive.</p> </li>   <li> <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.</p> </li>  </ul>
    /// - On success, responds with [`CreateGroupOutput`](crate::output::CreateGroupOutput) with field(s):
    ///   - [`group(Option<Group>)`](crate::output::CreateGroupOutput::group): <p>The group that was created. Contains the name of the group that was created, the Amazon Resource Name (ARN) of the group that was generated based on the group name, the filter expression, and the insight configuration that was assigned to the group.</p>
    /// - On failure, responds with [`SdkError<CreateGroupError>`](crate::error::CreateGroupError)
    pub fn create_group(&self) -> fluent_builders::CreateGroup {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSamplingRule`](crate::client::fluent_builders::CreateSamplingRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sampling_rule(SamplingRule)`](crate::client::fluent_builders::CreateSamplingRule::sampling_rule) / [`set_sampling_rule(Option<SamplingRule>)`](crate::client::fluent_builders::CreateSamplingRule::set_sampling_rule): <p>The rule definition.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSamplingRule::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSamplingRule::set_tags): <p>A map that contains one or more tag keys and tag values to attach to an X-Ray sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>  <p>The following restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of user-applied tags per resource: 50</p> </li>   <li> <p>Maximum tag key length: 128 Unicode characters</p> </li>   <li> <p>Maximum tag value length: 256 Unicode characters</p> </li>   <li> <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @</p> </li>   <li> <p>Tag keys and values are case sensitive.</p> </li>   <li> <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.</p> </li>  </ul>
    /// - On success, responds with [`CreateSamplingRuleOutput`](crate::output::CreateSamplingRuleOutput) with field(s):
    ///   - [`sampling_rule_record(Option<SamplingRuleRecord>)`](crate::output::CreateSamplingRuleOutput::sampling_rule_record): <p>The saved rule definition and metadata.</p>
    /// - On failure, responds with [`SdkError<CreateSamplingRuleError>`](crate::error::CreateSamplingRuleError)
    pub fn create_sampling_rule(&self) -> fluent_builders::CreateSamplingRule {
        fluent_builders::CreateSamplingRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_group_name): <p>The case-sensitive name of the group.</p>
    ///   - [`group_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::group_arn) / [`set_group_arn(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_group_arn): <p>The ARN of the group that was generated on creation.</p>
    /// - On success, responds with [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteGroupError>`](crate::error::DeleteGroupError)
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSamplingRule`](crate::client::fluent_builders::DeleteSamplingRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSamplingRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::DeleteSamplingRule::set_rule_name): <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    ///   - [`rule_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteSamplingRule::rule_arn) / [`set_rule_arn(Option<String>)`](crate::client::fluent_builders::DeleteSamplingRule::set_rule_arn): <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    /// - On success, responds with [`DeleteSamplingRuleOutput`](crate::output::DeleteSamplingRuleOutput) with field(s):
    ///   - [`sampling_rule_record(Option<SamplingRuleRecord>)`](crate::output::DeleteSamplingRuleOutput::sampling_rule_record): <p>The deleted rule definition and metadata.</p>
    /// - On failure, responds with [`SdkError<DeleteSamplingRuleError>`](crate::error::DeleteSamplingRuleError)
    pub fn delete_sampling_rule(&self) -> fluent_builders::DeleteSamplingRule {
        fluent_builders::DeleteSamplingRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEncryptionConfig`](crate::client::fluent_builders::GetEncryptionConfig) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetEncryptionConfig::send) it.

    /// - On success, responds with [`GetEncryptionConfigOutput`](crate::output::GetEncryptionConfigOutput) with field(s):
    ///   - [`encryption_config(Option<EncryptionConfig>)`](crate::output::GetEncryptionConfigOutput::encryption_config): <p>The encryption configuration document.</p>
    /// - On failure, responds with [`SdkError<GetEncryptionConfigError>`](crate::error::GetEncryptionConfigError)
    pub fn get_encryption_config(&self) -> fluent_builders::GetEncryptionConfig {
        fluent_builders::GetEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGroup`](crate::client::fluent_builders::GetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::GetGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::GetGroup::set_group_name): <p>The case-sensitive name of the group.</p>
    ///   - [`group_arn(impl Into<String>)`](crate::client::fluent_builders::GetGroup::group_arn) / [`set_group_arn(Option<String>)`](crate::client::fluent_builders::GetGroup::set_group_arn): <p>The ARN of the group that was generated on creation.</p>
    /// - On success, responds with [`GetGroupOutput`](crate::output::GetGroupOutput) with field(s):
    ///   - [`group(Option<Group>)`](crate::output::GetGroupOutput::group): <p>The group that was requested. Contains the name of the group, the ARN of the group, the filter expression, and the insight configuration assigned to the group.</p>
    /// - On failure, responds with [`SdkError<GetGroupError>`](crate::error::GetGroupError)
    pub fn get_group(&self) -> fluent_builders::GetGroup {
        fluent_builders::GetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGroups`](crate::client::fluent_builders::GetGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetGroups::set_next_token): <p>Pagination token.</p>
    /// - On success, responds with [`GetGroupsOutput`](crate::output::GetGroupsOutput) with field(s):
    ///   - [`groups(Option<Vec<GroupSummary>>)`](crate::output::GetGroupsOutput::groups): <p>The collection of all active groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetGroupsOutput::next_token): <p>Pagination token.</p>
    /// - On failure, responds with [`SdkError<GetGroupsError>`](crate::error::GetGroupsError)
    pub fn get_groups(&self) -> fluent_builders::GetGroups {
        fluent_builders::GetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInsight`](crate::client::fluent_builders::GetInsight) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_id(impl Into<String>)`](crate::client::fluent_builders::GetInsight::insight_id) / [`set_insight_id(Option<String>)`](crate::client::fluent_builders::GetInsight::set_insight_id): <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
    /// - On success, responds with [`GetInsightOutput`](crate::output::GetInsightOutput) with field(s):
    ///   - [`insight(Option<Insight>)`](crate::output::GetInsightOutput::insight): <p>The summary information of an insight.</p>
    /// - On failure, responds with [`SdkError<GetInsightError>`](crate::error::GetInsightError)
    pub fn get_insight(&self) -> fluent_builders::GetInsight {
        fluent_builders::GetInsight::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInsightEvents`](crate::client::fluent_builders::GetInsightEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetInsightEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_id(impl Into<String>)`](crate::client::fluent_builders::GetInsightEvents::insight_id) / [`set_insight_id(Option<String>)`](crate::client::fluent_builders::GetInsightEvents::set_insight_id): <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetInsightEvents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetInsightEvents::set_max_results): <p>Used to retrieve at most the specified value of events.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetInsightEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetInsightEvents::set_next_token): <p>Specify the pagination token returned by a previous request to retrieve the next page of events. </p>
    /// - On success, responds with [`GetInsightEventsOutput`](crate::output::GetInsightEventsOutput) with field(s):
    ///   - [`insight_events(Option<Vec<InsightEvent>>)`](crate::output::GetInsightEventsOutput::insight_events): <p>A detailed description of the event. This includes the time of the event, client and root cause impact statistics, and the top anomalous service at the time of the event.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetInsightEventsOutput::next_token): <p>Use this token to retrieve the next page of insight events.</p>
    /// - On failure, responds with [`SdkError<GetInsightEventsError>`](crate::error::GetInsightEventsError)
    pub fn get_insight_events(&self) -> fluent_builders::GetInsightEvents {
        fluent_builders::GetInsightEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInsightImpactGraph`](crate::client::fluent_builders::GetInsightImpactGraph) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_id(impl Into<String>)`](crate::client::fluent_builders::GetInsightImpactGraph::insight_id) / [`set_insight_id(Option<String>)`](crate::client::fluent_builders::GetInsightImpactGraph::set_insight_id): <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetInsightImpactGraph::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetInsightImpactGraph::set_start_time): <p>The estimated start time of the insight, in Unix time seconds. The StartTime is inclusive of the value provided and can't be more than 30 days old.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetInsightImpactGraph::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetInsightImpactGraph::set_end_time): <p>The estimated end time of the insight, in Unix time seconds. The EndTime is exclusive of the value provided. The time range between the start time and end time can't be more than six hours. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetInsightImpactGraph::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetInsightImpactGraph::set_next_token): <p>Specify the pagination token returned by a previous request to retrieve the next page of results. </p>
    /// - On success, responds with [`GetInsightImpactGraphOutput`](crate::output::GetInsightImpactGraphOutput) with field(s):
    ///   - [`insight_id(Option<String>)`](crate::output::GetInsightImpactGraphOutput::insight_id): <p>The insight's unique identifier.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::GetInsightImpactGraphOutput::start_time): <p>The provided start time.</p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::GetInsightImpactGraphOutput::end_time): <p>The provided end time. </p>
    ///   - [`service_graph_start_time(Option<DateTime>)`](crate::output::GetInsightImpactGraphOutput::service_graph_start_time): <p>The time, in Unix seconds, at which the service graph started.</p>
    ///   - [`service_graph_end_time(Option<DateTime>)`](crate::output::GetInsightImpactGraphOutput::service_graph_end_time): <p>The time, in Unix seconds, at which the service graph ended.</p>
    ///   - [`services(Option<Vec<InsightImpactGraphService>>)`](crate::output::GetInsightImpactGraphOutput::services): <p>The Amazon Web Services instrumented services related to the insight.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetInsightImpactGraphOutput::next_token): <p>Pagination token.</p>
    /// - On failure, responds with [`SdkError<GetInsightImpactGraphError>`](crate::error::GetInsightImpactGraphError)
    pub fn get_insight_impact_graph(&self) -> fluent_builders::GetInsightImpactGraph {
        fluent_builders::GetInsightImpactGraph::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInsightSummaries`](crate::client::fluent_builders::GetInsightSummaries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetInsightSummaries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`states(Vec<InsightState>)`](crate::client::fluent_builders::GetInsightSummaries::states) / [`set_states(Option<Vec<InsightState>>)`](crate::client::fluent_builders::GetInsightSummaries::set_states): <p>The list of insight states. </p>
    ///   - [`group_arn(impl Into<String>)`](crate::client::fluent_builders::GetInsightSummaries::group_arn) / [`set_group_arn(Option<String>)`](crate::client::fluent_builders::GetInsightSummaries::set_group_arn): <p>The Amazon Resource Name (ARN) of the group. Required if the GroupName isn't provided.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::GetInsightSummaries::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::GetInsightSummaries::set_group_name): <p>The name of the group. Required if the GroupARN isn't provided.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetInsightSummaries::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetInsightSummaries::set_start_time): <p>The beginning of the time frame in which the insights started. The start time can't be more than 30 days old.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetInsightSummaries::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetInsightSummaries::set_end_time): <p>The end of the time frame in which the insights ended. The end time can't be more than 30 days old.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetInsightSummaries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetInsightSummaries::set_max_results): <p>The maximum number of results to display.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetInsightSummaries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetInsightSummaries::set_next_token): <p>Pagination token.</p>
    /// - On success, responds with [`GetInsightSummariesOutput`](crate::output::GetInsightSummariesOutput) with field(s):
    ///   - [`insight_summaries(Option<Vec<InsightSummary>>)`](crate::output::GetInsightSummariesOutput::insight_summaries): <p>The summary of each insight within the group matching the provided filters. The summary contains the InsightID, start and end time, the root cause service, the root cause and client impact statistics, the top anomalous services, and the status of the insight.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetInsightSummariesOutput::next_token): <p>Pagination token.</p>
    /// - On failure, responds with [`SdkError<GetInsightSummariesError>`](crate::error::GetInsightSummariesError)
    pub fn get_insight_summaries(&self) -> fluent_builders::GetInsightSummaries {
        fluent_builders::GetInsightSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSamplingRules`](crate::client::fluent_builders::GetSamplingRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetSamplingRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetSamplingRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetSamplingRules::set_next_token): <p>Pagination token.</p>
    /// - On success, responds with [`GetSamplingRulesOutput`](crate::output::GetSamplingRulesOutput) with field(s):
    ///   - [`sampling_rule_records(Option<Vec<SamplingRuleRecord>>)`](crate::output::GetSamplingRulesOutput::sampling_rule_records): <p>Rule definitions and metadata.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetSamplingRulesOutput::next_token): <p>Pagination token.</p>
    /// - On failure, responds with [`SdkError<GetSamplingRulesError>`](crate::error::GetSamplingRulesError)
    pub fn get_sampling_rules(&self) -> fluent_builders::GetSamplingRules {
        fluent_builders::GetSamplingRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSamplingStatisticSummaries`](crate::client::fluent_builders::GetSamplingStatisticSummaries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetSamplingStatisticSummaries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetSamplingStatisticSummaries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetSamplingStatisticSummaries::set_next_token): <p>Pagination token.</p>
    /// - On success, responds with [`GetSamplingStatisticSummariesOutput`](crate::output::GetSamplingStatisticSummariesOutput) with field(s):
    ///   - [`sampling_statistic_summaries(Option<Vec<SamplingStatisticSummary>>)`](crate::output::GetSamplingStatisticSummariesOutput::sampling_statistic_summaries): <p>Information about the number of requests instrumented for each sampling rule.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetSamplingStatisticSummariesOutput::next_token): <p>Pagination token.</p>
    /// - On failure, responds with [`SdkError<GetSamplingStatisticSummariesError>`](crate::error::GetSamplingStatisticSummariesError)
    pub fn get_sampling_statistic_summaries(
        &self,
    ) -> fluent_builders::GetSamplingStatisticSummaries {
        fluent_builders::GetSamplingStatisticSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSamplingTargets`](crate::client::fluent_builders::GetSamplingTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sampling_statistics_documents(Vec<SamplingStatisticsDocument>)`](crate::client::fluent_builders::GetSamplingTargets::sampling_statistics_documents) / [`set_sampling_statistics_documents(Option<Vec<SamplingStatisticsDocument>>)`](crate::client::fluent_builders::GetSamplingTargets::set_sampling_statistics_documents): <p>Information about rules that the service is using to sample requests.</p>
    /// - On success, responds with [`GetSamplingTargetsOutput`](crate::output::GetSamplingTargetsOutput) with field(s):
    ///   - [`sampling_target_documents(Option<Vec<SamplingTargetDocument>>)`](crate::output::GetSamplingTargetsOutput::sampling_target_documents): <p>Updated rules that the service should use to sample requests.</p>
    ///   - [`last_rule_modification(Option<DateTime>)`](crate::output::GetSamplingTargetsOutput::last_rule_modification): <p>The last time a user changed the sampling rule configuration. If the sampling rule configuration changed since the service last retrieved it, the service should call <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html">GetSamplingRules</a> to get the latest version.</p>
    ///   - [`unprocessed_statistics(Option<Vec<UnprocessedStatistics>>)`](crate::output::GetSamplingTargetsOutput::unprocessed_statistics): <p>Information about <a href="https://docs.aws.amazon.com/xray/latest/api/API_SamplingStatisticsDocument.html">SamplingStatisticsDocument</a> that X-Ray could not process.</p>
    /// - On failure, responds with [`SdkError<GetSamplingTargetsError>`](crate::error::GetSamplingTargetsError)
    pub fn get_sampling_targets(&self) -> fluent_builders::GetSamplingTargets {
        fluent_builders::GetSamplingTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServiceGraph`](crate::client::fluent_builders::GetServiceGraph) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetServiceGraph::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetServiceGraph::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetServiceGraph::set_start_time): <p>The start of the time frame for which to generate a graph.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetServiceGraph::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetServiceGraph::set_end_time): <p>The end of the timeframe for which to generate a graph.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::GetServiceGraph::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::GetServiceGraph::set_group_name): <p>The name of a group based on which you want to generate a graph.</p>
    ///   - [`group_arn(impl Into<String>)`](crate::client::fluent_builders::GetServiceGraph::group_arn) / [`set_group_arn(Option<String>)`](crate::client::fluent_builders::GetServiceGraph::set_group_arn): <p>The Amazon Resource Name (ARN) of a group based on which you want to generate a graph.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetServiceGraph::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetServiceGraph::set_next_token): <p>Pagination token.</p>
    /// - On success, responds with [`GetServiceGraphOutput`](crate::output::GetServiceGraphOutput) with field(s):
    ///   - [`start_time(Option<DateTime>)`](crate::output::GetServiceGraphOutput::start_time): <p>The start of the time frame for which the graph was generated.</p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::GetServiceGraphOutput::end_time): <p>The end of the time frame for which the graph was generated.</p>
    ///   - [`services(Option<Vec<Service>>)`](crate::output::GetServiceGraphOutput::services): <p>The services that have processed a traced request during the specified time frame.</p>
    ///   - [`contains_old_group_versions(bool)`](crate::output::GetServiceGraphOutput::contains_old_group_versions): <p>A flag indicating whether the group's filter expression has been consistent, or if the returned service graph may show traces from an older version of the group's filter expression.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetServiceGraphOutput::next_token): <p>Pagination token.</p>
    /// - On failure, responds with [`SdkError<GetServiceGraphError>`](crate::error::GetServiceGraphError)
    pub fn get_service_graph(&self) -> fluent_builders::GetServiceGraph {
        fluent_builders::GetServiceGraph::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTimeSeriesServiceStatistics`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::set_start_time): <p>The start of the time frame for which to aggregate statistics.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::set_end_time): <p>The end of the time frame for which to aggregate statistics.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::set_group_name): <p>The case-sensitive name of the group for which to pull statistics from.</p>
    ///   - [`group_arn(impl Into<String>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::group_arn) / [`set_group_arn(Option<String>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::set_group_arn): <p>The Amazon Resource Name (ARN) of the group for which to pull statistics from.</p>
    ///   - [`entity_selector_expression(impl Into<String>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::entity_selector_expression) / [`set_entity_selector_expression(Option<String>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::set_entity_selector_expression): <p>A filter expression defining entities that will be aggregated for statistics. Supports ID, service, and edge functions. If no selector expression is specified, edge statistics are returned. </p>
    ///   - [`period(i32)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::period) / [`set_period(Option<i32>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::set_period): <p>Aggregation period in seconds.</p>
    ///   - [`forecast_statistics(bool)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::forecast_statistics) / [`set_forecast_statistics(Option<bool>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::set_forecast_statistics): <p>The forecasted high and low fault count values. Forecast enabled requests require the EntitySelectorExpression ID be provided.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics::set_next_token): <p>Pagination token.</p>
    /// - On success, responds with [`GetTimeSeriesServiceStatisticsOutput`](crate::output::GetTimeSeriesServiceStatisticsOutput) with field(s):
    ///   - [`time_series_service_statistics(Option<Vec<TimeSeriesServiceStatistics>>)`](crate::output::GetTimeSeriesServiceStatisticsOutput::time_series_service_statistics): <p>The collection of statistics.</p>
    ///   - [`contains_old_group_versions(bool)`](crate::output::GetTimeSeriesServiceStatisticsOutput::contains_old_group_versions): <p>A flag indicating whether or not a group's filter expression has been consistent, or if a returned aggregation might show statistics from an older version of the group's filter expression.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetTimeSeriesServiceStatisticsOutput::next_token): <p>Pagination token.</p>
    /// - On failure, responds with [`SdkError<GetTimeSeriesServiceStatisticsError>`](crate::error::GetTimeSeriesServiceStatisticsError)
    pub fn get_time_series_service_statistics(
        &self,
    ) -> fluent_builders::GetTimeSeriesServiceStatistics {
        fluent_builders::GetTimeSeriesServiceStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTraceGraph`](crate::client::fluent_builders::GetTraceGraph) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetTraceGraph::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`trace_ids(Vec<String>)`](crate::client::fluent_builders::GetTraceGraph::trace_ids) / [`set_trace_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetTraceGraph::set_trace_ids): <p>Trace IDs of requests for which to generate a service graph.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetTraceGraph::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetTraceGraph::set_next_token): <p>Pagination token.</p>
    /// - On success, responds with [`GetTraceGraphOutput`](crate::output::GetTraceGraphOutput) with field(s):
    ///   - [`services(Option<Vec<Service>>)`](crate::output::GetTraceGraphOutput::services): <p>The services that have processed one of the specified requests.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetTraceGraphOutput::next_token): <p>Pagination token.</p>
    /// - On failure, responds with [`SdkError<GetTraceGraphError>`](crate::error::GetTraceGraphError)
    pub fn get_trace_graph(&self) -> fluent_builders::GetTraceGraph {
        fluent_builders::GetTraceGraph::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTraceSummaries`](crate::client::fluent_builders::GetTraceSummaries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetTraceSummaries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetTraceSummaries::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetTraceSummaries::set_start_time): <p>The start of the time frame for which to retrieve traces.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetTraceSummaries::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetTraceSummaries::set_end_time): <p>The end of the time frame for which to retrieve traces.</p>
    ///   - [`time_range_type(TimeRangeType)`](crate::client::fluent_builders::GetTraceSummaries::time_range_type) / [`set_time_range_type(Option<TimeRangeType>)`](crate::client::fluent_builders::GetTraceSummaries::set_time_range_type): <p>A parameter to indicate whether to query trace summaries by TraceId or Event time.</p>
    ///   - [`sampling(bool)`](crate::client::fluent_builders::GetTraceSummaries::sampling) / [`set_sampling(Option<bool>)`](crate::client::fluent_builders::GetTraceSummaries::set_sampling): <p>Set to <code>true</code> to get summaries for only a subset of available traces.</p>
    ///   - [`sampling_strategy(SamplingStrategy)`](crate::client::fluent_builders::GetTraceSummaries::sampling_strategy) / [`set_sampling_strategy(Option<SamplingStrategy>)`](crate::client::fluent_builders::GetTraceSummaries::set_sampling_strategy): <p>A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and Value.</p>
    ///   - [`filter_expression(impl Into<String>)`](crate::client::fluent_builders::GetTraceSummaries::filter_expression) / [`set_filter_expression(Option<String>)`](crate::client::fluent_builders::GetTraceSummaries::set_filter_expression): <p>Specify a filter expression to retrieve trace summaries for services or requests that meet certain requirements.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetTraceSummaries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetTraceSummaries::set_next_token): <p>Specify the pagination token returned by a previous request to retrieve the next page of results.</p>
    /// - On success, responds with [`GetTraceSummariesOutput`](crate::output::GetTraceSummariesOutput) with field(s):
    ///   - [`trace_summaries(Option<Vec<TraceSummary>>)`](crate::output::GetTraceSummariesOutput::trace_summaries): <p>Trace IDs and annotations for traces that were found in the specified time frame.</p>
    ///   - [`approximate_time(Option<DateTime>)`](crate::output::GetTraceSummariesOutput::approximate_time): <p>The start time of this page of results.</p>
    ///   - [`traces_processed_count(Option<i64>)`](crate::output::GetTraceSummariesOutput::traces_processed_count): <p>The total number of traces processed, including traces that did not match the specified filter expression.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetTraceSummariesOutput::next_token): <p>If the requested time frame contained more than one page of results, you can use this token to retrieve the next page. The first page contains the most recent results, closest to the end of the time frame.</p>
    /// - On failure, responds with [`SdkError<GetTraceSummariesError>`](crate::error::GetTraceSummariesError)
    pub fn get_trace_summaries(&self) -> fluent_builders::GetTraceSummaries {
        fluent_builders::GetTraceSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with the current page of results as the value of this parameter to get the next page of results.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tags, as key and value pairs, that is associated with the specified X-Ray group or sampling rule.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with the current page of results to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEncryptionConfig`](crate::client::fluent_builders::PutEncryptionConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::PutEncryptionConfig::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::PutEncryptionConfig::set_key_id): <p>An Amazon Web Services KMS key in one of the following formats:</p>  <ul>   <li> <p> <b>Alias</b> - The name of the key. For example, <code>alias/MyKey</code>.</p> </li>   <li> <p> <b>Key ID</b> - The KMS key ID of the key. For example, <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Amazon Web Services X-Ray does not support asymmetric KMS keys.</p> </li>   <li> <p> <b>ARN</b> - The full Amazon Resource Name of the key ID or alias. For example, <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Use this format to specify a key in a different account.</p> </li>  </ul>  <p>Omit this key if you set <code>Type</code> to <code>NONE</code>.</p>
    ///   - [`r#type(EncryptionType)`](crate::client::fluent_builders::PutEncryptionConfig::type) / [`set_type(Option<EncryptionType>)`](crate::client::fluent_builders::PutEncryptionConfig::set_type): <p>The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to <code>NONE</code> for default encryption.</p>
    /// - On success, responds with [`PutEncryptionConfigOutput`](crate::output::PutEncryptionConfigOutput) with field(s):
    ///   - [`encryption_config(Option<EncryptionConfig>)`](crate::output::PutEncryptionConfigOutput::encryption_config): <p>The new encryption configuration.</p>
    /// - On failure, responds with [`SdkError<PutEncryptionConfigError>`](crate::error::PutEncryptionConfigError)
    pub fn put_encryption_config(&self) -> fluent_builders::PutEncryptionConfig {
        fluent_builders::PutEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutTelemetryRecords`](crate::client::fluent_builders::PutTelemetryRecords) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`telemetry_records(Vec<TelemetryRecord>)`](crate::client::fluent_builders::PutTelemetryRecords::telemetry_records) / [`set_telemetry_records(Option<Vec<TelemetryRecord>>)`](crate::client::fluent_builders::PutTelemetryRecords::set_telemetry_records): <p></p>
    ///   - [`ec2_instance_id(impl Into<String>)`](crate::client::fluent_builders::PutTelemetryRecords::ec2_instance_id) / [`set_ec2_instance_id(Option<String>)`](crate::client::fluent_builders::PutTelemetryRecords::set_ec2_instance_id): <p></p>
    ///   - [`hostname(impl Into<String>)`](crate::client::fluent_builders::PutTelemetryRecords::hostname) / [`set_hostname(Option<String>)`](crate::client::fluent_builders::PutTelemetryRecords::set_hostname): <p></p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::PutTelemetryRecords::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::PutTelemetryRecords::set_resource_arn): <p></p>
    /// - On success, responds with [`PutTelemetryRecordsOutput`](crate::output::PutTelemetryRecordsOutput)

    /// - On failure, responds with [`SdkError<PutTelemetryRecordsError>`](crate::error::PutTelemetryRecordsError)
    pub fn put_telemetry_records(&self) -> fluent_builders::PutTelemetryRecords {
        fluent_builders::PutTelemetryRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutTraceSegments`](crate::client::fluent_builders::PutTraceSegments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`trace_segment_documents(Vec<String>)`](crate::client::fluent_builders::PutTraceSegments::trace_segment_documents) / [`set_trace_segment_documents(Option<Vec<String>>)`](crate::client::fluent_builders::PutTraceSegments::set_trace_segment_documents): <p>A string containing a JSON document defining one or more segments or subsegments.</p>
    /// - On success, responds with [`PutTraceSegmentsOutput`](crate::output::PutTraceSegmentsOutput) with field(s):
    ///   - [`unprocessed_trace_segments(Option<Vec<UnprocessedTraceSegment>>)`](crate::output::PutTraceSegmentsOutput::unprocessed_trace_segments): <p>Segments that failed processing.</p>
    /// - On failure, responds with [`SdkError<PutTraceSegmentsError>`](crate::error::PutTraceSegmentsError)
    pub fn put_trace_segments(&self) -> fluent_builders::PutTraceSegments {
        fluent_builders::PutTraceSegments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group or sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>  <p>The following restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of user-applied tags per resource: 50</p> </li>   <li> <p>Maximum tag key length: 128 Unicode characters</p> </li>   <li> <p>Maximum tag value length: 256 Unicode characters</p> </li>   <li> <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @</p> </li>   <li> <p>Tag keys and values are case sensitive.</p> </li>   <li> <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You cannot edit or delete system tags.</p> </li>  </ul>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Keys for one or more tags that you want to remove from an X-Ray group or sampling rule.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGroup`](crate::client::fluent_builders::UpdateGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_group_name): <p>The case-sensitive name of the group.</p>
    ///   - [`group_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::group_arn) / [`set_group_arn(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_group_arn): <p>The ARN that was generated upon creation.</p>
    ///   - [`filter_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::filter_expression) / [`set_filter_expression(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_filter_expression): <p>The updated filter expression defining criteria by which to group traces.</p>
    ///   - [`insights_configuration(InsightsConfiguration)`](crate::client::fluent_builders::UpdateGroup::insights_configuration) / [`set_insights_configuration(Option<InsightsConfiguration>)`](crate::client::fluent_builders::UpdateGroup::set_insights_configuration): <p>The structure containing configurations related to insights.</p>  <ul>   <li> <p>The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for the group.</p> </li>   <li> <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group. Notifications can only be enabled on a group with InsightsEnabled set to true.</p> </li>  </ul>
    /// - On success, responds with [`UpdateGroupOutput`](crate::output::UpdateGroupOutput) with field(s):
    ///   - [`group(Option<Group>)`](crate::output::UpdateGroupOutput::group): <p>The group that was updated. Contains the name of the group that was updated, the ARN of the group that was updated, the updated filter expression, and the updated insight configuration assigned to the group.</p>
    /// - On failure, responds with [`SdkError<UpdateGroupError>`](crate::error::UpdateGroupError)
    pub fn update_group(&self) -> fluent_builders::UpdateGroup {
        fluent_builders::UpdateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSamplingRule`](crate::client::fluent_builders::UpdateSamplingRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sampling_rule_update(SamplingRuleUpdate)`](crate::client::fluent_builders::UpdateSamplingRule::sampling_rule_update) / [`set_sampling_rule_update(Option<SamplingRuleUpdate>)`](crate::client::fluent_builders::UpdateSamplingRule::set_sampling_rule_update): <p>The rule and fields to change.</p>
    /// - On success, responds with [`UpdateSamplingRuleOutput`](crate::output::UpdateSamplingRuleOutput) with field(s):
    ///   - [`sampling_rule_record(Option<SamplingRuleRecord>)`](crate::output::UpdateSamplingRuleOutput::sampling_rule_record): <p>The updated rule definition and metadata.</p>
    /// - On failure, responds with [`SdkError<UpdateSamplingRuleError>`](crate::error::UpdateSamplingRuleError)
    pub fn update_sampling_rule(&self) -> fluent_builders::UpdateSamplingRule {
        fluent_builders::UpdateSamplingRule::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchGetTraces`.
    ///
    /// <p>Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from a single request. Use <code>GetTraceSummaries</code> to get a list of trace IDs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetTraces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_traces_input::Builder,
    }
    impl BatchGetTraces {
        /// Creates a new `BatchGetTraces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetTracesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetTracesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::BatchGetTracesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::BatchGetTracesPaginator {
            crate::paginator::BatchGetTracesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `TraceIds`.
        ///
        /// To override the contents of this collection use [`set_trace_ids`](Self::set_trace_ids).
        ///
        /// <p>Specify the trace IDs of requests for which to retrieve segments.</p>
        pub fn trace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trace_ids(input.into());
            self
        }
        /// <p>Specify the trace IDs of requests for which to retrieve segments.</p>
        pub fn set_trace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trace_ids(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// <p>Creates a group resource with a name and a filter expression. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_group_input::Builder,
    }
    impl CreateGroup {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The case-sensitive name of the new group. Default is a reserved name and names must be unique.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The case-sensitive name of the new group. Default is a reserved name and names must be unique.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The filter expression defining criteria by which to group traces.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(input.into());
            self
        }
        /// <p>The filter expression defining criteria by which to group traces.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li> <p>The InsightsEnabled boolean can be set to true to enable insights for the new group or false to disable insights for the new group.</p> </li>
        /// <li> <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group. Notifications may only be enabled on a group with InsightsEnabled set to true.</p> </li>
        /// </ul>
        pub fn insights_configuration(
            mut self,
            input: crate::model::InsightsConfiguration,
        ) -> Self {
            self.inner = self.inner.insights_configuration(input);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li> <p>The InsightsEnabled boolean can be set to true to enable insights for the new group or false to disable insights for the new group.</p> </li>
        /// <li> <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group. Notifications may only be enabled on a group with InsightsEnabled set to true.</p> </li>
        /// </ul>
        pub fn set_insights_configuration(
            mut self,
            input: std::option::Option<crate::model::InsightsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_insights_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of user-applied tags per resource: 50</p> </li>
        /// <li> <p>Maximum tag key length: 128 Unicode characters</p> </li>
        /// <li> <p>Maximum tag value length: 256 Unicode characters</p> </li>
        /// <li> <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @</p> </li>
        /// <li> <p>Tag keys and values are case sensitive.</p> </li>
        /// <li> <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of user-applied tags per resource: 50</p> </li>
        /// <li> <p>Maximum tag key length: 128 Unicode characters</p> </li>
        /// <li> <p>Maximum tag value length: 256 Unicode characters</p> </li>
        /// <li> <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @</p> </li>
        /// <li> <p>Tag keys and values are case sensitive.</p> </li>
        /// <li> <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSamplingRule`.
    ///
    /// <p>Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html">GetSamplingRules</a>, and evaluate each rule in ascending order of <i>priority</i> for each request. If a rule matches, the service records a trace, borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a> to get updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of borrowing from the reservoir.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSamplingRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_sampling_rule_input::Builder,
    }
    impl CreateSamplingRule {
        /// Creates a new `CreateSamplingRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSamplingRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSamplingRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule definition.</p>
        pub fn sampling_rule(mut self, input: crate::model::SamplingRule) -> Self {
            self.inner = self.inner.sampling_rule(input);
            self
        }
        /// <p>The rule definition.</p>
        pub fn set_sampling_rule(
            mut self,
            input: std::option::Option<crate::model::SamplingRule>,
        ) -> Self {
            self.inner = self.inner.set_sampling_rule(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of user-applied tags per resource: 50</p> </li>
        /// <li> <p>Maximum tag key length: 128 Unicode characters</p> </li>
        /// <li> <p>Maximum tag value length: 256 Unicode characters</p> </li>
        /// <li> <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @</p> </li>
        /// <li> <p>Tag keys and values are case sensitive.</p> </li>
        /// <li> <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of user-applied tags per resource: 50</p> </li>
        /// <li> <p>Maximum tag key length: 128 Unicode characters</p> </li>
        /// <li> <p>Maximum tag value length: 256 Unicode characters</p> </li>
        /// <li> <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @</p> </li>
        /// <li> <p>Tag keys and values are case sensitive.</p> </li>
        /// <li> <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// <p>Deletes a group resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl DeleteGroup {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(input.into());
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSamplingRule`.
    ///
    /// <p>Deletes a sampling rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSamplingRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_sampling_rule_input::Builder,
    }
    impl DeleteSamplingRule {
        /// Creates a new `DeleteSamplingRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSamplingRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSamplingRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_arn(input.into());
            self
        }
        /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEncryptionConfig`.
    ///
    /// <p>Retrieves the current encryption configuration for X-Ray data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEncryptionConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_encryption_config_input::Builder,
    }
    impl GetEncryptionConfig {
        /// Creates a new `GetEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEncryptionConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetGroup`.
    ///
    /// <p>Retrieves group resource details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_group_input::Builder,
    }
    impl GetGroup {
        /// Creates a new `GetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(input.into());
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroups`.
    ///
    /// <p>Retrieves all active group details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_groups_input::Builder,
    }
    impl GetGroups {
        /// Creates a new `GetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetGroupsPaginator {
            crate::paginator::GetGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsight`.
    ///
    /// <p>Retrieves the summary information of an insight. This includes impact to clients and root cause services, the top anomalous services, the category, the state of the insight, and the start and end time of the insight.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInsight {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_insight_input::Builder,
    }
    impl GetInsight {
        /// Creates a new `GetInsight`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(input.into());
            self
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsightEvents`.
    ///
    /// <p>X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event. You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInsightEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_insight_events_input::Builder,
    }
    impl GetInsightEvents {
        /// Creates a new `GetInsightEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetInsightEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetInsightEventsPaginator {
            crate::paginator::GetInsightEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(input.into());
            self
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
        /// <p>Used to retrieve at most the specified value of events.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Used to retrieve at most the specified value of events.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of events. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of events. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsightImpactGraph`.
    ///
    /// <p>Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only structural information. For a complete service graph, use this API with the GetServiceGraph API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInsightImpactGraph {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_insight_impact_graph_input::Builder,
    }
    impl GetInsightImpactGraph {
        /// Creates a new `GetInsightImpactGraph`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightImpactGraphOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightImpactGraphError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(input.into());
            self
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
        /// <p>The estimated start time of the insight, in Unix time seconds. The StartTime is inclusive of the value provided and can't be more than 30 days old.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The estimated start time of the insight, in Unix time seconds. The StartTime is inclusive of the value provided and can't be more than 30 days old.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The estimated end time of the insight, in Unix time seconds. The EndTime is exclusive of the value provided. The time range between the start time and end time can't be more than six hours. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The estimated end time of the insight, in Unix time seconds. The EndTime is exclusive of the value provided. The time range between the start time and end time can't be more than six hours. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsightSummaries`.
    ///
    /// <p>Retrieves the summaries of all insights in the specified group matching the provided filter values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInsightSummaries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_insight_summaries_input::Builder,
    }
    impl GetInsightSummaries {
        /// Creates a new `GetInsightSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightSummariesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetInsightSummariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetInsightSummariesPaginator {
            crate::paginator::GetInsightSummariesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `States`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The list of insight states. </p>
        pub fn states(mut self, input: crate::model::InsightState) -> Self {
            self.inner = self.inner.states(input);
            self
        }
        /// <p>The list of insight states. </p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group. Required if the GroupName isn't provided.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group. Required if the GroupName isn't provided.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
        /// <p>The name of the group. Required if the GroupARN isn't provided.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group. Required if the GroupARN isn't provided.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The beginning of the time frame in which the insights started. The start time can't be more than 30 days old.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The beginning of the time frame in which the insights started. The start time can't be more than 30 days old.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time frame in which the insights ended. The end time can't be more than 30 days old.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time frame in which the insights ended. The end time can't be more than 30 days old.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSamplingRules`.
    ///
    /// <p>Retrieves all sampling rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSamplingRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_sampling_rules_input::Builder,
    }
    impl GetSamplingRules {
        /// Creates a new `GetSamplingRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSamplingRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSamplingRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSamplingRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetSamplingRulesPaginator {
            crate::paginator::GetSamplingRulesPaginator::new(self.handle, self.inner)
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSamplingStatisticSummaries`.
    ///
    /// <p>Retrieves information about recent sampling results for all sampling rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSamplingStatisticSummaries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_sampling_statistic_summaries_input::Builder,
    }
    impl GetSamplingStatisticSummaries {
        /// Creates a new `GetSamplingStatisticSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSamplingStatisticSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSamplingStatisticSummariesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSamplingStatisticSummariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetSamplingStatisticSummariesPaginator {
            crate::paginator::GetSamplingStatisticSummariesPaginator::new(self.handle, self.inner)
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSamplingTargets`.
    ///
    /// <p>Requests a sampling quota for rules that the service is using to sample requests. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSamplingTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_sampling_targets_input::Builder,
    }
    impl GetSamplingTargets {
        /// Creates a new `GetSamplingTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSamplingTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSamplingTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `SamplingStatisticsDocuments`.
        ///
        /// To override the contents of this collection use [`set_sampling_statistics_documents`](Self::set_sampling_statistics_documents).
        ///
        /// <p>Information about rules that the service is using to sample requests.</p>
        pub fn sampling_statistics_documents(
            mut self,
            input: crate::model::SamplingStatisticsDocument,
        ) -> Self {
            self.inner = self.inner.sampling_statistics_documents(input);
            self
        }
        /// <p>Information about rules that the service is using to sample requests.</p>
        pub fn set_sampling_statistics_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SamplingStatisticsDocument>>,
        ) -> Self {
            self.inner = self.inner.set_sampling_statistics_documents(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceGraph`.
    ///
    /// <p>Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result. Root services process incoming requests and make calls to downstream services. Root services are applications that use the <a href="https://docs.aws.amazon.com/xray/index.html">Amazon Web Services X-Ray SDK</a>. Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL databases.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServiceGraph {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_service_graph_input::Builder,
    }
    impl GetServiceGraph {
        /// Creates a new `GetServiceGraph`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceGraphOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceGraphError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetServiceGraphPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetServiceGraphPaginator {
            crate::paginator::GetServiceGraphPaginator::new(self.handle, self.inner)
        }
        /// <p>The start of the time frame for which to generate a graph.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start of the time frame for which to generate a graph.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the timeframe for which to generate a graph.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the timeframe for which to generate a graph.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The name of a group based on which you want to generate a graph.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of a group based on which you want to generate a graph.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a group based on which you want to generate a graph.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a group based on which you want to generate a graph.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTimeSeriesServiceStatistics`.
    ///
    /// <p>Get an aggregation of service statistics defined by a specific time range.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTimeSeriesServiceStatistics {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_time_series_service_statistics_input::Builder,
    }
    impl GetTimeSeriesServiceStatistics {
        /// Creates a new `GetTimeSeriesServiceStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTimeSeriesServiceStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTimeSeriesServiceStatisticsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetTimeSeriesServiceStatisticsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetTimeSeriesServiceStatisticsPaginator {
            crate::paginator::GetTimeSeriesServiceStatisticsPaginator::new(self.handle, self.inner)
        }
        /// <p>The start of the time frame for which to aggregate statistics.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start of the time frame for which to aggregate statistics.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time frame for which to aggregate statistics.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time frame for which to aggregate statistics.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The case-sensitive name of the group for which to pull statistics from.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The case-sensitive name of the group for which to pull statistics from.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group for which to pull statistics from.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group for which to pull statistics from.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
        /// <p>A filter expression defining entities that will be aggregated for statistics. Supports ID, service, and edge functions. If no selector expression is specified, edge statistics are returned. </p>
        pub fn entity_selector_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_selector_expression(input.into());
            self
        }
        /// <p>A filter expression defining entities that will be aggregated for statistics. Supports ID, service, and edge functions. If no selector expression is specified, edge statistics are returned. </p>
        pub fn set_entity_selector_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entity_selector_expression(input);
            self
        }
        /// <p>Aggregation period in seconds.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.inner = self.inner.period(input);
            self
        }
        /// <p>Aggregation period in seconds.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The forecasted high and low fault count values. Forecast enabled requests require the EntitySelectorExpression ID be provided.</p>
        pub fn forecast_statistics(mut self, input: bool) -> Self {
            self.inner = self.inner.forecast_statistics(input);
            self
        }
        /// <p>The forecasted high and low fault count values. Forecast enabled requests require the EntitySelectorExpression ID be provided.</p>
        pub fn set_forecast_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_forecast_statistics(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTraceGraph`.
    ///
    /// <p>Retrieves a service graph for one or more specific trace IDs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTraceGraph {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_trace_graph_input::Builder,
    }
    impl GetTraceGraph {
        /// Creates a new `GetTraceGraph`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTraceGraphOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTraceGraphError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetTraceGraphPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetTraceGraphPaginator {
            crate::paginator::GetTraceGraphPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `TraceIds`.
        ///
        /// To override the contents of this collection use [`set_trace_ids`](Self::set_trace_ids).
        ///
        /// <p>Trace IDs of requests for which to generate a service graph.</p>
        pub fn trace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trace_ids(input.into());
            self
        }
        /// <p>Trace IDs of requests for which to generate a service graph.</p>
        pub fn set_trace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trace_ids(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTraceSummaries`.
    ///
    /// <p>Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get the full traces, pass the trace IDs to <code>BatchGetTraces</code>.</p>
    /// <p>A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come from a known user. For example, the following filter expression targets traces that pass through <code>api.example.com</code>:</p>
    /// <p> <code>service("api.example.com")</code> </p>
    /// <p>This filter expression finds traces that have an annotation named <code>account</code> with the value <code>12345</code>:</p>
    /// <p> <code>annotation.account = "12345"</code> </p>
    /// <p>For a full list of indexed fields and keywords that you can use in filter expressions, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html">Using Filter Expressions</a> in the <i>Amazon Web Services X-Ray Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTraceSummaries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_trace_summaries_input::Builder,
    }
    impl GetTraceSummaries {
        /// Creates a new `GetTraceSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTraceSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTraceSummariesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetTraceSummariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetTraceSummariesPaginator {
            crate::paginator::GetTraceSummariesPaginator::new(self.handle, self.inner)
        }
        /// <p>The start of the time frame for which to retrieve traces.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start of the time frame for which to retrieve traces.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time frame for which to retrieve traces.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time frame for which to retrieve traces.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>A parameter to indicate whether to query trace summaries by TraceId or Event time.</p>
        pub fn time_range_type(mut self, input: crate::model::TimeRangeType) -> Self {
            self.inner = self.inner.time_range_type(input);
            self
        }
        /// <p>A parameter to indicate whether to query trace summaries by TraceId or Event time.</p>
        pub fn set_time_range_type(
            mut self,
            input: std::option::Option<crate::model::TimeRangeType>,
        ) -> Self {
            self.inner = self.inner.set_time_range_type(input);
            self
        }
        /// <p>Set to <code>true</code> to get summaries for only a subset of available traces.</p>
        pub fn sampling(mut self, input: bool) -> Self {
            self.inner = self.inner.sampling(input);
            self
        }
        /// <p>Set to <code>true</code> to get summaries for only a subset of available traces.</p>
        pub fn set_sampling(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sampling(input);
            self
        }
        /// <p>A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and Value.</p>
        pub fn sampling_strategy(mut self, input: crate::model::SamplingStrategy) -> Self {
            self.inner = self.inner.sampling_strategy(input);
            self
        }
        /// <p>A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and Value.</p>
        pub fn set_sampling_strategy(
            mut self,
            input: std::option::Option<crate::model::SamplingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_sampling_strategy(input);
            self
        }
        /// <p>Specify a filter expression to retrieve trace summaries for services or requests that meet certain requirements.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(input.into());
            self
        }
        /// <p>Specify a filter expression to retrieve trace summaries for services or requests that meet certain requirements.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with the current page of results as the value of this parameter to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with the current page of results as the value of this parameter to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEncryptionConfig`.
    ///
    /// <p>Updates the encryption configuration for X-Ray data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEncryptionConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_encryption_config_input::Builder,
    }
    impl PutEncryptionConfig {
        /// Creates a new `PutEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEncryptionConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Web Services KMS key in one of the following formats:</p>
        /// <ul>
        /// <li> <p> <b>Alias</b> - The name of the key. For example, <code>alias/MyKey</code>.</p> </li>
        /// <li> <p> <b>Key ID</b> - The KMS key ID of the key. For example, <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Amazon Web Services X-Ray does not support asymmetric KMS keys.</p> </li>
        /// <li> <p> <b>ARN</b> - The full Amazon Resource Name of the key ID or alias. For example, <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Use this format to specify a key in a different account.</p> </li>
        /// </ul>
        /// <p>Omit this key if you set <code>Type</code> to <code>NONE</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>An Amazon Web Services KMS key in one of the following formats:</p>
        /// <ul>
        /// <li> <p> <b>Alias</b> - The name of the key. For example, <code>alias/MyKey</code>.</p> </li>
        /// <li> <p> <b>Key ID</b> - The KMS key ID of the key. For example, <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Amazon Web Services X-Ray does not support asymmetric KMS keys.</p> </li>
        /// <li> <p> <b>ARN</b> - The full Amazon Resource Name of the key ID or alias. For example, <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Use this format to specify a key in a different account.</p> </li>
        /// </ul>
        /// <p>Omit this key if you set <code>Type</code> to <code>NONE</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to <code>NONE</code> for default encryption.</p>
        pub fn r#type(mut self, input: crate::model::EncryptionType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to <code>NONE</code> for default encryption.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutTelemetryRecords`.
    ///
    /// <p>Used by the Amazon Web Services X-Ray daemon to upload telemetry.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutTelemetryRecords {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_telemetry_records_input::Builder,
    }
    impl PutTelemetryRecords {
        /// Creates a new `PutTelemetryRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutTelemetryRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutTelemetryRecordsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TelemetryRecords`.
        ///
        /// To override the contents of this collection use [`set_telemetry_records`](Self::set_telemetry_records).
        ///
        /// <p></p>
        pub fn telemetry_records(mut self, input: crate::model::TelemetryRecord) -> Self {
            self.inner = self.inner.telemetry_records(input);
            self
        }
        /// <p></p>
        pub fn set_telemetry_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TelemetryRecord>>,
        ) -> Self {
            self.inner = self.inner.set_telemetry_records(input);
            self
        }
        /// <p></p>
        pub fn ec2_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_instance_id(input.into());
            self
        }
        /// <p></p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_instance_id(input);
            self
        }
        /// <p></p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hostname(input.into());
            self
        }
        /// <p></p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hostname(input);
            self
        }
        /// <p></p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutTraceSegments`.
    ///
    /// <p>Uploads segment documents to Amazon Web Services X-Ray. The <a href="https://docs.aws.amazon.com/xray/index.html">X-Ray SDK</a> generates segment documents and sends them to the X-Ray daemon, which uploads them in batches. A segment document can be a completed segment, an in-progress segment, or an array of subsegments.</p>
    /// <p>Segments must include the following fields. For the full segment document schema, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html">Amazon Web Services X-Ray Segment Documents</a> in the <i>Amazon Web Services X-Ray Developer Guide</i>.</p>
    /// <p class="title"> <b>Required segment document fields</b> </p>
    /// <ul>
    /// <li> <p> <code>name</code> - The name of the service that handled the request.</p> </li>
    /// <li> <p> <code>id</code> - A 64-bit identifier for the segment, unique among segments in the same trace, in 16 hexadecimal digits.</p> </li>
    /// <li> <p> <code>trace_id</code> - A unique identifier that connects all segments and subsegments originating from a single client request.</p> </li>
    /// <li> <p> <code>start_time</code> - Time the segment or subsegment was created, in floating point seconds in epoch time, accurate to milliseconds. For example, <code>1480615200.010</code> or <code>1.480615200010E9</code>.</p> </li>
    /// <li> <p> <code>end_time</code> - Time the segment or subsegment was closed. For example, <code>1480615200.090</code> or <code>1.480615200090E9</code>. Specify either an <code>end_time</code> or <code>in_progress</code>.</p> </li>
    /// <li> <p> <code>in_progress</code> - Set to <code>true</code> instead of specifying an <code>end_time</code> to record that a segment has been started, but is not complete. Send an in-progress segment when your application receives a request that will take a long time to serve, to trace that the request was received. When the response is sent, send the complete segment to overwrite the in-progress segment.</p> </li>
    /// </ul>
    /// <p>A <code>trace_id</code> consists of three numbers separated by hyphens. For example, 1-58406520-a006649127e371903a2de979. This includes:</p>
    /// <p class="title"> <b>Trace ID Format</b> </p>
    /// <ul>
    /// <li> <p>The version number, for instance, <code>1</code>.</p> </li>
    /// <li> <p>The time of the original request, in Unix epoch time, in 8 hexadecimal digits. For example, 10:00AM December 2nd, 2016 PST in epoch time is <code>1480615200</code> seconds, or <code>58406520</code> in hexadecimal.</p> </li>
    /// <li> <p>A 96-bit identifier for the trace, globally unique, in 24 hexadecimal digits.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutTraceSegments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_trace_segments_input::Builder,
    }
    impl PutTraceSegments {
        /// Creates a new `PutTraceSegments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutTraceSegmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutTraceSegmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TraceSegmentDocuments`.
        ///
        /// To override the contents of this collection use [`set_trace_segment_documents`](Self::set_trace_segment_documents).
        ///
        /// <p>A string containing a JSON document defining one or more segments or subsegments.</p>
        pub fn trace_segment_documents(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trace_segment_documents(input.into());
            self
        }
        /// <p>A string containing a JSON document defining one or more segments or subsegments.</p>
        pub fn set_trace_segment_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trace_segment_documents(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group or sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of user-applied tags per resource: 50</p> </li>
        /// <li> <p>Maximum tag key length: 128 Unicode characters</p> </li>
        /// <li> <p>Maximum tag value length: 256 Unicode characters</p> </li>
        /// <li> <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @</p> </li>
        /// <li> <p>Tag keys and values are case sensitive.</p> </li>
        /// <li> <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You cannot edit or delete system tags.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group or sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of user-applied tags per resource: 50</p> </li>
        /// <li> <p>Maximum tag key length: 128 Unicode characters</p> </li>
        /// <li> <p>Maximum tag value length: 256 Unicode characters</p> </li>
        /// <li> <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @</p> </li>
        /// <li> <p>Tag keys and values are case sensitive.</p> </li>
        /// <li> <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You cannot edit or delete system tags.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from an Amazon Web Services X-Ray group or sampling rule. You cannot edit or delete system tags (those with an <code>aws:</code> prefix).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys for one or more tags that you want to remove from an X-Ray group or sampling rule.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Keys for one or more tags that you want to remove from an X-Ray group or sampling rule.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroup`.
    ///
    /// <p>Updates a group resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_group_input::Builder,
    }
    impl UpdateGroup {
        /// Creates a new `UpdateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ARN that was generated upon creation.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(input.into());
            self
        }
        /// <p>The ARN that was generated upon creation.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
        /// <p>The updated filter expression defining criteria by which to group traces.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(input.into());
            self
        }
        /// <p>The updated filter expression defining criteria by which to group traces.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li> <p>The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for the group.</p> </li>
        /// <li> <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group. Notifications can only be enabled on a group with InsightsEnabled set to true.</p> </li>
        /// </ul>
        pub fn insights_configuration(
            mut self,
            input: crate::model::InsightsConfiguration,
        ) -> Self {
            self.inner = self.inner.insights_configuration(input);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li> <p>The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for the group.</p> </li>
        /// <li> <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group. Notifications can only be enabled on a group with InsightsEnabled set to true.</p> </li>
        /// </ul>
        pub fn set_insights_configuration(
            mut self,
            input: std::option::Option<crate::model::InsightsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_insights_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSamplingRule`.
    ///
    /// <p>Modifies a sampling rule's configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSamplingRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_sampling_rule_input::Builder,
    }
    impl UpdateSamplingRule {
        /// Creates a new `UpdateSamplingRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSamplingRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSamplingRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule and fields to change.</p>
        pub fn sampling_rule_update(mut self, input: crate::model::SamplingRuleUpdate) -> Self {
            self.inner = self.inner.sampling_rule_update(input);
            self
        }
        /// <p>The rule and fields to change.</p>
        pub fn set_sampling_rule_update(
            mut self,
            input: std::option::Option<crate::model::SamplingRuleUpdate>,
        ) -> Self {
            self.inner = self.inner.set_sampling_rule_update(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
