// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchGetTraces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetTracesError {
    /// Kind of error that occurred.
    pub kind: BatchGetTracesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetTraces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetTracesErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetTracesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetTracesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchGetTracesErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            BatchGetTracesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetTracesError {
    fn code(&self) -> Option<&str> {
        BatchGetTracesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetTracesError {
    /// Creates a new `BatchGetTracesError`.
    pub fn new(kind: BatchGetTracesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetTracesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetTracesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetTracesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetTracesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetTracesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetTracesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetTracesErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, BatchGetTracesErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for BatchGetTracesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetTracesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchGetTracesErrorKind::ThrottledException(_inner) => Some(_inner),
            BatchGetTracesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGroupError {
    /// Kind of error that occurred.
    pub kind: CreateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGroupErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGroupError {
    fn code(&self) -> Option<&str> {
        CreateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGroupError {
    /// Creates a new `CreateGroupError`.
    pub fn new(kind: CreateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for CreateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateGroupErrorKind::ThrottledException(_inner) => Some(_inner),
            CreateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSamplingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSamplingRuleError {
    /// Kind of error that occurred.
    pub kind: CreateSamplingRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSamplingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSamplingRuleErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You have reached the maximum number of sampling rules.</p>
    RuleLimitExceededException(crate::error::RuleLimitExceededException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSamplingRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSamplingRuleErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateSamplingRuleErrorKind::RuleLimitExceededException(_inner) => _inner.fmt(f),
            CreateSamplingRuleErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            CreateSamplingRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSamplingRuleError {
    fn code(&self) -> Option<&str> {
        CreateSamplingRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSamplingRuleError {
    /// Creates a new `CreateSamplingRuleError`.
    pub fn new(kind: CreateSamplingRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSamplingRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSamplingRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSamplingRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSamplingRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSamplingRuleErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSamplingRuleErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSamplingRuleErrorKind::RuleLimitExceededException`.
    pub fn is_rule_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSamplingRuleErrorKind::RuleLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSamplingRuleErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSamplingRuleErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for CreateSamplingRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSamplingRuleErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateSamplingRuleErrorKind::RuleLimitExceededException(_inner) => Some(_inner),
            CreateSamplingRuleErrorKind::ThrottledException(_inner) => Some(_inner),
            CreateSamplingRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGroupErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGroupError {
    fn code(&self) -> Option<&str> {
        DeleteGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGroupError {
    /// Creates a new `DeleteGroupError`.
    pub fn new(kind: DeleteGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for DeleteGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteGroupErrorKind::ThrottledException(_inner) => Some(_inner),
            DeleteGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSamplingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSamplingRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteSamplingRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSamplingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSamplingRuleErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSamplingRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSamplingRuleErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteSamplingRuleErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            DeleteSamplingRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSamplingRuleError {
    fn code(&self) -> Option<&str> {
        DeleteSamplingRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSamplingRuleError {
    /// Creates a new `DeleteSamplingRuleError`.
    pub fn new(kind: DeleteSamplingRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSamplingRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSamplingRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSamplingRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSamplingRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSamplingRuleErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSamplingRuleErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSamplingRuleErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSamplingRuleErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for DeleteSamplingRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSamplingRuleErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteSamplingRuleErrorKind::ThrottledException(_inner) => Some(_inner),
            DeleteSamplingRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEncryptionConfigError {
    /// Kind of error that occurred.
    pub kind: GetEncryptionConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEncryptionConfigErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEncryptionConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEncryptionConfigErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetEncryptionConfigErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetEncryptionConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEncryptionConfigError {
    fn code(&self) -> Option<&str> {
        GetEncryptionConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEncryptionConfigError {
    /// Creates a new `GetEncryptionConfigError`.
    pub fn new(kind: GetEncryptionConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEncryptionConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEncryptionConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEncryptionConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEncryptionConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEncryptionConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEncryptionConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEncryptionConfigErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEncryptionConfigErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for GetEncryptionConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEncryptionConfigErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetEncryptionConfigErrorKind::ThrottledException(_inner) => Some(_inner),
            GetEncryptionConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGroupError {
    /// Kind of error that occurred.
    pub kind: GetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGroupErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGroupError {
    fn code(&self) -> Option<&str> {
        GetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGroupError {
    /// Creates a new `GetGroupError`.
    pub fn new(kind: GetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `GetGroupErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for GetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetGroupErrorKind::ThrottledException(_inner) => Some(_inner),
            GetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGroupsError {
    /// Kind of error that occurred.
    pub kind: GetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGroupsErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGroupsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetGroupsErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGroupsError {
    fn code(&self) -> Option<&str> {
        GetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGroupsError {
    /// Creates a new `GetGroupsError`.
    pub fn new(kind: GetGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGroupsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetGroupsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `GetGroupsErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, GetGroupsErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for GetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGroupsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetGroupsErrorKind::ThrottledException(_inner) => Some(_inner),
            GetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInsight` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInsightError {
    /// Kind of error that occurred.
    pub kind: GetInsightErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInsight` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInsightErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInsightError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInsightErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetInsightErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetInsightErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInsightError {
    fn code(&self) -> Option<&str> {
        GetInsightError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInsightError {
    /// Creates a new `GetInsightError`.
    pub fn new(kind: GetInsightErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInsightError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInsightErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInsightError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInsightErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInsightErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetInsightErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `GetInsightErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, GetInsightErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for GetInsightError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInsightErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetInsightErrorKind::ThrottledException(_inner) => Some(_inner),
            GetInsightErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInsightEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInsightEventsError {
    /// Kind of error that occurred.
    pub kind: GetInsightEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInsightEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInsightEventsErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInsightEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInsightEventsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetInsightEventsErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetInsightEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInsightEventsError {
    fn code(&self) -> Option<&str> {
        GetInsightEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInsightEventsError {
    /// Creates a new `GetInsightEventsError`.
    pub fn new(kind: GetInsightEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInsightEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInsightEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInsightEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInsightEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInsightEventsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightEventsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightEventsErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, GetInsightEventsErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for GetInsightEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInsightEventsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetInsightEventsErrorKind::ThrottledException(_inner) => Some(_inner),
            GetInsightEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInsightImpactGraph` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInsightImpactGraphError {
    /// Kind of error that occurred.
    pub kind: GetInsightImpactGraphErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInsightImpactGraph` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInsightImpactGraphErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInsightImpactGraphError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInsightImpactGraphErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetInsightImpactGraphErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetInsightImpactGraphErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInsightImpactGraphError {
    fn code(&self) -> Option<&str> {
        GetInsightImpactGraphError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInsightImpactGraphError {
    /// Creates a new `GetInsightImpactGraphError`.
    pub fn new(kind: GetInsightImpactGraphErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInsightImpactGraphError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInsightImpactGraphErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInsightImpactGraphError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInsightImpactGraphErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInsightImpactGraphErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightImpactGraphErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightImpactGraphErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightImpactGraphErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for GetInsightImpactGraphError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInsightImpactGraphErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetInsightImpactGraphErrorKind::ThrottledException(_inner) => Some(_inner),
            GetInsightImpactGraphErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInsightSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInsightSummariesError {
    /// Kind of error that occurred.
    pub kind: GetInsightSummariesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInsightSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInsightSummariesErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInsightSummariesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInsightSummariesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetInsightSummariesErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetInsightSummariesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInsightSummariesError {
    fn code(&self) -> Option<&str> {
        GetInsightSummariesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInsightSummariesError {
    /// Creates a new `GetInsightSummariesError`.
    pub fn new(kind: GetInsightSummariesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInsightSummariesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInsightSummariesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInsightSummariesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInsightSummariesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInsightSummariesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightSummariesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightSummariesErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightSummariesErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for GetInsightSummariesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInsightSummariesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetInsightSummariesErrorKind::ThrottledException(_inner) => Some(_inner),
            GetInsightSummariesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSamplingRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSamplingRulesError {
    /// Kind of error that occurred.
    pub kind: GetSamplingRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSamplingRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSamplingRulesErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSamplingRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSamplingRulesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetSamplingRulesErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetSamplingRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSamplingRulesError {
    fn code(&self) -> Option<&str> {
        GetSamplingRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSamplingRulesError {
    /// Creates a new `GetSamplingRulesError`.
    pub fn new(kind: GetSamplingRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSamplingRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSamplingRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSamplingRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSamplingRulesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSamplingRulesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSamplingRulesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSamplingRulesErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, GetSamplingRulesErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for GetSamplingRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSamplingRulesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetSamplingRulesErrorKind::ThrottledException(_inner) => Some(_inner),
            GetSamplingRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSamplingStatisticSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSamplingStatisticSummariesError {
    /// Kind of error that occurred.
    pub kind: GetSamplingStatisticSummariesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSamplingStatisticSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSamplingStatisticSummariesErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSamplingStatisticSummariesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSamplingStatisticSummariesErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetSamplingStatisticSummariesErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetSamplingStatisticSummariesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSamplingStatisticSummariesError {
    fn code(&self) -> Option<&str> {
        GetSamplingStatisticSummariesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSamplingStatisticSummariesError {
    /// Creates a new `GetSamplingStatisticSummariesError`.
    pub fn new(
        kind: GetSamplingStatisticSummariesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSamplingStatisticSummariesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSamplingStatisticSummariesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSamplingStatisticSummariesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSamplingStatisticSummariesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSamplingStatisticSummariesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSamplingStatisticSummariesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSamplingStatisticSummariesErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSamplingStatisticSummariesErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for GetSamplingStatisticSummariesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSamplingStatisticSummariesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetSamplingStatisticSummariesErrorKind::ThrottledException(_inner) => Some(_inner),
            GetSamplingStatisticSummariesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSamplingTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSamplingTargetsError {
    /// Kind of error that occurred.
    pub kind: GetSamplingTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSamplingTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSamplingTargetsErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSamplingTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSamplingTargetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetSamplingTargetsErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetSamplingTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSamplingTargetsError {
    fn code(&self) -> Option<&str> {
        GetSamplingTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSamplingTargetsError {
    /// Creates a new `GetSamplingTargetsError`.
    pub fn new(kind: GetSamplingTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSamplingTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSamplingTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSamplingTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSamplingTargetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSamplingTargetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSamplingTargetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSamplingTargetsErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSamplingTargetsErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for GetSamplingTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSamplingTargetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetSamplingTargetsErrorKind::ThrottledException(_inner) => Some(_inner),
            GetSamplingTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceGraph` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceGraphError {
    /// Kind of error that occurred.
    pub kind: GetServiceGraphErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceGraph` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceGraphErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceGraphError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceGraphErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetServiceGraphErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetServiceGraphErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceGraphError {
    fn code(&self) -> Option<&str> {
        GetServiceGraphError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceGraphError {
    /// Creates a new `GetServiceGraphError`.
    pub fn new(kind: GetServiceGraphErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceGraphError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceGraphErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceGraphError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceGraphErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceGraphErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceGraphErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceGraphErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, GetServiceGraphErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for GetServiceGraphError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceGraphErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetServiceGraphErrorKind::ThrottledException(_inner) => Some(_inner),
            GetServiceGraphErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTimeSeriesServiceStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTimeSeriesServiceStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetTimeSeriesServiceStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTimeSeriesServiceStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTimeSeriesServiceStatisticsErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTimeSeriesServiceStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTimeSeriesServiceStatisticsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetTimeSeriesServiceStatisticsErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetTimeSeriesServiceStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTimeSeriesServiceStatisticsError {
    fn code(&self) -> Option<&str> {
        GetTimeSeriesServiceStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTimeSeriesServiceStatisticsError {
    /// Creates a new `GetTimeSeriesServiceStatisticsError`.
    pub fn new(
        kind: GetTimeSeriesServiceStatisticsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTimeSeriesServiceStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTimeSeriesServiceStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTimeSeriesServiceStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTimeSeriesServiceStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTimeSeriesServiceStatisticsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTimeSeriesServiceStatisticsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTimeSeriesServiceStatisticsErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTimeSeriesServiceStatisticsErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for GetTimeSeriesServiceStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTimeSeriesServiceStatisticsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            GetTimeSeriesServiceStatisticsErrorKind::ThrottledException(_inner) => Some(_inner),
            GetTimeSeriesServiceStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTraceGraph` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTraceGraphError {
    /// Kind of error that occurred.
    pub kind: GetTraceGraphErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTraceGraph` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTraceGraphErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTraceGraphError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTraceGraphErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetTraceGraphErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetTraceGraphErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTraceGraphError {
    fn code(&self) -> Option<&str> {
        GetTraceGraphError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTraceGraphError {
    /// Creates a new `GetTraceGraphError`.
    pub fn new(kind: GetTraceGraphErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTraceGraphError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTraceGraphErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTraceGraphError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTraceGraphErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTraceGraphErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTraceGraphErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTraceGraphErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, GetTraceGraphErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for GetTraceGraphError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTraceGraphErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetTraceGraphErrorKind::ThrottledException(_inner) => Some(_inner),
            GetTraceGraphErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTraceSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTraceSummariesError {
    /// Kind of error that occurred.
    pub kind: GetTraceSummariesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTraceSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTraceSummariesErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTraceSummariesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTraceSummariesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetTraceSummariesErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetTraceSummariesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTraceSummariesError {
    fn code(&self) -> Option<&str> {
        GetTraceSummariesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTraceSummariesError {
    /// Creates a new `GetTraceSummariesError`.
    pub fn new(kind: GetTraceSummariesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTraceSummariesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTraceSummariesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTraceSummariesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTraceSummariesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTraceSummariesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTraceSummariesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTraceSummariesErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTraceSummariesErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for GetTraceSummariesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTraceSummariesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetTraceSummariesErrorKind::ThrottledException(_inner) => Some(_inner),
            GetTraceSummariesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
    /// correct.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottledException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEncryptionConfigError {
    /// Kind of error that occurred.
    pub kind: PutEncryptionConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEncryptionConfigErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEncryptionConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEncryptionConfigErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PutEncryptionConfigErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            PutEncryptionConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEncryptionConfigError {
    fn code(&self) -> Option<&str> {
        PutEncryptionConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEncryptionConfigError {
    /// Creates a new `PutEncryptionConfigError`.
    pub fn new(kind: PutEncryptionConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEncryptionConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEncryptionConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEncryptionConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEncryptionConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutEncryptionConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEncryptionConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEncryptionConfigErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEncryptionConfigErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for PutEncryptionConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEncryptionConfigErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PutEncryptionConfigErrorKind::ThrottledException(_inner) => Some(_inner),
            PutEncryptionConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutTelemetryRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutTelemetryRecordsError {
    /// Kind of error that occurred.
    pub kind: PutTelemetryRecordsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutTelemetryRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutTelemetryRecordsErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutTelemetryRecordsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutTelemetryRecordsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PutTelemetryRecordsErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            PutTelemetryRecordsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutTelemetryRecordsError {
    fn code(&self) -> Option<&str> {
        PutTelemetryRecordsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutTelemetryRecordsError {
    /// Creates a new `PutTelemetryRecordsError`.
    pub fn new(kind: PutTelemetryRecordsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutTelemetryRecordsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutTelemetryRecordsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutTelemetryRecordsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutTelemetryRecordsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutTelemetryRecordsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutTelemetryRecordsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutTelemetryRecordsErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutTelemetryRecordsErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for PutTelemetryRecordsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutTelemetryRecordsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PutTelemetryRecordsErrorKind::ThrottledException(_inner) => Some(_inner),
            PutTelemetryRecordsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutTraceSegments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutTraceSegmentsError {
    /// Kind of error that occurred.
    pub kind: PutTraceSegmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutTraceSegments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutTraceSegmentsErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutTraceSegmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutTraceSegmentsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PutTraceSegmentsErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            PutTraceSegmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutTraceSegmentsError {
    fn code(&self) -> Option<&str> {
        PutTraceSegmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutTraceSegmentsError {
    /// Creates a new `PutTraceSegmentsError`.
    pub fn new(kind: PutTraceSegmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutTraceSegmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutTraceSegmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutTraceSegmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutTraceSegmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutTraceSegmentsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutTraceSegmentsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutTraceSegmentsErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, PutTraceSegmentsErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for PutTraceSegmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutTraceSegmentsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PutTraceSegmentsErrorKind::ThrottledException(_inner) => Some(_inner),
            PutTraceSegmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
    /// correct.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// <p>You have exceeded the maximum number of tags you can apply to this resource.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottledException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottledException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
    /// correct.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottledException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGroupErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGroupError {
    fn code(&self) -> Option<&str> {
        UpdateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGroupError {
    /// Creates a new `UpdateGroupError`.
    pub fn new(kind: UpdateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for UpdateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateGroupErrorKind::ThrottledException(_inner) => Some(_inner),
            UpdateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSamplingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSamplingRuleError {
    /// Kind of error that occurred.
    pub kind: UpdateSamplingRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSamplingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSamplingRuleErrorKind {
    /// <p>The request is missing required parameters or has invalid parameters.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request exceeds the maximum number of requests per second.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSamplingRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSamplingRuleErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateSamplingRuleErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            UpdateSamplingRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSamplingRuleError {
    fn code(&self) -> Option<&str> {
        UpdateSamplingRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSamplingRuleError {
    /// Creates a new `UpdateSamplingRuleError`.
    pub fn new(kind: UpdateSamplingRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSamplingRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSamplingRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSamplingRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSamplingRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSamplingRuleErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSamplingRuleErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSamplingRuleErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSamplingRuleErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for UpdateSamplingRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSamplingRuleErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateSamplingRuleErrorKind::ThrottledException(_inner) => Some(_inner),
            UpdateSamplingRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request exceeds the maximum number of requests per second.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottledException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottledException {}
/// See [`ThrottledException`](crate::error::ThrottledException)
pub mod throttled_exception {
    /// A builder for [`ThrottledException`](crate::error::ThrottledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottledException`](crate::error::ThrottledException)
        pub fn build(self) -> crate::error::ThrottledException {
            crate::error::ThrottledException {
                message: self.message,
            }
        }
    }
}
impl ThrottledException {
    /// Creates a new builder-style object to manufacture [`ThrottledException`](crate::error::ThrottledException)
    pub fn builder() -> crate::error::throttled_exception::Builder {
        crate::error::throttled_exception::Builder::default()
    }
}

/// <p>The request is missing required parameters or has invalid parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
/// correct.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_name: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>You have exceeded the maximum number of tags you can apply to this resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_name: std::option::Option<std::string::String>,
}
impl TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>You have reached the maximum number of sampling rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RuleLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RuleLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RuleLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RuleLimitExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for RuleLimitExceededException {}
/// See [`RuleLimitExceededException`](crate::error::RuleLimitExceededException)
pub mod rule_limit_exceeded_exception {
    /// A builder for [`RuleLimitExceededException`](crate::error::RuleLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleLimitExceededException`](crate::error::RuleLimitExceededException)
        pub fn build(self) -> crate::error::RuleLimitExceededException {
            crate::error::RuleLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl RuleLimitExceededException {
    /// Creates a new builder-style object to manufacture [`RuleLimitExceededException`](crate::error::RuleLimitExceededException)
    pub fn builder() -> crate::error::rule_limit_exceeded_exception::Builder {
        crate::error::rule_limit_exceeded_exception::Builder::default()
    }
}
