// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSXRay`.
///
/// This client allows ergonomic access to a `AWSXRay`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchGetTraces` operation.
    ///
    /// See [`BatchGetTraces`](crate::client::fluent_builders::BatchGetTraces) for more information about the
    /// operation and its arguments.
    pub fn batch_get_traces(&self) -> fluent_builders::BatchGetTraces<C, M, R> {
        fluent_builders::BatchGetTraces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGroup` operation.
    ///
    /// See [`CreateGroup`](crate::client::fluent_builders::CreateGroup) for more information about the
    /// operation and its arguments.
    pub fn create_group(&self) -> fluent_builders::CreateGroup<C, M, R> {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSamplingRule` operation.
    ///
    /// See [`CreateSamplingRule`](crate::client::fluent_builders::CreateSamplingRule) for more information about the
    /// operation and its arguments.
    pub fn create_sampling_rule(&self) -> fluent_builders::CreateSamplingRule<C, M, R> {
        fluent_builders::CreateSamplingRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGroup` operation.
    ///
    /// See [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup<C, M, R> {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSamplingRule` operation.
    ///
    /// See [`DeleteSamplingRule`](crate::client::fluent_builders::DeleteSamplingRule) for more information about the
    /// operation and its arguments.
    pub fn delete_sampling_rule(&self) -> fluent_builders::DeleteSamplingRule<C, M, R> {
        fluent_builders::DeleteSamplingRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEncryptionConfig` operation.
    ///
    /// See [`GetEncryptionConfig`](crate::client::fluent_builders::GetEncryptionConfig) for more information about the
    /// operation and its arguments.
    pub fn get_encryption_config(&self) -> fluent_builders::GetEncryptionConfig<C, M, R> {
        fluent_builders::GetEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroup` operation.
    ///
    /// See [`GetGroup`](crate::client::fluent_builders::GetGroup) for more information about the
    /// operation and its arguments.
    pub fn get_group(&self) -> fluent_builders::GetGroup<C, M, R> {
        fluent_builders::GetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroups` operation.
    ///
    /// See [`GetGroups`](crate::client::fluent_builders::GetGroups) for more information about the
    /// operation and its arguments.
    pub fn get_groups(&self) -> fluent_builders::GetGroups<C, M, R> {
        fluent_builders::GetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInsight` operation.
    ///
    /// See [`GetInsight`](crate::client::fluent_builders::GetInsight) for more information about the
    /// operation and its arguments.
    pub fn get_insight(&self) -> fluent_builders::GetInsight<C, M, R> {
        fluent_builders::GetInsight::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInsightEvents` operation.
    ///
    /// See [`GetInsightEvents`](crate::client::fluent_builders::GetInsightEvents) for more information about the
    /// operation and its arguments.
    pub fn get_insight_events(&self) -> fluent_builders::GetInsightEvents<C, M, R> {
        fluent_builders::GetInsightEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInsightImpactGraph` operation.
    ///
    /// See [`GetInsightImpactGraph`](crate::client::fluent_builders::GetInsightImpactGraph) for more information about the
    /// operation and its arguments.
    pub fn get_insight_impact_graph(&self) -> fluent_builders::GetInsightImpactGraph<C, M, R> {
        fluent_builders::GetInsightImpactGraph::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInsightSummaries` operation.
    ///
    /// See [`GetInsightSummaries`](crate::client::fluent_builders::GetInsightSummaries) for more information about the
    /// operation and its arguments.
    pub fn get_insight_summaries(&self) -> fluent_builders::GetInsightSummaries<C, M, R> {
        fluent_builders::GetInsightSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSamplingRules` operation.
    ///
    /// See [`GetSamplingRules`](crate::client::fluent_builders::GetSamplingRules) for more information about the
    /// operation and its arguments.
    pub fn get_sampling_rules(&self) -> fluent_builders::GetSamplingRules<C, M, R> {
        fluent_builders::GetSamplingRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSamplingStatisticSummaries` operation.
    ///
    /// See [`GetSamplingStatisticSummaries`](crate::client::fluent_builders::GetSamplingStatisticSummaries) for more information about the
    /// operation and its arguments.
    pub fn get_sampling_statistic_summaries(
        &self,
    ) -> fluent_builders::GetSamplingStatisticSummaries<C, M, R> {
        fluent_builders::GetSamplingStatisticSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSamplingTargets` operation.
    ///
    /// See [`GetSamplingTargets`](crate::client::fluent_builders::GetSamplingTargets) for more information about the
    /// operation and its arguments.
    pub fn get_sampling_targets(&self) -> fluent_builders::GetSamplingTargets<C, M, R> {
        fluent_builders::GetSamplingTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceGraph` operation.
    ///
    /// See [`GetServiceGraph`](crate::client::fluent_builders::GetServiceGraph) for more information about the
    /// operation and its arguments.
    pub fn get_service_graph(&self) -> fluent_builders::GetServiceGraph<C, M, R> {
        fluent_builders::GetServiceGraph::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTimeSeriesServiceStatistics` operation.
    ///
    /// See [`GetTimeSeriesServiceStatistics`](crate::client::fluent_builders::GetTimeSeriesServiceStatistics) for more information about the
    /// operation and its arguments.
    pub fn get_time_series_service_statistics(
        &self,
    ) -> fluent_builders::GetTimeSeriesServiceStatistics<C, M, R> {
        fluent_builders::GetTimeSeriesServiceStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTraceGraph` operation.
    ///
    /// See [`GetTraceGraph`](crate::client::fluent_builders::GetTraceGraph) for more information about the
    /// operation and its arguments.
    pub fn get_trace_graph(&self) -> fluent_builders::GetTraceGraph<C, M, R> {
        fluent_builders::GetTraceGraph::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTraceSummaries` operation.
    ///
    /// See [`GetTraceSummaries`](crate::client::fluent_builders::GetTraceSummaries) for more information about the
    /// operation and its arguments.
    pub fn get_trace_summaries(&self) -> fluent_builders::GetTraceSummaries<C, M, R> {
        fluent_builders::GetTraceSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEncryptionConfig` operation.
    ///
    /// See [`PutEncryptionConfig`](crate::client::fluent_builders::PutEncryptionConfig) for more information about the
    /// operation and its arguments.
    pub fn put_encryption_config(&self) -> fluent_builders::PutEncryptionConfig<C, M, R> {
        fluent_builders::PutEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutTelemetryRecords` operation.
    ///
    /// See [`PutTelemetryRecords`](crate::client::fluent_builders::PutTelemetryRecords) for more information about the
    /// operation and its arguments.
    pub fn put_telemetry_records(&self) -> fluent_builders::PutTelemetryRecords<C, M, R> {
        fluent_builders::PutTelemetryRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutTraceSegments` operation.
    ///
    /// See [`PutTraceSegments`](crate::client::fluent_builders::PutTraceSegments) for more information about the
    /// operation and its arguments.
    pub fn put_trace_segments(&self) -> fluent_builders::PutTraceSegments<C, M, R> {
        fluent_builders::PutTraceSegments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGroup` operation.
    ///
    /// See [`UpdateGroup`](crate::client::fluent_builders::UpdateGroup) for more information about the
    /// operation and its arguments.
    pub fn update_group(&self) -> fluent_builders::UpdateGroup<C, M, R> {
        fluent_builders::UpdateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSamplingRule` operation.
    ///
    /// See [`UpdateSamplingRule`](crate::client::fluent_builders::UpdateSamplingRule) for more information about the
    /// operation and its arguments.
    pub fn update_sampling_rule(&self) -> fluent_builders::UpdateSamplingRule<C, M, R> {
        fluent_builders::UpdateSamplingRule::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchGetTraces`.
    ///
    /// <p>Retrieves a list of traces specified by ID. Each trace is a collection of segment
    /// documents that originates from a single request. Use <code>GetTraceSummaries</code> to get a
    /// list of trace IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetTraces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_traces_input::Builder,
    }
    impl<C, M, R> BatchGetTraces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetTraces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetTracesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetTracesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetTracesInputOperationOutputAlias,
                crate::output::BatchGetTracesOutput,
                crate::error::BatchGetTracesError,
                crate::input::BatchGetTracesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TraceIds`.
        ///
        /// To override the contents of this collection use [`set_trace_ids`](Self::set_trace_ids).
        ///
        /// <p>Specify the trace IDs of requests for which to retrieve segments.</p>
        pub fn trace_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trace_ids(inp);
            self
        }
        /// <p>Specify the trace IDs of requests for which to retrieve segments.</p>
        pub fn set_trace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trace_ids(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// <p>Creates a group resource with a name and a filter expression. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_input::Builder,
    }
    impl<C, M, R> CreateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupInputOperationOutputAlias,
                crate::output::CreateGroupOutput,
                crate::error::CreateGroupError,
                crate::input::CreateGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The case-sensitive name of the new group. Default is a reserved name and names must
        /// be unique.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The case-sensitive name of the new group. Default is a reserved name and names must
        /// be unique.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The filter expression defining criteria by which to group traces.</p>
        pub fn filter_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(inp);
            self
        }
        /// <p>The filter expression defining criteria by which to group traces.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// new group or false to disable insights for the new group.</p>
        /// </li>
        /// <li>
        /// <p>The NotifcationsEnabled boolean can be set to true to enable insights
        /// notifications for the new group. Notifications may only be enabled on a group
        /// with InsightsEnabled set to true.</p>
        /// </li>
        /// </ul>
        pub fn insights_configuration(mut self, inp: crate::model::InsightsConfiguration) -> Self {
            self.inner = self.inner.insights_configuration(inp);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// new group or false to disable insights for the new group.</p>
        /// </li>
        /// <li>
        /// <p>The NotifcationsEnabled boolean can be set to true to enable insights
        /// notifications for the new group. Notifications may only be enabled on a group
        /// with InsightsEnabled set to true.</p>
        /// </li>
        /// </ul>
        pub fn set_insights_configuration(
            mut self,
            input: std::option::Option<crate::model::InsightsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_insights_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group.
        /// For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group.
        /// For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSamplingRule`.
    ///
    /// <p>Creates a rule to control sampling behavior for instrumented applications. Services
    /// retrieve rules with <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html">GetSamplingRules</a>, and evaluate each rule in ascending
    /// order of <i>priority</i> for each request. If a rule matches, the service
    /// records a trace, borrowing it from the reservoir size. After 10 seconds, the service
    /// reports back to X-Ray with <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a> to get updated versions of
    /// each in-use rule. The updated rule contains a trace quota that the service can use instead
    /// of borrowing from the reservoir.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSamplingRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sampling_rule_input::Builder,
    }
    impl<C, M, R> CreateSamplingRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSamplingRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSamplingRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSamplingRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSamplingRuleInputOperationOutputAlias,
                crate::output::CreateSamplingRuleOutput,
                crate::error::CreateSamplingRuleError,
                crate::input::CreateSamplingRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule definition.</p>
        pub fn sampling_rule(mut self, inp: crate::model::SamplingRule) -> Self {
            self.inner = self.inner.sampling_rule(inp);
            self
        }
        /// <p>The rule definition.</p>
        pub fn set_sampling_rule(
            mut self,
            input: std::option::Option<crate::model::SamplingRule>,
        ) -> Self {
            self.inner = self.inner.set_sampling_rule(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray sampling
        /// rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray sampling
        /// rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// <p>Deletes a group resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl<C, M, R> DeleteGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupInputOperationOutputAlias,
                crate::output::DeleteGroupOutput,
                crate::error::DeleteGroupError,
                crate::input::DeleteGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(inp);
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSamplingRule`.
    ///
    /// <p>Deletes a sampling rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSamplingRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_sampling_rule_input::Builder,
    }
    impl<C, M, R> DeleteSamplingRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSamplingRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSamplingRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSamplingRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSamplingRuleInputOperationOutputAlias,
                crate::output::DeleteSamplingRuleOutput,
                crate::error::DeleteSamplingRuleError,
                crate::input::DeleteSamplingRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(inp);
            self
        }
        /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn rule_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_arn(inp);
            self
        }
        /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEncryptionConfig`.
    ///
    /// <p>Retrieves the current encryption configuration for X-Ray data.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEncryptionConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_encryption_config_input::Builder,
    }
    impl<C, M, R> GetEncryptionConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEncryptionConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEncryptionConfigInputOperationOutputAlias,
                crate::output::GetEncryptionConfigOutput,
                crate::error::GetEncryptionConfigError,
                crate::input::GetEncryptionConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetGroup`.
    ///
    /// <p>Retrieves group resource details.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_input::Builder,
    }
    impl<C, M, R> GetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupInputOperationOutputAlias,
                crate::output::GetGroupOutput,
                crate::error::GetGroupError,
                crate::input::GetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(inp);
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroups`.
    ///
    /// <p>Retrieves all active group details.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_groups_input::Builder,
    }
    impl<C, M, R> GetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupsInputOperationOutputAlias,
                crate::output::GetGroupsOutput,
                crate::error::GetGroupsError,
                crate::input::GetGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsight`.
    ///
    /// <p>Retrieves the summary information of an insight. This includes impact to clients and
    /// root cause services, the top anomalous services, the category, the state of the insight,
    /// and the start and end time of the insight.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInsight<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_insight_input::Builder,
    }
    impl<C, M, R> GetInsight<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInsight`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInsightInputOperationOutputAlias,
                crate::output::GetInsightOutput,
                crate::error::GetInsightError,
                crate::input::GetInsightInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn insight_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(inp);
            self
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsightEvents`.
    ///
    /// <p>X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an
    /// event. You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray
    /// console.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInsightEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_insight_events_input::Builder,
    }
    impl<C, M, R> GetInsightEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInsightEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInsightEventsInputOperationOutputAlias,
                crate::output::GetInsightEventsOutput,
                crate::error::GetInsightEventsError,
                crate::input::GetInsightEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn insight_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(inp);
            self
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
        /// <p>Used to retrieve at most the specified value of events.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Used to retrieve at most the specified value of events.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of events. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of events. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsightImpactGraph`.
    ///
    /// <p>Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only
    /// structural information. For a complete service graph, use this API with the GetServiceGraph API.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInsightImpactGraph<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_insight_impact_graph_input::Builder,
    }
    impl<C, M, R> GetInsightImpactGraph<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInsightImpactGraph`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightImpactGraphOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightImpactGraphError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInsightImpactGraphInputOperationOutputAlias,
                crate::output::GetInsightImpactGraphOutput,
                crate::error::GetInsightImpactGraphError,
                crate::input::GetInsightImpactGraphInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn insight_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(inp);
            self
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
        /// <p>The estimated start time of the insight, in Unix time seconds. The StartTime is inclusive of the value
        /// provided and can't be more than 30 days old.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The estimated start time of the insight, in Unix time seconds. The StartTime is inclusive of the value
        /// provided and can't be more than 30 days old.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The estimated end time of the insight, in Unix time seconds. The EndTime is exclusive of the value provided.
        /// The time range between the start time and end time can't be more than six hours. </p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The estimated end time of the insight, in Unix time seconds. The EndTime is exclusive of the value provided.
        /// The time range between the start time and end time can't be more than six hours. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsightSummaries`.
    ///
    /// <p>Retrieves the summaries of all insights in the specified group matching the provided filter values.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInsightSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_insight_summaries_input::Builder,
    }
    impl<C, M, R> GetInsightSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInsightSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightSummariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInsightSummariesInputOperationOutputAlias,
                crate::output::GetInsightSummariesOutput,
                crate::error::GetInsightSummariesError,
                crate::input::GetInsightSummariesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `States`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The list of insight states. </p>
        pub fn states(mut self, inp: impl Into<crate::model::InsightState>) -> Self {
            self.inner = self.inner.states(inp);
            self
        }
        /// <p>The list of insight states. </p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group. Required if the GroupName isn't provided.</p>
        pub fn group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group. Required if the GroupName isn't provided.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
        /// <p>The name of the group. Required if the GroupARN isn't provided.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group. Required if the GroupARN isn't provided.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The beginning of the time frame in which the insights started. The start time can't be more than 30 days
        /// old.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The beginning of the time frame in which the insights started. The start time can't be more than 30 days
        /// old.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time frame in which the insights ended. The end time can't be more than 30 days old.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time frame in which the insights ended. The end time can't be more than 30 days old.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSamplingRules`.
    ///
    /// <p>Retrieves all sampling rules.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSamplingRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sampling_rules_input::Builder,
    }
    impl<C, M, R> GetSamplingRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSamplingRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSamplingRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSamplingRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSamplingRulesInputOperationOutputAlias,
                crate::output::GetSamplingRulesOutput,
                crate::error::GetSamplingRulesError,
                crate::input::GetSamplingRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSamplingStatisticSummaries`.
    ///
    /// <p>Retrieves information about recent sampling results for all sampling rules.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSamplingStatisticSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sampling_statistic_summaries_input::Builder,
    }
    impl<C, M, R> GetSamplingStatisticSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSamplingStatisticSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSamplingStatisticSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSamplingStatisticSummariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSamplingStatisticSummariesInputOperationOutputAlias,
                crate::output::GetSamplingStatisticSummariesOutput,
                crate::error::GetSamplingStatisticSummariesError,
                crate::input::GetSamplingStatisticSummariesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSamplingTargets`.
    ///
    /// <p>Requests a sampling quota for rules that the service is using to sample requests.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetSamplingTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sampling_targets_input::Builder,
    }
    impl<C, M, R> GetSamplingTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSamplingTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSamplingTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSamplingTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSamplingTargetsInputOperationOutputAlias,
                crate::output::GetSamplingTargetsOutput,
                crate::error::GetSamplingTargetsError,
                crate::input::GetSamplingTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `SamplingStatisticsDocuments`.
        ///
        /// To override the contents of this collection use [`set_sampling_statistics_documents`](Self::set_sampling_statistics_documents).
        ///
        /// <p>Information about rules that the service is using to sample requests.</p>
        pub fn sampling_statistics_documents(
            mut self,
            inp: impl Into<crate::model::SamplingStatisticsDocument>,
        ) -> Self {
            self.inner = self.inner.sampling_statistics_documents(inp);
            self
        }
        /// <p>Information about rules that the service is using to sample requests.</p>
        pub fn set_sampling_statistics_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SamplingStatisticsDocument>>,
        ) -> Self {
            self.inner = self.inner.set_sampling_statistics_documents(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceGraph`.
    ///
    /// <p>Retrieves a document that describes services that process incoming requests, and
    /// downstream services that they call as a result. Root services process incoming requests and
    /// make calls to downstream services. Root services are applications that use the <a href="https://docs.aws.amazon.com/xray/index.html">Amazon Web Services X-Ray SDK</a>.
    /// Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL
    /// databases.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceGraph<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_graph_input::Builder,
    }
    impl<C, M, R> GetServiceGraph<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceGraph`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceGraphOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceGraphError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceGraphInputOperationOutputAlias,
                crate::output::GetServiceGraphOutput,
                crate::error::GetServiceGraphError,
                crate::input::GetServiceGraphInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The start of the time frame for which to generate a graph.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start of the time frame for which to generate a graph.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the timeframe for which to generate a graph.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the timeframe for which to generate a graph.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The name of a group based on which you want to generate a graph.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of a group based on which you want to generate a graph.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a group based on which you want to generate a graph.</p>
        pub fn group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a group based on which you want to generate a graph.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTimeSeriesServiceStatistics`.
    ///
    /// <p>Get an aggregation of service statistics defined by a specific time
    /// range.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTimeSeriesServiceStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_time_series_service_statistics_input::Builder,
    }
    impl<C, M, R> GetTimeSeriesServiceStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTimeSeriesServiceStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTimeSeriesServiceStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTimeSeriesServiceStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTimeSeriesServiceStatisticsInputOperationOutputAlias,
                crate::output::GetTimeSeriesServiceStatisticsOutput,
                crate::error::GetTimeSeriesServiceStatisticsError,
                crate::input::GetTimeSeriesServiceStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The start of the time frame for which to aggregate statistics.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start of the time frame for which to aggregate statistics.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time frame for which to aggregate statistics.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time frame for which to aggregate statistics.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The case-sensitive name of the group for which to pull statistics from.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The case-sensitive name of the group for which to pull statistics from.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group for which to pull statistics from.</p>
        pub fn group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group for which to pull statistics from.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
        /// <p>A filter expression defining entities that will be aggregated for statistics.
        /// Supports ID, service, and edge functions. If no selector expression is specified, edge
        /// statistics are returned. </p>
        pub fn entity_selector_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_selector_expression(inp);
            self
        }
        /// <p>A filter expression defining entities that will be aggregated for statistics.
        /// Supports ID, service, and edge functions. If no selector expression is specified, edge
        /// statistics are returned. </p>
        pub fn set_entity_selector_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entity_selector_expression(input);
            self
        }
        /// <p>Aggregation period in seconds.</p>
        pub fn period(mut self, inp: i32) -> Self {
            self.inner = self.inner.period(inp);
            self
        }
        /// <p>Aggregation period in seconds.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The forecasted high and low fault count values. Forecast enabled requests require the
        /// EntitySelectorExpression ID be provided.</p>
        pub fn forecast_statistics(mut self, inp: bool) -> Self {
            self.inner = self.inner.forecast_statistics(inp);
            self
        }
        /// <p>The forecasted high and low fault count values. Forecast enabled requests require the
        /// EntitySelectorExpression ID be provided.</p>
        pub fn set_forecast_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_forecast_statistics(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTraceGraph`.
    ///
    /// <p>Retrieves a service graph for one or more specific trace IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTraceGraph<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_trace_graph_input::Builder,
    }
    impl<C, M, R> GetTraceGraph<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTraceGraph`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTraceGraphOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTraceGraphError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTraceGraphInputOperationOutputAlias,
                crate::output::GetTraceGraphOutput,
                crate::error::GetTraceGraphError,
                crate::input::GetTraceGraphInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TraceIds`.
        ///
        /// To override the contents of this collection use [`set_trace_ids`](Self::set_trace_ids).
        ///
        /// <p>Trace IDs of requests for which to generate a service graph.</p>
        pub fn trace_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trace_ids(inp);
            self
        }
        /// <p>Trace IDs of requests for which to generate a service graph.</p>
        pub fn set_trace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trace_ids(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTraceSummaries`.
    ///
    /// <p>Retrieves IDs and annotations for traces available for a specified time frame using an
    /// optional filter. To get the full traces, pass the trace IDs to
    /// <code>BatchGetTraces</code>.</p>
    /// <p>A filter expression can target traced requests that hit specific service nodes or
    /// edges, have errors, or come from a known user. For example, the following filter expression
    /// targets traces that pass through <code>api.example.com</code>:</p>
    /// <p>
    /// <code>service("api.example.com")</code>
    /// </p>
    /// <p>This filter expression finds traces that have an annotation named <code>account</code>
    /// with the value <code>12345</code>:</p>
    /// <p>
    /// <code>annotation.account = "12345"</code>
    /// </p>
    /// <p>For a full list of indexed fields and keywords that you can use in filter expressions,
    /// see <a href="https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html">Using Filter
    /// Expressions</a> in the <i>Amazon Web Services X-Ray Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTraceSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_trace_summaries_input::Builder,
    }
    impl<C, M, R> GetTraceSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTraceSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTraceSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTraceSummariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTraceSummariesInputOperationOutputAlias,
                crate::output::GetTraceSummariesOutput,
                crate::error::GetTraceSummariesError,
                crate::input::GetTraceSummariesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The start of the time frame for which to retrieve traces.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start of the time frame for which to retrieve traces.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time frame for which to retrieve traces.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time frame for which to retrieve traces.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>A parameter to indicate whether to query trace summaries by TraceId or Event time.</p>
        pub fn time_range_type(mut self, inp: crate::model::TimeRangeType) -> Self {
            self.inner = self.inner.time_range_type(inp);
            self
        }
        /// <p>A parameter to indicate whether to query trace summaries by TraceId or Event time.</p>
        pub fn set_time_range_type(
            mut self,
            input: std::option::Option<crate::model::TimeRangeType>,
        ) -> Self {
            self.inner = self.inner.set_time_range_type(input);
            self
        }
        /// <p>Set to <code>true</code> to get summaries for only a subset of available
        /// traces.</p>
        pub fn sampling(mut self, inp: bool) -> Self {
            self.inner = self.inner.sampling(inp);
            self
        }
        /// <p>Set to <code>true</code> to get summaries for only a subset of available
        /// traces.</p>
        pub fn set_sampling(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sampling(input);
            self
        }
        /// <p>A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and
        /// Value.</p>
        pub fn sampling_strategy(mut self, inp: crate::model::SamplingStrategy) -> Self {
            self.inner = self.inner.sampling_strategy(inp);
            self
        }
        /// <p>A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and
        /// Value.</p>
        pub fn set_sampling_strategy(
            mut self,
            input: std::option::Option<crate::model::SamplingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_sampling_strategy(input);
            self
        }
        /// <p>Specify a filter expression to retrieve trace summaries for services or requests that
        /// meet certain requirements.</p>
        pub fn filter_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(inp);
            self
        }
        /// <p>Specify a filter expression to retrieve trace summaries for services or requests that
        /// meet certain requirements.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page
        /// of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page
        /// of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with
        /// the current page of results as the value of this parameter to get the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with
        /// the current page of results as the value of this parameter to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEncryptionConfig`.
    ///
    /// <p>Updates the encryption configuration for X-Ray data.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEncryptionConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_encryption_config_input::Builder,
    }
    impl<C, M, R> PutEncryptionConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEncryptionConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEncryptionConfigInputOperationOutputAlias,
                crate::output::PutEncryptionConfigOutput,
                crate::error::PutEncryptionConfigError,
                crate::input::PutEncryptionConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Web Services KMS key in one of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Alias</b> - The name of the key. For example,
        /// <code>alias/MyKey</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Key ID</b> - The KMS key ID of the key. For example,
        /// <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Amazon Web Services X-Ray does not support asymmetric KMS keys.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ARN</b> - The full Amazon Resource Name of the key ID or alias.
        /// For example,
        /// <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>.
        /// Use this format to specify a key in a different account.</p>
        /// </li>
        /// </ul>
        /// <p>Omit this key if you set <code>Type</code> to <code>NONE</code>.</p>
        pub fn key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(inp);
            self
        }
        /// <p>An Amazon Web Services KMS key in one of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Alias</b> - The name of the key. For example,
        /// <code>alias/MyKey</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Key ID</b> - The KMS key ID of the key. For example,
        /// <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Amazon Web Services X-Ray does not support asymmetric KMS keys.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ARN</b> - The full Amazon Resource Name of the key ID or alias.
        /// For example,
        /// <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>.
        /// Use this format to specify a key in a different account.</p>
        /// </li>
        /// </ul>
        /// <p>Omit this key if you set <code>Type</code> to <code>NONE</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set
        /// to <code>NONE</code> for default encryption.</p>
        pub fn r#type(mut self, inp: crate::model::EncryptionType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set
        /// to <code>NONE</code> for default encryption.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutTelemetryRecords`.
    ///
    /// <p>Used by the Amazon Web Services X-Ray daemon to upload telemetry.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutTelemetryRecords<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_telemetry_records_input::Builder,
    }
    impl<C, M, R> PutTelemetryRecords<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutTelemetryRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutTelemetryRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutTelemetryRecordsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutTelemetryRecordsInputOperationOutputAlias,
                crate::output::PutTelemetryRecordsOutput,
                crate::error::PutTelemetryRecordsError,
                crate::input::PutTelemetryRecordsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TelemetryRecords`.
        ///
        /// To override the contents of this collection use [`set_telemetry_records`](Self::set_telemetry_records).
        ///
        /// <p></p>
        pub fn telemetry_records(mut self, inp: impl Into<crate::model::TelemetryRecord>) -> Self {
            self.inner = self.inner.telemetry_records(inp);
            self
        }
        /// <p></p>
        pub fn set_telemetry_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TelemetryRecord>>,
        ) -> Self {
            self.inner = self.inner.set_telemetry_records(input);
            self
        }
        /// <p></p>
        pub fn ec2_instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_instance_id(inp);
            self
        }
        /// <p></p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_instance_id(input);
            self
        }
        /// <p></p>
        pub fn hostname(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hostname(inp);
            self
        }
        /// <p></p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hostname(input);
            self
        }
        /// <p></p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutTraceSegments`.
    ///
    /// <p>Uploads segment documents to Amazon Web Services X-Ray. The <a href="https://docs.aws.amazon.com/xray/index.html">X-Ray SDK</a> generates segment documents and sends them to the X-Ray daemon, which uploads them in
    /// batches. A segment document can be a completed segment, an in-progress segment, or an array of
    /// subsegments.</p>
    /// <p>Segments must include the following fields. For the full segment document schema, see
    /// <a href="https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html">Amazon Web Services X-Ray
    /// Segment Documents</a> in the <i>Amazon Web Services X-Ray Developer Guide</i>.</p>
    /// <p class="title">
    /// <b>Required segment document fields</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>name</code> - The name of the service that handled the request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>id</code> - A 64-bit identifier for the segment, unique among segments in the same trace, in 16
    /// hexadecimal digits.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>trace_id</code> - A unique identifier that connects all segments and subsegments originating from
    /// a single client request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>start_time</code> - Time the segment or subsegment was created, in floating point seconds in
    /// epoch time, accurate to milliseconds. For example, <code>1480615200.010</code> or
    /// <code>1.480615200010E9</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>end_time</code> - Time the segment or subsegment was closed. For example,
    /// <code>1480615200.090</code> or <code>1.480615200090E9</code>. Specify either an <code>end_time</code> or
    /// <code>in_progress</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>in_progress</code> - Set to <code>true</code> instead of specifying an <code>end_time</code> to
    /// record that a segment has been started, but is not complete. Send an in-progress segment when your application
    /// receives a request that will take a long time to serve, to trace that the request was received. When the
    /// response is sent, send the complete segment to overwrite the in-progress segment.</p>
    /// </li>
    /// </ul>
    /// <p>A <code>trace_id</code> consists of three numbers separated by hyphens. For example,
    /// 1-58406520-a006649127e371903a2de979. This includes:</p>
    /// <p class="title">
    /// <b>Trace ID Format</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The version number, for instance, <code>1</code>.</p>
    /// </li>
    /// <li>
    /// <p>The time of the original request, in Unix epoch time, in 8 hexadecimal digits. For
    /// example, 10:00AM December 2nd, 2016 PST in epoch time is <code>1480615200</code> seconds,
    /// or <code>58406520</code> in hexadecimal.</p>
    /// </li>
    /// <li>
    /// <p>A 96-bit identifier for the trace, globally unique, in 24 hexadecimal
    /// digits.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutTraceSegments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_trace_segments_input::Builder,
    }
    impl<C, M, R> PutTraceSegments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutTraceSegments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutTraceSegmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutTraceSegmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutTraceSegmentsInputOperationOutputAlias,
                crate::output::PutTraceSegmentsOutput,
                crate::error::PutTraceSegmentsError,
                crate::input::PutTraceSegmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TraceSegmentDocuments`.
        ///
        /// To override the contents of this collection use [`set_trace_segment_documents`](Self::set_trace_segment_documents).
        ///
        /// <p>A string containing a JSON document defining one or more segments or
        /// subsegments.</p>
        pub fn trace_segment_documents(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trace_segment_documents(inp);
            self
        }
        /// <p>A string containing a JSON document defining one or more segments or
        /// subsegments.</p>
        pub fn set_trace_segment_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trace_segment_documents(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group or
        /// sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You
        /// cannot edit or delete system tags.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group or
        /// sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You
        /// cannot edit or delete system tags.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from an Amazon Web Services X-Ray group or sampling rule. You cannot edit or delete system
    /// tags (those with an <code>aws:</code> prefix).</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys for one or more tags that you want to remove from an X-Ray group or sampling rule.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>Keys for one or more tags that you want to remove from an X-Ray group or sampling rule.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroup`.
    ///
    /// <p>Updates a group resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_group_input::Builder,
    }
    impl<C, M, R> UpdateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGroupInputOperationOutputAlias,
                crate::output::UpdateGroupOutput,
                crate::error::UpdateGroupError,
                crate::input::UpdateGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ARN that was generated upon creation.</p>
        pub fn group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_arn(inp);
            self
        }
        /// <p>The ARN that was generated upon creation.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_arn(input);
            self
        }
        /// <p>The updated filter expression defining criteria by which to group traces.</p>
        pub fn filter_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(inp);
            self
        }
        /// <p>The updated filter expression defining criteria by which to group traces.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// group or false to disable insights for the group.</p>
        /// </li>
        /// <li>
        /// <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group.
        /// Notifications can only be enabled on a group with InsightsEnabled set to true.</p>
        /// </li>
        /// </ul>
        pub fn insights_configuration(mut self, inp: crate::model::InsightsConfiguration) -> Self {
            self.inner = self.inner.insights_configuration(inp);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// group or false to disable insights for the group.</p>
        /// </li>
        /// <li>
        /// <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group.
        /// Notifications can only be enabled on a group with InsightsEnabled set to true.</p>
        /// </li>
        /// </ul>
        pub fn set_insights_configuration(
            mut self,
            input: std::option::Option<crate::model::InsightsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_insights_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSamplingRule`.
    ///
    /// <p>Modifies a sampling rule's configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSamplingRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_sampling_rule_input::Builder,
    }
    impl<C, M, R> UpdateSamplingRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSamplingRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSamplingRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSamplingRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSamplingRuleInputOperationOutputAlias,
                crate::output::UpdateSamplingRuleOutput,
                crate::error::UpdateSamplingRuleError,
                crate::input::UpdateSamplingRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule and fields to change.</p>
        pub fn sampling_rule_update(mut self, inp: crate::model::SamplingRuleUpdate) -> Self {
            self.inner = self.inner.sampling_rule_update(inp);
            self
        }
        /// <p>The rule and fields to change.</p>
        pub fn set_sampling_rule_update(
            mut self,
            input: std::option::Option<crate::model::SamplingRuleUpdate>,
        ) -> Self {
            self.inner = self.inner.set_sampling_rule_update(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
