// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A <a href="https://docs.aws.amazon.com/xray/latest/api/API_SamplingRule.html">SamplingRule</a> and its metadata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamplingRuleRecord {
    /// <p>The sampling rule.</p>
    pub sampling_rule: std::option::Option<crate::model::SamplingRule>,
    /// <p>When the rule was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>When the rule was last modified.</p>
    pub modified_at: std::option::Option<aws_smithy_types::Instant>,
}
impl SamplingRuleRecord {
    /// <p>The sampling rule.</p>
    pub fn sampling_rule(&self) -> std::option::Option<&crate::model::SamplingRule> {
        self.sampling_rule.as_ref()
    }
    /// <p>When the rule was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>When the rule was last modified.</p>
    pub fn modified_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.modified_at.as_ref()
    }
}
impl std::fmt::Debug for SamplingRuleRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamplingRuleRecord");
        formatter.field("sampling_rule", &self.sampling_rule);
        formatter.field("created_at", &self.created_at);
        formatter.field("modified_at", &self.modified_at);
        formatter.finish()
    }
}
/// See [`SamplingRuleRecord`](crate::model::SamplingRuleRecord)
pub mod sampling_rule_record {
    /// A builder for [`SamplingRuleRecord`](crate::model::SamplingRuleRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampling_rule: std::option::Option<crate::model::SamplingRule>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) modified_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The sampling rule.</p>
        pub fn sampling_rule(mut self, input: crate::model::SamplingRule) -> Self {
            self.sampling_rule = Some(input);
            self
        }
        /// <p>The sampling rule.</p>
        pub fn set_sampling_rule(
            mut self,
            input: std::option::Option<crate::model::SamplingRule>,
        ) -> Self {
            self.sampling_rule = input;
            self
        }
        /// <p>When the rule was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>When the rule was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>When the rule was last modified.</p>
        pub fn modified_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.modified_at = Some(input);
            self
        }
        /// <p>When the rule was last modified.</p>
        pub fn set_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.modified_at = input;
            self
        }
        /// Consumes the builder and constructs a [`SamplingRuleRecord`](crate::model::SamplingRuleRecord)
        pub fn build(self) -> crate::model::SamplingRuleRecord {
            crate::model::SamplingRuleRecord {
                sampling_rule: self.sampling_rule,
                created_at: self.created_at,
                modified_at: self.modified_at,
            }
        }
    }
}
impl SamplingRuleRecord {
    /// Creates a new builder-style object to manufacture [`SamplingRuleRecord`](crate::model::SamplingRuleRecord)
    pub fn builder() -> crate::model::sampling_rule_record::Builder {
        crate::model::sampling_rule_record::Builder::default()
    }
}

/// <p>A sampling rule that services use to decide whether to instrument a request. Rule
/// fields can match properties of the service, or properties of a request. The service can ignore
/// rules that don't match its properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamplingRule {
    /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub rule_arn: std::option::Option<std::string::String>,
    /// <p>Matches the ARN of the Amazon Web Services resource on which the service runs.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The priority of the sampling rule.</p>
    pub priority: i32,
    /// <p>The percentage of matching requests to instrument, after the reservoir is
    /// exhausted.</p>
    pub fixed_rate: f64,
    /// <p>A fixed number of matching requests to instrument per second, prior to applying the
    /// fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.</p>
    pub reservoir_size: i32,
    /// <p>Matches the <code>name</code> that the service uses to identify itself in segments.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>Matches the <code>origin</code> that the service uses to identify its type in segments.</p>
    pub service_type: std::option::Option<std::string::String>,
    /// <p>Matches the hostname from a request URL.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Matches the HTTP method of a request.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>Matches the path from a request URL.</p>
    pub url_path: std::option::Option<std::string::String>,
    /// <p>The version of the sampling rule format (<code>1</code>).</p>
    pub version: i32,
    /// <p>Matches attributes derived from the request.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl SamplingRule {
    /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub fn rule_arn(&self) -> std::option::Option<&str> {
        self.rule_arn.as_deref()
    }
    /// <p>Matches the ARN of the Amazon Web Services resource on which the service runs.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The priority of the sampling rule.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
    /// <p>The percentage of matching requests to instrument, after the reservoir is
    /// exhausted.</p>
    pub fn fixed_rate(&self) -> f64 {
        self.fixed_rate
    }
    /// <p>A fixed number of matching requests to instrument per second, prior to applying the
    /// fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.</p>
    pub fn reservoir_size(&self) -> i32 {
        self.reservoir_size
    }
    /// <p>Matches the <code>name</code> that the service uses to identify itself in segments.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>Matches the <code>origin</code> that the service uses to identify its type in segments.</p>
    pub fn service_type(&self) -> std::option::Option<&str> {
        self.service_type.as_deref()
    }
    /// <p>Matches the hostname from a request URL.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Matches the HTTP method of a request.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>Matches the path from a request URL.</p>
    pub fn url_path(&self) -> std::option::Option<&str> {
        self.url_path.as_deref()
    }
    /// <p>The version of the sampling rule format (<code>1</code>).</p>
    pub fn version(&self) -> i32 {
        self.version
    }
    /// <p>Matches attributes derived from the request.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for SamplingRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamplingRule");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("rule_arn", &self.rule_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("priority", &self.priority);
        formatter.field("fixed_rate", &self.fixed_rate);
        formatter.field("reservoir_size", &self.reservoir_size);
        formatter.field("service_name", &self.service_name);
        formatter.field("service_type", &self.service_type);
        formatter.field("host", &self.host);
        formatter.field("http_method", &self.http_method);
        formatter.field("url_path", &self.url_path);
        formatter.field("version", &self.version);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`SamplingRule`](crate::model::SamplingRule)
pub mod sampling_rule {
    /// A builder for [`SamplingRule`](crate::model::SamplingRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) rule_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) fixed_rate: std::option::Option<f64>,
        pub(crate) reservoir_size: std::option::Option<i32>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) service_type: std::option::Option<std::string::String>,
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) url_path: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_arn = input;
            self
        }
        /// <p>Matches the ARN of the Amazon Web Services resource on which the service runs.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Matches the ARN of the Amazon Web Services resource on which the service runs.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The priority of the sampling rule.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority of the sampling rule.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The percentage of matching requests to instrument, after the reservoir is
        /// exhausted.</p>
        pub fn fixed_rate(mut self, input: f64) -> Self {
            self.fixed_rate = Some(input);
            self
        }
        /// <p>The percentage of matching requests to instrument, after the reservoir is
        /// exhausted.</p>
        pub fn set_fixed_rate(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_rate = input;
            self
        }
        /// <p>A fixed number of matching requests to instrument per second, prior to applying the
        /// fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.</p>
        pub fn reservoir_size(mut self, input: i32) -> Self {
            self.reservoir_size = Some(input);
            self
        }
        /// <p>A fixed number of matching requests to instrument per second, prior to applying the
        /// fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.</p>
        pub fn set_reservoir_size(mut self, input: std::option::Option<i32>) -> Self {
            self.reservoir_size = input;
            self
        }
        /// <p>Matches the <code>name</code> that the service uses to identify itself in segments.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>Matches the <code>name</code> that the service uses to identify itself in segments.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>Matches the <code>origin</code> that the service uses to identify its type in segments.</p>
        pub fn service_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_type = Some(input.into());
            self
        }
        /// <p>Matches the <code>origin</code> that the service uses to identify its type in segments.</p>
        pub fn set_service_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_type = input;
            self
        }
        /// <p>Matches the hostname from a request URL.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Matches the hostname from a request URL.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Matches the HTTP method of a request.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>Matches the HTTP method of a request.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>Matches the path from a request URL.</p>
        pub fn url_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.url_path = Some(input.into());
            self
        }
        /// <p>Matches the path from a request URL.</p>
        pub fn set_url_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url_path = input;
            self
        }
        /// <p>The version of the sampling rule format (<code>1</code>).</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the sampling rule format (<code>1</code>).</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Matches attributes derived from the request.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>Matches attributes derived from the request.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`SamplingRule`](crate::model::SamplingRule)
        pub fn build(self) -> crate::model::SamplingRule {
            crate::model::SamplingRule {
                rule_name: self.rule_name,
                rule_arn: self.rule_arn,
                resource_arn: self.resource_arn,
                priority: self.priority.unwrap_or_default(),
                fixed_rate: self.fixed_rate.unwrap_or_default(),
                reservoir_size: self.reservoir_size.unwrap_or_default(),
                service_name: self.service_name,
                service_type: self.service_type,
                host: self.host,
                http_method: self.http_method,
                url_path: self.url_path,
                version: self.version.unwrap_or_default(),
                attributes: self.attributes,
            }
        }
    }
}
impl SamplingRule {
    /// Creates a new builder-style object to manufacture [`SamplingRule`](crate::model::SamplingRule)
    pub fn builder() -> crate::model::sampling_rule::Builder {
        crate::model::sampling_rule::Builder::default()
    }
}

/// <p>A document specifying changes to a sampling rule's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamplingRuleUpdate {
    /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub rule_arn: std::option::Option<std::string::String>,
    /// <p>Matches the ARN of the Amazon Web Services resource on which the service runs.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The priority of the sampling rule.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The percentage of matching requests to instrument, after the reservoir is
    /// exhausted.</p>
    pub fixed_rate: std::option::Option<f64>,
    /// <p>A fixed number of matching requests to instrument per second, prior to applying the
    /// fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.</p>
    pub reservoir_size: std::option::Option<i32>,
    /// <p>Matches the hostname from a request URL.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Matches the <code>name</code> that the service uses to identify itself in segments.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>Matches the <code>origin</code> that the service uses to identify its type in segments.</p>
    pub service_type: std::option::Option<std::string::String>,
    /// <p>Matches the HTTP method of a request.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>Matches the path from a request URL.</p>
    pub url_path: std::option::Option<std::string::String>,
    /// <p>Matches attributes derived from the request.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl SamplingRuleUpdate {
    /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub fn rule_arn(&self) -> std::option::Option<&str> {
        self.rule_arn.as_deref()
    }
    /// <p>Matches the ARN of the Amazon Web Services resource on which the service runs.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The priority of the sampling rule.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>The percentage of matching requests to instrument, after the reservoir is
    /// exhausted.</p>
    pub fn fixed_rate(&self) -> std::option::Option<f64> {
        self.fixed_rate
    }
    /// <p>A fixed number of matching requests to instrument per second, prior to applying the
    /// fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.</p>
    pub fn reservoir_size(&self) -> std::option::Option<i32> {
        self.reservoir_size
    }
    /// <p>Matches the hostname from a request URL.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Matches the <code>name</code> that the service uses to identify itself in segments.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>Matches the <code>origin</code> that the service uses to identify its type in segments.</p>
    pub fn service_type(&self) -> std::option::Option<&str> {
        self.service_type.as_deref()
    }
    /// <p>Matches the HTTP method of a request.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>Matches the path from a request URL.</p>
    pub fn url_path(&self) -> std::option::Option<&str> {
        self.url_path.as_deref()
    }
    /// <p>Matches attributes derived from the request.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for SamplingRuleUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamplingRuleUpdate");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("rule_arn", &self.rule_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("priority", &self.priority);
        formatter.field("fixed_rate", &self.fixed_rate);
        formatter.field("reservoir_size", &self.reservoir_size);
        formatter.field("host", &self.host);
        formatter.field("service_name", &self.service_name);
        formatter.field("service_type", &self.service_type);
        formatter.field("http_method", &self.http_method);
        formatter.field("url_path", &self.url_path);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`SamplingRuleUpdate`](crate::model::SamplingRuleUpdate)
pub mod sampling_rule_update {
    /// A builder for [`SamplingRuleUpdate`](crate::model::SamplingRuleUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) rule_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) fixed_rate: std::option::Option<f64>,
        pub(crate) reservoir_size: std::option::Option<i32>,
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) service_type: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) url_path: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_arn = input;
            self
        }
        /// <p>Matches the ARN of the Amazon Web Services resource on which the service runs.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Matches the ARN of the Amazon Web Services resource on which the service runs.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The priority of the sampling rule.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority of the sampling rule.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The percentage of matching requests to instrument, after the reservoir is
        /// exhausted.</p>
        pub fn fixed_rate(mut self, input: f64) -> Self {
            self.fixed_rate = Some(input);
            self
        }
        /// <p>The percentage of matching requests to instrument, after the reservoir is
        /// exhausted.</p>
        pub fn set_fixed_rate(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_rate = input;
            self
        }
        /// <p>A fixed number of matching requests to instrument per second, prior to applying the
        /// fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.</p>
        pub fn reservoir_size(mut self, input: i32) -> Self {
            self.reservoir_size = Some(input);
            self
        }
        /// <p>A fixed number of matching requests to instrument per second, prior to applying the
        /// fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.</p>
        pub fn set_reservoir_size(mut self, input: std::option::Option<i32>) -> Self {
            self.reservoir_size = input;
            self
        }
        /// <p>Matches the hostname from a request URL.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Matches the hostname from a request URL.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Matches the <code>name</code> that the service uses to identify itself in segments.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>Matches the <code>name</code> that the service uses to identify itself in segments.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>Matches the <code>origin</code> that the service uses to identify its type in segments.</p>
        pub fn service_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_type = Some(input.into());
            self
        }
        /// <p>Matches the <code>origin</code> that the service uses to identify its type in segments.</p>
        pub fn set_service_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_type = input;
            self
        }
        /// <p>Matches the HTTP method of a request.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>Matches the HTTP method of a request.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>Matches the path from a request URL.</p>
        pub fn url_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.url_path = Some(input.into());
            self
        }
        /// <p>Matches the path from a request URL.</p>
        pub fn set_url_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url_path = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Matches attributes derived from the request.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>Matches attributes derived from the request.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`SamplingRuleUpdate`](crate::model::SamplingRuleUpdate)
        pub fn build(self) -> crate::model::SamplingRuleUpdate {
            crate::model::SamplingRuleUpdate {
                rule_name: self.rule_name,
                rule_arn: self.rule_arn,
                resource_arn: self.resource_arn,
                priority: self.priority,
                fixed_rate: self.fixed_rate,
                reservoir_size: self.reservoir_size,
                host: self.host,
                service_name: self.service_name,
                service_type: self.service_type,
                http_method: self.http_method,
                url_path: self.url_path,
                attributes: self.attributes,
            }
        }
    }
}
impl SamplingRuleUpdate {
    /// Creates a new builder-style object to manufacture [`SamplingRuleUpdate`](crate::model::SamplingRuleUpdate)
    pub fn builder() -> crate::model::sampling_rule_update::Builder {
        crate::model::sampling_rule_update::Builder::default()
    }
}

/// <p>Details and metadata for a group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Group {
    /// <p>The unique case-sensitive name of the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the group generated based on the GroupName.</p>
    pub group_arn: std::option::Option<std::string::String>,
    /// <p>The filter expression defining the parameters to include traces.</p>
    pub filter_expression: std::option::Option<std::string::String>,
    /// <p>The structure containing configurations related to insights.</p>
    /// <ul>
    /// <li>
    /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
    /// group or false to disable insights for the group.</p>
    /// </li>
    /// <li>
    /// <p>The NotificationsEnabled boolean can be set to true to enable insights
    /// notifications through Amazon EventBridge for the group.</p>
    /// </li>
    /// </ul>
    pub insights_configuration: std::option::Option<crate::model::InsightsConfiguration>,
}
impl Group {
    /// <p>The unique case-sensitive name of the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the group generated based on the GroupName.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
    /// <p>The filter expression defining the parameters to include traces.</p>
    pub fn filter_expression(&self) -> std::option::Option<&str> {
        self.filter_expression.as_deref()
    }
    /// <p>The structure containing configurations related to insights.</p>
    /// <ul>
    /// <li>
    /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
    /// group or false to disable insights for the group.</p>
    /// </li>
    /// <li>
    /// <p>The NotificationsEnabled boolean can be set to true to enable insights
    /// notifications through Amazon EventBridge for the group.</p>
    /// </li>
    /// </ul>
    pub fn insights_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InsightsConfiguration> {
        self.insights_configuration.as_ref()
    }
}
impl std::fmt::Debug for Group {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Group");
        formatter.field("group_name", &self.group_name);
        formatter.field("group_arn", &self.group_arn);
        formatter.field("filter_expression", &self.filter_expression);
        formatter.field("insights_configuration", &self.insights_configuration);
        formatter.finish()
    }
}
/// See [`Group`](crate::model::Group)
pub mod group {
    /// A builder for [`Group`](crate::model::Group)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
        pub(crate) filter_expression: std::option::Option<std::string::String>,
        pub(crate) insights_configuration: std::option::Option<crate::model::InsightsConfiguration>,
    }
    impl Builder {
        /// <p>The unique case-sensitive name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The unique case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group generated based on the GroupName.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group generated based on the GroupName.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// <p>The filter expression defining the parameters to include traces.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>The filter expression defining the parameters to include traces.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// group or false to disable insights for the group.</p>
        /// </li>
        /// <li>
        /// <p>The NotificationsEnabled boolean can be set to true to enable insights
        /// notifications through Amazon EventBridge for the group.</p>
        /// </li>
        /// </ul>
        pub fn insights_configuration(
            mut self,
            input: crate::model::InsightsConfiguration,
        ) -> Self {
            self.insights_configuration = Some(input);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// group or false to disable insights for the group.</p>
        /// </li>
        /// <li>
        /// <p>The NotificationsEnabled boolean can be set to true to enable insights
        /// notifications through Amazon EventBridge for the group.</p>
        /// </li>
        /// </ul>
        pub fn set_insights_configuration(
            mut self,
            input: std::option::Option<crate::model::InsightsConfiguration>,
        ) -> Self {
            self.insights_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Group`](crate::model::Group)
        pub fn build(self) -> crate::model::Group {
            crate::model::Group {
                group_name: self.group_name,
                group_arn: self.group_arn,
                filter_expression: self.filter_expression,
                insights_configuration: self.insights_configuration,
            }
        }
    }
}
impl Group {
    /// Creates a new builder-style object to manufacture [`Group`](crate::model::Group)
    pub fn builder() -> crate::model::group::Builder {
        crate::model::group::Builder::default()
    }
}

/// <p>The structure containing configurations related to insights.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightsConfiguration {
    /// <p>Set the InsightsEnabled value to true to enable insights or false to disable
    /// insights.</p>
    pub insights_enabled: std::option::Option<bool>,
    /// <p>Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be
    /// enabled on a group with InsightsEnabled set to true.</p>
    pub notifications_enabled: std::option::Option<bool>,
}
impl InsightsConfiguration {
    /// <p>Set the InsightsEnabled value to true to enable insights or false to disable
    /// insights.</p>
    pub fn insights_enabled(&self) -> std::option::Option<bool> {
        self.insights_enabled
    }
    /// <p>Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be
    /// enabled on a group with InsightsEnabled set to true.</p>
    pub fn notifications_enabled(&self) -> std::option::Option<bool> {
        self.notifications_enabled
    }
}
impl std::fmt::Debug for InsightsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightsConfiguration");
        formatter.field("insights_enabled", &self.insights_enabled);
        formatter.field("notifications_enabled", &self.notifications_enabled);
        formatter.finish()
    }
}
/// See [`InsightsConfiguration`](crate::model::InsightsConfiguration)
pub mod insights_configuration {
    /// A builder for [`InsightsConfiguration`](crate::model::InsightsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insights_enabled: std::option::Option<bool>,
        pub(crate) notifications_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Set the InsightsEnabled value to true to enable insights or false to disable
        /// insights.</p>
        pub fn insights_enabled(mut self, input: bool) -> Self {
            self.insights_enabled = Some(input);
            self
        }
        /// <p>Set the InsightsEnabled value to true to enable insights or false to disable
        /// insights.</p>
        pub fn set_insights_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.insights_enabled = input;
            self
        }
        /// <p>Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be
        /// enabled on a group with InsightsEnabled set to true.</p>
        pub fn notifications_enabled(mut self, input: bool) -> Self {
            self.notifications_enabled = Some(input);
            self
        }
        /// <p>Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be
        /// enabled on a group with InsightsEnabled set to true.</p>
        pub fn set_notifications_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.notifications_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightsConfiguration`](crate::model::InsightsConfiguration)
        pub fn build(self) -> crate::model::InsightsConfiguration {
            crate::model::InsightsConfiguration {
                insights_enabled: self.insights_enabled,
                notifications_enabled: self.notifications_enabled,
            }
        }
    }
}
impl InsightsConfiguration {
    /// Creates a new builder-style object to manufacture [`InsightsConfiguration`](crate::model::InsightsConfiguration)
    pub fn builder() -> crate::model::insights_configuration::Builder {
        crate::model::insights_configuration::Builder::default()
    }
}

/// <p>A map that contains tag keys and tag values to attach to an Amazon Web Services X-Ray group or sampling
/// rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
/// in the <i>Amazon Web Services General Reference</i>.</p>
/// <p>The following restrictions apply to tags:</p>
/// <ul>
/// <li>
/// <p>Maximum number of user-applied tags per resource: 50</p>
/// </li>
/// <li>
/// <p>Tag keys and values are case sensitive.</p>
/// </li>
/// <li>
/// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You
/// cannot edit or delete system tags.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The
    /// key can be a maximum of 128 characters, and can contain only Unicode letters, numbers, or separators,
    /// or the following special characters: <code>+ - = . _ : /</code>
    /// </p>
    pub key: std::option::Option<std::string::String>,
    /// <p>An optional tag value, such as <code>Production</code> or <code>test-only</code>. The value can be
    /// a maximum of 255 characters, and contain only Unicode letters, numbers, or separators, or the following
    /// special characters: <code>+ - = . _ : /</code>
    /// </p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The
    /// key can be a maximum of 128 characters, and can contain only Unicode letters, numbers, or separators,
    /// or the following special characters: <code>+ - = . _ : /</code>
    /// </p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>An optional tag value, such as <code>Production</code> or <code>test-only</code>. The value can be
    /// a maximum of 255 characters, and contain only Unicode letters, numbers, or separators, or the following
    /// special characters: <code>+ - = . _ : /</code>
    /// </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The
        /// key can be a maximum of 128 characters, and can contain only Unicode letters, numbers, or separators,
        /// or the following special characters: <code>+ - = . _ : /</code>
        /// </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A tag key, such as <code>Stage</code> or <code>Name</code>. A tag key cannot be empty. The
        /// key can be a maximum of 128 characters, and can contain only Unicode letters, numbers, or separators,
        /// or the following special characters: <code>+ - = . _ : /</code>
        /// </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>An optional tag value, such as <code>Production</code> or <code>test-only</code>. The value can be
        /// a maximum of 255 characters, and contain only Unicode letters, numbers, or separators, or the following
        /// special characters: <code>+ - = . _ : /</code>
        /// </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>An optional tag value, such as <code>Production</code> or <code>test-only</code>. The value can be
        /// a maximum of 255 characters, and contain only Unicode letters, numbers, or separators, or the following
        /// special characters: <code>+ - = . _ : /</code>
        /// </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Information about a segment that failed processing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessedTraceSegment {
    /// <p>The segment's ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The error that caused processing to fail.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl UnprocessedTraceSegment {
    /// <p>The segment's ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The error that caused processing to fail.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for UnprocessedTraceSegment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessedTraceSegment");
        formatter.field("id", &self.id);
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`UnprocessedTraceSegment`](crate::model::UnprocessedTraceSegment)
pub mod unprocessed_trace_segment {
    /// A builder for [`UnprocessedTraceSegment`](crate::model::UnprocessedTraceSegment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The segment's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The segment's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The error that caused processing to fail.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error that caused processing to fail.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessedTraceSegment`](crate::model::UnprocessedTraceSegment)
        pub fn build(self) -> crate::model::UnprocessedTraceSegment {
            crate::model::UnprocessedTraceSegment {
                id: self.id,
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl UnprocessedTraceSegment {
    /// Creates a new builder-style object to manufacture [`UnprocessedTraceSegment`](crate::model::UnprocessedTraceSegment)
    pub fn builder() -> crate::model::unprocessed_trace_segment::Builder {
        crate::model::unprocessed_trace_segment::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TelemetryRecord {
    /// <p></p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p></p>
    pub segments_received_count: std::option::Option<i32>,
    /// <p></p>
    pub segments_sent_count: std::option::Option<i32>,
    /// <p></p>
    pub segments_spillover_count: std::option::Option<i32>,
    /// <p></p>
    pub segments_rejected_count: std::option::Option<i32>,
    /// <p></p>
    pub backend_connection_errors: std::option::Option<crate::model::BackendConnectionErrors>,
}
impl TelemetryRecord {
    /// <p></p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p></p>
    pub fn segments_received_count(&self) -> std::option::Option<i32> {
        self.segments_received_count
    }
    /// <p></p>
    pub fn segments_sent_count(&self) -> std::option::Option<i32> {
        self.segments_sent_count
    }
    /// <p></p>
    pub fn segments_spillover_count(&self) -> std::option::Option<i32> {
        self.segments_spillover_count
    }
    /// <p></p>
    pub fn segments_rejected_count(&self) -> std::option::Option<i32> {
        self.segments_rejected_count
    }
    /// <p></p>
    pub fn backend_connection_errors(
        &self,
    ) -> std::option::Option<&crate::model::BackendConnectionErrors> {
        self.backend_connection_errors.as_ref()
    }
}
impl std::fmt::Debug for TelemetryRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TelemetryRecord");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("segments_received_count", &self.segments_received_count);
        formatter.field("segments_sent_count", &self.segments_sent_count);
        formatter.field("segments_spillover_count", &self.segments_spillover_count);
        formatter.field("segments_rejected_count", &self.segments_rejected_count);
        formatter.field("backend_connection_errors", &self.backend_connection_errors);
        formatter.finish()
    }
}
/// See [`TelemetryRecord`](crate::model::TelemetryRecord)
pub mod telemetry_record {
    /// A builder for [`TelemetryRecord`](crate::model::TelemetryRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) segments_received_count: std::option::Option<i32>,
        pub(crate) segments_sent_count: std::option::Option<i32>,
        pub(crate) segments_spillover_count: std::option::Option<i32>,
        pub(crate) segments_rejected_count: std::option::Option<i32>,
        pub(crate) backend_connection_errors:
            std::option::Option<crate::model::BackendConnectionErrors>,
    }
    impl Builder {
        /// <p></p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p></p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p></p>
        pub fn segments_received_count(mut self, input: i32) -> Self {
            self.segments_received_count = Some(input);
            self
        }
        /// <p></p>
        pub fn set_segments_received_count(mut self, input: std::option::Option<i32>) -> Self {
            self.segments_received_count = input;
            self
        }
        /// <p></p>
        pub fn segments_sent_count(mut self, input: i32) -> Self {
            self.segments_sent_count = Some(input);
            self
        }
        /// <p></p>
        pub fn set_segments_sent_count(mut self, input: std::option::Option<i32>) -> Self {
            self.segments_sent_count = input;
            self
        }
        /// <p></p>
        pub fn segments_spillover_count(mut self, input: i32) -> Self {
            self.segments_spillover_count = Some(input);
            self
        }
        /// <p></p>
        pub fn set_segments_spillover_count(mut self, input: std::option::Option<i32>) -> Self {
            self.segments_spillover_count = input;
            self
        }
        /// <p></p>
        pub fn segments_rejected_count(mut self, input: i32) -> Self {
            self.segments_rejected_count = Some(input);
            self
        }
        /// <p></p>
        pub fn set_segments_rejected_count(mut self, input: std::option::Option<i32>) -> Self {
            self.segments_rejected_count = input;
            self
        }
        /// <p></p>
        pub fn backend_connection_errors(
            mut self,
            input: crate::model::BackendConnectionErrors,
        ) -> Self {
            self.backend_connection_errors = Some(input);
            self
        }
        /// <p></p>
        pub fn set_backend_connection_errors(
            mut self,
            input: std::option::Option<crate::model::BackendConnectionErrors>,
        ) -> Self {
            self.backend_connection_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`TelemetryRecord`](crate::model::TelemetryRecord)
        pub fn build(self) -> crate::model::TelemetryRecord {
            crate::model::TelemetryRecord {
                timestamp: self.timestamp,
                segments_received_count: self.segments_received_count,
                segments_sent_count: self.segments_sent_count,
                segments_spillover_count: self.segments_spillover_count,
                segments_rejected_count: self.segments_rejected_count,
                backend_connection_errors: self.backend_connection_errors,
            }
        }
    }
}
impl TelemetryRecord {
    /// Creates a new builder-style object to manufacture [`TelemetryRecord`](crate::model::TelemetryRecord)
    pub fn builder() -> crate::model::telemetry_record::Builder {
        crate::model::telemetry_record::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackendConnectionErrors {
    /// <p></p>
    pub timeout_count: std::option::Option<i32>,
    /// <p></p>
    pub connection_refused_count: std::option::Option<i32>,
    /// <p></p>
    pub http_code4_xx_count: std::option::Option<i32>,
    /// <p></p>
    pub http_code5_xx_count: std::option::Option<i32>,
    /// <p></p>
    pub unknown_host_count: std::option::Option<i32>,
    /// <p></p>
    pub other_count: std::option::Option<i32>,
}
impl BackendConnectionErrors {
    /// <p></p>
    pub fn timeout_count(&self) -> std::option::Option<i32> {
        self.timeout_count
    }
    /// <p></p>
    pub fn connection_refused_count(&self) -> std::option::Option<i32> {
        self.connection_refused_count
    }
    /// <p></p>
    pub fn http_code4_xx_count(&self) -> std::option::Option<i32> {
        self.http_code4_xx_count
    }
    /// <p></p>
    pub fn http_code5_xx_count(&self) -> std::option::Option<i32> {
        self.http_code5_xx_count
    }
    /// <p></p>
    pub fn unknown_host_count(&self) -> std::option::Option<i32> {
        self.unknown_host_count
    }
    /// <p></p>
    pub fn other_count(&self) -> std::option::Option<i32> {
        self.other_count
    }
}
impl std::fmt::Debug for BackendConnectionErrors {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackendConnectionErrors");
        formatter.field("timeout_count", &self.timeout_count);
        formatter.field("connection_refused_count", &self.connection_refused_count);
        formatter.field("http_code4_xx_count", &self.http_code4_xx_count);
        formatter.field("http_code5_xx_count", &self.http_code5_xx_count);
        formatter.field("unknown_host_count", &self.unknown_host_count);
        formatter.field("other_count", &self.other_count);
        formatter.finish()
    }
}
/// See [`BackendConnectionErrors`](crate::model::BackendConnectionErrors)
pub mod backend_connection_errors {
    /// A builder for [`BackendConnectionErrors`](crate::model::BackendConnectionErrors)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_count: std::option::Option<i32>,
        pub(crate) connection_refused_count: std::option::Option<i32>,
        pub(crate) http_code4_xx_count: std::option::Option<i32>,
        pub(crate) http_code5_xx_count: std::option::Option<i32>,
        pub(crate) unknown_host_count: std::option::Option<i32>,
        pub(crate) other_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p></p>
        pub fn timeout_count(mut self, input: i32) -> Self {
            self.timeout_count = Some(input);
            self
        }
        /// <p></p>
        pub fn set_timeout_count(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_count = input;
            self
        }
        /// <p></p>
        pub fn connection_refused_count(mut self, input: i32) -> Self {
            self.connection_refused_count = Some(input);
            self
        }
        /// <p></p>
        pub fn set_connection_refused_count(mut self, input: std::option::Option<i32>) -> Self {
            self.connection_refused_count = input;
            self
        }
        /// <p></p>
        pub fn http_code4_xx_count(mut self, input: i32) -> Self {
            self.http_code4_xx_count = Some(input);
            self
        }
        /// <p></p>
        pub fn set_http_code4_xx_count(mut self, input: std::option::Option<i32>) -> Self {
            self.http_code4_xx_count = input;
            self
        }
        /// <p></p>
        pub fn http_code5_xx_count(mut self, input: i32) -> Self {
            self.http_code5_xx_count = Some(input);
            self
        }
        /// <p></p>
        pub fn set_http_code5_xx_count(mut self, input: std::option::Option<i32>) -> Self {
            self.http_code5_xx_count = input;
            self
        }
        /// <p></p>
        pub fn unknown_host_count(mut self, input: i32) -> Self {
            self.unknown_host_count = Some(input);
            self
        }
        /// <p></p>
        pub fn set_unknown_host_count(mut self, input: std::option::Option<i32>) -> Self {
            self.unknown_host_count = input;
            self
        }
        /// <p></p>
        pub fn other_count(mut self, input: i32) -> Self {
            self.other_count = Some(input);
            self
        }
        /// <p></p>
        pub fn set_other_count(mut self, input: std::option::Option<i32>) -> Self {
            self.other_count = input;
            self
        }
        /// Consumes the builder and constructs a [`BackendConnectionErrors`](crate::model::BackendConnectionErrors)
        pub fn build(self) -> crate::model::BackendConnectionErrors {
            crate::model::BackendConnectionErrors {
                timeout_count: self.timeout_count,
                connection_refused_count: self.connection_refused_count,
                http_code4_xx_count: self.http_code4_xx_count,
                http_code5_xx_count: self.http_code5_xx_count,
                unknown_host_count: self.unknown_host_count,
                other_count: self.other_count,
            }
        }
    }
}
impl BackendConnectionErrors {
    /// Creates a new builder-style object to manufacture [`BackendConnectionErrors`](crate::model::BackendConnectionErrors)
    pub fn builder() -> crate::model::backend_connection_errors::Builder {
        crate::model::backend_connection_errors::Builder::default()
    }
}

/// <p>A configuration document that specifies encryption configuration settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionConfig {
    /// <p>The ID of the KMS key used for encryption, if applicable.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a combination of the new and old settings.</p>
    pub status: std::option::Option<crate::model::EncryptionStatus>,
    /// <p>The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code> for
    /// default encryption.</p>
    pub r#type: std::option::Option<crate::model::EncryptionType>,
}
impl EncryptionConfig {
    /// <p>The ID of the KMS key used for encryption, if applicable.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a combination of the new and old settings.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EncryptionStatus> {
        self.status.as_ref()
    }
    /// <p>The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code> for
    /// default encryption.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for EncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionConfig");
        formatter.field("key_id", &self.key_id);
        formatter.field("status", &self.status);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`EncryptionConfig`](crate::model::EncryptionConfig)
pub mod encryption_config {
    /// A builder for [`EncryptionConfig`](crate::model::EncryptionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EncryptionStatus>,
        pub(crate) r#type: std::option::Option<crate::model::EncryptionType>,
    }
    impl Builder {
        /// <p>The ID of the KMS key used for encryption, if applicable.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used for encryption, if applicable.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a combination of the new and old settings.</p>
        pub fn status(mut self, input: crate::model::EncryptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The encryption status. While the status is <code>UPDATING</code>, X-Ray may encrypt data with a combination of the new and old settings.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EncryptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code> for
        /// default encryption.</p>
        pub fn r#type(mut self, input: crate::model::EncryptionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of encryption. Set to <code>KMS</code> for encryption with KMS keys. Set to <code>NONE</code> for
        /// default encryption.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionConfig`](crate::model::EncryptionConfig)
        pub fn build(self) -> crate::model::EncryptionConfig {
            crate::model::EncryptionConfig {
                key_id: self.key_id,
                status: self.status,
                r#type: self.r#type,
            }
        }
    }
}
impl EncryptionConfig {
    /// Creates a new builder-style object to manufacture [`EncryptionConfig`](crate::model::EncryptionConfig)
    pub fn builder() -> crate::model::encryption_config::Builder {
        crate::model::encryption_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionType {
    #[allow(missing_docs)] // documentation missing in model
    Kms,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionType {
    fn from(s: &str) -> Self {
        match s {
            "KMS" => EncryptionType::Kms,
            "NONE" => EncryptionType::None,
            other => EncryptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionType::from(s))
    }
}
impl EncryptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionType::Kms => "KMS",
            EncryptionType::None => "NONE",
            EncryptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KMS", "NONE"]
    }
}
impl AsRef<str> for EncryptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => EncryptionStatus::Active,
            "UPDATING" => EncryptionStatus::Updating,
            other => EncryptionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionStatus::from(s))
    }
}
impl EncryptionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionStatus::Active => "ACTIVE",
            EncryptionStatus::Updating => "UPDATING",
            EncryptionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "UPDATING"]
    }
}
impl AsRef<str> for EncryptionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata generated from the segment documents in a trace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TraceSummary {
    /// <p>The unique identifier for the request that generated the trace's segments and
    /// subsegments.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The length of time in seconds between the start time of the root segment and the end
    /// time of the last segment that completed.</p>
    pub duration: std::option::Option<f64>,
    /// <p>The length of time in seconds between the start and end times of the root segment. If
    /// the service performs work asynchronously, the response time measures the time before the
    /// response is sent to the user, while the duration measures the amount of time before the last
    /// traced activity completes.</p>
    pub response_time: std::option::Option<f64>,
    /// <p>The root segment document has a 500 series error.</p>
    pub has_fault: std::option::Option<bool>,
    /// <p>The root segment document has a 400 series error.</p>
    pub has_error: std::option::Option<bool>,
    /// <p>One or more of the segment documents has a 429 throttling error.</p>
    pub has_throttle: std::option::Option<bool>,
    /// <p>One or more of the segment documents is in progress.</p>
    pub is_partial: std::option::Option<bool>,
    /// <p>Information about the HTTP request served by the trace.</p>
    pub http: std::option::Option<crate::model::Http>,
    /// <p>Annotations from the trace's segment documents.</p>
    pub annotations: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::ValueWithServiceIds>,
        >,
    >,
    /// <p>Users from the trace's segment documents.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::TraceUser>>,
    /// <p>Service IDs from the trace's segment documents.</p>
    pub service_ids: std::option::Option<std::vec::Vec<crate::model::ServiceId>>,
    /// <p>A list of resource ARNs for any resource corresponding to the trace segments.</p>
    pub resource_ar_ns: std::option::Option<std::vec::Vec<crate::model::ResourceArnDetail>>,
    /// <p>A list of EC2 instance IDs for any instance corresponding to the trace
    /// segments.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<crate::model::InstanceIdDetail>>,
    /// <p>A list of Availability Zones for any zone corresponding to the trace segments.</p>
    pub availability_zones:
        std::option::Option<std::vec::Vec<crate::model::AvailabilityZoneDetail>>,
    /// <p>The root of a trace.</p>
    pub entry_point: std::option::Option<crate::model::ServiceId>,
    /// <p>A collection of FaultRootCause structures corresponding to the trace segments.</p>
    pub fault_root_causes: std::option::Option<std::vec::Vec<crate::model::FaultRootCause>>,
    /// <p>A collection of ErrorRootCause structures corresponding to the trace
    /// segments.</p>
    pub error_root_causes: std::option::Option<std::vec::Vec<crate::model::ErrorRootCause>>,
    /// <p>A collection of ResponseTimeRootCause structures corresponding to the trace
    /// segments.</p>
    pub response_time_root_causes:
        std::option::Option<std::vec::Vec<crate::model::ResponseTimeRootCause>>,
    /// <p>The revision number of a trace.</p>
    pub revision: i32,
    /// <p>The matched time stamp of a defined event.</p>
    pub matched_event_time: std::option::Option<aws_smithy_types::Instant>,
}
impl TraceSummary {
    /// <p>The unique identifier for the request that generated the trace's segments and
    /// subsegments.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The length of time in seconds between the start time of the root segment and the end
    /// time of the last segment that completed.</p>
    pub fn duration(&self) -> std::option::Option<f64> {
        self.duration
    }
    /// <p>The length of time in seconds between the start and end times of the root segment. If
    /// the service performs work asynchronously, the response time measures the time before the
    /// response is sent to the user, while the duration measures the amount of time before the last
    /// traced activity completes.</p>
    pub fn response_time(&self) -> std::option::Option<f64> {
        self.response_time
    }
    /// <p>The root segment document has a 500 series error.</p>
    pub fn has_fault(&self) -> std::option::Option<bool> {
        self.has_fault
    }
    /// <p>The root segment document has a 400 series error.</p>
    pub fn has_error(&self) -> std::option::Option<bool> {
        self.has_error
    }
    /// <p>One or more of the segment documents has a 429 throttling error.</p>
    pub fn has_throttle(&self) -> std::option::Option<bool> {
        self.has_throttle
    }
    /// <p>One or more of the segment documents is in progress.</p>
    pub fn is_partial(&self) -> std::option::Option<bool> {
        self.is_partial
    }
    /// <p>Information about the HTTP request served by the trace.</p>
    pub fn http(&self) -> std::option::Option<&crate::model::Http> {
        self.http.as_ref()
    }
    /// <p>Annotations from the trace's segment documents.</p>
    pub fn annotations(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::ValueWithServiceIds>,
        >,
    > {
        self.annotations.as_ref()
    }
    /// <p>Users from the trace's segment documents.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::TraceUser]> {
        self.users.as_deref()
    }
    /// <p>Service IDs from the trace's segment documents.</p>
    pub fn service_ids(&self) -> std::option::Option<&[crate::model::ServiceId]> {
        self.service_ids.as_deref()
    }
    /// <p>A list of resource ARNs for any resource corresponding to the trace segments.</p>
    pub fn resource_ar_ns(&self) -> std::option::Option<&[crate::model::ResourceArnDetail]> {
        self.resource_ar_ns.as_deref()
    }
    /// <p>A list of EC2 instance IDs for any instance corresponding to the trace
    /// segments.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[crate::model::InstanceIdDetail]> {
        self.instance_ids.as_deref()
    }
    /// <p>A list of Availability Zones for any zone corresponding to the trace segments.</p>
    pub fn availability_zones(
        &self,
    ) -> std::option::Option<&[crate::model::AvailabilityZoneDetail]> {
        self.availability_zones.as_deref()
    }
    /// <p>The root of a trace.</p>
    pub fn entry_point(&self) -> std::option::Option<&crate::model::ServiceId> {
        self.entry_point.as_ref()
    }
    /// <p>A collection of FaultRootCause structures corresponding to the trace segments.</p>
    pub fn fault_root_causes(&self) -> std::option::Option<&[crate::model::FaultRootCause]> {
        self.fault_root_causes.as_deref()
    }
    /// <p>A collection of ErrorRootCause structures corresponding to the trace
    /// segments.</p>
    pub fn error_root_causes(&self) -> std::option::Option<&[crate::model::ErrorRootCause]> {
        self.error_root_causes.as_deref()
    }
    /// <p>A collection of ResponseTimeRootCause structures corresponding to the trace
    /// segments.</p>
    pub fn response_time_root_causes(
        &self,
    ) -> std::option::Option<&[crate::model::ResponseTimeRootCause]> {
        self.response_time_root_causes.as_deref()
    }
    /// <p>The revision number of a trace.</p>
    pub fn revision(&self) -> i32 {
        self.revision
    }
    /// <p>The matched time stamp of a defined event.</p>
    pub fn matched_event_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.matched_event_time.as_ref()
    }
}
impl std::fmt::Debug for TraceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TraceSummary");
        formatter.field("id", &self.id);
        formatter.field("duration", &self.duration);
        formatter.field("response_time", &self.response_time);
        formatter.field("has_fault", &self.has_fault);
        formatter.field("has_error", &self.has_error);
        formatter.field("has_throttle", &self.has_throttle);
        formatter.field("is_partial", &self.is_partial);
        formatter.field("http", &self.http);
        formatter.field("annotations", &self.annotations);
        formatter.field("users", &self.users);
        formatter.field("service_ids", &self.service_ids);
        formatter.field("resource_ar_ns", &self.resource_ar_ns);
        formatter.field("instance_ids", &self.instance_ids);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("entry_point", &self.entry_point);
        formatter.field("fault_root_causes", &self.fault_root_causes);
        formatter.field("error_root_causes", &self.error_root_causes);
        formatter.field("response_time_root_causes", &self.response_time_root_causes);
        formatter.field("revision", &self.revision);
        formatter.field("matched_event_time", &self.matched_event_time);
        formatter.finish()
    }
}
/// See [`TraceSummary`](crate::model::TraceSummary)
pub mod trace_summary {
    /// A builder for [`TraceSummary`](crate::model::TraceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<f64>,
        pub(crate) response_time: std::option::Option<f64>,
        pub(crate) has_fault: std::option::Option<bool>,
        pub(crate) has_error: std::option::Option<bool>,
        pub(crate) has_throttle: std::option::Option<bool>,
        pub(crate) is_partial: std::option::Option<bool>,
        pub(crate) http: std::option::Option<crate::model::Http>,
        pub(crate) annotations: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::ValueWithServiceIds>,
            >,
        >,
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::TraceUser>>,
        pub(crate) service_ids: std::option::Option<std::vec::Vec<crate::model::ServiceId>>,
        pub(crate) resource_ar_ns:
            std::option::Option<std::vec::Vec<crate::model::ResourceArnDetail>>,
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<crate::model::InstanceIdDetail>>,
        pub(crate) availability_zones:
            std::option::Option<std::vec::Vec<crate::model::AvailabilityZoneDetail>>,
        pub(crate) entry_point: std::option::Option<crate::model::ServiceId>,
        pub(crate) fault_root_causes:
            std::option::Option<std::vec::Vec<crate::model::FaultRootCause>>,
        pub(crate) error_root_causes:
            std::option::Option<std::vec::Vec<crate::model::ErrorRootCause>>,
        pub(crate) response_time_root_causes:
            std::option::Option<std::vec::Vec<crate::model::ResponseTimeRootCause>>,
        pub(crate) revision: std::option::Option<i32>,
        pub(crate) matched_event_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier for the request that generated the trace's segments and
        /// subsegments.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request that generated the trace's segments and
        /// subsegments.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The length of time in seconds between the start time of the root segment and the end
        /// time of the last segment that completed.</p>
        pub fn duration(mut self, input: f64) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The length of time in seconds between the start time of the root segment and the end
        /// time of the last segment that completed.</p>
        pub fn set_duration(mut self, input: std::option::Option<f64>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The length of time in seconds between the start and end times of the root segment. If
        /// the service performs work asynchronously, the response time measures the time before the
        /// response is sent to the user, while the duration measures the amount of time before the last
        /// traced activity completes.</p>
        pub fn response_time(mut self, input: f64) -> Self {
            self.response_time = Some(input);
            self
        }
        /// <p>The length of time in seconds between the start and end times of the root segment. If
        /// the service performs work asynchronously, the response time measures the time before the
        /// response is sent to the user, while the duration measures the amount of time before the last
        /// traced activity completes.</p>
        pub fn set_response_time(mut self, input: std::option::Option<f64>) -> Self {
            self.response_time = input;
            self
        }
        /// <p>The root segment document has a 500 series error.</p>
        pub fn has_fault(mut self, input: bool) -> Self {
            self.has_fault = Some(input);
            self
        }
        /// <p>The root segment document has a 500 series error.</p>
        pub fn set_has_fault(mut self, input: std::option::Option<bool>) -> Self {
            self.has_fault = input;
            self
        }
        /// <p>The root segment document has a 400 series error.</p>
        pub fn has_error(mut self, input: bool) -> Self {
            self.has_error = Some(input);
            self
        }
        /// <p>The root segment document has a 400 series error.</p>
        pub fn set_has_error(mut self, input: std::option::Option<bool>) -> Self {
            self.has_error = input;
            self
        }
        /// <p>One or more of the segment documents has a 429 throttling error.</p>
        pub fn has_throttle(mut self, input: bool) -> Self {
            self.has_throttle = Some(input);
            self
        }
        /// <p>One or more of the segment documents has a 429 throttling error.</p>
        pub fn set_has_throttle(mut self, input: std::option::Option<bool>) -> Self {
            self.has_throttle = input;
            self
        }
        /// <p>One or more of the segment documents is in progress.</p>
        pub fn is_partial(mut self, input: bool) -> Self {
            self.is_partial = Some(input);
            self
        }
        /// <p>One or more of the segment documents is in progress.</p>
        pub fn set_is_partial(mut self, input: std::option::Option<bool>) -> Self {
            self.is_partial = input;
            self
        }
        /// <p>Information about the HTTP request served by the trace.</p>
        pub fn http(mut self, input: crate::model::Http) -> Self {
            self.http = Some(input);
            self
        }
        /// <p>Information about the HTTP request served by the trace.</p>
        pub fn set_http(mut self, input: std::option::Option<crate::model::Http>) -> Self {
            self.http = input;
            self
        }
        /// Adds a key-value pair to `annotations`.
        ///
        /// To override the contents of this collection use [`set_annotations`](Self::set_annotations).
        ///
        /// <p>Annotations from the trace's segment documents.</p>
        pub fn annotations(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::ValueWithServiceIds>>,
        ) -> Self {
            let mut hash_map = self.annotations.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.annotations = Some(hash_map);
            self
        }
        /// <p>Annotations from the trace's segment documents.</p>
        pub fn set_annotations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ValueWithServiceIds>,
                >,
            >,
        ) -> Self {
            self.annotations = input;
            self
        }
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>Users from the trace's segment documents.</p>
        pub fn users(mut self, input: impl Into<crate::model::TraceUser>) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input.into());
            self.users = Some(v);
            self
        }
        /// <p>Users from the trace's segment documents.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TraceUser>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// Appends an item to `service_ids`.
        ///
        /// To override the contents of this collection use [`set_service_ids`](Self::set_service_ids).
        ///
        /// <p>Service IDs from the trace's segment documents.</p>
        pub fn service_ids(mut self, input: impl Into<crate::model::ServiceId>) -> Self {
            let mut v = self.service_ids.unwrap_or_default();
            v.push(input.into());
            self.service_ids = Some(v);
            self
        }
        /// <p>Service IDs from the trace's segment documents.</p>
        pub fn set_service_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceId>>,
        ) -> Self {
            self.service_ids = input;
            self
        }
        /// Appends an item to `resource_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_resource_ar_ns`](Self::set_resource_ar_ns).
        ///
        /// <p>A list of resource ARNs for any resource corresponding to the trace segments.</p>
        pub fn resource_ar_ns(mut self, input: impl Into<crate::model::ResourceArnDetail>) -> Self {
            let mut v = self.resource_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.resource_ar_ns = Some(v);
            self
        }
        /// <p>A list of resource ARNs for any resource corresponding to the trace segments.</p>
        pub fn set_resource_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceArnDetail>>,
        ) -> Self {
            self.resource_ar_ns = input;
            self
        }
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>A list of EC2 instance IDs for any instance corresponding to the trace
        /// segments.</p>
        pub fn instance_ids(mut self, input: impl Into<crate::model::InstanceIdDetail>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>A list of EC2 instance IDs for any instance corresponding to the trace
        /// segments.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceIdDetail>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Availability Zones for any zone corresponding to the trace segments.</p>
        pub fn availability_zones(
            mut self,
            input: impl Into<crate::model::AvailabilityZoneDetail>,
        ) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of Availability Zones for any zone corresponding to the trace segments.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailabilityZoneDetail>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>The root of a trace.</p>
        pub fn entry_point(mut self, input: crate::model::ServiceId) -> Self {
            self.entry_point = Some(input);
            self
        }
        /// <p>The root of a trace.</p>
        pub fn set_entry_point(
            mut self,
            input: std::option::Option<crate::model::ServiceId>,
        ) -> Self {
            self.entry_point = input;
            self
        }
        /// Appends an item to `fault_root_causes`.
        ///
        /// To override the contents of this collection use [`set_fault_root_causes`](Self::set_fault_root_causes).
        ///
        /// <p>A collection of FaultRootCause structures corresponding to the trace segments.</p>
        pub fn fault_root_causes(mut self, input: impl Into<crate::model::FaultRootCause>) -> Self {
            let mut v = self.fault_root_causes.unwrap_or_default();
            v.push(input.into());
            self.fault_root_causes = Some(v);
            self
        }
        /// <p>A collection of FaultRootCause structures corresponding to the trace segments.</p>
        pub fn set_fault_root_causes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FaultRootCause>>,
        ) -> Self {
            self.fault_root_causes = input;
            self
        }
        /// Appends an item to `error_root_causes`.
        ///
        /// To override the contents of this collection use [`set_error_root_causes`](Self::set_error_root_causes).
        ///
        /// <p>A collection of ErrorRootCause structures corresponding to the trace
        /// segments.</p>
        pub fn error_root_causes(mut self, input: impl Into<crate::model::ErrorRootCause>) -> Self {
            let mut v = self.error_root_causes.unwrap_or_default();
            v.push(input.into());
            self.error_root_causes = Some(v);
            self
        }
        /// <p>A collection of ErrorRootCause structures corresponding to the trace
        /// segments.</p>
        pub fn set_error_root_causes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ErrorRootCause>>,
        ) -> Self {
            self.error_root_causes = input;
            self
        }
        /// Appends an item to `response_time_root_causes`.
        ///
        /// To override the contents of this collection use [`set_response_time_root_causes`](Self::set_response_time_root_causes).
        ///
        /// <p>A collection of ResponseTimeRootCause structures corresponding to the trace
        /// segments.</p>
        pub fn response_time_root_causes(
            mut self,
            input: impl Into<crate::model::ResponseTimeRootCause>,
        ) -> Self {
            let mut v = self.response_time_root_causes.unwrap_or_default();
            v.push(input.into());
            self.response_time_root_causes = Some(v);
            self
        }
        /// <p>A collection of ResponseTimeRootCause structures corresponding to the trace
        /// segments.</p>
        pub fn set_response_time_root_causes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResponseTimeRootCause>>,
        ) -> Self {
            self.response_time_root_causes = input;
            self
        }
        /// <p>The revision number of a trace.</p>
        pub fn revision(mut self, input: i32) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The revision number of a trace.</p>
        pub fn set_revision(mut self, input: std::option::Option<i32>) -> Self {
            self.revision = input;
            self
        }
        /// <p>The matched time stamp of a defined event.</p>
        pub fn matched_event_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.matched_event_time = Some(input);
            self
        }
        /// <p>The matched time stamp of a defined event.</p>
        pub fn set_matched_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.matched_event_time = input;
            self
        }
        /// Consumes the builder and constructs a [`TraceSummary`](crate::model::TraceSummary)
        pub fn build(self) -> crate::model::TraceSummary {
            crate::model::TraceSummary {
                id: self.id,
                duration: self.duration,
                response_time: self.response_time,
                has_fault: self.has_fault,
                has_error: self.has_error,
                has_throttle: self.has_throttle,
                is_partial: self.is_partial,
                http: self.http,
                annotations: self.annotations,
                users: self.users,
                service_ids: self.service_ids,
                resource_ar_ns: self.resource_ar_ns,
                instance_ids: self.instance_ids,
                availability_zones: self.availability_zones,
                entry_point: self.entry_point,
                fault_root_causes: self.fault_root_causes,
                error_root_causes: self.error_root_causes,
                response_time_root_causes: self.response_time_root_causes,
                revision: self.revision.unwrap_or_default(),
                matched_event_time: self.matched_event_time,
            }
        }
    }
}
impl TraceSummary {
    /// Creates a new builder-style object to manufacture [`TraceSummary`](crate::model::TraceSummary)
    pub fn builder() -> crate::model::trace_summary::Builder {
        crate::model::trace_summary::Builder::default()
    }
}

/// <p>The root cause information for a response time warning.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseTimeRootCause {
    /// <p>A list of corresponding services. A service identifies a segment and contains a name,
    /// account ID, type, and inferred flag.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::ResponseTimeRootCauseService>>,
    /// <p>A flag that denotes that the root cause impacts the trace client.</p>
    pub client_impacting: std::option::Option<bool>,
}
impl ResponseTimeRootCause {
    /// <p>A list of corresponding services. A service identifies a segment and contains a name,
    /// account ID, type, and inferred flag.</p>
    pub fn services(&self) -> std::option::Option<&[crate::model::ResponseTimeRootCauseService]> {
        self.services.as_deref()
    }
    /// <p>A flag that denotes that the root cause impacts the trace client.</p>
    pub fn client_impacting(&self) -> std::option::Option<bool> {
        self.client_impacting
    }
}
impl std::fmt::Debug for ResponseTimeRootCause {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseTimeRootCause");
        formatter.field("services", &self.services);
        formatter.field("client_impacting", &self.client_impacting);
        formatter.finish()
    }
}
/// See [`ResponseTimeRootCause`](crate::model::ResponseTimeRootCause)
pub mod response_time_root_cause {
    /// A builder for [`ResponseTimeRootCause`](crate::model::ResponseTimeRootCause)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services:
            std::option::Option<std::vec::Vec<crate::model::ResponseTimeRootCauseService>>,
        pub(crate) client_impacting: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>A list of corresponding services. A service identifies a segment and contains a name,
        /// account ID, type, and inferred flag.</p>
        pub fn services(
            mut self,
            input: impl Into<crate::model::ResponseTimeRootCauseService>,
        ) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>A list of corresponding services. A service identifies a segment and contains a name,
        /// account ID, type, and inferred flag.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResponseTimeRootCauseService>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// <p>A flag that denotes that the root cause impacts the trace client.</p>
        pub fn client_impacting(mut self, input: bool) -> Self {
            self.client_impacting = Some(input);
            self
        }
        /// <p>A flag that denotes that the root cause impacts the trace client.</p>
        pub fn set_client_impacting(mut self, input: std::option::Option<bool>) -> Self {
            self.client_impacting = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseTimeRootCause`](crate::model::ResponseTimeRootCause)
        pub fn build(self) -> crate::model::ResponseTimeRootCause {
            crate::model::ResponseTimeRootCause {
                services: self.services,
                client_impacting: self.client_impacting,
            }
        }
    }
}
impl ResponseTimeRootCause {
    /// Creates a new builder-style object to manufacture [`ResponseTimeRootCause`](crate::model::ResponseTimeRootCause)
    pub fn builder() -> crate::model::response_time_root_cause::Builder {
        crate::model::response_time_root_cause::Builder::default()
    }
}

/// <p>A collection of fields identifying the service in a response time warning.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseTimeRootCauseService {
    /// <p>The service name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A collection of associated service names.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type associated to the service.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The account ID associated to the service.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The path of root cause entities found on the service. </p>
    pub entity_path: std::option::Option<std::vec::Vec<crate::model::ResponseTimeRootCauseEntity>>,
    /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
    pub inferred: std::option::Option<bool>,
}
impl ResponseTimeRootCauseService {
    /// <p>The service name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A collection of associated service names.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>The type associated to the service.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The account ID associated to the service.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The path of root cause entities found on the service. </p>
    pub fn entity_path(&self) -> std::option::Option<&[crate::model::ResponseTimeRootCauseEntity]> {
        self.entity_path.as_deref()
    }
    /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
    pub fn inferred(&self) -> std::option::Option<bool> {
        self.inferred
    }
}
impl std::fmt::Debug for ResponseTimeRootCauseService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseTimeRootCauseService");
        formatter.field("name", &self.name);
        formatter.field("names", &self.names);
        formatter.field("r#type", &self.r#type);
        formatter.field("account_id", &self.account_id);
        formatter.field("entity_path", &self.entity_path);
        formatter.field("inferred", &self.inferred);
        formatter.finish()
    }
}
/// See [`ResponseTimeRootCauseService`](crate::model::ResponseTimeRootCauseService)
pub mod response_time_root_cause_service {
    /// A builder for [`ResponseTimeRootCauseService`](crate::model::ResponseTimeRootCauseService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) entity_path:
            std::option::Option<std::vec::Vec<crate::model::ResponseTimeRootCauseEntity>>,
        pub(crate) inferred: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The service name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The service name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A collection of associated service names.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>A collection of associated service names.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The type associated to the service.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type associated to the service.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The account ID associated to the service.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID associated to the service.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `entity_path`.
        ///
        /// To override the contents of this collection use [`set_entity_path`](Self::set_entity_path).
        ///
        /// <p>The path of root cause entities found on the service. </p>
        pub fn entity_path(
            mut self,
            input: impl Into<crate::model::ResponseTimeRootCauseEntity>,
        ) -> Self {
            let mut v = self.entity_path.unwrap_or_default();
            v.push(input.into());
            self.entity_path = Some(v);
            self
        }
        /// <p>The path of root cause entities found on the service. </p>
        pub fn set_entity_path(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResponseTimeRootCauseEntity>>,
        ) -> Self {
            self.entity_path = input;
            self
        }
        /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
        pub fn inferred(mut self, input: bool) -> Self {
            self.inferred = Some(input);
            self
        }
        /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
        pub fn set_inferred(mut self, input: std::option::Option<bool>) -> Self {
            self.inferred = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseTimeRootCauseService`](crate::model::ResponseTimeRootCauseService)
        pub fn build(self) -> crate::model::ResponseTimeRootCauseService {
            crate::model::ResponseTimeRootCauseService {
                name: self.name,
                names: self.names,
                r#type: self.r#type,
                account_id: self.account_id,
                entity_path: self.entity_path,
                inferred: self.inferred,
            }
        }
    }
}
impl ResponseTimeRootCauseService {
    /// Creates a new builder-style object to manufacture [`ResponseTimeRootCauseService`](crate::model::ResponseTimeRootCauseService)
    pub fn builder() -> crate::model::response_time_root_cause_service::Builder {
        crate::model::response_time_root_cause_service::Builder::default()
    }
}

/// <p>A collection of segments and corresponding subsegments associated to a response time
/// warning.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseTimeRootCauseEntity {
    /// <p>The name of the entity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type and messages of the exceptions.</p>
    pub coverage: std::option::Option<f64>,
    /// <p>A flag that denotes a remote subsegment.</p>
    pub remote: std::option::Option<bool>,
}
impl ResponseTimeRootCauseEntity {
    /// <p>The name of the entity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type and messages of the exceptions.</p>
    pub fn coverage(&self) -> std::option::Option<f64> {
        self.coverage
    }
    /// <p>A flag that denotes a remote subsegment.</p>
    pub fn remote(&self) -> std::option::Option<bool> {
        self.remote
    }
}
impl std::fmt::Debug for ResponseTimeRootCauseEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseTimeRootCauseEntity");
        formatter.field("name", &self.name);
        formatter.field("coverage", &self.coverage);
        formatter.field("remote", &self.remote);
        formatter.finish()
    }
}
/// See [`ResponseTimeRootCauseEntity`](crate::model::ResponseTimeRootCauseEntity)
pub mod response_time_root_cause_entity {
    /// A builder for [`ResponseTimeRootCauseEntity`](crate::model::ResponseTimeRootCauseEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) coverage: std::option::Option<f64>,
        pub(crate) remote: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the entity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type and messages of the exceptions.</p>
        pub fn coverage(mut self, input: f64) -> Self {
            self.coverage = Some(input);
            self
        }
        /// <p>The type and messages of the exceptions.</p>
        pub fn set_coverage(mut self, input: std::option::Option<f64>) -> Self {
            self.coverage = input;
            self
        }
        /// <p>A flag that denotes a remote subsegment.</p>
        pub fn remote(mut self, input: bool) -> Self {
            self.remote = Some(input);
            self
        }
        /// <p>A flag that denotes a remote subsegment.</p>
        pub fn set_remote(mut self, input: std::option::Option<bool>) -> Self {
            self.remote = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseTimeRootCauseEntity`](crate::model::ResponseTimeRootCauseEntity)
        pub fn build(self) -> crate::model::ResponseTimeRootCauseEntity {
            crate::model::ResponseTimeRootCauseEntity {
                name: self.name,
                coverage: self.coverage,
                remote: self.remote,
            }
        }
    }
}
impl ResponseTimeRootCauseEntity {
    /// Creates a new builder-style object to manufacture [`ResponseTimeRootCauseEntity`](crate::model::ResponseTimeRootCauseEntity)
    pub fn builder() -> crate::model::response_time_root_cause_entity::Builder {
        crate::model::response_time_root_cause_entity::Builder::default()
    }
}

/// <p>The root cause of a trace summary error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorRootCause {
    /// <p>A list of services corresponding to an error. A service identifies a segment and it
    /// contains a name, account ID, type, and inferred flag.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::ErrorRootCauseService>>,
    /// <p>A flag that denotes that the root cause impacts the trace client.</p>
    pub client_impacting: std::option::Option<bool>,
}
impl ErrorRootCause {
    /// <p>A list of services corresponding to an error. A service identifies a segment and it
    /// contains a name, account ID, type, and inferred flag.</p>
    pub fn services(&self) -> std::option::Option<&[crate::model::ErrorRootCauseService]> {
        self.services.as_deref()
    }
    /// <p>A flag that denotes that the root cause impacts the trace client.</p>
    pub fn client_impacting(&self) -> std::option::Option<bool> {
        self.client_impacting
    }
}
impl std::fmt::Debug for ErrorRootCause {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorRootCause");
        formatter.field("services", &self.services);
        formatter.field("client_impacting", &self.client_impacting);
        formatter.finish()
    }
}
/// See [`ErrorRootCause`](crate::model::ErrorRootCause)
pub mod error_root_cause {
    /// A builder for [`ErrorRootCause`](crate::model::ErrorRootCause)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services:
            std::option::Option<std::vec::Vec<crate::model::ErrorRootCauseService>>,
        pub(crate) client_impacting: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>A list of services corresponding to an error. A service identifies a segment and it
        /// contains a name, account ID, type, and inferred flag.</p>
        pub fn services(mut self, input: impl Into<crate::model::ErrorRootCauseService>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>A list of services corresponding to an error. A service identifies a segment and it
        /// contains a name, account ID, type, and inferred flag.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ErrorRootCauseService>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// <p>A flag that denotes that the root cause impacts the trace client.</p>
        pub fn client_impacting(mut self, input: bool) -> Self {
            self.client_impacting = Some(input);
            self
        }
        /// <p>A flag that denotes that the root cause impacts the trace client.</p>
        pub fn set_client_impacting(mut self, input: std::option::Option<bool>) -> Self {
            self.client_impacting = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorRootCause`](crate::model::ErrorRootCause)
        pub fn build(self) -> crate::model::ErrorRootCause {
            crate::model::ErrorRootCause {
                services: self.services,
                client_impacting: self.client_impacting,
            }
        }
    }
}
impl ErrorRootCause {
    /// Creates a new builder-style object to manufacture [`ErrorRootCause`](crate::model::ErrorRootCause)
    pub fn builder() -> crate::model::error_root_cause::Builder {
        crate::model::error_root_cause::Builder::default()
    }
}

/// <p>A collection of fields identifying the services in a trace summary error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorRootCauseService {
    /// <p>The service name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A collection of associated service names.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type associated to the service.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The account ID associated to the service.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The path of root cause entities found on the service. </p>
    pub entity_path: std::option::Option<std::vec::Vec<crate::model::ErrorRootCauseEntity>>,
    /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
    pub inferred: std::option::Option<bool>,
}
impl ErrorRootCauseService {
    /// <p>The service name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A collection of associated service names.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>The type associated to the service.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The account ID associated to the service.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The path of root cause entities found on the service. </p>
    pub fn entity_path(&self) -> std::option::Option<&[crate::model::ErrorRootCauseEntity]> {
        self.entity_path.as_deref()
    }
    /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
    pub fn inferred(&self) -> std::option::Option<bool> {
        self.inferred
    }
}
impl std::fmt::Debug for ErrorRootCauseService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorRootCauseService");
        formatter.field("name", &self.name);
        formatter.field("names", &self.names);
        formatter.field("r#type", &self.r#type);
        formatter.field("account_id", &self.account_id);
        formatter.field("entity_path", &self.entity_path);
        formatter.field("inferred", &self.inferred);
        formatter.finish()
    }
}
/// See [`ErrorRootCauseService`](crate::model::ErrorRootCauseService)
pub mod error_root_cause_service {
    /// A builder for [`ErrorRootCauseService`](crate::model::ErrorRootCauseService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) entity_path:
            std::option::Option<std::vec::Vec<crate::model::ErrorRootCauseEntity>>,
        pub(crate) inferred: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The service name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The service name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A collection of associated service names.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>A collection of associated service names.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The type associated to the service.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type associated to the service.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The account ID associated to the service.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID associated to the service.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `entity_path`.
        ///
        /// To override the contents of this collection use [`set_entity_path`](Self::set_entity_path).
        ///
        /// <p>The path of root cause entities found on the service. </p>
        pub fn entity_path(mut self, input: impl Into<crate::model::ErrorRootCauseEntity>) -> Self {
            let mut v = self.entity_path.unwrap_or_default();
            v.push(input.into());
            self.entity_path = Some(v);
            self
        }
        /// <p>The path of root cause entities found on the service. </p>
        pub fn set_entity_path(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ErrorRootCauseEntity>>,
        ) -> Self {
            self.entity_path = input;
            self
        }
        /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
        pub fn inferred(mut self, input: bool) -> Self {
            self.inferred = Some(input);
            self
        }
        /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
        pub fn set_inferred(mut self, input: std::option::Option<bool>) -> Self {
            self.inferred = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorRootCauseService`](crate::model::ErrorRootCauseService)
        pub fn build(self) -> crate::model::ErrorRootCauseService {
            crate::model::ErrorRootCauseService {
                name: self.name,
                names: self.names,
                r#type: self.r#type,
                account_id: self.account_id,
                entity_path: self.entity_path,
                inferred: self.inferred,
            }
        }
    }
}
impl ErrorRootCauseService {
    /// Creates a new builder-style object to manufacture [`ErrorRootCauseService`](crate::model::ErrorRootCauseService)
    pub fn builder() -> crate::model::error_root_cause_service::Builder {
        crate::model::error_root_cause_service::Builder::default()
    }
}

/// <p>A collection of segments and corresponding subsegments associated to a trace summary
/// error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorRootCauseEntity {
    /// <p>The name of the entity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The types and messages of the exceptions.</p>
    pub exceptions: std::option::Option<std::vec::Vec<crate::model::RootCauseException>>,
    /// <p>A flag that denotes a remote subsegment.</p>
    pub remote: std::option::Option<bool>,
}
impl ErrorRootCauseEntity {
    /// <p>The name of the entity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The types and messages of the exceptions.</p>
    pub fn exceptions(&self) -> std::option::Option<&[crate::model::RootCauseException]> {
        self.exceptions.as_deref()
    }
    /// <p>A flag that denotes a remote subsegment.</p>
    pub fn remote(&self) -> std::option::Option<bool> {
        self.remote
    }
}
impl std::fmt::Debug for ErrorRootCauseEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorRootCauseEntity");
        formatter.field("name", &self.name);
        formatter.field("exceptions", &self.exceptions);
        formatter.field("remote", &self.remote);
        formatter.finish()
    }
}
/// See [`ErrorRootCauseEntity`](crate::model::ErrorRootCauseEntity)
pub mod error_root_cause_entity {
    /// A builder for [`ErrorRootCauseEntity`](crate::model::ErrorRootCauseEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) exceptions: std::option::Option<std::vec::Vec<crate::model::RootCauseException>>,
        pub(crate) remote: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the entity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `exceptions`.
        ///
        /// To override the contents of this collection use [`set_exceptions`](Self::set_exceptions).
        ///
        /// <p>The types and messages of the exceptions.</p>
        pub fn exceptions(mut self, input: impl Into<crate::model::RootCauseException>) -> Self {
            let mut v = self.exceptions.unwrap_or_default();
            v.push(input.into());
            self.exceptions = Some(v);
            self
        }
        /// <p>The types and messages of the exceptions.</p>
        pub fn set_exceptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RootCauseException>>,
        ) -> Self {
            self.exceptions = input;
            self
        }
        /// <p>A flag that denotes a remote subsegment.</p>
        pub fn remote(mut self, input: bool) -> Self {
            self.remote = Some(input);
            self
        }
        /// <p>A flag that denotes a remote subsegment.</p>
        pub fn set_remote(mut self, input: std::option::Option<bool>) -> Self {
            self.remote = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorRootCauseEntity`](crate::model::ErrorRootCauseEntity)
        pub fn build(self) -> crate::model::ErrorRootCauseEntity {
            crate::model::ErrorRootCauseEntity {
                name: self.name,
                exceptions: self.exceptions,
                remote: self.remote,
            }
        }
    }
}
impl ErrorRootCauseEntity {
    /// Creates a new builder-style object to manufacture [`ErrorRootCauseEntity`](crate::model::ErrorRootCauseEntity)
    pub fn builder() -> crate::model::error_root_cause_entity::Builder {
        crate::model::error_root_cause_entity::Builder::default()
    }
}

/// <p>The exception associated with a root cause.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RootCauseException {
    /// <p>The name of the exception.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The message of the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl RootCauseException {
    /// <p>The name of the exception.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The message of the exception.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for RootCauseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RootCauseException");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`RootCauseException`](crate::model::RootCauseException)
pub mod root_cause_exception {
    /// A builder for [`RootCauseException`](crate::model::RootCauseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the exception.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the exception.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The message of the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message of the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RootCauseException`](crate::model::RootCauseException)
        pub fn build(self) -> crate::model::RootCauseException {
            crate::model::RootCauseException {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl RootCauseException {
    /// Creates a new builder-style object to manufacture [`RootCauseException`](crate::model::RootCauseException)
    pub fn builder() -> crate::model::root_cause_exception::Builder {
        crate::model::root_cause_exception::Builder::default()
    }
}

/// <p>The root cause information for a trace summary fault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaultRootCause {
    /// <p>A list of corresponding services. A service identifies a segment and it contains a
    /// name, account ID, type, and inferred flag.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::FaultRootCauseService>>,
    /// <p>A flag that denotes that the root cause impacts the trace client.</p>
    pub client_impacting: std::option::Option<bool>,
}
impl FaultRootCause {
    /// <p>A list of corresponding services. A service identifies a segment and it contains a
    /// name, account ID, type, and inferred flag.</p>
    pub fn services(&self) -> std::option::Option<&[crate::model::FaultRootCauseService]> {
        self.services.as_deref()
    }
    /// <p>A flag that denotes that the root cause impacts the trace client.</p>
    pub fn client_impacting(&self) -> std::option::Option<bool> {
        self.client_impacting
    }
}
impl std::fmt::Debug for FaultRootCause {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaultRootCause");
        formatter.field("services", &self.services);
        formatter.field("client_impacting", &self.client_impacting);
        formatter.finish()
    }
}
/// See [`FaultRootCause`](crate::model::FaultRootCause)
pub mod fault_root_cause {
    /// A builder for [`FaultRootCause`](crate::model::FaultRootCause)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services:
            std::option::Option<std::vec::Vec<crate::model::FaultRootCauseService>>,
        pub(crate) client_impacting: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>A list of corresponding services. A service identifies a segment and it contains a
        /// name, account ID, type, and inferred flag.</p>
        pub fn services(mut self, input: impl Into<crate::model::FaultRootCauseService>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>A list of corresponding services. A service identifies a segment and it contains a
        /// name, account ID, type, and inferred flag.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FaultRootCauseService>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// <p>A flag that denotes that the root cause impacts the trace client.</p>
        pub fn client_impacting(mut self, input: bool) -> Self {
            self.client_impacting = Some(input);
            self
        }
        /// <p>A flag that denotes that the root cause impacts the trace client.</p>
        pub fn set_client_impacting(mut self, input: std::option::Option<bool>) -> Self {
            self.client_impacting = input;
            self
        }
        /// Consumes the builder and constructs a [`FaultRootCause`](crate::model::FaultRootCause)
        pub fn build(self) -> crate::model::FaultRootCause {
            crate::model::FaultRootCause {
                services: self.services,
                client_impacting: self.client_impacting,
            }
        }
    }
}
impl FaultRootCause {
    /// Creates a new builder-style object to manufacture [`FaultRootCause`](crate::model::FaultRootCause)
    pub fn builder() -> crate::model::fault_root_cause::Builder {
        crate::model::fault_root_cause::Builder::default()
    }
}

/// <p>A collection of fields identifying the services in a trace summary fault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaultRootCauseService {
    /// <p>The service name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A collection of associated service names.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type associated to the service.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The account ID associated to the service.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The path of root cause entities found on the service. </p>
    pub entity_path: std::option::Option<std::vec::Vec<crate::model::FaultRootCauseEntity>>,
    /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
    pub inferred: std::option::Option<bool>,
}
impl FaultRootCauseService {
    /// <p>The service name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A collection of associated service names.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>The type associated to the service.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The account ID associated to the service.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The path of root cause entities found on the service. </p>
    pub fn entity_path(&self) -> std::option::Option<&[crate::model::FaultRootCauseEntity]> {
        self.entity_path.as_deref()
    }
    /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
    pub fn inferred(&self) -> std::option::Option<bool> {
        self.inferred
    }
}
impl std::fmt::Debug for FaultRootCauseService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaultRootCauseService");
        formatter.field("name", &self.name);
        formatter.field("names", &self.names);
        formatter.field("r#type", &self.r#type);
        formatter.field("account_id", &self.account_id);
        formatter.field("entity_path", &self.entity_path);
        formatter.field("inferred", &self.inferred);
        formatter.finish()
    }
}
/// See [`FaultRootCauseService`](crate::model::FaultRootCauseService)
pub mod fault_root_cause_service {
    /// A builder for [`FaultRootCauseService`](crate::model::FaultRootCauseService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) entity_path:
            std::option::Option<std::vec::Vec<crate::model::FaultRootCauseEntity>>,
        pub(crate) inferred: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The service name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The service name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A collection of associated service names.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>A collection of associated service names.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The type associated to the service.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type associated to the service.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The account ID associated to the service.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID associated to the service.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `entity_path`.
        ///
        /// To override the contents of this collection use [`set_entity_path`](Self::set_entity_path).
        ///
        /// <p>The path of root cause entities found on the service. </p>
        pub fn entity_path(mut self, input: impl Into<crate::model::FaultRootCauseEntity>) -> Self {
            let mut v = self.entity_path.unwrap_or_default();
            v.push(input.into());
            self.entity_path = Some(v);
            self
        }
        /// <p>The path of root cause entities found on the service. </p>
        pub fn set_entity_path(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FaultRootCauseEntity>>,
        ) -> Self {
            self.entity_path = input;
            self
        }
        /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
        pub fn inferred(mut self, input: bool) -> Self {
            self.inferred = Some(input);
            self
        }
        /// <p>A Boolean value indicating if the service is inferred from the trace.</p>
        pub fn set_inferred(mut self, input: std::option::Option<bool>) -> Self {
            self.inferred = input;
            self
        }
        /// Consumes the builder and constructs a [`FaultRootCauseService`](crate::model::FaultRootCauseService)
        pub fn build(self) -> crate::model::FaultRootCauseService {
            crate::model::FaultRootCauseService {
                name: self.name,
                names: self.names,
                r#type: self.r#type,
                account_id: self.account_id,
                entity_path: self.entity_path,
                inferred: self.inferred,
            }
        }
    }
}
impl FaultRootCauseService {
    /// Creates a new builder-style object to manufacture [`FaultRootCauseService`](crate::model::FaultRootCauseService)
    pub fn builder() -> crate::model::fault_root_cause_service::Builder {
        crate::model::fault_root_cause_service::Builder::default()
    }
}

/// <p>A collection of segments and corresponding subsegments associated to a trace summary
/// fault error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaultRootCauseEntity {
    /// <p>The name of the entity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The types and messages of the exceptions.</p>
    pub exceptions: std::option::Option<std::vec::Vec<crate::model::RootCauseException>>,
    /// <p>A flag that denotes a remote subsegment.</p>
    pub remote: std::option::Option<bool>,
}
impl FaultRootCauseEntity {
    /// <p>The name of the entity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The types and messages of the exceptions.</p>
    pub fn exceptions(&self) -> std::option::Option<&[crate::model::RootCauseException]> {
        self.exceptions.as_deref()
    }
    /// <p>A flag that denotes a remote subsegment.</p>
    pub fn remote(&self) -> std::option::Option<bool> {
        self.remote
    }
}
impl std::fmt::Debug for FaultRootCauseEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaultRootCauseEntity");
        formatter.field("name", &self.name);
        formatter.field("exceptions", &self.exceptions);
        formatter.field("remote", &self.remote);
        formatter.finish()
    }
}
/// See [`FaultRootCauseEntity`](crate::model::FaultRootCauseEntity)
pub mod fault_root_cause_entity {
    /// A builder for [`FaultRootCauseEntity`](crate::model::FaultRootCauseEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) exceptions: std::option::Option<std::vec::Vec<crate::model::RootCauseException>>,
        pub(crate) remote: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the entity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `exceptions`.
        ///
        /// To override the contents of this collection use [`set_exceptions`](Self::set_exceptions).
        ///
        /// <p>The types and messages of the exceptions.</p>
        pub fn exceptions(mut self, input: impl Into<crate::model::RootCauseException>) -> Self {
            let mut v = self.exceptions.unwrap_or_default();
            v.push(input.into());
            self.exceptions = Some(v);
            self
        }
        /// <p>The types and messages of the exceptions.</p>
        pub fn set_exceptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RootCauseException>>,
        ) -> Self {
            self.exceptions = input;
            self
        }
        /// <p>A flag that denotes a remote subsegment.</p>
        pub fn remote(mut self, input: bool) -> Self {
            self.remote = Some(input);
            self
        }
        /// <p>A flag that denotes a remote subsegment.</p>
        pub fn set_remote(mut self, input: std::option::Option<bool>) -> Self {
            self.remote = input;
            self
        }
        /// Consumes the builder and constructs a [`FaultRootCauseEntity`](crate::model::FaultRootCauseEntity)
        pub fn build(self) -> crate::model::FaultRootCauseEntity {
            crate::model::FaultRootCauseEntity {
                name: self.name,
                exceptions: self.exceptions,
                remote: self.remote,
            }
        }
    }
}
impl FaultRootCauseEntity {
    /// Creates a new builder-style object to manufacture [`FaultRootCauseEntity`](crate::model::FaultRootCauseEntity)
    pub fn builder() -> crate::model::fault_root_cause_entity::Builder {
        crate::model::fault_root_cause_entity::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceId {
    /// <p></p>
    pub name: std::option::Option<std::string::String>,
    /// <p></p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p></p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
}
impl ServiceId {
    /// <p></p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p></p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p></p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ServiceId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceId");
        formatter.field("name", &self.name);
        formatter.field("names", &self.names);
        formatter.field("account_id", &self.account_id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ServiceId`](crate::model::ServiceId)
pub mod service_id {
    /// A builder for [`ServiceId`](crate::model::ServiceId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p></p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p></p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p></p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceId`](crate::model::ServiceId)
        pub fn build(self) -> crate::model::ServiceId {
            crate::model::ServiceId {
                name: self.name,
                names: self.names,
                account_id: self.account_id,
                r#type: self.r#type,
            }
        }
    }
}
impl ServiceId {
    /// Creates a new builder-style object to manufacture [`ServiceId`](crate::model::ServiceId)
    pub fn builder() -> crate::model::service_id::Builder {
        crate::model::service_id::Builder::default()
    }
}

/// <p>A list of Availability Zones corresponding to the segments in a trace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZoneDetail {
    /// <p>The name of a corresponding Availability Zone.</p>
    pub name: std::option::Option<std::string::String>,
}
impl AvailabilityZoneDetail {
    /// <p>The name of a corresponding Availability Zone.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for AvailabilityZoneDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZoneDetail");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AvailabilityZoneDetail`](crate::model::AvailabilityZoneDetail)
pub mod availability_zone_detail {
    /// A builder for [`AvailabilityZoneDetail`](crate::model::AvailabilityZoneDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a corresponding Availability Zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a corresponding Availability Zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZoneDetail`](crate::model::AvailabilityZoneDetail)
        pub fn build(self) -> crate::model::AvailabilityZoneDetail {
            crate::model::AvailabilityZoneDetail { name: self.name }
        }
    }
}
impl AvailabilityZoneDetail {
    /// Creates a new builder-style object to manufacture [`AvailabilityZoneDetail`](crate::model::AvailabilityZoneDetail)
    pub fn builder() -> crate::model::availability_zone_detail::Builder {
        crate::model::availability_zone_detail::Builder::default()
    }
}

/// <p>A list of EC2 instance IDs corresponding to the segments in a trace. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceIdDetail {
    /// <p>The ID of a corresponding EC2 instance.</p>
    pub id: std::option::Option<std::string::String>,
}
impl InstanceIdDetail {
    /// <p>The ID of a corresponding EC2 instance.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for InstanceIdDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceIdDetail");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`InstanceIdDetail`](crate::model::InstanceIdDetail)
pub mod instance_id_detail {
    /// A builder for [`InstanceIdDetail`](crate::model::InstanceIdDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a corresponding EC2 instance.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a corresponding EC2 instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceIdDetail`](crate::model::InstanceIdDetail)
        pub fn build(self) -> crate::model::InstanceIdDetail {
            crate::model::InstanceIdDetail { id: self.id }
        }
    }
}
impl InstanceIdDetail {
    /// Creates a new builder-style object to manufacture [`InstanceIdDetail`](crate::model::InstanceIdDetail)
    pub fn builder() -> crate::model::instance_id_detail::Builder {
        crate::model::instance_id_detail::Builder::default()
    }
}

/// <p>A list of resources ARNs corresponding to the segments in a trace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceArnDetail {
    /// <p>The ARN of a corresponding resource.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl ResourceArnDetail {
    /// <p>The ARN of a corresponding resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ResourceArnDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceArnDetail");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ResourceArnDetail`](crate::model::ResourceArnDetail)
pub mod resource_arn_detail {
    /// A builder for [`ResourceArnDetail`](crate::model::ResourceArnDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a corresponding resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of a corresponding resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceArnDetail`](crate::model::ResourceArnDetail)
        pub fn build(self) -> crate::model::ResourceArnDetail {
            crate::model::ResourceArnDetail { arn: self.arn }
        }
    }
}
impl ResourceArnDetail {
    /// Creates a new builder-style object to manufacture [`ResourceArnDetail`](crate::model::ResourceArnDetail)
    pub fn builder() -> crate::model::resource_arn_detail::Builder {
        crate::model::resource_arn_detail::Builder::default()
    }
}

/// <p>Information about a user recorded in segment documents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TraceUser {
    /// <p>The user's name.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Services that the user's request hit.</p>
    pub service_ids: std::option::Option<std::vec::Vec<crate::model::ServiceId>>,
}
impl TraceUser {
    /// <p>The user's name.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>Services that the user's request hit.</p>
    pub fn service_ids(&self) -> std::option::Option<&[crate::model::ServiceId]> {
        self.service_ids.as_deref()
    }
}
impl std::fmt::Debug for TraceUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TraceUser");
        formatter.field("user_name", &self.user_name);
        formatter.field("service_ids", &self.service_ids);
        formatter.finish()
    }
}
/// See [`TraceUser`](crate::model::TraceUser)
pub mod trace_user {
    /// A builder for [`TraceUser`](crate::model::TraceUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) service_ids: std::option::Option<std::vec::Vec<crate::model::ServiceId>>,
    }
    impl Builder {
        /// <p>The user's name.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user's name.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Appends an item to `service_ids`.
        ///
        /// To override the contents of this collection use [`set_service_ids`](Self::set_service_ids).
        ///
        /// <p>Services that the user's request hit.</p>
        pub fn service_ids(mut self, input: impl Into<crate::model::ServiceId>) -> Self {
            let mut v = self.service_ids.unwrap_or_default();
            v.push(input.into());
            self.service_ids = Some(v);
            self
        }
        /// <p>Services that the user's request hit.</p>
        pub fn set_service_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceId>>,
        ) -> Self {
            self.service_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`TraceUser`](crate::model::TraceUser)
        pub fn build(self) -> crate::model::TraceUser {
            crate::model::TraceUser {
                user_name: self.user_name,
                service_ids: self.service_ids,
            }
        }
    }
}
impl TraceUser {
    /// Creates a new builder-style object to manufacture [`TraceUser`](crate::model::TraceUser)
    pub fn builder() -> crate::model::trace_user::Builder {
        crate::model::trace_user::Builder::default()
    }
}

/// <p>Information about a segment annotation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValueWithServiceIds {
    /// <p>Values of the annotation.</p>
    pub annotation_value: std::option::Option<crate::model::AnnotationValue>,
    /// <p>Services to which the annotation applies.</p>
    pub service_ids: std::option::Option<std::vec::Vec<crate::model::ServiceId>>,
}
impl ValueWithServiceIds {
    /// <p>Values of the annotation.</p>
    pub fn annotation_value(&self) -> std::option::Option<&crate::model::AnnotationValue> {
        self.annotation_value.as_ref()
    }
    /// <p>Services to which the annotation applies.</p>
    pub fn service_ids(&self) -> std::option::Option<&[crate::model::ServiceId]> {
        self.service_ids.as_deref()
    }
}
impl std::fmt::Debug for ValueWithServiceIds {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValueWithServiceIds");
        formatter.field("annotation_value", &self.annotation_value);
        formatter.field("service_ids", &self.service_ids);
        formatter.finish()
    }
}
/// See [`ValueWithServiceIds`](crate::model::ValueWithServiceIds)
pub mod value_with_service_ids {
    /// A builder for [`ValueWithServiceIds`](crate::model::ValueWithServiceIds)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) annotation_value: std::option::Option<crate::model::AnnotationValue>,
        pub(crate) service_ids: std::option::Option<std::vec::Vec<crate::model::ServiceId>>,
    }
    impl Builder {
        /// <p>Values of the annotation.</p>
        pub fn annotation_value(mut self, input: crate::model::AnnotationValue) -> Self {
            self.annotation_value = Some(input);
            self
        }
        /// <p>Values of the annotation.</p>
        pub fn set_annotation_value(
            mut self,
            input: std::option::Option<crate::model::AnnotationValue>,
        ) -> Self {
            self.annotation_value = input;
            self
        }
        /// Appends an item to `service_ids`.
        ///
        /// To override the contents of this collection use [`set_service_ids`](Self::set_service_ids).
        ///
        /// <p>Services to which the annotation applies.</p>
        pub fn service_ids(mut self, input: impl Into<crate::model::ServiceId>) -> Self {
            let mut v = self.service_ids.unwrap_or_default();
            v.push(input.into());
            self.service_ids = Some(v);
            self
        }
        /// <p>Services to which the annotation applies.</p>
        pub fn set_service_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceId>>,
        ) -> Self {
            self.service_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ValueWithServiceIds`](crate::model::ValueWithServiceIds)
        pub fn build(self) -> crate::model::ValueWithServiceIds {
            crate::model::ValueWithServiceIds {
                annotation_value: self.annotation_value,
                service_ids: self.service_ids,
            }
        }
    }
}
impl ValueWithServiceIds {
    /// Creates a new builder-style object to manufacture [`ValueWithServiceIds`](crate::model::ValueWithServiceIds)
    pub fn builder() -> crate::model::value_with_service_ids::Builder {
        crate::model::value_with_service_ids::Builder::default()
    }
}

/// <p>Value of a segment annotation. Has one of three value types: Number, Boolean, or String.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AnnotationValue {
    /// <p>Value for a Boolean annotation.</p>
    BooleanValue(bool),
    /// <p>Value for a Number annotation.</p>
    NumberValue(f64),
    /// <p>Value for a String annotation.</p>
    StringValue(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AnnotationValue {
    /// Tries to convert the enum instance into [`BooleanValue`](crate::model::AnnotationValue::BooleanValue), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_boolean_value(&self) -> std::result::Result<&bool, &Self> {
        if let AnnotationValue::BooleanValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`BooleanValue`](crate::model::AnnotationValue::BooleanValue).
    pub fn is_boolean_value(&self) -> bool {
        self.as_boolean_value().is_ok()
    }
    /// Tries to convert the enum instance into [`NumberValue`](crate::model::AnnotationValue::NumberValue), extracting the inner [`f64`](f64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_number_value(&self) -> std::result::Result<&f64, &Self> {
        if let AnnotationValue::NumberValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`NumberValue`](crate::model::AnnotationValue::NumberValue).
    pub fn is_number_value(&self) -> bool {
        self.as_number_value().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValue`](crate::model::AnnotationValue::StringValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AnnotationValue::StringValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`StringValue`](crate::model::AnnotationValue::StringValue).
    pub fn is_string_value(&self) -> bool {
        self.as_string_value().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Information about an HTTP request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Http {
    /// <p>The request URL.</p>
    pub http_url: std::option::Option<std::string::String>,
    /// <p>The response status.</p>
    pub http_status: std::option::Option<i32>,
    /// <p>The request method.</p>
    pub http_method: std::option::Option<std::string::String>,
    /// <p>The request's user agent string.</p>
    pub user_agent: std::option::Option<std::string::String>,
    /// <p>The IP address of the requestor.</p>
    pub client_ip: std::option::Option<std::string::String>,
}
impl Http {
    /// <p>The request URL.</p>
    pub fn http_url(&self) -> std::option::Option<&str> {
        self.http_url.as_deref()
    }
    /// <p>The response status.</p>
    pub fn http_status(&self) -> std::option::Option<i32> {
        self.http_status
    }
    /// <p>The request method.</p>
    pub fn http_method(&self) -> std::option::Option<&str> {
        self.http_method.as_deref()
    }
    /// <p>The request's user agent string.</p>
    pub fn user_agent(&self) -> std::option::Option<&str> {
        self.user_agent.as_deref()
    }
    /// <p>The IP address of the requestor.</p>
    pub fn client_ip(&self) -> std::option::Option<&str> {
        self.client_ip.as_deref()
    }
}
impl std::fmt::Debug for Http {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Http");
        formatter.field("http_url", &self.http_url);
        formatter.field("http_status", &self.http_status);
        formatter.field("http_method", &self.http_method);
        formatter.field("user_agent", &self.user_agent);
        formatter.field("client_ip", &self.client_ip);
        formatter.finish()
    }
}
/// See [`Http`](crate::model::Http)
pub mod http {
    /// A builder for [`Http`](crate::model::Http)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_url: std::option::Option<std::string::String>,
        pub(crate) http_status: std::option::Option<i32>,
        pub(crate) http_method: std::option::Option<std::string::String>,
        pub(crate) user_agent: std::option::Option<std::string::String>,
        pub(crate) client_ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request URL.</p>
        pub fn http_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_url = Some(input.into());
            self
        }
        /// <p>The request URL.</p>
        pub fn set_http_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_url = input;
            self
        }
        /// <p>The response status.</p>
        pub fn http_status(mut self, input: i32) -> Self {
            self.http_status = Some(input);
            self
        }
        /// <p>The response status.</p>
        pub fn set_http_status(mut self, input: std::option::Option<i32>) -> Self {
            self.http_status = input;
            self
        }
        /// <p>The request method.</p>
        pub fn http_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_method = Some(input.into());
            self
        }
        /// <p>The request method.</p>
        pub fn set_http_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The request's user agent string.</p>
        pub fn user_agent(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_agent = Some(input.into());
            self
        }
        /// <p>The request's user agent string.</p>
        pub fn set_user_agent(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_agent = input;
            self
        }
        /// <p>The IP address of the requestor.</p>
        pub fn client_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_ip = Some(input.into());
            self
        }
        /// <p>The IP address of the requestor.</p>
        pub fn set_client_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`Http`](crate::model::Http)
        pub fn build(self) -> crate::model::Http {
            crate::model::Http {
                http_url: self.http_url,
                http_status: self.http_status,
                http_method: self.http_method,
                user_agent: self.user_agent,
                client_ip: self.client_ip,
            }
        }
    }
}
impl Http {
    /// Creates a new builder-style object to manufacture [`Http`](crate::model::Http)
    pub fn builder() -> crate::model::http::Builder {
        crate::model::http::Builder::default()
    }
}

/// <p>The name and value of a sampling rule to apply to a trace summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamplingStrategy {
    /// <p>The name of a sampling rule.</p>
    pub name: std::option::Option<crate::model::SamplingStrategyName>,
    /// <p>The value of a sampling rule.</p>
    pub value: std::option::Option<f64>,
}
impl SamplingStrategy {
    /// <p>The name of a sampling rule.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::SamplingStrategyName> {
        self.name.as_ref()
    }
    /// <p>The value of a sampling rule.</p>
    pub fn value(&self) -> std::option::Option<f64> {
        self.value
    }
}
impl std::fmt::Debug for SamplingStrategy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamplingStrategy");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SamplingStrategy`](crate::model::SamplingStrategy)
pub mod sampling_strategy {
    /// A builder for [`SamplingStrategy`](crate::model::SamplingStrategy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SamplingStrategyName>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of a sampling rule.</p>
        pub fn name(mut self, input: crate::model::SamplingStrategyName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of a sampling rule.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SamplingStrategyName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of a sampling rule.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of a sampling rule.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SamplingStrategy`](crate::model::SamplingStrategy)
        pub fn build(self) -> crate::model::SamplingStrategy {
            crate::model::SamplingStrategy {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl SamplingStrategy {
    /// Creates a new builder-style object to manufacture [`SamplingStrategy`](crate::model::SamplingStrategy)
    pub fn builder() -> crate::model::sampling_strategy::Builder {
        crate::model::sampling_strategy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SamplingStrategyName {
    #[allow(missing_docs)] // documentation missing in model
    FixedRate,
    #[allow(missing_docs)] // documentation missing in model
    PartialScan,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SamplingStrategyName {
    fn from(s: &str) -> Self {
        match s {
            "FixedRate" => SamplingStrategyName::FixedRate,
            "PartialScan" => SamplingStrategyName::PartialScan,
            other => SamplingStrategyName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SamplingStrategyName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SamplingStrategyName::from(s))
    }
}
impl SamplingStrategyName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SamplingStrategyName::FixedRate => "FixedRate",
            SamplingStrategyName::PartialScan => "PartialScan",
            SamplingStrategyName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FixedRate", "PartialScan"]
    }
}
impl AsRef<str> for SamplingStrategyName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimeRangeType {
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    TraceId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimeRangeType {
    fn from(s: &str) -> Self {
        match s {
            "Event" => TimeRangeType::Event,
            "TraceId" => TimeRangeType::TraceId,
            other => TimeRangeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimeRangeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimeRangeType::from(s))
    }
}
impl TimeRangeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimeRangeType::Event => "Event",
            TimeRangeType::TraceId => "TraceId",
            TimeRangeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Event", "TraceId"]
    }
}
impl AsRef<str> for TimeRangeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an application that processed requests, users that made requests, or downstream services,
/// resources, and applications that an application used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Service {
    /// <p>Identifier for the service. Unique within the service map.</p>
    pub reference_id: std::option::Option<i32>,
    /// <p>The canonical name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of names for the service, including the canonical name.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates that the service was the first service to process a request.</p>
    pub root: std::option::Option<bool>,
    /// <p>Identifier of the Amazon Web Services account in which the service runs.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The type of service.</p>
    /// <ul>
    /// <li>
    /// <p>Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, <code>AWS::EC2::Instance</code> for an
    /// application running on Amazon EC2 or <code>AWS::DynamoDB::Table</code> for an Amazon DynamoDB table that the
    /// application used.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, <code>AWS::DynamoDB</code>
    /// for downstream calls to Amazon DynamoDB that didn't target a specific table.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>client</code> - Represents the clients that sent requests to a root
    /// service.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>remote</code> - A downstream service of indeterminate type.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The service's state.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The start time of the first segment that the service generated.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end time of the last segment that the service generated.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Connections to downstream services.</p>
    pub edges: std::option::Option<std::vec::Vec<crate::model::Edge>>,
    /// <p>Aggregated statistics for the service.</p>
    pub summary_statistics: std::option::Option<crate::model::ServiceStatistics>,
    /// <p>A histogram that maps the spread of service durations.</p>
    pub duration_histogram: std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
    /// <p>A histogram that maps the spread of service response times.</p>
    pub response_time_histogram: std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
}
impl Service {
    /// <p>Identifier for the service. Unique within the service map.</p>
    pub fn reference_id(&self) -> std::option::Option<i32> {
        self.reference_id
    }
    /// <p>The canonical name of the service.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of names for the service, including the canonical name.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>Indicates that the service was the first service to process a request.</p>
    pub fn root(&self) -> std::option::Option<bool> {
        self.root
    }
    /// <p>Identifier of the Amazon Web Services account in which the service runs.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The type of service.</p>
    /// <ul>
    /// <li>
    /// <p>Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, <code>AWS::EC2::Instance</code> for an
    /// application running on Amazon EC2 or <code>AWS::DynamoDB::Table</code> for an Amazon DynamoDB table that the
    /// application used.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, <code>AWS::DynamoDB</code>
    /// for downstream calls to Amazon DynamoDB that didn't target a specific table.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>client</code> - Represents the clients that sent requests to a root
    /// service.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>remote</code> - A downstream service of indeterminate type.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The service's state.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>The start time of the first segment that the service generated.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The end time of the last segment that the service generated.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>Connections to downstream services.</p>
    pub fn edges(&self) -> std::option::Option<&[crate::model::Edge]> {
        self.edges.as_deref()
    }
    /// <p>Aggregated statistics for the service.</p>
    pub fn summary_statistics(&self) -> std::option::Option<&crate::model::ServiceStatistics> {
        self.summary_statistics.as_ref()
    }
    /// <p>A histogram that maps the spread of service durations.</p>
    pub fn duration_histogram(&self) -> std::option::Option<&[crate::model::HistogramEntry]> {
        self.duration_histogram.as_deref()
    }
    /// <p>A histogram that maps the spread of service response times.</p>
    pub fn response_time_histogram(&self) -> std::option::Option<&[crate::model::HistogramEntry]> {
        self.response_time_histogram.as_deref()
    }
}
impl std::fmt::Debug for Service {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Service");
        formatter.field("reference_id", &self.reference_id);
        formatter.field("name", &self.name);
        formatter.field("names", &self.names);
        formatter.field("root", &self.root);
        formatter.field("account_id", &self.account_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("state", &self.state);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("edges", &self.edges);
        formatter.field("summary_statistics", &self.summary_statistics);
        formatter.field("duration_histogram", &self.duration_histogram);
        formatter.field("response_time_histogram", &self.response_time_histogram);
        formatter.finish()
    }
}
/// See [`Service`](crate::model::Service)
pub mod service {
    /// A builder for [`Service`](crate::model::Service)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reference_id: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) root: std::option::Option<bool>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) edges: std::option::Option<std::vec::Vec<crate::model::Edge>>,
        pub(crate) summary_statistics: std::option::Option<crate::model::ServiceStatistics>,
        pub(crate) duration_histogram:
            std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
        pub(crate) response_time_histogram:
            std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
    }
    impl Builder {
        /// <p>Identifier for the service. Unique within the service map.</p>
        pub fn reference_id(mut self, input: i32) -> Self {
            self.reference_id = Some(input);
            self
        }
        /// <p>Identifier for the service. Unique within the service map.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<i32>) -> Self {
            self.reference_id = input;
            self
        }
        /// <p>The canonical name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The canonical name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A list of names for the service, including the canonical name.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>A list of names for the service, including the canonical name.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>Indicates that the service was the first service to process a request.</p>
        pub fn root(mut self, input: bool) -> Self {
            self.root = Some(input);
            self
        }
        /// <p>Indicates that the service was the first service to process a request.</p>
        pub fn set_root(mut self, input: std::option::Option<bool>) -> Self {
            self.root = input;
            self
        }
        /// <p>Identifier of the Amazon Web Services account in which the service runs.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>Identifier of the Amazon Web Services account in which the service runs.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The type of service.</p>
        /// <ul>
        /// <li>
        /// <p>Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, <code>AWS::EC2::Instance</code> for an
        /// application running on Amazon EC2 or <code>AWS::DynamoDB::Table</code> for an Amazon DynamoDB table that the
        /// application used.</p>
        /// </li>
        /// <li>
        /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, <code>AWS::DynamoDB</code>
        /// for downstream calls to Amazon DynamoDB that didn't target a specific table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client</code> - Represents the clients that sent requests to a root
        /// service.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>remote</code> - A downstream service of indeterminate type.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of service.</p>
        /// <ul>
        /// <li>
        /// <p>Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, <code>AWS::EC2::Instance</code> for an
        /// application running on Amazon EC2 or <code>AWS::DynamoDB::Table</code> for an Amazon DynamoDB table that the
        /// application used.</p>
        /// </li>
        /// <li>
        /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, <code>AWS::DynamoDB</code>
        /// for downstream calls to Amazon DynamoDB that didn't target a specific table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client</code> - Represents the clients that sent requests to a root
        /// service.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>remote</code> - A downstream service of indeterminate type.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The service's state.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The service's state.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The start time of the first segment that the service generated.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the first segment that the service generated.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the last segment that the service generated.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the last segment that the service generated.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Appends an item to `edges`.
        ///
        /// To override the contents of this collection use [`set_edges`](Self::set_edges).
        ///
        /// <p>Connections to downstream services.</p>
        pub fn edges(mut self, input: impl Into<crate::model::Edge>) -> Self {
            let mut v = self.edges.unwrap_or_default();
            v.push(input.into());
            self.edges = Some(v);
            self
        }
        /// <p>Connections to downstream services.</p>
        pub fn set_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Edge>>,
        ) -> Self {
            self.edges = input;
            self
        }
        /// <p>Aggregated statistics for the service.</p>
        pub fn summary_statistics(mut self, input: crate::model::ServiceStatistics) -> Self {
            self.summary_statistics = Some(input);
            self
        }
        /// <p>Aggregated statistics for the service.</p>
        pub fn set_summary_statistics(
            mut self,
            input: std::option::Option<crate::model::ServiceStatistics>,
        ) -> Self {
            self.summary_statistics = input;
            self
        }
        /// Appends an item to `duration_histogram`.
        ///
        /// To override the contents of this collection use [`set_duration_histogram`](Self::set_duration_histogram).
        ///
        /// <p>A histogram that maps the spread of service durations.</p>
        pub fn duration_histogram(
            mut self,
            input: impl Into<crate::model::HistogramEntry>,
        ) -> Self {
            let mut v = self.duration_histogram.unwrap_or_default();
            v.push(input.into());
            self.duration_histogram = Some(v);
            self
        }
        /// <p>A histogram that maps the spread of service durations.</p>
        pub fn set_duration_histogram(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
        ) -> Self {
            self.duration_histogram = input;
            self
        }
        /// Appends an item to `response_time_histogram`.
        ///
        /// To override the contents of this collection use [`set_response_time_histogram`](Self::set_response_time_histogram).
        ///
        /// <p>A histogram that maps the spread of service response times.</p>
        pub fn response_time_histogram(
            mut self,
            input: impl Into<crate::model::HistogramEntry>,
        ) -> Self {
            let mut v = self.response_time_histogram.unwrap_or_default();
            v.push(input.into());
            self.response_time_histogram = Some(v);
            self
        }
        /// <p>A histogram that maps the spread of service response times.</p>
        pub fn set_response_time_histogram(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
        ) -> Self {
            self.response_time_histogram = input;
            self
        }
        /// Consumes the builder and constructs a [`Service`](crate::model::Service)
        pub fn build(self) -> crate::model::Service {
            crate::model::Service {
                reference_id: self.reference_id,
                name: self.name,
                names: self.names,
                root: self.root,
                account_id: self.account_id,
                r#type: self.r#type,
                state: self.state,
                start_time: self.start_time,
                end_time: self.end_time,
                edges: self.edges,
                summary_statistics: self.summary_statistics,
                duration_histogram: self.duration_histogram,
                response_time_histogram: self.response_time_histogram,
            }
        }
    }
}
impl Service {
    /// Creates a new builder-style object to manufacture [`Service`](crate::model::Service)
    pub fn builder() -> crate::model::service::Builder {
        crate::model::service::Builder::default()
    }
}

/// <p>An entry in a histogram for a statistic. A histogram maps the range of observed values
/// on the X axis, and the prevalence of each value on the Y axis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HistogramEntry {
    /// <p>The value of the entry.</p>
    pub value: f64,
    /// <p>The prevalence of the entry.</p>
    pub count: i32,
}
impl HistogramEntry {
    /// <p>The value of the entry.</p>
    pub fn value(&self) -> f64 {
        self.value
    }
    /// <p>The prevalence of the entry.</p>
    pub fn count(&self) -> i32 {
        self.count
    }
}
impl std::fmt::Debug for HistogramEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HistogramEntry");
        formatter.field("value", &self.value);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`HistogramEntry`](crate::model::HistogramEntry)
pub mod histogram_entry {
    /// A builder for [`HistogramEntry`](crate::model::HistogramEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<f64>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The value of the entry.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the entry.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// <p>The prevalence of the entry.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The prevalence of the entry.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`HistogramEntry`](crate::model::HistogramEntry)
        pub fn build(self) -> crate::model::HistogramEntry {
            crate::model::HistogramEntry {
                value: self.value.unwrap_or_default(),
                count: self.count.unwrap_or_default(),
            }
        }
    }
}
impl HistogramEntry {
    /// Creates a new builder-style object to manufacture [`HistogramEntry`](crate::model::HistogramEntry)
    pub fn builder() -> crate::model::histogram_entry::Builder {
        crate::model::histogram_entry::Builder::default()
    }
}

/// <p>Response statistics for a service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceStatistics {
    /// <p>The number of requests that completed with a 2xx Success status code.</p>
    pub ok_count: std::option::Option<i64>,
    /// <p>Information about requests that failed with a 4xx Client Error status code.</p>
    pub error_statistics: std::option::Option<crate::model::ErrorStatistics>,
    /// <p>Information about requests that failed with a 5xx Server Error status code.</p>
    pub fault_statistics: std::option::Option<crate::model::FaultStatistics>,
    /// <p>The total number of completed requests.</p>
    pub total_count: std::option::Option<i64>,
    /// <p>The aggregate response time of completed requests.</p>
    pub total_response_time: std::option::Option<f64>,
}
impl ServiceStatistics {
    /// <p>The number of requests that completed with a 2xx Success status code.</p>
    pub fn ok_count(&self) -> std::option::Option<i64> {
        self.ok_count
    }
    /// <p>Information about requests that failed with a 4xx Client Error status code.</p>
    pub fn error_statistics(&self) -> std::option::Option<&crate::model::ErrorStatistics> {
        self.error_statistics.as_ref()
    }
    /// <p>Information about requests that failed with a 5xx Server Error status code.</p>
    pub fn fault_statistics(&self) -> std::option::Option<&crate::model::FaultStatistics> {
        self.fault_statistics.as_ref()
    }
    /// <p>The total number of completed requests.</p>
    pub fn total_count(&self) -> std::option::Option<i64> {
        self.total_count
    }
    /// <p>The aggregate response time of completed requests.</p>
    pub fn total_response_time(&self) -> std::option::Option<f64> {
        self.total_response_time
    }
}
impl std::fmt::Debug for ServiceStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceStatistics");
        formatter.field("ok_count", &self.ok_count);
        formatter.field("error_statistics", &self.error_statistics);
        formatter.field("fault_statistics", &self.fault_statistics);
        formatter.field("total_count", &self.total_count);
        formatter.field("total_response_time", &self.total_response_time);
        formatter.finish()
    }
}
/// See [`ServiceStatistics`](crate::model::ServiceStatistics)
pub mod service_statistics {
    /// A builder for [`ServiceStatistics`](crate::model::ServiceStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ok_count: std::option::Option<i64>,
        pub(crate) error_statistics: std::option::Option<crate::model::ErrorStatistics>,
        pub(crate) fault_statistics: std::option::Option<crate::model::FaultStatistics>,
        pub(crate) total_count: std::option::Option<i64>,
        pub(crate) total_response_time: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The number of requests that completed with a 2xx Success status code.</p>
        pub fn ok_count(mut self, input: i64) -> Self {
            self.ok_count = Some(input);
            self
        }
        /// <p>The number of requests that completed with a 2xx Success status code.</p>
        pub fn set_ok_count(mut self, input: std::option::Option<i64>) -> Self {
            self.ok_count = input;
            self
        }
        /// <p>Information about requests that failed with a 4xx Client Error status code.</p>
        pub fn error_statistics(mut self, input: crate::model::ErrorStatistics) -> Self {
            self.error_statistics = Some(input);
            self
        }
        /// <p>Information about requests that failed with a 4xx Client Error status code.</p>
        pub fn set_error_statistics(
            mut self,
            input: std::option::Option<crate::model::ErrorStatistics>,
        ) -> Self {
            self.error_statistics = input;
            self
        }
        /// <p>Information about requests that failed with a 5xx Server Error status code.</p>
        pub fn fault_statistics(mut self, input: crate::model::FaultStatistics) -> Self {
            self.fault_statistics = Some(input);
            self
        }
        /// <p>Information about requests that failed with a 5xx Server Error status code.</p>
        pub fn set_fault_statistics(
            mut self,
            input: std::option::Option<crate::model::FaultStatistics>,
        ) -> Self {
            self.fault_statistics = input;
            self
        }
        /// <p>The total number of completed requests.</p>
        pub fn total_count(mut self, input: i64) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of completed requests.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i64>) -> Self {
            self.total_count = input;
            self
        }
        /// <p>The aggregate response time of completed requests.</p>
        pub fn total_response_time(mut self, input: f64) -> Self {
            self.total_response_time = Some(input);
            self
        }
        /// <p>The aggregate response time of completed requests.</p>
        pub fn set_total_response_time(mut self, input: std::option::Option<f64>) -> Self {
            self.total_response_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceStatistics`](crate::model::ServiceStatistics)
        pub fn build(self) -> crate::model::ServiceStatistics {
            crate::model::ServiceStatistics {
                ok_count: self.ok_count,
                error_statistics: self.error_statistics,
                fault_statistics: self.fault_statistics,
                total_count: self.total_count,
                total_response_time: self.total_response_time,
            }
        }
    }
}
impl ServiceStatistics {
    /// Creates a new builder-style object to manufacture [`ServiceStatistics`](crate::model::ServiceStatistics)
    pub fn builder() -> crate::model::service_statistics::Builder {
        crate::model::service_statistics::Builder::default()
    }
}

/// <p>Information about requests that failed with a 5xx Server Error status code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaultStatistics {
    /// <p>The number of requests that failed with untracked 5xx Server Error status
    /// codes.</p>
    pub other_count: std::option::Option<i64>,
    /// <p>The total number of requests that failed with a 5xx Server Error status code.</p>
    pub total_count: std::option::Option<i64>,
}
impl FaultStatistics {
    /// <p>The number of requests that failed with untracked 5xx Server Error status
    /// codes.</p>
    pub fn other_count(&self) -> std::option::Option<i64> {
        self.other_count
    }
    /// <p>The total number of requests that failed with a 5xx Server Error status code.</p>
    pub fn total_count(&self) -> std::option::Option<i64> {
        self.total_count
    }
}
impl std::fmt::Debug for FaultStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaultStatistics");
        formatter.field("other_count", &self.other_count);
        formatter.field("total_count", &self.total_count);
        formatter.finish()
    }
}
/// See [`FaultStatistics`](crate::model::FaultStatistics)
pub mod fault_statistics {
    /// A builder for [`FaultStatistics`](crate::model::FaultStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) other_count: std::option::Option<i64>,
        pub(crate) total_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of requests that failed with untracked 5xx Server Error status
        /// codes.</p>
        pub fn other_count(mut self, input: i64) -> Self {
            self.other_count = Some(input);
            self
        }
        /// <p>The number of requests that failed with untracked 5xx Server Error status
        /// codes.</p>
        pub fn set_other_count(mut self, input: std::option::Option<i64>) -> Self {
            self.other_count = input;
            self
        }
        /// <p>The total number of requests that failed with a 5xx Server Error status code.</p>
        pub fn total_count(mut self, input: i64) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of requests that failed with a 5xx Server Error status code.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i64>) -> Self {
            self.total_count = input;
            self
        }
        /// Consumes the builder and constructs a [`FaultStatistics`](crate::model::FaultStatistics)
        pub fn build(self) -> crate::model::FaultStatistics {
            crate::model::FaultStatistics {
                other_count: self.other_count,
                total_count: self.total_count,
            }
        }
    }
}
impl FaultStatistics {
    /// Creates a new builder-style object to manufacture [`FaultStatistics`](crate::model::FaultStatistics)
    pub fn builder() -> crate::model::fault_statistics::Builder {
        crate::model::fault_statistics::Builder::default()
    }
}

/// <p>Information about requests that failed with a 4xx Client Error status code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorStatistics {
    /// <p>The number of requests that failed with a 419 throttling status code.</p>
    pub throttle_count: std::option::Option<i64>,
    /// <p>The number of requests that failed with untracked 4xx Client Error status
    /// codes.</p>
    pub other_count: std::option::Option<i64>,
    /// <p>The total number of requests that failed with a 4xx Client Error status code.</p>
    pub total_count: std::option::Option<i64>,
}
impl ErrorStatistics {
    /// <p>The number of requests that failed with a 419 throttling status code.</p>
    pub fn throttle_count(&self) -> std::option::Option<i64> {
        self.throttle_count
    }
    /// <p>The number of requests that failed with untracked 4xx Client Error status
    /// codes.</p>
    pub fn other_count(&self) -> std::option::Option<i64> {
        self.other_count
    }
    /// <p>The total number of requests that failed with a 4xx Client Error status code.</p>
    pub fn total_count(&self) -> std::option::Option<i64> {
        self.total_count
    }
}
impl std::fmt::Debug for ErrorStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorStatistics");
        formatter.field("throttle_count", &self.throttle_count);
        formatter.field("other_count", &self.other_count);
        formatter.field("total_count", &self.total_count);
        formatter.finish()
    }
}
/// See [`ErrorStatistics`](crate::model::ErrorStatistics)
pub mod error_statistics {
    /// A builder for [`ErrorStatistics`](crate::model::ErrorStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) throttle_count: std::option::Option<i64>,
        pub(crate) other_count: std::option::Option<i64>,
        pub(crate) total_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of requests that failed with a 419 throttling status code.</p>
        pub fn throttle_count(mut self, input: i64) -> Self {
            self.throttle_count = Some(input);
            self
        }
        /// <p>The number of requests that failed with a 419 throttling status code.</p>
        pub fn set_throttle_count(mut self, input: std::option::Option<i64>) -> Self {
            self.throttle_count = input;
            self
        }
        /// <p>The number of requests that failed with untracked 4xx Client Error status
        /// codes.</p>
        pub fn other_count(mut self, input: i64) -> Self {
            self.other_count = Some(input);
            self
        }
        /// <p>The number of requests that failed with untracked 4xx Client Error status
        /// codes.</p>
        pub fn set_other_count(mut self, input: std::option::Option<i64>) -> Self {
            self.other_count = input;
            self
        }
        /// <p>The total number of requests that failed with a 4xx Client Error status code.</p>
        pub fn total_count(mut self, input: i64) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of requests that failed with a 4xx Client Error status code.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i64>) -> Self {
            self.total_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorStatistics`](crate::model::ErrorStatistics)
        pub fn build(self) -> crate::model::ErrorStatistics {
            crate::model::ErrorStatistics {
                throttle_count: self.throttle_count,
                other_count: self.other_count,
                total_count: self.total_count,
            }
        }
    }
}
impl ErrorStatistics {
    /// Creates a new builder-style object to manufacture [`ErrorStatistics`](crate::model::ErrorStatistics)
    pub fn builder() -> crate::model::error_statistics::Builder {
        crate::model::error_statistics::Builder::default()
    }
}

/// <p>Information about a connection between two services.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Edge {
    /// <p>Identifier of the edge. Unique within a service map.</p>
    pub reference_id: std::option::Option<i32>,
    /// <p>The start time of the first segment on the edge.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end time of the last segment on the edge.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Response statistics for segments on the edge.</p>
    pub summary_statistics: std::option::Option<crate::model::EdgeStatistics>,
    /// <p>A histogram that maps the spread of client response times on an edge.</p>
    pub response_time_histogram: std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
    /// <p>Aliases for the edge.</p>
    pub aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
}
impl Edge {
    /// <p>Identifier of the edge. Unique within a service map.</p>
    pub fn reference_id(&self) -> std::option::Option<i32> {
        self.reference_id
    }
    /// <p>The start time of the first segment on the edge.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The end time of the last segment on the edge.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>Response statistics for segments on the edge.</p>
    pub fn summary_statistics(&self) -> std::option::Option<&crate::model::EdgeStatistics> {
        self.summary_statistics.as_ref()
    }
    /// <p>A histogram that maps the spread of client response times on an edge.</p>
    pub fn response_time_histogram(&self) -> std::option::Option<&[crate::model::HistogramEntry]> {
        self.response_time_histogram.as_deref()
    }
    /// <p>Aliases for the edge.</p>
    pub fn aliases(&self) -> std::option::Option<&[crate::model::Alias]> {
        self.aliases.as_deref()
    }
}
impl std::fmt::Debug for Edge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Edge");
        formatter.field("reference_id", &self.reference_id);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("summary_statistics", &self.summary_statistics);
        formatter.field("response_time_histogram", &self.response_time_histogram);
        formatter.field("aliases", &self.aliases);
        formatter.finish()
    }
}
/// See [`Edge`](crate::model::Edge)
pub mod edge {
    /// A builder for [`Edge`](crate::model::Edge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reference_id: std::option::Option<i32>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) summary_statistics: std::option::Option<crate::model::EdgeStatistics>,
        pub(crate) response_time_histogram:
            std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
        pub(crate) aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
    }
    impl Builder {
        /// <p>Identifier of the edge. Unique within a service map.</p>
        pub fn reference_id(mut self, input: i32) -> Self {
            self.reference_id = Some(input);
            self
        }
        /// <p>Identifier of the edge. Unique within a service map.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<i32>) -> Self {
            self.reference_id = input;
            self
        }
        /// <p>The start time of the first segment on the edge.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the first segment on the edge.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the last segment on the edge.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the last segment on the edge.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Response statistics for segments on the edge.</p>
        pub fn summary_statistics(mut self, input: crate::model::EdgeStatistics) -> Self {
            self.summary_statistics = Some(input);
            self
        }
        /// <p>Response statistics for segments on the edge.</p>
        pub fn set_summary_statistics(
            mut self,
            input: std::option::Option<crate::model::EdgeStatistics>,
        ) -> Self {
            self.summary_statistics = input;
            self
        }
        /// Appends an item to `response_time_histogram`.
        ///
        /// To override the contents of this collection use [`set_response_time_histogram`](Self::set_response_time_histogram).
        ///
        /// <p>A histogram that maps the spread of client response times on an edge.</p>
        pub fn response_time_histogram(
            mut self,
            input: impl Into<crate::model::HistogramEntry>,
        ) -> Self {
            let mut v = self.response_time_histogram.unwrap_or_default();
            v.push(input.into());
            self.response_time_histogram = Some(v);
            self
        }
        /// <p>A histogram that maps the spread of client response times on an edge.</p>
        pub fn set_response_time_histogram(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
        ) -> Self {
            self.response_time_histogram = input;
            self
        }
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>Aliases for the edge.</p>
        pub fn aliases(mut self, input: impl Into<crate::model::Alias>) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input.into());
            self.aliases = Some(v);
            self
        }
        /// <p>Aliases for the edge.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alias>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`Edge`](crate::model::Edge)
        pub fn build(self) -> crate::model::Edge {
            crate::model::Edge {
                reference_id: self.reference_id,
                start_time: self.start_time,
                end_time: self.end_time,
                summary_statistics: self.summary_statistics,
                response_time_histogram: self.response_time_histogram,
                aliases: self.aliases,
            }
        }
    }
}
impl Edge {
    /// Creates a new builder-style object to manufacture [`Edge`](crate::model::Edge)
    pub fn builder() -> crate::model::edge::Builder {
        crate::model::edge::Builder::default()
    }
}

/// <p>An alias for an edge.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alias {
    /// <p>The canonical name of the alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of names for the alias, including the canonical name.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of the alias.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl Alias {
    /// <p>The canonical name of the alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of names for the alias, including the canonical name.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>The type of the alias.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for Alias {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alias");
        formatter.field("name", &self.name);
        formatter.field("names", &self.names);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Alias`](crate::model::Alias)
pub mod alias {
    /// A builder for [`Alias`](crate::model::Alias)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canonical name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The canonical name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A list of names for the alias, including the canonical name.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>A list of names for the alias, including the canonical name.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The type of the alias.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the alias.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Alias`](crate::model::Alias)
        pub fn build(self) -> crate::model::Alias {
            crate::model::Alias {
                name: self.name,
                names: self.names,
                r#type: self.r#type,
            }
        }
    }
}
impl Alias {
    /// Creates a new builder-style object to manufacture [`Alias`](crate::model::Alias)
    pub fn builder() -> crate::model::alias::Builder {
        crate::model::alias::Builder::default()
    }
}

/// <p>Response statistics for an edge.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EdgeStatistics {
    /// <p>The number of requests that completed with a 2xx Success status code.</p>
    pub ok_count: std::option::Option<i64>,
    /// <p>Information about requests that failed with a 4xx Client Error status code.</p>
    pub error_statistics: std::option::Option<crate::model::ErrorStatistics>,
    /// <p>Information about requests that failed with a 5xx Server Error status code.</p>
    pub fault_statistics: std::option::Option<crate::model::FaultStatistics>,
    /// <p>The total number of completed requests.</p>
    pub total_count: std::option::Option<i64>,
    /// <p>The aggregate response time of completed requests.</p>
    pub total_response_time: std::option::Option<f64>,
}
impl EdgeStatistics {
    /// <p>The number of requests that completed with a 2xx Success status code.</p>
    pub fn ok_count(&self) -> std::option::Option<i64> {
        self.ok_count
    }
    /// <p>Information about requests that failed with a 4xx Client Error status code.</p>
    pub fn error_statistics(&self) -> std::option::Option<&crate::model::ErrorStatistics> {
        self.error_statistics.as_ref()
    }
    /// <p>Information about requests that failed with a 5xx Server Error status code.</p>
    pub fn fault_statistics(&self) -> std::option::Option<&crate::model::FaultStatistics> {
        self.fault_statistics.as_ref()
    }
    /// <p>The total number of completed requests.</p>
    pub fn total_count(&self) -> std::option::Option<i64> {
        self.total_count
    }
    /// <p>The aggregate response time of completed requests.</p>
    pub fn total_response_time(&self) -> std::option::Option<f64> {
        self.total_response_time
    }
}
impl std::fmt::Debug for EdgeStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EdgeStatistics");
        formatter.field("ok_count", &self.ok_count);
        formatter.field("error_statistics", &self.error_statistics);
        formatter.field("fault_statistics", &self.fault_statistics);
        formatter.field("total_count", &self.total_count);
        formatter.field("total_response_time", &self.total_response_time);
        formatter.finish()
    }
}
/// See [`EdgeStatistics`](crate::model::EdgeStatistics)
pub mod edge_statistics {
    /// A builder for [`EdgeStatistics`](crate::model::EdgeStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ok_count: std::option::Option<i64>,
        pub(crate) error_statistics: std::option::Option<crate::model::ErrorStatistics>,
        pub(crate) fault_statistics: std::option::Option<crate::model::FaultStatistics>,
        pub(crate) total_count: std::option::Option<i64>,
        pub(crate) total_response_time: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The number of requests that completed with a 2xx Success status code.</p>
        pub fn ok_count(mut self, input: i64) -> Self {
            self.ok_count = Some(input);
            self
        }
        /// <p>The number of requests that completed with a 2xx Success status code.</p>
        pub fn set_ok_count(mut self, input: std::option::Option<i64>) -> Self {
            self.ok_count = input;
            self
        }
        /// <p>Information about requests that failed with a 4xx Client Error status code.</p>
        pub fn error_statistics(mut self, input: crate::model::ErrorStatistics) -> Self {
            self.error_statistics = Some(input);
            self
        }
        /// <p>Information about requests that failed with a 4xx Client Error status code.</p>
        pub fn set_error_statistics(
            mut self,
            input: std::option::Option<crate::model::ErrorStatistics>,
        ) -> Self {
            self.error_statistics = input;
            self
        }
        /// <p>Information about requests that failed with a 5xx Server Error status code.</p>
        pub fn fault_statistics(mut self, input: crate::model::FaultStatistics) -> Self {
            self.fault_statistics = Some(input);
            self
        }
        /// <p>Information about requests that failed with a 5xx Server Error status code.</p>
        pub fn set_fault_statistics(
            mut self,
            input: std::option::Option<crate::model::FaultStatistics>,
        ) -> Self {
            self.fault_statistics = input;
            self
        }
        /// <p>The total number of completed requests.</p>
        pub fn total_count(mut self, input: i64) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of completed requests.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i64>) -> Self {
            self.total_count = input;
            self
        }
        /// <p>The aggregate response time of completed requests.</p>
        pub fn total_response_time(mut self, input: f64) -> Self {
            self.total_response_time = Some(input);
            self
        }
        /// <p>The aggregate response time of completed requests.</p>
        pub fn set_total_response_time(mut self, input: std::option::Option<f64>) -> Self {
            self.total_response_time = input;
            self
        }
        /// Consumes the builder and constructs a [`EdgeStatistics`](crate::model::EdgeStatistics)
        pub fn build(self) -> crate::model::EdgeStatistics {
            crate::model::EdgeStatistics {
                ok_count: self.ok_count,
                error_statistics: self.error_statistics,
                fault_statistics: self.fault_statistics,
                total_count: self.total_count,
                total_response_time: self.total_response_time,
            }
        }
    }
}
impl EdgeStatistics {
    /// Creates a new builder-style object to manufacture [`EdgeStatistics`](crate::model::EdgeStatistics)
    pub fn builder() -> crate::model::edge_statistics::Builder {
        crate::model::edge_statistics::Builder::default()
    }
}

/// <p>A list of TimeSeriesStatistic structures.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeSeriesServiceStatistics {
    /// <p>Timestamp of the window for which statistics are aggregated.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Response statistics for an edge.</p>
    pub edge_summary_statistics: std::option::Option<crate::model::EdgeStatistics>,
    /// <p>Response statistics for a service.</p>
    pub service_summary_statistics: std::option::Option<crate::model::ServiceStatistics>,
    /// <p>The forecasted high and low fault count values.</p>
    pub service_forecast_statistics: std::option::Option<crate::model::ForecastStatistics>,
    /// <p>The response time histogram for the selected entities.</p>
    pub response_time_histogram: std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
}
impl TimeSeriesServiceStatistics {
    /// <p>Timestamp of the window for which statistics are aggregated.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>Response statistics for an edge.</p>
    pub fn edge_summary_statistics(&self) -> std::option::Option<&crate::model::EdgeStatistics> {
        self.edge_summary_statistics.as_ref()
    }
    /// <p>Response statistics for a service.</p>
    pub fn service_summary_statistics(
        &self,
    ) -> std::option::Option<&crate::model::ServiceStatistics> {
        self.service_summary_statistics.as_ref()
    }
    /// <p>The forecasted high and low fault count values.</p>
    pub fn service_forecast_statistics(
        &self,
    ) -> std::option::Option<&crate::model::ForecastStatistics> {
        self.service_forecast_statistics.as_ref()
    }
    /// <p>The response time histogram for the selected entities.</p>
    pub fn response_time_histogram(&self) -> std::option::Option<&[crate::model::HistogramEntry]> {
        self.response_time_histogram.as_deref()
    }
}
impl std::fmt::Debug for TimeSeriesServiceStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeSeriesServiceStatistics");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("edge_summary_statistics", &self.edge_summary_statistics);
        formatter.field(
            "service_summary_statistics",
            &self.service_summary_statistics,
        );
        formatter.field(
            "service_forecast_statistics",
            &self.service_forecast_statistics,
        );
        formatter.field("response_time_histogram", &self.response_time_histogram);
        formatter.finish()
    }
}
/// See [`TimeSeriesServiceStatistics`](crate::model::TimeSeriesServiceStatistics)
pub mod time_series_service_statistics {
    /// A builder for [`TimeSeriesServiceStatistics`](crate::model::TimeSeriesServiceStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) edge_summary_statistics: std::option::Option<crate::model::EdgeStatistics>,
        pub(crate) service_summary_statistics: std::option::Option<crate::model::ServiceStatistics>,
        pub(crate) service_forecast_statistics:
            std::option::Option<crate::model::ForecastStatistics>,
        pub(crate) response_time_histogram:
            std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
    }
    impl Builder {
        /// <p>Timestamp of the window for which statistics are aggregated.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Timestamp of the window for which statistics are aggregated.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Response statistics for an edge.</p>
        pub fn edge_summary_statistics(mut self, input: crate::model::EdgeStatistics) -> Self {
            self.edge_summary_statistics = Some(input);
            self
        }
        /// <p>Response statistics for an edge.</p>
        pub fn set_edge_summary_statistics(
            mut self,
            input: std::option::Option<crate::model::EdgeStatistics>,
        ) -> Self {
            self.edge_summary_statistics = input;
            self
        }
        /// <p>Response statistics for a service.</p>
        pub fn service_summary_statistics(
            mut self,
            input: crate::model::ServiceStatistics,
        ) -> Self {
            self.service_summary_statistics = Some(input);
            self
        }
        /// <p>Response statistics for a service.</p>
        pub fn set_service_summary_statistics(
            mut self,
            input: std::option::Option<crate::model::ServiceStatistics>,
        ) -> Self {
            self.service_summary_statistics = input;
            self
        }
        /// <p>The forecasted high and low fault count values.</p>
        pub fn service_forecast_statistics(
            mut self,
            input: crate::model::ForecastStatistics,
        ) -> Self {
            self.service_forecast_statistics = Some(input);
            self
        }
        /// <p>The forecasted high and low fault count values.</p>
        pub fn set_service_forecast_statistics(
            mut self,
            input: std::option::Option<crate::model::ForecastStatistics>,
        ) -> Self {
            self.service_forecast_statistics = input;
            self
        }
        /// Appends an item to `response_time_histogram`.
        ///
        /// To override the contents of this collection use [`set_response_time_histogram`](Self::set_response_time_histogram).
        ///
        /// <p>The response time histogram for the selected entities.</p>
        pub fn response_time_histogram(
            mut self,
            input: impl Into<crate::model::HistogramEntry>,
        ) -> Self {
            let mut v = self.response_time_histogram.unwrap_or_default();
            v.push(input.into());
            self.response_time_histogram = Some(v);
            self
        }
        /// <p>The response time histogram for the selected entities.</p>
        pub fn set_response_time_histogram(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HistogramEntry>>,
        ) -> Self {
            self.response_time_histogram = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeSeriesServiceStatistics`](crate::model::TimeSeriesServiceStatistics)
        pub fn build(self) -> crate::model::TimeSeriesServiceStatistics {
            crate::model::TimeSeriesServiceStatistics {
                timestamp: self.timestamp,
                edge_summary_statistics: self.edge_summary_statistics,
                service_summary_statistics: self.service_summary_statistics,
                service_forecast_statistics: self.service_forecast_statistics,
                response_time_histogram: self.response_time_histogram,
            }
        }
    }
}
impl TimeSeriesServiceStatistics {
    /// Creates a new builder-style object to manufacture [`TimeSeriesServiceStatistics`](crate::model::TimeSeriesServiceStatistics)
    pub fn builder() -> crate::model::time_series_service_statistics::Builder {
        crate::model::time_series_service_statistics::Builder::default()
    }
}

/// <p>The predicted high and low fault count. This is used to determine if a service has
/// become anomalous and if an insight should be created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForecastStatistics {
    /// <p>The upper limit of fault counts for a service.</p>
    pub fault_count_high: std::option::Option<i64>,
    /// <p>The lower limit of fault counts for a service.</p>
    pub fault_count_low: std::option::Option<i64>,
}
impl ForecastStatistics {
    /// <p>The upper limit of fault counts for a service.</p>
    pub fn fault_count_high(&self) -> std::option::Option<i64> {
        self.fault_count_high
    }
    /// <p>The lower limit of fault counts for a service.</p>
    pub fn fault_count_low(&self) -> std::option::Option<i64> {
        self.fault_count_low
    }
}
impl std::fmt::Debug for ForecastStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForecastStatistics");
        formatter.field("fault_count_high", &self.fault_count_high);
        formatter.field("fault_count_low", &self.fault_count_low);
        formatter.finish()
    }
}
/// See [`ForecastStatistics`](crate::model::ForecastStatistics)
pub mod forecast_statistics {
    /// A builder for [`ForecastStatistics`](crate::model::ForecastStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fault_count_high: std::option::Option<i64>,
        pub(crate) fault_count_low: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The upper limit of fault counts for a service.</p>
        pub fn fault_count_high(mut self, input: i64) -> Self {
            self.fault_count_high = Some(input);
            self
        }
        /// <p>The upper limit of fault counts for a service.</p>
        pub fn set_fault_count_high(mut self, input: std::option::Option<i64>) -> Self {
            self.fault_count_high = input;
            self
        }
        /// <p>The lower limit of fault counts for a service.</p>
        pub fn fault_count_low(mut self, input: i64) -> Self {
            self.fault_count_low = Some(input);
            self
        }
        /// <p>The lower limit of fault counts for a service.</p>
        pub fn set_fault_count_low(mut self, input: std::option::Option<i64>) -> Self {
            self.fault_count_low = input;
            self
        }
        /// Consumes the builder and constructs a [`ForecastStatistics`](crate::model::ForecastStatistics)
        pub fn build(self) -> crate::model::ForecastStatistics {
            crate::model::ForecastStatistics {
                fault_count_high: self.fault_count_high,
                fault_count_low: self.fault_count_low,
            }
        }
    }
}
impl ForecastStatistics {
    /// Creates a new builder-style object to manufacture [`ForecastStatistics`](crate::model::ForecastStatistics)
    pub fn builder() -> crate::model::forecast_statistics::Builder {
        crate::model::forecast_statistics::Builder::default()
    }
}

/// <p>Sampling statistics from a call to <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a> that X-Ray
/// could not process.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessedStatistics {
    /// <p>The name of the sampling rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl UnprocessedStatistics {
    /// <p>The name of the sampling rule.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for UnprocessedStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessedStatistics");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`UnprocessedStatistics`](crate::model::UnprocessedStatistics)
pub mod unprocessed_statistics {
    /// A builder for [`UnprocessedStatistics`](crate::model::UnprocessedStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the sampling rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the sampling rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessedStatistics`](crate::model::UnprocessedStatistics)
        pub fn build(self) -> crate::model::UnprocessedStatistics {
            crate::model::UnprocessedStatistics {
                rule_name: self.rule_name,
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl UnprocessedStatistics {
    /// Creates a new builder-style object to manufacture [`UnprocessedStatistics`](crate::model::UnprocessedStatistics)
    pub fn builder() -> crate::model::unprocessed_statistics::Builder {
        crate::model::unprocessed_statistics::Builder::default()
    }
}

/// <p>Temporary changes to a sampling rule configuration. To meet the global sampling target for a rule, X-Ray
/// calculates a new reservoir for each service based on the recent sampling results of all services that called
/// <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamplingTargetDocument {
    /// <p>The name of the sampling rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The percentage of matching requests to instrument, after the reservoir is
    /// exhausted.</p>
    pub fixed_rate: f64,
    /// <p>The number of requests per second that X-Ray allocated for this service.</p>
    pub reservoir_quota: std::option::Option<i32>,
    /// <p>When the reservoir quota expires.</p>
    pub reservoir_quota_ttl: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of seconds for the service to wait before getting sampling targets
    /// again.</p>
    pub interval: std::option::Option<i32>,
}
impl SamplingTargetDocument {
    /// <p>The name of the sampling rule.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The percentage of matching requests to instrument, after the reservoir is
    /// exhausted.</p>
    pub fn fixed_rate(&self) -> f64 {
        self.fixed_rate
    }
    /// <p>The number of requests per second that X-Ray allocated for this service.</p>
    pub fn reservoir_quota(&self) -> std::option::Option<i32> {
        self.reservoir_quota
    }
    /// <p>When the reservoir quota expires.</p>
    pub fn reservoir_quota_ttl(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.reservoir_quota_ttl.as_ref()
    }
    /// <p>The number of seconds for the service to wait before getting sampling targets
    /// again.</p>
    pub fn interval(&self) -> std::option::Option<i32> {
        self.interval
    }
}
impl std::fmt::Debug for SamplingTargetDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamplingTargetDocument");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("fixed_rate", &self.fixed_rate);
        formatter.field("reservoir_quota", &self.reservoir_quota);
        formatter.field("reservoir_quota_ttl", &self.reservoir_quota_ttl);
        formatter.field("interval", &self.interval);
        formatter.finish()
    }
}
/// See [`SamplingTargetDocument`](crate::model::SamplingTargetDocument)
pub mod sampling_target_document {
    /// A builder for [`SamplingTargetDocument`](crate::model::SamplingTargetDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) fixed_rate: std::option::Option<f64>,
        pub(crate) reservoir_quota: std::option::Option<i32>,
        pub(crate) reservoir_quota_ttl: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) interval: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the sampling rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the sampling rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The percentage of matching requests to instrument, after the reservoir is
        /// exhausted.</p>
        pub fn fixed_rate(mut self, input: f64) -> Self {
            self.fixed_rate = Some(input);
            self
        }
        /// <p>The percentage of matching requests to instrument, after the reservoir is
        /// exhausted.</p>
        pub fn set_fixed_rate(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_rate = input;
            self
        }
        /// <p>The number of requests per second that X-Ray allocated for this service.</p>
        pub fn reservoir_quota(mut self, input: i32) -> Self {
            self.reservoir_quota = Some(input);
            self
        }
        /// <p>The number of requests per second that X-Ray allocated for this service.</p>
        pub fn set_reservoir_quota(mut self, input: std::option::Option<i32>) -> Self {
            self.reservoir_quota = input;
            self
        }
        /// <p>When the reservoir quota expires.</p>
        pub fn reservoir_quota_ttl(mut self, input: aws_smithy_types::Instant) -> Self {
            self.reservoir_quota_ttl = Some(input);
            self
        }
        /// <p>When the reservoir quota expires.</p>
        pub fn set_reservoir_quota_ttl(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.reservoir_quota_ttl = input;
            self
        }
        /// <p>The number of seconds for the service to wait before getting sampling targets
        /// again.</p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The number of seconds for the service to wait before getting sampling targets
        /// again.</p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// Consumes the builder and constructs a [`SamplingTargetDocument`](crate::model::SamplingTargetDocument)
        pub fn build(self) -> crate::model::SamplingTargetDocument {
            crate::model::SamplingTargetDocument {
                rule_name: self.rule_name,
                fixed_rate: self.fixed_rate.unwrap_or_default(),
                reservoir_quota: self.reservoir_quota,
                reservoir_quota_ttl: self.reservoir_quota_ttl,
                interval: self.interval,
            }
        }
    }
}
impl SamplingTargetDocument {
    /// Creates a new builder-style object to manufacture [`SamplingTargetDocument`](crate::model::SamplingTargetDocument)
    pub fn builder() -> crate::model::sampling_target_document::Builder {
        crate::model::sampling_target_document::Builder::default()
    }
}

/// <p>Request sampling results for a single rule from a service. Results are for the last 10
/// seconds unless the service has been assigned a longer reporting interval after a previous call
/// to <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamplingStatisticsDocument {
    /// <p>The name of the sampling rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the service in hexadecimal.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The current time.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of requests that matched the rule.</p>
    pub request_count: i32,
    /// <p>The number of requests recorded.</p>
    pub sampled_count: i32,
    /// <p>The number of requests recorded with borrowed reservoir quota.</p>
    pub borrow_count: i32,
}
impl SamplingStatisticsDocument {
    /// <p>The name of the sampling rule.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>A unique identifier for the service in hexadecimal.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The current time.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>The number of requests that matched the rule.</p>
    pub fn request_count(&self) -> i32 {
        self.request_count
    }
    /// <p>The number of requests recorded.</p>
    pub fn sampled_count(&self) -> i32 {
        self.sampled_count
    }
    /// <p>The number of requests recorded with borrowed reservoir quota.</p>
    pub fn borrow_count(&self) -> i32 {
        self.borrow_count
    }
}
impl std::fmt::Debug for SamplingStatisticsDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamplingStatisticsDocument");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("client_id", &self.client_id);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("request_count", &self.request_count);
        formatter.field("sampled_count", &self.sampled_count);
        formatter.field("borrow_count", &self.borrow_count);
        formatter.finish()
    }
}
/// See [`SamplingStatisticsDocument`](crate::model::SamplingStatisticsDocument)
pub mod sampling_statistics_document {
    /// A builder for [`SamplingStatisticsDocument`](crate::model::SamplingStatisticsDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) request_count: std::option::Option<i32>,
        pub(crate) sampled_count: std::option::Option<i32>,
        pub(crate) borrow_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the sampling rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the sampling rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>A unique identifier for the service in hexadecimal.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the service in hexadecimal.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The current time.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The current time.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The number of requests that matched the rule.</p>
        pub fn request_count(mut self, input: i32) -> Self {
            self.request_count = Some(input);
            self
        }
        /// <p>The number of requests that matched the rule.</p>
        pub fn set_request_count(mut self, input: std::option::Option<i32>) -> Self {
            self.request_count = input;
            self
        }
        /// <p>The number of requests recorded.</p>
        pub fn sampled_count(mut self, input: i32) -> Self {
            self.sampled_count = Some(input);
            self
        }
        /// <p>The number of requests recorded.</p>
        pub fn set_sampled_count(mut self, input: std::option::Option<i32>) -> Self {
            self.sampled_count = input;
            self
        }
        /// <p>The number of requests recorded with borrowed reservoir quota.</p>
        pub fn borrow_count(mut self, input: i32) -> Self {
            self.borrow_count = Some(input);
            self
        }
        /// <p>The number of requests recorded with borrowed reservoir quota.</p>
        pub fn set_borrow_count(mut self, input: std::option::Option<i32>) -> Self {
            self.borrow_count = input;
            self
        }
        /// Consumes the builder and constructs a [`SamplingStatisticsDocument`](crate::model::SamplingStatisticsDocument)
        pub fn build(self) -> crate::model::SamplingStatisticsDocument {
            crate::model::SamplingStatisticsDocument {
                rule_name: self.rule_name,
                client_id: self.client_id,
                timestamp: self.timestamp,
                request_count: self.request_count.unwrap_or_default(),
                sampled_count: self.sampled_count.unwrap_or_default(),
                borrow_count: self.borrow_count.unwrap_or_default(),
            }
        }
    }
}
impl SamplingStatisticsDocument {
    /// Creates a new builder-style object to manufacture [`SamplingStatisticsDocument`](crate::model::SamplingStatisticsDocument)
    pub fn builder() -> crate::model::sampling_statistics_document::Builder {
        crate::model::sampling_statistics_document::Builder::default()
    }
}

/// <p>Aggregated request sampling data for a sampling rule across all services for a 10-second window.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamplingStatisticSummary {
    /// <p>The name of the sampling rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The start time of the reporting window.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of requests that matched the rule.</p>
    pub request_count: i32,
    /// <p>The number of requests recorded with borrowed reservoir quota.</p>
    pub borrow_count: i32,
    /// <p>The number of requests recorded.</p>
    pub sampled_count: i32,
}
impl SamplingStatisticSummary {
    /// <p>The name of the sampling rule.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The start time of the reporting window.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>The number of requests that matched the rule.</p>
    pub fn request_count(&self) -> i32 {
        self.request_count
    }
    /// <p>The number of requests recorded with borrowed reservoir quota.</p>
    pub fn borrow_count(&self) -> i32 {
        self.borrow_count
    }
    /// <p>The number of requests recorded.</p>
    pub fn sampled_count(&self) -> i32 {
        self.sampled_count
    }
}
impl std::fmt::Debug for SamplingStatisticSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamplingStatisticSummary");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("request_count", &self.request_count);
        formatter.field("borrow_count", &self.borrow_count);
        formatter.field("sampled_count", &self.sampled_count);
        formatter.finish()
    }
}
/// See [`SamplingStatisticSummary`](crate::model::SamplingStatisticSummary)
pub mod sampling_statistic_summary {
    /// A builder for [`SamplingStatisticSummary`](crate::model::SamplingStatisticSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) request_count: std::option::Option<i32>,
        pub(crate) borrow_count: std::option::Option<i32>,
        pub(crate) sampled_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the sampling rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the sampling rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The start time of the reporting window.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The start time of the reporting window.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The number of requests that matched the rule.</p>
        pub fn request_count(mut self, input: i32) -> Self {
            self.request_count = Some(input);
            self
        }
        /// <p>The number of requests that matched the rule.</p>
        pub fn set_request_count(mut self, input: std::option::Option<i32>) -> Self {
            self.request_count = input;
            self
        }
        /// <p>The number of requests recorded with borrowed reservoir quota.</p>
        pub fn borrow_count(mut self, input: i32) -> Self {
            self.borrow_count = Some(input);
            self
        }
        /// <p>The number of requests recorded with borrowed reservoir quota.</p>
        pub fn set_borrow_count(mut self, input: std::option::Option<i32>) -> Self {
            self.borrow_count = input;
            self
        }
        /// <p>The number of requests recorded.</p>
        pub fn sampled_count(mut self, input: i32) -> Self {
            self.sampled_count = Some(input);
            self
        }
        /// <p>The number of requests recorded.</p>
        pub fn set_sampled_count(mut self, input: std::option::Option<i32>) -> Self {
            self.sampled_count = input;
            self
        }
        /// Consumes the builder and constructs a [`SamplingStatisticSummary`](crate::model::SamplingStatisticSummary)
        pub fn build(self) -> crate::model::SamplingStatisticSummary {
            crate::model::SamplingStatisticSummary {
                rule_name: self.rule_name,
                timestamp: self.timestamp,
                request_count: self.request_count.unwrap_or_default(),
                borrow_count: self.borrow_count.unwrap_or_default(),
                sampled_count: self.sampled_count.unwrap_or_default(),
            }
        }
    }
}
impl SamplingStatisticSummary {
    /// Creates a new builder-style object to manufacture [`SamplingStatisticSummary`](crate::model::SamplingStatisticSummary)
    pub fn builder() -> crate::model::sampling_statistic_summary::Builder {
        crate::model::sampling_statistic_summary::Builder::default()
    }
}

/// <p>Information that describes an insight.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightSummary {
    /// <p>The insights unique identifier. </p>
    pub insight_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the group that the insight belongs to.</p>
    pub group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the group  that the insight belongs to.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p></p>
    pub root_cause_service_id: std::option::Option<crate::model::ServiceId>,
    /// <p> Categories The categories that label and describe the type of insight.</p>
    pub categories: std::option::Option<std::vec::Vec<crate::model::InsightCategory>>,
    /// <p>The current state of the insight.</p>
    pub state: std::option::Option<crate::model::InsightState>,
    /// <p>The time, in Unix seconds, at which the insight began.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time, in Unix seconds, at which the insight ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A brief description of the insight.</p>
    pub summary: std::option::Option<std::string::String>,
    /// <p>The impact statistics of the client side service. This includes the number of requests
    /// to the client service and whether the requests were faults or okay. </p>
    pub client_request_impact_statistics:
        std::option::Option<crate::model::RequestImpactStatistics>,
    /// <p>The impact statistics of the root cause service. This includes the number of requests to
    /// the client service and whether the requests were faults or okay. </p>
    pub root_cause_service_request_impact_statistics:
        std::option::Option<crate::model::RequestImpactStatistics>,
    /// <p>The service within the insight that is most impacted by the incident.</p>
    pub top_anomalous_services: std::option::Option<std::vec::Vec<crate::model::AnomalousService>>,
    /// <p>The time, in Unix seconds, that the insight was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl InsightSummary {
    /// <p>The insights unique identifier. </p>
    pub fn insight_id(&self) -> std::option::Option<&str> {
        self.insight_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the group that the insight belongs to.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
    /// <p>The name of the group  that the insight belongs to.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p></p>
    pub fn root_cause_service_id(&self) -> std::option::Option<&crate::model::ServiceId> {
        self.root_cause_service_id.as_ref()
    }
    /// <p> Categories The categories that label and describe the type of insight.</p>
    pub fn categories(&self) -> std::option::Option<&[crate::model::InsightCategory]> {
        self.categories.as_deref()
    }
    /// <p>The current state of the insight.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::InsightState> {
        self.state.as_ref()
    }
    /// <p>The time, in Unix seconds, at which the insight began.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The time, in Unix seconds, at which the insight ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>A brief description of the insight.</p>
    pub fn summary(&self) -> std::option::Option<&str> {
        self.summary.as_deref()
    }
    /// <p>The impact statistics of the client side service. This includes the number of requests
    /// to the client service and whether the requests were faults or okay. </p>
    pub fn client_request_impact_statistics(
        &self,
    ) -> std::option::Option<&crate::model::RequestImpactStatistics> {
        self.client_request_impact_statistics.as_ref()
    }
    /// <p>The impact statistics of the root cause service. This includes the number of requests to
    /// the client service and whether the requests were faults or okay. </p>
    pub fn root_cause_service_request_impact_statistics(
        &self,
    ) -> std::option::Option<&crate::model::RequestImpactStatistics> {
        self.root_cause_service_request_impact_statistics.as_ref()
    }
    /// <p>The service within the insight that is most impacted by the incident.</p>
    pub fn top_anomalous_services(&self) -> std::option::Option<&[crate::model::AnomalousService]> {
        self.top_anomalous_services.as_deref()
    }
    /// <p>The time, in Unix seconds, that the insight was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for InsightSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightSummary");
        formatter.field("insight_id", &self.insight_id);
        formatter.field("group_arn", &self.group_arn);
        formatter.field("group_name", &self.group_name);
        formatter.field("root_cause_service_id", &self.root_cause_service_id);
        formatter.field("categories", &self.categories);
        formatter.field("state", &self.state);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("summary", &self.summary);
        formatter.field(
            "client_request_impact_statistics",
            &self.client_request_impact_statistics,
        );
        formatter.field(
            "root_cause_service_request_impact_statistics",
            &self.root_cause_service_request_impact_statistics,
        );
        formatter.field("top_anomalous_services", &self.top_anomalous_services);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`InsightSummary`](crate::model::InsightSummary)
pub mod insight_summary {
    /// A builder for [`InsightSummary`](crate::model::InsightSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) root_cause_service_id: std::option::Option<crate::model::ServiceId>,
        pub(crate) categories: std::option::Option<std::vec::Vec<crate::model::InsightCategory>>,
        pub(crate) state: std::option::Option<crate::model::InsightState>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) summary: std::option::Option<std::string::String>,
        pub(crate) client_request_impact_statistics:
            std::option::Option<crate::model::RequestImpactStatistics>,
        pub(crate) root_cause_service_request_impact_statistics:
            std::option::Option<crate::model::RequestImpactStatistics>,
        pub(crate) top_anomalous_services:
            std::option::Option<std::vec::Vec<crate::model::AnomalousService>>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The insights unique identifier. </p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p>The insights unique identifier. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group that the insight belongs to.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group that the insight belongs to.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// <p>The name of the group  that the insight belongs to.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group  that the insight belongs to.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p></p>
        pub fn root_cause_service_id(mut self, input: crate::model::ServiceId) -> Self {
            self.root_cause_service_id = Some(input);
            self
        }
        /// <p></p>
        pub fn set_root_cause_service_id(
            mut self,
            input: std::option::Option<crate::model::ServiceId>,
        ) -> Self {
            self.root_cause_service_id = input;
            self
        }
        /// Appends an item to `categories`.
        ///
        /// To override the contents of this collection use [`set_categories`](Self::set_categories).
        ///
        /// <p> Categories The categories that label and describe the type of insight.</p>
        pub fn categories(mut self, input: impl Into<crate::model::InsightCategory>) -> Self {
            let mut v = self.categories.unwrap_or_default();
            v.push(input.into());
            self.categories = Some(v);
            self
        }
        /// <p> Categories The categories that label and describe the type of insight.</p>
        pub fn set_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightCategory>>,
        ) -> Self {
            self.categories = input;
            self
        }
        /// <p>The current state of the insight.</p>
        pub fn state(mut self, input: crate::model::InsightState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the insight.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::InsightState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The time, in Unix seconds, at which the insight began.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time, in Unix seconds, at which the insight began.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time, in Unix seconds, at which the insight ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time, in Unix seconds, at which the insight ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>A brief description of the insight.</p>
        pub fn summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.summary = Some(input.into());
            self
        }
        /// <p>A brief description of the insight.</p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.summary = input;
            self
        }
        /// <p>The impact statistics of the client side service. This includes the number of requests
        /// to the client service and whether the requests were faults or okay. </p>
        pub fn client_request_impact_statistics(
            mut self,
            input: crate::model::RequestImpactStatistics,
        ) -> Self {
            self.client_request_impact_statistics = Some(input);
            self
        }
        /// <p>The impact statistics of the client side service. This includes the number of requests
        /// to the client service and whether the requests were faults or okay. </p>
        pub fn set_client_request_impact_statistics(
            mut self,
            input: std::option::Option<crate::model::RequestImpactStatistics>,
        ) -> Self {
            self.client_request_impact_statistics = input;
            self
        }
        /// <p>The impact statistics of the root cause service. This includes the number of requests to
        /// the client service and whether the requests were faults or okay. </p>
        pub fn root_cause_service_request_impact_statistics(
            mut self,
            input: crate::model::RequestImpactStatistics,
        ) -> Self {
            self.root_cause_service_request_impact_statistics = Some(input);
            self
        }
        /// <p>The impact statistics of the root cause service. This includes the number of requests to
        /// the client service and whether the requests were faults or okay. </p>
        pub fn set_root_cause_service_request_impact_statistics(
            mut self,
            input: std::option::Option<crate::model::RequestImpactStatistics>,
        ) -> Self {
            self.root_cause_service_request_impact_statistics = input;
            self
        }
        /// Appends an item to `top_anomalous_services`.
        ///
        /// To override the contents of this collection use [`set_top_anomalous_services`](Self::set_top_anomalous_services).
        ///
        /// <p>The service within the insight that is most impacted by the incident.</p>
        pub fn top_anomalous_services(
            mut self,
            input: impl Into<crate::model::AnomalousService>,
        ) -> Self {
            let mut v = self.top_anomalous_services.unwrap_or_default();
            v.push(input.into());
            self.top_anomalous_services = Some(v);
            self
        }
        /// <p>The service within the insight that is most impacted by the incident.</p>
        pub fn set_top_anomalous_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalousService>>,
        ) -> Self {
            self.top_anomalous_services = input;
            self
        }
        /// <p>The time, in Unix seconds, that the insight was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time, in Unix seconds, that the insight was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightSummary`](crate::model::InsightSummary)
        pub fn build(self) -> crate::model::InsightSummary {
            crate::model::InsightSummary {
                insight_id: self.insight_id,
                group_arn: self.group_arn,
                group_name: self.group_name,
                root_cause_service_id: self.root_cause_service_id,
                categories: self.categories,
                state: self.state,
                start_time: self.start_time,
                end_time: self.end_time,
                summary: self.summary,
                client_request_impact_statistics: self.client_request_impact_statistics,
                root_cause_service_request_impact_statistics: self
                    .root_cause_service_request_impact_statistics,
                top_anomalous_services: self.top_anomalous_services,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl InsightSummary {
    /// Creates a new builder-style object to manufacture [`InsightSummary`](crate::model::InsightSummary)
    pub fn builder() -> crate::model::insight_summary::Builder {
        crate::model::insight_summary::Builder::default()
    }
}

/// <p>The service within the service graph that has anomalously high fault rates. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalousService {
    /// <p></p>
    pub service_id: std::option::Option<crate::model::ServiceId>,
}
impl AnomalousService {
    /// <p></p>
    pub fn service_id(&self) -> std::option::Option<&crate::model::ServiceId> {
        self.service_id.as_ref()
    }
}
impl std::fmt::Debug for AnomalousService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalousService");
        formatter.field("service_id", &self.service_id);
        formatter.finish()
    }
}
/// See [`AnomalousService`](crate::model::AnomalousService)
pub mod anomalous_service {
    /// A builder for [`AnomalousService`](crate::model::AnomalousService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_id: std::option::Option<crate::model::ServiceId>,
    }
    impl Builder {
        /// <p></p>
        pub fn service_id(mut self, input: crate::model::ServiceId) -> Self {
            self.service_id = Some(input);
            self
        }
        /// <p></p>
        pub fn set_service_id(
            mut self,
            input: std::option::Option<crate::model::ServiceId>,
        ) -> Self {
            self.service_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalousService`](crate::model::AnomalousService)
        pub fn build(self) -> crate::model::AnomalousService {
            crate::model::AnomalousService {
                service_id: self.service_id,
            }
        }
    }
}
impl AnomalousService {
    /// Creates a new builder-style object to manufacture [`AnomalousService`](crate::model::AnomalousService)
    pub fn builder() -> crate::model::anomalous_service::Builder {
        crate::model::anomalous_service::Builder::default()
    }
}

/// <p>Statistics that describe how the incident has impacted a service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestImpactStatistics {
    /// <p>The number of requests that have resulted in a fault,</p>
    pub fault_count: std::option::Option<i64>,
    /// <p>The number of successful requests.</p>
    pub ok_count: std::option::Option<i64>,
    /// <p>The total number of requests to the service.</p>
    pub total_count: std::option::Option<i64>,
}
impl RequestImpactStatistics {
    /// <p>The number of requests that have resulted in a fault,</p>
    pub fn fault_count(&self) -> std::option::Option<i64> {
        self.fault_count
    }
    /// <p>The number of successful requests.</p>
    pub fn ok_count(&self) -> std::option::Option<i64> {
        self.ok_count
    }
    /// <p>The total number of requests to the service.</p>
    pub fn total_count(&self) -> std::option::Option<i64> {
        self.total_count
    }
}
impl std::fmt::Debug for RequestImpactStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestImpactStatistics");
        formatter.field("fault_count", &self.fault_count);
        formatter.field("ok_count", &self.ok_count);
        formatter.field("total_count", &self.total_count);
        formatter.finish()
    }
}
/// See [`RequestImpactStatistics`](crate::model::RequestImpactStatistics)
pub mod request_impact_statistics {
    /// A builder for [`RequestImpactStatistics`](crate::model::RequestImpactStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fault_count: std::option::Option<i64>,
        pub(crate) ok_count: std::option::Option<i64>,
        pub(crate) total_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of requests that have resulted in a fault,</p>
        pub fn fault_count(mut self, input: i64) -> Self {
            self.fault_count = Some(input);
            self
        }
        /// <p>The number of requests that have resulted in a fault,</p>
        pub fn set_fault_count(mut self, input: std::option::Option<i64>) -> Self {
            self.fault_count = input;
            self
        }
        /// <p>The number of successful requests.</p>
        pub fn ok_count(mut self, input: i64) -> Self {
            self.ok_count = Some(input);
            self
        }
        /// <p>The number of successful requests.</p>
        pub fn set_ok_count(mut self, input: std::option::Option<i64>) -> Self {
            self.ok_count = input;
            self
        }
        /// <p>The total number of requests to the service.</p>
        pub fn total_count(mut self, input: i64) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of requests to the service.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i64>) -> Self {
            self.total_count = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestImpactStatistics`](crate::model::RequestImpactStatistics)
        pub fn build(self) -> crate::model::RequestImpactStatistics {
            crate::model::RequestImpactStatistics {
                fault_count: self.fault_count,
                ok_count: self.ok_count,
                total_count: self.total_count,
            }
        }
    }
}
impl RequestImpactStatistics {
    /// Creates a new builder-style object to manufacture [`RequestImpactStatistics`](crate::model::RequestImpactStatistics)
    pub fn builder() -> crate::model::request_impact_statistics::Builder {
        crate::model::request_impact_statistics::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => InsightState::Active,
            "CLOSED" => InsightState::Closed,
            other => InsightState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightState::from(s))
    }
}
impl InsightState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightState::Active => "ACTIVE",
            InsightState::Closed => "CLOSED",
            InsightState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CLOSED"]
    }
}
impl AsRef<str> for InsightState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightCategory {
    #[allow(missing_docs)] // documentation missing in model
    Fault,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightCategory {
    fn from(s: &str) -> Self {
        match s {
            "FAULT" => InsightCategory::Fault,
            other => InsightCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightCategory::from(s))
    }
}
impl InsightCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightCategory::Fault => "FAULT",
            InsightCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAULT"]
    }
}
impl AsRef<str> for InsightCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an application that processed requests, users that made requests, or downstream services,
/// resources, and applications that an application used. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightImpactGraphService {
    /// <p>Identifier for the service. Unique within the service map.</p>
    pub reference_id: std::option::Option<i32>,
    /// <p>Identifier for the service. Unique within the service map.</p>
    /// <ul>
    /// <li>
    /// <p>Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, AWS::EC2::Instance for an application running
    /// on Amazon EC2 or AWS::DynamoDB::Table for an Amazon DynamoDB table that the application used. </p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for downstream calls to Amazon
    /// DynamoDB that didn't target a specific table. </p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for downstream calls to Amazon
    /// DynamoDB that didn't target a specific table. </p>
    /// </li>
    /// <li>
    /// <p>remote - A downstream service of indeterminate type.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The canonical name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of names for the service, including the canonical name.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Identifier of the Amazon Web Services account in which the service runs.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Connections to downstream services.</p>
    pub edges: std::option::Option<std::vec::Vec<crate::model::InsightImpactGraphEdge>>,
}
impl InsightImpactGraphService {
    /// <p>Identifier for the service. Unique within the service map.</p>
    pub fn reference_id(&self) -> std::option::Option<i32> {
        self.reference_id
    }
    /// <p>Identifier for the service. Unique within the service map.</p>
    /// <ul>
    /// <li>
    /// <p>Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, AWS::EC2::Instance for an application running
    /// on Amazon EC2 or AWS::DynamoDB::Table for an Amazon DynamoDB table that the application used. </p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for downstream calls to Amazon
    /// DynamoDB that didn't target a specific table. </p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for downstream calls to Amazon
    /// DynamoDB that didn't target a specific table. </p>
    /// </li>
    /// <li>
    /// <p>remote - A downstream service of indeterminate type.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The canonical name of the service.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of names for the service, including the canonical name.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>Identifier of the Amazon Web Services account in which the service runs.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Connections to downstream services.</p>
    pub fn edges(&self) -> std::option::Option<&[crate::model::InsightImpactGraphEdge]> {
        self.edges.as_deref()
    }
}
impl std::fmt::Debug for InsightImpactGraphService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightImpactGraphService");
        formatter.field("reference_id", &self.reference_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("names", &self.names);
        formatter.field("account_id", &self.account_id);
        formatter.field("edges", &self.edges);
        formatter.finish()
    }
}
/// See [`InsightImpactGraphService`](crate::model::InsightImpactGraphService)
pub mod insight_impact_graph_service {
    /// A builder for [`InsightImpactGraphService`](crate::model::InsightImpactGraphService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reference_id: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) edges: std::option::Option<std::vec::Vec<crate::model::InsightImpactGraphEdge>>,
    }
    impl Builder {
        /// <p>Identifier for the service. Unique within the service map.</p>
        pub fn reference_id(mut self, input: i32) -> Self {
            self.reference_id = Some(input);
            self
        }
        /// <p>Identifier for the service. Unique within the service map.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<i32>) -> Self {
            self.reference_id = input;
            self
        }
        /// <p>Identifier for the service. Unique within the service map.</p>
        /// <ul>
        /// <li>
        /// <p>Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, AWS::EC2::Instance for an application running
        /// on Amazon EC2 or AWS::DynamoDB::Table for an Amazon DynamoDB table that the application used. </p>
        /// </li>
        /// <li>
        /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for downstream calls to Amazon
        /// DynamoDB that didn't target a specific table. </p>
        /// </li>
        /// <li>
        /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for downstream calls to Amazon
        /// DynamoDB that didn't target a specific table. </p>
        /// </li>
        /// <li>
        /// <p>remote - A downstream service of indeterminate type.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Identifier for the service. Unique within the service map.</p>
        /// <ul>
        /// <li>
        /// <p>Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, AWS::EC2::Instance for an application running
        /// on Amazon EC2 or AWS::DynamoDB::Table for an Amazon DynamoDB table that the application used. </p>
        /// </li>
        /// <li>
        /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for downstream calls to Amazon
        /// DynamoDB that didn't target a specific table. </p>
        /// </li>
        /// <li>
        /// <p>Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for downstream calls to Amazon
        /// DynamoDB that didn't target a specific table. </p>
        /// </li>
        /// <li>
        /// <p>remote - A downstream service of indeterminate type.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The canonical name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The canonical name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A list of names for the service, including the canonical name.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>A list of names for the service, including the canonical name.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>Identifier of the Amazon Web Services account in which the service runs.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>Identifier of the Amazon Web Services account in which the service runs.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `edges`.
        ///
        /// To override the contents of this collection use [`set_edges`](Self::set_edges).
        ///
        /// <p>Connections to downstream services.</p>
        pub fn edges(mut self, input: impl Into<crate::model::InsightImpactGraphEdge>) -> Self {
            let mut v = self.edges.unwrap_or_default();
            v.push(input.into());
            self.edges = Some(v);
            self
        }
        /// <p>Connections to downstream services.</p>
        pub fn set_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightImpactGraphEdge>>,
        ) -> Self {
            self.edges = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightImpactGraphService`](crate::model::InsightImpactGraphService)
        pub fn build(self) -> crate::model::InsightImpactGraphService {
            crate::model::InsightImpactGraphService {
                reference_id: self.reference_id,
                r#type: self.r#type,
                name: self.name,
                names: self.names,
                account_id: self.account_id,
                edges: self.edges,
            }
        }
    }
}
impl InsightImpactGraphService {
    /// Creates a new builder-style object to manufacture [`InsightImpactGraphService`](crate::model::InsightImpactGraphService)
    pub fn builder() -> crate::model::insight_impact_graph_service::Builder {
        crate::model::insight_impact_graph_service::Builder::default()
    }
}

/// <p>The connection between two service in an insight impact graph.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightImpactGraphEdge {
    /// <p>Identifier of the edge. Unique within a service map.</p>
    pub reference_id: std::option::Option<i32>,
}
impl InsightImpactGraphEdge {
    /// <p>Identifier of the edge. Unique within a service map.</p>
    pub fn reference_id(&self) -> std::option::Option<i32> {
        self.reference_id
    }
}
impl std::fmt::Debug for InsightImpactGraphEdge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightImpactGraphEdge");
        formatter.field("reference_id", &self.reference_id);
        formatter.finish()
    }
}
/// See [`InsightImpactGraphEdge`](crate::model::InsightImpactGraphEdge)
pub mod insight_impact_graph_edge {
    /// A builder for [`InsightImpactGraphEdge`](crate::model::InsightImpactGraphEdge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reference_id: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Identifier of the edge. Unique within a service map.</p>
        pub fn reference_id(mut self, input: i32) -> Self {
            self.reference_id = Some(input);
            self
        }
        /// <p>Identifier of the edge. Unique within a service map.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<i32>) -> Self {
            self.reference_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightImpactGraphEdge`](crate::model::InsightImpactGraphEdge)
        pub fn build(self) -> crate::model::InsightImpactGraphEdge {
            crate::model::InsightImpactGraphEdge {
                reference_id: self.reference_id,
            }
        }
    }
}
impl InsightImpactGraphEdge {
    /// Creates a new builder-style object to manufacture [`InsightImpactGraphEdge`](crate::model::InsightImpactGraphEdge)
    pub fn builder() -> crate::model::insight_impact_graph_edge::Builder {
        crate::model::insight_impact_graph_edge::Builder::default()
    }
}

/// <p>X-Ray reevaluates insights periodically until they are resolved, and records each intermediate state in an
/// event. You can review incident events in the Impact Timeline on the Inspect page in the X-Ray console.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightEvent {
    /// <p>A brief description of the event.</p>
    pub summary: std::option::Option<std::string::String>,
    /// <p>The time, in Unix seconds, at which the event was recorded.</p>
    pub event_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The impact statistics of the client side service. This includes the number of requests to the client service
    /// and whether the requests were faults or okay.</p>
    pub client_request_impact_statistics:
        std::option::Option<crate::model::RequestImpactStatistics>,
    /// <p>The impact statistics of the root cause service. This includes the number of requests to the client service
    /// and whether the requests were faults or okay.</p>
    pub root_cause_service_request_impact_statistics:
        std::option::Option<crate::model::RequestImpactStatistics>,
    /// <p>The service during the event that is most impacted by the incident.</p>
    pub top_anomalous_services: std::option::Option<std::vec::Vec<crate::model::AnomalousService>>,
}
impl InsightEvent {
    /// <p>A brief description of the event.</p>
    pub fn summary(&self) -> std::option::Option<&str> {
        self.summary.as_deref()
    }
    /// <p>The time, in Unix seconds, at which the event was recorded.</p>
    pub fn event_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.event_time.as_ref()
    }
    /// <p>The impact statistics of the client side service. This includes the number of requests to the client service
    /// and whether the requests were faults or okay.</p>
    pub fn client_request_impact_statistics(
        &self,
    ) -> std::option::Option<&crate::model::RequestImpactStatistics> {
        self.client_request_impact_statistics.as_ref()
    }
    /// <p>The impact statistics of the root cause service. This includes the number of requests to the client service
    /// and whether the requests were faults or okay.</p>
    pub fn root_cause_service_request_impact_statistics(
        &self,
    ) -> std::option::Option<&crate::model::RequestImpactStatistics> {
        self.root_cause_service_request_impact_statistics.as_ref()
    }
    /// <p>The service during the event that is most impacted by the incident.</p>
    pub fn top_anomalous_services(&self) -> std::option::Option<&[crate::model::AnomalousService]> {
        self.top_anomalous_services.as_deref()
    }
}
impl std::fmt::Debug for InsightEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightEvent");
        formatter.field("summary", &self.summary);
        formatter.field("event_time", &self.event_time);
        formatter.field(
            "client_request_impact_statistics",
            &self.client_request_impact_statistics,
        );
        formatter.field(
            "root_cause_service_request_impact_statistics",
            &self.root_cause_service_request_impact_statistics,
        );
        formatter.field("top_anomalous_services", &self.top_anomalous_services);
        formatter.finish()
    }
}
/// See [`InsightEvent`](crate::model::InsightEvent)
pub mod insight_event {
    /// A builder for [`InsightEvent`](crate::model::InsightEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<std::string::String>,
        pub(crate) event_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) client_request_impact_statistics:
            std::option::Option<crate::model::RequestImpactStatistics>,
        pub(crate) root_cause_service_request_impact_statistics:
            std::option::Option<crate::model::RequestImpactStatistics>,
        pub(crate) top_anomalous_services:
            std::option::Option<std::vec::Vec<crate::model::AnomalousService>>,
    }
    impl Builder {
        /// <p>A brief description of the event.</p>
        pub fn summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.summary = Some(input.into());
            self
        }
        /// <p>A brief description of the event.</p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.summary = input;
            self
        }
        /// <p>The time, in Unix seconds, at which the event was recorded.</p>
        pub fn event_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_time = Some(input);
            self
        }
        /// <p>The time, in Unix seconds, at which the event was recorded.</p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_time = input;
            self
        }
        /// <p>The impact statistics of the client side service. This includes the number of requests to the client service
        /// and whether the requests were faults or okay.</p>
        pub fn client_request_impact_statistics(
            mut self,
            input: crate::model::RequestImpactStatistics,
        ) -> Self {
            self.client_request_impact_statistics = Some(input);
            self
        }
        /// <p>The impact statistics of the client side service. This includes the number of requests to the client service
        /// and whether the requests were faults or okay.</p>
        pub fn set_client_request_impact_statistics(
            mut self,
            input: std::option::Option<crate::model::RequestImpactStatistics>,
        ) -> Self {
            self.client_request_impact_statistics = input;
            self
        }
        /// <p>The impact statistics of the root cause service. This includes the number of requests to the client service
        /// and whether the requests were faults or okay.</p>
        pub fn root_cause_service_request_impact_statistics(
            mut self,
            input: crate::model::RequestImpactStatistics,
        ) -> Self {
            self.root_cause_service_request_impact_statistics = Some(input);
            self
        }
        /// <p>The impact statistics of the root cause service. This includes the number of requests to the client service
        /// and whether the requests were faults or okay.</p>
        pub fn set_root_cause_service_request_impact_statistics(
            mut self,
            input: std::option::Option<crate::model::RequestImpactStatistics>,
        ) -> Self {
            self.root_cause_service_request_impact_statistics = input;
            self
        }
        /// Appends an item to `top_anomalous_services`.
        ///
        /// To override the contents of this collection use [`set_top_anomalous_services`](Self::set_top_anomalous_services).
        ///
        /// <p>The service during the event that is most impacted by the incident.</p>
        pub fn top_anomalous_services(
            mut self,
            input: impl Into<crate::model::AnomalousService>,
        ) -> Self {
            let mut v = self.top_anomalous_services.unwrap_or_default();
            v.push(input.into());
            self.top_anomalous_services = Some(v);
            self
        }
        /// <p>The service during the event that is most impacted by the incident.</p>
        pub fn set_top_anomalous_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalousService>>,
        ) -> Self {
            self.top_anomalous_services = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightEvent`](crate::model::InsightEvent)
        pub fn build(self) -> crate::model::InsightEvent {
            crate::model::InsightEvent {
                summary: self.summary,
                event_time: self.event_time,
                client_request_impact_statistics: self.client_request_impact_statistics,
                root_cause_service_request_impact_statistics: self
                    .root_cause_service_request_impact_statistics,
                top_anomalous_services: self.top_anomalous_services,
            }
        }
    }
}
impl InsightEvent {
    /// Creates a new builder-style object to manufacture [`InsightEvent`](crate::model::InsightEvent)
    pub fn builder() -> crate::model::insight_event::Builder {
        crate::model::insight_event::Builder::default()
    }
}

/// <p>When fault rates go outside of the expected range, X-Ray creates an insight. Insights
/// tracks emergent issues within your applications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Insight {
    /// <p>The insights unique identifier. </p>
    pub insight_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the group that the insight belongs to.</p>
    pub group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the group  that the insight belongs to.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p></p>
    pub root_cause_service_id: std::option::Option<crate::model::ServiceId>,
    /// <p>The categories that label and describe the type of insight.</p>
    pub categories: std::option::Option<std::vec::Vec<crate::model::InsightCategory>>,
    /// <p>The current state of the insight.</p>
    pub state: std::option::Option<crate::model::InsightState>,
    /// <p>The time, in Unix seconds, at which the insight began.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time, in Unix seconds, at which the insight ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A brief description of the insight.</p>
    pub summary: std::option::Option<std::string::String>,
    /// <p>The impact statistics of the client side service. This includes the number of requests to the client service
    /// and whether the requests were faults or okay.</p>
    pub client_request_impact_statistics:
        std::option::Option<crate::model::RequestImpactStatistics>,
    /// <p>The impact statistics of the root cause service. This includes the number of requests to the client service
    /// and whether the requests were faults or okay.</p>
    pub root_cause_service_request_impact_statistics:
        std::option::Option<crate::model::RequestImpactStatistics>,
    /// <p>The service within the insight that is most impacted by the incident.</p>
    pub top_anomalous_services: std::option::Option<std::vec::Vec<crate::model::AnomalousService>>,
}
impl Insight {
    /// <p>The insights unique identifier. </p>
    pub fn insight_id(&self) -> std::option::Option<&str> {
        self.insight_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the group that the insight belongs to.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
    /// <p>The name of the group  that the insight belongs to.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p></p>
    pub fn root_cause_service_id(&self) -> std::option::Option<&crate::model::ServiceId> {
        self.root_cause_service_id.as_ref()
    }
    /// <p>The categories that label and describe the type of insight.</p>
    pub fn categories(&self) -> std::option::Option<&[crate::model::InsightCategory]> {
        self.categories.as_deref()
    }
    /// <p>The current state of the insight.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::InsightState> {
        self.state.as_ref()
    }
    /// <p>The time, in Unix seconds, at which the insight began.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The time, in Unix seconds, at which the insight ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>A brief description of the insight.</p>
    pub fn summary(&self) -> std::option::Option<&str> {
        self.summary.as_deref()
    }
    /// <p>The impact statistics of the client side service. This includes the number of requests to the client service
    /// and whether the requests were faults or okay.</p>
    pub fn client_request_impact_statistics(
        &self,
    ) -> std::option::Option<&crate::model::RequestImpactStatistics> {
        self.client_request_impact_statistics.as_ref()
    }
    /// <p>The impact statistics of the root cause service. This includes the number of requests to the client service
    /// and whether the requests were faults or okay.</p>
    pub fn root_cause_service_request_impact_statistics(
        &self,
    ) -> std::option::Option<&crate::model::RequestImpactStatistics> {
        self.root_cause_service_request_impact_statistics.as_ref()
    }
    /// <p>The service within the insight that is most impacted by the incident.</p>
    pub fn top_anomalous_services(&self) -> std::option::Option<&[crate::model::AnomalousService]> {
        self.top_anomalous_services.as_deref()
    }
}
impl std::fmt::Debug for Insight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Insight");
        formatter.field("insight_id", &self.insight_id);
        formatter.field("group_arn", &self.group_arn);
        formatter.field("group_name", &self.group_name);
        formatter.field("root_cause_service_id", &self.root_cause_service_id);
        formatter.field("categories", &self.categories);
        formatter.field("state", &self.state);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("summary", &self.summary);
        formatter.field(
            "client_request_impact_statistics",
            &self.client_request_impact_statistics,
        );
        formatter.field(
            "root_cause_service_request_impact_statistics",
            &self.root_cause_service_request_impact_statistics,
        );
        formatter.field("top_anomalous_services", &self.top_anomalous_services);
        formatter.finish()
    }
}
/// See [`Insight`](crate::model::Insight)
pub mod insight {
    /// A builder for [`Insight`](crate::model::Insight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) root_cause_service_id: std::option::Option<crate::model::ServiceId>,
        pub(crate) categories: std::option::Option<std::vec::Vec<crate::model::InsightCategory>>,
        pub(crate) state: std::option::Option<crate::model::InsightState>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) summary: std::option::Option<std::string::String>,
        pub(crate) client_request_impact_statistics:
            std::option::Option<crate::model::RequestImpactStatistics>,
        pub(crate) root_cause_service_request_impact_statistics:
            std::option::Option<crate::model::RequestImpactStatistics>,
        pub(crate) top_anomalous_services:
            std::option::Option<std::vec::Vec<crate::model::AnomalousService>>,
    }
    impl Builder {
        /// <p>The insights unique identifier. </p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p>The insights unique identifier. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group that the insight belongs to.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group that the insight belongs to.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// <p>The name of the group  that the insight belongs to.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group  that the insight belongs to.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p></p>
        pub fn root_cause_service_id(mut self, input: crate::model::ServiceId) -> Self {
            self.root_cause_service_id = Some(input);
            self
        }
        /// <p></p>
        pub fn set_root_cause_service_id(
            mut self,
            input: std::option::Option<crate::model::ServiceId>,
        ) -> Self {
            self.root_cause_service_id = input;
            self
        }
        /// Appends an item to `categories`.
        ///
        /// To override the contents of this collection use [`set_categories`](Self::set_categories).
        ///
        /// <p>The categories that label and describe the type of insight.</p>
        pub fn categories(mut self, input: impl Into<crate::model::InsightCategory>) -> Self {
            let mut v = self.categories.unwrap_or_default();
            v.push(input.into());
            self.categories = Some(v);
            self
        }
        /// <p>The categories that label and describe the type of insight.</p>
        pub fn set_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightCategory>>,
        ) -> Self {
            self.categories = input;
            self
        }
        /// <p>The current state of the insight.</p>
        pub fn state(mut self, input: crate::model::InsightState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the insight.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::InsightState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The time, in Unix seconds, at which the insight began.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time, in Unix seconds, at which the insight began.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time, in Unix seconds, at which the insight ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time, in Unix seconds, at which the insight ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>A brief description of the insight.</p>
        pub fn summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.summary = Some(input.into());
            self
        }
        /// <p>A brief description of the insight.</p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.summary = input;
            self
        }
        /// <p>The impact statistics of the client side service. This includes the number of requests to the client service
        /// and whether the requests were faults or okay.</p>
        pub fn client_request_impact_statistics(
            mut self,
            input: crate::model::RequestImpactStatistics,
        ) -> Self {
            self.client_request_impact_statistics = Some(input);
            self
        }
        /// <p>The impact statistics of the client side service. This includes the number of requests to the client service
        /// and whether the requests were faults or okay.</p>
        pub fn set_client_request_impact_statistics(
            mut self,
            input: std::option::Option<crate::model::RequestImpactStatistics>,
        ) -> Self {
            self.client_request_impact_statistics = input;
            self
        }
        /// <p>The impact statistics of the root cause service. This includes the number of requests to the client service
        /// and whether the requests were faults or okay.</p>
        pub fn root_cause_service_request_impact_statistics(
            mut self,
            input: crate::model::RequestImpactStatistics,
        ) -> Self {
            self.root_cause_service_request_impact_statistics = Some(input);
            self
        }
        /// <p>The impact statistics of the root cause service. This includes the number of requests to the client service
        /// and whether the requests were faults or okay.</p>
        pub fn set_root_cause_service_request_impact_statistics(
            mut self,
            input: std::option::Option<crate::model::RequestImpactStatistics>,
        ) -> Self {
            self.root_cause_service_request_impact_statistics = input;
            self
        }
        /// Appends an item to `top_anomalous_services`.
        ///
        /// To override the contents of this collection use [`set_top_anomalous_services`](Self::set_top_anomalous_services).
        ///
        /// <p>The service within the insight that is most impacted by the incident.</p>
        pub fn top_anomalous_services(
            mut self,
            input: impl Into<crate::model::AnomalousService>,
        ) -> Self {
            let mut v = self.top_anomalous_services.unwrap_or_default();
            v.push(input.into());
            self.top_anomalous_services = Some(v);
            self
        }
        /// <p>The service within the insight that is most impacted by the incident.</p>
        pub fn set_top_anomalous_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalousService>>,
        ) -> Self {
            self.top_anomalous_services = input;
            self
        }
        /// Consumes the builder and constructs a [`Insight`](crate::model::Insight)
        pub fn build(self) -> crate::model::Insight {
            crate::model::Insight {
                insight_id: self.insight_id,
                group_arn: self.group_arn,
                group_name: self.group_name,
                root_cause_service_id: self.root_cause_service_id,
                categories: self.categories,
                state: self.state,
                start_time: self.start_time,
                end_time: self.end_time,
                summary: self.summary,
                client_request_impact_statistics: self.client_request_impact_statistics,
                root_cause_service_request_impact_statistics: self
                    .root_cause_service_request_impact_statistics,
                top_anomalous_services: self.top_anomalous_services,
            }
        }
    }
}
impl Insight {
    /// Creates a new builder-style object to manufacture [`Insight`](crate::model::Insight)
    pub fn builder() -> crate::model::insight::Builder {
        crate::model::insight::Builder::default()
    }
}

/// <p>Details for a group without metadata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupSummary {
    /// <p>The unique case-sensitive name of the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the group generated based on the GroupName.</p>
    pub group_arn: std::option::Option<std::string::String>,
    /// <p>The filter expression defining the parameters to include traces.</p>
    pub filter_expression: std::option::Option<std::string::String>,
    /// <p>The structure containing configurations related to insights.</p>
    /// <ul>
    /// <li>
    /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
    /// group or false to disable insights for the group.</p>
    /// </li>
    /// <li>
    /// <p>The NotificationsEnabled boolean can be set to true to enable insights notifications.
    /// Notifications can only be enabled on a group with InsightsEnabled set to true.</p>
    /// </li>
    /// </ul>
    pub insights_configuration: std::option::Option<crate::model::InsightsConfiguration>,
}
impl GroupSummary {
    /// <p>The unique case-sensitive name of the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The ARN of the group generated based on the GroupName.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
    /// <p>The filter expression defining the parameters to include traces.</p>
    pub fn filter_expression(&self) -> std::option::Option<&str> {
        self.filter_expression.as_deref()
    }
    /// <p>The structure containing configurations related to insights.</p>
    /// <ul>
    /// <li>
    /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
    /// group or false to disable insights for the group.</p>
    /// </li>
    /// <li>
    /// <p>The NotificationsEnabled boolean can be set to true to enable insights notifications.
    /// Notifications can only be enabled on a group with InsightsEnabled set to true.</p>
    /// </li>
    /// </ul>
    pub fn insights_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InsightsConfiguration> {
        self.insights_configuration.as_ref()
    }
}
impl std::fmt::Debug for GroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupSummary");
        formatter.field("group_name", &self.group_name);
        formatter.field("group_arn", &self.group_arn);
        formatter.field("filter_expression", &self.filter_expression);
        formatter.field("insights_configuration", &self.insights_configuration);
        formatter.finish()
    }
}
/// See [`GroupSummary`](crate::model::GroupSummary)
pub mod group_summary {
    /// A builder for [`GroupSummary`](crate::model::GroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
        pub(crate) filter_expression: std::option::Option<std::string::String>,
        pub(crate) insights_configuration: std::option::Option<crate::model::InsightsConfiguration>,
    }
    impl Builder {
        /// <p>The unique case-sensitive name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The unique case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The ARN of the group generated based on the GroupName.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the group generated based on the GroupName.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// <p>The filter expression defining the parameters to include traces.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>The filter expression defining the parameters to include traces.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// group or false to disable insights for the group.</p>
        /// </li>
        /// <li>
        /// <p>The NotificationsEnabled boolean can be set to true to enable insights notifications.
        /// Notifications can only be enabled on a group with InsightsEnabled set to true.</p>
        /// </li>
        /// </ul>
        pub fn insights_configuration(
            mut self,
            input: crate::model::InsightsConfiguration,
        ) -> Self {
            self.insights_configuration = Some(input);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// group or false to disable insights for the group.</p>
        /// </li>
        /// <li>
        /// <p>The NotificationsEnabled boolean can be set to true to enable insights notifications.
        /// Notifications can only be enabled on a group with InsightsEnabled set to true.</p>
        /// </li>
        /// </ul>
        pub fn set_insights_configuration(
            mut self,
            input: std::option::Option<crate::model::InsightsConfiguration>,
        ) -> Self {
            self.insights_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupSummary`](crate::model::GroupSummary)
        pub fn build(self) -> crate::model::GroupSummary {
            crate::model::GroupSummary {
                group_name: self.group_name,
                group_arn: self.group_arn,
                filter_expression: self.filter_expression,
                insights_configuration: self.insights_configuration,
            }
        }
    }
}
impl GroupSummary {
    /// Creates a new builder-style object to manufacture [`GroupSummary`](crate::model::GroupSummary)
    pub fn builder() -> crate::model::group_summary::Builder {
        crate::model::group_summary::Builder::default()
    }
}

/// <p>A collection of segment documents with matching trace IDs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Trace {
    /// <p>The unique identifier for the request that generated the trace's segments and
    /// subsegments.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The length of time in seconds between the start time of the root segment and the end
    /// time of the last segment that completed.</p>
    pub duration: std::option::Option<f64>,
    /// <p>LimitExceeded is set to true when the trace has exceeded one of the defined quotas. For
    /// more information about quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/xray.html">Amazon Web Services X-Ray endpoints and quotas</a>.</p>
    pub limit_exceeded: std::option::Option<bool>,
    /// <p>Segment documents for the segments and subsegments that comprise the trace.</p>
    pub segments: std::option::Option<std::vec::Vec<crate::model::Segment>>,
}
impl Trace {
    /// <p>The unique identifier for the request that generated the trace's segments and
    /// subsegments.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The length of time in seconds between the start time of the root segment and the end
    /// time of the last segment that completed.</p>
    pub fn duration(&self) -> std::option::Option<f64> {
        self.duration
    }
    /// <p>LimitExceeded is set to true when the trace has exceeded one of the defined quotas. For
    /// more information about quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/xray.html">Amazon Web Services X-Ray endpoints and quotas</a>.</p>
    pub fn limit_exceeded(&self) -> std::option::Option<bool> {
        self.limit_exceeded
    }
    /// <p>Segment documents for the segments and subsegments that comprise the trace.</p>
    pub fn segments(&self) -> std::option::Option<&[crate::model::Segment]> {
        self.segments.as_deref()
    }
}
impl std::fmt::Debug for Trace {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Trace");
        formatter.field("id", &self.id);
        formatter.field("duration", &self.duration);
        formatter.field("limit_exceeded", &self.limit_exceeded);
        formatter.field("segments", &self.segments);
        formatter.finish()
    }
}
/// See [`Trace`](crate::model::Trace)
pub mod trace {
    /// A builder for [`Trace`](crate::model::Trace)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<f64>,
        pub(crate) limit_exceeded: std::option::Option<bool>,
        pub(crate) segments: std::option::Option<std::vec::Vec<crate::model::Segment>>,
    }
    impl Builder {
        /// <p>The unique identifier for the request that generated the trace's segments and
        /// subsegments.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the request that generated the trace's segments and
        /// subsegments.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The length of time in seconds between the start time of the root segment and the end
        /// time of the last segment that completed.</p>
        pub fn duration(mut self, input: f64) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The length of time in seconds between the start time of the root segment and the end
        /// time of the last segment that completed.</p>
        pub fn set_duration(mut self, input: std::option::Option<f64>) -> Self {
            self.duration = input;
            self
        }
        /// <p>LimitExceeded is set to true when the trace has exceeded one of the defined quotas. For
        /// more information about quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/xray.html">Amazon Web Services X-Ray endpoints and quotas</a>.</p>
        pub fn limit_exceeded(mut self, input: bool) -> Self {
            self.limit_exceeded = Some(input);
            self
        }
        /// <p>LimitExceeded is set to true when the trace has exceeded one of the defined quotas. For
        /// more information about quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/xray.html">Amazon Web Services X-Ray endpoints and quotas</a>.</p>
        pub fn set_limit_exceeded(mut self, input: std::option::Option<bool>) -> Self {
            self.limit_exceeded = input;
            self
        }
        /// Appends an item to `segments`.
        ///
        /// To override the contents of this collection use [`set_segments`](Self::set_segments).
        ///
        /// <p>Segment documents for the segments and subsegments that comprise the trace.</p>
        pub fn segments(mut self, input: impl Into<crate::model::Segment>) -> Self {
            let mut v = self.segments.unwrap_or_default();
            v.push(input.into());
            self.segments = Some(v);
            self
        }
        /// <p>Segment documents for the segments and subsegments that comprise the trace.</p>
        pub fn set_segments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Segment>>,
        ) -> Self {
            self.segments = input;
            self
        }
        /// Consumes the builder and constructs a [`Trace`](crate::model::Trace)
        pub fn build(self) -> crate::model::Trace {
            crate::model::Trace {
                id: self.id,
                duration: self.duration,
                limit_exceeded: self.limit_exceeded,
                segments: self.segments,
            }
        }
    }
}
impl Trace {
    /// Creates a new builder-style object to manufacture [`Trace`](crate::model::Trace)
    pub fn builder() -> crate::model::trace::Builder {
        crate::model::trace::Builder::default()
    }
}

/// <p>A segment from a trace that has been ingested by the X-Ray service. The segment can be
/// compiled from documents uploaded with <a href="https://docs.aws.amazon.com/xray/latest/api/API_PutTraceSegments.html">PutTraceSegments</a>, or an
/// <code>inferred</code> segment for a downstream service, generated from a subsegment sent by
/// the service that called it.</p>
/// <p>For the full segment document schema, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html">Amazon Web Services X-Ray Segment
/// Documents</a> in the <i>Amazon Web Services X-Ray Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Segment {
    /// <p>The segment's ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The segment document.</p>
    pub document: std::option::Option<std::string::String>,
}
impl Segment {
    /// <p>The segment's ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The segment document.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
}
impl std::fmt::Debug for Segment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Segment");
        formatter.field("id", &self.id);
        formatter.field("document", &self.document);
        formatter.finish()
    }
}
/// See [`Segment`](crate::model::Segment)
pub mod segment {
    /// A builder for [`Segment`](crate::model::Segment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The segment's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The segment's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The segment document.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The segment document.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// Consumes the builder and constructs a [`Segment`](crate::model::Segment)
        pub fn build(self) -> crate::model::Segment {
            crate::model::Segment {
                id: self.id,
                document: self.document,
            }
        }
    }
}
impl Segment {
    /// Creates a new builder-style object to manufacture [`Segment`](crate::model::Segment)
    pub fn builder() -> crate::model::segment::Builder {
        crate::model::segment::Builder::default()
    }
}
