// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchGetTracesInput`](crate::input::BatchGetTracesInput)
pub mod batch_get_traces_input {
    /// A builder for [`BatchGetTracesInput`](crate::input::BatchGetTracesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trace_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `trace_ids`.
        ///
        /// To override the contents of this collection use [`set_trace_ids`](Self::set_trace_ids).
        ///
        /// <p>Specify the trace IDs of requests for which to retrieve segments.</p>
        pub fn trace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trace_ids.unwrap_or_default();
            v.push(input.into());
            self.trace_ids = Some(v);
            self
        }
        /// <p>Specify the trace IDs of requests for which to retrieve segments.</p>
        pub fn set_trace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trace_ids = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetTracesInput`](crate::input::BatchGetTracesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetTracesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetTracesInput {
                trace_ids: self.trace_ids,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetTracesInputOperationOutputAlias = crate::operation::BatchGetTraces;
#[doc(hidden)]
pub type BatchGetTracesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchGetTracesInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetTraces`](crate::operation::BatchGetTraces)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetTraces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetTracesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/Traces").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetTracesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetTracesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_get_traces(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetTraces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetTraces",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetTracesInput`](crate::input::BatchGetTracesInput)
    pub fn builder() -> crate::input::batch_get_traces_input::Builder {
        crate::input::batch_get_traces_input::Builder::default()
    }
}

/// See [`CreateGroupInput`](crate::input::CreateGroupInput)
pub mod create_group_input {
    /// A builder for [`CreateGroupInput`](crate::input::CreateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) filter_expression: std::option::Option<std::string::String>,
        pub(crate) insights_configuration: std::option::Option<crate::model::InsightsConfiguration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The case-sensitive name of the new group. Default is a reserved name and names must
        /// be unique.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The case-sensitive name of the new group. Default is a reserved name and names must
        /// be unique.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The filter expression defining criteria by which to group traces.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>The filter expression defining criteria by which to group traces.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// new group or false to disable insights for the new group.</p>
        /// </li>
        /// <li>
        /// <p>The NotifcationsEnabled boolean can be set to true to enable insights
        /// notifications for the new group. Notifications may only be enabled on a group
        /// with InsightsEnabled set to true.</p>
        /// </li>
        /// </ul>
        pub fn insights_configuration(
            mut self,
            input: crate::model::InsightsConfiguration,
        ) -> Self {
            self.insights_configuration = Some(input);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// new group or false to disable insights for the new group.</p>
        /// </li>
        /// <li>
        /// <p>The NotifcationsEnabled boolean can be set to true to enable insights
        /// notifications for the new group. Notifications may only be enabled on a group
        /// with InsightsEnabled set to true.</p>
        /// </li>
        /// </ul>
        pub fn set_insights_configuration(
            mut self,
            input: std::option::Option<crate::model::InsightsConfiguration>,
        ) -> Self {
            self.insights_configuration = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group.
        /// For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group.
        /// For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupInput`](crate::input::CreateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGroupInput {
                group_name: self.group_name,
                filter_expression: self.filter_expression,
                insights_configuration: self.insights_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGroupInputOperationOutputAlias = crate::operation::CreateGroup;
#[doc(hidden)]
pub type CreateGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateGroup`](crate::operation::CreateGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/CreateGroup").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGroup",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
}

/// See [`CreateSamplingRuleInput`](crate::input::CreateSamplingRuleInput)
pub mod create_sampling_rule_input {
    /// A builder for [`CreateSamplingRuleInput`](crate::input::CreateSamplingRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampling_rule: std::option::Option<crate::model::SamplingRule>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The rule definition.</p>
        pub fn sampling_rule(mut self, input: crate::model::SamplingRule) -> Self {
            self.sampling_rule = Some(input);
            self
        }
        /// <p>The rule definition.</p>
        pub fn set_sampling_rule(
            mut self,
            input: std::option::Option<crate::model::SamplingRule>,
        ) -> Self {
            self.sampling_rule = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray sampling
        /// rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray sampling
        /// rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSamplingRuleInput`](crate::input::CreateSamplingRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSamplingRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSamplingRuleInput {
                sampling_rule: self.sampling_rule,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSamplingRuleInputOperationOutputAlias = crate::operation::CreateSamplingRule;
#[doc(hidden)]
pub type CreateSamplingRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSamplingRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateSamplingRule`](crate::operation::CreateSamplingRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSamplingRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSamplingRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/CreateSamplingRule").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSamplingRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSamplingRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_sampling_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSamplingRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSamplingRule",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSamplingRuleInput`](crate::input::CreateSamplingRuleInput)
    pub fn builder() -> crate::input::create_sampling_rule_input::Builder {
        crate::input::create_sampling_rule_input::Builder::default()
    }
}

/// See [`DeleteGroupInput`](crate::input::DeleteGroupInput)
pub mod delete_group_input {
    /// A builder for [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The case-sensitive name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupInput`](crate::input::DeleteGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGroupInput {
                group_name: self.group_name,
                group_arn: self.group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGroupInputOperationOutputAlias = crate::operation::DeleteGroup;
#[doc(hidden)]
pub type DeleteGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGroup`](crate::operation::DeleteGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeleteGroup").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGroup",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
}

/// See [`DeleteSamplingRuleInput`](crate::input::DeleteSamplingRuleInput)
pub mod delete_sampling_rule_input {
    /// A builder for [`DeleteSamplingRuleInput`](crate::input::DeleteSamplingRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) rule_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSamplingRuleInput`](crate::input::DeleteSamplingRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSamplingRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSamplingRuleInput {
                rule_name: self.rule_name,
                rule_arn: self.rule_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSamplingRuleInputOperationOutputAlias = crate::operation::DeleteSamplingRule;
#[doc(hidden)]
pub type DeleteSamplingRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSamplingRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSamplingRule`](crate::operation::DeleteSamplingRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSamplingRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSamplingRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeleteSamplingRule").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSamplingRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSamplingRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_sampling_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSamplingRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSamplingRule",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSamplingRuleInput`](crate::input::DeleteSamplingRuleInput)
    pub fn builder() -> crate::input::delete_sampling_rule_input::Builder {
        crate::input::delete_sampling_rule_input::Builder::default()
    }
}

/// See [`GetEncryptionConfigInput`](crate::input::GetEncryptionConfigInput)
pub mod get_encryption_config_input {
    /// A builder for [`GetEncryptionConfigInput`](crate::input::GetEncryptionConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetEncryptionConfigInput`](crate::input::GetEncryptionConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEncryptionConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEncryptionConfigInput {})
        }
    }
}
#[doc(hidden)]
pub type GetEncryptionConfigInputOperationOutputAlias = crate::operation::GetEncryptionConfig;
#[doc(hidden)]
pub type GetEncryptionConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEncryptionConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetEncryptionConfig`](crate::operation::GetEncryptionConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEncryptionConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEncryptionConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/EncryptionConfig").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEncryptionConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEncryptionConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEncryptionConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEncryptionConfig",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEncryptionConfigInput`](crate::input::GetEncryptionConfigInput)
    pub fn builder() -> crate::input::get_encryption_config_input::Builder {
        crate::input::get_encryption_config_input::Builder::default()
    }
}

/// See [`GetGroupInput`](crate::input::GetGroupInput)
pub mod get_group_input {
    /// A builder for [`GetGroupInput`](crate::input::GetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The case-sensitive name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the group that was generated on creation.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupInput`](crate::input::GetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetGroupInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetGroupInput {
                group_name: self.group_name,
                group_arn: self.group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupInputOperationOutputAlias = crate::operation::GetGroup;
#[doc(hidden)]
pub type GetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetGroup`](crate::operation::GetGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetGroup").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetGroup::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetGroup", "xray",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupInput`](crate::input::GetGroupInput)
    pub fn builder() -> crate::input::get_group_input::Builder {
        crate::input::get_group_input::Builder::default()
    }
}

/// See [`GetGroupsInput`](crate::input::GetGroupsInput)
pub mod get_groups_input {
    /// A builder for [`GetGroupsInput`](crate::input::GetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupsInput`](crate::input::GetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetGroupsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetGroupsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupsInputOperationOutputAlias = crate::operation::GetGroups;
#[doc(hidden)]
pub type GetGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`GetGroups`](crate::operation::GetGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/Groups").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_groups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetGroups::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetGroups",
                    "xray",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupsInput`](crate::input::GetGroupsInput)
    pub fn builder() -> crate::input::get_groups_input::Builder {
        crate::input::get_groups_input::Builder::default()
    }
}

/// See [`GetInsightInput`](crate::input::GetInsightInput)
pub mod get_insight_input {
    /// A builder for [`GetInsightInput`](crate::input::GetInsightInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightInput`](crate::input::GetInsightInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInsightInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInsightInput {
                insight_id: self.insight_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInsightInputOperationOutputAlias = crate::operation::GetInsight;
#[doc(hidden)]
pub type GetInsightInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInsightInput {
    /// Consumes the builder and constructs an Operation<[`GetInsight`](crate::operation::GetInsight)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInsight,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInsightInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/Insight").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInsightInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInsightInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_insight(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInsight::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInsight",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInsightInput`](crate::input::GetInsightInput)
    pub fn builder() -> crate::input::get_insight_input::Builder {
        crate::input::get_insight_input::Builder::default()
    }
}

/// See [`GetInsightEventsInput`](crate::input::GetInsightEventsInput)
pub mod get_insight_events_input {
    /// A builder for [`GetInsightEventsInput`](crate::input::GetInsightEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// <p>Used to retrieve at most the specified value of events.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Used to retrieve at most the specified value of events.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of events. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of events. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightEventsInput`](crate::input::GetInsightEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInsightEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInsightEventsInput {
                insight_id: self.insight_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInsightEventsInputOperationOutputAlias = crate::operation::GetInsightEvents;
#[doc(hidden)]
pub type GetInsightEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInsightEventsInput {
    /// Consumes the builder and constructs an Operation<[`GetInsightEvents`](crate::operation::GetInsightEvents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInsightEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInsightEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/InsightEvents").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInsightEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInsightEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_insight_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInsightEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInsightEvents",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInsightEventsInput`](crate::input::GetInsightEventsInput)
    pub fn builder() -> crate::input::get_insight_events_input::Builder {
        crate::input::get_insight_events_input::Builder::default()
    }
}

/// See [`GetInsightImpactGraphInput`](crate::input::GetInsightImpactGraphInput)
pub mod get_insight_impact_graph_input {
    /// A builder for [`GetInsightImpactGraphInput`](crate::input::GetInsightImpactGraphInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// <p>The estimated start time of the insight, in Unix time seconds. The StartTime is inclusive of the value
        /// provided and can't be more than 30 days old.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The estimated start time of the insight, in Unix time seconds. The StartTime is inclusive of the value
        /// provided and can't be more than 30 days old.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The estimated end time of the insight, in Unix time seconds. The EndTime is exclusive of the value provided.
        /// The time range between the start time and end time can't be more than six hours. </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The estimated end time of the insight, in Unix time seconds. The EndTime is exclusive of the value provided.
        /// The time range between the start time and end time can't be more than six hours. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightImpactGraphInput`](crate::input::GetInsightImpactGraphInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInsightImpactGraphInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInsightImpactGraphInput {
                insight_id: self.insight_id,
                start_time: self.start_time,
                end_time: self.end_time,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInsightImpactGraphInputOperationOutputAlias = crate::operation::GetInsightImpactGraph;
#[doc(hidden)]
pub type GetInsightImpactGraphInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInsightImpactGraphInput {
    /// Consumes the builder and constructs an Operation<[`GetInsightImpactGraph`](crate::operation::GetInsightImpactGraph)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInsightImpactGraph,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInsightImpactGraphInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/InsightImpactGraph").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInsightImpactGraphInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInsightImpactGraphInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_insight_impact_graph(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInsightImpactGraph::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInsightImpactGraph",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInsightImpactGraphInput`](crate::input::GetInsightImpactGraphInput)
    pub fn builder() -> crate::input::get_insight_impact_graph_input::Builder {
        crate::input::get_insight_impact_graph_input::Builder::default()
    }
}

/// See [`GetInsightSummariesInput`](crate::input::GetInsightSummariesInput)
pub mod get_insight_summaries_input {
    /// A builder for [`GetInsightSummariesInput`](crate::input::GetInsightSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::InsightState>>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The list of insight states. </p>
        pub fn states(mut self, input: impl Into<crate::model::InsightState>) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input.into());
            self.states = Some(v);
            self
        }
        /// <p>The list of insight states. </p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group. Required if the GroupName isn't provided.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group. Required if the GroupName isn't provided.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// <p>The name of the group. Required if the GroupARN isn't provided.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group. Required if the GroupARN isn't provided.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The beginning of the time frame in which the insights started. The start time can't be more than 30 days
        /// old.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The beginning of the time frame in which the insights started. The start time can't be more than 30 days
        /// old.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time frame in which the insights ended. The end time can't be more than 30 days old.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time frame in which the insights ended. The end time can't be more than 30 days old.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightSummariesInput`](crate::input::GetInsightSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInsightSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInsightSummariesInput {
                states: self.states,
                group_arn: self.group_arn,
                group_name: self.group_name,
                start_time: self.start_time,
                end_time: self.end_time,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInsightSummariesInputOperationOutputAlias = crate::operation::GetInsightSummaries;
#[doc(hidden)]
pub type GetInsightSummariesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInsightSummariesInput {
    /// Consumes the builder and constructs an Operation<[`GetInsightSummaries`](crate::operation::GetInsightSummaries)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInsightSummaries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInsightSummariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/InsightSummaries").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInsightSummariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInsightSummariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_insight_summaries(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInsightSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInsightSummaries",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInsightSummariesInput`](crate::input::GetInsightSummariesInput)
    pub fn builder() -> crate::input::get_insight_summaries_input::Builder {
        crate::input::get_insight_summaries_input::Builder::default()
    }
}

/// See [`GetSamplingRulesInput`](crate::input::GetSamplingRulesInput)
pub mod get_sampling_rules_input {
    /// A builder for [`GetSamplingRulesInput`](crate::input::GetSamplingRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSamplingRulesInput`](crate::input::GetSamplingRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSamplingRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSamplingRulesInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSamplingRulesInputOperationOutputAlias = crate::operation::GetSamplingRules;
#[doc(hidden)]
pub type GetSamplingRulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSamplingRulesInput {
    /// Consumes the builder and constructs an Operation<[`GetSamplingRules`](crate::operation::GetSamplingRules)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSamplingRules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSamplingRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetSamplingRules").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSamplingRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSamplingRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_sampling_rules(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSamplingRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSamplingRules",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSamplingRulesInput`](crate::input::GetSamplingRulesInput)
    pub fn builder() -> crate::input::get_sampling_rules_input::Builder {
        crate::input::get_sampling_rules_input::Builder::default()
    }
}

/// See [`GetSamplingStatisticSummariesInput`](crate::input::GetSamplingStatisticSummariesInput)
pub mod get_sampling_statistic_summaries_input {
    /// A builder for [`GetSamplingStatisticSummariesInput`](crate::input::GetSamplingStatisticSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSamplingStatisticSummariesInput`](crate::input::GetSamplingStatisticSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSamplingStatisticSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSamplingStatisticSummariesInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSamplingStatisticSummariesInputOperationOutputAlias =
    crate::operation::GetSamplingStatisticSummaries;
#[doc(hidden)]
pub type GetSamplingStatisticSummariesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSamplingStatisticSummariesInput {
    /// Consumes the builder and constructs an Operation<[`GetSamplingStatisticSummaries`](crate::operation::GetSamplingStatisticSummaries)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSamplingStatisticSummaries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSamplingStatisticSummariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/SamplingStatisticSummaries").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSamplingStatisticSummariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSamplingStatisticSummariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_sampling_statistic_summaries(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSamplingStatisticSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSamplingStatisticSummaries",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSamplingStatisticSummariesInput`](crate::input::GetSamplingStatisticSummariesInput)
    pub fn builder() -> crate::input::get_sampling_statistic_summaries_input::Builder {
        crate::input::get_sampling_statistic_summaries_input::Builder::default()
    }
}

/// See [`GetSamplingTargetsInput`](crate::input::GetSamplingTargetsInput)
pub mod get_sampling_targets_input {
    /// A builder for [`GetSamplingTargetsInput`](crate::input::GetSamplingTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampling_statistics_documents:
            std::option::Option<std::vec::Vec<crate::model::SamplingStatisticsDocument>>,
    }
    impl Builder {
        /// Appends an item to `sampling_statistics_documents`.
        ///
        /// To override the contents of this collection use [`set_sampling_statistics_documents`](Self::set_sampling_statistics_documents).
        ///
        /// <p>Information about rules that the service is using to sample requests.</p>
        pub fn sampling_statistics_documents(
            mut self,
            input: impl Into<crate::model::SamplingStatisticsDocument>,
        ) -> Self {
            let mut v = self.sampling_statistics_documents.unwrap_or_default();
            v.push(input.into());
            self.sampling_statistics_documents = Some(v);
            self
        }
        /// <p>Information about rules that the service is using to sample requests.</p>
        pub fn set_sampling_statistics_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SamplingStatisticsDocument>>,
        ) -> Self {
            self.sampling_statistics_documents = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSamplingTargetsInput`](crate::input::GetSamplingTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSamplingTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSamplingTargetsInput {
                sampling_statistics_documents: self.sampling_statistics_documents,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSamplingTargetsInputOperationOutputAlias = crate::operation::GetSamplingTargets;
#[doc(hidden)]
pub type GetSamplingTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSamplingTargetsInput {
    /// Consumes the builder and constructs an Operation<[`GetSamplingTargets`](crate::operation::GetSamplingTargets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSamplingTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSamplingTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/SamplingTargets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSamplingTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSamplingTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_sampling_targets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSamplingTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSamplingTargets",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSamplingTargetsInput`](crate::input::GetSamplingTargetsInput)
    pub fn builder() -> crate::input::get_sampling_targets_input::Builder {
        crate::input::get_sampling_targets_input::Builder::default()
    }
}

/// See [`GetServiceGraphInput`](crate::input::GetServiceGraphInput)
pub mod get_service_graph_input {
    /// A builder for [`GetServiceGraphInput`](crate::input::GetServiceGraphInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start of the time frame for which to generate a graph.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time frame for which to generate a graph.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the timeframe for which to generate a graph.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the timeframe for which to generate a graph.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The name of a group based on which you want to generate a graph.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of a group based on which you want to generate a graph.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a group based on which you want to generate a graph.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a group based on which you want to generate a graph.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceGraphInput`](crate::input::GetServiceGraphInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceGraphInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceGraphInput {
                start_time: self.start_time,
                end_time: self.end_time,
                group_name: self.group_name,
                group_arn: self.group_arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetServiceGraphInputOperationOutputAlias = crate::operation::GetServiceGraph;
#[doc(hidden)]
pub type GetServiceGraphInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServiceGraphInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceGraph`](crate::operation::GetServiceGraph)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceGraph,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceGraphInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ServiceGraph").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceGraphInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceGraphInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_service_graph(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceGraph::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceGraph",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceGraphInput`](crate::input::GetServiceGraphInput)
    pub fn builder() -> crate::input::get_service_graph_input::Builder {
        crate::input::get_service_graph_input::Builder::default()
    }
}

/// See [`GetTimeSeriesServiceStatisticsInput`](crate::input::GetTimeSeriesServiceStatisticsInput)
pub mod get_time_series_service_statistics_input {
    /// A builder for [`GetTimeSeriesServiceStatisticsInput`](crate::input::GetTimeSeriesServiceStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
        pub(crate) entity_selector_expression: std::option::Option<std::string::String>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) forecast_statistics: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start of the time frame for which to aggregate statistics.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time frame for which to aggregate statistics.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time frame for which to aggregate statistics.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time frame for which to aggregate statistics.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The case-sensitive name of the group for which to pull statistics from.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The case-sensitive name of the group for which to pull statistics from.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group for which to pull statistics from.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the group for which to pull statistics from.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// <p>A filter expression defining entities that will be aggregated for statistics.
        /// Supports ID, service, and edge functions. If no selector expression is specified, edge
        /// statistics are returned. </p>
        pub fn entity_selector_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_selector_expression = Some(input.into());
            self
        }
        /// <p>A filter expression defining entities that will be aggregated for statistics.
        /// Supports ID, service, and edge functions. If no selector expression is specified, edge
        /// statistics are returned. </p>
        pub fn set_entity_selector_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_selector_expression = input;
            self
        }
        /// <p>Aggregation period in seconds.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>Aggregation period in seconds.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The forecasted high and low fault count values. Forecast enabled requests require the
        /// EntitySelectorExpression ID be provided.</p>
        pub fn forecast_statistics(mut self, input: bool) -> Self {
            self.forecast_statistics = Some(input);
            self
        }
        /// <p>The forecasted high and low fault count values. Forecast enabled requests require the
        /// EntitySelectorExpression ID be provided.</p>
        pub fn set_forecast_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.forecast_statistics = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTimeSeriesServiceStatisticsInput`](crate::input::GetTimeSeriesServiceStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTimeSeriesServiceStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTimeSeriesServiceStatisticsInput {
                start_time: self.start_time,
                end_time: self.end_time,
                group_name: self.group_name,
                group_arn: self.group_arn,
                entity_selector_expression: self.entity_selector_expression,
                period: self.period,
                forecast_statistics: self.forecast_statistics,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTimeSeriesServiceStatisticsInputOperationOutputAlias =
    crate::operation::GetTimeSeriesServiceStatistics;
#[doc(hidden)]
pub type GetTimeSeriesServiceStatisticsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTimeSeriesServiceStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetTimeSeriesServiceStatistics`](crate::operation::GetTimeSeriesServiceStatistics)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTimeSeriesServiceStatistics,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTimeSeriesServiceStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/TimeSeriesServiceStatistics").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTimeSeriesServiceStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTimeSeriesServiceStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_time_series_service_statistics(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTimeSeriesServiceStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTimeSeriesServiceStatistics",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTimeSeriesServiceStatisticsInput`](crate::input::GetTimeSeriesServiceStatisticsInput)
    pub fn builder() -> crate::input::get_time_series_service_statistics_input::Builder {
        crate::input::get_time_series_service_statistics_input::Builder::default()
    }
}

/// See [`GetTraceGraphInput`](crate::input::GetTraceGraphInput)
pub mod get_trace_graph_input {
    /// A builder for [`GetTraceGraphInput`](crate::input::GetTraceGraphInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trace_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `trace_ids`.
        ///
        /// To override the contents of this collection use [`set_trace_ids`](Self::set_trace_ids).
        ///
        /// <p>Trace IDs of requests for which to generate a service graph.</p>
        pub fn trace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trace_ids.unwrap_or_default();
            v.push(input.into());
            self.trace_ids = Some(v);
            self
        }
        /// <p>Trace IDs of requests for which to generate a service graph.</p>
        pub fn set_trace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trace_ids = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTraceGraphInput`](crate::input::GetTraceGraphInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTraceGraphInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTraceGraphInput {
                trace_ids: self.trace_ids,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTraceGraphInputOperationOutputAlias = crate::operation::GetTraceGraph;
#[doc(hidden)]
pub type GetTraceGraphInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTraceGraphInput {
    /// Consumes the builder and constructs an Operation<[`GetTraceGraph`](crate::operation::GetTraceGraph)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTraceGraph,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTraceGraphInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/TraceGraph").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTraceGraphInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTraceGraphInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_trace_graph(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTraceGraph::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTraceGraph",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTraceGraphInput`](crate::input::GetTraceGraphInput)
    pub fn builder() -> crate::input::get_trace_graph_input::Builder {
        crate::input::get_trace_graph_input::Builder::default()
    }
}

/// See [`GetTraceSummariesInput`](crate::input::GetTraceSummariesInput)
pub mod get_trace_summaries_input {
    /// A builder for [`GetTraceSummariesInput`](crate::input::GetTraceSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) time_range_type: std::option::Option<crate::model::TimeRangeType>,
        pub(crate) sampling: std::option::Option<bool>,
        pub(crate) sampling_strategy: std::option::Option<crate::model::SamplingStrategy>,
        pub(crate) filter_expression: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start of the time frame for which to retrieve traces.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time frame for which to retrieve traces.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time frame for which to retrieve traces.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time frame for which to retrieve traces.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>A parameter to indicate whether to query trace summaries by TraceId or Event time.</p>
        pub fn time_range_type(mut self, input: crate::model::TimeRangeType) -> Self {
            self.time_range_type = Some(input);
            self
        }
        /// <p>A parameter to indicate whether to query trace summaries by TraceId or Event time.</p>
        pub fn set_time_range_type(
            mut self,
            input: std::option::Option<crate::model::TimeRangeType>,
        ) -> Self {
            self.time_range_type = input;
            self
        }
        /// <p>Set to <code>true</code> to get summaries for only a subset of available
        /// traces.</p>
        pub fn sampling(mut self, input: bool) -> Self {
            self.sampling = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to get summaries for only a subset of available
        /// traces.</p>
        pub fn set_sampling(mut self, input: std::option::Option<bool>) -> Self {
            self.sampling = input;
            self
        }
        /// <p>A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and
        /// Value.</p>
        pub fn sampling_strategy(mut self, input: crate::model::SamplingStrategy) -> Self {
            self.sampling_strategy = Some(input);
            self
        }
        /// <p>A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and
        /// Value.</p>
        pub fn set_sampling_strategy(
            mut self,
            input: std::option::Option<crate::model::SamplingStrategy>,
        ) -> Self {
            self.sampling_strategy = input;
            self
        }
        /// <p>Specify a filter expression to retrieve trace summaries for services or requests that
        /// meet certain requirements.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>Specify a filter expression to retrieve trace summaries for services or requests that
        /// meet certain requirements.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page
        /// of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token returned by a previous request to retrieve the next page
        /// of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTraceSummariesInput`](crate::input::GetTraceSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTraceSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTraceSummariesInput {
                start_time: self.start_time,
                end_time: self.end_time,
                time_range_type: self.time_range_type,
                sampling: self.sampling,
                sampling_strategy: self.sampling_strategy,
                filter_expression: self.filter_expression,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTraceSummariesInputOperationOutputAlias = crate::operation::GetTraceSummaries;
#[doc(hidden)]
pub type GetTraceSummariesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTraceSummariesInput {
    /// Consumes the builder and constructs an Operation<[`GetTraceSummaries`](crate::operation::GetTraceSummaries)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTraceSummaries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTraceSummariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/TraceSummaries").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTraceSummariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTraceSummariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_trace_summaries(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTraceSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTraceSummaries",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTraceSummariesInput`](crate::input::GetTraceSummariesInput)
    pub fn builder() -> crate::input::get_trace_summaries_input::Builder {
        crate::input::get_trace_summaries_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with
        /// the current page of results as the value of this parameter to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with
        /// the current page of results as the value of this parameter to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListTagsForResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutEncryptionConfigInput`](crate::input::PutEncryptionConfigInput)
pub mod put_encryption_config_input {
    /// A builder for [`PutEncryptionConfigInput`](crate::input::PutEncryptionConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::EncryptionType>,
    }
    impl Builder {
        /// <p>An Amazon Web Services KMS key in one of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Alias</b> - The name of the key. For example,
        /// <code>alias/MyKey</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Key ID</b> - The KMS key ID of the key. For example,
        /// <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Amazon Web Services X-Ray does not support asymmetric KMS keys.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ARN</b> - The full Amazon Resource Name of the key ID or alias.
        /// For example,
        /// <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>.
        /// Use this format to specify a key in a different account.</p>
        /// </li>
        /// </ul>
        /// <p>Omit this key if you set <code>Type</code> to <code>NONE</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services KMS key in one of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Alias</b> - The name of the key. For example,
        /// <code>alias/MyKey</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Key ID</b> - The KMS key ID of the key. For example,
        /// <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Amazon Web Services X-Ray does not support asymmetric KMS keys.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ARN</b> - The full Amazon Resource Name of the key ID or alias.
        /// For example,
        /// <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>.
        /// Use this format to specify a key in a different account.</p>
        /// </li>
        /// </ul>
        /// <p>Omit this key if you set <code>Type</code> to <code>NONE</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set
        /// to <code>NONE</code> for default encryption.</p>
        pub fn r#type(mut self, input: crate::model::EncryptionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set
        /// to <code>NONE</code> for default encryption.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEncryptionConfigInput`](crate::input::PutEncryptionConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEncryptionConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEncryptionConfigInput {
                key_id: self.key_id,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEncryptionConfigInputOperationOutputAlias = crate::operation::PutEncryptionConfig;
#[doc(hidden)]
pub type PutEncryptionConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutEncryptionConfigInput {
    /// Consumes the builder and constructs an Operation<[`PutEncryptionConfig`](crate::operation::PutEncryptionConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEncryptionConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutEncryptionConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/PutEncryptionConfig").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutEncryptionConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutEncryptionConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_encryption_config(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEncryptionConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEncryptionConfig",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutEncryptionConfigInput`](crate::input::PutEncryptionConfigInput)
    pub fn builder() -> crate::input::put_encryption_config_input::Builder {
        crate::input::put_encryption_config_input::Builder::default()
    }
}

/// See [`PutTelemetryRecordsInput`](crate::input::PutTelemetryRecordsInput)
pub mod put_telemetry_records_input {
    /// A builder for [`PutTelemetryRecordsInput`](crate::input::PutTelemetryRecordsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) telemetry_records:
            std::option::Option<std::vec::Vec<crate::model::TelemetryRecord>>,
        pub(crate) ec2_instance_id: std::option::Option<std::string::String>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `telemetry_records`.
        ///
        /// To override the contents of this collection use [`set_telemetry_records`](Self::set_telemetry_records).
        ///
        /// <p></p>
        pub fn telemetry_records(
            mut self,
            input: impl Into<crate::model::TelemetryRecord>,
        ) -> Self {
            let mut v = self.telemetry_records.unwrap_or_default();
            v.push(input.into());
            self.telemetry_records = Some(v);
            self
        }
        /// <p></p>
        pub fn set_telemetry_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TelemetryRecord>>,
        ) -> Self {
            self.telemetry_records = input;
            self
        }
        /// <p></p>
        pub fn ec2_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_id = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_id = input;
            self
        }
        /// <p></p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p></p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutTelemetryRecordsInput`](crate::input::PutTelemetryRecordsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutTelemetryRecordsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutTelemetryRecordsInput {
                telemetry_records: self.telemetry_records,
                ec2_instance_id: self.ec2_instance_id,
                hostname: self.hostname,
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type PutTelemetryRecordsInputOperationOutputAlias = crate::operation::PutTelemetryRecords;
#[doc(hidden)]
pub type PutTelemetryRecordsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutTelemetryRecordsInput {
    /// Consumes the builder and constructs an Operation<[`PutTelemetryRecords`](crate::operation::PutTelemetryRecords)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutTelemetryRecords,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutTelemetryRecordsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/TelemetryRecords").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutTelemetryRecordsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutTelemetryRecordsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_telemetry_records(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutTelemetryRecords::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutTelemetryRecords",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutTelemetryRecordsInput`](crate::input::PutTelemetryRecordsInput)
    pub fn builder() -> crate::input::put_telemetry_records_input::Builder {
        crate::input::put_telemetry_records_input::Builder::default()
    }
}

/// See [`PutTraceSegmentsInput`](crate::input::PutTraceSegmentsInput)
pub mod put_trace_segments_input {
    /// A builder for [`PutTraceSegmentsInput`](crate::input::PutTraceSegmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trace_segment_documents: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `trace_segment_documents`.
        ///
        /// To override the contents of this collection use [`set_trace_segment_documents`](Self::set_trace_segment_documents).
        ///
        /// <p>A string containing a JSON document defining one or more segments or
        /// subsegments.</p>
        pub fn trace_segment_documents(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trace_segment_documents.unwrap_or_default();
            v.push(input.into());
            self.trace_segment_documents = Some(v);
            self
        }
        /// <p>A string containing a JSON document defining one or more segments or
        /// subsegments.</p>
        pub fn set_trace_segment_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trace_segment_documents = input;
            self
        }
        /// Consumes the builder and constructs a [`PutTraceSegmentsInput`](crate::input::PutTraceSegmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutTraceSegmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutTraceSegmentsInput {
                trace_segment_documents: self.trace_segment_documents,
            })
        }
    }
}
#[doc(hidden)]
pub type PutTraceSegmentsInputOperationOutputAlias = crate::operation::PutTraceSegments;
#[doc(hidden)]
pub type PutTraceSegmentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutTraceSegmentsInput {
    /// Consumes the builder and constructs an Operation<[`PutTraceSegments`](crate::operation::PutTraceSegments)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutTraceSegments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutTraceSegmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/TraceSegments").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutTraceSegmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutTraceSegmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_trace_segments(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutTraceSegments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutTraceSegments",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutTraceSegmentsInput`](crate::input::PutTraceSegmentsInput)
    pub fn builder() -> crate::input::put_trace_segments_input::Builder {
        crate::input::put_trace_segments_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group or
        /// sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You
        /// cannot edit or delete system tags.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group or
        /// sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of user-applied tags per resource: 50</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag key length: 128 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Maximum tag value length: 256 Unicode characters</p>
        /// </li>
        /// <li>
        /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
        /// / = + - and @</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You
        /// cannot edit or delete system tags.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/TagResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys for one or more tags that you want to remove from an X-Ray group or sampling rule.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Keys for one or more tags that you want to remove from an X-Ray group or sampling rule.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UntagResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateGroupInput`](crate::input::UpdateGroupInput)
pub mod update_group_input {
    /// A builder for [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
        pub(crate) filter_expression: std::option::Option<std::string::String>,
        pub(crate) insights_configuration: std::option::Option<crate::model::InsightsConfiguration>,
    }
    impl Builder {
        /// <p>The case-sensitive name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The case-sensitive name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The ARN that was generated upon creation.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The ARN that was generated upon creation.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// <p>The updated filter expression defining criteria by which to group traces.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>The updated filter expression defining criteria by which to group traces.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// group or false to disable insights for the group.</p>
        /// </li>
        /// <li>
        /// <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group.
        /// Notifications can only be enabled on a group with InsightsEnabled set to true.</p>
        /// </li>
        /// </ul>
        pub fn insights_configuration(
            mut self,
            input: crate::model::InsightsConfiguration,
        ) -> Self {
            self.insights_configuration = Some(input);
            self
        }
        /// <p>The structure containing configurations related to insights.</p>
        /// <ul>
        /// <li>
        /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
        /// group or false to disable insights for the group.</p>
        /// </li>
        /// <li>
        /// <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group.
        /// Notifications can only be enabled on a group with InsightsEnabled set to true.</p>
        /// </li>
        /// </ul>
        pub fn set_insights_configuration(
            mut self,
            input: std::option::Option<crate::model::InsightsConfiguration>,
        ) -> Self {
            self.insights_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupInput`](crate::input::UpdateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGroupInput {
                group_name: self.group_name,
                group_arn: self.group_arn,
                filter_expression: self.filter_expression,
                insights_configuration: self.insights_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGroupInputOperationOutputAlias = crate::operation::UpdateGroup;
#[doc(hidden)]
pub type UpdateGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGroup`](crate::operation::UpdateGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UpdateGroup").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGroup",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    pub fn builder() -> crate::input::update_group_input::Builder {
        crate::input::update_group_input::Builder::default()
    }
}

/// See [`UpdateSamplingRuleInput`](crate::input::UpdateSamplingRuleInput)
pub mod update_sampling_rule_input {
    /// A builder for [`UpdateSamplingRuleInput`](crate::input::UpdateSamplingRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampling_rule_update: std::option::Option<crate::model::SamplingRuleUpdate>,
    }
    impl Builder {
        /// <p>The rule and fields to change.</p>
        pub fn sampling_rule_update(mut self, input: crate::model::SamplingRuleUpdate) -> Self {
            self.sampling_rule_update = Some(input);
            self
        }
        /// <p>The rule and fields to change.</p>
        pub fn set_sampling_rule_update(
            mut self,
            input: std::option::Option<crate::model::SamplingRuleUpdate>,
        ) -> Self {
            self.sampling_rule_update = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSamplingRuleInput`](crate::input::UpdateSamplingRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSamplingRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSamplingRuleInput {
                sampling_rule_update: self.sampling_rule_update,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSamplingRuleInputOperationOutputAlias = crate::operation::UpdateSamplingRule;
#[doc(hidden)]
pub type UpdateSamplingRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSamplingRuleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSamplingRule`](crate::operation::UpdateSamplingRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSamplingRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSamplingRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UpdateSamplingRule").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSamplingRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSamplingRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_sampling_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSamplingRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSamplingRule",
            "xray",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSamplingRuleInput`](crate::input::UpdateSamplingRuleInput)
    pub fn builder() -> crate::input::update_sampling_rule_input::Builder {
        crate::input::update_sampling_rule_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSamplingRuleInput {
    /// <p>The rule and fields to change.</p>
    pub sampling_rule_update: std::option::Option<crate::model::SamplingRuleUpdate>,
}
impl UpdateSamplingRuleInput {
    /// <p>The rule and fields to change.</p>
    pub fn sampling_rule_update(&self) -> std::option::Option<&crate::model::SamplingRuleUpdate> {
        self.sampling_rule_update.as_ref()
    }
}
impl std::fmt::Debug for UpdateSamplingRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSamplingRuleInput");
        formatter.field("sampling_rule_update", &self.sampling_rule_update);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupInput {
    /// <p>The case-sensitive name of the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The ARN that was generated upon creation.</p>
    pub group_arn: std::option::Option<std::string::String>,
    /// <p>The updated filter expression defining criteria by which to group traces.</p>
    pub filter_expression: std::option::Option<std::string::String>,
    /// <p>The structure containing configurations related to insights.</p>
    /// <ul>
    /// <li>
    /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
    /// group or false to disable insights for the group.</p>
    /// </li>
    /// <li>
    /// <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group.
    /// Notifications can only be enabled on a group with InsightsEnabled set to true.</p>
    /// </li>
    /// </ul>
    pub insights_configuration: std::option::Option<crate::model::InsightsConfiguration>,
}
impl UpdateGroupInput {
    /// <p>The case-sensitive name of the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The ARN that was generated upon creation.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
    /// <p>The updated filter expression defining criteria by which to group traces.</p>
    pub fn filter_expression(&self) -> std::option::Option<&str> {
        self.filter_expression.as_deref()
    }
    /// <p>The structure containing configurations related to insights.</p>
    /// <ul>
    /// <li>
    /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
    /// group or false to disable insights for the group.</p>
    /// </li>
    /// <li>
    /// <p>The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group.
    /// Notifications can only be enabled on a group with InsightsEnabled set to true.</p>
    /// </li>
    /// </ul>
    pub fn insights_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InsightsConfiguration> {
        self.insights_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("group_arn", &self.group_arn);
        formatter.field("filter_expression", &self.filter_expression);
        formatter.field("insights_configuration", &self.insights_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Keys for one or more tags that you want to remove from an X-Ray group or sampling rule.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Keys for one or more tags that you want to remove from an X-Ray group or sampling rule.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group or
    /// sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
    /// in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p>The following restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of user-applied tags per resource: 50</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag key length: 128 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag value length: 256 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
    /// / = + - and @</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You
    /// cannot edit or delete system tags.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group or
    /// sampling rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
    /// in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p>The following restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of user-applied tags per resource: 50</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag key length: 128 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag value length: 256 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
    /// / = + - and @</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use. You
    /// cannot edit or delete system tags.</p>
    /// </li>
    /// </ul>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutTraceSegmentsInput {
    /// <p>A string containing a JSON document defining one or more segments or
    /// subsegments.</p>
    pub trace_segment_documents: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PutTraceSegmentsInput {
    /// <p>A string containing a JSON document defining one or more segments or
    /// subsegments.</p>
    pub fn trace_segment_documents(&self) -> std::option::Option<&[std::string::String]> {
        self.trace_segment_documents.as_deref()
    }
}
impl std::fmt::Debug for PutTraceSegmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutTraceSegmentsInput");
        formatter.field("trace_segment_documents", &self.trace_segment_documents);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutTelemetryRecordsInput {
    /// <p></p>
    pub telemetry_records: std::option::Option<std::vec::Vec<crate::model::TelemetryRecord>>,
    /// <p></p>
    pub ec2_instance_id: std::option::Option<std::string::String>,
    /// <p></p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p></p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl PutTelemetryRecordsInput {
    /// <p></p>
    pub fn telemetry_records(&self) -> std::option::Option<&[crate::model::TelemetryRecord]> {
        self.telemetry_records.as_deref()
    }
    /// <p></p>
    pub fn ec2_instance_id(&self) -> std::option::Option<&str> {
        self.ec2_instance_id.as_deref()
    }
    /// <p></p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p></p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for PutTelemetryRecordsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutTelemetryRecordsInput");
        formatter.field("telemetry_records", &self.telemetry_records);
        formatter.field("ec2_instance_id", &self.ec2_instance_id);
        formatter.field("hostname", &self.hostname);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEncryptionConfigInput {
    /// <p>An Amazon Web Services KMS key in one of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Alias</b> - The name of the key. For example,
    /// <code>alias/MyKey</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Key ID</b> - The KMS key ID of the key. For example,
    /// <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Amazon Web Services X-Ray does not support asymmetric KMS keys.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ARN</b> - The full Amazon Resource Name of the key ID or alias.
    /// For example,
    /// <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>.
    /// Use this format to specify a key in a different account.</p>
    /// </li>
    /// </ul>
    /// <p>Omit this key if you set <code>Type</code> to <code>NONE</code>.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set
    /// to <code>NONE</code> for default encryption.</p>
    pub r#type: std::option::Option<crate::model::EncryptionType>,
}
impl PutEncryptionConfigInput {
    /// <p>An Amazon Web Services KMS key in one of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Alias</b> - The name of the key. For example,
    /// <code>alias/MyKey</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Key ID</b> - The KMS key ID of the key. For example,
    /// <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Amazon Web Services X-Ray does not support asymmetric KMS keys.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ARN</b> - The full Amazon Resource Name of the key ID or alias.
    /// For example,
    /// <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>.
    /// Use this format to specify a key in a different account.</p>
    /// </li>
    /// </ul>
    /// <p>Omit this key if you set <code>Type</code> to <code>NONE</code>.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set
    /// to <code>NONE</code> for default encryption.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for PutEncryptionConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEncryptionConfigInput");
        formatter.field("key_id", &self.key_id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with
    /// the current page of results as the value of this parameter to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with
    /// the current page of results as the value of this parameter to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTraceSummariesInput {
    /// <p>The start of the time frame for which to retrieve traces.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end of the time frame for which to retrieve traces.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A parameter to indicate whether to query trace summaries by TraceId or Event time.</p>
    pub time_range_type: std::option::Option<crate::model::TimeRangeType>,
    /// <p>Set to <code>true</code> to get summaries for only a subset of available
    /// traces.</p>
    pub sampling: std::option::Option<bool>,
    /// <p>A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and
    /// Value.</p>
    pub sampling_strategy: std::option::Option<crate::model::SamplingStrategy>,
    /// <p>Specify a filter expression to retrieve trace summaries for services or requests that
    /// meet certain requirements.</p>
    pub filter_expression: std::option::Option<std::string::String>,
    /// <p>Specify the pagination token returned by a previous request to retrieve the next page
    /// of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetTraceSummariesInput {
    /// <p>The start of the time frame for which to retrieve traces.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The end of the time frame for which to retrieve traces.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>A parameter to indicate whether to query trace summaries by TraceId or Event time.</p>
    pub fn time_range_type(&self) -> std::option::Option<&crate::model::TimeRangeType> {
        self.time_range_type.as_ref()
    }
    /// <p>Set to <code>true</code> to get summaries for only a subset of available
    /// traces.</p>
    pub fn sampling(&self) -> std::option::Option<bool> {
        self.sampling
    }
    /// <p>A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and
    /// Value.</p>
    pub fn sampling_strategy(&self) -> std::option::Option<&crate::model::SamplingStrategy> {
        self.sampling_strategy.as_ref()
    }
    /// <p>Specify a filter expression to retrieve trace summaries for services or requests that
    /// meet certain requirements.</p>
    pub fn filter_expression(&self) -> std::option::Option<&str> {
        self.filter_expression.as_deref()
    }
    /// <p>Specify the pagination token returned by a previous request to retrieve the next page
    /// of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetTraceSummariesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTraceSummariesInput");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("time_range_type", &self.time_range_type);
        formatter.field("sampling", &self.sampling);
        formatter.field("sampling_strategy", &self.sampling_strategy);
        formatter.field("filter_expression", &self.filter_expression);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTraceGraphInput {
    /// <p>Trace IDs of requests for which to generate a service graph.</p>
    pub trace_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetTraceGraphInput {
    /// <p>Trace IDs of requests for which to generate a service graph.</p>
    pub fn trace_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.trace_ids.as_deref()
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetTraceGraphInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTraceGraphInput");
        formatter.field("trace_ids", &self.trace_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTimeSeriesServiceStatisticsInput {
    /// <p>The start of the time frame for which to aggregate statistics.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end of the time frame for which to aggregate statistics.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The case-sensitive name of the group for which to pull statistics from.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the group for which to pull statistics from.</p>
    pub group_arn: std::option::Option<std::string::String>,
    /// <p>A filter expression defining entities that will be aggregated for statistics.
    /// Supports ID, service, and edge functions. If no selector expression is specified, edge
    /// statistics are returned. </p>
    pub entity_selector_expression: std::option::Option<std::string::String>,
    /// <p>Aggregation period in seconds.</p>
    pub period: std::option::Option<i32>,
    /// <p>The forecasted high and low fault count values. Forecast enabled requests require the
    /// EntitySelectorExpression ID be provided.</p>
    pub forecast_statistics: std::option::Option<bool>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetTimeSeriesServiceStatisticsInput {
    /// <p>The start of the time frame for which to aggregate statistics.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The end of the time frame for which to aggregate statistics.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The case-sensitive name of the group for which to pull statistics from.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the group for which to pull statistics from.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
    /// <p>A filter expression defining entities that will be aggregated for statistics.
    /// Supports ID, service, and edge functions. If no selector expression is specified, edge
    /// statistics are returned. </p>
    pub fn entity_selector_expression(&self) -> std::option::Option<&str> {
        self.entity_selector_expression.as_deref()
    }
    /// <p>Aggregation period in seconds.</p>
    pub fn period(&self) -> std::option::Option<i32> {
        self.period
    }
    /// <p>The forecasted high and low fault count values. Forecast enabled requests require the
    /// EntitySelectorExpression ID be provided.</p>
    pub fn forecast_statistics(&self) -> std::option::Option<bool> {
        self.forecast_statistics
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetTimeSeriesServiceStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTimeSeriesServiceStatisticsInput");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("group_name", &self.group_name);
        formatter.field("group_arn", &self.group_arn);
        formatter.field(
            "entity_selector_expression",
            &self.entity_selector_expression,
        );
        formatter.field("period", &self.period);
        formatter.field("forecast_statistics", &self.forecast_statistics);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceGraphInput {
    /// <p>The start of the time frame for which to generate a graph.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end of the timeframe for which to generate a graph.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of a group based on which you want to generate a graph.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a group based on which you want to generate a graph.</p>
    pub group_arn: std::option::Option<std::string::String>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetServiceGraphInput {
    /// <p>The start of the time frame for which to generate a graph.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The end of the timeframe for which to generate a graph.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The name of a group based on which you want to generate a graph.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a group based on which you want to generate a graph.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetServiceGraphInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceGraphInput");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("group_name", &self.group_name);
        formatter.field("group_arn", &self.group_arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSamplingTargetsInput {
    /// <p>Information about rules that the service is using to sample requests.</p>
    pub sampling_statistics_documents:
        std::option::Option<std::vec::Vec<crate::model::SamplingStatisticsDocument>>,
}
impl GetSamplingTargetsInput {
    /// <p>Information about rules that the service is using to sample requests.</p>
    pub fn sampling_statistics_documents(
        &self,
    ) -> std::option::Option<&[crate::model::SamplingStatisticsDocument]> {
        self.sampling_statistics_documents.as_deref()
    }
}
impl std::fmt::Debug for GetSamplingTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSamplingTargetsInput");
        formatter.field(
            "sampling_statistics_documents",
            &self.sampling_statistics_documents,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSamplingStatisticSummariesInput {
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetSamplingStatisticSummariesInput {
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetSamplingStatisticSummariesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSamplingStatisticSummariesInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSamplingRulesInput {
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetSamplingRulesInput {
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetSamplingRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSamplingRulesInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightSummariesInput {
    /// <p>The list of insight states. </p>
    pub states: std::option::Option<std::vec::Vec<crate::model::InsightState>>,
    /// <p>The Amazon Resource Name (ARN) of the group. Required if the GroupName isn't provided.</p>
    pub group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the group. Required if the GroupARN isn't provided.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The beginning of the time frame in which the insights started. The start time can't be more than 30 days
    /// old.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end of the time frame in which the insights ended. The end time can't be more than 30 days old.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The maximum number of results to display.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetInsightSummariesInput {
    /// <p>The list of insight states. </p>
    pub fn states(&self) -> std::option::Option<&[crate::model::InsightState]> {
        self.states.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the group. Required if the GroupName isn't provided.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
    /// <p>The name of the group. Required if the GroupARN isn't provided.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The beginning of the time frame in which the insights started. The start time can't be more than 30 days
    /// old.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The end of the time frame in which the insights ended. The end time can't be more than 30 days old.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The maximum number of results to display.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetInsightSummariesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightSummariesInput");
        formatter.field("states", &self.states);
        formatter.field("group_arn", &self.group_arn);
        formatter.field("group_name", &self.group_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightImpactGraphInput {
    /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
    pub insight_id: std::option::Option<std::string::String>,
    /// <p>The estimated start time of the insight, in Unix time seconds. The StartTime is inclusive of the value
    /// provided and can't be more than 30 days old.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The estimated end time of the insight, in Unix time seconds. The EndTime is exclusive of the value provided.
    /// The time range between the start time and end time can't be more than six hours. </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specify the pagination token returned by a previous request to retrieve the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetInsightImpactGraphInput {
    /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
    pub fn insight_id(&self) -> std::option::Option<&str> {
        self.insight_id.as_deref()
    }
    /// <p>The estimated start time of the insight, in Unix time seconds. The StartTime is inclusive of the value
    /// provided and can't be more than 30 days old.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The estimated end time of the insight, in Unix time seconds. The EndTime is exclusive of the value provided.
    /// The time range between the start time and end time can't be more than six hours. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>Specify the pagination token returned by a previous request to retrieve the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetInsightImpactGraphInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightImpactGraphInput");
        formatter.field("insight_id", &self.insight_id);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightEventsInput {
    /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
    pub insight_id: std::option::Option<std::string::String>,
    /// <p>Used to retrieve at most the specified value of events.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Specify the pagination token returned by a previous request to retrieve the next page of events. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetInsightEventsInput {
    /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
    pub fn insight_id(&self) -> std::option::Option<&str> {
        self.insight_id.as_deref()
    }
    /// <p>Used to retrieve at most the specified value of events.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Specify the pagination token returned by a previous request to retrieve the next page of events. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetInsightEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightEventsInput");
        formatter.field("insight_id", &self.insight_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightInput {
    /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
    pub insight_id: std::option::Option<std::string::String>,
}
impl GetInsightInput {
    /// <p>The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.</p>
    pub fn insight_id(&self) -> std::option::Option<&str> {
        self.insight_id.as_deref()
    }
}
impl std::fmt::Debug for GetInsightInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightInput");
        formatter.field("insight_id", &self.insight_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupsInput {
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetGroupsInput {
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupInput {
    /// <p>The case-sensitive name of the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the group that was generated on creation.</p>
    pub group_arn: std::option::Option<std::string::String>,
}
impl GetGroupInput {
    /// <p>The case-sensitive name of the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The ARN of the group that was generated on creation.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
}
impl std::fmt::Debug for GetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("group_arn", &self.group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEncryptionConfigInput {}
impl std::fmt::Debug for GetEncryptionConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEncryptionConfigInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSamplingRuleInput {
    /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub rule_arn: std::option::Option<std::string::String>,
}
impl DeleteSamplingRuleInput {
    /// <p>The name of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.</p>
    pub fn rule_arn(&self) -> std::option::Option<&str> {
        self.rule_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteSamplingRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSamplingRuleInput");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("rule_arn", &self.rule_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupInput {
    /// <p>The case-sensitive name of the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the group that was generated on creation.</p>
    pub group_arn: std::option::Option<std::string::String>,
}
impl DeleteGroupInput {
    /// <p>The case-sensitive name of the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The ARN of the group that was generated on creation.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("group_arn", &self.group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSamplingRuleInput {
    /// <p>The rule definition.</p>
    pub sampling_rule: std::option::Option<crate::model::SamplingRule>,
    /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray sampling
    /// rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p>The following restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of user-applied tags per resource: 50</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag key length: 128 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag value length: 256 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
    /// / = + - and @</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
    /// use.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateSamplingRuleInput {
    /// <p>The rule definition.</p>
    pub fn sampling_rule(&self) -> std::option::Option<&crate::model::SamplingRule> {
        self.sampling_rule.as_ref()
    }
    /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray sampling
    /// rule. For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p>The following restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of user-applied tags per resource: 50</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag key length: 128 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag value length: 256 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
    /// / = + - and @</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
    /// use.</p>
    /// </li>
    /// </ul>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateSamplingRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSamplingRuleInput");
        formatter.field("sampling_rule", &self.sampling_rule);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupInput {
    /// <p>The case-sensitive name of the new group. Default is a reserved name and names must
    /// be unique.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The filter expression defining criteria by which to group traces.</p>
    pub filter_expression: std::option::Option<std::string::String>,
    /// <p>The structure containing configurations related to insights.</p>
    /// <ul>
    /// <li>
    /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
    /// new group or false to disable insights for the new group.</p>
    /// </li>
    /// <li>
    /// <p>The NotifcationsEnabled boolean can be set to true to enable insights
    /// notifications for the new group. Notifications may only be enabled on a group
    /// with InsightsEnabled set to true.</p>
    /// </li>
    /// </ul>
    pub insights_configuration: std::option::Option<crate::model::InsightsConfiguration>,
    /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group.
    /// For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p>The following restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of user-applied tags per resource: 50</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag key length: 128 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag value length: 256 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
    /// / = + - and @</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
    /// use.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateGroupInput {
    /// <p>The case-sensitive name of the new group. Default is a reserved name and names must
    /// be unique.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The filter expression defining criteria by which to group traces.</p>
    pub fn filter_expression(&self) -> std::option::Option<&str> {
        self.filter_expression.as_deref()
    }
    /// <p>The structure containing configurations related to insights.</p>
    /// <ul>
    /// <li>
    /// <p>The InsightsEnabled boolean can be set to true to enable insights for the
    /// new group or false to disable insights for the new group.</p>
    /// </li>
    /// <li>
    /// <p>The NotifcationsEnabled boolean can be set to true to enable insights
    /// notifications for the new group. Notifications may only be enabled on a group
    /// with InsightsEnabled set to true.</p>
    /// </li>
    /// </ul>
    pub fn insights_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InsightsConfiguration> {
        self.insights_configuration.as_ref()
    }
    /// <p>A map that contains one or more tag keys and tag values to attach to an X-Ray group.
    /// For more information about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p>The following restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of user-applied tags per resource: 50</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag key length: 128 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Maximum tag value length: 256 Unicode characters</p>
    /// </li>
    /// <li>
    /// <p>Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . :
    /// / = + - and @</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services
    /// use.</p>
    /// </li>
    /// </ul>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("filter_expression", &self.filter_expression);
        formatter.field("insights_configuration", &self.insights_configuration);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetTracesInput {
    /// <p>Specify the trace IDs of requests for which to retrieve segments.</p>
    pub trace_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchGetTracesInput {
    /// <p>Specify the trace IDs of requests for which to retrieve segments.</p>
    pub fn trace_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.trace_ids.as_deref()
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchGetTracesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetTracesInput");
        formatter.field("trace_ids", &self.trace_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
