// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSamplingRuleOutput {
    /// <p>The updated rule definition and metadata.</p>
    pub sampling_rule_record: std::option::Option<crate::model::SamplingRuleRecord>,
}
impl std::fmt::Debug for UpdateSamplingRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSamplingRuleOutput");
        formatter.field("sampling_rule_record", &self.sampling_rule_record);
        formatter.finish()
    }
}
/// See [`UpdateSamplingRuleOutput`](crate::output::UpdateSamplingRuleOutput)
pub mod update_sampling_rule_output {
    /// A builder for [`UpdateSamplingRuleOutput`](crate::output::UpdateSamplingRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampling_rule_record: std::option::Option<crate::model::SamplingRuleRecord>,
    }
    impl Builder {
        /// <p>The updated rule definition and metadata.</p>
        pub fn sampling_rule_record(mut self, input: crate::model::SamplingRuleRecord) -> Self {
            self.sampling_rule_record = Some(input);
            self
        }
        /// <p>The updated rule definition and metadata.</p>
        pub fn set_sampling_rule_record(
            mut self,
            input: std::option::Option<crate::model::SamplingRuleRecord>,
        ) -> Self {
            self.sampling_rule_record = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSamplingRuleOutput`](crate::output::UpdateSamplingRuleOutput)
        pub fn build(self) -> crate::output::UpdateSamplingRuleOutput {
            crate::output::UpdateSamplingRuleOutput {
                sampling_rule_record: self.sampling_rule_record,
            }
        }
    }
}
impl UpdateSamplingRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSamplingRuleOutput`](crate::output::UpdateSamplingRuleOutput)
    pub fn builder() -> crate::output::update_sampling_rule_output::Builder {
        crate::output::update_sampling_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupOutput {
    /// <p>The group that was updated. Contains the name of the group that was updated, the
    /// ARN of the group that was updated, the updated filter expression, and the updated insight
    /// configuration assigned to the group.</p>
    pub group: std::option::Option<crate::model::Group>,
}
impl std::fmt::Debug for UpdateGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupOutput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}
/// See [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
pub mod update_group_output {
    /// A builder for [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
    }
    impl Builder {
        /// <p>The group that was updated. Contains the name of the group that was updated, the
        /// ARN of the group that was updated, the updated filter expression, and the updated insight
        /// configuration assigned to the group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The group that was updated. Contains the name of the group that was updated, the
        /// ARN of the group that was updated, the updated filter expression, and the updated insight
        /// configuration assigned to the group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
        pub fn build(self) -> crate::output::UpdateGroupOutput {
            crate::output::UpdateGroupOutput { group: self.group }
        }
    }
}
impl UpdateGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
    pub fn builder() -> crate::output::update_group_output::Builder {
        crate::output::update_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutTraceSegmentsOutput {
    /// <p>Segments that failed processing.</p>
    pub unprocessed_trace_segments:
        std::option::Option<std::vec::Vec<crate::model::UnprocessedTraceSegment>>,
}
impl std::fmt::Debug for PutTraceSegmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutTraceSegmentsOutput");
        formatter.field(
            "unprocessed_trace_segments",
            &self.unprocessed_trace_segments,
        );
        formatter.finish()
    }
}
/// See [`PutTraceSegmentsOutput`](crate::output::PutTraceSegmentsOutput)
pub mod put_trace_segments_output {
    /// A builder for [`PutTraceSegmentsOutput`](crate::output::PutTraceSegmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unprocessed_trace_segments:
            std::option::Option<std::vec::Vec<crate::model::UnprocessedTraceSegment>>,
    }
    impl Builder {
        /// Appends an item to `unprocessed_trace_segments`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_trace_segments`](Self::set_unprocessed_trace_segments).
        ///
        /// <p>Segments that failed processing.</p>
        pub fn unprocessed_trace_segments(
            mut self,
            input: impl Into<crate::model::UnprocessedTraceSegment>,
        ) -> Self {
            let mut v = self.unprocessed_trace_segments.unwrap_or_default();
            v.push(input.into());
            self.unprocessed_trace_segments = Some(v);
            self
        }
        /// <p>Segments that failed processing.</p>
        pub fn set_unprocessed_trace_segments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UnprocessedTraceSegment>>,
        ) -> Self {
            self.unprocessed_trace_segments = input;
            self
        }
        /// Consumes the builder and constructs a [`PutTraceSegmentsOutput`](crate::output::PutTraceSegmentsOutput)
        pub fn build(self) -> crate::output::PutTraceSegmentsOutput {
            crate::output::PutTraceSegmentsOutput {
                unprocessed_trace_segments: self.unprocessed_trace_segments,
            }
        }
    }
}
impl PutTraceSegmentsOutput {
    /// Creates a new builder-style object to manufacture [`PutTraceSegmentsOutput`](crate::output::PutTraceSegmentsOutput)
    pub fn builder() -> crate::output::put_trace_segments_output::Builder {
        crate::output::put_trace_segments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutTelemetryRecordsOutput {}
impl std::fmt::Debug for PutTelemetryRecordsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutTelemetryRecordsOutput");
        formatter.finish()
    }
}
/// See [`PutTelemetryRecordsOutput`](crate::output::PutTelemetryRecordsOutput)
pub mod put_telemetry_records_output {
    /// A builder for [`PutTelemetryRecordsOutput`](crate::output::PutTelemetryRecordsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutTelemetryRecordsOutput`](crate::output::PutTelemetryRecordsOutput)
        pub fn build(self) -> crate::output::PutTelemetryRecordsOutput {
            crate::output::PutTelemetryRecordsOutput {}
        }
    }
}
impl PutTelemetryRecordsOutput {
    /// Creates a new builder-style object to manufacture [`PutTelemetryRecordsOutput`](crate::output::PutTelemetryRecordsOutput)
    pub fn builder() -> crate::output::put_telemetry_records_output::Builder {
        crate::output::put_telemetry_records_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEncryptionConfigOutput {
    /// <p>The new encryption configuration.</p>
    pub encryption_config: std::option::Option<crate::model::EncryptionConfig>,
}
impl std::fmt::Debug for PutEncryptionConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEncryptionConfigOutput");
        formatter.field("encryption_config", &self.encryption_config);
        formatter.finish()
    }
}
/// See [`PutEncryptionConfigOutput`](crate::output::PutEncryptionConfigOutput)
pub mod put_encryption_config_output {
    /// A builder for [`PutEncryptionConfigOutput`](crate::output::PutEncryptionConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_config: std::option::Option<crate::model::EncryptionConfig>,
    }
    impl Builder {
        /// <p>The new encryption configuration.</p>
        pub fn encryption_config(mut self, input: crate::model::EncryptionConfig) -> Self {
            self.encryption_config = Some(input);
            self
        }
        /// <p>The new encryption configuration.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfig>,
        ) -> Self {
            self.encryption_config = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEncryptionConfigOutput`](crate::output::PutEncryptionConfigOutput)
        pub fn build(self) -> crate::output::PutEncryptionConfigOutput {
            crate::output::PutEncryptionConfigOutput {
                encryption_config: self.encryption_config,
            }
        }
    }
}
impl PutEncryptionConfigOutput {
    /// Creates a new builder-style object to manufacture [`PutEncryptionConfigOutput`](crate::output::PutEncryptionConfigOutput)
    pub fn builder() -> crate::output::put_encryption_config_output::Builder {
        crate::output::put_encryption_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of tags, as key and value pairs, that is associated with the specified X-Ray group or sampling rule.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with
    /// the current page of results to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags, as key and value pairs, that is associated with the specified X-Ray group or sampling rule.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags, as key and value pairs, that is associated with the specified X-Ray group or sampling rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with
        /// the current page of results to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token. If multiple pages of results are returned, use the <code>NextToken</code> value returned with
        /// the current page of results to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTraceSummariesOutput {
    /// <p>Trace IDs and annotations for traces that were found in the specified time
    /// frame.</p>
    pub trace_summaries: std::option::Option<std::vec::Vec<crate::model::TraceSummary>>,
    /// <p>The start time of this page of results.</p>
    pub approximate_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The total number of traces processed, including traces that did not match the specified
    /// filter expression.</p>
    pub traces_processed_count: std::option::Option<i64>,
    /// <p>If the requested time frame contained more than one page of results, you can use this token to retrieve the
    /// next page. The first page contains the most recent results, closest to the end of the time frame.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTraceSummariesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTraceSummariesOutput");
        formatter.field("trace_summaries", &self.trace_summaries);
        formatter.field("approximate_time", &self.approximate_time);
        formatter.field("traces_processed_count", &self.traces_processed_count);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTraceSummariesOutput`](crate::output::GetTraceSummariesOutput)
pub mod get_trace_summaries_output {
    /// A builder for [`GetTraceSummariesOutput`](crate::output::GetTraceSummariesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trace_summaries: std::option::Option<std::vec::Vec<crate::model::TraceSummary>>,
        pub(crate) approximate_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) traces_processed_count: std::option::Option<i64>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `trace_summaries`.
        ///
        /// To override the contents of this collection use [`set_trace_summaries`](Self::set_trace_summaries).
        ///
        /// <p>Trace IDs and annotations for traces that were found in the specified time
        /// frame.</p>
        pub fn trace_summaries(mut self, input: impl Into<crate::model::TraceSummary>) -> Self {
            let mut v = self.trace_summaries.unwrap_or_default();
            v.push(input.into());
            self.trace_summaries = Some(v);
            self
        }
        /// <p>Trace IDs and annotations for traces that were found in the specified time
        /// frame.</p>
        pub fn set_trace_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TraceSummary>>,
        ) -> Self {
            self.trace_summaries = input;
            self
        }
        /// <p>The start time of this page of results.</p>
        pub fn approximate_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.approximate_time = Some(input);
            self
        }
        /// <p>The start time of this page of results.</p>
        pub fn set_approximate_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.approximate_time = input;
            self
        }
        /// <p>The total number of traces processed, including traces that did not match the specified
        /// filter expression.</p>
        pub fn traces_processed_count(mut self, input: i64) -> Self {
            self.traces_processed_count = Some(input);
            self
        }
        /// <p>The total number of traces processed, including traces that did not match the specified
        /// filter expression.</p>
        pub fn set_traces_processed_count(mut self, input: std::option::Option<i64>) -> Self {
            self.traces_processed_count = input;
            self
        }
        /// <p>If the requested time frame contained more than one page of results, you can use this token to retrieve the
        /// next page. The first page contains the most recent results, closest to the end of the time frame.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the requested time frame contained more than one page of results, you can use this token to retrieve the
        /// next page. The first page contains the most recent results, closest to the end of the time frame.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTraceSummariesOutput`](crate::output::GetTraceSummariesOutput)
        pub fn build(self) -> crate::output::GetTraceSummariesOutput {
            crate::output::GetTraceSummariesOutput {
                trace_summaries: self.trace_summaries,
                approximate_time: self.approximate_time,
                traces_processed_count: self.traces_processed_count,
                next_token: self.next_token,
            }
        }
    }
}
impl GetTraceSummariesOutput {
    /// Creates a new builder-style object to manufacture [`GetTraceSummariesOutput`](crate::output::GetTraceSummariesOutput)
    pub fn builder() -> crate::output::get_trace_summaries_output::Builder {
        crate::output::get_trace_summaries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTraceGraphOutput {
    /// <p>The services that have processed one of the specified requests.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::Service>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTraceGraphOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTraceGraphOutput");
        formatter.field("services", &self.services);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTraceGraphOutput`](crate::output::GetTraceGraphOutput)
pub mod get_trace_graph_output {
    /// A builder for [`GetTraceGraphOutput`](crate::output::GetTraceGraphOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services: std::option::Option<std::vec::Vec<crate::model::Service>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>The services that have processed one of the specified requests.</p>
        pub fn services(mut self, input: impl Into<crate::model::Service>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>The services that have processed one of the specified requests.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Service>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTraceGraphOutput`](crate::output::GetTraceGraphOutput)
        pub fn build(self) -> crate::output::GetTraceGraphOutput {
            crate::output::GetTraceGraphOutput {
                services: self.services,
                next_token: self.next_token,
            }
        }
    }
}
impl GetTraceGraphOutput {
    /// Creates a new builder-style object to manufacture [`GetTraceGraphOutput`](crate::output::GetTraceGraphOutput)
    pub fn builder() -> crate::output::get_trace_graph_output::Builder {
        crate::output::get_trace_graph_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTimeSeriesServiceStatisticsOutput {
    /// <p>The collection of statistics.</p>
    pub time_series_service_statistics:
        std::option::Option<std::vec::Vec<crate::model::TimeSeriesServiceStatistics>>,
    /// <p>A flag indicating whether or not a group's filter expression has been consistent, or if a returned
    /// aggregation might show statistics from an older version of the group's filter expression.</p>
    pub contains_old_group_versions: bool,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTimeSeriesServiceStatisticsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTimeSeriesServiceStatisticsOutput");
        formatter.field(
            "time_series_service_statistics",
            &self.time_series_service_statistics,
        );
        formatter.field(
            "contains_old_group_versions",
            &self.contains_old_group_versions,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTimeSeriesServiceStatisticsOutput`](crate::output::GetTimeSeriesServiceStatisticsOutput)
pub mod get_time_series_service_statistics_output {
    /// A builder for [`GetTimeSeriesServiceStatisticsOutput`](crate::output::GetTimeSeriesServiceStatisticsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_series_service_statistics:
            std::option::Option<std::vec::Vec<crate::model::TimeSeriesServiceStatistics>>,
        pub(crate) contains_old_group_versions: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `time_series_service_statistics`.
        ///
        /// To override the contents of this collection use [`set_time_series_service_statistics`](Self::set_time_series_service_statistics).
        ///
        /// <p>The collection of statistics.</p>
        pub fn time_series_service_statistics(
            mut self,
            input: impl Into<crate::model::TimeSeriesServiceStatistics>,
        ) -> Self {
            let mut v = self.time_series_service_statistics.unwrap_or_default();
            v.push(input.into());
            self.time_series_service_statistics = Some(v);
            self
        }
        /// <p>The collection of statistics.</p>
        pub fn set_time_series_service_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TimeSeriesServiceStatistics>>,
        ) -> Self {
            self.time_series_service_statistics = input;
            self
        }
        /// <p>A flag indicating whether or not a group's filter expression has been consistent, or if a returned
        /// aggregation might show statistics from an older version of the group's filter expression.</p>
        pub fn contains_old_group_versions(mut self, input: bool) -> Self {
            self.contains_old_group_versions = Some(input);
            self
        }
        /// <p>A flag indicating whether or not a group's filter expression has been consistent, or if a returned
        /// aggregation might show statistics from an older version of the group's filter expression.</p>
        pub fn set_contains_old_group_versions(mut self, input: std::option::Option<bool>) -> Self {
            self.contains_old_group_versions = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTimeSeriesServiceStatisticsOutput`](crate::output::GetTimeSeriesServiceStatisticsOutput)
        pub fn build(self) -> crate::output::GetTimeSeriesServiceStatisticsOutput {
            crate::output::GetTimeSeriesServiceStatisticsOutput {
                time_series_service_statistics: self.time_series_service_statistics,
                contains_old_group_versions: self.contains_old_group_versions.unwrap_or_default(),
                next_token: self.next_token,
            }
        }
    }
}
impl GetTimeSeriesServiceStatisticsOutput {
    /// Creates a new builder-style object to manufacture [`GetTimeSeriesServiceStatisticsOutput`](crate::output::GetTimeSeriesServiceStatisticsOutput)
    pub fn builder() -> crate::output::get_time_series_service_statistics_output::Builder {
        crate::output::get_time_series_service_statistics_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceGraphOutput {
    /// <p>The start of the time frame for which the graph was generated.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end of the time frame for which the graph was generated.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The services that have processed a traced request during the specified time
    /// frame.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::Service>>,
    /// <p>A flag indicating whether the group's filter expression has been consistent, or
    /// if the returned service graph may show traces from an older version of the group's filter
    /// expression.</p>
    pub contains_old_group_versions: bool,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetServiceGraphOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceGraphOutput");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("services", &self.services);
        formatter.field(
            "contains_old_group_versions",
            &self.contains_old_group_versions,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetServiceGraphOutput`](crate::output::GetServiceGraphOutput)
pub mod get_service_graph_output {
    /// A builder for [`GetServiceGraphOutput`](crate::output::GetServiceGraphOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) services: std::option::Option<std::vec::Vec<crate::model::Service>>,
        pub(crate) contains_old_group_versions: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start of the time frame for which the graph was generated.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time frame for which the graph was generated.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time frame for which the graph was generated.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time frame for which the graph was generated.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>The services that have processed a traced request during the specified time
        /// frame.</p>
        pub fn services(mut self, input: impl Into<crate::model::Service>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>The services that have processed a traced request during the specified time
        /// frame.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Service>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// <p>A flag indicating whether the group's filter expression has been consistent, or
        /// if the returned service graph may show traces from an older version of the group's filter
        /// expression.</p>
        pub fn contains_old_group_versions(mut self, input: bool) -> Self {
            self.contains_old_group_versions = Some(input);
            self
        }
        /// <p>A flag indicating whether the group's filter expression has been consistent, or
        /// if the returned service graph may show traces from an older version of the group's filter
        /// expression.</p>
        pub fn set_contains_old_group_versions(mut self, input: std::option::Option<bool>) -> Self {
            self.contains_old_group_versions = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceGraphOutput`](crate::output::GetServiceGraphOutput)
        pub fn build(self) -> crate::output::GetServiceGraphOutput {
            crate::output::GetServiceGraphOutput {
                start_time: self.start_time,
                end_time: self.end_time,
                services: self.services,
                contains_old_group_versions: self.contains_old_group_versions.unwrap_or_default(),
                next_token: self.next_token,
            }
        }
    }
}
impl GetServiceGraphOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceGraphOutput`](crate::output::GetServiceGraphOutput)
    pub fn builder() -> crate::output::get_service_graph_output::Builder {
        crate::output::get_service_graph_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSamplingTargetsOutput {
    /// <p>Updated rules that the service should use to sample requests.</p>
    pub sampling_target_documents:
        std::option::Option<std::vec::Vec<crate::model::SamplingTargetDocument>>,
    /// <p>The last time a user changed the sampling rule configuration. If
    /// the sampling rule configuration changed since the service last retrieved it, the service
    /// should call <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html">GetSamplingRules</a> to get the latest version.</p>
    pub last_rule_modification: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Information about <a href="https://docs.aws.amazon.com/xray/latest/api/API_SamplingStatisticsDocument.html">SamplingStatisticsDocument</a> that X-Ray could not
    /// process.</p>
    pub unprocessed_statistics:
        std::option::Option<std::vec::Vec<crate::model::UnprocessedStatistics>>,
}
impl std::fmt::Debug for GetSamplingTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSamplingTargetsOutput");
        formatter.field("sampling_target_documents", &self.sampling_target_documents);
        formatter.field("last_rule_modification", &self.last_rule_modification);
        formatter.field("unprocessed_statistics", &self.unprocessed_statistics);
        formatter.finish()
    }
}
/// See [`GetSamplingTargetsOutput`](crate::output::GetSamplingTargetsOutput)
pub mod get_sampling_targets_output {
    /// A builder for [`GetSamplingTargetsOutput`](crate::output::GetSamplingTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampling_target_documents:
            std::option::Option<std::vec::Vec<crate::model::SamplingTargetDocument>>,
        pub(crate) last_rule_modification: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) unprocessed_statistics:
            std::option::Option<std::vec::Vec<crate::model::UnprocessedStatistics>>,
    }
    impl Builder {
        /// Appends an item to `sampling_target_documents`.
        ///
        /// To override the contents of this collection use [`set_sampling_target_documents`](Self::set_sampling_target_documents).
        ///
        /// <p>Updated rules that the service should use to sample requests.</p>
        pub fn sampling_target_documents(
            mut self,
            input: impl Into<crate::model::SamplingTargetDocument>,
        ) -> Self {
            let mut v = self.sampling_target_documents.unwrap_or_default();
            v.push(input.into());
            self.sampling_target_documents = Some(v);
            self
        }
        /// <p>Updated rules that the service should use to sample requests.</p>
        pub fn set_sampling_target_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SamplingTargetDocument>>,
        ) -> Self {
            self.sampling_target_documents = input;
            self
        }
        /// <p>The last time a user changed the sampling rule configuration. If
        /// the sampling rule configuration changed since the service last retrieved it, the service
        /// should call <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html">GetSamplingRules</a> to get the latest version.</p>
        pub fn last_rule_modification(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_rule_modification = Some(input);
            self
        }
        /// <p>The last time a user changed the sampling rule configuration. If
        /// the sampling rule configuration changed since the service last retrieved it, the service
        /// should call <a href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html">GetSamplingRules</a> to get the latest version.</p>
        pub fn set_last_rule_modification(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_rule_modification = input;
            self
        }
        /// Appends an item to `unprocessed_statistics`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_statistics`](Self::set_unprocessed_statistics).
        ///
        /// <p>Information about <a href="https://docs.aws.amazon.com/xray/latest/api/API_SamplingStatisticsDocument.html">SamplingStatisticsDocument</a> that X-Ray could not
        /// process.</p>
        pub fn unprocessed_statistics(
            mut self,
            input: impl Into<crate::model::UnprocessedStatistics>,
        ) -> Self {
            let mut v = self.unprocessed_statistics.unwrap_or_default();
            v.push(input.into());
            self.unprocessed_statistics = Some(v);
            self
        }
        /// <p>Information about <a href="https://docs.aws.amazon.com/xray/latest/api/API_SamplingStatisticsDocument.html">SamplingStatisticsDocument</a> that X-Ray could not
        /// process.</p>
        pub fn set_unprocessed_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UnprocessedStatistics>>,
        ) -> Self {
            self.unprocessed_statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSamplingTargetsOutput`](crate::output::GetSamplingTargetsOutput)
        pub fn build(self) -> crate::output::GetSamplingTargetsOutput {
            crate::output::GetSamplingTargetsOutput {
                sampling_target_documents: self.sampling_target_documents,
                last_rule_modification: self.last_rule_modification,
                unprocessed_statistics: self.unprocessed_statistics,
            }
        }
    }
}
impl GetSamplingTargetsOutput {
    /// Creates a new builder-style object to manufacture [`GetSamplingTargetsOutput`](crate::output::GetSamplingTargetsOutput)
    pub fn builder() -> crate::output::get_sampling_targets_output::Builder {
        crate::output::get_sampling_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSamplingStatisticSummariesOutput {
    /// <p>Information about the number of requests instrumented for each sampling
    /// rule.</p>
    pub sampling_statistic_summaries:
        std::option::Option<std::vec::Vec<crate::model::SamplingStatisticSummary>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSamplingStatisticSummariesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSamplingStatisticSummariesOutput");
        formatter.field(
            "sampling_statistic_summaries",
            &self.sampling_statistic_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetSamplingStatisticSummariesOutput`](crate::output::GetSamplingStatisticSummariesOutput)
pub mod get_sampling_statistic_summaries_output {
    /// A builder for [`GetSamplingStatisticSummariesOutput`](crate::output::GetSamplingStatisticSummariesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampling_statistic_summaries:
            std::option::Option<std::vec::Vec<crate::model::SamplingStatisticSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `sampling_statistic_summaries`.
        ///
        /// To override the contents of this collection use [`set_sampling_statistic_summaries`](Self::set_sampling_statistic_summaries).
        ///
        /// <p>Information about the number of requests instrumented for each sampling
        /// rule.</p>
        pub fn sampling_statistic_summaries(
            mut self,
            input: impl Into<crate::model::SamplingStatisticSummary>,
        ) -> Self {
            let mut v = self.sampling_statistic_summaries.unwrap_or_default();
            v.push(input.into());
            self.sampling_statistic_summaries = Some(v);
            self
        }
        /// <p>Information about the number of requests instrumented for each sampling
        /// rule.</p>
        pub fn set_sampling_statistic_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SamplingStatisticSummary>>,
        ) -> Self {
            self.sampling_statistic_summaries = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSamplingStatisticSummariesOutput`](crate::output::GetSamplingStatisticSummariesOutput)
        pub fn build(self) -> crate::output::GetSamplingStatisticSummariesOutput {
            crate::output::GetSamplingStatisticSummariesOutput {
                sampling_statistic_summaries: self.sampling_statistic_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl GetSamplingStatisticSummariesOutput {
    /// Creates a new builder-style object to manufacture [`GetSamplingStatisticSummariesOutput`](crate::output::GetSamplingStatisticSummariesOutput)
    pub fn builder() -> crate::output::get_sampling_statistic_summaries_output::Builder {
        crate::output::get_sampling_statistic_summaries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSamplingRulesOutput {
    /// <p>Rule definitions and metadata.</p>
    pub sampling_rule_records: std::option::Option<std::vec::Vec<crate::model::SamplingRuleRecord>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSamplingRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSamplingRulesOutput");
        formatter.field("sampling_rule_records", &self.sampling_rule_records);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetSamplingRulesOutput`](crate::output::GetSamplingRulesOutput)
pub mod get_sampling_rules_output {
    /// A builder for [`GetSamplingRulesOutput`](crate::output::GetSamplingRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampling_rule_records:
            std::option::Option<std::vec::Vec<crate::model::SamplingRuleRecord>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `sampling_rule_records`.
        ///
        /// To override the contents of this collection use [`set_sampling_rule_records`](Self::set_sampling_rule_records).
        ///
        /// <p>Rule definitions and metadata.</p>
        pub fn sampling_rule_records(
            mut self,
            input: impl Into<crate::model::SamplingRuleRecord>,
        ) -> Self {
            let mut v = self.sampling_rule_records.unwrap_or_default();
            v.push(input.into());
            self.sampling_rule_records = Some(v);
            self
        }
        /// <p>Rule definitions and metadata.</p>
        pub fn set_sampling_rule_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SamplingRuleRecord>>,
        ) -> Self {
            self.sampling_rule_records = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSamplingRulesOutput`](crate::output::GetSamplingRulesOutput)
        pub fn build(self) -> crate::output::GetSamplingRulesOutput {
            crate::output::GetSamplingRulesOutput {
                sampling_rule_records: self.sampling_rule_records,
                next_token: self.next_token,
            }
        }
    }
}
impl GetSamplingRulesOutput {
    /// Creates a new builder-style object to manufacture [`GetSamplingRulesOutput`](crate::output::GetSamplingRulesOutput)
    pub fn builder() -> crate::output::get_sampling_rules_output::Builder {
        crate::output::get_sampling_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightSummariesOutput {
    /// <p>The summary of each insight within the group matching the provided filters. The summary
    /// contains the InsightID, start and end time, the root cause service, the root cause and
    /// client impact statistics, the top anomalous services, and the status of the insight.</p>
    pub insight_summaries: std::option::Option<std::vec::Vec<crate::model::InsightSummary>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetInsightSummariesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightSummariesOutput");
        formatter.field("insight_summaries", &self.insight_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetInsightSummariesOutput`](crate::output::GetInsightSummariesOutput)
pub mod get_insight_summaries_output {
    /// A builder for [`GetInsightSummariesOutput`](crate::output::GetInsightSummariesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_summaries:
            std::option::Option<std::vec::Vec<crate::model::InsightSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `insight_summaries`.
        ///
        /// To override the contents of this collection use [`set_insight_summaries`](Self::set_insight_summaries).
        ///
        /// <p>The summary of each insight within the group matching the provided filters. The summary
        /// contains the InsightID, start and end time, the root cause service, the root cause and
        /// client impact statistics, the top anomalous services, and the status of the insight.</p>
        pub fn insight_summaries(mut self, input: impl Into<crate::model::InsightSummary>) -> Self {
            let mut v = self.insight_summaries.unwrap_or_default();
            v.push(input.into());
            self.insight_summaries = Some(v);
            self
        }
        /// <p>The summary of each insight within the group matching the provided filters. The summary
        /// contains the InsightID, start and end time, the root cause service, the root cause and
        /// client impact statistics, the top anomalous services, and the status of the insight.</p>
        pub fn set_insight_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSummary>>,
        ) -> Self {
            self.insight_summaries = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightSummariesOutput`](crate::output::GetInsightSummariesOutput)
        pub fn build(self) -> crate::output::GetInsightSummariesOutput {
            crate::output::GetInsightSummariesOutput {
                insight_summaries: self.insight_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl GetInsightSummariesOutput {
    /// Creates a new builder-style object to manufacture [`GetInsightSummariesOutput`](crate::output::GetInsightSummariesOutput)
    pub fn builder() -> crate::output::get_insight_summaries_output::Builder {
        crate::output::get_insight_summaries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightImpactGraphOutput {
    /// <p>The insight's unique identifier.</p>
    pub insight_id: std::option::Option<std::string::String>,
    /// <p>The provided start time.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The provided end time. </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time, in Unix seconds, at which the service graph started.</p>
    pub service_graph_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time, in Unix seconds, at which the service graph ended.</p>
    pub service_graph_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Web Services instrumented services related to the insight.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::InsightImpactGraphService>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetInsightImpactGraphOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightImpactGraphOutput");
        formatter.field("insight_id", &self.insight_id);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("service_graph_start_time", &self.service_graph_start_time);
        formatter.field("service_graph_end_time", &self.service_graph_end_time);
        formatter.field("services", &self.services);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetInsightImpactGraphOutput`](crate::output::GetInsightImpactGraphOutput)
pub mod get_insight_impact_graph_output {
    /// A builder for [`GetInsightImpactGraphOutput`](crate::output::GetInsightImpactGraphOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) service_graph_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) service_graph_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) services:
            std::option::Option<std::vec::Vec<crate::model::InsightImpactGraphService>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The insight's unique identifier.</p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p>The insight's unique identifier.</p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// <p>The provided start time.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The provided start time.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The provided end time. </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The provided end time. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The time, in Unix seconds, at which the service graph started.</p>
        pub fn service_graph_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.service_graph_start_time = Some(input);
            self
        }
        /// <p>The time, in Unix seconds, at which the service graph started.</p>
        pub fn set_service_graph_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.service_graph_start_time = input;
            self
        }
        /// <p>The time, in Unix seconds, at which the service graph ended.</p>
        pub fn service_graph_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.service_graph_end_time = Some(input);
            self
        }
        /// <p>The time, in Unix seconds, at which the service graph ended.</p>
        pub fn set_service_graph_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.service_graph_end_time = input;
            self
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>The Amazon Web Services instrumented services related to the insight.</p>
        pub fn services(
            mut self,
            input: impl Into<crate::model::InsightImpactGraphService>,
        ) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>The Amazon Web Services instrumented services related to the insight.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightImpactGraphService>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightImpactGraphOutput`](crate::output::GetInsightImpactGraphOutput)
        pub fn build(self) -> crate::output::GetInsightImpactGraphOutput {
            crate::output::GetInsightImpactGraphOutput {
                insight_id: self.insight_id,
                start_time: self.start_time,
                end_time: self.end_time,
                service_graph_start_time: self.service_graph_start_time,
                service_graph_end_time: self.service_graph_end_time,
                services: self.services,
                next_token: self.next_token,
            }
        }
    }
}
impl GetInsightImpactGraphOutput {
    /// Creates a new builder-style object to manufacture [`GetInsightImpactGraphOutput`](crate::output::GetInsightImpactGraphOutput)
    pub fn builder() -> crate::output::get_insight_impact_graph_output::Builder {
        crate::output::get_insight_impact_graph_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightEventsOutput {
    /// <p>A detailed description of the event. This includes the time of the event, client and
    /// root cause impact statistics, and the top anomalous service at the time of the
    /// event.</p>
    pub insight_events: std::option::Option<std::vec::Vec<crate::model::InsightEvent>>,
    /// <p>Use this token to retrieve the next page of insight events.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetInsightEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightEventsOutput");
        formatter.field("insight_events", &self.insight_events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetInsightEventsOutput`](crate::output::GetInsightEventsOutput)
pub mod get_insight_events_output {
    /// A builder for [`GetInsightEventsOutput`](crate::output::GetInsightEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_events: std::option::Option<std::vec::Vec<crate::model::InsightEvent>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `insight_events`.
        ///
        /// To override the contents of this collection use [`set_insight_events`](Self::set_insight_events).
        ///
        /// <p>A detailed description of the event. This includes the time of the event, client and
        /// root cause impact statistics, and the top anomalous service at the time of the
        /// event.</p>
        pub fn insight_events(mut self, input: impl Into<crate::model::InsightEvent>) -> Self {
            let mut v = self.insight_events.unwrap_or_default();
            v.push(input.into());
            self.insight_events = Some(v);
            self
        }
        /// <p>A detailed description of the event. This includes the time of the event, client and
        /// root cause impact statistics, and the top anomalous service at the time of the
        /// event.</p>
        pub fn set_insight_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightEvent>>,
        ) -> Self {
            self.insight_events = input;
            self
        }
        /// <p>Use this token to retrieve the next page of insight events.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Use this token to retrieve the next page of insight events.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightEventsOutput`](crate::output::GetInsightEventsOutput)
        pub fn build(self) -> crate::output::GetInsightEventsOutput {
            crate::output::GetInsightEventsOutput {
                insight_events: self.insight_events,
                next_token: self.next_token,
            }
        }
    }
}
impl GetInsightEventsOutput {
    /// Creates a new builder-style object to manufacture [`GetInsightEventsOutput`](crate::output::GetInsightEventsOutput)
    pub fn builder() -> crate::output::get_insight_events_output::Builder {
        crate::output::get_insight_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightOutput {
    /// <p>The summary information of an insight.</p>
    pub insight: std::option::Option<crate::model::Insight>,
}
impl std::fmt::Debug for GetInsightOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightOutput");
        formatter.field("insight", &self.insight);
        formatter.finish()
    }
}
/// See [`GetInsightOutput`](crate::output::GetInsightOutput)
pub mod get_insight_output {
    /// A builder for [`GetInsightOutput`](crate::output::GetInsightOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight: std::option::Option<crate::model::Insight>,
    }
    impl Builder {
        /// <p>The summary information of an insight.</p>
        pub fn insight(mut self, input: crate::model::Insight) -> Self {
            self.insight = Some(input);
            self
        }
        /// <p>The summary information of an insight.</p>
        pub fn set_insight(mut self, input: std::option::Option<crate::model::Insight>) -> Self {
            self.insight = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightOutput`](crate::output::GetInsightOutput)
        pub fn build(self) -> crate::output::GetInsightOutput {
            crate::output::GetInsightOutput {
                insight: self.insight,
            }
        }
    }
}
impl GetInsightOutput {
    /// Creates a new builder-style object to manufacture [`GetInsightOutput`](crate::output::GetInsightOutput)
    pub fn builder() -> crate::output::get_insight_output::Builder {
        crate::output::get_insight_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupsOutput {
    /// <p>The collection of all active groups.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::GroupSummary>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupsOutput");
        formatter.field("groups", &self.groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetGroupsOutput`](crate::output::GetGroupsOutput)
pub mod get_groups_output {
    /// A builder for [`GetGroupsOutput`](crate::output::GetGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::GroupSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The collection of all active groups.</p>
        pub fn groups(mut self, input: impl Into<crate::model::GroupSummary>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The collection of all active groups.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupSummary>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupsOutput`](crate::output::GetGroupsOutput)
        pub fn build(self) -> crate::output::GetGroupsOutput {
            crate::output::GetGroupsOutput {
                groups: self.groups,
                next_token: self.next_token,
            }
        }
    }
}
impl GetGroupsOutput {
    /// Creates a new builder-style object to manufacture [`GetGroupsOutput`](crate::output::GetGroupsOutput)
    pub fn builder() -> crate::output::get_groups_output::Builder {
        crate::output::get_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupOutput {
    /// <p>The group that was requested. Contains the name of the group, the ARN of the group,
    /// the filter expression, and the insight configuration assigned to the group.</p>
    pub group: std::option::Option<crate::model::Group>,
}
impl std::fmt::Debug for GetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupOutput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}
/// See [`GetGroupOutput`](crate::output::GetGroupOutput)
pub mod get_group_output {
    /// A builder for [`GetGroupOutput`](crate::output::GetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
    }
    impl Builder {
        /// <p>The group that was requested. Contains the name of the group, the ARN of the group,
        /// the filter expression, and the insight configuration assigned to the group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The group that was requested. Contains the name of the group, the ARN of the group,
        /// the filter expression, and the insight configuration assigned to the group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupOutput`](crate::output::GetGroupOutput)
        pub fn build(self) -> crate::output::GetGroupOutput {
            crate::output::GetGroupOutput { group: self.group }
        }
    }
}
impl GetGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetGroupOutput`](crate::output::GetGroupOutput)
    pub fn builder() -> crate::output::get_group_output::Builder {
        crate::output::get_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEncryptionConfigOutput {
    /// <p>The encryption configuration document.</p>
    pub encryption_config: std::option::Option<crate::model::EncryptionConfig>,
}
impl std::fmt::Debug for GetEncryptionConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEncryptionConfigOutput");
        formatter.field("encryption_config", &self.encryption_config);
        formatter.finish()
    }
}
/// See [`GetEncryptionConfigOutput`](crate::output::GetEncryptionConfigOutput)
pub mod get_encryption_config_output {
    /// A builder for [`GetEncryptionConfigOutput`](crate::output::GetEncryptionConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_config: std::option::Option<crate::model::EncryptionConfig>,
    }
    impl Builder {
        /// <p>The encryption configuration document.</p>
        pub fn encryption_config(mut self, input: crate::model::EncryptionConfig) -> Self {
            self.encryption_config = Some(input);
            self
        }
        /// <p>The encryption configuration document.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfig>,
        ) -> Self {
            self.encryption_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEncryptionConfigOutput`](crate::output::GetEncryptionConfigOutput)
        pub fn build(self) -> crate::output::GetEncryptionConfigOutput {
            crate::output::GetEncryptionConfigOutput {
                encryption_config: self.encryption_config,
            }
        }
    }
}
impl GetEncryptionConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetEncryptionConfigOutput`](crate::output::GetEncryptionConfigOutput)
    pub fn builder() -> crate::output::get_encryption_config_output::Builder {
        crate::output::get_encryption_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSamplingRuleOutput {
    /// <p>The deleted rule definition and metadata.</p>
    pub sampling_rule_record: std::option::Option<crate::model::SamplingRuleRecord>,
}
impl std::fmt::Debug for DeleteSamplingRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSamplingRuleOutput");
        formatter.field("sampling_rule_record", &self.sampling_rule_record);
        formatter.finish()
    }
}
/// See [`DeleteSamplingRuleOutput`](crate::output::DeleteSamplingRuleOutput)
pub mod delete_sampling_rule_output {
    /// A builder for [`DeleteSamplingRuleOutput`](crate::output::DeleteSamplingRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampling_rule_record: std::option::Option<crate::model::SamplingRuleRecord>,
    }
    impl Builder {
        /// <p>The deleted rule definition and metadata.</p>
        pub fn sampling_rule_record(mut self, input: crate::model::SamplingRuleRecord) -> Self {
            self.sampling_rule_record = Some(input);
            self
        }
        /// <p>The deleted rule definition and metadata.</p>
        pub fn set_sampling_rule_record(
            mut self,
            input: std::option::Option<crate::model::SamplingRuleRecord>,
        ) -> Self {
            self.sampling_rule_record = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSamplingRuleOutput`](crate::output::DeleteSamplingRuleOutput)
        pub fn build(self) -> crate::output::DeleteSamplingRuleOutput {
            crate::output::DeleteSamplingRuleOutput {
                sampling_rule_record: self.sampling_rule_record,
            }
        }
    }
}
impl DeleteSamplingRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSamplingRuleOutput`](crate::output::DeleteSamplingRuleOutput)
    pub fn builder() -> crate::output::delete_sampling_rule_output::Builder {
        crate::output::delete_sampling_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupOutput {}
impl std::fmt::Debug for DeleteGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
pub mod delete_group_output {
    /// A builder for [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
        pub fn build(self) -> crate::output::DeleteGroupOutput {
            crate::output::DeleteGroupOutput {}
        }
    }
}
impl DeleteGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
    pub fn builder() -> crate::output::delete_group_output::Builder {
        crate::output::delete_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSamplingRuleOutput {
    /// <p>The saved rule definition and metadata.</p>
    pub sampling_rule_record: std::option::Option<crate::model::SamplingRuleRecord>,
}
impl std::fmt::Debug for CreateSamplingRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSamplingRuleOutput");
        formatter.field("sampling_rule_record", &self.sampling_rule_record);
        formatter.finish()
    }
}
/// See [`CreateSamplingRuleOutput`](crate::output::CreateSamplingRuleOutput)
pub mod create_sampling_rule_output {
    /// A builder for [`CreateSamplingRuleOutput`](crate::output::CreateSamplingRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampling_rule_record: std::option::Option<crate::model::SamplingRuleRecord>,
    }
    impl Builder {
        /// <p>The saved rule definition and metadata.</p>
        pub fn sampling_rule_record(mut self, input: crate::model::SamplingRuleRecord) -> Self {
            self.sampling_rule_record = Some(input);
            self
        }
        /// <p>The saved rule definition and metadata.</p>
        pub fn set_sampling_rule_record(
            mut self,
            input: std::option::Option<crate::model::SamplingRuleRecord>,
        ) -> Self {
            self.sampling_rule_record = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSamplingRuleOutput`](crate::output::CreateSamplingRuleOutput)
        pub fn build(self) -> crate::output::CreateSamplingRuleOutput {
            crate::output::CreateSamplingRuleOutput {
                sampling_rule_record: self.sampling_rule_record,
            }
        }
    }
}
impl CreateSamplingRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateSamplingRuleOutput`](crate::output::CreateSamplingRuleOutput)
    pub fn builder() -> crate::output::create_sampling_rule_output::Builder {
        crate::output::create_sampling_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupOutput {
    /// <p>The group that was created. Contains the name of the group that was created, the Amazon Resource Name
    /// (ARN) of the group that was generated based on the group name, the filter expression, and the insight
    /// configuration that was assigned to the group.</p>
    pub group: std::option::Option<crate::model::Group>,
}
impl std::fmt::Debug for CreateGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupOutput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}
/// See [`CreateGroupOutput`](crate::output::CreateGroupOutput)
pub mod create_group_output {
    /// A builder for [`CreateGroupOutput`](crate::output::CreateGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
    }
    impl Builder {
        /// <p>The group that was created. Contains the name of the group that was created, the Amazon Resource Name
        /// (ARN) of the group that was generated based on the group name, the filter expression, and the insight
        /// configuration that was assigned to the group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The group that was created. Contains the name of the group that was created, the Amazon Resource Name
        /// (ARN) of the group that was generated based on the group name, the filter expression, and the insight
        /// configuration that was assigned to the group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupOutput`](crate::output::CreateGroupOutput)
        pub fn build(self) -> crate::output::CreateGroupOutput {
            crate::output::CreateGroupOutput { group: self.group }
        }
    }
}
impl CreateGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateGroupOutput`](crate::output::CreateGroupOutput)
    pub fn builder() -> crate::output::create_group_output::Builder {
        crate::output::create_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetTracesOutput {
    /// <p>Full traces for the specified requests.</p>
    pub traces: std::option::Option<std::vec::Vec<crate::model::Trace>>,
    /// <p>Trace IDs of requests that haven't been processed.</p>
    pub unprocessed_trace_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchGetTracesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetTracesOutput");
        formatter.field("traces", &self.traces);
        formatter.field("unprocessed_trace_ids", &self.unprocessed_trace_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`BatchGetTracesOutput`](crate::output::BatchGetTracesOutput)
pub mod batch_get_traces_output {
    /// A builder for [`BatchGetTracesOutput`](crate::output::BatchGetTracesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traces: std::option::Option<std::vec::Vec<crate::model::Trace>>,
        pub(crate) unprocessed_trace_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `traces`.
        ///
        /// To override the contents of this collection use [`set_traces`](Self::set_traces).
        ///
        /// <p>Full traces for the specified requests.</p>
        pub fn traces(mut self, input: impl Into<crate::model::Trace>) -> Self {
            let mut v = self.traces.unwrap_or_default();
            v.push(input.into());
            self.traces = Some(v);
            self
        }
        /// <p>Full traces for the specified requests.</p>
        pub fn set_traces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Trace>>,
        ) -> Self {
            self.traces = input;
            self
        }
        /// Appends an item to `unprocessed_trace_ids`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_trace_ids`](Self::set_unprocessed_trace_ids).
        ///
        /// <p>Trace IDs of requests that haven't been processed.</p>
        pub fn unprocessed_trace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.unprocessed_trace_ids.unwrap_or_default();
            v.push(input.into());
            self.unprocessed_trace_ids = Some(v);
            self
        }
        /// <p>Trace IDs of requests that haven't been processed.</p>
        pub fn set_unprocessed_trace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.unprocessed_trace_ids = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetTracesOutput`](crate::output::BatchGetTracesOutput)
        pub fn build(self) -> crate::output::BatchGetTracesOutput {
            crate::output::BatchGetTracesOutput {
                traces: self.traces,
                unprocessed_trace_ids: self.unprocessed_trace_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl BatchGetTracesOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetTracesOutput`](crate::output::BatchGetTracesOutput)
    pub fn builder() -> crate::output::batch_get_traces_output::Builder {
        crate::output::batch_get_traces_output::Builder::default()
    }
}
