// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateBrowserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_browser_settings`](crate::client::Client::associate_browser_settings).
///
/// See [`crate::client::fluent_builders::AssociateBrowserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateBrowserSettings {
    _private: (),
}
impl AssociateBrowserSettings {
    /// Creates a new builder-style object to manufacture [`AssociateBrowserSettingsInput`](crate::input::AssociateBrowserSettingsInput)
    pub fn builder() -> crate::input::associate_browser_settings_input::Builder {
        crate::input::associate_browser_settings_input::Builder::default()
    }
    /// Creates a new `AssociateBrowserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateBrowserSettings {
    type Output = std::result::Result<
        crate::output::AssociateBrowserSettingsOutput,
        crate::error::AssociateBrowserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_browser_settings_error(response)
        } else {
            crate::operation_deser::parse_associate_browser_settings_response(response)
        }
    }
}

/// Operation shape for `AssociateNetworkSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_network_settings`](crate::client::Client::associate_network_settings).
///
/// See [`crate::client::fluent_builders::AssociateNetworkSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateNetworkSettings {
    _private: (),
}
impl AssociateNetworkSettings {
    /// Creates a new builder-style object to manufacture [`AssociateNetworkSettingsInput`](crate::input::AssociateNetworkSettingsInput)
    pub fn builder() -> crate::input::associate_network_settings_input::Builder {
        crate::input::associate_network_settings_input::Builder::default()
    }
    /// Creates a new `AssociateNetworkSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateNetworkSettings {
    type Output = std::result::Result<
        crate::output::AssociateNetworkSettingsOutput,
        crate::error::AssociateNetworkSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_network_settings_error(response)
        } else {
            crate::operation_deser::parse_associate_network_settings_response(response)
        }
    }
}

/// Operation shape for `AssociateTrustStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_trust_store`](crate::client::Client::associate_trust_store).
///
/// See [`crate::client::fluent_builders::AssociateTrustStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateTrustStore {
    _private: (),
}
impl AssociateTrustStore {
    /// Creates a new builder-style object to manufacture [`AssociateTrustStoreInput`](crate::input::AssociateTrustStoreInput)
    pub fn builder() -> crate::input::associate_trust_store_input::Builder {
        crate::input::associate_trust_store_input::Builder::default()
    }
    /// Creates a new `AssociateTrustStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateTrustStore {
    type Output = std::result::Result<
        crate::output::AssociateTrustStoreOutput,
        crate::error::AssociateTrustStoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_trust_store_error(response)
        } else {
            crate::operation_deser::parse_associate_trust_store_response(response)
        }
    }
}

/// Operation shape for `AssociateUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_user_settings`](crate::client::Client::associate_user_settings).
///
/// See [`crate::client::fluent_builders::AssociateUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateUserSettings {
    _private: (),
}
impl AssociateUserSettings {
    /// Creates a new builder-style object to manufacture [`AssociateUserSettingsInput`](crate::input::AssociateUserSettingsInput)
    pub fn builder() -> crate::input::associate_user_settings_input::Builder {
        crate::input::associate_user_settings_input::Builder::default()
    }
    /// Creates a new `AssociateUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateUserSettings {
    type Output = std::result::Result<
        crate::output::AssociateUserSettingsOutput,
        crate::error::AssociateUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_user_settings_error(response)
        } else {
            crate::operation_deser::parse_associate_user_settings_response(response)
        }
    }
}

/// Operation shape for `CreateBrowserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_browser_settings`](crate::client::Client::create_browser_settings).
///
/// See [`crate::client::fluent_builders::CreateBrowserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBrowserSettings {
    _private: (),
}
impl CreateBrowserSettings {
    /// Creates a new builder-style object to manufacture [`CreateBrowserSettingsInput`](crate::input::CreateBrowserSettingsInput)
    pub fn builder() -> crate::input::create_browser_settings_input::Builder {
        crate::input::create_browser_settings_input::Builder::default()
    }
    /// Creates a new `CreateBrowserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBrowserSettings {
    type Output = std::result::Result<
        crate::output::CreateBrowserSettingsOutput,
        crate::error::CreateBrowserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_browser_settings_error(response)
        } else {
            crate::operation_deser::parse_create_browser_settings_response(response)
        }
    }
}

/// Operation shape for `CreateIdentityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_identity_provider`](crate::client::Client::create_identity_provider).
///
/// See [`crate::client::fluent_builders::CreateIdentityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIdentityProvider {
    _private: (),
}
impl CreateIdentityProvider {
    /// Creates a new builder-style object to manufacture [`CreateIdentityProviderInput`](crate::input::CreateIdentityProviderInput)
    pub fn builder() -> crate::input::create_identity_provider_input::Builder {
        crate::input::create_identity_provider_input::Builder::default()
    }
    /// Creates a new `CreateIdentityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIdentityProvider {
    type Output = std::result::Result<
        crate::output::CreateIdentityProviderOutput,
        crate::error::CreateIdentityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_identity_provider_error(response)
        } else {
            crate::operation_deser::parse_create_identity_provider_response(response)
        }
    }
}

/// Operation shape for `CreateNetworkSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_network_settings`](crate::client::Client::create_network_settings).
///
/// See [`crate::client::fluent_builders::CreateNetworkSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNetworkSettings {
    _private: (),
}
impl CreateNetworkSettings {
    /// Creates a new builder-style object to manufacture [`CreateNetworkSettingsInput`](crate::input::CreateNetworkSettingsInput)
    pub fn builder() -> crate::input::create_network_settings_input::Builder {
        crate::input::create_network_settings_input::Builder::default()
    }
    /// Creates a new `CreateNetworkSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNetworkSettings {
    type Output = std::result::Result<
        crate::output::CreateNetworkSettingsOutput,
        crate::error::CreateNetworkSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_network_settings_error(response)
        } else {
            crate::operation_deser::parse_create_network_settings_response(response)
        }
    }
}

/// Operation shape for `CreatePortal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_portal`](crate::client::Client::create_portal).
///
/// See [`crate::client::fluent_builders::CreatePortal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePortal {
    _private: (),
}
impl CreatePortal {
    /// Creates a new builder-style object to manufacture [`CreatePortalInput`](crate::input::CreatePortalInput)
    pub fn builder() -> crate::input::create_portal_input::Builder {
        crate::input::create_portal_input::Builder::default()
    }
    /// Creates a new `CreatePortal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePortal {
    type Output =
        std::result::Result<crate::output::CreatePortalOutput, crate::error::CreatePortalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_portal_error(response)
        } else {
            crate::operation_deser::parse_create_portal_response(response)
        }
    }
}

/// Operation shape for `CreateTrustStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_trust_store`](crate::client::Client::create_trust_store).
///
/// See [`crate::client::fluent_builders::CreateTrustStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrustStore {
    _private: (),
}
impl CreateTrustStore {
    /// Creates a new builder-style object to manufacture [`CreateTrustStoreInput`](crate::input::CreateTrustStoreInput)
    pub fn builder() -> crate::input::create_trust_store_input::Builder {
        crate::input::create_trust_store_input::Builder::default()
    }
    /// Creates a new `CreateTrustStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrustStore {
    type Output = std::result::Result<
        crate::output::CreateTrustStoreOutput,
        crate::error::CreateTrustStoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_trust_store_error(response)
        } else {
            crate::operation_deser::parse_create_trust_store_response(response)
        }
    }
}

/// Operation shape for `CreateUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user_settings`](crate::client::Client::create_user_settings).
///
/// See [`crate::client::fluent_builders::CreateUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUserSettings {
    _private: (),
}
impl CreateUserSettings {
    /// Creates a new builder-style object to manufacture [`CreateUserSettingsInput`](crate::input::CreateUserSettingsInput)
    pub fn builder() -> crate::input::create_user_settings_input::Builder {
        crate::input::create_user_settings_input::Builder::default()
    }
    /// Creates a new `CreateUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUserSettings {
    type Output = std::result::Result<
        crate::output::CreateUserSettingsOutput,
        crate::error::CreateUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_settings_error(response)
        } else {
            crate::operation_deser::parse_create_user_settings_response(response)
        }
    }
}

/// Operation shape for `DeleteBrowserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_browser_settings`](crate::client::Client::delete_browser_settings).
///
/// See [`crate::client::fluent_builders::DeleteBrowserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBrowserSettings {
    _private: (),
}
impl DeleteBrowserSettings {
    /// Creates a new builder-style object to manufacture [`DeleteBrowserSettingsInput`](crate::input::DeleteBrowserSettingsInput)
    pub fn builder() -> crate::input::delete_browser_settings_input::Builder {
        crate::input::delete_browser_settings_input::Builder::default()
    }
    /// Creates a new `DeleteBrowserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBrowserSettings {
    type Output = std::result::Result<
        crate::output::DeleteBrowserSettingsOutput,
        crate::error::DeleteBrowserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_browser_settings_error(response)
        } else {
            crate::operation_deser::parse_delete_browser_settings_response(response)
        }
    }
}

/// Operation shape for `DeleteIdentityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_identity_provider`](crate::client::Client::delete_identity_provider).
///
/// See [`crate::client::fluent_builders::DeleteIdentityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIdentityProvider {
    _private: (),
}
impl DeleteIdentityProvider {
    /// Creates a new builder-style object to manufacture [`DeleteIdentityProviderInput`](crate::input::DeleteIdentityProviderInput)
    pub fn builder() -> crate::input::delete_identity_provider_input::Builder {
        crate::input::delete_identity_provider_input::Builder::default()
    }
    /// Creates a new `DeleteIdentityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIdentityProvider {
    type Output = std::result::Result<
        crate::output::DeleteIdentityProviderOutput,
        crate::error::DeleteIdentityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_identity_provider_error(response)
        } else {
            crate::operation_deser::parse_delete_identity_provider_response(response)
        }
    }
}

/// Operation shape for `DeleteNetworkSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_settings`](crate::client::Client::delete_network_settings).
///
/// See [`crate::client::fluent_builders::DeleteNetworkSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkSettings {
    _private: (),
}
impl DeleteNetworkSettings {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkSettingsInput`](crate::input::DeleteNetworkSettingsInput)
    pub fn builder() -> crate::input::delete_network_settings_input::Builder {
        crate::input::delete_network_settings_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkSettings {
    type Output = std::result::Result<
        crate::output::DeleteNetworkSettingsOutput,
        crate::error::DeleteNetworkSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_settings_error(response)
        } else {
            crate::operation_deser::parse_delete_network_settings_response(response)
        }
    }
}

/// Operation shape for `DeletePortal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_portal`](crate::client::Client::delete_portal).
///
/// See [`crate::client::fluent_builders::DeletePortal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePortal {
    _private: (),
}
impl DeletePortal {
    /// Creates a new builder-style object to manufacture [`DeletePortalInput`](crate::input::DeletePortalInput)
    pub fn builder() -> crate::input::delete_portal_input::Builder {
        crate::input::delete_portal_input::Builder::default()
    }
    /// Creates a new `DeletePortal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePortal {
    type Output =
        std::result::Result<crate::output::DeletePortalOutput, crate::error::DeletePortalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_portal_error(response)
        } else {
            crate::operation_deser::parse_delete_portal_response(response)
        }
    }
}

/// Operation shape for `DeleteTrustStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_trust_store`](crate::client::Client::delete_trust_store).
///
/// See [`crate::client::fluent_builders::DeleteTrustStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrustStore {
    _private: (),
}
impl DeleteTrustStore {
    /// Creates a new builder-style object to manufacture [`DeleteTrustStoreInput`](crate::input::DeleteTrustStoreInput)
    pub fn builder() -> crate::input::delete_trust_store_input::Builder {
        crate::input::delete_trust_store_input::Builder::default()
    }
    /// Creates a new `DeleteTrustStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrustStore {
    type Output = std::result::Result<
        crate::output::DeleteTrustStoreOutput,
        crate::error::DeleteTrustStoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_trust_store_error(response)
        } else {
            crate::operation_deser::parse_delete_trust_store_response(response)
        }
    }
}

/// Operation shape for `DeleteUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_settings`](crate::client::Client::delete_user_settings).
///
/// See [`crate::client::fluent_builders::DeleteUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserSettings {
    _private: (),
}
impl DeleteUserSettings {
    /// Creates a new builder-style object to manufacture [`DeleteUserSettingsInput`](crate::input::DeleteUserSettingsInput)
    pub fn builder() -> crate::input::delete_user_settings_input::Builder {
        crate::input::delete_user_settings_input::Builder::default()
    }
    /// Creates a new `DeleteUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserSettings {
    type Output = std::result::Result<
        crate::output::DeleteUserSettingsOutput,
        crate::error::DeleteUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_settings_error(response)
        } else {
            crate::operation_deser::parse_delete_user_settings_response(response)
        }
    }
}

/// Operation shape for `DisassociateBrowserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_browser_settings`](crate::client::Client::disassociate_browser_settings).
///
/// See [`crate::client::fluent_builders::DisassociateBrowserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateBrowserSettings {
    _private: (),
}
impl DisassociateBrowserSettings {
    /// Creates a new builder-style object to manufacture [`DisassociateBrowserSettingsInput`](crate::input::DisassociateBrowserSettingsInput)
    pub fn builder() -> crate::input::disassociate_browser_settings_input::Builder {
        crate::input::disassociate_browser_settings_input::Builder::default()
    }
    /// Creates a new `DisassociateBrowserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateBrowserSettings {
    type Output = std::result::Result<
        crate::output::DisassociateBrowserSettingsOutput,
        crate::error::DisassociateBrowserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_browser_settings_error(response)
        } else {
            crate::operation_deser::parse_disassociate_browser_settings_response(response)
        }
    }
}

/// Operation shape for `DisassociateNetworkSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_network_settings`](crate::client::Client::disassociate_network_settings).
///
/// See [`crate::client::fluent_builders::DisassociateNetworkSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateNetworkSettings {
    _private: (),
}
impl DisassociateNetworkSettings {
    /// Creates a new builder-style object to manufacture [`DisassociateNetworkSettingsInput`](crate::input::DisassociateNetworkSettingsInput)
    pub fn builder() -> crate::input::disassociate_network_settings_input::Builder {
        crate::input::disassociate_network_settings_input::Builder::default()
    }
    /// Creates a new `DisassociateNetworkSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateNetworkSettings {
    type Output = std::result::Result<
        crate::output::DisassociateNetworkSettingsOutput,
        crate::error::DisassociateNetworkSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_network_settings_error(response)
        } else {
            crate::operation_deser::parse_disassociate_network_settings_response(response)
        }
    }
}

/// Operation shape for `DisassociateTrustStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_trust_store`](crate::client::Client::disassociate_trust_store).
///
/// See [`crate::client::fluent_builders::DisassociateTrustStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateTrustStore {
    _private: (),
}
impl DisassociateTrustStore {
    /// Creates a new builder-style object to manufacture [`DisassociateTrustStoreInput`](crate::input::DisassociateTrustStoreInput)
    pub fn builder() -> crate::input::disassociate_trust_store_input::Builder {
        crate::input::disassociate_trust_store_input::Builder::default()
    }
    /// Creates a new `DisassociateTrustStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateTrustStore {
    type Output = std::result::Result<
        crate::output::DisassociateTrustStoreOutput,
        crate::error::DisassociateTrustStoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_trust_store_error(response)
        } else {
            crate::operation_deser::parse_disassociate_trust_store_response(response)
        }
    }
}

/// Operation shape for `DisassociateUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_user_settings`](crate::client::Client::disassociate_user_settings).
///
/// See [`crate::client::fluent_builders::DisassociateUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateUserSettings {
    _private: (),
}
impl DisassociateUserSettings {
    /// Creates a new builder-style object to manufacture [`DisassociateUserSettingsInput`](crate::input::DisassociateUserSettingsInput)
    pub fn builder() -> crate::input::disassociate_user_settings_input::Builder {
        crate::input::disassociate_user_settings_input::Builder::default()
    }
    /// Creates a new `DisassociateUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateUserSettings {
    type Output = std::result::Result<
        crate::output::DisassociateUserSettingsOutput,
        crate::error::DisassociateUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_user_settings_error(response)
        } else {
            crate::operation_deser::parse_disassociate_user_settings_response(response)
        }
    }
}

/// Operation shape for `GetBrowserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_browser_settings`](crate::client::Client::get_browser_settings).
///
/// See [`crate::client::fluent_builders::GetBrowserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBrowserSettings {
    _private: (),
}
impl GetBrowserSettings {
    /// Creates a new builder-style object to manufacture [`GetBrowserSettingsInput`](crate::input::GetBrowserSettingsInput)
    pub fn builder() -> crate::input::get_browser_settings_input::Builder {
        crate::input::get_browser_settings_input::Builder::default()
    }
    /// Creates a new `GetBrowserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBrowserSettings {
    type Output = std::result::Result<
        crate::output::GetBrowserSettingsOutput,
        crate::error::GetBrowserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_browser_settings_error(response)
        } else {
            crate::operation_deser::parse_get_browser_settings_response(response)
        }
    }
}

/// Operation shape for `GetIdentityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_identity_provider`](crate::client::Client::get_identity_provider).
///
/// See [`crate::client::fluent_builders::GetIdentityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIdentityProvider {
    _private: (),
}
impl GetIdentityProvider {
    /// Creates a new builder-style object to manufacture [`GetIdentityProviderInput`](crate::input::GetIdentityProviderInput)
    pub fn builder() -> crate::input::get_identity_provider_input::Builder {
        crate::input::get_identity_provider_input::Builder::default()
    }
    /// Creates a new `GetIdentityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIdentityProvider {
    type Output = std::result::Result<
        crate::output::GetIdentityProviderOutput,
        crate::error::GetIdentityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_identity_provider_error(response)
        } else {
            crate::operation_deser::parse_get_identity_provider_response(response)
        }
    }
}

/// Operation shape for `GetNetworkSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_settings`](crate::client::Client::get_network_settings).
///
/// See [`crate::client::fluent_builders::GetNetworkSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkSettings {
    _private: (),
}
impl GetNetworkSettings {
    /// Creates a new builder-style object to manufacture [`GetNetworkSettingsInput`](crate::input::GetNetworkSettingsInput)
    pub fn builder() -> crate::input::get_network_settings_input::Builder {
        crate::input::get_network_settings_input::Builder::default()
    }
    /// Creates a new `GetNetworkSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetworkSettings {
    type Output = std::result::Result<
        crate::output::GetNetworkSettingsOutput,
        crate::error::GetNetworkSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_settings_error(response)
        } else {
            crate::operation_deser::parse_get_network_settings_response(response)
        }
    }
}

/// Operation shape for `GetPortal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_portal`](crate::client::Client::get_portal).
///
/// See [`crate::client::fluent_builders::GetPortal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPortal {
    _private: (),
}
impl GetPortal {
    /// Creates a new builder-style object to manufacture [`GetPortalInput`](crate::input::GetPortalInput)
    pub fn builder() -> crate::input::get_portal_input::Builder {
        crate::input::get_portal_input::Builder::default()
    }
    /// Creates a new `GetPortal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPortal {
    type Output = std::result::Result<crate::output::GetPortalOutput, crate::error::GetPortalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_portal_error(response)
        } else {
            crate::operation_deser::parse_get_portal_response(response)
        }
    }
}

/// Operation shape for `GetPortalServiceProviderMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_portal_service_provider_metadata`](crate::client::Client::get_portal_service_provider_metadata).
///
/// See [`crate::client::fluent_builders::GetPortalServiceProviderMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPortalServiceProviderMetadata {
    _private: (),
}
impl GetPortalServiceProviderMetadata {
    /// Creates a new builder-style object to manufacture [`GetPortalServiceProviderMetadataInput`](crate::input::GetPortalServiceProviderMetadataInput)
    pub fn builder() -> crate::input::get_portal_service_provider_metadata_input::Builder {
        crate::input::get_portal_service_provider_metadata_input::Builder::default()
    }
    /// Creates a new `GetPortalServiceProviderMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPortalServiceProviderMetadata {
    type Output = std::result::Result<
        crate::output::GetPortalServiceProviderMetadataOutput,
        crate::error::GetPortalServiceProviderMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_portal_service_provider_metadata_error(response)
        } else {
            crate::operation_deser::parse_get_portal_service_provider_metadata_response(response)
        }
    }
}

/// Operation shape for `GetTrustStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_trust_store`](crate::client::Client::get_trust_store).
///
/// See [`crate::client::fluent_builders::GetTrustStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTrustStore {
    _private: (),
}
impl GetTrustStore {
    /// Creates a new builder-style object to manufacture [`GetTrustStoreInput`](crate::input::GetTrustStoreInput)
    pub fn builder() -> crate::input::get_trust_store_input::Builder {
        crate::input::get_trust_store_input::Builder::default()
    }
    /// Creates a new `GetTrustStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTrustStore {
    type Output =
        std::result::Result<crate::output::GetTrustStoreOutput, crate::error::GetTrustStoreError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_trust_store_error(response)
        } else {
            crate::operation_deser::parse_get_trust_store_response(response)
        }
    }
}

/// Operation shape for `GetTrustStoreCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_trust_store_certificate`](crate::client::Client::get_trust_store_certificate).
///
/// See [`crate::client::fluent_builders::GetTrustStoreCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTrustStoreCertificate {
    _private: (),
}
impl GetTrustStoreCertificate {
    /// Creates a new builder-style object to manufacture [`GetTrustStoreCertificateInput`](crate::input::GetTrustStoreCertificateInput)
    pub fn builder() -> crate::input::get_trust_store_certificate_input::Builder {
        crate::input::get_trust_store_certificate_input::Builder::default()
    }
    /// Creates a new `GetTrustStoreCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTrustStoreCertificate {
    type Output = std::result::Result<
        crate::output::GetTrustStoreCertificateOutput,
        crate::error::GetTrustStoreCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_trust_store_certificate_error(response)
        } else {
            crate::operation_deser::parse_get_trust_store_certificate_response(response)
        }
    }
}

/// Operation shape for `GetUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_user_settings`](crate::client::Client::get_user_settings).
///
/// See [`crate::client::fluent_builders::GetUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUserSettings {
    _private: (),
}
impl GetUserSettings {
    /// Creates a new builder-style object to manufacture [`GetUserSettingsInput`](crate::input::GetUserSettingsInput)
    pub fn builder() -> crate::input::get_user_settings_input::Builder {
        crate::input::get_user_settings_input::Builder::default()
    }
    /// Creates a new `GetUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUserSettings {
    type Output = std::result::Result<
        crate::output::GetUserSettingsOutput,
        crate::error::GetUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_user_settings_error(response)
        } else {
            crate::operation_deser::parse_get_user_settings_response(response)
        }
    }
}

/// Operation shape for `ListBrowserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_browser_settings`](crate::client::Client::list_browser_settings).
///
/// See [`crate::client::fluent_builders::ListBrowserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBrowserSettings {
    _private: (),
}
impl ListBrowserSettings {
    /// Creates a new builder-style object to manufacture [`ListBrowserSettingsInput`](crate::input::ListBrowserSettingsInput)
    pub fn builder() -> crate::input::list_browser_settings_input::Builder {
        crate::input::list_browser_settings_input::Builder::default()
    }
    /// Creates a new `ListBrowserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBrowserSettings {
    type Output = std::result::Result<
        crate::output::ListBrowserSettingsOutput,
        crate::error::ListBrowserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_browser_settings_error(response)
        } else {
            crate::operation_deser::parse_list_browser_settings_response(response)
        }
    }
}

/// Operation shape for `ListIdentityProviders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_identity_providers`](crate::client::Client::list_identity_providers).
///
/// See [`crate::client::fluent_builders::ListIdentityProviders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIdentityProviders {
    _private: (),
}
impl ListIdentityProviders {
    /// Creates a new builder-style object to manufacture [`ListIdentityProvidersInput`](crate::input::ListIdentityProvidersInput)
    pub fn builder() -> crate::input::list_identity_providers_input::Builder {
        crate::input::list_identity_providers_input::Builder::default()
    }
    /// Creates a new `ListIdentityProviders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIdentityProviders {
    type Output = std::result::Result<
        crate::output::ListIdentityProvidersOutput,
        crate::error::ListIdentityProvidersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_identity_providers_error(response)
        } else {
            crate::operation_deser::parse_list_identity_providers_response(response)
        }
    }
}

/// Operation shape for `ListNetworkSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_network_settings`](crate::client::Client::list_network_settings).
///
/// See [`crate::client::fluent_builders::ListNetworkSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNetworkSettings {
    _private: (),
}
impl ListNetworkSettings {
    /// Creates a new builder-style object to manufacture [`ListNetworkSettingsInput`](crate::input::ListNetworkSettingsInput)
    pub fn builder() -> crate::input::list_network_settings_input::Builder {
        crate::input::list_network_settings_input::Builder::default()
    }
    /// Creates a new `ListNetworkSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNetworkSettings {
    type Output = std::result::Result<
        crate::output::ListNetworkSettingsOutput,
        crate::error::ListNetworkSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_network_settings_error(response)
        } else {
            crate::operation_deser::parse_list_network_settings_response(response)
        }
    }
}

/// Operation shape for `ListPortals`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_portals`](crate::client::Client::list_portals).
///
/// See [`crate::client::fluent_builders::ListPortals`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPortals {
    _private: (),
}
impl ListPortals {
    /// Creates a new builder-style object to manufacture [`ListPortalsInput`](crate::input::ListPortalsInput)
    pub fn builder() -> crate::input::list_portals_input::Builder {
        crate::input::list_portals_input::Builder::default()
    }
    /// Creates a new `ListPortals` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPortals {
    type Output =
        std::result::Result<crate::output::ListPortalsOutput, crate::error::ListPortalsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_portals_error(response)
        } else {
            crate::operation_deser::parse_list_portals_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTrustStoreCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_trust_store_certificates`](crate::client::Client::list_trust_store_certificates).
///
/// See [`crate::client::fluent_builders::ListTrustStoreCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrustStoreCertificates {
    _private: (),
}
impl ListTrustStoreCertificates {
    /// Creates a new builder-style object to manufacture [`ListTrustStoreCertificatesInput`](crate::input::ListTrustStoreCertificatesInput)
    pub fn builder() -> crate::input::list_trust_store_certificates_input::Builder {
        crate::input::list_trust_store_certificates_input::Builder::default()
    }
    /// Creates a new `ListTrustStoreCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrustStoreCertificates {
    type Output = std::result::Result<
        crate::output::ListTrustStoreCertificatesOutput,
        crate::error::ListTrustStoreCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_trust_store_certificates_error(response)
        } else {
            crate::operation_deser::parse_list_trust_store_certificates_response(response)
        }
    }
}

/// Operation shape for `ListTrustStores`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_trust_stores`](crate::client::Client::list_trust_stores).
///
/// See [`crate::client::fluent_builders::ListTrustStores`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrustStores {
    _private: (),
}
impl ListTrustStores {
    /// Creates a new builder-style object to manufacture [`ListTrustStoresInput`](crate::input::ListTrustStoresInput)
    pub fn builder() -> crate::input::list_trust_stores_input::Builder {
        crate::input::list_trust_stores_input::Builder::default()
    }
    /// Creates a new `ListTrustStores` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrustStores {
    type Output = std::result::Result<
        crate::output::ListTrustStoresOutput,
        crate::error::ListTrustStoresError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_trust_stores_error(response)
        } else {
            crate::operation_deser::parse_list_trust_stores_response(response)
        }
    }
}

/// Operation shape for `ListUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_user_settings`](crate::client::Client::list_user_settings).
///
/// See [`crate::client::fluent_builders::ListUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUserSettings {
    _private: (),
}
impl ListUserSettings {
    /// Creates a new builder-style object to manufacture [`ListUserSettingsInput`](crate::input::ListUserSettingsInput)
    pub fn builder() -> crate::input::list_user_settings_input::Builder {
        crate::input::list_user_settings_input::Builder::default()
    }
    /// Creates a new `ListUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUserSettings {
    type Output = std::result::Result<
        crate::output::ListUserSettingsOutput,
        crate::error::ListUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_user_settings_error(response)
        } else {
            crate::operation_deser::parse_list_user_settings_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateBrowserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_browser_settings`](crate::client::Client::update_browser_settings).
///
/// See [`crate::client::fluent_builders::UpdateBrowserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBrowserSettings {
    _private: (),
}
impl UpdateBrowserSettings {
    /// Creates a new builder-style object to manufacture [`UpdateBrowserSettingsInput`](crate::input::UpdateBrowserSettingsInput)
    pub fn builder() -> crate::input::update_browser_settings_input::Builder {
        crate::input::update_browser_settings_input::Builder::default()
    }
    /// Creates a new `UpdateBrowserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBrowserSettings {
    type Output = std::result::Result<
        crate::output::UpdateBrowserSettingsOutput,
        crate::error::UpdateBrowserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_browser_settings_error(response)
        } else {
            crate::operation_deser::parse_update_browser_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateIdentityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_identity_provider`](crate::client::Client::update_identity_provider).
///
/// See [`crate::client::fluent_builders::UpdateIdentityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIdentityProvider {
    _private: (),
}
impl UpdateIdentityProvider {
    /// Creates a new builder-style object to manufacture [`UpdateIdentityProviderInput`](crate::input::UpdateIdentityProviderInput)
    pub fn builder() -> crate::input::update_identity_provider_input::Builder {
        crate::input::update_identity_provider_input::Builder::default()
    }
    /// Creates a new `UpdateIdentityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIdentityProvider {
    type Output = std::result::Result<
        crate::output::UpdateIdentityProviderOutput,
        crate::error::UpdateIdentityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_identity_provider_error(response)
        } else {
            crate::operation_deser::parse_update_identity_provider_response(response)
        }
    }
}

/// Operation shape for `UpdateNetworkSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_network_settings`](crate::client::Client::update_network_settings).
///
/// See [`crate::client::fluent_builders::UpdateNetworkSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNetworkSettings {
    _private: (),
}
impl UpdateNetworkSettings {
    /// Creates a new builder-style object to manufacture [`UpdateNetworkSettingsInput`](crate::input::UpdateNetworkSettingsInput)
    pub fn builder() -> crate::input::update_network_settings_input::Builder {
        crate::input::update_network_settings_input::Builder::default()
    }
    /// Creates a new `UpdateNetworkSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNetworkSettings {
    type Output = std::result::Result<
        crate::output::UpdateNetworkSettingsOutput,
        crate::error::UpdateNetworkSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_network_settings_error(response)
        } else {
            crate::operation_deser::parse_update_network_settings_response(response)
        }
    }
}

/// Operation shape for `UpdatePortal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_portal`](crate::client::Client::update_portal).
///
/// See [`crate::client::fluent_builders::UpdatePortal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePortal {
    _private: (),
}
impl UpdatePortal {
    /// Creates a new builder-style object to manufacture [`UpdatePortalInput`](crate::input::UpdatePortalInput)
    pub fn builder() -> crate::input::update_portal_input::Builder {
        crate::input::update_portal_input::Builder::default()
    }
    /// Creates a new `UpdatePortal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePortal {
    type Output =
        std::result::Result<crate::output::UpdatePortalOutput, crate::error::UpdatePortalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_portal_error(response)
        } else {
            crate::operation_deser::parse_update_portal_response(response)
        }
    }
}

/// Operation shape for `UpdateTrustStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_trust_store`](crate::client::Client::update_trust_store).
///
/// See [`crate::client::fluent_builders::UpdateTrustStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTrustStore {
    _private: (),
}
impl UpdateTrustStore {
    /// Creates a new builder-style object to manufacture [`UpdateTrustStoreInput`](crate::input::UpdateTrustStoreInput)
    pub fn builder() -> crate::input::update_trust_store_input::Builder {
        crate::input::update_trust_store_input::Builder::default()
    }
    /// Creates a new `UpdateTrustStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTrustStore {
    type Output = std::result::Result<
        crate::output::UpdateTrustStoreOutput,
        crate::error::UpdateTrustStoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_trust_store_error(response)
        } else {
            crate::operation_deser::parse_update_trust_store_response(response)
        }
    }
}

/// Operation shape for `UpdateUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_settings`](crate::client::Client::update_user_settings).
///
/// See [`crate::client::fluent_builders::UpdateUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserSettings {
    _private: (),
}
impl UpdateUserSettings {
    /// Creates a new builder-style object to manufacture [`UpdateUserSettingsInput`](crate::input::UpdateUserSettingsInput)
    pub fn builder() -> crate::input::update_user_settings_input::Builder {
        crate::input::update_user_settings_input::Builder::default()
    }
    /// Creates a new `UpdateUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserSettings {
    type Output = std::result::Result<
        crate::output::UpdateUserSettingsOutput,
        crate::error::UpdateUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_settings_error(response)
        } else {
            crate::operation_deser::parse_update_user_settings_response(response)
        }
    }
}
