// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_browser_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateBrowserSettingsOutput,
    crate::error::AssociateBrowserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateBrowserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateBrowserSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AssociateBrowserSettingsError {
            meta: generic,
            kind: crate::error::AssociateBrowserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::AssociateBrowserSettingsError {
                meta: generic,
                kind: crate::error::AssociateBrowserSettingsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateBrowserSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::AssociateBrowserSettingsError {
            meta: generic,
            kind: crate::error::AssociateBrowserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_browser_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociateBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateBrowserSettingsError {
            meta: generic,
            kind: crate::error::AssociateBrowserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::AssociateBrowserSettingsError {
            meta: generic,
            kind: crate::error::AssociateBrowserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_browser_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociateBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::AssociateBrowserSettingsError {
            meta: generic,
            kind: crate::error::AssociateBrowserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateBrowserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_browser_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateBrowserSettingsOutput,
    crate::error::AssociateBrowserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_browser_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_browser_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateBrowserSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_network_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateNetworkSettingsOutput,
    crate::error::AssociateNetworkSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateNetworkSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateNetworkSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AssociateNetworkSettingsError {
            meta: generic,
            kind: crate::error::AssociateNetworkSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::AssociateNetworkSettingsError {
                meta: generic,
                kind: crate::error::AssociateNetworkSettingsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateNetworkSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::AssociateNetworkSettingsError {
            meta: generic,
            kind: crate::error::AssociateNetworkSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_network_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociateNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateNetworkSettingsError {
            meta: generic,
            kind: crate::error::AssociateNetworkSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::AssociateNetworkSettingsError {
            meta: generic,
            kind: crate::error::AssociateNetworkSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_network_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociateNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::AssociateNetworkSettingsError {
            meta: generic,
            kind: crate::error::AssociateNetworkSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateNetworkSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_network_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateNetworkSettingsOutput,
    crate::error::AssociateNetworkSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_network_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_network_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateNetworkSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_trust_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateTrustStoreOutput,
    crate::error::AssociateTrustStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateTrustStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateTrustStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AssociateTrustStoreError {
            meta: generic,
            kind: crate::error::AssociateTrustStoreErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::AssociateTrustStoreError {
            meta: generic,
            kind: crate::error::AssociateTrustStoreErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_trust_store_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociateTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateTrustStoreError {
            meta: generic,
            kind: crate::error::AssociateTrustStoreErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::AssociateTrustStoreError {
            meta: generic,
            kind: crate::error::AssociateTrustStoreErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_trust_store_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociateTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::AssociateTrustStoreError {
            meta: generic,
            kind: crate::error::AssociateTrustStoreErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateTrustStoreError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_trust_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateTrustStoreOutput,
    crate::error::AssociateTrustStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_trust_store_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_trust_store(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateTrustStoreError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_user_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateUserSettingsOutput,
    crate::error::AssociateUserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateUserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateUserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AssociateUserSettingsError {
            meta: generic,
            kind: crate::error::AssociateUserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::AssociateUserSettingsError {
                meta: generic,
                kind: crate::error::AssociateUserSettingsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateUserSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::AssociateUserSettingsError {
            meta: generic,
            kind: crate::error::AssociateUserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_user_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociateUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateUserSettingsError {
            meta: generic,
            kind: crate::error::AssociateUserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::AssociateUserSettingsError {
            meta: generic,
            kind: crate::error::AssociateUserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_user_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociateUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::AssociateUserSettingsError {
            meta: generic,
            kind: crate::error::AssociateUserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateUserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_user_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateUserSettingsOutput,
    crate::error::AssociateUserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_user_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_user_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateUserSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_browser_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBrowserSettingsOutput,
    crate::error::CreateBrowserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBrowserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBrowserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateBrowserSettingsError {
            meta: generic,
            kind: crate::error::CreateBrowserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateBrowserSettingsError {
                meta: generic,
                kind: crate::error::CreateBrowserSettingsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBrowserSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CreateBrowserSettingsError {
            meta: generic,
            kind: crate::error::CreateBrowserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_browser_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateBrowserSettingsError {
            meta: generic,
            kind: crate::error::CreateBrowserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::CreateBrowserSettingsError {
            meta: generic,
            kind: crate::error::CreateBrowserSettingsErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreateBrowserSettingsError {
            meta: generic,
            kind: crate::error::CreateBrowserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_browser_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateBrowserSettingsError {
            meta: generic,
            kind: crate::error::CreateBrowserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBrowserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_browser_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBrowserSettingsOutput,
    crate::error::CreateBrowserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_browser_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_browser_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateBrowserSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_identity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateIdentityProviderOutput,
    crate::error::CreateIdentityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateIdentityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateIdentityProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateIdentityProviderError {
                meta: generic,
                kind: crate::error::CreateIdentityProviderErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_identity_provider_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateIdentityProviderError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_identity_provider_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateIdentityProviderError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateIdentityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_identity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateIdentityProviderOutput,
    crate::error::CreateIdentityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_identity_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_identity_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateIdentityProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_network_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNetworkSettingsOutput,
    crate::error::CreateNetworkSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateNetworkSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateNetworkSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateNetworkSettingsError {
            meta: generic,
            kind: crate::error::CreateNetworkSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateNetworkSettingsError {
                meta: generic,
                kind: crate::error::CreateNetworkSettingsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CreateNetworkSettingsError {
            meta: generic,
            kind: crate::error::CreateNetworkSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_network_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::CreateNetworkSettingsError {
            meta: generic,
            kind: crate::error::CreateNetworkSettingsErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreateNetworkSettingsError {
            meta: generic,
            kind: crate::error::CreateNetworkSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_network_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateNetworkSettingsError {
            meta: generic,
            kind: crate::error::CreateNetworkSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateNetworkSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_network_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNetworkSettingsOutput,
    crate::error::CreateNetworkSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_network_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_network_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateNetworkSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_portal_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePortalOutput, crate::error::CreatePortalError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePortalError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePortalError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreatePortalError {
            meta: generic,
            kind: crate::error::CreatePortalErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreatePortalError {
                meta: generic,
                kind: crate::error::CreatePortalErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortalError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CreatePortalError {
            meta: generic,
            kind: crate::error::CreatePortalErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortalError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_portal_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreatePortalError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreatePortalError {
            meta: generic,
            kind: crate::error::CreatePortalErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::CreatePortalError {
            meta: generic,
            kind: crate::error::CreatePortalErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreatePortalError {
            meta: generic,
            kind: crate::error::CreatePortalErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortalError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_portal_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreatePortalError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreatePortalError {
            meta: generic,
            kind: crate::error::CreatePortalErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePortalError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_portal_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePortalOutput, crate::error::CreatePortalError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_portal_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_portal(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePortalError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_trust_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTrustStoreOutput, crate::error::CreateTrustStoreError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTrustStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTrustStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateTrustStoreError {
            meta: generic,
            kind: crate::error::CreateTrustStoreErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateTrustStoreError {
                meta: generic,
                kind: crate::error::CreateTrustStoreErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustStoreError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CreateTrustStoreError {
            meta: generic,
            kind: crate::error::CreateTrustStoreErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_trust_store_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::CreateTrustStoreError {
            meta: generic,
            kind: crate::error::CreateTrustStoreErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreateTrustStoreError {
            meta: generic,
            kind: crate::error::CreateTrustStoreErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_trust_store_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateTrustStoreError {
            meta: generic,
            kind: crate::error::CreateTrustStoreErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTrustStoreError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_trust_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTrustStoreOutput, crate::error::CreateTrustStoreError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_trust_store_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_trust_store(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTrustStoreError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateUserSettingsOutput,
    crate::error::CreateUserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateUserSettingsError {
            meta: generic,
            kind: crate::error::CreateUserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateUserSettingsError {
                meta: generic,
                kind: crate::error::CreateUserSettingsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CreateUserSettingsError {
            meta: generic,
            kind: crate::error::CreateUserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_user_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::CreateUserSettingsError {
            meta: generic,
            kind: crate::error::CreateUserSettingsErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreateUserSettingsError {
            meta: generic,
            kind: crate::error::CreateUserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_user_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateUserSettingsError {
            meta: generic,
            kind: crate::error::CreateUserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateUserSettingsOutput,
    crate::error::CreateUserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_user_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_browser_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBrowserSettingsOutput,
    crate::error::DeleteBrowserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBrowserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteBrowserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteBrowserSettingsError {
            meta: generic,
            kind: crate::error::DeleteBrowserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeleteBrowserSettingsError {
                meta: generic,
                kind: crate::error::DeleteBrowserSettingsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBrowserSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DeleteBrowserSettingsError {
            meta: generic,
            kind: crate::error::DeleteBrowserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_browser_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeleteBrowserSettingsError {
            meta: generic,
            kind: crate::error::DeleteBrowserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_browser_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteBrowserSettingsError {
            meta: generic,
            kind: crate::error::DeleteBrowserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteBrowserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_browser_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBrowserSettingsOutput,
    crate::error::DeleteBrowserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_browser_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_identity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteIdentityProviderOutput,
    crate::error::DeleteIdentityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteIdentityProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteIdentityProviderError {
            meta: generic,
            kind: crate::error::DeleteIdentityProviderErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeleteIdentityProviderError {
                meta: generic,
                kind: crate::error::DeleteIdentityProviderErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DeleteIdentityProviderError {
            meta: generic,
            kind: crate::error::DeleteIdentityProviderErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_identity_provider_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteIdentityProviderError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeleteIdentityProviderError {
            meta: generic,
            kind: crate::error::DeleteIdentityProviderErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_identity_provider_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteIdentityProviderError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteIdentityProviderError {
            meta: generic,
            kind: crate::error::DeleteIdentityProviderErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteIdentityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_identity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteIdentityProviderOutput,
    crate::error::DeleteIdentityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_identity_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_network_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNetworkSettingsOutput,
    crate::error::DeleteNetworkSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteNetworkSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteNetworkSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteNetworkSettingsError {
            meta: generic,
            kind: crate::error::DeleteNetworkSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeleteNetworkSettingsError {
                meta: generic,
                kind: crate::error::DeleteNetworkSettingsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNetworkSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DeleteNetworkSettingsError {
            meta: generic,
            kind: crate::error::DeleteNetworkSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_network_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeleteNetworkSettingsError {
            meta: generic,
            kind: crate::error::DeleteNetworkSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_network_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteNetworkSettingsError {
            meta: generic,
            kind: crate::error::DeleteNetworkSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteNetworkSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_network_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNetworkSettingsOutput,
    crate::error::DeleteNetworkSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_network_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_portal_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePortalOutput, crate::error::DeletePortalError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePortalError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePortalError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeletePortalError {
            meta: generic,
            kind: crate::error::DeletePortalErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeletePortalError {
                meta: generic,
                kind: crate::error::DeletePortalErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortalError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DeletePortalError {
            meta: generic,
            kind: crate::error::DeletePortalErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortalError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_portal_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeletePortalError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeletePortalError {
            meta: generic,
            kind: crate::error::DeletePortalErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortalError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_portal_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeletePortalError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeletePortalError {
            meta: generic,
            kind: crate::error::DeletePortalErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePortalError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_portal_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePortalOutput, crate::error::DeletePortalError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_portal_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_trust_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTrustStoreOutput, crate::error::DeleteTrustStoreError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTrustStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTrustStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteTrustStoreError {
            meta: generic,
            kind: crate::error::DeleteTrustStoreErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeleteTrustStoreError {
                meta: generic,
                kind: crate::error::DeleteTrustStoreErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrustStoreError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DeleteTrustStoreError {
            meta: generic,
            kind: crate::error::DeleteTrustStoreErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_trust_store_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeleteTrustStoreError {
            meta: generic,
            kind: crate::error::DeleteTrustStoreErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_trust_store_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteTrustStoreError {
            meta: generic,
            kind: crate::error::DeleteTrustStoreErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTrustStoreError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_trust_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTrustStoreOutput, crate::error::DeleteTrustStoreError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_trust_store_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteUserSettingsOutput,
    crate::error::DeleteUserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteUserSettingsError {
            meta: generic,
            kind: crate::error::DeleteUserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeleteUserSettingsError {
                meta: generic,
                kind: crate::error::DeleteUserSettingsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DeleteUserSettingsError {
            meta: generic,
            kind: crate::error::DeleteUserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_user_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeleteUserSettingsError {
            meta: generic,
            kind: crate::error::DeleteUserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_user_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteUserSettingsError {
            meta: generic,
            kind: crate::error::DeleteUserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteUserSettingsOutput,
    crate::error::DeleteUserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_browser_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateBrowserSettingsOutput,
    crate::error::DisassociateBrowserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateBrowserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateBrowserSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisassociateBrowserSettingsError {
            meta: generic,
            kind: crate::error::DisassociateBrowserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::DisassociateBrowserSettingsError {
            meta: generic,
            kind: crate::error::DisassociateBrowserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_browser_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociateBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DisassociateBrowserSettingsError {
            meta: generic,
            kind: crate::error::DisassociateBrowserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DisassociateBrowserSettingsError {
            meta: generic,
            kind: crate::error::DisassociateBrowserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_browser_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociateBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DisassociateBrowserSettingsError {
            meta: generic,
            kind: crate::error::DisassociateBrowserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateBrowserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_browser_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateBrowserSettingsOutput,
    crate::error::DisassociateBrowserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_browser_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_network_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateNetworkSettingsOutput,
    crate::error::DisassociateNetworkSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateNetworkSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateNetworkSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisassociateNetworkSettingsError {
            meta: generic,
            kind: crate::error::DisassociateNetworkSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::DisassociateNetworkSettingsError {
            meta: generic,
            kind: crate::error::DisassociateNetworkSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_network_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociateNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DisassociateNetworkSettingsError {
            meta: generic,
            kind: crate::error::DisassociateNetworkSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DisassociateNetworkSettingsError {
            meta: generic,
            kind: crate::error::DisassociateNetworkSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_network_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociateNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DisassociateNetworkSettingsError {
            meta: generic,
            kind: crate::error::DisassociateNetworkSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateNetworkSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_network_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateNetworkSettingsOutput,
    crate::error::DisassociateNetworkSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_network_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_trust_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateTrustStoreOutput,
    crate::error::DisassociateTrustStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateTrustStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateTrustStoreError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisassociateTrustStoreError {
            meta: generic,
            kind: crate::error::DisassociateTrustStoreErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::DisassociateTrustStoreError {
            meta: generic,
            kind: crate::error::DisassociateTrustStoreErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_trust_store_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociateTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DisassociateTrustStoreError {
            meta: generic,
            kind: crate::error::DisassociateTrustStoreErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DisassociateTrustStoreError {
            meta: generic,
            kind: crate::error::DisassociateTrustStoreErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_trust_store_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociateTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DisassociateTrustStoreError {
            meta: generic,
            kind: crate::error::DisassociateTrustStoreErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateTrustStoreError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_trust_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateTrustStoreOutput,
    crate::error::DisassociateTrustStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_trust_store_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_user_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateUserSettingsOutput,
    crate::error::DisassociateUserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateUserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateUserSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisassociateUserSettingsError {
            meta: generic,
            kind: crate::error::DisassociateUserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::DisassociateUserSettingsError {
            meta: generic,
            kind: crate::error::DisassociateUserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_user_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociateUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DisassociateUserSettingsError {
            meta: generic,
            kind: crate::error::DisassociateUserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DisassociateUserSettingsError {
            meta: generic,
            kind: crate::error::DisassociateUserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_user_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociateUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DisassociateUserSettingsError {
            meta: generic,
            kind: crate::error::DisassociateUserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateUserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_user_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateUserSettingsOutput,
    crate::error::DisassociateUserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_user_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_browser_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBrowserSettingsOutput,
    crate::error::GetBrowserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBrowserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetBrowserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetBrowserSettingsError {
            meta: generic,
            kind: crate::error::GetBrowserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetBrowserSettingsError {
            meta: generic,
            kind: crate::error::GetBrowserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_browser_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetBrowserSettingsError {
            meta: generic,
            kind: crate::error::GetBrowserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::GetBrowserSettingsError {
            meta: generic,
            kind: crate::error::GetBrowserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_browser_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetBrowserSettingsError {
            meta: generic,
            kind: crate::error::GetBrowserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetBrowserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_browser_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBrowserSettingsOutput,
    crate::error::GetBrowserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_browser_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_browser_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBrowserSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityProviderOutput,
    crate::error::GetIdentityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIdentityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetIdentityProviderError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetIdentityProviderError {
            meta: generic,
            kind: crate::error::GetIdentityProviderErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetIdentityProviderError {
            meta: generic,
            kind: crate::error::GetIdentityProviderErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIdentityProviderError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_identity_provider_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetIdentityProviderError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetIdentityProviderError {
            meta: generic,
            kind: crate::error::GetIdentityProviderErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::GetIdentityProviderError {
            meta: generic,
            kind: crate::error::GetIdentityProviderErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIdentityProviderError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_identity_provider_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetIdentityProviderError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetIdentityProviderError {
            meta: generic,
            kind: crate::error::GetIdentityProviderErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetIdentityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityProviderOutput,
    crate::error::GetIdentityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_identity_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_identity_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetIdentityProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_network_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetNetworkSettingsOutput,
    crate::error::GetNetworkSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetNetworkSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetNetworkSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetNetworkSettingsError {
            meta: generic,
            kind: crate::error::GetNetworkSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetNetworkSettingsError {
            meta: generic,
            kind: crate::error::GetNetworkSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_network_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetNetworkSettingsError {
            meta: generic,
            kind: crate::error::GetNetworkSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::GetNetworkSettingsError {
            meta: generic,
            kind: crate::error::GetNetworkSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_network_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetNetworkSettingsError {
            meta: generic,
            kind: crate::error::GetNetworkSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetNetworkSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_network_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetNetworkSettingsOutput,
    crate::error::GetNetworkSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_network_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_network_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetNetworkSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_portal_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPortalOutput, crate::error::GetPortalError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPortalError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPortalError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetPortalError {
            meta: generic,
            kind: crate::error::GetPortalErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetPortalError {
            meta: generic,
            kind: crate::error::GetPortalErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPortalError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_portal_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetPortalError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetPortalError {
            meta: generic,
            kind: crate::error::GetPortalErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::GetPortalError {
            meta: generic,
            kind: crate::error::GetPortalErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPortalError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_portal_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetPortalError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetPortalError {
            meta: generic,
            kind: crate::error::GetPortalErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPortalError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_portal_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPortalOutput, crate::error::GetPortalError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_portal_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_portal(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPortalError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_portal_service_provider_metadata_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPortalServiceProviderMetadataOutput,
    crate::error::GetPortalServiceProviderMetadataError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPortalServiceProviderMetadataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetPortalServiceProviderMetadataError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetPortalServiceProviderMetadataError {
            meta: generic,
            kind: crate::error::GetPortalServiceProviderMetadataErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPortalServiceProviderMetadataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetPortalServiceProviderMetadataError {
            meta: generic,
            kind: crate::error::GetPortalServiceProviderMetadataErrorKind::InternalServerException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPortalServiceProviderMetadataError::unhandled)?;
                        output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_portal_service_provider_metadata_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetPortalServiceProviderMetadataError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::GetPortalServiceProviderMetadataError {
            meta: generic,
            kind:
                crate::error::GetPortalServiceProviderMetadataErrorKind::ResourceNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPortalServiceProviderMetadataError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ThrottlingException" => crate::error::GetPortalServiceProviderMetadataError {
            meta: generic,
            kind: crate::error::GetPortalServiceProviderMetadataErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPortalServiceProviderMetadataError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_portal_service_provider_metadata_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetPortalServiceProviderMetadataError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetPortalServiceProviderMetadataError {
            meta: generic,
            kind: crate::error::GetPortalServiceProviderMetadataErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPortalServiceProviderMetadataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPortalServiceProviderMetadataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_portal_service_provider_metadata_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPortalServiceProviderMetadataOutput,
    crate::error::GetPortalServiceProviderMetadataError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_portal_service_provider_metadata_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_portal_service_provider_metadata(response.body().as_ref(), output).map_err(crate::error::GetPortalServiceProviderMetadataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_trust_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTrustStoreOutput, crate::error::GetTrustStoreError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTrustStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetTrustStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetTrustStoreError {
            meta: generic,
            kind: crate::error::GetTrustStoreErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetTrustStoreError {
            meta: generic,
            kind: crate::error::GetTrustStoreErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_trust_store_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetTrustStoreError {
            meta: generic,
            kind: crate::error::GetTrustStoreErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::GetTrustStoreError {
            meta: generic,
            kind: crate::error::GetTrustStoreErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_trust_store_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetTrustStoreError {
            meta: generic,
            kind: crate::error::GetTrustStoreErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetTrustStoreError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_trust_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTrustStoreOutput, crate::error::GetTrustStoreError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_trust_store_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_trust_store(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTrustStoreError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_trust_store_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetTrustStoreCertificateOutput,
    crate::error::GetTrustStoreCertificateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTrustStoreCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetTrustStoreCertificateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetTrustStoreCertificateError {
            meta: generic,
            kind: crate::error::GetTrustStoreCertificateErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrustStoreCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetTrustStoreCertificateError {
            meta: generic,
            kind: crate::error::GetTrustStoreCertificateErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrustStoreCertificateError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_trust_store_certificate_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetTrustStoreCertificateError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetTrustStoreCertificateError {
            meta: generic,
            kind: crate::error::GetTrustStoreCertificateErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrustStoreCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::GetTrustStoreCertificateError {
            meta: generic,
            kind: crate::error::GetTrustStoreCertificateErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrustStoreCertificateError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_trust_store_certificate_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetTrustStoreCertificateError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetTrustStoreCertificateError {
            meta: generic,
            kind: crate::error::GetTrustStoreCertificateErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrustStoreCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetTrustStoreCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_trust_store_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetTrustStoreCertificateOutput,
    crate::error::GetTrustStoreCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_trust_store_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_trust_store_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTrustStoreCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUserSettingsOutput, crate::error::GetUserSettingsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetUserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetUserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetUserSettingsError {
            meta: generic,
            kind: crate::error::GetUserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetUserSettingsError {
            meta: generic,
            kind: crate::error::GetUserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_user_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetUserSettingsError {
            meta: generic,
            kind: crate::error::GetUserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::GetUserSettingsError {
            meta: generic,
            kind: crate::error::GetUserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_user_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetUserSettingsError {
            meta: generic,
            kind: crate::error::GetUserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetUserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUserSettingsOutput, crate::error::GetUserSettingsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_user_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_user_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetUserSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_browser_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBrowserSettingsOutput,
    crate::error::ListBrowserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBrowserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListBrowserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListBrowserSettingsError {
            meta: generic,
            kind: crate::error::ListBrowserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListBrowserSettingsError {
            meta: generic,
            kind: crate::error::ListBrowserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_browser_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListBrowserSettingsError {
            meta: generic,
            kind: crate::error::ListBrowserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_browser_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListBrowserSettingsError {
            meta: generic,
            kind: crate::error::ListBrowserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListBrowserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_browser_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBrowserSettingsOutput,
    crate::error::ListBrowserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_browser_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_browser_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListBrowserSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_identity_providers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListIdentityProvidersOutput,
    crate::error::ListIdentityProvidersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListIdentityProvidersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListIdentityProvidersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListIdentityProvidersError {
            meta: generic,
            kind: crate::error::ListIdentityProvidersErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIdentityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListIdentityProvidersError {
            meta: generic,
            kind: crate::error::ListIdentityProvidersErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIdentityProvidersError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_identity_providers_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListIdentityProvidersError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListIdentityProvidersError {
            meta: generic,
            kind: crate::error::ListIdentityProvidersErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIdentityProvidersError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_identity_providers_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListIdentityProvidersError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListIdentityProvidersError {
            meta: generic,
            kind: crate::error::ListIdentityProvidersErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIdentityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListIdentityProvidersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_identity_providers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListIdentityProvidersOutput,
    crate::error::ListIdentityProvidersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_identity_providers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_identity_providers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListIdentityProvidersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_network_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListNetworkSettingsOutput,
    crate::error::ListNetworkSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListNetworkSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListNetworkSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListNetworkSettingsError {
            meta: generic,
            kind: crate::error::ListNetworkSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListNetworkSettingsError {
            meta: generic,
            kind: crate::error::ListNetworkSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_network_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListNetworkSettingsError {
            meta: generic,
            kind: crate::error::ListNetworkSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_network_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListNetworkSettingsError {
            meta: generic,
            kind: crate::error::ListNetworkSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListNetworkSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_network_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListNetworkSettingsOutput,
    crate::error::ListNetworkSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_network_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_network_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListNetworkSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_portals_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPortalsOutput, crate::error::ListPortalsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPortalsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPortalsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListPortalsError {
            meta: generic,
            kind: crate::error::ListPortalsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPortalsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListPortalsError {
            meta: generic,
            kind: crate::error::ListPortalsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPortalsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_portals_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListPortalsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListPortalsError {
            meta: generic,
            kind: crate::error::ListPortalsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPortalsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_portals_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListPortalsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListPortalsError {
            meta: generic,
            kind: crate::error::ListPortalsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPortalsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPortalsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_portals_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPortalsOutput, crate::error::ListPortalsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_portals_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_portals(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPortalsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_tags_for_resource_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListTagsForResourceError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_tags_for_resource_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListTagsForResourceError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_trust_store_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTrustStoreCertificatesOutput,
    crate::error::ListTrustStoreCertificatesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTrustStoreCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListTrustStoreCertificatesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListTrustStoreCertificatesError {
            meta: generic,
            kind: crate::error::ListTrustStoreCertificatesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrustStoreCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListTrustStoreCertificatesError {
            meta: generic,
            kind: crate::error::ListTrustStoreCertificatesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrustStoreCertificatesError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_trust_store_certificates_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListTrustStoreCertificatesError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTrustStoreCertificatesError {
            meta: generic,
            kind: crate::error::ListTrustStoreCertificatesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrustStoreCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListTrustStoreCertificatesError {
            meta: generic,
            kind: crate::error::ListTrustStoreCertificatesErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrustStoreCertificatesError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_trust_store_certificates_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListTrustStoreCertificatesError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListTrustStoreCertificatesError {
            meta: generic,
            kind: crate::error::ListTrustStoreCertificatesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrustStoreCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTrustStoreCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_trust_store_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTrustStoreCertificatesOutput,
    crate::error::ListTrustStoreCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_trust_store_certificates_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_trust_store_certificates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTrustStoreCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_trust_stores_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTrustStoresOutput, crate::error::ListTrustStoresError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTrustStoresError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTrustStoresError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListTrustStoresError {
            meta: generic,
            kind: crate::error::ListTrustStoresErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrustStoresError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListTrustStoresError {
            meta: generic,
            kind: crate::error::ListTrustStoresErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrustStoresError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_trust_stores_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListTrustStoresError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListTrustStoresError {
            meta: generic,
            kind: crate::error::ListTrustStoresErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrustStoresError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_trust_stores_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListTrustStoresError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListTrustStoresError {
            meta: generic,
            kind: crate::error::ListTrustStoresErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrustStoresError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTrustStoresError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_trust_stores_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTrustStoresOutput, crate::error::ListTrustStoresError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_trust_stores_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_trust_stores(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTrustStoresError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserSettingsOutput, crate::error::ListUserSettingsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListUserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListUserSettingsError {
            meta: generic,
            kind: crate::error::ListUserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListUserSettingsError {
            meta: generic,
            kind: crate::error::ListUserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_user_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListUserSettingsError {
            meta: generic,
            kind: crate::error::ListUserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_user_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListUserSettingsError {
            meta: generic,
            kind: crate::error::ListUserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListUserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserSettingsOutput, crate::error::ListUserSettingsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_user_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_user_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUserSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_tag_resource_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::TagResourceError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_tag_resource_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::TagResourceError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_untag_resource_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UntagResourceError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_untag_resource_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UntagResourceError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_browser_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBrowserSettingsOutput,
    crate::error::UpdateBrowserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateBrowserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateBrowserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateBrowserSettingsError {
            meta: generic,
            kind: crate::error::UpdateBrowserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::UpdateBrowserSettingsError {
            meta: generic,
            kind: crate::error::UpdateBrowserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_browser_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateBrowserSettingsError {
            meta: generic,
            kind: crate::error::UpdateBrowserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UpdateBrowserSettingsError {
            meta: generic,
            kind: crate::error::UpdateBrowserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBrowserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_browser_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateBrowserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateBrowserSettingsError {
            meta: generic,
            kind: crate::error::UpdateBrowserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBrowserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateBrowserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_browser_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBrowserSettingsOutput,
    crate::error::UpdateBrowserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_browser_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_browser_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateBrowserSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_identity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateIdentityProviderOutput,
    crate::error::UpdateIdentityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateIdentityProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind: crate::error::UpdateIdentityProviderErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind: crate::error::UpdateIdentityProviderErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_identity_provider_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateIdentityProviderError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind: crate::error::UpdateIdentityProviderErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind: crate::error::UpdateIdentityProviderErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_identity_provider_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateIdentityProviderError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind: crate::error::UpdateIdentityProviderErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateIdentityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_identity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateIdentityProviderOutput,
    crate::error::UpdateIdentityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_identity_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_identity_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_network_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNetworkSettingsOutput,
    crate::error::UpdateNetworkSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateNetworkSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateNetworkSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateNetworkSettingsError {
            meta: generic,
            kind: crate::error::UpdateNetworkSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::UpdateNetworkSettingsError {
            meta: generic,
            kind: crate::error::UpdateNetworkSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_network_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateNetworkSettingsError {
            meta: generic,
            kind: crate::error::UpdateNetworkSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UpdateNetworkSettingsError {
            meta: generic,
            kind: crate::error::UpdateNetworkSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNetworkSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_network_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateNetworkSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateNetworkSettingsError {
            meta: generic,
            kind: crate::error::UpdateNetworkSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNetworkSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateNetworkSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_network_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNetworkSettingsOutput,
    crate::error::UpdateNetworkSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_network_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_network_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateNetworkSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_portal_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePortalOutput, crate::error::UpdatePortalError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePortalError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePortalError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdatePortalError {
            meta: generic,
            kind: crate::error::UpdatePortalErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::UpdatePortalError {
            meta: generic,
            kind: crate::error::UpdatePortalErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortalError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_portal_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdatePortalError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdatePortalError {
            meta: generic,
            kind: crate::error::UpdatePortalErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UpdatePortalError {
            meta: generic,
            kind: crate::error::UpdatePortalErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortalError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_portal_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdatePortalError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdatePortalError {
            meta: generic,
            kind: crate::error::UpdatePortalErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortalError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdatePortalError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_portal_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePortalOutput, crate::error::UpdatePortalError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_portal_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_portal(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePortalError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_trust_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTrustStoreOutput, crate::error::UpdateTrustStoreError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTrustStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTrustStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateTrustStoreError {
            meta: generic,
            kind: crate::error::UpdateTrustStoreErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::UpdateTrustStoreError {
            meta: generic,
            kind: crate::error::UpdateTrustStoreErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_trust_store_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateTrustStoreError {
            meta: generic,
            kind: crate::error::UpdateTrustStoreErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::UpdateTrustStoreError {
            meta: generic,
            kind: crate::error::UpdateTrustStoreErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UpdateTrustStoreError {
            meta: generic,
            kind: crate::error::UpdateTrustStoreErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrustStoreError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_trust_store_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateTrustStoreError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateTrustStoreError {
            meta: generic,
            kind: crate::error::UpdateTrustStoreErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrustStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateTrustStoreError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_trust_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTrustStoreOutput, crate::error::UpdateTrustStoreError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_trust_store_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_trust_store(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTrustStoreError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateUserSettingsOutput,
    crate::error::UpdateUserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateUserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateUserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateUserSettingsError {
            meta: generic,
            kind: crate::error::UpdateUserSettingsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::UpdateUserSettingsError {
            meta: generic,
            kind: crate::error::UpdateUserSettingsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_user_settings_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateUserSettingsError {
            meta: generic,
            kind: crate::error::UpdateUserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UpdateUserSettingsError {
            meta: generic,
            kind: crate::error::UpdateUserSettingsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_user_settings_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateUserSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateUserSettingsError {
            meta: generic,
            kind: crate::error::UpdateUserSettingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateUserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateUserSettingsOutput,
    crate::error::UpdateUserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_user_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_user_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateUserSettingsError::unhandled)?;
        output.build()
    })
}
