// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateBrowserSettingsError {
    /// Kind of error that occurred.
    pub kind: AssociateBrowserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateBrowserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateBrowserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateBrowserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateBrowserSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateBrowserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateBrowserSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateBrowserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateBrowserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateBrowserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateBrowserSettingsError {
    fn code(&self) -> Option<&str> {
        AssociateBrowserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateBrowserSettingsError {
    /// Creates a new `AssociateBrowserSettingsError`.
    pub fn new(kind: AssociateBrowserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateBrowserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateBrowserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateBrowserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateBrowserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateBrowserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBrowserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateBrowserSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBrowserSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateBrowserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBrowserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateBrowserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBrowserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateBrowserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBrowserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateBrowserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBrowserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateBrowserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateBrowserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateBrowserSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateBrowserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateBrowserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateBrowserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateBrowserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateBrowserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateNetworkSettingsError {
    /// Kind of error that occurred.
    pub kind: AssociateNetworkSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateNetworkSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateNetworkSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateNetworkSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateNetworkSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateNetworkSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateNetworkSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateNetworkSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateNetworkSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateNetworkSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateNetworkSettingsError {
    fn code(&self) -> Option<&str> {
        AssociateNetworkSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateNetworkSettingsError {
    /// Creates a new `AssociateNetworkSettingsError`.
    pub fn new(kind: AssociateNetworkSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateNetworkSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateNetworkSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateNetworkSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateNetworkSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateNetworkSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateNetworkSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateNetworkSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateNetworkSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateNetworkSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateNetworkSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateNetworkSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateNetworkSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateNetworkSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateNetworkSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateNetworkSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateNetworkSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateNetworkSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateNetworkSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateNetworkSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateNetworkSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateNetworkSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateNetworkSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateNetworkSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateNetworkSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateTrustStoreError {
    /// Kind of error that occurred.
    pub kind: AssociateTrustStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateTrustStoreErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateTrustStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateTrustStoreErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateTrustStoreErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateTrustStoreErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateTrustStoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateTrustStoreErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateTrustStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateTrustStoreError {
    fn code(&self) -> Option<&str> {
        AssociateTrustStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateTrustStoreError {
    /// Creates a new `AssociateTrustStoreError`.
    pub fn new(kind: AssociateTrustStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateTrustStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateTrustStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateTrustStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateTrustStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateTrustStoreErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTrustStoreErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTrustStoreErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTrustStoreErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTrustStoreErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTrustStoreErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTrustStoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTrustStoreErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTrustStoreErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTrustStoreErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateTrustStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateTrustStoreErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateTrustStoreErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateTrustStoreErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateTrustStoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateTrustStoreErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateTrustStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateUserSettingsError {
    /// Kind of error that occurred.
    pub kind: AssociateUserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateUserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateUserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateUserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateUserSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateUserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateUserSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateUserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateUserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateUserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateUserSettingsError {
    fn code(&self) -> Option<&str> {
        AssociateUserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateUserSettingsError {
    /// Creates a new `AssociateUserSettingsError`.
    pub fn new(kind: AssociateUserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateUserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateUserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateUserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateUserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateUserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateUserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateUserSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateUserSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateUserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateUserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateUserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateUserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateUserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateUserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateUserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateUserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateUserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateUserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateUserSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateUserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateUserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateUserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateUserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateUserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBrowserSettingsError {
    /// Kind of error that occurred.
    pub kind: CreateBrowserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBrowserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBrowserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBrowserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateBrowserSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateBrowserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateBrowserSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateBrowserSettingsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateBrowserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateBrowserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateBrowserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBrowserSettingsError {
    fn code(&self) -> Option<&str> {
        CreateBrowserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBrowserSettingsError {
    /// Creates a new `CreateBrowserSettingsError`.
    pub fn new(kind: CreateBrowserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBrowserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBrowserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBrowserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBrowserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBrowserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBrowserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBrowserSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBrowserSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBrowserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBrowserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBrowserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBrowserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBrowserSettingsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBrowserSettingsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBrowserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBrowserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBrowserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBrowserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateBrowserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBrowserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateBrowserSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            CreateBrowserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateBrowserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateBrowserSettingsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateBrowserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateBrowserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            CreateBrowserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIdentityProviderError {
    /// Kind of error that occurred.
    pub kind: CreateIdentityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIdentityProviderErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIdentityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIdentityProviderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateIdentityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIdentityProviderError {
    fn code(&self) -> Option<&str> {
        CreateIdentityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIdentityProviderError {
    /// Creates a new `CreateIdentityProviderError`.
    pub fn new(kind: CreateIdentityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIdentityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIdentityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIdentityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIdentityProviderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIdentityProviderErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIdentityProviderErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateIdentityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIdentityProviderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::ConflictException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::ValidationException(_inner) => Some(_inner),
            CreateIdentityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNetworkSettingsError {
    /// Kind of error that occurred.
    pub kind: CreateNetworkSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNetworkSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNetworkSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNetworkSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateNetworkSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateNetworkSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateNetworkSettingsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateNetworkSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateNetworkSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateNetworkSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNetworkSettingsError {
    fn code(&self) -> Option<&str> {
        CreateNetworkSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNetworkSettingsError {
    /// Creates a new `CreateNetworkSettingsError`.
    pub fn new(kind: CreateNetworkSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNetworkSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNetworkSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNetworkSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNetworkSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateNetworkSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkSettingsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkSettingsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateNetworkSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNetworkSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateNetworkSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            CreateNetworkSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateNetworkSettingsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateNetworkSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateNetworkSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            CreateNetworkSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePortalError {
    /// Kind of error that occurred.
    pub kind: CreatePortalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePortalErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePortalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePortalErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePortalError {
    fn code(&self) -> Option<&str> {
        CreatePortalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePortalError {
    /// Creates a new `CreatePortalError`.
    pub fn new(kind: CreatePortalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePortalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePortalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePortalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePortalErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePortalErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreatePortalErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreatePortalErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreatePortalErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreatePortalErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortalErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePortalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePortalErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortalErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePortalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreatePortalErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreatePortalErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreatePortalErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreatePortalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePortalErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePortalErrorKind::ConflictException(_inner) => Some(_inner),
            CreatePortalErrorKind::InternalServerException(_inner) => Some(_inner),
            CreatePortalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreatePortalErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreatePortalErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreatePortalErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePortalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTrustStoreError {
    /// Kind of error that occurred.
    pub kind: CreateTrustStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTrustStoreErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTrustStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTrustStoreErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateTrustStoreErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateTrustStoreErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateTrustStoreErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateTrustStoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateTrustStoreErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateTrustStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTrustStoreError {
    fn code(&self) -> Option<&str> {
        CreateTrustStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTrustStoreError {
    /// Creates a new `CreateTrustStoreError`.
    pub fn new(kind: CreateTrustStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTrustStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTrustStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTrustStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTrustStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTrustStoreErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrustStoreErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrustStoreErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateTrustStoreErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateTrustStoreErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrustStoreErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrustStoreErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrustStoreErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrustStoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrustStoreErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrustStoreErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrustStoreErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateTrustStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTrustStoreErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateTrustStoreErrorKind::ConflictException(_inner) => Some(_inner),
            CreateTrustStoreErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateTrustStoreErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateTrustStoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateTrustStoreErrorKind::ValidationException(_inner) => Some(_inner),
            CreateTrustStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserSettingsError {
    /// Kind of error that occurred.
    pub kind: CreateUserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateUserSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateUserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateUserSettingsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateUserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateUserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateUserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserSettingsError {
    fn code(&self) -> Option<&str> {
        CreateUserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserSettingsError {
    /// Creates a new `CreateUserSettingsError`.
    pub fn new(kind: CreateUserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserSettingsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserSettingsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateUserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateUserSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            CreateUserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateUserSettingsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateUserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateUserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            CreateUserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBrowserSettingsError {
    /// Kind of error that occurred.
    pub kind: DeleteBrowserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBrowserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBrowserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBrowserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteBrowserSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteBrowserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteBrowserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteBrowserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteBrowserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBrowserSettingsError {
    fn code(&self) -> Option<&str> {
        DeleteBrowserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBrowserSettingsError {
    /// Creates a new `DeleteBrowserSettingsError`.
    pub fn new(kind: DeleteBrowserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBrowserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBrowserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBrowserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBrowserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBrowserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBrowserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBrowserSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBrowserSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBrowserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBrowserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBrowserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBrowserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBrowserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBrowserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteBrowserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBrowserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteBrowserSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteBrowserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteBrowserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteBrowserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteBrowserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIdentityProviderError {
    /// Kind of error that occurred.
    pub kind: DeleteIdentityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIdentityProviderErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIdentityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIdentityProviderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteIdentityProviderErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteIdentityProviderErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteIdentityProviderErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteIdentityProviderErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteIdentityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIdentityProviderError {
    fn code(&self) -> Option<&str> {
        DeleteIdentityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIdentityProviderError {
    /// Creates a new `DeleteIdentityProviderError`.
    pub fn new(kind: DeleteIdentityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIdentityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIdentityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIdentityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIdentityProviderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIdentityProviderErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIdentityProviderErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteIdentityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIdentityProviderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteIdentityProviderErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteIdentityProviderErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteIdentityProviderErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteIdentityProviderErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteIdentityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNetworkSettingsError {
    /// Kind of error that occurred.
    pub kind: DeleteNetworkSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNetworkSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNetworkSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNetworkSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteNetworkSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteNetworkSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteNetworkSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteNetworkSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteNetworkSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNetworkSettingsError {
    fn code(&self) -> Option<&str> {
        DeleteNetworkSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNetworkSettingsError {
    /// Creates a new `DeleteNetworkSettingsError`.
    pub fn new(kind: DeleteNetworkSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNetworkSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNetworkSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNetworkSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNetworkSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteNetworkSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNetworkSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNetworkSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNetworkSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNetworkSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteNetworkSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNetworkSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteNetworkSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteNetworkSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteNetworkSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteNetworkSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteNetworkSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePortalError {
    /// Kind of error that occurred.
    pub kind: DeletePortalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePortalErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePortalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePortalErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePortalErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePortalErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeletePortalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePortalErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePortalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePortalError {
    fn code(&self) -> Option<&str> {
        DeletePortalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePortalError {
    /// Creates a new `DeletePortalError`.
    pub fn new(kind: DeletePortalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePortalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePortalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePortalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePortalErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePortalErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeletePortalErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeletePortalErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeletePortalErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeletePortalErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortalErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePortalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeletePortalErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeletePortalErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeletePortalErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeletePortalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePortalErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePortalErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePortalErrorKind::InternalServerException(_inner) => Some(_inner),
            DeletePortalErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePortalErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePortalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTrustStoreError {
    /// Kind of error that occurred.
    pub kind: DeleteTrustStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTrustStoreErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTrustStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTrustStoreErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteTrustStoreErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteTrustStoreErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteTrustStoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteTrustStoreErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteTrustStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTrustStoreError {
    fn code(&self) -> Option<&str> {
        DeleteTrustStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTrustStoreError {
    /// Creates a new `DeleteTrustStoreError`.
    pub fn new(kind: DeleteTrustStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTrustStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTrustStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTrustStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTrustStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTrustStoreErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrustStoreErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrustStoreErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteTrustStoreErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteTrustStoreErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrustStoreErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrustStoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrustStoreErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrustStoreErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrustStoreErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteTrustStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTrustStoreErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteTrustStoreErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteTrustStoreErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteTrustStoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteTrustStoreErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteTrustStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserSettingsError {
    /// Kind of error that occurred.
    pub kind: DeleteUserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a conflict.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteUserSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteUserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteUserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteUserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteUserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserSettingsError {
    fn code(&self) -> Option<&str> {
        DeleteUserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserSettingsError {
    /// Creates a new `DeleteUserSettingsError`.
    pub fn new(kind: DeleteUserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteUserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteUserSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteUserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteUserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteUserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteUserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateBrowserSettingsError {
    /// Kind of error that occurred.
    pub kind: DisassociateBrowserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateBrowserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateBrowserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateBrowserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateBrowserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateBrowserSettingsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateBrowserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateBrowserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateBrowserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateBrowserSettingsError {
    fn code(&self) -> Option<&str> {
        DisassociateBrowserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateBrowserSettingsError {
    /// Creates a new `DisassociateBrowserSettingsError`.
    pub fn new(kind: DisassociateBrowserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateBrowserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateBrowserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateBrowserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateBrowserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateBrowserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateBrowserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateBrowserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateBrowserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateBrowserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateBrowserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateBrowserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateBrowserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateBrowserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateBrowserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateBrowserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateBrowserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateBrowserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateBrowserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateBrowserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateBrowserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateBrowserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateNetworkSettingsError {
    /// Kind of error that occurred.
    pub kind: DisassociateNetworkSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateNetworkSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateNetworkSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateNetworkSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateNetworkSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateNetworkSettingsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateNetworkSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateNetworkSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateNetworkSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateNetworkSettingsError {
    fn code(&self) -> Option<&str> {
        DisassociateNetworkSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateNetworkSettingsError {
    /// Creates a new `DisassociateNetworkSettingsError`.
    pub fn new(kind: DisassociateNetworkSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateNetworkSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateNetworkSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateNetworkSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateNetworkSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateNetworkSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateNetworkSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateNetworkSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateNetworkSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateNetworkSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateNetworkSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateNetworkSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateNetworkSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateNetworkSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateNetworkSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateNetworkSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateNetworkSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateNetworkSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateNetworkSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateNetworkSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateNetworkSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateNetworkSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateTrustStoreError {
    /// Kind of error that occurred.
    pub kind: DisassociateTrustStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateTrustStoreErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateTrustStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateTrustStoreErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateTrustStoreErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateTrustStoreErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateTrustStoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateTrustStoreErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateTrustStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateTrustStoreError {
    fn code(&self) -> Option<&str> {
        DisassociateTrustStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateTrustStoreError {
    /// Creates a new `DisassociateTrustStoreError`.
    pub fn new(kind: DisassociateTrustStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateTrustStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateTrustStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateTrustStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateTrustStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateTrustStoreErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTrustStoreErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTrustStoreErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTrustStoreErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTrustStoreErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTrustStoreErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTrustStoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTrustStoreErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateTrustStoreErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTrustStoreErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateTrustStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateTrustStoreErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateTrustStoreErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateTrustStoreErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateTrustStoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateTrustStoreErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateTrustStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateUserSettingsError {
    /// Kind of error that occurred.
    pub kind: DisassociateUserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateUserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateUserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateUserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateUserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateUserSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateUserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateUserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateUserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateUserSettingsError {
    fn code(&self) -> Option<&str> {
        DisassociateUserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateUserSettingsError {
    /// Creates a new `DisassociateUserSettingsError`.
    pub fn new(kind: DisassociateUserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateUserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateUserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateUserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateUserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateUserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateUserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateUserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateUserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateUserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateUserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateUserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateUserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateUserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateUserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateUserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateUserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateUserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateUserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateUserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateUserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateUserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBrowserSettingsError {
    /// Kind of error that occurred.
    pub kind: GetBrowserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBrowserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBrowserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBrowserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetBrowserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetBrowserSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetBrowserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetBrowserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetBrowserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBrowserSettingsError {
    fn code(&self) -> Option<&str> {
        GetBrowserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBrowserSettingsError {
    /// Creates a new `GetBrowserSettingsError`.
    pub fn new(kind: GetBrowserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBrowserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBrowserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBrowserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBrowserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBrowserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBrowserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBrowserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBrowserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBrowserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBrowserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBrowserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBrowserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBrowserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBrowserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetBrowserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBrowserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetBrowserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetBrowserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBrowserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetBrowserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            GetBrowserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIdentityProviderError {
    /// Kind of error that occurred.
    pub kind: GetIdentityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIdentityProviderErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIdentityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIdentityProviderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetIdentityProviderErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetIdentityProviderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetIdentityProviderErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetIdentityProviderErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetIdentityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIdentityProviderError {
    fn code(&self) -> Option<&str> {
        GetIdentityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIdentityProviderError {
    /// Creates a new `GetIdentityProviderError`.
    pub fn new(kind: GetIdentityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIdentityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIdentityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIdentityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIdentityProviderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetIdentityProviderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIdentityProviderErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIdentityProviderErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIdentityProviderErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIdentityProviderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIdentityProviderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIdentityProviderErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIdentityProviderErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIdentityProviderErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIdentityProviderErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetIdentityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIdentityProviderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetIdentityProviderErrorKind::InternalServerException(_inner) => Some(_inner),
            GetIdentityProviderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetIdentityProviderErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetIdentityProviderErrorKind::ValidationException(_inner) => Some(_inner),
            GetIdentityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNetworkSettingsError {
    /// Kind of error that occurred.
    pub kind: GetNetworkSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNetworkSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNetworkSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNetworkSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetNetworkSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetNetworkSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetNetworkSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetNetworkSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetNetworkSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNetworkSettingsError {
    fn code(&self) -> Option<&str> {
        GetNetworkSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNetworkSettingsError {
    /// Creates a new `GetNetworkSettingsError`.
    pub fn new(kind: GetNetworkSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNetworkSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNetworkSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNetworkSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNetworkSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNetworkSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetNetworkSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNetworkSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetNetworkSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetNetworkSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetNetworkSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetNetworkSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            GetNetworkSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPortalError {
    /// Kind of error that occurred.
    pub kind: GetPortalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPortalErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPortalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPortalErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPortalErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPortalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPortalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPortalErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPortalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPortalError {
    fn code(&self) -> Option<&str> {
        GetPortalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPortalError {
    /// Creates a new `GetPortalError`.
    pub fn new(kind: GetPortalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPortalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPortalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPortalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPortalErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPortalErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetPortalErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetPortalErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetPortalErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetPortalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPortalErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetPortalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetPortalErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetPortalErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetPortalErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetPortalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPortalErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPortalErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPortalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPortalErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPortalErrorKind::ValidationException(_inner) => Some(_inner),
            GetPortalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPortalServiceProviderMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPortalServiceProviderMetadataError {
    /// Kind of error that occurred.
    pub kind: GetPortalServiceProviderMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPortalServiceProviderMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPortalServiceProviderMetadataErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPortalServiceProviderMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPortalServiceProviderMetadataErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetPortalServiceProviderMetadataErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetPortalServiceProviderMetadataErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetPortalServiceProviderMetadataErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPortalServiceProviderMetadataErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPortalServiceProviderMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPortalServiceProviderMetadataError {
    fn code(&self) -> Option<&str> {
        GetPortalServiceProviderMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPortalServiceProviderMetadataError {
    /// Creates a new `GetPortalServiceProviderMetadataError`.
    pub fn new(
        kind: GetPortalServiceProviderMetadataErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPortalServiceProviderMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPortalServiceProviderMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPortalServiceProviderMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPortalServiceProviderMetadataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPortalServiceProviderMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortalServiceProviderMetadataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPortalServiceProviderMetadataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortalServiceProviderMetadataErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPortalServiceProviderMetadataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortalServiceProviderMetadataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPortalServiceProviderMetadataErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortalServiceProviderMetadataErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPortalServiceProviderMetadataErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortalServiceProviderMetadataErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPortalServiceProviderMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPortalServiceProviderMetadataErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetPortalServiceProviderMetadataErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetPortalServiceProviderMetadataErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetPortalServiceProviderMetadataErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPortalServiceProviderMetadataErrorKind::ValidationException(_inner) => Some(_inner),
            GetPortalServiceProviderMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTrustStoreError {
    /// Kind of error that occurred.
    pub kind: GetTrustStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTrustStoreErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTrustStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTrustStoreErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetTrustStoreErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetTrustStoreErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetTrustStoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetTrustStoreErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetTrustStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTrustStoreError {
    fn code(&self) -> Option<&str> {
        GetTrustStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTrustStoreError {
    /// Creates a new `GetTrustStoreError`.
    pub fn new(kind: GetTrustStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTrustStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTrustStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTrustStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTrustStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTrustStoreErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetTrustStoreErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetTrustStoreErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrustStoreErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrustStoreErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrustStoreErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrustStoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetTrustStoreErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetTrustStoreErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetTrustStoreErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetTrustStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTrustStoreErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetTrustStoreErrorKind::InternalServerException(_inner) => Some(_inner),
            GetTrustStoreErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetTrustStoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetTrustStoreErrorKind::ValidationException(_inner) => Some(_inner),
            GetTrustStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTrustStoreCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTrustStoreCertificateError {
    /// Kind of error that occurred.
    pub kind: GetTrustStoreCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTrustStoreCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTrustStoreCertificateErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTrustStoreCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTrustStoreCertificateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetTrustStoreCertificateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetTrustStoreCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetTrustStoreCertificateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetTrustStoreCertificateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetTrustStoreCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTrustStoreCertificateError {
    fn code(&self) -> Option<&str> {
        GetTrustStoreCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTrustStoreCertificateError {
    /// Creates a new `GetTrustStoreCertificateError`.
    pub fn new(kind: GetTrustStoreCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTrustStoreCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTrustStoreCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTrustStoreCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTrustStoreCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTrustStoreCertificateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrustStoreCertificateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrustStoreCertificateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrustStoreCertificateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrustStoreCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrustStoreCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrustStoreCertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrustStoreCertificateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrustStoreCertificateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrustStoreCertificateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetTrustStoreCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTrustStoreCertificateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetTrustStoreCertificateErrorKind::InternalServerException(_inner) => Some(_inner),
            GetTrustStoreCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetTrustStoreCertificateErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetTrustStoreCertificateErrorKind::ValidationException(_inner) => Some(_inner),
            GetTrustStoreCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserSettingsError {
    /// Kind of error that occurred.
    pub kind: GetUserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserSettingsError {
    fn code(&self) -> Option<&str> {
        GetUserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserSettingsError {
    /// Creates a new `GetUserSettingsError`.
    pub fn new(kind: GetUserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetUserSettingsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetUserSettingsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetUserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBrowserSettingsError {
    /// Kind of error that occurred.
    pub kind: ListBrowserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBrowserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBrowserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBrowserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListBrowserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListBrowserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBrowserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListBrowserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBrowserSettingsError {
    fn code(&self) -> Option<&str> {
        ListBrowserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBrowserSettingsError {
    /// Creates a new `ListBrowserSettingsError`.
    pub fn new(kind: ListBrowserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBrowserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBrowserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBrowserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBrowserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBrowserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBrowserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBrowserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBrowserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBrowserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBrowserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBrowserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBrowserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListBrowserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBrowserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListBrowserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListBrowserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBrowserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            ListBrowserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIdentityProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIdentityProvidersError {
    /// Kind of error that occurred.
    pub kind: ListIdentityProvidersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIdentityProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIdentityProvidersErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIdentityProvidersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIdentityProvidersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListIdentityProvidersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListIdentityProvidersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListIdentityProvidersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListIdentityProvidersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIdentityProvidersError {
    fn code(&self) -> Option<&str> {
        ListIdentityProvidersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIdentityProvidersError {
    /// Creates a new `ListIdentityProvidersError`.
    pub fn new(kind: ListIdentityProvidersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIdentityProvidersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIdentityProvidersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIdentityProvidersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIdentityProvidersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIdentityProvidersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProvidersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProvidersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProvidersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProvidersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProvidersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProvidersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProvidersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListIdentityProvidersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIdentityProvidersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListIdentityProvidersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListIdentityProvidersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListIdentityProvidersErrorKind::ValidationException(_inner) => Some(_inner),
            ListIdentityProvidersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNetworkSettingsError {
    /// Kind of error that occurred.
    pub kind: ListNetworkSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNetworkSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNetworkSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNetworkSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListNetworkSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListNetworkSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListNetworkSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListNetworkSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNetworkSettingsError {
    fn code(&self) -> Option<&str> {
        ListNetworkSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNetworkSettingsError {
    /// Creates a new `ListNetworkSettingsError`.
    pub fn new(kind: ListNetworkSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNetworkSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNetworkSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNetworkSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNetworkSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNetworkSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNetworkSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNetworkSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNetworkSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListNetworkSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNetworkSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListNetworkSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListNetworkSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListNetworkSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            ListNetworkSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPortals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPortalsError {
    /// Kind of error that occurred.
    pub kind: ListPortalsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPortals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPortalsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPortalsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPortalsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPortalsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPortalsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPortalsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPortalsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPortalsError {
    fn code(&self) -> Option<&str> {
        ListPortalsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPortalsError {
    /// Creates a new `ListPortalsError`.
    pub fn new(kind: ListPortalsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPortalsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPortalsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPortalsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPortalsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPortalsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListPortalsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListPortalsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListPortalsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListPortalsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListPortalsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListPortalsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListPortalsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListPortalsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPortalsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPortalsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPortalsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPortalsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPortalsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTrustStoreCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTrustStoreCertificatesError {
    /// Kind of error that occurred.
    pub kind: ListTrustStoreCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTrustStoreCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTrustStoreCertificatesErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTrustStoreCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTrustStoreCertificatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTrustStoreCertificatesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTrustStoreCertificatesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTrustStoreCertificatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTrustStoreCertificatesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTrustStoreCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTrustStoreCertificatesError {
    fn code(&self) -> Option<&str> {
        ListTrustStoreCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTrustStoreCertificatesError {
    /// Creates a new `ListTrustStoreCertificatesError`.
    pub fn new(kind: ListTrustStoreCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTrustStoreCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTrustStoreCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTrustStoreCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTrustStoreCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTrustStoreCertificatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTrustStoreCertificatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrustStoreCertificatesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTrustStoreCertificatesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrustStoreCertificatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTrustStoreCertificatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrustStoreCertificatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTrustStoreCertificatesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrustStoreCertificatesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTrustStoreCertificatesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTrustStoreCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTrustStoreCertificatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTrustStoreCertificatesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTrustStoreCertificatesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTrustStoreCertificatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTrustStoreCertificatesErrorKind::ValidationException(_inner) => Some(_inner),
            ListTrustStoreCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTrustStores` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTrustStoresError {
    /// Kind of error that occurred.
    pub kind: ListTrustStoresErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTrustStores` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTrustStoresErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTrustStoresError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTrustStoresErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTrustStoresErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTrustStoresErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTrustStoresErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTrustStoresErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTrustStoresError {
    fn code(&self) -> Option<&str> {
        ListTrustStoresError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTrustStoresError {
    /// Creates a new `ListTrustStoresError`.
    pub fn new(kind: ListTrustStoresErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTrustStoresError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTrustStoresErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTrustStoresError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTrustStoresErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTrustStoresErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTrustStoresErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrustStoresErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTrustStoresErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrustStoresErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListTrustStoresErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListTrustStoresErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListTrustStoresErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListTrustStoresError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTrustStoresErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTrustStoresErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTrustStoresErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTrustStoresErrorKind::ValidationException(_inner) => Some(_inner),
            ListTrustStoresErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUserSettingsError {
    /// Kind of error that occurred.
    pub kind: ListUserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListUserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListUserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListUserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListUserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUserSettingsError {
    fn code(&self) -> Option<&str> {
        ListUserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUserSettingsError {
    /// Creates a new `ListUserSettingsError`.
    pub fn new(kind: ListUserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListUserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListUserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListUserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListUserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            ListUserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There are too many tags.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBrowserSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateBrowserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBrowserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBrowserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBrowserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBrowserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateBrowserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateBrowserSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateBrowserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateBrowserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateBrowserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBrowserSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateBrowserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBrowserSettingsError {
    /// Creates a new `UpdateBrowserSettingsError`.
    pub fn new(kind: UpdateBrowserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBrowserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBrowserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBrowserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBrowserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBrowserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBrowserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBrowserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBrowserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBrowserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBrowserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBrowserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBrowserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBrowserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBrowserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateBrowserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBrowserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateBrowserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateBrowserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateBrowserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateBrowserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateBrowserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIdentityProviderError {
    /// Kind of error that occurred.
    pub kind: UpdateIdentityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIdentityProviderErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIdentityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIdentityProviderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateIdentityProviderErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateIdentityProviderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateIdentityProviderErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateIdentityProviderErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateIdentityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIdentityProviderError {
    fn code(&self) -> Option<&str> {
        UpdateIdentityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIdentityProviderError {
    /// Creates a new `UpdateIdentityProviderError`.
    pub fn new(kind: UpdateIdentityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIdentityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIdentityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIdentityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIdentityProviderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateIdentityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIdentityProviderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateIdentityProviderErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateIdentityProviderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateIdentityProviderErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateIdentityProviderErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateIdentityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNetworkSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateNetworkSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNetworkSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNetworkSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNetworkSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNetworkSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateNetworkSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateNetworkSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateNetworkSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateNetworkSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateNetworkSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNetworkSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateNetworkSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNetworkSettingsError {
    /// Creates a new `UpdateNetworkSettingsError`.
    pub fn new(kind: UpdateNetworkSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNetworkSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNetworkSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNetworkSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNetworkSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateNetworkSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateNetworkSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNetworkSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateNetworkSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateNetworkSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateNetworkSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateNetworkSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateNetworkSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePortalError {
    /// Kind of error that occurred.
    pub kind: UpdatePortalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePortalErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePortalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePortalErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePortalErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePortalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePortalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePortalErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePortalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePortalError {
    fn code(&self) -> Option<&str> {
        UpdatePortalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePortalError {
    /// Creates a new `UpdatePortalError`.
    pub fn new(kind: UpdatePortalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePortalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePortalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePortalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePortalErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePortalErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdatePortalErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdatePortalErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortalErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePortalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePortalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdatePortalErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdatePortalErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdatePortalErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdatePortalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePortalErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePortalErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePortalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePortalErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePortalErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePortalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTrustStoreError {
    /// Kind of error that occurred.
    pub kind: UpdateTrustStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTrustStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTrustStoreErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTrustStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTrustStoreErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateTrustStoreErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateTrustStoreErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTrustStoreErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateTrustStoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateTrustStoreErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateTrustStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTrustStoreError {
    fn code(&self) -> Option<&str> {
        UpdateTrustStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTrustStoreError {
    /// Creates a new `UpdateTrustStoreError`.
    pub fn new(kind: UpdateTrustStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTrustStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTrustStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTrustStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTrustStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTrustStoreErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrustStoreErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrustStoreErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrustStoreErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrustStoreErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrustStoreErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrustStoreErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrustStoreErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrustStoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrustStoreErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrustStoreErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrustStoreErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateTrustStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTrustStoreErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateTrustStoreErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateTrustStoreErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTrustStoreErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateTrustStoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateTrustStoreErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateTrustStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateUserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserSettingsErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>There is a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There is a validation error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateUserSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateUserSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateUserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateUserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserSettingsError {
    /// Creates a new `UpdateUserSettingsError`.
    pub fn new(kind: UpdateUserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateUserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateUserSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateUserSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateUserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>There is a validation error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Reason the request failed validation</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>The field that caused the error.</p>
    pub field_list: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>Reason the request failed validation</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>The field that caused the error.</p>
    pub fn field_list(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.field_list.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("field_list", &self.field_list);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) field_list:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Reason the request failed validation</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>Reason the request failed validation</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `field_list`.
        ///
        /// To override the contents of this collection use [`set_field_list`](Self::set_field_list).
        ///
        /// <p>The field that caused the error.</p>
        pub fn field_list(mut self, input: crate::model::ValidationExceptionField) -> Self {
            let mut v = self.field_list.unwrap_or_default();
            v.push(input);
            self.field_list = Some(v);
            self
        }
        /// <p>The field that caused the error.</p>
        pub fn set_field_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.field_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                field_list: self.field_list,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>There is a throttling error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The originating service.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The originating quota.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>Advice to clients on when the call can be safely retried.</p>
    pub retry_after_seconds: i32,
}
impl ThrottlingException {
    /// <p>The originating service.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The originating quota.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>Advice to clients on when the call can be safely retried.</p>
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The originating service.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The originating service.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The originating quota.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The originating quota.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>Advice to clients on when the call can be safely retried.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>Advice to clients on when the call can be safely retried.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                service_code: self.service_code,
                quota_code: self.quota_code,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The resource cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Hypothetical identifier of the resource affected.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Hypothetical type of the resource affected.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>Hypothetical identifier of the resource affected.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Hypothetical type of the resource affected.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Hypothetical identifier of the resource affected.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Hypothetical identifier of the resource affected.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Hypothetical type of the resource affected.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Hypothetical type of the resource affected.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>There is an internal server error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Advice to clients on when the call can be safely retried.</p>
    pub retry_after_seconds: i32,
}
impl InternalServerException {
    /// <p>Advice to clients on when the call can be safely retried.</p>
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Advice to clients on when the call can be safely retried.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>Advice to clients on when the call can be safely retried.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Access is denied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The service quota has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Identifier of the resource affected.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p> Type of the resource affected.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The originating service.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The originating quota.</p>
    pub quota_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// <p>Identifier of the resource affected.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p> Type of the resource affected.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The originating service.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The originating quota.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Identifier of the resource affected.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Identifier of the resource affected.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p> Type of the resource affected.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p> Type of the resource affected.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The originating service.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The originating service.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The originating quota.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The originating quota.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                service_code: self.service_code,
                quota_code: self.quota_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>There are too many tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Name of the resource affected.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl TooManyTagsException {
    /// <p>Name of the resource affected.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Name of the resource affected.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>Name of the resource affected.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>There is a conflict.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Identifier of the resource affected.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Type of the resource affected.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>Identifier of the resource affected.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Type of the resource affected.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Identifier of the resource affected.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Identifier of the resource affected.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Type of the resource affected.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of the resource affected.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}
