// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon WorkSpaces Web
///
/// Client for invoking operations on Amazon WorkSpaces Web. Each operation on Amazon WorkSpaces Web is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_workspacesweb::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_workspacesweb::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_workspacesweb::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AssociateBrowserSettings`](crate::client::fluent_builders::AssociateBrowserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateBrowserSettings::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::AssociateBrowserSettings::set_portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`browser_settings_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateBrowserSettings::browser_settings_arn) / [`set_browser_settings_arn(Option<String>)`](crate::client::fluent_builders::AssociateBrowserSettings::set_browser_settings_arn): <p>The ARN of the browser settings.</p>
    /// - On success, responds with [`AssociateBrowserSettingsOutput`](crate::output::AssociateBrowserSettingsOutput) with field(s):
    ///   - [`portal_arn(Option<String>)`](crate::output::AssociateBrowserSettingsOutput::portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`browser_settings_arn(Option<String>)`](crate::output::AssociateBrowserSettingsOutput::browser_settings_arn): <p>The ARN of the browser settings.</p>
    /// - On failure, responds with [`SdkError<AssociateBrowserSettingsError>`](crate::error::AssociateBrowserSettingsError)
    pub fn associate_browser_settings(&self) -> fluent_builders::AssociateBrowserSettings<C, M, R> {
        fluent_builders::AssociateBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateNetworkSettings`](crate::client::fluent_builders::AssociateNetworkSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateNetworkSettings::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::AssociateNetworkSettings::set_portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`network_settings_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateNetworkSettings::network_settings_arn) / [`set_network_settings_arn(Option<String>)`](crate::client::fluent_builders::AssociateNetworkSettings::set_network_settings_arn): <p>The ARN of the network settings.</p>
    /// - On success, responds with [`AssociateNetworkSettingsOutput`](crate::output::AssociateNetworkSettingsOutput) with field(s):
    ///   - [`portal_arn(Option<String>)`](crate::output::AssociateNetworkSettingsOutput::portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`network_settings_arn(Option<String>)`](crate::output::AssociateNetworkSettingsOutput::network_settings_arn): <p>The ARN of the network settings.</p>
    /// - On failure, responds with [`SdkError<AssociateNetworkSettingsError>`](crate::error::AssociateNetworkSettingsError)
    pub fn associate_network_settings(&self) -> fluent_builders::AssociateNetworkSettings<C, M, R> {
        fluent_builders::AssociateNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateTrustStore`](crate::client::fluent_builders::AssociateTrustStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateTrustStore::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::AssociateTrustStore::set_portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`trust_store_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateTrustStore::trust_store_arn) / [`set_trust_store_arn(Option<String>)`](crate::client::fluent_builders::AssociateTrustStore::set_trust_store_arn): <p>The ARN of the trust store.</p>
    /// - On success, responds with [`AssociateTrustStoreOutput`](crate::output::AssociateTrustStoreOutput) with field(s):
    ///   - [`portal_arn(Option<String>)`](crate::output::AssociateTrustStoreOutput::portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`trust_store_arn(Option<String>)`](crate::output::AssociateTrustStoreOutput::trust_store_arn): <p>The ARN of the trust store.</p>
    /// - On failure, responds with [`SdkError<AssociateTrustStoreError>`](crate::error::AssociateTrustStoreError)
    pub fn associate_trust_store(&self) -> fluent_builders::AssociateTrustStore<C, M, R> {
        fluent_builders::AssociateTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateUserSettings`](crate::client::fluent_builders::AssociateUserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateUserSettings::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::AssociateUserSettings::set_portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`user_settings_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateUserSettings::user_settings_arn) / [`set_user_settings_arn(Option<String>)`](crate::client::fluent_builders::AssociateUserSettings::set_user_settings_arn): <p>The ARN of the user settings.</p>
    /// - On success, responds with [`AssociateUserSettingsOutput`](crate::output::AssociateUserSettingsOutput) with field(s):
    ///   - [`portal_arn(Option<String>)`](crate::output::AssociateUserSettingsOutput::portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`user_settings_arn(Option<String>)`](crate::output::AssociateUserSettingsOutput::user_settings_arn): <p>The ARN of the user settings.</p>
    /// - On failure, responds with [`SdkError<AssociateUserSettingsError>`](crate::error::AssociateUserSettingsError)
    pub fn associate_user_settings(&self) -> fluent_builders::AssociateUserSettings<C, M, R> {
        fluent_builders::AssociateUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBrowserSettings`](crate::client::fluent_builders::CreateBrowserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateBrowserSettings::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateBrowserSettings::set_tags): <p>The tags to add to the browser settings resource. A tag is a key-value pair.</p>
    ///   - [`customer_managed_key(impl Into<String>)`](crate::client::fluent_builders::CreateBrowserSettings::customer_managed_key) / [`set_customer_managed_key(Option<String>)`](crate::client::fluent_builders::CreateBrowserSettings::set_customer_managed_key): <p>The custom managed key of the browser settings.</p>
    ///   - [`additional_encryption_context(HashMap<String, String>)`](crate::client::fluent_builders::CreateBrowserSettings::additional_encryption_context) / [`set_additional_encryption_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateBrowserSettings::set_additional_encryption_context): <p>Additional encryption context of the browser settings.</p>
    ///   - [`browser_policy(impl Into<String>)`](crate::client::fluent_builders::CreateBrowserSettings::browser_policy) / [`set_browser_policy(Option<String>)`](crate::client::fluent_builders::CreateBrowserSettings::set_browser_policy): <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateBrowserSettings::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateBrowserSettings::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK. </p>
    /// - On success, responds with [`CreateBrowserSettingsOutput`](crate::output::CreateBrowserSettingsOutput) with field(s):
    ///   - [`browser_settings_arn(Option<String>)`](crate::output::CreateBrowserSettingsOutput::browser_settings_arn): <p>The ARN of the browser settings.</p>
    /// - On failure, responds with [`SdkError<CreateBrowserSettingsError>`](crate::error::CreateBrowserSettingsError)
    pub fn create_browser_settings(&self) -> fluent_builders::CreateBrowserSettings<C, M, R> {
        fluent_builders::CreateBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIdentityProvider`](crate::client::fluent_builders::CreateIdentityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::CreateIdentityProvider::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::CreateIdentityProvider::set_portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`identity_provider_name(impl Into<String>)`](crate::client::fluent_builders::CreateIdentityProvider::identity_provider_name) / [`set_identity_provider_name(Option<String>)`](crate::client::fluent_builders::CreateIdentityProvider::set_identity_provider_name): <p>The identity provider name.</p>
    ///   - [`identity_provider_type(IdentityProviderType)`](crate::client::fluent_builders::CreateIdentityProvider::identity_provider_type) / [`set_identity_provider_type(Option<IdentityProviderType>)`](crate::client::fluent_builders::CreateIdentityProvider::set_identity_provider_type): <p>The identity provider type.</p>
    ///   - [`identity_provider_details(HashMap<String, String>)`](crate::client::fluent_builders::CreateIdentityProvider::identity_provider_details) / [`set_identity_provider_details(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIdentityProvider::set_identity_provider_details): <p>The identity provider details. The following list describes the provider detail keys for each identity provider type. </p>  <ul>   <li> <p>For Google and Login with Amazon:</p>    <ul>     <li> <p> <code>client_id</code> </p> </li>     <li> <p> <code>client_secret</code> </p> </li>     <li> <p> <code>authorize_scopes</code> </p> </li>    </ul> </li>   <li> <p>For Facebook:</p>    <ul>     <li> <p> <code>client_id</code> </p> </li>     <li> <p> <code>client_secret</code> </p> </li>     <li> <p> <code>authorize_scopes</code> </p> </li>     <li> <p> <code>api_version</code> </p> </li>    </ul> </li>   <li> <p>For Sign in with Apple:</p>    <ul>     <li> <p> <code>client_id</code> </p> </li>     <li> <p> <code>team_id</code> </p> </li>     <li> <p> <code>key_id</code> </p> </li>     <li> <p> <code>private_key</code> </p> </li>     <li> <p> <code>authorize_scopes</code> </p> </li>    </ul> </li>   <li> <p>For OIDC providers:</p>    <ul>     <li> <p> <code>client_id</code> </p> </li>     <li> <p> <code>client_secret</code> </p> </li>     <li> <p> <code>attributes_request_method</code> </p> </li>     <li> <p> <code>oidc_issuer</code> </p> </li>     <li> <p> <code>authorize_scopes</code> </p> </li>     <li> <p> <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>     <li> <p> <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>     <li> <p> <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>     <li> <p> <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>    </ul> </li>   <li> <p>For SAML providers:</p>    <ul>     <li> <p> <code>MetadataFile</code> OR <code>MetadataURL</code> </p> </li>     <li> <p> <code>IDPSignout</code> <i>optional</i> </p> </li>    </ul> </li>  </ul>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateIdentityProvider::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateIdentityProvider::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`CreateIdentityProviderOutput`](crate::output::CreateIdentityProviderOutput) with field(s):
    ///   - [`identity_provider_arn(Option<String>)`](crate::output::CreateIdentityProviderOutput::identity_provider_arn): <p>The ARN of the identity provider.</p>
    /// - On failure, responds with [`SdkError<CreateIdentityProviderError>`](crate::error::CreateIdentityProviderError)
    pub fn create_identity_provider(&self) -> fluent_builders::CreateIdentityProvider<C, M, R> {
        fluent_builders::CreateIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNetworkSettings`](crate::client::fluent_builders::CreateNetworkSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkSettings::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateNetworkSettings::set_vpc_id): <p>The VPC that streaming instances will connect to.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateNetworkSettings::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateNetworkSettings::set_subnet_ids): <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateNetworkSettings::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateNetworkSettings::set_security_group_ids): <p>One or more security groups used to control access from streaming instances to your VPC.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateNetworkSettings::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateNetworkSettings::set_tags): <p>The tags to add to the network settings resource. A tag is a key-value pair.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkSettings::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateNetworkSettings::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`CreateNetworkSettingsOutput`](crate::output::CreateNetworkSettingsOutput) with field(s):
    ///   - [`network_settings_arn(Option<String>)`](crate::output::CreateNetworkSettingsOutput::network_settings_arn): <p>The ARN of the network settings.</p>
    /// - On failure, responds with [`SdkError<CreateNetworkSettingsError>`](crate::error::CreateNetworkSettingsError)
    pub fn create_network_settings(&self) -> fluent_builders::CreateNetworkSettings<C, M, R> {
        fluent_builders::CreateNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePortal`](crate::client::fluent_builders::CreatePortal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreatePortal::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreatePortal::set_display_name): <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePortal::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePortal::set_tags): <p>The tags to add to the web portal. A tag is a key-value pair.</p>
    ///   - [`customer_managed_key(impl Into<String>)`](crate::client::fluent_builders::CreatePortal::customer_managed_key) / [`set_customer_managed_key(Option<String>)`](crate::client::fluent_builders::CreatePortal::set_customer_managed_key): <p>The customer managed key of the web portal.</p>
    ///   - [`additional_encryption_context(HashMap<String, String>)`](crate::client::fluent_builders::CreatePortal::additional_encryption_context) / [`set_additional_encryption_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreatePortal::set_additional_encryption_context): <p>The additional encryption context of the portal.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreatePortal::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreatePortal::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`CreatePortalOutput`](crate::output::CreatePortalOutput) with field(s):
    ///   - [`portal_arn(Option<String>)`](crate::output::CreatePortalOutput::portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`portal_endpoint(Option<String>)`](crate::output::CreatePortalOutput::portal_endpoint): <p>The endpoint URL of the web portal that users access in order to start streaming sessions.</p>
    /// - On failure, responds with [`SdkError<CreatePortalError>`](crate::error::CreatePortalError)
    pub fn create_portal(&self) -> fluent_builders::CreatePortal<C, M, R> {
        fluent_builders::CreatePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTrustStore`](crate::client::fluent_builders::CreateTrustStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_list(Vec<Blob>)`](crate::client::fluent_builders::CreateTrustStore::certificate_list) / [`set_certificate_list(Option<Vec<Blob>>)`](crate::client::fluent_builders::CreateTrustStore::set_certificate_list): <p>A list of CA certificates to be added to the trust store.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTrustStore::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTrustStore::set_tags): <p>The tags to add to the trust store. A tag is a key-value pair.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateTrustStore::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateTrustStore::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`CreateTrustStoreOutput`](crate::output::CreateTrustStoreOutput) with field(s):
    ///   - [`trust_store_arn(Option<String>)`](crate::output::CreateTrustStoreOutput::trust_store_arn): <p>The ARN of the trust store.</p>
    /// - On failure, responds with [`SdkError<CreateTrustStoreError>`](crate::error::CreateTrustStoreError)
    pub fn create_trust_store(&self) -> fluent_builders::CreateTrustStore<C, M, R> {
        fluent_builders::CreateTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUserSettings`](crate::client::fluent_builders::CreateUserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`copy_allowed(EnabledType)`](crate::client::fluent_builders::CreateUserSettings::copy_allowed) / [`set_copy_allowed(Option<EnabledType>)`](crate::client::fluent_builders::CreateUserSettings::set_copy_allowed): <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
    ///   - [`paste_allowed(EnabledType)`](crate::client::fluent_builders::CreateUserSettings::paste_allowed) / [`set_paste_allowed(Option<EnabledType>)`](crate::client::fluent_builders::CreateUserSettings::set_paste_allowed): <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
    ///   - [`download_allowed(EnabledType)`](crate::client::fluent_builders::CreateUserSettings::download_allowed) / [`set_download_allowed(Option<EnabledType>)`](crate::client::fluent_builders::CreateUserSettings::set_download_allowed): <p>Specifies whether the user can download files from the streaming session to the local device.</p>
    ///   - [`upload_allowed(EnabledType)`](crate::client::fluent_builders::CreateUserSettings::upload_allowed) / [`set_upload_allowed(Option<EnabledType>)`](crate::client::fluent_builders::CreateUserSettings::set_upload_allowed): <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
    ///   - [`print_allowed(EnabledType)`](crate::client::fluent_builders::CreateUserSettings::print_allowed) / [`set_print_allowed(Option<EnabledType>)`](crate::client::fluent_builders::CreateUserSettings::set_print_allowed): <p>Specifies whether the user can print to the local device.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateUserSettings::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateUserSettings::set_tags): <p>The tags to add to the user settings resource. A tag is a key-value pair.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateUserSettings::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateUserSettings::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`CreateUserSettingsOutput`](crate::output::CreateUserSettingsOutput) with field(s):
    ///   - [`user_settings_arn(Option<String>)`](crate::output::CreateUserSettingsOutput::user_settings_arn): <p>The ARN of the user settings.</p>
    /// - On failure, responds with [`SdkError<CreateUserSettingsError>`](crate::error::CreateUserSettingsError)
    pub fn create_user_settings(&self) -> fluent_builders::CreateUserSettings<C, M, R> {
        fluent_builders::CreateUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBrowserSettings`](crate::client::fluent_builders::DeleteBrowserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`browser_settings_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteBrowserSettings::browser_settings_arn) / [`set_browser_settings_arn(Option<String>)`](crate::client::fluent_builders::DeleteBrowserSettings::set_browser_settings_arn): <p>The ARN of the browser settings.</p>
    /// - On success, responds with [`DeleteBrowserSettingsOutput`](crate::output::DeleteBrowserSettingsOutput)

    /// - On failure, responds with [`SdkError<DeleteBrowserSettingsError>`](crate::error::DeleteBrowserSettingsError)
    pub fn delete_browser_settings(&self) -> fluent_builders::DeleteBrowserSettings<C, M, R> {
        fluent_builders::DeleteBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIdentityProvider`](crate::client::fluent_builders::DeleteIdentityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_provider_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteIdentityProvider::identity_provider_arn) / [`set_identity_provider_arn(Option<String>)`](crate::client::fluent_builders::DeleteIdentityProvider::set_identity_provider_arn): <p>The ARN of the identity provider.</p>
    /// - On success, responds with [`DeleteIdentityProviderOutput`](crate::output::DeleteIdentityProviderOutput)

    /// - On failure, responds with [`SdkError<DeleteIdentityProviderError>`](crate::error::DeleteIdentityProviderError)
    pub fn delete_identity_provider(&self) -> fluent_builders::DeleteIdentityProvider<C, M, R> {
        fluent_builders::DeleteIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNetworkSettings`](crate::client::fluent_builders::DeleteNetworkSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_settings_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteNetworkSettings::network_settings_arn) / [`set_network_settings_arn(Option<String>)`](crate::client::fluent_builders::DeleteNetworkSettings::set_network_settings_arn): <p>The ARN of the network settings.</p>
    /// - On success, responds with [`DeleteNetworkSettingsOutput`](crate::output::DeleteNetworkSettingsOutput)

    /// - On failure, responds with [`SdkError<DeleteNetworkSettingsError>`](crate::error::DeleteNetworkSettingsError)
    pub fn delete_network_settings(&self) -> fluent_builders::DeleteNetworkSettings<C, M, R> {
        fluent_builders::DeleteNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePortal`](crate::client::fluent_builders::DeletePortal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::DeletePortal::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::DeletePortal::set_portal_arn): <p>The ARN of the web portal.</p>
    /// - On success, responds with [`DeletePortalOutput`](crate::output::DeletePortalOutput)

    /// - On failure, responds with [`SdkError<DeletePortalError>`](crate::error::DeletePortalError)
    pub fn delete_portal(&self) -> fluent_builders::DeletePortal<C, M, R> {
        fluent_builders::DeletePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTrustStore`](crate::client::fluent_builders::DeleteTrustStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`trust_store_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteTrustStore::trust_store_arn) / [`set_trust_store_arn(Option<String>)`](crate::client::fluent_builders::DeleteTrustStore::set_trust_store_arn): <p>The ARN of the trust store.</p>
    /// - On success, responds with [`DeleteTrustStoreOutput`](crate::output::DeleteTrustStoreOutput)

    /// - On failure, responds with [`SdkError<DeleteTrustStoreError>`](crate::error::DeleteTrustStoreError)
    pub fn delete_trust_store(&self) -> fluent_builders::DeleteTrustStore<C, M, R> {
        fluent_builders::DeleteTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUserSettings`](crate::client::fluent_builders::DeleteUserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_settings_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteUserSettings::user_settings_arn) / [`set_user_settings_arn(Option<String>)`](crate::client::fluent_builders::DeleteUserSettings::set_user_settings_arn): <p>The ARN of the user settings.</p>
    /// - On success, responds with [`DeleteUserSettingsOutput`](crate::output::DeleteUserSettingsOutput)

    /// - On failure, responds with [`SdkError<DeleteUserSettingsError>`](crate::error::DeleteUserSettingsError)
    pub fn delete_user_settings(&self) -> fluent_builders::DeleteUserSettings<C, M, R> {
        fluent_builders::DeleteUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateBrowserSettings`](crate::client::fluent_builders::DisassociateBrowserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateBrowserSettings::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::DisassociateBrowserSettings::set_portal_arn): <p>The ARN of the web portal.</p>
    /// - On success, responds with [`DisassociateBrowserSettingsOutput`](crate::output::DisassociateBrowserSettingsOutput)

    /// - On failure, responds with [`SdkError<DisassociateBrowserSettingsError>`](crate::error::DisassociateBrowserSettingsError)
    pub fn disassociate_browser_settings(
        &self,
    ) -> fluent_builders::DisassociateBrowserSettings<C, M, R> {
        fluent_builders::DisassociateBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateNetworkSettings`](crate::client::fluent_builders::DisassociateNetworkSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateNetworkSettings::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::DisassociateNetworkSettings::set_portal_arn): <p>The ARN of the web portal.</p>
    /// - On success, responds with [`DisassociateNetworkSettingsOutput`](crate::output::DisassociateNetworkSettingsOutput)

    /// - On failure, responds with [`SdkError<DisassociateNetworkSettingsError>`](crate::error::DisassociateNetworkSettingsError)
    pub fn disassociate_network_settings(
        &self,
    ) -> fluent_builders::DisassociateNetworkSettings<C, M, R> {
        fluent_builders::DisassociateNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateTrustStore`](crate::client::fluent_builders::DisassociateTrustStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateTrustStore::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::DisassociateTrustStore::set_portal_arn): <p>The ARN of the web portal.</p>
    /// - On success, responds with [`DisassociateTrustStoreOutput`](crate::output::DisassociateTrustStoreOutput)

    /// - On failure, responds with [`SdkError<DisassociateTrustStoreError>`](crate::error::DisassociateTrustStoreError)
    pub fn disassociate_trust_store(&self) -> fluent_builders::DisassociateTrustStore<C, M, R> {
        fluent_builders::DisassociateTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateUserSettings`](crate::client::fluent_builders::DisassociateUserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateUserSettings::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::DisassociateUserSettings::set_portal_arn): <p>The ARN of the web portal.</p>
    /// - On success, responds with [`DisassociateUserSettingsOutput`](crate::output::DisassociateUserSettingsOutput)

    /// - On failure, responds with [`SdkError<DisassociateUserSettingsError>`](crate::error::DisassociateUserSettingsError)
    pub fn disassociate_user_settings(&self) -> fluent_builders::DisassociateUserSettings<C, M, R> {
        fluent_builders::DisassociateUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBrowserSettings`](crate::client::fluent_builders::GetBrowserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`browser_settings_arn(impl Into<String>)`](crate::client::fluent_builders::GetBrowserSettings::browser_settings_arn) / [`set_browser_settings_arn(Option<String>)`](crate::client::fluent_builders::GetBrowserSettings::set_browser_settings_arn): <p>The ARN of the browser settings.</p>
    /// - On success, responds with [`GetBrowserSettingsOutput`](crate::output::GetBrowserSettingsOutput) with field(s):
    ///   - [`browser_settings(Option<BrowserSettings>)`](crate::output::GetBrowserSettingsOutput::browser_settings): <p>The browser settings.</p>
    /// - On failure, responds with [`SdkError<GetBrowserSettingsError>`](crate::error::GetBrowserSettingsError)
    pub fn get_browser_settings(&self) -> fluent_builders::GetBrowserSettings<C, M, R> {
        fluent_builders::GetBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIdentityProvider`](crate::client::fluent_builders::GetIdentityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_provider_arn(impl Into<String>)`](crate::client::fluent_builders::GetIdentityProvider::identity_provider_arn) / [`set_identity_provider_arn(Option<String>)`](crate::client::fluent_builders::GetIdentityProvider::set_identity_provider_arn): <p>The ARN of the identity provider.</p>
    /// - On success, responds with [`GetIdentityProviderOutput`](crate::output::GetIdentityProviderOutput) with field(s):
    ///   - [`identity_provider(Option<IdentityProvider>)`](crate::output::GetIdentityProviderOutput::identity_provider): <p>The identity provider.</p>
    /// - On failure, responds with [`SdkError<GetIdentityProviderError>`](crate::error::GetIdentityProviderError)
    pub fn get_identity_provider(&self) -> fluent_builders::GetIdentityProvider<C, M, R> {
        fluent_builders::GetIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNetworkSettings`](crate::client::fluent_builders::GetNetworkSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_settings_arn(impl Into<String>)`](crate::client::fluent_builders::GetNetworkSettings::network_settings_arn) / [`set_network_settings_arn(Option<String>)`](crate::client::fluent_builders::GetNetworkSettings::set_network_settings_arn): <p>The ARN of the network settings.</p>
    /// - On success, responds with [`GetNetworkSettingsOutput`](crate::output::GetNetworkSettingsOutput) with field(s):
    ///   - [`network_settings(Option<NetworkSettings>)`](crate::output::GetNetworkSettingsOutput::network_settings): <p>The network settings.</p>
    /// - On failure, responds with [`SdkError<GetNetworkSettingsError>`](crate::error::GetNetworkSettingsError)
    pub fn get_network_settings(&self) -> fluent_builders::GetNetworkSettings<C, M, R> {
        fluent_builders::GetNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPortal`](crate::client::fluent_builders::GetPortal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::GetPortal::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::GetPortal::set_portal_arn): <p>The ARN of the web portal.</p>
    /// - On success, responds with [`GetPortalOutput`](crate::output::GetPortalOutput) with field(s):
    ///   - [`portal(Option<Portal>)`](crate::output::GetPortalOutput::portal): <p>The web portal.</p>
    /// - On failure, responds with [`SdkError<GetPortalError>`](crate::error::GetPortalError)
    pub fn get_portal(&self) -> fluent_builders::GetPortal<C, M, R> {
        fluent_builders::GetPortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPortalServiceProviderMetadata`](crate::client::fluent_builders::GetPortalServiceProviderMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::GetPortalServiceProviderMetadata::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::GetPortalServiceProviderMetadata::set_portal_arn): <p>The ARN of the web portal.</p>
    /// - On success, responds with [`GetPortalServiceProviderMetadataOutput`](crate::output::GetPortalServiceProviderMetadataOutput) with field(s):
    ///   - [`portal_arn(Option<String>)`](crate::output::GetPortalServiceProviderMetadataOutput::portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`service_provider_saml_metadata(Option<String>)`](crate::output::GetPortalServiceProviderMetadataOutput::service_provider_saml_metadata): <p>The service provider SAML metadata.</p>
    /// - On failure, responds with [`SdkError<GetPortalServiceProviderMetadataError>`](crate::error::GetPortalServiceProviderMetadataError)
    pub fn get_portal_service_provider_metadata(
        &self,
    ) -> fluent_builders::GetPortalServiceProviderMetadata<C, M, R> {
        fluent_builders::GetPortalServiceProviderMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTrustStore`](crate::client::fluent_builders::GetTrustStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`trust_store_arn(impl Into<String>)`](crate::client::fluent_builders::GetTrustStore::trust_store_arn) / [`set_trust_store_arn(Option<String>)`](crate::client::fluent_builders::GetTrustStore::set_trust_store_arn): <p>The ARN of the trust store.</p>
    /// - On success, responds with [`GetTrustStoreOutput`](crate::output::GetTrustStoreOutput) with field(s):
    ///   - [`trust_store(Option<TrustStore>)`](crate::output::GetTrustStoreOutput::trust_store): <p>The trust store.</p>
    /// - On failure, responds with [`SdkError<GetTrustStoreError>`](crate::error::GetTrustStoreError)
    pub fn get_trust_store(&self) -> fluent_builders::GetTrustStore<C, M, R> {
        fluent_builders::GetTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTrustStoreCertificate`](crate::client::fluent_builders::GetTrustStoreCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`trust_store_arn(impl Into<String>)`](crate::client::fluent_builders::GetTrustStoreCertificate::trust_store_arn) / [`set_trust_store_arn(Option<String>)`](crate::client::fluent_builders::GetTrustStoreCertificate::set_trust_store_arn): <p>The ARN of the trust store certificate.</p>
    ///   - [`thumbprint(impl Into<String>)`](crate::client::fluent_builders::GetTrustStoreCertificate::thumbprint) / [`set_thumbprint(Option<String>)`](crate::client::fluent_builders::GetTrustStoreCertificate::set_thumbprint): <p>The thumbprint of the trust store certificate.</p>
    /// - On success, responds with [`GetTrustStoreCertificateOutput`](crate::output::GetTrustStoreCertificateOutput) with field(s):
    ///   - [`trust_store_arn(Option<String>)`](crate::output::GetTrustStoreCertificateOutput::trust_store_arn): <p>The ARN of the trust store certificate.</p>
    ///   - [`certificate(Option<Certificate>)`](crate::output::GetTrustStoreCertificateOutput::certificate): <p>The certificate of the trust store certificate.</p>
    /// - On failure, responds with [`SdkError<GetTrustStoreCertificateError>`](crate::error::GetTrustStoreCertificateError)
    pub fn get_trust_store_certificate(
        &self,
    ) -> fluent_builders::GetTrustStoreCertificate<C, M, R> {
        fluent_builders::GetTrustStoreCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUserSettings`](crate::client::fluent_builders::GetUserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_settings_arn(impl Into<String>)`](crate::client::fluent_builders::GetUserSettings::user_settings_arn) / [`set_user_settings_arn(Option<String>)`](crate::client::fluent_builders::GetUserSettings::set_user_settings_arn): <p>The ARN of the user settings.</p>
    /// - On success, responds with [`GetUserSettingsOutput`](crate::output::GetUserSettingsOutput) with field(s):
    ///   - [`user_settings(Option<UserSettings>)`](crate::output::GetUserSettingsOutput::user_settings): <p>The user settings.</p>
    /// - On failure, responds with [`SdkError<GetUserSettingsError>`](crate::error::GetUserSettingsError)
    pub fn get_user_settings(&self) -> fluent_builders::GetUserSettings<C, M, R> {
        fluent_builders::GetUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBrowserSettings`](crate::client::fluent_builders::ListBrowserSettings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBrowserSettings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBrowserSettings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBrowserSettings::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBrowserSettings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBrowserSettings::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    /// - On success, responds with [`ListBrowserSettingsOutput`](crate::output::ListBrowserSettingsOutput) with field(s):
    ///   - [`browser_settings(Option<Vec<BrowserSettingsSummary>>)`](crate::output::ListBrowserSettingsOutput::browser_settings): <p>The browser settings.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBrowserSettingsOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    /// - On failure, responds with [`SdkError<ListBrowserSettingsError>`](crate::error::ListBrowserSettingsError)
    pub fn list_browser_settings(&self) -> fluent_builders::ListBrowserSettings<C, M, R> {
        fluent_builders::ListBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIdentityProviders`](crate::client::fluent_builders::ListIdentityProviders) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListIdentityProviders::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIdentityProviders::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIdentityProviders::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIdentityProviders::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIdentityProviders::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::ListIdentityProviders::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::ListIdentityProviders::set_portal_arn): <p>The ARN of the web portal.</p>
    /// - On success, responds with [`ListIdentityProvidersOutput`](crate::output::ListIdentityProvidersOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListIdentityProvidersOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    ///   - [`identity_providers(Option<Vec<IdentityProviderSummary>>)`](crate::output::ListIdentityProvidersOutput::identity_providers): <p>The identity providers.</p>
    /// - On failure, responds with [`SdkError<ListIdentityProvidersError>`](crate::error::ListIdentityProvidersError)
    pub fn list_identity_providers(&self) -> fluent_builders::ListIdentityProviders<C, M, R> {
        fluent_builders::ListIdentityProviders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNetworkSettings`](crate::client::fluent_builders::ListNetworkSettings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNetworkSettings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListNetworkSettings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListNetworkSettings::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListNetworkSettings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListNetworkSettings::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    /// - On success, responds with [`ListNetworkSettingsOutput`](crate::output::ListNetworkSettingsOutput) with field(s):
    ///   - [`network_settings(Option<Vec<NetworkSettingsSummary>>)`](crate::output::ListNetworkSettingsOutput::network_settings): <p>The network settings.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListNetworkSettingsOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    /// - On failure, responds with [`SdkError<ListNetworkSettingsError>`](crate::error::ListNetworkSettingsError)
    pub fn list_network_settings(&self) -> fluent_builders::ListNetworkSettings<C, M, R> {
        fluent_builders::ListNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPortals`](crate::client::fluent_builders::ListPortals) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPortals::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPortals::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPortals::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPortals::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPortals::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    /// - On success, responds with [`ListPortalsOutput`](crate::output::ListPortalsOutput) with field(s):
    ///   - [`portals(Option<Vec<PortalSummary>>)`](crate::output::ListPortalsOutput::portals): <p>The portals in the list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPortalsOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation. </p>
    /// - On failure, responds with [`SdkError<ListPortalsError>`](crate::error::ListPortalsError)
    pub fn list_portals(&self) -> fluent_builders::ListPortals<C, M, R> {
        fluent_builders::ListPortals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags of the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTrustStoreCertificates`](crate::client::fluent_builders::ListTrustStoreCertificates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTrustStoreCertificates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`trust_store_arn(impl Into<String>)`](crate::client::fluent_builders::ListTrustStoreCertificates::trust_store_arn) / [`set_trust_store_arn(Option<String>)`](crate::client::fluent_builders::ListTrustStoreCertificates::set_trust_store_arn): <p>The ARN of the trust store</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTrustStoreCertificates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTrustStoreCertificates::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTrustStoreCertificates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTrustStoreCertificates::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    /// - On success, responds with [`ListTrustStoreCertificatesOutput`](crate::output::ListTrustStoreCertificatesOutput) with field(s):
    ///   - [`certificate_list(Option<Vec<CertificateSummary>>)`](crate::output::ListTrustStoreCertificatesOutput::certificate_list): <p>The certificate list.</p>
    ///   - [`trust_store_arn(Option<String>)`](crate::output::ListTrustStoreCertificatesOutput::trust_store_arn): <p>The ARN of the trust store.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTrustStoreCertificatesOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation.&gt;</p>
    /// - On failure, responds with [`SdkError<ListTrustStoreCertificatesError>`](crate::error::ListTrustStoreCertificatesError)
    pub fn list_trust_store_certificates(
        &self,
    ) -> fluent_builders::ListTrustStoreCertificates<C, M, R> {
        fluent_builders::ListTrustStoreCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTrustStores`](crate::client::fluent_builders::ListTrustStores) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTrustStores::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTrustStores::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTrustStores::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTrustStores::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTrustStores::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    /// - On success, responds with [`ListTrustStoresOutput`](crate::output::ListTrustStoresOutput) with field(s):
    ///   - [`trust_stores(Option<Vec<TrustStoreSummary>>)`](crate::output::ListTrustStoresOutput::trust_stores): <p>The trust stores.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTrustStoresOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    /// - On failure, responds with [`SdkError<ListTrustStoresError>`](crate::error::ListTrustStoresError)
    pub fn list_trust_stores(&self) -> fluent_builders::ListTrustStores<C, M, R> {
        fluent_builders::ListTrustStores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUserSettings`](crate::client::fluent_builders::ListUserSettings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUserSettings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUserSettings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUserSettings::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUserSettings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUserSettings::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    /// - On success, responds with [`ListUserSettingsOutput`](crate::output::ListUserSettingsOutput) with field(s):
    ///   - [`user_settings(Option<Vec<UserSettingsSummary>>)`](crate::output::ListUserSettingsOutput::user_settings): <p>The user settings.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUserSettingsOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation. </p>
    /// - On failure, responds with [`SdkError<ListUserSettingsError>`](crate::error::ListUserSettingsError)
    pub fn list_user_settings(&self) -> fluent_builders::ListUserSettings<C, M, R> {
        fluent_builders::ListUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags of the resource.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::TagResource::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::TagResource::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tag keys to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBrowserSettings`](crate::client::fluent_builders::UpdateBrowserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`browser_settings_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateBrowserSettings::browser_settings_arn) / [`set_browser_settings_arn(Option<String>)`](crate::client::fluent_builders::UpdateBrowserSettings::set_browser_settings_arn): <p>The ARN of the browser settings.</p>
    ///   - [`browser_policy(impl Into<String>)`](crate::client::fluent_builders::UpdateBrowserSettings::browser_policy) / [`set_browser_policy(Option<String>)`](crate::client::fluent_builders::UpdateBrowserSettings::set_browser_policy): <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateBrowserSettings::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateBrowserSettings::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`UpdateBrowserSettingsOutput`](crate::output::UpdateBrowserSettingsOutput) with field(s):
    ///   - [`browser_settings(Option<BrowserSettings>)`](crate::output::UpdateBrowserSettingsOutput::browser_settings): <p>The browser settings.</p>
    /// - On failure, responds with [`SdkError<UpdateBrowserSettingsError>`](crate::error::UpdateBrowserSettingsError)
    pub fn update_browser_settings(&self) -> fluent_builders::UpdateBrowserSettings<C, M, R> {
        fluent_builders::UpdateBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIdentityProvider`](crate::client::fluent_builders::UpdateIdentityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_provider_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::identity_provider_arn) / [`set_identity_provider_arn(Option<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::set_identity_provider_arn): <p>The ARN of the identity provider.</p>
    ///   - [`identity_provider_name(impl Into<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::identity_provider_name) / [`set_identity_provider_name(Option<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::set_identity_provider_name): <p>The name of the identity provider.</p>
    ///   - [`identity_provider_type(IdentityProviderType)`](crate::client::fluent_builders::UpdateIdentityProvider::identity_provider_type) / [`set_identity_provider_type(Option<IdentityProviderType>)`](crate::client::fluent_builders::UpdateIdentityProvider::set_identity_provider_type): <p>The type of the identity provider.</p>
    ///   - [`identity_provider_details(HashMap<String, String>)`](crate::client::fluent_builders::UpdateIdentityProvider::identity_provider_details) / [`set_identity_provider_details(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIdentityProvider::set_identity_provider_details): <p>The details of the identity provider.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateIdentityProvider::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`UpdateIdentityProviderOutput`](crate::output::UpdateIdentityProviderOutput) with field(s):
    ///   - [`identity_provider(Option<IdentityProvider>)`](crate::output::UpdateIdentityProviderOutput::identity_provider): <p>The identity provider.</p>
    /// - On failure, responds with [`SdkError<UpdateIdentityProviderError>`](crate::error::UpdateIdentityProviderError)
    pub fn update_identity_provider(&self) -> fluent_builders::UpdateIdentityProvider<C, M, R> {
        fluent_builders::UpdateIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNetworkSettings`](crate::client::fluent_builders::UpdateNetworkSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_settings_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateNetworkSettings::network_settings_arn) / [`set_network_settings_arn(Option<String>)`](crate::client::fluent_builders::UpdateNetworkSettings::set_network_settings_arn): <p>The ARN of the network settings.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::UpdateNetworkSettings::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::UpdateNetworkSettings::set_vpc_id): <p>The VPC that streaming instances will connect to.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::UpdateNetworkSettings::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateNetworkSettings::set_subnet_ids): <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::UpdateNetworkSettings::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateNetworkSettings::set_security_group_ids): <p>One or more security groups used to control access from streaming instances to your VPC.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateNetworkSettings::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateNetworkSettings::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`UpdateNetworkSettingsOutput`](crate::output::UpdateNetworkSettingsOutput) with field(s):
    ///   - [`network_settings(Option<NetworkSettings>)`](crate::output::UpdateNetworkSettingsOutput::network_settings): <p>The network settings.</p>
    /// - On failure, responds with [`SdkError<UpdateNetworkSettingsError>`](crate::error::UpdateNetworkSettingsError)
    pub fn update_network_settings(&self) -> fluent_builders::UpdateNetworkSettings<C, M, R> {
        fluent_builders::UpdateNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePortal`](crate::client::fluent_builders::UpdatePortal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_arn(impl Into<String>)`](crate::client::fluent_builders::UpdatePortal::portal_arn) / [`set_portal_arn(Option<String>)`](crate::client::fluent_builders::UpdatePortal::set_portal_arn): <p>The ARN of the web portal.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePortal::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdatePortal::set_display_name): <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
    /// - On success, responds with [`UpdatePortalOutput`](crate::output::UpdatePortalOutput) with field(s):
    ///   - [`portal(Option<Portal>)`](crate::output::UpdatePortalOutput::portal): <p>The web portal.</p>
    /// - On failure, responds with [`SdkError<UpdatePortalError>`](crate::error::UpdatePortalError)
    pub fn update_portal(&self) -> fluent_builders::UpdatePortal<C, M, R> {
        fluent_builders::UpdatePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTrustStore`](crate::client::fluent_builders::UpdateTrustStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`trust_store_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateTrustStore::trust_store_arn) / [`set_trust_store_arn(Option<String>)`](crate::client::fluent_builders::UpdateTrustStore::set_trust_store_arn): <p>The ARN of the trust store.</p>
    ///   - [`certificates_to_add(Vec<Blob>)`](crate::client::fluent_builders::UpdateTrustStore::certificates_to_add) / [`set_certificates_to_add(Option<Vec<Blob>>)`](crate::client::fluent_builders::UpdateTrustStore::set_certificates_to_add): <p>A list of CA certificates to add to the trust store.</p>
    ///   - [`certificates_to_delete(Vec<String>)`](crate::client::fluent_builders::UpdateTrustStore::certificates_to_delete) / [`set_certificates_to_delete(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateTrustStore::set_certificates_to_delete): <p>A list of CA certificates to delete from a trust store.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateTrustStore::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateTrustStore::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`UpdateTrustStoreOutput`](crate::output::UpdateTrustStoreOutput) with field(s):
    ///   - [`trust_store_arn(Option<String>)`](crate::output::UpdateTrustStoreOutput::trust_store_arn): <p>The ARN of the trust store.</p>
    /// - On failure, responds with [`SdkError<UpdateTrustStoreError>`](crate::error::UpdateTrustStoreError)
    pub fn update_trust_store(&self) -> fluent_builders::UpdateTrustStore<C, M, R> {
        fluent_builders::UpdateTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserSettings`](crate::client::fluent_builders::UpdateUserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_settings_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateUserSettings::user_settings_arn) / [`set_user_settings_arn(Option<String>)`](crate::client::fluent_builders::UpdateUserSettings::set_user_settings_arn): <p>The ARN of the user settings.</p>
    ///   - [`copy_allowed(EnabledType)`](crate::client::fluent_builders::UpdateUserSettings::copy_allowed) / [`set_copy_allowed(Option<EnabledType>)`](crate::client::fluent_builders::UpdateUserSettings::set_copy_allowed): <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
    ///   - [`paste_allowed(EnabledType)`](crate::client::fluent_builders::UpdateUserSettings::paste_allowed) / [`set_paste_allowed(Option<EnabledType>)`](crate::client::fluent_builders::UpdateUserSettings::set_paste_allowed): <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
    ///   - [`download_allowed(EnabledType)`](crate::client::fluent_builders::UpdateUserSettings::download_allowed) / [`set_download_allowed(Option<EnabledType>)`](crate::client::fluent_builders::UpdateUserSettings::set_download_allowed): <p>Specifies whether the user can download files from the streaming session to the local device.</p>
    ///   - [`upload_allowed(EnabledType)`](crate::client::fluent_builders::UpdateUserSettings::upload_allowed) / [`set_upload_allowed(Option<EnabledType>)`](crate::client::fluent_builders::UpdateUserSettings::set_upload_allowed): <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
    ///   - [`print_allowed(EnabledType)`](crate::client::fluent_builders::UpdateUserSettings::print_allowed) / [`set_print_allowed(Option<EnabledType>)`](crate::client::fluent_builders::UpdateUserSettings::set_print_allowed): <p>Specifies whether the user can print to the local device.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateUserSettings::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateUserSettings::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>  <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    /// - On success, responds with [`UpdateUserSettingsOutput`](crate::output::UpdateUserSettingsOutput) with field(s):
    ///   - [`user_settings(Option<UserSettings>)`](crate::output::UpdateUserSettingsOutput::user_settings): <p>The user settings.</p>
    /// - On failure, responds with [`SdkError<UpdateUserSettingsError>`](crate::error::UpdateUserSettingsError)
    pub fn update_user_settings(&self) -> fluent_builders::UpdateUserSettings<C, M, R> {
        fluent_builders::UpdateUserSettings::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateBrowserSettings`.
    ///
    /// <p>Associates a browser settings resource with a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_browser_settings_input::Builder,
    }
    impl<C, M, R> AssociateBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateBrowserSettingsInputOperationOutputAlias,
                crate::output::AssociateBrowserSettingsOutput,
                crate::error::AssociateBrowserSettingsError,
                crate::input::AssociateBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateNetworkSettings`.
    ///
    /// <p>Associates a network settings resource with a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_network_settings_input::Builder,
    }
    impl<C, M, R> AssociateNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateNetworkSettingsInputOperationOutputAlias,
                crate::output::AssociateNetworkSettingsOutput,
                crate::error::AssociateNetworkSettingsError,
                crate::input::AssociateNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTrustStore`.
    ///
    /// <p>Associates a trust store with a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_trust_store_input::Builder,
    }
    impl<C, M, R> AssociateTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTrustStoreInputOperationOutputAlias,
                crate::output::AssociateTrustStoreOutput,
                crate::error::AssociateTrustStoreError,
                crate::input::AssociateTrustStoreInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(input.into());
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateUserSettings`.
    ///
    /// <p>Associates a user settings resource with a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_user_settings_input::Builder,
    }
    impl<C, M, R> AssociateUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateUserSettingsInputOperationOutputAlias,
                crate::output::AssociateUserSettingsOutput,
                crate::error::AssociateUserSettingsError,
                crate::input::AssociateUserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBrowserSettings`.
    ///
    /// <p>Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal, browser settings control how the browser will behave once a user starts a streaming session for the web portal. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_browser_settings_input::Builder,
    }
    impl<C, M, R> CreateBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBrowserSettingsInputOperationOutputAlias,
                crate::output::CreateBrowserSettingsOutput,
                crate::error::CreateBrowserSettingsError,
                crate::input::CreateBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the browser settings resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the browser settings resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The custom managed key of the browser settings.</p>
        pub fn customer_managed_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_managed_key(input.into());
            self
        }
        /// <p>The custom managed key of the browser settings.</p>
        pub fn set_customer_managed_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_managed_key(input);
            self
        }
        /// Adds a key-value pair to `additionalEncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_additional_encryption_context`](Self::set_additional_encryption_context).
        ///
        /// <p>Additional encryption context of the browser settings.</p>
        pub fn additional_encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_encryption_context(k.into(), v.into());
            self
        }
        /// <p>Additional encryption context of the browser settings.</p>
        pub fn set_additional_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_encryption_context(input);
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.</p>
        pub fn browser_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_policy(input.into());
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.</p>
        pub fn set_browser_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_policy(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIdentityProvider`.
    ///
    /// <p>Creates an identity provider resource that is then associated with a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_identity_provider_input::Builder,
    }
    impl<C, M, R> CreateIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIdentityProviderInputOperationOutputAlias,
                crate::output::CreateIdentityProviderOutput,
                crate::error::CreateIdentityProviderError,
                crate::input::CreateIdentityProviderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The identity provider name.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_name(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_name(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.inner = self.inner.identity_provider_type(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_type(input);
            self
        }
        /// Adds a key-value pair to `identityProviderDetails`.
        ///
        /// To override the contents of this collection use [`set_identity_provider_details`](Self::set_identity_provider_details).
        ///
        /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type. </p>
        /// <ul>
        /// <li> <p>For Google and Login with Amazon:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For Facebook:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// <li> <p> <code>api_version</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For Sign in with Apple:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>team_id</code> </p> </li>
        /// <li> <p> <code>key_id</code> </p> </li>
        /// <li> <p> <code>private_key</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For OIDC providers:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>attributes_request_method</code> </p> </li>
        /// <li> <p> <code>oidc_issuer</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// <li> <p> <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// </ul> </li>
        /// <li> <p>For SAML providers:</p>
        /// <ul>
        /// <li> <p> <code>MetadataFile</code> OR <code>MetadataURL</code> </p> </li>
        /// <li> <p> <code>IDPSignout</code> <i>optional</i> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn identity_provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_provider_details(k.into(), v.into());
            self
        }
        /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type. </p>
        /// <ul>
        /// <li> <p>For Google and Login with Amazon:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For Facebook:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// <li> <p> <code>api_version</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For Sign in with Apple:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>team_id</code> </p> </li>
        /// <li> <p> <code>key_id</code> </p> </li>
        /// <li> <p> <code>private_key</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For OIDC providers:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>attributes_request_method</code> </p> </li>
        /// <li> <p> <code>oidc_issuer</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// <li> <p> <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// </ul> </li>
        /// <li> <p>For SAML providers:</p>
        /// <ul>
        /// <li> <p> <code>MetadataFile</code> OR <code>MetadataURL</code> </p> </li>
        /// <li> <p> <code>IDPSignout</code> <i>optional</i> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_details(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetworkSettings`.
    ///
    /// <p>Creates a network settings resource that can be associated with a web portal. Once associated with a web portal, network settings define how streaming instances will connect with your specified VPC. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_settings_input::Builder,
    }
    impl<C, M, R> CreateNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkSettingsInputOperationOutputAlias,
                crate::output::CreateNetworkSettingsOutput,
                crate::error::CreateNetworkSettingsError,
                crate::input::CreateNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `subnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `securityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the network settings resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the network settings resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePortal`.
    ///
    /// <p>Creates a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePortal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_portal_input::Builder,
    }
    impl<C, M, R> CreatePortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePortalInputOperationOutputAlias,
                crate::output::CreatePortalOutput,
                crate::error::CreatePortalError,
                crate::input::CreatePortalInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the web portal. A tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the web portal. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The customer managed key of the web portal.</p>
        pub fn customer_managed_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_managed_key(input.into());
            self
        }
        /// <p>The customer managed key of the web portal.</p>
        pub fn set_customer_managed_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_managed_key(input);
            self
        }
        /// Adds a key-value pair to `additionalEncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_additional_encryption_context`](Self::set_additional_encryption_context).
        ///
        /// <p>The additional encryption context of the portal.</p>
        pub fn additional_encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_encryption_context(k.into(), v.into());
            self
        }
        /// <p>The additional encryption context of the portal.</p>
        pub fn set_additional_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_encryption_context(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrustStore`.
    ///
    /// <p>Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA) certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates that have been issued using any of the CAs in the trust store. If your organization has internal websites that use certificates issued by private CAs, you should add the private CA certificate to the trust store. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_trust_store_input::Builder,
    }
    impl<C, M, R> CreateTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrustStoreInputOperationOutputAlias,
                crate::output::CreateTrustStoreOutput,
                crate::error::CreateTrustStoreError,
                crate::input::CreateTrustStoreInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `certificateList`.
        ///
        /// To override the contents of this collection use [`set_certificate_list`](Self::set_certificate_list).
        ///
        /// <p>A list of CA certificates to be added to the trust store.</p>
        pub fn certificate_list(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.certificate_list(input);
            self
        }
        /// <p>A list of CA certificates to be added to the trust store.</p>
        pub fn set_certificate_list(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        ) -> Self {
            self.inner = self.inner.set_certificate_list(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the trust store. A tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the trust store. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserSettings`.
    ///
    /// <p>Creates a user settings resource that can be associated with a web portal. Once associated with a web portal, user settings control how users can transfer data between a streaming session and the their local devices. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_settings_input::Builder,
    }
    impl<C, M, R> CreateUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserSettingsInputOperationOutputAlias,
                crate::output::CreateUserSettingsOutput,
                crate::error::CreateUserSettingsError,
                crate::input::CreateUserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
        pub fn copy_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.inner = self.inner.copy_allowed(input);
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
        pub fn set_copy_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_copy_allowed(input);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
        pub fn paste_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.inner = self.inner.paste_allowed(input);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
        pub fn set_paste_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_paste_allowed(input);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
        pub fn download_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.inner = self.inner.download_allowed(input);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
        pub fn set_download_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_download_allowed(input);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
        pub fn upload_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.inner = self.inner.upload_allowed(input);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
        pub fn set_upload_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_upload_allowed(input);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn print_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.inner = self.inner.print_allowed(input);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn set_print_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_print_allowed(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the user settings resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the user settings resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBrowserSettings`.
    ///
    /// <p>Deletes browser settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_browser_settings_input::Builder,
    }
    impl<C, M, R> DeleteBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBrowserSettingsInputOperationOutputAlias,
                crate::output::DeleteBrowserSettingsOutput,
                crate::error::DeleteBrowserSettingsError,
                crate::input::DeleteBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentityProvider`.
    ///
    /// <p>Deletes the identity provider.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_identity_provider_input::Builder,
    }
    impl<C, M, R> DeleteIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIdentityProviderInputOperationOutputAlias,
                crate::output::DeleteIdentityProviderOutput,
                crate::error::DeleteIdentityProviderError,
                crate::input::DeleteIdentityProviderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_arn(input.into());
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNetworkSettings`.
    ///
    /// <p>Deletes network settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_network_settings_input::Builder,
    }
    impl<C, M, R> DeleteNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNetworkSettingsInputOperationOutputAlias,
                crate::output::DeleteNetworkSettingsOutput,
                crate::error::DeleteNetworkSettingsError,
                crate::input::DeleteNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePortal`.
    ///
    /// <p>Deletes a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePortal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_portal_input::Builder,
    }
    impl<C, M, R> DeletePortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePortalInputOperationOutputAlias,
                crate::output::DeletePortalOutput,
                crate::error::DeletePortalError,
                crate::input::DeletePortalInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrustStore`.
    ///
    /// <p>Deletes the trust store.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_trust_store_input::Builder,
    }
    impl<C, M, R> DeleteTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTrustStoreInputOperationOutputAlias,
                crate::output::DeleteTrustStoreOutput,
                crate::error::DeleteTrustStoreError,
                crate::input::DeleteTrustStoreInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(input.into());
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserSettings`.
    ///
    /// <p>Deletes user settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_settings_input::Builder,
    }
    impl<C, M, R> DeleteUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserSettingsInputOperationOutputAlias,
                crate::output::DeleteUserSettingsOutput,
                crate::error::DeleteUserSettingsError,
                crate::input::DeleteUserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateBrowserSettings`.
    ///
    /// <p>Disassociates browser settings from a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_browser_settings_input::Builder,
    }
    impl<C, M, R> DisassociateBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateBrowserSettingsInputOperationOutputAlias,
                crate::output::DisassociateBrowserSettingsOutput,
                crate::error::DisassociateBrowserSettingsError,
                crate::input::DisassociateBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateNetworkSettings`.
    ///
    /// <p>Disassociates network settings from a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_network_settings_input::Builder,
    }
    impl<C, M, R> DisassociateNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateNetworkSettingsInputOperationOutputAlias,
                crate::output::DisassociateNetworkSettingsOutput,
                crate::error::DisassociateNetworkSettingsError,
                crate::input::DisassociateNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTrustStore`.
    ///
    /// <p>Disassociates a trust store from a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_trust_store_input::Builder,
    }
    impl<C, M, R> DisassociateTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateTrustStoreInputOperationOutputAlias,
                crate::output::DisassociateTrustStoreOutput,
                crate::error::DisassociateTrustStoreError,
                crate::input::DisassociateTrustStoreInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateUserSettings`.
    ///
    /// <p>Disassociates user settings from a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_user_settings_input::Builder,
    }
    impl<C, M, R> DisassociateUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateUserSettingsInputOperationOutputAlias,
                crate::output::DisassociateUserSettingsOutput,
                crate::error::DisassociateUserSettingsError,
                crate::input::DisassociateUserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBrowserSettings`.
    ///
    /// <p>Gets browser settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_browser_settings_input::Builder,
    }
    impl<C, M, R> GetBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBrowserSettingsInputOperationOutputAlias,
                crate::output::GetBrowserSettingsOutput,
                crate::error::GetBrowserSettingsError,
                crate::input::GetBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityProvider`.
    ///
    /// <p>Gets the identity provider.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_identity_provider_input::Builder,
    }
    impl<C, M, R> GetIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdentityProviderInputOperationOutputAlias,
                crate::output::GetIdentityProviderOutput,
                crate::error::GetIdentityProviderError,
                crate::input::GetIdentityProviderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_arn(input.into());
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkSettings`.
    ///
    /// <p>Gets the network settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_settings_input::Builder,
    }
    impl<C, M, R> GetNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkSettingsInputOperationOutputAlias,
                crate::output::GetNetworkSettingsOutput,
                crate::error::GetNetworkSettingsError,
                crate::input::GetNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPortal`.
    ///
    /// <p>Gets the web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPortal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_portal_input::Builder,
    }
    impl<C, M, R> GetPortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPortalOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPortalInputOperationOutputAlias,
                crate::output::GetPortalOutput,
                crate::error::GetPortalError,
                crate::input::GetPortalInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPortalServiceProviderMetadata`.
    ///
    /// <p>Gets the service provider metadata.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPortalServiceProviderMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_portal_service_provider_metadata_input::Builder,
    }
    impl<C, M, R> GetPortalServiceProviderMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPortalServiceProviderMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPortalServiceProviderMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPortalServiceProviderMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPortalServiceProviderMetadataInputOperationOutputAlias,
                crate::output::GetPortalServiceProviderMetadataOutput,
                crate::error::GetPortalServiceProviderMetadataError,
                crate::input::GetPortalServiceProviderMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrustStore`.
    ///
    /// <p>Gets the trust store.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_trust_store_input::Builder,
    }
    impl<C, M, R> GetTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTrustStoreInputOperationOutputAlias,
                crate::output::GetTrustStoreOutput,
                crate::error::GetTrustStoreError,
                crate::input::GetTrustStoreInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(input.into());
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrustStoreCertificate`.
    ///
    /// <p>Gets the trust store certificate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTrustStoreCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_trust_store_certificate_input::Builder,
    }
    impl<C, M, R> GetTrustStoreCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTrustStoreCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrustStoreCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrustStoreCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTrustStoreCertificateInputOperationOutputAlias,
                crate::output::GetTrustStoreCertificateOutput,
                crate::error::GetTrustStoreCertificateError,
                crate::input::GetTrustStoreCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the trust store certificate.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(input.into());
            self
        }
        /// <p>The ARN of the trust store certificate.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
        /// <p>The thumbprint of the trust store certificate.</p>
        pub fn thumbprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thumbprint(input.into());
            self
        }
        /// <p>The thumbprint of the trust store certificate.</p>
        pub fn set_thumbprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thumbprint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserSettings`.
    ///
    /// <p>Gets user settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_settings_input::Builder,
    }
    impl<C, M, R> GetUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserSettingsInputOperationOutputAlias,
                crate::output::GetUserSettingsOutput,
                crate::error::GetUserSettingsError,
                crate::input::GetUserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBrowserSettings`.
    ///
    /// <p>Retrieves a list of browser settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_browser_settings_input::Builder,
    }
    impl<C, M, R> ListBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBrowserSettingsInputOperationOutputAlias,
                crate::output::ListBrowserSettingsOutput,
                crate::error::ListBrowserSettingsError,
                crate::input::ListBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBrowserSettingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBrowserSettingsPaginator<C, M, R> {
            crate::paginator::ListBrowserSettingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityProviders`.
    ///
    /// <p>Retrieves a list of identity providers for a specific web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIdentityProviders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_identity_providers_input::Builder,
    }
    impl<C, M, R> ListIdentityProviders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIdentityProviders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityProvidersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityProvidersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIdentityProvidersInputOperationOutputAlias,
                crate::output::ListIdentityProvidersOutput,
                crate::error::ListIdentityProvidersError,
                crate::input::ListIdentityProvidersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListIdentityProvidersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListIdentityProvidersPaginator<C, M, R> {
            crate::paginator::ListIdentityProvidersPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNetworkSettings`.
    ///
    /// <p>Retrieves a list of network settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_network_settings_input::Builder,
    }
    impl<C, M, R> ListNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNetworkSettingsInputOperationOutputAlias,
                crate::output::ListNetworkSettingsOutput,
                crate::error::ListNetworkSettingsError,
                crate::input::ListNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNetworkSettingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNetworkSettingsPaginator<C, M, R> {
            crate::paginator::ListNetworkSettingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPortals`.
    ///
    /// <p>Retrieves a list or web portals.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPortals<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_portals_input::Builder,
    }
    impl<C, M, R> ListPortals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPortals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPortalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPortalsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPortalsInputOperationOutputAlias,
                crate::output::ListPortalsOutput,
                crate::error::ListPortalsError,
                crate::input::ListPortalsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPortalsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPortalsPaginator<C, M, R> {
            crate::paginator::ListPortalsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves a list of tags for a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrustStoreCertificates`.
    ///
    /// <p>Retrieves a list of trust store certificates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrustStoreCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_trust_store_certificates_input::Builder,
    }
    impl<C, M, R> ListTrustStoreCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrustStoreCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrustStoreCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrustStoreCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrustStoreCertificatesInputOperationOutputAlias,
                crate::output::ListTrustStoreCertificatesOutput,
                crate::error::ListTrustStoreCertificatesError,
                crate::input::ListTrustStoreCertificatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTrustStoreCertificatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListTrustStoreCertificatesPaginator<C, M, R> {
            crate::paginator::ListTrustStoreCertificatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the trust store</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(input.into());
            self
        }
        /// <p>The ARN of the trust store</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrustStores`.
    ///
    /// <p>Retrieves a list of trust stores.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrustStores<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_trust_stores_input::Builder,
    }
    impl<C, M, R> ListTrustStores<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrustStores`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrustStoresOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrustStoresError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrustStoresInputOperationOutputAlias,
                crate::output::ListTrustStoresOutput,
                crate::error::ListTrustStoresError,
                crate::input::ListTrustStoresInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTrustStoresPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTrustStoresPaginator<C, M, R> {
            crate::paginator::ListTrustStoresPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserSettings`.
    ///
    /// <p>Retrieves a list of user settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_settings_input::Builder,
    }
    impl<C, M, R> ListUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserSettingsInputOperationOutputAlias,
                crate::output::ListUserSettingsOutput,
                crate::error::ListUserSettingsError,
                crate::input::ListUserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUserSettingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUserSettingsPaginator<C, M, R> {
            crate::paginator::ListUserSettingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags of the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBrowserSettings`.
    ///
    /// <p>Updates browser settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_browser_settings_input::Builder,
    }
    impl<C, M, R> UpdateBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBrowserSettingsInputOperationOutputAlias,
                crate::output::UpdateBrowserSettingsOutput,
                crate::error::UpdateBrowserSettingsError,
                crate::input::UpdateBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_settings_arn(input);
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions. </p>
        pub fn browser_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_policy(input.into());
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions. </p>
        pub fn set_browser_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_policy(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIdentityProvider`.
    ///
    /// <p>Updates the identity provider.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_identity_provider_input::Builder,
    }
    impl<C, M, R> UpdateIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIdentityProviderInputOperationOutputAlias,
                crate::output::UpdateIdentityProviderOutput,
                crate::error::UpdateIdentityProviderError,
                crate::input::UpdateIdentityProviderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_arn(input.into());
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_arn(input);
            self
        }
        /// <p>The name of the identity provider.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_name(input.into());
            self
        }
        /// <p>The name of the identity provider.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_name(input);
            self
        }
        /// <p>The type of the identity provider.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.inner = self.inner.identity_provider_type(input);
            self
        }
        /// <p>The type of the identity provider.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_type(input);
            self
        }
        /// Adds a key-value pair to `identityProviderDetails`.
        ///
        /// To override the contents of this collection use [`set_identity_provider_details`](Self::set_identity_provider_details).
        ///
        /// <p>The details of the identity provider.</p>
        pub fn identity_provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_provider_details(k.into(), v.into());
            self
        }
        /// <p>The details of the identity provider.</p>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_details(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNetworkSettings`.
    ///
    /// <p>Updates network settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_network_settings_input::Builder,
    }
    impl<C, M, R> UpdateNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNetworkSettingsInputOperationOutputAlias,
                crate::output::UpdateNetworkSettingsOutput,
                crate::error::UpdateNetworkSettingsError,
                crate::input::UpdateNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_settings_arn(input);
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `subnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `securityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePortal`.
    ///
    /// <p>Updates a web portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePortal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_portal_input::Builder,
    }
    impl<C, M, R> UpdatePortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePortalInputOperationOutputAlias,
                crate::output::UpdatePortalOutput,
                crate::error::UpdatePortalError,
                crate::input::UpdatePortalInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTrustStore`.
    ///
    /// <p>Updates the trust store.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_trust_store_input::Builder,
    }
    impl<C, M, R> UpdateTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTrustStoreInputOperationOutputAlias,
                crate::output::UpdateTrustStoreOutput,
                crate::error::UpdateTrustStoreError,
                crate::input::UpdateTrustStoreInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(input.into());
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
        /// Appends an item to `certificatesToAdd`.
        ///
        /// To override the contents of this collection use [`set_certificates_to_add`](Self::set_certificates_to_add).
        ///
        /// <p>A list of CA certificates to add to the trust store.</p>
        pub fn certificates_to_add(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.certificates_to_add(input);
            self
        }
        /// <p>A list of CA certificates to add to the trust store.</p>
        pub fn set_certificates_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        ) -> Self {
            self.inner = self.inner.set_certificates_to_add(input);
            self
        }
        /// Appends an item to `certificatesToDelete`.
        ///
        /// To override the contents of this collection use [`set_certificates_to_delete`](Self::set_certificates_to_delete).
        ///
        /// <p>A list of CA certificates to delete from a trust store.</p>
        pub fn certificates_to_delete(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificates_to_delete(input.into());
            self
        }
        /// <p>A list of CA certificates to delete from a trust store.</p>
        pub fn set_certificates_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_certificates_to_delete(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserSettings`.
    ///
    /// <p>Updates the user settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_settings_input::Builder,
    }
    impl<C, M, R> UpdateUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserSettingsInputOperationOutputAlias,
                crate::output::UpdateUserSettingsOutput,
                crate::error::UpdateUserSettingsError,
                crate::input::UpdateUserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_settings_arn(input.into());
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_settings_arn(input);
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
        pub fn copy_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.inner = self.inner.copy_allowed(input);
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
        pub fn set_copy_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_copy_allowed(input);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
        pub fn paste_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.inner = self.inner.paste_allowed(input);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
        pub fn set_paste_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_paste_allowed(input);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
        pub fn download_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.inner = self.inner.download_allowed(input);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
        pub fn set_download_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_download_allowed(input);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
        pub fn upload_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.inner = self.inner.upload_allowed(input);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
        pub fn set_upload_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_upload_allowed(input);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn print_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.inner = self.inner.print_allowed(input);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn set_print_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_print_allowed(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
