// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateBrowserSettingsInput`](crate::input::AssociateBrowserSettingsInput)
pub mod associate_browser_settings_input {
    /// A builder for [`AssociateBrowserSettingsInput`](crate::input::AssociateBrowserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
        pub(crate) browser_settings_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_settings_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateBrowserSettingsInput`](crate::input::AssociateBrowserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateBrowserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateBrowserSettingsInput {
                portal_arn: self.portal_arn,
                browser_settings_arn: self.browser_settings_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateBrowserSettingsInputOperationOutputAlias =
    crate::operation::AssociateBrowserSettings;
#[doc(hidden)]
pub type AssociateBrowserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateBrowserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`AssociateBrowserSettings`](crate::operation::AssociateBrowserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateBrowserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateBrowserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.portal_arn;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_1, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/portals/{portalArn}/browserSettings",
                portalArn = portal_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::AssociateBrowserSettingsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_2) = &_input.browser_settings_arn {
                query.push_kv(
                    "browserSettingsArn",
                    &aws_smithy_http::query::fmt_string(&inner_2),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateBrowserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateBrowserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateBrowserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateBrowserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateBrowserSettingsInput`](crate::input::AssociateBrowserSettingsInput)
    pub fn builder() -> crate::input::associate_browser_settings_input::Builder {
        crate::input::associate_browser_settings_input::Builder::default()
    }
}

/// See [`AssociateNetworkSettingsInput`](crate::input::AssociateNetworkSettingsInput)
pub mod associate_network_settings_input {
    /// A builder for [`AssociateNetworkSettingsInput`](crate::input::AssociateNetworkSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
        pub(crate) network_settings_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_settings_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateNetworkSettingsInput`](crate::input::AssociateNetworkSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateNetworkSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateNetworkSettingsInput {
                portal_arn: self.portal_arn,
                network_settings_arn: self.network_settings_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateNetworkSettingsInputOperationOutputAlias =
    crate::operation::AssociateNetworkSettings;
#[doc(hidden)]
pub type AssociateNetworkSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateNetworkSettingsInput {
    /// Consumes the builder and constructs an Operation<[`AssociateNetworkSettings`](crate::operation::AssociateNetworkSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateNetworkSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateNetworkSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.portal_arn;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_3, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/portals/{portalArn}/networkSettings",
                portalArn = portal_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::AssociateNetworkSettingsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_4) = &_input.network_settings_arn {
                query.push_kv(
                    "networkSettingsArn",
                    &aws_smithy_http::query::fmt_string(&inner_4),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateNetworkSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateNetworkSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateNetworkSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateNetworkSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateNetworkSettingsInput`](crate::input::AssociateNetworkSettingsInput)
    pub fn builder() -> crate::input::associate_network_settings_input::Builder {
        crate::input::associate_network_settings_input::Builder::default()
    }
}

/// See [`AssociateTrustStoreInput`](crate::input::AssociateTrustStoreInput)
pub mod associate_trust_store_input {
    /// A builder for [`AssociateTrustStoreInput`](crate::input::AssociateTrustStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
        pub(crate) trust_store_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_store_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTrustStoreInput`](crate::input::AssociateTrustStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateTrustStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateTrustStoreInput {
                portal_arn: self.portal_arn,
                trust_store_arn: self.trust_store_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateTrustStoreInputOperationOutputAlias = crate::operation::AssociateTrustStore;
#[doc(hidden)]
pub type AssociateTrustStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateTrustStoreInput {
    /// Consumes the builder and constructs an Operation<[`AssociateTrustStore`](crate::operation::AssociateTrustStore)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateTrustStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateTrustStoreInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.portal_arn;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_5, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/portals/{portalArn}/trustStores",
                portalArn = portal_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::AssociateTrustStoreInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.trust_store_arn {
                query.push_kv(
                    "trustStoreArn",
                    &aws_smithy_http::query::fmt_string(&inner_6),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateTrustStoreInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateTrustStoreInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateTrustStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateTrustStore",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateTrustStoreInput`](crate::input::AssociateTrustStoreInput)
    pub fn builder() -> crate::input::associate_trust_store_input::Builder {
        crate::input::associate_trust_store_input::Builder::default()
    }
}

/// See [`AssociateUserSettingsInput`](crate::input::AssociateUserSettingsInput)
pub mod associate_user_settings_input {
    /// A builder for [`AssociateUserSettingsInput`](crate::input::AssociateUserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
        pub(crate) user_settings_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_settings_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateUserSettingsInput`](crate::input::AssociateUserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateUserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateUserSettingsInput {
                portal_arn: self.portal_arn,
                user_settings_arn: self.user_settings_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateUserSettingsInputOperationOutputAlias = crate::operation::AssociateUserSettings;
#[doc(hidden)]
pub type AssociateUserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateUserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`AssociateUserSettings`](crate::operation::AssociateUserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateUserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateUserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.portal_arn;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_7, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/portals/{portalArn}/userSettings",
                portalArn = portal_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::AssociateUserSettingsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_8) = &_input.user_settings_arn {
                query.push_kv(
                    "userSettingsArn",
                    &aws_smithy_http::query::fmt_string(&inner_8),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateUserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateUserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateUserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateUserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateUserSettingsInput`](crate::input::AssociateUserSettingsInput)
    pub fn builder() -> crate::input::associate_user_settings_input::Builder {
        crate::input::associate_user_settings_input::Builder::default()
    }
}

/// See [`CreateBrowserSettingsInput`](crate::input::CreateBrowserSettingsInput)
pub mod create_browser_settings_input {
    /// A builder for [`CreateBrowserSettingsInput`](crate::input::CreateBrowserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) customer_managed_key: std::option::Option<std::string::String>,
        pub(crate) additional_encryption_context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) browser_policy: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the browser settings resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the browser settings resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The custom managed key of the browser settings.</p>
        pub fn customer_managed_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_managed_key = Some(input.into());
            self
        }
        /// <p>The custom managed key of the browser settings.</p>
        pub fn set_customer_managed_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_managed_key = input;
            self
        }
        /// Adds a key-value pair to `additional_encryption_context`.
        ///
        /// To override the contents of this collection use [`set_additional_encryption_context`](Self::set_additional_encryption_context).
        ///
        /// <p>Additional encryption context of the browser settings.</p>
        pub fn additional_encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.additional_encryption_context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.additional_encryption_context = Some(hash_map);
            self
        }
        /// <p>Additional encryption context of the browser settings.</p>
        pub fn set_additional_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.additional_encryption_context = input;
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.</p>
        pub fn browser_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_policy = Some(input.into());
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.</p>
        pub fn set_browser_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_policy = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBrowserSettingsInput`](crate::input::CreateBrowserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBrowserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBrowserSettingsInput {
                tags: self.tags,
                customer_managed_key: self.customer_managed_key,
                additional_encryption_context: self.additional_encryption_context,
                browser_policy: self.browser_policy,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBrowserSettingsInputOperationOutputAlias = crate::operation::CreateBrowserSettings;
#[doc(hidden)]
pub type CreateBrowserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBrowserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`CreateBrowserSettings`](crate::operation::CreateBrowserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBrowserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBrowserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/browserSettings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBrowserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBrowserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_browser_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBrowserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBrowserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBrowserSettingsInput`](crate::input::CreateBrowserSettingsInput)
    pub fn builder() -> crate::input::create_browser_settings_input::Builder {
        crate::input::create_browser_settings_input::Builder::default()
    }
}

/// See [`CreateIdentityProviderInput`](crate::input::CreateIdentityProviderInput)
pub mod create_identity_provider_input {
    /// A builder for [`CreateIdentityProviderInput`](crate::input::CreateIdentityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
        pub(crate) identity_provider_name: std::option::Option<std::string::String>,
        pub(crate) identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
        pub(crate) identity_provider_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// <p>The identity provider name.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_name = Some(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_name = input;
            self
        }
        /// <p>The identity provider type.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider_type = Some(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider_type = input;
            self
        }
        /// Adds a key-value pair to `identity_provider_details`.
        ///
        /// To override the contents of this collection use [`set_identity_provider_details`](Self::set_identity_provider_details).
        ///
        /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type. </p>
        /// <ul>
        /// <li> <p>For Google and Login with Amazon:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For Facebook:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// <li> <p> <code>api_version</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For Sign in with Apple:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>team_id</code> </p> </li>
        /// <li> <p> <code>key_id</code> </p> </li>
        /// <li> <p> <code>private_key</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For OIDC providers:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>attributes_request_method</code> </p> </li>
        /// <li> <p> <code>oidc_issuer</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// <li> <p> <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// </ul> </li>
        /// <li> <p>For SAML providers:</p>
        /// <ul>
        /// <li> <p> <code>MetadataFile</code> OR <code>MetadataURL</code> </p> </li>
        /// <li> <p> <code>IDPSignout</code> <i>optional</i> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn identity_provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identity_provider_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.identity_provider_details = Some(hash_map);
            self
        }
        /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type. </p>
        /// <ul>
        /// <li> <p>For Google and Login with Amazon:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For Facebook:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// <li> <p> <code>api_version</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For Sign in with Apple:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>team_id</code> </p> </li>
        /// <li> <p> <code>key_id</code> </p> </li>
        /// <li> <p> <code>private_key</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>For OIDC providers:</p>
        /// <ul>
        /// <li> <p> <code>client_id</code> </p> </li>
        /// <li> <p> <code>client_secret</code> </p> </li>
        /// <li> <p> <code>attributes_request_method</code> </p> </li>
        /// <li> <p> <code>oidc_issuer</code> </p> </li>
        /// <li> <p> <code>authorize_scopes</code> </p> </li>
        /// <li> <p> <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// <li> <p> <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
        /// </ul> </li>
        /// <li> <p>For SAML providers:</p>
        /// <ul>
        /// <li> <p> <code>MetadataFile</code> OR <code>MetadataURL</code> </p> </li>
        /// <li> <p> <code>IDPSignout</code> <i>optional</i> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.identity_provider_details = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIdentityProviderInput`](crate::input::CreateIdentityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIdentityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIdentityProviderInput {
                portal_arn: self.portal_arn,
                identity_provider_name: self.identity_provider_name,
                identity_provider_type: self.identity_provider_type,
                identity_provider_details: self.identity_provider_details,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIdentityProviderInputOperationOutputAlias = crate::operation::CreateIdentityProvider;
#[doc(hidden)]
pub type CreateIdentityProviderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIdentityProviderInput {
    /// Consumes the builder and constructs an Operation<[`CreateIdentityProvider`](crate::operation::CreateIdentityProvider)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIdentityProvider,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIdentityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/identityProviders").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIdentityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIdentityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_identity_provider(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIdentityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIdentityProvider",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIdentityProviderInput`](crate::input::CreateIdentityProviderInput)
    pub fn builder() -> crate::input::create_identity_provider_input::Builder {
        crate::input::create_identity_provider_input::Builder::default()
    }
}

/// See [`CreateNetworkSettingsInput`](crate::input::CreateNetworkSettingsInput)
pub mod create_network_settings_input {
    /// A builder for [`CreateNetworkSettingsInput`](crate::input::CreateNetworkSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the network settings resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the network settings resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkSettingsInput`](crate::input::CreateNetworkSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNetworkSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNetworkSettingsInput {
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNetworkSettingsInputOperationOutputAlias = crate::operation::CreateNetworkSettings;
#[doc(hidden)]
pub type CreateNetworkSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateNetworkSettingsInput {
    /// Consumes the builder and constructs an Operation<[`CreateNetworkSettings`](crate::operation::CreateNetworkSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNetworkSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNetworkSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/networkSettings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNetworkSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNetworkSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_network_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNetworkSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNetworkSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNetworkSettingsInput`](crate::input::CreateNetworkSettingsInput)
    pub fn builder() -> crate::input::create_network_settings_input::Builder {
        crate::input::create_network_settings_input::Builder::default()
    }
}

/// See [`CreatePortalInput`](crate::input::CreatePortalInput)
pub mod create_portal_input {
    /// A builder for [`CreatePortalInput`](crate::input::CreatePortalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) customer_managed_key: std::option::Option<std::string::String>,
        pub(crate) additional_encryption_context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the web portal. A tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the web portal. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The customer managed key of the web portal.</p>
        pub fn customer_managed_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_managed_key = Some(input.into());
            self
        }
        /// <p>The customer managed key of the web portal.</p>
        pub fn set_customer_managed_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_managed_key = input;
            self
        }
        /// Adds a key-value pair to `additional_encryption_context`.
        ///
        /// To override the contents of this collection use [`set_additional_encryption_context`](Self::set_additional_encryption_context).
        ///
        /// <p>The additional encryption context of the portal.</p>
        pub fn additional_encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.additional_encryption_context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.additional_encryption_context = Some(hash_map);
            self
        }
        /// <p>The additional encryption context of the portal.</p>
        pub fn set_additional_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.additional_encryption_context = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePortalInput`](crate::input::CreatePortalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePortalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePortalInput {
                display_name: self.display_name,
                tags: self.tags,
                customer_managed_key: self.customer_managed_key,
                additional_encryption_context: self.additional_encryption_context,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePortalInputOperationOutputAlias = crate::operation::CreatePortal;
#[doc(hidden)]
pub type CreatePortalInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePortalInput {
    /// Consumes the builder and constructs an Operation<[`CreatePortal`](crate::operation::CreatePortal)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePortal,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePortalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/portals").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePortalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePortalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_portal(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePortal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePortal",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePortalInput`](crate::input::CreatePortalInput)
    pub fn builder() -> crate::input::create_portal_input::Builder {
        crate::input::create_portal_input::Builder::default()
    }
}

/// See [`CreateTrustStoreInput`](crate::input::CreateTrustStoreInput)
pub mod create_trust_store_input {
    /// A builder for [`CreateTrustStoreInput`](crate::input::CreateTrustStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_list: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `certificate_list`.
        ///
        /// To override the contents of this collection use [`set_certificate_list`](Self::set_certificate_list).
        ///
        /// <p>A list of CA certificates to be added to the trust store.</p>
        pub fn certificate_list(mut self, input: aws_smithy_types::Blob) -> Self {
            let mut v = self.certificate_list.unwrap_or_default();
            v.push(input);
            self.certificate_list = Some(v);
            self
        }
        /// <p>A list of CA certificates to be added to the trust store.</p>
        pub fn set_certificate_list(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        ) -> Self {
            self.certificate_list = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the trust store. A tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the trust store. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrustStoreInput`](crate::input::CreateTrustStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrustStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrustStoreInput {
                certificate_list: self.certificate_list,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrustStoreInputOperationOutputAlias = crate::operation::CreateTrustStore;
#[doc(hidden)]
pub type CreateTrustStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTrustStoreInput {
    /// Consumes the builder and constructs an Operation<[`CreateTrustStore`](crate::operation::CreateTrustStore)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTrustStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTrustStoreInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/trustStores").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTrustStoreInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTrustStoreInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_trust_store(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTrustStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTrustStore",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTrustStoreInput`](crate::input::CreateTrustStoreInput)
    pub fn builder() -> crate::input::create_trust_store_input::Builder {
        crate::input::create_trust_store_input::Builder::default()
    }
}

/// See [`CreateUserSettingsInput`](crate::input::CreateUserSettingsInput)
pub mod create_user_settings_input {
    /// A builder for [`CreateUserSettingsInput`](crate::input::CreateUserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) copy_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) paste_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) download_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) upload_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) print_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
        pub fn copy_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.copy_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
        pub fn set_copy_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.copy_allowed = input;
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
        pub fn paste_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.paste_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
        pub fn set_paste_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.paste_allowed = input;
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
        pub fn download_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.download_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
        pub fn set_download_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.download_allowed = input;
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
        pub fn upload_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.upload_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
        pub fn set_upload_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.upload_allowed = input;
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn print_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.print_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn set_print_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.print_allowed = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the user settings resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the user settings resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserSettingsInput`](crate::input::CreateUserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserSettingsInput {
                copy_allowed: self.copy_allowed,
                paste_allowed: self.paste_allowed,
                download_allowed: self.download_allowed,
                upload_allowed: self.upload_allowed,
                print_allowed: self.print_allowed,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserSettingsInputOperationOutputAlias = crate::operation::CreateUserSettings;
#[doc(hidden)]
pub type CreateUserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`CreateUserSettings`](crate::operation::CreateUserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/userSettings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_user_settings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserSettingsInput`](crate::input::CreateUserSettingsInput)
    pub fn builder() -> crate::input::create_user_settings_input::Builder {
        crate::input::create_user_settings_input::Builder::default()
    }
}

/// See [`DeleteBrowserSettingsInput`](crate::input::DeleteBrowserSettingsInput)
pub mod delete_browser_settings_input {
    /// A builder for [`DeleteBrowserSettingsInput`](crate::input::DeleteBrowserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) browser_settings_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_settings_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBrowserSettingsInput`](crate::input::DeleteBrowserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBrowserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBrowserSettingsInput {
                browser_settings_arn: self.browser_settings_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBrowserSettingsInputOperationOutputAlias = crate::operation::DeleteBrowserSettings;
#[doc(hidden)]
pub type DeleteBrowserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBrowserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBrowserSettings`](crate::operation::DeleteBrowserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBrowserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBrowserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.browser_settings_arn;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "browser_settings_arn",
                        details: "cannot be empty or unset",
                    })?;
            let browser_settings_arn = aws_smithy_http::label::fmt_string(input_9, true);
            if browser_settings_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "browser_settings_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/browserSettings/{browserSettingsArn}",
                browserSettingsArn = browser_settings_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBrowserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBrowserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBrowserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBrowserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBrowserSettingsInput`](crate::input::DeleteBrowserSettingsInput)
    pub fn builder() -> crate::input::delete_browser_settings_input::Builder {
        crate::input::delete_browser_settings_input::Builder::default()
    }
}

/// See [`DeleteIdentityProviderInput`](crate::input::DeleteIdentityProviderInput)
pub mod delete_identity_provider_input {
    /// A builder for [`DeleteIdentityProviderInput`](crate::input::DeleteIdentityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIdentityProviderInput`](crate::input::DeleteIdentityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIdentityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIdentityProviderInput {
                identity_provider_arn: self.identity_provider_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIdentityProviderInputOperationOutputAlias = crate::operation::DeleteIdentityProvider;
#[doc(hidden)]
pub type DeleteIdentityProviderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteIdentityProviderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIdentityProvider`](crate::operation::DeleteIdentityProvider)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIdentityProvider,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIdentityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.identity_provider_arn;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_provider_arn",
                        details: "cannot be empty or unset",
                    })?;
            let identity_provider_arn = aws_smithy_http::label::fmt_string(input_10, true);
            if identity_provider_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_provider_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identityProviders/{identityProviderArn}",
                identityProviderArn = identity_provider_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIdentityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIdentityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIdentityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIdentityProvider",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIdentityProviderInput`](crate::input::DeleteIdentityProviderInput)
    pub fn builder() -> crate::input::delete_identity_provider_input::Builder {
        crate::input::delete_identity_provider_input::Builder::default()
    }
}

/// See [`DeleteNetworkSettingsInput`](crate::input::DeleteNetworkSettingsInput)
pub mod delete_network_settings_input {
    /// A builder for [`DeleteNetworkSettingsInput`](crate::input::DeleteNetworkSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_settings_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_settings_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNetworkSettingsInput`](crate::input::DeleteNetworkSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNetworkSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNetworkSettingsInput {
                network_settings_arn: self.network_settings_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNetworkSettingsInputOperationOutputAlias = crate::operation::DeleteNetworkSettings;
#[doc(hidden)]
pub type DeleteNetworkSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteNetworkSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNetworkSettings`](crate::operation::DeleteNetworkSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNetworkSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNetworkSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.network_settings_arn;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_settings_arn",
                        details: "cannot be empty or unset",
                    })?;
            let network_settings_arn = aws_smithy_http::label::fmt_string(input_11, true);
            if network_settings_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "network_settings_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/networkSettings/{networkSettingsArn}",
                networkSettingsArn = network_settings_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNetworkSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNetworkSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNetworkSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNetworkSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNetworkSettingsInput`](crate::input::DeleteNetworkSettingsInput)
    pub fn builder() -> crate::input::delete_network_settings_input::Builder {
        crate::input::delete_network_settings_input::Builder::default()
    }
}

/// See [`DeletePortalInput`](crate::input::DeletePortalInput)
pub mod delete_portal_input {
    /// A builder for [`DeletePortalInput`](crate::input::DeletePortalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePortalInput`](crate::input::DeletePortalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePortalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePortalInput {
                portal_arn: self.portal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePortalInputOperationOutputAlias = crate::operation::DeletePortal;
#[doc(hidden)]
pub type DeletePortalInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePortalInput {
    /// Consumes the builder and constructs an Operation<[`DeletePortal`](crate::operation::DeletePortal)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePortal,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePortalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.portal_arn;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_12, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/portals/{portalArn}", portalArn = portal_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePortalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePortalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePortal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePortal",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePortalInput`](crate::input::DeletePortalInput)
    pub fn builder() -> crate::input::delete_portal_input::Builder {
        crate::input::delete_portal_input::Builder::default()
    }
}

/// See [`DeleteTrustStoreInput`](crate::input::DeleteTrustStoreInput)
pub mod delete_trust_store_input {
    /// A builder for [`DeleteTrustStoreInput`](crate::input::DeleteTrustStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_store_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_store_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTrustStoreInput`](crate::input::DeleteTrustStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTrustStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTrustStoreInput {
                trust_store_arn: self.trust_store_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTrustStoreInputOperationOutputAlias = crate::operation::DeleteTrustStore;
#[doc(hidden)]
pub type DeleteTrustStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTrustStoreInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTrustStore`](crate::operation::DeleteTrustStore)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTrustStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTrustStoreInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.trust_store_arn;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "trust_store_arn",
                        details: "cannot be empty or unset",
                    })?;
            let trust_store_arn = aws_smithy_http::label::fmt_string(input_13, true);
            if trust_store_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "trust_store_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/trustStores/{trustStoreArn}",
                trustStoreArn = trust_store_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTrustStoreInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTrustStoreInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTrustStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTrustStore",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTrustStoreInput`](crate::input::DeleteTrustStoreInput)
    pub fn builder() -> crate::input::delete_trust_store_input::Builder {
        crate::input::delete_trust_store_input::Builder::default()
    }
}

/// See [`DeleteUserSettingsInput`](crate::input::DeleteUserSettingsInput)
pub mod delete_user_settings_input {
    /// A builder for [`DeleteUserSettingsInput`](crate::input::DeleteUserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_settings_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_settings_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserSettingsInput`](crate::input::DeleteUserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserSettingsInput {
                user_settings_arn: self.user_settings_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserSettingsInputOperationOutputAlias = crate::operation::DeleteUserSettings;
#[doc(hidden)]
pub type DeleteUserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserSettings`](crate::operation::DeleteUserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.user_settings_arn;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_settings_arn",
                        details: "cannot be empty or unset",
                    })?;
            let user_settings_arn = aws_smithy_http::label::fmt_string(input_14, true);
            if user_settings_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_settings_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/userSettings/{userSettingsArn}",
                userSettingsArn = user_settings_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserSettingsInput`](crate::input::DeleteUserSettingsInput)
    pub fn builder() -> crate::input::delete_user_settings_input::Builder {
        crate::input::delete_user_settings_input::Builder::default()
    }
}

/// See [`DisassociateBrowserSettingsInput`](crate::input::DisassociateBrowserSettingsInput)
pub mod disassociate_browser_settings_input {
    /// A builder for [`DisassociateBrowserSettingsInput`](crate::input::DisassociateBrowserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateBrowserSettingsInput`](crate::input::DisassociateBrowserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateBrowserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateBrowserSettingsInput {
                portal_arn: self.portal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateBrowserSettingsInputOperationOutputAlias =
    crate::operation::DisassociateBrowserSettings;
#[doc(hidden)]
pub type DisassociateBrowserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateBrowserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateBrowserSettings`](crate::operation::DisassociateBrowserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateBrowserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateBrowserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.portal_arn;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_15, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/portals/{portalArn}/browserSettings",
                portalArn = portal_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateBrowserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateBrowserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateBrowserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateBrowserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateBrowserSettingsInput`](crate::input::DisassociateBrowserSettingsInput)
    pub fn builder() -> crate::input::disassociate_browser_settings_input::Builder {
        crate::input::disassociate_browser_settings_input::Builder::default()
    }
}

/// See [`DisassociateNetworkSettingsInput`](crate::input::DisassociateNetworkSettingsInput)
pub mod disassociate_network_settings_input {
    /// A builder for [`DisassociateNetworkSettingsInput`](crate::input::DisassociateNetworkSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateNetworkSettingsInput`](crate::input::DisassociateNetworkSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateNetworkSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateNetworkSettingsInput {
                portal_arn: self.portal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateNetworkSettingsInputOperationOutputAlias =
    crate::operation::DisassociateNetworkSettings;
#[doc(hidden)]
pub type DisassociateNetworkSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateNetworkSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateNetworkSettings`](crate::operation::DisassociateNetworkSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateNetworkSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateNetworkSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.portal_arn;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_16, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/portals/{portalArn}/networkSettings",
                portalArn = portal_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateNetworkSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateNetworkSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateNetworkSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateNetworkSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateNetworkSettingsInput`](crate::input::DisassociateNetworkSettingsInput)
    pub fn builder() -> crate::input::disassociate_network_settings_input::Builder {
        crate::input::disassociate_network_settings_input::Builder::default()
    }
}

/// See [`DisassociateTrustStoreInput`](crate::input::DisassociateTrustStoreInput)
pub mod disassociate_trust_store_input {
    /// A builder for [`DisassociateTrustStoreInput`](crate::input::DisassociateTrustStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateTrustStoreInput`](crate::input::DisassociateTrustStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateTrustStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateTrustStoreInput {
                portal_arn: self.portal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateTrustStoreInputOperationOutputAlias = crate::operation::DisassociateTrustStore;
#[doc(hidden)]
pub type DisassociateTrustStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateTrustStoreInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateTrustStore`](crate::operation::DisassociateTrustStore)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateTrustStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateTrustStoreInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.portal_arn;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_17, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/portals/{portalArn}/trustStores",
                portalArn = portal_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateTrustStoreInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateTrustStoreInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateTrustStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateTrustStore",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateTrustStoreInput`](crate::input::DisassociateTrustStoreInput)
    pub fn builder() -> crate::input::disassociate_trust_store_input::Builder {
        crate::input::disassociate_trust_store_input::Builder::default()
    }
}

/// See [`DisassociateUserSettingsInput`](crate::input::DisassociateUserSettingsInput)
pub mod disassociate_user_settings_input {
    /// A builder for [`DisassociateUserSettingsInput`](crate::input::DisassociateUserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateUserSettingsInput`](crate::input::DisassociateUserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateUserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateUserSettingsInput {
                portal_arn: self.portal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateUserSettingsInputOperationOutputAlias =
    crate::operation::DisassociateUserSettings;
#[doc(hidden)]
pub type DisassociateUserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateUserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateUserSettings`](crate::operation::DisassociateUserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateUserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateUserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.portal_arn;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_18, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/portals/{portalArn}/userSettings",
                portalArn = portal_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateUserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateUserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateUserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateUserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateUserSettingsInput`](crate::input::DisassociateUserSettingsInput)
    pub fn builder() -> crate::input::disassociate_user_settings_input::Builder {
        crate::input::disassociate_user_settings_input::Builder::default()
    }
}

/// See [`GetBrowserSettingsInput`](crate::input::GetBrowserSettingsInput)
pub mod get_browser_settings_input {
    /// A builder for [`GetBrowserSettingsInput`](crate::input::GetBrowserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) browser_settings_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_settings_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBrowserSettingsInput`](crate::input::GetBrowserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBrowserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBrowserSettingsInput {
                browser_settings_arn: self.browser_settings_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBrowserSettingsInputOperationOutputAlias = crate::operation::GetBrowserSettings;
#[doc(hidden)]
pub type GetBrowserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBrowserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetBrowserSettings`](crate::operation::GetBrowserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBrowserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBrowserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.browser_settings_arn;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "browser_settings_arn",
                        details: "cannot be empty or unset",
                    })?;
            let browser_settings_arn = aws_smithy_http::label::fmt_string(input_19, true);
            if browser_settings_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "browser_settings_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/browserSettings/{browserSettingsArn}",
                browserSettingsArn = browser_settings_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBrowserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBrowserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBrowserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBrowserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBrowserSettingsInput`](crate::input::GetBrowserSettingsInput)
    pub fn builder() -> crate::input::get_browser_settings_input::Builder {
        crate::input::get_browser_settings_input::Builder::default()
    }
}

/// See [`GetIdentityProviderInput`](crate::input::GetIdentityProviderInput)
pub mod get_identity_provider_input {
    /// A builder for [`GetIdentityProviderInput`](crate::input::GetIdentityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityProviderInput`](crate::input::GetIdentityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIdentityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIdentityProviderInput {
                identity_provider_arn: self.identity_provider_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdentityProviderInputOperationOutputAlias = crate::operation::GetIdentityProvider;
#[doc(hidden)]
pub type GetIdentityProviderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetIdentityProviderInput {
    /// Consumes the builder and constructs an Operation<[`GetIdentityProvider`](crate::operation::GetIdentityProvider)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIdentityProvider,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIdentityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.identity_provider_arn;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_provider_arn",
                        details: "cannot be empty or unset",
                    })?;
            let identity_provider_arn = aws_smithy_http::label::fmt_string(input_20, true);
            if identity_provider_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_provider_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identityProviders/{identityProviderArn}",
                identityProviderArn = identity_provider_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIdentityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIdentityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIdentityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIdentityProvider",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIdentityProviderInput`](crate::input::GetIdentityProviderInput)
    pub fn builder() -> crate::input::get_identity_provider_input::Builder {
        crate::input::get_identity_provider_input::Builder::default()
    }
}

/// See [`GetNetworkSettingsInput`](crate::input::GetNetworkSettingsInput)
pub mod get_network_settings_input {
    /// A builder for [`GetNetworkSettingsInput`](crate::input::GetNetworkSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_settings_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_settings_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkSettingsInput`](crate::input::GetNetworkSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetNetworkSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetNetworkSettingsInput {
                network_settings_arn: self.network_settings_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetNetworkSettingsInputOperationOutputAlias = crate::operation::GetNetworkSettings;
#[doc(hidden)]
pub type GetNetworkSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetNetworkSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetNetworkSettings`](crate::operation::GetNetworkSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetNetworkSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetNetworkSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.network_settings_arn;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_settings_arn",
                        details: "cannot be empty or unset",
                    })?;
            let network_settings_arn = aws_smithy_http::label::fmt_string(input_21, true);
            if network_settings_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "network_settings_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/networkSettings/{networkSettingsArn}",
                networkSettingsArn = network_settings_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetNetworkSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetNetworkSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetNetworkSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetNetworkSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetNetworkSettingsInput`](crate::input::GetNetworkSettingsInput)
    pub fn builder() -> crate::input::get_network_settings_input::Builder {
        crate::input::get_network_settings_input::Builder::default()
    }
}

/// See [`GetPortalInput`](crate::input::GetPortalInput)
pub mod get_portal_input {
    /// A builder for [`GetPortalInput`](crate::input::GetPortalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPortalInput`](crate::input::GetPortalInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetPortalInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetPortalInput {
                portal_arn: self.portal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPortalInputOperationOutputAlias = crate::operation::GetPortal;
#[doc(hidden)]
pub type GetPortalInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPortalInput {
    /// Consumes the builder and constructs an Operation<[`GetPortal`](crate::operation::GetPortal)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPortal,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPortalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.portal_arn;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_22, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/portals/{portalArn}", portalArn = portal_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPortalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPortalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetPortal::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetPortal",
                    "workspacesweb",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPortalInput`](crate::input::GetPortalInput)
    pub fn builder() -> crate::input::get_portal_input::Builder {
        crate::input::get_portal_input::Builder::default()
    }
}

/// See [`GetPortalServiceProviderMetadataInput`](crate::input::GetPortalServiceProviderMetadataInput)
pub mod get_portal_service_provider_metadata_input {
    /// A builder for [`GetPortalServiceProviderMetadataInput`](crate::input::GetPortalServiceProviderMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPortalServiceProviderMetadataInput`](crate::input::GetPortalServiceProviderMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPortalServiceProviderMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPortalServiceProviderMetadataInput {
                portal_arn: self.portal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPortalServiceProviderMetadataInputOperationOutputAlias =
    crate::operation::GetPortalServiceProviderMetadata;
#[doc(hidden)]
pub type GetPortalServiceProviderMetadataInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetPortalServiceProviderMetadataInput {
    /// Consumes the builder and constructs an Operation<[`GetPortalServiceProviderMetadata`](crate::operation::GetPortalServiceProviderMetadata)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPortalServiceProviderMetadata,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPortalServiceProviderMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.portal_arn;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_23, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/portalIdp/{portalArn}", portalArn = portal_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPortalServiceProviderMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPortalServiceProviderMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPortalServiceProviderMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPortalServiceProviderMetadata",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPortalServiceProviderMetadataInput`](crate::input::GetPortalServiceProviderMetadataInput)
    pub fn builder() -> crate::input::get_portal_service_provider_metadata_input::Builder {
        crate::input::get_portal_service_provider_metadata_input::Builder::default()
    }
}

/// See [`GetTrustStoreInput`](crate::input::GetTrustStoreInput)
pub mod get_trust_store_input {
    /// A builder for [`GetTrustStoreInput`](crate::input::GetTrustStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_store_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_store_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrustStoreInput`](crate::input::GetTrustStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTrustStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTrustStoreInput {
                trust_store_arn: self.trust_store_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTrustStoreInputOperationOutputAlias = crate::operation::GetTrustStore;
#[doc(hidden)]
pub type GetTrustStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTrustStoreInput {
    /// Consumes the builder and constructs an Operation<[`GetTrustStore`](crate::operation::GetTrustStore)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTrustStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTrustStoreInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.trust_store_arn;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "trust_store_arn",
                        details: "cannot be empty or unset",
                    })?;
            let trust_store_arn = aws_smithy_http::label::fmt_string(input_24, true);
            if trust_store_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "trust_store_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/trustStores/{trustStoreArn}",
                trustStoreArn = trust_store_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTrustStoreInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTrustStoreInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTrustStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTrustStore",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTrustStoreInput`](crate::input::GetTrustStoreInput)
    pub fn builder() -> crate::input::get_trust_store_input::Builder {
        crate::input::get_trust_store_input::Builder::default()
    }
}

/// See [`GetTrustStoreCertificateInput`](crate::input::GetTrustStoreCertificateInput)
pub mod get_trust_store_certificate_input {
    /// A builder for [`GetTrustStoreCertificateInput`](crate::input::GetTrustStoreCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_store_arn: std::option::Option<std::string::String>,
        pub(crate) thumbprint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the trust store certificate.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust store certificate.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_store_arn = input;
            self
        }
        /// <p>The thumbprint of the trust store certificate.</p>
        pub fn thumbprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.thumbprint = Some(input.into());
            self
        }
        /// <p>The thumbprint of the trust store certificate.</p>
        pub fn set_thumbprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thumbprint = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrustStoreCertificateInput`](crate::input::GetTrustStoreCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTrustStoreCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTrustStoreCertificateInput {
                trust_store_arn: self.trust_store_arn,
                thumbprint: self.thumbprint,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTrustStoreCertificateInputOperationOutputAlias =
    crate::operation::GetTrustStoreCertificate;
#[doc(hidden)]
pub type GetTrustStoreCertificateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTrustStoreCertificateInput {
    /// Consumes the builder and constructs an Operation<[`GetTrustStoreCertificate`](crate::operation::GetTrustStoreCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTrustStoreCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTrustStoreCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.trust_store_arn;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "trust_store_arn",
                        details: "cannot be empty or unset",
                    })?;
            let trust_store_arn = aws_smithy_http::label::fmt_string(input_25, true);
            if trust_store_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "trust_store_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/trustStores/{trustStoreArn}/certificate",
                trustStoreArn = trust_store_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetTrustStoreCertificateInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_26) = &_input.thumbprint {
                query.push_kv("thumbprint", &aws_smithy_http::query::fmt_string(&inner_26));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTrustStoreCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTrustStoreCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTrustStoreCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTrustStoreCertificate",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTrustStoreCertificateInput`](crate::input::GetTrustStoreCertificateInput)
    pub fn builder() -> crate::input::get_trust_store_certificate_input::Builder {
        crate::input::get_trust_store_certificate_input::Builder::default()
    }
}

/// See [`GetUserSettingsInput`](crate::input::GetUserSettingsInput)
pub mod get_user_settings_input {
    /// A builder for [`GetUserSettingsInput`](crate::input::GetUserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_settings_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_settings_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserSettingsInput`](crate::input::GetUserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUserSettingsInput {
                user_settings_arn: self.user_settings_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUserSettingsInputOperationOutputAlias = crate::operation::GetUserSettings;
#[doc(hidden)]
pub type GetUserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetUserSettings`](crate::operation::GetUserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.user_settings_arn;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_settings_arn",
                        details: "cannot be empty or unset",
                    })?;
            let user_settings_arn = aws_smithy_http::label::fmt_string(input_27, true);
            if user_settings_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_settings_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/userSettings/{userSettingsArn}",
                userSettingsArn = user_settings_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUserSettingsInput`](crate::input::GetUserSettingsInput)
    pub fn builder() -> crate::input::get_user_settings_input::Builder {
        crate::input::get_user_settings_input::Builder::default()
    }
}

/// See [`ListBrowserSettingsInput`](crate::input::ListBrowserSettingsInput)
pub mod list_browser_settings_input {
    /// A builder for [`ListBrowserSettingsInput`](crate::input::ListBrowserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBrowserSettingsInput`](crate::input::ListBrowserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBrowserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBrowserSettingsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBrowserSettingsInputOperationOutputAlias = crate::operation::ListBrowserSettings;
#[doc(hidden)]
pub type ListBrowserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBrowserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`ListBrowserSettings`](crate::operation::ListBrowserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBrowserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBrowserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/browserSettings").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBrowserSettingsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_28) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_28));
            }
            if let Some(inner_29) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_29).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBrowserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBrowserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBrowserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBrowserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBrowserSettingsInput`](crate::input::ListBrowserSettingsInput)
    pub fn builder() -> crate::input::list_browser_settings_input::Builder {
        crate::input::list_browser_settings_input::Builder::default()
    }
}

/// See [`ListIdentityProvidersInput`](crate::input::ListIdentityProvidersInput)
pub mod list_identity_providers_input {
    /// A builder for [`ListIdentityProvidersInput`](crate::input::ListIdentityProvidersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) portal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentityProvidersInput`](crate::input::ListIdentityProvidersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIdentityProvidersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIdentityProvidersInput {
                next_token: self.next_token,
                max_results: self.max_results,
                portal_arn: self.portal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIdentityProvidersInputOperationOutputAlias = crate::operation::ListIdentityProviders;
#[doc(hidden)]
pub type ListIdentityProvidersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIdentityProvidersInput {
    /// Consumes the builder and constructs an Operation<[`ListIdentityProviders`](crate::operation::ListIdentityProviders)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIdentityProviders,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIdentityProvidersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.portal_arn;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_30, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/portals/{portalArn}/identityProviders",
                portalArn = portal_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListIdentityProvidersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_31) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_31));
            }
            if let Some(inner_32) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_32).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIdentityProvidersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIdentityProvidersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIdentityProviders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIdentityProviders",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIdentityProvidersInput`](crate::input::ListIdentityProvidersInput)
    pub fn builder() -> crate::input::list_identity_providers_input::Builder {
        crate::input::list_identity_providers_input::Builder::default()
    }
}

/// See [`ListNetworkSettingsInput`](crate::input::ListNetworkSettingsInput)
pub mod list_network_settings_input {
    /// A builder for [`ListNetworkSettingsInput`](crate::input::ListNetworkSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNetworkSettingsInput`](crate::input::ListNetworkSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNetworkSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNetworkSettingsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListNetworkSettingsInputOperationOutputAlias = crate::operation::ListNetworkSettings;
#[doc(hidden)]
pub type ListNetworkSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListNetworkSettingsInput {
    /// Consumes the builder and constructs an Operation<[`ListNetworkSettings`](crate::operation::ListNetworkSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNetworkSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListNetworkSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/networkSettings").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListNetworkSettingsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_33) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_33));
            }
            if let Some(inner_34) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_34).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListNetworkSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListNetworkSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNetworkSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNetworkSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListNetworkSettingsInput`](crate::input::ListNetworkSettingsInput)
    pub fn builder() -> crate::input::list_network_settings_input::Builder {
        crate::input::list_network_settings_input::Builder::default()
    }
}

/// See [`ListPortalsInput`](crate::input::ListPortalsInput)
pub mod list_portals_input {
    /// A builder for [`ListPortalsInput`](crate::input::ListPortalsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPortalsInput`](crate::input::ListPortalsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPortalsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPortalsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPortalsInputOperationOutputAlias = crate::operation::ListPortals;
#[doc(hidden)]
pub type ListPortalsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPortalsInput {
    /// Consumes the builder and constructs an Operation<[`ListPortals`](crate::operation::ListPortals)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPortals,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPortalsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/portals").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPortalsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_35) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_35));
            }
            if let Some(inner_36) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_36).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPortalsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPortalsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPortals::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPortals",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPortalsInput`](crate::input::ListPortalsInput)
    pub fn builder() -> crate::input::list_portals_input::Builder {
        crate::input::list_portals_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.resource_arn;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_37, true);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTrustStoreCertificatesInput`](crate::input::ListTrustStoreCertificatesInput)
pub mod list_trust_store_certificates_input {
    /// A builder for [`ListTrustStoreCertificatesInput`](crate::input::ListTrustStoreCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_store_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the trust store</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust store</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_store_arn = input;
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrustStoreCertificatesInput`](crate::input::ListTrustStoreCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrustStoreCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrustStoreCertificatesInput {
                trust_store_arn: self.trust_store_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrustStoreCertificatesInputOperationOutputAlias =
    crate::operation::ListTrustStoreCertificates;
#[doc(hidden)]
pub type ListTrustStoreCertificatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTrustStoreCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`ListTrustStoreCertificates`](crate::operation::ListTrustStoreCertificates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrustStoreCertificates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTrustStoreCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.trust_store_arn;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "trust_store_arn",
                        details: "cannot be empty or unset",
                    })?;
            let trust_store_arn = aws_smithy_http::label::fmt_string(input_38, true);
            if trust_store_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "trust_store_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/trustStores/{trustStoreArn}/certificates",
                trustStoreArn = trust_store_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTrustStoreCertificatesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_39) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_39));
            }
            if let Some(inner_40) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_40).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTrustStoreCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTrustStoreCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrustStoreCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrustStoreCertificates",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTrustStoreCertificatesInput`](crate::input::ListTrustStoreCertificatesInput)
    pub fn builder() -> crate::input::list_trust_store_certificates_input::Builder {
        crate::input::list_trust_store_certificates_input::Builder::default()
    }
}

/// See [`ListTrustStoresInput`](crate::input::ListTrustStoresInput)
pub mod list_trust_stores_input {
    /// A builder for [`ListTrustStoresInput`](crate::input::ListTrustStoresInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrustStoresInput`](crate::input::ListTrustStoresInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrustStoresInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrustStoresInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrustStoresInputOperationOutputAlias = crate::operation::ListTrustStores;
#[doc(hidden)]
pub type ListTrustStoresInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTrustStoresInput {
    /// Consumes the builder and constructs an Operation<[`ListTrustStores`](crate::operation::ListTrustStores)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrustStores,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTrustStoresInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/trustStores").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTrustStoresInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_41) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_41));
            }
            if let Some(inner_42) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_42).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTrustStoresInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTrustStoresInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrustStores::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrustStores",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTrustStoresInput`](crate::input::ListTrustStoresInput)
    pub fn builder() -> crate::input::list_trust_stores_input::Builder {
        crate::input::list_trust_stores_input::Builder::default()
    }
}

/// See [`ListUserSettingsInput`](crate::input::ListUserSettingsInput)
pub mod list_user_settings_input {
    /// A builder for [`ListUserSettingsInput`](crate::input::ListUserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserSettingsInput`](crate::input::ListUserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUserSettingsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUserSettingsInputOperationOutputAlias = crate::operation::ListUserSettings;
#[doc(hidden)]
pub type ListUserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`ListUserSettings`](crate::operation::ListUserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/userSettings").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListUserSettingsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_43) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_43));
            }
            if let Some(inner_44) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_44).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUserSettingsInput`](crate::input::ListUserSettingsInput)
    pub fn builder() -> crate::input::list_user_settings_input::Builder {
        crate::input::list_user_settings_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags of the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_45 = &_input.resource_arn;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_45, true);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_46 = &_input.resource_arn;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_46, true);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_47) = &_input.tag_keys {
                for inner_48 in inner_47 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_48));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateBrowserSettingsInput`](crate::input::UpdateBrowserSettingsInput)
pub mod update_browser_settings_input {
    /// A builder for [`UpdateBrowserSettingsInput`](crate::input::UpdateBrowserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) browser_settings_arn: std::option::Option<std::string::String>,
        pub(crate) browser_policy: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_settings_arn = input;
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions. </p>
        pub fn browser_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_policy = Some(input.into());
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions. </p>
        pub fn set_browser_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_policy = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBrowserSettingsInput`](crate::input::UpdateBrowserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBrowserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBrowserSettingsInput {
                browser_settings_arn: self.browser_settings_arn,
                browser_policy: self.browser_policy,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBrowserSettingsInputOperationOutputAlias = crate::operation::UpdateBrowserSettings;
#[doc(hidden)]
pub type UpdateBrowserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBrowserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBrowserSettings`](crate::operation::UpdateBrowserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBrowserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBrowserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_49 = &_input.browser_settings_arn;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "browser_settings_arn",
                        details: "cannot be empty or unset",
                    })?;
            let browser_settings_arn = aws_smithy_http::label::fmt_string(input_49, true);
            if browser_settings_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "browser_settings_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/browserSettings/{browserSettingsArn}",
                browserSettingsArn = browser_settings_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBrowserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBrowserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_browser_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBrowserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBrowserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBrowserSettingsInput`](crate::input::UpdateBrowserSettingsInput)
    pub fn builder() -> crate::input::update_browser_settings_input::Builder {
        crate::input::update_browser_settings_input::Builder::default()
    }
}

/// See [`UpdateIdentityProviderInput`](crate::input::UpdateIdentityProviderInput)
pub mod update_identity_provider_input {
    /// A builder for [`UpdateIdentityProviderInput`](crate::input::UpdateIdentityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider_arn: std::option::Option<std::string::String>,
        pub(crate) identity_provider_name: std::option::Option<std::string::String>,
        pub(crate) identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
        pub(crate) identity_provider_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_arn = input;
            self
        }
        /// <p>The name of the identity provider.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_name = Some(input.into());
            self
        }
        /// <p>The name of the identity provider.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_name = input;
            self
        }
        /// <p>The type of the identity provider.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider_type = Some(input);
            self
        }
        /// <p>The type of the identity provider.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider_type = input;
            self
        }
        /// Adds a key-value pair to `identity_provider_details`.
        ///
        /// To override the contents of this collection use [`set_identity_provider_details`](Self::set_identity_provider_details).
        ///
        /// <p>The details of the identity provider.</p>
        pub fn identity_provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identity_provider_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.identity_provider_details = Some(hash_map);
            self
        }
        /// <p>The details of the identity provider.</p>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.identity_provider_details = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIdentityProviderInput`](crate::input::UpdateIdentityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateIdentityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateIdentityProviderInput {
                identity_provider_arn: self.identity_provider_arn,
                identity_provider_name: self.identity_provider_name,
                identity_provider_type: self.identity_provider_type,
                identity_provider_details: self.identity_provider_details,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateIdentityProviderInputOperationOutputAlias = crate::operation::UpdateIdentityProvider;
#[doc(hidden)]
pub type UpdateIdentityProviderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateIdentityProviderInput {
    /// Consumes the builder and constructs an Operation<[`UpdateIdentityProvider`](crate::operation::UpdateIdentityProvider)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateIdentityProvider,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateIdentityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.identity_provider_arn;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_provider_arn",
                        details: "cannot be empty or unset",
                    })?;
            let identity_provider_arn = aws_smithy_http::label::fmt_string(input_50, true);
            if identity_provider_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_provider_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identityProviders/{identityProviderArn}",
                identityProviderArn = identity_provider_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateIdentityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateIdentityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_identity_provider(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateIdentityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateIdentityProvider",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateIdentityProviderInput`](crate::input::UpdateIdentityProviderInput)
    pub fn builder() -> crate::input::update_identity_provider_input::Builder {
        crate::input::update_identity_provider_input::Builder::default()
    }
}

/// See [`UpdateNetworkSettingsInput`](crate::input::UpdateNetworkSettingsInput)
pub mod update_network_settings_input {
    /// A builder for [`UpdateNetworkSettingsInput`](crate::input::UpdateNetworkSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_settings_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_settings_arn = input;
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNetworkSettingsInput`](crate::input::UpdateNetworkSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateNetworkSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateNetworkSettingsInput {
                network_settings_arn: self.network_settings_arn,
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateNetworkSettingsInputOperationOutputAlias = crate::operation::UpdateNetworkSettings;
#[doc(hidden)]
pub type UpdateNetworkSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateNetworkSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateNetworkSettings`](crate::operation::UpdateNetworkSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateNetworkSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateNetworkSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.network_settings_arn;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_settings_arn",
                        details: "cannot be empty or unset",
                    })?;
            let network_settings_arn = aws_smithy_http::label::fmt_string(input_51, true);
            if network_settings_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "network_settings_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/networkSettings/{networkSettingsArn}",
                networkSettingsArn = network_settings_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateNetworkSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateNetworkSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_network_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateNetworkSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateNetworkSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateNetworkSettingsInput`](crate::input::UpdateNetworkSettingsInput)
    pub fn builder() -> crate::input::update_network_settings_input::Builder {
        crate::input::update_network_settings_input::Builder::default()
    }
}

/// See [`UpdatePortalInput`](crate::input::UpdatePortalInput)
pub mod update_portal_input {
    /// A builder for [`UpdatePortalInput`](crate::input::UpdatePortalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePortalInput`](crate::input::UpdatePortalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePortalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePortalInput {
                portal_arn: self.portal_arn,
                display_name: self.display_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePortalInputOperationOutputAlias = crate::operation::UpdatePortal;
#[doc(hidden)]
pub type UpdatePortalInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePortalInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePortal`](crate::operation::UpdatePortal)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePortal,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePortalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.portal_arn;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_arn",
                        details: "cannot be empty or unset",
                    })?;
            let portal_arn = aws_smithy_http::label::fmt_string(input_52, true);
            if portal_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/portals/{portalArn}", portalArn = portal_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePortalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePortalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_portal(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePortal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePortal",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePortalInput`](crate::input::UpdatePortalInput)
    pub fn builder() -> crate::input::update_portal_input::Builder {
        crate::input::update_portal_input::Builder::default()
    }
}

/// See [`UpdateTrustStoreInput`](crate::input::UpdateTrustStoreInput)
pub mod update_trust_store_input {
    /// A builder for [`UpdateTrustStoreInput`](crate::input::UpdateTrustStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_store_arn: std::option::Option<std::string::String>,
        pub(crate) certificates_to_add: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        pub(crate) certificates_to_delete: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_store_arn = input;
            self
        }
        /// Appends an item to `certificates_to_add`.
        ///
        /// To override the contents of this collection use [`set_certificates_to_add`](Self::set_certificates_to_add).
        ///
        /// <p>A list of CA certificates to add to the trust store.</p>
        pub fn certificates_to_add(mut self, input: aws_smithy_types::Blob) -> Self {
            let mut v = self.certificates_to_add.unwrap_or_default();
            v.push(input);
            self.certificates_to_add = Some(v);
            self
        }
        /// <p>A list of CA certificates to add to the trust store.</p>
        pub fn set_certificates_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        ) -> Self {
            self.certificates_to_add = input;
            self
        }
        /// Appends an item to `certificates_to_delete`.
        ///
        /// To override the contents of this collection use [`set_certificates_to_delete`](Self::set_certificates_to_delete).
        ///
        /// <p>A list of CA certificates to delete from a trust store.</p>
        pub fn certificates_to_delete(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.certificates_to_delete.unwrap_or_default();
            v.push(input.into());
            self.certificates_to_delete = Some(v);
            self
        }
        /// <p>A list of CA certificates to delete from a trust store.</p>
        pub fn set_certificates_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.certificates_to_delete = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrustStoreInput`](crate::input::UpdateTrustStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTrustStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTrustStoreInput {
                trust_store_arn: self.trust_store_arn,
                certificates_to_add: self.certificates_to_add,
                certificates_to_delete: self.certificates_to_delete,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTrustStoreInputOperationOutputAlias = crate::operation::UpdateTrustStore;
#[doc(hidden)]
pub type UpdateTrustStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTrustStoreInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTrustStore`](crate::operation::UpdateTrustStore)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTrustStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTrustStoreInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.trust_store_arn;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "trust_store_arn",
                        details: "cannot be empty or unset",
                    })?;
            let trust_store_arn = aws_smithy_http::label::fmt_string(input_53, true);
            if trust_store_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "trust_store_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/trustStores/{trustStoreArn}",
                trustStoreArn = trust_store_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTrustStoreInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTrustStoreInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_trust_store(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTrustStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTrustStore",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTrustStoreInput`](crate::input::UpdateTrustStoreInput)
    pub fn builder() -> crate::input::update_trust_store_input::Builder {
        crate::input::update_trust_store_input::Builder::default()
    }
}

/// See [`UpdateUserSettingsInput`](crate::input::UpdateUserSettingsInput)
pub mod update_user_settings_input {
    /// A builder for [`UpdateUserSettingsInput`](crate::input::UpdateUserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_settings_arn: std::option::Option<std::string::String>,
        pub(crate) copy_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) paste_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) download_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) upload_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) print_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_settings_arn = input;
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
        pub fn copy_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.copy_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
        pub fn set_copy_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.copy_allowed = input;
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
        pub fn paste_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.paste_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
        pub fn set_paste_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.paste_allowed = input;
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
        pub fn download_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.download_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
        pub fn set_download_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.download_allowed = input;
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
        pub fn upload_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.upload_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
        pub fn set_upload_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.upload_allowed = input;
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn print_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.print_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn set_print_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.print_allowed = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserSettingsInput`](crate::input::UpdateUserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserSettingsInput {
                user_settings_arn: self.user_settings_arn,
                copy_allowed: self.copy_allowed,
                paste_allowed: self.paste_allowed,
                download_allowed: self.download_allowed,
                upload_allowed: self.upload_allowed,
                print_allowed: self.print_allowed,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserSettingsInputOperationOutputAlias = crate::operation::UpdateUserSettings;
#[doc(hidden)]
pub type UpdateUserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateUserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUserSettings`](crate::operation::UpdateUserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateUserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_54 = &_input.user_settings_arn;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_settings_arn",
                        details: "cannot be empty or unset",
                    })?;
            let user_settings_arn = aws_smithy_http::label::fmt_string(input_54, true);
            if user_settings_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_settings_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/userSettings/{userSettingsArn}",
                userSettingsArn = user_settings_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateUserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateUserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_user_settings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUserSettings",
            "workspacesweb",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserSettingsInput`](crate::input::UpdateUserSettingsInput)
    pub fn builder() -> crate::input::update_user_settings_input::Builder {
        crate::input::update_user_settings_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserSettingsInput {
    /// <p>The ARN of the user settings.</p>
    pub user_settings_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
    pub copy_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
    pub paste_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
    pub download_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
    pub upload_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can print to the local device.</p>
    pub print_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateUserSettingsInput {
    /// <p>The ARN of the user settings.</p>
    pub fn user_settings_arn(&self) -> std::option::Option<&str> {
        self.user_settings_arn.as_deref()
    }
    /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
    pub fn copy_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.copy_allowed.as_ref()
    }
    /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
    pub fn paste_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.paste_allowed.as_ref()
    }
    /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
    pub fn download_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.download_allowed.as_ref()
    }
    /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
    pub fn upload_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.upload_allowed.as_ref()
    }
    /// <p>Specifies whether the user can print to the local device.</p>
    pub fn print_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.print_allowed.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateUserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserSettingsInput");
        formatter.field("user_settings_arn", &self.user_settings_arn);
        formatter.field("copy_allowed", &self.copy_allowed);
        formatter.field("paste_allowed", &self.paste_allowed);
        formatter.field("download_allowed", &self.download_allowed);
        formatter.field("upload_allowed", &self.upload_allowed);
        formatter.field("print_allowed", &self.print_allowed);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrustStoreInput {
    /// <p>The ARN of the trust store.</p>
    pub trust_store_arn: std::option::Option<std::string::String>,
    /// <p>A list of CA certificates to add to the trust store.</p>
    pub certificates_to_add: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
    /// <p>A list of CA certificates to delete from a trust store.</p>
    pub certificates_to_delete: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateTrustStoreInput {
    /// <p>The ARN of the trust store.</p>
    pub fn trust_store_arn(&self) -> std::option::Option<&str> {
        self.trust_store_arn.as_deref()
    }
    /// <p>A list of CA certificates to add to the trust store.</p>
    pub fn certificates_to_add(&self) -> std::option::Option<&[aws_smithy_types::Blob]> {
        self.certificates_to_add.as_deref()
    }
    /// <p>A list of CA certificates to delete from a trust store.</p>
    pub fn certificates_to_delete(&self) -> std::option::Option<&[std::string::String]> {
        self.certificates_to_delete.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateTrustStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrustStoreInput");
        formatter.field("trust_store_arn", &self.trust_store_arn);
        formatter.field("certificates_to_add", &self.certificates_to_add);
        formatter.field("certificates_to_delete", &self.certificates_to_delete);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePortalInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
    /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
    pub display_name: std::option::Option<std::string::String>,
}
impl UpdatePortalInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
    /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
}
impl std::fmt::Debug for UpdatePortalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePortalInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.field("display_name", &self.display_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNetworkSettingsInput {
    /// <p>The ARN of the network settings.</p>
    pub network_settings_arn: std::option::Option<std::string::String>,
    /// <p>The VPC that streaming instances will connect to.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateNetworkSettingsInput {
    /// <p>The ARN of the network settings.</p>
    pub fn network_settings_arn(&self) -> std::option::Option<&str> {
        self.network_settings_arn.as_deref()
    }
    /// <p>The VPC that streaming instances will connect to.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateNetworkSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNetworkSettingsInput");
        formatter.field("network_settings_arn", &self.network_settings_arn);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIdentityProviderInput {
    /// <p>The ARN of the identity provider.</p>
    pub identity_provider_arn: std::option::Option<std::string::String>,
    /// <p>The name of the identity provider.</p>
    pub identity_provider_name: std::option::Option<std::string::String>,
    /// <p>The type of the identity provider.</p>
    pub identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
    /// <p>The details of the identity provider.</p>
    pub identity_provider_details:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateIdentityProviderInput {
    /// <p>The ARN of the identity provider.</p>
    pub fn identity_provider_arn(&self) -> std::option::Option<&str> {
        self.identity_provider_arn.as_deref()
    }
    /// <p>The name of the identity provider.</p>
    pub fn identity_provider_name(&self) -> std::option::Option<&str> {
        self.identity_provider_name.as_deref()
    }
    /// <p>The type of the identity provider.</p>
    pub fn identity_provider_type(
        &self,
    ) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider_type.as_ref()
    }
    /// <p>The details of the identity provider.</p>
    pub fn identity_provider_details(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.identity_provider_details.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateIdentityProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIdentityProviderInput");
        formatter.field("identity_provider_arn", &self.identity_provider_arn);
        formatter.field("identity_provider_name", &self.identity_provider_name);
        formatter.field("identity_provider_type", &self.identity_provider_type);
        formatter.field("identity_provider_details", &self.identity_provider_details);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBrowserSettingsInput {
    /// <p>The ARN of the browser settings.</p>
    pub browser_settings_arn: std::option::Option<std::string::String>,
    /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions. </p>
    pub browser_policy: std::option::Option<std::string::String>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateBrowserSettingsInput {
    /// <p>The ARN of the browser settings.</p>
    pub fn browser_settings_arn(&self) -> std::option::Option<&str> {
        self.browser_settings_arn.as_deref()
    }
    /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions. </p>
    pub fn browser_policy(&self) -> std::option::Option<&str> {
        self.browser_policy.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateBrowserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBrowserSettingsInput");
        formatter.field("browser_settings_arn", &self.browser_settings_arn);
        formatter.field("browser_policy", &self.browser_policy);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tag keys to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tag keys to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags of the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl TagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags of the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUserSettingsInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be included in the next page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListUserSettingsInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be included in the next page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListUserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUserSettingsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrustStoresInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be included in the next page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTrustStoresInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be included in the next page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTrustStoresInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrustStoresInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrustStoreCertificatesInput {
    /// <p>The ARN of the trust store</p>
    pub trust_store_arn: std::option::Option<std::string::String>,
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be included in the next page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTrustStoreCertificatesInput {
    /// <p>The ARN of the trust store</p>
    pub fn trust_store_arn(&self) -> std::option::Option<&str> {
        self.trust_store_arn.as_deref()
    }
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be included in the next page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTrustStoreCertificatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrustStoreCertificatesInput");
        formatter.field("trust_store_arn", &self.trust_store_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPortalsInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be included in the next page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPortalsInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be included in the next page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPortalsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPortalsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNetworkSettingsInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be included in the next page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListNetworkSettingsInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be included in the next page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListNetworkSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNetworkSettingsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentityProvidersInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be included in the next page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
}
impl ListIdentityProvidersInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be included in the next page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
}
impl std::fmt::Debug for ListIdentityProvidersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentityProvidersInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("portal_arn", &self.portal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBrowserSettingsInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be included in the next page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListBrowserSettingsInput {
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be included in the next page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListBrowserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBrowserSettingsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUserSettingsInput {
    /// <p>The ARN of the user settings.</p>
    pub user_settings_arn: std::option::Option<std::string::String>,
}
impl GetUserSettingsInput {
    /// <p>The ARN of the user settings.</p>
    pub fn user_settings_arn(&self) -> std::option::Option<&str> {
        self.user_settings_arn.as_deref()
    }
}
impl std::fmt::Debug for GetUserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUserSettingsInput");
        formatter.field("user_settings_arn", &self.user_settings_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrustStoreCertificateInput {
    /// <p>The ARN of the trust store certificate.</p>
    pub trust_store_arn: std::option::Option<std::string::String>,
    /// <p>The thumbprint of the trust store certificate.</p>
    pub thumbprint: std::option::Option<std::string::String>,
}
impl GetTrustStoreCertificateInput {
    /// <p>The ARN of the trust store certificate.</p>
    pub fn trust_store_arn(&self) -> std::option::Option<&str> {
        self.trust_store_arn.as_deref()
    }
    /// <p>The thumbprint of the trust store certificate.</p>
    pub fn thumbprint(&self) -> std::option::Option<&str> {
        self.thumbprint.as_deref()
    }
}
impl std::fmt::Debug for GetTrustStoreCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrustStoreCertificateInput");
        formatter.field("trust_store_arn", &self.trust_store_arn);
        formatter.field("thumbprint", &self.thumbprint);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrustStoreInput {
    /// <p>The ARN of the trust store.</p>
    pub trust_store_arn: std::option::Option<std::string::String>,
}
impl GetTrustStoreInput {
    /// <p>The ARN of the trust store.</p>
    pub fn trust_store_arn(&self) -> std::option::Option<&str> {
        self.trust_store_arn.as_deref()
    }
}
impl std::fmt::Debug for GetTrustStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrustStoreInput");
        formatter.field("trust_store_arn", &self.trust_store_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPortalServiceProviderMetadataInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
}
impl GetPortalServiceProviderMetadataInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
}
impl std::fmt::Debug for GetPortalServiceProviderMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPortalServiceProviderMetadataInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPortalInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
}
impl GetPortalInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
}
impl std::fmt::Debug for GetPortalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPortalInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkSettingsInput {
    /// <p>The ARN of the network settings.</p>
    pub network_settings_arn: std::option::Option<std::string::String>,
}
impl GetNetworkSettingsInput {
    /// <p>The ARN of the network settings.</p>
    pub fn network_settings_arn(&self) -> std::option::Option<&str> {
        self.network_settings_arn.as_deref()
    }
}
impl std::fmt::Debug for GetNetworkSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkSettingsInput");
        formatter.field("network_settings_arn", &self.network_settings_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityProviderInput {
    /// <p>The ARN of the identity provider.</p>
    pub identity_provider_arn: std::option::Option<std::string::String>,
}
impl GetIdentityProviderInput {
    /// <p>The ARN of the identity provider.</p>
    pub fn identity_provider_arn(&self) -> std::option::Option<&str> {
        self.identity_provider_arn.as_deref()
    }
}
impl std::fmt::Debug for GetIdentityProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityProviderInput");
        formatter.field("identity_provider_arn", &self.identity_provider_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBrowserSettingsInput {
    /// <p>The ARN of the browser settings.</p>
    pub browser_settings_arn: std::option::Option<std::string::String>,
}
impl GetBrowserSettingsInput {
    /// <p>The ARN of the browser settings.</p>
    pub fn browser_settings_arn(&self) -> std::option::Option<&str> {
        self.browser_settings_arn.as_deref()
    }
}
impl std::fmt::Debug for GetBrowserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBrowserSettingsInput");
        formatter.field("browser_settings_arn", &self.browser_settings_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateUserSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
}
impl DisassociateUserSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateUserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateUserSettingsInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTrustStoreInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
}
impl DisassociateTrustStoreInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateTrustStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTrustStoreInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateNetworkSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
}
impl DisassociateNetworkSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateNetworkSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateNetworkSettingsInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateBrowserSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
}
impl DisassociateBrowserSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateBrowserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateBrowserSettingsInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserSettingsInput {
    /// <p>The ARN of the user settings.</p>
    pub user_settings_arn: std::option::Option<std::string::String>,
}
impl DeleteUserSettingsInput {
    /// <p>The ARN of the user settings.</p>
    pub fn user_settings_arn(&self) -> std::option::Option<&str> {
        self.user_settings_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserSettingsInput");
        formatter.field("user_settings_arn", &self.user_settings_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrustStoreInput {
    /// <p>The ARN of the trust store.</p>
    pub trust_store_arn: std::option::Option<std::string::String>,
}
impl DeleteTrustStoreInput {
    /// <p>The ARN of the trust store.</p>
    pub fn trust_store_arn(&self) -> std::option::Option<&str> {
        self.trust_store_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteTrustStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrustStoreInput");
        formatter.field("trust_store_arn", &self.trust_store_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePortalInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
}
impl DeletePortalInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
}
impl std::fmt::Debug for DeletePortalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePortalInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNetworkSettingsInput {
    /// <p>The ARN of the network settings.</p>
    pub network_settings_arn: std::option::Option<std::string::String>,
}
impl DeleteNetworkSettingsInput {
    /// <p>The ARN of the network settings.</p>
    pub fn network_settings_arn(&self) -> std::option::Option<&str> {
        self.network_settings_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteNetworkSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNetworkSettingsInput");
        formatter.field("network_settings_arn", &self.network_settings_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIdentityProviderInput {
    /// <p>The ARN of the identity provider.</p>
    pub identity_provider_arn: std::option::Option<std::string::String>,
}
impl DeleteIdentityProviderInput {
    /// <p>The ARN of the identity provider.</p>
    pub fn identity_provider_arn(&self) -> std::option::Option<&str> {
        self.identity_provider_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteIdentityProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIdentityProviderInput");
        formatter.field("identity_provider_arn", &self.identity_provider_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBrowserSettingsInput {
    /// <p>The ARN of the browser settings.</p>
    pub browser_settings_arn: std::option::Option<std::string::String>,
}
impl DeleteBrowserSettingsInput {
    /// <p>The ARN of the browser settings.</p>
    pub fn browser_settings_arn(&self) -> std::option::Option<&str> {
        self.browser_settings_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteBrowserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBrowserSettingsInput");
        formatter.field("browser_settings_arn", &self.browser_settings_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserSettingsInput {
    /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
    pub copy_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
    pub paste_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
    pub download_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
    pub upload_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can print to the local device.</p>
    pub print_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>The tags to add to the user settings resource. A tag is a key-value pair.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateUserSettingsInput {
    /// <p>Specifies whether the user can copy text from the streaming session to the local device.</p>
    pub fn copy_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.copy_allowed.as_ref()
    }
    /// <p>Specifies whether the user can paste text from the local device to the streaming session.</p>
    pub fn paste_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.paste_allowed.as_ref()
    }
    /// <p>Specifies whether the user can download files from the streaming session to the local device.</p>
    pub fn download_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.download_allowed.as_ref()
    }
    /// <p>Specifies whether the user can upload files from the local device to the streaming session.</p>
    pub fn upload_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.upload_allowed.as_ref()
    }
    /// <p>Specifies whether the user can print to the local device.</p>
    pub fn print_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.print_allowed.as_ref()
    }
    /// <p>The tags to add to the user settings resource. A tag is a key-value pair.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateUserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserSettingsInput");
        formatter.field("copy_allowed", &self.copy_allowed);
        formatter.field("paste_allowed", &self.paste_allowed);
        formatter.field("download_allowed", &self.download_allowed);
        formatter.field("upload_allowed", &self.upload_allowed);
        formatter.field("print_allowed", &self.print_allowed);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrustStoreInput {
    /// <p>A list of CA certificates to be added to the trust store.</p>
    pub certificate_list: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
    /// <p>The tags to add to the trust store. A tag is a key-value pair.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateTrustStoreInput {
    /// <p>A list of CA certificates to be added to the trust store.</p>
    pub fn certificate_list(&self) -> std::option::Option<&[aws_smithy_types::Blob]> {
        self.certificate_list.as_deref()
    }
    /// <p>The tags to add to the trust store. A tag is a key-value pair.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateTrustStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrustStoreInput");
        formatter.field("certificate_list", &self.certificate_list);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePortalInput {
    /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The tags to add to the web portal. A tag is a key-value pair.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The customer managed key of the web portal.</p>
    pub customer_managed_key: std::option::Option<std::string::String>,
    /// <p>The additional encryption context of the portal.</p>
    pub additional_encryption_context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreatePortalInput {
    /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The tags to add to the web portal. A tag is a key-value pair.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The customer managed key of the web portal.</p>
    pub fn customer_managed_key(&self) -> std::option::Option<&str> {
        self.customer_managed_key.as_deref()
    }
    /// <p>The additional encryption context of the portal.</p>
    pub fn additional_encryption_context(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.additional_encryption_context.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreatePortalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePortalInput");
        formatter.field("display_name", &self.display_name);
        formatter.field("tags", &self.tags);
        formatter.field("customer_managed_key", &self.customer_managed_key);
        formatter.field(
            "additional_encryption_context",
            &self.additional_encryption_context,
        );
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNetworkSettingsInput {
    /// <p>The VPC that streaming instances will connect to.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to add to the network settings resource. A tag is a key-value pair.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateNetworkSettingsInput {
    /// <p>The VPC that streaming instances will connect to.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The tags to add to the network settings resource. A tag is a key-value pair.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request. </p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateNetworkSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNetworkSettingsInput");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIdentityProviderInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
    /// <p>The identity provider name.</p>
    pub identity_provider_name: std::option::Option<std::string::String>,
    /// <p>The identity provider type.</p>
    pub identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
    /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type. </p>
    /// <ul>
    /// <li> <p>For Google and Login with Amazon:</p>
    /// <ul>
    /// <li> <p> <code>client_id</code> </p> </li>
    /// <li> <p> <code>client_secret</code> </p> </li>
    /// <li> <p> <code>authorize_scopes</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>For Facebook:</p>
    /// <ul>
    /// <li> <p> <code>client_id</code> </p> </li>
    /// <li> <p> <code>client_secret</code> </p> </li>
    /// <li> <p> <code>authorize_scopes</code> </p> </li>
    /// <li> <p> <code>api_version</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>For Sign in with Apple:</p>
    /// <ul>
    /// <li> <p> <code>client_id</code> </p> </li>
    /// <li> <p> <code>team_id</code> </p> </li>
    /// <li> <p> <code>key_id</code> </p> </li>
    /// <li> <p> <code>private_key</code> </p> </li>
    /// <li> <p> <code>authorize_scopes</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>For OIDC providers:</p>
    /// <ul>
    /// <li> <p> <code>client_id</code> </p> </li>
    /// <li> <p> <code>client_secret</code> </p> </li>
    /// <li> <p> <code>attributes_request_method</code> </p> </li>
    /// <li> <p> <code>oidc_issuer</code> </p> </li>
    /// <li> <p> <code>authorize_scopes</code> </p> </li>
    /// <li> <p> <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
    /// <li> <p> <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
    /// <li> <p> <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
    /// <li> <p> <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
    /// </ul> </li>
    /// <li> <p>For SAML providers:</p>
    /// <ul>
    /// <li> <p> <code>MetadataFile</code> OR <code>MetadataURL</code> </p> </li>
    /// <li> <p> <code>IDPSignout</code> <i>optional</i> </p> </li>
    /// </ul> </li>
    /// </ul>
    pub identity_provider_details:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateIdentityProviderInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
    /// <p>The identity provider name.</p>
    pub fn identity_provider_name(&self) -> std::option::Option<&str> {
        self.identity_provider_name.as_deref()
    }
    /// <p>The identity provider type.</p>
    pub fn identity_provider_type(
        &self,
    ) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider_type.as_ref()
    }
    /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type. </p>
    /// <ul>
    /// <li> <p>For Google and Login with Amazon:</p>
    /// <ul>
    /// <li> <p> <code>client_id</code> </p> </li>
    /// <li> <p> <code>client_secret</code> </p> </li>
    /// <li> <p> <code>authorize_scopes</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>For Facebook:</p>
    /// <ul>
    /// <li> <p> <code>client_id</code> </p> </li>
    /// <li> <p> <code>client_secret</code> </p> </li>
    /// <li> <p> <code>authorize_scopes</code> </p> </li>
    /// <li> <p> <code>api_version</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>For Sign in with Apple:</p>
    /// <ul>
    /// <li> <p> <code>client_id</code> </p> </li>
    /// <li> <p> <code>team_id</code> </p> </li>
    /// <li> <p> <code>key_id</code> </p> </li>
    /// <li> <p> <code>private_key</code> </p> </li>
    /// <li> <p> <code>authorize_scopes</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>For OIDC providers:</p>
    /// <ul>
    /// <li> <p> <code>client_id</code> </p> </li>
    /// <li> <p> <code>client_secret</code> </p> </li>
    /// <li> <p> <code>attributes_request_method</code> </p> </li>
    /// <li> <p> <code>oidc_issuer</code> </p> </li>
    /// <li> <p> <code>authorize_scopes</code> </p> </li>
    /// <li> <p> <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
    /// <li> <p> <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
    /// <li> <p> <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
    /// <li> <p> <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i> </p> </li>
    /// </ul> </li>
    /// <li> <p>For SAML providers:</p>
    /// <ul>
    /// <li> <p> <code>MetadataFile</code> OR <code>MetadataURL</code> </p> </li>
    /// <li> <p> <code>IDPSignout</code> <i>optional</i> </p> </li>
    /// </ul> </li>
    /// </ul>
    pub fn identity_provider_details(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.identity_provider_details.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateIdentityProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIdentityProviderInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.field("identity_provider_name", &self.identity_provider_name);
        formatter.field("identity_provider_type", &self.identity_provider_type);
        formatter.field("identity_provider_details", &self.identity_provider_details);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBrowserSettingsInput {
    /// <p>The tags to add to the browser settings resource. A tag is a key-value pair.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The custom managed key of the browser settings.</p>
    pub customer_managed_key: std::option::Option<std::string::String>,
    /// <p>Additional encryption context of the browser settings.</p>
    pub additional_encryption_context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.</p>
    pub browser_policy: std::option::Option<std::string::String>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK. </p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateBrowserSettingsInput {
    /// <p>The tags to add to the browser settings resource. A tag is a key-value pair.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The custom managed key of the browser settings.</p>
    pub fn customer_managed_key(&self) -> std::option::Option<&str> {
        self.customer_managed_key.as_deref()
    }
    /// <p>Additional encryption context of the browser settings.</p>
    pub fn additional_encryption_context(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.additional_encryption_context.as_ref()
    }
    /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.</p>
    pub fn browser_policy(&self) -> std::option::Option<&str> {
        self.browser_policy.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.</p>
    /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateBrowserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBrowserSettingsInput");
        formatter.field("tags", &self.tags);
        formatter.field("customer_managed_key", &self.customer_managed_key);
        formatter.field(
            "additional_encryption_context",
            &self.additional_encryption_context,
        );
        formatter.field("browser_policy", &self.browser_policy);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateUserSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the user settings.</p>
    pub user_settings_arn: std::option::Option<std::string::String>,
}
impl AssociateUserSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
    /// <p>The ARN of the user settings.</p>
    pub fn user_settings_arn(&self) -> std::option::Option<&str> {
        self.user_settings_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateUserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateUserSettingsInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.field("user_settings_arn", &self.user_settings_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTrustStoreInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the trust store.</p>
    pub trust_store_arn: std::option::Option<std::string::String>,
}
impl AssociateTrustStoreInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
    /// <p>The ARN of the trust store.</p>
    pub fn trust_store_arn(&self) -> std::option::Option<&str> {
        self.trust_store_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateTrustStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTrustStoreInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.field("trust_store_arn", &self.trust_store_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateNetworkSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the network settings.</p>
    pub network_settings_arn: std::option::Option<std::string::String>,
}
impl AssociateNetworkSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
    /// <p>The ARN of the network settings.</p>
    pub fn network_settings_arn(&self) -> std::option::Option<&str> {
        self.network_settings_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateNetworkSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateNetworkSettingsInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.field("network_settings_arn", &self.network_settings_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateBrowserSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the browser settings.</p>
    pub browser_settings_arn: std::option::Option<std::string::String>,
}
impl AssociateBrowserSettingsInput {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
    /// <p>The ARN of the browser settings.</p>
    pub fn browser_settings_arn(&self) -> std::option::Option<&str> {
        self.browser_settings_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateBrowserSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateBrowserSettingsInput");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.field("browser_settings_arn", &self.browser_settings_arn);
        formatter.finish()
    }
}
