// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about a field passed inside a request that resulted in an exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the field that failed validation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The message describing why the field failed validation.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The name of the field that failed validation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The message describing why the field failed validation.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field that failed validation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the field that failed validation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The message describing why the field failed validation.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message describing why the field failed validation.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "cannotParse" => ValidationExceptionReason::CannotParse,
            "fieldValidationFailed" => ValidationExceptionReason::FieldValidationFailed,
            "other" => ValidationExceptionReason::Other,
            "unknownOperation" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "cannotParse",
            ValidationExceptionReason::FieldValidationFailed => "fieldValidationFailed",
            ValidationExceptionReason::Other => "other",
            ValidationExceptionReason::UnknownOperation => "unknownOperation",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cannotParse",
            "fieldValidationFailed",
            "other",
            "unknownOperation",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A user settings resource that can be associated with a web portal. Once associated with
/// a web portal, user settings control how users can transfer data between a streaming session
/// and the their local devices. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserSettings {
    /// <p>The ARN of the user settings.</p>
    pub user_settings_arn: std::option::Option<std::string::String>,
    /// <p>A list of web portal ARNs that this user settings is associated with.</p>
    pub associated_portal_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether the user can copy text from the streaming session to the local
    /// device.</p>
    pub copy_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can paste text from the local device to the streaming
    /// session.</p>
    pub paste_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can download files from the streaming session to the local
    /// device.</p>
    pub download_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can upload files from the local device to the streaming
    /// session.</p>
    pub upload_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can print to the local device.</p>
    pub print_allowed: std::option::Option<crate::model::EnabledType>,
}
impl UserSettings {
    /// <p>The ARN of the user settings.</p>
    pub fn user_settings_arn(&self) -> std::option::Option<&str> {
        self.user_settings_arn.as_deref()
    }
    /// <p>A list of web portal ARNs that this user settings is associated with.</p>
    pub fn associated_portal_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.associated_portal_arns.as_deref()
    }
    /// <p>Specifies whether the user can copy text from the streaming session to the local
    /// device.</p>
    pub fn copy_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.copy_allowed.as_ref()
    }
    /// <p>Specifies whether the user can paste text from the local device to the streaming
    /// session.</p>
    pub fn paste_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.paste_allowed.as_ref()
    }
    /// <p>Specifies whether the user can download files from the streaming session to the local
    /// device.</p>
    pub fn download_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.download_allowed.as_ref()
    }
    /// <p>Specifies whether the user can upload files from the local device to the streaming
    /// session.</p>
    pub fn upload_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.upload_allowed.as_ref()
    }
    /// <p>Specifies whether the user can print to the local device.</p>
    pub fn print_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.print_allowed.as_ref()
    }
}
impl std::fmt::Debug for UserSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserSettings");
        formatter.field("user_settings_arn", &self.user_settings_arn);
        formatter.field("associated_portal_arns", &self.associated_portal_arns);
        formatter.field("copy_allowed", &self.copy_allowed);
        formatter.field("paste_allowed", &self.paste_allowed);
        formatter.field("download_allowed", &self.download_allowed);
        formatter.field("upload_allowed", &self.upload_allowed);
        formatter.field("print_allowed", &self.print_allowed);
        formatter.finish()
    }
}
/// See [`UserSettings`](crate::model::UserSettings)
pub mod user_settings {
    /// A builder for [`UserSettings`](crate::model::UserSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_settings_arn: std::option::Option<std::string::String>,
        pub(crate) associated_portal_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) copy_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) paste_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) download_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) upload_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) print_allowed: std::option::Option<crate::model::EnabledType>,
    }
    impl Builder {
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_settings_arn = input;
            self
        }
        /// Appends an item to `associated_portal_arns`.
        ///
        /// To override the contents of this collection use [`set_associated_portal_arns`](Self::set_associated_portal_arns).
        ///
        /// <p>A list of web portal ARNs that this user settings is associated with.</p>
        pub fn associated_portal_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.associated_portal_arns.unwrap_or_default();
            v.push(input.into());
            self.associated_portal_arns = Some(v);
            self
        }
        /// <p>A list of web portal ARNs that this user settings is associated with.</p>
        pub fn set_associated_portal_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.associated_portal_arns = input;
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local
        /// device.</p>
        pub fn copy_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.copy_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local
        /// device.</p>
        pub fn set_copy_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.copy_allowed = input;
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming
        /// session.</p>
        pub fn paste_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.paste_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming
        /// session.</p>
        pub fn set_paste_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.paste_allowed = input;
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local
        /// device.</p>
        pub fn download_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.download_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local
        /// device.</p>
        pub fn set_download_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.download_allowed = input;
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming
        /// session.</p>
        pub fn upload_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.upload_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming
        /// session.</p>
        pub fn set_upload_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.upload_allowed = input;
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn print_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.print_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn set_print_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.print_allowed = input;
            self
        }
        /// Consumes the builder and constructs a [`UserSettings`](crate::model::UserSettings)
        pub fn build(self) -> crate::model::UserSettings {
            crate::model::UserSettings {
                user_settings_arn: self.user_settings_arn,
                associated_portal_arns: self.associated_portal_arns,
                copy_allowed: self.copy_allowed,
                paste_allowed: self.paste_allowed,
                download_allowed: self.download_allowed,
                upload_allowed: self.upload_allowed,
                print_allowed: self.print_allowed,
            }
        }
    }
}
impl UserSettings {
    /// Creates a new builder-style object to manufacture [`UserSettings`](crate::model::UserSettings)
    pub fn builder() -> crate::model::user_settings::Builder {
        crate::model::user_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnabledType {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnabledType {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => EnabledType::Disabled,
            "Enabled" => EnabledType::Enabled,
            other => EnabledType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnabledType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnabledType::from(s))
    }
}
impl EnabledType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnabledType::Disabled => "Disabled",
            EnabledType::Enabled => "Enabled",
            EnabledType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for EnabledType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The web portal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Portal {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
    /// <p>The renderer that is used in streaming sessions.</p>
    pub renderer_type: std::option::Option<crate::model::RendererType>,
    /// <p>The browser that users see when using a streaming session.</p>
    pub browser_type: std::option::Option<crate::model::BrowserType>,
    /// <p>The status of the web portal.</p>
    pub portal_status: std::option::Option<crate::model::PortalStatus>,
    /// <p>The endpoint URL of the web portal that users access in order to start streaming
    /// sessions.</p>
    pub portal_endpoint: std::option::Option<std::string::String>,
    /// <p>The name of the web portal.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The creation date of the web portal.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ARN of the browser settings that is associated with this web portal.</p>
    pub browser_settings_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the trust store that is associated with the web portal.</p>
    pub user_settings_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the network settings that is associated with the web portal.</p>
    pub network_settings_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the trust store that is associated with the web portal.</p>
    pub trust_store_arn: std::option::Option<std::string::String>,
    /// <p>A message that explains why the web portal is in its current status.</p>
    pub status_reason: std::option::Option<std::string::String>,
}
impl Portal {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
    /// <p>The renderer that is used in streaming sessions.</p>
    pub fn renderer_type(&self) -> std::option::Option<&crate::model::RendererType> {
        self.renderer_type.as_ref()
    }
    /// <p>The browser that users see when using a streaming session.</p>
    pub fn browser_type(&self) -> std::option::Option<&crate::model::BrowserType> {
        self.browser_type.as_ref()
    }
    /// <p>The status of the web portal.</p>
    pub fn portal_status(&self) -> std::option::Option<&crate::model::PortalStatus> {
        self.portal_status.as_ref()
    }
    /// <p>The endpoint URL of the web portal that users access in order to start streaming
    /// sessions.</p>
    pub fn portal_endpoint(&self) -> std::option::Option<&str> {
        self.portal_endpoint.as_deref()
    }
    /// <p>The name of the web portal.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The creation date of the web portal.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The ARN of the browser settings that is associated with this web portal.</p>
    pub fn browser_settings_arn(&self) -> std::option::Option<&str> {
        self.browser_settings_arn.as_deref()
    }
    /// <p>The ARN of the trust store that is associated with the web portal.</p>
    pub fn user_settings_arn(&self) -> std::option::Option<&str> {
        self.user_settings_arn.as_deref()
    }
    /// <p>The ARN of the network settings that is associated with the web portal.</p>
    pub fn network_settings_arn(&self) -> std::option::Option<&str> {
        self.network_settings_arn.as_deref()
    }
    /// <p>The ARN of the trust store that is associated with the web portal.</p>
    pub fn trust_store_arn(&self) -> std::option::Option<&str> {
        self.trust_store_arn.as_deref()
    }
    /// <p>A message that explains why the web portal is in its current status.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
}
impl std::fmt::Debug for Portal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Portal");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.field("renderer_type", &self.renderer_type);
        formatter.field("browser_type", &self.browser_type);
        formatter.field("portal_status", &self.portal_status);
        formatter.field("portal_endpoint", &self.portal_endpoint);
        formatter.field("display_name", &self.display_name);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("browser_settings_arn", &self.browser_settings_arn);
        formatter.field("user_settings_arn", &self.user_settings_arn);
        formatter.field("network_settings_arn", &self.network_settings_arn);
        formatter.field("trust_store_arn", &self.trust_store_arn);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`Portal`](crate::model::Portal)
pub mod portal {
    /// A builder for [`Portal`](crate::model::Portal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
        pub(crate) renderer_type: std::option::Option<crate::model::RendererType>,
        pub(crate) browser_type: std::option::Option<crate::model::BrowserType>,
        pub(crate) portal_status: std::option::Option<crate::model::PortalStatus>,
        pub(crate) portal_endpoint: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) browser_settings_arn: std::option::Option<std::string::String>,
        pub(crate) user_settings_arn: std::option::Option<std::string::String>,
        pub(crate) network_settings_arn: std::option::Option<std::string::String>,
        pub(crate) trust_store_arn: std::option::Option<std::string::String>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// <p>The renderer that is used in streaming sessions.</p>
        pub fn renderer_type(mut self, input: crate::model::RendererType) -> Self {
            self.renderer_type = Some(input);
            self
        }
        /// <p>The renderer that is used in streaming sessions.</p>
        pub fn set_renderer_type(
            mut self,
            input: std::option::Option<crate::model::RendererType>,
        ) -> Self {
            self.renderer_type = input;
            self
        }
        /// <p>The browser that users see when using a streaming session.</p>
        pub fn browser_type(mut self, input: crate::model::BrowserType) -> Self {
            self.browser_type = Some(input);
            self
        }
        /// <p>The browser that users see when using a streaming session.</p>
        pub fn set_browser_type(
            mut self,
            input: std::option::Option<crate::model::BrowserType>,
        ) -> Self {
            self.browser_type = input;
            self
        }
        /// <p>The status of the web portal.</p>
        pub fn portal_status(mut self, input: crate::model::PortalStatus) -> Self {
            self.portal_status = Some(input);
            self
        }
        /// <p>The status of the web portal.</p>
        pub fn set_portal_status(
            mut self,
            input: std::option::Option<crate::model::PortalStatus>,
        ) -> Self {
            self.portal_status = input;
            self
        }
        /// <p>The endpoint URL of the web portal that users access in order to start streaming
        /// sessions.</p>
        pub fn portal_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint URL of the web portal that users access in order to start streaming
        /// sessions.</p>
        pub fn set_portal_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_endpoint = input;
            self
        }
        /// <p>The name of the web portal.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the web portal.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The creation date of the web portal.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date of the web portal.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The ARN of the browser settings that is associated with this web portal.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the browser settings that is associated with this web portal.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_settings_arn = input;
            self
        }
        /// <p>The ARN of the trust store that is associated with the web portal.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust store that is associated with the web portal.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_settings_arn = input;
            self
        }
        /// <p>The ARN of the network settings that is associated with the web portal.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network settings that is associated with the web portal.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_settings_arn = input;
            self
        }
        /// <p>The ARN of the trust store that is associated with the web portal.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust store that is associated with the web portal.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_store_arn = input;
            self
        }
        /// <p>A message that explains why the web portal is in its current status.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>A message that explains why the web portal is in its current status.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`Portal`](crate::model::Portal)
        pub fn build(self) -> crate::model::Portal {
            crate::model::Portal {
                portal_arn: self.portal_arn,
                renderer_type: self.renderer_type,
                browser_type: self.browser_type,
                portal_status: self.portal_status,
                portal_endpoint: self.portal_endpoint,
                display_name: self.display_name,
                creation_date: self.creation_date,
                browser_settings_arn: self.browser_settings_arn,
                user_settings_arn: self.user_settings_arn,
                network_settings_arn: self.network_settings_arn,
                trust_store_arn: self.trust_store_arn,
                status_reason: self.status_reason,
            }
        }
    }
}
impl Portal {
    /// Creates a new builder-style object to manufacture [`Portal`](crate::model::Portal)
    pub fn builder() -> crate::model::portal::Builder {
        crate::model::portal::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PortalStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Incomplete,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PortalStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => PortalStatus::Active,
            "Incomplete" => PortalStatus::Incomplete,
            "Pending" => PortalStatus::Pending,
            other => PortalStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PortalStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PortalStatus::from(s))
    }
}
impl PortalStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PortalStatus::Active => "Active",
            PortalStatus::Incomplete => "Incomplete",
            PortalStatus::Pending => "Pending",
            PortalStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Incomplete", "Pending"]
    }
}
impl AsRef<str> for PortalStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BrowserType {
    #[allow(missing_docs)] // documentation missing in model
    Chrome,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BrowserType {
    fn from(s: &str) -> Self {
        match s {
            "Chrome" => BrowserType::Chrome,
            other => BrowserType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BrowserType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BrowserType::from(s))
    }
}
impl BrowserType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BrowserType::Chrome => "Chrome",
            BrowserType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Chrome"]
    }
}
impl AsRef<str> for BrowserType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RendererType {
    #[allow(missing_docs)] // documentation missing in model
    Appstream,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RendererType {
    fn from(s: &str) -> Self {
        match s {
            "AppStream" => RendererType::Appstream,
            other => RendererType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RendererType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RendererType::from(s))
    }
}
impl RendererType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RendererType::Appstream => "AppStream",
            RendererType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AppStream"]
    }
}
impl AsRef<str> for RendererType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A network settings resource that can be associated with a web portal. Once associated
/// with a web portal, network settings define how streaming instances will connect with your
/// specified VPC. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkSettings {
    /// <p>The ARN of the network settings.</p>
    pub network_settings_arn: std::option::Option<std::string::String>,
    /// <p>A list of web portal ARNs that this network settings is associated with.</p>
    pub associated_portal_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The VPC that streaming instances will connect to.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more security groups used to control access from streaming instances to your VPC. </p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl NetworkSettings {
    /// <p>The ARN of the network settings.</p>
    pub fn network_settings_arn(&self) -> std::option::Option<&str> {
        self.network_settings_arn.as_deref()
    }
    /// <p>A list of web portal ARNs that this network settings is associated with.</p>
    pub fn associated_portal_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.associated_portal_arns.as_deref()
    }
    /// <p>The VPC that streaming instances will connect to.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>One or more security groups used to control access from streaming instances to your VPC. </p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for NetworkSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkSettings");
        formatter.field("network_settings_arn", &self.network_settings_arn);
        formatter.field("associated_portal_arns", &self.associated_portal_arns);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`NetworkSettings`](crate::model::NetworkSettings)
pub mod network_settings {
    /// A builder for [`NetworkSettings`](crate::model::NetworkSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_settings_arn: std::option::Option<std::string::String>,
        pub(crate) associated_portal_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_settings_arn = input;
            self
        }
        /// Appends an item to `associated_portal_arns`.
        ///
        /// To override the contents of this collection use [`set_associated_portal_arns`](Self::set_associated_portal_arns).
        ///
        /// <p>A list of web portal ARNs that this network settings is associated with.</p>
        pub fn associated_portal_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.associated_portal_arns.unwrap_or_default();
            v.push(input.into());
            self.associated_portal_arns = Some(v);
            self
        }
        /// <p>A list of web portal ARNs that this network settings is associated with.</p>
        pub fn set_associated_portal_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.associated_portal_arns = input;
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more security groups used to control access from streaming instances to your VPC. </p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>One or more security groups used to control access from streaming instances to your VPC. </p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkSettings`](crate::model::NetworkSettings)
        pub fn build(self) -> crate::model::NetworkSettings {
            crate::model::NetworkSettings {
                network_settings_arn: self.network_settings_arn,
                associated_portal_arns: self.associated_portal_arns,
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl NetworkSettings {
    /// Creates a new builder-style object to manufacture [`NetworkSettings`](crate::model::NetworkSettings)
    pub fn builder() -> crate::model::network_settings::Builder {
        crate::model::network_settings::Builder::default()
    }
}

/// <p>The identity provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityProvider {
    /// <p>The ARN of the identity provider.</p>
    pub identity_provider_arn: std::option::Option<std::string::String>,
    /// <p>The identity provider name.</p>
    pub identity_provider_name: std::option::Option<std::string::String>,
    /// <p>The identity provider type.</p>
    pub identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
    /// <p>The identity provider details. The following list describes the provider detail keys for
    /// each identity provider type. </p>
    /// <ul>
    /// <li>
    /// <p>For Google and Login with Amazon:</p>      
    /// <ul>
    /// <li>
    /// <p>
    /// <code>client_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>client_secret</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>authorize_scopes</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>For Facebook:</p>      
    /// <ul>
    /// <li>
    /// <p>
    /// <code>client_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>client_secret</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>authorize_scopes</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>api_version</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>For Sign in with Apple:</p>      
    /// <ul>
    /// <li>
    /// <p>
    /// <code>client_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>team_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>key_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>private_key</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>authorize_scopes</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>For OIDC providers:</p>      
    /// <ul>
    /// <li>
    /// <p>
    /// <code>client_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>client_secret</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>attributes_request_method</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>oidc_issuer</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>authorize_scopes</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>authorize_url</code>
    /// <i>if not available from discovery URL specified by oidc_issuer
    /// key</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>token_url</code>
    /// <i>if not available from discovery URL specified by oidc_issuer
    /// key</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>attributes_url</code>
    /// <i>if not available from discovery URL specified by oidc_issuer
    /// key</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>jwks_uri</code>
    /// <i>if not available from discovery URL specified by oidc_issuer
    /// key</i>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>For SAML providers:</p>      
    /// <ul>
    /// <li>
    /// <p>
    /// <code>MetadataFile</code> OR <code>MetadataURL</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IDPSignout</code>
    /// <i>optional</i>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub identity_provider_details:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl IdentityProvider {
    /// <p>The ARN of the identity provider.</p>
    pub fn identity_provider_arn(&self) -> std::option::Option<&str> {
        self.identity_provider_arn.as_deref()
    }
    /// <p>The identity provider name.</p>
    pub fn identity_provider_name(&self) -> std::option::Option<&str> {
        self.identity_provider_name.as_deref()
    }
    /// <p>The identity provider type.</p>
    pub fn identity_provider_type(
        &self,
    ) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider_type.as_ref()
    }
    /// <p>The identity provider details. The following list describes the provider detail keys for
    /// each identity provider type. </p>
    /// <ul>
    /// <li>
    /// <p>For Google and Login with Amazon:</p>      
    /// <ul>
    /// <li>
    /// <p>
    /// <code>client_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>client_secret</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>authorize_scopes</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>For Facebook:</p>      
    /// <ul>
    /// <li>
    /// <p>
    /// <code>client_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>client_secret</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>authorize_scopes</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>api_version</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>For Sign in with Apple:</p>      
    /// <ul>
    /// <li>
    /// <p>
    /// <code>client_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>team_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>key_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>private_key</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>authorize_scopes</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>For OIDC providers:</p>      
    /// <ul>
    /// <li>
    /// <p>
    /// <code>client_id</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>client_secret</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>attributes_request_method</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>oidc_issuer</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>authorize_scopes</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>authorize_url</code>
    /// <i>if not available from discovery URL specified by oidc_issuer
    /// key</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>token_url</code>
    /// <i>if not available from discovery URL specified by oidc_issuer
    /// key</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>attributes_url</code>
    /// <i>if not available from discovery URL specified by oidc_issuer
    /// key</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>jwks_uri</code>
    /// <i>if not available from discovery URL specified by oidc_issuer
    /// key</i>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>For SAML providers:</p>      
    /// <ul>
    /// <li>
    /// <p>
    /// <code>MetadataFile</code> OR <code>MetadataURL</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IDPSignout</code>
    /// <i>optional</i>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn identity_provider_details(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.identity_provider_details.as_ref()
    }
}
impl std::fmt::Debug for IdentityProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityProvider");
        formatter.field("identity_provider_arn", &self.identity_provider_arn);
        formatter.field("identity_provider_name", &self.identity_provider_name);
        formatter.field("identity_provider_type", &self.identity_provider_type);
        formatter.field("identity_provider_details", &self.identity_provider_details);
        formatter.finish()
    }
}
/// See [`IdentityProvider`](crate::model::IdentityProvider)
pub mod identity_provider {
    /// A builder for [`IdentityProvider`](crate::model::IdentityProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider_arn: std::option::Option<std::string::String>,
        pub(crate) identity_provider_name: std::option::Option<std::string::String>,
        pub(crate) identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
        pub(crate) identity_provider_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_arn = input;
            self
        }
        /// <p>The identity provider name.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_name = Some(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_name = input;
            self
        }
        /// <p>The identity provider type.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider_type = Some(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider_type = input;
            self
        }
        /// Adds a key-value pair to `identity_provider_details`.
        ///
        /// To override the contents of this collection use [`set_identity_provider_details`](Self::set_identity_provider_details).
        ///
        /// <p>The identity provider details. The following list describes the provider detail keys for
        /// each identity provider type. </p>
        /// <ul>
        /// <li>
        /// <p>For Google and Login with Amazon:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For Facebook:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>api_version</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For Sign in with Apple:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>team_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>key_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>private_key</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For OIDC providers:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>attributes_request_method</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oidc_issuer</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_url</code>
        /// <i>if not available from discovery URL specified by oidc_issuer
        /// key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>token_url</code>
        /// <i>if not available from discovery URL specified by oidc_issuer
        /// key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>attributes_url</code>
        /// <i>if not available from discovery URL specified by oidc_issuer
        /// key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jwks_uri</code>
        /// <i>if not available from discovery URL specified by oidc_issuer
        /// key</i>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For SAML providers:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MetadataFile</code> OR <code>MetadataURL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IDPSignout</code>
        /// <i>optional</i>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn identity_provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identity_provider_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.identity_provider_details = Some(hash_map);
            self
        }
        /// <p>The identity provider details. The following list describes the provider detail keys for
        /// each identity provider type. </p>
        /// <ul>
        /// <li>
        /// <p>For Google and Login with Amazon:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For Facebook:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>api_version</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For Sign in with Apple:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>team_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>key_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>private_key</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For OIDC providers:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>attributes_request_method</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oidc_issuer</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_url</code>
        /// <i>if not available from discovery URL specified by oidc_issuer
        /// key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>token_url</code>
        /// <i>if not available from discovery URL specified by oidc_issuer
        /// key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>attributes_url</code>
        /// <i>if not available from discovery URL specified by oidc_issuer
        /// key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jwks_uri</code>
        /// <i>if not available from discovery URL specified by oidc_issuer
        /// key</i>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For SAML providers:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MetadataFile</code> OR <code>MetadataURL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IDPSignout</code>
        /// <i>optional</i>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.identity_provider_details = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityProvider`](crate::model::IdentityProvider)
        pub fn build(self) -> crate::model::IdentityProvider {
            crate::model::IdentityProvider {
                identity_provider_arn: self.identity_provider_arn,
                identity_provider_name: self.identity_provider_name,
                identity_provider_type: self.identity_provider_type,
                identity_provider_details: self.identity_provider_details,
            }
        }
    }
}
impl IdentityProvider {
    /// Creates a new builder-style object to manufacture [`IdentityProvider`](crate::model::IdentityProvider)
    pub fn builder() -> crate::model::identity_provider::Builder {
        crate::model::identity_provider::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentityProviderType {
    #[allow(missing_docs)] // documentation missing in model
    Facebook,
    #[allow(missing_docs)] // documentation missing in model
    Google,
    #[allow(missing_docs)] // documentation missing in model
    LoginWithAmazon,
    #[allow(missing_docs)] // documentation missing in model
    Oidc,
    #[allow(missing_docs)] // documentation missing in model
    Saml,
    #[allow(missing_docs)] // documentation missing in model
    SignInWithApple,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentityProviderType {
    fn from(s: &str) -> Self {
        match s {
            "Facebook" => IdentityProviderType::Facebook,
            "Google" => IdentityProviderType::Google,
            "LoginWithAmazon" => IdentityProviderType::LoginWithAmazon,
            "OIDC" => IdentityProviderType::Oidc,
            "SAML" => IdentityProviderType::Saml,
            "SignInWithApple" => IdentityProviderType::SignInWithApple,
            other => IdentityProviderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentityProviderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentityProviderType::from(s))
    }
}
impl IdentityProviderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentityProviderType::Facebook => "Facebook",
            IdentityProviderType::Google => "Google",
            IdentityProviderType::LoginWithAmazon => "LoginWithAmazon",
            IdentityProviderType::Oidc => "OIDC",
            IdentityProviderType::Saml => "SAML",
            IdentityProviderType::SignInWithApple => "SignInWithApple",
            IdentityProviderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Facebook",
            "Google",
            "LoginWithAmazon",
            "OIDC",
            "SAML",
            "SignInWithApple",
        ]
    }
}
impl AsRef<str> for IdentityProviderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The browser settings resource that can be associated with a web portal. Once associated
/// with a web portal, browser settings control how the browser will behave once a user starts
/// a streaming session for the web portal. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BrowserSettings {
    /// <p>The ARN of the browser settings.</p>
    pub browser_settings_arn: std::option::Option<std::string::String>,
    /// <p>A list of web portal ARNs that this browser settings is associated with.</p>
    pub associated_portal_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all
    /// streaming sessions.</p>
    pub browser_policy: std::option::Option<std::string::String>,
}
impl BrowserSettings {
    /// <p>The ARN of the browser settings.</p>
    pub fn browser_settings_arn(&self) -> std::option::Option<&str> {
        self.browser_settings_arn.as_deref()
    }
    /// <p>A list of web portal ARNs that this browser settings is associated with.</p>
    pub fn associated_portal_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.associated_portal_arns.as_deref()
    }
    /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all
    /// streaming sessions.</p>
    pub fn browser_policy(&self) -> std::option::Option<&str> {
        self.browser_policy.as_deref()
    }
}
impl std::fmt::Debug for BrowserSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BrowserSettings");
        formatter.field("browser_settings_arn", &self.browser_settings_arn);
        formatter.field("associated_portal_arns", &self.associated_portal_arns);
        formatter.field("browser_policy", &self.browser_policy);
        formatter.finish()
    }
}
/// See [`BrowserSettings`](crate::model::BrowserSettings)
pub mod browser_settings {
    /// A builder for [`BrowserSettings`](crate::model::BrowserSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) browser_settings_arn: std::option::Option<std::string::String>,
        pub(crate) associated_portal_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) browser_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_settings_arn = input;
            self
        }
        /// Appends an item to `associated_portal_arns`.
        ///
        /// To override the contents of this collection use [`set_associated_portal_arns`](Self::set_associated_portal_arns).
        ///
        /// <p>A list of web portal ARNs that this browser settings is associated with.</p>
        pub fn associated_portal_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.associated_portal_arns.unwrap_or_default();
            v.push(input.into());
            self.associated_portal_arns = Some(v);
            self
        }
        /// <p>A list of web portal ARNs that this browser settings is associated with.</p>
        pub fn set_associated_portal_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.associated_portal_arns = input;
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all
        /// streaming sessions.</p>
        pub fn browser_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_policy = Some(input.into());
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all
        /// streaming sessions.</p>
        pub fn set_browser_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`BrowserSettings`](crate::model::BrowserSettings)
        pub fn build(self) -> crate::model::BrowserSettings {
            crate::model::BrowserSettings {
                browser_settings_arn: self.browser_settings_arn,
                associated_portal_arns: self.associated_portal_arns,
                browser_policy: self.browser_policy,
            }
        }
    }
}
impl BrowserSettings {
    /// Creates a new builder-style object to manufacture [`BrowserSettings`](crate::model::BrowserSettings)
    pub fn builder() -> crate::model::browser_settings::Builder {
        crate::model::browser_settings::Builder::default()
    }
}

/// <p>The tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The summary of user settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserSettingsSummary {
    /// <p>The ARN of the user settings.</p>
    pub user_settings_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether the user can copy text from the streaming session to the local
    /// device.</p>
    pub copy_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can paste text from the local device to the streaming
    /// session.</p>
    pub paste_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can download files from the streaming session to the local
    /// device.</p>
    pub download_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can upload files from the local device to the streaming
    /// session.</p>
    pub upload_allowed: std::option::Option<crate::model::EnabledType>,
    /// <p>Specifies whether the user can print to the local device.</p>
    pub print_allowed: std::option::Option<crate::model::EnabledType>,
}
impl UserSettingsSummary {
    /// <p>The ARN of the user settings.</p>
    pub fn user_settings_arn(&self) -> std::option::Option<&str> {
        self.user_settings_arn.as_deref()
    }
    /// <p>Specifies whether the user can copy text from the streaming session to the local
    /// device.</p>
    pub fn copy_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.copy_allowed.as_ref()
    }
    /// <p>Specifies whether the user can paste text from the local device to the streaming
    /// session.</p>
    pub fn paste_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.paste_allowed.as_ref()
    }
    /// <p>Specifies whether the user can download files from the streaming session to the local
    /// device.</p>
    pub fn download_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.download_allowed.as_ref()
    }
    /// <p>Specifies whether the user can upload files from the local device to the streaming
    /// session.</p>
    pub fn upload_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.upload_allowed.as_ref()
    }
    /// <p>Specifies whether the user can print to the local device.</p>
    pub fn print_allowed(&self) -> std::option::Option<&crate::model::EnabledType> {
        self.print_allowed.as_ref()
    }
}
impl std::fmt::Debug for UserSettingsSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserSettingsSummary");
        formatter.field("user_settings_arn", &self.user_settings_arn);
        formatter.field("copy_allowed", &self.copy_allowed);
        formatter.field("paste_allowed", &self.paste_allowed);
        formatter.field("download_allowed", &self.download_allowed);
        formatter.field("upload_allowed", &self.upload_allowed);
        formatter.field("print_allowed", &self.print_allowed);
        formatter.finish()
    }
}
/// See [`UserSettingsSummary`](crate::model::UserSettingsSummary)
pub mod user_settings_summary {
    /// A builder for [`UserSettingsSummary`](crate::model::UserSettingsSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_settings_arn: std::option::Option<std::string::String>,
        pub(crate) copy_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) paste_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) download_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) upload_allowed: std::option::Option<crate::model::EnabledType>,
        pub(crate) print_allowed: std::option::Option<crate::model::EnabledType>,
    }
    impl Builder {
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_settings_arn = input;
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local
        /// device.</p>
        pub fn copy_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.copy_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local
        /// device.</p>
        pub fn set_copy_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.copy_allowed = input;
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming
        /// session.</p>
        pub fn paste_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.paste_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming
        /// session.</p>
        pub fn set_paste_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.paste_allowed = input;
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local
        /// device.</p>
        pub fn download_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.download_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local
        /// device.</p>
        pub fn set_download_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.download_allowed = input;
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming
        /// session.</p>
        pub fn upload_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.upload_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming
        /// session.</p>
        pub fn set_upload_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.upload_allowed = input;
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn print_allowed(mut self, input: crate::model::EnabledType) -> Self {
            self.print_allowed = Some(input);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn set_print_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.print_allowed = input;
            self
        }
        /// Consumes the builder and constructs a [`UserSettingsSummary`](crate::model::UserSettingsSummary)
        pub fn build(self) -> crate::model::UserSettingsSummary {
            crate::model::UserSettingsSummary {
                user_settings_arn: self.user_settings_arn,
                copy_allowed: self.copy_allowed,
                paste_allowed: self.paste_allowed,
                download_allowed: self.download_allowed,
                upload_allowed: self.upload_allowed,
                print_allowed: self.print_allowed,
            }
        }
    }
}
impl UserSettingsSummary {
    /// Creates a new builder-style object to manufacture [`UserSettingsSummary`](crate::model::UserSettingsSummary)
    pub fn builder() -> crate::model::user_settings_summary::Builder {
        crate::model::user_settings_summary::Builder::default()
    }
}

/// <p>The summary of the trust store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustStoreSummary {
    /// <p>The ARN of the trust store.</p>
    pub trust_store_arn: std::option::Option<std::string::String>,
}
impl TrustStoreSummary {
    /// <p>The ARN of the trust store.</p>
    pub fn trust_store_arn(&self) -> std::option::Option<&str> {
        self.trust_store_arn.as_deref()
    }
}
impl std::fmt::Debug for TrustStoreSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustStoreSummary");
        formatter.field("trust_store_arn", &self.trust_store_arn);
        formatter.finish()
    }
}
/// See [`TrustStoreSummary`](crate::model::TrustStoreSummary)
pub mod trust_store_summary {
    /// A builder for [`TrustStoreSummary`](crate::model::TrustStoreSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_store_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_store_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustStoreSummary`](crate::model::TrustStoreSummary)
        pub fn build(self) -> crate::model::TrustStoreSummary {
            crate::model::TrustStoreSummary {
                trust_store_arn: self.trust_store_arn,
            }
        }
    }
}
impl TrustStoreSummary {
    /// Creates a new builder-style object to manufacture [`TrustStoreSummary`](crate::model::TrustStoreSummary)
    pub fn builder() -> crate::model::trust_store_summary::Builder {
        crate::model::trust_store_summary::Builder::default()
    }
}

/// <p>The summary of the certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateSummary {
    /// <p>A hexadecimal identifier for the certificate.</p>
    pub thumbprint: std::option::Option<std::string::String>,
    /// <p>The entity the certificate belongs to.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The entity that issued the certificate.</p>
    pub issuer: std::option::Option<std::string::String>,
    /// <p>The certificate is not valid before this date.</p>
    pub not_valid_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The certificate is not valid after this date.</p>
    pub not_valid_after: std::option::Option<aws_smithy_types::DateTime>,
}
impl CertificateSummary {
    /// <p>A hexadecimal identifier for the certificate.</p>
    pub fn thumbprint(&self) -> std::option::Option<&str> {
        self.thumbprint.as_deref()
    }
    /// <p>The entity the certificate belongs to.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The entity that issued the certificate.</p>
    pub fn issuer(&self) -> std::option::Option<&str> {
        self.issuer.as_deref()
    }
    /// <p>The certificate is not valid before this date.</p>
    pub fn not_valid_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.not_valid_before.as_ref()
    }
    /// <p>The certificate is not valid after this date.</p>
    pub fn not_valid_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.not_valid_after.as_ref()
    }
}
impl std::fmt::Debug for CertificateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateSummary");
        formatter.field("thumbprint", &self.thumbprint);
        formatter.field("subject", &self.subject);
        formatter.field("issuer", &self.issuer);
        formatter.field("not_valid_before", &self.not_valid_before);
        formatter.field("not_valid_after", &self.not_valid_after);
        formatter.finish()
    }
}
/// See [`CertificateSummary`](crate::model::CertificateSummary)
pub mod certificate_summary {
    /// A builder for [`CertificateSummary`](crate::model::CertificateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thumbprint: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<std::string::String>,
        pub(crate) not_valid_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) not_valid_after: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A hexadecimal identifier for the certificate.</p>
        pub fn thumbprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.thumbprint = Some(input.into());
            self
        }
        /// <p>A hexadecimal identifier for the certificate.</p>
        pub fn set_thumbprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thumbprint = input;
            self
        }
        /// <p>The entity the certificate belongs to.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The entity the certificate belongs to.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The entity that issued the certificate.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The entity that issued the certificate.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// <p>The certificate is not valid before this date.</p>
        pub fn not_valid_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_valid_before = Some(input);
            self
        }
        /// <p>The certificate is not valid before this date.</p>
        pub fn set_not_valid_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_valid_before = input;
            self
        }
        /// <p>The certificate is not valid after this date.</p>
        pub fn not_valid_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_valid_after = Some(input);
            self
        }
        /// <p>The certificate is not valid after this date.</p>
        pub fn set_not_valid_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_valid_after = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateSummary`](crate::model::CertificateSummary)
        pub fn build(self) -> crate::model::CertificateSummary {
            crate::model::CertificateSummary {
                thumbprint: self.thumbprint,
                subject: self.subject,
                issuer: self.issuer,
                not_valid_before: self.not_valid_before,
                not_valid_after: self.not_valid_after,
            }
        }
    }
}
impl CertificateSummary {
    /// Creates a new builder-style object to manufacture [`CertificateSummary`](crate::model::CertificateSummary)
    pub fn builder() -> crate::model::certificate_summary::Builder {
        crate::model::certificate_summary::Builder::default()
    }
}

/// <p>The summary of the portal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortalSummary {
    /// <p>The ARN of the web portal.</p>
    pub portal_arn: std::option::Option<std::string::String>,
    /// <p>The renderer that is used in streaming sessions.</p>
    pub renderer_type: std::option::Option<crate::model::RendererType>,
    /// <p>The browser type of the web portal.</p>
    pub browser_type: std::option::Option<crate::model::BrowserType>,
    /// <p>The status of the web portal.</p>
    pub portal_status: std::option::Option<crate::model::PortalStatus>,
    /// <p>The endpoint URL of the web portal that users access in order to start streaming
    /// sessions.</p>
    pub portal_endpoint: std::option::Option<std::string::String>,
    /// <p>The name of the web portal.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The creation date of the web portal.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ARN of the browser settings that is associated with the web portal.</p>
    pub browser_settings_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the user settings that is associated with the web portal.</p>
    pub user_settings_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the network settings that is associated with the web portal.</p>
    pub network_settings_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the trust that is associated with this web portal.</p>
    pub trust_store_arn: std::option::Option<std::string::String>,
}
impl PortalSummary {
    /// <p>The ARN of the web portal.</p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
    /// <p>The renderer that is used in streaming sessions.</p>
    pub fn renderer_type(&self) -> std::option::Option<&crate::model::RendererType> {
        self.renderer_type.as_ref()
    }
    /// <p>The browser type of the web portal.</p>
    pub fn browser_type(&self) -> std::option::Option<&crate::model::BrowserType> {
        self.browser_type.as_ref()
    }
    /// <p>The status of the web portal.</p>
    pub fn portal_status(&self) -> std::option::Option<&crate::model::PortalStatus> {
        self.portal_status.as_ref()
    }
    /// <p>The endpoint URL of the web portal that users access in order to start streaming
    /// sessions.</p>
    pub fn portal_endpoint(&self) -> std::option::Option<&str> {
        self.portal_endpoint.as_deref()
    }
    /// <p>The name of the web portal.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The creation date of the web portal.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The ARN of the browser settings that is associated with the web portal.</p>
    pub fn browser_settings_arn(&self) -> std::option::Option<&str> {
        self.browser_settings_arn.as_deref()
    }
    /// <p>The ARN of the user settings that is associated with the web portal.</p>
    pub fn user_settings_arn(&self) -> std::option::Option<&str> {
        self.user_settings_arn.as_deref()
    }
    /// <p>The ARN of the network settings that is associated with the web portal.</p>
    pub fn network_settings_arn(&self) -> std::option::Option<&str> {
        self.network_settings_arn.as_deref()
    }
    /// <p>The ARN of the trust that is associated with this web portal.</p>
    pub fn trust_store_arn(&self) -> std::option::Option<&str> {
        self.trust_store_arn.as_deref()
    }
}
impl std::fmt::Debug for PortalSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortalSummary");
        formatter.field("portal_arn", &self.portal_arn);
        formatter.field("renderer_type", &self.renderer_type);
        formatter.field("browser_type", &self.browser_type);
        formatter.field("portal_status", &self.portal_status);
        formatter.field("portal_endpoint", &self.portal_endpoint);
        formatter.field("display_name", &self.display_name);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("browser_settings_arn", &self.browser_settings_arn);
        formatter.field("user_settings_arn", &self.user_settings_arn);
        formatter.field("network_settings_arn", &self.network_settings_arn);
        formatter.field("trust_store_arn", &self.trust_store_arn);
        formatter.finish()
    }
}
/// See [`PortalSummary`](crate::model::PortalSummary)
pub mod portal_summary {
    /// A builder for [`PortalSummary`](crate::model::PortalSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_arn: std::option::Option<std::string::String>,
        pub(crate) renderer_type: std::option::Option<crate::model::RendererType>,
        pub(crate) browser_type: std::option::Option<crate::model::BrowserType>,
        pub(crate) portal_status: std::option::Option<crate::model::PortalStatus>,
        pub(crate) portal_endpoint: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) browser_settings_arn: std::option::Option<std::string::String>,
        pub(crate) user_settings_arn: std::option::Option<std::string::String>,
        pub(crate) network_settings_arn: std::option::Option<std::string::String>,
        pub(crate) trust_store_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// <p>The renderer that is used in streaming sessions.</p>
        pub fn renderer_type(mut self, input: crate::model::RendererType) -> Self {
            self.renderer_type = Some(input);
            self
        }
        /// <p>The renderer that is used in streaming sessions.</p>
        pub fn set_renderer_type(
            mut self,
            input: std::option::Option<crate::model::RendererType>,
        ) -> Self {
            self.renderer_type = input;
            self
        }
        /// <p>The browser type of the web portal.</p>
        pub fn browser_type(mut self, input: crate::model::BrowserType) -> Self {
            self.browser_type = Some(input);
            self
        }
        /// <p>The browser type of the web portal.</p>
        pub fn set_browser_type(
            mut self,
            input: std::option::Option<crate::model::BrowserType>,
        ) -> Self {
            self.browser_type = input;
            self
        }
        /// <p>The status of the web portal.</p>
        pub fn portal_status(mut self, input: crate::model::PortalStatus) -> Self {
            self.portal_status = Some(input);
            self
        }
        /// <p>The status of the web portal.</p>
        pub fn set_portal_status(
            mut self,
            input: std::option::Option<crate::model::PortalStatus>,
        ) -> Self {
            self.portal_status = input;
            self
        }
        /// <p>The endpoint URL of the web portal that users access in order to start streaming
        /// sessions.</p>
        pub fn portal_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint URL of the web portal that users access in order to start streaming
        /// sessions.</p>
        pub fn set_portal_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_endpoint = input;
            self
        }
        /// <p>The name of the web portal.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the web portal.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The creation date of the web portal.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date of the web portal.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The ARN of the browser settings that is associated with the web portal.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the browser settings that is associated with the web portal.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_settings_arn = input;
            self
        }
        /// <p>The ARN of the user settings that is associated with the web portal.</p>
        pub fn user_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user settings that is associated with the web portal.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_settings_arn = input;
            self
        }
        /// <p>The ARN of the network settings that is associated with the web portal.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network settings that is associated with the web portal.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_settings_arn = input;
            self
        }
        /// <p>The ARN of the trust that is associated with this web portal.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust that is associated with this web portal.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_store_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PortalSummary`](crate::model::PortalSummary)
        pub fn build(self) -> crate::model::PortalSummary {
            crate::model::PortalSummary {
                portal_arn: self.portal_arn,
                renderer_type: self.renderer_type,
                browser_type: self.browser_type,
                portal_status: self.portal_status,
                portal_endpoint: self.portal_endpoint,
                display_name: self.display_name,
                creation_date: self.creation_date,
                browser_settings_arn: self.browser_settings_arn,
                user_settings_arn: self.user_settings_arn,
                network_settings_arn: self.network_settings_arn,
                trust_store_arn: self.trust_store_arn,
            }
        }
    }
}
impl PortalSummary {
    /// Creates a new builder-style object to manufacture [`PortalSummary`](crate::model::PortalSummary)
    pub fn builder() -> crate::model::portal_summary::Builder {
        crate::model::portal_summary::Builder::default()
    }
}

/// <p>The summary of network settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkSettingsSummary {
    /// <p>The ARN of the network settings.</p>
    pub network_settings_arn: std::option::Option<std::string::String>,
    /// <p>The VPC ID of the network settings.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl NetworkSettingsSummary {
    /// <p>The ARN of the network settings.</p>
    pub fn network_settings_arn(&self) -> std::option::Option<&str> {
        self.network_settings_arn.as_deref()
    }
    /// <p>The VPC ID of the network settings.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for NetworkSettingsSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkSettingsSummary");
        formatter.field("network_settings_arn", &self.network_settings_arn);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`NetworkSettingsSummary`](crate::model::NetworkSettingsSummary)
pub mod network_settings_summary {
    /// A builder for [`NetworkSettingsSummary`](crate::model::NetworkSettingsSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_settings_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_settings_arn = input;
            self
        }
        /// <p>The VPC ID of the network settings.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC ID of the network settings.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkSettingsSummary`](crate::model::NetworkSettingsSummary)
        pub fn build(self) -> crate::model::NetworkSettingsSummary {
            crate::model::NetworkSettingsSummary {
                network_settings_arn: self.network_settings_arn,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl NetworkSettingsSummary {
    /// Creates a new builder-style object to manufacture [`NetworkSettingsSummary`](crate::model::NetworkSettingsSummary)
    pub fn builder() -> crate::model::network_settings_summary::Builder {
        crate::model::network_settings_summary::Builder::default()
    }
}

/// <p>The summary of the identity provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityProviderSummary {
    /// <p>The ARN of the identity provider.</p>
    pub identity_provider_arn: std::option::Option<std::string::String>,
    /// <p>The identity provider name.</p>
    pub identity_provider_name: std::option::Option<std::string::String>,
    /// <p>The identity provider type.</p>
    pub identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
}
impl IdentityProviderSummary {
    /// <p>The ARN of the identity provider.</p>
    pub fn identity_provider_arn(&self) -> std::option::Option<&str> {
        self.identity_provider_arn.as_deref()
    }
    /// <p>The identity provider name.</p>
    pub fn identity_provider_name(&self) -> std::option::Option<&str> {
        self.identity_provider_name.as_deref()
    }
    /// <p>The identity provider type.</p>
    pub fn identity_provider_type(
        &self,
    ) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider_type.as_ref()
    }
}
impl std::fmt::Debug for IdentityProviderSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityProviderSummary");
        formatter.field("identity_provider_arn", &self.identity_provider_arn);
        formatter.field("identity_provider_name", &self.identity_provider_name);
        formatter.field("identity_provider_type", &self.identity_provider_type);
        formatter.finish()
    }
}
/// See [`IdentityProviderSummary`](crate::model::IdentityProviderSummary)
pub mod identity_provider_summary {
    /// A builder for [`IdentityProviderSummary`](crate::model::IdentityProviderSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider_arn: std::option::Option<std::string::String>,
        pub(crate) identity_provider_name: std::option::Option<std::string::String>,
        pub(crate) identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
    }
    impl Builder {
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_arn = input;
            self
        }
        /// <p>The identity provider name.</p>
        pub fn identity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_provider_name = Some(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_name = input;
            self
        }
        /// <p>The identity provider type.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider_type = Some(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider_type = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityProviderSummary`](crate::model::IdentityProviderSummary)
        pub fn build(self) -> crate::model::IdentityProviderSummary {
            crate::model::IdentityProviderSummary {
                identity_provider_arn: self.identity_provider_arn,
                identity_provider_name: self.identity_provider_name,
                identity_provider_type: self.identity_provider_type,
            }
        }
    }
}
impl IdentityProviderSummary {
    /// Creates a new builder-style object to manufacture [`IdentityProviderSummary`](crate::model::IdentityProviderSummary)
    pub fn builder() -> crate::model::identity_provider_summary::Builder {
        crate::model::identity_provider_summary::Builder::default()
    }
}

/// <p>The summary for browser settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BrowserSettingsSummary {
    /// <p>The ARN of the browser settings.</p>
    pub browser_settings_arn: std::option::Option<std::string::String>,
}
impl BrowserSettingsSummary {
    /// <p>The ARN of the browser settings.</p>
    pub fn browser_settings_arn(&self) -> std::option::Option<&str> {
        self.browser_settings_arn.as_deref()
    }
}
impl std::fmt::Debug for BrowserSettingsSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BrowserSettingsSummary");
        formatter.field("browser_settings_arn", &self.browser_settings_arn);
        formatter.finish()
    }
}
/// See [`BrowserSettingsSummary`](crate::model::BrowserSettingsSummary)
pub mod browser_settings_summary {
    /// A builder for [`BrowserSettingsSummary`](crate::model::BrowserSettingsSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) browser_settings_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.browser_settings_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.browser_settings_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BrowserSettingsSummary`](crate::model::BrowserSettingsSummary)
        pub fn build(self) -> crate::model::BrowserSettingsSummary {
            crate::model::BrowserSettingsSummary {
                browser_settings_arn: self.browser_settings_arn,
            }
        }
    }
}
impl BrowserSettingsSummary {
    /// Creates a new builder-style object to manufacture [`BrowserSettingsSummary`](crate::model::BrowserSettingsSummary)
    pub fn builder() -> crate::model::browser_settings_summary::Builder {
        crate::model::browser_settings_summary::Builder::default()
    }
}

/// <p>The certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Certificate {
    /// <p>A hexadecimal identifier for the certificate.</p>
    pub thumbprint: std::option::Option<std::string::String>,
    /// <p>The entity the certificate belongs to.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The entity that issued the certificate.</p>
    pub issuer: std::option::Option<std::string::String>,
    /// <p>The certificate is not valid before this date.</p>
    pub not_valid_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The certificate is not valid after this date.</p>
    pub not_valid_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The body of the certificate.</p>
    pub body: std::option::Option<aws_smithy_types::Blob>,
}
impl Certificate {
    /// <p>A hexadecimal identifier for the certificate.</p>
    pub fn thumbprint(&self) -> std::option::Option<&str> {
        self.thumbprint.as_deref()
    }
    /// <p>The entity the certificate belongs to.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The entity that issued the certificate.</p>
    pub fn issuer(&self) -> std::option::Option<&str> {
        self.issuer.as_deref()
    }
    /// <p>The certificate is not valid before this date.</p>
    pub fn not_valid_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.not_valid_before.as_ref()
    }
    /// <p>The certificate is not valid after this date.</p>
    pub fn not_valid_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.not_valid_after.as_ref()
    }
    /// <p>The body of the certificate.</p>
    pub fn body(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.body.as_ref()
    }
}
impl std::fmt::Debug for Certificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Certificate");
        formatter.field("thumbprint", &self.thumbprint);
        formatter.field("subject", &self.subject);
        formatter.field("issuer", &self.issuer);
        formatter.field("not_valid_before", &self.not_valid_before);
        formatter.field("not_valid_after", &self.not_valid_after);
        formatter.field("body", &self.body);
        formatter.finish()
    }
}
/// See [`Certificate`](crate::model::Certificate)
pub mod certificate {
    /// A builder for [`Certificate`](crate::model::Certificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thumbprint: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<std::string::String>,
        pub(crate) not_valid_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) not_valid_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) body: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>A hexadecimal identifier for the certificate.</p>
        pub fn thumbprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.thumbprint = Some(input.into());
            self
        }
        /// <p>A hexadecimal identifier for the certificate.</p>
        pub fn set_thumbprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thumbprint = input;
            self
        }
        /// <p>The entity the certificate belongs to.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The entity the certificate belongs to.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The entity that issued the certificate.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The entity that issued the certificate.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// <p>The certificate is not valid before this date.</p>
        pub fn not_valid_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_valid_before = Some(input);
            self
        }
        /// <p>The certificate is not valid before this date.</p>
        pub fn set_not_valid_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_valid_before = input;
            self
        }
        /// <p>The certificate is not valid after this date.</p>
        pub fn not_valid_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_valid_after = Some(input);
            self
        }
        /// <p>The certificate is not valid after this date.</p>
        pub fn set_not_valid_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_valid_after = input;
            self
        }
        /// <p>The body of the certificate.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The body of the certificate.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`Certificate`](crate::model::Certificate)
        pub fn build(self) -> crate::model::Certificate {
            crate::model::Certificate {
                thumbprint: self.thumbprint,
                subject: self.subject,
                issuer: self.issuer,
                not_valid_before: self.not_valid_before,
                not_valid_after: self.not_valid_after,
                body: self.body,
            }
        }
    }
}
impl Certificate {
    /// Creates a new builder-style object to manufacture [`Certificate`](crate::model::Certificate)
    pub fn builder() -> crate::model::certificate::Builder {
        crate::model::certificate::Builder::default()
    }
}

/// <p>A trust store that can be associated with a web portal. A trust store contains
/// certificate authority (CA) certificates. Once associated with a web portal, the browser in
/// a streaming session will recognize certificates that have been issued using any of the CAs
/// in the trust store. If your organization has internal websites that use certificates issued
/// by private CAs, you should add the private CA certificate to the trust store. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustStore {
    /// <p>A list of web portal ARNs that this trust store is associated with.</p>
    pub associated_portal_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARN of the trust store.</p>
    pub trust_store_arn: std::option::Option<std::string::String>,
}
impl TrustStore {
    /// <p>A list of web portal ARNs that this trust store is associated with.</p>
    pub fn associated_portal_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.associated_portal_arns.as_deref()
    }
    /// <p>The ARN of the trust store.</p>
    pub fn trust_store_arn(&self) -> std::option::Option<&str> {
        self.trust_store_arn.as_deref()
    }
}
impl std::fmt::Debug for TrustStore {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustStore");
        formatter.field("associated_portal_arns", &self.associated_portal_arns);
        formatter.field("trust_store_arn", &self.trust_store_arn);
        formatter.finish()
    }
}
/// See [`TrustStore`](crate::model::TrustStore)
pub mod trust_store {
    /// A builder for [`TrustStore`](crate::model::TrustStore)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) associated_portal_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) trust_store_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `associated_portal_arns`.
        ///
        /// To override the contents of this collection use [`set_associated_portal_arns`](Self::set_associated_portal_arns).
        ///
        /// <p>A list of web portal ARNs that this trust store is associated with.</p>
        pub fn associated_portal_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.associated_portal_arns.unwrap_or_default();
            v.push(input.into());
            self.associated_portal_arns = Some(v);
            self
        }
        /// <p>A list of web portal ARNs that this trust store is associated with.</p>
        pub fn set_associated_portal_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.associated_portal_arns = input;
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_store_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustStore`](crate::model::TrustStore)
        pub fn build(self) -> crate::model::TrustStore {
            crate::model::TrustStore {
                associated_portal_arns: self.associated_portal_arns,
                trust_store_arn: self.trust_store_arn,
            }
        }
    }
}
impl TrustStore {
    /// Creates a new builder-style object to manufacture [`TrustStore`](crate::model::TrustStore)
    pub fn builder() -> crate::model::trust_store::Builder {
        crate::model::trust_store::Builder::default()
    }
}
