// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon WorkSpaces Web
///
/// Client for invoking operations on Amazon WorkSpaces Web. Each operation on Amazon WorkSpaces Web is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_workspacesweb::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_workspacesweb::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_workspacesweb::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateBrowserSettings` operation.
    ///
    /// See [`AssociateBrowserSettings`](crate::client::fluent_builders::AssociateBrowserSettings) for more information about the
    /// operation and its arguments.
    pub fn associate_browser_settings(&self) -> fluent_builders::AssociateBrowserSettings<C, M, R> {
        fluent_builders::AssociateBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateNetworkSettings` operation.
    ///
    /// See [`AssociateNetworkSettings`](crate::client::fluent_builders::AssociateNetworkSettings) for more information about the
    /// operation and its arguments.
    pub fn associate_network_settings(&self) -> fluent_builders::AssociateNetworkSettings<C, M, R> {
        fluent_builders::AssociateNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateTrustStore` operation.
    ///
    /// See [`AssociateTrustStore`](crate::client::fluent_builders::AssociateTrustStore) for more information about the
    /// operation and its arguments.
    pub fn associate_trust_store(&self) -> fluent_builders::AssociateTrustStore<C, M, R> {
        fluent_builders::AssociateTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateUserSettings` operation.
    ///
    /// See [`AssociateUserSettings`](crate::client::fluent_builders::AssociateUserSettings) for more information about the
    /// operation and its arguments.
    pub fn associate_user_settings(&self) -> fluent_builders::AssociateUserSettings<C, M, R> {
        fluent_builders::AssociateUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBrowserSettings` operation.
    ///
    /// See [`CreateBrowserSettings`](crate::client::fluent_builders::CreateBrowserSettings) for more information about the
    /// operation and its arguments.
    pub fn create_browser_settings(&self) -> fluent_builders::CreateBrowserSettings<C, M, R> {
        fluent_builders::CreateBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIdentityProvider` operation.
    ///
    /// See [`CreateIdentityProvider`](crate::client::fluent_builders::CreateIdentityProvider) for more information about the
    /// operation and its arguments.
    pub fn create_identity_provider(&self) -> fluent_builders::CreateIdentityProvider<C, M, R> {
        fluent_builders::CreateIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNetworkSettings` operation.
    ///
    /// See [`CreateNetworkSettings`](crate::client::fluent_builders::CreateNetworkSettings) for more information about the
    /// operation and its arguments.
    pub fn create_network_settings(&self) -> fluent_builders::CreateNetworkSettings<C, M, R> {
        fluent_builders::CreateNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePortal` operation.
    ///
    /// See [`CreatePortal`](crate::client::fluent_builders::CreatePortal) for more information about the
    /// operation and its arguments.
    pub fn create_portal(&self) -> fluent_builders::CreatePortal<C, M, R> {
        fluent_builders::CreatePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrustStore` operation.
    ///
    /// See [`CreateTrustStore`](crate::client::fluent_builders::CreateTrustStore) for more information about the
    /// operation and its arguments.
    pub fn create_trust_store(&self) -> fluent_builders::CreateTrustStore<C, M, R> {
        fluent_builders::CreateTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUserSettings` operation.
    ///
    /// See [`CreateUserSettings`](crate::client::fluent_builders::CreateUserSettings) for more information about the
    /// operation and its arguments.
    pub fn create_user_settings(&self) -> fluent_builders::CreateUserSettings<C, M, R> {
        fluent_builders::CreateUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBrowserSettings` operation.
    ///
    /// See [`DeleteBrowserSettings`](crate::client::fluent_builders::DeleteBrowserSettings) for more information about the
    /// operation and its arguments.
    pub fn delete_browser_settings(&self) -> fluent_builders::DeleteBrowserSettings<C, M, R> {
        fluent_builders::DeleteBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIdentityProvider` operation.
    ///
    /// See [`DeleteIdentityProvider`](crate::client::fluent_builders::DeleteIdentityProvider) for more information about the
    /// operation and its arguments.
    pub fn delete_identity_provider(&self) -> fluent_builders::DeleteIdentityProvider<C, M, R> {
        fluent_builders::DeleteIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkSettings` operation.
    ///
    /// See [`DeleteNetworkSettings`](crate::client::fluent_builders::DeleteNetworkSettings) for more information about the
    /// operation and its arguments.
    pub fn delete_network_settings(&self) -> fluent_builders::DeleteNetworkSettings<C, M, R> {
        fluent_builders::DeleteNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePortal` operation.
    ///
    /// See [`DeletePortal`](crate::client::fluent_builders::DeletePortal) for more information about the
    /// operation and its arguments.
    pub fn delete_portal(&self) -> fluent_builders::DeletePortal<C, M, R> {
        fluent_builders::DeletePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrustStore` operation.
    ///
    /// See [`DeleteTrustStore`](crate::client::fluent_builders::DeleteTrustStore) for more information about the
    /// operation and its arguments.
    pub fn delete_trust_store(&self) -> fluent_builders::DeleteTrustStore<C, M, R> {
        fluent_builders::DeleteTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUserSettings` operation.
    ///
    /// See [`DeleteUserSettings`](crate::client::fluent_builders::DeleteUserSettings) for more information about the
    /// operation and its arguments.
    pub fn delete_user_settings(&self) -> fluent_builders::DeleteUserSettings<C, M, R> {
        fluent_builders::DeleteUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateBrowserSettings` operation.
    ///
    /// See [`DisassociateBrowserSettings`](crate::client::fluent_builders::DisassociateBrowserSettings) for more information about the
    /// operation and its arguments.
    pub fn disassociate_browser_settings(
        &self,
    ) -> fluent_builders::DisassociateBrowserSettings<C, M, R> {
        fluent_builders::DisassociateBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateNetworkSettings` operation.
    ///
    /// See [`DisassociateNetworkSettings`](crate::client::fluent_builders::DisassociateNetworkSettings) for more information about the
    /// operation and its arguments.
    pub fn disassociate_network_settings(
        &self,
    ) -> fluent_builders::DisassociateNetworkSettings<C, M, R> {
        fluent_builders::DisassociateNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateTrustStore` operation.
    ///
    /// See [`DisassociateTrustStore`](crate::client::fluent_builders::DisassociateTrustStore) for more information about the
    /// operation and its arguments.
    pub fn disassociate_trust_store(&self) -> fluent_builders::DisassociateTrustStore<C, M, R> {
        fluent_builders::DisassociateTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateUserSettings` operation.
    ///
    /// See [`DisassociateUserSettings`](crate::client::fluent_builders::DisassociateUserSettings) for more information about the
    /// operation and its arguments.
    pub fn disassociate_user_settings(&self) -> fluent_builders::DisassociateUserSettings<C, M, R> {
        fluent_builders::DisassociateUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBrowserSettings` operation.
    ///
    /// See [`GetBrowserSettings`](crate::client::fluent_builders::GetBrowserSettings) for more information about the
    /// operation and its arguments.
    pub fn get_browser_settings(&self) -> fluent_builders::GetBrowserSettings<C, M, R> {
        fluent_builders::GetBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIdentityProvider` operation.
    ///
    /// See [`GetIdentityProvider`](crate::client::fluent_builders::GetIdentityProvider) for more information about the
    /// operation and its arguments.
    pub fn get_identity_provider(&self) -> fluent_builders::GetIdentityProvider<C, M, R> {
        fluent_builders::GetIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetworkSettings` operation.
    ///
    /// See [`GetNetworkSettings`](crate::client::fluent_builders::GetNetworkSettings) for more information about the
    /// operation and its arguments.
    pub fn get_network_settings(&self) -> fluent_builders::GetNetworkSettings<C, M, R> {
        fluent_builders::GetNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPortal` operation.
    ///
    /// See [`GetPortal`](crate::client::fluent_builders::GetPortal) for more information about the
    /// operation and its arguments.
    pub fn get_portal(&self) -> fluent_builders::GetPortal<C, M, R> {
        fluent_builders::GetPortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPortalServiceProviderMetadata` operation.
    ///
    /// See [`GetPortalServiceProviderMetadata`](crate::client::fluent_builders::GetPortalServiceProviderMetadata) for more information about the
    /// operation and its arguments.
    pub fn get_portal_service_provider_metadata(
        &self,
    ) -> fluent_builders::GetPortalServiceProviderMetadata<C, M, R> {
        fluent_builders::GetPortalServiceProviderMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTrustStore` operation.
    ///
    /// See [`GetTrustStore`](crate::client::fluent_builders::GetTrustStore) for more information about the
    /// operation and its arguments.
    pub fn get_trust_store(&self) -> fluent_builders::GetTrustStore<C, M, R> {
        fluent_builders::GetTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTrustStoreCertificate` operation.
    ///
    /// See [`GetTrustStoreCertificate`](crate::client::fluent_builders::GetTrustStoreCertificate) for more information about the
    /// operation and its arguments.
    pub fn get_trust_store_certificate(
        &self,
    ) -> fluent_builders::GetTrustStoreCertificate<C, M, R> {
        fluent_builders::GetTrustStoreCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUserSettings` operation.
    ///
    /// See [`GetUserSettings`](crate::client::fluent_builders::GetUserSettings) for more information about the
    /// operation and its arguments.
    pub fn get_user_settings(&self) -> fluent_builders::GetUserSettings<C, M, R> {
        fluent_builders::GetUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBrowserSettings` operation.
    ///
    /// See [`ListBrowserSettings`](crate::client::fluent_builders::ListBrowserSettings) for more information about the
    /// operation and its arguments.
    pub fn list_browser_settings(&self) -> fluent_builders::ListBrowserSettings<C, M, R> {
        fluent_builders::ListBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIdentityProviders` operation.
    ///
    /// See [`ListIdentityProviders`](crate::client::fluent_builders::ListIdentityProviders) for more information about the
    /// operation and its arguments.
    pub fn list_identity_providers(&self) -> fluent_builders::ListIdentityProviders<C, M, R> {
        fluent_builders::ListIdentityProviders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNetworkSettings` operation.
    ///
    /// See [`ListNetworkSettings`](crate::client::fluent_builders::ListNetworkSettings) for more information about the
    /// operation and its arguments.
    pub fn list_network_settings(&self) -> fluent_builders::ListNetworkSettings<C, M, R> {
        fluent_builders::ListNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPortals` operation.
    ///
    /// See [`ListPortals`](crate::client::fluent_builders::ListPortals) for more information about the
    /// operation and its arguments.
    pub fn list_portals(&self) -> fluent_builders::ListPortals<C, M, R> {
        fluent_builders::ListPortals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrustStoreCertificates` operation.
    ///
    /// See [`ListTrustStoreCertificates`](crate::client::fluent_builders::ListTrustStoreCertificates) for more information about the
    /// operation and its arguments.
    pub fn list_trust_store_certificates(
        &self,
    ) -> fluent_builders::ListTrustStoreCertificates<C, M, R> {
        fluent_builders::ListTrustStoreCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrustStores` operation.
    ///
    /// See [`ListTrustStores`](crate::client::fluent_builders::ListTrustStores) for more information about the
    /// operation and its arguments.
    pub fn list_trust_stores(&self) -> fluent_builders::ListTrustStores<C, M, R> {
        fluent_builders::ListTrustStores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUserSettings` operation.
    ///
    /// See [`ListUserSettings`](crate::client::fluent_builders::ListUserSettings) for more information about the
    /// operation and its arguments.
    pub fn list_user_settings(&self) -> fluent_builders::ListUserSettings<C, M, R> {
        fluent_builders::ListUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBrowserSettings` operation.
    ///
    /// See [`UpdateBrowserSettings`](crate::client::fluent_builders::UpdateBrowserSettings) for more information about the
    /// operation and its arguments.
    pub fn update_browser_settings(&self) -> fluent_builders::UpdateBrowserSettings<C, M, R> {
        fluent_builders::UpdateBrowserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIdentityProvider` operation.
    ///
    /// See [`UpdateIdentityProvider`](crate::client::fluent_builders::UpdateIdentityProvider) for more information about the
    /// operation and its arguments.
    pub fn update_identity_provider(&self) -> fluent_builders::UpdateIdentityProvider<C, M, R> {
        fluent_builders::UpdateIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNetworkSettings` operation.
    ///
    /// See [`UpdateNetworkSettings`](crate::client::fluent_builders::UpdateNetworkSettings) for more information about the
    /// operation and its arguments.
    pub fn update_network_settings(&self) -> fluent_builders::UpdateNetworkSettings<C, M, R> {
        fluent_builders::UpdateNetworkSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePortal` operation.
    ///
    /// See [`UpdatePortal`](crate::client::fluent_builders::UpdatePortal) for more information about the
    /// operation and its arguments.
    pub fn update_portal(&self) -> fluent_builders::UpdatePortal<C, M, R> {
        fluent_builders::UpdatePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTrustStore` operation.
    ///
    /// See [`UpdateTrustStore`](crate::client::fluent_builders::UpdateTrustStore) for more information about the
    /// operation and its arguments.
    pub fn update_trust_store(&self) -> fluent_builders::UpdateTrustStore<C, M, R> {
        fluent_builders::UpdateTrustStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserSettings` operation.
    ///
    /// See [`UpdateUserSettings`](crate::client::fluent_builders::UpdateUserSettings) for more information about the
    /// operation and its arguments.
    pub fn update_user_settings(&self) -> fluent_builders::UpdateUserSettings<C, M, R> {
        fluent_builders::UpdateUserSettings::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateBrowserSettings`.
    ///
    /// <p>Associates a browser settings resource with a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_browser_settings_input::Builder,
    }
    impl<C, M, R> AssociateBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateBrowserSettingsInputOperationOutputAlias,
                crate::output::AssociateBrowserSettingsOutput,
                crate::error::AssociateBrowserSettingsError,
                crate::input::AssociateBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_settings_arn(inp);
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateNetworkSettings`.
    ///
    /// <p>Associates a network settings resource with a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_network_settings_input::Builder,
    }
    impl<C, M, R> AssociateNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateNetworkSettingsInputOperationOutputAlias,
                crate::output::AssociateNetworkSettingsOutput,
                crate::error::AssociateNetworkSettingsError,
                crate::input::AssociateNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_settings_arn(inp);
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTrustStore`.
    ///
    /// <p>Associates a trust store with a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_trust_store_input::Builder,
    }
    impl<C, M, R> AssociateTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTrustStoreInputOperationOutputAlias,
                crate::output::AssociateTrustStoreOutput,
                crate::error::AssociateTrustStoreError,
                crate::input::AssociateTrustStoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(inp);
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateUserSettings`.
    ///
    /// <p>Associates a user settings resource with a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_user_settings_input::Builder,
    }
    impl<C, M, R> AssociateUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateUserSettingsInputOperationOutputAlias,
                crate::output::AssociateUserSettingsOutput,
                crate::error::AssociateUserSettingsError,
                crate::input::AssociateUserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_settings_arn(inp);
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBrowserSettings`.
    ///
    /// <p>Creates a browser settings resource that can be associated with a web portal. Once
    /// associated with a web portal, browser settings control how the browser will behave once a
    /// user starts a streaming session for the web portal. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_browser_settings_input::Builder,
    }
    impl<C, M, R> CreateBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBrowserSettingsInputOperationOutputAlias,
                crate::output::CreateBrowserSettingsOutput,
                crate::error::CreateBrowserSettingsError,
                crate::input::CreateBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the browser settings resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to the browser settings resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The custom managed key of the browser settings.</p>
        pub fn customer_managed_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_managed_key(inp);
            self
        }
        /// <p>The custom managed key of the browser settings.</p>
        pub fn set_customer_managed_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_managed_key(input);
            self
        }
        /// Adds a key-value pair to `additionalEncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_additional_encryption_context`](Self::set_additional_encryption_context).
        ///
        /// <p>Additional encryption context of the browser settings.</p>
        pub fn additional_encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_encryption_context(k, v);
            self
        }
        /// <p>Additional encryption context of the browser settings.</p>
        pub fn set_additional_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_encryption_context(input);
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all
        /// streaming sessions.</p>
        pub fn browser_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_policy(inp);
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all
        /// streaming sessions.</p>
        pub fn set_browser_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_policy(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK. </p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS SDK. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIdentityProvider`.
    ///
    /// <p>Creates an identity provider resource that is then associated with a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_identity_provider_input::Builder,
    }
    impl<C, M, R> CreateIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIdentityProviderInputOperationOutputAlias,
                crate::output::CreateIdentityProviderOutput,
                crate::error::CreateIdentityProviderError,
                crate::input::CreateIdentityProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The identity provider name.</p>
        pub fn identity_provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_name(inp);
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_name(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn identity_provider_type(mut self, inp: crate::model::IdentityProviderType) -> Self {
            self.inner = self.inner.identity_provider_type(inp);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_type(input);
            self
        }
        /// Adds a key-value pair to `identityProviderDetails`.
        ///
        /// To override the contents of this collection use [`set_identity_provider_details`](Self::set_identity_provider_details).
        ///
        /// <p>The identity provider details. The following list describes the provider detail keys for
        /// each identity provider type. </p>
        /// <ul>
        /// <li>
        /// <p>For Google and Login with Amazon:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For Facebook:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>api_version</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For Sign in with Apple:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>team_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>key_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>private_key</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For OIDC providers:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>attributes_request_method</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oidc_issuer</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_url</code>
        /// <i>if not available from discovery URL specified by
        /// <code>oidc_issuer</code> key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>token_url</code>
        /// <i>if not available from discovery URL specified by
        /// <code>oidc_issuer</code> key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>attributes_url</code>
        /// <i>if not available from discovery URL specified by
        /// <code>oidc_issuer</code> key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jwks_uri</code>
        /// <i>if not available from discovery URL specified by
        /// <code>oidc_issuer</code> key</i>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For SAML providers:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MetadataFile</code> OR <code>MetadataURL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IDPSignout</code>
        /// <i>optional</i>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn identity_provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_provider_details(k, v);
            self
        }
        /// <p>The identity provider details. The following list describes the provider detail keys for
        /// each identity provider type. </p>
        /// <ul>
        /// <li>
        /// <p>For Google and Login with Amazon:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For Facebook:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>api_version</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For Sign in with Apple:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>team_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>key_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>private_key</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For OIDC providers:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>client_id</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>client_secret</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>attributes_request_method</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oidc_issuer</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_scopes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>authorize_url</code>
        /// <i>if not available from discovery URL specified by
        /// <code>oidc_issuer</code> key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>token_url</code>
        /// <i>if not available from discovery URL specified by
        /// <code>oidc_issuer</code> key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>attributes_url</code>
        /// <i>if not available from discovery URL specified by
        /// <code>oidc_issuer</code> key</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jwks_uri</code>
        /// <i>if not available from discovery URL specified by
        /// <code>oidc_issuer</code> key</i>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For SAML providers:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MetadataFile</code> OR <code>MetadataURL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IDPSignout</code>
        /// <i>optional</i>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_details(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetworkSettings`.
    ///
    /// <p>Creates a network settings resource that can be associated with a web portal. Once
    /// associated with a web portal, network settings define how streaming instances will connect
    /// with your specified VPC. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_settings_input::Builder,
    }
    impl<C, M, R> CreateNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkSettingsInputOperationOutputAlias,
                crate::output::CreateNetworkSettingsOutput,
                crate::error::CreateNetworkSettingsError,
                crate::input::CreateNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn vpc_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(inp);
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `subnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `securityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(inp);
            self
        }
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the network settings resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to the network settings resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePortal`.
    ///
    /// <p>Creates a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePortal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_portal_input::Builder,
    }
    impl<C, M, R> CreatePortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePortalInputOperationOutputAlias,
                crate::output::CreatePortalOutput,
                crate::error::CreatePortalError,
                crate::input::CreatePortalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the web portal. A tag is a key-value pair.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to the web portal. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The customer managed key of the web portal.</p>
        pub fn customer_managed_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_managed_key(inp);
            self
        }
        /// <p>The customer managed key of the web portal.</p>
        pub fn set_customer_managed_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_managed_key(input);
            self
        }
        /// Adds a key-value pair to `additionalEncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_additional_encryption_context`](Self::set_additional_encryption_context).
        ///
        /// <p>The additional encryption context of the portal.</p>
        pub fn additional_encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_encryption_context(k, v);
            self
        }
        /// <p>The additional encryption context of the portal.</p>
        pub fn set_additional_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_encryption_context(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrustStore`.
    ///
    /// <p>Creates a trust store that can be associated with a web portal. A trust store contains
    /// certificate authority (CA) certificates. Once associated with a web portal, the browser in
    /// a streaming session will recognize certificates that have been issued using any of the CAs
    /// in the trust store. If your organization has internal websites that use certificates issued
    /// by private CAs, you should add the private CA certificate to the trust store. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_trust_store_input::Builder,
    }
    impl<C, M, R> CreateTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrustStoreInputOperationOutputAlias,
                crate::output::CreateTrustStoreOutput,
                crate::error::CreateTrustStoreError,
                crate::input::CreateTrustStoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `certificateList`.
        ///
        /// To override the contents of this collection use [`set_certificate_list`](Self::set_certificate_list).
        ///
        /// <p>A list of CA certificates to be added to the trust store.</p>
        pub fn certificate_list(mut self, inp: impl Into<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.certificate_list(inp);
            self
        }
        /// <p>A list of CA certificates to be added to the trust store.</p>
        pub fn set_certificate_list(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        ) -> Self {
            self.inner = self.inner.set_certificate_list(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the trust store. A tag is a key-value pair.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to the trust store. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserSettings`.
    ///
    /// <p>Creates a user settings resource that can be associated with a web portal. Once
    /// associated with a web portal, user settings control how users can transfer data between a
    /// streaming session and the their local devices. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_settings_input::Builder,
    }
    impl<C, M, R> CreateUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserSettingsInputOperationOutputAlias,
                crate::output::CreateUserSettingsOutput,
                crate::error::CreateUserSettingsError,
                crate::input::CreateUserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local
        /// device.</p>
        pub fn copy_allowed(mut self, inp: crate::model::EnabledType) -> Self {
            self.inner = self.inner.copy_allowed(inp);
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local
        /// device.</p>
        pub fn set_copy_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_copy_allowed(input);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming
        /// session.</p>
        pub fn paste_allowed(mut self, inp: crate::model::EnabledType) -> Self {
            self.inner = self.inner.paste_allowed(inp);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming
        /// session.</p>
        pub fn set_paste_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_paste_allowed(input);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local
        /// device.</p>
        pub fn download_allowed(mut self, inp: crate::model::EnabledType) -> Self {
            self.inner = self.inner.download_allowed(inp);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local
        /// device.</p>
        pub fn set_download_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_download_allowed(input);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming
        /// session.</p>
        pub fn upload_allowed(mut self, inp: crate::model::EnabledType) -> Self {
            self.inner = self.inner.upload_allowed(inp);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming
        /// session.</p>
        pub fn set_upload_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_upload_allowed(input);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn print_allowed(mut self, inp: crate::model::EnabledType) -> Self {
            self.inner = self.inner.print_allowed(inp);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn set_print_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_print_allowed(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the user settings resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to the user settings resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBrowserSettings`.
    ///
    /// <p>Deletes browser settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_browser_settings_input::Builder,
    }
    impl<C, M, R> DeleteBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBrowserSettingsInputOperationOutputAlias,
                crate::output::DeleteBrowserSettingsOutput,
                crate::error::DeleteBrowserSettingsError,
                crate::input::DeleteBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_settings_arn(inp);
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentityProvider`.
    ///
    /// <p>Deletes the identity provider.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_identity_provider_input::Builder,
    }
    impl<C, M, R> DeleteIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIdentityProviderInputOperationOutputAlias,
                crate::output::DeleteIdentityProviderOutput,
                crate::error::DeleteIdentityProviderError,
                crate::input::DeleteIdentityProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_arn(inp);
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNetworkSettings`.
    ///
    /// <p>Deletes network settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_network_settings_input::Builder,
    }
    impl<C, M, R> DeleteNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNetworkSettingsInputOperationOutputAlias,
                crate::output::DeleteNetworkSettingsOutput,
                crate::error::DeleteNetworkSettingsError,
                crate::input::DeleteNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_settings_arn(inp);
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePortal`.
    ///
    /// <p>Deletes a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePortal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_portal_input::Builder,
    }
    impl<C, M, R> DeletePortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePortalInputOperationOutputAlias,
                crate::output::DeletePortalOutput,
                crate::error::DeletePortalError,
                crate::input::DeletePortalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrustStore`.
    ///
    /// <p>Deletes the trust store.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_trust_store_input::Builder,
    }
    impl<C, M, R> DeleteTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTrustStoreInputOperationOutputAlias,
                crate::output::DeleteTrustStoreOutput,
                crate::error::DeleteTrustStoreError,
                crate::input::DeleteTrustStoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(inp);
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserSettings`.
    ///
    /// <p>Deletes user settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_settings_input::Builder,
    }
    impl<C, M, R> DeleteUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserSettingsInputOperationOutputAlias,
                crate::output::DeleteUserSettingsOutput,
                crate::error::DeleteUserSettingsError,
                crate::input::DeleteUserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_settings_arn(inp);
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateBrowserSettings`.
    ///
    /// <p>Disassociates browser settings from a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_browser_settings_input::Builder,
    }
    impl<C, M, R> DisassociateBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateBrowserSettingsInputOperationOutputAlias,
                crate::output::DisassociateBrowserSettingsOutput,
                crate::error::DisassociateBrowserSettingsError,
                crate::input::DisassociateBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateNetworkSettings`.
    ///
    /// <p>Disassociates network settings from a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_network_settings_input::Builder,
    }
    impl<C, M, R> DisassociateNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateNetworkSettingsInputOperationOutputAlias,
                crate::output::DisassociateNetworkSettingsOutput,
                crate::error::DisassociateNetworkSettingsError,
                crate::input::DisassociateNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTrustStore`.
    ///
    /// <p>Disassociates a trust store from a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_trust_store_input::Builder,
    }
    impl<C, M, R> DisassociateTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateTrustStoreInputOperationOutputAlias,
                crate::output::DisassociateTrustStoreOutput,
                crate::error::DisassociateTrustStoreError,
                crate::input::DisassociateTrustStoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateUserSettings`.
    ///
    /// <p>Disassociates user settings from a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_user_settings_input::Builder,
    }
    impl<C, M, R> DisassociateUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateUserSettingsInputOperationOutputAlias,
                crate::output::DisassociateUserSettingsOutput,
                crate::error::DisassociateUserSettingsError,
                crate::input::DisassociateUserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBrowserSettings`.
    ///
    /// <p>Gets browser settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_browser_settings_input::Builder,
    }
    impl<C, M, R> GetBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBrowserSettingsInputOperationOutputAlias,
                crate::output::GetBrowserSettingsOutput,
                crate::error::GetBrowserSettingsError,
                crate::input::GetBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_settings_arn(inp);
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityProvider`.
    ///
    /// <p>Gets the identity provider.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_identity_provider_input::Builder,
    }
    impl<C, M, R> GetIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdentityProviderInputOperationOutputAlias,
                crate::output::GetIdentityProviderOutput,
                crate::error::GetIdentityProviderError,
                crate::input::GetIdentityProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_arn(inp);
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkSettings`.
    ///
    /// <p>Gets the network settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_settings_input::Builder,
    }
    impl<C, M, R> GetNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkSettingsInputOperationOutputAlias,
                crate::output::GetNetworkSettingsOutput,
                crate::error::GetNetworkSettingsError,
                crate::input::GetNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_settings_arn(inp);
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPortal`.
    ///
    /// <p>Gets the web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPortal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_portal_input::Builder,
    }
    impl<C, M, R> GetPortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPortalOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPortalInputOperationOutputAlias,
                crate::output::GetPortalOutput,
                crate::error::GetPortalError,
                crate::input::GetPortalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPortalServiceProviderMetadata`.
    ///
    /// <p>Gets the service provider metadata.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPortalServiceProviderMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_portal_service_provider_metadata_input::Builder,
    }
    impl<C, M, R> GetPortalServiceProviderMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPortalServiceProviderMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPortalServiceProviderMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPortalServiceProviderMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPortalServiceProviderMetadataInputOperationOutputAlias,
                crate::output::GetPortalServiceProviderMetadataOutput,
                crate::error::GetPortalServiceProviderMetadataError,
                crate::input::GetPortalServiceProviderMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrustStore`.
    ///
    /// <p>Gets the trust store.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_trust_store_input::Builder,
    }
    impl<C, M, R> GetTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTrustStoreInputOperationOutputAlias,
                crate::output::GetTrustStoreOutput,
                crate::error::GetTrustStoreError,
                crate::input::GetTrustStoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(inp);
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrustStoreCertificate`.
    ///
    /// <p>Gets the trust store certificate.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTrustStoreCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_trust_store_certificate_input::Builder,
    }
    impl<C, M, R> GetTrustStoreCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTrustStoreCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrustStoreCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrustStoreCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTrustStoreCertificateInputOperationOutputAlias,
                crate::output::GetTrustStoreCertificateOutput,
                crate::error::GetTrustStoreCertificateError,
                crate::input::GetTrustStoreCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the trust store certificate.</p>
        pub fn trust_store_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(inp);
            self
        }
        /// <p>The ARN of the trust store certificate.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
        /// <p>The thumbprint of the trust store certificate.</p>
        pub fn thumbprint(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thumbprint(inp);
            self
        }
        /// <p>The thumbprint of the trust store certificate.</p>
        pub fn set_thumbprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thumbprint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserSettings`.
    ///
    /// <p>Gets user settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_settings_input::Builder,
    }
    impl<C, M, R> GetUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserSettingsInputOperationOutputAlias,
                crate::output::GetUserSettingsOutput,
                crate::error::GetUserSettingsError,
                crate::input::GetUserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_settings_arn(inp);
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_settings_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBrowserSettings`.
    ///
    /// <p>Retrieves a list of browser settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_browser_settings_input::Builder,
    }
    impl<C, M, R> ListBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBrowserSettingsInputOperationOutputAlias,
                crate::output::ListBrowserSettingsOutput,
                crate::error::ListBrowserSettingsError,
                crate::input::ListBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityProviders`.
    ///
    /// <p>Retrieves a list of identity providers for a specific web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIdentityProviders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_identity_providers_input::Builder,
    }
    impl<C, M, R> ListIdentityProviders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIdentityProviders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityProvidersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityProvidersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIdentityProvidersInputOperationOutputAlias,
                crate::output::ListIdentityProvidersOutput,
                crate::error::ListIdentityProvidersError,
                crate::input::ListIdentityProvidersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNetworkSettings`.
    ///
    /// <p>Retrieves a list of network settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_network_settings_input::Builder,
    }
    impl<C, M, R> ListNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNetworkSettingsInputOperationOutputAlias,
                crate::output::ListNetworkSettingsOutput,
                crate::error::ListNetworkSettingsError,
                crate::input::ListNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPortals`.
    ///
    /// <p>Retrieves a list or web portals.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPortals<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_portals_input::Builder,
    }
    impl<C, M, R> ListPortals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPortals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPortalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPortalsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPortalsInputOperationOutputAlias,
                crate::output::ListPortalsOutput,
                crate::error::ListPortalsError,
                crate::input::ListPortalsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves a list of tags for a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrustStoreCertificates`.
    ///
    /// <p>Retrieves a list of trust store certificates.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTrustStoreCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_trust_store_certificates_input::Builder,
    }
    impl<C, M, R> ListTrustStoreCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrustStoreCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrustStoreCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrustStoreCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrustStoreCertificatesInputOperationOutputAlias,
                crate::output::ListTrustStoreCertificatesOutput,
                crate::error::ListTrustStoreCertificatesError,
                crate::input::ListTrustStoreCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the trust store</p>
        pub fn trust_store_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(inp);
            self
        }
        /// <p>The ARN of the trust store</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrustStores`.
    ///
    /// <p>Retrieves a list of trust stores.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTrustStores<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_trust_stores_input::Builder,
    }
    impl<C, M, R> ListTrustStores<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrustStores`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrustStoresOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrustStoresError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrustStoresInputOperationOutputAlias,
                crate::output::ListTrustStoresOutput,
                crate::error::ListTrustStoresError,
                crate::input::ListTrustStoresInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserSettings`.
    ///
    /// <p>Retrieves a list of user settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_settings_input::Builder,
    }
    impl<C, M, R> ListUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserSettingsInputOperationOutputAlias,
                crate::output::ListUserSettingsOutput,
                crate::error::ListUserSettingsError,
                crate::input::ListUserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags of the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token returns the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBrowserSettings`.
    ///
    /// <p>Updates browser settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBrowserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_browser_settings_input::Builder,
    }
    impl<C, M, R> UpdateBrowserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBrowserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBrowserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBrowserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBrowserSettingsInputOperationOutputAlias,
                crate::output::UpdateBrowserSettingsOutput,
                crate::error::UpdateBrowserSettingsError,
                crate::input::UpdateBrowserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn browser_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_settings_arn(inp);
            self
        }
        /// <p>The ARN of the browser settings.</p>
        pub fn set_browser_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_settings_arn(input);
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all
        /// streaming sessions. </p>
        pub fn browser_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.browser_policy(inp);
            self
        }
        /// <p>A JSON string containing Chrome Enterprise policies that will be applied to all
        /// streaming sessions. </p>
        pub fn set_browser_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_browser_policy(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIdentityProvider`.
    ///
    /// <p>Updates the identity provider.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIdentityProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_identity_provider_input::Builder,
    }
    impl<C, M, R> UpdateIdentityProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIdentityProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIdentityProviderInputOperationOutputAlias,
                crate::output::UpdateIdentityProviderOutput,
                crate::error::UpdateIdentityProviderError,
                crate::input::UpdateIdentityProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn identity_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_arn(inp);
            self
        }
        /// <p>The ARN of the identity provider.</p>
        pub fn set_identity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_arn(input);
            self
        }
        /// <p>The name of the identity provider.</p>
        pub fn identity_provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_provider_name(inp);
            self
        }
        /// <p>The name of the identity provider.</p>
        pub fn set_identity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_name(input);
            self
        }
        /// <p>The type of the identity provider.</p>
        pub fn identity_provider_type(mut self, inp: crate::model::IdentityProviderType) -> Self {
            self.inner = self.inner.identity_provider_type(inp);
            self
        }
        /// <p>The type of the identity provider.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_type(input);
            self
        }
        /// Adds a key-value pair to `identityProviderDetails`.
        ///
        /// To override the contents of this collection use [`set_identity_provider_details`](Self::set_identity_provider_details).
        ///
        /// <p>The details of the identity provider.</p>
        pub fn identity_provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_provider_details(k, v);
            self
        }
        /// <p>The details of the identity provider.</p>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_details(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNetworkSettings`.
    ///
    /// <p>Updates network settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateNetworkSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_network_settings_input::Builder,
    }
    impl<C, M, R> UpdateNetworkSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNetworkSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNetworkSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNetworkSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNetworkSettingsInputOperationOutputAlias,
                crate::output::UpdateNetworkSettingsOutput,
                crate::error::UpdateNetworkSettingsError,
                crate::input::UpdateNetworkSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network settings.</p>
        pub fn network_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_settings_arn(inp);
            self
        }
        /// <p>The ARN of the network settings.</p>
        pub fn set_network_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_settings_arn(input);
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn vpc_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(inp);
            self
        }
        /// <p>The VPC that streaming instances will connect to.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `subnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `securityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(inp);
            self
        }
        /// <p>One or more security groups used to control access from streaming instances to your VPC.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePortal`.
    ///
    /// <p>Updates a web portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePortal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_portal_input::Builder,
    }
    impl<C, M, R> UpdatePortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePortalInputOperationOutputAlias,
                crate::output::UpdatePortalOutput,
                crate::error::UpdatePortalError,
                crate::input::UpdatePortalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the web portal.</p>
        pub fn portal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_arn(inp);
            self
        }
        /// <p>The ARN of the web portal.</p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_arn(input);
            self
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The name of the web portal. This is not visible to users who log into the web portal.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTrustStore`.
    ///
    /// <p>Updates the trust store.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTrustStore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_trust_store_input::Builder,
    }
    impl<C, M, R> UpdateTrustStore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTrustStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrustStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrustStoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTrustStoreInputOperationOutputAlias,
                crate::output::UpdateTrustStoreOutput,
                crate::error::UpdateTrustStoreError,
                crate::input::UpdateTrustStoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the trust store.</p>
        pub fn trust_store_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_store_arn(inp);
            self
        }
        /// <p>The ARN of the trust store.</p>
        pub fn set_trust_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_store_arn(input);
            self
        }
        /// Appends an item to `certificatesToAdd`.
        ///
        /// To override the contents of this collection use [`set_certificates_to_add`](Self::set_certificates_to_add).
        ///
        /// <p>A list of CA certificates to add to the trust store.</p>
        pub fn certificates_to_add(mut self, inp: impl Into<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.certificates_to_add(inp);
            self
        }
        /// <p>A list of CA certificates to add to the trust store.</p>
        pub fn set_certificates_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        ) -> Self {
            self.inner = self.inner.set_certificates_to_add(input);
            self
        }
        /// Appends an item to `certificatesToDelete`.
        ///
        /// To override the contents of this collection use [`set_certificates_to_delete`](Self::set_certificates_to_delete).
        ///
        /// <p>A list of CA certificates to delete from a trust store.</p>
        pub fn certificates_to_delete(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificates_to_delete(inp);
            self
        }
        /// <p>A list of CA certificates to delete from a trust store.</p>
        pub fn set_certificates_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_certificates_to_delete(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserSettings`.
    ///
    /// <p>Updates the user settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_settings_input::Builder,
    }
    impl<C, M, R> UpdateUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserSettingsInputOperationOutputAlias,
                crate::output::UpdateUserSettingsOutput,
                crate::error::UpdateUserSettingsError,
                crate::input::UpdateUserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user settings.</p>
        pub fn user_settings_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_settings_arn(inp);
            self
        }
        /// <p>The ARN of the user settings.</p>
        pub fn set_user_settings_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_settings_arn(input);
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local
        /// device.</p>
        pub fn copy_allowed(mut self, inp: crate::model::EnabledType) -> Self {
            self.inner = self.inner.copy_allowed(inp);
            self
        }
        /// <p>Specifies whether the user can copy text from the streaming session to the local
        /// device.</p>
        pub fn set_copy_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_copy_allowed(input);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming
        /// session.</p>
        pub fn paste_allowed(mut self, inp: crate::model::EnabledType) -> Self {
            self.inner = self.inner.paste_allowed(inp);
            self
        }
        /// <p>Specifies whether the user can paste text from the local device to the streaming
        /// session.</p>
        pub fn set_paste_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_paste_allowed(input);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local
        /// device.</p>
        pub fn download_allowed(mut self, inp: crate::model::EnabledType) -> Self {
            self.inner = self.inner.download_allowed(inp);
            self
        }
        /// <p>Specifies whether the user can download files from the streaming session to the local
        /// device.</p>
        pub fn set_download_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_download_allowed(input);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming
        /// session.</p>
        pub fn upload_allowed(mut self, inp: crate::model::EnabledType) -> Self {
            self.inner = self.inner.upload_allowed(inp);
            self
        }
        /// <p>Specifies whether the user can upload files from the local device to the streaming
        /// session.</p>
        pub fn set_upload_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_upload_allowed(input);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn print_allowed(mut self, inp: crate::model::EnabledType) -> Self {
            self.inner = self.inner.print_allowed(inp);
            self
        }
        /// <p>Specifies whether the user can print to the local device.</p>
        pub fn set_print_allowed(
            mut self,
            input: std::option::Option<crate::model::EnabledType>,
        ) -> Self {
            self.inner = self.inner.set_print_allowed(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, subsequent retries with the same
        /// client token return the result from the original successful request. </p>
        /// <p>If you do not specify a client token, one is automatically generated by the AWS
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
