// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon WorkSpaces
///
/// Client for invoking operations on Amazon WorkSpaces. Each operation on Amazon WorkSpaces is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_workspaces::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_workspaces::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_workspaces::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateConnectionAlias`](crate::client::fluent_builders::AssociateConnectionAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias_id(impl Into<String>)`](crate::client::fluent_builders::AssociateConnectionAlias::alias_id) / [`set_alias_id(Option<String>)`](crate::client::fluent_builders::AssociateConnectionAlias::set_alias_id): <p>The identifier of the connection alias.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::AssociateConnectionAlias::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::AssociateConnectionAlias::set_resource_id): <p>The identifier of the directory to associate the connection alias with.</p>
    /// - On success, responds with [`AssociateConnectionAliasOutput`](crate::output::AssociateConnectionAliasOutput) with field(s):
    ///   - [`connection_identifier(Option<String>)`](crate::output::AssociateConnectionAliasOutput::connection_identifier): <p>The identifier of the connection alias association. You use the connection identifier in the DNS TXT record when you're configuring your DNS routing policies. </p>
    /// - On failure, responds with [`SdkError<AssociateConnectionAliasError>`](crate::error::AssociateConnectionAliasError)
    pub fn associate_connection_alias(&self) -> fluent_builders::AssociateConnectionAlias {
        fluent_builders::AssociateConnectionAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateIpGroups`](crate::client::fluent_builders::AssociateIpGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::AssociateIpGroups::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::AssociateIpGroups::set_directory_id): <p>The identifier of the directory.</p>
    ///   - [`group_ids(Vec<String>)`](crate::client::fluent_builders::AssociateIpGroups::group_ids) / [`set_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AssociateIpGroups::set_group_ids): <p>The identifiers of one or more IP access control groups.</p>
    /// - On success, responds with [`AssociateIpGroupsOutput`](crate::output::AssociateIpGroupsOutput)

    /// - On failure, responds with [`SdkError<AssociateIpGroupsError>`](crate::error::AssociateIpGroupsError)
    pub fn associate_ip_groups(&self) -> fluent_builders::AssociateIpGroups {
        fluent_builders::AssociateIpGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AuthorizeIpRules`](crate::client::fluent_builders::AuthorizeIpRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeIpRules::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::AuthorizeIpRules::set_group_id): <p>The identifier of the group.</p>
    ///   - [`user_rules(Vec<IpRuleItem>)`](crate::client::fluent_builders::AuthorizeIpRules::user_rules) / [`set_user_rules(Option<Vec<IpRuleItem>>)`](crate::client::fluent_builders::AuthorizeIpRules::set_user_rules): <p>The rules to add to the group.</p>
    /// - On success, responds with [`AuthorizeIpRulesOutput`](crate::output::AuthorizeIpRulesOutput)

    /// - On failure, responds with [`SdkError<AuthorizeIpRulesError>`](crate::error::AuthorizeIpRulesError)
    pub fn authorize_ip_rules(&self) -> fluent_builders::AuthorizeIpRules {
        fluent_builders::AuthorizeIpRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyWorkspaceImage`](crate::client::fluent_builders::CopyWorkspaceImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CopyWorkspaceImage::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CopyWorkspaceImage::set_name): <p>The name of the image.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CopyWorkspaceImage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CopyWorkspaceImage::set_description): <p>A description of the image.</p>
    ///   - [`source_image_id(impl Into<String>)`](crate::client::fluent_builders::CopyWorkspaceImage::source_image_id) / [`set_source_image_id(Option<String>)`](crate::client::fluent_builders::CopyWorkspaceImage::set_source_image_id): <p>The identifier of the source image.</p>
    ///   - [`source_region(impl Into<String>)`](crate::client::fluent_builders::CopyWorkspaceImage::source_region) / [`set_source_region(Option<String>)`](crate::client::fluent_builders::CopyWorkspaceImage::set_source_region): <p>The identifier of the source Region.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopyWorkspaceImage::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyWorkspaceImage::set_tags): <p>The tags for the image.</p>
    /// - On success, responds with [`CopyWorkspaceImageOutput`](crate::output::CopyWorkspaceImageOutput) with field(s):
    ///   - [`image_id(Option<String>)`](crate::output::CopyWorkspaceImageOutput::image_id): <p>The identifier of the image.</p>
    /// - On failure, responds with [`SdkError<CopyWorkspaceImageError>`](crate::error::CopyWorkspaceImageError)
    pub fn copy_workspace_image(&self) -> fluent_builders::CopyWorkspaceImage {
        fluent_builders::CopyWorkspaceImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConnectClientAddIn`](crate::client::fluent_builders::CreateConnectClientAddIn) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::CreateConnectClientAddIn::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::CreateConnectClientAddIn::set_resource_id): <p>The directory identifier for which to configure the client add-in.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateConnectClientAddIn::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateConnectClientAddIn::set_name): <p>The name of the client add-in.</p>
    ///   - [`url(impl Into<String>)`](crate::client::fluent_builders::CreateConnectClientAddIn::url) / [`set_url(Option<String>)`](crate::client::fluent_builders::CreateConnectClientAddIn::set_url): <p>The endpoint URL of the Amazon Connect client add-in.</p>
    /// - On success, responds with [`CreateConnectClientAddInOutput`](crate::output::CreateConnectClientAddInOutput) with field(s):
    ///   - [`add_in_id(Option<String>)`](crate::output::CreateConnectClientAddInOutput::add_in_id): <p>The client add-in identifier.</p>
    /// - On failure, responds with [`SdkError<CreateConnectClientAddInError>`](crate::error::CreateConnectClientAddInError)
    pub fn create_connect_client_add_in(&self) -> fluent_builders::CreateConnectClientAddIn {
        fluent_builders::CreateConnectClientAddIn::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConnectionAlias`](crate::client::fluent_builders::CreateConnectionAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`connection_string(impl Into<String>)`](crate::client::fluent_builders::CreateConnectionAlias::connection_string) / [`set_connection_string(Option<String>)`](crate::client::fluent_builders::CreateConnectionAlias::set_connection_string): <p>A connection string in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p> <important>   <p>After you create a connection string, it is always associated to your Amazon Web Services account. You cannot recreate the same connection string with a different account, even if you delete all instances of it from the original account. The connection string is globally reserved for your account.</p>  </important>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateConnectionAlias::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateConnectionAlias::set_tags): <p>The tags to associate with the connection alias.</p>
    /// - On success, responds with [`CreateConnectionAliasOutput`](crate::output::CreateConnectionAliasOutput) with field(s):
    ///   - [`alias_id(Option<String>)`](crate::output::CreateConnectionAliasOutput::alias_id): <p>The identifier of the connection alias.</p>
    /// - On failure, responds with [`SdkError<CreateConnectionAliasError>`](crate::error::CreateConnectionAliasError)
    pub fn create_connection_alias(&self) -> fluent_builders::CreateConnectionAlias {
        fluent_builders::CreateConnectionAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIpGroup`](crate::client::fluent_builders::CreateIpGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::CreateIpGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::CreateIpGroup::set_group_name): <p>The name of the group.</p>
    ///   - [`group_desc(impl Into<String>)`](crate::client::fluent_builders::CreateIpGroup::group_desc) / [`set_group_desc(Option<String>)`](crate::client::fluent_builders::CreateIpGroup::set_group_desc): <p>The description of the group.</p>
    ///   - [`user_rules(Vec<IpRuleItem>)`](crate::client::fluent_builders::CreateIpGroup::user_rules) / [`set_user_rules(Option<Vec<IpRuleItem>>)`](crate::client::fluent_builders::CreateIpGroup::set_user_rules): <p>The rules to add to the group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateIpGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateIpGroup::set_tags): <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
    /// - On success, responds with [`CreateIpGroupOutput`](crate::output::CreateIpGroupOutput) with field(s):
    ///   - [`group_id(Option<String>)`](crate::output::CreateIpGroupOutput::group_id): <p>The identifier of the group.</p>
    /// - On failure, responds with [`SdkError<CreateIpGroupError>`](crate::error::CreateIpGroupError)
    pub fn create_ip_group(&self) -> fluent_builders::CreateIpGroup {
        fluent_builders::CreateIpGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTags`](crate::client::fluent_builders::CreateTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::CreateTags::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::CreateTags::set_resource_id): <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTags::set_tags): <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
    /// - On success, responds with [`CreateTagsOutput`](crate::output::CreateTagsOutput)

    /// - On failure, responds with [`SdkError<CreateTagsError>`](crate::error::CreateTagsError)
    pub fn create_tags(&self) -> fluent_builders::CreateTags {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUpdatedWorkspaceImage`](crate::client::fluent_builders::CreateUpdatedWorkspaceImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateUpdatedWorkspaceImage::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateUpdatedWorkspaceImage::set_name): <p>The name of the new updated WorkSpace image.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateUpdatedWorkspaceImage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateUpdatedWorkspaceImage::set_description): <p>A description of whether updates for the WorkSpace image are available.</p>
    ///   - [`source_image_id(impl Into<String>)`](crate::client::fluent_builders::CreateUpdatedWorkspaceImage::source_image_id) / [`set_source_image_id(Option<String>)`](crate::client::fluent_builders::CreateUpdatedWorkspaceImage::set_source_image_id): <p>The identifier of the source WorkSpace image.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateUpdatedWorkspaceImage::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateUpdatedWorkspaceImage::set_tags): <p>The tags that you want to add to the new updated WorkSpace image.</p> <note>   <p>To add tags at the same time when you're creating the updated image, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>  </note>
    /// - On success, responds with [`CreateUpdatedWorkspaceImageOutput`](crate::output::CreateUpdatedWorkspaceImageOutput) with field(s):
    ///   - [`image_id(Option<String>)`](crate::output::CreateUpdatedWorkspaceImageOutput::image_id): <p>The identifier of the new updated WorkSpace image.</p>
    /// - On failure, responds with [`SdkError<CreateUpdatedWorkspaceImageError>`](crate::error::CreateUpdatedWorkspaceImageError)
    pub fn create_updated_workspace_image(&self) -> fluent_builders::CreateUpdatedWorkspaceImage {
        fluent_builders::CreateUpdatedWorkspaceImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWorkspaceBundle`](crate::client::fluent_builders::CreateWorkspaceBundle) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bundle_name(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspaceBundle::bundle_name) / [`set_bundle_name(Option<String>)`](crate::client::fluent_builders::CreateWorkspaceBundle::set_bundle_name): <p>The name of the bundle.</p>
    ///   - [`bundle_description(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspaceBundle::bundle_description) / [`set_bundle_description(Option<String>)`](crate::client::fluent_builders::CreateWorkspaceBundle::set_bundle_description): <p>The description of the bundle.</p>
    ///   - [`image_id(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspaceBundle::image_id) / [`set_image_id(Option<String>)`](crate::client::fluent_builders::CreateWorkspaceBundle::set_image_id): <p>The identifier of the image that is used to create the bundle.</p>
    ///   - [`compute_type(ComputeType)`](crate::client::fluent_builders::CreateWorkspaceBundle::compute_type) / [`set_compute_type(Option<ComputeType>)`](crate::client::fluent_builders::CreateWorkspaceBundle::set_compute_type): <p>Describes the compute type of the bundle.</p>
    ///   - [`user_storage(UserStorage)`](crate::client::fluent_builders::CreateWorkspaceBundle::user_storage) / [`set_user_storage(Option<UserStorage>)`](crate::client::fluent_builders::CreateWorkspaceBundle::set_user_storage): <p>Describes the user volume for a WorkSpace bundle.</p>
    ///   - [`root_storage(RootStorage)`](crate::client::fluent_builders::CreateWorkspaceBundle::root_storage) / [`set_root_storage(Option<RootStorage>)`](crate::client::fluent_builders::CreateWorkspaceBundle::set_root_storage): <p>Describes the root volume for a WorkSpace bundle.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateWorkspaceBundle::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateWorkspaceBundle::set_tags): <p>The tags associated with the bundle.</p> <note>   <p>To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>  </note>
    /// - On success, responds with [`CreateWorkspaceBundleOutput`](crate::output::CreateWorkspaceBundleOutput) with field(s):
    ///   - [`workspace_bundle(Option<WorkspaceBundle>)`](crate::output::CreateWorkspaceBundleOutput::workspace_bundle): <p>Describes a WorkSpace bundle.</p>
    /// - On failure, responds with [`SdkError<CreateWorkspaceBundleError>`](crate::error::CreateWorkspaceBundleError)
    pub fn create_workspace_bundle(&self) -> fluent_builders::CreateWorkspaceBundle {
        fluent_builders::CreateWorkspaceBundle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWorkspaces`](crate::client::fluent_builders::CreateWorkspaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspaces(Vec<WorkspaceRequest>)`](crate::client::fluent_builders::CreateWorkspaces::workspaces) / [`set_workspaces(Option<Vec<WorkspaceRequest>>)`](crate::client::fluent_builders::CreateWorkspaces::set_workspaces): <p>The WorkSpaces to create. You can specify up to 25 WorkSpaces.</p>
    /// - On success, responds with [`CreateWorkspacesOutput`](crate::output::CreateWorkspacesOutput) with field(s):
    ///   - [`failed_requests(Option<Vec<FailedCreateWorkspaceRequest>>)`](crate::output::CreateWorkspacesOutput::failed_requests): <p>Information about the WorkSpaces that could not be created.</p>
    ///   - [`pending_requests(Option<Vec<Workspace>>)`](crate::output::CreateWorkspacesOutput::pending_requests): <p>Information about the WorkSpaces that were created.</p>  <p>Because this operation is asynchronous, the identifier returned is not immediately available for use with other operations. For example, if you call <code>DescribeWorkspaces</code> before the WorkSpace is created, the information returned can be incomplete.</p>
    /// - On failure, responds with [`SdkError<CreateWorkspacesError>`](crate::error::CreateWorkspacesError)
    pub fn create_workspaces(&self) -> fluent_builders::CreateWorkspaces {
        fluent_builders::CreateWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConnectClientAddIn`](crate::client::fluent_builders::DeleteConnectClientAddIn) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`add_in_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConnectClientAddIn::add_in_id) / [`set_add_in_id(Option<String>)`](crate::client::fluent_builders::DeleteConnectClientAddIn::set_add_in_id): <p>The identifier of the client add-in to delete.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConnectClientAddIn::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteConnectClientAddIn::set_resource_id): <p>The directory identifier for which the client add-in is configured.</p>
    /// - On success, responds with [`DeleteConnectClientAddInOutput`](crate::output::DeleteConnectClientAddInOutput)

    /// - On failure, responds with [`SdkError<DeleteConnectClientAddInError>`](crate::error::DeleteConnectClientAddInError)
    pub fn delete_connect_client_add_in(&self) -> fluent_builders::DeleteConnectClientAddIn {
        fluent_builders::DeleteConnectClientAddIn::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConnectionAlias`](crate::client::fluent_builders::DeleteConnectionAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConnectionAlias::alias_id) / [`set_alias_id(Option<String>)`](crate::client::fluent_builders::DeleteConnectionAlias::set_alias_id): <p>The identifier of the connection alias to delete.</p>
    /// - On success, responds with [`DeleteConnectionAliasOutput`](crate::output::DeleteConnectionAliasOutput)

    /// - On failure, responds with [`SdkError<DeleteConnectionAliasError>`](crate::error::DeleteConnectionAliasError)
    pub fn delete_connection_alias(&self) -> fluent_builders::DeleteConnectionAlias {
        fluent_builders::DeleteConnectionAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIpGroup`](crate::client::fluent_builders::DeleteIpGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIpGroup::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::DeleteIpGroup::set_group_id): <p>The identifier of the IP access control group.</p>
    /// - On success, responds with [`DeleteIpGroupOutput`](crate::output::DeleteIpGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteIpGroupError>`](crate::error::DeleteIpGroupError)
    pub fn delete_ip_group(&self) -> fluent_builders::DeleteIpGroup {
        fluent_builders::DeleteIpGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTags`](crate::client::fluent_builders::DeleteTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTags::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteTags::set_resource_id): <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DeleteTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteTags::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)

    /// - On failure, responds with [`SdkError<DeleteTagsError>`](crate::error::DeleteTagsError)
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWorkspaceBundle`](crate::client::fluent_builders::DeleteWorkspaceBundle) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bundle_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkspaceBundle::bundle_id) / [`set_bundle_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkspaceBundle::set_bundle_id): <p>The identifier of the bundle.</p>
    /// - On success, responds with [`DeleteWorkspaceBundleOutput`](crate::output::DeleteWorkspaceBundleOutput)

    /// - On failure, responds with [`SdkError<DeleteWorkspaceBundleError>`](crate::error::DeleteWorkspaceBundleError)
    pub fn delete_workspace_bundle(&self) -> fluent_builders::DeleteWorkspaceBundle {
        fluent_builders::DeleteWorkspaceBundle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWorkspaceImage`](crate::client::fluent_builders::DeleteWorkspaceImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkspaceImage::image_id) / [`set_image_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkspaceImage::set_image_id): <p>The identifier of the image.</p>
    /// - On success, responds with [`DeleteWorkspaceImageOutput`](crate::output::DeleteWorkspaceImageOutput)

    /// - On failure, responds with [`SdkError<DeleteWorkspaceImageError>`](crate::error::DeleteWorkspaceImageError)
    pub fn delete_workspace_image(&self) -> fluent_builders::DeleteWorkspaceImage {
        fluent_builders::DeleteWorkspaceImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterWorkspaceDirectory`](crate::client::fluent_builders::DeregisterWorkspaceDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterWorkspaceDirectory::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DeregisterWorkspaceDirectory::set_directory_id): <p>The identifier of the directory. If any WorkSpaces are registered to this directory, you must remove them before you deregister the directory, or you will receive an OperationNotSupportedException error.</p>
    /// - On success, responds with [`DeregisterWorkspaceDirectoryOutput`](crate::output::DeregisterWorkspaceDirectoryOutput)

    /// - On failure, responds with [`SdkError<DeregisterWorkspaceDirectoryError>`](crate::error::DeregisterWorkspaceDirectoryError)
    pub fn deregister_workspace_directory(&self) -> fluent_builders::DeregisterWorkspaceDirectory {
        fluent_builders::DeregisterWorkspaceDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccount`](crate::client::fluent_builders::DescribeAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeAccount::send) it.

    /// - On success, responds with [`DescribeAccountOutput`](crate::output::DescribeAccountOutput) with field(s):
    ///   - [`dedicated_tenancy_support(Option<DedicatedTenancySupportResultEnum>)`](crate::output::DescribeAccountOutput::dedicated_tenancy_support): <p>The status of BYOL (whether BYOL is enabled or disabled).</p>
    ///   - [`dedicated_tenancy_management_cidr_range(Option<String>)`](crate::output::DescribeAccountOutput::dedicated_tenancy_management_cidr_range): <p>The IP address range, specified as an IPv4 CIDR block, used for the management network interface.</p>  <p>The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage the WorkSpace.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountError>`](crate::error::DescribeAccountError)
    pub fn describe_account(&self) -> fluent_builders::DescribeAccount {
        fluent_builders::DescribeAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountModifications`](crate::client::fluent_builders::DescribeAccountModifications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountModifications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAccountModifications::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
    /// - On success, responds with [`DescribeAccountModificationsOutput`](crate::output::DescribeAccountModificationsOutput) with field(s):
    ///   - [`account_modifications(Option<Vec<AccountModification>>)`](crate::output::DescribeAccountModificationsOutput::account_modifications): <p>The list of modifications to the configuration of BYOL.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAccountModificationsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeAccountModificationsError>`](crate::error::DescribeAccountModificationsError)
    pub fn describe_account_modifications(&self) -> fluent_builders::DescribeAccountModifications {
        fluent_builders::DescribeAccountModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClientProperties`](crate::client::fluent_builders::DescribeClientProperties) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_ids(Vec<String>)`](crate::client::fluent_builders::DescribeClientProperties::resource_ids) / [`set_resource_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClientProperties::set_resource_ids): <p>The resource identifier, in the form of directory IDs.</p>
    /// - On success, responds with [`DescribeClientPropertiesOutput`](crate::output::DescribeClientPropertiesOutput) with field(s):
    ///   - [`client_properties_list(Option<Vec<ClientPropertiesResult>>)`](crate::output::DescribeClientPropertiesOutput::client_properties_list): <p>Information about the specified Amazon WorkSpaces clients.</p>
    /// - On failure, responds with [`SdkError<DescribeClientPropertiesError>`](crate::error::DescribeClientPropertiesError)
    pub fn describe_client_properties(&self) -> fluent_builders::DescribeClientProperties {
        fluent_builders::DescribeClientProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnectClientAddIns`](crate::client::fluent_builders::DescribeConnectClientAddIns) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectClientAddIns::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DescribeConnectClientAddIns::set_resource_id): <p>The directory identifier for which the client add-in is configured.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectClientAddIns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeConnectClientAddIns::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeConnectClientAddIns::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeConnectClientAddIns::set_max_results): <p>The maximum number of items to return.</p>
    /// - On success, responds with [`DescribeConnectClientAddInsOutput`](crate::output::DescribeConnectClientAddInsOutput) with field(s):
    ///   - [`add_ins(Option<Vec<ConnectClientAddIn>>)`](crate::output::DescribeConnectClientAddInsOutput::add_ins): <p>Information about client add-ins.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeConnectClientAddInsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeConnectClientAddInsError>`](crate::error::DescribeConnectClientAddInsError)
    pub fn describe_connect_client_add_ins(&self) -> fluent_builders::DescribeConnectClientAddIns {
        fluent_builders::DescribeConnectClientAddIns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnectionAliases`](crate::client::fluent_builders::DescribeConnectionAliases) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias_ids(Vec<String>)`](crate::client::fluent_builders::DescribeConnectionAliases::alias_ids) / [`set_alias_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeConnectionAliases::set_alias_ids): <p>The identifiers of the connection aliases to describe.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectionAliases::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DescribeConnectionAliases::set_resource_id): <p>The identifier of the directory associated with the connection alias.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeConnectionAliases::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeConnectionAliases::set_limit): <p>The maximum number of connection aliases to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectionAliases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeConnectionAliases::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>
    /// - On success, responds with [`DescribeConnectionAliasesOutput`](crate::output::DescribeConnectionAliasesOutput) with field(s):
    ///   - [`connection_aliases(Option<Vec<ConnectionAlias>>)`](crate::output::DescribeConnectionAliasesOutput::connection_aliases): <p>Information about the specified connection aliases.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeConnectionAliasesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeConnectionAliasesError>`](crate::error::DescribeConnectionAliasesError)
    pub fn describe_connection_aliases(&self) -> fluent_builders::DescribeConnectionAliases {
        fluent_builders::DescribeConnectionAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnectionAliasPermissions`](crate::client::fluent_builders::DescribeConnectionAliasPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias_id(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectionAliasPermissions::alias_id) / [`set_alias_id(Option<String>)`](crate::client::fluent_builders::DescribeConnectionAliasPermissions::set_alias_id): <p>The identifier of the connection alias.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeConnectionAliasPermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeConnectionAliasPermissions::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeConnectionAliasPermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeConnectionAliasPermissions::set_max_results): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`DescribeConnectionAliasPermissionsOutput`](crate::output::DescribeConnectionAliasPermissionsOutput) with field(s):
    ///   - [`alias_id(Option<String>)`](crate::output::DescribeConnectionAliasPermissionsOutput::alias_id): <p>The identifier of the connection alias.</p>
    ///   - [`connection_alias_permissions(Option<Vec<ConnectionAliasPermission>>)`](crate::output::DescribeConnectionAliasPermissionsOutput::connection_alias_permissions): <p>The permissions associated with a connection alias.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeConnectionAliasPermissionsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeConnectionAliasPermissionsError>`](crate::error::DescribeConnectionAliasPermissionsError)
    pub fn describe_connection_alias_permissions(
        &self,
    ) -> fluent_builders::DescribeConnectionAliasPermissions {
        fluent_builders::DescribeConnectionAliasPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIpGroups`](crate::client::fluent_builders::DescribeIpGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_ids(Vec<String>)`](crate::client::fluent_builders::DescribeIpGroups::group_ids) / [`set_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeIpGroups::set_group_ids): <p>The identifiers of one or more IP access control groups.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeIpGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeIpGroups::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeIpGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeIpGroups::set_max_results): <p>The maximum number of items to return.</p>
    /// - On success, responds with [`DescribeIpGroupsOutput`](crate::output::DescribeIpGroupsOutput) with field(s):
    ///   - [`result(Option<Vec<WorkspacesIpGroup>>)`](crate::output::DescribeIpGroupsOutput::result): <p>Information about the IP access control groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeIpGroupsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeIpGroupsError>`](crate::error::DescribeIpGroupsError)
    pub fn describe_ip_groups(&self) -> fluent_builders::DescribeIpGroups {
        fluent_builders::DescribeIpGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTags`](crate::client::fluent_builders::DescribeTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTags::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DescribeTags::set_resource_id): <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
    /// - On success, responds with [`DescribeTagsOutput`](crate::output::DescribeTagsOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::DescribeTagsOutput::tag_list): <p>The tags.</p>
    /// - On failure, responds with [`SdkError<DescribeTagsError>`](crate::error::DescribeTagsError)
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkspaceBundles`](crate::client::fluent_builders::DescribeWorkspaceBundles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeWorkspaceBundles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bundle_ids(Vec<String>)`](crate::client::fluent_builders::DescribeWorkspaceBundles::bundle_ids) / [`set_bundle_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeWorkspaceBundles::set_bundle_ids): <p>The identifiers of the bundles. You cannot combine this parameter with any other filter.</p>
    ///   - [`owner(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaceBundles::owner) / [`set_owner(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaceBundles::set_owner): <p>The owner of the bundles. You cannot combine this parameter with any other filter.</p>  <p>To describe the bundles provided by Amazon Web Services, specify <code>AMAZON</code>. To describe the bundles that belong to your account, don't specify a value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaceBundles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaceBundles::set_next_token): <p>The token for the next set of results. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeWorkspaceBundlesOutput`](crate::output::DescribeWorkspaceBundlesOutput) with field(s):
    ///   - [`bundles(Option<Vec<WorkspaceBundle>>)`](crate::output::DescribeWorkspaceBundlesOutput::bundles): <p>Information about the bundles.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeWorkspaceBundlesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. This token is valid for one day and must be used within that time frame.</p>
    /// - On failure, responds with [`SdkError<DescribeWorkspaceBundlesError>`](crate::error::DescribeWorkspaceBundlesError)
    pub fn describe_workspace_bundles(&self) -> fluent_builders::DescribeWorkspaceBundles {
        fluent_builders::DescribeWorkspaceBundles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkspaceDirectories`](crate::client::fluent_builders::DescribeWorkspaceDirectories) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeWorkspaceDirectories::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_ids(Vec<String>)`](crate::client::fluent_builders::DescribeWorkspaceDirectories::directory_ids) / [`set_directory_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeWorkspaceDirectories::set_directory_ids): <p>The identifiers of the directories. If the value is null, all directories are retrieved.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeWorkspaceDirectories::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeWorkspaceDirectories::set_limit): <p>The maximum number of directories to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaceDirectories::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaceDirectories::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
    /// - On success, responds with [`DescribeWorkspaceDirectoriesOutput`](crate::output::DescribeWorkspaceDirectoriesOutput) with field(s):
    ///   - [`directories(Option<Vec<WorkspaceDirectory>>)`](crate::output::DescribeWorkspaceDirectoriesOutput::directories): <p>Information about the directories.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeWorkspaceDirectoriesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeWorkspaceDirectoriesError>`](crate::error::DescribeWorkspaceDirectoriesError)
    pub fn describe_workspace_directories(&self) -> fluent_builders::DescribeWorkspaceDirectories {
        fluent_builders::DescribeWorkspaceDirectories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkspaceImagePermissions`](crate::client::fluent_builders::DescribeWorkspaceImagePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_id(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaceImagePermissions::image_id) / [`set_image_id(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaceImagePermissions::set_image_id): <p>The identifier of the image.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaceImagePermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaceImagePermissions::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeWorkspaceImagePermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeWorkspaceImagePermissions::set_max_results): <p>The maximum number of items to return.</p>
    /// - On success, responds with [`DescribeWorkspaceImagePermissionsOutput`](crate::output::DescribeWorkspaceImagePermissionsOutput) with field(s):
    ///   - [`image_id(Option<String>)`](crate::output::DescribeWorkspaceImagePermissionsOutput::image_id): <p>The identifier of the image.</p>
    ///   - [`image_permissions(Option<Vec<ImagePermission>>)`](crate::output::DescribeWorkspaceImagePermissionsOutput::image_permissions): <p>The identifiers of the Amazon Web Services accounts that the image has been shared with.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeWorkspaceImagePermissionsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeWorkspaceImagePermissionsError>`](crate::error::DescribeWorkspaceImagePermissionsError)
    pub fn describe_workspace_image_permissions(
        &self,
    ) -> fluent_builders::DescribeWorkspaceImagePermissions {
        fluent_builders::DescribeWorkspaceImagePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkspaceImages`](crate::client::fluent_builders::DescribeWorkspaceImages) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_ids(Vec<String>)`](crate::client::fluent_builders::DescribeWorkspaceImages::image_ids) / [`set_image_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeWorkspaceImages::set_image_ids): <p>The identifier of the image.</p>
    ///   - [`image_type(ImageType)`](crate::client::fluent_builders::DescribeWorkspaceImages::image_type) / [`set_image_type(Option<ImageType>)`](crate::client::fluent_builders::DescribeWorkspaceImages::set_image_type): <p>The type (owned or shared) of the image.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaceImages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaceImages::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeWorkspaceImages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeWorkspaceImages::set_max_results): <p>The maximum number of items to return.</p>
    /// - On success, responds with [`DescribeWorkspaceImagesOutput`](crate::output::DescribeWorkspaceImagesOutput) with field(s):
    ///   - [`images(Option<Vec<WorkspaceImage>>)`](crate::output::DescribeWorkspaceImagesOutput::images): <p>Information about the images.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeWorkspaceImagesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeWorkspaceImagesError>`](crate::error::DescribeWorkspaceImagesError)
    pub fn describe_workspace_images(&self) -> fluent_builders::DescribeWorkspaceImages {
        fluent_builders::DescribeWorkspaceImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkspaces`](crate::client::fluent_builders::DescribeWorkspaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeWorkspaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_ids(Vec<String>)`](crate::client::fluent_builders::DescribeWorkspaces::workspace_ids) / [`set_workspace_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeWorkspaces::set_workspace_ids): <p>The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.</p>  <p>Because the <code>CreateWorkspaces</code> operation is asynchronous, the identifier it returns is not immediately available. If you immediately call <code>DescribeWorkspaces</code> with this identifier, no information is returned.</p>
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaces::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaces::set_directory_id): <p>The identifier of the directory. In addition, you can optionally specify a specific directory user (see <code>UserName</code>). You cannot combine this parameter with any other filter.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaces::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaces::set_user_name): <p>The name of the directory user. You must specify this parameter with <code>DirectoryId</code>.</p>
    ///   - [`bundle_id(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaces::bundle_id) / [`set_bundle_id(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaces::set_bundle_id): <p>The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot combine this parameter with any other filter.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeWorkspaces::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeWorkspaces::set_limit): <p>The maximum number of items to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaces::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
    /// - On success, responds with [`DescribeWorkspacesOutput`](crate::output::DescribeWorkspacesOutput) with field(s):
    ///   - [`workspaces(Option<Vec<Workspace>>)`](crate::output::DescribeWorkspacesOutput::workspaces): <p>Information about the WorkSpaces.</p>  <p>Because <code>CreateWorkspaces</code> is an asynchronous operation, some of the returned information could be incomplete.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeWorkspacesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeWorkspacesError>`](crate::error::DescribeWorkspacesError)
    pub fn describe_workspaces(&self) -> fluent_builders::DescribeWorkspaces {
        fluent_builders::DescribeWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkspacesConnectionStatus`](crate::client::fluent_builders::DescribeWorkspacesConnectionStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_ids(Vec<String>)`](crate::client::fluent_builders::DescribeWorkspacesConnectionStatus::workspace_ids) / [`set_workspace_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeWorkspacesConnectionStatus::set_workspace_ids): <p>The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspacesConnectionStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeWorkspacesConnectionStatus::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
    /// - On success, responds with [`DescribeWorkspacesConnectionStatusOutput`](crate::output::DescribeWorkspacesConnectionStatusOutput) with field(s):
    ///   - [`workspaces_connection_status(Option<Vec<WorkspaceConnectionStatus>>)`](crate::output::DescribeWorkspacesConnectionStatusOutput::workspaces_connection_status): <p>Information about the connection status of the WorkSpace.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeWorkspacesConnectionStatusOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeWorkspacesConnectionStatusError>`](crate::error::DescribeWorkspacesConnectionStatusError)
    pub fn describe_workspaces_connection_status(
        &self,
    ) -> fluent_builders::DescribeWorkspacesConnectionStatus {
        fluent_builders::DescribeWorkspacesConnectionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkspaceSnapshots`](crate::client::fluent_builders::DescribeWorkspaceSnapshots) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaceSnapshots::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaceSnapshots::set_workspace_id): <p>The identifier of the WorkSpace.</p>
    /// - On success, responds with [`DescribeWorkspaceSnapshotsOutput`](crate::output::DescribeWorkspaceSnapshotsOutput) with field(s):
    ///   - [`rebuild_snapshots(Option<Vec<Snapshot>>)`](crate::output::DescribeWorkspaceSnapshotsOutput::rebuild_snapshots): <p>Information about the snapshots that can be used to rebuild a WorkSpace. These snapshots include the user volume.</p>
    ///   - [`restore_snapshots(Option<Vec<Snapshot>>)`](crate::output::DescribeWorkspaceSnapshotsOutput::restore_snapshots): <p>Information about the snapshots that can be used to restore a WorkSpace. These snapshots include both the root volume and the user volume.</p>
    /// - On failure, responds with [`SdkError<DescribeWorkspaceSnapshotsError>`](crate::error::DescribeWorkspaceSnapshotsError)
    pub fn describe_workspace_snapshots(&self) -> fluent_builders::DescribeWorkspaceSnapshots {
        fluent_builders::DescribeWorkspaceSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateConnectionAlias`](crate::client::fluent_builders::DisassociateConnectionAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateConnectionAlias::alias_id) / [`set_alias_id(Option<String>)`](crate::client::fluent_builders::DisassociateConnectionAlias::set_alias_id): <p>The identifier of the connection alias to disassociate.</p>
    /// - On success, responds with [`DisassociateConnectionAliasOutput`](crate::output::DisassociateConnectionAliasOutput)

    /// - On failure, responds with [`SdkError<DisassociateConnectionAliasError>`](crate::error::DisassociateConnectionAliasError)
    pub fn disassociate_connection_alias(&self) -> fluent_builders::DisassociateConnectionAlias {
        fluent_builders::DisassociateConnectionAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateIpGroups`](crate::client::fluent_builders::DisassociateIpGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateIpGroups::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::DisassociateIpGroups::set_directory_id): <p>The identifier of the directory.</p>
    ///   - [`group_ids(Vec<String>)`](crate::client::fluent_builders::DisassociateIpGroups::group_ids) / [`set_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateIpGroups::set_group_ids): <p>The identifiers of one or more IP access control groups.</p>
    /// - On success, responds with [`DisassociateIpGroupsOutput`](crate::output::DisassociateIpGroupsOutput)

    /// - On failure, responds with [`SdkError<DisassociateIpGroupsError>`](crate::error::DisassociateIpGroupsError)
    pub fn disassociate_ip_groups(&self) -> fluent_builders::DisassociateIpGroups {
        fluent_builders::DisassociateIpGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportWorkspaceImage`](crate::client::fluent_builders::ImportWorkspaceImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ec2_image_id(impl Into<String>)`](crate::client::fluent_builders::ImportWorkspaceImage::ec2_image_id) / [`set_ec2_image_id(Option<String>)`](crate::client::fluent_builders::ImportWorkspaceImage::set_ec2_image_id): <p>The identifier of the EC2 image.</p>
    ///   - [`ingestion_process(WorkspaceImageIngestionProcess)`](crate::client::fluent_builders::ImportWorkspaceImage::ingestion_process) / [`set_ingestion_process(Option<WorkspaceImageIngestionProcess>)`](crate::client::fluent_builders::ImportWorkspaceImage::set_ingestion_process): <p>The ingestion process to be used when importing the image, depending on which protocol you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces Streaming Protocol (WSP). To use WSP, specify a value that ends in <code>_WSP</code>. To use PCoIP, specify a value that does not end in <code>_WSP</code>. </p>  <p>For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify <code>BYOL_REGULAR</code> or <code>BYOL_REGULAR_WSP</code>, depending on the protocol.</p>
    ///   - [`image_name(impl Into<String>)`](crate::client::fluent_builders::ImportWorkspaceImage::image_name) / [`set_image_name(Option<String>)`](crate::client::fluent_builders::ImportWorkspaceImage::set_image_name): <p>The name of the WorkSpace image.</p>
    ///   - [`image_description(impl Into<String>)`](crate::client::fluent_builders::ImportWorkspaceImage::image_description) / [`set_image_description(Option<String>)`](crate::client::fluent_builders::ImportWorkspaceImage::set_image_description): <p>The description of the WorkSpace image.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::ImportWorkspaceImage::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::ImportWorkspaceImage::set_tags): <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
    ///   - [`applications(Vec<Application>)`](crate::client::fluent_builders::ImportWorkspaceImage::applications) / [`set_applications(Option<Vec<Application>>)`](crate::client::fluent_builders::ImportWorkspaceImage::set_applications): <p>If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10 BYOL images. For more information about subscribing to Office for BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows Desktop Licenses</a>.</p> <note>   <p>Although this parameter is an array, only one item is allowed at this time.</p>  </note>
    /// - On success, responds with [`ImportWorkspaceImageOutput`](crate::output::ImportWorkspaceImageOutput) with field(s):
    ///   - [`image_id(Option<String>)`](crate::output::ImportWorkspaceImageOutput::image_id): <p>The identifier of the WorkSpace image.</p>
    /// - On failure, responds with [`SdkError<ImportWorkspaceImageError>`](crate::error::ImportWorkspaceImageError)
    pub fn import_workspace_image(&self) -> fluent_builders::ImportWorkspaceImage {
        fluent_builders::ImportWorkspaceImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAvailableManagementCidrRanges`](crate::client::fluent_builders::ListAvailableManagementCidrRanges) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`management_cidr_range_constraint(impl Into<String>)`](crate::client::fluent_builders::ListAvailableManagementCidrRanges::management_cidr_range_constraint) / [`set_management_cidr_range_constraint(Option<String>)`](crate::client::fluent_builders::ListAvailableManagementCidrRanges::set_management_cidr_range_constraint): <p>The IP address range to search. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAvailableManagementCidrRanges::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAvailableManagementCidrRanges::set_max_results): <p>The maximum number of items to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAvailableManagementCidrRanges::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAvailableManagementCidrRanges::set_next_token): <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
    /// - On success, responds with [`ListAvailableManagementCidrRangesOutput`](crate::output::ListAvailableManagementCidrRangesOutput) with field(s):
    ///   - [`management_cidr_ranges(Option<Vec<String>>)`](crate::output::ListAvailableManagementCidrRangesOutput::management_cidr_ranges): <p>The list of available IP address ranges, specified as IPv4 CIDR blocks.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAvailableManagementCidrRangesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<ListAvailableManagementCidrRangesError>`](crate::error::ListAvailableManagementCidrRangesError)
    pub fn list_available_management_cidr_ranges(
        &self,
    ) -> fluent_builders::ListAvailableManagementCidrRanges {
        fluent_builders::ListAvailableManagementCidrRanges::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MigrateWorkspace`](crate::client::fluent_builders::MigrateWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_workspace_id(impl Into<String>)`](crate::client::fluent_builders::MigrateWorkspace::source_workspace_id) / [`set_source_workspace_id(Option<String>)`](crate::client::fluent_builders::MigrateWorkspace::set_source_workspace_id): <p>The identifier of the WorkSpace to migrate from.</p>
    ///   - [`bundle_id(impl Into<String>)`](crate::client::fluent_builders::MigrateWorkspace::bundle_id) / [`set_bundle_id(Option<String>)`](crate::client::fluent_builders::MigrateWorkspace::set_bundle_id): <p>The identifier of the target bundle type to migrate the WorkSpace to.</p>
    /// - On success, responds with [`MigrateWorkspaceOutput`](crate::output::MigrateWorkspaceOutput) with field(s):
    ///   - [`source_workspace_id(Option<String>)`](crate::output::MigrateWorkspaceOutput::source_workspace_id): <p>The original identifier of the WorkSpace that is being migrated.</p>
    ///   - [`target_workspace_id(Option<String>)`](crate::output::MigrateWorkspaceOutput::target_workspace_id): <p>The new identifier of the WorkSpace that is being migrated. If the migration does not succeed, the target WorkSpace ID will not be used, and the WorkSpace will still have the original WorkSpace ID.</p>
    /// - On failure, responds with [`SdkError<MigrateWorkspaceError>`](crate::error::MigrateWorkspaceError)
    pub fn migrate_workspace(&self) -> fluent_builders::MigrateWorkspace {
        fluent_builders::MigrateWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyAccount`](crate::client::fluent_builders::ModifyAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dedicated_tenancy_support(DedicatedTenancySupportEnum)`](crate::client::fluent_builders::ModifyAccount::dedicated_tenancy_support) / [`set_dedicated_tenancy_support(Option<DedicatedTenancySupportEnum>)`](crate::client::fluent_builders::ModifyAccount::set_dedicated_tenancy_support): <p>The status of BYOL.</p>
    ///   - [`dedicated_tenancy_management_cidr_range(impl Into<String>)`](crate::client::fluent_builders::ModifyAccount::dedicated_tenancy_management_cidr_range) / [`set_dedicated_tenancy_management_cidr_range(Option<String>)`](crate::client::fluent_builders::ModifyAccount::set_dedicated_tenancy_management_cidr_range): <p>The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be specified as available by the <code>ListAvailableManagementCidrRanges</code> operation.</p>
    /// - On success, responds with [`ModifyAccountOutput`](crate::output::ModifyAccountOutput)

    /// - On failure, responds with [`SdkError<ModifyAccountError>`](crate::error::ModifyAccountError)
    pub fn modify_account(&self) -> fluent_builders::ModifyAccount {
        fluent_builders::ModifyAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyClientProperties`](crate::client::fluent_builders::ModifyClientProperties) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ModifyClientProperties::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ModifyClientProperties::set_resource_id): <p>The resource identifiers, in the form of directory IDs.</p>
    ///   - [`client_properties(ClientProperties)`](crate::client::fluent_builders::ModifyClientProperties::client_properties) / [`set_client_properties(Option<ClientProperties>)`](crate::client::fluent_builders::ModifyClientProperties::set_client_properties): <p>Information about the Amazon WorkSpaces client.</p>
    /// - On success, responds with [`ModifyClientPropertiesOutput`](crate::output::ModifyClientPropertiesOutput)

    /// - On failure, responds with [`SdkError<ModifyClientPropertiesError>`](crate::error::ModifyClientPropertiesError)
    pub fn modify_client_properties(&self) -> fluent_builders::ModifyClientProperties {
        fluent_builders::ModifyClientProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifySelfservicePermissions`](crate::client::fluent_builders::ModifySelfservicePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ModifySelfservicePermissions::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ModifySelfservicePermissions::set_resource_id): <p>The identifier of the directory.</p>
    ///   - [`selfservice_permissions(SelfservicePermissions)`](crate::client::fluent_builders::ModifySelfservicePermissions::selfservice_permissions) / [`set_selfservice_permissions(Option<SelfservicePermissions>)`](crate::client::fluent_builders::ModifySelfservicePermissions::set_selfservice_permissions): <p>The permissions to enable or disable self-service capabilities.</p>
    /// - On success, responds with [`ModifySelfservicePermissionsOutput`](crate::output::ModifySelfservicePermissionsOutput)

    /// - On failure, responds with [`SdkError<ModifySelfservicePermissionsError>`](crate::error::ModifySelfservicePermissionsError)
    pub fn modify_selfservice_permissions(&self) -> fluent_builders::ModifySelfservicePermissions {
        fluent_builders::ModifySelfservicePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyWorkspaceAccessProperties`](crate::client::fluent_builders::ModifyWorkspaceAccessProperties) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ModifyWorkspaceAccessProperties::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ModifyWorkspaceAccessProperties::set_resource_id): <p>The identifier of the directory.</p>
    ///   - [`workspace_access_properties(WorkspaceAccessProperties)`](crate::client::fluent_builders::ModifyWorkspaceAccessProperties::workspace_access_properties) / [`set_workspace_access_properties(Option<WorkspaceAccessProperties>)`](crate::client::fluent_builders::ModifyWorkspaceAccessProperties::set_workspace_access_properties): <p>The device types and operating systems to enable or disable for access.</p>
    /// - On success, responds with [`ModifyWorkspaceAccessPropertiesOutput`](crate::output::ModifyWorkspaceAccessPropertiesOutput)

    /// - On failure, responds with [`SdkError<ModifyWorkspaceAccessPropertiesError>`](crate::error::ModifyWorkspaceAccessPropertiesError)
    pub fn modify_workspace_access_properties(
        &self,
    ) -> fluent_builders::ModifyWorkspaceAccessProperties {
        fluent_builders::ModifyWorkspaceAccessProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyWorkspaceCreationProperties`](crate::client::fluent_builders::ModifyWorkspaceCreationProperties) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ModifyWorkspaceCreationProperties::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ModifyWorkspaceCreationProperties::set_resource_id): <p>The identifier of the directory.</p>
    ///   - [`workspace_creation_properties(WorkspaceCreationProperties)`](crate::client::fluent_builders::ModifyWorkspaceCreationProperties::workspace_creation_properties) / [`set_workspace_creation_properties(Option<WorkspaceCreationProperties>)`](crate::client::fluent_builders::ModifyWorkspaceCreationProperties::set_workspace_creation_properties): <p>The default properties for creating WorkSpaces.</p>
    /// - On success, responds with [`ModifyWorkspaceCreationPropertiesOutput`](crate::output::ModifyWorkspaceCreationPropertiesOutput)

    /// - On failure, responds with [`SdkError<ModifyWorkspaceCreationPropertiesError>`](crate::error::ModifyWorkspaceCreationPropertiesError)
    pub fn modify_workspace_creation_properties(
        &self,
    ) -> fluent_builders::ModifyWorkspaceCreationProperties {
        fluent_builders::ModifyWorkspaceCreationProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyWorkspaceProperties`](crate::client::fluent_builders::ModifyWorkspaceProperties) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::ModifyWorkspaceProperties::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::ModifyWorkspaceProperties::set_workspace_id): <p>The identifier of the WorkSpace.</p>
    ///   - [`workspace_properties(WorkspaceProperties)`](crate::client::fluent_builders::ModifyWorkspaceProperties::workspace_properties) / [`set_workspace_properties(Option<WorkspaceProperties>)`](crate::client::fluent_builders::ModifyWorkspaceProperties::set_workspace_properties): <p>The properties of the WorkSpace.</p>
    /// - On success, responds with [`ModifyWorkspacePropertiesOutput`](crate::output::ModifyWorkspacePropertiesOutput)

    /// - On failure, responds with [`SdkError<ModifyWorkspacePropertiesError>`](crate::error::ModifyWorkspacePropertiesError)
    pub fn modify_workspace_properties(&self) -> fluent_builders::ModifyWorkspaceProperties {
        fluent_builders::ModifyWorkspaceProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyWorkspaceState`](crate::client::fluent_builders::ModifyWorkspaceState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::ModifyWorkspaceState::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::ModifyWorkspaceState::set_workspace_id): <p>The identifier of the WorkSpace.</p>
    ///   - [`workspace_state(TargetWorkspaceState)`](crate::client::fluent_builders::ModifyWorkspaceState::workspace_state) / [`set_workspace_state(Option<TargetWorkspaceState>)`](crate::client::fluent_builders::ModifyWorkspaceState::set_workspace_state): <p>The WorkSpace state.</p>
    /// - On success, responds with [`ModifyWorkspaceStateOutput`](crate::output::ModifyWorkspaceStateOutput)

    /// - On failure, responds with [`SdkError<ModifyWorkspaceStateError>`](crate::error::ModifyWorkspaceStateError)
    pub fn modify_workspace_state(&self) -> fluent_builders::ModifyWorkspaceState {
        fluent_builders::ModifyWorkspaceState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebootWorkspaces`](crate::client::fluent_builders::RebootWorkspaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`reboot_workspace_requests(Vec<RebootRequest>)`](crate::client::fluent_builders::RebootWorkspaces::reboot_workspace_requests) / [`set_reboot_workspace_requests(Option<Vec<RebootRequest>>)`](crate::client::fluent_builders::RebootWorkspaces::set_reboot_workspace_requests): <p>The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.</p>
    /// - On success, responds with [`RebootWorkspacesOutput`](crate::output::RebootWorkspacesOutput) with field(s):
    ///   - [`failed_requests(Option<Vec<FailedWorkspaceChangeRequest>>)`](crate::output::RebootWorkspacesOutput::failed_requests): <p>Information about the WorkSpaces that could not be rebooted.</p>
    /// - On failure, responds with [`SdkError<RebootWorkspacesError>`](crate::error::RebootWorkspacesError)
    pub fn reboot_workspaces(&self) -> fluent_builders::RebootWorkspaces {
        fluent_builders::RebootWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebuildWorkspaces`](crate::client::fluent_builders::RebuildWorkspaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rebuild_workspace_requests(Vec<RebuildRequest>)`](crate::client::fluent_builders::RebuildWorkspaces::rebuild_workspace_requests) / [`set_rebuild_workspace_requests(Option<Vec<RebuildRequest>>)`](crate::client::fluent_builders::RebuildWorkspaces::set_rebuild_workspace_requests): <p>The WorkSpace to rebuild. You can specify a single WorkSpace.</p>
    /// - On success, responds with [`RebuildWorkspacesOutput`](crate::output::RebuildWorkspacesOutput) with field(s):
    ///   - [`failed_requests(Option<Vec<FailedWorkspaceChangeRequest>>)`](crate::output::RebuildWorkspacesOutput::failed_requests): <p>Information about the WorkSpace that could not be rebuilt.</p>
    /// - On failure, responds with [`SdkError<RebuildWorkspacesError>`](crate::error::RebuildWorkspacesError)
    pub fn rebuild_workspaces(&self) -> fluent_builders::RebuildWorkspaces {
        fluent_builders::RebuildWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterWorkspaceDirectory`](crate::client::fluent_builders::RegisterWorkspaceDirectory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::set_directory_id): <p>The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::set_subnet_ids): <p>The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error.</p>
    ///   - [`enable_work_docs(bool)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::enable_work_docs) / [`set_enable_work_docs(Option<bool>)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::set_enable_work_docs): <p>Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set <code>EnableWorkDocs</code> to disabled, and try again.</p>
    ///   - [`enable_self_service(bool)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::enable_self_service) / [`set_enable_self_service(Option<bool>)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::set_enable_self_service): <p>Indicates whether self-service capabilities are enabled or disabled.</p>
    ///   - [`tenancy(Tenancy)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::tenancy) / [`set_tenancy(Option<Tenancy>)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::set_tenancy): <p>Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RegisterWorkspaceDirectory::set_tags): <p>The tags associated with the directory.</p>
    /// - On success, responds with [`RegisterWorkspaceDirectoryOutput`](crate::output::RegisterWorkspaceDirectoryOutput)

    /// - On failure, responds with [`SdkError<RegisterWorkspaceDirectoryError>`](crate::error::RegisterWorkspaceDirectoryError)
    pub fn register_workspace_directory(&self) -> fluent_builders::RegisterWorkspaceDirectory {
        fluent_builders::RegisterWorkspaceDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreWorkspace`](crate::client::fluent_builders::RestoreWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::RestoreWorkspace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::RestoreWorkspace::set_workspace_id): <p>The identifier of the WorkSpace.</p>
    /// - On success, responds with [`RestoreWorkspaceOutput`](crate::output::RestoreWorkspaceOutput)

    /// - On failure, responds with [`SdkError<RestoreWorkspaceError>`](crate::error::RestoreWorkspaceError)
    pub fn restore_workspace(&self) -> fluent_builders::RestoreWorkspace {
        fluent_builders::RestoreWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeIpRules`](crate::client::fluent_builders::RevokeIpRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::RevokeIpRules::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::RevokeIpRules::set_group_id): <p>The identifier of the group.</p>
    ///   - [`user_rules(Vec<String>)`](crate::client::fluent_builders::RevokeIpRules::user_rules) / [`set_user_rules(Option<Vec<String>>)`](crate::client::fluent_builders::RevokeIpRules::set_user_rules): <p>The rules to remove from the group.</p>
    /// - On success, responds with [`RevokeIpRulesOutput`](crate::output::RevokeIpRulesOutput)

    /// - On failure, responds with [`SdkError<RevokeIpRulesError>`](crate::error::RevokeIpRulesError)
    pub fn revoke_ip_rules(&self) -> fluent_builders::RevokeIpRules {
        fluent_builders::RevokeIpRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartWorkspaces`](crate::client::fluent_builders::StartWorkspaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_workspace_requests(Vec<StartRequest>)`](crate::client::fluent_builders::StartWorkspaces::start_workspace_requests) / [`set_start_workspace_requests(Option<Vec<StartRequest>>)`](crate::client::fluent_builders::StartWorkspaces::set_start_workspace_requests): <p>The WorkSpaces to start. You can specify up to 25 WorkSpaces.</p>
    /// - On success, responds with [`StartWorkspacesOutput`](crate::output::StartWorkspacesOutput) with field(s):
    ///   - [`failed_requests(Option<Vec<FailedWorkspaceChangeRequest>>)`](crate::output::StartWorkspacesOutput::failed_requests): <p>Information about the WorkSpaces that could not be started.</p>
    /// - On failure, responds with [`SdkError<StartWorkspacesError>`](crate::error::StartWorkspacesError)
    pub fn start_workspaces(&self) -> fluent_builders::StartWorkspaces {
        fluent_builders::StartWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopWorkspaces`](crate::client::fluent_builders::StopWorkspaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stop_workspace_requests(Vec<StopRequest>)`](crate::client::fluent_builders::StopWorkspaces::stop_workspace_requests) / [`set_stop_workspace_requests(Option<Vec<StopRequest>>)`](crate::client::fluent_builders::StopWorkspaces::set_stop_workspace_requests): <p>The WorkSpaces to stop. You can specify up to 25 WorkSpaces.</p>
    /// - On success, responds with [`StopWorkspacesOutput`](crate::output::StopWorkspacesOutput) with field(s):
    ///   - [`failed_requests(Option<Vec<FailedWorkspaceChangeRequest>>)`](crate::output::StopWorkspacesOutput::failed_requests): <p>Information about the WorkSpaces that could not be stopped.</p>
    /// - On failure, responds with [`SdkError<StopWorkspacesError>`](crate::error::StopWorkspacesError)
    pub fn stop_workspaces(&self) -> fluent_builders::StopWorkspaces {
        fluent_builders::StopWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TerminateWorkspaces`](crate::client::fluent_builders::TerminateWorkspaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`terminate_workspace_requests(Vec<TerminateRequest>)`](crate::client::fluent_builders::TerminateWorkspaces::terminate_workspace_requests) / [`set_terminate_workspace_requests(Option<Vec<TerminateRequest>>)`](crate::client::fluent_builders::TerminateWorkspaces::set_terminate_workspace_requests): <p>The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.</p>
    /// - On success, responds with [`TerminateWorkspacesOutput`](crate::output::TerminateWorkspacesOutput) with field(s):
    ///   - [`failed_requests(Option<Vec<FailedWorkspaceChangeRequest>>)`](crate::output::TerminateWorkspacesOutput::failed_requests): <p>Information about the WorkSpaces that could not be terminated.</p>
    /// - On failure, responds with [`SdkError<TerminateWorkspacesError>`](crate::error::TerminateWorkspacesError)
    pub fn terminate_workspaces(&self) -> fluent_builders::TerminateWorkspaces {
        fluent_builders::TerminateWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConnectClientAddIn`](crate::client::fluent_builders::UpdateConnectClientAddIn) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`add_in_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConnectClientAddIn::add_in_id) / [`set_add_in_id(Option<String>)`](crate::client::fluent_builders::UpdateConnectClientAddIn::set_add_in_id): <p>The identifier of the client add-in to update.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConnectClientAddIn::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UpdateConnectClientAddIn::set_resource_id): <p>The directory identifier for which the client add-in is configured.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateConnectClientAddIn::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateConnectClientAddIn::set_name): <p>The name of the client add-in.</p>
    ///   - [`url(impl Into<String>)`](crate::client::fluent_builders::UpdateConnectClientAddIn::url) / [`set_url(Option<String>)`](crate::client::fluent_builders::UpdateConnectClientAddIn::set_url): <p>The endpoint URL of the Amazon Connect client add-in.</p>
    /// - On success, responds with [`UpdateConnectClientAddInOutput`](crate::output::UpdateConnectClientAddInOutput)

    /// - On failure, responds with [`SdkError<UpdateConnectClientAddInError>`](crate::error::UpdateConnectClientAddInError)
    pub fn update_connect_client_add_in(&self) -> fluent_builders::UpdateConnectClientAddIn {
        fluent_builders::UpdateConnectClientAddIn::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConnectionAliasPermission`](crate::client::fluent_builders::UpdateConnectionAliasPermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConnectionAliasPermission::alias_id) / [`set_alias_id(Option<String>)`](crate::client::fluent_builders::UpdateConnectionAliasPermission::set_alias_id): <p>The identifier of the connection alias that you want to update permissions for.</p>
    ///   - [`connection_alias_permission(ConnectionAliasPermission)`](crate::client::fluent_builders::UpdateConnectionAliasPermission::connection_alias_permission) / [`set_connection_alias_permission(Option<ConnectionAliasPermission>)`](crate::client::fluent_builders::UpdateConnectionAliasPermission::set_connection_alias_permission): <p>Indicates whether to share or unshare the connection alias with the specified Amazon Web Services account.</p>
    /// - On success, responds with [`UpdateConnectionAliasPermissionOutput`](crate::output::UpdateConnectionAliasPermissionOutput)

    /// - On failure, responds with [`SdkError<UpdateConnectionAliasPermissionError>`](crate::error::UpdateConnectionAliasPermissionError)
    pub fn update_connection_alias_permission(
        &self,
    ) -> fluent_builders::UpdateConnectionAliasPermission {
        fluent_builders::UpdateConnectionAliasPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRulesOfIpGroup`](crate::client::fluent_builders::UpdateRulesOfIpGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRulesOfIpGroup::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::UpdateRulesOfIpGroup::set_group_id): <p>The identifier of the group.</p>
    ///   - [`user_rules(Vec<IpRuleItem>)`](crate::client::fluent_builders::UpdateRulesOfIpGroup::user_rules) / [`set_user_rules(Option<Vec<IpRuleItem>>)`](crate::client::fluent_builders::UpdateRulesOfIpGroup::set_user_rules): <p>One or more rules.</p>
    /// - On success, responds with [`UpdateRulesOfIpGroupOutput`](crate::output::UpdateRulesOfIpGroupOutput)

    /// - On failure, responds with [`SdkError<UpdateRulesOfIpGroupError>`](crate::error::UpdateRulesOfIpGroupError)
    pub fn update_rules_of_ip_group(&self) -> fluent_builders::UpdateRulesOfIpGroup {
        fluent_builders::UpdateRulesOfIpGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWorkspaceBundle`](crate::client::fluent_builders::UpdateWorkspaceBundle) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bundle_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspaceBundle::bundle_id) / [`set_bundle_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkspaceBundle::set_bundle_id): <p>The identifier of the bundle.</p>
    ///   - [`image_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspaceBundle::image_id) / [`set_image_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkspaceBundle::set_image_id): <p>The identifier of the image.</p>
    /// - On success, responds with [`UpdateWorkspaceBundleOutput`](crate::output::UpdateWorkspaceBundleOutput)

    /// - On failure, responds with [`SdkError<UpdateWorkspaceBundleError>`](crate::error::UpdateWorkspaceBundleError)
    pub fn update_workspace_bundle(&self) -> fluent_builders::UpdateWorkspaceBundle {
        fluent_builders::UpdateWorkspaceBundle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWorkspaceImagePermission`](crate::client::fluent_builders::UpdateWorkspaceImagePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspaceImagePermission::image_id) / [`set_image_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkspaceImagePermission::set_image_id): <p>The identifier of the image.</p>
    ///   - [`allow_copy_image(bool)`](crate::client::fluent_builders::UpdateWorkspaceImagePermission::allow_copy_image) / [`set_allow_copy_image(Option<bool>)`](crate::client::fluent_builders::UpdateWorkspaceImagePermission::set_allow_copy_image): <p>The permission to copy the image. This permission can be revoked only after an image has been shared.</p>
    ///   - [`shared_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspaceImagePermission::shared_account_id) / [`set_shared_account_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkspaceImagePermission::set_shared_account_id): <p>The identifier of the Amazon Web Services account to share or unshare the image with.</p> <important>   <p>Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.</p>  </important>
    /// - On success, responds with [`UpdateWorkspaceImagePermissionOutput`](crate::output::UpdateWorkspaceImagePermissionOutput)

    /// - On failure, responds with [`SdkError<UpdateWorkspaceImagePermissionError>`](crate::error::UpdateWorkspaceImagePermissionError)
    pub fn update_workspace_image_permission(
        &self,
    ) -> fluent_builders::UpdateWorkspaceImagePermission {
        fluent_builders::UpdateWorkspaceImagePermission::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateConnectionAlias`.
    ///
    /// <p>Associates the specified connection alias with the specified directory to enable cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <note>
    /// <p>Before performing this operation, call <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html"> DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateConnectionAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_connection_alias_input::Builder,
    }
    impl AssociateConnectionAlias {
        /// Creates a new `AssociateConnectionAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateConnectionAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateConnectionAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_id(input.into());
            self
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_id(input);
            self
        }
        /// <p>The identifier of the directory to associate the connection alias with.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the directory to associate the connection alias with.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateIpGroups`.
    ///
    /// <p>Associates the specified IP access control group with the specified directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateIpGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_ip_groups_input::Builder,
    }
    impl AssociateIpGroups {
        /// Creates a new `AssociateIpGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateIpGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateIpGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `GroupIds`.
        ///
        /// To override the contents of this collection use [`set_group_ids`](Self::set_group_ids).
        ///
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_ids(input.into());
            self
        }
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn set_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeIpRules`.
    ///
    /// <p>Adds one or more rules to the specified IP access control group.</p>
    /// <p>This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeIpRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::authorize_ip_rules_input::Builder,
    }
    impl AuthorizeIpRules {
        /// Creates a new `AuthorizeIpRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeIpRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeIpRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// Appends an item to `UserRules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>The rules to add to the group.</p>
        pub fn user_rules(mut self, input: crate::model::IpRuleItem) -> Self {
            self.inner = self.inner.user_rules(input);
            self
        }
        /// <p>The rules to add to the group.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        ) -> Self {
            self.inner = self.inner.set_user_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyWorkspaceImage`.
    ///
    /// <p>Copies the specified image from the specified Region to the current Region. For more information about copying images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html"> Copy a Custom WorkSpaces Image</a>.</p>
    /// <p>In the China (Ningxia) Region, you can copy images only within the same Region.</p>
    /// <p>In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.</p> <important>
    /// <p>Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns an image, use the <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">DescribeWorkSpaceImages</a> and <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html">DescribeWorkspaceImagePermissions</a> API operations. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyWorkspaceImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_workspace_image_input::Builder,
    }
    impl CopyWorkspaceImage {
        /// Creates a new `CopyWorkspaceImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyWorkspaceImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyWorkspaceImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The identifier of the source image.</p>
        pub fn source_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_image_id(input.into());
            self
        }
        /// <p>The identifier of the source image.</p>
        pub fn set_source_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_image_id(input);
            self
        }
        /// <p>The identifier of the source Region.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_region(input.into());
            self
        }
        /// <p>The identifier of the source Region.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_region(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the image.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags for the image.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnectClientAddIn`.
    ///
    /// <p>Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client add-in within a directory.</p>
    /// <p>This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnectClientAddIn {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_connect_client_add_in_input::Builder,
    }
    impl CreateConnectClientAddIn {
        /// Creates a new `CreateConnectClientAddIn`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectClientAddInOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectClientAddInError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The directory identifier for which to configure the client add-in.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The directory identifier for which to configure the client add-in.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The name of the client add-in.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the client add-in.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The endpoint URL of the Amazon Connect client add-in.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.url(input.into());
            self
        }
        /// <p>The endpoint URL of the Amazon Connect client add-in.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnectionAlias`.
    ///
    /// <p>Creates the specified connection alias for use with cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnectionAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_connection_alias_input::Builder,
    }
    impl CreateConnectionAlias {
        /// Creates a new `CreateConnectionAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A connection string in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p> <important>
        /// <p>After you create a connection string, it is always associated to your Amazon Web Services account. You cannot recreate the same connection string with a different account, even if you delete all instances of it from the original account. The connection string is globally reserved for your account.</p>
        /// </important>
        pub fn connection_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_string(input.into());
            self
        }
        /// <p>A connection string in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p> <important>
        /// <p>After you create a connection string, it is always associated to your Amazon Web Services account. You cannot recreate the same connection string with a different account, even if you delete all instances of it from the original account. The connection string is globally reserved for your account.</p>
        /// </important>
        pub fn set_connection_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_string(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the connection alias.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to associate with the connection alias.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIpGroup`.
    ///
    /// <p>Creates an IP access control group.</p>
    /// <p>An IP access control group provides you with the ability to control the IP addresses from which users are allowed to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and then associate the group with your directory. You can add rules when you create the group or at any time using <code>AuthorizeIpRules</code>.</p>
    /// <p>There is a default IP access control group associated with your directory. If you don't associate an IP access control group with your directory, the default group is used. The default group includes a default rule that allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for your directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIpGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_ip_group_input::Builder,
    }
    impl CreateIpGroup {
        /// Creates a new `CreateIpGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIpGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIpGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The description of the group.</p>
        pub fn group_desc(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_desc(input.into());
            self
        }
        /// <p>The description of the group.</p>
        pub fn set_group_desc(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_desc(input);
            self
        }
        /// Appends an item to `UserRules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>The rules to add to the group.</p>
        pub fn user_rules(mut self, input: crate::model::IpRuleItem) -> Self {
            self.inner = self.inner.user_rules(input);
            self
        }
        /// <p>The rules to add to the group.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        ) -> Self {
            self.inner = self.inner.set_user_rules(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <p>Creates the specified tags for the specified WorkSpaces resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl CreateTags {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUpdatedWorkspaceImage`.
    ///
    /// <p>Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has the latest drivers and other updates required by the Amazon WorkSpaces components.</p>
    /// <p>To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html"> DescribeWorkspaceImages</a>.</p> <note>
    /// <ul>
    /// <li> <p>Only Windows 10, Windows Sever 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at this time.</p> </li>
    /// <li> <p>Microsoft Windows updates and other application updates are not included in the update process.</p> </li>
    /// <li> <p>The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated image and created a new bundle. </p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUpdatedWorkspaceImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_updated_workspace_image_input::Builder,
    }
    impl CreateUpdatedWorkspaceImage {
        /// Creates a new `CreateUpdatedWorkspaceImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUpdatedWorkspaceImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUpdatedWorkspaceImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new updated WorkSpace image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new updated WorkSpace image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of whether updates for the WorkSpace image are available.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of whether updates for the WorkSpace image are available.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The identifier of the source WorkSpace image.</p>
        pub fn source_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_image_id(input.into());
            self
        }
        /// <p>The identifier of the source WorkSpace image.</p>
        pub fn set_source_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_image_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to add to the new updated WorkSpace image.</p> <note>
        /// <p>To add tags at the same time when you're creating the updated image, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags that you want to add to the new updated WorkSpace image.</p> <note>
        /// <p>To add tags at the same time when you're creating the updated image, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkspaceBundle`.
    ///
    /// <p>Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html"> Create a Custom WorkSpaces Image and Bundle</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkspaceBundle {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_workspace_bundle_input::Builder,
    }
    impl CreateWorkspaceBundle {
        /// Creates a new `CreateWorkspaceBundle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkspaceBundleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkspaceBundleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bundle.</p>
        pub fn bundle_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_name(input.into());
            self
        }
        /// <p>The name of the bundle.</p>
        pub fn set_bundle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_name(input);
            self
        }
        /// <p>The description of the bundle.</p>
        pub fn bundle_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_description(input.into());
            self
        }
        /// <p>The description of the bundle.</p>
        pub fn set_bundle_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bundle_description(input);
            self
        }
        /// <p>The identifier of the image that is used to create the bundle.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier of the image that is used to create the bundle.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>Describes the compute type of the bundle.</p>
        pub fn compute_type(mut self, input: crate::model::ComputeType) -> Self {
            self.inner = self.inner.compute_type(input);
            self
        }
        /// <p>Describes the compute type of the bundle.</p>
        pub fn set_compute_type(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.inner = self.inner.set_compute_type(input);
            self
        }
        /// <p>Describes the user volume for a WorkSpace bundle.</p>
        pub fn user_storage(mut self, input: crate::model::UserStorage) -> Self {
            self.inner = self.inner.user_storage(input);
            self
        }
        /// <p>Describes the user volume for a WorkSpace bundle.</p>
        pub fn set_user_storage(
            mut self,
            input: std::option::Option<crate::model::UserStorage>,
        ) -> Self {
            self.inner = self.inner.set_user_storage(input);
            self
        }
        /// <p>Describes the root volume for a WorkSpace bundle.</p>
        pub fn root_storage(mut self, input: crate::model::RootStorage) -> Self {
            self.inner = self.inner.root_storage(input);
            self
        }
        /// <p>Describes the root volume for a WorkSpace bundle.</p>
        pub fn set_root_storage(
            mut self,
            input: std::option::Option<crate::model::RootStorage>,
        ) -> Self {
            self.inner = self.inner.set_root_storage(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the bundle.</p> <note>
        /// <p>To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with the bundle.</p> <note>
        /// <p>To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkspaces`.
    ///
    /// <p>Creates one or more WorkSpaces.</p>
    /// <p>This operation is asynchronous and returns before the WorkSpaces are created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkspaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_workspaces_input::Builder,
    }
    impl CreateWorkspaces {
        /// Creates a new `CreateWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkspacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Workspaces`.
        ///
        /// To override the contents of this collection use [`set_workspaces`](Self::set_workspaces).
        ///
        /// <p>The WorkSpaces to create. You can specify up to 25 WorkSpaces.</p>
        pub fn workspaces(mut self, input: crate::model::WorkspaceRequest) -> Self {
            self.inner = self.inner.workspaces(input);
            self
        }
        /// <p>The WorkSpaces to create. You can specify up to 25 WorkSpaces.</p>
        pub fn set_workspaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkspaceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_workspaces(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnectClientAddIn`.
    ///
    /// <p>Deletes a client-add-in for Amazon Connect that is configured within a directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnectClientAddIn {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_connect_client_add_in_input::Builder,
    }
    impl DeleteConnectClientAddIn {
        /// Creates a new `DeleteConnectClientAddIn`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectClientAddInOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectClientAddInError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the client add-in to delete.</p>
        pub fn add_in_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.add_in_id(input.into());
            self
        }
        /// <p>The identifier of the client add-in to delete.</p>
        pub fn set_add_in_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_add_in_id(input);
            self
        }
        /// <p>The directory identifier for which the client add-in is configured.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The directory identifier for which the client add-in is configured.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnectionAlias`.
    ///
    /// <p>Deletes the specified connection alias. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <important>
    /// <p> <b>If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your WorkSpaces users, you must take certain precautions to prevent potential security issues.</b> For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations"> Security Considerations if You Stop Using Cross-Region Redirection</a>.</p>
    /// </important> <note>
    /// <p>To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnectionAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_connection_alias_input::Builder,
    }
    impl DeleteConnectionAlias {
        /// Creates a new `DeleteConnectionAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the connection alias to delete.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_id(input.into());
            self
        }
        /// <p>The identifier of the connection alias to delete.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIpGroup`.
    ///
    /// <p>Deletes the specified IP access control group.</p>
    /// <p>You cannot delete an IP access control group that is associated with a directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIpGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_ip_group_input::Builder,
    }
    impl DeleteIpGroup {
        /// Creates a new `DeleteIpGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIpGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIpGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the IP access control group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier of the IP access control group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Deletes the specified tags from the specified WorkSpaces resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl DeleteTags {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkspaceBundle`.
    ///
    /// <p>Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html"> Delete a Custom WorkSpaces Bundle or Image</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkspaceBundle {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_workspace_bundle_input::Builder,
    }
    impl DeleteWorkspaceBundle {
        /// Creates a new `DeleteWorkspaceBundle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkspaceBundleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceBundleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bundle.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(input.into());
            self
        }
        /// <p>The identifier of the bundle.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkspaceImage`.
    ///
    /// <p>Deletes the specified image from your account. To delete an image, you must first delete any bundles that are associated with the image and unshare the image if it is shared with other accounts. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkspaceImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_workspace_image_input::Builder,
    }
    impl DeleteWorkspaceImage {
        /// Creates a new `DeleteWorkspaceImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkspaceImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterWorkspaceDirectory`.
    ///
    /// <p>Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister the directory.</p> <note>
    /// <p>Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.</p>
    /// <p>To delete empty directories, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterWorkspaceDirectory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_workspace_directory_input::Builder,
    }
    impl DeregisterWorkspaceDirectory {
        /// Creates a new `DeregisterWorkspaceDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterWorkspaceDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterWorkspaceDirectoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory. If any WorkSpaces are registered to this directory, you must remove them before you deregister the directory, or you will receive an OperationNotSupportedException error.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory. If any WorkSpaces are registered to this directory, you must remove them before you deregister the directory, or you will receive an OperationNotSupportedException error.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccount`.
    ///
    /// <p>Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_input::Builder,
    }
    impl DescribeAccount {
        /// Creates a new `DescribeAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountModifications`.
    ///
    /// <p>Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the specified account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountModifications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_modifications_input::Builder,
    }
    impl DescribeAccountModifications {
        /// Creates a new `DescribeAccountModifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountModificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountModificationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClientProperties`.
    ///
    /// <p>Retrieves a list that describes one or more specified Amazon WorkSpaces clients.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClientProperties {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_client_properties_input::Builder,
    }
    impl DescribeClientProperties {
        /// Creates a new `DescribeClientProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClientPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClientPropertiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceIds`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The resource identifier, in the form of directory IDs.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_ids(input.into());
            self
        }
        /// <p>The resource identifier, in the form of directory IDs.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectClientAddIns`.
    ///
    /// <p>Retrieves a list of Amazon Connect client add-ins that have been created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnectClientAddIns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connect_client_add_ins_input::Builder,
    }
    impl DescribeConnectClientAddIns {
        /// Creates a new `DescribeConnectClientAddIns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectClientAddInsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectClientAddInsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The directory identifier for which the client add-in is configured.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The directory identifier for which the client add-in is configured.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectionAliases`.
    ///
    /// <p>Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnectionAliases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connection_aliases_input::Builder,
    }
    impl DescribeConnectionAliases {
        /// Creates a new `DescribeConnectionAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionAliasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AliasIds`.
        ///
        /// To override the contents of this collection use [`set_alias_ids`](Self::set_alias_ids).
        ///
        /// <p>The identifiers of the connection aliases to describe.</p>
        pub fn alias_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_ids(input.into());
            self
        }
        /// <p>The identifiers of the connection aliases to describe.</p>
        pub fn set_alias_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_alias_ids(input);
            self
        }
        /// <p>The identifier of the directory associated with the connection alias.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the directory associated with the connection alias.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The maximum number of connection aliases to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of connection aliases to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectionAliasPermissions`.
    ///
    /// <p>Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account for the specified connection alias. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnectionAliasPermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connection_alias_permissions_input::Builder,
    }
    impl DescribeConnectionAliasPermissions {
        /// Creates a new `DescribeConnectionAliasPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionAliasPermissionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeConnectionAliasPermissionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_id(input.into());
            self
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_id(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIpGroups`.
    ///
    /// <p>Describes one or more of your IP access control groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIpGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_ip_groups_input::Builder,
    }
    impl DescribeIpGroups {
        /// Creates a new `DescribeIpGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIpGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIpGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `GroupIds`.
        ///
        /// To override the contents of this collection use [`set_group_ids`](Self::set_group_ids).
        ///
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_ids(input.into());
            self
        }
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn set_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_group_ids(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Describes the specified tags for the specified WorkSpaces resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl DescribeTags {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceBundles`.
    ///
    /// <p>Retrieves a list that describes the available WorkSpace bundles.</p>
    /// <p>You can filter the results using either bundle ID or owner, but not both.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceBundles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workspace_bundles_input::Builder,
    }
    impl DescribeWorkspaceBundles {
        /// Creates a new `DescribeWorkspaceBundles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceBundlesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceBundlesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeWorkspaceBundlesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeWorkspaceBundlesPaginator {
            crate::paginator::DescribeWorkspaceBundlesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `BundleIds`.
        ///
        /// To override the contents of this collection use [`set_bundle_ids`](Self::set_bundle_ids).
        ///
        /// <p>The identifiers of the bundles. You cannot combine this parameter with any other filter.</p>
        pub fn bundle_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_ids(input.into());
            self
        }
        /// <p>The identifiers of the bundles. You cannot combine this parameter with any other filter.</p>
        pub fn set_bundle_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_bundle_ids(input);
            self
        }
        /// <p>The owner of the bundles. You cannot combine this parameter with any other filter.</p>
        /// <p>To describe the bundles provided by Amazon Web Services, specify <code>AMAZON</code>. To describe the bundles that belong to your account, don't specify a value.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner(input.into());
            self
        }
        /// <p>The owner of the bundles. You cannot combine this parameter with any other filter.</p>
        /// <p>To describe the bundles provided by Amazon Web Services, specify <code>AMAZON</code>. To describe the bundles that belong to your account, don't specify a value.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// <p>The token for the next set of results. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceDirectories`.
    ///
    /// <p>Describes the available directories that are registered with Amazon WorkSpaces.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceDirectories {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workspace_directories_input::Builder,
    }
    impl DescribeWorkspaceDirectories {
        /// Creates a new `DescribeWorkspaceDirectories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceDirectoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceDirectoriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeWorkspaceDirectoriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeWorkspaceDirectoriesPaginator {
            crate::paginator::DescribeWorkspaceDirectoriesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `DirectoryIds`.
        ///
        /// To override the contents of this collection use [`set_directory_ids`](Self::set_directory_ids).
        ///
        /// <p>The identifiers of the directories. If the value is null, all directories are retrieved.</p>
        pub fn directory_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_ids(input.into());
            self
        }
        /// <p>The identifiers of the directories. If the value is null, all directories are retrieved.</p>
        pub fn set_directory_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_directory_ids(input);
            self
        }
        /// <p>The maximum number of directories to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of directories to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceImagePermissions`.
    ///
    /// <p>Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceImagePermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workspace_image_permissions_input::Builder,
    }
    impl DescribeWorkspaceImagePermissions {
        /// Creates a new `DescribeWorkspaceImagePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceImagePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceImagePermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceImages`.
    ///
    /// <p>Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise, all images in the account are described. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceImages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workspace_images_input::Builder,
    }
    impl DescribeWorkspaceImages {
        /// Creates a new `DescribeWorkspaceImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceImagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ImageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The identifier of the image.</p>
        pub fn image_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_ids(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
        /// <p>The type (owned or shared) of the image.</p>
        pub fn image_type(mut self, input: crate::model::ImageType) -> Self {
            self.inner = self.inner.image_type(input);
            self
        }
        /// <p>The type (owned or shared) of the image.</p>
        pub fn set_image_type(
            mut self,
            input: std::option::Option<crate::model::ImageType>,
        ) -> Self {
            self.inner = self.inner.set_image_type(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaces`.
    ///
    /// <p>Describes the specified WorkSpaces.</p>
    /// <p>You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify only one filter at a time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workspaces_input::Builder,
    }
    impl DescribeWorkspaces {
        /// Creates a new `DescribeWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeWorkspacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeWorkspacesPaginator {
            crate::paginator::DescribeWorkspacesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `WorkspaceIds`.
        ///
        /// To override the contents of this collection use [`set_workspace_ids`](Self::set_workspace_ids).
        ///
        /// <p>The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.</p>
        /// <p>Because the <code>CreateWorkspaces</code> operation is asynchronous, the identifier it returns is not immediately available. If you immediately call <code>DescribeWorkspaces</code> with this identifier, no information is returned.</p>
        pub fn workspace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_ids(input.into());
            self
        }
        /// <p>The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.</p>
        /// <p>Because the <code>CreateWorkspaces</code> operation is asynchronous, the identifier it returns is not immediately available. If you immediately call <code>DescribeWorkspaces</code> with this identifier, no information is returned.</p>
        pub fn set_workspace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_workspace_ids(input);
            self
        }
        /// <p>The identifier of the directory. In addition, you can optionally specify a specific directory user (see <code>UserName</code>). You cannot combine this parameter with any other filter.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory. In addition, you can optionally specify a specific directory user (see <code>UserName</code>). You cannot combine this parameter with any other filter.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the directory user. You must specify this parameter with <code>DirectoryId</code>.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the directory user. You must specify this parameter with <code>DirectoryId</code>.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot combine this parameter with any other filter.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(input.into());
            self
        }
        /// <p>The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot combine this parameter with any other filter.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspacesConnectionStatus`.
    ///
    /// <p>Describes the connection status of the specified WorkSpaces.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspacesConnectionStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workspaces_connection_status_input::Builder,
    }
    impl DescribeWorkspacesConnectionStatus {
        /// Creates a new `DescribeWorkspacesConnectionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspacesConnectionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeWorkspacesConnectionStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `WorkspaceIds`.
        ///
        /// To override the contents of this collection use [`set_workspace_ids`](Self::set_workspace_ids).
        ///
        /// <p>The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.</p>
        pub fn workspace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_ids(input.into());
            self
        }
        /// <p>The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.</p>
        pub fn set_workspace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_workspace_ids(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceSnapshots`.
    ///
    /// <p>Describes the snapshots for the specified WorkSpace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceSnapshots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workspace_snapshots_input::Builder,
    }
    impl DescribeWorkspaceSnapshots {
        /// Creates a new `DescribeWorkspaceSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceSnapshotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateConnectionAlias`.
    ///
    /// <p>Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region redirection between two directories in different Regions. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <note>
    /// <p>Before performing this operation, call <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html"> DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateConnectionAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_connection_alias_input::Builder,
    }
    impl DisassociateConnectionAlias {
        /// Creates a new `DisassociateConnectionAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateConnectionAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateConnectionAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the connection alias to disassociate.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_id(input.into());
            self
        }
        /// <p>The identifier of the connection alias to disassociate.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateIpGroups`.
    ///
    /// <p>Disassociates the specified IP access control group from the specified directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateIpGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_ip_groups_input::Builder,
    }
    impl DisassociateIpGroups {
        /// Creates a new `DisassociateIpGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateIpGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateIpGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `GroupIds`.
        ///
        /// To override the contents of this collection use [`set_group_ids`](Self::set_group_ids).
        ///
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_ids(input.into());
            self
        }
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn set_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportWorkspaceImage`.
    ///
    /// <p>Imports the specified Windows 10 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image. For more information about creating BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows Desktop Licenses</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportWorkspaceImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_workspace_image_input::Builder,
    }
    impl ImportWorkspaceImage {
        /// Creates a new `ImportWorkspaceImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportWorkspaceImageOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportWorkspaceImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the EC2 image.</p>
        pub fn ec2_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_image_id(input.into());
            self
        }
        /// <p>The identifier of the EC2 image.</p>
        pub fn set_ec2_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ec2_image_id(input);
            self
        }
        /// <p>The ingestion process to be used when importing the image, depending on which protocol you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces Streaming Protocol (WSP). To use WSP, specify a value that ends in <code>_WSP</code>. To use PCoIP, specify a value that does not end in <code>_WSP</code>. </p>
        /// <p>For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify <code>BYOL_REGULAR</code> or <code>BYOL_REGULAR_WSP</code>, depending on the protocol.</p>
        pub fn ingestion_process(
            mut self,
            input: crate::model::WorkspaceImageIngestionProcess,
        ) -> Self {
            self.inner = self.inner.ingestion_process(input);
            self
        }
        /// <p>The ingestion process to be used when importing the image, depending on which protocol you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces Streaming Protocol (WSP). To use WSP, specify a value that ends in <code>_WSP</code>. To use PCoIP, specify a value that does not end in <code>_WSP</code>. </p>
        /// <p>For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify <code>BYOL_REGULAR</code> or <code>BYOL_REGULAR_WSP</code>, depending on the protocol.</p>
        pub fn set_ingestion_process(
            mut self,
            input: std::option::Option<crate::model::WorkspaceImageIngestionProcess>,
        ) -> Self {
            self.inner = self.inner.set_ingestion_process(input);
            self
        }
        /// <p>The name of the WorkSpace image.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The name of the WorkSpace image.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The description of the WorkSpace image.</p>
        pub fn image_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_description(input.into());
            self
        }
        /// <p>The description of the WorkSpace image.</p>
        pub fn set_image_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `Applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10 BYOL images. For more information about subscribing to Office for BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows Desktop Licenses</a>.</p> <note>
        /// <p>Although this parameter is an array, only one item is allowed at this time.</p>
        /// </note>
        pub fn applications(mut self, input: crate::model::Application) -> Self {
            self.inner = self.inner.applications(input);
            self
        }
        /// <p>If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10 BYOL images. For more information about subscribing to Office for BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows Desktop Licenses</a>.</p> <note>
        /// <p>Although this parameter is an array, only one item is allowed at this time.</p>
        /// </note>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Application>>,
        ) -> Self {
            self.inner = self.inner.set_applications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAvailableManagementCidrRanges`.
    ///
    /// <p>Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management interface when you enable Bring Your Own License (BYOL). </p>
    /// <p>This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't enabled for BYOL, you'll receive an <code>AccessDeniedException</code> error.</p>
    /// <p>The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage the WorkSpace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAvailableManagementCidrRanges {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_available_management_cidr_ranges_input::Builder,
    }
    impl ListAvailableManagementCidrRanges {
        /// Creates a new `ListAvailableManagementCidrRanges`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAvailableManagementCidrRangesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAvailableManagementCidrRangesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IP address range to search. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).</p>
        pub fn management_cidr_range_constraint(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.management_cidr_range_constraint(input.into());
            self
        }
        /// <p>The IP address range to search. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).</p>
        pub fn set_management_cidr_range_constraint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_management_cidr_range_constraint(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MigrateWorkspace`.
    ///
    /// <p>Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user volume.</p>
    /// <p>The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the user volume from the last available snapshot of the original WorkSpace. During migration, the original <code>D:\Users\%USERNAME%</code> user profile folder is renamed to <code>D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\Users\%USERNAME%\</code> folder is generated by the new OS. Certain files in the old user profile are moved to the new user profile.</p>
    /// <p>For available migration scenarios, details about what happens during migration, and best practices, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MigrateWorkspace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::migrate_workspace_input::Builder,
    }
    impl MigrateWorkspace {
        /// Creates a new `MigrateWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MigrateWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::MigrateWorkspaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpace to migrate from.</p>
        pub fn source_workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_workspace_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace to migrate from.</p>
        pub fn set_source_workspace_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_workspace_id(input);
            self
        }
        /// <p>The identifier of the target bundle type to migrate the WorkSpace to.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(input.into());
            self
        }
        /// <p>The identifier of the target bundle type to migrate the WorkSpace to.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyAccount`.
    ///
    /// <p>Modifies the configuration of Bring Your Own License (BYOL) for the specified account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_account_input::Builder,
    }
    impl ModifyAccount {
        /// Creates a new `ModifyAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The status of BYOL.</p>
        pub fn dedicated_tenancy_support(
            mut self,
            input: crate::model::DedicatedTenancySupportEnum,
        ) -> Self {
            self.inner = self.inner.dedicated_tenancy_support(input);
            self
        }
        /// <p>The status of BYOL.</p>
        pub fn set_dedicated_tenancy_support(
            mut self,
            input: std::option::Option<crate::model::DedicatedTenancySupportEnum>,
        ) -> Self {
            self.inner = self.inner.set_dedicated_tenancy_support(input);
            self
        }
        /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be specified as available by the <code>ListAvailableManagementCidrRanges</code> operation.</p>
        pub fn dedicated_tenancy_management_cidr_range(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .dedicated_tenancy_management_cidr_range(input.into());
            self
        }
        /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be specified as available by the <code>ListAvailableManagementCidrRanges</code> operation.</p>
        pub fn set_dedicated_tenancy_management_cidr_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_dedicated_tenancy_management_cidr_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClientProperties`.
    ///
    /// <p>Modifies the properties of the specified Amazon WorkSpaces clients.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyClientProperties {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_client_properties_input::Builder,
    }
    impl ModifyClientProperties {
        /// Creates a new `ModifyClientProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClientPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClientPropertiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource identifiers, in the form of directory IDs.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The resource identifiers, in the form of directory IDs.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Information about the Amazon WorkSpaces client.</p>
        pub fn client_properties(mut self, input: crate::model::ClientProperties) -> Self {
            self.inner = self.inner.client_properties(input);
            self
        }
        /// <p>Information about the Amazon WorkSpaces client.</p>
        pub fn set_client_properties(
            mut self,
            input: std::option::Option<crate::model::ClientProperties>,
        ) -> Self {
            self.inner = self.inner.set_client_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifySelfservicePermissions`.
    ///
    /// <p>Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html">Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifySelfservicePermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_selfservice_permissions_input::Builder,
    }
    impl ModifySelfservicePermissions {
        /// Creates a new `ModifySelfservicePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifySelfservicePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifySelfservicePermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The permissions to enable or disable self-service capabilities.</p>
        pub fn selfservice_permissions(
            mut self,
            input: crate::model::SelfservicePermissions,
        ) -> Self {
            self.inner = self.inner.selfservice_permissions(input);
            self
        }
        /// <p>The permissions to enable or disable self-service capabilities.</p>
        pub fn set_selfservice_permissions(
            mut self,
            input: std::option::Option<crate::model::SelfservicePermissions>,
        ) -> Self {
            self.inner = self.inner.set_selfservice_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyWorkspaceAccessProperties`.
    ///
    /// <p>Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access"> Control Device Access</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyWorkspaceAccessProperties {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_workspace_access_properties_input::Builder,
    }
    impl ModifyWorkspaceAccessProperties {
        /// Creates a new `ModifyWorkspaceAccessProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyWorkspaceAccessPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyWorkspaceAccessPropertiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The device types and operating systems to enable or disable for access.</p>
        pub fn workspace_access_properties(
            mut self,
            input: crate::model::WorkspaceAccessProperties,
        ) -> Self {
            self.inner = self.inner.workspace_access_properties(input);
            self
        }
        /// <p>The device types and operating systems to enable or disable for access.</p>
        pub fn set_workspace_access_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceAccessProperties>,
        ) -> Self {
            self.inner = self.inner.set_workspace_access_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyWorkspaceCreationProperties`.
    ///
    /// <p>Modify the default properties used to create WorkSpaces.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyWorkspaceCreationProperties {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_workspace_creation_properties_input::Builder,
    }
    impl ModifyWorkspaceCreationProperties {
        /// Creates a new `ModifyWorkspaceCreationProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyWorkspaceCreationPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyWorkspaceCreationPropertiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The default properties for creating WorkSpaces.</p>
        pub fn workspace_creation_properties(
            mut self,
            input: crate::model::WorkspaceCreationProperties,
        ) -> Self {
            self.inner = self.inner.workspace_creation_properties(input);
            self
        }
        /// <p>The default properties for creating WorkSpaces.</p>
        pub fn set_workspace_creation_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceCreationProperties>,
        ) -> Self {
            self.inner = self.inner.set_workspace_creation_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyWorkspaceProperties`.
    ///
    /// <p>Modifies the specified WorkSpace properties. For important information about how to modify the size of the root and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html"> Modify a WorkSpace</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyWorkspaceProperties {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_workspace_properties_input::Builder,
    }
    impl ModifyWorkspaceProperties {
        /// Creates a new `ModifyWorkspaceProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyWorkspacePropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyWorkspacePropertiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The properties of the WorkSpace.</p>
        pub fn workspace_properties(mut self, input: crate::model::WorkspaceProperties) -> Self {
            self.inner = self.inner.workspace_properties(input);
            self
        }
        /// <p>The properties of the WorkSpace.</p>
        pub fn set_workspace_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceProperties>,
        ) -> Self {
            self.inner = self.inner.set_workspace_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyWorkspaceState`.
    ///
    /// <p>Sets the state of the specified WorkSpace.</p>
    /// <p>To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>. WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code> state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyWorkspaceState {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_workspace_state_input::Builder,
    }
    impl ModifyWorkspaceState {
        /// Creates a new `ModifyWorkspaceState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyWorkspaceStateOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyWorkspaceStateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The WorkSpace state.</p>
        pub fn workspace_state(mut self, input: crate::model::TargetWorkspaceState) -> Self {
            self.inner = self.inner.workspace_state(input);
            self
        }
        /// <p>The WorkSpace state.</p>
        pub fn set_workspace_state(
            mut self,
            input: std::option::Option<crate::model::TargetWorkspaceState>,
        ) -> Self {
            self.inner = self.inner.set_workspace_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootWorkspaces`.
    ///
    /// <p>Reboots the specified WorkSpaces.</p>
    /// <p>You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code> or <code>UNHEALTHY</code>.</p>
    /// <p>This operation is asynchronous and returns before the WorkSpaces have rebooted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebootWorkspaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reboot_workspaces_input::Builder,
    }
    impl RebootWorkspaces {
        /// Creates a new `RebootWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootWorkspacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `RebootWorkspaceRequests`.
        ///
        /// To override the contents of this collection use [`set_reboot_workspace_requests`](Self::set_reboot_workspace_requests).
        ///
        /// <p>The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.</p>
        pub fn reboot_workspace_requests(mut self, input: crate::model::RebootRequest) -> Self {
            self.inner = self.inner.reboot_workspace_requests(input);
            self
        }
        /// <p>The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.</p>
        pub fn set_reboot_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RebootRequest>>,
        ) -> Self {
            self.inner = self.inner.set_reboot_workspace_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebuildWorkspaces`.
    ///
    /// <p>Rebuilds the specified WorkSpace.</p>
    /// <p>You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>, <code>UNHEALTHY</code>, <code>STOPPED</code>, or <code>REBOOTING</code>.</p>
    /// <p>Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild a WorkSpace</a>.</p>
    /// <p>This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebuildWorkspaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::rebuild_workspaces_input::Builder,
    }
    impl RebuildWorkspaces {
        /// Creates a new `RebuildWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebuildWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::RebuildWorkspacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `RebuildWorkspaceRequests`.
        ///
        /// To override the contents of this collection use [`set_rebuild_workspace_requests`](Self::set_rebuild_workspace_requests).
        ///
        /// <p>The WorkSpace to rebuild. You can specify a single WorkSpace.</p>
        pub fn rebuild_workspace_requests(mut self, input: crate::model::RebuildRequest) -> Self {
            self.inner = self.inner.rebuild_workspace_requests(input);
            self
        }
        /// <p>The WorkSpace to rebuild. You can specify a single WorkSpace.</p>
        pub fn set_rebuild_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RebuildRequest>>,
        ) -> Self {
            self.inner = self.inner.set_rebuild_workspace_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterWorkspaceDirectory`.
    ///
    /// <p>Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is registered. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"> Creating the workspaces_DefaultRole Role</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterWorkspaceDirectory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_workspace_directory_input::Builder,
    }
    impl RegisterWorkspaceDirectory {
        /// Creates a new `RegisterWorkspaceDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterWorkspaceDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterWorkspaceDirectoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// <p>Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set <code>EnableWorkDocs</code> to disabled, and try again.</p>
        pub fn enable_work_docs(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_work_docs(input);
            self
        }
        /// <p>Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set <code>EnableWorkDocs</code> to disabled, and try again.</p>
        pub fn set_enable_work_docs(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_work_docs(input);
            self
        }
        /// <p>Indicates whether self-service capabilities are enabled or disabled.</p>
        pub fn enable_self_service(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_self_service(input);
            self
        }
        /// <p>Indicates whether self-service capabilities are enabled or disabled.</p>
        pub fn set_enable_self_service(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_self_service(input);
            self
        }
        /// <p>Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>
        pub fn tenancy(mut self, input: crate::model::Tenancy) -> Self {
            self.inner = self.inner.tenancy(input);
            self
        }
        /// <p>Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>
        pub fn set_tenancy(mut self, input: std::option::Option<crate::model::Tenancy>) -> Self {
            self.inner = self.inner.set_tenancy(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the directory.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with the directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreWorkspace`.
    ///
    /// <p>Restores the specified WorkSpace to its last known healthy state.</p>
    /// <p>You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>, <code>UNHEALTHY</code>, or <code>STOPPED</code>.</p>
    /// <p>Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.</p>
    /// <p>This operation is asynchronous and returns before the WorkSpace is completely restored.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreWorkspace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_workspace_input::Builder,
    }
    impl RestoreWorkspace {
        /// Creates a new `RestoreWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreWorkspaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeIpRules`.
    ///
    /// <p>Removes one or more rules from the specified IP access control group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeIpRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::revoke_ip_rules_input::Builder,
    }
    impl RevokeIpRules {
        /// Creates a new `RevokeIpRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeIpRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeIpRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// Appends an item to `UserRules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>The rules to remove from the group.</p>
        pub fn user_rules(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_rules(input.into());
            self
        }
        /// <p>The rules to remove from the group.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartWorkspaces`.
    ///
    /// <p>Starts the specified WorkSpaces.</p>
    /// <p>You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of <code>STOPPED</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartWorkspaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_workspaces_input::Builder,
    }
    impl StartWorkspaces {
        /// Creates a new `StartWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::StartWorkspacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `StartWorkspaceRequests`.
        ///
        /// To override the contents of this collection use [`set_start_workspace_requests`](Self::set_start_workspace_requests).
        ///
        /// <p>The WorkSpaces to start. You can specify up to 25 WorkSpaces.</p>
        pub fn start_workspace_requests(mut self, input: crate::model::StartRequest) -> Self {
            self.inner = self.inner.start_workspace_requests(input);
            self
        }
        /// <p>The WorkSpaces to start. You can specify up to 25 WorkSpaces.</p>
        pub fn set_start_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StartRequest>>,
        ) -> Self {
            self.inner = self.inner.set_start_workspace_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopWorkspaces`.
    ///
    /// <p> Stops the specified WorkSpaces.</p>
    /// <p>You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopWorkspaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_workspaces_input::Builder,
    }
    impl StopWorkspaces {
        /// Creates a new `StopWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::StopWorkspacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `StopWorkspaceRequests`.
        ///
        /// To override the contents of this collection use [`set_stop_workspace_requests`](Self::set_stop_workspace_requests).
        ///
        /// <p>The WorkSpaces to stop. You can specify up to 25 WorkSpaces.</p>
        pub fn stop_workspace_requests(mut self, input: crate::model::StopRequest) -> Self {
            self.inner = self.inner.stop_workspace_requests(input);
            self
        }
        /// <p>The WorkSpaces to stop. You can specify up to 25 WorkSpaces.</p>
        pub fn set_stop_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StopRequest>>,
        ) -> Self {
            self.inner = self.inner.set_stop_workspace_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateWorkspaces`.
    ///
    /// <p>Terminates the specified WorkSpaces.</p> <important>
    /// <p>Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to archive any user data, contact Amazon Web Services Support before terminating the WorkSpace.</p>
    /// </important>
    /// <p>You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.</p>
    /// <p>This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a WorkSpace is terminated, the <code>TERMINATED</code> state is returned only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkSpaces</a>. If the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.</p> <note>
    /// <p>Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.</p>
    /// <p>To delete empty directories, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TerminateWorkspaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::terminate_workspaces_input::Builder,
    }
    impl TerminateWorkspaces {
        /// Creates a new `TerminateWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateWorkspacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TerminateWorkspaceRequests`.
        ///
        /// To override the contents of this collection use [`set_terminate_workspace_requests`](Self::set_terminate_workspace_requests).
        ///
        /// <p>The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.</p>
        pub fn terminate_workspace_requests(
            mut self,
            input: crate::model::TerminateRequest,
        ) -> Self {
            self.inner = self.inner.terminate_workspace_requests(input);
            self
        }
        /// <p>The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.</p>
        pub fn set_terminate_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TerminateRequest>>,
        ) -> Self {
            self.inner = self.inner.set_terminate_workspace_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnectClientAddIn`.
    ///
    /// <p>Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect client add-in.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnectClientAddIn {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_connect_client_add_in_input::Builder,
    }
    impl UpdateConnectClientAddIn {
        /// Creates a new `UpdateConnectClientAddIn`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectClientAddInOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectClientAddInError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the client add-in to update.</p>
        pub fn add_in_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.add_in_id(input.into());
            self
        }
        /// <p>The identifier of the client add-in to update.</p>
        pub fn set_add_in_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_add_in_id(input);
            self
        }
        /// <p>The directory identifier for which the client add-in is configured.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The directory identifier for which the client add-in is configured.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The name of the client add-in.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the client add-in.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The endpoint URL of the Amazon Connect client add-in.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.url(input.into());
            self
        }
        /// <p>The endpoint URL of the Amazon Connect client add-in.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnectionAliasPermission`.
    ///
    /// <p>Shares or unshares a connection alias with one account by specifying whether that account has permission to associate the connection alias with a directory. If the association permission is granted, the connection alias is shared with that account. If the association permission is revoked, the connection alias is unshared with the account. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <note>
    /// <ul>
    /// <li> <p>Before performing this operation, call <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html"> DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>.</p> </li>
    /// <li> <p>To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnectionAliasPermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_connection_alias_permission_input::Builder,
    }
    impl UpdateConnectionAliasPermission {
        /// Creates a new `UpdateConnectionAliasPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectionAliasPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectionAliasPermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the connection alias that you want to update permissions for.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_id(input.into());
            self
        }
        /// <p>The identifier of the connection alias that you want to update permissions for.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_id(input);
            self
        }
        /// <p>Indicates whether to share or unshare the connection alias with the specified Amazon Web Services account.</p>
        pub fn connection_alias_permission(
            mut self,
            input: crate::model::ConnectionAliasPermission,
        ) -> Self {
            self.inner = self.inner.connection_alias_permission(input);
            self
        }
        /// <p>Indicates whether to share or unshare the connection alias with the specified Amazon Web Services account.</p>
        pub fn set_connection_alias_permission(
            mut self,
            input: std::option::Option<crate::model::ConnectionAliasPermission>,
        ) -> Self {
            self.inner = self.inner.set_connection_alias_permission(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRulesOfIpGroup`.
    ///
    /// <p>Replaces the current rules of the specified IP access control group with the specified rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRulesOfIpGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_rules_of_ip_group_input::Builder,
    }
    impl UpdateRulesOfIpGroup {
        /// Creates a new `UpdateRulesOfIpGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRulesOfIpGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRulesOfIpGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// Appends an item to `UserRules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>One or more rules.</p>
        pub fn user_rules(mut self, input: crate::model::IpRuleItem) -> Self {
            self.inner = self.inner.user_rules(input);
            self
        }
        /// <p>One or more rules.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        ) -> Self {
            self.inner = self.inner.set_user_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkspaceBundle`.
    ///
    /// <p>Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html"> Update a Custom WorkSpaces Bundle</a>.</p> <important>
    /// <p>Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or delete and recreate them.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkspaceBundle {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_workspace_bundle_input::Builder,
    }
    impl UpdateWorkspaceBundle {
        /// Creates a new `UpdateWorkspaceBundle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkspaceBundleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceBundleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bundle.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(input.into());
            self
        }
        /// <p>The identifier of the bundle.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkspaceImagePermission`.
    ///
    /// <p>Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that account has permission to copy the image. If the copy image permission is granted, the image is shared with that account. If the copy image permission is revoked, the image is unshared with the account.</p>
    /// <p>After an image has been shared, the recipient account can copy the image to other Regions as needed.</p>
    /// <p>In the China (Ningxia) Region, you can copy images only within the same Region.</p>
    /// <p>In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.</p>
    /// <p>For more information about sharing images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a Custom WorkSpaces Image</a>.</p> <note>
    /// <ul>
    /// <li> <p>To delete an image that has been shared, you must unshare the image before you delete it.</p> </li>
    /// <li> <p>Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US), contact Amazon Web Services Support.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkspaceImagePermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_workspace_image_permission_input::Builder,
    }
    impl UpdateWorkspaceImagePermission {
        /// Creates a new `UpdateWorkspaceImagePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkspaceImagePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceImagePermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>The permission to copy the image. This permission can be revoked only after an image has been shared.</p>
        pub fn allow_copy_image(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_copy_image(input);
            self
        }
        /// <p>The permission to copy the image. This permission can be revoked only after an image has been shared.</p>
        pub fn set_allow_copy_image(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_copy_image(input);
            self
        }
        /// <p>The identifier of the Amazon Web Services account to share or unshare the image with.</p> <important>
        /// <p>Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.</p>
        /// </important>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_account_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account to share or unshare the image with.</p> <important>
        /// <p>Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.</p>
        /// </important>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_account_id(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
