// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_connection_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateConnectionAliasOutput,
    crate::error::AssociateConnectionAliasError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateConnectionAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateConnectionAliasError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AssociateConnectionAliasError {
            meta: generic,
            kind: crate::error::AssociateConnectionAliasErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::AssociateConnectionAliasError {
            meta: generic,
            kind: crate::error::AssociateConnectionAliasErrorKind::InvalidParameterValuesException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_values_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConnectionAliasError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidResourceStateException" => crate::error::AssociateConnectionAliasError {
            meta: generic,
            kind: crate::error::AssociateConnectionAliasErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::AssociateConnectionAliasError {
            meta: generic,
            kind: crate::error::AssociateConnectionAliasErrorKind::OperationNotSupportedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_not_supported_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConnectionAliasError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceAssociatedException" => crate::error::AssociateConnectionAliasError {
            meta: generic,
            kind: crate::error::AssociateConnectionAliasErrorKind::ResourceAssociatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_associated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_associated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateConnectionAliasError {
            meta: generic,
            kind: crate::error::AssociateConnectionAliasErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateConnectionAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_connection_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateConnectionAliasOutput,
    crate::error::AssociateConnectionAliasError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_connection_alias_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_connection_alias(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateConnectionAliasError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_ip_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociateIpGroupsOutput, crate::error::AssociateIpGroupsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateIpGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateIpGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AssociateIpGroupsError {
            meta: generic,
            kind: crate::error::AssociateIpGroupsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::AssociateIpGroupsError {
            meta: generic,
            kind: crate::error::AssociateIpGroupsErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateException" => crate::error::AssociateIpGroupsError {
            meta: generic,
            kind: crate::error::AssociateIpGroupsErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::AssociateIpGroupsError {
            meta: generic,
            kind: crate::error::AssociateIpGroupsErrorKind::OperationNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::AssociateIpGroupsError {
            meta: generic,
            kind: crate::error::AssociateIpGroupsErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateIpGroupsError {
            meta: generic,
            kind: crate::error::AssociateIpGroupsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateIpGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_ip_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociateIpGroupsOutput, crate::error::AssociateIpGroupsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_ip_groups_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_ip_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AuthorizeIpRulesOutput, crate::error::AuthorizeIpRulesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AuthorizeIpRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AuthorizeIpRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AuthorizeIpRulesError {
            meta: generic,
            kind: crate::error::AuthorizeIpRulesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeIpRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::AuthorizeIpRulesError {
            meta: generic,
            kind: crate::error::AuthorizeIpRulesErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeIpRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateException" => crate::error::AuthorizeIpRulesError {
            meta: generic,
            kind: crate::error::AuthorizeIpRulesErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeIpRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::AuthorizeIpRulesError {
            meta: generic,
            kind: crate::error::AuthorizeIpRulesErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeIpRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AuthorizeIpRulesError {
            meta: generic,
            kind: crate::error::AuthorizeIpRulesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeIpRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AuthorizeIpRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_ip_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AuthorizeIpRulesOutput, crate::error::AuthorizeIpRulesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::authorize_ip_rules_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_workspace_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CopyWorkspaceImageOutput,
    crate::error::CopyWorkspaceImageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopyWorkspaceImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopyWorkspaceImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CopyWorkspaceImageError {
            meta: generic,
            kind: crate::error::CopyWorkspaceImageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopyWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::CopyWorkspaceImageError {
            meta: generic,
            kind: crate::error::CopyWorkspaceImageErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopyWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::CopyWorkspaceImageError {
            meta: generic,
            kind: crate::error::CopyWorkspaceImageErrorKind::OperationNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopyWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsException" => crate::error::CopyWorkspaceImageError {
            meta: generic,
            kind: crate::error::CopyWorkspaceImageErrorKind::ResourceAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopyWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CopyWorkspaceImageError {
            meta: generic,
            kind: crate::error::CopyWorkspaceImageErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopyWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CopyWorkspaceImageError {
            meta: generic,
            kind: crate::error::CopyWorkspaceImageErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopyWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::CopyWorkspaceImageError {
            meta: generic,
            kind: crate::error::CopyWorkspaceImageErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopyWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CopyWorkspaceImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_workspace_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CopyWorkspaceImageOutput,
    crate::error::CopyWorkspaceImageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_workspace_image_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_copy_workspace_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopyWorkspaceImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_connection_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConnectionAliasOutput,
    crate::error::CreateConnectionAliasError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateConnectionAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateConnectionAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateConnectionAliasError {
            meta: generic,
            kind: crate::error::CreateConnectionAliasErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::CreateConnectionAliasError {
            meta: generic,
            kind: crate::error::CreateConnectionAliasErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateException" => crate::error::CreateConnectionAliasError {
            meta: generic,
            kind: crate::error::CreateConnectionAliasErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::CreateConnectionAliasError {
            meta: generic,
            kind: crate::error::CreateConnectionAliasErrorKind::OperationNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsException" => crate::error::CreateConnectionAliasError {
            meta: generic,
            kind: crate::error::CreateConnectionAliasErrorKind::ResourceAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateConnectionAliasError {
            meta: generic,
            kind: crate::error::CreateConnectionAliasErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateConnectionAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_connection_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConnectionAliasOutput,
    crate::error::CreateConnectionAliasError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_connection_alias_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_connection_alias(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateConnectionAliasError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_ip_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateIpGroupOutput, crate::error::CreateIpGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateIpGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateIpGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateIpGroupError {
            meta: generic,
            kind: crate::error::CreateIpGroupErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::CreateIpGroupError {
            meta: generic,
            kind: crate::error::CreateIpGroupErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsException" => crate::error::CreateIpGroupError {
            meta: generic,
            kind: crate::error::CreateIpGroupErrorKind::ResourceAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceCreationFailedException" => crate::error::CreateIpGroupError {
            meta: generic,
            kind: crate::error::CreateIpGroupErrorKind::ResourceCreationFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_creation_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_creation_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateIpGroupError {
            meta: generic,
            kind: crate::error::CreateIpGroupErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateIpGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_ip_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateIpGroupOutput, crate::error::CreateIpGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_ip_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_ip_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateIpGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValuesException" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_updated_workspace_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateUpdatedWorkspaceImageOutput,
    crate::error::CreateUpdatedWorkspaceImageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUpdatedWorkspaceImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateUpdatedWorkspaceImageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateUpdatedWorkspaceImageError {
            meta: generic,
            kind: crate::error::CreateUpdatedWorkspaceImageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUpdatedWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::CreateUpdatedWorkspaceImageError {
            meta: generic,
            kind:
                crate::error::CreateUpdatedWorkspaceImageErrorKind::InvalidParameterValuesException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_values_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUpdatedWorkspaceImageError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidResourceStateException" => crate::error::CreateUpdatedWorkspaceImageError {
            meta: generic,
            kind: crate::error::CreateUpdatedWorkspaceImageErrorKind::InvalidResourceStateException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_resource_state_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUpdatedWorkspaceImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "OperationNotSupportedException" => crate::error::CreateUpdatedWorkspaceImageError {
            meta: generic,
            kind:
                crate::error::CreateUpdatedWorkspaceImageErrorKind::OperationNotSupportedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::operation_not_supported_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUpdatedWorkspaceImageError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceAlreadyExistsException" => crate::error::CreateUpdatedWorkspaceImageError {
            meta: generic,
            kind:
                crate::error::CreateUpdatedWorkspaceImageErrorKind::ResourceAlreadyExistsException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_already_exists_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUpdatedWorkspaceImageError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceLimitExceededException" => crate::error::CreateUpdatedWorkspaceImageError {
            meta: generic,
            kind:
                crate::error::CreateUpdatedWorkspaceImageErrorKind::ResourceLimitExceededException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_limit_exceeded_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUpdatedWorkspaceImageError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::CreateUpdatedWorkspaceImageError {
            meta: generic,
            kind: crate::error::CreateUpdatedWorkspaceImageErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUpdatedWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUpdatedWorkspaceImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_updated_workspace_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateUpdatedWorkspaceImageOutput,
    crate::error::CreateUpdatedWorkspaceImageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_updated_workspace_image_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_updated_workspace_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUpdatedWorkspaceImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_workspace_bundle_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateWorkspaceBundleOutput,
    crate::error::CreateWorkspaceBundleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateWorkspaceBundleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateWorkspaceBundleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateWorkspaceBundleError {
            meta: generic,
            kind: crate::error::CreateWorkspaceBundleErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::CreateWorkspaceBundleError {
            meta: generic,
            kind: crate::error::CreateWorkspaceBundleErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsException" => crate::error::CreateWorkspaceBundleError {
            meta: generic,
            kind: crate::error::CreateWorkspaceBundleErrorKind::ResourceAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateWorkspaceBundleError {
            meta: generic,
            kind: crate::error::CreateWorkspaceBundleErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateWorkspaceBundleError {
            meta: generic,
            kind: crate::error::CreateWorkspaceBundleErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::CreateWorkspaceBundleError {
            meta: generic,
            kind: crate::error::CreateWorkspaceBundleErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateWorkspaceBundleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_workspace_bundle_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateWorkspaceBundleOutput,
    crate::error::CreateWorkspaceBundleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_workspace_bundle_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_workspace_bundle(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateWorkspaceBundleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_workspaces_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWorkspacesOutput, crate::error::CreateWorkspacesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateWorkspacesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateWorkspacesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValuesException" => crate::error::CreateWorkspacesError {
            meta: generic,
            kind: crate::error::CreateWorkspacesErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWorkspacesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateWorkspacesError {
            meta: generic,
            kind: crate::error::CreateWorkspacesErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWorkspacesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateWorkspacesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_workspaces_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWorkspacesOutput, crate::error::CreateWorkspacesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_workspaces_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_workspaces(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateWorkspacesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_connection_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConnectionAliasOutput,
    crate::error::DeleteConnectionAliasError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteConnectionAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteConnectionAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteConnectionAliasError {
            meta: generic,
            kind: crate::error::DeleteConnectionAliasErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::DeleteConnectionAliasError {
            meta: generic,
            kind: crate::error::DeleteConnectionAliasErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateException" => crate::error::DeleteConnectionAliasError {
            meta: generic,
            kind: crate::error::DeleteConnectionAliasErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::DeleteConnectionAliasError {
            meta: generic,
            kind: crate::error::DeleteConnectionAliasErrorKind::OperationNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAssociatedException" => crate::error::DeleteConnectionAliasError {
            meta: generic,
            kind: crate::error::DeleteConnectionAliasErrorKind::ResourceAssociatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_associated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_associated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteConnectionAliasError {
            meta: generic,
            kind: crate::error::DeleteConnectionAliasErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteConnectionAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_connection_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConnectionAliasOutput,
    crate::error::DeleteConnectionAliasError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_connection_alias_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_ip_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIpGroupOutput, crate::error::DeleteIpGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteIpGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteIpGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteIpGroupError {
            meta: generic,
            kind: crate::error::DeleteIpGroupErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::DeleteIpGroupError {
            meta: generic,
            kind: crate::error::DeleteIpGroupErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAssociatedException" => crate::error::DeleteIpGroupError {
            meta: generic,
            kind: crate::error::DeleteIpGroupErrorKind::ResourceAssociatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_associated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_associated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteIpGroupError {
            meta: generic,
            kind: crate::error::DeleteIpGroupErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteIpGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_ip_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIpGroupOutput, crate::error::DeleteIpGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_ip_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValuesException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_workspace_bundle_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteWorkspaceBundleOutput,
    crate::error::DeleteWorkspaceBundleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteWorkspaceBundleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteWorkspaceBundleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteWorkspaceBundleError {
            meta: generic,
            kind: crate::error::DeleteWorkspaceBundleErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::DeleteWorkspaceBundleError {
            meta: generic,
            kind: crate::error::DeleteWorkspaceBundleErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAssociatedException" => crate::error::DeleteWorkspaceBundleError {
            meta: generic,
            kind: crate::error::DeleteWorkspaceBundleErrorKind::ResourceAssociatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_associated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_associated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteWorkspaceBundleError {
            meta: generic,
            kind: crate::error::DeleteWorkspaceBundleErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteWorkspaceBundleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_workspace_bundle_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteWorkspaceBundleOutput,
    crate::error::DeleteWorkspaceBundleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_workspace_bundle_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_workspace_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteWorkspaceImageOutput,
    crate::error::DeleteWorkspaceImageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteWorkspaceImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteWorkspaceImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteWorkspaceImageError {
            meta: generic,
            kind: crate::error::DeleteWorkspaceImageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateException" => crate::error::DeleteWorkspaceImageError {
            meta: generic,
            kind: crate::error::DeleteWorkspaceImageErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAssociatedException" => crate::error::DeleteWorkspaceImageError {
            meta: generic,
            kind: crate::error::DeleteWorkspaceImageErrorKind::ResourceAssociatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_associated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_associated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteWorkspaceImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_workspace_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteWorkspaceImageOutput,
    crate::error::DeleteWorkspaceImageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_workspace_image_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_workspace_directory_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterWorkspaceDirectoryOutput,
    crate::error::DeregisterWorkspaceDirectoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterWorkspaceDirectoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeregisterWorkspaceDirectoryError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeregisterWorkspaceDirectoryError {
            meta: generic,
            kind: crate::error::DeregisterWorkspaceDirectoryErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterWorkspaceDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::DeregisterWorkspaceDirectoryError {
            meta: generic,
            kind:
                crate::error::DeregisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_values_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterWorkspaceDirectoryError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidResourceStateException" => crate::error::DeregisterWorkspaceDirectoryError {
            meta: generic,
            kind:
                crate::error::DeregisterWorkspaceDirectoryErrorKind::InvalidResourceStateException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_resource_state_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterWorkspaceDirectoryError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "OperationNotSupportedException" => crate::error::DeregisterWorkspaceDirectoryError {
            meta: generic,
            kind:
                crate::error::DeregisterWorkspaceDirectoryErrorKind::OperationNotSupportedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::operation_not_supported_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterWorkspaceDirectoryError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::DeregisterWorkspaceDirectoryError {
            meta: generic,
            kind: crate::error::DeregisterWorkspaceDirectoryErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterWorkspaceDirectoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeregisterWorkspaceDirectoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_workspace_directory_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterWorkspaceDirectoryOutput,
    crate::error::DeregisterWorkspaceDirectoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_workspace_directory_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAccountOutput, crate::error::DescribeAccountError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAccountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeAccountError {
            meta: generic,
            kind: crate::error::DescribeAccountErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAccountError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAccountOutput, crate::error::DescribeAccountError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_account(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_modifications_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountModificationsOutput,
    crate::error::DescribeAccountModificationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountModificationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAccountModificationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeAccountModificationsError {
            meta: generic,
            kind: crate::error::DescribeAccountModificationsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountModificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAccountModificationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_modifications_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountModificationsOutput,
    crate::error::DescribeAccountModificationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_modifications_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_account_modifications(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountModificationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_client_properties_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClientPropertiesOutput,
    crate::error::DescribeClientPropertiesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClientPropertiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeClientPropertiesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeClientPropertiesError {
            meta: generic,
            kind: crate::error::DescribeClientPropertiesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClientPropertiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::DescribeClientPropertiesError {
            meta: generic,
            kind: crate::error::DescribeClientPropertiesErrorKind::InvalidParameterValuesException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_values_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClientPropertiesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::DescribeClientPropertiesError {
            meta: generic,
            kind: crate::error::DescribeClientPropertiesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClientPropertiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeClientPropertiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_client_properties_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClientPropertiesOutput,
    crate::error::DescribeClientPropertiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_client_properties_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_client_properties(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeClientPropertiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_connection_aliases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConnectionAliasesOutput,
    crate::error::DescribeConnectionAliasesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeConnectionAliasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeConnectionAliasesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeConnectionAliasesError {
            meta: generic,
            kind: crate::error::DescribeConnectionAliasesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConnectionAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::DescribeConnectionAliasesError {
            meta: generic,
            kind: crate::error::DescribeConnectionAliasesErrorKind::InvalidParameterValuesException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_values_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConnectionAliasesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "OperationNotSupportedException" => crate::error::DescribeConnectionAliasesError {
            meta: generic,
            kind: crate::error::DescribeConnectionAliasesErrorKind::OperationNotSupportedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_not_supported_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConnectionAliasesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeConnectionAliasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_connection_aliases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConnectionAliasesOutput,
    crate::error::DescribeConnectionAliasesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_connection_aliases_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_connection_aliases(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeConnectionAliasesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_connection_alias_permissions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConnectionAliasPermissionsOutput,
    crate::error::DescribeConnectionAliasPermissionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeConnectionAliasPermissionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeConnectionAliasPermissionsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeConnectionAliasPermissionsError { meta: generic, kind: crate::error::DescribeConnectionAliasPermissionsErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConnectionAliasPermissionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValuesException" => crate::error::DescribeConnectionAliasPermissionsError { meta: generic, kind: crate::error::DescribeConnectionAliasPermissionsErrorKind::InvalidParameterValuesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConnectionAliasPermissionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotSupportedException" => crate::error::DescribeConnectionAliasPermissionsError { meta: generic, kind: crate::error::DescribeConnectionAliasPermissionsErrorKind::OperationNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConnectionAliasPermissionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::DescribeConnectionAliasPermissionsError { meta: generic, kind: crate::error::DescribeConnectionAliasPermissionsErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConnectionAliasPermissionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeConnectionAliasPermissionsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_connection_alias_permissions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConnectionAliasPermissionsOutput,
    crate::error::DescribeConnectionAliasPermissionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_connection_alias_permissions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_connection_alias_permissions(response.body().as_ref(), output).map_err(crate::error::DescribeConnectionAliasPermissionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_ip_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeIpGroupsOutput, crate::error::DescribeIpGroupsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeIpGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeIpGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeIpGroupsError {
            meta: generic,
            kind: crate::error::DescribeIpGroupsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::DescribeIpGroupsError {
            meta: generic,
            kind: crate::error::DescribeIpGroupsErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeIpGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_ip_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeIpGroupsOutput, crate::error::DescribeIpGroupsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_ip_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_ip_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeIpGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspace_bundles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspaceBundlesOutput,
    crate::error::DescribeWorkspaceBundlesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWorkspaceBundlesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeWorkspaceBundlesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValuesException" => crate::error::DescribeWorkspaceBundlesError {
            meta: generic,
            kind: crate::error::DescribeWorkspaceBundlesErrorKind::InvalidParameterValuesException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_values_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspaceBundlesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeWorkspaceBundlesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspace_bundles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspaceBundlesOutput,
    crate::error::DescribeWorkspaceBundlesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_workspace_bundles_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_workspace_bundles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeWorkspaceBundlesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspace_directories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspaceDirectoriesOutput,
    crate::error::DescribeWorkspaceDirectoriesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWorkspaceDirectoriesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeWorkspaceDirectoriesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValuesException" => crate::error::DescribeWorkspaceDirectoriesError {
            meta: generic,
            kind:
                crate::error::DescribeWorkspaceDirectoriesErrorKind::InvalidParameterValuesException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_values_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspaceDirectoriesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeWorkspaceDirectoriesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspace_directories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspaceDirectoriesOutput,
    crate::error::DescribeWorkspaceDirectoriesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_workspace_directories_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_workspace_directories(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeWorkspaceDirectoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspace_image_permissions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspaceImagePermissionsOutput,
    crate::error::DescribeWorkspaceImagePermissionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWorkspaceImagePermissionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeWorkspaceImagePermissionsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeWorkspaceImagePermissionsError { meta: generic, kind: crate::error::DescribeWorkspaceImagePermissionsErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspaceImagePermissionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValuesException" => crate::error::DescribeWorkspaceImagePermissionsError { meta: generic, kind: crate::error::DescribeWorkspaceImagePermissionsErrorKind::InvalidParameterValuesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspaceImagePermissionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::DescribeWorkspaceImagePermissionsError { meta: generic, kind: crate::error::DescribeWorkspaceImagePermissionsErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspaceImagePermissionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeWorkspaceImagePermissionsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspace_image_permissions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspaceImagePermissionsOutput,
    crate::error::DescribeWorkspaceImagePermissionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_workspace_image_permissions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_workspace_image_permissions(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspaceImagePermissionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspace_images_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspaceImagesOutput,
    crate::error::DescribeWorkspaceImagesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWorkspaceImagesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeWorkspaceImagesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeWorkspaceImagesError {
            meta: generic,
            kind: crate::error::DescribeWorkspaceImagesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspaceImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeWorkspaceImagesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspace_images_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspaceImagesOutput,
    crate::error::DescribeWorkspaceImagesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_workspace_images_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_workspace_images(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeWorkspaceImagesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspaces_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspacesOutput,
    crate::error::DescribeWorkspacesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWorkspacesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeWorkspacesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValuesException" => crate::error::DescribeWorkspacesError {
            meta: generic,
            kind: crate::error::DescribeWorkspacesErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspacesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::DescribeWorkspacesError {
            meta: generic,
            kind: crate::error::DescribeWorkspacesErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspacesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeWorkspacesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspaces_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspacesOutput,
    crate::error::DescribeWorkspacesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_workspaces_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_workspaces(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeWorkspacesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspaces_connection_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspacesConnectionStatusOutput,
    crate::error::DescribeWorkspacesConnectionStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWorkspacesConnectionStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeWorkspacesConnectionStatusError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValuesException" => crate::error::DescribeWorkspacesConnectionStatusError { meta: generic, kind: crate::error::DescribeWorkspacesConnectionStatusErrorKind::InvalidParameterValuesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspacesConnectionStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeWorkspacesConnectionStatusError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspaces_connection_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspacesConnectionStatusOutput,
    crate::error::DescribeWorkspacesConnectionStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_workspaces_connection_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_workspaces_connection_status(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspacesConnectionStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspace_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspaceSnapshotsOutput,
    crate::error::DescribeWorkspaceSnapshotsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWorkspaceSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeWorkspaceSnapshotsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeWorkspaceSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeWorkspaceSnapshotsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspaceSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::DescribeWorkspaceSnapshotsError {
            meta: generic,
            kind:
                crate::error::DescribeWorkspaceSnapshotsErrorKind::InvalidParameterValuesException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_values_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspaceSnapshotsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::DescribeWorkspaceSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeWorkspaceSnapshotsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeWorkspaceSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeWorkspaceSnapshotsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workspace_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeWorkspaceSnapshotsOutput,
    crate::error::DescribeWorkspaceSnapshotsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_workspace_snapshots_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_workspace_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeWorkspaceSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_connection_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateConnectionAliasOutput,
    crate::error::DisassociateConnectionAliasError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateConnectionAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateConnectionAliasError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisassociateConnectionAliasError {
            meta: generic,
            kind: crate::error::DisassociateConnectionAliasErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::DisassociateConnectionAliasError {
            meta: generic,
            kind:
                crate::error::DisassociateConnectionAliasErrorKind::InvalidParameterValuesException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_values_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConnectionAliasError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidResourceStateException" => crate::error::DisassociateConnectionAliasError {
            meta: generic,
            kind: crate::error::DisassociateConnectionAliasErrorKind::InvalidResourceStateException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_resource_state_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConnectionAliasError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "OperationNotSupportedException" => crate::error::DisassociateConnectionAliasError {
            meta: generic,
            kind:
                crate::error::DisassociateConnectionAliasErrorKind::OperationNotSupportedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::operation_not_supported_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConnectionAliasError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::DisassociateConnectionAliasError {
            meta: generic,
            kind: crate::error::DisassociateConnectionAliasErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConnectionAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateConnectionAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_connection_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateConnectionAliasOutput,
    crate::error::DisassociateConnectionAliasError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_connection_alias_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_ip_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateIpGroupsOutput,
    crate::error::DisassociateIpGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateIpGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisassociateIpGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisassociateIpGroupsError {
            meta: generic,
            kind: crate::error::DisassociateIpGroupsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::DisassociateIpGroupsError {
            meta: generic,
            kind: crate::error::DisassociateIpGroupsErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateException" => crate::error::DisassociateIpGroupsError {
            meta: generic,
            kind: crate::error::DisassociateIpGroupsErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DisassociateIpGroupsError {
            meta: generic,
            kind: crate::error::DisassociateIpGroupsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateIpGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateIpGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_ip_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateIpGroupsOutput,
    crate::error::DisassociateIpGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_ip_groups_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_workspace_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ImportWorkspaceImageOutput,
    crate::error::ImportWorkspaceImageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ImportWorkspaceImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ImportWorkspaceImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ImportWorkspaceImageError {
            meta: generic,
            kind: crate::error::ImportWorkspaceImageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::ImportWorkspaceImageError {
            meta: generic,
            kind: crate::error::ImportWorkspaceImageErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::ImportWorkspaceImageError {
            meta: generic,
            kind: crate::error::ImportWorkspaceImageErrorKind::OperationNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsException" => crate::error::ImportWorkspaceImageError {
            meta: generic,
            kind: crate::error::ImportWorkspaceImageErrorKind::ResourceAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::ImportWorkspaceImageError {
            meta: generic,
            kind: crate::error::ImportWorkspaceImageErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ImportWorkspaceImageError {
            meta: generic,
            kind: crate::error::ImportWorkspaceImageErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportWorkspaceImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ImportWorkspaceImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_workspace_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ImportWorkspaceImageOutput,
    crate::error::ImportWorkspaceImageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::import_workspace_image_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_import_workspace_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ImportWorkspaceImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_available_management_cidr_ranges_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAvailableManagementCidrRangesOutput,
    crate::error::ListAvailableManagementCidrRangesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAvailableManagementCidrRangesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListAvailableManagementCidrRangesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListAvailableManagementCidrRangesError { meta: generic, kind: crate::error::ListAvailableManagementCidrRangesErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAvailableManagementCidrRangesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValuesException" => crate::error::ListAvailableManagementCidrRangesError { meta: generic, kind: crate::error::ListAvailableManagementCidrRangesErrorKind::InvalidParameterValuesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAvailableManagementCidrRangesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListAvailableManagementCidrRangesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_available_management_cidr_ranges_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAvailableManagementCidrRangesOutput,
    crate::error::ListAvailableManagementCidrRangesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_available_management_cidr_ranges_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_available_management_cidr_ranges(response.body().as_ref(), output).map_err(crate::error::ListAvailableManagementCidrRangesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_migrate_workspace_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::MigrateWorkspaceOutput, crate::error::MigrateWorkspaceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::MigrateWorkspaceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::MigrateWorkspaceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::MigrateWorkspaceError {
            meta: generic,
            kind: crate::error::MigrateWorkspaceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MigrateWorkspaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::MigrateWorkspaceError {
            meta: generic,
            kind: crate::error::MigrateWorkspaceErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MigrateWorkspaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationInProgressException" => crate::error::MigrateWorkspaceError {
            meta: generic,
            kind: crate::error::MigrateWorkspaceErrorKind::OperationInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MigrateWorkspaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::MigrateWorkspaceError {
            meta: generic,
            kind: crate::error::MigrateWorkspaceErrorKind::OperationNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MigrateWorkspaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::MigrateWorkspaceError {
            meta: generic,
            kind: crate::error::MigrateWorkspaceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MigrateWorkspaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::MigrateWorkspaceError {
            meta: generic,
            kind: crate::error::MigrateWorkspaceErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::MigrateWorkspaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::MigrateWorkspaceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_migrate_workspace_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::MigrateWorkspaceOutput, crate::error::MigrateWorkspaceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::migrate_workspace_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_migrate_workspace(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::MigrateWorkspaceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_account_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyAccountOutput, crate::error::ModifyAccountError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyAccountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyAccountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ModifyAccountError {
            meta: generic,
            kind: crate::error::ModifyAccountErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::ModifyAccountError {
            meta: generic,
            kind: crate::error::ModifyAccountErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateException" => crate::error::ModifyAccountError {
            meta: generic,
            kind: crate::error::ModifyAccountErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ModifyAccountError {
            meta: generic,
            kind: crate::error::ModifyAccountErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::ModifyAccountError {
            meta: generic,
            kind: crate::error::ModifyAccountErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyAccountError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_account_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyAccountOutput, crate::error::ModifyAccountError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_account_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_client_properties_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClientPropertiesOutput,
    crate::error::ModifyClientPropertiesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyClientPropertiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyClientPropertiesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ModifyClientPropertiesError {
            meta: generic,
            kind: crate::error::ModifyClientPropertiesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyClientPropertiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::ModifyClientPropertiesError {
            meta: generic,
            kind: crate::error::ModifyClientPropertiesErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyClientPropertiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ModifyClientPropertiesError {
            meta: generic,
            kind: crate::error::ModifyClientPropertiesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyClientPropertiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyClientPropertiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_client_properties_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClientPropertiesOutput,
    crate::error::ModifyClientPropertiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_client_properties_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_selfservice_permissions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifySelfservicePermissionsOutput,
    crate::error::ModifySelfservicePermissionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifySelfservicePermissionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifySelfservicePermissionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ModifySelfservicePermissionsError {
            meta: generic,
            kind: crate::error::ModifySelfservicePermissionsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifySelfservicePermissionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::ModifySelfservicePermissionsError {
            meta: generic,
            kind:
                crate::error::ModifySelfservicePermissionsErrorKind::InvalidParameterValuesException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_values_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifySelfservicePermissionsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::ModifySelfservicePermissionsError {
            meta: generic,
            kind: crate::error::ModifySelfservicePermissionsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifySelfservicePermissionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifySelfservicePermissionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_selfservice_permissions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifySelfservicePermissionsOutput,
    crate::error::ModifySelfservicePermissionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_selfservice_permissions_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_workspace_access_properties_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyWorkspaceAccessPropertiesOutput,
    crate::error::ModifyWorkspaceAccessPropertiesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyWorkspaceAccessPropertiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyWorkspaceAccessPropertiesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ModifyWorkspaceAccessPropertiesError {
            meta: generic,
            kind: crate::error::ModifyWorkspaceAccessPropertiesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspaceAccessPropertiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ModifyWorkspaceAccessPropertiesError {
            meta: generic,
            kind: crate::error::ModifyWorkspaceAccessPropertiesErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspaceAccessPropertiesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ModifyWorkspaceAccessPropertiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_workspace_access_properties_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyWorkspaceAccessPropertiesOutput,
    crate::error::ModifyWorkspaceAccessPropertiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::modify_workspace_access_properties_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_workspace_creation_properties_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyWorkspaceCreationPropertiesOutput,
    crate::error::ModifyWorkspaceCreationPropertiesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyWorkspaceCreationPropertiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyWorkspaceCreationPropertiesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ModifyWorkspaceCreationPropertiesError { meta: generic, kind: crate::error::ModifyWorkspaceCreationPropertiesErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspaceCreationPropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValuesException" => crate::error::ModifyWorkspaceCreationPropertiesError { meta: generic, kind: crate::error::ModifyWorkspaceCreationPropertiesErrorKind::InvalidParameterValuesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspaceCreationPropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotSupportedException" => crate::error::ModifyWorkspaceCreationPropertiesError { meta: generic, kind: crate::error::ModifyWorkspaceCreationPropertiesErrorKind::OperationNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspaceCreationPropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ModifyWorkspaceCreationPropertiesError { meta: generic, kind: crate::error::ModifyWorkspaceCreationPropertiesErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspaceCreationPropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyWorkspaceCreationPropertiesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_workspace_creation_properties_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyWorkspaceCreationPropertiesOutput,
    crate::error::ModifyWorkspaceCreationPropertiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::modify_workspace_creation_properties_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_workspace_properties_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyWorkspacePropertiesOutput,
    crate::error::ModifyWorkspacePropertiesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyWorkspacePropertiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyWorkspacePropertiesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ModifyWorkspacePropertiesError { meta: generic, kind: crate::error::ModifyWorkspacePropertiesErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspacePropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValuesException" => crate::error::ModifyWorkspacePropertiesError { meta: generic, kind: crate::error::ModifyWorkspacePropertiesErrorKind::InvalidParameterValuesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspacePropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidResourceStateException" => crate::error::ModifyWorkspacePropertiesError { meta: generic, kind: crate::error::ModifyWorkspacePropertiesErrorKind::InvalidResourceStateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspacePropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationInProgressException" => crate::error::ModifyWorkspacePropertiesError { meta: generic, kind: crate::error::ModifyWorkspacePropertiesErrorKind::OperationInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspacePropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ModifyWorkspacePropertiesError { meta: generic, kind: crate::error::ModifyWorkspacePropertiesErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspacePropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceUnavailableException" => crate::error::ModifyWorkspacePropertiesError { meta: generic, kind: crate::error::ModifyWorkspacePropertiesErrorKind::ResourceUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspacePropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedWorkspaceConfigurationException" => crate::error::ModifyWorkspacePropertiesError { meta: generic, kind: crate::error::ModifyWorkspacePropertiesErrorKind::UnsupportedWorkspaceConfigurationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_workspace_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_workspace_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspacePropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyWorkspacePropertiesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_workspace_properties_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyWorkspacePropertiesOutput,
    crate::error::ModifyWorkspacePropertiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_workspace_properties_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_workspace_state_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyWorkspaceStateOutput,
    crate::error::ModifyWorkspaceStateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyWorkspaceStateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyWorkspaceStateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValuesException" => crate::error::ModifyWorkspaceStateError {
            meta: generic,
            kind: crate::error::ModifyWorkspaceStateErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspaceStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateException" => crate::error::ModifyWorkspaceStateError {
            meta: generic,
            kind: crate::error::ModifyWorkspaceStateErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspaceStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ModifyWorkspaceStateError {
            meta: generic,
            kind: crate::error::ModifyWorkspaceStateErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyWorkspaceStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyWorkspaceStateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_workspace_state_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyWorkspaceStateOutput,
    crate::error::ModifyWorkspaceStateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_workspace_state_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_workspaces_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebootWorkspacesOutput, crate::error::RebootWorkspacesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebootWorkspacesError::unhandled)?;
    Err(crate::error::RebootWorkspacesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_workspaces_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebootWorkspacesOutput, crate::error::RebootWorkspacesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reboot_workspaces_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_reboot_workspaces(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RebootWorkspacesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rebuild_workspaces_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebuildWorkspacesOutput, crate::error::RebuildWorkspacesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebuildWorkspacesError::unhandled)?;
    Err(crate::error::RebuildWorkspacesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rebuild_workspaces_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebuildWorkspacesOutput, crate::error::RebuildWorkspacesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::rebuild_workspaces_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_rebuild_workspaces(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RebuildWorkspacesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_workspace_directory_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterWorkspaceDirectoryOutput,
    crate::error::RegisterWorkspaceDirectoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterWorkspaceDirectoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RegisterWorkspaceDirectoryError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RegisterWorkspaceDirectoryError { meta: generic, kind: crate::error::RegisterWorkspaceDirectoryErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterWorkspaceDirectoryError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValuesException" => crate::error::RegisterWorkspaceDirectoryError { meta: generic, kind: crate::error::RegisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterWorkspaceDirectoryError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidResourceStateException" => crate::error::RegisterWorkspaceDirectoryError { meta: generic, kind: crate::error::RegisterWorkspaceDirectoryErrorKind::InvalidResourceStateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterWorkspaceDirectoryError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotSupportedException" => crate::error::RegisterWorkspaceDirectoryError { meta: generic, kind: crate::error::RegisterWorkspaceDirectoryErrorKind::OperationNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterWorkspaceDirectoryError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceLimitExceededException" => crate::error::RegisterWorkspaceDirectoryError { meta: generic, kind: crate::error::RegisterWorkspaceDirectoryErrorKind::ResourceLimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterWorkspaceDirectoryError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::RegisterWorkspaceDirectoryError { meta: generic, kind: crate::error::RegisterWorkspaceDirectoryErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterWorkspaceDirectoryError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedNetworkConfigurationException" => crate::error::RegisterWorkspaceDirectoryError { meta: generic, kind: crate::error::RegisterWorkspaceDirectoryErrorKind::UnsupportedNetworkConfigurationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_network_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_network_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterWorkspaceDirectoryError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WorkspacesDefaultRoleNotFoundException" => crate::error::RegisterWorkspaceDirectoryError { meta: generic, kind: crate::error::RegisterWorkspaceDirectoryErrorKind::WorkspacesDefaultRoleNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::workspaces_default_role_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_workspaces_default_role_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterWorkspaceDirectoryError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RegisterWorkspaceDirectoryError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_workspace_directory_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterWorkspaceDirectoryOutput,
    crate::error::RegisterWorkspaceDirectoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_workspace_directory_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_workspace_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RestoreWorkspaceOutput, crate::error::RestoreWorkspaceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreWorkspaceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RestoreWorkspaceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RestoreWorkspaceError {
            meta: generic,
            kind: crate::error::RestoreWorkspaceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreWorkspaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::RestoreWorkspaceError {
            meta: generic,
            kind: crate::error::RestoreWorkspaceErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreWorkspaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RestoreWorkspaceError {
            meta: generic,
            kind: crate::error::RestoreWorkspaceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreWorkspaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RestoreWorkspaceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_workspace_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RestoreWorkspaceOutput, crate::error::RestoreWorkspaceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_workspace_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_ip_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RevokeIpRulesOutput, crate::error::RevokeIpRulesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RevokeIpRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RevokeIpRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RevokeIpRulesError {
            meta: generic,
            kind: crate::error::RevokeIpRulesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeIpRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::RevokeIpRulesError {
            meta: generic,
            kind: crate::error::RevokeIpRulesErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeIpRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateException" => crate::error::RevokeIpRulesError {
            meta: generic,
            kind: crate::error::RevokeIpRulesErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeIpRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RevokeIpRulesError {
            meta: generic,
            kind: crate::error::RevokeIpRulesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeIpRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RevokeIpRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_ip_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RevokeIpRulesOutput, crate::error::RevokeIpRulesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::revoke_ip_rules_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_workspaces_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartWorkspacesOutput, crate::error::StartWorkspacesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartWorkspacesError::unhandled)?;
    Err(crate::error::StartWorkspacesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_workspaces_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartWorkspacesOutput, crate::error::StartWorkspacesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_workspaces_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_workspaces(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartWorkspacesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_workspaces_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopWorkspacesOutput, crate::error::StopWorkspacesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopWorkspacesError::unhandled)?;
    Err(crate::error::StopWorkspacesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_workspaces_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopWorkspacesOutput, crate::error::StopWorkspacesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_workspaces_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_workspaces(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopWorkspacesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_workspaces_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TerminateWorkspacesOutput,
    crate::error::TerminateWorkspacesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TerminateWorkspacesError::unhandled)?;
    Err(crate::error::TerminateWorkspacesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_workspaces_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TerminateWorkspacesOutput,
    crate::error::TerminateWorkspacesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::terminate_workspaces_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_terminate_workspaces(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TerminateWorkspacesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_connection_alias_permission_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConnectionAliasPermissionOutput,
    crate::error::UpdateConnectionAliasPermissionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateConnectionAliasPermissionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateConnectionAliasPermissionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateConnectionAliasPermissionError { meta: generic, kind: crate::error::UpdateConnectionAliasPermissionErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConnectionAliasPermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValuesException" => crate::error::UpdateConnectionAliasPermissionError { meta: generic, kind: crate::error::UpdateConnectionAliasPermissionErrorKind::InvalidParameterValuesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConnectionAliasPermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidResourceStateException" => crate::error::UpdateConnectionAliasPermissionError { meta: generic, kind: crate::error::UpdateConnectionAliasPermissionErrorKind::InvalidResourceStateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConnectionAliasPermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotSupportedException" => crate::error::UpdateConnectionAliasPermissionError { meta: generic, kind: crate::error::UpdateConnectionAliasPermissionErrorKind::OperationNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConnectionAliasPermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceAssociatedException" => crate::error::UpdateConnectionAliasPermissionError { meta: generic, kind: crate::error::UpdateConnectionAliasPermissionErrorKind::ResourceAssociatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_associated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_associated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConnectionAliasPermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceLimitExceededException" => crate::error::UpdateConnectionAliasPermissionError { meta: generic, kind: crate::error::UpdateConnectionAliasPermissionErrorKind::ResourceLimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConnectionAliasPermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::UpdateConnectionAliasPermissionError { meta: generic, kind: crate::error::UpdateConnectionAliasPermissionErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConnectionAliasPermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateConnectionAliasPermissionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_connection_alias_permission_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConnectionAliasPermissionOutput,
    crate::error::UpdateConnectionAliasPermissionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_connection_alias_permission_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_rules_of_ip_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRulesOfIpGroupOutput,
    crate::error::UpdateRulesOfIpGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRulesOfIpGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRulesOfIpGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateRulesOfIpGroupError {
            meta: generic,
            kind: crate::error::UpdateRulesOfIpGroupErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRulesOfIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::UpdateRulesOfIpGroupError {
            meta: generic,
            kind: crate::error::UpdateRulesOfIpGroupErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRulesOfIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateException" => crate::error::UpdateRulesOfIpGroupError {
            meta: generic,
            kind: crate::error::UpdateRulesOfIpGroupErrorKind::InvalidResourceStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_resource_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRulesOfIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::UpdateRulesOfIpGroupError {
            meta: generic,
            kind: crate::error::UpdateRulesOfIpGroupErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRulesOfIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateRulesOfIpGroupError {
            meta: generic,
            kind: crate::error::UpdateRulesOfIpGroupErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRulesOfIpGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRulesOfIpGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_rules_of_ip_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRulesOfIpGroupOutput,
    crate::error::UpdateRulesOfIpGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_rules_of_ip_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_workspace_bundle_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateWorkspaceBundleOutput,
    crate::error::UpdateWorkspaceBundleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateWorkspaceBundleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateWorkspaceBundleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateWorkspaceBundleError {
            meta: generic,
            kind: crate::error::UpdateWorkspaceBundleErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValuesException" => crate::error::UpdateWorkspaceBundleError {
            meta: generic,
            kind: crate::error::UpdateWorkspaceBundleErrorKind::InvalidParameterValuesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateWorkspaceBundleError {
            meta: generic,
            kind: crate::error::UpdateWorkspaceBundleErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::UpdateWorkspaceBundleError {
            meta: generic,
            kind: crate::error::UpdateWorkspaceBundleErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWorkspaceBundleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateWorkspaceBundleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_workspace_bundle_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateWorkspaceBundleOutput,
    crate::error::UpdateWorkspaceBundleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_workspace_bundle_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_workspace_image_permission_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateWorkspaceImagePermissionOutput,
    crate::error::UpdateWorkspaceImagePermissionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateWorkspaceImagePermissionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateWorkspaceImagePermissionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateWorkspaceImagePermissionError { meta: generic, kind: crate::error::UpdateWorkspaceImagePermissionErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWorkspaceImagePermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValuesException" => crate::error::UpdateWorkspaceImagePermissionError { meta: generic, kind: crate::error::UpdateWorkspaceImagePermissionErrorKind::InvalidParameterValuesException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_values_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_values_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWorkspaceImagePermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotSupportedException" => crate::error::UpdateWorkspaceImagePermissionError { meta: generic, kind: crate::error::UpdateWorkspaceImagePermissionErrorKind::OperationNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWorkspaceImagePermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::UpdateWorkspaceImagePermissionError { meta: generic, kind: crate::error::UpdateWorkspaceImagePermissionErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWorkspaceImagePermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceUnavailableException" => crate::error::UpdateWorkspaceImagePermissionError { meta: generic, kind: crate::error::UpdateWorkspaceImagePermissionErrorKind::ResourceUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWorkspaceImagePermissionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateWorkspaceImagePermissionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_workspace_image_permission_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateWorkspaceImagePermissionOutput,
    crate::error::UpdateWorkspaceImagePermissionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_workspace_image_permission_output::Builder::default();
        let _ = response;
        output.build()
    })
}
