// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>The properties of this WorkSpace are currently being modified. Try again in a moment.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The resource is associated with a directory.</p>
    ResourceAssociatedException(crate::error::ResourceAssociatedException),
    /// <p>The resource could not be created.</p>
    ResourceCreationFailedException(crate::error::ResourceCreationFailedException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The configuration of this network is not supported for this operation, or your network configuration conflicts with the Amazon WorkSpaces management network IP range. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a VPC for Amazon WorkSpaces</a>.</p>
    UnsupportedNetworkConfigurationException(
        crate::error::UnsupportedNetworkConfigurationException,
    ),
    /// <p>The configuration of this WorkSpace is not supported for this operation. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required Configuration and Service Components for WorkSpaces </a>.</p>
    UnsupportedWorkspaceConfigurationException(
        crate::error::UnsupportedWorkspaceConfigurationException,
    ),
    /// <p>The workspaces_DefaultRole role could not be found. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">Creating the workspaces_DefaultRole Role</a>.</p>
    WorkspacesDefaultRoleNotFoundException(crate::error::WorkspacesDefaultRoleNotFoundException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::InvalidParameterValuesException(inner) => inner.fmt(f),
            Error::InvalidResourceStateException(inner) => inner.fmt(f),
            Error::OperationInProgressException(inner) => inner.fmt(f),
            Error::OperationNotSupportedException(inner) => inner.fmt(f),
            Error::ResourceAlreadyExistsException(inner) => inner.fmt(f),
            Error::ResourceAssociatedException(inner) => inner.fmt(f),
            Error::ResourceCreationFailedException(inner) => inner.fmt(f),
            Error::ResourceLimitExceededException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ResourceUnavailableException(inner) => inner.fmt(f),
            Error::UnsupportedNetworkConfigurationException(inner) => inner.fmt(f),
            Error::UnsupportedWorkspaceConfigurationException(inner) => inner.fmt(f),
            Error::WorkspacesDefaultRoleNotFoundException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateConnectionAliasError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateConnectionAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateConnectionAliasErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::AssociateConnectionAliasErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::AssociateConnectionAliasErrorKind::InvalidResourceStateException(inner) => Error::InvalidResourceStateException(inner),
                crate::error::AssociateConnectionAliasErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::AssociateConnectionAliasErrorKind::ResourceAssociatedException(inner) => Error::ResourceAssociatedException(inner),
                crate::error::AssociateConnectionAliasErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::AssociateConnectionAliasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateIpGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateIpGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateIpGroupsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AssociateIpGroupsErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::AssociateIpGroupsErrorKind::InvalidResourceStateException(inner) => {
                    Error::InvalidResourceStateException(inner)
                }
                crate::error::AssociateIpGroupsErrorKind::OperationNotSupportedException(inner) => {
                    Error::OperationNotSupportedException(inner)
                }
                crate::error::AssociateIpGroupsErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::AssociateIpGroupsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::AssociateIpGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AuthorizeIpRulesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AuthorizeIpRulesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AuthorizeIpRulesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AuthorizeIpRulesErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::AuthorizeIpRulesErrorKind::InvalidResourceStateException(inner) => {
                    Error::InvalidResourceStateException(inner)
                }
                crate::error::AuthorizeIpRulesErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::AuthorizeIpRulesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::AuthorizeIpRulesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyWorkspaceImageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CopyWorkspaceImageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CopyWorkspaceImageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CopyWorkspaceImageErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::CopyWorkspaceImageErrorKind::OperationNotSupportedException(
                    inner,
                ) => Error::OperationNotSupportedException(inner),
                crate::error::CopyWorkspaceImageErrorKind::ResourceAlreadyExistsException(
                    inner,
                ) => Error::ResourceAlreadyExistsException(inner),
                crate::error::CopyWorkspaceImageErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::CopyWorkspaceImageErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CopyWorkspaceImageErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::CopyWorkspaceImageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateConnectionAliasError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateConnectionAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateConnectionAliasErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateConnectionAliasErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::CreateConnectionAliasErrorKind::InvalidResourceStateException(
                    inner,
                ) => Error::InvalidResourceStateException(inner),
                crate::error::CreateConnectionAliasErrorKind::OperationNotSupportedException(
                    inner,
                ) => Error::OperationNotSupportedException(inner),
                crate::error::CreateConnectionAliasErrorKind::ResourceAlreadyExistsException(
                    inner,
                ) => Error::ResourceAlreadyExistsException(inner),
                crate::error::CreateConnectionAliasErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateConnectionAliasErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateIpGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateIpGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateIpGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateIpGroupErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::CreateIpGroupErrorKind::ResourceAlreadyExistsException(inner) => {
                    Error::ResourceAlreadyExistsException(inner)
                }
                crate::error::CreateIpGroupErrorKind::ResourceCreationFailedException(inner) => {
                    Error::ResourceCreationFailedException(inner)
                }
                crate::error::CreateIpGroupErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::CreateIpGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTagsErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::CreateTagsErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::CreateTagsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateUpdatedWorkspaceImageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateUpdatedWorkspaceImageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateUpdatedWorkspaceImageErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateUpdatedWorkspaceImageErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::CreateUpdatedWorkspaceImageErrorKind::InvalidResourceStateException(inner) => Error::InvalidResourceStateException(inner),
                crate::error::CreateUpdatedWorkspaceImageErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::CreateUpdatedWorkspaceImageErrorKind::ResourceAlreadyExistsException(inner) => Error::ResourceAlreadyExistsException(inner),
                crate::error::CreateUpdatedWorkspaceImageErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateUpdatedWorkspaceImageErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::CreateUpdatedWorkspaceImageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateWorkspaceBundleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateWorkspaceBundleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateWorkspaceBundleErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateWorkspaceBundleErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::CreateWorkspaceBundleErrorKind::ResourceAlreadyExistsException(
                    inner,
                ) => Error::ResourceAlreadyExistsException(inner),
                crate::error::CreateWorkspaceBundleErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateWorkspaceBundleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateWorkspaceBundleErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::CreateWorkspaceBundleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateWorkspacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateWorkspacesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateWorkspacesErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::CreateWorkspacesErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::CreateWorkspacesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteConnectionAliasError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteConnectionAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteConnectionAliasErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteConnectionAliasErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::DeleteConnectionAliasErrorKind::InvalidResourceStateException(
                    inner,
                ) => Error::InvalidResourceStateException(inner),
                crate::error::DeleteConnectionAliasErrorKind::OperationNotSupportedException(
                    inner,
                ) => Error::OperationNotSupportedException(inner),
                crate::error::DeleteConnectionAliasErrorKind::ResourceAssociatedException(
                    inner,
                ) => Error::ResourceAssociatedException(inner),
                crate::error::DeleteConnectionAliasErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteConnectionAliasErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteIpGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteIpGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteIpGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteIpGroupErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::DeleteIpGroupErrorKind::ResourceAssociatedException(inner) => {
                    Error::ResourceAssociatedException(inner)
                }
                crate::error::DeleteIpGroupErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteIpGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTagsErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::DeleteTagsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceBundleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceBundleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteWorkspaceBundleErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteWorkspaceBundleErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::DeleteWorkspaceBundleErrorKind::ResourceAssociatedException(
                    inner,
                ) => Error::ResourceAssociatedException(inner),
                crate::error::DeleteWorkspaceBundleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteWorkspaceBundleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceImageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceImageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteWorkspaceImageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteWorkspaceImageErrorKind::InvalidResourceStateException(
                    inner,
                ) => Error::InvalidResourceStateException(inner),
                crate::error::DeleteWorkspaceImageErrorKind::ResourceAssociatedException(inner) => {
                    Error::ResourceAssociatedException(inner)
                }
                crate::error::DeleteWorkspaceImageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterWorkspaceDirectoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterWorkspaceDirectoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeregisterWorkspaceDirectoryErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeregisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::DeregisterWorkspaceDirectoryErrorKind::InvalidResourceStateException(inner) => Error::InvalidResourceStateException(inner),
                crate::error::DeregisterWorkspaceDirectoryErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::DeregisterWorkspaceDirectoryErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DeregisterWorkspaceDirectoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccountErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeAccountErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountModificationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountModificationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccountModificationsErrorKind::AccessDeniedException(
                    inner,
                ) => Error::AccessDeniedException(inner),
                crate::error::DescribeAccountModificationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClientPropertiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClientPropertiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeClientPropertiesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeClientPropertiesErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::DescribeClientPropertiesErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeClientPropertiesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeConnectionAliasesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeConnectionAliasesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConnectionAliasesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeConnectionAliasesErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::DescribeConnectionAliasesErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::DescribeConnectionAliasesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeConnectionAliasPermissionsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeConnectionAliasPermissionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConnectionAliasPermissionsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeConnectionAliasPermissionsErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::DescribeConnectionAliasPermissionsErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::DescribeConnectionAliasPermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeConnectionAliasPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeIpGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeIpGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeIpGroupsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeIpGroupsErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::DescribeIpGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTagsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceBundlesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceBundlesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeWorkspaceBundlesErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::DescribeWorkspaceBundlesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceDirectoriesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceDirectoriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeWorkspaceDirectoriesErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::DescribeWorkspaceDirectoriesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceImagePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeWorkspaceImagePermissionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeWorkspaceImagePermissionsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeWorkspaceImagePermissionsErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::DescribeWorkspaceImagePermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeWorkspaceImagePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceImagesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceImagesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeWorkspaceImagesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeWorkspaceImagesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeWorkspacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeWorkspacesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeWorkspacesErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::DescribeWorkspacesErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::DescribeWorkspacesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeWorkspacesConnectionStatusError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeWorkspacesConnectionStatusError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeWorkspacesConnectionStatusErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::DescribeWorkspacesConnectionStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceSnapshotsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeWorkspaceSnapshotsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeWorkspaceSnapshotsErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::DescribeWorkspaceSnapshotsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeWorkspaceSnapshotsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateConnectionAliasError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateConnectionAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateConnectionAliasErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DisassociateConnectionAliasErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::DisassociateConnectionAliasErrorKind::InvalidResourceStateException(inner) => Error::InvalidResourceStateException(inner),
                crate::error::DisassociateConnectionAliasErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::DisassociateConnectionAliasErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DisassociateConnectionAliasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateIpGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateIpGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisassociateIpGroupsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DisassociateIpGroupsErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::DisassociateIpGroupsErrorKind::InvalidResourceStateException(
                    inner,
                ) => Error::InvalidResourceStateException(inner),
                crate::error::DisassociateIpGroupsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DisassociateIpGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportWorkspaceImageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ImportWorkspaceImageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportWorkspaceImageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ImportWorkspaceImageErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::ImportWorkspaceImageErrorKind::OperationNotSupportedException(
                    inner,
                ) => Error::OperationNotSupportedException(inner),
                crate::error::ImportWorkspaceImageErrorKind::ResourceAlreadyExistsException(
                    inner,
                ) => Error::ResourceAlreadyExistsException(inner),
                crate::error::ImportWorkspaceImageErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::ImportWorkspaceImageErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ImportWorkspaceImageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListAvailableManagementCidrRangesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListAvailableManagementCidrRangesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListAvailableManagementCidrRangesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListAvailableManagementCidrRangesErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::ListAvailableManagementCidrRangesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::MigrateWorkspaceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::MigrateWorkspaceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::MigrateWorkspaceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::MigrateWorkspaceErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::MigrateWorkspaceErrorKind::OperationInProgressException(inner) => {
                    Error::OperationInProgressException(inner)
                }
                crate::error::MigrateWorkspaceErrorKind::OperationNotSupportedException(inner) => {
                    Error::OperationNotSupportedException(inner)
                }
                crate::error::MigrateWorkspaceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::MigrateWorkspaceErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::MigrateWorkspaceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyAccountError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyAccountError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyAccountErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ModifyAccountErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::ModifyAccountErrorKind::InvalidResourceStateException(inner) => {
                    Error::InvalidResourceStateException(inner)
                }
                crate::error::ModifyAccountErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ModifyAccountErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::ModifyAccountErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyClientPropertiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyClientPropertiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyClientPropertiesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ModifyClientPropertiesErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::ModifyClientPropertiesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ModifyClientPropertiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifySelfservicePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifySelfservicePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifySelfservicePermissionsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ModifySelfservicePermissionsErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::ModifySelfservicePermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::ModifySelfservicePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ModifyWorkspaceAccessPropertiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ModifyWorkspaceAccessPropertiesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyWorkspaceAccessPropertiesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ModifyWorkspaceAccessPropertiesErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::ModifyWorkspaceAccessPropertiesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ModifyWorkspaceCreationPropertiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ModifyWorkspaceCreationPropertiesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyWorkspaceCreationPropertiesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ModifyWorkspaceCreationPropertiesErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::ModifyWorkspaceCreationPropertiesErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::ModifyWorkspaceCreationPropertiesErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::ModifyWorkspaceCreationPropertiesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyWorkspacePropertiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyWorkspacePropertiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyWorkspacePropertiesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ModifyWorkspacePropertiesErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::ModifyWorkspacePropertiesErrorKind::InvalidResourceStateException(inner) => Error::InvalidResourceStateException(inner),
                crate::error::ModifyWorkspacePropertiesErrorKind::OperationInProgressException(inner) => Error::OperationInProgressException(inner),
                crate::error::ModifyWorkspacePropertiesErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::ModifyWorkspacePropertiesErrorKind::ResourceUnavailableException(inner) => Error::ResourceUnavailableException(inner),
                crate::error::ModifyWorkspacePropertiesErrorKind::UnsupportedWorkspaceConfigurationException(inner) => Error::UnsupportedWorkspaceConfigurationException(inner),
                crate::error::ModifyWorkspacePropertiesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyWorkspaceStateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyWorkspaceStateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyWorkspaceStateErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::ModifyWorkspaceStateErrorKind::InvalidResourceStateException(
                    inner,
                ) => Error::InvalidResourceStateException(inner),
                crate::error::ModifyWorkspaceStateErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ModifyWorkspaceStateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebootWorkspacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RebootWorkspacesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RebootWorkspacesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebuildWorkspacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RebuildWorkspacesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RebuildWorkspacesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterWorkspaceDirectoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterWorkspaceDirectoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterWorkspaceDirectoryErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::RegisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::RegisterWorkspaceDirectoryErrorKind::InvalidResourceStateException(inner) => Error::InvalidResourceStateException(inner),
                crate::error::RegisterWorkspaceDirectoryErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::RegisterWorkspaceDirectoryErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::RegisterWorkspaceDirectoryErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::RegisterWorkspaceDirectoryErrorKind::UnsupportedNetworkConfigurationException(inner) => Error::UnsupportedNetworkConfigurationException(inner),
                crate::error::RegisterWorkspaceDirectoryErrorKind::WorkspacesDefaultRoleNotFoundException(inner) => Error::WorkspacesDefaultRoleNotFoundException(inner),
                crate::error::RegisterWorkspaceDirectoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreWorkspaceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreWorkspaceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RestoreWorkspaceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::RestoreWorkspaceErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::RestoreWorkspaceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::RestoreWorkspaceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RevokeIpRulesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RevokeIpRulesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RevokeIpRulesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::RevokeIpRulesErrorKind::InvalidParameterValuesException(inner) => {
                    Error::InvalidParameterValuesException(inner)
                }
                crate::error::RevokeIpRulesErrorKind::InvalidResourceStateException(inner) => {
                    Error::InvalidResourceStateException(inner)
                }
                crate::error::RevokeIpRulesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::RevokeIpRulesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartWorkspacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartWorkspacesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartWorkspacesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopWorkspacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopWorkspacesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopWorkspacesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TerminateWorkspacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::TerminateWorkspacesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TerminateWorkspacesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateConnectionAliasPermissionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateConnectionAliasPermissionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateConnectionAliasPermissionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateConnectionAliasPermissionErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::UpdateConnectionAliasPermissionErrorKind::InvalidResourceStateException(inner) => Error::InvalidResourceStateException(inner),
                crate::error::UpdateConnectionAliasPermissionErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::UpdateConnectionAliasPermissionErrorKind::ResourceAssociatedException(inner) => Error::ResourceAssociatedException(inner),
                crate::error::UpdateConnectionAliasPermissionErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::UpdateConnectionAliasPermissionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateConnectionAliasPermissionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateRulesOfIpGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateRulesOfIpGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateRulesOfIpGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateRulesOfIpGroupErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::UpdateRulesOfIpGroupErrorKind::InvalidResourceStateException(
                    inner,
                ) => Error::InvalidResourceStateException(inner),
                crate::error::UpdateRulesOfIpGroupErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::UpdateRulesOfIpGroupErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateRulesOfIpGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceBundleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceBundleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateWorkspaceBundleErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateWorkspaceBundleErrorKind::InvalidParameterValuesException(
                    inner,
                ) => Error::InvalidParameterValuesException(inner),
                crate::error::UpdateWorkspaceBundleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateWorkspaceBundleErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::UpdateWorkspaceBundleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceImagePermissionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateWorkspaceImagePermissionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateWorkspaceImagePermissionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateWorkspaceImagePermissionErrorKind::InvalidParameterValuesException(inner) => Error::InvalidParameterValuesException(inner),
                crate::error::UpdateWorkspaceImagePermissionErrorKind::OperationNotSupportedException(inner) => Error::OperationNotSupportedException(inner),
                crate::error::UpdateWorkspaceImagePermissionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateWorkspaceImagePermissionErrorKind::ResourceUnavailableException(inner) => Error::ResourceUnavailableException(inner),
                crate::error::UpdateWorkspaceImagePermissionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
