// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon WorkSpaces
///
/// Client for invoking operations on Amazon WorkSpaces. Each operation on Amazon WorkSpaces is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_workspaces::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_workspaces::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_workspaces::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateConnectionAlias` operation.
    ///
    /// See [`AssociateConnectionAlias`](crate::client::fluent_builders::AssociateConnectionAlias) for more information about the
    /// operation and its arguments.
    pub fn associate_connection_alias(&self) -> fluent_builders::AssociateConnectionAlias<C, M, R> {
        fluent_builders::AssociateConnectionAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateIpGroups` operation.
    ///
    /// See [`AssociateIpGroups`](crate::client::fluent_builders::AssociateIpGroups) for more information about the
    /// operation and its arguments.
    pub fn associate_ip_groups(&self) -> fluent_builders::AssociateIpGroups<C, M, R> {
        fluent_builders::AssociateIpGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AuthorizeIpRules` operation.
    ///
    /// See [`AuthorizeIpRules`](crate::client::fluent_builders::AuthorizeIpRules) for more information about the
    /// operation and its arguments.
    pub fn authorize_ip_rules(&self) -> fluent_builders::AuthorizeIpRules<C, M, R> {
        fluent_builders::AuthorizeIpRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyWorkspaceImage` operation.
    ///
    /// See [`CopyWorkspaceImage`](crate::client::fluent_builders::CopyWorkspaceImage) for more information about the
    /// operation and its arguments.
    pub fn copy_workspace_image(&self) -> fluent_builders::CopyWorkspaceImage<C, M, R> {
        fluent_builders::CopyWorkspaceImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConnectionAlias` operation.
    ///
    /// See [`CreateConnectionAlias`](crate::client::fluent_builders::CreateConnectionAlias) for more information about the
    /// operation and its arguments.
    pub fn create_connection_alias(&self) -> fluent_builders::CreateConnectionAlias<C, M, R> {
        fluent_builders::CreateConnectionAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIpGroup` operation.
    ///
    /// See [`CreateIpGroup`](crate::client::fluent_builders::CreateIpGroup) for more information about the
    /// operation and its arguments.
    pub fn create_ip_group(&self) -> fluent_builders::CreateIpGroup<C, M, R> {
        fluent_builders::CreateIpGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTags` operation.
    ///
    /// See [`CreateTags`](crate::client::fluent_builders::CreateTags) for more information about the
    /// operation and its arguments.
    pub fn create_tags(&self) -> fluent_builders::CreateTags<C, M, R> {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUpdatedWorkspaceImage` operation.
    ///
    /// See [`CreateUpdatedWorkspaceImage`](crate::client::fluent_builders::CreateUpdatedWorkspaceImage) for more information about the
    /// operation and its arguments.
    pub fn create_updated_workspace_image(
        &self,
    ) -> fluent_builders::CreateUpdatedWorkspaceImage<C, M, R> {
        fluent_builders::CreateUpdatedWorkspaceImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkspaceBundle` operation.
    ///
    /// See [`CreateWorkspaceBundle`](crate::client::fluent_builders::CreateWorkspaceBundle) for more information about the
    /// operation and its arguments.
    pub fn create_workspace_bundle(&self) -> fluent_builders::CreateWorkspaceBundle<C, M, R> {
        fluent_builders::CreateWorkspaceBundle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkspaces` operation.
    ///
    /// See [`CreateWorkspaces`](crate::client::fluent_builders::CreateWorkspaces) for more information about the
    /// operation and its arguments.
    pub fn create_workspaces(&self) -> fluent_builders::CreateWorkspaces<C, M, R> {
        fluent_builders::CreateWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnectionAlias` operation.
    ///
    /// See [`DeleteConnectionAlias`](crate::client::fluent_builders::DeleteConnectionAlias) for more information about the
    /// operation and its arguments.
    pub fn delete_connection_alias(&self) -> fluent_builders::DeleteConnectionAlias<C, M, R> {
        fluent_builders::DeleteConnectionAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIpGroup` operation.
    ///
    /// See [`DeleteIpGroup`](crate::client::fluent_builders::DeleteIpGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_ip_group(&self) -> fluent_builders::DeleteIpGroup<C, M, R> {
        fluent_builders::DeleteIpGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTags` operation.
    ///
    /// See [`DeleteTags`](crate::client::fluent_builders::DeleteTags) for more information about the
    /// operation and its arguments.
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkspaceBundle` operation.
    ///
    /// See [`DeleteWorkspaceBundle`](crate::client::fluent_builders::DeleteWorkspaceBundle) for more information about the
    /// operation and its arguments.
    pub fn delete_workspace_bundle(&self) -> fluent_builders::DeleteWorkspaceBundle<C, M, R> {
        fluent_builders::DeleteWorkspaceBundle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkspaceImage` operation.
    ///
    /// See [`DeleteWorkspaceImage`](crate::client::fluent_builders::DeleteWorkspaceImage) for more information about the
    /// operation and its arguments.
    pub fn delete_workspace_image(&self) -> fluent_builders::DeleteWorkspaceImage<C, M, R> {
        fluent_builders::DeleteWorkspaceImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterWorkspaceDirectory` operation.
    ///
    /// See [`DeregisterWorkspaceDirectory`](crate::client::fluent_builders::DeregisterWorkspaceDirectory) for more information about the
    /// operation and its arguments.
    pub fn deregister_workspace_directory(
        &self,
    ) -> fluent_builders::DeregisterWorkspaceDirectory<C, M, R> {
        fluent_builders::DeregisterWorkspaceDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccount` operation.
    ///
    /// See [`DescribeAccount`](crate::client::fluent_builders::DescribeAccount) for more information about the
    /// operation and its arguments.
    pub fn describe_account(&self) -> fluent_builders::DescribeAccount<C, M, R> {
        fluent_builders::DescribeAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountModifications` operation.
    ///
    /// See [`DescribeAccountModifications`](crate::client::fluent_builders::DescribeAccountModifications) for more information about the
    /// operation and its arguments.
    pub fn describe_account_modifications(
        &self,
    ) -> fluent_builders::DescribeAccountModifications<C, M, R> {
        fluent_builders::DescribeAccountModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClientProperties` operation.
    ///
    /// See [`DescribeClientProperties`](crate::client::fluent_builders::DescribeClientProperties) for more information about the
    /// operation and its arguments.
    pub fn describe_client_properties(&self) -> fluent_builders::DescribeClientProperties<C, M, R> {
        fluent_builders::DescribeClientProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnectionAliases` operation.
    ///
    /// See [`DescribeConnectionAliases`](crate::client::fluent_builders::DescribeConnectionAliases) for more information about the
    /// operation and its arguments.
    pub fn describe_connection_aliases(
        &self,
    ) -> fluent_builders::DescribeConnectionAliases<C, M, R> {
        fluent_builders::DescribeConnectionAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnectionAliasPermissions` operation.
    ///
    /// See [`DescribeConnectionAliasPermissions`](crate::client::fluent_builders::DescribeConnectionAliasPermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_connection_alias_permissions(
        &self,
    ) -> fluent_builders::DescribeConnectionAliasPermissions<C, M, R> {
        fluent_builders::DescribeConnectionAliasPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIpGroups` operation.
    ///
    /// See [`DescribeIpGroups`](crate::client::fluent_builders::DescribeIpGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_ip_groups(&self) -> fluent_builders::DescribeIpGroups<C, M, R> {
        fluent_builders::DescribeIpGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTags` operation.
    ///
    /// See [`DescribeTags`](crate::client::fluent_builders::DescribeTags) for more information about the
    /// operation and its arguments.
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags<C, M, R> {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkspaceBundles` operation.
    ///
    /// See [`DescribeWorkspaceBundles`](crate::client::fluent_builders::DescribeWorkspaceBundles) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeWorkspaceBundles::into_paginator).
    pub fn describe_workspace_bundles(&self) -> fluent_builders::DescribeWorkspaceBundles<C, M, R> {
        fluent_builders::DescribeWorkspaceBundles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkspaceDirectories` operation.
    ///
    /// See [`DescribeWorkspaceDirectories`](crate::client::fluent_builders::DescribeWorkspaceDirectories) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeWorkspaceDirectories::into_paginator).
    pub fn describe_workspace_directories(
        &self,
    ) -> fluent_builders::DescribeWorkspaceDirectories<C, M, R> {
        fluent_builders::DescribeWorkspaceDirectories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkspaceImagePermissions` operation.
    ///
    /// See [`DescribeWorkspaceImagePermissions`](crate::client::fluent_builders::DescribeWorkspaceImagePermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_workspace_image_permissions(
        &self,
    ) -> fluent_builders::DescribeWorkspaceImagePermissions<C, M, R> {
        fluent_builders::DescribeWorkspaceImagePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkspaceImages` operation.
    ///
    /// See [`DescribeWorkspaceImages`](crate::client::fluent_builders::DescribeWorkspaceImages) for more information about the
    /// operation and its arguments.
    pub fn describe_workspace_images(&self) -> fluent_builders::DescribeWorkspaceImages<C, M, R> {
        fluent_builders::DescribeWorkspaceImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkspaces` operation.
    ///
    /// See [`DescribeWorkspaces`](crate::client::fluent_builders::DescribeWorkspaces) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeWorkspaces::into_paginator).
    pub fn describe_workspaces(&self) -> fluent_builders::DescribeWorkspaces<C, M, R> {
        fluent_builders::DescribeWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkspacesConnectionStatus` operation.
    ///
    /// See [`DescribeWorkspacesConnectionStatus`](crate::client::fluent_builders::DescribeWorkspacesConnectionStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_workspaces_connection_status(
        &self,
    ) -> fluent_builders::DescribeWorkspacesConnectionStatus<C, M, R> {
        fluent_builders::DescribeWorkspacesConnectionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkspaceSnapshots` operation.
    ///
    /// See [`DescribeWorkspaceSnapshots`](crate::client::fluent_builders::DescribeWorkspaceSnapshots) for more information about the
    /// operation and its arguments.
    pub fn describe_workspace_snapshots(
        &self,
    ) -> fluent_builders::DescribeWorkspaceSnapshots<C, M, R> {
        fluent_builders::DescribeWorkspaceSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateConnectionAlias` operation.
    ///
    /// See [`DisassociateConnectionAlias`](crate::client::fluent_builders::DisassociateConnectionAlias) for more information about the
    /// operation and its arguments.
    pub fn disassociate_connection_alias(
        &self,
    ) -> fluent_builders::DisassociateConnectionAlias<C, M, R> {
        fluent_builders::DisassociateConnectionAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateIpGroups` operation.
    ///
    /// See [`DisassociateIpGroups`](crate::client::fluent_builders::DisassociateIpGroups) for more information about the
    /// operation and its arguments.
    pub fn disassociate_ip_groups(&self) -> fluent_builders::DisassociateIpGroups<C, M, R> {
        fluent_builders::DisassociateIpGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportWorkspaceImage` operation.
    ///
    /// See [`ImportWorkspaceImage`](crate::client::fluent_builders::ImportWorkspaceImage) for more information about the
    /// operation and its arguments.
    pub fn import_workspace_image(&self) -> fluent_builders::ImportWorkspaceImage<C, M, R> {
        fluent_builders::ImportWorkspaceImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAvailableManagementCidrRanges` operation.
    ///
    /// See [`ListAvailableManagementCidrRanges`](crate::client::fluent_builders::ListAvailableManagementCidrRanges) for more information about the
    /// operation and its arguments.
    pub fn list_available_management_cidr_ranges(
        &self,
    ) -> fluent_builders::ListAvailableManagementCidrRanges<C, M, R> {
        fluent_builders::ListAvailableManagementCidrRanges::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MigrateWorkspace` operation.
    ///
    /// See [`MigrateWorkspace`](crate::client::fluent_builders::MigrateWorkspace) for more information about the
    /// operation and its arguments.
    pub fn migrate_workspace(&self) -> fluent_builders::MigrateWorkspace<C, M, R> {
        fluent_builders::MigrateWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyAccount` operation.
    ///
    /// See [`ModifyAccount`](crate::client::fluent_builders::ModifyAccount) for more information about the
    /// operation and its arguments.
    pub fn modify_account(&self) -> fluent_builders::ModifyAccount<C, M, R> {
        fluent_builders::ModifyAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyClientProperties` operation.
    ///
    /// See [`ModifyClientProperties`](crate::client::fluent_builders::ModifyClientProperties) for more information about the
    /// operation and its arguments.
    pub fn modify_client_properties(&self) -> fluent_builders::ModifyClientProperties<C, M, R> {
        fluent_builders::ModifyClientProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifySelfservicePermissions` operation.
    ///
    /// See [`ModifySelfservicePermissions`](crate::client::fluent_builders::ModifySelfservicePermissions) for more information about the
    /// operation and its arguments.
    pub fn modify_selfservice_permissions(
        &self,
    ) -> fluent_builders::ModifySelfservicePermissions<C, M, R> {
        fluent_builders::ModifySelfservicePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyWorkspaceAccessProperties` operation.
    ///
    /// See [`ModifyWorkspaceAccessProperties`](crate::client::fluent_builders::ModifyWorkspaceAccessProperties) for more information about the
    /// operation and its arguments.
    pub fn modify_workspace_access_properties(
        &self,
    ) -> fluent_builders::ModifyWorkspaceAccessProperties<C, M, R> {
        fluent_builders::ModifyWorkspaceAccessProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyWorkspaceCreationProperties` operation.
    ///
    /// See [`ModifyWorkspaceCreationProperties`](crate::client::fluent_builders::ModifyWorkspaceCreationProperties) for more information about the
    /// operation and its arguments.
    pub fn modify_workspace_creation_properties(
        &self,
    ) -> fluent_builders::ModifyWorkspaceCreationProperties<C, M, R> {
        fluent_builders::ModifyWorkspaceCreationProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyWorkspaceProperties` operation.
    ///
    /// See [`ModifyWorkspaceProperties`](crate::client::fluent_builders::ModifyWorkspaceProperties) for more information about the
    /// operation and its arguments.
    pub fn modify_workspace_properties(
        &self,
    ) -> fluent_builders::ModifyWorkspaceProperties<C, M, R> {
        fluent_builders::ModifyWorkspaceProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyWorkspaceState` operation.
    ///
    /// See [`ModifyWorkspaceState`](crate::client::fluent_builders::ModifyWorkspaceState) for more information about the
    /// operation and its arguments.
    pub fn modify_workspace_state(&self) -> fluent_builders::ModifyWorkspaceState<C, M, R> {
        fluent_builders::ModifyWorkspaceState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootWorkspaces` operation.
    ///
    /// See [`RebootWorkspaces`](crate::client::fluent_builders::RebootWorkspaces) for more information about the
    /// operation and its arguments.
    pub fn reboot_workspaces(&self) -> fluent_builders::RebootWorkspaces<C, M, R> {
        fluent_builders::RebootWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebuildWorkspaces` operation.
    ///
    /// See [`RebuildWorkspaces`](crate::client::fluent_builders::RebuildWorkspaces) for more information about the
    /// operation and its arguments.
    pub fn rebuild_workspaces(&self) -> fluent_builders::RebuildWorkspaces<C, M, R> {
        fluent_builders::RebuildWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterWorkspaceDirectory` operation.
    ///
    /// See [`RegisterWorkspaceDirectory`](crate::client::fluent_builders::RegisterWorkspaceDirectory) for more information about the
    /// operation and its arguments.
    pub fn register_workspace_directory(
        &self,
    ) -> fluent_builders::RegisterWorkspaceDirectory<C, M, R> {
        fluent_builders::RegisterWorkspaceDirectory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreWorkspace` operation.
    ///
    /// See [`RestoreWorkspace`](crate::client::fluent_builders::RestoreWorkspace) for more information about the
    /// operation and its arguments.
    pub fn restore_workspace(&self) -> fluent_builders::RestoreWorkspace<C, M, R> {
        fluent_builders::RestoreWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeIpRules` operation.
    ///
    /// See [`RevokeIpRules`](crate::client::fluent_builders::RevokeIpRules) for more information about the
    /// operation and its arguments.
    pub fn revoke_ip_rules(&self) -> fluent_builders::RevokeIpRules<C, M, R> {
        fluent_builders::RevokeIpRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartWorkspaces` operation.
    ///
    /// See [`StartWorkspaces`](crate::client::fluent_builders::StartWorkspaces) for more information about the
    /// operation and its arguments.
    pub fn start_workspaces(&self) -> fluent_builders::StartWorkspaces<C, M, R> {
        fluent_builders::StartWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopWorkspaces` operation.
    ///
    /// See [`StopWorkspaces`](crate::client::fluent_builders::StopWorkspaces) for more information about the
    /// operation and its arguments.
    pub fn stop_workspaces(&self) -> fluent_builders::StopWorkspaces<C, M, R> {
        fluent_builders::StopWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TerminateWorkspaces` operation.
    ///
    /// See [`TerminateWorkspaces`](crate::client::fluent_builders::TerminateWorkspaces) for more information about the
    /// operation and its arguments.
    pub fn terminate_workspaces(&self) -> fluent_builders::TerminateWorkspaces<C, M, R> {
        fluent_builders::TerminateWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConnectionAliasPermission` operation.
    ///
    /// See [`UpdateConnectionAliasPermission`](crate::client::fluent_builders::UpdateConnectionAliasPermission) for more information about the
    /// operation and its arguments.
    pub fn update_connection_alias_permission(
        &self,
    ) -> fluent_builders::UpdateConnectionAliasPermission<C, M, R> {
        fluent_builders::UpdateConnectionAliasPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRulesOfIpGroup` operation.
    ///
    /// See [`UpdateRulesOfIpGroup`](crate::client::fluent_builders::UpdateRulesOfIpGroup) for more information about the
    /// operation and its arguments.
    pub fn update_rules_of_ip_group(&self) -> fluent_builders::UpdateRulesOfIpGroup<C, M, R> {
        fluent_builders::UpdateRulesOfIpGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkspaceBundle` operation.
    ///
    /// See [`UpdateWorkspaceBundle`](crate::client::fluent_builders::UpdateWorkspaceBundle) for more information about the
    /// operation and its arguments.
    pub fn update_workspace_bundle(&self) -> fluent_builders::UpdateWorkspaceBundle<C, M, R> {
        fluent_builders::UpdateWorkspaceBundle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkspaceImagePermission` operation.
    ///
    /// See [`UpdateWorkspaceImagePermission`](crate::client::fluent_builders::UpdateWorkspaceImagePermission) for more information about the
    /// operation and its arguments.
    pub fn update_workspace_image_permission(
        &self,
    ) -> fluent_builders::UpdateWorkspaceImagePermission<C, M, R> {
        fluent_builders::UpdateWorkspaceImagePermission::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateConnectionAlias`.
    ///
    /// <p>Associates the specified connection alias with the specified directory to enable cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <note>
    /// <p>Before performing this operation, call <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html"> DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateConnectionAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_connection_alias_input::Builder,
    }
    impl<C, M, R> AssociateConnectionAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateConnectionAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateConnectionAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateConnectionAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateConnectionAliasInputOperationOutputAlias,
                crate::output::AssociateConnectionAliasOutput,
                crate::error::AssociateConnectionAliasError,
                crate::input::AssociateConnectionAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_id(input.into());
            self
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_id(input);
            self
        }
        /// <p>The identifier of the directory to associate the connection alias with.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the directory to associate the connection alias with.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateIpGroups`.
    ///
    /// <p>Associates the specified IP access control group with the specified directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateIpGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_ip_groups_input::Builder,
    }
    impl<C, M, R> AssociateIpGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateIpGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateIpGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateIpGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateIpGroupsInputOperationOutputAlias,
                crate::output::AssociateIpGroupsOutput,
                crate::error::AssociateIpGroupsError,
                crate::input::AssociateIpGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `GroupIds`.
        ///
        /// To override the contents of this collection use [`set_group_ids`](Self::set_group_ids).
        ///
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_ids(input.into());
            self
        }
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn set_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeIpRules`.
    ///
    /// <p>Adds one or more rules to the specified IP access control group.</p>
    /// <p>This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeIpRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::authorize_ip_rules_input::Builder,
    }
    impl<C, M, R> AuthorizeIpRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AuthorizeIpRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeIpRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeIpRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AuthorizeIpRulesInputOperationOutputAlias,
                crate::output::AuthorizeIpRulesOutput,
                crate::error::AuthorizeIpRulesError,
                crate::input::AuthorizeIpRulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// Appends an item to `UserRules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>The rules to add to the group.</p>
        pub fn user_rules(mut self, input: crate::model::IpRuleItem) -> Self {
            self.inner = self.inner.user_rules(input);
            self
        }
        /// <p>The rules to add to the group.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        ) -> Self {
            self.inner = self.inner.set_user_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyWorkspaceImage`.
    ///
    /// <p>Copies the specified image from the specified Region to the current Region. For more information about copying images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html"> Copy a Custom WorkSpaces Image</a>.</p>
    /// <p>In the China (Ningxia) Region, you can copy images only within the same Region.</p>
    /// <p>In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.</p> <important>
    /// <p>Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns an image, use the <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">DescribeWorkSpaceImages</a> and <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html">DescribeWorkspaceImagePermissions</a> API operations. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyWorkspaceImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_workspace_image_input::Builder,
    }
    impl<C, M, R> CopyWorkspaceImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyWorkspaceImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyWorkspaceImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyWorkspaceImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyWorkspaceImageInputOperationOutputAlias,
                crate::output::CopyWorkspaceImageOutput,
                crate::error::CopyWorkspaceImageError,
                crate::input::CopyWorkspaceImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The identifier of the source image.</p>
        pub fn source_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_image_id(input.into());
            self
        }
        /// <p>The identifier of the source image.</p>
        pub fn set_source_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_image_id(input);
            self
        }
        /// <p>The identifier of the source Region.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_region(input.into());
            self
        }
        /// <p>The identifier of the source Region.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_region(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the image.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags for the image.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnectionAlias`.
    ///
    /// <p>Creates the specified connection alias for use with cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnectionAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connection_alias_input::Builder,
    }
    impl<C, M, R> CreateConnectionAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnectionAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectionAliasInputOperationOutputAlias,
                crate::output::CreateConnectionAliasOutput,
                crate::error::CreateConnectionAliasError,
                crate::input::CreateConnectionAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A connection string in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p> <important>
        /// <p>After you create a connection string, it is always associated to your Amazon Web Services account. You cannot recreate the same connection string with a different account, even if you delete all instances of it from the original account. The connection string is globally reserved for your account.</p>
        /// </important>
        pub fn connection_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_string(input.into());
            self
        }
        /// <p>A connection string in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p> <important>
        /// <p>After you create a connection string, it is always associated to your Amazon Web Services account. You cannot recreate the same connection string with a different account, even if you delete all instances of it from the original account. The connection string is globally reserved for your account.</p>
        /// </important>
        pub fn set_connection_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_string(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the connection alias.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to associate with the connection alias.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIpGroup`.
    ///
    /// <p>Creates an IP access control group.</p>
    /// <p>An IP access control group provides you with the ability to control the IP addresses from which users are allowed to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and then associate the group with your directory. You can add rules when you create the group or at any time using <code>AuthorizeIpRules</code>.</p>
    /// <p>There is a default IP access control group associated with your directory. If you don't associate an IP access control group with your directory, the default group is used. The default group includes a default rule that allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for your directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIpGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ip_group_input::Builder,
    }
    impl<C, M, R> CreateIpGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIpGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIpGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIpGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIpGroupInputOperationOutputAlias,
                crate::output::CreateIpGroupOutput,
                crate::error::CreateIpGroupError,
                crate::input::CreateIpGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The description of the group.</p>
        pub fn group_desc(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_desc(input.into());
            self
        }
        /// <p>The description of the group.</p>
        pub fn set_group_desc(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_desc(input);
            self
        }
        /// Appends an item to `UserRules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>The rules to add to the group.</p>
        pub fn user_rules(mut self, input: crate::model::IpRuleItem) -> Self {
            self.inner = self.inner.user_rules(input);
            self
        }
        /// <p>The rules to add to the group.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        ) -> Self {
            self.inner = self.inner.set_user_rules(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <p>Creates the specified tags for the specified WorkSpaces resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl<C, M, R> CreateTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTagsInputOperationOutputAlias,
                crate::output::CreateTagsOutput,
                crate::error::CreateTagsError,
                crate::input::CreateTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUpdatedWorkspaceImage`.
    ///
    /// <p>Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has the latest drivers and other updates required by the Amazon WorkSpaces components.</p>
    /// <p>To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html"> DescribeWorkspaceImages</a>.</p> <note>
    /// <ul>
    /// <li> <p>Only Windows 10, Windows Sever 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at this time.</p> </li>
    /// <li> <p>Microsoft Windows updates and other application updates are not included in the update process.</p> </li>
    /// <li> <p>The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated image and created a new bundle. </p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUpdatedWorkspaceImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_updated_workspace_image_input::Builder,
    }
    impl<C, M, R> CreateUpdatedWorkspaceImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUpdatedWorkspaceImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUpdatedWorkspaceImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUpdatedWorkspaceImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUpdatedWorkspaceImageInputOperationOutputAlias,
                crate::output::CreateUpdatedWorkspaceImageOutput,
                crate::error::CreateUpdatedWorkspaceImageError,
                crate::input::CreateUpdatedWorkspaceImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new updated WorkSpace image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new updated WorkSpace image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of whether updates for the WorkSpace image are available.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of whether updates for the WorkSpace image are available.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The identifier of the source WorkSpace image.</p>
        pub fn source_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_image_id(input.into());
            self
        }
        /// <p>The identifier of the source WorkSpace image.</p>
        pub fn set_source_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_image_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to add to the new updated WorkSpace image.</p> <note>
        /// <p>To add tags at the same time when you're creating the updated image, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags that you want to add to the new updated WorkSpace image.</p> <note>
        /// <p>To add tags at the same time when you're creating the updated image, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkspaceBundle`.
    ///
    /// <p>Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html"> Create a Custom WorkSpaces Image and Bundle</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkspaceBundle<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workspace_bundle_input::Builder,
    }
    impl<C, M, R> CreateWorkspaceBundle<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkspaceBundle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkspaceBundleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkspaceBundleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkspaceBundleInputOperationOutputAlias,
                crate::output::CreateWorkspaceBundleOutput,
                crate::error::CreateWorkspaceBundleError,
                crate::input::CreateWorkspaceBundleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bundle.</p>
        pub fn bundle_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_name(input.into());
            self
        }
        /// <p>The name of the bundle.</p>
        pub fn set_bundle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_name(input);
            self
        }
        /// <p>The description of the bundle.</p>
        pub fn bundle_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_description(input.into());
            self
        }
        /// <p>The description of the bundle.</p>
        pub fn set_bundle_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bundle_description(input);
            self
        }
        /// <p>The identifier of the image that is used to create the bundle.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier of the image that is used to create the bundle.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>Describes the compute type of the bundle.</p>
        pub fn compute_type(mut self, input: crate::model::ComputeType) -> Self {
            self.inner = self.inner.compute_type(input);
            self
        }
        /// <p>Describes the compute type of the bundle.</p>
        pub fn set_compute_type(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.inner = self.inner.set_compute_type(input);
            self
        }
        /// <p>Describes the user volume for a WorkSpace bundle.</p>
        pub fn user_storage(mut self, input: crate::model::UserStorage) -> Self {
            self.inner = self.inner.user_storage(input);
            self
        }
        /// <p>Describes the user volume for a WorkSpace bundle.</p>
        pub fn set_user_storage(
            mut self,
            input: std::option::Option<crate::model::UserStorage>,
        ) -> Self {
            self.inner = self.inner.set_user_storage(input);
            self
        }
        /// <p>Describes the root volume for a WorkSpace bundle.</p>
        pub fn root_storage(mut self, input: crate::model::RootStorage) -> Self {
            self.inner = self.inner.root_storage(input);
            self
        }
        /// <p>Describes the root volume for a WorkSpace bundle.</p>
        pub fn set_root_storage(
            mut self,
            input: std::option::Option<crate::model::RootStorage>,
        ) -> Self {
            self.inner = self.inner.set_root_storage(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the bundle.</p> <note>
        /// <p>To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with the bundle.</p> <note>
        /// <p>To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkspaces`.
    ///
    /// <p>Creates one or more WorkSpaces.</p>
    /// <p>This operation is asynchronous and returns before the WorkSpaces are created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workspaces_input::Builder,
    }
    impl<C, M, R> CreateWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkspacesInputOperationOutputAlias,
                crate::output::CreateWorkspacesOutput,
                crate::error::CreateWorkspacesError,
                crate::input::CreateWorkspacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Workspaces`.
        ///
        /// To override the contents of this collection use [`set_workspaces`](Self::set_workspaces).
        ///
        /// <p>The WorkSpaces to create. You can specify up to 25 WorkSpaces.</p>
        pub fn workspaces(mut self, input: crate::model::WorkspaceRequest) -> Self {
            self.inner = self.inner.workspaces(input);
            self
        }
        /// <p>The WorkSpaces to create. You can specify up to 25 WorkSpaces.</p>
        pub fn set_workspaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkspaceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_workspaces(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnectionAlias`.
    ///
    /// <p>Deletes the specified connection alias. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <important>
    /// <p> <b>If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your WorkSpaces users, you must take certain precautions to prevent potential security issues.</b> For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations"> Security Considerations if You Stop Using Cross-Region Redirection</a>.</p>
    /// </important> <note>
    /// <p>To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnectionAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connection_alias_input::Builder,
    }
    impl<C, M, R> DeleteConnectionAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnectionAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectionAliasInputOperationOutputAlias,
                crate::output::DeleteConnectionAliasOutput,
                crate::error::DeleteConnectionAliasError,
                crate::input::DeleteConnectionAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the connection alias to delete.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_id(input.into());
            self
        }
        /// <p>The identifier of the connection alias to delete.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIpGroup`.
    ///
    /// <p>Deletes the specified IP access control group.</p>
    /// <p>You cannot delete an IP access control group that is associated with a directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIpGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ip_group_input::Builder,
    }
    impl<C, M, R> DeleteIpGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIpGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIpGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIpGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIpGroupInputOperationOutputAlias,
                crate::output::DeleteIpGroupOutput,
                crate::error::DeleteIpGroupError,
                crate::input::DeleteIpGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the IP access control group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier of the IP access control group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Deletes the specified tags from the specified WorkSpaces resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl<C, M, R> DeleteTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagsInputOperationOutputAlias,
                crate::output::DeleteTagsOutput,
                crate::error::DeleteTagsError,
                crate::input::DeleteTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkspaceBundle`.
    ///
    /// <p>Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html"> Delete a Custom WorkSpaces Bundle or Image</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkspaceBundle<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workspace_bundle_input::Builder,
    }
    impl<C, M, R> DeleteWorkspaceBundle<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkspaceBundle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkspaceBundleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceBundleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkspaceBundleInputOperationOutputAlias,
                crate::output::DeleteWorkspaceBundleOutput,
                crate::error::DeleteWorkspaceBundleError,
                crate::input::DeleteWorkspaceBundleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bundle.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(input.into());
            self
        }
        /// <p>The identifier of the bundle.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkspaceImage`.
    ///
    /// <p>Deletes the specified image from your account. To delete an image, you must first delete any bundles that are associated with the image and unshare the image if it is shared with other accounts. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkspaceImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workspace_image_input::Builder,
    }
    impl<C, M, R> DeleteWorkspaceImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkspaceImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkspaceImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkspaceImageInputOperationOutputAlias,
                crate::output::DeleteWorkspaceImageOutput,
                crate::error::DeleteWorkspaceImageError,
                crate::input::DeleteWorkspaceImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterWorkspaceDirectory`.
    ///
    /// <p>Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister the directory.</p> <note>
    /// <p>Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.</p>
    /// <p>To delete empty directories, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterWorkspaceDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_workspace_directory_input::Builder,
    }
    impl<C, M, R> DeregisterWorkspaceDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterWorkspaceDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterWorkspaceDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterWorkspaceDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterWorkspaceDirectoryInputOperationOutputAlias,
                crate::output::DeregisterWorkspaceDirectoryOutput,
                crate::error::DeregisterWorkspaceDirectoryError,
                crate::input::DeregisterWorkspaceDirectoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory. If any WorkSpaces are registered to this directory, you must remove them before you deregister the directory, or you will receive an OperationNotSupportedException error.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory. If any WorkSpaces are registered to this directory, you must remove them before you deregister the directory, or you will receive an OperationNotSupportedException error.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccount`.
    ///
    /// <p>Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_input::Builder,
    }
    impl<C, M, R> DescribeAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountInputOperationOutputAlias,
                crate::output::DescribeAccountOutput,
                crate::error::DescribeAccountError,
                crate::input::DescribeAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountModifications`.
    ///
    /// <p>Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the specified account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountModifications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_modifications_input::Builder,
    }
    impl<C, M, R> DescribeAccountModifications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountModifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountModificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountModificationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountModificationsInputOperationOutputAlias,
                crate::output::DescribeAccountModificationsOutput,
                crate::error::DescribeAccountModificationsError,
                crate::input::DescribeAccountModificationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClientProperties`.
    ///
    /// <p>Retrieves a list that describes one or more specified Amazon WorkSpaces clients.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClientProperties<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_client_properties_input::Builder,
    }
    impl<C, M, R> DescribeClientProperties<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClientProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClientPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClientPropertiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClientPropertiesInputOperationOutputAlias,
                crate::output::DescribeClientPropertiesOutput,
                crate::error::DescribeClientPropertiesError,
                crate::input::DescribeClientPropertiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceIds`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The resource identifier, in the form of directory IDs.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_ids(input.into());
            self
        }
        /// <p>The resource identifier, in the form of directory IDs.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectionAliases`.
    ///
    /// <p>Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnectionAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connection_aliases_input::Builder,
    }
    impl<C, M, R> DescribeConnectionAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnectionAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectionAliasesInputOperationOutputAlias,
                crate::output::DescribeConnectionAliasesOutput,
                crate::error::DescribeConnectionAliasesError,
                crate::input::DescribeConnectionAliasesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AliasIds`.
        ///
        /// To override the contents of this collection use [`set_alias_ids`](Self::set_alias_ids).
        ///
        /// <p>The identifiers of the connection aliases to describe.</p>
        pub fn alias_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_ids(input.into());
            self
        }
        /// <p>The identifiers of the connection aliases to describe.</p>
        pub fn set_alias_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_alias_ids(input);
            self
        }
        /// <p>The identifier of the directory associated with the connection alias.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the directory associated with the connection alias.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The maximum number of connection aliases to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of connection aliases to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnectionAliasPermissions`.
    ///
    /// <p>Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account for the specified connection alias. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnectionAliasPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connection_alias_permissions_input::Builder,
    }
    impl<C, M, R> DescribeConnectionAliasPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnectionAliasPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionAliasPermissionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeConnectionAliasPermissionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectionAliasPermissionsInputOperationOutputAlias,
                crate::output::DescribeConnectionAliasPermissionsOutput,
                crate::error::DescribeConnectionAliasPermissionsError,
                crate::input::DescribeConnectionAliasPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_id(input.into());
            self
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_id(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIpGroups`.
    ///
    /// <p>Describes one or more of your IP access control groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIpGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ip_groups_input::Builder,
    }
    impl<C, M, R> DescribeIpGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIpGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIpGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIpGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIpGroupsInputOperationOutputAlias,
                crate::output::DescribeIpGroupsOutput,
                crate::error::DescribeIpGroupsError,
                crate::input::DescribeIpGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `GroupIds`.
        ///
        /// To override the contents of this collection use [`set_group_ids`](Self::set_group_ids).
        ///
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_ids(input.into());
            self
        }
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn set_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_group_ids(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Describes the specified tags for the specified WorkSpaces resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl<C, M, R> DescribeTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTagsInputOperationOutputAlias,
                crate::output::DescribeTagsOutput,
                crate::error::DescribeTagsError,
                crate::input::DescribeTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceBundles`.
    ///
    /// <p>Retrieves a list that describes the available WorkSpace bundles.</p>
    /// <p>You can filter the results using either bundle ID or owner, but not both.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceBundles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workspace_bundles_input::Builder,
    }
    impl<C, M, R> DescribeWorkspaceBundles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkspaceBundles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceBundlesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceBundlesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkspaceBundlesInputOperationOutputAlias,
                crate::output::DescribeWorkspaceBundlesOutput,
                crate::error::DescribeWorkspaceBundlesError,
                crate::input::DescribeWorkspaceBundlesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeWorkspaceBundlesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeWorkspaceBundlesPaginator<C, M, R> {
            crate::paginator::DescribeWorkspaceBundlesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `BundleIds`.
        ///
        /// To override the contents of this collection use [`set_bundle_ids`](Self::set_bundle_ids).
        ///
        /// <p>The identifiers of the bundles. You cannot combine this parameter with any other filter.</p>
        pub fn bundle_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_ids(input.into());
            self
        }
        /// <p>The identifiers of the bundles. You cannot combine this parameter with any other filter.</p>
        pub fn set_bundle_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_bundle_ids(input);
            self
        }
        /// <p>The owner of the bundles. You cannot combine this parameter with any other filter.</p>
        /// <p>To describe the bundles provided by Amazon Web Services, specify <code>AMAZON</code>. To describe the bundles that belong to your account, don't specify a value.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner(input.into());
            self
        }
        /// <p>The owner of the bundles. You cannot combine this parameter with any other filter.</p>
        /// <p>To describe the bundles provided by Amazon Web Services, specify <code>AMAZON</code>. To describe the bundles that belong to your account, don't specify a value.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// <p>The token for the next set of results. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceDirectories`.
    ///
    /// <p>Describes the available directories that are registered with Amazon WorkSpaces.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceDirectories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workspace_directories_input::Builder,
    }
    impl<C, M, R> DescribeWorkspaceDirectories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkspaceDirectories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceDirectoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceDirectoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkspaceDirectoriesInputOperationOutputAlias,
                crate::output::DescribeWorkspaceDirectoriesOutput,
                crate::error::DescribeWorkspaceDirectoriesError,
                crate::input::DescribeWorkspaceDirectoriesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeWorkspaceDirectoriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeWorkspaceDirectoriesPaginator<C, M, R> {
            crate::paginator::DescribeWorkspaceDirectoriesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `DirectoryIds`.
        ///
        /// To override the contents of this collection use [`set_directory_ids`](Self::set_directory_ids).
        ///
        /// <p>The identifiers of the directories. If the value is null, all directories are retrieved.</p>
        pub fn directory_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_ids(input.into());
            self
        }
        /// <p>The identifiers of the directories. If the value is null, all directories are retrieved.</p>
        pub fn set_directory_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_directory_ids(input);
            self
        }
        /// <p>The maximum number of directories to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of directories to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceImagePermissions`.
    ///
    /// <p>Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceImagePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workspace_image_permissions_input::Builder,
    }
    impl<C, M, R> DescribeWorkspaceImagePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkspaceImagePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceImagePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceImagePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkspaceImagePermissionsInputOperationOutputAlias,
                crate::output::DescribeWorkspaceImagePermissionsOutput,
                crate::error::DescribeWorkspaceImagePermissionsError,
                crate::input::DescribeWorkspaceImagePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceImages`.
    ///
    /// <p>Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise, all images in the account are described. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceImages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workspace_images_input::Builder,
    }
    impl<C, M, R> DescribeWorkspaceImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkspaceImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkspaceImagesInputOperationOutputAlias,
                crate::output::DescribeWorkspaceImagesOutput,
                crate::error::DescribeWorkspaceImagesError,
                crate::input::DescribeWorkspaceImagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ImageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The identifier of the image.</p>
        pub fn image_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_ids(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
        /// <p>The type (owned or shared) of the image.</p>
        pub fn image_type(mut self, input: crate::model::ImageType) -> Self {
            self.inner = self.inner.image_type(input);
            self
        }
        /// <p>The type (owned or shared) of the image.</p>
        pub fn set_image_type(
            mut self,
            input: std::option::Option<crate::model::ImageType>,
        ) -> Self {
            self.inner = self.inner.set_image_type(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaces`.
    ///
    /// <p>Describes the specified WorkSpaces.</p>
    /// <p>You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify only one filter at a time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workspaces_input::Builder,
    }
    impl<C, M, R> DescribeWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkspacesInputOperationOutputAlias,
                crate::output::DescribeWorkspacesOutput,
                crate::error::DescribeWorkspacesError,
                crate::input::DescribeWorkspacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeWorkspacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeWorkspacesPaginator<C, M, R> {
            crate::paginator::DescribeWorkspacesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `WorkspaceIds`.
        ///
        /// To override the contents of this collection use [`set_workspace_ids`](Self::set_workspace_ids).
        ///
        /// <p>The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.</p>
        /// <p>Because the <code>CreateWorkspaces</code> operation is asynchronous, the identifier it returns is not immediately available. If you immediately call <code>DescribeWorkspaces</code> with this identifier, no information is returned.</p>
        pub fn workspace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_ids(input.into());
            self
        }
        /// <p>The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.</p>
        /// <p>Because the <code>CreateWorkspaces</code> operation is asynchronous, the identifier it returns is not immediately available. If you immediately call <code>DescribeWorkspaces</code> with this identifier, no information is returned.</p>
        pub fn set_workspace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_workspace_ids(input);
            self
        }
        /// <p>The identifier of the directory. In addition, you can optionally specify a specific directory user (see <code>UserName</code>). You cannot combine this parameter with any other filter.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory. In addition, you can optionally specify a specific directory user (see <code>UserName</code>). You cannot combine this parameter with any other filter.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The name of the directory user. You must specify this parameter with <code>DirectoryId</code>.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the directory user. You must specify this parameter with <code>DirectoryId</code>.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot combine this parameter with any other filter.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(input.into());
            self
        }
        /// <p>The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot combine this parameter with any other filter.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspacesConnectionStatus`.
    ///
    /// <p>Describes the connection status of the specified WorkSpaces.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspacesConnectionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workspaces_connection_status_input::Builder,
    }
    impl<C, M, R> DescribeWorkspacesConnectionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkspacesConnectionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspacesConnectionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeWorkspacesConnectionStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkspacesConnectionStatusInputOperationOutputAlias,
                crate::output::DescribeWorkspacesConnectionStatusOutput,
                crate::error::DescribeWorkspacesConnectionStatusError,
                crate::input::DescribeWorkspacesConnectionStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `WorkspaceIds`.
        ///
        /// To override the contents of this collection use [`set_workspace_ids`](Self::set_workspace_ids).
        ///
        /// <p>The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.</p>
        pub fn workspace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_ids(input.into());
            self
        }
        /// <p>The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.</p>
        pub fn set_workspace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_workspace_ids(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceSnapshots`.
    ///
    /// <p>Describes the snapshots for the specified WorkSpace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workspace_snapshots_input::Builder,
    }
    impl<C, M, R> DescribeWorkspaceSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkspaceSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkspaceSnapshotsInputOperationOutputAlias,
                crate::output::DescribeWorkspaceSnapshotsOutput,
                crate::error::DescribeWorkspaceSnapshotsError,
                crate::input::DescribeWorkspaceSnapshotsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateConnectionAlias`.
    ///
    /// <p>Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region redirection between two directories in different Regions. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <note>
    /// <p>Before performing this operation, call <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html"> DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateConnectionAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_connection_alias_input::Builder,
    }
    impl<C, M, R> DisassociateConnectionAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateConnectionAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateConnectionAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateConnectionAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateConnectionAliasInputOperationOutputAlias,
                crate::output::DisassociateConnectionAliasOutput,
                crate::error::DisassociateConnectionAliasError,
                crate::input::DisassociateConnectionAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the connection alias to disassociate.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_id(input.into());
            self
        }
        /// <p>The identifier of the connection alias to disassociate.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateIpGroups`.
    ///
    /// <p>Disassociates the specified IP access control group from the specified directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateIpGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_ip_groups_input::Builder,
    }
    impl<C, M, R> DisassociateIpGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateIpGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateIpGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateIpGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateIpGroupsInputOperationOutputAlias,
                crate::output::DisassociateIpGroupsOutput,
                crate::error::DisassociateIpGroupsError,
                crate::input::DisassociateIpGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `GroupIds`.
        ///
        /// To override the contents of this collection use [`set_group_ids`](Self::set_group_ids).
        ///
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_ids(input.into());
            self
        }
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn set_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportWorkspaceImage`.
    ///
    /// <p>Imports the specified Windows 10 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image. For more information about creating BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows Desktop Licenses</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportWorkspaceImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_workspace_image_input::Builder,
    }
    impl<C, M, R> ImportWorkspaceImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportWorkspaceImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportWorkspaceImageOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportWorkspaceImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportWorkspaceImageInputOperationOutputAlias,
                crate::output::ImportWorkspaceImageOutput,
                crate::error::ImportWorkspaceImageError,
                crate::input::ImportWorkspaceImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the EC2 image.</p>
        pub fn ec2_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_image_id(input.into());
            self
        }
        /// <p>The identifier of the EC2 image.</p>
        pub fn set_ec2_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ec2_image_id(input);
            self
        }
        /// <p>The ingestion process to be used when importing the image, depending on which protocol you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces Streaming Protocol (WSP). To use WSP, specify a value that ends in <code>_WSP</code>. To use PCoIP, specify a value that does not end in <code>_WSP</code>. </p>
        /// <p>For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify <code>BYOL_REGULAR</code> or <code>BYOL_REGULAR_WSP</code>, depending on the protocol.</p>
        pub fn ingestion_process(
            mut self,
            input: crate::model::WorkspaceImageIngestionProcess,
        ) -> Self {
            self.inner = self.inner.ingestion_process(input);
            self
        }
        /// <p>The ingestion process to be used when importing the image, depending on which protocol you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces Streaming Protocol (WSP). To use WSP, specify a value that ends in <code>_WSP</code>. To use PCoIP, specify a value that does not end in <code>_WSP</code>. </p>
        /// <p>For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify <code>BYOL_REGULAR</code> or <code>BYOL_REGULAR_WSP</code>, depending on the protocol.</p>
        pub fn set_ingestion_process(
            mut self,
            input: std::option::Option<crate::model::WorkspaceImageIngestionProcess>,
        ) -> Self {
            self.inner = self.inner.set_ingestion_process(input);
            self
        }
        /// <p>The name of the WorkSpace image.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The name of the WorkSpace image.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The description of the WorkSpace image.</p>
        pub fn image_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_description(input.into());
            self
        }
        /// <p>The description of the WorkSpace image.</p>
        pub fn set_image_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `Applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10 BYOL images. For more information about subscribing to Office for BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows Desktop Licenses</a>.</p> <note>
        /// <p>Although this parameter is an array, only one item is allowed at this time.</p>
        /// </note>
        pub fn applications(mut self, input: crate::model::Application) -> Self {
            self.inner = self.inner.applications(input);
            self
        }
        /// <p>If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10 BYOL images. For more information about subscribing to Office for BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows Desktop Licenses</a>.</p> <note>
        /// <p>Although this parameter is an array, only one item is allowed at this time.</p>
        /// </note>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Application>>,
        ) -> Self {
            self.inner = self.inner.set_applications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAvailableManagementCidrRanges`.
    ///
    /// <p>Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management interface when you enable Bring Your Own License (BYOL). </p>
    /// <p>This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't enabled for BYOL, you'll receive an <code>AccessDeniedException</code> error.</p>
    /// <p>The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage the WorkSpace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAvailableManagementCidrRanges<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_available_management_cidr_ranges_input::Builder,
    }
    impl<C, M, R> ListAvailableManagementCidrRanges<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAvailableManagementCidrRanges`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAvailableManagementCidrRangesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAvailableManagementCidrRangesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAvailableManagementCidrRangesInputOperationOutputAlias,
                crate::output::ListAvailableManagementCidrRangesOutput,
                crate::error::ListAvailableManagementCidrRangesError,
                crate::input::ListAvailableManagementCidrRangesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IP address range to search. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).</p>
        pub fn management_cidr_range_constraint(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.management_cidr_range_constraint(input.into());
            self
        }
        /// <p>The IP address range to search. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).</p>
        pub fn set_management_cidr_range_constraint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_management_cidr_range_constraint(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MigrateWorkspace`.
    ///
    /// <p>Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user volume.</p>
    /// <p>The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the user volume from the last available snapshot of the original WorkSpace. During migration, the original <code>D:\Users\%USERNAME%</code> user profile folder is renamed to <code>D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\Users\%USERNAME%\</code> folder is generated by the new OS. Certain files in the old user profile are moved to the new user profile.</p>
    /// <p>For available migration scenarios, details about what happens during migration, and best practices, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MigrateWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::migrate_workspace_input::Builder,
    }
    impl<C, M, R> MigrateWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MigrateWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MigrateWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::MigrateWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MigrateWorkspaceInputOperationOutputAlias,
                crate::output::MigrateWorkspaceOutput,
                crate::error::MigrateWorkspaceError,
                crate::input::MigrateWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpace to migrate from.</p>
        pub fn source_workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_workspace_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace to migrate from.</p>
        pub fn set_source_workspace_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_workspace_id(input);
            self
        }
        /// <p>The identifier of the target bundle type to migrate the WorkSpace to.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(input.into());
            self
        }
        /// <p>The identifier of the target bundle type to migrate the WorkSpace to.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyAccount`.
    ///
    /// <p>Modifies the configuration of Bring Your Own License (BYOL) for the specified account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_account_input::Builder,
    }
    impl<C, M, R> ModifyAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyAccountInputOperationOutputAlias,
                crate::output::ModifyAccountOutput,
                crate::error::ModifyAccountError,
                crate::input::ModifyAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The status of BYOL.</p>
        pub fn dedicated_tenancy_support(
            mut self,
            input: crate::model::DedicatedTenancySupportEnum,
        ) -> Self {
            self.inner = self.inner.dedicated_tenancy_support(input);
            self
        }
        /// <p>The status of BYOL.</p>
        pub fn set_dedicated_tenancy_support(
            mut self,
            input: std::option::Option<crate::model::DedicatedTenancySupportEnum>,
        ) -> Self {
            self.inner = self.inner.set_dedicated_tenancy_support(input);
            self
        }
        /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be specified as available by the <code>ListAvailableManagementCidrRanges</code> operation.</p>
        pub fn dedicated_tenancy_management_cidr_range(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .dedicated_tenancy_management_cidr_range(input.into());
            self
        }
        /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be specified as available by the <code>ListAvailableManagementCidrRanges</code> operation.</p>
        pub fn set_dedicated_tenancy_management_cidr_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_dedicated_tenancy_management_cidr_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClientProperties`.
    ///
    /// <p>Modifies the properties of the specified Amazon WorkSpaces clients.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyClientProperties<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_client_properties_input::Builder,
    }
    impl<C, M, R> ModifyClientProperties<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyClientProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClientPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClientPropertiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyClientPropertiesInputOperationOutputAlias,
                crate::output::ModifyClientPropertiesOutput,
                crate::error::ModifyClientPropertiesError,
                crate::input::ModifyClientPropertiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource identifiers, in the form of directory IDs.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The resource identifiers, in the form of directory IDs.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Information about the Amazon WorkSpaces client.</p>
        pub fn client_properties(mut self, input: crate::model::ClientProperties) -> Self {
            self.inner = self.inner.client_properties(input);
            self
        }
        /// <p>Information about the Amazon WorkSpaces client.</p>
        pub fn set_client_properties(
            mut self,
            input: std::option::Option<crate::model::ClientProperties>,
        ) -> Self {
            self.inner = self.inner.set_client_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifySelfservicePermissions`.
    ///
    /// <p>Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html">Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifySelfservicePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_selfservice_permissions_input::Builder,
    }
    impl<C, M, R> ModifySelfservicePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifySelfservicePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifySelfservicePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifySelfservicePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifySelfservicePermissionsInputOperationOutputAlias,
                crate::output::ModifySelfservicePermissionsOutput,
                crate::error::ModifySelfservicePermissionsError,
                crate::input::ModifySelfservicePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The permissions to enable or disable self-service capabilities.</p>
        pub fn selfservice_permissions(
            mut self,
            input: crate::model::SelfservicePermissions,
        ) -> Self {
            self.inner = self.inner.selfservice_permissions(input);
            self
        }
        /// <p>The permissions to enable or disable self-service capabilities.</p>
        pub fn set_selfservice_permissions(
            mut self,
            input: std::option::Option<crate::model::SelfservicePermissions>,
        ) -> Self {
            self.inner = self.inner.set_selfservice_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyWorkspaceAccessProperties`.
    ///
    /// <p>Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access"> Control Device Access</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyWorkspaceAccessProperties<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_workspace_access_properties_input::Builder,
    }
    impl<C, M, R> ModifyWorkspaceAccessProperties<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyWorkspaceAccessProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyWorkspaceAccessPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyWorkspaceAccessPropertiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyWorkspaceAccessPropertiesInputOperationOutputAlias,
                crate::output::ModifyWorkspaceAccessPropertiesOutput,
                crate::error::ModifyWorkspaceAccessPropertiesError,
                crate::input::ModifyWorkspaceAccessPropertiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The device types and operating systems to enable or disable for access.</p>
        pub fn workspace_access_properties(
            mut self,
            input: crate::model::WorkspaceAccessProperties,
        ) -> Self {
            self.inner = self.inner.workspace_access_properties(input);
            self
        }
        /// <p>The device types and operating systems to enable or disable for access.</p>
        pub fn set_workspace_access_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceAccessProperties>,
        ) -> Self {
            self.inner = self.inner.set_workspace_access_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyWorkspaceCreationProperties`.
    ///
    /// <p>Modify the default properties used to create WorkSpaces.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyWorkspaceCreationProperties<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_workspace_creation_properties_input::Builder,
    }
    impl<C, M, R> ModifyWorkspaceCreationProperties<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyWorkspaceCreationProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyWorkspaceCreationPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyWorkspaceCreationPropertiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyWorkspaceCreationPropertiesInputOperationOutputAlias,
                crate::output::ModifyWorkspaceCreationPropertiesOutput,
                crate::error::ModifyWorkspaceCreationPropertiesError,
                crate::input::ModifyWorkspaceCreationPropertiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The default properties for creating WorkSpaces.</p>
        pub fn workspace_creation_properties(
            mut self,
            input: crate::model::WorkspaceCreationProperties,
        ) -> Self {
            self.inner = self.inner.workspace_creation_properties(input);
            self
        }
        /// <p>The default properties for creating WorkSpaces.</p>
        pub fn set_workspace_creation_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceCreationProperties>,
        ) -> Self {
            self.inner = self.inner.set_workspace_creation_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyWorkspaceProperties`.
    ///
    /// <p>Modifies the specified WorkSpace properties. For important information about how to modify the size of the root and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html"> Modify a WorkSpace</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyWorkspaceProperties<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_workspace_properties_input::Builder,
    }
    impl<C, M, R> ModifyWorkspaceProperties<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyWorkspaceProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyWorkspacePropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyWorkspacePropertiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyWorkspacePropertiesInputOperationOutputAlias,
                crate::output::ModifyWorkspacePropertiesOutput,
                crate::error::ModifyWorkspacePropertiesError,
                crate::input::ModifyWorkspacePropertiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The properties of the WorkSpace.</p>
        pub fn workspace_properties(mut self, input: crate::model::WorkspaceProperties) -> Self {
            self.inner = self.inner.workspace_properties(input);
            self
        }
        /// <p>The properties of the WorkSpace.</p>
        pub fn set_workspace_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceProperties>,
        ) -> Self {
            self.inner = self.inner.set_workspace_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyWorkspaceState`.
    ///
    /// <p>Sets the state of the specified WorkSpace.</p>
    /// <p>To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>. WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code> state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyWorkspaceState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_workspace_state_input::Builder,
    }
    impl<C, M, R> ModifyWorkspaceState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyWorkspaceState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyWorkspaceStateOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyWorkspaceStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyWorkspaceStateInputOperationOutputAlias,
                crate::output::ModifyWorkspaceStateOutput,
                crate::error::ModifyWorkspaceStateError,
                crate::input::ModifyWorkspaceStateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The WorkSpace state.</p>
        pub fn workspace_state(mut self, input: crate::model::TargetWorkspaceState) -> Self {
            self.inner = self.inner.workspace_state(input);
            self
        }
        /// <p>The WorkSpace state.</p>
        pub fn set_workspace_state(
            mut self,
            input: std::option::Option<crate::model::TargetWorkspaceState>,
        ) -> Self {
            self.inner = self.inner.set_workspace_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootWorkspaces`.
    ///
    /// <p>Reboots the specified WorkSpaces.</p>
    /// <p>You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code> or <code>UNHEALTHY</code>.</p>
    /// <p>This operation is asynchronous and returns before the WorkSpaces have rebooted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebootWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reboot_workspaces_input::Builder,
    }
    impl<C, M, R> RebootWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebootWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebootWorkspacesInputOperationOutputAlias,
                crate::output::RebootWorkspacesOutput,
                crate::error::RebootWorkspacesError,
                crate::input::RebootWorkspacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `RebootWorkspaceRequests`.
        ///
        /// To override the contents of this collection use [`set_reboot_workspace_requests`](Self::set_reboot_workspace_requests).
        ///
        /// <p>The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.</p>
        pub fn reboot_workspace_requests(mut self, input: crate::model::RebootRequest) -> Self {
            self.inner = self.inner.reboot_workspace_requests(input);
            self
        }
        /// <p>The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.</p>
        pub fn set_reboot_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RebootRequest>>,
        ) -> Self {
            self.inner = self.inner.set_reboot_workspace_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebuildWorkspaces`.
    ///
    /// <p>Rebuilds the specified WorkSpace.</p>
    /// <p>You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>, <code>UNHEALTHY</code>, <code>STOPPED</code>, or <code>REBOOTING</code>.</p>
    /// <p>Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild a WorkSpace</a>.</p>
    /// <p>This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebuildWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::rebuild_workspaces_input::Builder,
    }
    impl<C, M, R> RebuildWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebuildWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebuildWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::RebuildWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebuildWorkspacesInputOperationOutputAlias,
                crate::output::RebuildWorkspacesOutput,
                crate::error::RebuildWorkspacesError,
                crate::input::RebuildWorkspacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `RebuildWorkspaceRequests`.
        ///
        /// To override the contents of this collection use [`set_rebuild_workspace_requests`](Self::set_rebuild_workspace_requests).
        ///
        /// <p>The WorkSpace to rebuild. You can specify a single WorkSpace.</p>
        pub fn rebuild_workspace_requests(mut self, input: crate::model::RebuildRequest) -> Self {
            self.inner = self.inner.rebuild_workspace_requests(input);
            self
        }
        /// <p>The WorkSpace to rebuild. You can specify a single WorkSpace.</p>
        pub fn set_rebuild_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RebuildRequest>>,
        ) -> Self {
            self.inner = self.inner.set_rebuild_workspace_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterWorkspaceDirectory`.
    ///
    /// <p>Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is registered. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"> Creating the workspaces_DefaultRole Role</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterWorkspaceDirectory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_workspace_directory_input::Builder,
    }
    impl<C, M, R> RegisterWorkspaceDirectory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterWorkspaceDirectory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterWorkspaceDirectoryOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterWorkspaceDirectoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterWorkspaceDirectoryInputOperationOutputAlias,
                crate::output::RegisterWorkspaceDirectoryOutput,
                crate::error::RegisterWorkspaceDirectoryError,
                crate::input::RegisterWorkspaceDirectoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// <p>Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set <code>EnableWorkDocs</code> to disabled, and try again.</p>
        pub fn enable_work_docs(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_work_docs(input);
            self
        }
        /// <p>Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set <code>EnableWorkDocs</code> to disabled, and try again.</p>
        pub fn set_enable_work_docs(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_work_docs(input);
            self
        }
        /// <p>Indicates whether self-service capabilities are enabled or disabled.</p>
        pub fn enable_self_service(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_self_service(input);
            self
        }
        /// <p>Indicates whether self-service capabilities are enabled or disabled.</p>
        pub fn set_enable_self_service(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_self_service(input);
            self
        }
        /// <p>Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>
        pub fn tenancy(mut self, input: crate::model::Tenancy) -> Self {
            self.inner = self.inner.tenancy(input);
            self
        }
        /// <p>Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>
        pub fn set_tenancy(mut self, input: std::option::Option<crate::model::Tenancy>) -> Self {
            self.inner = self.inner.set_tenancy(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the directory.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with the directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreWorkspace`.
    ///
    /// <p>Restores the specified WorkSpace to its last known healthy state.</p>
    /// <p>You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>, <code>UNHEALTHY</code>, or <code>STOPPED</code>.</p>
    /// <p>Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.</p>
    /// <p>This operation is asynchronous and returns before the WorkSpace is completely restored.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_workspace_input::Builder,
    }
    impl<C, M, R> RestoreWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreWorkspaceInputOperationOutputAlias,
                crate::output::RestoreWorkspaceOutput,
                crate::error::RestoreWorkspaceError,
                crate::input::RestoreWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeIpRules`.
    ///
    /// <p>Removes one or more rules from the specified IP access control group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeIpRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_ip_rules_input::Builder,
    }
    impl<C, M, R> RevokeIpRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokeIpRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeIpRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeIpRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokeIpRulesInputOperationOutputAlias,
                crate::output::RevokeIpRulesOutput,
                crate::error::RevokeIpRulesError,
                crate::input::RevokeIpRulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// Appends an item to `UserRules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>The rules to remove from the group.</p>
        pub fn user_rules(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_rules(input.into());
            self
        }
        /// <p>The rules to remove from the group.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartWorkspaces`.
    ///
    /// <p>Starts the specified WorkSpaces.</p>
    /// <p>You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of <code>STOPPED</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_workspaces_input::Builder,
    }
    impl<C, M, R> StartWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::StartWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartWorkspacesInputOperationOutputAlias,
                crate::output::StartWorkspacesOutput,
                crate::error::StartWorkspacesError,
                crate::input::StartWorkspacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `StartWorkspaceRequests`.
        ///
        /// To override the contents of this collection use [`set_start_workspace_requests`](Self::set_start_workspace_requests).
        ///
        /// <p>The WorkSpaces to start. You can specify up to 25 WorkSpaces.</p>
        pub fn start_workspace_requests(mut self, input: crate::model::StartRequest) -> Self {
            self.inner = self.inner.start_workspace_requests(input);
            self
        }
        /// <p>The WorkSpaces to start. You can specify up to 25 WorkSpaces.</p>
        pub fn set_start_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StartRequest>>,
        ) -> Self {
            self.inner = self.inner.set_start_workspace_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopWorkspaces`.
    ///
    /// <p> Stops the specified WorkSpaces.</p>
    /// <p>You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_workspaces_input::Builder,
    }
    impl<C, M, R> StopWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::StopWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopWorkspacesInputOperationOutputAlias,
                crate::output::StopWorkspacesOutput,
                crate::error::StopWorkspacesError,
                crate::input::StopWorkspacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `StopWorkspaceRequests`.
        ///
        /// To override the contents of this collection use [`set_stop_workspace_requests`](Self::set_stop_workspace_requests).
        ///
        /// <p>The WorkSpaces to stop. You can specify up to 25 WorkSpaces.</p>
        pub fn stop_workspace_requests(mut self, input: crate::model::StopRequest) -> Self {
            self.inner = self.inner.stop_workspace_requests(input);
            self
        }
        /// <p>The WorkSpaces to stop. You can specify up to 25 WorkSpaces.</p>
        pub fn set_stop_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StopRequest>>,
        ) -> Self {
            self.inner = self.inner.set_stop_workspace_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateWorkspaces`.
    ///
    /// <p>Terminates the specified WorkSpaces.</p> <important>
    /// <p>Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to archive any user data, contact Amazon Web Services Support before terminating the WorkSpace.</p>
    /// </important>
    /// <p>You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.</p>
    /// <p>This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a WorkSpace is terminated, the <code>TERMINATED</code> state is returned only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkSpaces</a>. If the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.</p> <note>
    /// <p>Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.</p>
    /// <p>To delete empty directories, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TerminateWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::terminate_workspaces_input::Builder,
    }
    impl<C, M, R> TerminateWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TerminateWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TerminateWorkspacesInputOperationOutputAlias,
                crate::output::TerminateWorkspacesOutput,
                crate::error::TerminateWorkspacesError,
                crate::input::TerminateWorkspacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TerminateWorkspaceRequests`.
        ///
        /// To override the contents of this collection use [`set_terminate_workspace_requests`](Self::set_terminate_workspace_requests).
        ///
        /// <p>The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.</p>
        pub fn terminate_workspace_requests(
            mut self,
            input: crate::model::TerminateRequest,
        ) -> Self {
            self.inner = self.inner.terminate_workspace_requests(input);
            self
        }
        /// <p>The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.</p>
        pub fn set_terminate_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TerminateRequest>>,
        ) -> Self {
            self.inner = self.inner.set_terminate_workspace_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnectionAliasPermission`.
    ///
    /// <p>Shares or unshares a connection alias with one account by specifying whether that account has permission to associate the connection alias with a directory. If the association permission is granted, the connection alias is shared with that account. If the association permission is revoked, the connection alias is unshared with the account. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <note>
    /// <ul>
    /// <li> <p>Before performing this operation, call <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html"> DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>.</p> </li>
    /// <li> <p>To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnectionAliasPermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_connection_alias_permission_input::Builder,
    }
    impl<C, M, R> UpdateConnectionAliasPermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConnectionAliasPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectionAliasPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectionAliasPermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConnectionAliasPermissionInputOperationOutputAlias,
                crate::output::UpdateConnectionAliasPermissionOutput,
                crate::error::UpdateConnectionAliasPermissionError,
                crate::input::UpdateConnectionAliasPermissionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the connection alias that you want to update permissions for.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_id(input.into());
            self
        }
        /// <p>The identifier of the connection alias that you want to update permissions for.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_id(input);
            self
        }
        /// <p>Indicates whether to share or unshare the connection alias with the specified Amazon Web Services account.</p>
        pub fn connection_alias_permission(
            mut self,
            input: crate::model::ConnectionAliasPermission,
        ) -> Self {
            self.inner = self.inner.connection_alias_permission(input);
            self
        }
        /// <p>Indicates whether to share or unshare the connection alias with the specified Amazon Web Services account.</p>
        pub fn set_connection_alias_permission(
            mut self,
            input: std::option::Option<crate::model::ConnectionAliasPermission>,
        ) -> Self {
            self.inner = self.inner.set_connection_alias_permission(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRulesOfIpGroup`.
    ///
    /// <p>Replaces the current rules of the specified IP access control group with the specified rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRulesOfIpGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_rules_of_ip_group_input::Builder,
    }
    impl<C, M, R> UpdateRulesOfIpGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRulesOfIpGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRulesOfIpGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRulesOfIpGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRulesOfIpGroupInputOperationOutputAlias,
                crate::output::UpdateRulesOfIpGroupOutput,
                crate::error::UpdateRulesOfIpGroupError,
                crate::input::UpdateRulesOfIpGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// Appends an item to `UserRules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>One or more rules.</p>
        pub fn user_rules(mut self, input: crate::model::IpRuleItem) -> Self {
            self.inner = self.inner.user_rules(input);
            self
        }
        /// <p>One or more rules.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        ) -> Self {
            self.inner = self.inner.set_user_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkspaceBundle`.
    ///
    /// <p>Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html"> Update a Custom WorkSpaces Bundle</a>.</p> <important>
    /// <p>Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or delete and recreate them.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkspaceBundle<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workspace_bundle_input::Builder,
    }
    impl<C, M, R> UpdateWorkspaceBundle<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkspaceBundle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkspaceBundleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceBundleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkspaceBundleInputOperationOutputAlias,
                crate::output::UpdateWorkspaceBundleOutput,
                crate::error::UpdateWorkspaceBundleError,
                crate::input::UpdateWorkspaceBundleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bundle.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(input.into());
            self
        }
        /// <p>The identifier of the bundle.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkspaceImagePermission`.
    ///
    /// <p>Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that account has permission to copy the image. If the copy image permission is granted, the image is shared with that account. If the copy image permission is revoked, the image is unshared with the account.</p>
    /// <p>After an image has been shared, the recipient account can copy the image to other Regions as needed.</p>
    /// <p>In the China (Ningxia) Region, you can copy images only within the same Region.</p>
    /// <p>In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.</p>
    /// <p>For more information about sharing images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a Custom WorkSpaces Image</a>.</p> <note>
    /// <ul>
    /// <li> <p>To delete an image that has been shared, you must unshare the image before you delete it.</p> </li>
    /// <li> <p>Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US), contact Amazon Web Services Support.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkspaceImagePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workspace_image_permission_input::Builder,
    }
    impl<C, M, R> UpdateWorkspaceImagePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkspaceImagePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkspaceImagePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceImagePermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkspaceImagePermissionInputOperationOutputAlias,
                crate::output::UpdateWorkspaceImagePermissionOutput,
                crate::error::UpdateWorkspaceImagePermissionError,
                crate::input::UpdateWorkspaceImagePermissionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>The permission to copy the image. This permission can be revoked only after an image has been shared.</p>
        pub fn allow_copy_image(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_copy_image(input);
            self
        }
        /// <p>The permission to copy the image. This permission can be revoked only after an image has been shared.</p>
        pub fn set_allow_copy_image(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_copy_image(input);
            self
        }
        /// <p>The identifier of the Amazon Web Services account to share or unshare the image with.</p> <important>
        /// <p>Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.</p>
        /// </important>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_account_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account to share or unshare the image with.</p> <important>
        /// <p>Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.</p>
        /// </important>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_account_id(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
