// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateConnectionAliasInput`](crate::input::AssociateConnectionAliasInput)
pub mod associate_connection_alias_input {
    /// A builder for [`AssociateConnectionAliasInput`](crate::input::AssociateConnectionAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the connection alias.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// <p>The identifier of the directory to associate the connection alias with.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory to associate the connection alias with.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateConnectionAliasInput`](crate::input::AssociateConnectionAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateConnectionAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateConnectionAliasInput {
                alias_id: self.alias_id,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateConnectionAliasInputOperationOutputAlias =
    crate::operation::AssociateConnectionAlias;
#[doc(hidden)]
pub type AssociateConnectionAliasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateConnectionAliasInput {
    /// Consumes the builder and constructs an Operation<[`AssociateConnectionAlias`](crate::operation::AssociateConnectionAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateConnectionAlias,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateConnectionAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateConnectionAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateConnectionAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.AssociateConnectionAlias",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_connection_alias(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateConnectionAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateConnectionAlias",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateConnectionAliasInput`](crate::input::AssociateConnectionAliasInput)
    pub fn builder() -> crate::input::associate_connection_alias_input::Builder {
        crate::input::associate_connection_alias_input::Builder::default()
    }
}

/// See [`AssociateIpGroupsInput`](crate::input::AssociateIpGroupsInput)
pub mod associate_ip_groups_input {
    /// A builder for [`AssociateIpGroupsInput`](crate::input::AssociateIpGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Appends an item to `group_ids`.
        ///
        /// To override the contents of this collection use [`set_group_ids`](Self::set_group_ids).
        ///
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.group_ids.unwrap_or_default();
            v.push(input.into());
            self.group_ids = Some(v);
            self
        }
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn set_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateIpGroupsInput`](crate::input::AssociateIpGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateIpGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateIpGroupsInput {
                directory_id: self.directory_id,
                group_ids: self.group_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateIpGroupsInputOperationOutputAlias = crate::operation::AssociateIpGroups;
#[doc(hidden)]
pub type AssociateIpGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateIpGroupsInput {
    /// Consumes the builder and constructs an Operation<[`AssociateIpGroups`](crate::operation::AssociateIpGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateIpGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateIpGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateIpGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateIpGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.AssociateIpGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_ip_groups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateIpGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateIpGroups",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateIpGroupsInput`](crate::input::AssociateIpGroupsInput)
    pub fn builder() -> crate::input::associate_ip_groups_input::Builder {
        crate::input::associate_ip_groups_input::Builder::default()
    }
}

/// See [`AuthorizeIpRulesInput`](crate::input::AuthorizeIpRulesInput)
pub mod authorize_ip_rules_input {
    /// A builder for [`AuthorizeIpRulesInput`](crate::input::AuthorizeIpRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) user_rules: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
    }
    impl Builder {
        /// <p>The identifier of the group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Appends an item to `user_rules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>The rules to add to the group.</p>
        pub fn user_rules(mut self, input: impl Into<crate::model::IpRuleItem>) -> Self {
            let mut v = self.user_rules.unwrap_or_default();
            v.push(input.into());
            self.user_rules = Some(v);
            self
        }
        /// <p>The rules to add to the group.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        ) -> Self {
            self.user_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeIpRulesInput`](crate::input::AuthorizeIpRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AuthorizeIpRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AuthorizeIpRulesInput {
                group_id: self.group_id,
                user_rules: self.user_rules,
            })
        }
    }
}
#[doc(hidden)]
pub type AuthorizeIpRulesInputOperationOutputAlias = crate::operation::AuthorizeIpRules;
#[doc(hidden)]
pub type AuthorizeIpRulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AuthorizeIpRulesInput {
    /// Consumes the builder and constructs an Operation<[`AuthorizeIpRules`](crate::operation::AuthorizeIpRules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AuthorizeIpRules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AuthorizeIpRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AuthorizeIpRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AuthorizeIpRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.AuthorizeIpRules",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_authorize_ip_rules(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AuthorizeIpRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AuthorizeIpRules",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AuthorizeIpRulesInput`](crate::input::AuthorizeIpRulesInput)
    pub fn builder() -> crate::input::authorize_ip_rules_input::Builder {
        crate::input::authorize_ip_rules_input::Builder::default()
    }
}

/// See [`CopyWorkspaceImageInput`](crate::input::CopyWorkspaceImageInput)
pub mod copy_workspace_image_input {
    /// A builder for [`CopyWorkspaceImageInput`](crate::input::CopyWorkspaceImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source_image_id: std::option::Option<std::string::String>,
        pub(crate) source_region: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The identifier of the source image.</p>
        pub fn source_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the source image.</p>
        pub fn set_source_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_image_id = input;
            self
        }
        /// <p>The identifier of the source Region.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_region = Some(input.into());
            self
        }
        /// <p>The identifier of the source Region.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the image.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the image.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyWorkspaceImageInput`](crate::input::CopyWorkspaceImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyWorkspaceImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyWorkspaceImageInput {
                name: self.name,
                description: self.description,
                source_image_id: self.source_image_id,
                source_region: self.source_region,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyWorkspaceImageInputOperationOutputAlias = crate::operation::CopyWorkspaceImage;
#[doc(hidden)]
pub type CopyWorkspaceImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CopyWorkspaceImageInput {
    /// Consumes the builder and constructs an Operation<[`CopyWorkspaceImage`](crate::operation::CopyWorkspaceImage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyWorkspaceImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyWorkspaceImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyWorkspaceImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyWorkspaceImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.CopyWorkspaceImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_copy_workspace_image(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyWorkspaceImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyWorkspaceImage",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyWorkspaceImageInput`](crate::input::CopyWorkspaceImageInput)
    pub fn builder() -> crate::input::copy_workspace_image_input::Builder {
        crate::input::copy_workspace_image_input::Builder::default()
    }
}

/// See [`CreateConnectionAliasInput`](crate::input::CreateConnectionAliasInput)
pub mod create_connection_alias_input {
    /// A builder for [`CreateConnectionAliasInput`](crate::input::CreateConnectionAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_string: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A connection string in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p>
        ///
        /// <important>
        /// <p>After you create a connection string, it is always associated to your Amazon Web Services account. You cannot recreate the same
        /// connection string with a different account, even if you delete all instances of it from the original account. The
        /// connection string is globally reserved for your account.</p>
        /// </important>
        pub fn connection_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_string = Some(input.into());
            self
        }
        /// <p>A connection string in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p>
        ///
        /// <important>
        /// <p>After you create a connection string, it is always associated to your Amazon Web Services account. You cannot recreate the same
        /// connection string with a different account, even if you delete all instances of it from the original account. The
        /// connection string is globally reserved for your account.</p>
        /// </important>
        pub fn set_connection_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_string = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the connection alias.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to associate with the connection alias.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionAliasInput`](crate::input::CreateConnectionAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConnectionAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConnectionAliasInput {
                connection_string: self.connection_string,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConnectionAliasInputOperationOutputAlias = crate::operation::CreateConnectionAlias;
#[doc(hidden)]
pub type CreateConnectionAliasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConnectionAliasInput {
    /// Consumes the builder and constructs an Operation<[`CreateConnectionAlias`](crate::operation::CreateConnectionAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConnectionAlias,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConnectionAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConnectionAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConnectionAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.CreateConnectionAlias",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_connection_alias(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConnectionAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConnectionAlias",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConnectionAliasInput`](crate::input::CreateConnectionAliasInput)
    pub fn builder() -> crate::input::create_connection_alias_input::Builder {
        crate::input::create_connection_alias_input::Builder::default()
    }
}

/// See [`CreateIpGroupInput`](crate::input::CreateIpGroupInput)
pub mod create_ip_group_input {
    /// A builder for [`CreateIpGroupInput`](crate::input::CreateIpGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_desc: std::option::Option<std::string::String>,
        pub(crate) user_rules: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The description of the group.</p>
        pub fn group_desc(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_desc = Some(input.into());
            self
        }
        /// <p>The description of the group.</p>
        pub fn set_group_desc(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_desc = input;
            self
        }
        /// Appends an item to `user_rules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>The rules to add to the group.</p>
        pub fn user_rules(mut self, input: impl Into<crate::model::IpRuleItem>) -> Self {
            let mut v = self.user_rules.unwrap_or_default();
            v.push(input.into());
            self.user_rules = Some(v);
            self
        }
        /// <p>The rules to add to the group.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        ) -> Self {
            self.user_rules = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIpGroupInput`](crate::input::CreateIpGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIpGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIpGroupInput {
                group_name: self.group_name,
                group_desc: self.group_desc,
                user_rules: self.user_rules,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIpGroupInputOperationOutputAlias = crate::operation::CreateIpGroup;
#[doc(hidden)]
pub type CreateIpGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateIpGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateIpGroup`](crate::operation::CreateIpGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIpGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIpGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIpGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIpGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.CreateIpGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_ip_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIpGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIpGroup",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIpGroupInput`](crate::input::CreateIpGroupInput)
    pub fn builder() -> crate::input::create_ip_group_input::Builder {
        crate::input::create_ip_group_input::Builder::default()
    }
}

/// See [`CreateTagsInput`](crate::input::CreateTagsInput)
pub mod create_tags_input {
    /// A builder for [`CreateTagsInput`](crate::input::CreateTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
        /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
        /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTagsInput`](crate::input::CreateTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTagsInput {
                resource_id: self.resource_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTagsInputOperationOutputAlias = crate::operation::CreateTags;
#[doc(hidden)]
pub type CreateTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTagsInput {
    /// Consumes the builder and constructs an Operation<[`CreateTags`](crate::operation::CreateTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.CreateTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTags",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTagsInput`](crate::input::CreateTagsInput)
    pub fn builder() -> crate::input::create_tags_input::Builder {
        crate::input::create_tags_input::Builder::default()
    }
}

/// See [`CreateUpdatedWorkspaceImageInput`](crate::input::CreateUpdatedWorkspaceImageInput)
pub mod create_updated_workspace_image_input {
    /// A builder for [`CreateUpdatedWorkspaceImageInput`](crate::input::CreateUpdatedWorkspaceImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source_image_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the new updated WorkSpace image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new updated WorkSpace image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of whether updates for the WorkSpace image are available.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of whether updates for the WorkSpace image are available.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The identifier of the source WorkSpace image.</p>
        pub fn source_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the source WorkSpace image.</p>
        pub fn set_source_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_image_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to add to the new updated WorkSpace image.</p>
        ///
        /// <note>
        /// <p>To add tags at the same time when you're creating the updated image, you must create
        /// an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags that you want to add to the new updated WorkSpace image.</p>
        ///
        /// <note>
        /// <p>To add tags at the same time when you're creating the updated image, you must create
        /// an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUpdatedWorkspaceImageInput`](crate::input::CreateUpdatedWorkspaceImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUpdatedWorkspaceImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUpdatedWorkspaceImageInput {
                name: self.name,
                description: self.description,
                source_image_id: self.source_image_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUpdatedWorkspaceImageInputOperationOutputAlias =
    crate::operation::CreateUpdatedWorkspaceImage;
#[doc(hidden)]
pub type CreateUpdatedWorkspaceImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateUpdatedWorkspaceImageInput {
    /// Consumes the builder and constructs an Operation<[`CreateUpdatedWorkspaceImage`](crate::operation::CreateUpdatedWorkspaceImage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUpdatedWorkspaceImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUpdatedWorkspaceImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUpdatedWorkspaceImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUpdatedWorkspaceImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.CreateUpdatedWorkspaceImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_updated_workspace_image(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUpdatedWorkspaceImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUpdatedWorkspaceImage",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUpdatedWorkspaceImageInput`](crate::input::CreateUpdatedWorkspaceImageInput)
    pub fn builder() -> crate::input::create_updated_workspace_image_input::Builder {
        crate::input::create_updated_workspace_image_input::Builder::default()
    }
}

/// See [`CreateWorkspaceBundleInput`](crate::input::CreateWorkspaceBundleInput)
pub mod create_workspace_bundle_input {
    /// A builder for [`CreateWorkspaceBundleInput`](crate::input::CreateWorkspaceBundleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_name: std::option::Option<std::string::String>,
        pub(crate) bundle_description: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) compute_type: std::option::Option<crate::model::ComputeType>,
        pub(crate) user_storage: std::option::Option<crate::model::UserStorage>,
        pub(crate) root_storage: std::option::Option<crate::model::RootStorage>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the bundle.</p>
        pub fn bundle_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_name = Some(input.into());
            self
        }
        /// <p>The name of the bundle.</p>
        pub fn set_bundle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_name = input;
            self
        }
        /// <p>The description of the bundle.</p>
        pub fn bundle_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_description = Some(input.into());
            self
        }
        /// <p>The description of the bundle.</p>
        pub fn set_bundle_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bundle_description = input;
            self
        }
        /// <p>The identifier of the image that is used to create the bundle.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the image that is used to create the bundle.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>Describes the compute type of the bundle.</p>
        pub fn compute_type(mut self, input: crate::model::ComputeType) -> Self {
            self.compute_type = Some(input);
            self
        }
        /// <p>Describes the compute type of the bundle.</p>
        pub fn set_compute_type(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.compute_type = input;
            self
        }
        /// <p>Describes the user volume for a WorkSpace bundle.</p>
        pub fn user_storage(mut self, input: crate::model::UserStorage) -> Self {
            self.user_storage = Some(input);
            self
        }
        /// <p>Describes the user volume for a WorkSpace bundle.</p>
        pub fn set_user_storage(
            mut self,
            input: std::option::Option<crate::model::UserStorage>,
        ) -> Self {
            self.user_storage = input;
            self
        }
        /// <p>Describes the root volume for a WorkSpace bundle.</p>
        pub fn root_storage(mut self, input: crate::model::RootStorage) -> Self {
            self.root_storage = Some(input);
            self
        }
        /// <p>Describes the root volume for a WorkSpace bundle.</p>
        pub fn set_root_storage(
            mut self,
            input: std::option::Option<crate::model::RootStorage>,
        ) -> Self {
            self.root_storage = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the bundle.</p>
        ///
        /// <note>
        /// <p>To add tags at the same time when you're creating the bundle, you must create an IAM policy that
        /// grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the bundle.</p>
        ///
        /// <note>
        /// <p>To add tags at the same time when you're creating the bundle, you must create an IAM policy that
        /// grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkspaceBundleInput`](crate::input::CreateWorkspaceBundleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkspaceBundleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkspaceBundleInput {
                bundle_name: self.bundle_name,
                bundle_description: self.bundle_description,
                image_id: self.image_id,
                compute_type: self.compute_type,
                user_storage: self.user_storage,
                root_storage: self.root_storage,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkspaceBundleInputOperationOutputAlias = crate::operation::CreateWorkspaceBundle;
#[doc(hidden)]
pub type CreateWorkspaceBundleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkspaceBundleInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkspaceBundle`](crate::operation::CreateWorkspaceBundle)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkspaceBundle,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkspaceBundleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkspaceBundleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkspaceBundleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.CreateWorkspaceBundle",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_workspace_bundle(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkspaceBundle::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkspaceBundle",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkspaceBundleInput`](crate::input::CreateWorkspaceBundleInput)
    pub fn builder() -> crate::input::create_workspace_bundle_input::Builder {
        crate::input::create_workspace_bundle_input::Builder::default()
    }
}

/// See [`CreateWorkspacesInput`](crate::input::CreateWorkspacesInput)
pub mod create_workspaces_input {
    /// A builder for [`CreateWorkspacesInput`](crate::input::CreateWorkspacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspaces: std::option::Option<std::vec::Vec<crate::model::WorkspaceRequest>>,
    }
    impl Builder {
        /// Appends an item to `workspaces`.
        ///
        /// To override the contents of this collection use [`set_workspaces`](Self::set_workspaces).
        ///
        /// <p>The WorkSpaces to create. You can specify up to 25 WorkSpaces.</p>
        pub fn workspaces(mut self, input: impl Into<crate::model::WorkspaceRequest>) -> Self {
            let mut v = self.workspaces.unwrap_or_default();
            v.push(input.into());
            self.workspaces = Some(v);
            self
        }
        /// <p>The WorkSpaces to create. You can specify up to 25 WorkSpaces.</p>
        pub fn set_workspaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkspaceRequest>>,
        ) -> Self {
            self.workspaces = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkspacesInput`](crate::input::CreateWorkspacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkspacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkspacesInput {
                workspaces: self.workspaces,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkspacesInputOperationOutputAlias = crate::operation::CreateWorkspaces;
#[doc(hidden)]
pub type CreateWorkspacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkspacesInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkspaces`](crate::operation::CreateWorkspaces)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkspaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkspacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkspacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkspacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.CreateWorkspaces",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_workspaces(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkspaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkspaces",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkspacesInput`](crate::input::CreateWorkspacesInput)
    pub fn builder() -> crate::input::create_workspaces_input::Builder {
        crate::input::create_workspaces_input::Builder::default()
    }
}

/// See [`DeleteConnectionAliasInput`](crate::input::DeleteConnectionAliasInput)
pub mod delete_connection_alias_input {
    /// A builder for [`DeleteConnectionAliasInput`](crate::input::DeleteConnectionAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the connection alias to delete.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the connection alias to delete.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectionAliasInput`](crate::input::DeleteConnectionAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConnectionAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConnectionAliasInput {
                alias_id: self.alias_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConnectionAliasInputOperationOutputAlias = crate::operation::DeleteConnectionAlias;
#[doc(hidden)]
pub type DeleteConnectionAliasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConnectionAliasInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConnectionAlias`](crate::operation::DeleteConnectionAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConnectionAlias,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConnectionAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConnectionAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConnectionAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DeleteConnectionAlias",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_connection_alias(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConnectionAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConnectionAlias",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConnectionAliasInput`](crate::input::DeleteConnectionAliasInput)
    pub fn builder() -> crate::input::delete_connection_alias_input::Builder {
        crate::input::delete_connection_alias_input::Builder::default()
    }
}

/// See [`DeleteIpGroupInput`](crate::input::DeleteIpGroupInput)
pub mod delete_ip_group_input {
    /// A builder for [`DeleteIpGroupInput`](crate::input::DeleteIpGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the IP access control group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the IP access control group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIpGroupInput`](crate::input::DeleteIpGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIpGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIpGroupInput {
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIpGroupInputOperationOutputAlias = crate::operation::DeleteIpGroup;
#[doc(hidden)]
pub type DeleteIpGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteIpGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIpGroup`](crate::operation::DeleteIpGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIpGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIpGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIpGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIpGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DeleteIpGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_ip_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIpGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIpGroup",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIpGroupInput`](crate::input::DeleteIpGroupInput)
    pub fn builder() -> crate::input::delete_ip_group_input::Builder {
        crate::input::delete_ip_group_input::Builder::default()
    }
}

/// See [`DeleteTagsInput`](crate::input::DeleteTagsInput)
pub mod delete_tags_input {
    /// A builder for [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
        /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
        /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagsInput`](crate::input::DeleteTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTagsInput {
                resource_id: self.resource_id,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTagsInputOperationOutputAlias = crate::operation::DeleteTags;
#[doc(hidden)]
pub type DeleteTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTagsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTags`](crate::operation::DeleteTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DeleteTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTags",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
}

/// See [`DeleteWorkspaceBundleInput`](crate::input::DeleteWorkspaceBundleInput)
pub mod delete_workspace_bundle_input {
    /// A builder for [`DeleteWorkspaceBundleInput`](crate::input::DeleteWorkspaceBundleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bundle.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bundle.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkspaceBundleInput`](crate::input::DeleteWorkspaceBundleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkspaceBundleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkspaceBundleInput {
                bundle_id: self.bundle_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkspaceBundleInputOperationOutputAlias = crate::operation::DeleteWorkspaceBundle;
#[doc(hidden)]
pub type DeleteWorkspaceBundleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkspaceBundleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkspaceBundle`](crate::operation::DeleteWorkspaceBundle)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkspaceBundle,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkspaceBundleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkspaceBundleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkspaceBundleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DeleteWorkspaceBundle",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_workspace_bundle(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkspaceBundle::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkspaceBundle",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceBundleInput`](crate::input::DeleteWorkspaceBundleInput)
    pub fn builder() -> crate::input::delete_workspace_bundle_input::Builder {
        crate::input::delete_workspace_bundle_input::Builder::default()
    }
}

/// See [`DeleteWorkspaceImageInput`](crate::input::DeleteWorkspaceImageInput)
pub mod delete_workspace_image_input {
    /// A builder for [`DeleteWorkspaceImageInput`](crate::input::DeleteWorkspaceImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkspaceImageInput`](crate::input::DeleteWorkspaceImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkspaceImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkspaceImageInput {
                image_id: self.image_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkspaceImageInputOperationOutputAlias = crate::operation::DeleteWorkspaceImage;
#[doc(hidden)]
pub type DeleteWorkspaceImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkspaceImageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkspaceImage`](crate::operation::DeleteWorkspaceImage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkspaceImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkspaceImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkspaceImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkspaceImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DeleteWorkspaceImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_workspace_image(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkspaceImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkspaceImage",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceImageInput`](crate::input::DeleteWorkspaceImageInput)
    pub fn builder() -> crate::input::delete_workspace_image_input::Builder {
        crate::input::delete_workspace_image_input::Builder::default()
    }
}

/// See [`DeregisterWorkspaceDirectoryInput`](crate::input::DeregisterWorkspaceDirectoryInput)
pub mod deregister_workspace_directory_input {
    /// A builder for [`DeregisterWorkspaceDirectoryInput`](crate::input::DeregisterWorkspaceDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the directory. If any WorkSpaces are registered to this directory, you must
        /// remove them before you deregister the directory, or you will receive an OperationNotSupportedException
        /// error.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory. If any WorkSpaces are registered to this directory, you must
        /// remove them before you deregister the directory, or you will receive an OperationNotSupportedException
        /// error.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterWorkspaceDirectoryInput`](crate::input::DeregisterWorkspaceDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterWorkspaceDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterWorkspaceDirectoryInput {
                directory_id: self.directory_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterWorkspaceDirectoryInputOperationOutputAlias =
    crate::operation::DeregisterWorkspaceDirectory;
#[doc(hidden)]
pub type DeregisterWorkspaceDirectoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterWorkspaceDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterWorkspaceDirectory`](crate::operation::DeregisterWorkspaceDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterWorkspaceDirectory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterWorkspaceDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterWorkspaceDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterWorkspaceDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DeregisterWorkspaceDirectory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_workspace_directory(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterWorkspaceDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterWorkspaceDirectory",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterWorkspaceDirectoryInput`](crate::input::DeregisterWorkspaceDirectoryInput)
    pub fn builder() -> crate::input::deregister_workspace_directory_input::Builder {
        crate::input::deregister_workspace_directory_input::Builder::default()
    }
}

/// See [`DescribeAccountInput`](crate::input::DescribeAccountInput)
pub mod describe_account_input {
    /// A builder for [`DescribeAccountInput`](crate::input::DescribeAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeAccountInput`](crate::input::DescribeAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountInputOperationOutputAlias = crate::operation::DescribeAccount;
#[doc(hidden)]
pub type DescribeAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccountInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccount`](crate::operation::DescribeAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_account(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccount",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountInput`](crate::input::DescribeAccountInput)
    pub fn builder() -> crate::input::describe_account_input::Builder {
        crate::input::describe_account_input::Builder::default()
    }
}

/// See [`DescribeAccountModificationsInput`](crate::input::DescribeAccountModificationsInput)
pub mod describe_account_modifications_input {
    /// A builder for [`DescribeAccountModificationsInput`](crate::input::DescribeAccountModificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountModificationsInput`](crate::input::DescribeAccountModificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountModificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountModificationsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountModificationsInputOperationOutputAlias =
    crate::operation::DescribeAccountModifications;
#[doc(hidden)]
pub type DescribeAccountModificationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccountModificationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountModifications`](crate::operation::DescribeAccountModifications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountModifications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountModificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountModificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountModificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeAccountModifications",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_account_modifications(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountModifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountModifications",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountModificationsInput`](crate::input::DescribeAccountModificationsInput)
    pub fn builder() -> crate::input::describe_account_modifications_input::Builder {
        crate::input::describe_account_modifications_input::Builder::default()
    }
}

/// See [`DescribeClientPropertiesInput`](crate::input::DescribeClientPropertiesInput)
pub mod describe_client_properties_input {
    /// A builder for [`DescribeClientPropertiesInput`](crate::input::DescribeClientPropertiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The resource identifier, in the form of directory IDs.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input.into());
            self.resource_ids = Some(v);
            self
        }
        /// <p>The resource identifier, in the form of directory IDs.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClientPropertiesInput`](crate::input::DescribeClientPropertiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClientPropertiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClientPropertiesInput {
                resource_ids: self.resource_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClientPropertiesInputOperationOutputAlias =
    crate::operation::DescribeClientProperties;
#[doc(hidden)]
pub type DescribeClientPropertiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClientPropertiesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClientProperties`](crate::operation::DescribeClientProperties)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClientProperties,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClientPropertiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClientPropertiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClientPropertiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeClientProperties",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_client_properties(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClientProperties::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClientProperties",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClientPropertiesInput`](crate::input::DescribeClientPropertiesInput)
    pub fn builder() -> crate::input::describe_client_properties_input::Builder {
        crate::input::describe_client_properties_input::Builder::default()
    }
}

/// See [`DescribeConnectionAliasesInput`](crate::input::DescribeConnectionAliasesInput)
pub mod describe_connection_aliases_input {
    /// A builder for [`DescribeConnectionAliasesInput`](crate::input::DescribeConnectionAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `alias_ids`.
        ///
        /// To override the contents of this collection use [`set_alias_ids`](Self::set_alias_ids).
        ///
        /// <p>The identifiers of the connection aliases to describe.</p>
        pub fn alias_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.alias_ids.unwrap_or_default();
            v.push(input.into());
            self.alias_ids = Some(v);
            self
        }
        /// <p>The identifiers of the connection aliases to describe.</p>
        pub fn set_alias_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.alias_ids = input;
            self
        }
        /// <p>The identifier of the directory associated with the connection alias.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory associated with the connection alias.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The maximum number of connection aliases to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of connection aliases to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the
        /// next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the
        /// next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionAliasesInput`](crate::input::DescribeConnectionAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectionAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectionAliasesInput {
                alias_ids: self.alias_ids,
                resource_id: self.resource_id,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectionAliasesInputOperationOutputAlias =
    crate::operation::DescribeConnectionAliases;
#[doc(hidden)]
pub type DescribeConnectionAliasesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeConnectionAliasesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnectionAliases`](crate::operation::DescribeConnectionAliases)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnectionAliases,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectionAliasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectionAliasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectionAliasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeConnectionAliases",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_connection_aliases(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnectionAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnectionAliases",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectionAliasesInput`](crate::input::DescribeConnectionAliasesInput)
    pub fn builder() -> crate::input::describe_connection_aliases_input::Builder {
        crate::input::describe_connection_aliases_input::Builder::default()
    }
}

/// See [`DescribeConnectionAliasPermissionsInput`](crate::input::DescribeConnectionAliasPermissionsInput)
pub mod describe_connection_alias_permissions_input {
    /// A builder for [`DescribeConnectionAliasPermissionsInput`](crate::input::DescribeConnectionAliasPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the connection alias.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the
        /// next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the
        /// next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionAliasPermissionsInput`](crate::input::DescribeConnectionAliasPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectionAliasPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectionAliasPermissionsInput {
                alias_id: self.alias_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectionAliasPermissionsInputOperationOutputAlias =
    crate::operation::DescribeConnectionAliasPermissions;
#[doc(hidden)]
pub type DescribeConnectionAliasPermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeConnectionAliasPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnectionAliasPermissions`](crate::operation::DescribeConnectionAliasPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnectionAliasPermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectionAliasPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectionAliasPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectionAliasPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeConnectionAliasPermissions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_connection_alias_permissions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnectionAliasPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnectionAliasPermissions",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectionAliasPermissionsInput`](crate::input::DescribeConnectionAliasPermissionsInput)
    pub fn builder() -> crate::input::describe_connection_alias_permissions_input::Builder {
        crate::input::describe_connection_alias_permissions_input::Builder::default()
    }
}

/// See [`DescribeIpGroupsInput`](crate::input::DescribeIpGroupsInput)
pub mod describe_ip_groups_input {
    /// A builder for [`DescribeIpGroupsInput`](crate::input::DescribeIpGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `group_ids`.
        ///
        /// To override the contents of this collection use [`set_group_ids`](Self::set_group_ids).
        ///
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.group_ids.unwrap_or_default();
            v.push(input.into());
            self.group_ids = Some(v);
            self
        }
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn set_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.group_ids = input;
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIpGroupsInput`](crate::input::DescribeIpGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIpGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIpGroupsInput {
                group_ids: self.group_ids,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIpGroupsInputOperationOutputAlias = crate::operation::DescribeIpGroups;
#[doc(hidden)]
pub type DescribeIpGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeIpGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIpGroups`](crate::operation::DescribeIpGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIpGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIpGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIpGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIpGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeIpGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_ip_groups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIpGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIpGroups",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIpGroupsInput`](crate::input::DescribeIpGroupsInput)
    pub fn builder() -> crate::input::describe_ip_groups_input::Builder {
        crate::input::describe_ip_groups_input::Builder::default()
    }
}

/// See [`DescribeTagsInput`](crate::input::DescribeTagsInput)
pub mod describe_tags_input {
    /// A builder for [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
        /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
        /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsInput`](crate::input::DescribeTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTagsInput {
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTagsInputOperationOutputAlias = crate::operation::DescribeTags;
#[doc(hidden)]
pub type DescribeTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTagsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTags`](crate::operation::DescribeTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTags",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
}

/// See [`DescribeWorkspaceBundlesInput`](crate::input::DescribeWorkspaceBundlesInput)
pub mod describe_workspace_bundles_input {
    /// A builder for [`DescribeWorkspaceBundlesInput`](crate::input::DescribeWorkspaceBundlesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `bundle_ids`.
        ///
        /// To override the contents of this collection use [`set_bundle_ids`](Self::set_bundle_ids).
        ///
        /// <p>The identifiers of the bundles. You cannot combine this parameter with any other filter.</p>
        pub fn bundle_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.bundle_ids.unwrap_or_default();
            v.push(input.into());
            self.bundle_ids = Some(v);
            self
        }
        /// <p>The identifiers of the bundles. You cannot combine this parameter with any other filter.</p>
        pub fn set_bundle_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.bundle_ids = input;
            self
        }
        /// <p>The owner of the bundles. You cannot combine this parameter with any other filter.</p>
        /// <p>To describe the bundles provided by Amazon Web Services, specify <code>AMAZON</code>.
        /// To describe the bundles that belong to your account, don't specify a value.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the bundles. You cannot combine this parameter with any other filter.</p>
        /// <p>To describe the bundles provided by Amazon Web Services, specify <code>AMAZON</code>.
        /// To describe the bundles that belong to your account, don't specify a value.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The token for the next set of results. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspaceBundlesInput`](crate::input::DescribeWorkspaceBundlesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkspaceBundlesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkspaceBundlesInput {
                bundle_ids: self.bundle_ids,
                owner: self.owner,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkspaceBundlesInputOperationOutputAlias =
    crate::operation::DescribeWorkspaceBundles;
#[doc(hidden)]
pub type DescribeWorkspaceBundlesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkspaceBundlesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkspaceBundles`](crate::operation::DescribeWorkspaceBundles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkspaceBundles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkspaceBundlesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkspaceBundlesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkspaceBundlesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeWorkspaceBundles",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_workspace_bundles(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkspaceBundles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkspaceBundles",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceBundlesInput`](crate::input::DescribeWorkspaceBundlesInput)
    pub fn builder() -> crate::input::describe_workspace_bundles_input::Builder {
        crate::input::describe_workspace_bundles_input::Builder::default()
    }
}

/// See [`DescribeWorkspaceDirectoriesInput`](crate::input::DescribeWorkspaceDirectoriesInput)
pub mod describe_workspace_directories_input {
    /// A builder for [`DescribeWorkspaceDirectoriesInput`](crate::input::DescribeWorkspaceDirectoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `directory_ids`.
        ///
        /// To override the contents of this collection use [`set_directory_ids`](Self::set_directory_ids).
        ///
        /// <p>The identifiers of the directories. If the value is null, all directories are
        /// retrieved.</p>
        pub fn directory_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.directory_ids.unwrap_or_default();
            v.push(input.into());
            self.directory_ids = Some(v);
            self
        }
        /// <p>The identifiers of the directories. If the value is null, all directories are
        /// retrieved.</p>
        pub fn set_directory_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.directory_ids = input;
            self
        }
        /// <p>The maximum number of directories to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of directories to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspaceDirectoriesInput`](crate::input::DescribeWorkspaceDirectoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkspaceDirectoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkspaceDirectoriesInput {
                directory_ids: self.directory_ids,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkspaceDirectoriesInputOperationOutputAlias =
    crate::operation::DescribeWorkspaceDirectories;
#[doc(hidden)]
pub type DescribeWorkspaceDirectoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkspaceDirectoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkspaceDirectories`](crate::operation::DescribeWorkspaceDirectories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkspaceDirectories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkspaceDirectoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkspaceDirectoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkspaceDirectoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeWorkspaceDirectories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_workspace_directories(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkspaceDirectories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkspaceDirectories",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceDirectoriesInput`](crate::input::DescribeWorkspaceDirectoriesInput)
    pub fn builder() -> crate::input::describe_workspace_directories_input::Builder {
        crate::input::describe_workspace_directories_input::Builder::default()
    }
}

/// See [`DescribeWorkspaceImagePermissionsInput`](crate::input::DescribeWorkspaceImagePermissionsInput)
pub mod describe_workspace_image_permissions_input {
    /// A builder for [`DescribeWorkspaceImagePermissionsInput`](crate::input::DescribeWorkspaceImagePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspaceImagePermissionsInput`](crate::input::DescribeWorkspaceImagePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkspaceImagePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkspaceImagePermissionsInput {
                image_id: self.image_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkspaceImagePermissionsInputOperationOutputAlias =
    crate::operation::DescribeWorkspaceImagePermissions;
#[doc(hidden)]
pub type DescribeWorkspaceImagePermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkspaceImagePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkspaceImagePermissions`](crate::operation::DescribeWorkspaceImagePermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkspaceImagePermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkspaceImagePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkspaceImagePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkspaceImagePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeWorkspaceImagePermissions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_workspace_image_permissions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkspaceImagePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkspaceImagePermissions",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceImagePermissionsInput`](crate::input::DescribeWorkspaceImagePermissionsInput)
    pub fn builder() -> crate::input::describe_workspace_image_permissions_input::Builder {
        crate::input::describe_workspace_image_permissions_input::Builder::default()
    }
}

/// See [`DescribeWorkspaceImagesInput`](crate::input::DescribeWorkspaceImagesInput)
pub mod describe_workspace_images_input {
    /// A builder for [`DescribeWorkspaceImagesInput`](crate::input::DescribeWorkspaceImagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) image_type: std::option::Option<crate::model::ImageType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `image_ids`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The identifier of the image.</p>
        pub fn image_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.image_ids.unwrap_or_default();
            v.push(input.into());
            self.image_ids = Some(v);
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.image_ids = input;
            self
        }
        /// <p>The type (owned or shared) of the image.</p>
        pub fn image_type(mut self, input: crate::model::ImageType) -> Self {
            self.image_type = Some(input);
            self
        }
        /// <p>The type (owned or shared) of the image.</p>
        pub fn set_image_type(
            mut self,
            input: std::option::Option<crate::model::ImageType>,
        ) -> Self {
            self.image_type = input;
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspaceImagesInput`](crate::input::DescribeWorkspaceImagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkspaceImagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkspaceImagesInput {
                image_ids: self.image_ids,
                image_type: self.image_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkspaceImagesInputOperationOutputAlias =
    crate::operation::DescribeWorkspaceImages;
#[doc(hidden)]
pub type DescribeWorkspaceImagesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkspaceImagesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkspaceImages`](crate::operation::DescribeWorkspaceImages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkspaceImages,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkspaceImagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkspaceImagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkspaceImagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeWorkspaceImages",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_workspace_images(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkspaceImages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkspaceImages",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceImagesInput`](crate::input::DescribeWorkspaceImagesInput)
    pub fn builder() -> crate::input::describe_workspace_images_input::Builder {
        crate::input::describe_workspace_images_input::Builder::default()
    }
}

/// See [`DescribeWorkspacesInput`](crate::input::DescribeWorkspacesInput)
pub mod describe_workspaces_input {
    /// A builder for [`DescribeWorkspacesInput`](crate::input::DescribeWorkspacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `workspace_ids`.
        ///
        /// To override the contents of this collection use [`set_workspace_ids`](Self::set_workspace_ids).
        ///
        /// <p>The identifiers of the WorkSpaces. You cannot combine this parameter with any other
        /// filter.</p>
        /// <p>Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier
        /// it returns is not immediately available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no information is returned.</p>
        pub fn workspace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.workspace_ids.unwrap_or_default();
            v.push(input.into());
            self.workspace_ids = Some(v);
            self
        }
        /// <p>The identifiers of the WorkSpaces. You cannot combine this parameter with any other
        /// filter.</p>
        /// <p>Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier
        /// it returns is not immediately available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no information is returned.</p>
        pub fn set_workspace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.workspace_ids = input;
            self
        }
        /// <p>The identifier of the directory. In addition, you can optionally specify a specific
        /// directory user (see <code>UserName</code>). You cannot combine this parameter with any
        /// other filter.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory. In addition, you can optionally specify a specific
        /// directory user (see <code>UserName</code>). You cannot combine this parameter with any
        /// other filter.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The name of the directory user. You must specify this parameter with
        /// <code>DirectoryId</code>.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the directory user. You must specify this parameter with
        /// <code>DirectoryId</code>.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The identifier of the bundle. All WorkSpaces that are created from this bundle are
        /// retrieved. You cannot combine this parameter with any other filter.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bundle. All WorkSpaces that are created from this bundle are
        /// retrieved. You cannot combine this parameter with any other filter.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspacesInput`](crate::input::DescribeWorkspacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkspacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkspacesInput {
                workspace_ids: self.workspace_ids,
                directory_id: self.directory_id,
                user_name: self.user_name,
                bundle_id: self.bundle_id,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkspacesInputOperationOutputAlias = crate::operation::DescribeWorkspaces;
#[doc(hidden)]
pub type DescribeWorkspacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkspacesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkspaces`](crate::operation::DescribeWorkspaces)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkspaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkspacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkspacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkspacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeWorkspaces",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_workspaces(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkspaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkspaces",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkspacesInput`](crate::input::DescribeWorkspacesInput)
    pub fn builder() -> crate::input::describe_workspaces_input::Builder {
        crate::input::describe_workspaces_input::Builder::default()
    }
}

/// See [`DescribeWorkspacesConnectionStatusInput`](crate::input::DescribeWorkspacesConnectionStatusInput)
pub mod describe_workspaces_connection_status_input {
    /// A builder for [`DescribeWorkspacesConnectionStatusInput`](crate::input::DescribeWorkspacesConnectionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `workspace_ids`.
        ///
        /// To override the contents of this collection use [`set_workspace_ids`](Self::set_workspace_ids).
        ///
        /// <p>The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.</p>
        pub fn workspace_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.workspace_ids.unwrap_or_default();
            v.push(input.into());
            self.workspace_ids = Some(v);
            self
        }
        /// <p>The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.</p>
        pub fn set_workspace_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.workspace_ids = input;
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspacesConnectionStatusInput`](crate::input::DescribeWorkspacesConnectionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkspacesConnectionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkspacesConnectionStatusInput {
                workspace_ids: self.workspace_ids,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkspacesConnectionStatusInputOperationOutputAlias =
    crate::operation::DescribeWorkspacesConnectionStatus;
#[doc(hidden)]
pub type DescribeWorkspacesConnectionStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkspacesConnectionStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkspacesConnectionStatus`](crate::operation::DescribeWorkspacesConnectionStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkspacesConnectionStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkspacesConnectionStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkspacesConnectionStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkspacesConnectionStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeWorkspacesConnectionStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_workspaces_connection_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkspacesConnectionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkspacesConnectionStatus",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkspacesConnectionStatusInput`](crate::input::DescribeWorkspacesConnectionStatusInput)
    pub fn builder() -> crate::input::describe_workspaces_connection_status_input::Builder {
        crate::input::describe_workspaces_connection_status_input::Builder::default()
    }
}

/// See [`DescribeWorkspaceSnapshotsInput`](crate::input::DescribeWorkspaceSnapshotsInput)
pub mod describe_workspace_snapshots_input {
    /// A builder for [`DescribeWorkspaceSnapshotsInput`](crate::input::DescribeWorkspaceSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspaceSnapshotsInput`](crate::input::DescribeWorkspaceSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkspaceSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkspaceSnapshotsInput {
                workspace_id: self.workspace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkspaceSnapshotsInputOperationOutputAlias =
    crate::operation::DescribeWorkspaceSnapshots;
#[doc(hidden)]
pub type DescribeWorkspaceSnapshotsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkspaceSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkspaceSnapshots`](crate::operation::DescribeWorkspaceSnapshots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkspaceSnapshots,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkspaceSnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkspaceSnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkspaceSnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DescribeWorkspaceSnapshots",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_workspace_snapshots(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkspaceSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkspaceSnapshots",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceSnapshotsInput`](crate::input::DescribeWorkspaceSnapshotsInput)
    pub fn builder() -> crate::input::describe_workspace_snapshots_input::Builder {
        crate::input::describe_workspace_snapshots_input::Builder::default()
    }
}

/// See [`DisassociateConnectionAliasInput`](crate::input::DisassociateConnectionAliasInput)
pub mod disassociate_connection_alias_input {
    /// A builder for [`DisassociateConnectionAliasInput`](crate::input::DisassociateConnectionAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the connection alias to disassociate.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the connection alias to disassociate.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateConnectionAliasInput`](crate::input::DisassociateConnectionAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateConnectionAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateConnectionAliasInput {
                alias_id: self.alias_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateConnectionAliasInputOperationOutputAlias =
    crate::operation::DisassociateConnectionAlias;
#[doc(hidden)]
pub type DisassociateConnectionAliasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateConnectionAliasInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateConnectionAlias`](crate::operation::DisassociateConnectionAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateConnectionAlias,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateConnectionAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateConnectionAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateConnectionAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DisassociateConnectionAlias",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_connection_alias(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateConnectionAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateConnectionAlias",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateConnectionAliasInput`](crate::input::DisassociateConnectionAliasInput)
    pub fn builder() -> crate::input::disassociate_connection_alias_input::Builder {
        crate::input::disassociate_connection_alias_input::Builder::default()
    }
}

/// See [`DisassociateIpGroupsInput`](crate::input::DisassociateIpGroupsInput)
pub mod disassociate_ip_groups_input {
    /// A builder for [`DisassociateIpGroupsInput`](crate::input::DisassociateIpGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Appends an item to `group_ids`.
        ///
        /// To override the contents of this collection use [`set_group_ids`](Self::set_group_ids).
        ///
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.group_ids.unwrap_or_default();
            v.push(input.into());
            self.group_ids = Some(v);
            self
        }
        /// <p>The identifiers of one or more IP access control groups.</p>
        pub fn set_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateIpGroupsInput`](crate::input::DisassociateIpGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateIpGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateIpGroupsInput {
                directory_id: self.directory_id,
                group_ids: self.group_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateIpGroupsInputOperationOutputAlias = crate::operation::DisassociateIpGroups;
#[doc(hidden)]
pub type DisassociateIpGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateIpGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateIpGroups`](crate::operation::DisassociateIpGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateIpGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateIpGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateIpGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateIpGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.DisassociateIpGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_ip_groups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateIpGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateIpGroups",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateIpGroupsInput`](crate::input::DisassociateIpGroupsInput)
    pub fn builder() -> crate::input::disassociate_ip_groups_input::Builder {
        crate::input::disassociate_ip_groups_input::Builder::default()
    }
}

/// See [`ImportWorkspaceImageInput`](crate::input::ImportWorkspaceImageInput)
pub mod import_workspace_image_input {
    /// A builder for [`ImportWorkspaceImageInput`](crate::input::ImportWorkspaceImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_image_id: std::option::Option<std::string::String>,
        pub(crate) ingestion_process:
            std::option::Option<crate::model::WorkspaceImageIngestionProcess>,
        pub(crate) image_name: std::option::Option<std::string::String>,
        pub(crate) image_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) applications: std::option::Option<std::vec::Vec<crate::model::Application>>,
    }
    impl Builder {
        /// <p>The identifier of the EC2 image.</p>
        pub fn ec2_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the EC2 image.</p>
        pub fn set_ec2_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ec2_image_id = input;
            self
        }
        /// <p>The ingestion process to be used when importing the image, depending on which protocol
        /// you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces Streaming Protocol
        /// (WSP). To use WSP, specify a value that ends in <code>_WSP</code>. To use PCoIP, specify a value
        /// that does not end in <code>_WSP</code>. </p>
        ///
        /// <p>For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify
        /// <code>BYOL_REGULAR</code> or <code>BYOL_REGULAR_WSP</code>, depending on the protocol.</p>
        pub fn ingestion_process(
            mut self,
            input: crate::model::WorkspaceImageIngestionProcess,
        ) -> Self {
            self.ingestion_process = Some(input);
            self
        }
        /// <p>The ingestion process to be used when importing the image, depending on which protocol
        /// you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces Streaming Protocol
        /// (WSP). To use WSP, specify a value that ends in <code>_WSP</code>. To use PCoIP, specify a value
        /// that does not end in <code>_WSP</code>. </p>
        ///
        /// <p>For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify
        /// <code>BYOL_REGULAR</code> or <code>BYOL_REGULAR_WSP</code>, depending on the protocol.</p>
        pub fn set_ingestion_process(
            mut self,
            input: std::option::Option<crate::model::WorkspaceImageIngestionProcess>,
        ) -> Self {
            self.ingestion_process = input;
            self
        }
        /// <p>The name of the WorkSpace image.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the WorkSpace image.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// <p>The description of the WorkSpace image.</p>
        pub fn image_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_description = Some(input.into());
            self
        }
        /// <p>The description of the WorkSpace image.</p>
        pub fn set_image_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10
        /// BYOL images. For more information about subscribing to Office for BYOL images, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">
        /// Bring Your Own Windows Desktop Licenses</a>.</p>
        ///
        /// <note>
        /// <p>Although this parameter is an array, only one item is allowed at this time.</p>
        /// </note>
        pub fn applications(mut self, input: impl Into<crate::model::Application>) -> Self {
            let mut v = self.applications.unwrap_or_default();
            v.push(input.into());
            self.applications = Some(v);
            self
        }
        /// <p>If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10
        /// BYOL images. For more information about subscribing to Office for BYOL images, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">
        /// Bring Your Own Windows Desktop Licenses</a>.</p>
        ///
        /// <note>
        /// <p>Although this parameter is an array, only one item is allowed at this time.</p>
        /// </note>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Application>>,
        ) -> Self {
            self.applications = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportWorkspaceImageInput`](crate::input::ImportWorkspaceImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportWorkspaceImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportWorkspaceImageInput {
                ec2_image_id: self.ec2_image_id,
                ingestion_process: self.ingestion_process,
                image_name: self.image_name,
                image_description: self.image_description,
                tags: self.tags,
                applications: self.applications,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportWorkspaceImageInputOperationOutputAlias = crate::operation::ImportWorkspaceImage;
#[doc(hidden)]
pub type ImportWorkspaceImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ImportWorkspaceImageInput {
    /// Consumes the builder and constructs an Operation<[`ImportWorkspaceImage`](crate::operation::ImportWorkspaceImage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportWorkspaceImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportWorkspaceImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportWorkspaceImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportWorkspaceImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.ImportWorkspaceImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_workspace_image(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportWorkspaceImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportWorkspaceImage",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportWorkspaceImageInput`](crate::input::ImportWorkspaceImageInput)
    pub fn builder() -> crate::input::import_workspace_image_input::Builder {
        crate::input::import_workspace_image_input::Builder::default()
    }
}

/// See [`ListAvailableManagementCidrRangesInput`](crate::input::ListAvailableManagementCidrRangesInput)
pub mod list_available_management_cidr_ranges_input {
    /// A builder for [`ListAvailableManagementCidrRangesInput`](crate::input::ListAvailableManagementCidrRangesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) management_cidr_range_constraint: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IP address range to search. Specify an IP address range that is compatible with your
        /// network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).</p>
        pub fn management_cidr_range_constraint(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.management_cidr_range_constraint = Some(input.into());
            self
        }
        /// <p>The IP address range to search. Specify an IP address range that is compatible with your
        /// network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).</p>
        pub fn set_management_cidr_range_constraint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.management_cidr_range_constraint = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
        /// provide this token to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAvailableManagementCidrRangesInput`](crate::input::ListAvailableManagementCidrRangesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAvailableManagementCidrRangesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAvailableManagementCidrRangesInput {
                management_cidr_range_constraint: self.management_cidr_range_constraint,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAvailableManagementCidrRangesInputOperationOutputAlias =
    crate::operation::ListAvailableManagementCidrRanges;
#[doc(hidden)]
pub type ListAvailableManagementCidrRangesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAvailableManagementCidrRangesInput {
    /// Consumes the builder and constructs an Operation<[`ListAvailableManagementCidrRanges`](crate::operation::ListAvailableManagementCidrRanges)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAvailableManagementCidrRanges,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAvailableManagementCidrRangesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAvailableManagementCidrRangesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAvailableManagementCidrRangesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.ListAvailableManagementCidrRanges",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_available_management_cidr_ranges(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAvailableManagementCidrRanges::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAvailableManagementCidrRanges",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAvailableManagementCidrRangesInput`](crate::input::ListAvailableManagementCidrRangesInput)
    pub fn builder() -> crate::input::list_available_management_cidr_ranges_input::Builder {
        crate::input::list_available_management_cidr_ranges_input::Builder::default()
    }
}

/// See [`MigrateWorkspaceInput`](crate::input::MigrateWorkspaceInput)
pub mod migrate_workspace_input {
    /// A builder for [`MigrateWorkspaceInput`](crate::input::MigrateWorkspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_workspace_id: std::option::Option<std::string::String>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace to migrate from.</p>
        pub fn source_workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace to migrate from.</p>
        pub fn set_source_workspace_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_workspace_id = input;
            self
        }
        /// <p>The identifier of the target bundle type to migrate the WorkSpace to.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The identifier of the target bundle type to migrate the WorkSpace to.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MigrateWorkspaceInput`](crate::input::MigrateWorkspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MigrateWorkspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MigrateWorkspaceInput {
                source_workspace_id: self.source_workspace_id,
                bundle_id: self.bundle_id,
            })
        }
    }
}
#[doc(hidden)]
pub type MigrateWorkspaceInputOperationOutputAlias = crate::operation::MigrateWorkspace;
#[doc(hidden)]
pub type MigrateWorkspaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl MigrateWorkspaceInput {
    /// Consumes the builder and constructs an Operation<[`MigrateWorkspace`](crate::operation::MigrateWorkspace)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MigrateWorkspace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MigrateWorkspaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MigrateWorkspaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MigrateWorkspaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.MigrateWorkspace",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_migrate_workspace(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MigrateWorkspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MigrateWorkspace",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MigrateWorkspaceInput`](crate::input::MigrateWorkspaceInput)
    pub fn builder() -> crate::input::migrate_workspace_input::Builder {
        crate::input::migrate_workspace_input::Builder::default()
    }
}

/// See [`ModifyAccountInput`](crate::input::ModifyAccountInput)
pub mod modify_account_input {
    /// A builder for [`ModifyAccountInput`](crate::input::ModifyAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dedicated_tenancy_support:
            std::option::Option<crate::model::DedicatedTenancySupportEnum>,
        pub(crate) dedicated_tenancy_management_cidr_range:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of BYOL.</p>
        pub fn dedicated_tenancy_support(
            mut self,
            input: crate::model::DedicatedTenancySupportEnum,
        ) -> Self {
            self.dedicated_tenancy_support = Some(input);
            self
        }
        /// <p>The status of BYOL.</p>
        pub fn set_dedicated_tenancy_support(
            mut self,
            input: std::option::Option<crate::model::DedicatedTenancySupportEnum>,
        ) -> Self {
            self.dedicated_tenancy_support = input;
            self
        }
        /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network
        /// interface. Specify an IP address range that is compatible with your network and in CIDR
        /// notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be
        /// /16 (for example, 203.0.113.25/16). It must also be specified as available by the
        /// <code>ListAvailableManagementCidrRanges</code> operation.</p>
        pub fn dedicated_tenancy_management_cidr_range(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.dedicated_tenancy_management_cidr_range = Some(input.into());
            self
        }
        /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network
        /// interface. Specify an IP address range that is compatible with your network and in CIDR
        /// notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be
        /// /16 (for example, 203.0.113.25/16). It must also be specified as available by the
        /// <code>ListAvailableManagementCidrRanges</code> operation.</p>
        pub fn set_dedicated_tenancy_management_cidr_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dedicated_tenancy_management_cidr_range = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyAccountInput`](crate::input::ModifyAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyAccountInput {
                dedicated_tenancy_support: self.dedicated_tenancy_support,
                dedicated_tenancy_management_cidr_range: self
                    .dedicated_tenancy_management_cidr_range,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyAccountInputOperationOutputAlias = crate::operation::ModifyAccount;
#[doc(hidden)]
pub type ModifyAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyAccountInput {
    /// Consumes the builder and constructs an Operation<[`ModifyAccount`](crate::operation::ModifyAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.ModifyAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_modify_account(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyAccount",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyAccountInput`](crate::input::ModifyAccountInput)
    pub fn builder() -> crate::input::modify_account_input::Builder {
        crate::input::modify_account_input::Builder::default()
    }
}

/// See [`ModifyClientPropertiesInput`](crate::input::ModifyClientPropertiesInput)
pub mod modify_client_properties_input {
    /// A builder for [`ModifyClientPropertiesInput`](crate::input::ModifyClientPropertiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) client_properties: std::option::Option<crate::model::ClientProperties>,
    }
    impl Builder {
        /// <p>The resource identifiers, in the form of directory IDs.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource identifiers, in the form of directory IDs.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Information about the Amazon WorkSpaces client.</p>
        pub fn client_properties(mut self, input: crate::model::ClientProperties) -> Self {
            self.client_properties = Some(input);
            self
        }
        /// <p>Information about the Amazon WorkSpaces client.</p>
        pub fn set_client_properties(
            mut self,
            input: std::option::Option<crate::model::ClientProperties>,
        ) -> Self {
            self.client_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClientPropertiesInput`](crate::input::ModifyClientPropertiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyClientPropertiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyClientPropertiesInput {
                resource_id: self.resource_id,
                client_properties: self.client_properties,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyClientPropertiesInputOperationOutputAlias = crate::operation::ModifyClientProperties;
#[doc(hidden)]
pub type ModifyClientPropertiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyClientPropertiesInput {
    /// Consumes the builder and constructs an Operation<[`ModifyClientProperties`](crate::operation::ModifyClientProperties)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyClientProperties,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyClientPropertiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyClientPropertiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyClientPropertiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.ModifyClientProperties",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_client_properties(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyClientProperties::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyClientProperties",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyClientPropertiesInput`](crate::input::ModifyClientPropertiesInput)
    pub fn builder() -> crate::input::modify_client_properties_input::Builder {
        crate::input::modify_client_properties_input::Builder::default()
    }
}

/// See [`ModifySelfservicePermissionsInput`](crate::input::ModifySelfservicePermissionsInput)
pub mod modify_selfservice_permissions_input {
    /// A builder for [`ModifySelfservicePermissionsInput`](crate::input::ModifySelfservicePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) selfservice_permissions:
            std::option::Option<crate::model::SelfservicePermissions>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The permissions to enable or disable self-service capabilities.</p>
        pub fn selfservice_permissions(
            mut self,
            input: crate::model::SelfservicePermissions,
        ) -> Self {
            self.selfservice_permissions = Some(input);
            self
        }
        /// <p>The permissions to enable or disable self-service capabilities.</p>
        pub fn set_selfservice_permissions(
            mut self,
            input: std::option::Option<crate::model::SelfservicePermissions>,
        ) -> Self {
            self.selfservice_permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifySelfservicePermissionsInput`](crate::input::ModifySelfservicePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifySelfservicePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifySelfservicePermissionsInput {
                resource_id: self.resource_id,
                selfservice_permissions: self.selfservice_permissions,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifySelfservicePermissionsInputOperationOutputAlias =
    crate::operation::ModifySelfservicePermissions;
#[doc(hidden)]
pub type ModifySelfservicePermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifySelfservicePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`ModifySelfservicePermissions`](crate::operation::ModifySelfservicePermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifySelfservicePermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifySelfservicePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifySelfservicePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifySelfservicePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.ModifySelfservicePermissions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_selfservice_permissions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifySelfservicePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifySelfservicePermissions",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifySelfservicePermissionsInput`](crate::input::ModifySelfservicePermissionsInput)
    pub fn builder() -> crate::input::modify_selfservice_permissions_input::Builder {
        crate::input::modify_selfservice_permissions_input::Builder::default()
    }
}

/// See [`ModifyWorkspaceAccessPropertiesInput`](crate::input::ModifyWorkspaceAccessPropertiesInput)
pub mod modify_workspace_access_properties_input {
    /// A builder for [`ModifyWorkspaceAccessPropertiesInput`](crate::input::ModifyWorkspaceAccessPropertiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) workspace_access_properties:
            std::option::Option<crate::model::WorkspaceAccessProperties>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The device types and operating systems to enable or disable for access.</p>
        pub fn workspace_access_properties(
            mut self,
            input: crate::model::WorkspaceAccessProperties,
        ) -> Self {
            self.workspace_access_properties = Some(input);
            self
        }
        /// <p>The device types and operating systems to enable or disable for access.</p>
        pub fn set_workspace_access_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceAccessProperties>,
        ) -> Self {
            self.workspace_access_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyWorkspaceAccessPropertiesInput`](crate::input::ModifyWorkspaceAccessPropertiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyWorkspaceAccessPropertiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyWorkspaceAccessPropertiesInput {
                resource_id: self.resource_id,
                workspace_access_properties: self.workspace_access_properties,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyWorkspaceAccessPropertiesInputOperationOutputAlias =
    crate::operation::ModifyWorkspaceAccessProperties;
#[doc(hidden)]
pub type ModifyWorkspaceAccessPropertiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyWorkspaceAccessPropertiesInput {
    /// Consumes the builder and constructs an Operation<[`ModifyWorkspaceAccessProperties`](crate::operation::ModifyWorkspaceAccessProperties)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyWorkspaceAccessProperties,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyWorkspaceAccessPropertiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyWorkspaceAccessPropertiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyWorkspaceAccessPropertiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.ModifyWorkspaceAccessProperties",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_workspace_access_properties(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyWorkspaceAccessProperties::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyWorkspaceAccessProperties",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyWorkspaceAccessPropertiesInput`](crate::input::ModifyWorkspaceAccessPropertiesInput)
    pub fn builder() -> crate::input::modify_workspace_access_properties_input::Builder {
        crate::input::modify_workspace_access_properties_input::Builder::default()
    }
}

/// See [`ModifyWorkspaceCreationPropertiesInput`](crate::input::ModifyWorkspaceCreationPropertiesInput)
pub mod modify_workspace_creation_properties_input {
    /// A builder for [`ModifyWorkspaceCreationPropertiesInput`](crate::input::ModifyWorkspaceCreationPropertiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) workspace_creation_properties:
            std::option::Option<crate::model::WorkspaceCreationProperties>,
    }
    impl Builder {
        /// <p>The identifier of the directory.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The default properties for creating WorkSpaces.</p>
        pub fn workspace_creation_properties(
            mut self,
            input: crate::model::WorkspaceCreationProperties,
        ) -> Self {
            self.workspace_creation_properties = Some(input);
            self
        }
        /// <p>The default properties for creating WorkSpaces.</p>
        pub fn set_workspace_creation_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceCreationProperties>,
        ) -> Self {
            self.workspace_creation_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyWorkspaceCreationPropertiesInput`](crate::input::ModifyWorkspaceCreationPropertiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyWorkspaceCreationPropertiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyWorkspaceCreationPropertiesInput {
                resource_id: self.resource_id,
                workspace_creation_properties: self.workspace_creation_properties,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyWorkspaceCreationPropertiesInputOperationOutputAlias =
    crate::operation::ModifyWorkspaceCreationProperties;
#[doc(hidden)]
pub type ModifyWorkspaceCreationPropertiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyWorkspaceCreationPropertiesInput {
    /// Consumes the builder and constructs an Operation<[`ModifyWorkspaceCreationProperties`](crate::operation::ModifyWorkspaceCreationProperties)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyWorkspaceCreationProperties,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyWorkspaceCreationPropertiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyWorkspaceCreationPropertiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyWorkspaceCreationPropertiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.ModifyWorkspaceCreationProperties",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_workspace_creation_properties(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyWorkspaceCreationProperties::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyWorkspaceCreationProperties",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyWorkspaceCreationPropertiesInput`](crate::input::ModifyWorkspaceCreationPropertiesInput)
    pub fn builder() -> crate::input::modify_workspace_creation_properties_input::Builder {
        crate::input::modify_workspace_creation_properties_input::Builder::default()
    }
}

/// See [`ModifyWorkspacePropertiesInput`](crate::input::ModifyWorkspacePropertiesInput)
pub mod modify_workspace_properties_input {
    /// A builder for [`ModifyWorkspacePropertiesInput`](crate::input::ModifyWorkspacePropertiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) workspace_properties: std::option::Option<crate::model::WorkspaceProperties>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The properties of the WorkSpace.</p>
        pub fn workspace_properties(mut self, input: crate::model::WorkspaceProperties) -> Self {
            self.workspace_properties = Some(input);
            self
        }
        /// <p>The properties of the WorkSpace.</p>
        pub fn set_workspace_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceProperties>,
        ) -> Self {
            self.workspace_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyWorkspacePropertiesInput`](crate::input::ModifyWorkspacePropertiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyWorkspacePropertiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyWorkspacePropertiesInput {
                workspace_id: self.workspace_id,
                workspace_properties: self.workspace_properties,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyWorkspacePropertiesInputOperationOutputAlias =
    crate::operation::ModifyWorkspaceProperties;
#[doc(hidden)]
pub type ModifyWorkspacePropertiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyWorkspacePropertiesInput {
    /// Consumes the builder and constructs an Operation<[`ModifyWorkspaceProperties`](crate::operation::ModifyWorkspaceProperties)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyWorkspaceProperties,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyWorkspacePropertiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyWorkspacePropertiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyWorkspacePropertiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.ModifyWorkspaceProperties",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_workspace_properties(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyWorkspaceProperties::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyWorkspaceProperties",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyWorkspacePropertiesInput`](crate::input::ModifyWorkspacePropertiesInput)
    pub fn builder() -> crate::input::modify_workspace_properties_input::Builder {
        crate::input::modify_workspace_properties_input::Builder::default()
    }
}

/// See [`ModifyWorkspaceStateInput`](crate::input::ModifyWorkspaceStateInput)
pub mod modify_workspace_state_input {
    /// A builder for [`ModifyWorkspaceStateInput`](crate::input::ModifyWorkspaceStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) workspace_state: std::option::Option<crate::model::TargetWorkspaceState>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The WorkSpace state.</p>
        pub fn workspace_state(mut self, input: crate::model::TargetWorkspaceState) -> Self {
            self.workspace_state = Some(input);
            self
        }
        /// <p>The WorkSpace state.</p>
        pub fn set_workspace_state(
            mut self,
            input: std::option::Option<crate::model::TargetWorkspaceState>,
        ) -> Self {
            self.workspace_state = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyWorkspaceStateInput`](crate::input::ModifyWorkspaceStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyWorkspaceStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyWorkspaceStateInput {
                workspace_id: self.workspace_id,
                workspace_state: self.workspace_state,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyWorkspaceStateInputOperationOutputAlias = crate::operation::ModifyWorkspaceState;
#[doc(hidden)]
pub type ModifyWorkspaceStateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyWorkspaceStateInput {
    /// Consumes the builder and constructs an Operation<[`ModifyWorkspaceState`](crate::operation::ModifyWorkspaceState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyWorkspaceState,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyWorkspaceStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyWorkspaceStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyWorkspaceStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.ModifyWorkspaceState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_workspace_state(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyWorkspaceState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyWorkspaceState",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyWorkspaceStateInput`](crate::input::ModifyWorkspaceStateInput)
    pub fn builder() -> crate::input::modify_workspace_state_input::Builder {
        crate::input::modify_workspace_state_input::Builder::default()
    }
}

/// See [`RebootWorkspacesInput`](crate::input::RebootWorkspacesInput)
pub mod reboot_workspaces_input {
    /// A builder for [`RebootWorkspacesInput`](crate::input::RebootWorkspacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reboot_workspace_requests:
            std::option::Option<std::vec::Vec<crate::model::RebootRequest>>,
    }
    impl Builder {
        /// Appends an item to `reboot_workspace_requests`.
        ///
        /// To override the contents of this collection use [`set_reboot_workspace_requests`](Self::set_reboot_workspace_requests).
        ///
        /// <p>The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.</p>
        pub fn reboot_workspace_requests(
            mut self,
            input: impl Into<crate::model::RebootRequest>,
        ) -> Self {
            let mut v = self.reboot_workspace_requests.unwrap_or_default();
            v.push(input.into());
            self.reboot_workspace_requests = Some(v);
            self
        }
        /// <p>The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.</p>
        pub fn set_reboot_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RebootRequest>>,
        ) -> Self {
            self.reboot_workspace_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootWorkspacesInput`](crate::input::RebootWorkspacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebootWorkspacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebootWorkspacesInput {
                reboot_workspace_requests: self.reboot_workspace_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type RebootWorkspacesInputOperationOutputAlias = crate::operation::RebootWorkspaces;
#[doc(hidden)]
pub type RebootWorkspacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RebootWorkspacesInput {
    /// Consumes the builder and constructs an Operation<[`RebootWorkspaces`](crate::operation::RebootWorkspaces)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebootWorkspaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RebootWorkspacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RebootWorkspacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RebootWorkspacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.RebootWorkspaces",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reboot_workspaces(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebootWorkspaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebootWorkspaces",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RebootWorkspacesInput`](crate::input::RebootWorkspacesInput)
    pub fn builder() -> crate::input::reboot_workspaces_input::Builder {
        crate::input::reboot_workspaces_input::Builder::default()
    }
}

/// See [`RebuildWorkspacesInput`](crate::input::RebuildWorkspacesInput)
pub mod rebuild_workspaces_input {
    /// A builder for [`RebuildWorkspacesInput`](crate::input::RebuildWorkspacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rebuild_workspace_requests:
            std::option::Option<std::vec::Vec<crate::model::RebuildRequest>>,
    }
    impl Builder {
        /// Appends an item to `rebuild_workspace_requests`.
        ///
        /// To override the contents of this collection use [`set_rebuild_workspace_requests`](Self::set_rebuild_workspace_requests).
        ///
        /// <p>The WorkSpace to rebuild. You can specify a single WorkSpace.</p>
        pub fn rebuild_workspace_requests(
            mut self,
            input: impl Into<crate::model::RebuildRequest>,
        ) -> Self {
            let mut v = self.rebuild_workspace_requests.unwrap_or_default();
            v.push(input.into());
            self.rebuild_workspace_requests = Some(v);
            self
        }
        /// <p>The WorkSpace to rebuild. You can specify a single WorkSpace.</p>
        pub fn set_rebuild_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RebuildRequest>>,
        ) -> Self {
            self.rebuild_workspace_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`RebuildWorkspacesInput`](crate::input::RebuildWorkspacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebuildWorkspacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebuildWorkspacesInput {
                rebuild_workspace_requests: self.rebuild_workspace_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type RebuildWorkspacesInputOperationOutputAlias = crate::operation::RebuildWorkspaces;
#[doc(hidden)]
pub type RebuildWorkspacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RebuildWorkspacesInput {
    /// Consumes the builder and constructs an Operation<[`RebuildWorkspaces`](crate::operation::RebuildWorkspaces)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebuildWorkspaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RebuildWorkspacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RebuildWorkspacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RebuildWorkspacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.RebuildWorkspaces",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_rebuild_workspaces(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebuildWorkspaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebuildWorkspaces",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RebuildWorkspacesInput`](crate::input::RebuildWorkspacesInput)
    pub fn builder() -> crate::input::rebuild_workspaces_input::Builder {
        crate::input::rebuild_workspaces_input::Builder::default()
    }
}

/// See [`RegisterWorkspaceDirectoryInput`](crate::input::RegisterWorkspaceDirectoryInput)
pub mod register_workspace_directory_input {
    /// A builder for [`RegisterWorkspaceDirectoryInput`](crate::input::RegisterWorkspaceDirectoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enable_work_docs: std::option::Option<bool>,
        pub(crate) enable_self_service: std::option::Option<bool>,
        pub(crate) tenancy: std::option::Option<crate::model::Tenancy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the directory. You cannot register a directory if it does not have a status
        /// of Active. If the directory does not have a status of Active, you will receive an
        /// InvalidResourceStateException error. If you have already registered the maximum number of directories
        /// that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error.
        /// Deregister directories that you are not using for WorkSpaces, and try again.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory. You cannot register a directory if it does not have a status
        /// of Active. If the directory does not have a status of Active, you will receive an
        /// InvalidResourceStateException error. If you have already registered the maximum number of directories
        /// that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error.
        /// Deregister directories that you are not using for WorkSpaces, and try again.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets
        /// are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these
        /// conditions are not met, you will receive an OperationNotSupportedException error.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets
        /// are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these
        /// conditions are not met, you will receive an OperationNotSupportedException error.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and
        /// WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set
        /// <code>EnableWorkDocs</code> to disabled, and try again.</p>
        pub fn enable_work_docs(mut self, input: bool) -> Self {
            self.enable_work_docs = Some(input);
            self
        }
        /// <p>Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and
        /// WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set
        /// <code>EnableWorkDocs</code> to disabled, and try again.</p>
        pub fn set_enable_work_docs(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_work_docs = input;
            self
        }
        /// <p>Indicates whether self-service capabilities are enabled or disabled.</p>
        pub fn enable_self_service(mut self, input: bool) -> Self {
            self.enable_self_service = Some(input);
            self
        }
        /// <p>Indicates whether self-service capabilities are enabled or disabled.</p>
        pub fn set_enable_self_service(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_self_service = input;
            self
        }
        /// <p>Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own
        /// License (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be
        /// enabled for BYOL. If your account has not been enabled for BYOL, you will receive an
        /// InvalidParameterValuesException error. For more information about BYOL images, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>
        pub fn tenancy(mut self, input: crate::model::Tenancy) -> Self {
            self.tenancy = Some(input);
            self
        }
        /// <p>Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own
        /// License (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be
        /// enabled for BYOL. If your account has not been enabled for BYOL, you will receive an
        /// InvalidParameterValuesException error. For more information about BYOL images, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>
        pub fn set_tenancy(mut self, input: std::option::Option<crate::model::Tenancy>) -> Self {
            self.tenancy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the directory.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the directory.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterWorkspaceDirectoryInput`](crate::input::RegisterWorkspaceDirectoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterWorkspaceDirectoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterWorkspaceDirectoryInput {
                directory_id: self.directory_id,
                subnet_ids: self.subnet_ids,
                enable_work_docs: self.enable_work_docs,
                enable_self_service: self.enable_self_service,
                tenancy: self.tenancy,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterWorkspaceDirectoryInputOperationOutputAlias =
    crate::operation::RegisterWorkspaceDirectory;
#[doc(hidden)]
pub type RegisterWorkspaceDirectoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterWorkspaceDirectoryInput {
    /// Consumes the builder and constructs an Operation<[`RegisterWorkspaceDirectory`](crate::operation::RegisterWorkspaceDirectory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterWorkspaceDirectory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterWorkspaceDirectoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterWorkspaceDirectoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterWorkspaceDirectoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.RegisterWorkspaceDirectory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_workspace_directory(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterWorkspaceDirectory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterWorkspaceDirectory",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterWorkspaceDirectoryInput`](crate::input::RegisterWorkspaceDirectoryInput)
    pub fn builder() -> crate::input::register_workspace_directory_input::Builder {
        crate::input::register_workspace_directory_input::Builder::default()
    }
}

/// See [`RestoreWorkspaceInput`](crate::input::RestoreWorkspaceInput)
pub mod restore_workspace_input {
    /// A builder for [`RestoreWorkspaceInput`](crate::input::RestoreWorkspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreWorkspaceInput`](crate::input::RestoreWorkspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreWorkspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreWorkspaceInput {
                workspace_id: self.workspace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreWorkspaceInputOperationOutputAlias = crate::operation::RestoreWorkspace;
#[doc(hidden)]
pub type RestoreWorkspaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RestoreWorkspaceInput {
    /// Consumes the builder and constructs an Operation<[`RestoreWorkspace`](crate::operation::RestoreWorkspace)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreWorkspace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestoreWorkspaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestoreWorkspaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestoreWorkspaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.RestoreWorkspace",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_restore_workspace(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreWorkspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreWorkspace",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestoreWorkspaceInput`](crate::input::RestoreWorkspaceInput)
    pub fn builder() -> crate::input::restore_workspace_input::Builder {
        crate::input::restore_workspace_input::Builder::default()
    }
}

/// See [`RevokeIpRulesInput`](crate::input::RevokeIpRulesInput)
pub mod revoke_ip_rules_input {
    /// A builder for [`RevokeIpRulesInput`](crate::input::RevokeIpRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) user_rules: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Appends an item to `user_rules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>The rules to remove from the group.</p>
        pub fn user_rules(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_rules.unwrap_or_default();
            v.push(input.into());
            self.user_rules = Some(v);
            self
        }
        /// <p>The rules to remove from the group.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeIpRulesInput`](crate::input::RevokeIpRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RevokeIpRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RevokeIpRulesInput {
                group_id: self.group_id,
                user_rules: self.user_rules,
            })
        }
    }
}
#[doc(hidden)]
pub type RevokeIpRulesInputOperationOutputAlias = crate::operation::RevokeIpRules;
#[doc(hidden)]
pub type RevokeIpRulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RevokeIpRulesInput {
    /// Consumes the builder and constructs an Operation<[`RevokeIpRules`](crate::operation::RevokeIpRules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RevokeIpRules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RevokeIpRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RevokeIpRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RevokeIpRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.RevokeIpRules",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_revoke_ip_rules(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RevokeIpRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RevokeIpRules",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RevokeIpRulesInput`](crate::input::RevokeIpRulesInput)
    pub fn builder() -> crate::input::revoke_ip_rules_input::Builder {
        crate::input::revoke_ip_rules_input::Builder::default()
    }
}

/// See [`StartWorkspacesInput`](crate::input::StartWorkspacesInput)
pub mod start_workspaces_input {
    /// A builder for [`StartWorkspacesInput`](crate::input::StartWorkspacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_workspace_requests:
            std::option::Option<std::vec::Vec<crate::model::StartRequest>>,
    }
    impl Builder {
        /// Appends an item to `start_workspace_requests`.
        ///
        /// To override the contents of this collection use [`set_start_workspace_requests`](Self::set_start_workspace_requests).
        ///
        /// <p>The WorkSpaces to start. You can specify up to 25 WorkSpaces.</p>
        pub fn start_workspace_requests(
            mut self,
            input: impl Into<crate::model::StartRequest>,
        ) -> Self {
            let mut v = self.start_workspace_requests.unwrap_or_default();
            v.push(input.into());
            self.start_workspace_requests = Some(v);
            self
        }
        /// <p>The WorkSpaces to start. You can specify up to 25 WorkSpaces.</p>
        pub fn set_start_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StartRequest>>,
        ) -> Self {
            self.start_workspace_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`StartWorkspacesInput`](crate::input::StartWorkspacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartWorkspacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartWorkspacesInput {
                start_workspace_requests: self.start_workspace_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type StartWorkspacesInputOperationOutputAlias = crate::operation::StartWorkspaces;
#[doc(hidden)]
pub type StartWorkspacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartWorkspacesInput {
    /// Consumes the builder and constructs an Operation<[`StartWorkspaces`](crate::operation::StartWorkspaces)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartWorkspaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartWorkspacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartWorkspacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartWorkspacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.StartWorkspaces",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_workspaces(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartWorkspaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartWorkspaces",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartWorkspacesInput`](crate::input::StartWorkspacesInput)
    pub fn builder() -> crate::input::start_workspaces_input::Builder {
        crate::input::start_workspaces_input::Builder::default()
    }
}

/// See [`StopWorkspacesInput`](crate::input::StopWorkspacesInput)
pub mod stop_workspaces_input {
    /// A builder for [`StopWorkspacesInput`](crate::input::StopWorkspacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stop_workspace_requests:
            std::option::Option<std::vec::Vec<crate::model::StopRequest>>,
    }
    impl Builder {
        /// Appends an item to `stop_workspace_requests`.
        ///
        /// To override the contents of this collection use [`set_stop_workspace_requests`](Self::set_stop_workspace_requests).
        ///
        /// <p>The WorkSpaces to stop. You can specify up to 25 WorkSpaces.</p>
        pub fn stop_workspace_requests(
            mut self,
            input: impl Into<crate::model::StopRequest>,
        ) -> Self {
            let mut v = self.stop_workspace_requests.unwrap_or_default();
            v.push(input.into());
            self.stop_workspace_requests = Some(v);
            self
        }
        /// <p>The WorkSpaces to stop. You can specify up to 25 WorkSpaces.</p>
        pub fn set_stop_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StopRequest>>,
        ) -> Self {
            self.stop_workspace_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`StopWorkspacesInput`](crate::input::StopWorkspacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopWorkspacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopWorkspacesInput {
                stop_workspace_requests: self.stop_workspace_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type StopWorkspacesInputOperationOutputAlias = crate::operation::StopWorkspaces;
#[doc(hidden)]
pub type StopWorkspacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopWorkspacesInput {
    /// Consumes the builder and constructs an Operation<[`StopWorkspaces`](crate::operation::StopWorkspaces)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopWorkspaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopWorkspacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopWorkspacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopWorkspacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.StopWorkspaces",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_workspaces(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopWorkspaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopWorkspaces",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopWorkspacesInput`](crate::input::StopWorkspacesInput)
    pub fn builder() -> crate::input::stop_workspaces_input::Builder {
        crate::input::stop_workspaces_input::Builder::default()
    }
}

/// See [`TerminateWorkspacesInput`](crate::input::TerminateWorkspacesInput)
pub mod terminate_workspaces_input {
    /// A builder for [`TerminateWorkspacesInput`](crate::input::TerminateWorkspacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) terminate_workspace_requests:
            std::option::Option<std::vec::Vec<crate::model::TerminateRequest>>,
    }
    impl Builder {
        /// Appends an item to `terminate_workspace_requests`.
        ///
        /// To override the contents of this collection use [`set_terminate_workspace_requests`](Self::set_terminate_workspace_requests).
        ///
        /// <p>The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.</p>
        pub fn terminate_workspace_requests(
            mut self,
            input: impl Into<crate::model::TerminateRequest>,
        ) -> Self {
            let mut v = self.terminate_workspace_requests.unwrap_or_default();
            v.push(input.into());
            self.terminate_workspace_requests = Some(v);
            self
        }
        /// <p>The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.</p>
        pub fn set_terminate_workspace_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TerminateRequest>>,
        ) -> Self {
            self.terminate_workspace_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateWorkspacesInput`](crate::input::TerminateWorkspacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TerminateWorkspacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TerminateWorkspacesInput {
                terminate_workspace_requests: self.terminate_workspace_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type TerminateWorkspacesInputOperationOutputAlias = crate::operation::TerminateWorkspaces;
#[doc(hidden)]
pub type TerminateWorkspacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TerminateWorkspacesInput {
    /// Consumes the builder and constructs an Operation<[`TerminateWorkspaces`](crate::operation::TerminateWorkspaces)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TerminateWorkspaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TerminateWorkspacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TerminateWorkspacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TerminateWorkspacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.TerminateWorkspaces",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_terminate_workspaces(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TerminateWorkspaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TerminateWorkspaces",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TerminateWorkspacesInput`](crate::input::TerminateWorkspacesInput)
    pub fn builder() -> crate::input::terminate_workspaces_input::Builder {
        crate::input::terminate_workspaces_input::Builder::default()
    }
}

/// See [`UpdateConnectionAliasPermissionInput`](crate::input::UpdateConnectionAliasPermissionInput)
pub mod update_connection_alias_permission_input {
    /// A builder for [`UpdateConnectionAliasPermissionInput`](crate::input::UpdateConnectionAliasPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_id: std::option::Option<std::string::String>,
        pub(crate) connection_alias_permission:
            std::option::Option<crate::model::ConnectionAliasPermission>,
    }
    impl Builder {
        /// <p>The identifier of the connection alias that you want to update permissions for.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the connection alias that you want to update permissions for.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// <p>Indicates whether to share or unshare the connection alias with the specified Amazon Web Services account.</p>
        pub fn connection_alias_permission(
            mut self,
            input: crate::model::ConnectionAliasPermission,
        ) -> Self {
            self.connection_alias_permission = Some(input);
            self
        }
        /// <p>Indicates whether to share or unshare the connection alias with the specified Amazon Web Services account.</p>
        pub fn set_connection_alias_permission(
            mut self,
            input: std::option::Option<crate::model::ConnectionAliasPermission>,
        ) -> Self {
            self.connection_alias_permission = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionAliasPermissionInput`](crate::input::UpdateConnectionAliasPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConnectionAliasPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConnectionAliasPermissionInput {
                alias_id: self.alias_id,
                connection_alias_permission: self.connection_alias_permission,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConnectionAliasPermissionInputOperationOutputAlias =
    crate::operation::UpdateConnectionAliasPermission;
#[doc(hidden)]
pub type UpdateConnectionAliasPermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateConnectionAliasPermissionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConnectionAliasPermission`](crate::operation::UpdateConnectionAliasPermission)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConnectionAliasPermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConnectionAliasPermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConnectionAliasPermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConnectionAliasPermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.UpdateConnectionAliasPermission",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_connection_alias_permission(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConnectionAliasPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConnectionAliasPermission",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConnectionAliasPermissionInput`](crate::input::UpdateConnectionAliasPermissionInput)
    pub fn builder() -> crate::input::update_connection_alias_permission_input::Builder {
        crate::input::update_connection_alias_permission_input::Builder::default()
    }
}

/// See [`UpdateRulesOfIpGroupInput`](crate::input::UpdateRulesOfIpGroupInput)
pub mod update_rules_of_ip_group_input {
    /// A builder for [`UpdateRulesOfIpGroupInput`](crate::input::UpdateRulesOfIpGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) user_rules: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
    }
    impl Builder {
        /// <p>The identifier of the group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Appends an item to `user_rules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>One or more rules.</p>
        pub fn user_rules(mut self, input: impl Into<crate::model::IpRuleItem>) -> Self {
            let mut v = self.user_rules.unwrap_or_default();
            v.push(input.into());
            self.user_rules = Some(v);
            self
        }
        /// <p>One or more rules.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        ) -> Self {
            self.user_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRulesOfIpGroupInput`](crate::input::UpdateRulesOfIpGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRulesOfIpGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRulesOfIpGroupInput {
                group_id: self.group_id,
                user_rules: self.user_rules,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRulesOfIpGroupInputOperationOutputAlias = crate::operation::UpdateRulesOfIpGroup;
#[doc(hidden)]
pub type UpdateRulesOfIpGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRulesOfIpGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRulesOfIpGroup`](crate::operation::UpdateRulesOfIpGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRulesOfIpGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRulesOfIpGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRulesOfIpGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRulesOfIpGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.UpdateRulesOfIpGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_rules_of_ip_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRulesOfIpGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRulesOfIpGroup",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRulesOfIpGroupInput`](crate::input::UpdateRulesOfIpGroupInput)
    pub fn builder() -> crate::input::update_rules_of_ip_group_input::Builder {
        crate::input::update_rules_of_ip_group_input::Builder::default()
    }
}

/// See [`UpdateWorkspaceBundleInput`](crate::input::UpdateWorkspaceBundleInput)
pub mod update_workspace_bundle_input {
    /// A builder for [`UpdateWorkspaceBundleInput`](crate::input::UpdateWorkspaceBundleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bundle.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bundle.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkspaceBundleInput`](crate::input::UpdateWorkspaceBundleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWorkspaceBundleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWorkspaceBundleInput {
                bundle_id: self.bundle_id,
                image_id: self.image_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWorkspaceBundleInputOperationOutputAlias = crate::operation::UpdateWorkspaceBundle;
#[doc(hidden)]
pub type UpdateWorkspaceBundleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateWorkspaceBundleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWorkspaceBundle`](crate::operation::UpdateWorkspaceBundle)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWorkspaceBundle,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateWorkspaceBundleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateWorkspaceBundleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateWorkspaceBundleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.UpdateWorkspaceBundle",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_workspace_bundle(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWorkspaceBundle::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWorkspaceBundle",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceBundleInput`](crate::input::UpdateWorkspaceBundleInput)
    pub fn builder() -> crate::input::update_workspace_bundle_input::Builder {
        crate::input::update_workspace_bundle_input::Builder::default()
    }
}

/// See [`UpdateWorkspaceImagePermissionInput`](crate::input::UpdateWorkspaceImagePermissionInput)
pub mod update_workspace_image_permission_input {
    /// A builder for [`UpdateWorkspaceImagePermissionInput`](crate::input::UpdateWorkspaceImagePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) allow_copy_image: std::option::Option<bool>,
        pub(crate) shared_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The permission to copy the image. This permission can be revoked only after an image
        /// has been shared.</p>
        pub fn allow_copy_image(mut self, input: bool) -> Self {
            self.allow_copy_image = Some(input);
            self
        }
        /// <p>The permission to copy the image. This permission can be revoked only after an image
        /// has been shared.</p>
        pub fn set_allow_copy_image(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_copy_image = input;
            self
        }
        /// <p>The identifier of the Amazon Web Services account to share or unshare the image with.</p>
        ///
        /// <important>
        /// <p>Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.</p>
        /// </important>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account to share or unshare the image with.</p>
        ///
        /// <important>
        /// <p>Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.</p>
        /// </important>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkspaceImagePermissionInput`](crate::input::UpdateWorkspaceImagePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWorkspaceImagePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWorkspaceImagePermissionInput {
                image_id: self.image_id,
                allow_copy_image: self.allow_copy_image,
                shared_account_id: self.shared_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWorkspaceImagePermissionInputOperationOutputAlias =
    crate::operation::UpdateWorkspaceImagePermission;
#[doc(hidden)]
pub type UpdateWorkspaceImagePermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateWorkspaceImagePermissionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWorkspaceImagePermission`](crate::operation::UpdateWorkspaceImagePermission)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWorkspaceImagePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateWorkspaceImagePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateWorkspaceImagePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateWorkspaceImagePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkspacesService.UpdateWorkspaceImagePermission",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_workspace_image_permission(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWorkspaceImagePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWorkspaceImagePermission",
            "workspaces",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceImagePermissionInput`](crate::input::UpdateWorkspaceImagePermissionInput)
    pub fn builder() -> crate::input::update_workspace_image_permission_input::Builder {
        crate::input::update_workspace_image_permission_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkspaceImagePermissionInput {
    /// <p>The identifier of the image.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The permission to copy the image. This permission can be revoked only after an image
    /// has been shared.</p>
    pub allow_copy_image: std::option::Option<bool>,
    /// <p>The identifier of the Amazon Web Services account to share or unshare the image with.</p>
    ///
    /// <important>
    /// <p>Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.</p>
    /// </important>
    pub shared_account_id: std::option::Option<std::string::String>,
}
impl UpdateWorkspaceImagePermissionInput {
    /// <p>The identifier of the image.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The permission to copy the image. This permission can be revoked only after an image
    /// has been shared.</p>
    pub fn allow_copy_image(&self) -> std::option::Option<bool> {
        self.allow_copy_image
    }
    /// <p>The identifier of the Amazon Web Services account to share or unshare the image with.</p>
    ///
    /// <important>
    /// <p>Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.</p>
    /// </important>
    pub fn shared_account_id(&self) -> std::option::Option<&str> {
        self.shared_account_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateWorkspaceImagePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkspaceImagePermissionInput");
        formatter.field("image_id", &self.image_id);
        formatter.field("allow_copy_image", &self.allow_copy_image);
        formatter.field("shared_account_id", &self.shared_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkspaceBundleInput {
    /// <p>The identifier of the bundle.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the image.</p>
    pub image_id: std::option::Option<std::string::String>,
}
impl UpdateWorkspaceBundleInput {
    /// <p>The identifier of the bundle.</p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
    /// <p>The identifier of the image.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateWorkspaceBundleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkspaceBundleInput");
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("image_id", &self.image_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRulesOfIpGroupInput {
    /// <p>The identifier of the group.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>One or more rules.</p>
    pub user_rules: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
}
impl UpdateRulesOfIpGroupInput {
    /// <p>The identifier of the group.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>One or more rules.</p>
    pub fn user_rules(&self) -> std::option::Option<&[crate::model::IpRuleItem]> {
        self.user_rules.as_deref()
    }
}
impl std::fmt::Debug for UpdateRulesOfIpGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRulesOfIpGroupInput");
        formatter.field("group_id", &self.group_id);
        formatter.field("user_rules", &self.user_rules);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionAliasPermissionInput {
    /// <p>The identifier of the connection alias that you want to update permissions for.</p>
    pub alias_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether to share or unshare the connection alias with the specified Amazon Web Services account.</p>
    pub connection_alias_permission: std::option::Option<crate::model::ConnectionAliasPermission>,
}
impl UpdateConnectionAliasPermissionInput {
    /// <p>The identifier of the connection alias that you want to update permissions for.</p>
    pub fn alias_id(&self) -> std::option::Option<&str> {
        self.alias_id.as_deref()
    }
    /// <p>Indicates whether to share or unshare the connection alias with the specified Amazon Web Services account.</p>
    pub fn connection_alias_permission(
        &self,
    ) -> std::option::Option<&crate::model::ConnectionAliasPermission> {
        self.connection_alias_permission.as_ref()
    }
}
impl std::fmt::Debug for UpdateConnectionAliasPermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionAliasPermissionInput");
        formatter.field("alias_id", &self.alias_id);
        formatter.field(
            "connection_alias_permission",
            &self.connection_alias_permission,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateWorkspacesInput {
    /// <p>The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.</p>
    pub terminate_workspace_requests:
        std::option::Option<std::vec::Vec<crate::model::TerminateRequest>>,
}
impl TerminateWorkspacesInput {
    /// <p>The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.</p>
    pub fn terminate_workspace_requests(
        &self,
    ) -> std::option::Option<&[crate::model::TerminateRequest]> {
        self.terminate_workspace_requests.as_deref()
    }
}
impl std::fmt::Debug for TerminateWorkspacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateWorkspacesInput");
        formatter.field(
            "terminate_workspace_requests",
            &self.terminate_workspace_requests,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopWorkspacesInput {
    /// <p>The WorkSpaces to stop. You can specify up to 25 WorkSpaces.</p>
    pub stop_workspace_requests: std::option::Option<std::vec::Vec<crate::model::StopRequest>>,
}
impl StopWorkspacesInput {
    /// <p>The WorkSpaces to stop. You can specify up to 25 WorkSpaces.</p>
    pub fn stop_workspace_requests(&self) -> std::option::Option<&[crate::model::StopRequest]> {
        self.stop_workspace_requests.as_deref()
    }
}
impl std::fmt::Debug for StopWorkspacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopWorkspacesInput");
        formatter.field("stop_workspace_requests", &self.stop_workspace_requests);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartWorkspacesInput {
    /// <p>The WorkSpaces to start. You can specify up to 25 WorkSpaces.</p>
    pub start_workspace_requests: std::option::Option<std::vec::Vec<crate::model::StartRequest>>,
}
impl StartWorkspacesInput {
    /// <p>The WorkSpaces to start. You can specify up to 25 WorkSpaces.</p>
    pub fn start_workspace_requests(&self) -> std::option::Option<&[crate::model::StartRequest]> {
        self.start_workspace_requests.as_deref()
    }
}
impl std::fmt::Debug for StartWorkspacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartWorkspacesInput");
        formatter.field("start_workspace_requests", &self.start_workspace_requests);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeIpRulesInput {
    /// <p>The identifier of the group.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The rules to remove from the group.</p>
    pub user_rules: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RevokeIpRulesInput {
    /// <p>The identifier of the group.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The rules to remove from the group.</p>
    pub fn user_rules(&self) -> std::option::Option<&[std::string::String]> {
        self.user_rules.as_deref()
    }
}
impl std::fmt::Debug for RevokeIpRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeIpRulesInput");
        formatter.field("group_id", &self.group_id);
        formatter.field("user_rules", &self.user_rules);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreWorkspaceInput {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl RestoreWorkspaceInput {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for RestoreWorkspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreWorkspaceInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterWorkspaceDirectoryInput {
    /// <p>The identifier of the directory. You cannot register a directory if it does not have a status
    /// of Active. If the directory does not have a status of Active, you will receive an
    /// InvalidResourceStateException error. If you have already registered the maximum number of directories
    /// that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error.
    /// Deregister directories that you are not using for WorkSpaces, and try again.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets
    /// are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these
    /// conditions are not met, you will receive an OperationNotSupportedException error.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and
    /// WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set
    /// <code>EnableWorkDocs</code> to disabled, and try again.</p>
    pub enable_work_docs: std::option::Option<bool>,
    /// <p>Indicates whether self-service capabilities are enabled or disabled.</p>
    pub enable_self_service: std::option::Option<bool>,
    /// <p>Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own
    /// License (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be
    /// enabled for BYOL. If your account has not been enabled for BYOL, you will receive an
    /// InvalidParameterValuesException error. For more information about BYOL images, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>
    pub tenancy: std::option::Option<crate::model::Tenancy>,
    /// <p>The tags associated with the directory.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl RegisterWorkspaceDirectoryInput {
    /// <p>The identifier of the directory. You cannot register a directory if it does not have a status
    /// of Active. If the directory does not have a status of Active, you will receive an
    /// InvalidResourceStateException error. If you have already registered the maximum number of directories
    /// that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error.
    /// Deregister directories that you are not using for WorkSpaces, and try again.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets
    /// are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these
    /// conditions are not met, you will receive an OperationNotSupportedException error.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and
    /// WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set
    /// <code>EnableWorkDocs</code> to disabled, and try again.</p>
    pub fn enable_work_docs(&self) -> std::option::Option<bool> {
        self.enable_work_docs
    }
    /// <p>Indicates whether self-service capabilities are enabled or disabled.</p>
    pub fn enable_self_service(&self) -> std::option::Option<bool> {
        self.enable_self_service
    }
    /// <p>Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own
    /// License (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be
    /// enabled for BYOL. If your account has not been enabled for BYOL, you will receive an
    /// InvalidParameterValuesException error. For more information about BYOL images, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>
    pub fn tenancy(&self) -> std::option::Option<&crate::model::Tenancy> {
        self.tenancy.as_ref()
    }
    /// <p>The tags associated with the directory.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for RegisterWorkspaceDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterWorkspaceDirectoryInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("enable_work_docs", &self.enable_work_docs);
        formatter.field("enable_self_service", &self.enable_self_service);
        formatter.field("tenancy", &self.tenancy);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebuildWorkspacesInput {
    /// <p>The WorkSpace to rebuild. You can specify a single WorkSpace.</p>
    pub rebuild_workspace_requests:
        std::option::Option<std::vec::Vec<crate::model::RebuildRequest>>,
}
impl RebuildWorkspacesInput {
    /// <p>The WorkSpace to rebuild. You can specify a single WorkSpace.</p>
    pub fn rebuild_workspace_requests(
        &self,
    ) -> std::option::Option<&[crate::model::RebuildRequest]> {
        self.rebuild_workspace_requests.as_deref()
    }
}
impl std::fmt::Debug for RebuildWorkspacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebuildWorkspacesInput");
        formatter.field(
            "rebuild_workspace_requests",
            &self.rebuild_workspace_requests,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootWorkspacesInput {
    /// <p>The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.</p>
    pub reboot_workspace_requests: std::option::Option<std::vec::Vec<crate::model::RebootRequest>>,
}
impl RebootWorkspacesInput {
    /// <p>The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.</p>
    pub fn reboot_workspace_requests(&self) -> std::option::Option<&[crate::model::RebootRequest]> {
        self.reboot_workspace_requests.as_deref()
    }
}
impl std::fmt::Debug for RebootWorkspacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootWorkspacesInput");
        formatter.field("reboot_workspace_requests", &self.reboot_workspace_requests);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyWorkspaceStateInput {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The WorkSpace state.</p>
    pub workspace_state: std::option::Option<crate::model::TargetWorkspaceState>,
}
impl ModifyWorkspaceStateInput {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The WorkSpace state.</p>
    pub fn workspace_state(&self) -> std::option::Option<&crate::model::TargetWorkspaceState> {
        self.workspace_state.as_ref()
    }
}
impl std::fmt::Debug for ModifyWorkspaceStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyWorkspaceStateInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("workspace_state", &self.workspace_state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyWorkspacePropertiesInput {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The properties of the WorkSpace.</p>
    pub workspace_properties: std::option::Option<crate::model::WorkspaceProperties>,
}
impl ModifyWorkspacePropertiesInput {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The properties of the WorkSpace.</p>
    pub fn workspace_properties(&self) -> std::option::Option<&crate::model::WorkspaceProperties> {
        self.workspace_properties.as_ref()
    }
}
impl std::fmt::Debug for ModifyWorkspacePropertiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyWorkspacePropertiesInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("workspace_properties", &self.workspace_properties);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyWorkspaceCreationPropertiesInput {
    /// <p>The identifier of the directory.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The default properties for creating WorkSpaces.</p>
    pub workspace_creation_properties:
        std::option::Option<crate::model::WorkspaceCreationProperties>,
}
impl ModifyWorkspaceCreationPropertiesInput {
    /// <p>The identifier of the directory.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The default properties for creating WorkSpaces.</p>
    pub fn workspace_creation_properties(
        &self,
    ) -> std::option::Option<&crate::model::WorkspaceCreationProperties> {
        self.workspace_creation_properties.as_ref()
    }
}
impl std::fmt::Debug for ModifyWorkspaceCreationPropertiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyWorkspaceCreationPropertiesInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field(
            "workspace_creation_properties",
            &self.workspace_creation_properties,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyWorkspaceAccessPropertiesInput {
    /// <p>The identifier of the directory.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The device types and operating systems to enable or disable for access.</p>
    pub workspace_access_properties: std::option::Option<crate::model::WorkspaceAccessProperties>,
}
impl ModifyWorkspaceAccessPropertiesInput {
    /// <p>The identifier of the directory.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The device types and operating systems to enable or disable for access.</p>
    pub fn workspace_access_properties(
        &self,
    ) -> std::option::Option<&crate::model::WorkspaceAccessProperties> {
        self.workspace_access_properties.as_ref()
    }
}
impl std::fmt::Debug for ModifyWorkspaceAccessPropertiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyWorkspaceAccessPropertiesInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field(
            "workspace_access_properties",
            &self.workspace_access_properties,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifySelfservicePermissionsInput {
    /// <p>The identifier of the directory.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The permissions to enable or disable self-service capabilities.</p>
    pub selfservice_permissions: std::option::Option<crate::model::SelfservicePermissions>,
}
impl ModifySelfservicePermissionsInput {
    /// <p>The identifier of the directory.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The permissions to enable or disable self-service capabilities.</p>
    pub fn selfservice_permissions(
        &self,
    ) -> std::option::Option<&crate::model::SelfservicePermissions> {
        self.selfservice_permissions.as_ref()
    }
}
impl std::fmt::Debug for ModifySelfservicePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifySelfservicePermissionsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("selfservice_permissions", &self.selfservice_permissions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyClientPropertiesInput {
    /// <p>The resource identifiers, in the form of directory IDs.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Information about the Amazon WorkSpaces client.</p>
    pub client_properties: std::option::Option<crate::model::ClientProperties>,
}
impl ModifyClientPropertiesInput {
    /// <p>The resource identifiers, in the form of directory IDs.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Information about the Amazon WorkSpaces client.</p>
    pub fn client_properties(&self) -> std::option::Option<&crate::model::ClientProperties> {
        self.client_properties.as_ref()
    }
}
impl std::fmt::Debug for ModifyClientPropertiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyClientPropertiesInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("client_properties", &self.client_properties);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyAccountInput {
    /// <p>The status of BYOL.</p>
    pub dedicated_tenancy_support: std::option::Option<crate::model::DedicatedTenancySupportEnum>,
    /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network
    /// interface. Specify an IP address range that is compatible with your network and in CIDR
    /// notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be
    /// /16 (for example, 203.0.113.25/16). It must also be specified as available by the
    /// <code>ListAvailableManagementCidrRanges</code> operation.</p>
    pub dedicated_tenancy_management_cidr_range: std::option::Option<std::string::String>,
}
impl ModifyAccountInput {
    /// <p>The status of BYOL.</p>
    pub fn dedicated_tenancy_support(
        &self,
    ) -> std::option::Option<&crate::model::DedicatedTenancySupportEnum> {
        self.dedicated_tenancy_support.as_ref()
    }
    /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network
    /// interface. Specify an IP address range that is compatible with your network and in CIDR
    /// notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be
    /// /16 (for example, 203.0.113.25/16). It must also be specified as available by the
    /// <code>ListAvailableManagementCidrRanges</code> operation.</p>
    pub fn dedicated_tenancy_management_cidr_range(&self) -> std::option::Option<&str> {
        self.dedicated_tenancy_management_cidr_range.as_deref()
    }
}
impl std::fmt::Debug for ModifyAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyAccountInput");
        formatter.field("dedicated_tenancy_support", &self.dedicated_tenancy_support);
        formatter.field(
            "dedicated_tenancy_management_cidr_range",
            &self.dedicated_tenancy_management_cidr_range,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MigrateWorkspaceInput {
    /// <p>The identifier of the WorkSpace to migrate from.</p>
    pub source_workspace_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the target bundle type to migrate the WorkSpace to.</p>
    pub bundle_id: std::option::Option<std::string::String>,
}
impl MigrateWorkspaceInput {
    /// <p>The identifier of the WorkSpace to migrate from.</p>
    pub fn source_workspace_id(&self) -> std::option::Option<&str> {
        self.source_workspace_id.as_deref()
    }
    /// <p>The identifier of the target bundle type to migrate the WorkSpace to.</p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
}
impl std::fmt::Debug for MigrateWorkspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MigrateWorkspaceInput");
        formatter.field("source_workspace_id", &self.source_workspace_id);
        formatter.field("bundle_id", &self.bundle_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAvailableManagementCidrRangesInput {
    /// <p>The IP address range to search. Specify an IP address range that is compatible with your
    /// network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).</p>
    pub management_cidr_range_constraint: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAvailableManagementCidrRangesInput {
    /// <p>The IP address range to search. Specify an IP address range that is compatible with your
    /// network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).</p>
    pub fn management_cidr_range_constraint(&self) -> std::option::Option<&str> {
        self.management_cidr_range_constraint.as_deref()
    }
    /// <p>The maximum number of items to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAvailableManagementCidrRangesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAvailableManagementCidrRangesInput");
        formatter.field(
            "management_cidr_range_constraint",
            &self.management_cidr_range_constraint,
        );
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportWorkspaceImageInput {
    /// <p>The identifier of the EC2 image.</p>
    pub ec2_image_id: std::option::Option<std::string::String>,
    /// <p>The ingestion process to be used when importing the image, depending on which protocol
    /// you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces Streaming Protocol
    /// (WSP). To use WSP, specify a value that ends in <code>_WSP</code>. To use PCoIP, specify a value
    /// that does not end in <code>_WSP</code>. </p>
    ///
    /// <p>For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify
    /// <code>BYOL_REGULAR</code> or <code>BYOL_REGULAR_WSP</code>, depending on the protocol.</p>
    pub ingestion_process: std::option::Option<crate::model::WorkspaceImageIngestionProcess>,
    /// <p>The name of the WorkSpace image.</p>
    pub image_name: std::option::Option<std::string::String>,
    /// <p>The description of the WorkSpace image.</p>
    pub image_description: std::option::Option<std::string::String>,
    /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10
    /// BYOL images. For more information about subscribing to Office for BYOL images, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">
    /// Bring Your Own Windows Desktop Licenses</a>.</p>
    ///
    /// <note>
    /// <p>Although this parameter is an array, only one item is allowed at this time.</p>
    /// </note>
    pub applications: std::option::Option<std::vec::Vec<crate::model::Application>>,
}
impl ImportWorkspaceImageInput {
    /// <p>The identifier of the EC2 image.</p>
    pub fn ec2_image_id(&self) -> std::option::Option<&str> {
        self.ec2_image_id.as_deref()
    }
    /// <p>The ingestion process to be used when importing the image, depending on which protocol
    /// you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces Streaming Protocol
    /// (WSP). To use WSP, specify a value that ends in <code>_WSP</code>. To use PCoIP, specify a value
    /// that does not end in <code>_WSP</code>. </p>
    ///
    /// <p>For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify
    /// <code>BYOL_REGULAR</code> or <code>BYOL_REGULAR_WSP</code>, depending on the protocol.</p>
    pub fn ingestion_process(
        &self,
    ) -> std::option::Option<&crate::model::WorkspaceImageIngestionProcess> {
        self.ingestion_process.as_ref()
    }
    /// <p>The name of the WorkSpace image.</p>
    pub fn image_name(&self) -> std::option::Option<&str> {
        self.image_name.as_deref()
    }
    /// <p>The description of the WorkSpace image.</p>
    pub fn image_description(&self) -> std::option::Option<&str> {
        self.image_description.as_deref()
    }
    /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10
    /// BYOL images. For more information about subscribing to Office for BYOL images, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">
    /// Bring Your Own Windows Desktop Licenses</a>.</p>
    ///
    /// <note>
    /// <p>Although this parameter is an array, only one item is allowed at this time.</p>
    /// </note>
    pub fn applications(&self) -> std::option::Option<&[crate::model::Application]> {
        self.applications.as_deref()
    }
}
impl std::fmt::Debug for ImportWorkspaceImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportWorkspaceImageInput");
        formatter.field("ec2_image_id", &self.ec2_image_id);
        formatter.field("ingestion_process", &self.ingestion_process);
        formatter.field("image_name", &self.image_name);
        formatter.field("image_description", &self.image_description);
        formatter.field("tags", &self.tags);
        formatter.field("applications", &self.applications);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateIpGroupsInput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The identifiers of one or more IP access control groups.</p>
    pub group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DisassociateIpGroupsInput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The identifiers of one or more IP access control groups.</p>
    pub fn group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.group_ids.as_deref()
    }
}
impl std::fmt::Debug for DisassociateIpGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateIpGroupsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("group_ids", &self.group_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateConnectionAliasInput {
    /// <p>The identifier of the connection alias to disassociate.</p>
    pub alias_id: std::option::Option<std::string::String>,
}
impl DisassociateConnectionAliasInput {
    /// <p>The identifier of the connection alias to disassociate.</p>
    pub fn alias_id(&self) -> std::option::Option<&str> {
        self.alias_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateConnectionAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateConnectionAliasInput");
        formatter.field("alias_id", &self.alias_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspaceSnapshotsInput {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl DescribeWorkspaceSnapshotsInput {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorkspaceSnapshotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspaceSnapshotsInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspacesConnectionStatusInput {
    /// <p>The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.</p>
    pub workspace_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeWorkspacesConnectionStatusInput {
    /// <p>The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.</p>
    pub fn workspace_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.workspace_ids.as_deref()
    }
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorkspacesConnectionStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspacesConnectionStatusInput");
        formatter.field("workspace_ids", &self.workspace_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspacesInput {
    /// <p>The identifiers of the WorkSpaces. You cannot combine this parameter with any other
    /// filter.</p>
    /// <p>Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier
    /// it returns is not immediately available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no information is returned.</p>
    pub workspace_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The identifier of the directory. In addition, you can optionally specify a specific
    /// directory user (see <code>UserName</code>). You cannot combine this parameter with any
    /// other filter.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The name of the directory user. You must specify this parameter with
    /// <code>DirectoryId</code>.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the bundle. All WorkSpaces that are created from this bundle are
    /// retrieved. You cannot combine this parameter with any other filter.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeWorkspacesInput {
    /// <p>The identifiers of the WorkSpaces. You cannot combine this parameter with any other
    /// filter.</p>
    /// <p>Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier
    /// it returns is not immediately available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no information is returned.</p>
    pub fn workspace_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.workspace_ids.as_deref()
    }
    /// <p>The identifier of the directory. In addition, you can optionally specify a specific
    /// directory user (see <code>UserName</code>). You cannot combine this parameter with any
    /// other filter.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The name of the directory user. You must specify this parameter with
    /// <code>DirectoryId</code>.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The identifier of the bundle. All WorkSpaces that are created from this bundle are
    /// retrieved. You cannot combine this parameter with any other filter.</p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
    /// <p>The maximum number of items to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorkspacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspacesInput");
        formatter.field("workspace_ids", &self.workspace_ids);
        formatter.field("directory_id", &self.directory_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspaceImagesInput {
    /// <p>The identifier of the image.</p>
    pub image_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type (owned or shared) of the image.</p>
    pub image_type: std::option::Option<crate::model::ImageType>,
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeWorkspaceImagesInput {
    /// <p>The identifier of the image.</p>
    pub fn image_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.image_ids.as_deref()
    }
    /// <p>The type (owned or shared) of the image.</p>
    pub fn image_type(&self) -> std::option::Option<&crate::model::ImageType> {
        self.image_type.as_ref()
    }
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeWorkspaceImagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspaceImagesInput");
        formatter.field("image_ids", &self.image_ids);
        formatter.field("image_type", &self.image_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspaceImagePermissionsInput {
    /// <p>The identifier of the image.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeWorkspaceImagePermissionsInput {
    /// <p>The identifier of the image.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeWorkspaceImagePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspaceImagePermissionsInput");
        formatter.field("image_id", &self.image_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspaceDirectoriesInput {
    /// <p>The identifiers of the directories. If the value is null, all directories are
    /// retrieved.</p>
    pub directory_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of directories to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeWorkspaceDirectoriesInput {
    /// <p>The identifiers of the directories. If the value is null, all directories are
    /// retrieved.</p>
    pub fn directory_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.directory_ids.as_deref()
    }
    /// <p>The maximum number of directories to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorkspaceDirectoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspaceDirectoriesInput");
        formatter.field("directory_ids", &self.directory_ids);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspaceBundlesInput {
    /// <p>The identifiers of the bundles. You cannot combine this parameter with any other filter.</p>
    pub bundle_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The owner of the bundles. You cannot combine this parameter with any other filter.</p>
    /// <p>To describe the bundles provided by Amazon Web Services, specify <code>AMAZON</code>.
    /// To describe the bundles that belong to your account, don't specify a value.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeWorkspaceBundlesInput {
    /// <p>The identifiers of the bundles. You cannot combine this parameter with any other filter.</p>
    pub fn bundle_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.bundle_ids.as_deref()
    }
    /// <p>The owner of the bundles. You cannot combine this parameter with any other filter.</p>
    /// <p>To describe the bundles provided by Amazon Web Services, specify <code>AMAZON</code>.
    /// To describe the bundles that belong to your account, don't specify a value.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The token for the next set of results. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorkspaceBundlesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspaceBundlesInput");
        formatter.field("bundle_ids", &self.bundle_ids);
        formatter.field("owner", &self.owner);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsInput {
    /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
    /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl DescribeTagsInput {
    /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
    /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIpGroupsInput {
    /// <p>The identifiers of one or more IP access control groups.</p>
    pub group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeIpGroupsInput {
    /// <p>The identifiers of one or more IP access control groups.</p>
    pub fn group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.group_ids.as_deref()
    }
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeIpGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIpGroupsInput");
        formatter.field("group_ids", &self.group_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionAliasPermissionsInput {
    /// <p>The identifier of the connection alias.</p>
    pub alias_id: std::option::Option<std::string::String>,
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the
    /// next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeConnectionAliasPermissionsInput {
    /// <p>The identifier of the connection alias.</p>
    pub fn alias_id(&self) -> std::option::Option<&str> {
        self.alias_id.as_deref()
    }
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the
    /// next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeConnectionAliasPermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionAliasPermissionsInput");
        formatter.field("alias_id", &self.alias_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionAliasesInput {
    /// <p>The identifiers of the connection aliases to describe.</p>
    pub alias_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The identifier of the directory associated with the connection alias.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of connection aliases to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the
    /// next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeConnectionAliasesInput {
    /// <p>The identifiers of the connection aliases to describe.</p>
    pub fn alias_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.alias_ids.as_deref()
    }
    /// <p>The identifier of the directory associated with the connection alias.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The maximum number of connection aliases to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the
    /// next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeConnectionAliasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionAliasesInput");
        formatter.field("alias_ids", &self.alias_ids);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClientPropertiesInput {
    /// <p>The resource identifier, in the form of directory IDs.</p>
    pub resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeClientPropertiesInput {
    /// <p>The resource identifier, in the form of directory IDs.</p>
    pub fn resource_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeClientPropertiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClientPropertiesInput");
        formatter.field("resource_ids", &self.resource_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountModificationsInput {
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAccountModificationsInput {
    /// <p>If you received a <code>NextToken</code> from a previous call that was paginated,
    /// provide this token to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccountModificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountModificationsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountInput {}
impl std::fmt::Debug for DescribeAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterWorkspaceDirectoryInput {
    /// <p>The identifier of the directory. If any WorkSpaces are registered to this directory, you must
    /// remove them before you deregister the directory, or you will receive an OperationNotSupportedException
    /// error.</p>
    pub directory_id: std::option::Option<std::string::String>,
}
impl DeregisterWorkspaceDirectoryInput {
    /// <p>The identifier of the directory. If any WorkSpaces are registered to this directory, you must
    /// remove them before you deregister the directory, or you will receive an OperationNotSupportedException
    /// error.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
}
impl std::fmt::Debug for DeregisterWorkspaceDirectoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterWorkspaceDirectoryInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkspaceImageInput {
    /// <p>The identifier of the image.</p>
    pub image_id: std::option::Option<std::string::String>,
}
impl DeleteWorkspaceImageInput {
    /// <p>The identifier of the image.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWorkspaceImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkspaceImageInput");
        formatter.field("image_id", &self.image_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkspaceBundleInput {
    /// <p>The identifier of the bundle.</p>
    pub bundle_id: std::option::Option<std::string::String>,
}
impl DeleteWorkspaceBundleInput {
    /// <p>The identifier of the bundle.</p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWorkspaceBundleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkspaceBundleInput");
        formatter.field("bundle_id", &self.bundle_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsInput {
    /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
    /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The tag keys.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteTagsInput {
    /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
    /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The tag keys.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for DeleteTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIpGroupInput {
    /// <p>The identifier of the IP access control group.</p>
    pub group_id: std::option::Option<std::string::String>,
}
impl DeleteIpGroupInput {
    /// <p>The identifier of the IP access control group.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteIpGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIpGroupInput");
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionAliasInput {
    /// <p>The identifier of the connection alias to delete.</p>
    pub alias_id: std::option::Option<std::string::String>,
}
impl DeleteConnectionAliasInput {
    /// <p>The identifier of the connection alias to delete.</p>
    pub fn alias_id(&self) -> std::option::Option<&str> {
        self.alias_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteConnectionAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionAliasInput");
        formatter.field("alias_id", &self.alias_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkspacesInput {
    /// <p>The WorkSpaces to create. You can specify up to 25 WorkSpaces.</p>
    pub workspaces: std::option::Option<std::vec::Vec<crate::model::WorkspaceRequest>>,
}
impl CreateWorkspacesInput {
    /// <p>The WorkSpaces to create. You can specify up to 25 WorkSpaces.</p>
    pub fn workspaces(&self) -> std::option::Option<&[crate::model::WorkspaceRequest]> {
        self.workspaces.as_deref()
    }
}
impl std::fmt::Debug for CreateWorkspacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkspacesInput");
        formatter.field("workspaces", &self.workspaces);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkspaceBundleInput {
    /// <p>The name of the bundle.</p>
    pub bundle_name: std::option::Option<std::string::String>,
    /// <p>The description of the bundle.</p>
    pub bundle_description: std::option::Option<std::string::String>,
    /// <p>The identifier of the image that is used to create the bundle.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>Describes the compute type of the bundle.</p>
    pub compute_type: std::option::Option<crate::model::ComputeType>,
    /// <p>Describes the user volume for a WorkSpace bundle.</p>
    pub user_storage: std::option::Option<crate::model::UserStorage>,
    /// <p>Describes the root volume for a WorkSpace bundle.</p>
    pub root_storage: std::option::Option<crate::model::RootStorage>,
    /// <p>The tags associated with the bundle.</p>
    ///
    /// <note>
    /// <p>To add tags at the same time when you're creating the bundle, you must create an IAM policy that
    /// grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateWorkspaceBundleInput {
    /// <p>The name of the bundle.</p>
    pub fn bundle_name(&self) -> std::option::Option<&str> {
        self.bundle_name.as_deref()
    }
    /// <p>The description of the bundle.</p>
    pub fn bundle_description(&self) -> std::option::Option<&str> {
        self.bundle_description.as_deref()
    }
    /// <p>The identifier of the image that is used to create the bundle.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>Describes the compute type of the bundle.</p>
    pub fn compute_type(&self) -> std::option::Option<&crate::model::ComputeType> {
        self.compute_type.as_ref()
    }
    /// <p>Describes the user volume for a WorkSpace bundle.</p>
    pub fn user_storage(&self) -> std::option::Option<&crate::model::UserStorage> {
        self.user_storage.as_ref()
    }
    /// <p>Describes the root volume for a WorkSpace bundle.</p>
    pub fn root_storage(&self) -> std::option::Option<&crate::model::RootStorage> {
        self.root_storage.as_ref()
    }
    /// <p>The tags associated with the bundle.</p>
    ///
    /// <note>
    /// <p>To add tags at the same time when you're creating the bundle, you must create an IAM policy that
    /// grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateWorkspaceBundleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkspaceBundleInput");
        formatter.field("bundle_name", &self.bundle_name);
        formatter.field("bundle_description", &self.bundle_description);
        formatter.field("image_id", &self.image_id);
        formatter.field("compute_type", &self.compute_type);
        formatter.field("user_storage", &self.user_storage);
        formatter.field("root_storage", &self.root_storage);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUpdatedWorkspaceImageInput {
    /// <p>The name of the new updated WorkSpace image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of whether updates for the WorkSpace image are available.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The identifier of the source WorkSpace image.</p>
    pub source_image_id: std::option::Option<std::string::String>,
    /// <p>The tags that you want to add to the new updated WorkSpace image.</p>
    ///
    /// <note>
    /// <p>To add tags at the same time when you're creating the updated image, you must create
    /// an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateUpdatedWorkspaceImageInput {
    /// <p>The name of the new updated WorkSpace image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of whether updates for the WorkSpace image are available.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The identifier of the source WorkSpace image.</p>
    pub fn source_image_id(&self) -> std::option::Option<&str> {
        self.source_image_id.as_deref()
    }
    /// <p>The tags that you want to add to the new updated WorkSpace image.</p>
    ///
    /// <note>
    /// <p>To add tags at the same time when you're creating the updated image, you must create
    /// an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateUpdatedWorkspaceImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUpdatedWorkspaceImageInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("source_image_id", &self.source_image_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTagsInput {
    /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
    /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateTagsInput {
    /// <p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces,
    /// registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTagsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIpGroupInput {
    /// <p>The name of the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The description of the group.</p>
    pub group_desc: std::option::Option<std::string::String>,
    /// <p>The rules to add to the group.</p>
    pub user_rules: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
    /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateIpGroupInput {
    /// <p>The name of the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The description of the group.</p>
    pub fn group_desc(&self) -> std::option::Option<&str> {
        self.group_desc.as_deref()
    }
    /// <p>The rules to add to the group.</p>
    pub fn user_rules(&self) -> std::option::Option<&[crate::model::IpRuleItem]> {
        self.user_rules.as_deref()
    }
    /// <p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateIpGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIpGroupInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("group_desc", &self.group_desc);
        formatter.field("user_rules", &self.user_rules);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionAliasInput {
    /// <p>A connection string in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p>
    ///
    /// <important>
    /// <p>After you create a connection string, it is always associated to your Amazon Web Services account. You cannot recreate the same
    /// connection string with a different account, even if you delete all instances of it from the original account. The
    /// connection string is globally reserved for your account.</p>
    /// </important>
    pub connection_string: std::option::Option<std::string::String>,
    /// <p>The tags to associate with the connection alias.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateConnectionAliasInput {
    /// <p>A connection string in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p>
    ///
    /// <important>
    /// <p>After you create a connection string, it is always associated to your Amazon Web Services account. You cannot recreate the same
    /// connection string with a different account, even if you delete all instances of it from the original account. The
    /// connection string is globally reserved for your account.</p>
    /// </important>
    pub fn connection_string(&self) -> std::option::Option<&str> {
        self.connection_string.as_deref()
    }
    /// <p>The tags to associate with the connection alias.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateConnectionAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionAliasInput");
        formatter.field("connection_string", &self.connection_string);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyWorkspaceImageInput {
    /// <p>The name of the image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the image.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The identifier of the source image.</p>
    pub source_image_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the source Region.</p>
    pub source_region: std::option::Option<std::string::String>,
    /// <p>The tags for the image.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CopyWorkspaceImageInput {
    /// <p>The name of the image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the image.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The identifier of the source image.</p>
    pub fn source_image_id(&self) -> std::option::Option<&str> {
        self.source_image_id.as_deref()
    }
    /// <p>The identifier of the source Region.</p>
    pub fn source_region(&self) -> std::option::Option<&str> {
        self.source_region.as_deref()
    }
    /// <p>The tags for the image.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CopyWorkspaceImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyWorkspaceImageInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("source_image_id", &self.source_image_id);
        formatter.field("source_region", &self.source_region);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizeIpRulesInput {
    /// <p>The identifier of the group.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The rules to add to the group.</p>
    pub user_rules: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
}
impl AuthorizeIpRulesInput {
    /// <p>The identifier of the group.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The rules to add to the group.</p>
    pub fn user_rules(&self) -> std::option::Option<&[crate::model::IpRuleItem]> {
        self.user_rules.as_deref()
    }
}
impl std::fmt::Debug for AuthorizeIpRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizeIpRulesInput");
        formatter.field("group_id", &self.group_id);
        formatter.field("user_rules", &self.user_rules);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateIpGroupsInput {
    /// <p>The identifier of the directory.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The identifiers of one or more IP access control groups.</p>
    pub group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AssociateIpGroupsInput {
    /// <p>The identifier of the directory.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The identifiers of one or more IP access control groups.</p>
    pub fn group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.group_ids.as_deref()
    }
}
impl std::fmt::Debug for AssociateIpGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateIpGroupsInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("group_ids", &self.group_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateConnectionAliasInput {
    /// <p>The identifier of the connection alias.</p>
    pub alias_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the directory to associate the connection alias with.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl AssociateConnectionAliasInput {
    /// <p>The identifier of the connection alias.</p>
    pub fn alias_id(&self) -> std::option::Option<&str> {
        self.alias_id.as_deref()
    }
    /// <p>The identifier of the directory to associate the connection alias with.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateConnectionAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateConnectionAliasInput");
        formatter.field("alias_id", &self.alias_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
