// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateConnectionAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_connection_alias`](crate::client::Client::associate_connection_alias).
///
/// See [`crate::client::fluent_builders::AssociateConnectionAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateConnectionAlias {
    _private: (),
}
impl AssociateConnectionAlias {
    /// Creates a new builder-style object to manufacture [`AssociateConnectionAliasInput`](crate::input::AssociateConnectionAliasInput)
    pub fn builder() -> crate::input::associate_connection_alias_input::Builder {
        crate::input::associate_connection_alias_input::Builder::default()
    }
    /// Creates a new `AssociateConnectionAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateConnectionAlias {
    type Output = std::result::Result<
        crate::output::AssociateConnectionAliasOutput,
        crate::error::AssociateConnectionAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_connection_alias_error(response)
        } else {
            crate::operation_deser::parse_associate_connection_alias_response(response)
        }
    }
}

/// Operation shape for `AssociateIpGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_ip_groups`](crate::client::Client::associate_ip_groups).
///
/// See [`crate::client::fluent_builders::AssociateIpGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateIpGroups {
    _private: (),
}
impl AssociateIpGroups {
    /// Creates a new builder-style object to manufacture [`AssociateIpGroupsInput`](crate::input::AssociateIpGroupsInput)
    pub fn builder() -> crate::input::associate_ip_groups_input::Builder {
        crate::input::associate_ip_groups_input::Builder::default()
    }
    /// Creates a new `AssociateIpGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateIpGroups {
    type Output = std::result::Result<
        crate::output::AssociateIpGroupsOutput,
        crate::error::AssociateIpGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_ip_groups_error(response)
        } else {
            crate::operation_deser::parse_associate_ip_groups_response(response)
        }
    }
}

/// Operation shape for `AuthorizeIpRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`authorize_ip_rules`](crate::client::Client::authorize_ip_rules).
///
/// See [`crate::client::fluent_builders::AuthorizeIpRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AuthorizeIpRules {
    _private: (),
}
impl AuthorizeIpRules {
    /// Creates a new builder-style object to manufacture [`AuthorizeIpRulesInput`](crate::input::AuthorizeIpRulesInput)
    pub fn builder() -> crate::input::authorize_ip_rules_input::Builder {
        crate::input::authorize_ip_rules_input::Builder::default()
    }
    /// Creates a new `AuthorizeIpRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AuthorizeIpRules {
    type Output = std::result::Result<
        crate::output::AuthorizeIpRulesOutput,
        crate::error::AuthorizeIpRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_authorize_ip_rules_error(response)
        } else {
            crate::operation_deser::parse_authorize_ip_rules_response(response)
        }
    }
}

/// Operation shape for `CopyWorkspaceImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_workspace_image`](crate::client::Client::copy_workspace_image).
///
/// See [`crate::client::fluent_builders::CopyWorkspaceImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyWorkspaceImage {
    _private: (),
}
impl CopyWorkspaceImage {
    /// Creates a new builder-style object to manufacture [`CopyWorkspaceImageInput`](crate::input::CopyWorkspaceImageInput)
    pub fn builder() -> crate::input::copy_workspace_image_input::Builder {
        crate::input::copy_workspace_image_input::Builder::default()
    }
    /// Creates a new `CopyWorkspaceImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyWorkspaceImage {
    type Output = std::result::Result<
        crate::output::CopyWorkspaceImageOutput,
        crate::error::CopyWorkspaceImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_workspace_image_error(response)
        } else {
            crate::operation_deser::parse_copy_workspace_image_response(response)
        }
    }
}

/// Operation shape for `CreateConnectClientAddIn`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connect_client_add_in`](crate::client::Client::create_connect_client_add_in).
///
/// See [`crate::client::fluent_builders::CreateConnectClientAddIn`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnectClientAddIn {
    _private: (),
}
impl CreateConnectClientAddIn {
    /// Creates a new builder-style object to manufacture [`CreateConnectClientAddInInput`](crate::input::CreateConnectClientAddInInput)
    pub fn builder() -> crate::input::create_connect_client_add_in_input::Builder {
        crate::input::create_connect_client_add_in_input::Builder::default()
    }
    /// Creates a new `CreateConnectClientAddIn` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnectClientAddIn {
    type Output = std::result::Result<
        crate::output::CreateConnectClientAddInOutput,
        crate::error::CreateConnectClientAddInError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connect_client_add_in_error(response)
        } else {
            crate::operation_deser::parse_create_connect_client_add_in_response(response)
        }
    }
}

/// Operation shape for `CreateConnectionAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connection_alias`](crate::client::Client::create_connection_alias).
///
/// See [`crate::client::fluent_builders::CreateConnectionAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnectionAlias {
    _private: (),
}
impl CreateConnectionAlias {
    /// Creates a new builder-style object to manufacture [`CreateConnectionAliasInput`](crate::input::CreateConnectionAliasInput)
    pub fn builder() -> crate::input::create_connection_alias_input::Builder {
        crate::input::create_connection_alias_input::Builder::default()
    }
    /// Creates a new `CreateConnectionAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnectionAlias {
    type Output = std::result::Result<
        crate::output::CreateConnectionAliasOutput,
        crate::error::CreateConnectionAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connection_alias_error(response)
        } else {
            crate::operation_deser::parse_create_connection_alias_response(response)
        }
    }
}

/// Operation shape for `CreateIpGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ip_group`](crate::client::Client::create_ip_group).
///
/// See [`crate::client::fluent_builders::CreateIpGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIpGroup {
    _private: (),
}
impl CreateIpGroup {
    /// Creates a new builder-style object to manufacture [`CreateIpGroupInput`](crate::input::CreateIpGroupInput)
    pub fn builder() -> crate::input::create_ip_group_input::Builder {
        crate::input::create_ip_group_input::Builder::default()
    }
    /// Creates a new `CreateIpGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIpGroup {
    type Output =
        std::result::Result<crate::output::CreateIpGroupOutput, crate::error::CreateIpGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ip_group_error(response)
        } else {
            crate::operation_deser::parse_create_ip_group_response(response)
        }
    }
}

/// Operation shape for `CreateTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_tags`](crate::client::Client::create_tags).
///
/// See [`crate::client::fluent_builders::CreateTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTags {
    _private: (),
}
impl CreateTags {
    /// Creates a new builder-style object to manufacture [`CreateTagsInput`](crate::input::CreateTagsInput)
    pub fn builder() -> crate::input::create_tags_input::Builder {
        crate::input::create_tags_input::Builder::default()
    }
    /// Creates a new `CreateTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTags {
    type Output =
        std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_tags_error(response)
        } else {
            crate::operation_deser::parse_create_tags_response(response)
        }
    }
}

/// Operation shape for `CreateUpdatedWorkspaceImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_updated_workspace_image`](crate::client::Client::create_updated_workspace_image).
///
/// See [`crate::client::fluent_builders::CreateUpdatedWorkspaceImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUpdatedWorkspaceImage {
    _private: (),
}
impl CreateUpdatedWorkspaceImage {
    /// Creates a new builder-style object to manufacture [`CreateUpdatedWorkspaceImageInput`](crate::input::CreateUpdatedWorkspaceImageInput)
    pub fn builder() -> crate::input::create_updated_workspace_image_input::Builder {
        crate::input::create_updated_workspace_image_input::Builder::default()
    }
    /// Creates a new `CreateUpdatedWorkspaceImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUpdatedWorkspaceImage {
    type Output = std::result::Result<
        crate::output::CreateUpdatedWorkspaceImageOutput,
        crate::error::CreateUpdatedWorkspaceImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_updated_workspace_image_error(response)
        } else {
            crate::operation_deser::parse_create_updated_workspace_image_response(response)
        }
    }
}

/// Operation shape for `CreateWorkspaceBundle`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_workspace_bundle`](crate::client::Client::create_workspace_bundle).
///
/// See [`crate::client::fluent_builders::CreateWorkspaceBundle`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkspaceBundle {
    _private: (),
}
impl CreateWorkspaceBundle {
    /// Creates a new builder-style object to manufacture [`CreateWorkspaceBundleInput`](crate::input::CreateWorkspaceBundleInput)
    pub fn builder() -> crate::input::create_workspace_bundle_input::Builder {
        crate::input::create_workspace_bundle_input::Builder::default()
    }
    /// Creates a new `CreateWorkspaceBundle` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkspaceBundle {
    type Output = std::result::Result<
        crate::output::CreateWorkspaceBundleOutput,
        crate::error::CreateWorkspaceBundleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_workspace_bundle_error(response)
        } else {
            crate::operation_deser::parse_create_workspace_bundle_response(response)
        }
    }
}

/// Operation shape for `CreateWorkspaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_workspaces`](crate::client::Client::create_workspaces).
///
/// See [`crate::client::fluent_builders::CreateWorkspaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkspaces {
    _private: (),
}
impl CreateWorkspaces {
    /// Creates a new builder-style object to manufacture [`CreateWorkspacesInput`](crate::input::CreateWorkspacesInput)
    pub fn builder() -> crate::input::create_workspaces_input::Builder {
        crate::input::create_workspaces_input::Builder::default()
    }
    /// Creates a new `CreateWorkspaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkspaces {
    type Output = std::result::Result<
        crate::output::CreateWorkspacesOutput,
        crate::error::CreateWorkspacesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_workspaces_error(response)
        } else {
            crate::operation_deser::parse_create_workspaces_response(response)
        }
    }
}

/// Operation shape for `DeleteClientBranding`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_client_branding`](crate::client::Client::delete_client_branding).
///
/// See [`crate::client::fluent_builders::DeleteClientBranding`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteClientBranding {
    _private: (),
}
impl DeleteClientBranding {
    /// Creates a new builder-style object to manufacture [`DeleteClientBrandingInput`](crate::input::DeleteClientBrandingInput)
    pub fn builder() -> crate::input::delete_client_branding_input::Builder {
        crate::input::delete_client_branding_input::Builder::default()
    }
    /// Creates a new `DeleteClientBranding` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteClientBranding {
    type Output = std::result::Result<
        crate::output::DeleteClientBrandingOutput,
        crate::error::DeleteClientBrandingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_client_branding_error(response)
        } else {
            crate::operation_deser::parse_delete_client_branding_response(response)
        }
    }
}

/// Operation shape for `DeleteConnectClientAddIn`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connect_client_add_in`](crate::client::Client::delete_connect_client_add_in).
///
/// See [`crate::client::fluent_builders::DeleteConnectClientAddIn`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnectClientAddIn {
    _private: (),
}
impl DeleteConnectClientAddIn {
    /// Creates a new builder-style object to manufacture [`DeleteConnectClientAddInInput`](crate::input::DeleteConnectClientAddInInput)
    pub fn builder() -> crate::input::delete_connect_client_add_in_input::Builder {
        crate::input::delete_connect_client_add_in_input::Builder::default()
    }
    /// Creates a new `DeleteConnectClientAddIn` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnectClientAddIn {
    type Output = std::result::Result<
        crate::output::DeleteConnectClientAddInOutput,
        crate::error::DeleteConnectClientAddInError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connect_client_add_in_error(response)
        } else {
            crate::operation_deser::parse_delete_connect_client_add_in_response(response)
        }
    }
}

/// Operation shape for `DeleteConnectionAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connection_alias`](crate::client::Client::delete_connection_alias).
///
/// See [`crate::client::fluent_builders::DeleteConnectionAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnectionAlias {
    _private: (),
}
impl DeleteConnectionAlias {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionAliasInput`](crate::input::DeleteConnectionAliasInput)
    pub fn builder() -> crate::input::delete_connection_alias_input::Builder {
        crate::input::delete_connection_alias_input::Builder::default()
    }
    /// Creates a new `DeleteConnectionAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnectionAlias {
    type Output = std::result::Result<
        crate::output::DeleteConnectionAliasOutput,
        crate::error::DeleteConnectionAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connection_alias_error(response)
        } else {
            crate::operation_deser::parse_delete_connection_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteIpGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ip_group`](crate::client::Client::delete_ip_group).
///
/// See [`crate::client::fluent_builders::DeleteIpGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIpGroup {
    _private: (),
}
impl DeleteIpGroup {
    /// Creates a new builder-style object to manufacture [`DeleteIpGroupInput`](crate::input::DeleteIpGroupInput)
    pub fn builder() -> crate::input::delete_ip_group_input::Builder {
        crate::input::delete_ip_group_input::Builder::default()
    }
    /// Creates a new `DeleteIpGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIpGroup {
    type Output =
        std::result::Result<crate::output::DeleteIpGroupOutput, crate::error::DeleteIpGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ip_group_error(response)
        } else {
            crate::operation_deser::parse_delete_ip_group_response(response)
        }
    }
}

/// Operation shape for `DeleteTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tags`](crate::client::Client::delete_tags).
///
/// See [`crate::client::fluent_builders::DeleteTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTags {
    _private: (),
}
impl DeleteTags {
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
    /// Creates a new `DeleteTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTags {
    type Output =
        std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_tags_error(response)
        } else {
            crate::operation_deser::parse_delete_tags_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkspaceBundle`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_workspace_bundle`](crate::client::Client::delete_workspace_bundle).
///
/// See [`crate::client::fluent_builders::DeleteWorkspaceBundle`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkspaceBundle {
    _private: (),
}
impl DeleteWorkspaceBundle {
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceBundleInput`](crate::input::DeleteWorkspaceBundleInput)
    pub fn builder() -> crate::input::delete_workspace_bundle_input::Builder {
        crate::input::delete_workspace_bundle_input::Builder::default()
    }
    /// Creates a new `DeleteWorkspaceBundle` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkspaceBundle {
    type Output = std::result::Result<
        crate::output::DeleteWorkspaceBundleOutput,
        crate::error::DeleteWorkspaceBundleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_workspace_bundle_error(response)
        } else {
            crate::operation_deser::parse_delete_workspace_bundle_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkspaceImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_workspace_image`](crate::client::Client::delete_workspace_image).
///
/// See [`crate::client::fluent_builders::DeleteWorkspaceImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkspaceImage {
    _private: (),
}
impl DeleteWorkspaceImage {
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceImageInput`](crate::input::DeleteWorkspaceImageInput)
    pub fn builder() -> crate::input::delete_workspace_image_input::Builder {
        crate::input::delete_workspace_image_input::Builder::default()
    }
    /// Creates a new `DeleteWorkspaceImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkspaceImage {
    type Output = std::result::Result<
        crate::output::DeleteWorkspaceImageOutput,
        crate::error::DeleteWorkspaceImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_workspace_image_error(response)
        } else {
            crate::operation_deser::parse_delete_workspace_image_response(response)
        }
    }
}

/// Operation shape for `DeregisterWorkspaceDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_workspace_directory`](crate::client::Client::deregister_workspace_directory).
///
/// See [`crate::client::fluent_builders::DeregisterWorkspaceDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterWorkspaceDirectory {
    _private: (),
}
impl DeregisterWorkspaceDirectory {
    /// Creates a new builder-style object to manufacture [`DeregisterWorkspaceDirectoryInput`](crate::input::DeregisterWorkspaceDirectoryInput)
    pub fn builder() -> crate::input::deregister_workspace_directory_input::Builder {
        crate::input::deregister_workspace_directory_input::Builder::default()
    }
    /// Creates a new `DeregisterWorkspaceDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterWorkspaceDirectory {
    type Output = std::result::Result<
        crate::output::DeregisterWorkspaceDirectoryOutput,
        crate::error::DeregisterWorkspaceDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_workspace_directory_error(response)
        } else {
            crate::operation_deser::parse_deregister_workspace_directory_response(response)
        }
    }
}

/// Operation shape for `DescribeAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account`](crate::client::Client::describe_account).
///
/// See [`crate::client::fluent_builders::DescribeAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccount {
    _private: (),
}
impl DescribeAccount {
    /// Creates a new builder-style object to manufacture [`DescribeAccountInput`](crate::input::DescribeAccountInput)
    pub fn builder() -> crate::input::describe_account_input::Builder {
        crate::input::describe_account_input::Builder::default()
    }
    /// Creates a new `DescribeAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccount {
    type Output = std::result::Result<
        crate::output::DescribeAccountOutput,
        crate::error::DescribeAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_error(response)
        } else {
            crate::operation_deser::parse_describe_account_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountModifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_modifications`](crate::client::Client::describe_account_modifications).
///
/// See [`crate::client::fluent_builders::DescribeAccountModifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountModifications {
    _private: (),
}
impl DescribeAccountModifications {
    /// Creates a new builder-style object to manufacture [`DescribeAccountModificationsInput`](crate::input::DescribeAccountModificationsInput)
    pub fn builder() -> crate::input::describe_account_modifications_input::Builder {
        crate::input::describe_account_modifications_input::Builder::default()
    }
    /// Creates a new `DescribeAccountModifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountModifications {
    type Output = std::result::Result<
        crate::output::DescribeAccountModificationsOutput,
        crate::error::DescribeAccountModificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_modifications_error(response)
        } else {
            crate::operation_deser::parse_describe_account_modifications_response(response)
        }
    }
}

/// Operation shape for `DescribeClientBranding`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_client_branding`](crate::client::Client::describe_client_branding).
///
/// See [`crate::client::fluent_builders::DescribeClientBranding`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClientBranding {
    _private: (),
}
impl DescribeClientBranding {
    /// Creates a new builder-style object to manufacture [`DescribeClientBrandingInput`](crate::input::DescribeClientBrandingInput)
    pub fn builder() -> crate::input::describe_client_branding_input::Builder {
        crate::input::describe_client_branding_input::Builder::default()
    }
    /// Creates a new `DescribeClientBranding` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClientBranding {
    type Output = std::result::Result<
        crate::output::DescribeClientBrandingOutput,
        crate::error::DescribeClientBrandingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_client_branding_error(response)
        } else {
            crate::operation_deser::parse_describe_client_branding_response(response)
        }
    }
}

/// Operation shape for `DescribeClientProperties`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_client_properties`](crate::client::Client::describe_client_properties).
///
/// See [`crate::client::fluent_builders::DescribeClientProperties`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClientProperties {
    _private: (),
}
impl DescribeClientProperties {
    /// Creates a new builder-style object to manufacture [`DescribeClientPropertiesInput`](crate::input::DescribeClientPropertiesInput)
    pub fn builder() -> crate::input::describe_client_properties_input::Builder {
        crate::input::describe_client_properties_input::Builder::default()
    }
    /// Creates a new `DescribeClientProperties` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClientProperties {
    type Output = std::result::Result<
        crate::output::DescribeClientPropertiesOutput,
        crate::error::DescribeClientPropertiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_client_properties_error(response)
        } else {
            crate::operation_deser::parse_describe_client_properties_response(response)
        }
    }
}

/// Operation shape for `DescribeConnectClientAddIns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_connect_client_add_ins`](crate::client::Client::describe_connect_client_add_ins).
///
/// See [`crate::client::fluent_builders::DescribeConnectClientAddIns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConnectClientAddIns {
    _private: (),
}
impl DescribeConnectClientAddIns {
    /// Creates a new builder-style object to manufacture [`DescribeConnectClientAddInsInput`](crate::input::DescribeConnectClientAddInsInput)
    pub fn builder() -> crate::input::describe_connect_client_add_ins_input::Builder {
        crate::input::describe_connect_client_add_ins_input::Builder::default()
    }
    /// Creates a new `DescribeConnectClientAddIns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConnectClientAddIns {
    type Output = std::result::Result<
        crate::output::DescribeConnectClientAddInsOutput,
        crate::error::DescribeConnectClientAddInsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_connect_client_add_ins_error(response)
        } else {
            crate::operation_deser::parse_describe_connect_client_add_ins_response(response)
        }
    }
}

/// Operation shape for `DescribeConnectionAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_connection_aliases`](crate::client::Client::describe_connection_aliases).
///
/// See [`crate::client::fluent_builders::DescribeConnectionAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConnectionAliases {
    _private: (),
}
impl DescribeConnectionAliases {
    /// Creates a new builder-style object to manufacture [`DescribeConnectionAliasesInput`](crate::input::DescribeConnectionAliasesInput)
    pub fn builder() -> crate::input::describe_connection_aliases_input::Builder {
        crate::input::describe_connection_aliases_input::Builder::default()
    }
    /// Creates a new `DescribeConnectionAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConnectionAliases {
    type Output = std::result::Result<
        crate::output::DescribeConnectionAliasesOutput,
        crate::error::DescribeConnectionAliasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_connection_aliases_error(response)
        } else {
            crate::operation_deser::parse_describe_connection_aliases_response(response)
        }
    }
}

/// Operation shape for `DescribeConnectionAliasPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_connection_alias_permissions`](crate::client::Client::describe_connection_alias_permissions).
///
/// See [`crate::client::fluent_builders::DescribeConnectionAliasPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConnectionAliasPermissions {
    _private: (),
}
impl DescribeConnectionAliasPermissions {
    /// Creates a new builder-style object to manufacture [`DescribeConnectionAliasPermissionsInput`](crate::input::DescribeConnectionAliasPermissionsInput)
    pub fn builder() -> crate::input::describe_connection_alias_permissions_input::Builder {
        crate::input::describe_connection_alias_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeConnectionAliasPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConnectionAliasPermissions {
    type Output = std::result::Result<
        crate::output::DescribeConnectionAliasPermissionsOutput,
        crate::error::DescribeConnectionAliasPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_connection_alias_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_connection_alias_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeIpGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ip_groups`](crate::client::Client::describe_ip_groups).
///
/// See [`crate::client::fluent_builders::DescribeIpGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIpGroups {
    _private: (),
}
impl DescribeIpGroups {
    /// Creates a new builder-style object to manufacture [`DescribeIpGroupsInput`](crate::input::DescribeIpGroupsInput)
    pub fn builder() -> crate::input::describe_ip_groups_input::Builder {
        crate::input::describe_ip_groups_input::Builder::default()
    }
    /// Creates a new `DescribeIpGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIpGroups {
    type Output = std::result::Result<
        crate::output::DescribeIpGroupsOutput,
        crate::error::DescribeIpGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ip_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_ip_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tags`](crate::client::Client::describe_tags).
///
/// See [`crate::client::fluent_builders::DescribeTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTags {
    _private: (),
}
impl DescribeTags {
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
    /// Creates a new `DescribeTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTags {
    type Output =
        std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tags_error(response)
        } else {
            crate::operation_deser::parse_describe_tags_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkspaceBundles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workspace_bundles`](crate::client::Client::describe_workspace_bundles).
///
/// See [`crate::client::fluent_builders::DescribeWorkspaceBundles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkspaceBundles {
    _private: (),
}
impl DescribeWorkspaceBundles {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceBundlesInput`](crate::input::DescribeWorkspaceBundlesInput)
    pub fn builder() -> crate::input::describe_workspace_bundles_input::Builder {
        crate::input::describe_workspace_bundles_input::Builder::default()
    }
    /// Creates a new `DescribeWorkspaceBundles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkspaceBundles {
    type Output = std::result::Result<
        crate::output::DescribeWorkspaceBundlesOutput,
        crate::error::DescribeWorkspaceBundlesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workspace_bundles_error(response)
        } else {
            crate::operation_deser::parse_describe_workspace_bundles_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkspaceDirectories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workspace_directories`](crate::client::Client::describe_workspace_directories).
///
/// See [`crate::client::fluent_builders::DescribeWorkspaceDirectories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkspaceDirectories {
    _private: (),
}
impl DescribeWorkspaceDirectories {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceDirectoriesInput`](crate::input::DescribeWorkspaceDirectoriesInput)
    pub fn builder() -> crate::input::describe_workspace_directories_input::Builder {
        crate::input::describe_workspace_directories_input::Builder::default()
    }
    /// Creates a new `DescribeWorkspaceDirectories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkspaceDirectories {
    type Output = std::result::Result<
        crate::output::DescribeWorkspaceDirectoriesOutput,
        crate::error::DescribeWorkspaceDirectoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workspace_directories_error(response)
        } else {
            crate::operation_deser::parse_describe_workspace_directories_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkspaceImagePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workspace_image_permissions`](crate::client::Client::describe_workspace_image_permissions).
///
/// See [`crate::client::fluent_builders::DescribeWorkspaceImagePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkspaceImagePermissions {
    _private: (),
}
impl DescribeWorkspaceImagePermissions {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceImagePermissionsInput`](crate::input::DescribeWorkspaceImagePermissionsInput)
    pub fn builder() -> crate::input::describe_workspace_image_permissions_input::Builder {
        crate::input::describe_workspace_image_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeWorkspaceImagePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkspaceImagePermissions {
    type Output = std::result::Result<
        crate::output::DescribeWorkspaceImagePermissionsOutput,
        crate::error::DescribeWorkspaceImagePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workspace_image_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_workspace_image_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkspaceImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workspace_images`](crate::client::Client::describe_workspace_images).
///
/// See [`crate::client::fluent_builders::DescribeWorkspaceImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkspaceImages {
    _private: (),
}
impl DescribeWorkspaceImages {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceImagesInput`](crate::input::DescribeWorkspaceImagesInput)
    pub fn builder() -> crate::input::describe_workspace_images_input::Builder {
        crate::input::describe_workspace_images_input::Builder::default()
    }
    /// Creates a new `DescribeWorkspaceImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkspaceImages {
    type Output = std::result::Result<
        crate::output::DescribeWorkspaceImagesOutput,
        crate::error::DescribeWorkspaceImagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workspace_images_error(response)
        } else {
            crate::operation_deser::parse_describe_workspace_images_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkspaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workspaces`](crate::client::Client::describe_workspaces).
///
/// See [`crate::client::fluent_builders::DescribeWorkspaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkspaces {
    _private: (),
}
impl DescribeWorkspaces {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspacesInput`](crate::input::DescribeWorkspacesInput)
    pub fn builder() -> crate::input::describe_workspaces_input::Builder {
        crate::input::describe_workspaces_input::Builder::default()
    }
    /// Creates a new `DescribeWorkspaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkspaces {
    type Output = std::result::Result<
        crate::output::DescribeWorkspacesOutput,
        crate::error::DescribeWorkspacesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workspaces_error(response)
        } else {
            crate::operation_deser::parse_describe_workspaces_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkspacesConnectionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workspaces_connection_status`](crate::client::Client::describe_workspaces_connection_status).
///
/// See [`crate::client::fluent_builders::DescribeWorkspacesConnectionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkspacesConnectionStatus {
    _private: (),
}
impl DescribeWorkspacesConnectionStatus {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspacesConnectionStatusInput`](crate::input::DescribeWorkspacesConnectionStatusInput)
    pub fn builder() -> crate::input::describe_workspaces_connection_status_input::Builder {
        crate::input::describe_workspaces_connection_status_input::Builder::default()
    }
    /// Creates a new `DescribeWorkspacesConnectionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkspacesConnectionStatus {
    type Output = std::result::Result<
        crate::output::DescribeWorkspacesConnectionStatusOutput,
        crate::error::DescribeWorkspacesConnectionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workspaces_connection_status_error(response)
        } else {
            crate::operation_deser::parse_describe_workspaces_connection_status_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkspaceSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workspace_snapshots`](crate::client::Client::describe_workspace_snapshots).
///
/// See [`crate::client::fluent_builders::DescribeWorkspaceSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkspaceSnapshots {
    _private: (),
}
impl DescribeWorkspaceSnapshots {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceSnapshotsInput`](crate::input::DescribeWorkspaceSnapshotsInput)
    pub fn builder() -> crate::input::describe_workspace_snapshots_input::Builder {
        crate::input::describe_workspace_snapshots_input::Builder::default()
    }
    /// Creates a new `DescribeWorkspaceSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkspaceSnapshots {
    type Output = std::result::Result<
        crate::output::DescribeWorkspaceSnapshotsOutput,
        crate::error::DescribeWorkspaceSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workspace_snapshots_error(response)
        } else {
            crate::operation_deser::parse_describe_workspace_snapshots_response(response)
        }
    }
}

/// Operation shape for `DisassociateConnectionAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_connection_alias`](crate::client::Client::disassociate_connection_alias).
///
/// See [`crate::client::fluent_builders::DisassociateConnectionAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateConnectionAlias {
    _private: (),
}
impl DisassociateConnectionAlias {
    /// Creates a new builder-style object to manufacture [`DisassociateConnectionAliasInput`](crate::input::DisassociateConnectionAliasInput)
    pub fn builder() -> crate::input::disassociate_connection_alias_input::Builder {
        crate::input::disassociate_connection_alias_input::Builder::default()
    }
    /// Creates a new `DisassociateConnectionAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateConnectionAlias {
    type Output = std::result::Result<
        crate::output::DisassociateConnectionAliasOutput,
        crate::error::DisassociateConnectionAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_connection_alias_error(response)
        } else {
            crate::operation_deser::parse_disassociate_connection_alias_response(response)
        }
    }
}

/// Operation shape for `DisassociateIpGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_ip_groups`](crate::client::Client::disassociate_ip_groups).
///
/// See [`crate::client::fluent_builders::DisassociateIpGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateIpGroups {
    _private: (),
}
impl DisassociateIpGroups {
    /// Creates a new builder-style object to manufacture [`DisassociateIpGroupsInput`](crate::input::DisassociateIpGroupsInput)
    pub fn builder() -> crate::input::disassociate_ip_groups_input::Builder {
        crate::input::disassociate_ip_groups_input::Builder::default()
    }
    /// Creates a new `DisassociateIpGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateIpGroups {
    type Output = std::result::Result<
        crate::output::DisassociateIpGroupsOutput,
        crate::error::DisassociateIpGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_ip_groups_error(response)
        } else {
            crate::operation_deser::parse_disassociate_ip_groups_response(response)
        }
    }
}

/// Operation shape for `ImportClientBranding`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_client_branding`](crate::client::Client::import_client_branding).
///
/// See [`crate::client::fluent_builders::ImportClientBranding`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportClientBranding {
    _private: (),
}
impl ImportClientBranding {
    /// Creates a new builder-style object to manufacture [`ImportClientBrandingInput`](crate::input::ImportClientBrandingInput)
    pub fn builder() -> crate::input::import_client_branding_input::Builder {
        crate::input::import_client_branding_input::Builder::default()
    }
    /// Creates a new `ImportClientBranding` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportClientBranding {
    type Output = std::result::Result<
        crate::output::ImportClientBrandingOutput,
        crate::error::ImportClientBrandingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_client_branding_error(response)
        } else {
            crate::operation_deser::parse_import_client_branding_response(response)
        }
    }
}

/// Operation shape for `ImportWorkspaceImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_workspace_image`](crate::client::Client::import_workspace_image).
///
/// See [`crate::client::fluent_builders::ImportWorkspaceImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportWorkspaceImage {
    _private: (),
}
impl ImportWorkspaceImage {
    /// Creates a new builder-style object to manufacture [`ImportWorkspaceImageInput`](crate::input::ImportWorkspaceImageInput)
    pub fn builder() -> crate::input::import_workspace_image_input::Builder {
        crate::input::import_workspace_image_input::Builder::default()
    }
    /// Creates a new `ImportWorkspaceImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportWorkspaceImage {
    type Output = std::result::Result<
        crate::output::ImportWorkspaceImageOutput,
        crate::error::ImportWorkspaceImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_workspace_image_error(response)
        } else {
            crate::operation_deser::parse_import_workspace_image_response(response)
        }
    }
}

/// Operation shape for `ListAvailableManagementCidrRanges`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_available_management_cidr_ranges`](crate::client::Client::list_available_management_cidr_ranges).
///
/// See [`crate::client::fluent_builders::ListAvailableManagementCidrRanges`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAvailableManagementCidrRanges {
    _private: (),
}
impl ListAvailableManagementCidrRanges {
    /// Creates a new builder-style object to manufacture [`ListAvailableManagementCidrRangesInput`](crate::input::ListAvailableManagementCidrRangesInput)
    pub fn builder() -> crate::input::list_available_management_cidr_ranges_input::Builder {
        crate::input::list_available_management_cidr_ranges_input::Builder::default()
    }
    /// Creates a new `ListAvailableManagementCidrRanges` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAvailableManagementCidrRanges {
    type Output = std::result::Result<
        crate::output::ListAvailableManagementCidrRangesOutput,
        crate::error::ListAvailableManagementCidrRangesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_available_management_cidr_ranges_error(response)
        } else {
            crate::operation_deser::parse_list_available_management_cidr_ranges_response(response)
        }
    }
}

/// Operation shape for `MigrateWorkspace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`migrate_workspace`](crate::client::Client::migrate_workspace).
///
/// See [`crate::client::fluent_builders::MigrateWorkspace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MigrateWorkspace {
    _private: (),
}
impl MigrateWorkspace {
    /// Creates a new builder-style object to manufacture [`MigrateWorkspaceInput`](crate::input::MigrateWorkspaceInput)
    pub fn builder() -> crate::input::migrate_workspace_input::Builder {
        crate::input::migrate_workspace_input::Builder::default()
    }
    /// Creates a new `MigrateWorkspace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MigrateWorkspace {
    type Output = std::result::Result<
        crate::output::MigrateWorkspaceOutput,
        crate::error::MigrateWorkspaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_migrate_workspace_error(response)
        } else {
            crate::operation_deser::parse_migrate_workspace_response(response)
        }
    }
}

/// Operation shape for `ModifyAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_account`](crate::client::Client::modify_account).
///
/// See [`crate::client::fluent_builders::ModifyAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyAccount {
    _private: (),
}
impl ModifyAccount {
    /// Creates a new builder-style object to manufacture [`ModifyAccountInput`](crate::input::ModifyAccountInput)
    pub fn builder() -> crate::input::modify_account_input::Builder {
        crate::input::modify_account_input::Builder::default()
    }
    /// Creates a new `ModifyAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyAccount {
    type Output =
        std::result::Result<crate::output::ModifyAccountOutput, crate::error::ModifyAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_account_error(response)
        } else {
            crate::operation_deser::parse_modify_account_response(response)
        }
    }
}

/// Operation shape for `ModifyClientProperties`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_client_properties`](crate::client::Client::modify_client_properties).
///
/// See [`crate::client::fluent_builders::ModifyClientProperties`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyClientProperties {
    _private: (),
}
impl ModifyClientProperties {
    /// Creates a new builder-style object to manufacture [`ModifyClientPropertiesInput`](crate::input::ModifyClientPropertiesInput)
    pub fn builder() -> crate::input::modify_client_properties_input::Builder {
        crate::input::modify_client_properties_input::Builder::default()
    }
    /// Creates a new `ModifyClientProperties` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyClientProperties {
    type Output = std::result::Result<
        crate::output::ModifyClientPropertiesOutput,
        crate::error::ModifyClientPropertiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_client_properties_error(response)
        } else {
            crate::operation_deser::parse_modify_client_properties_response(response)
        }
    }
}

/// Operation shape for `ModifySelfservicePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_selfservice_permissions`](crate::client::Client::modify_selfservice_permissions).
///
/// See [`crate::client::fluent_builders::ModifySelfservicePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifySelfservicePermissions {
    _private: (),
}
impl ModifySelfservicePermissions {
    /// Creates a new builder-style object to manufacture [`ModifySelfservicePermissionsInput`](crate::input::ModifySelfservicePermissionsInput)
    pub fn builder() -> crate::input::modify_selfservice_permissions_input::Builder {
        crate::input::modify_selfservice_permissions_input::Builder::default()
    }
    /// Creates a new `ModifySelfservicePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifySelfservicePermissions {
    type Output = std::result::Result<
        crate::output::ModifySelfservicePermissionsOutput,
        crate::error::ModifySelfservicePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_selfservice_permissions_error(response)
        } else {
            crate::operation_deser::parse_modify_selfservice_permissions_response(response)
        }
    }
}

/// Operation shape for `ModifyWorkspaceAccessProperties`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_workspace_access_properties`](crate::client::Client::modify_workspace_access_properties).
///
/// See [`crate::client::fluent_builders::ModifyWorkspaceAccessProperties`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyWorkspaceAccessProperties {
    _private: (),
}
impl ModifyWorkspaceAccessProperties {
    /// Creates a new builder-style object to manufacture [`ModifyWorkspaceAccessPropertiesInput`](crate::input::ModifyWorkspaceAccessPropertiesInput)
    pub fn builder() -> crate::input::modify_workspace_access_properties_input::Builder {
        crate::input::modify_workspace_access_properties_input::Builder::default()
    }
    /// Creates a new `ModifyWorkspaceAccessProperties` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyWorkspaceAccessProperties {
    type Output = std::result::Result<
        crate::output::ModifyWorkspaceAccessPropertiesOutput,
        crate::error::ModifyWorkspaceAccessPropertiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_workspace_access_properties_error(response)
        } else {
            crate::operation_deser::parse_modify_workspace_access_properties_response(response)
        }
    }
}

/// Operation shape for `ModifyWorkspaceCreationProperties`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_workspace_creation_properties`](crate::client::Client::modify_workspace_creation_properties).
///
/// See [`crate::client::fluent_builders::ModifyWorkspaceCreationProperties`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyWorkspaceCreationProperties {
    _private: (),
}
impl ModifyWorkspaceCreationProperties {
    /// Creates a new builder-style object to manufacture [`ModifyWorkspaceCreationPropertiesInput`](crate::input::ModifyWorkspaceCreationPropertiesInput)
    pub fn builder() -> crate::input::modify_workspace_creation_properties_input::Builder {
        crate::input::modify_workspace_creation_properties_input::Builder::default()
    }
    /// Creates a new `ModifyWorkspaceCreationProperties` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyWorkspaceCreationProperties {
    type Output = std::result::Result<
        crate::output::ModifyWorkspaceCreationPropertiesOutput,
        crate::error::ModifyWorkspaceCreationPropertiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_workspace_creation_properties_error(response)
        } else {
            crate::operation_deser::parse_modify_workspace_creation_properties_response(response)
        }
    }
}

/// Operation shape for `ModifyWorkspaceProperties`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_workspace_properties`](crate::client::Client::modify_workspace_properties).
///
/// See [`crate::client::fluent_builders::ModifyWorkspaceProperties`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyWorkspaceProperties {
    _private: (),
}
impl ModifyWorkspaceProperties {
    /// Creates a new builder-style object to manufacture [`ModifyWorkspacePropertiesInput`](crate::input::ModifyWorkspacePropertiesInput)
    pub fn builder() -> crate::input::modify_workspace_properties_input::Builder {
        crate::input::modify_workspace_properties_input::Builder::default()
    }
    /// Creates a new `ModifyWorkspaceProperties` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyWorkspaceProperties {
    type Output = std::result::Result<
        crate::output::ModifyWorkspacePropertiesOutput,
        crate::error::ModifyWorkspacePropertiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_workspace_properties_error(response)
        } else {
            crate::operation_deser::parse_modify_workspace_properties_response(response)
        }
    }
}

/// Operation shape for `ModifyWorkspaceState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_workspace_state`](crate::client::Client::modify_workspace_state).
///
/// See [`crate::client::fluent_builders::ModifyWorkspaceState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyWorkspaceState {
    _private: (),
}
impl ModifyWorkspaceState {
    /// Creates a new builder-style object to manufacture [`ModifyWorkspaceStateInput`](crate::input::ModifyWorkspaceStateInput)
    pub fn builder() -> crate::input::modify_workspace_state_input::Builder {
        crate::input::modify_workspace_state_input::Builder::default()
    }
    /// Creates a new `ModifyWorkspaceState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyWorkspaceState {
    type Output = std::result::Result<
        crate::output::ModifyWorkspaceStateOutput,
        crate::error::ModifyWorkspaceStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_workspace_state_error(response)
        } else {
            crate::operation_deser::parse_modify_workspace_state_response(response)
        }
    }
}

/// Operation shape for `RebootWorkspaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reboot_workspaces`](crate::client::Client::reboot_workspaces).
///
/// See [`crate::client::fluent_builders::RebootWorkspaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebootWorkspaces {
    _private: (),
}
impl RebootWorkspaces {
    /// Creates a new builder-style object to manufacture [`RebootWorkspacesInput`](crate::input::RebootWorkspacesInput)
    pub fn builder() -> crate::input::reboot_workspaces_input::Builder {
        crate::input::reboot_workspaces_input::Builder::default()
    }
    /// Creates a new `RebootWorkspaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebootWorkspaces {
    type Output = std::result::Result<
        crate::output::RebootWorkspacesOutput,
        crate::error::RebootWorkspacesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reboot_workspaces_error(response)
        } else {
            crate::operation_deser::parse_reboot_workspaces_response(response)
        }
    }
}

/// Operation shape for `RebuildWorkspaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`rebuild_workspaces`](crate::client::Client::rebuild_workspaces).
///
/// See [`crate::client::fluent_builders::RebuildWorkspaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebuildWorkspaces {
    _private: (),
}
impl RebuildWorkspaces {
    /// Creates a new builder-style object to manufacture [`RebuildWorkspacesInput`](crate::input::RebuildWorkspacesInput)
    pub fn builder() -> crate::input::rebuild_workspaces_input::Builder {
        crate::input::rebuild_workspaces_input::Builder::default()
    }
    /// Creates a new `RebuildWorkspaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebuildWorkspaces {
    type Output = std::result::Result<
        crate::output::RebuildWorkspacesOutput,
        crate::error::RebuildWorkspacesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_rebuild_workspaces_error(response)
        } else {
            crate::operation_deser::parse_rebuild_workspaces_response(response)
        }
    }
}

/// Operation shape for `RegisterWorkspaceDirectory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_workspace_directory`](crate::client::Client::register_workspace_directory).
///
/// See [`crate::client::fluent_builders::RegisterWorkspaceDirectory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterWorkspaceDirectory {
    _private: (),
}
impl RegisterWorkspaceDirectory {
    /// Creates a new builder-style object to manufacture [`RegisterWorkspaceDirectoryInput`](crate::input::RegisterWorkspaceDirectoryInput)
    pub fn builder() -> crate::input::register_workspace_directory_input::Builder {
        crate::input::register_workspace_directory_input::Builder::default()
    }
    /// Creates a new `RegisterWorkspaceDirectory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterWorkspaceDirectory {
    type Output = std::result::Result<
        crate::output::RegisterWorkspaceDirectoryOutput,
        crate::error::RegisterWorkspaceDirectoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_workspace_directory_error(response)
        } else {
            crate::operation_deser::parse_register_workspace_directory_response(response)
        }
    }
}

/// Operation shape for `RestoreWorkspace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_workspace`](crate::client::Client::restore_workspace).
///
/// See [`crate::client::fluent_builders::RestoreWorkspace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreWorkspace {
    _private: (),
}
impl RestoreWorkspace {
    /// Creates a new builder-style object to manufacture [`RestoreWorkspaceInput`](crate::input::RestoreWorkspaceInput)
    pub fn builder() -> crate::input::restore_workspace_input::Builder {
        crate::input::restore_workspace_input::Builder::default()
    }
    /// Creates a new `RestoreWorkspace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreWorkspace {
    type Output = std::result::Result<
        crate::output::RestoreWorkspaceOutput,
        crate::error::RestoreWorkspaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_workspace_error(response)
        } else {
            crate::operation_deser::parse_restore_workspace_response(response)
        }
    }
}

/// Operation shape for `RevokeIpRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_ip_rules`](crate::client::Client::revoke_ip_rules).
///
/// See [`crate::client::fluent_builders::RevokeIpRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeIpRules {
    _private: (),
}
impl RevokeIpRules {
    /// Creates a new builder-style object to manufacture [`RevokeIpRulesInput`](crate::input::RevokeIpRulesInput)
    pub fn builder() -> crate::input::revoke_ip_rules_input::Builder {
        crate::input::revoke_ip_rules_input::Builder::default()
    }
    /// Creates a new `RevokeIpRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeIpRules {
    type Output =
        std::result::Result<crate::output::RevokeIpRulesOutput, crate::error::RevokeIpRulesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_ip_rules_error(response)
        } else {
            crate::operation_deser::parse_revoke_ip_rules_response(response)
        }
    }
}

/// Operation shape for `StartWorkspaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_workspaces`](crate::client::Client::start_workspaces).
///
/// See [`crate::client::fluent_builders::StartWorkspaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartWorkspaces {
    _private: (),
}
impl StartWorkspaces {
    /// Creates a new builder-style object to manufacture [`StartWorkspacesInput`](crate::input::StartWorkspacesInput)
    pub fn builder() -> crate::input::start_workspaces_input::Builder {
        crate::input::start_workspaces_input::Builder::default()
    }
    /// Creates a new `StartWorkspaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartWorkspaces {
    type Output = std::result::Result<
        crate::output::StartWorkspacesOutput,
        crate::error::StartWorkspacesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_workspaces_error(response)
        } else {
            crate::operation_deser::parse_start_workspaces_response(response)
        }
    }
}

/// Operation shape for `StopWorkspaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_workspaces`](crate::client::Client::stop_workspaces).
///
/// See [`crate::client::fluent_builders::StopWorkspaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopWorkspaces {
    _private: (),
}
impl StopWorkspaces {
    /// Creates a new builder-style object to manufacture [`StopWorkspacesInput`](crate::input::StopWorkspacesInput)
    pub fn builder() -> crate::input::stop_workspaces_input::Builder {
        crate::input::stop_workspaces_input::Builder::default()
    }
    /// Creates a new `StopWorkspaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopWorkspaces {
    type Output =
        std::result::Result<crate::output::StopWorkspacesOutput, crate::error::StopWorkspacesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_workspaces_error(response)
        } else {
            crate::operation_deser::parse_stop_workspaces_response(response)
        }
    }
}

/// Operation shape for `TerminateWorkspaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_workspaces`](crate::client::Client::terminate_workspaces).
///
/// See [`crate::client::fluent_builders::TerminateWorkspaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateWorkspaces {
    _private: (),
}
impl TerminateWorkspaces {
    /// Creates a new builder-style object to manufacture [`TerminateWorkspacesInput`](crate::input::TerminateWorkspacesInput)
    pub fn builder() -> crate::input::terminate_workspaces_input::Builder {
        crate::input::terminate_workspaces_input::Builder::default()
    }
    /// Creates a new `TerminateWorkspaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateWorkspaces {
    type Output = std::result::Result<
        crate::output::TerminateWorkspacesOutput,
        crate::error::TerminateWorkspacesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_workspaces_error(response)
        } else {
            crate::operation_deser::parse_terminate_workspaces_response(response)
        }
    }
}

/// Operation shape for `UpdateConnectClientAddIn`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_connect_client_add_in`](crate::client::Client::update_connect_client_add_in).
///
/// See [`crate::client::fluent_builders::UpdateConnectClientAddIn`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConnectClientAddIn {
    _private: (),
}
impl UpdateConnectClientAddIn {
    /// Creates a new builder-style object to manufacture [`UpdateConnectClientAddInInput`](crate::input::UpdateConnectClientAddInInput)
    pub fn builder() -> crate::input::update_connect_client_add_in_input::Builder {
        crate::input::update_connect_client_add_in_input::Builder::default()
    }
    /// Creates a new `UpdateConnectClientAddIn` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConnectClientAddIn {
    type Output = std::result::Result<
        crate::output::UpdateConnectClientAddInOutput,
        crate::error::UpdateConnectClientAddInError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_connect_client_add_in_error(response)
        } else {
            crate::operation_deser::parse_update_connect_client_add_in_response(response)
        }
    }
}

/// Operation shape for `UpdateConnectionAliasPermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_connection_alias_permission`](crate::client::Client::update_connection_alias_permission).
///
/// See [`crate::client::fluent_builders::UpdateConnectionAliasPermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConnectionAliasPermission {
    _private: (),
}
impl UpdateConnectionAliasPermission {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionAliasPermissionInput`](crate::input::UpdateConnectionAliasPermissionInput)
    pub fn builder() -> crate::input::update_connection_alias_permission_input::Builder {
        crate::input::update_connection_alias_permission_input::Builder::default()
    }
    /// Creates a new `UpdateConnectionAliasPermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConnectionAliasPermission {
    type Output = std::result::Result<
        crate::output::UpdateConnectionAliasPermissionOutput,
        crate::error::UpdateConnectionAliasPermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_connection_alias_permission_error(response)
        } else {
            crate::operation_deser::parse_update_connection_alias_permission_response(response)
        }
    }
}

/// Operation shape for `UpdateRulesOfIpGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_rules_of_ip_group`](crate::client::Client::update_rules_of_ip_group).
///
/// See [`crate::client::fluent_builders::UpdateRulesOfIpGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRulesOfIpGroup {
    _private: (),
}
impl UpdateRulesOfIpGroup {
    /// Creates a new builder-style object to manufacture [`UpdateRulesOfIpGroupInput`](crate::input::UpdateRulesOfIpGroupInput)
    pub fn builder() -> crate::input::update_rules_of_ip_group_input::Builder {
        crate::input::update_rules_of_ip_group_input::Builder::default()
    }
    /// Creates a new `UpdateRulesOfIpGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRulesOfIpGroup {
    type Output = std::result::Result<
        crate::output::UpdateRulesOfIpGroupOutput,
        crate::error::UpdateRulesOfIpGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_rules_of_ip_group_error(response)
        } else {
            crate::operation_deser::parse_update_rules_of_ip_group_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkspaceBundle`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_workspace_bundle`](crate::client::Client::update_workspace_bundle).
///
/// See [`crate::client::fluent_builders::UpdateWorkspaceBundle`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkspaceBundle {
    _private: (),
}
impl UpdateWorkspaceBundle {
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceBundleInput`](crate::input::UpdateWorkspaceBundleInput)
    pub fn builder() -> crate::input::update_workspace_bundle_input::Builder {
        crate::input::update_workspace_bundle_input::Builder::default()
    }
    /// Creates a new `UpdateWorkspaceBundle` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkspaceBundle {
    type Output = std::result::Result<
        crate::output::UpdateWorkspaceBundleOutput,
        crate::error::UpdateWorkspaceBundleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_workspace_bundle_error(response)
        } else {
            crate::operation_deser::parse_update_workspace_bundle_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkspaceImagePermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_workspace_image_permission`](crate::client::Client::update_workspace_image_permission).
///
/// See [`crate::client::fluent_builders::UpdateWorkspaceImagePermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkspaceImagePermission {
    _private: (),
}
impl UpdateWorkspaceImagePermission {
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceImagePermissionInput`](crate::input::UpdateWorkspaceImagePermissionInput)
    pub fn builder() -> crate::input::update_workspace_image_permission_input::Builder {
        crate::input::update_workspace_image_permission_input::Builder::default()
    }
    /// Creates a new `UpdateWorkspaceImagePermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkspaceImagePermission {
    type Output = std::result::Result<
        crate::output::UpdateWorkspaceImagePermissionOutput,
        crate::error::UpdateWorkspaceImagePermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_workspace_image_permission_error(response)
        } else {
            crate::operation_deser::parse_update_workspace_image_permission_response(response)
        }
    }
}
