// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateConnectionAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateConnectionAliasError {
    /// Kind of error that occurred.
    pub kind: AssociateConnectionAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateConnectionAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateConnectionAliasErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The resource is associated with a directory.</p>
    ResourceAssociatedException(crate::error::ResourceAssociatedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateConnectionAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateConnectionAliasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateConnectionAliasErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            AssociateConnectionAliasErrorKind::InvalidResourceStateException(_inner) => {
                _inner.fmt(f)
            }
            AssociateConnectionAliasErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateConnectionAliasErrorKind::ResourceAssociatedException(_inner) => _inner.fmt(f),
            AssociateConnectionAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateConnectionAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateConnectionAliasError {
    fn code(&self) -> Option<&str> {
        AssociateConnectionAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateConnectionAliasError {
    /// Creates a new `AssociateConnectionAliasError`.
    pub fn new(kind: AssociateConnectionAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateConnectionAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateConnectionAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateConnectionAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateConnectionAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateConnectionAliasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectionAliasErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectionAliasErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectionAliasErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectionAliasErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectionAliasErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectionAliasErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectionAliasErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectionAliasErrorKind::ResourceAssociatedException`.
    pub fn is_resource_associated_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectionAliasErrorKind::ResourceAssociatedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateConnectionAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateConnectionAliasErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateConnectionAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateConnectionAliasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateConnectionAliasErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            AssociateConnectionAliasErrorKind::InvalidResourceStateException(_inner) => {
                Some(_inner)
            }
            AssociateConnectionAliasErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            AssociateConnectionAliasErrorKind::ResourceAssociatedException(_inner) => Some(_inner),
            AssociateConnectionAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateConnectionAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateIpGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateIpGroupsError {
    /// Kind of error that occurred.
    pub kind: AssociateIpGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateIpGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateIpGroupsErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateIpGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateIpGroupsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateIpGroupsErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            AssociateIpGroupsErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            AssociateIpGroupsErrorKind::OperationNotSupportedException(_inner) => _inner.fmt(f),
            AssociateIpGroupsErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            AssociateIpGroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateIpGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateIpGroupsError {
    fn code(&self) -> Option<&str> {
        AssociateIpGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateIpGroupsError {
    /// Creates a new `AssociateIpGroupsError`.
    pub fn new(kind: AssociateIpGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateIpGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateIpGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateIpGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateIpGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateIpGroupsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIpGroupsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateIpGroupsErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIpGroupsErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateIpGroupsErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIpGroupsErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateIpGroupsErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIpGroupsErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateIpGroupsErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIpGroupsErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateIpGroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIpGroupsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateIpGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateIpGroupsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateIpGroupsErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            AssociateIpGroupsErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            AssociateIpGroupsErrorKind::OperationNotSupportedException(_inner) => Some(_inner),
            AssociateIpGroupsErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            AssociateIpGroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateIpGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AuthorizeIpRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AuthorizeIpRulesError {
    /// Kind of error that occurred.
    pub kind: AuthorizeIpRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AuthorizeIpRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AuthorizeIpRulesErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AuthorizeIpRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AuthorizeIpRulesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AuthorizeIpRulesErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            AuthorizeIpRulesErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            AuthorizeIpRulesErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            AuthorizeIpRulesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AuthorizeIpRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AuthorizeIpRulesError {
    fn code(&self) -> Option<&str> {
        AuthorizeIpRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AuthorizeIpRulesError {
    /// Creates a new `AuthorizeIpRulesError`.
    pub fn new(kind: AuthorizeIpRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AuthorizeIpRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AuthorizeIpRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AuthorizeIpRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AuthorizeIpRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AuthorizeIpRulesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeIpRulesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeIpRulesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeIpRulesErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeIpRulesErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeIpRulesErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeIpRulesErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeIpRulesErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeIpRulesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeIpRulesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AuthorizeIpRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AuthorizeIpRulesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AuthorizeIpRulesErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            AuthorizeIpRulesErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            AuthorizeIpRulesErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            AuthorizeIpRulesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AuthorizeIpRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyWorkspaceImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyWorkspaceImageError {
    /// Kind of error that occurred.
    pub kind: CopyWorkspaceImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyWorkspaceImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyWorkspaceImageErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyWorkspaceImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyWorkspaceImageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CopyWorkspaceImageErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            CopyWorkspaceImageErrorKind::OperationNotSupportedException(_inner) => _inner.fmt(f),
            CopyWorkspaceImageErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CopyWorkspaceImageErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CopyWorkspaceImageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CopyWorkspaceImageErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            CopyWorkspaceImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyWorkspaceImageError {
    fn code(&self) -> Option<&str> {
        CopyWorkspaceImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyWorkspaceImageError {
    /// Creates a new `CopyWorkspaceImageError`.
    pub fn new(kind: CopyWorkspaceImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyWorkspaceImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyWorkspaceImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyWorkspaceImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyWorkspaceImageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyWorkspaceImageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyWorkspaceImageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyWorkspaceImageErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyWorkspaceImageErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyWorkspaceImageErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyWorkspaceImageErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyWorkspaceImageErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyWorkspaceImageErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyWorkspaceImageErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyWorkspaceImageErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyWorkspaceImageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyWorkspaceImageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyWorkspaceImageErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyWorkspaceImageErrorKind::ResourceUnavailableException(_)
        )
    }
}
impl std::error::Error for CopyWorkspaceImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyWorkspaceImageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CopyWorkspaceImageErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            CopyWorkspaceImageErrorKind::OperationNotSupportedException(_inner) => Some(_inner),
            CopyWorkspaceImageErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CopyWorkspaceImageErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CopyWorkspaceImageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CopyWorkspaceImageErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            CopyWorkspaceImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConnectClientAddIn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectClientAddInError {
    /// Kind of error that occurred.
    pub kind: CreateConnectClientAddInErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnectClientAddIn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectClientAddInErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The resource could not be created.</p>
    ResourceCreationFailedException(crate::error::ResourceCreationFailedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectClientAddInError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectClientAddInErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateConnectClientAddInErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            CreateConnectClientAddInErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateConnectClientAddInErrorKind::ResourceCreationFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreateConnectClientAddInErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateConnectClientAddInErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectClientAddInError {
    fn code(&self) -> Option<&str> {
        CreateConnectClientAddInError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectClientAddInError {
    /// Creates a new `CreateConnectClientAddInError`.
    pub fn new(kind: CreateConnectClientAddInErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectClientAddInError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectClientAddInErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectClientAddInError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectClientAddInErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConnectClientAddInErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectClientAddInErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectClientAddInErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectClientAddInErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectClientAddInErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectClientAddInErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectClientAddInErrorKind::ResourceCreationFailedException`.
    pub fn is_resource_creation_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectClientAddInErrorKind::ResourceCreationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectClientAddInErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectClientAddInErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateConnectClientAddInError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectClientAddInErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateConnectClientAddInErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            CreateConnectClientAddInErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateConnectClientAddInErrorKind::ResourceCreationFailedException(_inner) => {
                Some(_inner)
            }
            CreateConnectClientAddInErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateConnectClientAddInErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConnectionAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectionAliasError {
    /// Kind of error that occurred.
    pub kind: CreateConnectionAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnectionAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectionAliasErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectionAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectionAliasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateConnectionAliasErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            CreateConnectionAliasErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            CreateConnectionAliasErrorKind::OperationNotSupportedException(_inner) => _inner.fmt(f),
            CreateConnectionAliasErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateConnectionAliasErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateConnectionAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectionAliasError {
    fn code(&self) -> Option<&str> {
        CreateConnectionAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectionAliasError {
    /// Creates a new `CreateConnectionAliasError`.
    pub fn new(kind: CreateConnectionAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectionAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectionAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectionAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectionAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConnectionAliasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionAliasErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionAliasErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionAliasErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionAliasErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionAliasErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionAliasErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionAliasErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionAliasErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionAliasErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionAliasErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionAliasErrorKind::ResourceLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateConnectionAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectionAliasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateConnectionAliasErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            CreateConnectionAliasErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            CreateConnectionAliasErrorKind::OperationNotSupportedException(_inner) => Some(_inner),
            CreateConnectionAliasErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateConnectionAliasErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateConnectionAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIpGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIpGroupError {
    /// Kind of error that occurred.
    pub kind: CreateIpGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIpGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIpGroupErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The resource could not be created.</p>
    ResourceCreationFailedException(crate::error::ResourceCreationFailedException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIpGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIpGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateIpGroupErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            CreateIpGroupErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateIpGroupErrorKind::ResourceCreationFailedException(_inner) => _inner.fmt(f),
            CreateIpGroupErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateIpGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIpGroupError {
    fn code(&self) -> Option<&str> {
        CreateIpGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIpGroupError {
    /// Creates a new `CreateIpGroupError`.
    pub fn new(kind: CreateIpGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIpGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIpGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIpGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIpGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIpGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateIpGroupErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateIpGroupErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIpGroupErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIpGroupErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIpGroupErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIpGroupErrorKind::ResourceCreationFailedException`.
    pub fn is_resource_creation_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIpGroupErrorKind::ResourceCreationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIpGroupErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIpGroupErrorKind::ResourceLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateIpGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIpGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateIpGroupErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            CreateIpGroupErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateIpGroupErrorKind::ResourceCreationFailedException(_inner) => Some(_inner),
            CreateIpGroupErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateIpGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTagsError {
    /// Kind of error that occurred.
    pub kind: CreateTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTagsErrorKind {
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTagsErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTagsError {
    fn code(&self) -> Option<&str> {
        CreateTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTagsError {
    /// Creates a new `CreateTagsError`.
    pub fn new(kind: CreateTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTagsErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTagsErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTagsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTagsErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            CreateTagsErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUpdatedWorkspaceImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUpdatedWorkspaceImageError {
    /// Kind of error that occurred.
    pub kind: CreateUpdatedWorkspaceImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUpdatedWorkspaceImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUpdatedWorkspaceImageErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUpdatedWorkspaceImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUpdatedWorkspaceImageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateUpdatedWorkspaceImageErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            CreateUpdatedWorkspaceImageErrorKind::InvalidResourceStateException(_inner) => {
                _inner.fmt(f)
            }
            CreateUpdatedWorkspaceImageErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            CreateUpdatedWorkspaceImageErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateUpdatedWorkspaceImageErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateUpdatedWorkspaceImageErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateUpdatedWorkspaceImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUpdatedWorkspaceImageError {
    fn code(&self) -> Option<&str> {
        CreateUpdatedWorkspaceImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUpdatedWorkspaceImageError {
    /// Creates a new `CreateUpdatedWorkspaceImageError`.
    pub fn new(kind: CreateUpdatedWorkspaceImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUpdatedWorkspaceImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUpdatedWorkspaceImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUpdatedWorkspaceImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUpdatedWorkspaceImageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUpdatedWorkspaceImageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedWorkspaceImageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedWorkspaceImageErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedWorkspaceImageErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedWorkspaceImageErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedWorkspaceImageErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedWorkspaceImageErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedWorkspaceImageErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedWorkspaceImageErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedWorkspaceImageErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedWorkspaceImageErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedWorkspaceImageErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedWorkspaceImageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedWorkspaceImageErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateUpdatedWorkspaceImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUpdatedWorkspaceImageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateUpdatedWorkspaceImageErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            CreateUpdatedWorkspaceImageErrorKind::InvalidResourceStateException(_inner) => {
                Some(_inner)
            }
            CreateUpdatedWorkspaceImageErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            CreateUpdatedWorkspaceImageErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateUpdatedWorkspaceImageErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateUpdatedWorkspaceImageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateUpdatedWorkspaceImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkspaceBundle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkspaceBundleError {
    /// Kind of error that occurred.
    pub kind: CreateWorkspaceBundleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkspaceBundle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkspaceBundleErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkspaceBundleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkspaceBundleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateWorkspaceBundleErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            CreateWorkspaceBundleErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateWorkspaceBundleErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateWorkspaceBundleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateWorkspaceBundleErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            CreateWorkspaceBundleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkspaceBundleError {
    fn code(&self) -> Option<&str> {
        CreateWorkspaceBundleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWorkspaceBundleError {
    /// Creates a new `CreateWorkspaceBundleError`.
    pub fn new(kind: CreateWorkspaceBundleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkspaceBundleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkspaceBundleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkspaceBundleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkspaceBundleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWorkspaceBundleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceBundleErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceBundleErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceBundleErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceBundleErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceBundleErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceBundleErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceBundleErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceBundleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceBundleErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceBundleErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceBundleErrorKind::ResourceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateWorkspaceBundleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkspaceBundleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateWorkspaceBundleErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            CreateWorkspaceBundleErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateWorkspaceBundleErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateWorkspaceBundleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateWorkspaceBundleErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            CreateWorkspaceBundleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkspacesError {
    /// Kind of error that occurred.
    pub kind: CreateWorkspacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkspacesErrorKind {
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkspacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkspacesErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            CreateWorkspacesErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateWorkspacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkspacesError {
    fn code(&self) -> Option<&str> {
        CreateWorkspacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWorkspacesError {
    /// Creates a new `CreateWorkspacesError`.
    pub fn new(kind: CreateWorkspacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkspacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkspacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkspacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkspacesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWorkspacesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspacesErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspacesErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspacesErrorKind::ResourceLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateWorkspacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkspacesErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            CreateWorkspacesErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateWorkspacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteClientBranding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClientBrandingError {
    /// Kind of error that occurred.
    pub kind: DeleteClientBrandingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteClientBranding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClientBrandingErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClientBrandingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClientBrandingErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteClientBrandingErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            DeleteClientBrandingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteClientBrandingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClientBrandingError {
    fn code(&self) -> Option<&str> {
        DeleteClientBrandingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClientBrandingError {
    /// Creates a new `DeleteClientBrandingError`.
    pub fn new(kind: DeleteClientBrandingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClientBrandingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClientBrandingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClientBrandingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClientBrandingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClientBrandingErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClientBrandingErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClientBrandingErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClientBrandingErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClientBrandingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClientBrandingErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteClientBrandingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClientBrandingErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteClientBrandingErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            DeleteClientBrandingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteClientBrandingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnectClientAddIn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectClientAddInError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectClientAddInErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnectClientAddIn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectClientAddInErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectClientAddInError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectClientAddInErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteConnectClientAddInErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConnectClientAddInErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConnectClientAddInErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectClientAddInError {
    fn code(&self) -> Option<&str> {
        DeleteConnectClientAddInError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectClientAddInError {
    /// Creates a new `DeleteConnectClientAddInError`.
    pub fn new(kind: DeleteConnectClientAddInErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectClientAddInError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectClientAddInErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectClientAddInError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectClientAddInErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConnectClientAddInErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectClientAddInErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectClientAddInErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectClientAddInErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectClientAddInErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectClientAddInErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteConnectClientAddInError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectClientAddInErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteConnectClientAddInErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DeleteConnectClientAddInErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConnectClientAddInErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnectionAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectionAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectionAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnectionAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectionAliasErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The resource is associated with a directory.</p>
    ResourceAssociatedException(crate::error::ResourceAssociatedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectionAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectionAliasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteConnectionAliasErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConnectionAliasErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            DeleteConnectionAliasErrorKind::OperationNotSupportedException(_inner) => _inner.fmt(f),
            DeleteConnectionAliasErrorKind::ResourceAssociatedException(_inner) => _inner.fmt(f),
            DeleteConnectionAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConnectionAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectionAliasError {
    fn code(&self) -> Option<&str> {
        DeleteConnectionAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectionAliasError {
    /// Creates a new `DeleteConnectionAliasError`.
    pub fn new(kind: DeleteConnectionAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectionAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectionAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectionAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectionAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConnectionAliasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionAliasErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionAliasErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionAliasErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionAliasErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionAliasErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionAliasErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionAliasErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionAliasErrorKind::ResourceAssociatedException`.
    pub fn is_resource_associated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionAliasErrorKind::ResourceAssociatedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionAliasErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteConnectionAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectionAliasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteConnectionAliasErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            DeleteConnectionAliasErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            DeleteConnectionAliasErrorKind::OperationNotSupportedException(_inner) => Some(_inner),
            DeleteConnectionAliasErrorKind::ResourceAssociatedException(_inner) => Some(_inner),
            DeleteConnectionAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConnectionAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIpGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIpGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteIpGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIpGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIpGroupErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource is associated with a directory.</p>
    ResourceAssociatedException(crate::error::ResourceAssociatedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIpGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIpGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteIpGroupErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            DeleteIpGroupErrorKind::ResourceAssociatedException(_inner) => _inner.fmt(f),
            DeleteIpGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteIpGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIpGroupError {
    fn code(&self) -> Option<&str> {
        DeleteIpGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIpGroupError {
    /// Creates a new `DeleteIpGroupError`.
    pub fn new(kind: DeleteIpGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIpGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIpGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIpGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIpGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIpGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteIpGroupErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteIpGroupErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIpGroupErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIpGroupErrorKind::ResourceAssociatedException`.
    pub fn is_resource_associated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIpGroupErrorKind::ResourceAssociatedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIpGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIpGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteIpGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIpGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteIpGroupErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            DeleteIpGroupErrorKind::ResourceAssociatedException(_inner) => Some(_inner),
            DeleteIpGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteIpGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTagsError {
    /// Kind of error that occurred.
    pub kind: DeleteTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTagsErrorKind {
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTagsErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTagsError {
    fn code(&self) -> Option<&str> {
        DeleteTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTagsError {
    /// Creates a new `DeleteTagsError`.
    pub fn new(kind: DeleteTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTagsErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTagsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTagsErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            DeleteTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkspaceBundle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkspaceBundleError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkspaceBundleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkspaceBundle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkspaceBundleErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource is associated with a directory.</p>
    ResourceAssociatedException(crate::error::ResourceAssociatedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkspaceBundleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkspaceBundleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWorkspaceBundleErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DeleteWorkspaceBundleErrorKind::ResourceAssociatedException(_inner) => _inner.fmt(f),
            DeleteWorkspaceBundleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWorkspaceBundleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkspaceBundleError {
    fn code(&self) -> Option<&str> {
        DeleteWorkspaceBundleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWorkspaceBundleError {
    /// Creates a new `DeleteWorkspaceBundleError`.
    pub fn new(kind: DeleteWorkspaceBundleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkspaceBundleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkspaceBundleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkspaceBundleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkspaceBundleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceBundleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceBundleErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceBundleErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceBundleErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceBundleErrorKind::ResourceAssociatedException`.
    pub fn is_resource_associated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceBundleErrorKind::ResourceAssociatedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceBundleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceBundleErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteWorkspaceBundleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkspaceBundleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWorkspaceBundleErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            DeleteWorkspaceBundleErrorKind::ResourceAssociatedException(_inner) => Some(_inner),
            DeleteWorkspaceBundleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWorkspaceBundleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkspaceImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkspaceImageError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkspaceImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkspaceImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkspaceImageErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>The resource is associated with a directory.</p>
    ResourceAssociatedException(crate::error::ResourceAssociatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkspaceImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkspaceImageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWorkspaceImageErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            DeleteWorkspaceImageErrorKind::ResourceAssociatedException(_inner) => _inner.fmt(f),
            DeleteWorkspaceImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkspaceImageError {
    fn code(&self) -> Option<&str> {
        DeleteWorkspaceImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWorkspaceImageError {
    /// Creates a new `DeleteWorkspaceImageError`.
    pub fn new(kind: DeleteWorkspaceImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkspaceImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkspaceImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkspaceImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkspaceImageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceImageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceImageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceImageErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceImageErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceImageErrorKind::ResourceAssociatedException`.
    pub fn is_resource_associated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceImageErrorKind::ResourceAssociatedException(_)
        )
    }
}
impl std::error::Error for DeleteWorkspaceImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkspaceImageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWorkspaceImageErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            DeleteWorkspaceImageErrorKind::ResourceAssociatedException(_inner) => Some(_inner),
            DeleteWorkspaceImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterWorkspaceDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterWorkspaceDirectoryError {
    /// Kind of error that occurred.
    pub kind: DeregisterWorkspaceDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterWorkspaceDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterWorkspaceDirectoryErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterWorkspaceDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterWorkspaceDirectoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeregisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterWorkspaceDirectoryErrorKind::InvalidResourceStateException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterWorkspaceDirectoryErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterWorkspaceDirectoryErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterWorkspaceDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterWorkspaceDirectoryError {
    fn code(&self) -> Option<&str> {
        DeregisterWorkspaceDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterWorkspaceDirectoryError {
    /// Creates a new `DeregisterWorkspaceDirectoryError`.
    pub fn new(kind: DeregisterWorkspaceDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterWorkspaceDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterWorkspaceDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterWorkspaceDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterWorkspaceDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterWorkspaceDirectoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterWorkspaceDirectoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterWorkspaceDirectoryErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterWorkspaceDirectoryErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterWorkspaceDirectoryErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterWorkspaceDirectoryErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterWorkspaceDirectoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterWorkspaceDirectoryErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeregisterWorkspaceDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterWorkspaceDirectoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeregisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DeregisterWorkspaceDirectoryErrorKind::InvalidResourceStateException(_inner) => {
                Some(_inner)
            }
            DeregisterWorkspaceDirectoryErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            DeregisterWorkspaceDirectoryErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeregisterWorkspaceDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountError {
    fn code(&self) -> Option<&str> {
        DescribeAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountError {
    /// Creates a new `DescribeAccountError`.
    pub fn new(kind: DescribeAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountErrorKind::AccessDeniedException(_)
        )
    }
}
impl std::error::Error for DescribeAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountModifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountModificationsError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountModificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountModifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountModificationsErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountModificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountModificationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAccountModificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountModificationsError {
    fn code(&self) -> Option<&str> {
        DescribeAccountModificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountModificationsError {
    /// Creates a new `DescribeAccountModificationsError`.
    pub fn new(kind: DescribeAccountModificationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountModificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountModificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountModificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountModificationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountModificationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountModificationsErrorKind::AccessDeniedException(_)
        )
    }
}
impl std::error::Error for DescribeAccountModificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountModificationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAccountModificationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClientBranding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClientBrandingError {
    /// Kind of error that occurred.
    pub kind: DescribeClientBrandingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClientBranding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClientBrandingErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClientBrandingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClientBrandingErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeClientBrandingErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DescribeClientBrandingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeClientBrandingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClientBrandingError {
    fn code(&self) -> Option<&str> {
        DescribeClientBrandingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClientBrandingError {
    /// Creates a new `DescribeClientBrandingError`.
    pub fn new(kind: DescribeClientBrandingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClientBrandingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClientBrandingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClientBrandingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClientBrandingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClientBrandingErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientBrandingErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClientBrandingErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientBrandingErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClientBrandingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientBrandingErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeClientBrandingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClientBrandingErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeClientBrandingErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DescribeClientBrandingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeClientBrandingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClientProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClientPropertiesError {
    /// Kind of error that occurred.
    pub kind: DescribeClientPropertiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClientProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClientPropertiesErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClientPropertiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClientPropertiesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeClientPropertiesErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DescribeClientPropertiesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeClientPropertiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClientPropertiesError {
    fn code(&self) -> Option<&str> {
        DescribeClientPropertiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClientPropertiesError {
    /// Creates a new `DescribeClientPropertiesError`.
    pub fn new(kind: DescribeClientPropertiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClientPropertiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClientPropertiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClientPropertiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClientPropertiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClientPropertiesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientPropertiesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClientPropertiesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientPropertiesErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClientPropertiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClientPropertiesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeClientPropertiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClientPropertiesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeClientPropertiesErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DescribeClientPropertiesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeClientPropertiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnectClientAddIns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectClientAddInsError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectClientAddInsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnectClientAddIns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectClientAddInsErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectClientAddInsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectClientAddInsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeConnectClientAddInsErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConnectClientAddInsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConnectClientAddInsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectClientAddInsError {
    fn code(&self) -> Option<&str> {
        DescribeConnectClientAddInsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectClientAddInsError {
    /// Creates a new `DescribeConnectClientAddInsError`.
    pub fn new(kind: DescribeConnectClientAddInsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectClientAddInsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectClientAddInsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectClientAddInsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectClientAddInsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConnectClientAddInsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectClientAddInsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectClientAddInsErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectClientAddInsErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectClientAddInsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectClientAddInsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeConnectClientAddInsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectClientAddInsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeConnectClientAddInsErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DescribeConnectClientAddInsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeConnectClientAddInsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnectionAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectionAliasesError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectionAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnectionAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectionAliasesErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectionAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectionAliasesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeConnectionAliasesErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConnectionAliasesErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConnectionAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectionAliasesError {
    fn code(&self) -> Option<&str> {
        DescribeConnectionAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectionAliasesError {
    /// Creates a new `DescribeConnectionAliasesError`.
    pub fn new(kind: DescribeConnectionAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectionAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectionAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectionAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectionAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConnectionAliasesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionAliasesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectionAliasesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionAliasesErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectionAliasesErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionAliasesErrorKind::OperationNotSupportedException(_)
        )
    }
}
impl std::error::Error for DescribeConnectionAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectionAliasesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeConnectionAliasesErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DescribeConnectionAliasesErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            DescribeConnectionAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnectionAliasPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectionAliasPermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectionAliasPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnectionAliasPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectionAliasPermissionsErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectionAliasPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectionAliasPermissionsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConnectionAliasPermissionsErrorKind::InvalidParameterValuesException(
                _inner,
            ) => _inner.fmt(f),
            DescribeConnectionAliasPermissionsErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConnectionAliasPermissionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConnectionAliasPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectionAliasPermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeConnectionAliasPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectionAliasPermissionsError {
    /// Creates a new `DescribeConnectionAliasPermissionsError`.
    pub fn new(
        kind: DescribeConnectionAliasPermissionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectionAliasPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectionAliasPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectionAliasPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectionAliasPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConnectionAliasPermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionAliasPermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectionAliasPermissionsErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionAliasPermissionsErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectionAliasPermissionsErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionAliasPermissionsErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectionAliasPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionAliasPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeConnectionAliasPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectionAliasPermissionsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeConnectionAliasPermissionsErrorKind::InvalidParameterValuesException(
                _inner,
            ) => Some(_inner),
            DescribeConnectionAliasPermissionsErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            DescribeConnectionAliasPermissionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeConnectionAliasPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIpGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIpGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeIpGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIpGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIpGroupsErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIpGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIpGroupsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeIpGroupsErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            DescribeIpGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIpGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeIpGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIpGroupsError {
    /// Creates a new `DescribeIpGroupsError`.
    pub fn new(kind: DescribeIpGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIpGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIpGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIpGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIpGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeIpGroupsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIpGroupsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIpGroupsErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIpGroupsErrorKind::InvalidParameterValuesException(_)
        )
    }
}
impl std::error::Error for DescribeIpGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIpGroupsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeIpGroupsErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            DescribeIpGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTagsError {
    /// Kind of error that occurred.
    pub kind: DescribeTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTagsErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTagsError {
    fn code(&self) -> Option<&str> {
        DescribeTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTagsError {
    /// Creates a new `DescribeTagsError`.
    pub fn new(kind: DescribeTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkspaceBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkspaceBundlesError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkspaceBundlesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkspaceBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkspaceBundlesErrorKind {
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkspaceBundlesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkspaceBundlesErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkspaceBundlesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkspaceBundlesError {
    fn code(&self) -> Option<&str> {
        DescribeWorkspaceBundlesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkspaceBundlesError {
    /// Creates a new `DescribeWorkspaceBundlesError`.
    pub fn new(kind: DescribeWorkspaceBundlesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkspaceBundlesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkspaceBundlesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkspaceBundlesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkspaceBundlesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceBundlesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceBundlesErrorKind::InvalidParameterValuesException(_)
        )
    }
}
impl std::error::Error for DescribeWorkspaceBundlesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkspaceBundlesErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DescribeWorkspaceBundlesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkspaceDirectories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkspaceDirectoriesError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkspaceDirectoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkspaceDirectories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkspaceDirectoriesErrorKind {
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkspaceDirectoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkspaceDirectoriesErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkspaceDirectoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkspaceDirectoriesError {
    fn code(&self) -> Option<&str> {
        DescribeWorkspaceDirectoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkspaceDirectoriesError {
    /// Creates a new `DescribeWorkspaceDirectoriesError`.
    pub fn new(kind: DescribeWorkspaceDirectoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkspaceDirectoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkspaceDirectoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkspaceDirectoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkspaceDirectoriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceDirectoriesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceDirectoriesErrorKind::InvalidParameterValuesException(_)
        )
    }
}
impl std::error::Error for DescribeWorkspaceDirectoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkspaceDirectoriesErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DescribeWorkspaceDirectoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkspaceImagePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkspaceImagePermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkspaceImagePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkspaceImagePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkspaceImagePermissionsErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkspaceImagePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkspaceImagePermissionsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkspaceImagePermissionsErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkspaceImagePermissionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkspaceImagePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkspaceImagePermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeWorkspaceImagePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkspaceImagePermissionsError {
    /// Creates a new `DescribeWorkspaceImagePermissionsError`.
    pub fn new(
        kind: DescribeWorkspaceImagePermissionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkspaceImagePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkspaceImagePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkspaceImagePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkspaceImagePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceImagePermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceImagePermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceImagePermissionsErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceImagePermissionsErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceImagePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceImagePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeWorkspaceImagePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkspaceImagePermissionsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeWorkspaceImagePermissionsErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DescribeWorkspaceImagePermissionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeWorkspaceImagePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkspaceImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkspaceImagesError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkspaceImagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkspaceImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkspaceImagesErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkspaceImagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkspaceImagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeWorkspaceImagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkspaceImagesError {
    fn code(&self) -> Option<&str> {
        DescribeWorkspaceImagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkspaceImagesError {
    /// Creates a new `DescribeWorkspaceImagesError`.
    pub fn new(kind: DescribeWorkspaceImagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkspaceImagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkspaceImagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkspaceImagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkspaceImagesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceImagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceImagesErrorKind::AccessDeniedException(_)
        )
    }
}
impl std::error::Error for DescribeWorkspaceImagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkspaceImagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeWorkspaceImagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkspacesError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkspacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkspacesErrorKind {
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The specified resource is not available.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkspacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkspacesErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            DescribeWorkspacesErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DescribeWorkspacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkspacesError {
    fn code(&self) -> Option<&str> {
        DescribeWorkspacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkspacesError {
    /// Creates a new `DescribeWorkspacesError`.
    pub fn new(kind: DescribeWorkspacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkspacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkspacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkspacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkspacesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkspacesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspacesErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspacesErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspacesErrorKind::ResourceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeWorkspacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkspacesErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            DescribeWorkspacesErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DescribeWorkspacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkspacesConnectionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkspacesConnectionStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkspacesConnectionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkspacesConnectionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkspacesConnectionStatusErrorKind {
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkspacesConnectionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkspacesConnectionStatusErrorKind::InvalidParameterValuesException(
                _inner,
            ) => _inner.fmt(f),
            DescribeWorkspacesConnectionStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkspacesConnectionStatusError {
    fn code(&self) -> Option<&str> {
        DescribeWorkspacesConnectionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkspacesConnectionStatusError {
    /// Creates a new `DescribeWorkspacesConnectionStatusError`.
    pub fn new(
        kind: DescribeWorkspacesConnectionStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkspacesConnectionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkspacesConnectionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkspacesConnectionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkspacesConnectionStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkspacesConnectionStatusErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspacesConnectionStatusErrorKind::InvalidParameterValuesException(_)
        )
    }
}
impl std::error::Error for DescribeWorkspacesConnectionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkspacesConnectionStatusErrorKind::InvalidParameterValuesException(
                _inner,
            ) => Some(_inner),
            DescribeWorkspacesConnectionStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkspaceSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkspaceSnapshotsError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkspaceSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkspaceSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkspaceSnapshotsErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkspaceSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkspaceSnapshotsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeWorkspaceSnapshotsErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkspaceSnapshotsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeWorkspaceSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkspaceSnapshotsError {
    fn code(&self) -> Option<&str> {
        DescribeWorkspaceSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkspaceSnapshotsError {
    /// Creates a new `DescribeWorkspaceSnapshotsError`.
    pub fn new(kind: DescribeWorkspaceSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkspaceSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkspaceSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkspaceSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkspaceSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceSnapshotsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceSnapshotsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceSnapshotsErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceSnapshotsErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceSnapshotsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceSnapshotsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeWorkspaceSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkspaceSnapshotsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeWorkspaceSnapshotsErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DescribeWorkspaceSnapshotsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeWorkspaceSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateConnectionAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateConnectionAliasError {
    /// Kind of error that occurred.
    pub kind: DisassociateConnectionAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateConnectionAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateConnectionAliasErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateConnectionAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateConnectionAliasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateConnectionAliasErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateConnectionAliasErrorKind::InvalidResourceStateException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateConnectionAliasErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateConnectionAliasErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateConnectionAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateConnectionAliasError {
    fn code(&self) -> Option<&str> {
        DisassociateConnectionAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateConnectionAliasError {
    /// Creates a new `DisassociateConnectionAliasError`.
    pub fn new(kind: DisassociateConnectionAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateConnectionAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateConnectionAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateConnectionAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateConnectionAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateConnectionAliasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectionAliasErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateConnectionAliasErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectionAliasErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateConnectionAliasErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectionAliasErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateConnectionAliasErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectionAliasErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateConnectionAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectionAliasErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateConnectionAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateConnectionAliasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateConnectionAliasErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            DisassociateConnectionAliasErrorKind::InvalidResourceStateException(_inner) => {
                Some(_inner)
            }
            DisassociateConnectionAliasErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            DisassociateConnectionAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateConnectionAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateIpGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateIpGroupsError {
    /// Kind of error that occurred.
    pub kind: DisassociateIpGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateIpGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateIpGroupsErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateIpGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateIpGroupsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateIpGroupsErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            DisassociateIpGroupsErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            DisassociateIpGroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateIpGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateIpGroupsError {
    fn code(&self) -> Option<&str> {
        DisassociateIpGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateIpGroupsError {
    /// Creates a new `DisassociateIpGroupsError`.
    pub fn new(kind: DisassociateIpGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateIpGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateIpGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateIpGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateIpGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateIpGroupsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateIpGroupsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateIpGroupsErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateIpGroupsErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateIpGroupsErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateIpGroupsErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateIpGroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateIpGroupsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateIpGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateIpGroupsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateIpGroupsErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            DisassociateIpGroupsErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            DisassociateIpGroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateIpGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportClientBranding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportClientBrandingError {
    /// Kind of error that occurred.
    pub kind: ImportClientBrandingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportClientBranding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportClientBrandingErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportClientBrandingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportClientBrandingErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ImportClientBrandingErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            ImportClientBrandingErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            ImportClientBrandingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportClientBrandingError {
    fn code(&self) -> Option<&str> {
        ImportClientBrandingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportClientBrandingError {
    /// Creates a new `ImportClientBrandingError`.
    pub fn new(kind: ImportClientBrandingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportClientBrandingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportClientBrandingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportClientBrandingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportClientBrandingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportClientBrandingErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportClientBrandingErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportClientBrandingErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportClientBrandingErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportClientBrandingErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportClientBrandingErrorKind::ResourceLimitExceededException(_)
        )
    }
}
impl std::error::Error for ImportClientBrandingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportClientBrandingErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ImportClientBrandingErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            ImportClientBrandingErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            ImportClientBrandingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportWorkspaceImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportWorkspaceImageError {
    /// Kind of error that occurred.
    pub kind: ImportWorkspaceImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportWorkspaceImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportWorkspaceImageErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportWorkspaceImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportWorkspaceImageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ImportWorkspaceImageErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            ImportWorkspaceImageErrorKind::OperationNotSupportedException(_inner) => _inner.fmt(f),
            ImportWorkspaceImageErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            ImportWorkspaceImageErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            ImportWorkspaceImageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ImportWorkspaceImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportWorkspaceImageError {
    fn code(&self) -> Option<&str> {
        ImportWorkspaceImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportWorkspaceImageError {
    /// Creates a new `ImportWorkspaceImageError`.
    pub fn new(kind: ImportWorkspaceImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportWorkspaceImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportWorkspaceImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportWorkspaceImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportWorkspaceImageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportWorkspaceImageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportWorkspaceImageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportWorkspaceImageErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportWorkspaceImageErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportWorkspaceImageErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportWorkspaceImageErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportWorkspaceImageErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportWorkspaceImageErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportWorkspaceImageErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportWorkspaceImageErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportWorkspaceImageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportWorkspaceImageErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ImportWorkspaceImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportWorkspaceImageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ImportWorkspaceImageErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            ImportWorkspaceImageErrorKind::OperationNotSupportedException(_inner) => Some(_inner),
            ImportWorkspaceImageErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            ImportWorkspaceImageErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            ImportWorkspaceImageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ImportWorkspaceImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAvailableManagementCidrRanges` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAvailableManagementCidrRangesError {
    /// Kind of error that occurred.
    pub kind: ListAvailableManagementCidrRangesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAvailableManagementCidrRanges` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAvailableManagementCidrRangesErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAvailableManagementCidrRangesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAvailableManagementCidrRangesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListAvailableManagementCidrRangesErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            ListAvailableManagementCidrRangesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAvailableManagementCidrRangesError {
    fn code(&self) -> Option<&str> {
        ListAvailableManagementCidrRangesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAvailableManagementCidrRangesError {
    /// Creates a new `ListAvailableManagementCidrRangesError`.
    pub fn new(
        kind: ListAvailableManagementCidrRangesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAvailableManagementCidrRangesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAvailableManagementCidrRangesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAvailableManagementCidrRangesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAvailableManagementCidrRangesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAvailableManagementCidrRangesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableManagementCidrRangesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAvailableManagementCidrRangesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableManagementCidrRangesErrorKind::InvalidParameterValuesException(_)
        )
    }
}
impl std::error::Error for ListAvailableManagementCidrRangesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAvailableManagementCidrRangesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListAvailableManagementCidrRangesErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            ListAvailableManagementCidrRangesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `MigrateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MigrateWorkspaceError {
    /// Kind of error that occurred.
    pub kind: MigrateWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MigrateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MigrateWorkspaceErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The properties of this WorkSpace are currently being modified. Try again in a moment.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MigrateWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MigrateWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            MigrateWorkspaceErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            MigrateWorkspaceErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            MigrateWorkspaceErrorKind::OperationNotSupportedException(_inner) => _inner.fmt(f),
            MigrateWorkspaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            MigrateWorkspaceErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            MigrateWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MigrateWorkspaceError {
    fn code(&self) -> Option<&str> {
        MigrateWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MigrateWorkspaceError {
    /// Creates a new `MigrateWorkspaceError`.
    pub fn new(kind: MigrateWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MigrateWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MigrateWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MigrateWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MigrateWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MigrateWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            MigrateWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `MigrateWorkspaceErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            MigrateWorkspaceErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `MigrateWorkspaceErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            MigrateWorkspaceErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `MigrateWorkspaceErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            MigrateWorkspaceErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `MigrateWorkspaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MigrateWorkspaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MigrateWorkspaceErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            MigrateWorkspaceErrorKind::ResourceUnavailableException(_)
        )
    }
}
impl std::error::Error for MigrateWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MigrateWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            MigrateWorkspaceErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            MigrateWorkspaceErrorKind::OperationInProgressException(_inner) => Some(_inner),
            MigrateWorkspaceErrorKind::OperationNotSupportedException(_inner) => Some(_inner),
            MigrateWorkspaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            MigrateWorkspaceErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            MigrateWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyAccountError {
    /// Kind of error that occurred.
    pub kind: ModifyAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyAccountErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ModifyAccountErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            ModifyAccountErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            ModifyAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ModifyAccountErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            ModifyAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyAccountError {
    fn code(&self) -> Option<&str> {
        ModifyAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyAccountError {
    /// Creates a new `ModifyAccountError`.
    pub fn new(kind: ModifyAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ModifyAccountErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ModifyAccountErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyAccountErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyAccountErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyAccountErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyAccountErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyAccountErrorKind::ResourceUnavailableException(_)
        )
    }
}
impl std::error::Error for ModifyAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ModifyAccountErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            ModifyAccountErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            ModifyAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ModifyAccountErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            ModifyAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyClientProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyClientPropertiesError {
    /// Kind of error that occurred.
    pub kind: ModifyClientPropertiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyClientProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyClientPropertiesErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyClientPropertiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyClientPropertiesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ModifyClientPropertiesErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            ModifyClientPropertiesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ModifyClientPropertiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyClientPropertiesError {
    fn code(&self) -> Option<&str> {
        ModifyClientPropertiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyClientPropertiesError {
    /// Creates a new `ModifyClientPropertiesError`.
    pub fn new(kind: ModifyClientPropertiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyClientPropertiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyClientPropertiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyClientPropertiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyClientPropertiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyClientPropertiesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClientPropertiesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClientPropertiesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClientPropertiesErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClientPropertiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClientPropertiesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ModifyClientPropertiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyClientPropertiesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ModifyClientPropertiesErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            ModifyClientPropertiesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ModifyClientPropertiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifySelfservicePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifySelfservicePermissionsError {
    /// Kind of error that occurred.
    pub kind: ModifySelfservicePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifySelfservicePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifySelfservicePermissionsErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifySelfservicePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifySelfservicePermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ModifySelfservicePermissionsErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            ModifySelfservicePermissionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ModifySelfservicePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifySelfservicePermissionsError {
    fn code(&self) -> Option<&str> {
        ModifySelfservicePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifySelfservicePermissionsError {
    /// Creates a new `ModifySelfservicePermissionsError`.
    pub fn new(kind: ModifySelfservicePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifySelfservicePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifySelfservicePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifySelfservicePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifySelfservicePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifySelfservicePermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifySelfservicePermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifySelfservicePermissionsErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifySelfservicePermissionsErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifySelfservicePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifySelfservicePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ModifySelfservicePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifySelfservicePermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ModifySelfservicePermissionsErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            ModifySelfservicePermissionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ModifySelfservicePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyWorkspaceAccessProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyWorkspaceAccessPropertiesError {
    /// Kind of error that occurred.
    pub kind: ModifyWorkspaceAccessPropertiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyWorkspaceAccessProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyWorkspaceAccessPropertiesErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyWorkspaceAccessPropertiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyWorkspaceAccessPropertiesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ModifyWorkspaceAccessPropertiesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ModifyWorkspaceAccessPropertiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyWorkspaceAccessPropertiesError {
    fn code(&self) -> Option<&str> {
        ModifyWorkspaceAccessPropertiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyWorkspaceAccessPropertiesError {
    /// Creates a new `ModifyWorkspaceAccessPropertiesError`.
    pub fn new(
        kind: ModifyWorkspaceAccessPropertiesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyWorkspaceAccessPropertiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyWorkspaceAccessPropertiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyWorkspaceAccessPropertiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyWorkspaceAccessPropertiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyWorkspaceAccessPropertiesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspaceAccessPropertiesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspaceAccessPropertiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspaceAccessPropertiesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ModifyWorkspaceAccessPropertiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyWorkspaceAccessPropertiesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ModifyWorkspaceAccessPropertiesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ModifyWorkspaceAccessPropertiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyWorkspaceCreationProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyWorkspaceCreationPropertiesError {
    /// Kind of error that occurred.
    pub kind: ModifyWorkspaceCreationPropertiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyWorkspaceCreationProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyWorkspaceCreationPropertiesErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyWorkspaceCreationPropertiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyWorkspaceCreationPropertiesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ModifyWorkspaceCreationPropertiesErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            ModifyWorkspaceCreationPropertiesErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            ModifyWorkspaceCreationPropertiesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ModifyWorkspaceCreationPropertiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyWorkspaceCreationPropertiesError {
    fn code(&self) -> Option<&str> {
        ModifyWorkspaceCreationPropertiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyWorkspaceCreationPropertiesError {
    /// Creates a new `ModifyWorkspaceCreationPropertiesError`.
    pub fn new(
        kind: ModifyWorkspaceCreationPropertiesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyWorkspaceCreationPropertiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyWorkspaceCreationPropertiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyWorkspaceCreationPropertiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyWorkspaceCreationPropertiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyWorkspaceCreationPropertiesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspaceCreationPropertiesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspaceCreationPropertiesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspaceCreationPropertiesErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspaceCreationPropertiesErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspaceCreationPropertiesErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspaceCreationPropertiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspaceCreationPropertiesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ModifyWorkspaceCreationPropertiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyWorkspaceCreationPropertiesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ModifyWorkspaceCreationPropertiesErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            ModifyWorkspaceCreationPropertiesErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            ModifyWorkspaceCreationPropertiesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ModifyWorkspaceCreationPropertiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyWorkspaceProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyWorkspacePropertiesError {
    /// Kind of error that occurred.
    pub kind: ModifyWorkspacePropertiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyWorkspaceProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyWorkspacePropertiesErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>The properties of this WorkSpace are currently being modified. Try again in a moment.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The configuration of this WorkSpace is not supported for this operation. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required Configuration and Service Components for WorkSpaces </a>.</p>
    UnsupportedWorkspaceConfigurationException(
        crate::error::UnsupportedWorkspaceConfigurationException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyWorkspacePropertiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyWorkspacePropertiesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ModifyWorkspacePropertiesErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            ModifyWorkspacePropertiesErrorKind::InvalidResourceStateException(_inner) => {
                _inner.fmt(f)
            }
            ModifyWorkspacePropertiesErrorKind::OperationInProgressException(_inner) => {
                _inner.fmt(f)
            }
            ModifyWorkspacePropertiesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ModifyWorkspacePropertiesErrorKind::ResourceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ModifyWorkspacePropertiesErrorKind::UnsupportedWorkspaceConfigurationException(
                _inner,
            ) => _inner.fmt(f),
            ModifyWorkspacePropertiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyWorkspacePropertiesError {
    fn code(&self) -> Option<&str> {
        ModifyWorkspacePropertiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyWorkspacePropertiesError {
    /// Creates a new `ModifyWorkspacePropertiesError`.
    pub fn new(kind: ModifyWorkspacePropertiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyWorkspacePropertiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyWorkspacePropertiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyWorkspacePropertiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyWorkspacePropertiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyWorkspacePropertiesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspacePropertiesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspacePropertiesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspacePropertiesErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspacePropertiesErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspacePropertiesErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspacePropertiesErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspacePropertiesErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspacePropertiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspacePropertiesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspacePropertiesErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspacePropertiesErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspacePropertiesErrorKind::UnsupportedWorkspaceConfigurationException`.
    pub fn is_unsupported_workspace_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspacePropertiesErrorKind::UnsupportedWorkspaceConfigurationException(_)
        )
    }
}
impl std::error::Error for ModifyWorkspacePropertiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyWorkspacePropertiesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ModifyWorkspacePropertiesErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            ModifyWorkspacePropertiesErrorKind::InvalidResourceStateException(_inner) => {
                Some(_inner)
            }
            ModifyWorkspacePropertiesErrorKind::OperationInProgressException(_inner) => {
                Some(_inner)
            }
            ModifyWorkspacePropertiesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ModifyWorkspacePropertiesErrorKind::ResourceUnavailableException(_inner) => {
                Some(_inner)
            }
            ModifyWorkspacePropertiesErrorKind::UnsupportedWorkspaceConfigurationException(
                _inner,
            ) => Some(_inner),
            ModifyWorkspacePropertiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyWorkspaceState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyWorkspaceStateError {
    /// Kind of error that occurred.
    pub kind: ModifyWorkspaceStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyWorkspaceState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyWorkspaceStateErrorKind {
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyWorkspaceStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyWorkspaceStateErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            ModifyWorkspaceStateErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            ModifyWorkspaceStateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ModifyWorkspaceStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyWorkspaceStateError {
    fn code(&self) -> Option<&str> {
        ModifyWorkspaceStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyWorkspaceStateError {
    /// Creates a new `ModifyWorkspaceStateError`.
    pub fn new(kind: ModifyWorkspaceStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyWorkspaceStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyWorkspaceStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyWorkspaceStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyWorkspaceStateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyWorkspaceStateErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspaceStateErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspaceStateErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspaceStateErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyWorkspaceStateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyWorkspaceStateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ModifyWorkspaceStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyWorkspaceStateErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            ModifyWorkspaceStateErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            ModifyWorkspaceStateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ModifyWorkspaceStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebootWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebootWorkspacesError {
    /// Kind of error that occurred.
    pub kind: RebootWorkspacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebootWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebootWorkspacesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebootWorkspacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebootWorkspacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebootWorkspacesError {
    fn code(&self) -> Option<&str> {
        RebootWorkspacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebootWorkspacesError {
    /// Creates a new `RebootWorkspacesError`.
    pub fn new(kind: RebootWorkspacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebootWorkspacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebootWorkspacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebootWorkspacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebootWorkspacesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for RebootWorkspacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebootWorkspacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebuildWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebuildWorkspacesError {
    /// Kind of error that occurred.
    pub kind: RebuildWorkspacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebuildWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebuildWorkspacesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebuildWorkspacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebuildWorkspacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebuildWorkspacesError {
    fn code(&self) -> Option<&str> {
        RebuildWorkspacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebuildWorkspacesError {
    /// Creates a new `RebuildWorkspacesError`.
    pub fn new(kind: RebuildWorkspacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebuildWorkspacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebuildWorkspacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebuildWorkspacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebuildWorkspacesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for RebuildWorkspacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebuildWorkspacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterWorkspaceDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterWorkspaceDirectoryError {
    /// Kind of error that occurred.
    pub kind: RegisterWorkspaceDirectoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterWorkspaceDirectory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterWorkspaceDirectoryErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The configuration of this network is not supported for this operation, or your network configuration conflicts with the Amazon WorkSpaces management network IP range. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a VPC for Amazon WorkSpaces</a>.</p>
    UnsupportedNetworkConfigurationException(
        crate::error::UnsupportedNetworkConfigurationException,
    ),
    /// <p>The workspaces_DefaultRole role could not be found. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">Creating the workspaces_DefaultRole Role</a>.</p>
    WorkspacesDefaultRoleNotFoundException(crate::error::WorkspacesDefaultRoleNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterWorkspaceDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterWorkspaceDirectoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RegisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            RegisterWorkspaceDirectoryErrorKind::InvalidResourceStateException(_inner) => {
                _inner.fmt(f)
            }
            RegisterWorkspaceDirectoryErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            RegisterWorkspaceDirectoryErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            RegisterWorkspaceDirectoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RegisterWorkspaceDirectoryErrorKind::UnsupportedNetworkConfigurationException(
                _inner,
            ) => _inner.fmt(f),
            RegisterWorkspaceDirectoryErrorKind::WorkspacesDefaultRoleNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RegisterWorkspaceDirectoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterWorkspaceDirectoryError {
    fn code(&self) -> Option<&str> {
        RegisterWorkspaceDirectoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterWorkspaceDirectoryError {
    /// Creates a new `RegisterWorkspaceDirectoryError`.
    pub fn new(kind: RegisterWorkspaceDirectoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterWorkspaceDirectoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterWorkspaceDirectoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterWorkspaceDirectoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterWorkspaceDirectoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterWorkspaceDirectoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkspaceDirectoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWorkspaceDirectoryErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkspaceDirectoryErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWorkspaceDirectoryErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkspaceDirectoryErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWorkspaceDirectoryErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkspaceDirectoryErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWorkspaceDirectoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkspaceDirectoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWorkspaceDirectoryErrorKind::UnsupportedNetworkConfigurationException`.
    pub fn is_unsupported_network_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkspaceDirectoryErrorKind::UnsupportedNetworkConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterWorkspaceDirectoryErrorKind::WorkspacesDefaultRoleNotFoundException`.
    pub fn is_workspaces_default_role_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterWorkspaceDirectoryErrorKind::WorkspacesDefaultRoleNotFoundException(_)
        )
    }
}
impl std::error::Error for RegisterWorkspaceDirectoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterWorkspaceDirectoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RegisterWorkspaceDirectoryErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            RegisterWorkspaceDirectoryErrorKind::InvalidResourceStateException(_inner) => {
                Some(_inner)
            }
            RegisterWorkspaceDirectoryErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            RegisterWorkspaceDirectoryErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            RegisterWorkspaceDirectoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RegisterWorkspaceDirectoryErrorKind::UnsupportedNetworkConfigurationException(
                _inner,
            ) => Some(_inner),
            RegisterWorkspaceDirectoryErrorKind::WorkspacesDefaultRoleNotFoundException(_inner) => {
                Some(_inner)
            }
            RegisterWorkspaceDirectoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreWorkspaceError {
    /// Kind of error that occurred.
    pub kind: RestoreWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreWorkspaceErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RestoreWorkspaceErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            RestoreWorkspaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RestoreWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreWorkspaceError {
    fn code(&self) -> Option<&str> {
        RestoreWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreWorkspaceError {
    /// Creates a new `RestoreWorkspaceError`.
    pub fn new(kind: RestoreWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreWorkspaceErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreWorkspaceErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreWorkspaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreWorkspaceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RestoreWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RestoreWorkspaceErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            RestoreWorkspaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RestoreWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeIpRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeIpRulesError {
    /// Kind of error that occurred.
    pub kind: RevokeIpRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeIpRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeIpRulesErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeIpRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeIpRulesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RevokeIpRulesErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            RevokeIpRulesErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            RevokeIpRulesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RevokeIpRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeIpRulesError {
    fn code(&self) -> Option<&str> {
        RevokeIpRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeIpRulesError {
    /// Creates a new `RevokeIpRulesError`.
    pub fn new(kind: RevokeIpRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeIpRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeIpRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeIpRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeIpRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RevokeIpRulesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, RevokeIpRulesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `RevokeIpRulesErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeIpRulesErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeIpRulesErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeIpRulesErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeIpRulesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeIpRulesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RevokeIpRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeIpRulesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RevokeIpRulesErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            RevokeIpRulesErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            RevokeIpRulesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RevokeIpRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartWorkspacesError {
    /// Kind of error that occurred.
    pub kind: StartWorkspacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartWorkspacesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartWorkspacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartWorkspacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartWorkspacesError {
    fn code(&self) -> Option<&str> {
        StartWorkspacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartWorkspacesError {
    /// Creates a new `StartWorkspacesError`.
    pub fn new(kind: StartWorkspacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartWorkspacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartWorkspacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartWorkspacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartWorkspacesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for StartWorkspacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartWorkspacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopWorkspacesError {
    /// Kind of error that occurred.
    pub kind: StopWorkspacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopWorkspacesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopWorkspacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopWorkspacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopWorkspacesError {
    fn code(&self) -> Option<&str> {
        StopWorkspacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopWorkspacesError {
    /// Creates a new `StopWorkspacesError`.
    pub fn new(kind: StopWorkspacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopWorkspacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopWorkspacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopWorkspacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopWorkspacesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for StopWorkspacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopWorkspacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateWorkspacesError {
    /// Kind of error that occurred.
    pub kind: TerminateWorkspacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateWorkspacesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateWorkspacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateWorkspacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateWorkspacesError {
    fn code(&self) -> Option<&str> {
        TerminateWorkspacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateWorkspacesError {
    /// Creates a new `TerminateWorkspacesError`.
    pub fn new(kind: TerminateWorkspacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateWorkspacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateWorkspacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateWorkspacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateWorkspacesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for TerminateWorkspacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateWorkspacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConnectClientAddIn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConnectClientAddInError {
    /// Kind of error that occurred.
    pub kind: UpdateConnectClientAddInErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConnectClientAddIn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConnectClientAddInErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConnectClientAddInError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConnectClientAddInErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateConnectClientAddInErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConnectClientAddInErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateConnectClientAddInErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConnectClientAddInError {
    fn code(&self) -> Option<&str> {
        UpdateConnectClientAddInError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConnectClientAddInError {
    /// Creates a new `UpdateConnectClientAddInError`.
    pub fn new(kind: UpdateConnectClientAddInErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConnectClientAddInError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConnectClientAddInErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConnectClientAddInError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConnectClientAddInErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConnectClientAddInErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectClientAddInErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectClientAddInErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectClientAddInErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectClientAddInErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectClientAddInErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateConnectClientAddInError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConnectClientAddInErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateConnectClientAddInErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            UpdateConnectClientAddInErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateConnectClientAddInErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConnectionAliasPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConnectionAliasPermissionError {
    /// Kind of error that occurred.
    pub kind: UpdateConnectionAliasPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConnectionAliasPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConnectionAliasPermissionErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The resource is associated with a directory.</p>
    ResourceAssociatedException(crate::error::ResourceAssociatedException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConnectionAliasPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConnectionAliasPermissionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConnectionAliasPermissionErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConnectionAliasPermissionErrorKind::InvalidResourceStateException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConnectionAliasPermissionErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConnectionAliasPermissionErrorKind::ResourceAssociatedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConnectionAliasPermissionErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConnectionAliasPermissionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateConnectionAliasPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConnectionAliasPermissionError {
    fn code(&self) -> Option<&str> {
        UpdateConnectionAliasPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConnectionAliasPermissionError {
    /// Creates a new `UpdateConnectionAliasPermissionError`.
    pub fn new(
        kind: UpdateConnectionAliasPermissionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConnectionAliasPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConnectionAliasPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConnectionAliasPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConnectionAliasPermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConnectionAliasPermissionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionAliasPermissionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionAliasPermissionErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionAliasPermissionErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionAliasPermissionErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionAliasPermissionErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionAliasPermissionErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionAliasPermissionErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionAliasPermissionErrorKind::ResourceAssociatedException`.
    pub fn is_resource_associated_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionAliasPermissionErrorKind::ResourceAssociatedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionAliasPermissionErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionAliasPermissionErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionAliasPermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionAliasPermissionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateConnectionAliasPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConnectionAliasPermissionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateConnectionAliasPermissionErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            UpdateConnectionAliasPermissionErrorKind::InvalidResourceStateException(_inner) => {
                Some(_inner)
            }
            UpdateConnectionAliasPermissionErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            UpdateConnectionAliasPermissionErrorKind::ResourceAssociatedException(_inner) => {
                Some(_inner)
            }
            UpdateConnectionAliasPermissionErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            UpdateConnectionAliasPermissionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateConnectionAliasPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRulesOfIpGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRulesOfIpGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateRulesOfIpGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRulesOfIpGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRulesOfIpGroupErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The state of the resource is not valid for this operation.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRulesOfIpGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRulesOfIpGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRulesOfIpGroupErrorKind::InvalidParameterValuesException(_inner) => _inner.fmt(f),
            UpdateRulesOfIpGroupErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            UpdateRulesOfIpGroupErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            UpdateRulesOfIpGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRulesOfIpGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRulesOfIpGroupError {
    fn code(&self) -> Option<&str> {
        UpdateRulesOfIpGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRulesOfIpGroupError {
    /// Creates a new `UpdateRulesOfIpGroupError`.
    pub fn new(kind: UpdateRulesOfIpGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRulesOfIpGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRulesOfIpGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRulesOfIpGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRulesOfIpGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRulesOfIpGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRulesOfIpGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRulesOfIpGroupErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRulesOfIpGroupErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRulesOfIpGroupErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRulesOfIpGroupErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRulesOfIpGroupErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRulesOfIpGroupErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRulesOfIpGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRulesOfIpGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateRulesOfIpGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRulesOfIpGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRulesOfIpGroupErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            UpdateRulesOfIpGroupErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            UpdateRulesOfIpGroupErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            UpdateRulesOfIpGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRulesOfIpGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWorkspaceBundle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWorkspaceBundleError {
    /// Kind of error that occurred.
    pub kind: UpdateWorkspaceBundleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWorkspaceBundle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWorkspaceBundleErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWorkspaceBundleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWorkspaceBundleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateWorkspaceBundleErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            UpdateWorkspaceBundleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateWorkspaceBundleErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            UpdateWorkspaceBundleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWorkspaceBundleError {
    fn code(&self) -> Option<&str> {
        UpdateWorkspaceBundleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWorkspaceBundleError {
    /// Creates a new `UpdateWorkspaceBundleError`.
    pub fn new(kind: UpdateWorkspaceBundleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWorkspaceBundleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWorkspaceBundleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWorkspaceBundleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWorkspaceBundleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceBundleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceBundleErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceBundleErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceBundleErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceBundleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceBundleErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceBundleErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceBundleErrorKind::ResourceUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateWorkspaceBundleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWorkspaceBundleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateWorkspaceBundleErrorKind::InvalidParameterValuesException(_inner) => Some(_inner),
            UpdateWorkspaceBundleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateWorkspaceBundleErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            UpdateWorkspaceBundleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWorkspaceImagePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWorkspaceImagePermissionError {
    /// Kind of error that occurred.
    pub kind: UpdateWorkspaceImagePermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWorkspaceImagePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWorkspaceImagePermissionErrorKind {
    /// <p>The user is not authorized to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValuesException(crate::error::InvalidParameterValuesException),
    /// <p>This operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWorkspaceImagePermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWorkspaceImagePermissionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateWorkspaceImagePermissionErrorKind::InvalidParameterValuesException(_inner) => {
                _inner.fmt(f)
            }
            UpdateWorkspaceImagePermissionErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateWorkspaceImagePermissionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateWorkspaceImagePermissionErrorKind::ResourceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateWorkspaceImagePermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWorkspaceImagePermissionError {
    fn code(&self) -> Option<&str> {
        UpdateWorkspaceImagePermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWorkspaceImagePermissionError {
    /// Creates a new `UpdateWorkspaceImagePermissionError`.
    pub fn new(
        kind: UpdateWorkspaceImagePermissionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWorkspaceImagePermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWorkspaceImagePermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWorkspaceImagePermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWorkspaceImagePermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceImagePermissionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceImagePermissionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceImagePermissionErrorKind::InvalidParameterValuesException`.
    pub fn is_invalid_parameter_values_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceImagePermissionErrorKind::InvalidParameterValuesException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceImagePermissionErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceImagePermissionErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceImagePermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceImagePermissionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceImagePermissionErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceImagePermissionErrorKind::ResourceUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateWorkspaceImagePermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWorkspaceImagePermissionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateWorkspaceImagePermissionErrorKind::InvalidParameterValuesException(_inner) => {
                Some(_inner)
            }
            UpdateWorkspaceImagePermissionErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            UpdateWorkspaceImagePermissionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateWorkspaceImagePermissionErrorKind::ResourceUnavailableException(_inner) => {
                Some(_inner)
            }
            UpdateWorkspaceImagePermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified resource is not available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceUnavailableException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The identifier of the resource that is not available.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl ResourceUnavailableException {
    /// <p>The identifier of the resource that is not available.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceUnavailableException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
impl ResourceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceUnavailableException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceUnavailableException {}
/// See [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
pub mod resource_unavailable_exception {
    /// A builder for [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The identifier of the resource that is not available.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource that is not available.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
        pub fn build(self) -> crate::error::ResourceUnavailableException {
            crate::error::ResourceUnavailableException {
                message: self.message,
                resource_id: self.resource_id,
            }
        }
    }
}
impl ResourceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
    pub fn builder() -> crate::error::resource_unavailable_exception::Builder {
        crate::error::resource_unavailable_exception::Builder::default()
    }
}

/// <p>The resource could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The resource could not be found.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that could not be found.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>The ID of the resource that could not be found.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource could not be found.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The resource could not be found.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that could not be found.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that could not be found.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>This operation is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotSupportedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotSupportedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotSupportedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotSupportedException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotSupportedException {}
/// See [`OperationNotSupportedException`](crate::error::OperationNotSupportedException)
pub mod operation_not_supported_exception {
    /// A builder for [`OperationNotSupportedException`](crate::error::OperationNotSupportedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotSupportedException`](crate::error::OperationNotSupportedException)
        pub fn build(self) -> crate::error::OperationNotSupportedException {
            crate::error::OperationNotSupportedException {
                message: self.message,
            }
        }
    }
}
impl OperationNotSupportedException {
    /// Creates a new builder-style object to manufacture [`OperationNotSupportedException`](crate::error::OperationNotSupportedException)
    pub fn builder() -> crate::error::operation_not_supported_exception::Builder {
        crate::error::operation_not_supported_exception::Builder::default()
    }
}

/// <p>One or more parameter values are not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValuesException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterValuesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValuesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterValuesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValuesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValuesException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValuesException {}
/// See [`InvalidParameterValuesException`](crate::error::InvalidParameterValuesException)
pub mod invalid_parameter_values_exception {
    /// A builder for [`InvalidParameterValuesException`](crate::error::InvalidParameterValuesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValuesException`](crate::error::InvalidParameterValuesException)
        pub fn build(self) -> crate::error::InvalidParameterValuesException {
            crate::error::InvalidParameterValuesException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterValuesException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValuesException`](crate::error::InvalidParameterValuesException)
    pub fn builder() -> crate::error::invalid_parameter_values_exception::Builder {
        crate::error::invalid_parameter_values_exception::Builder::default()
    }
}

/// <p>The user is not authorized to access a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>Your resource limits have been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLimitExceededException {
    /// <p>The exception error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceLimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceLimitExceededException {}
/// See [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
pub mod resource_limit_exceeded_exception {
    /// A builder for [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
        pub fn build(self) -> crate::error::ResourceLimitExceededException {
            crate::error::ResourceLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ResourceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    pub fn builder() -> crate::error::resource_limit_exceeded_exception::Builder {
        crate::error::resource_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The state of the resource is not valid for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourceStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourceStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceStateException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceStateException {}
/// See [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
pub mod invalid_resource_state_exception {
    /// A builder for [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
        pub fn build(self) -> crate::error::InvalidResourceStateException {
            crate::error::InvalidResourceStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidResourceStateException {
    /// Creates a new builder-style object to manufacture [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
    pub fn builder() -> crate::error::invalid_resource_state_exception::Builder {
        crate::error::invalid_resource_state_exception::Builder::default()
    }
}

/// <p>The resource is associated with a directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAssociatedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAssociatedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAssociatedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAssociatedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAssociatedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAssociatedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAssociatedException {}
/// See [`ResourceAssociatedException`](crate::error::ResourceAssociatedException)
pub mod resource_associated_exception {
    /// A builder for [`ResourceAssociatedException`](crate::error::ResourceAssociatedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAssociatedException`](crate::error::ResourceAssociatedException)
        pub fn build(self) -> crate::error::ResourceAssociatedException {
            crate::error::ResourceAssociatedException {
                message: self.message,
            }
        }
    }
}
impl ResourceAssociatedException {
    /// Creates a new builder-style object to manufacture [`ResourceAssociatedException`](crate::error::ResourceAssociatedException)
    pub fn builder() -> crate::error::resource_associated_exception::Builder {
        crate::error::resource_associated_exception::Builder::default()
    }
}

/// <p>The workspaces_DefaultRole role could not be found. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">Creating the workspaces_DefaultRole Role</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspacesDefaultRoleNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WorkspacesDefaultRoleNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspacesDefaultRoleNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WorkspacesDefaultRoleNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WorkspacesDefaultRoleNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WorkspacesDefaultRoleNotFoundException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for WorkspacesDefaultRoleNotFoundException {}
/// See [`WorkspacesDefaultRoleNotFoundException`](crate::error::WorkspacesDefaultRoleNotFoundException)
pub mod workspaces_default_role_not_found_exception {
    /// A builder for [`WorkspacesDefaultRoleNotFoundException`](crate::error::WorkspacesDefaultRoleNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspacesDefaultRoleNotFoundException`](crate::error::WorkspacesDefaultRoleNotFoundException)
        pub fn build(self) -> crate::error::WorkspacesDefaultRoleNotFoundException {
            crate::error::WorkspacesDefaultRoleNotFoundException {
                message: self.message,
            }
        }
    }
}
impl WorkspacesDefaultRoleNotFoundException {
    /// Creates a new builder-style object to manufacture [`WorkspacesDefaultRoleNotFoundException`](crate::error::WorkspacesDefaultRoleNotFoundException)
    pub fn builder() -> crate::error::workspaces_default_role_not_found_exception::Builder {
        crate::error::workspaces_default_role_not_found_exception::Builder::default()
    }
}

/// <p>The configuration of this network is not supported for this operation, or your network configuration conflicts with the Amazon WorkSpaces management network IP range. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a VPC for Amazon WorkSpaces</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedNetworkConfigurationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedNetworkConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedNetworkConfigurationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedNetworkConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedNetworkConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedNetworkConfigurationException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedNetworkConfigurationException {}
/// See [`UnsupportedNetworkConfigurationException`](crate::error::UnsupportedNetworkConfigurationException)
pub mod unsupported_network_configuration_exception {
    /// A builder for [`UnsupportedNetworkConfigurationException`](crate::error::UnsupportedNetworkConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedNetworkConfigurationException`](crate::error::UnsupportedNetworkConfigurationException)
        pub fn build(self) -> crate::error::UnsupportedNetworkConfigurationException {
            crate::error::UnsupportedNetworkConfigurationException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedNetworkConfigurationException {
    /// Creates a new builder-style object to manufacture [`UnsupportedNetworkConfigurationException`](crate::error::UnsupportedNetworkConfigurationException)
    pub fn builder() -> crate::error::unsupported_network_configuration_exception::Builder {
        crate::error::unsupported_network_configuration_exception::Builder::default()
    }
}

/// <p>The configuration of this WorkSpace is not supported for this operation. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required Configuration and Service Components for WorkSpaces </a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedWorkspaceConfigurationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedWorkspaceConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedWorkspaceConfigurationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedWorkspaceConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedWorkspaceConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedWorkspaceConfigurationException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedWorkspaceConfigurationException {}
/// See [`UnsupportedWorkspaceConfigurationException`](crate::error::UnsupportedWorkspaceConfigurationException)
pub mod unsupported_workspace_configuration_exception {
    /// A builder for [`UnsupportedWorkspaceConfigurationException`](crate::error::UnsupportedWorkspaceConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedWorkspaceConfigurationException`](crate::error::UnsupportedWorkspaceConfigurationException)
        pub fn build(self) -> crate::error::UnsupportedWorkspaceConfigurationException {
            crate::error::UnsupportedWorkspaceConfigurationException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedWorkspaceConfigurationException {
    /// Creates a new builder-style object to manufacture [`UnsupportedWorkspaceConfigurationException`](crate::error::UnsupportedWorkspaceConfigurationException)
    pub fn builder() -> crate::error::unsupported_workspace_configuration_exception::Builder {
        crate::error::unsupported_workspace_configuration_exception::Builder::default()
    }
}

/// <p>The properties of this WorkSpace are currently being modified. Try again in a moment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationInProgressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationInProgressException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationInProgressException {}
/// See [`OperationInProgressException`](crate::error::OperationInProgressException)
pub mod operation_in_progress_exception {
    /// A builder for [`OperationInProgressException`](crate::error::OperationInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationInProgressException`](crate::error::OperationInProgressException)
        pub fn build(self) -> crate::error::OperationInProgressException {
            crate::error::OperationInProgressException {
                message: self.message,
            }
        }
    }
}
impl OperationInProgressException {
    /// Creates a new builder-style object to manufacture [`OperationInProgressException`](crate::error::OperationInProgressException)
    pub fn builder() -> crate::error::operation_in_progress_exception::Builder {
        crate::error::operation_in_progress_exception::Builder::default()
    }
}

/// <p>The specified resource already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}

/// <p>The resource could not be created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceCreationFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceCreationFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceCreationFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceCreationFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceCreationFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceCreationFailedException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceCreationFailedException {}
/// See [`ResourceCreationFailedException`](crate::error::ResourceCreationFailedException)
pub mod resource_creation_failed_exception {
    /// A builder for [`ResourceCreationFailedException`](crate::error::ResourceCreationFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceCreationFailedException`](crate::error::ResourceCreationFailedException)
        pub fn build(self) -> crate::error::ResourceCreationFailedException {
            crate::error::ResourceCreationFailedException {
                message: self.message,
            }
        }
    }
}
impl ResourceCreationFailedException {
    /// Creates a new builder-style object to manufacture [`ResourceCreationFailedException`](crate::error::ResourceCreationFailedException)
    pub fn builder() -> crate::error::resource_creation_failed_exception::Builder {
        crate::error::resource_creation_failed_exception::Builder::default()
    }
}
