// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes a rule for an IP access control group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpRuleItem {
    /// <p>The IP address range, in CIDR notation.</p>
    pub ip_rule: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub rule_desc: std::option::Option<std::string::String>,
}
impl IpRuleItem {
    /// <p>The IP address range, in CIDR notation.</p>
    pub fn ip_rule(&self) -> std::option::Option<&str> {
        self.ip_rule.as_deref()
    }
    /// <p>The description.</p>
    pub fn rule_desc(&self) -> std::option::Option<&str> {
        self.rule_desc.as_deref()
    }
}
impl std::fmt::Debug for IpRuleItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpRuleItem");
        formatter.field("ip_rule", &self.ip_rule);
        formatter.field("rule_desc", &self.rule_desc);
        formatter.finish()
    }
}
/// See [`IpRuleItem`](crate::model::IpRuleItem)
pub mod ip_rule_item {
    /// A builder for [`IpRuleItem`](crate::model::IpRuleItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_rule: std::option::Option<std::string::String>,
        pub(crate) rule_desc: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IP address range, in CIDR notation.</p>
        pub fn ip_rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_rule = Some(input.into());
            self
        }
        /// <p>The IP address range, in CIDR notation.</p>
        pub fn set_ip_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_rule = input;
            self
        }
        /// <p>The description.</p>
        pub fn rule_desc(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_desc = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_rule_desc(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_desc = input;
            self
        }
        /// Consumes the builder and constructs a [`IpRuleItem`](crate::model::IpRuleItem)
        pub fn build(self) -> crate::model::IpRuleItem {
            crate::model::IpRuleItem {
                ip_rule: self.ip_rule,
                rule_desc: self.rule_desc,
            }
        }
    }
}
impl IpRuleItem {
    /// Creates a new builder-style object to manufacture [`IpRuleItem`](crate::model::IpRuleItem)
    pub fn builder() -> crate::model::ip_rule_item::Builder {
        crate::model::ip_rule_item::Builder::default()
    }
}

/// <p>Describes the permissions for a connection alias. Connection aliases are used for cross-Region redirection.
/// For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html">
/// Cross-Region Redirection for Amazon WorkSpaces</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionAliasPermission {
    /// <p>The identifier of the Amazon Web Services account that the connection alias is shared with.</p>
    pub shared_account_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the specified Amazon Web Services account is allowed to associate the connection alias with a directory.</p>
    pub allow_association: std::option::Option<bool>,
}
impl ConnectionAliasPermission {
    /// <p>The identifier of the Amazon Web Services account that the connection alias is shared with.</p>
    pub fn shared_account_id(&self) -> std::option::Option<&str> {
        self.shared_account_id.as_deref()
    }
    /// <p>Indicates whether the specified Amazon Web Services account is allowed to associate the connection alias with a directory.</p>
    pub fn allow_association(&self) -> std::option::Option<bool> {
        self.allow_association
    }
}
impl std::fmt::Debug for ConnectionAliasPermission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionAliasPermission");
        formatter.field("shared_account_id", &self.shared_account_id);
        formatter.field("allow_association", &self.allow_association);
        formatter.finish()
    }
}
/// See [`ConnectionAliasPermission`](crate::model::ConnectionAliasPermission)
pub mod connection_alias_permission {
    /// A builder for [`ConnectionAliasPermission`](crate::model::ConnectionAliasPermission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shared_account_id: std::option::Option<std::string::String>,
        pub(crate) allow_association: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Web Services account that the connection alias is shared with.</p>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account that the connection alias is shared with.</p>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_account_id = input;
            self
        }
        /// <p>Indicates whether the specified Amazon Web Services account is allowed to associate the connection alias with a directory.</p>
        pub fn allow_association(mut self, input: bool) -> Self {
            self.allow_association = Some(input);
            self
        }
        /// <p>Indicates whether the specified Amazon Web Services account is allowed to associate the connection alias with a directory.</p>
        pub fn set_allow_association(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_association = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionAliasPermission`](crate::model::ConnectionAliasPermission)
        pub fn build(self) -> crate::model::ConnectionAliasPermission {
            crate::model::ConnectionAliasPermission {
                shared_account_id: self.shared_account_id,
                allow_association: self.allow_association,
            }
        }
    }
}
impl ConnectionAliasPermission {
    /// Creates a new builder-style object to manufacture [`ConnectionAliasPermission`](crate::model::ConnectionAliasPermission)
    pub fn builder() -> crate::model::connection_alias_permission::Builder {
        crate::model::connection_alias_permission::Builder::default()
    }
}

/// <p>Describes a WorkSpace that could not be rebooted.
/// (<a>RebootWorkspaces</a>), rebuilt (<a>RebuildWorkspaces</a>), restored (<a>RestoreWorkspace</a>), terminated
/// (<a>TerminateWorkspaces</a>), started (<a>StartWorkspaces</a>), or stopped (<a>StopWorkspaces</a>).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedWorkspaceChangeRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The error code that is returned if the WorkSpace cannot be rebooted.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The text of the error message that is returned if the WorkSpace cannot be
    /// rebooted.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl FailedWorkspaceChangeRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The error code that is returned if the WorkSpace cannot be rebooted.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The text of the error message that is returned if the WorkSpace cannot be
    /// rebooted.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for FailedWorkspaceChangeRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedWorkspaceChangeRequest");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`FailedWorkspaceChangeRequest`](crate::model::FailedWorkspaceChangeRequest)
pub mod failed_workspace_change_request {
    /// A builder for [`FailedWorkspaceChangeRequest`](crate::model::FailedWorkspaceChangeRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The error code that is returned if the WorkSpace cannot be rebooted.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that is returned if the WorkSpace cannot be rebooted.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The text of the error message that is returned if the WorkSpace cannot be
        /// rebooted.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The text of the error message that is returned if the WorkSpace cannot be
        /// rebooted.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedWorkspaceChangeRequest`](crate::model::FailedWorkspaceChangeRequest)
        pub fn build(self) -> crate::model::FailedWorkspaceChangeRequest {
            crate::model::FailedWorkspaceChangeRequest {
                workspace_id: self.workspace_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl FailedWorkspaceChangeRequest {
    /// Creates a new builder-style object to manufacture [`FailedWorkspaceChangeRequest`](crate::model::FailedWorkspaceChangeRequest)
    pub fn builder() -> crate::model::failed_workspace_change_request::Builder {
        crate::model::failed_workspace_change_request::Builder::default()
    }
}

/// <p>Describes the information used to terminate a WorkSpace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl TerminateRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for TerminateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateRequest");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}
/// See [`TerminateRequest`](crate::model::TerminateRequest)
pub mod terminate_request {
    /// A builder for [`TerminateRequest`](crate::model::TerminateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateRequest`](crate::model::TerminateRequest)
        pub fn build(self) -> crate::model::TerminateRequest {
            crate::model::TerminateRequest {
                workspace_id: self.workspace_id,
            }
        }
    }
}
impl TerminateRequest {
    /// Creates a new builder-style object to manufacture [`TerminateRequest`](crate::model::TerminateRequest)
    pub fn builder() -> crate::model::terminate_request::Builder {
        crate::model::terminate_request::Builder::default()
    }
}

/// <p>Describes the information used to stop a WorkSpace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl StopRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for StopRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopRequest");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}
/// See [`StopRequest`](crate::model::StopRequest)
pub mod stop_request {
    /// A builder for [`StopRequest`](crate::model::StopRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopRequest`](crate::model::StopRequest)
        pub fn build(self) -> crate::model::StopRequest {
            crate::model::StopRequest {
                workspace_id: self.workspace_id,
            }
        }
    }
}
impl StopRequest {
    /// Creates a new builder-style object to manufacture [`StopRequest`](crate::model::StopRequest)
    pub fn builder() -> crate::model::stop_request::Builder {
        crate::model::stop_request::Builder::default()
    }
}

/// <p>Information used to start a WorkSpace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl StartRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for StartRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartRequest");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}
/// See [`StartRequest`](crate::model::StartRequest)
pub mod start_request {
    /// A builder for [`StartRequest`](crate::model::StartRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartRequest`](crate::model::StartRequest)
        pub fn build(self) -> crate::model::StartRequest {
            crate::model::StartRequest {
                workspace_id: self.workspace_id,
            }
        }
    }
}
impl StartRequest {
    /// Creates a new builder-style object to manufacture [`StartRequest`](crate::model::StartRequest)
    pub fn builder() -> crate::model::start_request::Builder {
        crate::model::start_request::Builder::default()
    }
}

/// <p>Describes a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Tenancy {
    #[allow(missing_docs)] // documentation missing in model
    Dedicated,
    #[allow(missing_docs)] // documentation missing in model
    Shared,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Tenancy {
    fn from(s: &str) -> Self {
        match s {
            "DEDICATED" => Tenancy::Dedicated,
            "SHARED" => Tenancy::Shared,
            other => Tenancy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Tenancy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Tenancy::from(s))
    }
}
impl Tenancy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Tenancy::Dedicated => "DEDICATED",
            Tenancy::Shared => "SHARED",
            Tenancy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEDICATED", "SHARED"]
    }
}
impl AsRef<str> for Tenancy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the information used to rebuild a WorkSpace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebuildRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl RebuildRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for RebuildRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebuildRequest");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}
/// See [`RebuildRequest`](crate::model::RebuildRequest)
pub mod rebuild_request {
    /// A builder for [`RebuildRequest`](crate::model::RebuildRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RebuildRequest`](crate::model::RebuildRequest)
        pub fn build(self) -> crate::model::RebuildRequest {
            crate::model::RebuildRequest {
                workspace_id: self.workspace_id,
            }
        }
    }
}
impl RebuildRequest {
    /// Creates a new builder-style object to manufacture [`RebuildRequest`](crate::model::RebuildRequest)
    pub fn builder() -> crate::model::rebuild_request::Builder {
        crate::model::rebuild_request::Builder::default()
    }
}

/// <p>Describes the information used to reboot a WorkSpace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl RebootRequest {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for RebootRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootRequest");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}
/// See [`RebootRequest`](crate::model::RebootRequest)
pub mod reboot_request {
    /// A builder for [`RebootRequest`](crate::model::RebootRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootRequest`](crate::model::RebootRequest)
        pub fn build(self) -> crate::model::RebootRequest {
            crate::model::RebootRequest {
                workspace_id: self.workspace_id,
            }
        }
    }
}
impl RebootRequest {
    /// Creates a new builder-style object to manufacture [`RebootRequest`](crate::model::RebootRequest)
    pub fn builder() -> crate::model::reboot_request::Builder {
        crate::model::reboot_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetWorkspaceState {
    #[allow(missing_docs)] // documentation missing in model
    AdminMaintenance,
    #[allow(missing_docs)] // documentation missing in model
    Available,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetWorkspaceState {
    fn from(s: &str) -> Self {
        match s {
            "ADMIN_MAINTENANCE" => TargetWorkspaceState::AdminMaintenance,
            "AVAILABLE" => TargetWorkspaceState::Available,
            other => TargetWorkspaceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetWorkspaceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetWorkspaceState::from(s))
    }
}
impl TargetWorkspaceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetWorkspaceState::AdminMaintenance => "ADMIN_MAINTENANCE",
            TargetWorkspaceState::Available => "AVAILABLE",
            TargetWorkspaceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADMIN_MAINTENANCE", "AVAILABLE"]
    }
}
impl AsRef<str> for TargetWorkspaceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a WorkSpace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceProperties {
    /// <p>The running mode. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace Running
    /// Mode</a>.</p>
    pub running_mode: std::option::Option<crate::model::RunningMode>,
    /// <p>The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.</p>
    pub running_mode_auto_stop_timeout_in_minutes: std::option::Option<i32>,
    /// <p>The size of the root volume. For important information about how to modify the size of the root and user volumes, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">Modify a WorkSpace</a>.</p>
    pub root_volume_size_gib: std::option::Option<i32>,
    /// <p>The size of the user storage. For important information about how to modify the size of the root and user volumes, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">Modify a WorkSpace</a>.</p>
    pub user_volume_size_gib: std::option::Option<i32>,
    /// <p>The compute type. For more information, see <a href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces
    /// Bundles</a>.</p>
    pub compute_type_name: std::option::Option<crate::model::Compute>,
}
impl WorkspaceProperties {
    /// <p>The running mode. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace Running
    /// Mode</a>.</p>
    pub fn running_mode(&self) -> std::option::Option<&crate::model::RunningMode> {
        self.running_mode.as_ref()
    }
    /// <p>The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.</p>
    pub fn running_mode_auto_stop_timeout_in_minutes(&self) -> std::option::Option<i32> {
        self.running_mode_auto_stop_timeout_in_minutes
    }
    /// <p>The size of the root volume. For important information about how to modify the size of the root and user volumes, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">Modify a WorkSpace</a>.</p>
    pub fn root_volume_size_gib(&self) -> std::option::Option<i32> {
        self.root_volume_size_gib
    }
    /// <p>The size of the user storage. For important information about how to modify the size of the root and user volumes, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">Modify a WorkSpace</a>.</p>
    pub fn user_volume_size_gib(&self) -> std::option::Option<i32> {
        self.user_volume_size_gib
    }
    /// <p>The compute type. For more information, see <a href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces
    /// Bundles</a>.</p>
    pub fn compute_type_name(&self) -> std::option::Option<&crate::model::Compute> {
        self.compute_type_name.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceProperties");
        formatter.field("running_mode", &self.running_mode);
        formatter.field(
            "running_mode_auto_stop_timeout_in_minutes",
            &self.running_mode_auto_stop_timeout_in_minutes,
        );
        formatter.field("root_volume_size_gib", &self.root_volume_size_gib);
        formatter.field("user_volume_size_gib", &self.user_volume_size_gib);
        formatter.field("compute_type_name", &self.compute_type_name);
        formatter.finish()
    }
}
/// See [`WorkspaceProperties`](crate::model::WorkspaceProperties)
pub mod workspace_properties {
    /// A builder for [`WorkspaceProperties`](crate::model::WorkspaceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) running_mode: std::option::Option<crate::model::RunningMode>,
        pub(crate) running_mode_auto_stop_timeout_in_minutes: std::option::Option<i32>,
        pub(crate) root_volume_size_gib: std::option::Option<i32>,
        pub(crate) user_volume_size_gib: std::option::Option<i32>,
        pub(crate) compute_type_name: std::option::Option<crate::model::Compute>,
    }
    impl Builder {
        /// <p>The running mode. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace Running
        /// Mode</a>.</p>
        pub fn running_mode(mut self, input: crate::model::RunningMode) -> Self {
            self.running_mode = Some(input);
            self
        }
        /// <p>The running mode. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace Running
        /// Mode</a>.</p>
        pub fn set_running_mode(
            mut self,
            input: std::option::Option<crate::model::RunningMode>,
        ) -> Self {
            self.running_mode = input;
            self
        }
        /// <p>The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.</p>
        pub fn running_mode_auto_stop_timeout_in_minutes(mut self, input: i32) -> Self {
            self.running_mode_auto_stop_timeout_in_minutes = Some(input);
            self
        }
        /// <p>The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.</p>
        pub fn set_running_mode_auto_stop_timeout_in_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.running_mode_auto_stop_timeout_in_minutes = input;
            self
        }
        /// <p>The size of the root volume. For important information about how to modify the size of the root and user volumes, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">Modify a WorkSpace</a>.</p>
        pub fn root_volume_size_gib(mut self, input: i32) -> Self {
            self.root_volume_size_gib = Some(input);
            self
        }
        /// <p>The size of the root volume. For important information about how to modify the size of the root and user volumes, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">Modify a WorkSpace</a>.</p>
        pub fn set_root_volume_size_gib(mut self, input: std::option::Option<i32>) -> Self {
            self.root_volume_size_gib = input;
            self
        }
        /// <p>The size of the user storage. For important information about how to modify the size of the root and user volumes, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">Modify a WorkSpace</a>.</p>
        pub fn user_volume_size_gib(mut self, input: i32) -> Self {
            self.user_volume_size_gib = Some(input);
            self
        }
        /// <p>The size of the user storage. For important information about how to modify the size of the root and user volumes, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">Modify a WorkSpace</a>.</p>
        pub fn set_user_volume_size_gib(mut self, input: std::option::Option<i32>) -> Self {
            self.user_volume_size_gib = input;
            self
        }
        /// <p>The compute type. For more information, see <a href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces
        /// Bundles</a>.</p>
        pub fn compute_type_name(mut self, input: crate::model::Compute) -> Self {
            self.compute_type_name = Some(input);
            self
        }
        /// <p>The compute type. For more information, see <a href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces
        /// Bundles</a>.</p>
        pub fn set_compute_type_name(
            mut self,
            input: std::option::Option<crate::model::Compute>,
        ) -> Self {
            self.compute_type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceProperties`](crate::model::WorkspaceProperties)
        pub fn build(self) -> crate::model::WorkspaceProperties {
            crate::model::WorkspaceProperties {
                running_mode: self.running_mode,
                running_mode_auto_stop_timeout_in_minutes: self
                    .running_mode_auto_stop_timeout_in_minutes,
                root_volume_size_gib: self.root_volume_size_gib,
                user_volume_size_gib: self.user_volume_size_gib,
                compute_type_name: self.compute_type_name,
            }
        }
    }
}
impl WorkspaceProperties {
    /// Creates a new builder-style object to manufacture [`WorkspaceProperties`](crate::model::WorkspaceProperties)
    pub fn builder() -> crate::model::workspace_properties::Builder {
        crate::model::workspace_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Compute {
    #[allow(missing_docs)] // documentation missing in model
    Graphics,
    #[allow(missing_docs)] // documentation missing in model
    Graphicspro,
    #[allow(missing_docs)] // documentation missing in model
    Performance,
    #[allow(missing_docs)] // documentation missing in model
    Power,
    #[allow(missing_docs)] // documentation missing in model
    Powerpro,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    Value,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Compute {
    fn from(s: &str) -> Self {
        match s {
            "GRAPHICS" => Compute::Graphics,
            "GRAPHICSPRO" => Compute::Graphicspro,
            "PERFORMANCE" => Compute::Performance,
            "POWER" => Compute::Power,
            "POWERPRO" => Compute::Powerpro,
            "STANDARD" => Compute::Standard,
            "VALUE" => Compute::Value,
            other => Compute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Compute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Compute::from(s))
    }
}
impl Compute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Compute::Graphics => "GRAPHICS",
            Compute::Graphicspro => "GRAPHICSPRO",
            Compute::Performance => "PERFORMANCE",
            Compute::Power => "POWER",
            Compute::Powerpro => "POWERPRO",
            Compute::Standard => "STANDARD",
            Compute::Value => "VALUE",
            Compute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "GRAPHICS",
            "GRAPHICSPRO",
            "PERFORMANCE",
            "POWER",
            "POWERPRO",
            "STANDARD",
            "VALUE",
        ]
    }
}
impl AsRef<str> for Compute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RunningMode {
    #[allow(missing_docs)] // documentation missing in model
    AlwaysOn,
    #[allow(missing_docs)] // documentation missing in model
    AutoStop,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RunningMode {
    fn from(s: &str) -> Self {
        match s {
            "ALWAYS_ON" => RunningMode::AlwaysOn,
            "AUTO_STOP" => RunningMode::AutoStop,
            other => RunningMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RunningMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RunningMode::from(s))
    }
}
impl RunningMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RunningMode::AlwaysOn => "ALWAYS_ON",
            RunningMode::AutoStop => "AUTO_STOP",
            RunningMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALWAYS_ON", "AUTO_STOP"]
    }
}
impl AsRef<str> for RunningMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the default properties that are used for creating WorkSpaces. For more
/// information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html">Update Directory
/// Details for Your WorkSpaces</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceCreationProperties {
    /// <p>Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.</p>
    ///
    /// <note>         
    /// <p>If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched in the
    /// directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing WorkSpaces, unless
    /// you either disable users' access to WorkDocs or you delete the WorkDocs site. To disable users' access to WorkDocs,
    /// see <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html">Disabling Users</a> in the
    /// <i>Amazon WorkDocs Administration Guide</i>. To delete a WorkDocs site, see
    /// <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html">Deleting a Site</a> in the
    /// <i>Amazon WorkDocs Administration Guide</i>.</p>
    ///
    /// <p>If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces and any
    /// new WorkSpaces that are launched in the directory will have WorkDocs enabled.</p>
    /// </note>
    pub enable_work_docs: std::option::Option<bool>,
    /// <p>Indicates whether internet access is enabled for your WorkSpaces.</p>
    pub enable_internet_access: std::option::Option<bool>,
    /// <p>The default organizational unit (OU) for your WorkSpaces directories. This string must be the full Lightweight
    /// Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must be in the form
    /// <code>"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"</code>,
    /// where <i>value</i> is any string of characters, and the number of domain components (DCs) is
    /// two or more. For example, <code>OU=WorkSpaces_machines,DC=machines,DC=example,DC=com</code>. </p>
    ///
    /// <important>
    /// <ul>
    /// <li>
    /// <p>To avoid errors, certain characters in the distinguished name must be escaped. For more information,
    /// see <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names">
    /// Distinguished Names</a> in the Microsoft documentation.</p>
    /// </li>
    /// <li>
    /// <p>The API doesn't validate whether the OU exists.</p>
    /// </li>
    /// </ul>
    /// </important>
    pub default_ou: std::option::Option<std::string::String>,
    /// <p>The identifier of your custom security group.</p>
    pub custom_security_group_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether users are local administrators of their WorkSpaces.</p>
    pub user_enabled_as_local_administrator: std::option::Option<bool>,
    /// <p>Indicates whether maintenance mode is enabled for your WorkSpaces. For more information,
    /// see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
    /// Maintenance</a>. </p>
    pub enable_maintenance_mode: std::option::Option<bool>,
}
impl WorkspaceCreationProperties {
    /// <p>Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.</p>
    ///
    /// <note>         
    /// <p>If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched in the
    /// directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing WorkSpaces, unless
    /// you either disable users' access to WorkDocs or you delete the WorkDocs site. To disable users' access to WorkDocs,
    /// see <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html">Disabling Users</a> in the
    /// <i>Amazon WorkDocs Administration Guide</i>. To delete a WorkDocs site, see
    /// <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html">Deleting a Site</a> in the
    /// <i>Amazon WorkDocs Administration Guide</i>.</p>
    ///
    /// <p>If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces and any
    /// new WorkSpaces that are launched in the directory will have WorkDocs enabled.</p>
    /// </note>
    pub fn enable_work_docs(&self) -> std::option::Option<bool> {
        self.enable_work_docs
    }
    /// <p>Indicates whether internet access is enabled for your WorkSpaces.</p>
    pub fn enable_internet_access(&self) -> std::option::Option<bool> {
        self.enable_internet_access
    }
    /// <p>The default organizational unit (OU) for your WorkSpaces directories. This string must be the full Lightweight
    /// Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must be in the form
    /// <code>"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"</code>,
    /// where <i>value</i> is any string of characters, and the number of domain components (DCs) is
    /// two or more. For example, <code>OU=WorkSpaces_machines,DC=machines,DC=example,DC=com</code>. </p>
    ///
    /// <important>
    /// <ul>
    /// <li>
    /// <p>To avoid errors, certain characters in the distinguished name must be escaped. For more information,
    /// see <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names">
    /// Distinguished Names</a> in the Microsoft documentation.</p>
    /// </li>
    /// <li>
    /// <p>The API doesn't validate whether the OU exists.</p>
    /// </li>
    /// </ul>
    /// </important>
    pub fn default_ou(&self) -> std::option::Option<&str> {
        self.default_ou.as_deref()
    }
    /// <p>The identifier of your custom security group.</p>
    pub fn custom_security_group_id(&self) -> std::option::Option<&str> {
        self.custom_security_group_id.as_deref()
    }
    /// <p>Indicates whether users are local administrators of their WorkSpaces.</p>
    pub fn user_enabled_as_local_administrator(&self) -> std::option::Option<bool> {
        self.user_enabled_as_local_administrator
    }
    /// <p>Indicates whether maintenance mode is enabled for your WorkSpaces. For more information,
    /// see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
    /// Maintenance</a>. </p>
    pub fn enable_maintenance_mode(&self) -> std::option::Option<bool> {
        self.enable_maintenance_mode
    }
}
impl std::fmt::Debug for WorkspaceCreationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceCreationProperties");
        formatter.field("enable_work_docs", &self.enable_work_docs);
        formatter.field("enable_internet_access", &self.enable_internet_access);
        formatter.field("default_ou", &self.default_ou);
        formatter.field("custom_security_group_id", &self.custom_security_group_id);
        formatter.field(
            "user_enabled_as_local_administrator",
            &self.user_enabled_as_local_administrator,
        );
        formatter.field("enable_maintenance_mode", &self.enable_maintenance_mode);
        formatter.finish()
    }
}
/// See [`WorkspaceCreationProperties`](crate::model::WorkspaceCreationProperties)
pub mod workspace_creation_properties {
    /// A builder for [`WorkspaceCreationProperties`](crate::model::WorkspaceCreationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_work_docs: std::option::Option<bool>,
        pub(crate) enable_internet_access: std::option::Option<bool>,
        pub(crate) default_ou: std::option::Option<std::string::String>,
        pub(crate) custom_security_group_id: std::option::Option<std::string::String>,
        pub(crate) user_enabled_as_local_administrator: std::option::Option<bool>,
        pub(crate) enable_maintenance_mode: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.</p>
        ///
        /// <note>         
        /// <p>If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched in the
        /// directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing WorkSpaces, unless
        /// you either disable users' access to WorkDocs or you delete the WorkDocs site. To disable users' access to WorkDocs,
        /// see <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html">Disabling Users</a> in the
        /// <i>Amazon WorkDocs Administration Guide</i>. To delete a WorkDocs site, see
        /// <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html">Deleting a Site</a> in the
        /// <i>Amazon WorkDocs Administration Guide</i>.</p>
        ///
        /// <p>If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces and any
        /// new WorkSpaces that are launched in the directory will have WorkDocs enabled.</p>
        /// </note>
        pub fn enable_work_docs(mut self, input: bool) -> Self {
            self.enable_work_docs = Some(input);
            self
        }
        /// <p>Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.</p>
        ///
        /// <note>         
        /// <p>If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched in the
        /// directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing WorkSpaces, unless
        /// you either disable users' access to WorkDocs or you delete the WorkDocs site. To disable users' access to WorkDocs,
        /// see <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html">Disabling Users</a> in the
        /// <i>Amazon WorkDocs Administration Guide</i>. To delete a WorkDocs site, see
        /// <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html">Deleting a Site</a> in the
        /// <i>Amazon WorkDocs Administration Guide</i>.</p>
        ///
        /// <p>If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces and any
        /// new WorkSpaces that are launched in the directory will have WorkDocs enabled.</p>
        /// </note>
        pub fn set_enable_work_docs(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_work_docs = input;
            self
        }
        /// <p>Indicates whether internet access is enabled for your WorkSpaces.</p>
        pub fn enable_internet_access(mut self, input: bool) -> Self {
            self.enable_internet_access = Some(input);
            self
        }
        /// <p>Indicates whether internet access is enabled for your WorkSpaces.</p>
        pub fn set_enable_internet_access(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_internet_access = input;
            self
        }
        /// <p>The default organizational unit (OU) for your WorkSpaces directories. This string must be the full Lightweight
        /// Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must be in the form
        /// <code>"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"</code>,
        /// where <i>value</i> is any string of characters, and the number of domain components (DCs) is
        /// two or more. For example, <code>OU=WorkSpaces_machines,DC=machines,DC=example,DC=com</code>. </p>
        ///
        /// <important>
        /// <ul>
        /// <li>
        /// <p>To avoid errors, certain characters in the distinguished name must be escaped. For more information,
        /// see <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names">
        /// Distinguished Names</a> in the Microsoft documentation.</p>
        /// </li>
        /// <li>
        /// <p>The API doesn't validate whether the OU exists.</p>
        /// </li>
        /// </ul>
        /// </important>
        pub fn default_ou(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_ou = Some(input.into());
            self
        }
        /// <p>The default organizational unit (OU) for your WorkSpaces directories. This string must be the full Lightweight
        /// Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must be in the form
        /// <code>"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"</code>,
        /// where <i>value</i> is any string of characters, and the number of domain components (DCs) is
        /// two or more. For example, <code>OU=WorkSpaces_machines,DC=machines,DC=example,DC=com</code>. </p>
        ///
        /// <important>
        /// <ul>
        /// <li>
        /// <p>To avoid errors, certain characters in the distinguished name must be escaped. For more information,
        /// see <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names">
        /// Distinguished Names</a> in the Microsoft documentation.</p>
        /// </li>
        /// <li>
        /// <p>The API doesn't validate whether the OU exists.</p>
        /// </li>
        /// </ul>
        /// </important>
        pub fn set_default_ou(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.default_ou = input;
            self
        }
        /// <p>The identifier of your custom security group.</p>
        pub fn custom_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_security_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of your custom security group.</p>
        pub fn set_custom_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_security_group_id = input;
            self
        }
        /// <p>Indicates whether users are local administrators of their WorkSpaces.</p>
        pub fn user_enabled_as_local_administrator(mut self, input: bool) -> Self {
            self.user_enabled_as_local_administrator = Some(input);
            self
        }
        /// <p>Indicates whether users are local administrators of their WorkSpaces.</p>
        pub fn set_user_enabled_as_local_administrator(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.user_enabled_as_local_administrator = input;
            self
        }
        /// <p>Indicates whether maintenance mode is enabled for your WorkSpaces. For more information,
        /// see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
        /// Maintenance</a>. </p>
        pub fn enable_maintenance_mode(mut self, input: bool) -> Self {
            self.enable_maintenance_mode = Some(input);
            self
        }
        /// <p>Indicates whether maintenance mode is enabled for your WorkSpaces. For more information,
        /// see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
        /// Maintenance</a>. </p>
        pub fn set_enable_maintenance_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_maintenance_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceCreationProperties`](crate::model::WorkspaceCreationProperties)
        pub fn build(self) -> crate::model::WorkspaceCreationProperties {
            crate::model::WorkspaceCreationProperties {
                enable_work_docs: self.enable_work_docs,
                enable_internet_access: self.enable_internet_access,
                default_ou: self.default_ou,
                custom_security_group_id: self.custom_security_group_id,
                user_enabled_as_local_administrator: self.user_enabled_as_local_administrator,
                enable_maintenance_mode: self.enable_maintenance_mode,
            }
        }
    }
}
impl WorkspaceCreationProperties {
    /// Creates a new builder-style object to manufacture [`WorkspaceCreationProperties`](crate::model::WorkspaceCreationProperties)
    pub fn builder() -> crate::model::workspace_creation_properties::Builder {
        crate::model::workspace_creation_properties::Builder::default()
    }
}

/// <p>The device types and operating systems that can be used to access a WorkSpace. For more
/// information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-network-requirements.html">Amazon
/// WorkSpaces Client Network Requirements</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceAccessProperties {
    /// <p>Indicates whether users can use Windows clients to access their WorkSpaces.</p>
    pub device_type_windows: std::option::Option<crate::model::AccessPropertyValue>,
    /// <p>Indicates whether users can use macOS clients to access their WorkSpaces.</p>
    pub device_type_osx: std::option::Option<crate::model::AccessPropertyValue>,
    /// <p>Indicates whether users can access their WorkSpaces through a web browser.</p>
    pub device_type_web: std::option::Option<crate::model::AccessPropertyValue>,
    /// <p>Indicates whether users can use iOS devices to access their WorkSpaces.</p>
    pub device_type_ios: std::option::Option<crate::model::AccessPropertyValue>,
    /// <p>Indicates whether users can use Android and Android-compatible Chrome OS devices
    /// to access their WorkSpaces.</p>
    pub device_type_android: std::option::Option<crate::model::AccessPropertyValue>,
    /// <p>Indicates whether users can use Chromebooks to access their WorkSpaces.</p>
    pub device_type_chrome_os: std::option::Option<crate::model::AccessPropertyValue>,
    /// <p>Indicates whether users can use zero client devices to access their WorkSpaces.</p>
    pub device_type_zero_client: std::option::Option<crate::model::AccessPropertyValue>,
    /// <p>Indicates whether users can use Linux clients to access their WorkSpaces.</p>
    pub device_type_linux: std::option::Option<crate::model::AccessPropertyValue>,
}
impl WorkspaceAccessProperties {
    /// <p>Indicates whether users can use Windows clients to access their WorkSpaces.</p>
    pub fn device_type_windows(&self) -> std::option::Option<&crate::model::AccessPropertyValue> {
        self.device_type_windows.as_ref()
    }
    /// <p>Indicates whether users can use macOS clients to access their WorkSpaces.</p>
    pub fn device_type_osx(&self) -> std::option::Option<&crate::model::AccessPropertyValue> {
        self.device_type_osx.as_ref()
    }
    /// <p>Indicates whether users can access their WorkSpaces through a web browser.</p>
    pub fn device_type_web(&self) -> std::option::Option<&crate::model::AccessPropertyValue> {
        self.device_type_web.as_ref()
    }
    /// <p>Indicates whether users can use iOS devices to access their WorkSpaces.</p>
    pub fn device_type_ios(&self) -> std::option::Option<&crate::model::AccessPropertyValue> {
        self.device_type_ios.as_ref()
    }
    /// <p>Indicates whether users can use Android and Android-compatible Chrome OS devices
    /// to access their WorkSpaces.</p>
    pub fn device_type_android(&self) -> std::option::Option<&crate::model::AccessPropertyValue> {
        self.device_type_android.as_ref()
    }
    /// <p>Indicates whether users can use Chromebooks to access their WorkSpaces.</p>
    pub fn device_type_chrome_os(&self) -> std::option::Option<&crate::model::AccessPropertyValue> {
        self.device_type_chrome_os.as_ref()
    }
    /// <p>Indicates whether users can use zero client devices to access their WorkSpaces.</p>
    pub fn device_type_zero_client(
        &self,
    ) -> std::option::Option<&crate::model::AccessPropertyValue> {
        self.device_type_zero_client.as_ref()
    }
    /// <p>Indicates whether users can use Linux clients to access their WorkSpaces.</p>
    pub fn device_type_linux(&self) -> std::option::Option<&crate::model::AccessPropertyValue> {
        self.device_type_linux.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceAccessProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceAccessProperties");
        formatter.field("device_type_windows", &self.device_type_windows);
        formatter.field("device_type_osx", &self.device_type_osx);
        formatter.field("device_type_web", &self.device_type_web);
        formatter.field("device_type_ios", &self.device_type_ios);
        formatter.field("device_type_android", &self.device_type_android);
        formatter.field("device_type_chrome_os", &self.device_type_chrome_os);
        formatter.field("device_type_zero_client", &self.device_type_zero_client);
        formatter.field("device_type_linux", &self.device_type_linux);
        formatter.finish()
    }
}
/// See [`WorkspaceAccessProperties`](crate::model::WorkspaceAccessProperties)
pub mod workspace_access_properties {
    /// A builder for [`WorkspaceAccessProperties`](crate::model::WorkspaceAccessProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_type_windows: std::option::Option<crate::model::AccessPropertyValue>,
        pub(crate) device_type_osx: std::option::Option<crate::model::AccessPropertyValue>,
        pub(crate) device_type_web: std::option::Option<crate::model::AccessPropertyValue>,
        pub(crate) device_type_ios: std::option::Option<crate::model::AccessPropertyValue>,
        pub(crate) device_type_android: std::option::Option<crate::model::AccessPropertyValue>,
        pub(crate) device_type_chrome_os: std::option::Option<crate::model::AccessPropertyValue>,
        pub(crate) device_type_zero_client: std::option::Option<crate::model::AccessPropertyValue>,
        pub(crate) device_type_linux: std::option::Option<crate::model::AccessPropertyValue>,
    }
    impl Builder {
        /// <p>Indicates whether users can use Windows clients to access their WorkSpaces.</p>
        pub fn device_type_windows(mut self, input: crate::model::AccessPropertyValue) -> Self {
            self.device_type_windows = Some(input);
            self
        }
        /// <p>Indicates whether users can use Windows clients to access their WorkSpaces.</p>
        pub fn set_device_type_windows(
            mut self,
            input: std::option::Option<crate::model::AccessPropertyValue>,
        ) -> Self {
            self.device_type_windows = input;
            self
        }
        /// <p>Indicates whether users can use macOS clients to access their WorkSpaces.</p>
        pub fn device_type_osx(mut self, input: crate::model::AccessPropertyValue) -> Self {
            self.device_type_osx = Some(input);
            self
        }
        /// <p>Indicates whether users can use macOS clients to access their WorkSpaces.</p>
        pub fn set_device_type_osx(
            mut self,
            input: std::option::Option<crate::model::AccessPropertyValue>,
        ) -> Self {
            self.device_type_osx = input;
            self
        }
        /// <p>Indicates whether users can access their WorkSpaces through a web browser.</p>
        pub fn device_type_web(mut self, input: crate::model::AccessPropertyValue) -> Self {
            self.device_type_web = Some(input);
            self
        }
        /// <p>Indicates whether users can access their WorkSpaces through a web browser.</p>
        pub fn set_device_type_web(
            mut self,
            input: std::option::Option<crate::model::AccessPropertyValue>,
        ) -> Self {
            self.device_type_web = input;
            self
        }
        /// <p>Indicates whether users can use iOS devices to access their WorkSpaces.</p>
        pub fn device_type_ios(mut self, input: crate::model::AccessPropertyValue) -> Self {
            self.device_type_ios = Some(input);
            self
        }
        /// <p>Indicates whether users can use iOS devices to access their WorkSpaces.</p>
        pub fn set_device_type_ios(
            mut self,
            input: std::option::Option<crate::model::AccessPropertyValue>,
        ) -> Self {
            self.device_type_ios = input;
            self
        }
        /// <p>Indicates whether users can use Android and Android-compatible Chrome OS devices
        /// to access their WorkSpaces.</p>
        pub fn device_type_android(mut self, input: crate::model::AccessPropertyValue) -> Self {
            self.device_type_android = Some(input);
            self
        }
        /// <p>Indicates whether users can use Android and Android-compatible Chrome OS devices
        /// to access their WorkSpaces.</p>
        pub fn set_device_type_android(
            mut self,
            input: std::option::Option<crate::model::AccessPropertyValue>,
        ) -> Self {
            self.device_type_android = input;
            self
        }
        /// <p>Indicates whether users can use Chromebooks to access their WorkSpaces.</p>
        pub fn device_type_chrome_os(mut self, input: crate::model::AccessPropertyValue) -> Self {
            self.device_type_chrome_os = Some(input);
            self
        }
        /// <p>Indicates whether users can use Chromebooks to access their WorkSpaces.</p>
        pub fn set_device_type_chrome_os(
            mut self,
            input: std::option::Option<crate::model::AccessPropertyValue>,
        ) -> Self {
            self.device_type_chrome_os = input;
            self
        }
        /// <p>Indicates whether users can use zero client devices to access their WorkSpaces.</p>
        pub fn device_type_zero_client(mut self, input: crate::model::AccessPropertyValue) -> Self {
            self.device_type_zero_client = Some(input);
            self
        }
        /// <p>Indicates whether users can use zero client devices to access their WorkSpaces.</p>
        pub fn set_device_type_zero_client(
            mut self,
            input: std::option::Option<crate::model::AccessPropertyValue>,
        ) -> Self {
            self.device_type_zero_client = input;
            self
        }
        /// <p>Indicates whether users can use Linux clients to access their WorkSpaces.</p>
        pub fn device_type_linux(mut self, input: crate::model::AccessPropertyValue) -> Self {
            self.device_type_linux = Some(input);
            self
        }
        /// <p>Indicates whether users can use Linux clients to access their WorkSpaces.</p>
        pub fn set_device_type_linux(
            mut self,
            input: std::option::Option<crate::model::AccessPropertyValue>,
        ) -> Self {
            self.device_type_linux = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceAccessProperties`](crate::model::WorkspaceAccessProperties)
        pub fn build(self) -> crate::model::WorkspaceAccessProperties {
            crate::model::WorkspaceAccessProperties {
                device_type_windows: self.device_type_windows,
                device_type_osx: self.device_type_osx,
                device_type_web: self.device_type_web,
                device_type_ios: self.device_type_ios,
                device_type_android: self.device_type_android,
                device_type_chrome_os: self.device_type_chrome_os,
                device_type_zero_client: self.device_type_zero_client,
                device_type_linux: self.device_type_linux,
            }
        }
    }
}
impl WorkspaceAccessProperties {
    /// Creates a new builder-style object to manufacture [`WorkspaceAccessProperties`](crate::model::WorkspaceAccessProperties)
    pub fn builder() -> crate::model::workspace_access_properties::Builder {
        crate::model::workspace_access_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessPropertyValue {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessPropertyValue {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW" => AccessPropertyValue::Allow,
            "DENY" => AccessPropertyValue::Deny,
            other => AccessPropertyValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessPropertyValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessPropertyValue::from(s))
    }
}
impl AccessPropertyValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessPropertyValue::Allow => "ALLOW",
            AccessPropertyValue::Deny => "DENY",
            AccessPropertyValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW", "DENY"]
    }
}
impl AsRef<str> for AccessPropertyValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the self-service permissions for a directory. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html">Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelfservicePermissions {
    /// <p>Specifies whether users can restart their WorkSpace.</p>
    pub restart_workspace: std::option::Option<crate::model::ReconnectEnum>,
    /// <p>Specifies whether users can increase the volume size of the drives on their
    /// WorkSpace.</p>
    pub increase_volume_size: std::option::Option<crate::model::ReconnectEnum>,
    /// <p>Specifies whether users can change the compute type (bundle) for their WorkSpace.</p>
    pub change_compute_type: std::option::Option<crate::model::ReconnectEnum>,
    /// <p>Specifies whether users can switch the running mode of their WorkSpace.</p>
    pub switch_running_mode: std::option::Option<crate::model::ReconnectEnum>,
    /// <p>Specifies whether users can rebuild the operating system of a WorkSpace to its original
    /// state.</p>
    pub rebuild_workspace: std::option::Option<crate::model::ReconnectEnum>,
}
impl SelfservicePermissions {
    /// <p>Specifies whether users can restart their WorkSpace.</p>
    pub fn restart_workspace(&self) -> std::option::Option<&crate::model::ReconnectEnum> {
        self.restart_workspace.as_ref()
    }
    /// <p>Specifies whether users can increase the volume size of the drives on their
    /// WorkSpace.</p>
    pub fn increase_volume_size(&self) -> std::option::Option<&crate::model::ReconnectEnum> {
        self.increase_volume_size.as_ref()
    }
    /// <p>Specifies whether users can change the compute type (bundle) for their WorkSpace.</p>
    pub fn change_compute_type(&self) -> std::option::Option<&crate::model::ReconnectEnum> {
        self.change_compute_type.as_ref()
    }
    /// <p>Specifies whether users can switch the running mode of their WorkSpace.</p>
    pub fn switch_running_mode(&self) -> std::option::Option<&crate::model::ReconnectEnum> {
        self.switch_running_mode.as_ref()
    }
    /// <p>Specifies whether users can rebuild the operating system of a WorkSpace to its original
    /// state.</p>
    pub fn rebuild_workspace(&self) -> std::option::Option<&crate::model::ReconnectEnum> {
        self.rebuild_workspace.as_ref()
    }
}
impl std::fmt::Debug for SelfservicePermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelfservicePermissions");
        formatter.field("restart_workspace", &self.restart_workspace);
        formatter.field("increase_volume_size", &self.increase_volume_size);
        formatter.field("change_compute_type", &self.change_compute_type);
        formatter.field("switch_running_mode", &self.switch_running_mode);
        formatter.field("rebuild_workspace", &self.rebuild_workspace);
        formatter.finish()
    }
}
/// See [`SelfservicePermissions`](crate::model::SelfservicePermissions)
pub mod selfservice_permissions {
    /// A builder for [`SelfservicePermissions`](crate::model::SelfservicePermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) restart_workspace: std::option::Option<crate::model::ReconnectEnum>,
        pub(crate) increase_volume_size: std::option::Option<crate::model::ReconnectEnum>,
        pub(crate) change_compute_type: std::option::Option<crate::model::ReconnectEnum>,
        pub(crate) switch_running_mode: std::option::Option<crate::model::ReconnectEnum>,
        pub(crate) rebuild_workspace: std::option::Option<crate::model::ReconnectEnum>,
    }
    impl Builder {
        /// <p>Specifies whether users can restart their WorkSpace.</p>
        pub fn restart_workspace(mut self, input: crate::model::ReconnectEnum) -> Self {
            self.restart_workspace = Some(input);
            self
        }
        /// <p>Specifies whether users can restart their WorkSpace.</p>
        pub fn set_restart_workspace(
            mut self,
            input: std::option::Option<crate::model::ReconnectEnum>,
        ) -> Self {
            self.restart_workspace = input;
            self
        }
        /// <p>Specifies whether users can increase the volume size of the drives on their
        /// WorkSpace.</p>
        pub fn increase_volume_size(mut self, input: crate::model::ReconnectEnum) -> Self {
            self.increase_volume_size = Some(input);
            self
        }
        /// <p>Specifies whether users can increase the volume size of the drives on their
        /// WorkSpace.</p>
        pub fn set_increase_volume_size(
            mut self,
            input: std::option::Option<crate::model::ReconnectEnum>,
        ) -> Self {
            self.increase_volume_size = input;
            self
        }
        /// <p>Specifies whether users can change the compute type (bundle) for their WorkSpace.</p>
        pub fn change_compute_type(mut self, input: crate::model::ReconnectEnum) -> Self {
            self.change_compute_type = Some(input);
            self
        }
        /// <p>Specifies whether users can change the compute type (bundle) for their WorkSpace.</p>
        pub fn set_change_compute_type(
            mut self,
            input: std::option::Option<crate::model::ReconnectEnum>,
        ) -> Self {
            self.change_compute_type = input;
            self
        }
        /// <p>Specifies whether users can switch the running mode of their WorkSpace.</p>
        pub fn switch_running_mode(mut self, input: crate::model::ReconnectEnum) -> Self {
            self.switch_running_mode = Some(input);
            self
        }
        /// <p>Specifies whether users can switch the running mode of their WorkSpace.</p>
        pub fn set_switch_running_mode(
            mut self,
            input: std::option::Option<crate::model::ReconnectEnum>,
        ) -> Self {
            self.switch_running_mode = input;
            self
        }
        /// <p>Specifies whether users can rebuild the operating system of a WorkSpace to its original
        /// state.</p>
        pub fn rebuild_workspace(mut self, input: crate::model::ReconnectEnum) -> Self {
            self.rebuild_workspace = Some(input);
            self
        }
        /// <p>Specifies whether users can rebuild the operating system of a WorkSpace to its original
        /// state.</p>
        pub fn set_rebuild_workspace(
            mut self,
            input: std::option::Option<crate::model::ReconnectEnum>,
        ) -> Self {
            self.rebuild_workspace = input;
            self
        }
        /// Consumes the builder and constructs a [`SelfservicePermissions`](crate::model::SelfservicePermissions)
        pub fn build(self) -> crate::model::SelfservicePermissions {
            crate::model::SelfservicePermissions {
                restart_workspace: self.restart_workspace,
                increase_volume_size: self.increase_volume_size,
                change_compute_type: self.change_compute_type,
                switch_running_mode: self.switch_running_mode,
                rebuild_workspace: self.rebuild_workspace,
            }
        }
    }
}
impl SelfservicePermissions {
    /// Creates a new builder-style object to manufacture [`SelfservicePermissions`](crate::model::SelfservicePermissions)
    pub fn builder() -> crate::model::selfservice_permissions::Builder {
        crate::model::selfservice_permissions::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReconnectEnum {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReconnectEnum {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ReconnectEnum::Disabled,
            "ENABLED" => ReconnectEnum::Enabled,
            other => ReconnectEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReconnectEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReconnectEnum::from(s))
    }
}
impl ReconnectEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReconnectEnum::Disabled => "DISABLED",
            ReconnectEnum::Enabled => "ENABLED",
            ReconnectEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for ReconnectEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an Amazon WorkSpaces client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientProperties {
    /// <p>Specifies whether users can cache their credentials on the Amazon WorkSpaces client.
    /// When enabled, users can choose to reconnect to their WorkSpaces without re-entering their
    /// credentials. </p>
    pub reconnect_enabled: std::option::Option<crate::model::ReconnectEnum>,
}
impl ClientProperties {
    /// <p>Specifies whether users can cache their credentials on the Amazon WorkSpaces client.
    /// When enabled, users can choose to reconnect to their WorkSpaces without re-entering their
    /// credentials. </p>
    pub fn reconnect_enabled(&self) -> std::option::Option<&crate::model::ReconnectEnum> {
        self.reconnect_enabled.as_ref()
    }
}
impl std::fmt::Debug for ClientProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientProperties");
        formatter.field("reconnect_enabled", &self.reconnect_enabled);
        formatter.finish()
    }
}
/// See [`ClientProperties`](crate::model::ClientProperties)
pub mod client_properties {
    /// A builder for [`ClientProperties`](crate::model::ClientProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reconnect_enabled: std::option::Option<crate::model::ReconnectEnum>,
    }
    impl Builder {
        /// <p>Specifies whether users can cache their credentials on the Amazon WorkSpaces client.
        /// When enabled, users can choose to reconnect to their WorkSpaces without re-entering their
        /// credentials. </p>
        pub fn reconnect_enabled(mut self, input: crate::model::ReconnectEnum) -> Self {
            self.reconnect_enabled = Some(input);
            self
        }
        /// <p>Specifies whether users can cache their credentials on the Amazon WorkSpaces client.
        /// When enabled, users can choose to reconnect to their WorkSpaces without re-entering their
        /// credentials. </p>
        pub fn set_reconnect_enabled(
            mut self,
            input: std::option::Option<crate::model::ReconnectEnum>,
        ) -> Self {
            self.reconnect_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientProperties`](crate::model::ClientProperties)
        pub fn build(self) -> crate::model::ClientProperties {
            crate::model::ClientProperties {
                reconnect_enabled: self.reconnect_enabled,
            }
        }
    }
}
impl ClientProperties {
    /// Creates a new builder-style object to manufacture [`ClientProperties`](crate::model::ClientProperties)
    pub fn builder() -> crate::model::client_properties::Builder {
        crate::model::client_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DedicatedTenancySupportEnum {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DedicatedTenancySupportEnum {
    fn from(s: &str) -> Self {
        match s {
            "ENABLED" => DedicatedTenancySupportEnum::Enabled,
            other => DedicatedTenancySupportEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DedicatedTenancySupportEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DedicatedTenancySupportEnum::from(s))
    }
}
impl DedicatedTenancySupportEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DedicatedTenancySupportEnum::Enabled => "ENABLED",
            DedicatedTenancySupportEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENABLED"]
    }
}
impl AsRef<str> for DedicatedTenancySupportEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Application {
    #[allow(missing_docs)] // documentation missing in model
    MicrosoftOffice2016,
    #[allow(missing_docs)] // documentation missing in model
    MicrosoftOffice2019,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Application {
    fn from(s: &str) -> Self {
        match s {
            "Microsoft_Office_2016" => Application::MicrosoftOffice2016,
            "Microsoft_Office_2019" => Application::MicrosoftOffice2019,
            other => Application::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Application {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Application::from(s))
    }
}
impl Application {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Application::MicrosoftOffice2016 => "Microsoft_Office_2016",
            Application::MicrosoftOffice2019 => "Microsoft_Office_2019",
            Application::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Microsoft_Office_2016", "Microsoft_Office_2019"]
    }
}
impl AsRef<str> for Application {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkspaceImageIngestionProcess {
    #[allow(missing_docs)] // documentation missing in model
    ByolGraphics,
    #[allow(missing_docs)] // documentation missing in model
    ByolGraphicspro,
    #[allow(missing_docs)] // documentation missing in model
    ByolRegular,
    #[allow(missing_docs)] // documentation missing in model
    ByolRegularWsp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkspaceImageIngestionProcess {
    fn from(s: &str) -> Self {
        match s {
            "BYOL_GRAPHICS" => WorkspaceImageIngestionProcess::ByolGraphics,
            "BYOL_GRAPHICSPRO" => WorkspaceImageIngestionProcess::ByolGraphicspro,
            "BYOL_REGULAR" => WorkspaceImageIngestionProcess::ByolRegular,
            "BYOL_REGULAR_WSP" => WorkspaceImageIngestionProcess::ByolRegularWsp,
            other => WorkspaceImageIngestionProcess::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkspaceImageIngestionProcess {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkspaceImageIngestionProcess::from(s))
    }
}
impl WorkspaceImageIngestionProcess {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkspaceImageIngestionProcess::ByolGraphics => "BYOL_GRAPHICS",
            WorkspaceImageIngestionProcess::ByolGraphicspro => "BYOL_GRAPHICSPRO",
            WorkspaceImageIngestionProcess::ByolRegular => "BYOL_REGULAR",
            WorkspaceImageIngestionProcess::ByolRegularWsp => "BYOL_REGULAR_WSP",
            WorkspaceImageIngestionProcess::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BYOL_GRAPHICS",
            "BYOL_GRAPHICSPRO",
            "BYOL_REGULAR",
            "BYOL_REGULAR_WSP",
        ]
    }
}
impl AsRef<str> for WorkspaceImageIngestionProcess {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Snapshot {
    /// <p>The time when the snapshot was created.</p>
    pub snapshot_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Snapshot {
    /// <p>The time when the snapshot was created.</p>
    pub fn snapshot_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.snapshot_time.as_ref()
    }
}
impl std::fmt::Debug for Snapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Snapshot");
        formatter.field("snapshot_time", &self.snapshot_time);
        formatter.finish()
    }
}
/// See [`Snapshot`](crate::model::Snapshot)
pub mod snapshot {
    /// A builder for [`Snapshot`](crate::model::Snapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The time when the snapshot was created.</p>
        pub fn snapshot_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.snapshot_time = Some(input);
            self
        }
        /// <p>The time when the snapshot was created.</p>
        pub fn set_snapshot_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.snapshot_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Snapshot`](crate::model::Snapshot)
        pub fn build(self) -> crate::model::Snapshot {
            crate::model::Snapshot {
                snapshot_time: self.snapshot_time,
            }
        }
    }
}
impl Snapshot {
    /// Creates a new builder-style object to manufacture [`Snapshot`](crate::model::Snapshot)
    pub fn builder() -> crate::model::snapshot::Builder {
        crate::model::snapshot::Builder::default()
    }
}

/// <p>Describes the connection status of a WorkSpace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceConnectionStatus {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The connection state of the WorkSpace. The connection state is unknown if the WorkSpace
    /// is stopped.</p>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The timestamp of the connection status check.</p>
    pub connection_state_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp of the last known user connection.</p>
    pub last_known_user_connection_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl WorkspaceConnectionStatus {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The connection state of the WorkSpace. The connection state is unknown if the WorkSpace
    /// is stopped.</p>
    pub fn connection_state(&self) -> std::option::Option<&crate::model::ConnectionState> {
        self.connection_state.as_ref()
    }
    /// <p>The timestamp of the connection status check.</p>
    pub fn connection_state_check_timestamp(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.connection_state_check_timestamp.as_ref()
    }
    /// <p>The timestamp of the last known user connection.</p>
    pub fn last_known_user_connection_timestamp(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_known_user_connection_timestamp.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceConnectionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceConnectionStatus");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("connection_state", &self.connection_state);
        formatter.field(
            "connection_state_check_timestamp",
            &self.connection_state_check_timestamp,
        );
        formatter.field(
            "last_known_user_connection_timestamp",
            &self.last_known_user_connection_timestamp,
        );
        formatter.finish()
    }
}
/// See [`WorkspaceConnectionStatus`](crate::model::WorkspaceConnectionStatus)
pub mod workspace_connection_status {
    /// A builder for [`WorkspaceConnectionStatus`](crate::model::WorkspaceConnectionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) connection_state_check_timestamp:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_known_user_connection_timestamp:
            std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The connection state of the WorkSpace. The connection state is unknown if the WorkSpace
        /// is stopped.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The connection state of the WorkSpace. The connection state is unknown if the WorkSpace
        /// is stopped.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The timestamp of the connection status check.</p>
        pub fn connection_state_check_timestamp(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.connection_state_check_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of the connection status check.</p>
        pub fn set_connection_state_check_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.connection_state_check_timestamp = input;
            self
        }
        /// <p>The timestamp of the last known user connection.</p>
        pub fn last_known_user_connection_timestamp(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.last_known_user_connection_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of the last known user connection.</p>
        pub fn set_last_known_user_connection_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_known_user_connection_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceConnectionStatus`](crate::model::WorkspaceConnectionStatus)
        pub fn build(self) -> crate::model::WorkspaceConnectionStatus {
            crate::model::WorkspaceConnectionStatus {
                workspace_id: self.workspace_id,
                connection_state: self.connection_state,
                connection_state_check_timestamp: self.connection_state_check_timestamp,
                last_known_user_connection_timestamp: self.last_known_user_connection_timestamp,
            }
        }
    }
}
impl WorkspaceConnectionStatus {
    /// Creates a new builder-style object to manufacture [`WorkspaceConnectionStatus`](crate::model::WorkspaceConnectionStatus)
    pub fn builder() -> crate::model::workspace_connection_status::Builder {
        crate::model::workspace_connection_status::Builder::default()
    }
}

/// _Note: `ConnectionState::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionState {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    Disconnected,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionState {
    fn from(s: &str) -> Self {
        match s {
            "CONNECTED" => ConnectionState::Connected,
            "DISCONNECTED" => ConnectionState::Disconnected,
            "UNKNOWN" => ConnectionState::UnknownValue,
            other => ConnectionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionState::from(s))
    }
}
impl ConnectionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionState::Connected => "CONNECTED",
            ConnectionState::Disconnected => "DISCONNECTED",
            ConnectionState::UnknownValue => "UNKNOWN",
            ConnectionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECTED", "DISCONNECTED", "UNKNOWN"]
    }
}
impl AsRef<str> for ConnectionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a WorkSpace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Workspace {
    /// <p>The identifier of the WorkSpace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the Directory Service directory for the WorkSpace.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The user for the WorkSpace.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The IP address of the WorkSpace.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The operational state of the WorkSpace.</p>
    ///
    /// <note>
    /// <p>After a WorkSpace is terminated, the <code>TERMINATED</code> state is returned
    /// only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely
    /// returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html">
    /// DescribeWorkSpaces</a>. If the WorkSpace ID isn't returned, then the WorkSpace has
    /// been successfully terminated.</p>
    /// </note>
    pub state: std::option::Option<crate::model::WorkspaceState>,
    /// <p>The identifier of the bundle used to create the WorkSpace.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the subnet for the WorkSpace.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The text of the error message that is returned if the WorkSpace cannot be
    /// created.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The error code that is returned if the WorkSpace cannot be created.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The name of the WorkSpace, as seen by the operating system. The format of this name varies.
    /// For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/launch-workspaces-tutorials.html">
    /// Launch a WorkSpace</a>. </p>
    pub computer_name: std::option::Option<std::string::String>,
    /// <p>The symmetric KMS key used to encrypt data stored on your WorkSpace.
    /// Amazon WorkSpaces does not support asymmetric KMS keys.</p>
    pub volume_encryption_key: std::option::Option<std::string::String>,
    /// <p>Indicates whether the data stored on the user volume is encrypted.</p>
    pub user_volume_encryption_enabled: std::option::Option<bool>,
    /// <p>Indicates whether the data stored on the root volume is encrypted.</p>
    pub root_volume_encryption_enabled: std::option::Option<bool>,
    /// <p>The properties of the WorkSpace.</p>
    pub workspace_properties: std::option::Option<crate::model::WorkspaceProperties>,
    /// <p>The modification states of the WorkSpace.</p>
    pub modification_states: std::option::Option<std::vec::Vec<crate::model::ModificationState>>,
}
impl Workspace {
    /// <p>The identifier of the WorkSpace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The identifier of the Directory Service directory for the WorkSpace.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The user for the WorkSpace.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The IP address of the WorkSpace.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The operational state of the WorkSpace.</p>
    ///
    /// <note>
    /// <p>After a WorkSpace is terminated, the <code>TERMINATED</code> state is returned
    /// only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely
    /// returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html">
    /// DescribeWorkSpaces</a>. If the WorkSpace ID isn't returned, then the WorkSpace has
    /// been successfully terminated.</p>
    /// </note>
    pub fn state(&self) -> std::option::Option<&crate::model::WorkspaceState> {
        self.state.as_ref()
    }
    /// <p>The identifier of the bundle used to create the WorkSpace.</p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
    /// <p>The identifier of the subnet for the WorkSpace.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The text of the error message that is returned if the WorkSpace cannot be
    /// created.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The error code that is returned if the WorkSpace cannot be created.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The name of the WorkSpace, as seen by the operating system. The format of this name varies.
    /// For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/launch-workspaces-tutorials.html">
    /// Launch a WorkSpace</a>. </p>
    pub fn computer_name(&self) -> std::option::Option<&str> {
        self.computer_name.as_deref()
    }
    /// <p>The symmetric KMS key used to encrypt data stored on your WorkSpace.
    /// Amazon WorkSpaces does not support asymmetric KMS keys.</p>
    pub fn volume_encryption_key(&self) -> std::option::Option<&str> {
        self.volume_encryption_key.as_deref()
    }
    /// <p>Indicates whether the data stored on the user volume is encrypted.</p>
    pub fn user_volume_encryption_enabled(&self) -> std::option::Option<bool> {
        self.user_volume_encryption_enabled
    }
    /// <p>Indicates whether the data stored on the root volume is encrypted.</p>
    pub fn root_volume_encryption_enabled(&self) -> std::option::Option<bool> {
        self.root_volume_encryption_enabled
    }
    /// <p>The properties of the WorkSpace.</p>
    pub fn workspace_properties(&self) -> std::option::Option<&crate::model::WorkspaceProperties> {
        self.workspace_properties.as_ref()
    }
    /// <p>The modification states of the WorkSpace.</p>
    pub fn modification_states(&self) -> std::option::Option<&[crate::model::ModificationState]> {
        self.modification_states.as_deref()
    }
}
impl std::fmt::Debug for Workspace {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Workspace");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("directory_id", &self.directory_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("state", &self.state);
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("error_message", &self.error_message);
        formatter.field("error_code", &self.error_code);
        formatter.field("computer_name", &self.computer_name);
        formatter.field("volume_encryption_key", &self.volume_encryption_key);
        formatter.field(
            "user_volume_encryption_enabled",
            &self.user_volume_encryption_enabled,
        );
        formatter.field(
            "root_volume_encryption_enabled",
            &self.root_volume_encryption_enabled,
        );
        formatter.field("workspace_properties", &self.workspace_properties);
        formatter.field("modification_states", &self.modification_states);
        formatter.finish()
    }
}
/// See [`Workspace`](crate::model::Workspace)
pub mod workspace {
    /// A builder for [`Workspace`](crate::model::Workspace)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::WorkspaceState>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) computer_name: std::option::Option<std::string::String>,
        pub(crate) volume_encryption_key: std::option::Option<std::string::String>,
        pub(crate) user_volume_encryption_enabled: std::option::Option<bool>,
        pub(crate) root_volume_encryption_enabled: std::option::Option<bool>,
        pub(crate) workspace_properties: std::option::Option<crate::model::WorkspaceProperties>,
        pub(crate) modification_states:
            std::option::Option<std::vec::Vec<crate::model::ModificationState>>,
    }
    impl Builder {
        /// <p>The identifier of the WorkSpace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The identifier of the WorkSpace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The identifier of the Directory Service directory for the WorkSpace.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Directory Service directory for the WorkSpace.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The user for the WorkSpace.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user for the WorkSpace.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The IP address of the WorkSpace.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address of the WorkSpace.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The operational state of the WorkSpace.</p>
        ///
        /// <note>
        /// <p>After a WorkSpace is terminated, the <code>TERMINATED</code> state is returned
        /// only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely
        /// returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html">
        /// DescribeWorkSpaces</a>. If the WorkSpace ID isn't returned, then the WorkSpace has
        /// been successfully terminated.</p>
        /// </note>
        pub fn state(mut self, input: crate::model::WorkspaceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The operational state of the WorkSpace.</p>
        ///
        /// <note>
        /// <p>After a WorkSpace is terminated, the <code>TERMINATED</code> state is returned
        /// only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely
        /// returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html">
        /// DescribeWorkSpaces</a>. If the WorkSpace ID isn't returned, then the WorkSpace has
        /// been successfully terminated.</p>
        /// </note>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::WorkspaceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The identifier of the bundle used to create the WorkSpace.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bundle used to create the WorkSpace.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The identifier of the subnet for the WorkSpace.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The identifier of the subnet for the WorkSpace.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The text of the error message that is returned if the WorkSpace cannot be
        /// created.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The text of the error message that is returned if the WorkSpace cannot be
        /// created.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The error code that is returned if the WorkSpace cannot be created.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that is returned if the WorkSpace cannot be created.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The name of the WorkSpace, as seen by the operating system. The format of this name varies.
        /// For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/launch-workspaces-tutorials.html">
        /// Launch a WorkSpace</a>. </p>
        pub fn computer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.computer_name = Some(input.into());
            self
        }
        /// <p>The name of the WorkSpace, as seen by the operating system. The format of this name varies.
        /// For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/launch-workspaces-tutorials.html">
        /// Launch a WorkSpace</a>. </p>
        pub fn set_computer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.computer_name = input;
            self
        }
        /// <p>The symmetric KMS key used to encrypt data stored on your WorkSpace.
        /// Amazon WorkSpaces does not support asymmetric KMS keys.</p>
        pub fn volume_encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_encryption_key = Some(input.into());
            self
        }
        /// <p>The symmetric KMS key used to encrypt data stored on your WorkSpace.
        /// Amazon WorkSpaces does not support asymmetric KMS keys.</p>
        pub fn set_volume_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_encryption_key = input;
            self
        }
        /// <p>Indicates whether the data stored on the user volume is encrypted.</p>
        pub fn user_volume_encryption_enabled(mut self, input: bool) -> Self {
            self.user_volume_encryption_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the data stored on the user volume is encrypted.</p>
        pub fn set_user_volume_encryption_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.user_volume_encryption_enabled = input;
            self
        }
        /// <p>Indicates whether the data stored on the root volume is encrypted.</p>
        pub fn root_volume_encryption_enabled(mut self, input: bool) -> Self {
            self.root_volume_encryption_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the data stored on the root volume is encrypted.</p>
        pub fn set_root_volume_encryption_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.root_volume_encryption_enabled = input;
            self
        }
        /// <p>The properties of the WorkSpace.</p>
        pub fn workspace_properties(mut self, input: crate::model::WorkspaceProperties) -> Self {
            self.workspace_properties = Some(input);
            self
        }
        /// <p>The properties of the WorkSpace.</p>
        pub fn set_workspace_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceProperties>,
        ) -> Self {
            self.workspace_properties = input;
            self
        }
        /// Appends an item to `modification_states`.
        ///
        /// To override the contents of this collection use [`set_modification_states`](Self::set_modification_states).
        ///
        /// <p>The modification states of the WorkSpace.</p>
        pub fn modification_states(
            mut self,
            input: impl Into<crate::model::ModificationState>,
        ) -> Self {
            let mut v = self.modification_states.unwrap_or_default();
            v.push(input.into());
            self.modification_states = Some(v);
            self
        }
        /// <p>The modification states of the WorkSpace.</p>
        pub fn set_modification_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModificationState>>,
        ) -> Self {
            self.modification_states = input;
            self
        }
        /// Consumes the builder and constructs a [`Workspace`](crate::model::Workspace)
        pub fn build(self) -> crate::model::Workspace {
            crate::model::Workspace {
                workspace_id: self.workspace_id,
                directory_id: self.directory_id,
                user_name: self.user_name,
                ip_address: self.ip_address,
                state: self.state,
                bundle_id: self.bundle_id,
                subnet_id: self.subnet_id,
                error_message: self.error_message,
                error_code: self.error_code,
                computer_name: self.computer_name,
                volume_encryption_key: self.volume_encryption_key,
                user_volume_encryption_enabled: self.user_volume_encryption_enabled,
                root_volume_encryption_enabled: self.root_volume_encryption_enabled,
                workspace_properties: self.workspace_properties,
                modification_states: self.modification_states,
            }
        }
    }
}
impl Workspace {
    /// Creates a new builder-style object to manufacture [`Workspace`](crate::model::Workspace)
    pub fn builder() -> crate::model::workspace::Builder {
        crate::model::workspace::Builder::default()
    }
}

/// <p>Describes a WorkSpace modification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModificationState {
    /// <p>The resource.</p>
    pub resource: std::option::Option<crate::model::ModificationResourceEnum>,
    /// <p>The modification state.</p>
    pub state: std::option::Option<crate::model::ModificationStateEnum>,
}
impl ModificationState {
    /// <p>The resource.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::ModificationResourceEnum> {
        self.resource.as_ref()
    }
    /// <p>The modification state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ModificationStateEnum> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for ModificationState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModificationState");
        formatter.field("resource", &self.resource);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`ModificationState`](crate::model::ModificationState)
pub mod modification_state {
    /// A builder for [`ModificationState`](crate::model::ModificationState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<crate::model::ModificationResourceEnum>,
        pub(crate) state: std::option::Option<crate::model::ModificationStateEnum>,
    }
    impl Builder {
        /// <p>The resource.</p>
        pub fn resource(mut self, input: crate::model::ModificationResourceEnum) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The resource.</p>
        pub fn set_resource(
            mut self,
            input: std::option::Option<crate::model::ModificationResourceEnum>,
        ) -> Self {
            self.resource = input;
            self
        }
        /// <p>The modification state.</p>
        pub fn state(mut self, input: crate::model::ModificationStateEnum) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The modification state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ModificationStateEnum>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`ModificationState`](crate::model::ModificationState)
        pub fn build(self) -> crate::model::ModificationState {
            crate::model::ModificationState {
                resource: self.resource,
                state: self.state,
            }
        }
    }
}
impl ModificationState {
    /// Creates a new builder-style object to manufacture [`ModificationState`](crate::model::ModificationState)
    pub fn builder() -> crate::model::modification_state::Builder {
        crate::model::modification_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModificationStateEnum {
    #[allow(missing_docs)] // documentation missing in model
    UpdateInitiated,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModificationStateEnum {
    fn from(s: &str) -> Self {
        match s {
            "UPDATE_INITIATED" => ModificationStateEnum::UpdateInitiated,
            "UPDATE_IN_PROGRESS" => ModificationStateEnum::UpdateInProgress,
            other => ModificationStateEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModificationStateEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModificationStateEnum::from(s))
    }
}
impl ModificationStateEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModificationStateEnum::UpdateInitiated => "UPDATE_INITIATED",
            ModificationStateEnum::UpdateInProgress => "UPDATE_IN_PROGRESS",
            ModificationStateEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["UPDATE_INITIATED", "UPDATE_IN_PROGRESS"]
    }
}
impl AsRef<str> for ModificationStateEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModificationResourceEnum {
    #[allow(missing_docs)] // documentation missing in model
    ComputeType,
    #[allow(missing_docs)] // documentation missing in model
    RootVolume,
    #[allow(missing_docs)] // documentation missing in model
    UserVolume,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModificationResourceEnum {
    fn from(s: &str) -> Self {
        match s {
            "COMPUTE_TYPE" => ModificationResourceEnum::ComputeType,
            "ROOT_VOLUME" => ModificationResourceEnum::RootVolume,
            "USER_VOLUME" => ModificationResourceEnum::UserVolume,
            other => ModificationResourceEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModificationResourceEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModificationResourceEnum::from(s))
    }
}
impl ModificationResourceEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModificationResourceEnum::ComputeType => "COMPUTE_TYPE",
            ModificationResourceEnum::RootVolume => "ROOT_VOLUME",
            ModificationResourceEnum::UserVolume => "USER_VOLUME",
            ModificationResourceEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPUTE_TYPE", "ROOT_VOLUME", "USER_VOLUME"]
    }
}
impl AsRef<str> for ModificationResourceEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkspaceState {
    #[allow(missing_docs)] // documentation missing in model
    AdminMaintenance,
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Impaired,
    #[allow(missing_docs)] // documentation missing in model
    Maintenance,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Rebooting,
    #[allow(missing_docs)] // documentation missing in model
    Rebuilding,
    #[allow(missing_docs)] // documentation missing in model
    Restoring,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkspaceState {
    fn from(s: &str) -> Self {
        match s {
            "ADMIN_MAINTENANCE" => WorkspaceState::AdminMaintenance,
            "AVAILABLE" => WorkspaceState::Available,
            "ERROR" => WorkspaceState::Error,
            "IMPAIRED" => WorkspaceState::Impaired,
            "MAINTENANCE" => WorkspaceState::Maintenance,
            "PENDING" => WorkspaceState::Pending,
            "REBOOTING" => WorkspaceState::Rebooting,
            "REBUILDING" => WorkspaceState::Rebuilding,
            "RESTORING" => WorkspaceState::Restoring,
            "STARTING" => WorkspaceState::Starting,
            "STOPPED" => WorkspaceState::Stopped,
            "STOPPING" => WorkspaceState::Stopping,
            "SUSPENDED" => WorkspaceState::Suspended,
            "TERMINATED" => WorkspaceState::Terminated,
            "TERMINATING" => WorkspaceState::Terminating,
            "UNHEALTHY" => WorkspaceState::Unhealthy,
            "UPDATING" => WorkspaceState::Updating,
            other => WorkspaceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkspaceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkspaceState::from(s))
    }
}
impl WorkspaceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkspaceState::AdminMaintenance => "ADMIN_MAINTENANCE",
            WorkspaceState::Available => "AVAILABLE",
            WorkspaceState::Error => "ERROR",
            WorkspaceState::Impaired => "IMPAIRED",
            WorkspaceState::Maintenance => "MAINTENANCE",
            WorkspaceState::Pending => "PENDING",
            WorkspaceState::Rebooting => "REBOOTING",
            WorkspaceState::Rebuilding => "REBUILDING",
            WorkspaceState::Restoring => "RESTORING",
            WorkspaceState::Starting => "STARTING",
            WorkspaceState::Stopped => "STOPPED",
            WorkspaceState::Stopping => "STOPPING",
            WorkspaceState::Suspended => "SUSPENDED",
            WorkspaceState::Terminated => "TERMINATED",
            WorkspaceState::Terminating => "TERMINATING",
            WorkspaceState::Unhealthy => "UNHEALTHY",
            WorkspaceState::Updating => "UPDATING",
            WorkspaceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADMIN_MAINTENANCE",
            "AVAILABLE",
            "ERROR",
            "IMPAIRED",
            "MAINTENANCE",
            "PENDING",
            "REBOOTING",
            "REBUILDING",
            "RESTORING",
            "STARTING",
            "STOPPED",
            "STOPPING",
            "SUSPENDED",
            "TERMINATED",
            "TERMINATING",
            "UNHEALTHY",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for WorkspaceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a WorkSpace image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceImage {
    /// <p>The identifier of the image.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The name of the image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the image.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The operating system that the image is running. </p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
    /// <p>The status of the image.</p>
    pub state: std::option::Option<crate::model::WorkspaceImageState>,
    /// <p>Specifies whether the image is running on dedicated hardware. When Bring Your Own
    /// License (BYOL) is enabled, this value is set to <code>DEDICATED</code>. For more
    /// information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows
    /// Desktop Images</a>.</p>
    pub required_tenancy: std::option::Option<crate::model::WorkspaceImageRequiredTenancy>,
    /// <p>The error code that is returned for the image.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The text of the error message that is returned for the image.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The date when the image was created. If the image has been shared, the Amazon Web Services account
    /// that the image has been shared with sees the original creation date of the image.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier of the Amazon Web Services account that owns the image.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The updates (if any) that are available for the specified image.</p>
    pub updates: std::option::Option<crate::model::UpdateResult>,
}
impl WorkspaceImage {
    /// <p>The identifier of the image.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The name of the image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the image.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The operating system that the image is running. </p>
    pub fn operating_system(&self) -> std::option::Option<&crate::model::OperatingSystem> {
        self.operating_system.as_ref()
    }
    /// <p>The status of the image.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::WorkspaceImageState> {
        self.state.as_ref()
    }
    /// <p>Specifies whether the image is running on dedicated hardware. When Bring Your Own
    /// License (BYOL) is enabled, this value is set to <code>DEDICATED</code>. For more
    /// information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows
    /// Desktop Images</a>.</p>
    pub fn required_tenancy(
        &self,
    ) -> std::option::Option<&crate::model::WorkspaceImageRequiredTenancy> {
        self.required_tenancy.as_ref()
    }
    /// <p>The error code that is returned for the image.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The text of the error message that is returned for the image.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The date when the image was created. If the image has been shared, the Amazon Web Services account
    /// that the image has been shared with sees the original creation date of the image.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The identifier of the Amazon Web Services account that owns the image.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The updates (if any) that are available for the specified image.</p>
    pub fn updates(&self) -> std::option::Option<&crate::model::UpdateResult> {
        self.updates.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceImage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceImage");
        formatter.field("image_id", &self.image_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("operating_system", &self.operating_system);
        formatter.field("state", &self.state);
        formatter.field("required_tenancy", &self.required_tenancy);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("created", &self.created);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("updates", &self.updates);
        formatter.finish()
    }
}
/// See [`WorkspaceImage`](crate::model::WorkspaceImage)
pub mod workspace_image {
    /// A builder for [`WorkspaceImage`](crate::model::WorkspaceImage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) state: std::option::Option<crate::model::WorkspaceImageState>,
        pub(crate) required_tenancy:
            std::option::Option<crate::model::WorkspaceImageRequiredTenancy>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) updates: std::option::Option<crate::model::UpdateResult>,
    }
    impl Builder {
        /// <p>The identifier of the image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The name of the image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The operating system that the image is running. </p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>The operating system that the image is running. </p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>The status of the image.</p>
        pub fn state(mut self, input: crate::model::WorkspaceImageState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The status of the image.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::WorkspaceImageState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>Specifies whether the image is running on dedicated hardware. When Bring Your Own
        /// License (BYOL) is enabled, this value is set to <code>DEDICATED</code>. For more
        /// information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows
        /// Desktop Images</a>.</p>
        pub fn required_tenancy(
            mut self,
            input: crate::model::WorkspaceImageRequiredTenancy,
        ) -> Self {
            self.required_tenancy = Some(input);
            self
        }
        /// <p>Specifies whether the image is running on dedicated hardware. When Bring Your Own
        /// License (BYOL) is enabled, this value is set to <code>DEDICATED</code>. For more
        /// information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows
        /// Desktop Images</a>.</p>
        pub fn set_required_tenancy(
            mut self,
            input: std::option::Option<crate::model::WorkspaceImageRequiredTenancy>,
        ) -> Self {
            self.required_tenancy = input;
            self
        }
        /// <p>The error code that is returned for the image.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that is returned for the image.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The text of the error message that is returned for the image.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The text of the error message that is returned for the image.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The date when the image was created. If the image has been shared, the Amazon Web Services account
        /// that the image has been shared with sees the original creation date of the image.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date when the image was created. If the image has been shared, the Amazon Web Services account
        /// that the image has been shared with sees the original creation date of the image.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The identifier of the Amazon Web Services account that owns the image.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account that owns the image.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The updates (if any) that are available for the specified image.</p>
        pub fn updates(mut self, input: crate::model::UpdateResult) -> Self {
            self.updates = Some(input);
            self
        }
        /// <p>The updates (if any) that are available for the specified image.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<crate::model::UpdateResult>,
        ) -> Self {
            self.updates = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceImage`](crate::model::WorkspaceImage)
        pub fn build(self) -> crate::model::WorkspaceImage {
            crate::model::WorkspaceImage {
                image_id: self.image_id,
                name: self.name,
                description: self.description,
                operating_system: self.operating_system,
                state: self.state,
                required_tenancy: self.required_tenancy,
                error_code: self.error_code,
                error_message: self.error_message,
                created: self.created,
                owner_account_id: self.owner_account_id,
                updates: self.updates,
            }
        }
    }
}
impl WorkspaceImage {
    /// Creates a new builder-style object to manufacture [`WorkspaceImage`](crate::model::WorkspaceImage)
    pub fn builder() -> crate::model::workspace_image::Builder {
        crate::model::workspace_image::Builder::default()
    }
}

/// <p>Describes whether a WorkSpace image needs to be updated with the latest
/// drivers and other components required by Amazon WorkSpaces.</p>
///
/// <note>
/// <p>Only Windows 10 WorkSpace images can be programmatically updated at this time.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResult {
    /// <p>Indicates whether updated drivers or other components are available for the specified WorkSpace image.</p>
    pub update_available: std::option::Option<bool>,
    /// <p>A description of whether updates for the WorkSpace image are pending or available.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateResult {
    /// <p>Indicates whether updated drivers or other components are available for the specified WorkSpace image.</p>
    pub fn update_available(&self) -> std::option::Option<bool> {
        self.update_available
    }
    /// <p>A description of whether updates for the WorkSpace image are pending or available.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResult");
        formatter.field("update_available", &self.update_available);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`UpdateResult`](crate::model::UpdateResult)
pub mod update_result {
    /// A builder for [`UpdateResult`](crate::model::UpdateResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_available: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether updated drivers or other components are available for the specified WorkSpace image.</p>
        pub fn update_available(mut self, input: bool) -> Self {
            self.update_available = Some(input);
            self
        }
        /// <p>Indicates whether updated drivers or other components are available for the specified WorkSpace image.</p>
        pub fn set_update_available(mut self, input: std::option::Option<bool>) -> Self {
            self.update_available = input;
            self
        }
        /// <p>A description of whether updates for the WorkSpace image are pending or available.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of whether updates for the WorkSpace image are pending or available.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResult`](crate::model::UpdateResult)
        pub fn build(self) -> crate::model::UpdateResult {
            crate::model::UpdateResult {
                update_available: self.update_available,
                description: self.description,
            }
        }
    }
}
impl UpdateResult {
    /// Creates a new builder-style object to manufacture [`UpdateResult`](crate::model::UpdateResult)
    pub fn builder() -> crate::model::update_result::Builder {
        crate::model::update_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkspaceImageRequiredTenancy {
    #[allow(missing_docs)] // documentation missing in model
    Dedicated,
    #[allow(missing_docs)] // documentation missing in model
    Default,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkspaceImageRequiredTenancy {
    fn from(s: &str) -> Self {
        match s {
            "DEDICATED" => WorkspaceImageRequiredTenancy::Dedicated,
            "DEFAULT" => WorkspaceImageRequiredTenancy::Default,
            other => WorkspaceImageRequiredTenancy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkspaceImageRequiredTenancy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkspaceImageRequiredTenancy::from(s))
    }
}
impl WorkspaceImageRequiredTenancy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkspaceImageRequiredTenancy::Dedicated => "DEDICATED",
            WorkspaceImageRequiredTenancy::Default => "DEFAULT",
            WorkspaceImageRequiredTenancy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEDICATED", "DEFAULT"]
    }
}
impl AsRef<str> for WorkspaceImageRequiredTenancy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkspaceImageState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkspaceImageState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => WorkspaceImageState::Available,
            "ERROR" => WorkspaceImageState::Error,
            "PENDING" => WorkspaceImageState::Pending,
            other => WorkspaceImageState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkspaceImageState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkspaceImageState::from(s))
    }
}
impl WorkspaceImageState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkspaceImageState::Available => "AVAILABLE",
            WorkspaceImageState::Error => "ERROR",
            WorkspaceImageState::Pending => "PENDING",
            WorkspaceImageState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "ERROR", "PENDING"]
    }
}
impl AsRef<str> for WorkspaceImageState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The operating system that the image is running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperatingSystem {
    /// <p>The operating system.</p>
    pub r#type: std::option::Option<crate::model::OperatingSystemType>,
}
impl OperatingSystem {
    /// <p>The operating system.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OperatingSystemType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for OperatingSystem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperatingSystem");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`OperatingSystem`](crate::model::OperatingSystem)
pub mod operating_system {
    /// A builder for [`OperatingSystem`](crate::model::OperatingSystem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::OperatingSystemType>,
    }
    impl Builder {
        /// <p>The operating system.</p>
        pub fn r#type(mut self, input: crate::model::OperatingSystemType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The operating system.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::OperatingSystemType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`OperatingSystem`](crate::model::OperatingSystem)
        pub fn build(self) -> crate::model::OperatingSystem {
            crate::model::OperatingSystem {
                r#type: self.r#type,
            }
        }
    }
}
impl OperatingSystem {
    /// Creates a new builder-style object to manufacture [`OperatingSystem`](crate::model::OperatingSystem)
    pub fn builder() -> crate::model::operating_system::Builder {
        crate::model::operating_system::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperatingSystemType {
    #[allow(missing_docs)] // documentation missing in model
    Linux,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperatingSystemType {
    fn from(s: &str) -> Self {
        match s {
            "LINUX" => OperatingSystemType::Linux,
            "WINDOWS" => OperatingSystemType::Windows,
            other => OperatingSystemType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperatingSystemType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperatingSystemType::from(s))
    }
}
impl OperatingSystemType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperatingSystemType::Linux => "LINUX",
            OperatingSystemType::Windows => "WINDOWS",
            OperatingSystemType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINUX", "WINDOWS"]
    }
}
impl AsRef<str> for OperatingSystemType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageType {
    #[allow(missing_docs)] // documentation missing in model
    Owned,
    #[allow(missing_docs)] // documentation missing in model
    Shared,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageType {
    fn from(s: &str) -> Self {
        match s {
            "OWNED" => ImageType::Owned,
            "SHARED" => ImageType::Shared,
            other => ImageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageType::from(s))
    }
}
impl ImageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageType::Owned => "OWNED",
            ImageType::Shared => "SHARED",
            ImageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OWNED", "SHARED"]
    }
}
impl AsRef<str> for ImageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the Amazon Web Services accounts that have been granted permission to use a shared image.
/// For more information about sharing images, see
/// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html">
/// Share or Unshare a Custom WorkSpaces Image</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImagePermission {
    /// <p>The identifier of the Amazon Web Services account that an image has been shared with.</p>
    pub shared_account_id: std::option::Option<std::string::String>,
}
impl ImagePermission {
    /// <p>The identifier of the Amazon Web Services account that an image has been shared with.</p>
    pub fn shared_account_id(&self) -> std::option::Option<&str> {
        self.shared_account_id.as_deref()
    }
}
impl std::fmt::Debug for ImagePermission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImagePermission");
        formatter.field("shared_account_id", &self.shared_account_id);
        formatter.finish()
    }
}
/// See [`ImagePermission`](crate::model::ImagePermission)
pub mod image_permission {
    /// A builder for [`ImagePermission`](crate::model::ImagePermission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shared_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Web Services account that an image has been shared with.</p>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account that an image has been shared with.</p>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ImagePermission`](crate::model::ImagePermission)
        pub fn build(self) -> crate::model::ImagePermission {
            crate::model::ImagePermission {
                shared_account_id: self.shared_account_id,
            }
        }
    }
}
impl ImagePermission {
    /// Creates a new builder-style object to manufacture [`ImagePermission`](crate::model::ImagePermission)
    pub fn builder() -> crate::model::image_permission::Builder {
        crate::model::image_permission::Builder::default()
    }
}

/// <p>Describes a directory that is used with Amazon WorkSpaces.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceDirectory {
    /// <p>The directory identifier.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The directory alias.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The name of the directory.</p>
    pub directory_name: std::option::Option<std::string::String>,
    /// <p>The registration code for the directory. This is the code that users enter in their
    /// Amazon WorkSpaces client application to connect to the directory.</p>
    pub registration_code: std::option::Option<std::string::String>,
    /// <p>The identifiers of the subnets used with the directory.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IP addresses of the DNS servers for the directory.</p>
    pub dns_ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user name for the service account.</p>
    pub customer_user_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make
    /// calls to other services, such as Amazon EC2, on your behalf.</p>
    pub iam_role_id: std::option::Option<std::string::String>,
    /// <p>The directory type.</p>
    pub directory_type: std::option::Option<crate::model::WorkspaceDirectoryType>,
    /// <p>The identifier of the security group that is assigned to new WorkSpaces.</p>
    pub workspace_security_group_id: std::option::Option<std::string::String>,
    /// <p>The state of the directory's registration with Amazon WorkSpaces. After a directory is
    /// deregistered, the <code>DEREGISTERED</code> state is returned very briefly before the directory
    /// metadata is cleaned up, so this state is rarely returned. To confirm that a directory is deregistered,
    /// check for the directory ID by using
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
    /// DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been
    /// successfully deregistered.</p>
    pub state: std::option::Option<crate::model::WorkspaceDirectoryState>,
    /// <p>The default creation properties for all WorkSpaces in the directory.</p>
    pub workspace_creation_properties:
        std::option::Option<crate::model::DefaultWorkspaceCreationProperties>,
    /// <p>The identifiers of the IP access control groups associated with the directory.</p>
    pub ip_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The devices and operating systems that users can use to access WorkSpaces.</p>
    pub workspace_access_properties: std::option::Option<crate::model::WorkspaceAccessProperties>,
    /// <p>Specifies whether the directory is dedicated or shared. To use Bring Your Own License
    /// (BYOL), this value must be set to <code>DEDICATED</code>. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring
    /// Your Own Windows Desktop Images</a>.</p>
    pub tenancy: std::option::Option<crate::model::Tenancy>,
    /// <p>The default self-service permissions for WorkSpaces in the directory.</p>
    pub selfservice_permissions: std::option::Option<crate::model::SelfservicePermissions>,
}
impl WorkspaceDirectory {
    /// <p>The directory identifier.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The directory alias.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The name of the directory.</p>
    pub fn directory_name(&self) -> std::option::Option<&str> {
        self.directory_name.as_deref()
    }
    /// <p>The registration code for the directory. This is the code that users enter in their
    /// Amazon WorkSpaces client application to connect to the directory.</p>
    pub fn registration_code(&self) -> std::option::Option<&str> {
        self.registration_code.as_deref()
    }
    /// <p>The identifiers of the subnets used with the directory.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The IP addresses of the DNS servers for the directory.</p>
    pub fn dns_ip_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.dns_ip_addresses.as_deref()
    }
    /// <p>The user name for the service account.</p>
    pub fn customer_user_name(&self) -> std::option::Option<&str> {
        self.customer_user_name.as_deref()
    }
    /// <p>The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make
    /// calls to other services, such as Amazon EC2, on your behalf.</p>
    pub fn iam_role_id(&self) -> std::option::Option<&str> {
        self.iam_role_id.as_deref()
    }
    /// <p>The directory type.</p>
    pub fn directory_type(&self) -> std::option::Option<&crate::model::WorkspaceDirectoryType> {
        self.directory_type.as_ref()
    }
    /// <p>The identifier of the security group that is assigned to new WorkSpaces.</p>
    pub fn workspace_security_group_id(&self) -> std::option::Option<&str> {
        self.workspace_security_group_id.as_deref()
    }
    /// <p>The state of the directory's registration with Amazon WorkSpaces. After a directory is
    /// deregistered, the <code>DEREGISTERED</code> state is returned very briefly before the directory
    /// metadata is cleaned up, so this state is rarely returned. To confirm that a directory is deregistered,
    /// check for the directory ID by using
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
    /// DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been
    /// successfully deregistered.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::WorkspaceDirectoryState> {
        self.state.as_ref()
    }
    /// <p>The default creation properties for all WorkSpaces in the directory.</p>
    pub fn workspace_creation_properties(
        &self,
    ) -> std::option::Option<&crate::model::DefaultWorkspaceCreationProperties> {
        self.workspace_creation_properties.as_ref()
    }
    /// <p>The identifiers of the IP access control groups associated with the directory.</p>
    pub fn ip_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ip_group_ids.as_deref()
    }
    /// <p>The devices and operating systems that users can use to access WorkSpaces.</p>
    pub fn workspace_access_properties(
        &self,
    ) -> std::option::Option<&crate::model::WorkspaceAccessProperties> {
        self.workspace_access_properties.as_ref()
    }
    /// <p>Specifies whether the directory is dedicated or shared. To use Bring Your Own License
    /// (BYOL), this value must be set to <code>DEDICATED</code>. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring
    /// Your Own Windows Desktop Images</a>.</p>
    pub fn tenancy(&self) -> std::option::Option<&crate::model::Tenancy> {
        self.tenancy.as_ref()
    }
    /// <p>The default self-service permissions for WorkSpaces in the directory.</p>
    pub fn selfservice_permissions(
        &self,
    ) -> std::option::Option<&crate::model::SelfservicePermissions> {
        self.selfservice_permissions.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceDirectory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceDirectory");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("alias", &self.alias);
        formatter.field("directory_name", &self.directory_name);
        formatter.field("registration_code", &self.registration_code);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("dns_ip_addresses", &self.dns_ip_addresses);
        formatter.field("customer_user_name", &self.customer_user_name);
        formatter.field("iam_role_id", &self.iam_role_id);
        formatter.field("directory_type", &self.directory_type);
        formatter.field(
            "workspace_security_group_id",
            &self.workspace_security_group_id,
        );
        formatter.field("state", &self.state);
        formatter.field(
            "workspace_creation_properties",
            &self.workspace_creation_properties,
        );
        formatter.field("ip_group_ids", &self.ip_group_ids);
        formatter.field(
            "workspace_access_properties",
            &self.workspace_access_properties,
        );
        formatter.field("tenancy", &self.tenancy);
        formatter.field("selfservice_permissions", &self.selfservice_permissions);
        formatter.finish()
    }
}
/// See [`WorkspaceDirectory`](crate::model::WorkspaceDirectory)
pub mod workspace_directory {
    /// A builder for [`WorkspaceDirectory`](crate::model::WorkspaceDirectory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) directory_name: std::option::Option<std::string::String>,
        pub(crate) registration_code: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) dns_ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) customer_user_name: std::option::Option<std::string::String>,
        pub(crate) iam_role_id: std::option::Option<std::string::String>,
        pub(crate) directory_type: std::option::Option<crate::model::WorkspaceDirectoryType>,
        pub(crate) workspace_security_group_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::WorkspaceDirectoryState>,
        pub(crate) workspace_creation_properties:
            std::option::Option<crate::model::DefaultWorkspaceCreationProperties>,
        pub(crate) ip_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) workspace_access_properties:
            std::option::Option<crate::model::WorkspaceAccessProperties>,
        pub(crate) tenancy: std::option::Option<crate::model::Tenancy>,
        pub(crate) selfservice_permissions:
            std::option::Option<crate::model::SelfservicePermissions>,
    }
    impl Builder {
        /// <p>The directory identifier.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The directory identifier.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The directory alias.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The directory alias.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The name of the directory.</p>
        pub fn directory_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_name = Some(input.into());
            self
        }
        /// <p>The name of the directory.</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_name = input;
            self
        }
        /// <p>The registration code for the directory. This is the code that users enter in their
        /// Amazon WorkSpaces client application to connect to the directory.</p>
        pub fn registration_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.registration_code = Some(input.into());
            self
        }
        /// <p>The registration code for the directory. This is the code that users enter in their
        /// Amazon WorkSpaces client application to connect to the directory.</p>
        pub fn set_registration_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registration_code = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The identifiers of the subnets used with the directory.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The identifiers of the subnets used with the directory.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `dns_ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_dns_ip_addresses`](Self::set_dns_ip_addresses).
        ///
        /// <p>The IP addresses of the DNS servers for the directory.</p>
        pub fn dns_ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.dns_ip_addresses = Some(v);
            self
        }
        /// <p>The IP addresses of the DNS servers for the directory.</p>
        pub fn set_dns_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_ip_addresses = input;
            self
        }
        /// <p>The user name for the service account.</p>
        pub fn customer_user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_user_name = Some(input.into());
            self
        }
        /// <p>The user name for the service account.</p>
        pub fn set_customer_user_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_user_name = input;
            self
        }
        /// <p>The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make
        /// calls to other services, such as Amazon EC2, on your behalf.</p>
        pub fn iam_role_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_id = Some(input.into());
            self
        }
        /// <p>The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make
        /// calls to other services, such as Amazon EC2, on your behalf.</p>
        pub fn set_iam_role_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_id = input;
            self
        }
        /// <p>The directory type.</p>
        pub fn directory_type(mut self, input: crate::model::WorkspaceDirectoryType) -> Self {
            self.directory_type = Some(input);
            self
        }
        /// <p>The directory type.</p>
        pub fn set_directory_type(
            mut self,
            input: std::option::Option<crate::model::WorkspaceDirectoryType>,
        ) -> Self {
            self.directory_type = input;
            self
        }
        /// <p>The identifier of the security group that is assigned to new WorkSpaces.</p>
        pub fn workspace_security_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.workspace_security_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the security group that is assigned to new WorkSpaces.</p>
        pub fn set_workspace_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workspace_security_group_id = input;
            self
        }
        /// <p>The state of the directory's registration with Amazon WorkSpaces. After a directory is
        /// deregistered, the <code>DEREGISTERED</code> state is returned very briefly before the directory
        /// metadata is cleaned up, so this state is rarely returned. To confirm that a directory is deregistered,
        /// check for the directory ID by using
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
        /// DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been
        /// successfully deregistered.</p>
        pub fn state(mut self, input: crate::model::WorkspaceDirectoryState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the directory's registration with Amazon WorkSpaces. After a directory is
        /// deregistered, the <code>DEREGISTERED</code> state is returned very briefly before the directory
        /// metadata is cleaned up, so this state is rarely returned. To confirm that a directory is deregistered,
        /// check for the directory ID by using
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
        /// DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been
        /// successfully deregistered.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::WorkspaceDirectoryState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The default creation properties for all WorkSpaces in the directory.</p>
        pub fn workspace_creation_properties(
            mut self,
            input: crate::model::DefaultWorkspaceCreationProperties,
        ) -> Self {
            self.workspace_creation_properties = Some(input);
            self
        }
        /// <p>The default creation properties for all WorkSpaces in the directory.</p>
        pub fn set_workspace_creation_properties(
            mut self,
            input: std::option::Option<crate::model::DefaultWorkspaceCreationProperties>,
        ) -> Self {
            self.workspace_creation_properties = input;
            self
        }
        /// Appends an item to `ip_group_ids`.
        ///
        /// To override the contents of this collection use [`set_ip_group_ids`](Self::set_ip_group_ids).
        ///
        /// <p>The identifiers of the IP access control groups associated with the directory.</p>
        pub fn ip_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_group_ids.unwrap_or_default();
            v.push(input.into());
            self.ip_group_ids = Some(v);
            self
        }
        /// <p>The identifiers of the IP access control groups associated with the directory.</p>
        pub fn set_ip_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_group_ids = input;
            self
        }
        /// <p>The devices and operating systems that users can use to access WorkSpaces.</p>
        pub fn workspace_access_properties(
            mut self,
            input: crate::model::WorkspaceAccessProperties,
        ) -> Self {
            self.workspace_access_properties = Some(input);
            self
        }
        /// <p>The devices and operating systems that users can use to access WorkSpaces.</p>
        pub fn set_workspace_access_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceAccessProperties>,
        ) -> Self {
            self.workspace_access_properties = input;
            self
        }
        /// <p>Specifies whether the directory is dedicated or shared. To use Bring Your Own License
        /// (BYOL), this value must be set to <code>DEDICATED</code>. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring
        /// Your Own Windows Desktop Images</a>.</p>
        pub fn tenancy(mut self, input: crate::model::Tenancy) -> Self {
            self.tenancy = Some(input);
            self
        }
        /// <p>Specifies whether the directory is dedicated or shared. To use Bring Your Own License
        /// (BYOL), this value must be set to <code>DEDICATED</code>. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring
        /// Your Own Windows Desktop Images</a>.</p>
        pub fn set_tenancy(mut self, input: std::option::Option<crate::model::Tenancy>) -> Self {
            self.tenancy = input;
            self
        }
        /// <p>The default self-service permissions for WorkSpaces in the directory.</p>
        pub fn selfservice_permissions(
            mut self,
            input: crate::model::SelfservicePermissions,
        ) -> Self {
            self.selfservice_permissions = Some(input);
            self
        }
        /// <p>The default self-service permissions for WorkSpaces in the directory.</p>
        pub fn set_selfservice_permissions(
            mut self,
            input: std::option::Option<crate::model::SelfservicePermissions>,
        ) -> Self {
            self.selfservice_permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceDirectory`](crate::model::WorkspaceDirectory)
        pub fn build(self) -> crate::model::WorkspaceDirectory {
            crate::model::WorkspaceDirectory {
                directory_id: self.directory_id,
                alias: self.alias,
                directory_name: self.directory_name,
                registration_code: self.registration_code,
                subnet_ids: self.subnet_ids,
                dns_ip_addresses: self.dns_ip_addresses,
                customer_user_name: self.customer_user_name,
                iam_role_id: self.iam_role_id,
                directory_type: self.directory_type,
                workspace_security_group_id: self.workspace_security_group_id,
                state: self.state,
                workspace_creation_properties: self.workspace_creation_properties,
                ip_group_ids: self.ip_group_ids,
                workspace_access_properties: self.workspace_access_properties,
                tenancy: self.tenancy,
                selfservice_permissions: self.selfservice_permissions,
            }
        }
    }
}
impl WorkspaceDirectory {
    /// Creates a new builder-style object to manufacture [`WorkspaceDirectory`](crate::model::WorkspaceDirectory)
    pub fn builder() -> crate::model::workspace_directory::Builder {
        crate::model::workspace_directory::Builder::default()
    }
}

/// <p>Describes the default values that are used to create WorkSpaces. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html">Update Directory Details for Your WorkSpaces</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultWorkspaceCreationProperties {
    /// <p>Specifies whether the directory is enabled for Amazon WorkDocs.</p>
    pub enable_work_docs: std::option::Option<bool>,
    /// <p>Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory by default.
    /// If enabled, the Elastic public IP address allows outbound internet access from your WorkSpaces when you’re using an
    /// internet gateway in the Amazon VPC in which your WorkSpaces are located. If you're using a Network Address
    /// Translation (NAT) gateway for outbound internet access from your VPC, or if your WorkSpaces are in public
    /// subnets and you manually assign them Elastic IP addresses, you should disable this setting. This setting
    /// applies to new WorkSpaces that you launch or to existing WorkSpaces that you rebuild. For more information,
    /// see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html">
    /// Configure a VPC for Amazon WorkSpaces</a>.</p>
    pub enable_internet_access: std::option::Option<bool>,
    /// <p>The organizational unit (OU) in the directory for the WorkSpace machine accounts.</p>
    pub default_ou: std::option::Option<std::string::String>,
    /// <p>The identifier of the default security group to apply to WorkSpaces when they are created.
    /// For more information, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html">
    /// Security Groups for Your WorkSpaces</a>.</p>
    pub custom_security_group_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether WorkSpace users are local administrators on their WorkSpaces.</p>
    pub user_enabled_as_local_administrator: std::option::Option<bool>,
    /// <p>Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
    /// Maintenance</a>.</p>
    pub enable_maintenance_mode: std::option::Option<bool>,
}
impl DefaultWorkspaceCreationProperties {
    /// <p>Specifies whether the directory is enabled for Amazon WorkDocs.</p>
    pub fn enable_work_docs(&self) -> std::option::Option<bool> {
        self.enable_work_docs
    }
    /// <p>Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory by default.
    /// If enabled, the Elastic public IP address allows outbound internet access from your WorkSpaces when you’re using an
    /// internet gateway in the Amazon VPC in which your WorkSpaces are located. If you're using a Network Address
    /// Translation (NAT) gateway for outbound internet access from your VPC, or if your WorkSpaces are in public
    /// subnets and you manually assign them Elastic IP addresses, you should disable this setting. This setting
    /// applies to new WorkSpaces that you launch or to existing WorkSpaces that you rebuild. For more information,
    /// see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html">
    /// Configure a VPC for Amazon WorkSpaces</a>.</p>
    pub fn enable_internet_access(&self) -> std::option::Option<bool> {
        self.enable_internet_access
    }
    /// <p>The organizational unit (OU) in the directory for the WorkSpace machine accounts.</p>
    pub fn default_ou(&self) -> std::option::Option<&str> {
        self.default_ou.as_deref()
    }
    /// <p>The identifier of the default security group to apply to WorkSpaces when they are created.
    /// For more information, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html">
    /// Security Groups for Your WorkSpaces</a>.</p>
    pub fn custom_security_group_id(&self) -> std::option::Option<&str> {
        self.custom_security_group_id.as_deref()
    }
    /// <p>Specifies whether WorkSpace users are local administrators on their WorkSpaces.</p>
    pub fn user_enabled_as_local_administrator(&self) -> std::option::Option<bool> {
        self.user_enabled_as_local_administrator
    }
    /// <p>Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see
    /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
    /// Maintenance</a>.</p>
    pub fn enable_maintenance_mode(&self) -> std::option::Option<bool> {
        self.enable_maintenance_mode
    }
}
impl std::fmt::Debug for DefaultWorkspaceCreationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultWorkspaceCreationProperties");
        formatter.field("enable_work_docs", &self.enable_work_docs);
        formatter.field("enable_internet_access", &self.enable_internet_access);
        formatter.field("default_ou", &self.default_ou);
        formatter.field("custom_security_group_id", &self.custom_security_group_id);
        formatter.field(
            "user_enabled_as_local_administrator",
            &self.user_enabled_as_local_administrator,
        );
        formatter.field("enable_maintenance_mode", &self.enable_maintenance_mode);
        formatter.finish()
    }
}
/// See [`DefaultWorkspaceCreationProperties`](crate::model::DefaultWorkspaceCreationProperties)
pub mod default_workspace_creation_properties {
    /// A builder for [`DefaultWorkspaceCreationProperties`](crate::model::DefaultWorkspaceCreationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_work_docs: std::option::Option<bool>,
        pub(crate) enable_internet_access: std::option::Option<bool>,
        pub(crate) default_ou: std::option::Option<std::string::String>,
        pub(crate) custom_security_group_id: std::option::Option<std::string::String>,
        pub(crate) user_enabled_as_local_administrator: std::option::Option<bool>,
        pub(crate) enable_maintenance_mode: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether the directory is enabled for Amazon WorkDocs.</p>
        pub fn enable_work_docs(mut self, input: bool) -> Self {
            self.enable_work_docs = Some(input);
            self
        }
        /// <p>Specifies whether the directory is enabled for Amazon WorkDocs.</p>
        pub fn set_enable_work_docs(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_work_docs = input;
            self
        }
        /// <p>Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory by default.
        /// If enabled, the Elastic public IP address allows outbound internet access from your WorkSpaces when you’re using an
        /// internet gateway in the Amazon VPC in which your WorkSpaces are located. If you're using a Network Address
        /// Translation (NAT) gateway for outbound internet access from your VPC, or if your WorkSpaces are in public
        /// subnets and you manually assign them Elastic IP addresses, you should disable this setting. This setting
        /// applies to new WorkSpaces that you launch or to existing WorkSpaces that you rebuild. For more information,
        /// see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html">
        /// Configure a VPC for Amazon WorkSpaces</a>.</p>
        pub fn enable_internet_access(mut self, input: bool) -> Self {
            self.enable_internet_access = Some(input);
            self
        }
        /// <p>Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory by default.
        /// If enabled, the Elastic public IP address allows outbound internet access from your WorkSpaces when you’re using an
        /// internet gateway in the Amazon VPC in which your WorkSpaces are located. If you're using a Network Address
        /// Translation (NAT) gateway for outbound internet access from your VPC, or if your WorkSpaces are in public
        /// subnets and you manually assign them Elastic IP addresses, you should disable this setting. This setting
        /// applies to new WorkSpaces that you launch or to existing WorkSpaces that you rebuild. For more information,
        /// see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html">
        /// Configure a VPC for Amazon WorkSpaces</a>.</p>
        pub fn set_enable_internet_access(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_internet_access = input;
            self
        }
        /// <p>The organizational unit (OU) in the directory for the WorkSpace machine accounts.</p>
        pub fn default_ou(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_ou = Some(input.into());
            self
        }
        /// <p>The organizational unit (OU) in the directory for the WorkSpace machine accounts.</p>
        pub fn set_default_ou(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.default_ou = input;
            self
        }
        /// <p>The identifier of the default security group to apply to WorkSpaces when they are created.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html">
        /// Security Groups for Your WorkSpaces</a>.</p>
        pub fn custom_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_security_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the default security group to apply to WorkSpaces when they are created.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html">
        /// Security Groups for Your WorkSpaces</a>.</p>
        pub fn set_custom_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_security_group_id = input;
            self
        }
        /// <p>Specifies whether WorkSpace users are local administrators on their WorkSpaces.</p>
        pub fn user_enabled_as_local_administrator(mut self, input: bool) -> Self {
            self.user_enabled_as_local_administrator = Some(input);
            self
        }
        /// <p>Specifies whether WorkSpace users are local administrators on their WorkSpaces.</p>
        pub fn set_user_enabled_as_local_administrator(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.user_enabled_as_local_administrator = input;
            self
        }
        /// <p>Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
        /// Maintenance</a>.</p>
        pub fn enable_maintenance_mode(mut self, input: bool) -> Self {
            self.enable_maintenance_mode = Some(input);
            self
        }
        /// <p>Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see
        /// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
        /// Maintenance</a>.</p>
        pub fn set_enable_maintenance_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_maintenance_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultWorkspaceCreationProperties`](crate::model::DefaultWorkspaceCreationProperties)
        pub fn build(self) -> crate::model::DefaultWorkspaceCreationProperties {
            crate::model::DefaultWorkspaceCreationProperties {
                enable_work_docs: self.enable_work_docs,
                enable_internet_access: self.enable_internet_access,
                default_ou: self.default_ou,
                custom_security_group_id: self.custom_security_group_id,
                user_enabled_as_local_administrator: self.user_enabled_as_local_administrator,
                enable_maintenance_mode: self.enable_maintenance_mode,
            }
        }
    }
}
impl DefaultWorkspaceCreationProperties {
    /// Creates a new builder-style object to manufacture [`DefaultWorkspaceCreationProperties`](crate::model::DefaultWorkspaceCreationProperties)
    pub fn builder() -> crate::model::default_workspace_creation_properties::Builder {
        crate::model::default_workspace_creation_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkspaceDirectoryState {
    #[allow(missing_docs)] // documentation missing in model
    Deregistered,
    #[allow(missing_docs)] // documentation missing in model
    Deregistering,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Registered,
    #[allow(missing_docs)] // documentation missing in model
    Registering,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkspaceDirectoryState {
    fn from(s: &str) -> Self {
        match s {
            "DEREGISTERED" => WorkspaceDirectoryState::Deregistered,
            "DEREGISTERING" => WorkspaceDirectoryState::Deregistering,
            "ERROR" => WorkspaceDirectoryState::Error,
            "REGISTERED" => WorkspaceDirectoryState::Registered,
            "REGISTERING" => WorkspaceDirectoryState::Registering,
            other => WorkspaceDirectoryState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkspaceDirectoryState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkspaceDirectoryState::from(s))
    }
}
impl WorkspaceDirectoryState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkspaceDirectoryState::Deregistered => "DEREGISTERED",
            WorkspaceDirectoryState::Deregistering => "DEREGISTERING",
            WorkspaceDirectoryState::Error => "ERROR",
            WorkspaceDirectoryState::Registered => "REGISTERED",
            WorkspaceDirectoryState::Registering => "REGISTERING",
            WorkspaceDirectoryState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEREGISTERED",
            "DEREGISTERING",
            "ERROR",
            "REGISTERED",
            "REGISTERING",
        ]
    }
}
impl AsRef<str> for WorkspaceDirectoryState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkspaceDirectoryType {
    #[allow(missing_docs)] // documentation missing in model
    AdConnector,
    #[allow(missing_docs)] // documentation missing in model
    SimpleAd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkspaceDirectoryType {
    fn from(s: &str) -> Self {
        match s {
            "AD_CONNECTOR" => WorkspaceDirectoryType::AdConnector,
            "SIMPLE_AD" => WorkspaceDirectoryType::SimpleAd,
            other => WorkspaceDirectoryType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkspaceDirectoryType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkspaceDirectoryType::from(s))
    }
}
impl WorkspaceDirectoryType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkspaceDirectoryType::AdConnector => "AD_CONNECTOR",
            WorkspaceDirectoryType::SimpleAd => "SIMPLE_AD",
            WorkspaceDirectoryType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AD_CONNECTOR", "SIMPLE_AD"]
    }
}
impl AsRef<str> for WorkspaceDirectoryType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a WorkSpace bundle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceBundle {
    /// <p>The identifier of the bundle.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The name of the bundle.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The owner of the bundle. This is the account identifier of the owner, or
    /// <code>AMAZON</code> if the bundle is provided by Amazon Web Services.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The description of the bundle.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The identifier of the image that was used to create the bundle.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The size of the root volume.</p>
    pub root_storage: std::option::Option<crate::model::RootStorage>,
    /// <p>The size of the user volume.</p>
    pub user_storage: std::option::Option<crate::model::UserStorage>,
    /// <p>The compute type of the bundle. For more information, see
    /// <a href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.</p>
    pub compute_type: std::option::Option<crate::model::ComputeType>,
    /// <p>The last time that the bundle was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the bundle was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl WorkspaceBundle {
    /// <p>The identifier of the bundle.</p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
    /// <p>The name of the bundle.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The owner of the bundle. This is the account identifier of the owner, or
    /// <code>AMAZON</code> if the bundle is provided by Amazon Web Services.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The description of the bundle.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The identifier of the image that was used to create the bundle.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The size of the root volume.</p>
    pub fn root_storage(&self) -> std::option::Option<&crate::model::RootStorage> {
        self.root_storage.as_ref()
    }
    /// <p>The size of the user volume.</p>
    pub fn user_storage(&self) -> std::option::Option<&crate::model::UserStorage> {
        self.user_storage.as_ref()
    }
    /// <p>The compute type of the bundle. For more information, see
    /// <a href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.</p>
    pub fn compute_type(&self) -> std::option::Option<&crate::model::ComputeType> {
        self.compute_type.as_ref()
    }
    /// <p>The last time that the bundle was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The time when the bundle was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceBundle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceBundle");
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("name", &self.name);
        formatter.field("owner", &self.owner);
        formatter.field("description", &self.description);
        formatter.field("image_id", &self.image_id);
        formatter.field("root_storage", &self.root_storage);
        formatter.field("user_storage", &self.user_storage);
        formatter.field("compute_type", &self.compute_type);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`WorkspaceBundle`](crate::model::WorkspaceBundle)
pub mod workspace_bundle {
    /// A builder for [`WorkspaceBundle`](crate::model::WorkspaceBundle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) root_storage: std::option::Option<crate::model::RootStorage>,
        pub(crate) user_storage: std::option::Option<crate::model::UserStorage>,
        pub(crate) compute_type: std::option::Option<crate::model::ComputeType>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the bundle.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bundle.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The name of the bundle.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bundle.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The owner of the bundle. This is the account identifier of the owner, or
        /// <code>AMAZON</code> if the bundle is provided by Amazon Web Services.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the bundle. This is the account identifier of the owner, or
        /// <code>AMAZON</code> if the bundle is provided by Amazon Web Services.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The description of the bundle.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the bundle.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The identifier of the image that was used to create the bundle.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the image that was used to create the bundle.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The size of the root volume.</p>
        pub fn root_storage(mut self, input: crate::model::RootStorage) -> Self {
            self.root_storage = Some(input);
            self
        }
        /// <p>The size of the root volume.</p>
        pub fn set_root_storage(
            mut self,
            input: std::option::Option<crate::model::RootStorage>,
        ) -> Self {
            self.root_storage = input;
            self
        }
        /// <p>The size of the user volume.</p>
        pub fn user_storage(mut self, input: crate::model::UserStorage) -> Self {
            self.user_storage = Some(input);
            self
        }
        /// <p>The size of the user volume.</p>
        pub fn set_user_storage(
            mut self,
            input: std::option::Option<crate::model::UserStorage>,
        ) -> Self {
            self.user_storage = input;
            self
        }
        /// <p>The compute type of the bundle. For more information, see
        /// <a href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.</p>
        pub fn compute_type(mut self, input: crate::model::ComputeType) -> Self {
            self.compute_type = Some(input);
            self
        }
        /// <p>The compute type of the bundle. For more information, see
        /// <a href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.</p>
        pub fn set_compute_type(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.compute_type = input;
            self
        }
        /// <p>The last time that the bundle was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The last time that the bundle was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The time when the bundle was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when the bundle was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceBundle`](crate::model::WorkspaceBundle)
        pub fn build(self) -> crate::model::WorkspaceBundle {
            crate::model::WorkspaceBundle {
                bundle_id: self.bundle_id,
                name: self.name,
                owner: self.owner,
                description: self.description,
                image_id: self.image_id,
                root_storage: self.root_storage,
                user_storage: self.user_storage,
                compute_type: self.compute_type,
                last_updated_time: self.last_updated_time,
                creation_time: self.creation_time,
            }
        }
    }
}
impl WorkspaceBundle {
    /// Creates a new builder-style object to manufacture [`WorkspaceBundle`](crate::model::WorkspaceBundle)
    pub fn builder() -> crate::model::workspace_bundle::Builder {
        crate::model::workspace_bundle::Builder::default()
    }
}

/// <p>Describes the compute type of the bundle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComputeType {
    /// <p>The compute type.</p>
    pub name: std::option::Option<crate::model::Compute>,
}
impl ComputeType {
    /// <p>The compute type.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::Compute> {
        self.name.as_ref()
    }
}
impl std::fmt::Debug for ComputeType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComputeType");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ComputeType`](crate::model::ComputeType)
pub mod compute_type {
    /// A builder for [`ComputeType`](crate::model::ComputeType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::Compute>,
    }
    impl Builder {
        /// <p>The compute type.</p>
        pub fn name(mut self, input: crate::model::Compute) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The compute type.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::Compute>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ComputeType`](crate::model::ComputeType)
        pub fn build(self) -> crate::model::ComputeType {
            crate::model::ComputeType { name: self.name }
        }
    }
}
impl ComputeType {
    /// Creates a new builder-style object to manufacture [`ComputeType`](crate::model::ComputeType)
    pub fn builder() -> crate::model::compute_type::Builder {
        crate::model::compute_type::Builder::default()
    }
}

/// <p>Describes the user volume for a WorkSpace bundle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserStorage {
    /// <p>The size of the user volume.</p>
    pub capacity: std::option::Option<std::string::String>,
}
impl UserStorage {
    /// <p>The size of the user volume.</p>
    pub fn capacity(&self) -> std::option::Option<&str> {
        self.capacity.as_deref()
    }
}
impl std::fmt::Debug for UserStorage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserStorage");
        formatter.field("capacity", &self.capacity);
        formatter.finish()
    }
}
/// See [`UserStorage`](crate::model::UserStorage)
pub mod user_storage {
    /// A builder for [`UserStorage`](crate::model::UserStorage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The size of the user volume.</p>
        pub fn capacity(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity = Some(input.into());
            self
        }
        /// <p>The size of the user volume.</p>
        pub fn set_capacity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`UserStorage`](crate::model::UserStorage)
        pub fn build(self) -> crate::model::UserStorage {
            crate::model::UserStorage {
                capacity: self.capacity,
            }
        }
    }
}
impl UserStorage {
    /// Creates a new builder-style object to manufacture [`UserStorage`](crate::model::UserStorage)
    pub fn builder() -> crate::model::user_storage::Builder {
        crate::model::user_storage::Builder::default()
    }
}

/// <p>Describes the root volume for a WorkSpace bundle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RootStorage {
    /// <p>The size of the root volume.</p>
    pub capacity: std::option::Option<std::string::String>,
}
impl RootStorage {
    /// <p>The size of the root volume.</p>
    pub fn capacity(&self) -> std::option::Option<&str> {
        self.capacity.as_deref()
    }
}
impl std::fmt::Debug for RootStorage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RootStorage");
        formatter.field("capacity", &self.capacity);
        formatter.finish()
    }
}
/// See [`RootStorage`](crate::model::RootStorage)
pub mod root_storage {
    /// A builder for [`RootStorage`](crate::model::RootStorage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The size of the root volume.</p>
        pub fn capacity(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity = Some(input.into());
            self
        }
        /// <p>The size of the root volume.</p>
        pub fn set_capacity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`RootStorage`](crate::model::RootStorage)
        pub fn build(self) -> crate::model::RootStorage {
            crate::model::RootStorage {
                capacity: self.capacity,
            }
        }
    }
}
impl RootStorage {
    /// Creates a new builder-style object to manufacture [`RootStorage`](crate::model::RootStorage)
    pub fn builder() -> crate::model::root_storage::Builder {
        crate::model::root_storage::Builder::default()
    }
}

/// <p>Describes an IP access control group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspacesIpGroup {
    /// <p>The identifier of the group.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The name of the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The description of the group.</p>
    pub group_desc: std::option::Option<std::string::String>,
    /// <p>The rules.</p>
    pub user_rules: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
}
impl WorkspacesIpGroup {
    /// <p>The identifier of the group.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The name of the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The description of the group.</p>
    pub fn group_desc(&self) -> std::option::Option<&str> {
        self.group_desc.as_deref()
    }
    /// <p>The rules.</p>
    pub fn user_rules(&self) -> std::option::Option<&[crate::model::IpRuleItem]> {
        self.user_rules.as_deref()
    }
}
impl std::fmt::Debug for WorkspacesIpGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspacesIpGroup");
        formatter.field("group_id", &self.group_id);
        formatter.field("group_name", &self.group_name);
        formatter.field("group_desc", &self.group_desc);
        formatter.field("user_rules", &self.user_rules);
        formatter.finish()
    }
}
/// See [`WorkspacesIpGroup`](crate::model::WorkspacesIpGroup)
pub mod workspaces_ip_group {
    /// A builder for [`WorkspacesIpGroup`](crate::model::WorkspacesIpGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_desc: std::option::Option<std::string::String>,
        pub(crate) user_rules: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
    }
    impl Builder {
        /// <p>The identifier of the group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The description of the group.</p>
        pub fn group_desc(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_desc = Some(input.into());
            self
        }
        /// <p>The description of the group.</p>
        pub fn set_group_desc(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_desc = input;
            self
        }
        /// Appends an item to `user_rules`.
        ///
        /// To override the contents of this collection use [`set_user_rules`](Self::set_user_rules).
        ///
        /// <p>The rules.</p>
        pub fn user_rules(mut self, input: impl Into<crate::model::IpRuleItem>) -> Self {
            let mut v = self.user_rules.unwrap_or_default();
            v.push(input.into());
            self.user_rules = Some(v);
            self
        }
        /// <p>The rules.</p>
        pub fn set_user_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRuleItem>>,
        ) -> Self {
            self.user_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspacesIpGroup`](crate::model::WorkspacesIpGroup)
        pub fn build(self) -> crate::model::WorkspacesIpGroup {
            crate::model::WorkspacesIpGroup {
                group_id: self.group_id,
                group_name: self.group_name,
                group_desc: self.group_desc,
                user_rules: self.user_rules,
            }
        }
    }
}
impl WorkspacesIpGroup {
    /// Creates a new builder-style object to manufacture [`WorkspacesIpGroup`](crate::model::WorkspacesIpGroup)
    pub fn builder() -> crate::model::workspaces_ip_group::Builder {
        crate::model::workspaces_ip_group::Builder::default()
    }
}

/// <p>Describes a connection alias. Connection aliases are used for cross-Region redirection. For more information,
/// see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html">
/// Cross-Region Redirection for Amazon WorkSpaces</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionAlias {
    /// <p>The connection string specified for the connection alias. The connection string must be in the form of
    /// a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p>
    pub connection_string: std::option::Option<std::string::String>,
    /// <p>The identifier of the connection alias.</p>
    pub alias_id: std::option::Option<std::string::String>,
    /// <p>The current state of the connection alias.</p>
    pub state: std::option::Option<crate::model::ConnectionAliasState>,
    /// <p>The identifier of the Amazon Web Services account that owns the connection alias.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The association status of the connection alias.</p>
    pub associations: std::option::Option<std::vec::Vec<crate::model::ConnectionAliasAssociation>>,
}
impl ConnectionAlias {
    /// <p>The connection string specified for the connection alias. The connection string must be in the form of
    /// a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p>
    pub fn connection_string(&self) -> std::option::Option<&str> {
        self.connection_string.as_deref()
    }
    /// <p>The identifier of the connection alias.</p>
    pub fn alias_id(&self) -> std::option::Option<&str> {
        self.alias_id.as_deref()
    }
    /// <p>The current state of the connection alias.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ConnectionAliasState> {
        self.state.as_ref()
    }
    /// <p>The identifier of the Amazon Web Services account that owns the connection alias.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The association status of the connection alias.</p>
    pub fn associations(&self) -> std::option::Option<&[crate::model::ConnectionAliasAssociation]> {
        self.associations.as_deref()
    }
}
impl std::fmt::Debug for ConnectionAlias {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionAlias");
        formatter.field("connection_string", &self.connection_string);
        formatter.field("alias_id", &self.alias_id);
        formatter.field("state", &self.state);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("associations", &self.associations);
        formatter.finish()
    }
}
/// See [`ConnectionAlias`](crate::model::ConnectionAlias)
pub mod connection_alias {
    /// A builder for [`ConnectionAlias`](crate::model::ConnectionAlias)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_string: std::option::Option<std::string::String>,
        pub(crate) alias_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ConnectionAliasState>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) associations:
            std::option::Option<std::vec::Vec<crate::model::ConnectionAliasAssociation>>,
    }
    impl Builder {
        /// <p>The connection string specified for the connection alias. The connection string must be in the form of
        /// a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p>
        pub fn connection_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_string = Some(input.into());
            self
        }
        /// <p>The connection string specified for the connection alias. The connection string must be in the form of
        /// a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p>
        pub fn set_connection_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_string = input;
            self
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the connection alias.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// <p>The current state of the connection alias.</p>
        pub fn state(mut self, input: crate::model::ConnectionAliasState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the connection alias.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionAliasState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The identifier of the Amazon Web Services account that owns the connection alias.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account that owns the connection alias.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// Appends an item to `associations`.
        ///
        /// To override the contents of this collection use [`set_associations`](Self::set_associations).
        ///
        /// <p>The association status of the connection alias.</p>
        pub fn associations(
            mut self,
            input: impl Into<crate::model::ConnectionAliasAssociation>,
        ) -> Self {
            let mut v = self.associations.unwrap_or_default();
            v.push(input.into());
            self.associations = Some(v);
            self
        }
        /// <p>The association status of the connection alias.</p>
        pub fn set_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectionAliasAssociation>>,
        ) -> Self {
            self.associations = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionAlias`](crate::model::ConnectionAlias)
        pub fn build(self) -> crate::model::ConnectionAlias {
            crate::model::ConnectionAlias {
                connection_string: self.connection_string,
                alias_id: self.alias_id,
                state: self.state,
                owner_account_id: self.owner_account_id,
                associations: self.associations,
            }
        }
    }
}
impl ConnectionAlias {
    /// Creates a new builder-style object to manufacture [`ConnectionAlias`](crate::model::ConnectionAlias)
    pub fn builder() -> crate::model::connection_alias::Builder {
        crate::model::connection_alias::Builder::default()
    }
}

/// <p>Describes a connection alias association that is used for cross-Region redirection. For more information, see
/// <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html">
/// Cross-Region Redirection for Amazon WorkSpaces</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionAliasAssociation {
    /// <p>The association status of the connection alias.</p>
    pub association_status: std::option::Option<crate::model::AssociationStatus>,
    /// <p>The identifier of the Amazon Web Services account that associated the connection alias with a directory.</p>
    pub associated_account_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the directory associated with a connection alias.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the connection alias association. You use the connection identifier in the DNS TXT record when
    /// you're configuring your DNS routing policies.</p>
    pub connection_identifier: std::option::Option<std::string::String>,
}
impl ConnectionAliasAssociation {
    /// <p>The association status of the connection alias.</p>
    pub fn association_status(&self) -> std::option::Option<&crate::model::AssociationStatus> {
        self.association_status.as_ref()
    }
    /// <p>The identifier of the Amazon Web Services account that associated the connection alias with a directory.</p>
    pub fn associated_account_id(&self) -> std::option::Option<&str> {
        self.associated_account_id.as_deref()
    }
    /// <p>The identifier of the directory associated with a connection alias.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The identifier of the connection alias association. You use the connection identifier in the DNS TXT record when
    /// you're configuring your DNS routing policies.</p>
    pub fn connection_identifier(&self) -> std::option::Option<&str> {
        self.connection_identifier.as_deref()
    }
}
impl std::fmt::Debug for ConnectionAliasAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionAliasAssociation");
        formatter.field("association_status", &self.association_status);
        formatter.field("associated_account_id", &self.associated_account_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("connection_identifier", &self.connection_identifier);
        formatter.finish()
    }
}
/// See [`ConnectionAliasAssociation`](crate::model::ConnectionAliasAssociation)
pub mod connection_alias_association {
    /// A builder for [`ConnectionAliasAssociation`](crate::model::ConnectionAliasAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_status: std::option::Option<crate::model::AssociationStatus>,
        pub(crate) associated_account_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) connection_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The association status of the connection alias.</p>
        pub fn association_status(mut self, input: crate::model::AssociationStatus) -> Self {
            self.association_status = Some(input);
            self
        }
        /// <p>The association status of the connection alias.</p>
        pub fn set_association_status(
            mut self,
            input: std::option::Option<crate::model::AssociationStatus>,
        ) -> Self {
            self.association_status = input;
            self
        }
        /// <p>The identifier of the Amazon Web Services account that associated the connection alias with a directory.</p>
        pub fn associated_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_account_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account that associated the connection alias with a directory.</p>
        pub fn set_associated_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_account_id = input;
            self
        }
        /// <p>The identifier of the directory associated with a connection alias.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory associated with a connection alias.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The identifier of the connection alias association. You use the connection identifier in the DNS TXT record when
        /// you're configuring your DNS routing policies.</p>
        pub fn connection_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the connection alias association. You use the connection identifier in the DNS TXT record when
        /// you're configuring your DNS routing policies.</p>
        pub fn set_connection_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionAliasAssociation`](crate::model::ConnectionAliasAssociation)
        pub fn build(self) -> crate::model::ConnectionAliasAssociation {
            crate::model::ConnectionAliasAssociation {
                association_status: self.association_status,
                associated_account_id: self.associated_account_id,
                resource_id: self.resource_id,
                connection_identifier: self.connection_identifier,
            }
        }
    }
}
impl ConnectionAliasAssociation {
    /// Creates a new builder-style object to manufacture [`ConnectionAliasAssociation`](crate::model::ConnectionAliasAssociation)
    pub fn builder() -> crate::model::connection_alias_association::Builder {
        crate::model::connection_alias_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssociationStatus {
    #[allow(missing_docs)] // documentation missing in model
    AssociatedWithOwnerAccount,
    #[allow(missing_docs)] // documentation missing in model
    AssociatedWithSharedAccount,
    #[allow(missing_docs)] // documentation missing in model
    NotAssociated,
    #[allow(missing_docs)] // documentation missing in model
    PendingAssociation,
    #[allow(missing_docs)] // documentation missing in model
    PendingDisassociation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssociationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ASSOCIATED_WITH_OWNER_ACCOUNT" => AssociationStatus::AssociatedWithOwnerAccount,
            "ASSOCIATED_WITH_SHARED_ACCOUNT" => AssociationStatus::AssociatedWithSharedAccount,
            "NOT_ASSOCIATED" => AssociationStatus::NotAssociated,
            "PENDING_ASSOCIATION" => AssociationStatus::PendingAssociation,
            "PENDING_DISASSOCIATION" => AssociationStatus::PendingDisassociation,
            other => AssociationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssociationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssociationStatus::from(s))
    }
}
impl AssociationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssociationStatus::AssociatedWithOwnerAccount => "ASSOCIATED_WITH_OWNER_ACCOUNT",
            AssociationStatus::AssociatedWithSharedAccount => "ASSOCIATED_WITH_SHARED_ACCOUNT",
            AssociationStatus::NotAssociated => "NOT_ASSOCIATED",
            AssociationStatus::PendingAssociation => "PENDING_ASSOCIATION",
            AssociationStatus::PendingDisassociation => "PENDING_DISASSOCIATION",
            AssociationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSOCIATED_WITH_OWNER_ACCOUNT",
            "ASSOCIATED_WITH_SHARED_ACCOUNT",
            "NOT_ASSOCIATED",
            "PENDING_ASSOCIATION",
            "PENDING_DISASSOCIATION",
        ]
    }
}
impl AsRef<str> for AssociationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionAliasState {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionAliasState {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => ConnectionAliasState::Created,
            "CREATING" => ConnectionAliasState::Creating,
            "DELETING" => ConnectionAliasState::Deleting,
            other => ConnectionAliasState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionAliasState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionAliasState::from(s))
    }
}
impl ConnectionAliasState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionAliasState::Created => "CREATED",
            ConnectionAliasState::Creating => "CREATING",
            ConnectionAliasState::Deleting => "DELETING",
            ConnectionAliasState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATED", "CREATING", "DELETING"]
    }
}
impl AsRef<str> for ConnectionAliasState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the Amazon WorkSpaces client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientPropertiesResult {
    /// <p>The resource identifier, in the form of a directory ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Information about the Amazon WorkSpaces client.</p>
    pub client_properties: std::option::Option<crate::model::ClientProperties>,
}
impl ClientPropertiesResult {
    /// <p>The resource identifier, in the form of a directory ID.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Information about the Amazon WorkSpaces client.</p>
    pub fn client_properties(&self) -> std::option::Option<&crate::model::ClientProperties> {
        self.client_properties.as_ref()
    }
}
impl std::fmt::Debug for ClientPropertiesResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientPropertiesResult");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("client_properties", &self.client_properties);
        formatter.finish()
    }
}
/// See [`ClientPropertiesResult`](crate::model::ClientPropertiesResult)
pub mod client_properties_result {
    /// A builder for [`ClientPropertiesResult`](crate::model::ClientPropertiesResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) client_properties: std::option::Option<crate::model::ClientProperties>,
    }
    impl Builder {
        /// <p>The resource identifier, in the form of a directory ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource identifier, in the form of a directory ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Information about the Amazon WorkSpaces client.</p>
        pub fn client_properties(mut self, input: crate::model::ClientProperties) -> Self {
            self.client_properties = Some(input);
            self
        }
        /// <p>Information about the Amazon WorkSpaces client.</p>
        pub fn set_client_properties(
            mut self,
            input: std::option::Option<crate::model::ClientProperties>,
        ) -> Self {
            self.client_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientPropertiesResult`](crate::model::ClientPropertiesResult)
        pub fn build(self) -> crate::model::ClientPropertiesResult {
            crate::model::ClientPropertiesResult {
                resource_id: self.resource_id,
                client_properties: self.client_properties,
            }
        }
    }
}
impl ClientPropertiesResult {
    /// Creates a new builder-style object to manufacture [`ClientPropertiesResult`](crate::model::ClientPropertiesResult)
    pub fn builder() -> crate::model::client_properties_result::Builder {
        crate::model::client_properties_result::Builder::default()
    }
}

/// <p>Describes a modification to the configuration of Bring Your Own License (BYOL) for the
/// specified account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountModification {
    /// <p>The state of the modification to the configuration of BYOL.</p>
    pub modification_state:
        std::option::Option<crate::model::DedicatedTenancyModificationStateEnum>,
    /// <p>The status of BYOL (whether BYOL is being enabled or disabled).</p>
    pub dedicated_tenancy_support:
        std::option::Option<crate::model::DedicatedTenancySupportResultEnum>,
    /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network
    /// interface used for the account.</p>
    pub dedicated_tenancy_management_cidr_range: std::option::Option<std::string::String>,
    /// <p>The timestamp when the modification of the BYOL configuration was started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The error code that is returned if the configuration of BYOL cannot be modified.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The text of the error message that is returned if the configuration of BYOL cannot be
    /// modified.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl AccountModification {
    /// <p>The state of the modification to the configuration of BYOL.</p>
    pub fn modification_state(
        &self,
    ) -> std::option::Option<&crate::model::DedicatedTenancyModificationStateEnum> {
        self.modification_state.as_ref()
    }
    /// <p>The status of BYOL (whether BYOL is being enabled or disabled).</p>
    pub fn dedicated_tenancy_support(
        &self,
    ) -> std::option::Option<&crate::model::DedicatedTenancySupportResultEnum> {
        self.dedicated_tenancy_support.as_ref()
    }
    /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network
    /// interface used for the account.</p>
    pub fn dedicated_tenancy_management_cidr_range(&self) -> std::option::Option<&str> {
        self.dedicated_tenancy_management_cidr_range.as_deref()
    }
    /// <p>The timestamp when the modification of the BYOL configuration was started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The error code that is returned if the configuration of BYOL cannot be modified.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The text of the error message that is returned if the configuration of BYOL cannot be
    /// modified.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for AccountModification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountModification");
        formatter.field("modification_state", &self.modification_state);
        formatter.field("dedicated_tenancy_support", &self.dedicated_tenancy_support);
        formatter.field(
            "dedicated_tenancy_management_cidr_range",
            &self.dedicated_tenancy_management_cidr_range,
        );
        formatter.field("start_time", &self.start_time);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`AccountModification`](crate::model::AccountModification)
pub mod account_modification {
    /// A builder for [`AccountModification`](crate::model::AccountModification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) modification_state:
            std::option::Option<crate::model::DedicatedTenancyModificationStateEnum>,
        pub(crate) dedicated_tenancy_support:
            std::option::Option<crate::model::DedicatedTenancySupportResultEnum>,
        pub(crate) dedicated_tenancy_management_cidr_range:
            std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the modification to the configuration of BYOL.</p>
        pub fn modification_state(
            mut self,
            input: crate::model::DedicatedTenancyModificationStateEnum,
        ) -> Self {
            self.modification_state = Some(input);
            self
        }
        /// <p>The state of the modification to the configuration of BYOL.</p>
        pub fn set_modification_state(
            mut self,
            input: std::option::Option<crate::model::DedicatedTenancyModificationStateEnum>,
        ) -> Self {
            self.modification_state = input;
            self
        }
        /// <p>The status of BYOL (whether BYOL is being enabled or disabled).</p>
        pub fn dedicated_tenancy_support(
            mut self,
            input: crate::model::DedicatedTenancySupportResultEnum,
        ) -> Self {
            self.dedicated_tenancy_support = Some(input);
            self
        }
        /// <p>The status of BYOL (whether BYOL is being enabled or disabled).</p>
        pub fn set_dedicated_tenancy_support(
            mut self,
            input: std::option::Option<crate::model::DedicatedTenancySupportResultEnum>,
        ) -> Self {
            self.dedicated_tenancy_support = input;
            self
        }
        /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network
        /// interface used for the account.</p>
        pub fn dedicated_tenancy_management_cidr_range(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.dedicated_tenancy_management_cidr_range = Some(input.into());
            self
        }
        /// <p>The IP address range, specified as an IPv4 CIDR block, for the management network
        /// interface used for the account.</p>
        pub fn set_dedicated_tenancy_management_cidr_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dedicated_tenancy_management_cidr_range = input;
            self
        }
        /// <p>The timestamp when the modification of the BYOL configuration was started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The timestamp when the modification of the BYOL configuration was started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The error code that is returned if the configuration of BYOL cannot be modified.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that is returned if the configuration of BYOL cannot be modified.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The text of the error message that is returned if the configuration of BYOL cannot be
        /// modified.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The text of the error message that is returned if the configuration of BYOL cannot be
        /// modified.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountModification`](crate::model::AccountModification)
        pub fn build(self) -> crate::model::AccountModification {
            crate::model::AccountModification {
                modification_state: self.modification_state,
                dedicated_tenancy_support: self.dedicated_tenancy_support,
                dedicated_tenancy_management_cidr_range: self
                    .dedicated_tenancy_management_cidr_range,
                start_time: self.start_time,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl AccountModification {
    /// Creates a new builder-style object to manufacture [`AccountModification`](crate::model::AccountModification)
    pub fn builder() -> crate::model::account_modification::Builder {
        crate::model::account_modification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DedicatedTenancySupportResultEnum {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DedicatedTenancySupportResultEnum {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => DedicatedTenancySupportResultEnum::Disabled,
            "ENABLED" => DedicatedTenancySupportResultEnum::Enabled,
            other => DedicatedTenancySupportResultEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DedicatedTenancySupportResultEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DedicatedTenancySupportResultEnum::from(s))
    }
}
impl DedicatedTenancySupportResultEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DedicatedTenancySupportResultEnum::Disabled => "DISABLED",
            DedicatedTenancySupportResultEnum::Enabled => "ENABLED",
            DedicatedTenancySupportResultEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for DedicatedTenancySupportResultEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DedicatedTenancyModificationStateEnum {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DedicatedTenancyModificationStateEnum {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => DedicatedTenancyModificationStateEnum::Completed,
            "FAILED" => DedicatedTenancyModificationStateEnum::Failed,
            "PENDING" => DedicatedTenancyModificationStateEnum::Pending,
            other => DedicatedTenancyModificationStateEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DedicatedTenancyModificationStateEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DedicatedTenancyModificationStateEnum::from(s))
    }
}
impl DedicatedTenancyModificationStateEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DedicatedTenancyModificationStateEnum::Completed => "COMPLETED",
            DedicatedTenancyModificationStateEnum::Failed => "FAILED",
            DedicatedTenancyModificationStateEnum::Pending => "PENDING",
            DedicatedTenancyModificationStateEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "PENDING"]
    }
}
impl AsRef<str> for DedicatedTenancyModificationStateEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a WorkSpace that cannot be created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedCreateWorkspaceRequest {
    /// <p>Information about the WorkSpace.</p>
    pub workspace_request: std::option::Option<crate::model::WorkspaceRequest>,
    /// <p>The error code that is returned if the WorkSpace cannot be created.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The text of the error message that is returned if the WorkSpace cannot be
    /// created.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl FailedCreateWorkspaceRequest {
    /// <p>Information about the WorkSpace.</p>
    pub fn workspace_request(&self) -> std::option::Option<&crate::model::WorkspaceRequest> {
        self.workspace_request.as_ref()
    }
    /// <p>The error code that is returned if the WorkSpace cannot be created.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The text of the error message that is returned if the WorkSpace cannot be
    /// created.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for FailedCreateWorkspaceRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedCreateWorkspaceRequest");
        formatter.field("workspace_request", &self.workspace_request);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`FailedCreateWorkspaceRequest`](crate::model::FailedCreateWorkspaceRequest)
pub mod failed_create_workspace_request {
    /// A builder for [`FailedCreateWorkspaceRequest`](crate::model::FailedCreateWorkspaceRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_request: std::option::Option<crate::model::WorkspaceRequest>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the WorkSpace.</p>
        pub fn workspace_request(mut self, input: crate::model::WorkspaceRequest) -> Self {
            self.workspace_request = Some(input);
            self
        }
        /// <p>Information about the WorkSpace.</p>
        pub fn set_workspace_request(
            mut self,
            input: std::option::Option<crate::model::WorkspaceRequest>,
        ) -> Self {
            self.workspace_request = input;
            self
        }
        /// <p>The error code that is returned if the WorkSpace cannot be created.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that is returned if the WorkSpace cannot be created.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The text of the error message that is returned if the WorkSpace cannot be
        /// created.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The text of the error message that is returned if the WorkSpace cannot be
        /// created.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedCreateWorkspaceRequest`](crate::model::FailedCreateWorkspaceRequest)
        pub fn build(self) -> crate::model::FailedCreateWorkspaceRequest {
            crate::model::FailedCreateWorkspaceRequest {
                workspace_request: self.workspace_request,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl FailedCreateWorkspaceRequest {
    /// Creates a new builder-style object to manufacture [`FailedCreateWorkspaceRequest`](crate::model::FailedCreateWorkspaceRequest)
    pub fn builder() -> crate::model::failed_create_workspace_request::Builder {
        crate::model::failed_create_workspace_request::Builder::default()
    }
}

/// <p>Describes the information used to create a WorkSpace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceRequest {
    /// <p>The identifier of the Directory Service directory for the WorkSpace. You can use
    /// <a>DescribeWorkspaceDirectories</a> to list the available directories.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The user name of the user for the WorkSpace. This user name must exist in the Directory Service
    /// directory for the WorkSpace.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the bundle for the WorkSpace. You can use <a>DescribeWorkspaceBundles</a> to list the available bundles.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The symmetric KMS key used to encrypt data stored on your WorkSpace.
    /// Amazon WorkSpaces does not support asymmetric KMS keys.</p>
    pub volume_encryption_key: std::option::Option<std::string::String>,
    /// <p>Indicates whether the data stored on the user volume is encrypted.</p>
    pub user_volume_encryption_enabled: std::option::Option<bool>,
    /// <p>Indicates whether the data stored on the root volume is encrypted.</p>
    pub root_volume_encryption_enabled: std::option::Option<bool>,
    /// <p>The WorkSpace properties.</p>
    pub workspace_properties: std::option::Option<crate::model::WorkspaceProperties>,
    /// <p>The tags for the WorkSpace.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl WorkspaceRequest {
    /// <p>The identifier of the Directory Service directory for the WorkSpace. You can use
    /// <a>DescribeWorkspaceDirectories</a> to list the available directories.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The user name of the user for the WorkSpace. This user name must exist in the Directory Service
    /// directory for the WorkSpace.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The identifier of the bundle for the WorkSpace. You can use <a>DescribeWorkspaceBundles</a> to list the available bundles.</p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
    /// <p>The symmetric KMS key used to encrypt data stored on your WorkSpace.
    /// Amazon WorkSpaces does not support asymmetric KMS keys.</p>
    pub fn volume_encryption_key(&self) -> std::option::Option<&str> {
        self.volume_encryption_key.as_deref()
    }
    /// <p>Indicates whether the data stored on the user volume is encrypted.</p>
    pub fn user_volume_encryption_enabled(&self) -> std::option::Option<bool> {
        self.user_volume_encryption_enabled
    }
    /// <p>Indicates whether the data stored on the root volume is encrypted.</p>
    pub fn root_volume_encryption_enabled(&self) -> std::option::Option<bool> {
        self.root_volume_encryption_enabled
    }
    /// <p>The WorkSpace properties.</p>
    pub fn workspace_properties(&self) -> std::option::Option<&crate::model::WorkspaceProperties> {
        self.workspace_properties.as_ref()
    }
    /// <p>The tags for the WorkSpace.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for WorkspaceRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceRequest");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("volume_encryption_key", &self.volume_encryption_key);
        formatter.field(
            "user_volume_encryption_enabled",
            &self.user_volume_encryption_enabled,
        );
        formatter.field(
            "root_volume_encryption_enabled",
            &self.root_volume_encryption_enabled,
        );
        formatter.field("workspace_properties", &self.workspace_properties);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`WorkspaceRequest`](crate::model::WorkspaceRequest)
pub mod workspace_request {
    /// A builder for [`WorkspaceRequest`](crate::model::WorkspaceRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) volume_encryption_key: std::option::Option<std::string::String>,
        pub(crate) user_volume_encryption_enabled: std::option::Option<bool>,
        pub(crate) root_volume_encryption_enabled: std::option::Option<bool>,
        pub(crate) workspace_properties: std::option::Option<crate::model::WorkspaceProperties>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the Directory Service directory for the WorkSpace. You can use
        /// <a>DescribeWorkspaceDirectories</a> to list the available directories.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Directory Service directory for the WorkSpace. You can use
        /// <a>DescribeWorkspaceDirectories</a> to list the available directories.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The user name of the user for the WorkSpace. This user name must exist in the Directory Service
        /// directory for the WorkSpace.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user name of the user for the WorkSpace. This user name must exist in the Directory Service
        /// directory for the WorkSpace.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The identifier of the bundle for the WorkSpace. You can use <a>DescribeWorkspaceBundles</a> to list the available bundles.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bundle for the WorkSpace. You can use <a>DescribeWorkspaceBundles</a> to list the available bundles.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The symmetric KMS key used to encrypt data stored on your WorkSpace.
        /// Amazon WorkSpaces does not support asymmetric KMS keys.</p>
        pub fn volume_encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_encryption_key = Some(input.into());
            self
        }
        /// <p>The symmetric KMS key used to encrypt data stored on your WorkSpace.
        /// Amazon WorkSpaces does not support asymmetric KMS keys.</p>
        pub fn set_volume_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_encryption_key = input;
            self
        }
        /// <p>Indicates whether the data stored on the user volume is encrypted.</p>
        pub fn user_volume_encryption_enabled(mut self, input: bool) -> Self {
            self.user_volume_encryption_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the data stored on the user volume is encrypted.</p>
        pub fn set_user_volume_encryption_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.user_volume_encryption_enabled = input;
            self
        }
        /// <p>Indicates whether the data stored on the root volume is encrypted.</p>
        pub fn root_volume_encryption_enabled(mut self, input: bool) -> Self {
            self.root_volume_encryption_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the data stored on the root volume is encrypted.</p>
        pub fn set_root_volume_encryption_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.root_volume_encryption_enabled = input;
            self
        }
        /// <p>The WorkSpace properties.</p>
        pub fn workspace_properties(mut self, input: crate::model::WorkspaceProperties) -> Self {
            self.workspace_properties = Some(input);
            self
        }
        /// <p>The WorkSpace properties.</p>
        pub fn set_workspace_properties(
            mut self,
            input: std::option::Option<crate::model::WorkspaceProperties>,
        ) -> Self {
            self.workspace_properties = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the WorkSpace.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the WorkSpace.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceRequest`](crate::model::WorkspaceRequest)
        pub fn build(self) -> crate::model::WorkspaceRequest {
            crate::model::WorkspaceRequest {
                directory_id: self.directory_id,
                user_name: self.user_name,
                bundle_id: self.bundle_id,
                volume_encryption_key: self.volume_encryption_key,
                user_volume_encryption_enabled: self.user_volume_encryption_enabled,
                root_volume_encryption_enabled: self.root_volume_encryption_enabled,
                workspace_properties: self.workspace_properties,
                tags: self.tags,
            }
        }
    }
}
impl WorkspaceRequest {
    /// Creates a new builder-style object to manufacture [`WorkspaceRequest`](crate::model::WorkspaceRequest)
    pub fn builder() -> crate::model::workspace_request::Builder {
        crate::model::workspace_request::Builder::default()
    }
}
