// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>WorkMail could not access the updated email content. Possible reasons:</p>
    /// <ul>
    /// <li> <p>You made the request in a region other than your S3 bucket region.</p> </li>
    /// <li> <p>The <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-owner-condition.html">S3 bucket owner</a> is not the same as the calling AWS account.</p> </li>
    /// <li> <p>You have an incomplete or missing S3 bucket policy. For more information about policies, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/update-with-lambda.html"> Updating message content with AWS Lambda </a> in the <i>WorkMail Administrator Guide</i>.</p> </li>
    /// </ul>
    InvalidContentLocation(crate::error::InvalidContentLocation),
    /// <p>The requested email is not eligible for update. This is usually the case for a redirected email.</p>
    MessageFrozen(crate::error::MessageFrozen),
    /// <p>The requested email could not be updated due to an error in the MIME content. Check the error message for more information about what caused the error.</p>
    MessageRejected(crate::error::MessageRejected),
    /// <p>The requested email message is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::InvalidContentLocation(inner) => inner.fmt(f),
            Error::MessageFrozen(inner) => inner.fmt(f),
            Error::MessageRejected(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRawMessageContentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetRawMessageContentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetRawMessageContentErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetRawMessageContentErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutRawMessageContentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutRawMessageContentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutRawMessageContentErrorKind::InvalidContentLocation(inner) => {
                    Error::InvalidContentLocation(inner)
                }
                crate::error::PutRawMessageContentErrorKind::MessageFrozen(inner) => {
                    Error::MessageFrozen(inner)
                }
                crate::error::PutRawMessageContentErrorKind::MessageRejected(inner) => {
                    Error::MessageRejected(inner)
                }
                crate::error::PutRawMessageContentErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::PutRawMessageContentErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
