// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Provides the MIME content of the updated email message as an S3 object. All MIME content must meet the following criteria:</p>
/// <ul>
/// <li>
/// <p>Each part of a multipart MIME message must be formatted properly.</p>
/// </li>
/// <li>
/// <p>Attachments must be of a content type that Amazon SES supports. For more information, see
/// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types-appendix.html">Unsupported Attachment Types</a>.</p>
/// </li>
/// <li>
/// <p>If any of the MIME parts in a message contain content that is outside of the 7-bit ASCII character range, we recommend
/// encoding that content.</p>
/// </li>
/// <li>
/// <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC 5321</a>, the maximum length of each line of
/// text, including the <CRLF>, must not exceed 1,000 characters.</p>
/// </li>
/// <li>
/// <p>The message must contain all the required header fields. Check the returned error message for more information.</p>
/// </li>
/// <li>
/// <p>The value of immutable headers must remain unchanged. Check the returned error message for more information.</p>
/// </li>
/// <li>
/// <p>Certain unique headers can only appear once. Check the returned error message for more information.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RawMessageContent {
    /// <p>The S3 reference of an email message.</p>
    pub s3_reference: std::option::Option<crate::model::S3Reference>,
}
impl std::fmt::Debug for RawMessageContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RawMessageContent");
        formatter.field("s3_reference", &self.s3_reference);
        formatter.finish()
    }
}
/// See [`RawMessageContent`](crate::model::RawMessageContent)
pub mod raw_message_content {
    /// A builder for [`RawMessageContent`](crate::model::RawMessageContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_reference: std::option::Option<crate::model::S3Reference>,
    }
    impl Builder {
        /// <p>The S3 reference of an email message.</p>
        pub fn s3_reference(mut self, input: crate::model::S3Reference) -> Self {
            self.s3_reference = Some(input);
            self
        }
        /// <p>The S3 reference of an email message.</p>
        pub fn set_s3_reference(
            mut self,
            input: std::option::Option<crate::model::S3Reference>,
        ) -> Self {
            self.s3_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`RawMessageContent`](crate::model::RawMessageContent)
        pub fn build(self) -> crate::model::RawMessageContent {
            crate::model::RawMessageContent {
                s3_reference: self.s3_reference,
            }
        }
    }
}
impl RawMessageContent {
    /// Creates a new builder-style object to manufacture [`RawMessageContent`](crate::model::RawMessageContent)
    pub fn builder() -> crate::model::raw_message_content::Builder {
        crate::model::raw_message_content::Builder::default()
    }
}

/// <p>Amazon S3 object representing the updated message content, in MIME format.</p>
/// <note>
/// <p>The region for the S3 bucket containing the S3 object must match the region used for WorkMail operations. Also, for WorkMail to process
/// an S3 object, it must have permission to access that object. For more information, see
/// <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/update-with-lambda.html">
/// Updating message content with AWS Lambda</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Reference {
    /// <p>The S3 bucket name.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The S3 key object name.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>If you enable versioning for the bucket, you can specify the object version.</p>
    pub object_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3Reference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Reference");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("object_version", &self.object_version);
        formatter.finish()
    }
}
/// See [`S3Reference`](crate::model::S3Reference)
pub mod s3_reference {
    /// A builder for [`S3Reference`](crate::model::S3Reference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) object_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The S3 key object name.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The S3 key object name.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>If you enable versioning for the bucket, you can specify the object version.</p>
        pub fn object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_version = Some(input.into());
            self
        }
        /// <p>If you enable versioning for the bucket, you can specify the object version.</p>
        pub fn set_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_version = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Reference`](crate::model::S3Reference)
        pub fn build(self) -> crate::model::S3Reference {
            crate::model::S3Reference {
                bucket: self.bucket,
                key: self.key,
                object_version: self.object_version,
            }
        }
    }
}
impl S3Reference {
    /// Creates a new builder-style object to manufacture [`S3Reference`](crate::model::S3Reference)
    pub fn builder() -> crate::model::s3_reference::Builder {
        crate::model::s3_reference::Builder::default()
    }
}
