// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`GetRawMessageContentInput`](crate::input::GetRawMessageContentInput)
pub mod get_raw_message_content_input {
    /// A builder for [`GetRawMessageContentInput`](crate::input::GetRawMessageContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the email message to retrieve.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The identifier of the email message to retrieve.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRawMessageContentInput`](crate::input::GetRawMessageContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRawMessageContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRawMessageContentInput {
                message_id: self.message_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRawMessageContentInputOperationOutputAlias = crate::operation::GetRawMessageContent;
#[doc(hidden)]
pub type GetRawMessageContentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRawMessageContentInput {
    /// Consumes the builder and constructs an Operation<[`GetRawMessageContent`](crate::operation::GetRawMessageContent)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRawMessageContent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRawMessageContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.message_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "message_id",
                        details: "cannot be empty or unset",
                    })?;
            let message_id = aws_smithy_http::label::fmt_string(input_1, false);
            if message_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "message_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/messages/{messageId}", messageId = message_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRawMessageContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRawMessageContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRawMessageContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRawMessageContent",
            "workmailmessageflow",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRawMessageContentInput`](crate::input::GetRawMessageContentInput)
    pub fn builder() -> crate::input::get_raw_message_content_input::Builder {
        crate::input::get_raw_message_content_input::Builder::default()
    }
}

/// See [`PutRawMessageContentInput`](crate::input::PutRawMessageContentInput)
pub mod put_raw_message_content_input {
    /// A builder for [`PutRawMessageContentInput`](crate::input::PutRawMessageContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<crate::model::RawMessageContent>,
    }
    impl Builder {
        /// <p>The identifier of the email message being updated.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The identifier of the email message being updated.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>Describes the raw message content of the updated email message.</p>
        pub fn content(mut self, input: crate::model::RawMessageContent) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>Describes the raw message content of the updated email message.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::RawMessageContent>,
        ) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRawMessageContentInput`](crate::input::PutRawMessageContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRawMessageContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRawMessageContentInput {
                message_id: self.message_id,
                content: self.content,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRawMessageContentInputOperationOutputAlias = crate::operation::PutRawMessageContent;
#[doc(hidden)]
pub type PutRawMessageContentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRawMessageContentInput {
    /// Consumes the builder and constructs an Operation<[`PutRawMessageContent`](crate::operation::PutRawMessageContent)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRawMessageContent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRawMessageContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.message_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "message_id",
                        details: "cannot be empty or unset",
                    })?;
            let message_id = aws_smithy_http::label::fmt_string(input_2, false);
            if message_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "message_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/messages/{messageId}", messageId = message_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRawMessageContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRawMessageContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_raw_message_content(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRawMessageContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRawMessageContent",
            "workmailmessageflow",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRawMessageContentInput`](crate::input::PutRawMessageContentInput)
    pub fn builder() -> crate::input::put_raw_message_content_input::Builder {
        crate::input::put_raw_message_content_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRawMessageContentInput {
    /// <p>The identifier of the email message being updated.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>Describes the raw message content of the updated email message.</p>
    pub content: std::option::Option<crate::model::RawMessageContent>,
}
impl std::fmt::Debug for PutRawMessageContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRawMessageContentInput");
        formatter.field("message_id", &self.message_id);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRawMessageContentInput {
    /// <p>The identifier of the email message to retrieve.</p>
    pub message_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetRawMessageContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRawMessageContentInput");
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
