// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon WorkMail
///
/// Client for invoking operations on Amazon WorkMail. Each operation on Amazon WorkMail is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_workmail::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_workmail::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_workmail::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateDelegateToResource`](crate::client::fluent_builders::AssociateDelegateToResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::AssociateDelegateToResource::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::AssociateDelegateToResource::set_organization_id): <p>The organization under which the resource exists.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::AssociateDelegateToResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::AssociateDelegateToResource::set_resource_id): <p>The resource for which members (users or groups) are associated.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::AssociateDelegateToResource::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::AssociateDelegateToResource::set_entity_id): <p>The member (user or group) to associate to the resource.</p>
    /// - On success, responds with [`AssociateDelegateToResourceOutput`](crate::output::AssociateDelegateToResourceOutput)

    /// - On failure, responds with [`SdkError<AssociateDelegateToResourceError>`](crate::error::AssociateDelegateToResourceError)
    pub fn associate_delegate_to_resource(&self) -> fluent_builders::AssociateDelegateToResource {
        fluent_builders::AssociateDelegateToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateMemberToGroup`](crate::client::fluent_builders::AssociateMemberToGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::AssociateMemberToGroup::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::AssociateMemberToGroup::set_organization_id): <p>The organization under which the group exists.</p>
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::AssociateMemberToGroup::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::AssociateMemberToGroup::set_group_id): <p>The group to which the member (user or group) is associated.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::AssociateMemberToGroup::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::AssociateMemberToGroup::set_member_id): <p>The member (user or group) to associate to the group.</p>
    /// - On success, responds with [`AssociateMemberToGroupOutput`](crate::output::AssociateMemberToGroupOutput)

    /// - On failure, responds with [`SdkError<AssociateMemberToGroupError>`](crate::error::AssociateMemberToGroupError)
    pub fn associate_member_to_group(&self) -> fluent_builders::AssociateMemberToGroup {
        fluent_builders::AssociateMemberToGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelMailboxExportJob`](crate::client::fluent_builders::CancelMailboxExportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CancelMailboxExportJob::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CancelMailboxExportJob::set_client_token): <p>The idempotency token for the client request.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CancelMailboxExportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CancelMailboxExportJob::set_job_id): <p>The job ID.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::CancelMailboxExportJob::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::CancelMailboxExportJob::set_organization_id): <p>The organization ID.</p>
    /// - On success, responds with [`CancelMailboxExportJobOutput`](crate::output::CancelMailboxExportJobOutput)

    /// - On failure, responds with [`SdkError<CancelMailboxExportJobError>`](crate::error::CancelMailboxExportJobError)
    pub fn cancel_mailbox_export_job(&self) -> fluent_builders::CancelMailboxExportJob {
        fluent_builders::CancelMailboxExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAlias`](crate::client::fluent_builders::CreateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_organization_id): <p>The organization under which the member (user or group) exists.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_entity_id): <p>The member (user or group) to which this alias is added.</p>
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_alias): <p>The alias to add to the member set.</p>
    /// - On success, responds with [`CreateAliasOutput`](crate::output::CreateAliasOutput)

    /// - On failure, responds with [`SdkError<CreateAliasError>`](crate::error::CreateAliasError)
    pub fn create_alias(&self) -> fluent_builders::CreateAlias {
        fluent_builders::CreateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGroup`](crate::client::fluent_builders::CreateGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_organization_id): <p>The organization under which the group is to be created.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_name): <p>The name of the group.</p>
    /// - On success, responds with [`CreateGroupOutput`](crate::output::CreateGroupOutput) with field(s):
    ///   - [`group_id(Option<String>)`](crate::output::CreateGroupOutput::group_id): <p>The identifier of the group.</p>
    /// - On failure, responds with [`SdkError<CreateGroupError>`](crate::error::CreateGroupError)
    pub fn create_group(&self) -> fluent_builders::CreateGroup {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMobileDeviceAccessRule`](crate::client::fluent_builders::CreateMobileDeviceAccessRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_organization_id): <p>The Amazon WorkMail organization under which the rule will be created.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_client_token): <p>The idempotency token for the client request.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_name): <p>The rule name.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_description): <p>The rule description.</p>
    ///   - [`effect(MobileDeviceAccessRuleEffect)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::effect) / [`set_effect(Option<MobileDeviceAccessRuleEffect>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_effect): <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
    ///   - [`device_types(Vec<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::device_types) / [`set_device_types(Option<Vec<String>>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_device_types): <p>Device types that the rule will match.</p>
    ///   - [`not_device_types(Vec<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::not_device_types) / [`set_not_device_types(Option<Vec<String>>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_not_device_types): <p>Device types that the rule <b>will not</b> match. All other device types will match.</p>
    ///   - [`device_models(Vec<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::device_models) / [`set_device_models(Option<Vec<String>>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_device_models): <p>Device models that the rule will match.</p>
    ///   - [`not_device_models(Vec<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::not_device_models) / [`set_not_device_models(Option<Vec<String>>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_not_device_models): <p>Device models that the rule <b>will not</b> match. All other device models will match.</p>
    ///   - [`device_operating_systems(Vec<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::device_operating_systems) / [`set_device_operating_systems(Option<Vec<String>>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_device_operating_systems): <p>Device operating systems that the rule will match.</p>
    ///   - [`not_device_operating_systems(Vec<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::not_device_operating_systems) / [`set_not_device_operating_systems(Option<Vec<String>>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_not_device_operating_systems): <p>Device operating systems that the rule <b>will not</b> match. All other device operating systems will match.</p>
    ///   - [`device_user_agents(Vec<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::device_user_agents) / [`set_device_user_agents(Option<Vec<String>>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_device_user_agents): <p>Device user agents that the rule will match.</p>
    ///   - [`not_device_user_agents(Vec<String>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::not_device_user_agents) / [`set_not_device_user_agents(Option<Vec<String>>)`](crate::client::fluent_builders::CreateMobileDeviceAccessRule::set_not_device_user_agents): <p>Device user agents that the rule <b>will not</b> match. All other device user agents will match.</p>
    /// - On success, responds with [`CreateMobileDeviceAccessRuleOutput`](crate::output::CreateMobileDeviceAccessRuleOutput) with field(s):
    ///   - [`mobile_device_access_rule_id(Option<String>)`](crate::output::CreateMobileDeviceAccessRuleOutput::mobile_device_access_rule_id): <p>The identifier for the newly created mobile device access rule.</p>
    /// - On failure, responds with [`SdkError<CreateMobileDeviceAccessRuleError>`](crate::error::CreateMobileDeviceAccessRuleError)
    pub fn create_mobile_device_access_rule(
        &self,
    ) -> fluent_builders::CreateMobileDeviceAccessRule {
        fluent_builders::CreateMobileDeviceAccessRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOrganization`](crate::client::fluent_builders::CreateOrganization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::CreateOrganization::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::CreateOrganization::set_directory_id): <p>The AWS Directory Service directory ID.</p>
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::CreateOrganization::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::CreateOrganization::set_alias): <p>The organization alias.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateOrganization::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateOrganization::set_client_token): <p>The idempotency token associated with the request.</p>
    ///   - [`domains(Vec<Domain>)`](crate::client::fluent_builders::CreateOrganization::domains) / [`set_domains(Option<Vec<Domain>>)`](crate::client::fluent_builders::CreateOrganization::set_domains): <p>The email domains to associate with the organization.</p>
    ///   - [`kms_key_arn(impl Into<String>)`](crate::client::fluent_builders::CreateOrganization::kms_key_arn) / [`set_kms_key_arn(Option<String>)`](crate::client::fluent_builders::CreateOrganization::set_kms_key_arn): <p>The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.</p>
    ///   - [`enable_interoperability(bool)`](crate::client::fluent_builders::CreateOrganization::enable_interoperability) / [`set_enable_interoperability(bool)`](crate::client::fluent_builders::CreateOrganization::set_enable_interoperability): <p>When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the request.</p>
    /// - On success, responds with [`CreateOrganizationOutput`](crate::output::CreateOrganizationOutput) with field(s):
    ///   - [`organization_id(Option<String>)`](crate::output::CreateOrganizationOutput::organization_id): <p>The organization ID.</p>
    /// - On failure, responds with [`SdkError<CreateOrganizationError>`](crate::error::CreateOrganizationError)
    pub fn create_organization(&self) -> fluent_builders::CreateOrganization {
        fluent_builders::CreateOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResource`](crate::client::fluent_builders::CreateResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::CreateResource::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::CreateResource::set_organization_id): <p>The identifier associated with the organization for which the resource is created.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateResource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateResource::set_name): <p>The name of the new resource.</p>
    ///   - [`r#type(ResourceType)`](crate::client::fluent_builders::CreateResource::type) / [`set_type(Option<ResourceType>)`](crate::client::fluent_builders::CreateResource::set_type): <p>The type of the new resource. The available types are <code>equipment</code> and <code>room</code>.</p>
    /// - On success, responds with [`CreateResourceOutput`](crate::output::CreateResourceOutput) with field(s):
    ///   - [`resource_id(Option<String>)`](crate::output::CreateResourceOutput::resource_id): <p>The identifier of the new resource.</p>
    /// - On failure, responds with [`SdkError<CreateResourceError>`](crate::error::CreateResourceError)
    pub fn create_resource(&self) -> fluent_builders::CreateResource {
        fluent_builders::CreateResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUser`](crate::client::fluent_builders::CreateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_organization_id): <p>The identifier of the organization for which the user is created.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateUser::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateUser::set_name): <p>The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateUser::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateUser::set_display_name): <p>The display name for the new user.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::CreateUser::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::CreateUser::set_password): <p>The password for the new user.</p>
    /// - On success, responds with [`CreateUserOutput`](crate::output::CreateUserOutput) with field(s):
    ///   - [`user_id(Option<String>)`](crate::output::CreateUserOutput::user_id): <p>The identifier for the new user.</p>
    /// - On failure, responds with [`SdkError<CreateUserError>`](crate::error::CreateUserError)
    pub fn create_user(&self) -> fluent_builders::CreateUser {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccessControlRule`](crate::client::fluent_builders::DeleteAccessControlRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessControlRule::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteAccessControlRule::set_organization_id): <p>The identifier for the organization.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessControlRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteAccessControlRule::set_name): <p>The name of the access control rule.</p>
    /// - On success, responds with [`DeleteAccessControlRuleOutput`](crate::output::DeleteAccessControlRuleOutput)

    /// - On failure, responds with [`SdkError<DeleteAccessControlRuleError>`](crate::error::DeleteAccessControlRuleError)
    pub fn delete_access_control_rule(&self) -> fluent_builders::DeleteAccessControlRule {
        fluent_builders::DeleteAccessControlRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAlias`](crate::client::fluent_builders::DeleteAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAlias::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteAlias::set_organization_id): <p>The identifier for the organization under which the user exists.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAlias::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::DeleteAlias::set_entity_id): <p>The identifier for the member (user or group) from which to have the aliases removed.</p>
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::DeleteAlias::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::DeleteAlias::set_alias): <p>The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed into single entries (the list is transformed into a set).</p>
    /// - On success, responds with [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)

    /// - On failure, responds with [`SdkError<DeleteAliasError>`](crate::error::DeleteAliasError)
    pub fn delete_alias(&self) -> fluent_builders::DeleteAlias {
        fluent_builders::DeleteAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEmailMonitoringConfiguration`](crate::client::fluent_builders::DeleteEmailMonitoringConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEmailMonitoringConfiguration::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteEmailMonitoringConfiguration::set_organization_id): <p>The ID of the organization from which the email monitoring configuration is deleted.</p>
    /// - On success, responds with [`DeleteEmailMonitoringConfigurationOutput`](crate::output::DeleteEmailMonitoringConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteEmailMonitoringConfigurationError>`](crate::error::DeleteEmailMonitoringConfigurationError)
    pub fn delete_email_monitoring_configuration(
        &self,
    ) -> fluent_builders::DeleteEmailMonitoringConfiguration {
        fluent_builders::DeleteEmailMonitoringConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_organization_id): <p>The organization that contains the group.</p>
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_group_id): <p>The identifier of the group to be deleted.</p>
    /// - On success, responds with [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteGroupError>`](crate::error::DeleteGroupError)
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMailboxPermissions`](crate::client::fluent_builders::DeleteMailboxPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMailboxPermissions::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteMailboxPermissions::set_organization_id): <p>The identifier of the organization under which the member (user or group) exists.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMailboxPermissions::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::DeleteMailboxPermissions::set_entity_id): <p>The identifier of the member (user or group) that owns the mailbox.</p>
    ///   - [`grantee_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMailboxPermissions::grantee_id) / [`set_grantee_id(Option<String>)`](crate::client::fluent_builders::DeleteMailboxPermissions::set_grantee_id): <p>The identifier of the member (user or group) for which to delete granted permissions.</p>
    /// - On success, responds with [`DeleteMailboxPermissionsOutput`](crate::output::DeleteMailboxPermissionsOutput)

    /// - On failure, responds with [`SdkError<DeleteMailboxPermissionsError>`](crate::error::DeleteMailboxPermissionsError)
    pub fn delete_mailbox_permissions(&self) -> fluent_builders::DeleteMailboxPermissions {
        fluent_builders::DeleteMailboxPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMobileDeviceAccessOverride`](crate::client::fluent_builders::DeleteMobileDeviceAccessOverride) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMobileDeviceAccessOverride::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteMobileDeviceAccessOverride::set_organization_id): <p>The Amazon WorkMail organization for which the access override will be deleted.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMobileDeviceAccessOverride::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DeleteMobileDeviceAccessOverride::set_user_id): <p>The WorkMail user for which you want to delete the override. Accepts the following types of user identities:</p>  <ul>   <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>   <li> <p>Email address: <code>user@domain.tld</code> </p> </li>   <li> <p>User name: <code>user</code> </p> </li>  </ul>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMobileDeviceAccessOverride::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::DeleteMobileDeviceAccessOverride::set_device_id): <p>The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.</p>
    /// - On success, responds with [`DeleteMobileDeviceAccessOverrideOutput`](crate::output::DeleteMobileDeviceAccessOverrideOutput)

    /// - On failure, responds with [`SdkError<DeleteMobileDeviceAccessOverrideError>`](crate::error::DeleteMobileDeviceAccessOverrideError)
    pub fn delete_mobile_device_access_override(
        &self,
    ) -> fluent_builders::DeleteMobileDeviceAccessOverride {
        fluent_builders::DeleteMobileDeviceAccessOverride::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMobileDeviceAccessRule`](crate::client::fluent_builders::DeleteMobileDeviceAccessRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMobileDeviceAccessRule::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteMobileDeviceAccessRule::set_organization_id): <p>The Amazon WorkMail organization under which the rule will be deleted.</p>
    ///   - [`mobile_device_access_rule_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMobileDeviceAccessRule::mobile_device_access_rule_id) / [`set_mobile_device_access_rule_id(Option<String>)`](crate::client::fluent_builders::DeleteMobileDeviceAccessRule::set_mobile_device_access_rule_id): <p>The identifier of the rule to be deleted.</p>
    /// - On success, responds with [`DeleteMobileDeviceAccessRuleOutput`](crate::output::DeleteMobileDeviceAccessRuleOutput)

    /// - On failure, responds with [`SdkError<DeleteMobileDeviceAccessRuleError>`](crate::error::DeleteMobileDeviceAccessRuleError)
    pub fn delete_mobile_device_access_rule(
        &self,
    ) -> fluent_builders::DeleteMobileDeviceAccessRule {
        fluent_builders::DeleteMobileDeviceAccessRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOrganization`](crate::client::fluent_builders::DeleteOrganization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteOrganization::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteOrganization::set_client_token): <p>The idempotency token associated with the request.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteOrganization::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteOrganization::set_organization_id): <p>The organization ID.</p>
    ///   - [`delete_directory(bool)`](crate::client::fluent_builders::DeleteOrganization::delete_directory) / [`set_delete_directory(bool)`](crate::client::fluent_builders::DeleteOrganization::set_delete_directory): <p>If true, deletes the AWS Directory Service directory associated with the organization.</p>
    /// - On success, responds with [`DeleteOrganizationOutput`](crate::output::DeleteOrganizationOutput) with field(s):
    ///   - [`organization_id(Option<String>)`](crate::output::DeleteOrganizationOutput::organization_id): <p>The organization ID.</p>
    ///   - [`state(Option<String>)`](crate::output::DeleteOrganizationOutput::state): <p>The state of the organization.</p>
    /// - On failure, responds with [`SdkError<DeleteOrganizationError>`](crate::error::DeleteOrganizationError)
    pub fn delete_organization(&self) -> fluent_builders::DeleteOrganization {
        fluent_builders::DeleteOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResource`](crate::client::fluent_builders::DeleteResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResource::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteResource::set_organization_id): <p>The identifier associated with the organization from which the resource is deleted.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteResource::set_resource_id): <p>The identifier of the resource to be deleted.</p>
    /// - On success, responds with [`DeleteResourceOutput`](crate::output::DeleteResourceOutput)

    /// - On failure, responds with [`SdkError<DeleteResourceError>`](crate::error::DeleteResourceError)
    pub fn delete_resource(&self) -> fluent_builders::DeleteResource {
        fluent_builders::DeleteResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRetentionPolicy`](crate::client::fluent_builders::DeleteRetentionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRetentionPolicy::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteRetentionPolicy::set_organization_id): <p>The organization ID.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteRetentionPolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteRetentionPolicy::set_id): <p>The retention policy ID.</p>
    /// - On success, responds with [`DeleteRetentionPolicyOutput`](crate::output::DeleteRetentionPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteRetentionPolicyError>`](crate::error::DeleteRetentionPolicyError)
    pub fn delete_retention_policy(&self) -> fluent_builders::DeleteRetentionPolicy {
        fluent_builders::DeleteRetentionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUser`](crate::client::fluent_builders::DeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_organization_id): <p>The organization that contains the user to be deleted.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_user_id): <p>The identifier of the user to be deleted.</p>
    /// - On success, responds with [`DeleteUserOutput`](crate::output::DeleteUserOutput)

    /// - On failure, responds with [`SdkError<DeleteUserError>`](crate::error::DeleteUserError)
    pub fn delete_user(&self) -> fluent_builders::DeleteUser {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterFromWorkMail`](crate::client::fluent_builders::DeregisterFromWorkMail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterFromWorkMail::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeregisterFromWorkMail::set_organization_id): <p>The identifier for the organization under which the Amazon WorkMail entity exists.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterFromWorkMail::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::DeregisterFromWorkMail::set_entity_id): <p>The identifier for the member (user or group) to be updated.</p>
    /// - On success, responds with [`DeregisterFromWorkMailOutput`](crate::output::DeregisterFromWorkMailOutput)

    /// - On failure, responds with [`SdkError<DeregisterFromWorkMailError>`](crate::error::DeregisterFromWorkMailError)
    pub fn deregister_from_work_mail(&self) -> fluent_builders::DeregisterFromWorkMail {
        fluent_builders::DeregisterFromWorkMail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterMailDomain`](crate::client::fluent_builders::DeregisterMailDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterMailDomain::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeregisterMailDomain::set_organization_id): <p>The Amazon WorkMail organization for which the domain will be deregistered.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeregisterMailDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeregisterMailDomain::set_domain_name): <p>The domain to deregister in WorkMail and SES. </p>
    /// - On success, responds with [`DeregisterMailDomainOutput`](crate::output::DeregisterMailDomainOutput)

    /// - On failure, responds with [`SdkError<DeregisterMailDomainError>`](crate::error::DeregisterMailDomainError)
    pub fn deregister_mail_domain(&self) -> fluent_builders::DeregisterMailDomain {
        fluent_builders::DeregisterMailDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEmailMonitoringConfiguration`](crate::client::fluent_builders::DescribeEmailMonitoringConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEmailMonitoringConfiguration::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeEmailMonitoringConfiguration::set_organization_id): <p>The ID of the organization for which the email monitoring configuration is described.</p>
    /// - On success, responds with [`DescribeEmailMonitoringConfigurationOutput`](crate::output::DescribeEmailMonitoringConfigurationOutput) with field(s):
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeEmailMonitoringConfigurationOutput::role_arn): <p>The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.</p>
    ///   - [`log_group_arn(Option<String>)`](crate::output::DescribeEmailMonitoringConfigurationOutput::log_group_arn): <p>The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.</p>
    /// - On failure, responds with [`SdkError<DescribeEmailMonitoringConfigurationError>`](crate::error::DescribeEmailMonitoringConfigurationError)
    pub fn describe_email_monitoring_configuration(
        &self,
    ) -> fluent_builders::DescribeEmailMonitoringConfiguration {
        fluent_builders::DescribeEmailMonitoringConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGroup`](crate::client::fluent_builders::DescribeGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeGroup::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeGroup::set_organization_id): <p>The identifier for the organization under which the group exists.</p>
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::DescribeGroup::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::DescribeGroup::set_group_id): <p>The identifier for the group to be described.</p>
    /// - On success, responds with [`DescribeGroupOutput`](crate::output::DescribeGroupOutput) with field(s):
    ///   - [`group_id(Option<String>)`](crate::output::DescribeGroupOutput::group_id): <p>The identifier of the described group.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeGroupOutput::name): <p>The name of the described group.</p>
    ///   - [`email(Option<String>)`](crate::output::DescribeGroupOutput::email): <p>The email of the described group.</p>
    ///   - [`state(Option<EntityState>)`](crate::output::DescribeGroupOutput::state): <p>The state of the user: enabled (registered to Amazon WorkMail) or disabled (deregistered or never registered to WorkMail).</p>
    ///   - [`enabled_date(Option<DateTime>)`](crate::output::DescribeGroupOutput::enabled_date): <p>The date and time when a user was registered to WorkMail, in UNIX epoch time format.</p>
    ///   - [`disabled_date(Option<DateTime>)`](crate::output::DescribeGroupOutput::disabled_date): <p>The date and time when a user was deregistered from WorkMail, in UNIX epoch time format.</p>
    /// - On failure, responds with [`SdkError<DescribeGroupError>`](crate::error::DescribeGroupError)
    pub fn describe_group(&self) -> fluent_builders::DescribeGroup {
        fluent_builders::DescribeGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInboundDmarcSettings`](crate::client::fluent_builders::DescribeInboundDmarcSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInboundDmarcSettings::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeInboundDmarcSettings::set_organization_id): <p>Lists the ID of the given organization.</p>
    /// - On success, responds with [`DescribeInboundDmarcSettingsOutput`](crate::output::DescribeInboundDmarcSettingsOutput) with field(s):
    ///   - [`enforced(bool)`](crate::output::DescribeInboundDmarcSettingsOutput::enforced): <p>Lists the enforcement setting of the applied policy.</p>
    /// - On failure, responds with [`SdkError<DescribeInboundDmarcSettingsError>`](crate::error::DescribeInboundDmarcSettingsError)
    pub fn describe_inbound_dmarc_settings(&self) -> fluent_builders::DescribeInboundDmarcSettings {
        fluent_builders::DescribeInboundDmarcSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMailboxExportJob`](crate::client::fluent_builders::DescribeMailboxExportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMailboxExportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeMailboxExportJob::set_job_id): <p>The mailbox export job ID.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMailboxExportJob::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeMailboxExportJob::set_organization_id): <p>The organization ID.</p>
    /// - On success, responds with [`DescribeMailboxExportJobOutput`](crate::output::DescribeMailboxExportJobOutput) with field(s):
    ///   - [`entity_id(Option<String>)`](crate::output::DescribeMailboxExportJobOutput::entity_id): <p>The identifier of the user or resource associated with the mailbox.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeMailboxExportJobOutput::description): <p>The mailbox export job description.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeMailboxExportJobOutput::role_arn): <p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the Amazon Simple Storage Service (Amazon S3) bucket.</p>
    ///   - [`kms_key_arn(Option<String>)`](crate::output::DescribeMailboxExportJobOutput::kms_key_arn): <p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.</p>
    ///   - [`s3_bucket_name(Option<String>)`](crate::output::DescribeMailboxExportJobOutput::s3_bucket_name): <p>The name of the S3 bucket.</p>
    ///   - [`s3_prefix(Option<String>)`](crate::output::DescribeMailboxExportJobOutput::s3_prefix): <p>The S3 bucket prefix.</p>
    ///   - [`s3_path(Option<String>)`](crate::output::DescribeMailboxExportJobOutput::s3_path): <p>The path to the S3 bucket and file that the mailbox export job is exporting to.</p>
    ///   - [`estimated_progress(i32)`](crate::output::DescribeMailboxExportJobOutput::estimated_progress): <p>The estimated progress of the mailbox export job, in percentage points.</p>
    ///   - [`state(Option<MailboxExportJobState>)`](crate::output::DescribeMailboxExportJobOutput::state): <p>The state of the mailbox export job.</p>
    ///   - [`error_info(Option<String>)`](crate::output::DescribeMailboxExportJobOutput::error_info): <p>Error information for failed mailbox export jobs.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::DescribeMailboxExportJobOutput::start_time): <p>The mailbox export job start timestamp.</p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::DescribeMailboxExportJobOutput::end_time): <p>The mailbox export job end timestamp.</p>
    /// - On failure, responds with [`SdkError<DescribeMailboxExportJobError>`](crate::error::DescribeMailboxExportJobError)
    pub fn describe_mailbox_export_job(&self) -> fluent_builders::DescribeMailboxExportJob {
        fluent_builders::DescribeMailboxExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrganization`](crate::client::fluent_builders::DescribeOrganization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeOrganization::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeOrganization::set_organization_id): <p>The identifier for the organization to be described.</p>
    /// - On success, responds with [`DescribeOrganizationOutput`](crate::output::DescribeOrganizationOutput) with field(s):
    ///   - [`organization_id(Option<String>)`](crate::output::DescribeOrganizationOutput::organization_id): <p>The identifier of an organization.</p>
    ///   - [`alias(Option<String>)`](crate::output::DescribeOrganizationOutput::alias): <p>The alias for an organization.</p>
    ///   - [`state(Option<String>)`](crate::output::DescribeOrganizationOutput::state): <p>The state of an organization.</p>
    ///   - [`directory_id(Option<String>)`](crate::output::DescribeOrganizationOutput::directory_id): <p>The identifier for the directory associated with an Amazon WorkMail organization.</p>
    ///   - [`directory_type(Option<String>)`](crate::output::DescribeOrganizationOutput::directory_type): <p>The type of directory associated with the WorkMail organization.</p>
    ///   - [`default_mail_domain(Option<String>)`](crate::output::DescribeOrganizationOutput::default_mail_domain): <p>The default mail domain associated with the organization.</p>
    ///   - [`completed_date(Option<DateTime>)`](crate::output::DescribeOrganizationOutput::completed_date): <p>The date at which the organization became usable in the WorkMail context, in UNIX epoch time format.</p>
    ///   - [`error_message(Option<String>)`](crate::output::DescribeOrganizationOutput::error_message): <p>(Optional) The error message indicating if unexpected behavior was encountered with regards to the organization.</p>
    ///   - [`arn(Option<String>)`](crate::output::DescribeOrganizationOutput::arn): <p>The Amazon Resource Name (ARN) of the organization.</p>
    /// - On failure, responds with [`SdkError<DescribeOrganizationError>`](crate::error::DescribeOrganizationError)
    pub fn describe_organization(&self) -> fluent_builders::DescribeOrganization {
        fluent_builders::DescribeOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResource`](crate::client::fluent_builders::DescribeResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeResource::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeResource::set_organization_id): <p>The identifier associated with the organization for which the resource is described.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DescribeResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DescribeResource::set_resource_id): <p>The identifier of the resource to be described.</p>
    /// - On success, responds with [`DescribeResourceOutput`](crate::output::DescribeResourceOutput) with field(s):
    ///   - [`resource_id(Option<String>)`](crate::output::DescribeResourceOutput::resource_id): <p>The identifier of the described resource.</p>
    ///   - [`email(Option<String>)`](crate::output::DescribeResourceOutput::email): <p>The email of the described resource.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeResourceOutput::name): <p>The name of the described resource.</p>
    ///   - [`r#type(Option<ResourceType>)`](crate::output::DescribeResourceOutput::type): <p>The type of the described resource.</p>
    ///   - [`booking_options(Option<BookingOptions>)`](crate::output::DescribeResourceOutput::booking_options): <p>The booking options for the described resource.</p>
    ///   - [`state(Option<EntityState>)`](crate::output::DescribeResourceOutput::state): <p>The state of the resource: enabled (registered to Amazon WorkMail), disabled (deregistered or never registered to WorkMail), or deleted.</p>
    ///   - [`enabled_date(Option<DateTime>)`](crate::output::DescribeResourceOutput::enabled_date): <p>The date and time when a resource was enabled for WorkMail, in UNIX epoch time format.</p>
    ///   - [`disabled_date(Option<DateTime>)`](crate::output::DescribeResourceOutput::disabled_date): <p>The date and time when a resource was disabled from WorkMail, in UNIX epoch time format.</p>
    /// - On failure, responds with [`SdkError<DescribeResourceError>`](crate::error::DescribeResourceError)
    pub fn describe_resource(&self) -> fluent_builders::DescribeResource {
        fluent_builders::DescribeResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUser`](crate::client::fluent_builders::DescribeUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_organization_id): <p>The identifier for the organization under which the user exists.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_user_id): <p>The identifier for the user to be described.</p>
    /// - On success, responds with [`DescribeUserOutput`](crate::output::DescribeUserOutput) with field(s):
    ///   - [`user_id(Option<String>)`](crate::output::DescribeUserOutput::user_id): <p>The identifier for the described user.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeUserOutput::name): <p>The name for the user.</p>
    ///   - [`email(Option<String>)`](crate::output::DescribeUserOutput::email): <p>The email of the user.</p>
    ///   - [`display_name(Option<String>)`](crate::output::DescribeUserOutput::display_name): <p>The display name of the user.</p>
    ///   - [`state(Option<EntityState>)`](crate::output::DescribeUserOutput::state): <p>The state of a user: enabled (registered to Amazon WorkMail) or disabled (deregistered or never registered to WorkMail).</p>
    ///   - [`user_role(Option<UserRole>)`](crate::output::DescribeUserOutput::user_role): <p>In certain cases, other entities are modeled as users. If interoperability is enabled, resources are imported into Amazon WorkMail as users. Because different WorkMail organizations rely on different directory types, administrators can distinguish between an unregistered user (account is disabled and has a user role) and the directory administrators. The values are USER, RESOURCE, and SYSTEM_USER.</p>
    ///   - [`enabled_date(Option<DateTime>)`](crate::output::DescribeUserOutput::enabled_date): <p>The date and time at which the user was enabled for Amazon WorkMail usage, in UNIX epoch time format.</p>
    ///   - [`disabled_date(Option<DateTime>)`](crate::output::DescribeUserOutput::disabled_date): <p>The date and time at which the user was disabled for Amazon WorkMail usage, in UNIX epoch time format.</p>
    /// - On failure, responds with [`SdkError<DescribeUserError>`](crate::error::DescribeUserError)
    pub fn describe_user(&self) -> fluent_builders::DescribeUser {
        fluent_builders::DescribeUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateDelegateFromResource`](crate::client::fluent_builders::DisassociateDelegateFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateDelegateFromResource::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DisassociateDelegateFromResource::set_organization_id): <p>The identifier for the organization under which the resource exists.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateDelegateFromResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DisassociateDelegateFromResource::set_resource_id): <p>The identifier of the resource from which delegates' set members are removed. </p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateDelegateFromResource::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::DisassociateDelegateFromResource::set_entity_id): <p>The identifier for the member (user, group) to be removed from the resource's delegates.</p>
    /// - On success, responds with [`DisassociateDelegateFromResourceOutput`](crate::output::DisassociateDelegateFromResourceOutput)

    /// - On failure, responds with [`SdkError<DisassociateDelegateFromResourceError>`](crate::error::DisassociateDelegateFromResourceError)
    pub fn disassociate_delegate_from_resource(
        &self,
    ) -> fluent_builders::DisassociateDelegateFromResource {
        fluent_builders::DisassociateDelegateFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateMemberFromGroup`](crate::client::fluent_builders::DisassociateMemberFromGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateMemberFromGroup::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DisassociateMemberFromGroup::set_organization_id): <p>The identifier for the organization under which the group exists.</p>
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateMemberFromGroup::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::DisassociateMemberFromGroup::set_group_id): <p>The identifier for the group from which members are removed.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateMemberFromGroup::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::DisassociateMemberFromGroup::set_member_id): <p>The identifier for the member to be removed to the group.</p>
    /// - On success, responds with [`DisassociateMemberFromGroupOutput`](crate::output::DisassociateMemberFromGroupOutput)

    /// - On failure, responds with [`SdkError<DisassociateMemberFromGroupError>`](crate::error::DisassociateMemberFromGroupError)
    pub fn disassociate_member_from_group(&self) -> fluent_builders::DisassociateMemberFromGroup {
        fluent_builders::DisassociateMemberFromGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccessControlEffect`](crate::client::fluent_builders::GetAccessControlEffect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::GetAccessControlEffect::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::GetAccessControlEffect::set_organization_id): <p>The identifier for the organization.</p>
    ///   - [`ip_address(impl Into<String>)`](crate::client::fluent_builders::GetAccessControlEffect::ip_address) / [`set_ip_address(Option<String>)`](crate::client::fluent_builders::GetAccessControlEffect::set_ip_address): <p>The IPv4 address.</p>
    ///   - [`action(impl Into<String>)`](crate::client::fluent_builders::GetAccessControlEffect::action) / [`set_action(Option<String>)`](crate::client::fluent_builders::GetAccessControlEffect::set_action): <p>The access protocol action. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::GetAccessControlEffect::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::GetAccessControlEffect::set_user_id): <p>The user ID.</p>
    /// - On success, responds with [`GetAccessControlEffectOutput`](crate::output::GetAccessControlEffectOutput) with field(s):
    ///   - [`effect(Option<AccessControlRuleEffect>)`](crate::output::GetAccessControlEffectOutput::effect): <p>The rule effect.</p>
    ///   - [`matched_rules(Option<Vec<String>>)`](crate::output::GetAccessControlEffectOutput::matched_rules): <p>The rules that match the given parameters, resulting in an effect.</p>
    /// - On failure, responds with [`SdkError<GetAccessControlEffectError>`](crate::error::GetAccessControlEffectError)
    pub fn get_access_control_effect(&self) -> fluent_builders::GetAccessControlEffect {
        fluent_builders::GetAccessControlEffect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDefaultRetentionPolicy`](crate::client::fluent_builders::GetDefaultRetentionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::GetDefaultRetentionPolicy::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::GetDefaultRetentionPolicy::set_organization_id): <p>The organization ID.</p>
    /// - On success, responds with [`GetDefaultRetentionPolicyOutput`](crate::output::GetDefaultRetentionPolicyOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetDefaultRetentionPolicyOutput::id): <p>The retention policy ID.</p>
    ///   - [`name(Option<String>)`](crate::output::GetDefaultRetentionPolicyOutput::name): <p>The retention policy name.</p>
    ///   - [`description(Option<String>)`](crate::output::GetDefaultRetentionPolicyOutput::description): <p>The retention policy description.</p>
    ///   - [`folder_configurations(Option<Vec<FolderConfiguration>>)`](crate::output::GetDefaultRetentionPolicyOutput::folder_configurations): <p>The retention policy folder configurations.</p>
    /// - On failure, responds with [`SdkError<GetDefaultRetentionPolicyError>`](crate::error::GetDefaultRetentionPolicyError)
    pub fn get_default_retention_policy(&self) -> fluent_builders::GetDefaultRetentionPolicy {
        fluent_builders::GetDefaultRetentionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMailboxDetails`](crate::client::fluent_builders::GetMailboxDetails) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::GetMailboxDetails::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::GetMailboxDetails::set_organization_id): <p>The identifier for the organization that contains the user whose mailbox details are being requested.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::GetMailboxDetails::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::GetMailboxDetails::set_user_id): <p>The identifier for the user whose mailbox details are being requested.</p>
    /// - On success, responds with [`GetMailboxDetailsOutput`](crate::output::GetMailboxDetailsOutput) with field(s):
    ///   - [`mailbox_quota(Option<i32>)`](crate::output::GetMailboxDetailsOutput::mailbox_quota): <p>The maximum allowed mailbox size, in MB, for the specified user.</p>
    ///   - [`mailbox_size(f64)`](crate::output::GetMailboxDetailsOutput::mailbox_size): <p>The current mailbox size, in MB, for the specified user.</p>
    /// - On failure, responds with [`SdkError<GetMailboxDetailsError>`](crate::error::GetMailboxDetailsError)
    pub fn get_mailbox_details(&self) -> fluent_builders::GetMailboxDetails {
        fluent_builders::GetMailboxDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMailDomain`](crate::client::fluent_builders::GetMailDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::GetMailDomain::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::GetMailDomain::set_organization_id): <p>The Amazon WorkMail organization for which the domain is retrieved.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetMailDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetMailDomain::set_domain_name): <p>The domain from which you want to retrieve details.</p>
    /// - On success, responds with [`GetMailDomainOutput`](crate::output::GetMailDomainOutput) with field(s):
    ///   - [`records(Option<Vec<DnsRecord>>)`](crate::output::GetMailDomainOutput::records): <p>A list of the DNS records that Amazon WorkMail recommends adding in your DNS provider for the best user experience. The records configure your domain with DMARC, SPF, DKIM, and direct incoming email traffic to SES. See admin guide for more details.</p>
    ///   - [`is_test_domain(bool)`](crate::output::GetMailDomainOutput::is_test_domain): <p>Specifies whether the domain is a test domain provided by WorkMail, or a custom domain.</p>
    ///   - [`is_default(bool)`](crate::output::GetMailDomainOutput::is_default): <p>Specifies whether the domain is the default domain for your organization.</p>
    ///   - [`ownership_verification_status(Option<DnsRecordVerificationStatus>)`](crate::output::GetMailDomainOutput::ownership_verification_status): <p> Indicates the status of the domain ownership verification.</p>
    ///   - [`dkim_verification_status(Option<DnsRecordVerificationStatus>)`](crate::output::GetMailDomainOutput::dkim_verification_status): <p>Indicates the status of a DKIM verification.</p>
    /// - On failure, responds with [`SdkError<GetMailDomainError>`](crate::error::GetMailDomainError)
    pub fn get_mail_domain(&self) -> fluent_builders::GetMailDomain {
        fluent_builders::GetMailDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMobileDeviceAccessEffect`](crate::client::fluent_builders::GetMobileDeviceAccessEffect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessEffect::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessEffect::set_organization_id): <p>The Amazon WorkMail organization to simulate the access effect for.</p>
    ///   - [`device_type(impl Into<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessEffect::device_type) / [`set_device_type(Option<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessEffect::set_device_type): <p>Device type the simulated user will report.</p>
    ///   - [`device_model(impl Into<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessEffect::device_model) / [`set_device_model(Option<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessEffect::set_device_model): <p>Device model the simulated user will report.</p>
    ///   - [`device_operating_system(impl Into<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessEffect::device_operating_system) / [`set_device_operating_system(Option<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessEffect::set_device_operating_system): <p>Device operating system the simulated user will report.</p>
    ///   - [`device_user_agent(impl Into<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessEffect::device_user_agent) / [`set_device_user_agent(Option<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessEffect::set_device_user_agent): <p>Device user agent the simulated user will report.</p>
    /// - On success, responds with [`GetMobileDeviceAccessEffectOutput`](crate::output::GetMobileDeviceAccessEffectOutput) with field(s):
    ///   - [`effect(Option<MobileDeviceAccessRuleEffect>)`](crate::output::GetMobileDeviceAccessEffectOutput::effect): <p>The effect of the simulated access, <code>ALLOW</code> or <code>DENY</code>, after evaluating mobile device access rules in the Amazon WorkMail organization for the simulated user parameters.</p>
    ///   - [`matched_rules(Option<Vec<MobileDeviceAccessMatchedRule>>)`](crate::output::GetMobileDeviceAccessEffectOutput::matched_rules): <p>A list of the rules which matched the simulated user input and produced the effect.</p>
    /// - On failure, responds with [`SdkError<GetMobileDeviceAccessEffectError>`](crate::error::GetMobileDeviceAccessEffectError)
    pub fn get_mobile_device_access_effect(&self) -> fluent_builders::GetMobileDeviceAccessEffect {
        fluent_builders::GetMobileDeviceAccessEffect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMobileDeviceAccessOverride`](crate::client::fluent_builders::GetMobileDeviceAccessOverride) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessOverride::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessOverride::set_organization_id): <p>The Amazon WorkMail organization to which you want to apply the override.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessOverride::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessOverride::set_user_id): <p>Identifies the WorkMail user for the override. Accepts the following types of user identities: </p>  <ul>   <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>   <li> <p>Email address: <code>user@domain.tld</code> </p> </li>   <li> <p>User name: <code>user</code> </p> </li>  </ul>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessOverride::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::GetMobileDeviceAccessOverride::set_device_id): <p>The mobile device to which the override applies. <code>DeviceId</code> is case insensitive.</p>
    /// - On success, responds with [`GetMobileDeviceAccessOverrideOutput`](crate::output::GetMobileDeviceAccessOverrideOutput) with field(s):
    ///   - [`user_id(Option<String>)`](crate::output::GetMobileDeviceAccessOverrideOutput::user_id): <p>The WorkMail user to which the access override applies.</p>
    ///   - [`device_id(Option<String>)`](crate::output::GetMobileDeviceAccessOverrideOutput::device_id): <p>The device to which the access override applies.</p>
    ///   - [`effect(Option<MobileDeviceAccessRuleEffect>)`](crate::output::GetMobileDeviceAccessOverrideOutput::effect): <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
    ///   - [`description(Option<String>)`](crate::output::GetMobileDeviceAccessOverrideOutput::description): <p>A description of the override.</p>
    ///   - [`date_created(Option<DateTime>)`](crate::output::GetMobileDeviceAccessOverrideOutput::date_created): <p>The date the override was first created.</p>
    ///   - [`date_modified(Option<DateTime>)`](crate::output::GetMobileDeviceAccessOverrideOutput::date_modified): <p>The date the description was last modified.</p>
    /// - On failure, responds with [`SdkError<GetMobileDeviceAccessOverrideError>`](crate::error::GetMobileDeviceAccessOverrideError)
    pub fn get_mobile_device_access_override(
        &self,
    ) -> fluent_builders::GetMobileDeviceAccessOverride {
        fluent_builders::GetMobileDeviceAccessOverride::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccessControlRules`](crate::client::fluent_builders::ListAccessControlRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListAccessControlRules::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListAccessControlRules::set_organization_id): <p>The identifier for the organization.</p>
    /// - On success, responds with [`ListAccessControlRulesOutput`](crate::output::ListAccessControlRulesOutput) with field(s):
    ///   - [`rules(Option<Vec<AccessControlRule>>)`](crate::output::ListAccessControlRulesOutput::rules): <p>The access control rules.</p>
    /// - On failure, responds with [`SdkError<ListAccessControlRulesError>`](crate::error::ListAccessControlRulesError)
    pub fn list_access_control_rules(&self) -> fluent_builders::ListAccessControlRules {
        fluent_builders::ListAccessControlRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAliases`](crate::client::fluent_builders::ListAliases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAliases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListAliases::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListAliases::set_organization_id): <p>The identifier for the organization under which the entity exists.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::ListAliases::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::ListAliases::set_entity_id): <p>The identifier for the entity for which to list the aliases.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAliases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAliases::set_next_token): <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAliases::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAliases::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListAliasesOutput`](crate::output::ListAliasesOutput) with field(s):
    ///   - [`aliases(Option<Vec<String>>)`](crate::output::ListAliasesOutput::aliases): <p>The entity's paginated aliases.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAliasesOutput::next_token): <p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListAliasesError>`](crate::error::ListAliasesError)
    pub fn list_aliases(&self) -> fluent_builders::ListAliases {
        fluent_builders::ListAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGroupMembers`](crate::client::fluent_builders::ListGroupMembers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGroupMembers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListGroupMembers::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListGroupMembers::set_organization_id): <p>The identifier for the organization under which the group exists.</p>
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::ListGroupMembers::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::ListGroupMembers::set_group_id): <p>The identifier for the group to which the members (users or groups) are associated.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGroupMembers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGroupMembers::set_next_token): <p> The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGroupMembers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGroupMembers::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListGroupMembersOutput`](crate::output::ListGroupMembersOutput) with field(s):
    ///   - [`members(Option<Vec<Member>>)`](crate::output::ListGroupMembersOutput::members): <p>The members associated to the group.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGroupMembersOutput::next_token): <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    /// - On failure, responds with [`SdkError<ListGroupMembersError>`](crate::error::ListGroupMembersError)
    pub fn list_group_members(&self) -> fluent_builders::ListGroupMembers {
        fluent_builders::ListGroupMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGroups`](crate::client::fluent_builders::ListGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListGroups::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListGroups::set_organization_id): <p>The identifier for the organization under which the groups exist.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGroups::set_next_token): <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGroups::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListGroupsOutput`](crate::output::ListGroupsOutput) with field(s):
    ///   - [`groups(Option<Vec<Group>>)`](crate::output::ListGroupsOutput::groups): <p>The overview of groups for an organization.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGroupsOutput::next_token): <p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListGroupsError>`](crate::error::ListGroupsError)
    pub fn list_groups(&self) -> fluent_builders::ListGroups {
        fluent_builders::ListGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMailboxExportJobs`](crate::client::fluent_builders::ListMailboxExportJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMailboxExportJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListMailboxExportJobs::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListMailboxExportJobs::set_organization_id): <p>The organization ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMailboxExportJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMailboxExportJobs::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMailboxExportJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMailboxExportJobs::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListMailboxExportJobsOutput`](crate::output::ListMailboxExportJobsOutput) with field(s):
    ///   - [`jobs(Option<Vec<MailboxExportJob>>)`](crate::output::ListMailboxExportJobsOutput::jobs): <p>The mailbox export job details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMailboxExportJobsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListMailboxExportJobsError>`](crate::error::ListMailboxExportJobsError)
    pub fn list_mailbox_export_jobs(&self) -> fluent_builders::ListMailboxExportJobs {
        fluent_builders::ListMailboxExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMailboxPermissions`](crate::client::fluent_builders::ListMailboxPermissions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMailboxPermissions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListMailboxPermissions::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListMailboxPermissions::set_organization_id): <p>The identifier of the organization under which the user, group, or resource exists.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::ListMailboxPermissions::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::ListMailboxPermissions::set_entity_id): <p>The identifier of the user, group, or resource for which to list mailbox permissions.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMailboxPermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMailboxPermissions::set_next_token): <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMailboxPermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMailboxPermissions::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListMailboxPermissionsOutput`](crate::output::ListMailboxPermissionsOutput) with field(s):
    ///   - [`permissions(Option<Vec<Permission>>)`](crate::output::ListMailboxPermissionsOutput::permissions): <p>One page of the user, group, or resource mailbox permissions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMailboxPermissionsOutput::next_token): <p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListMailboxPermissionsError>`](crate::error::ListMailboxPermissionsError)
    pub fn list_mailbox_permissions(&self) -> fluent_builders::ListMailboxPermissions {
        fluent_builders::ListMailboxPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMailDomains`](crate::client::fluent_builders::ListMailDomains) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMailDomains::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListMailDomains::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListMailDomains::set_organization_id): <p>The Amazon WorkMail organization for which to list domains.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMailDomains::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMailDomains::set_max_results): <p>The maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMailDomains::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMailDomains::set_next_token): <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
    /// - On success, responds with [`ListMailDomainsOutput`](crate::output::ListMailDomainsOutput) with field(s):
    ///   - [`mail_domains(Option<Vec<MailDomainSummary>>)`](crate::output::ListMailDomainsOutput::mail_domains): <p>The list of mail domain summaries, specifying domains that exist in the specified Amazon WorkMail organization, along with the information about whether the domain is or isn't the default.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMailDomainsOutput::next_token): <p>The token to use to retrieve the next page of results. The value becomes <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListMailDomainsError>`](crate::error::ListMailDomainsError)
    pub fn list_mail_domains(&self) -> fluent_builders::ListMailDomains {
        fluent_builders::ListMailDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMobileDeviceAccessOverrides`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::set_organization_id): <p>The Amazon WorkMail organization under which to list mobile device access overrides.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::set_user_id): <p>The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:</p>  <ul>   <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>   <li> <p>Email address: <code>user@domain.tld</code> </p> </li>   <li> <p>User name: <code>user</code> </p> </li>  </ul>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::set_device_id): <p>The mobile device to which the access override applies.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::set_next_token): <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListMobileDeviceAccessOverridesOutput`](crate::output::ListMobileDeviceAccessOverridesOutput) with field(s):
    ///   - [`overrides(Option<Vec<MobileDeviceAccessOverride>>)`](crate::output::ListMobileDeviceAccessOverridesOutput::overrides): <p>The list of mobile device access overrides that exist for the specified Amazon WorkMail organization and user.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMobileDeviceAccessOverridesOutput::next_token): <p>The token to use to retrieve the next page of results. The value is “null” when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListMobileDeviceAccessOverridesError>`](crate::error::ListMobileDeviceAccessOverridesError)
    pub fn list_mobile_device_access_overrides(
        &self,
    ) -> fluent_builders::ListMobileDeviceAccessOverrides {
        fluent_builders::ListMobileDeviceAccessOverrides::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMobileDeviceAccessRules`](crate::client::fluent_builders::ListMobileDeviceAccessRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListMobileDeviceAccessRules::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListMobileDeviceAccessRules::set_organization_id): <p>The Amazon WorkMail organization for which to list the rules.</p>
    /// - On success, responds with [`ListMobileDeviceAccessRulesOutput`](crate::output::ListMobileDeviceAccessRulesOutput) with field(s):
    ///   - [`rules(Option<Vec<MobileDeviceAccessRule>>)`](crate::output::ListMobileDeviceAccessRulesOutput::rules): <p>The list of mobile device access rules that exist under the specified Amazon WorkMail organization.</p>
    /// - On failure, responds with [`SdkError<ListMobileDeviceAccessRulesError>`](crate::error::ListMobileDeviceAccessRulesError)
    pub fn list_mobile_device_access_rules(&self) -> fluent_builders::ListMobileDeviceAccessRules {
        fluent_builders::ListMobileDeviceAccessRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOrganizations`](crate::client::fluent_builders::ListOrganizations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOrganizations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOrganizations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOrganizations::set_next_token): <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOrganizations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOrganizations::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListOrganizationsOutput`](crate::output::ListOrganizationsOutput) with field(s):
    ///   - [`organization_summaries(Option<Vec<OrganizationSummary>>)`](crate::output::ListOrganizationsOutput::organization_summaries): <p>The overview of owned organizations presented as a list of organization summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOrganizationsOutput::next_token): <p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListOrganizationsError>`](crate::error::ListOrganizationsError)
    pub fn list_organizations(&self) -> fluent_builders::ListOrganizations {
        fluent_builders::ListOrganizations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceDelegates`](crate::client::fluent_builders::ListResourceDelegates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourceDelegates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListResourceDelegates::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListResourceDelegates::set_organization_id): <p>The identifier for the organization that contains the resource for which delegates are listed.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ListResourceDelegates::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ListResourceDelegates::set_resource_id): <p>The identifier for the resource whose delegates are listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourceDelegates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourceDelegates::set_next_token): <p>The token used to paginate through the delegates associated with a resource.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourceDelegates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResourceDelegates::set_max_results): <p>The number of maximum results in a page.</p>
    /// - On success, responds with [`ListResourceDelegatesOutput`](crate::output::ListResourceDelegatesOutput) with field(s):
    ///   - [`delegates(Option<Vec<Delegate>>)`](crate::output::ListResourceDelegatesOutput::delegates): <p>One page of the resource's delegates.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourceDelegatesOutput::next_token): <p>The token used to paginate through the delegates associated with a resource. While results are still available, it has an associated value. When the last page is reached, the token is empty. </p>
    /// - On failure, responds with [`SdkError<ListResourceDelegatesError>`](crate::error::ListResourceDelegatesError)
    pub fn list_resource_delegates(&self) -> fluent_builders::ListResourceDelegates {
        fluent_builders::ListResourceDelegates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResources`](crate::client::fluent_builders::ListResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListResources::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListResources::set_organization_id): <p>The identifier for the organization under which the resources exist.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResources::set_next_token): <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResources::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListResourcesOutput`](crate::output::ListResourcesOutput) with field(s):
    ///   - [`resources(Option<Vec<Resource>>)`](crate::output::ListResourcesOutput::resources): <p>One page of the organization's resource representation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourcesOutput::next_token): <p> The token used to paginate through all the organization's resources. While results are still available, it has an associated value. When the last page is reached, the token is empty.</p>
    /// - On failure, responds with [`SdkError<ListResourcesError>`](crate::error::ListResourcesError)
    pub fn list_resources(&self) -> fluent_builders::ListResources {
        fluent_builders::ListResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The resource ARN.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tag key-value pairs.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUsers`](crate::client::fluent_builders::ListUsers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUsers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ListUsers::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ListUsers::set_organization_id): <p>The identifier for the organization under which the users exist.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUsers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUsers::set_next_token): <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUsers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUsers::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListUsersOutput`](crate::output::ListUsersOutput) with field(s):
    ///   - [`users(Option<Vec<User>>)`](crate::output::ListUsersOutput::users): <p>The overview of users for an organization.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUsersOutput::next_token): <p> The token to use to retrieve the next page of results. This value is `null` when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListUsersError>`](crate::error::ListUsersError)
    pub fn list_users(&self) -> fluent_builders::ListUsers {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccessControlRule`](crate::client::fluent_builders::PutAccessControlRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutAccessControlRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutAccessControlRule::set_name): <p>The rule name.</p>
    ///   - [`effect(AccessControlRuleEffect)`](crate::client::fluent_builders::PutAccessControlRule::effect) / [`set_effect(Option<AccessControlRuleEffect>)`](crate::client::fluent_builders::PutAccessControlRule::set_effect): <p>The rule effect.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutAccessControlRule::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutAccessControlRule::set_description): <p>The rule description.</p>
    ///   - [`ip_ranges(Vec<String>)`](crate::client::fluent_builders::PutAccessControlRule::ip_ranges) / [`set_ip_ranges(Option<Vec<String>>)`](crate::client::fluent_builders::PutAccessControlRule::set_ip_ranges): <p>IPv4 CIDR ranges to include in the rule.</p>
    ///   - [`not_ip_ranges(Vec<String>)`](crate::client::fluent_builders::PutAccessControlRule::not_ip_ranges) / [`set_not_ip_ranges(Option<Vec<String>>)`](crate::client::fluent_builders::PutAccessControlRule::set_not_ip_ranges): <p>IPv4 CIDR ranges to exclude from the rule.</p>
    ///   - [`actions(Vec<String>)`](crate::client::fluent_builders::PutAccessControlRule::actions) / [`set_actions(Option<Vec<String>>)`](crate::client::fluent_builders::PutAccessControlRule::set_actions): <p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    ///   - [`not_actions(Vec<String>)`](crate::client::fluent_builders::PutAccessControlRule::not_actions) / [`set_not_actions(Option<Vec<String>>)`](crate::client::fluent_builders::PutAccessControlRule::set_not_actions): <p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    ///   - [`user_ids(Vec<String>)`](crate::client::fluent_builders::PutAccessControlRule::user_ids) / [`set_user_ids(Option<Vec<String>>)`](crate::client::fluent_builders::PutAccessControlRule::set_user_ids): <p>User IDs to include in the rule.</p>
    ///   - [`not_user_ids(Vec<String>)`](crate::client::fluent_builders::PutAccessControlRule::not_user_ids) / [`set_not_user_ids(Option<Vec<String>>)`](crate::client::fluent_builders::PutAccessControlRule::set_not_user_ids): <p>User IDs to exclude from the rule.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::PutAccessControlRule::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::PutAccessControlRule::set_organization_id): <p>The identifier of the organization.</p>
    /// - On success, responds with [`PutAccessControlRuleOutput`](crate::output::PutAccessControlRuleOutput)

    /// - On failure, responds with [`SdkError<PutAccessControlRuleError>`](crate::error::PutAccessControlRuleError)
    pub fn put_access_control_rule(&self) -> fluent_builders::PutAccessControlRule {
        fluent_builders::PutAccessControlRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEmailMonitoringConfiguration`](crate::client::fluent_builders::PutEmailMonitoringConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::PutEmailMonitoringConfiguration::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::PutEmailMonitoringConfiguration::set_organization_id): <p>The ID of the organization for which the email monitoring configuration is set.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::PutEmailMonitoringConfiguration::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::PutEmailMonitoringConfiguration::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.</p>
    ///   - [`log_group_arn(impl Into<String>)`](crate::client::fluent_builders::PutEmailMonitoringConfiguration::log_group_arn) / [`set_log_group_arn(Option<String>)`](crate::client::fluent_builders::PutEmailMonitoringConfiguration::set_log_group_arn): <p>The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.</p>
    /// - On success, responds with [`PutEmailMonitoringConfigurationOutput`](crate::output::PutEmailMonitoringConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutEmailMonitoringConfigurationError>`](crate::error::PutEmailMonitoringConfigurationError)
    pub fn put_email_monitoring_configuration(
        &self,
    ) -> fluent_builders::PutEmailMonitoringConfiguration {
        fluent_builders::PutEmailMonitoringConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutInboundDmarcSettings`](crate::client::fluent_builders::PutInboundDmarcSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::PutInboundDmarcSettings::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::PutInboundDmarcSettings::set_organization_id): <p>The ID of the organization that you are applying the DMARC policy to. </p>
    ///   - [`enforced(bool)`](crate::client::fluent_builders::PutInboundDmarcSettings::enforced) / [`set_enforced(Option<bool>)`](crate::client::fluent_builders::PutInboundDmarcSettings::set_enforced): <p>Enforces or suspends a policy after it's applied.</p>
    /// - On success, responds with [`PutInboundDmarcSettingsOutput`](crate::output::PutInboundDmarcSettingsOutput)

    /// - On failure, responds with [`SdkError<PutInboundDmarcSettingsError>`](crate::error::PutInboundDmarcSettingsError)
    pub fn put_inbound_dmarc_settings(&self) -> fluent_builders::PutInboundDmarcSettings {
        fluent_builders::PutInboundDmarcSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutMailboxPermissions`](crate::client::fluent_builders::PutMailboxPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::PutMailboxPermissions::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::PutMailboxPermissions::set_organization_id): <p>The identifier of the organization under which the user, group, or resource exists.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::PutMailboxPermissions::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::PutMailboxPermissions::set_entity_id): <p>The identifier of the user, group, or resource for which to update mailbox permissions.</p>
    ///   - [`grantee_id(impl Into<String>)`](crate::client::fluent_builders::PutMailboxPermissions::grantee_id) / [`set_grantee_id(Option<String>)`](crate::client::fluent_builders::PutMailboxPermissions::set_grantee_id): <p>The identifier of the user, group, or resource to which to grant the permissions.</p>
    ///   - [`permission_values(Vec<PermissionType>)`](crate::client::fluent_builders::PutMailboxPermissions::permission_values) / [`set_permission_values(Option<Vec<PermissionType>>)`](crate::client::fluent_builders::PutMailboxPermissions::set_permission_values): <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>
    /// - On success, responds with [`PutMailboxPermissionsOutput`](crate::output::PutMailboxPermissionsOutput)

    /// - On failure, responds with [`SdkError<PutMailboxPermissionsError>`](crate::error::PutMailboxPermissionsError)
    pub fn put_mailbox_permissions(&self) -> fluent_builders::PutMailboxPermissions {
        fluent_builders::PutMailboxPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutMobileDeviceAccessOverride`](crate::client::fluent_builders::PutMobileDeviceAccessOverride) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::PutMobileDeviceAccessOverride::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::PutMobileDeviceAccessOverride::set_organization_id): <p>Identifies the Amazon WorkMail organization for which you create the override.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::PutMobileDeviceAccessOverride::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::PutMobileDeviceAccessOverride::set_user_id): <p>The WorkMail user for which you create the override. Accepts the following types of user identities:</p>  <ul>   <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>   <li> <p>Email address: <code>user@domain.tld</code> </p> </li>   <li> <p>User name: <code>user</code> </p> </li>  </ul>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::PutMobileDeviceAccessOverride::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::PutMobileDeviceAccessOverride::set_device_id): <p>The mobile device for which you create the override. <code>DeviceId</code> is case insensitive.</p>
    ///   - [`effect(MobileDeviceAccessRuleEffect)`](crate::client::fluent_builders::PutMobileDeviceAccessOverride::effect) / [`set_effect(Option<MobileDeviceAccessRuleEffect>)`](crate::client::fluent_builders::PutMobileDeviceAccessOverride::set_effect): <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutMobileDeviceAccessOverride::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutMobileDeviceAccessOverride::set_description): <p>A description of the override.</p>
    /// - On success, responds with [`PutMobileDeviceAccessOverrideOutput`](crate::output::PutMobileDeviceAccessOverrideOutput)

    /// - On failure, responds with [`SdkError<PutMobileDeviceAccessOverrideError>`](crate::error::PutMobileDeviceAccessOverrideError)
    pub fn put_mobile_device_access_override(
        &self,
    ) -> fluent_builders::PutMobileDeviceAccessOverride {
        fluent_builders::PutMobileDeviceAccessOverride::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRetentionPolicy`](crate::client::fluent_builders::PutRetentionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::PutRetentionPolicy::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::PutRetentionPolicy::set_organization_id): <p>The organization ID.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::PutRetentionPolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::PutRetentionPolicy::set_id): <p>The retention policy ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutRetentionPolicy::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutRetentionPolicy::set_name): <p>The retention policy name.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutRetentionPolicy::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutRetentionPolicy::set_description): <p>The retention policy description.</p>
    ///   - [`folder_configurations(Vec<FolderConfiguration>)`](crate::client::fluent_builders::PutRetentionPolicy::folder_configurations) / [`set_folder_configurations(Option<Vec<FolderConfiguration>>)`](crate::client::fluent_builders::PutRetentionPolicy::set_folder_configurations): <p>The retention policy folder configurations.</p>
    /// - On success, responds with [`PutRetentionPolicyOutput`](crate::output::PutRetentionPolicyOutput)

    /// - On failure, responds with [`SdkError<PutRetentionPolicyError>`](crate::error::PutRetentionPolicyError)
    pub fn put_retention_policy(&self) -> fluent_builders::PutRetentionPolicy {
        fluent_builders::PutRetentionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterMailDomain`](crate::client::fluent_builders::RegisterMailDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::RegisterMailDomain::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::RegisterMailDomain::set_client_token): <p>Idempotency token used when retrying requests.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::RegisterMailDomain::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::RegisterMailDomain::set_organization_id): <p>The Amazon WorkMail organization under which you're creating the domain.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::RegisterMailDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::RegisterMailDomain::set_domain_name): <p>The name of the mail domain to create in Amazon WorkMail and SES.</p>
    /// - On success, responds with [`RegisterMailDomainOutput`](crate::output::RegisterMailDomainOutput)

    /// - On failure, responds with [`SdkError<RegisterMailDomainError>`](crate::error::RegisterMailDomainError)
    pub fn register_mail_domain(&self) -> fluent_builders::RegisterMailDomain {
        fluent_builders::RegisterMailDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterToWorkMail`](crate::client::fluent_builders::RegisterToWorkMail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::RegisterToWorkMail::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::RegisterToWorkMail::set_organization_id): <p>The identifier for the organization under which the user, group, or resource exists.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::RegisterToWorkMail::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::RegisterToWorkMail::set_entity_id): <p>The identifier for the user, group, or resource to be updated.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::RegisterToWorkMail::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::RegisterToWorkMail::set_email): <p>The email for the user, group, or resource to be updated.</p>
    /// - On success, responds with [`RegisterToWorkMailOutput`](crate::output::RegisterToWorkMailOutput)

    /// - On failure, responds with [`SdkError<RegisterToWorkMailError>`](crate::error::RegisterToWorkMailError)
    pub fn register_to_work_mail(&self) -> fluent_builders::RegisterToWorkMail {
        fluent_builders::RegisterToWorkMail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetPassword`](crate::client::fluent_builders::ResetPassword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::ResetPassword::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::ResetPassword::set_organization_id): <p>The identifier of the organization that contains the user for which the password is reset.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::ResetPassword::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::ResetPassword::set_user_id): <p>The identifier of the user for whom the password is reset.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::ResetPassword::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::ResetPassword::set_password): <p>The new password for the user.</p>
    /// - On success, responds with [`ResetPasswordOutput`](crate::output::ResetPasswordOutput)

    /// - On failure, responds with [`SdkError<ResetPasswordError>`](crate::error::ResetPasswordError)
    pub fn reset_password(&self) -> fluent_builders::ResetPassword {
        fluent_builders::ResetPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartMailboxExportJob`](crate::client::fluent_builders::StartMailboxExportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartMailboxExportJob::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartMailboxExportJob::set_client_token): <p>The idempotency token for the client request.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::StartMailboxExportJob::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::StartMailboxExportJob::set_organization_id): <p>The identifier associated with the organization.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::StartMailboxExportJob::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::StartMailboxExportJob::set_entity_id): <p>The identifier of the user or resource associated with the mailbox.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::StartMailboxExportJob::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::StartMailboxExportJob::set_description): <p>The mailbox export job description.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::StartMailboxExportJob::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::StartMailboxExportJob::set_role_arn): <p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3 bucket.</p>
    ///   - [`kms_key_arn(impl Into<String>)`](crate::client::fluent_builders::StartMailboxExportJob::kms_key_arn) / [`set_kms_key_arn(Option<String>)`](crate::client::fluent_builders::StartMailboxExportJob::set_kms_key_arn): <p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.</p>
    ///   - [`s3_bucket_name(impl Into<String>)`](crate::client::fluent_builders::StartMailboxExportJob::s3_bucket_name) / [`set_s3_bucket_name(Option<String>)`](crate::client::fluent_builders::StartMailboxExportJob::set_s3_bucket_name): <p>The name of the S3 bucket.</p>
    ///   - [`s3_prefix(impl Into<String>)`](crate::client::fluent_builders::StartMailboxExportJob::s3_prefix) / [`set_s3_prefix(Option<String>)`](crate::client::fluent_builders::StartMailboxExportJob::set_s3_prefix): <p>The S3 bucket prefix.</p>
    /// - On success, responds with [`StartMailboxExportJobOutput`](crate::output::StartMailboxExportJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartMailboxExportJobOutput::job_id): <p>The job ID.</p>
    /// - On failure, responds with [`SdkError<StartMailboxExportJobError>`](crate::error::StartMailboxExportJobError)
    pub fn start_mailbox_export_job(&self) -> fluent_builders::StartMailboxExportJob {
        fluent_builders::StartMailboxExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The resource ARN.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tag key-value pairs.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The resource ARN.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDefaultMailDomain`](crate::client::fluent_builders::UpdateDefaultMailDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDefaultMailDomain::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::UpdateDefaultMailDomain::set_organization_id): <p>The Amazon WorkMail organization for which to list domains.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDefaultMailDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDefaultMailDomain::set_domain_name): <p>The domain name that will become the default domain.</p>
    /// - On success, responds with [`UpdateDefaultMailDomainOutput`](crate::output::UpdateDefaultMailDomainOutput)

    /// - On failure, responds with [`SdkError<UpdateDefaultMailDomainError>`](crate::error::UpdateDefaultMailDomainError)
    pub fn update_default_mail_domain(&self) -> fluent_builders::UpdateDefaultMailDomain {
        fluent_builders::UpdateDefaultMailDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMailboxQuota`](crate::client::fluent_builders::UpdateMailboxQuota) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMailboxQuota::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::UpdateMailboxQuota::set_organization_id): <p>The identifier for the organization that contains the user for whom to update the mailbox quota.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMailboxQuota::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::UpdateMailboxQuota::set_user_id): <p>The identifer for the user for whom to update the mailbox quota.</p>
    ///   - [`mailbox_quota(i32)`](crate::client::fluent_builders::UpdateMailboxQuota::mailbox_quota) / [`set_mailbox_quota(Option<i32>)`](crate::client::fluent_builders::UpdateMailboxQuota::set_mailbox_quota): <p>The updated mailbox quota, in MB, for the specified user.</p>
    /// - On success, responds with [`UpdateMailboxQuotaOutput`](crate::output::UpdateMailboxQuotaOutput)

    /// - On failure, responds with [`SdkError<UpdateMailboxQuotaError>`](crate::error::UpdateMailboxQuotaError)
    pub fn update_mailbox_quota(&self) -> fluent_builders::UpdateMailboxQuota {
        fluent_builders::UpdateMailboxQuota::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMobileDeviceAccessRule`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_organization_id): <p>The Amazon WorkMail organization under which the rule will be updated.</p>
    ///   - [`mobile_device_access_rule_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::mobile_device_access_rule_id) / [`set_mobile_device_access_rule_id(Option<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_mobile_device_access_rule_id): <p>The identifier of the rule to be updated.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_name): <p>The updated rule name.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_description): <p>The updated rule description.</p>
    ///   - [`effect(MobileDeviceAccessRuleEffect)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::effect) / [`set_effect(Option<MobileDeviceAccessRuleEffect>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_effect): <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
    ///   - [`device_types(Vec<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::device_types) / [`set_device_types(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_device_types): <p>Device types that the updated rule will match.</p>
    ///   - [`not_device_types(Vec<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::not_device_types) / [`set_not_device_types(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_not_device_types): <p>Device types that the updated rule <b>will not</b> match. All other device types will match.</p>
    ///   - [`device_models(Vec<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::device_models) / [`set_device_models(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_device_models): <p>Device models that the updated rule will match.</p>
    ///   - [`not_device_models(Vec<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::not_device_models) / [`set_not_device_models(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_not_device_models): <p>Device models that the updated rule <b>will not</b> match. All other device models will match.</p>
    ///   - [`device_operating_systems(Vec<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::device_operating_systems) / [`set_device_operating_systems(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_device_operating_systems): <p>Device operating systems that the updated rule will match.</p>
    ///   - [`not_device_operating_systems(Vec<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::not_device_operating_systems) / [`set_not_device_operating_systems(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_not_device_operating_systems): <p>Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will match.</p>
    ///   - [`device_user_agents(Vec<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::device_user_agents) / [`set_device_user_agents(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_device_user_agents): <p>User agents that the updated rule will match.</p>
    ///   - [`not_device_user_agents(Vec<String>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::not_device_user_agents) / [`set_not_device_user_agents(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule::set_not_device_user_agents): <p>User agents that the updated rule <b>will not</b> match. All other user agents will match.</p>
    /// - On success, responds with [`UpdateMobileDeviceAccessRuleOutput`](crate::output::UpdateMobileDeviceAccessRuleOutput)

    /// - On failure, responds with [`SdkError<UpdateMobileDeviceAccessRuleError>`](crate::error::UpdateMobileDeviceAccessRuleError)
    pub fn update_mobile_device_access_rule(
        &self,
    ) -> fluent_builders::UpdateMobileDeviceAccessRule {
        fluent_builders::UpdateMobileDeviceAccessRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePrimaryEmailAddress`](crate::client::fluent_builders::UpdatePrimaryEmailAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePrimaryEmailAddress::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::UpdatePrimaryEmailAddress::set_organization_id): <p>The organization that contains the user, group, or resource to update.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePrimaryEmailAddress::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::UpdatePrimaryEmailAddress::set_entity_id): <p>The user, group, or resource to update.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::UpdatePrimaryEmailAddress::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::UpdatePrimaryEmailAddress::set_email): <p>The value of the email to be updated as primary.</p>
    /// - On success, responds with [`UpdatePrimaryEmailAddressOutput`](crate::output::UpdatePrimaryEmailAddressOutput)

    /// - On failure, responds with [`SdkError<UpdatePrimaryEmailAddressError>`](crate::error::UpdatePrimaryEmailAddressError)
    pub fn update_primary_email_address(&self) -> fluent_builders::UpdatePrimaryEmailAddress {
        fluent_builders::UpdatePrimaryEmailAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResource`](crate::client::fluent_builders::UpdateResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResource::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::UpdateResource::set_organization_id): <p>The identifier associated with the organization for which the resource is updated.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UpdateResource::set_resource_id): <p>The identifier of the resource to be updated.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateResource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateResource::set_name): <p>The name of the resource to be updated.</p>
    ///   - [`booking_options(BookingOptions)`](crate::client::fluent_builders::UpdateResource::booking_options) / [`set_booking_options(Option<BookingOptions>)`](crate::client::fluent_builders::UpdateResource::set_booking_options): <p>The resource's booking options to be updated.</p>
    /// - On success, responds with [`UpdateResourceOutput`](crate::output::UpdateResourceOutput)

    /// - On failure, responds with [`SdkError<UpdateResourceError>`](crate::error::UpdateResourceError)
    pub fn update_resource(&self) -> fluent_builders::UpdateResource {
        fluent_builders::UpdateResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateDelegateToResource`.
    ///
    /// <p>Adds a member (user or group) to the resource's set of delegates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateDelegateToResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_delegate_to_resource_input::Builder,
    }
    impl AssociateDelegateToResource {
        /// Creates a new `AssociateDelegateToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDelegateToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDelegateToResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization under which the resource exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization under which the resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The resource for which members (users or groups) are associated.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The resource for which members (users or groups) are associated.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The member (user or group) to associate to the resource.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The member (user or group) to associate to the resource.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateMemberToGroup`.
    ///
    /// <p>Adds a member (user or group) to the group's set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateMemberToGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_member_to_group_input::Builder,
    }
    impl AssociateMemberToGroup {
        /// Creates a new `AssociateMemberToGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateMemberToGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateMemberToGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization under which the group exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The group to which the member (user or group) is associated.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The group to which the member (user or group) is associated.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p>The member (user or group) to associate to the group.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The member (user or group) to associate to the group.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelMailboxExportJob`.
    ///
    /// <p>Cancels a mailbox export job.</p> <note>
    /// <p>If the mailbox export job is near completion, it might not be possible to cancel it.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelMailboxExportJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_mailbox_export_job_input::Builder,
    }
    impl CancelMailboxExportJob {
        /// Creates a new `CancelMailboxExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelMailboxExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelMailboxExportJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAlias`.
    ///
    /// <p>Adds an alias to the set of a given member (user or group) of Amazon WorkMail.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_alias_input::Builder,
    }
    impl CreateAlias {
        /// Creates a new `CreateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization under which the member (user or group) exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization under which the member (user or group) exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The member (user or group) to which this alias is added.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The member (user or group) to which this alias is added.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The alias to add to the member set.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The alias to add to the member set.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// <p>Creates a group that can be used in Amazon WorkMail by calling the <code>RegisterToWorkMail</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_group_input::Builder,
    }
    impl CreateGroup {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization under which the group is to be created.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization under which the group is to be created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The name of the group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMobileDeviceAccessRule`.
    ///
    /// <p>Creates a new mobile device access rule for the specified Amazon WorkMail organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMobileDeviceAccessRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_mobile_device_access_rule_input::Builder,
    }
    impl CreateMobileDeviceAccessRule {
        /// Creates a new `CreateMobileDeviceAccessRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMobileDeviceAccessRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMobileDeviceAccessRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization under which the rule will be created.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization under which the rule will be created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The rule name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The rule name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, input: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.inner = self.inner.effect(input);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.inner = self.inner.set_effect(input);
            self
        }
        /// Appends an item to `DeviceTypes`.
        ///
        /// To override the contents of this collection use [`set_device_types`](Self::set_device_types).
        ///
        /// <p>Device types that the rule will match.</p>
        pub fn device_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_types(input.into());
            self
        }
        /// <p>Device types that the rule will match.</p>
        pub fn set_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_types(input);
            self
        }
        /// Appends an item to `NotDeviceTypes`.
        ///
        /// To override the contents of this collection use [`set_not_device_types`](Self::set_not_device_types).
        ///
        /// <p>Device types that the rule <b>will not</b> match. All other device types will match.</p>
        pub fn not_device_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_types(input.into());
            self
        }
        /// <p>Device types that the rule <b>will not</b> match. All other device types will match.</p>
        pub fn set_not_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_types(input);
            self
        }
        /// Appends an item to `DeviceModels`.
        ///
        /// To override the contents of this collection use [`set_device_models`](Self::set_device_models).
        ///
        /// <p>Device models that the rule will match.</p>
        pub fn device_models(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_models(input.into());
            self
        }
        /// <p>Device models that the rule will match.</p>
        pub fn set_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_models(input);
            self
        }
        /// Appends an item to `NotDeviceModels`.
        ///
        /// To override the contents of this collection use [`set_not_device_models`](Self::set_not_device_models).
        ///
        /// <p>Device models that the rule <b>will not</b> match. All other device models will match.</p>
        pub fn not_device_models(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_models(input.into());
            self
        }
        /// <p>Device models that the rule <b>will not</b> match. All other device models will match.</p>
        pub fn set_not_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_models(input);
            self
        }
        /// Appends an item to `DeviceOperatingSystems`.
        ///
        /// To override the contents of this collection use [`set_device_operating_systems`](Self::set_device_operating_systems).
        ///
        /// <p>Device operating systems that the rule will match.</p>
        pub fn device_operating_systems(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_operating_systems(input.into());
            self
        }
        /// <p>Device operating systems that the rule will match.</p>
        pub fn set_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_operating_systems(input);
            self
        }
        /// Appends an item to `NotDeviceOperatingSystems`.
        ///
        /// To override the contents of this collection use [`set_not_device_operating_systems`](Self::set_not_device_operating_systems).
        ///
        /// <p>Device operating systems that the rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn not_device_operating_systems(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.not_device_operating_systems(input.into());
            self
        }
        /// <p>Device operating systems that the rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn set_not_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_operating_systems(input);
            self
        }
        /// Appends an item to `DeviceUserAgents`.
        ///
        /// To override the contents of this collection use [`set_device_user_agents`](Self::set_device_user_agents).
        ///
        /// <p>Device user agents that the rule will match.</p>
        pub fn device_user_agents(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_user_agents(input.into());
            self
        }
        /// <p>Device user agents that the rule will match.</p>
        pub fn set_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_user_agents(input);
            self
        }
        /// Appends an item to `NotDeviceUserAgents`.
        ///
        /// To override the contents of this collection use [`set_not_device_user_agents`](Self::set_not_device_user_agents).
        ///
        /// <p>Device user agents that the rule <b>will not</b> match. All other device user agents will match.</p>
        pub fn not_device_user_agents(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_user_agents(input.into());
            self
        }
        /// <p>Device user agents that the rule <b>will not</b> match. All other device user agents will match.</p>
        pub fn set_not_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_user_agents(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOrganization`.
    ///
    /// <p>Creates a new Amazon WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias must match the directory alias. If you choose not to associate an existing directory with your organization, then we create a new Amazon WorkMail directory for you. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an organization</a> in the <i>Amazon WorkMail Administrator Guide</i>.</p>
    /// <p>You can associate multiple email domains with an organization, then set your default email domain from the Amazon WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a domain</a> and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the default domain</a> in the <i>Amazon WorkMail Administrator Guide</i>.</p>
    /// <p>Optionally, you can use a customer managed master key from AWS Key Management Service (AWS KMS) to encrypt email for your organization. If you don't associate an AWS KMS key, Amazon WorkMail creates a default AWS managed master key for you.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_organization_input::Builder,
    }
    impl CreateOrganization {
        /// Creates a new `CreateOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Directory Service directory ID.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The AWS Directory Service directory ID.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The organization alias.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The organization alias.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>The email domains to associate with the organization.</p>
        pub fn domains(mut self, input: crate::model::Domain) -> Self {
            self.inner = self.inner.domains(input);
            self
        }
        /// <p>The email domains to associate with the organization.</p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Domain>>,
        ) -> Self {
            self.inner = self.inner.set_domains(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the request.</p>
        pub fn enable_interoperability(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_interoperability(input);
            self
        }
        /// <p>When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the request.</p>
        pub fn set_enable_interoperability(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_interoperability(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResource`.
    ///
    /// <p>Creates a new Amazon WorkMail resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resource_input::Builder,
    }
    impl CreateResource {
        /// Creates a new `CreateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the organization for which the resource is created.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier associated with the organization for which the resource is created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of the new resource. The available types are <code>equipment</code> and <code>room</code>.</p>
        pub fn r#type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of the new resource. The available types are <code>equipment</code> and <code>room</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ResourceType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a user who can be used in Amazon WorkMail by calling the <code>RegisterToWorkMail</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_user_input::Builder,
    }
    impl CreateUser {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the organization for which the user is created.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier of the organization for which the user is created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The display name for the new user.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The display name for the new user.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The password for the new user.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password for the new user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessControlRule`.
    ///
    /// <p>Deletes an access control rule for the specified WorkMail organization.</p> <note>
    /// <p>Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccessControlRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_access_control_rule_input::Builder,
    }
    impl DeleteAccessControlRule {
        /// Creates a new `DeleteAccessControlRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessControlRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessControlRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The name of the access control rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the access control rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlias`.
    ///
    /// <p>Remove one or more specified aliases from a set of aliases for a given user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_alias_input::Builder,
    }
    impl DeleteAlias {
        /// Creates a new `DeleteAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the member (user or group) from which to have the aliases removed.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The identifier for the member (user or group) from which to have the aliases removed.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed into single entries (the list is transformed into a set).</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed into single entries (the list is transformed into a set).</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailMonitoringConfiguration`.
    ///
    /// <p>Deletes the email monitoring configuration for a specified organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEmailMonitoringConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_email_monitoring_configuration_input::Builder,
    }
    impl DeleteEmailMonitoringConfiguration {
        /// Creates a new `DeleteEmailMonitoringConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailMonitoringConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteEmailMonitoringConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the organization from which the email monitoring configuration is deleted.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization from which the email monitoring configuration is deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// <p>Deletes a group from Amazon WorkMail.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl DeleteGroup {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization that contains the group.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization that contains the group.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the group to be deleted.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier of the group to be deleted.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMailboxPermissions`.
    ///
    /// <p>Deletes permissions granted to a member (user or group).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMailboxPermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_mailbox_permissions_input::Builder,
    }
    impl DeleteMailboxPermissions {
        /// Creates a new `DeleteMailboxPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMailboxPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMailboxPermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the organization under which the member (user or group) exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier of the organization under which the member (user or group) exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the member (user or group) that owns the mailbox.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The identifier of the member (user or group) that owns the mailbox.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The identifier of the member (user or group) for which to delete granted permissions.</p>
        pub fn grantee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grantee_id(input.into());
            self
        }
        /// <p>The identifier of the member (user or group) for which to delete granted permissions.</p>
        pub fn set_grantee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grantee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMobileDeviceAccessOverride`.
    ///
    /// <p>Deletes the mobile device access override for the given WorkMail organization, user, and device.</p> <note>
    /// <p>Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMobileDeviceAccessOverride {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_mobile_device_access_override_input::Builder,
    }
    impl DeleteMobileDeviceAccessOverride {
        /// Creates a new `DeleteMobileDeviceAccessOverride`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMobileDeviceAccessOverrideOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMobileDeviceAccessOverrideError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which the access override will be deleted.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which the access override will be deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The WorkMail user for which you want to delete the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The WorkMail user for which you want to delete the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMobileDeviceAccessRule`.
    ///
    /// <p>Deletes a mobile device access rule for the specified Amazon WorkMail organization.</p> <note>
    /// <p>Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMobileDeviceAccessRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_mobile_device_access_rule_input::Builder,
    }
    impl DeleteMobileDeviceAccessRule {
        /// Creates a new `DeleteMobileDeviceAccessRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMobileDeviceAccessRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMobileDeviceAccessRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization under which the rule will be deleted.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization under which the rule will be deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the rule to be deleted.</p>
        pub fn mobile_device_access_rule_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.mobile_device_access_rule_id(input.into());
            self
        }
        /// <p>The identifier of the rule to be deleted.</p>
        pub fn set_mobile_device_access_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mobile_device_access_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOrganization`.
    ///
    /// <p>Deletes an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of the organization. You can choose whether to delete the associated directory. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an organization</a> in the <i>Amazon WorkMail Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_organization_input::Builder,
    }
    impl DeleteOrganization {
        /// Creates a new `DeleteOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>If true, deletes the AWS Directory Service directory associated with the organization.</p>
        pub fn delete_directory(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_directory(input);
            self
        }
        /// <p>If true, deletes the AWS Directory Service directory associated with the organization.</p>
        pub fn set_delete_directory(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_directory(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResource`.
    ///
    /// <p>Deletes the specified resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_input::Builder,
    }
    impl DeleteResource {
        /// Creates a new `DeleteResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the organization from which the resource is deleted.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier associated with the organization from which the resource is deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the resource to be deleted.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the resource to be deleted.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRetentionPolicy`.
    ///
    /// <p>Deletes the specified retention policy from the specified organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRetentionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_retention_policy_input::Builder,
    }
    impl DeleteRetentionPolicy {
        /// Creates a new `DeleteRetentionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRetentionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRetentionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a user, the user state must be <code>DISABLED</code>. Use the <code>DescribeUser</code> action to confirm the user state.</p>
    /// <p>Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are permanently removed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl DeleteUser {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization that contains the user to be deleted.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization that contains the user to be deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the user to be deleted.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user to be deleted.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterFromWorkMail`.
    ///
    /// <p>Mark a user, group, or resource as no longer used in Amazon WorkMail. This action disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The functionality in the console is <i>Disable</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterFromWorkMail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_from_work_mail_input::Builder,
    }
    impl DeregisterFromWorkMail {
        /// Creates a new `DeregisterFromWorkMail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterFromWorkMailOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterFromWorkMailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the Amazon WorkMail entity exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the Amazon WorkMail entity exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the member (user or group) to be updated.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The identifier for the member (user or group) to be updated.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterMailDomain`.
    ///
    /// <p>Removes a domain from Amazon WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail use. SES keeps the domain because other applications may use it. You must first remove any email address used by WorkMail entities before you remove the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterMailDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_mail_domain_input::Builder,
    }
    impl DeregisterMailDomain {
        /// Creates a new `DeregisterMailDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterMailDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterMailDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which the domain will be deregistered.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which the domain will be deregistered.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The domain to deregister in WorkMail and SES. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain to deregister in WorkMail and SES. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEmailMonitoringConfiguration`.
    ///
    /// <p>Describes the current email monitoring configuration for a specified organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEmailMonitoringConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_email_monitoring_configuration_input::Builder,
    }
    impl DescribeEmailMonitoringConfiguration {
        /// Creates a new `DescribeEmailMonitoringConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEmailMonitoringConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEmailMonitoringConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the organization for which the email monitoring configuration is described.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization for which the email monitoring configuration is described.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGroup`.
    ///
    /// <p>Returns the data available for the group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_group_input::Builder,
    }
    impl DescribeGroup {
        /// Creates a new `DescribeGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the group to be described.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier for the group to be described.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInboundDmarcSettings`.
    ///
    /// <p>Lists the settings in a DMARC policy for a specified organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInboundDmarcSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_inbound_dmarc_settings_input::Builder,
    }
    impl DescribeInboundDmarcSettings {
        /// Creates a new `DescribeInboundDmarcSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInboundDmarcSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInboundDmarcSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Lists the ID of the given organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>Lists the ID of the given organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMailboxExportJob`.
    ///
    /// <p>Describes the current status of a mailbox export job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMailboxExportJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_mailbox_export_job_input::Builder,
    }
    impl DescribeMailboxExportJob {
        /// Creates a new `DescribeMailboxExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMailboxExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMailboxExportJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The mailbox export job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The mailbox export job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganization`.
    ///
    /// <p>Provides more information regarding a given organization based on its identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_organization_input::Builder,
    }
    impl DescribeOrganization {
        /// Creates a new `DescribeOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization to be described.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization to be described.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResource`.
    ///
    /// <p>Returns the data available for the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_resource_input::Builder,
    }
    impl DescribeResource {
        /// Creates a new `DescribeResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the organization for which the resource is described.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier associated with the organization for which the resource is described.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the resource to be described.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the resource to be described.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUser`.
    ///
    /// <p>Provides information regarding the user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_user_input::Builder,
    }
    impl DescribeUser {
        /// Creates a new `DescribeUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the user to be described.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier for the user to be described.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateDelegateFromResource`.
    ///
    /// <p>Removes a member from the resource's set of delegates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateDelegateFromResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_delegate_from_resource_input::Builder,
    }
    impl DisassociateDelegateFromResource {
        /// Creates a new `DisassociateDelegateFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDelegateFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDelegateFromResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the resource exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the resource from which delegates' set members are removed. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the resource from which delegates' set members are removed. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The identifier for the member (user, group) to be removed from the resource's delegates.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The identifier for the member (user, group) to be removed from the resource's delegates.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateMemberFromGroup`.
    ///
    /// <p>Removes a member from a group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateMemberFromGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_member_from_group_input::Builder,
    }
    impl DisassociateMemberFromGroup {
        /// Creates a new `DisassociateMemberFromGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMemberFromGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMemberFromGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the group from which members are removed.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier for the group from which members are removed.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p>The identifier for the member to be removed to the group.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The identifier for the member to be removed to the group.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessControlEffect`.
    ///
    /// <p>Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access protocol action, or user ID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccessControlEffect {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_access_control_effect_input::Builder,
    }
    impl GetAccessControlEffect {
        /// Creates a new `GetAccessControlEffect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessControlEffectOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessControlEffectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The IPv4 address.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_address(input.into());
            self
        }
        /// <p>The IPv4 address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
        /// <p>The access protocol action. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(input.into());
            self
        }
        /// <p>The access protocol action. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDefaultRetentionPolicy`.
    ///
    /// <p>Gets the default retention policy details for the specified organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDefaultRetentionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_default_retention_policy_input::Builder,
    }
    impl GetDefaultRetentionPolicy {
        /// Creates a new `GetDefaultRetentionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDefaultRetentionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDefaultRetentionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMailboxDetails`.
    ///
    /// <p>Requests a user's mailbox details for a specified organization and user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMailboxDetails {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_mailbox_details_input::Builder,
    }
    impl GetMailboxDetails {
        /// Creates a new `GetMailboxDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMailboxDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMailboxDetailsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization that contains the user whose mailbox details are being requested.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization that contains the user whose mailbox details are being requested.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the user whose mailbox details are being requested.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier for the user whose mailbox details are being requested.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMailDomain`.
    ///
    /// <p>Gets details for a mail domain, including domain records required to configure your domain with recommended security.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMailDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_mail_domain_input::Builder,
    }
    impl GetMailDomain {
        /// Creates a new `GetMailDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMailDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMailDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which the domain is retrieved.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which the domain is retrieved.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The domain from which you want to retrieve details.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain from which you want to retrieve details.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMobileDeviceAccessEffect`.
    ///
    /// <p>Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access rules for the Amazon WorkMail organization for a particular user's attributes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMobileDeviceAccessEffect {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_mobile_device_access_effect_input::Builder,
    }
    impl GetMobileDeviceAccessEffect {
        /// Creates a new `GetMobileDeviceAccessEffect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMobileDeviceAccessEffectOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMobileDeviceAccessEffectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization to simulate the access effect for.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization to simulate the access effect for.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>Device type the simulated user will report.</p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_type(input.into());
            self
        }
        /// <p>Device type the simulated user will report.</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_type(input);
            self
        }
        /// <p>Device model the simulated user will report.</p>
        pub fn device_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_model(input.into());
            self
        }
        /// <p>Device model the simulated user will report.</p>
        pub fn set_device_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_model(input);
            self
        }
        /// <p>Device operating system the simulated user will report.</p>
        pub fn device_operating_system(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_operating_system(input.into());
            self
        }
        /// <p>Device operating system the simulated user will report.</p>
        pub fn set_device_operating_system(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_operating_system(input);
            self
        }
        /// <p>Device user agent the simulated user will report.</p>
        pub fn device_user_agent(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_user_agent(input.into());
            self
        }
        /// <p>Device user agent the simulated user will report.</p>
        pub fn set_device_user_agent(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_user_agent(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMobileDeviceAccessOverride`.
    ///
    /// <p>Gets the mobile device access override for the given WorkMail organization, user, and device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMobileDeviceAccessOverride {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_mobile_device_access_override_input::Builder,
    }
    impl GetMobileDeviceAccessOverride {
        /// Creates a new `GetMobileDeviceAccessOverride`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMobileDeviceAccessOverrideOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMobileDeviceAccessOverrideError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization to which you want to apply the override.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization to which you want to apply the override.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>Identifies the WorkMail user for the override. Accepts the following types of user identities: </p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>Identifies the WorkMail user for the override. Accepts the following types of user identities: </p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The mobile device to which the override applies. <code>DeviceId</code> is case insensitive.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The mobile device to which the override applies. <code>DeviceId</code> is case insensitive.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessControlRules`.
    ///
    /// <p>Lists the access control rules for the specified organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccessControlRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_access_control_rules_input::Builder,
    }
    impl ListAccessControlRules {
        /// Creates a new `ListAccessControlRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessControlRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessControlRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAliases`.
    ///
    /// <p>Creates a paginated call to list the aliases associated with a given entity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAliases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_aliases_input::Builder,
    }
    impl ListAliases {
        /// Creates a new `ListAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAliasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAliasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAliasesPaginator {
            crate::paginator::ListAliasesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the organization under which the entity exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the entity exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the entity for which to list the aliases.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The identifier for the entity for which to list the aliases.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupMembers`.
    ///
    /// <p>Returns an overview of the members of a group. Users and groups can be members of a group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGroupMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_group_members_input::Builder,
    }
    impl ListGroupMembers {
        /// Creates a new `ListGroupMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGroupMembersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGroupMembersPaginator {
            crate::paginator::ListGroupMembersPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the group to which the members (users or groups) are associated.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The identifier for the group to which the members (users or groups) are associated.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p> The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroups`.
    ///
    /// <p>Returns summaries of the organization's groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_groups_input::Builder,
    }
    impl ListGroups {
        /// Creates a new `ListGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGroupsPaginator {
            crate::paginator::ListGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the organization under which the groups exist.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the groups exist.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMailboxExportJobs`.
    ///
    /// <p>Lists the mailbox export jobs started for the specified organization within the last seven days.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMailboxExportJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_mailbox_export_jobs_input::Builder,
    }
    impl ListMailboxExportJobs {
        /// Creates a new `ListMailboxExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMailboxExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMailboxExportJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMailboxExportJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMailboxExportJobsPaginator {
            crate::paginator::ListMailboxExportJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMailboxPermissions`.
    ///
    /// <p>Lists the mailbox permissions associated with a user, group, or resource mailbox.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMailboxPermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_mailbox_permissions_input::Builder,
    }
    impl ListMailboxPermissions {
        /// Creates a new `ListMailboxPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMailboxPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMailboxPermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMailboxPermissionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMailboxPermissionsPaginator {
            crate::paginator::ListMailboxPermissionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the user, group, or resource for which to list mailbox permissions.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The identifier of the user, group, or resource for which to list mailbox permissions.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMailDomains`.
    ///
    /// <p>Lists the mail domains in a given Amazon WorkMail organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMailDomains {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_mail_domains_input::Builder,
    }
    impl ListMailDomains {
        /// Creates a new `ListMailDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMailDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMailDomainsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMailDomainsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMailDomainsPaginator {
            crate::paginator::ListMailDomainsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMobileDeviceAccessOverrides`.
    ///
    /// <p>Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMobileDeviceAccessOverrides {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_mobile_device_access_overrides_input::Builder,
    }
    impl ListMobileDeviceAccessOverrides {
        /// Creates a new `ListMobileDeviceAccessOverrides`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMobileDeviceAccessOverridesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMobileDeviceAccessOverridesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMobileDeviceAccessOverridesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMobileDeviceAccessOverridesPaginator {
            crate::paginator::ListMobileDeviceAccessOverridesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon WorkMail organization under which to list mobile device access overrides.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization under which to list mobile device access overrides.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The mobile device to which the access override applies.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The mobile device to which the access override applies.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMobileDeviceAccessRules`.
    ///
    /// <p>Lists the mobile device access rules for the specified Amazon WorkMail organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMobileDeviceAccessRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_mobile_device_access_rules_input::Builder,
    }
    impl ListMobileDeviceAccessRules {
        /// Creates a new `ListMobileDeviceAccessRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMobileDeviceAccessRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMobileDeviceAccessRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which to list the rules.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which to list the rules.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizations`.
    ///
    /// <p>Returns summaries of the customer's organizations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOrganizations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_organizations_input::Builder,
    }
    impl ListOrganizations {
        /// Creates a new `ListOrganizations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOrganizationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOrganizationsPaginator {
            crate::paginator::ListOrganizationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceDelegates`.
    ///
    /// <p>Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on behalf of the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceDelegates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resource_delegates_input::Builder,
    }
    impl ListResourceDelegates {
        /// Creates a new `ListResourceDelegates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceDelegatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceDelegatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourceDelegatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourceDelegatesPaginator {
            crate::paginator::ListResourceDelegatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the organization that contains the resource for which delegates are listed.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization that contains the resource for which delegates are listed.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the resource whose delegates are listed.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier for the resource whose delegates are listed.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The token used to paginate through the delegates associated with a resource.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token used to paginate through the delegates associated with a resource.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of maximum results in a page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of maximum results in a page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResources`.
    ///
    /// <p>Returns summaries of the organization's resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resources_input::Builder,
    }
    impl ListResources {
        /// Creates a new `ListResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourcesPaginator {
            crate::paginator::ListResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the organization under which the resources exist.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the resources exist.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags applied to an Amazon WorkMail organization resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Returns summaries of the organization's users.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_users_input::Builder,
    }
    impl ListUsers {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUsersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUsersPaginator {
            crate::paginator::ListUsersPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the organization under which the users exist.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the users exist.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccessControlRule`.
    ///
    /// <p>Adds a new access control rule for the specified organization. The rule allows or denies access to the organization for the specified IPv4 addresses, access protocol actions, and user IDs. Adding a new rule with the same name as an existing rule replaces the older rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccessControlRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_access_control_rule_input::Builder,
    }
    impl PutAccessControlRule {
        /// Creates a new `PutAccessControlRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccessControlRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccessControlRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The rule name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The rule effect.</p>
        pub fn effect(mut self, input: crate::model::AccessControlRuleEffect) -> Self {
            self.inner = self.inner.effect(input);
            self
        }
        /// <p>The rule effect.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::AccessControlRuleEffect>,
        ) -> Self {
            self.inner = self.inner.set_effect(input);
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `IpRanges`.
        ///
        /// To override the contents of this collection use [`set_ip_ranges`](Self::set_ip_ranges).
        ///
        /// <p>IPv4 CIDR ranges to include in the rule.</p>
        pub fn ip_ranges(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_ranges(input.into());
            self
        }
        /// <p>IPv4 CIDR ranges to include in the rule.</p>
        pub fn set_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ip_ranges(input);
            self
        }
        /// Appends an item to `NotIpRanges`.
        ///
        /// To override the contents of this collection use [`set_not_ip_ranges`](Self::set_not_ip_ranges).
        ///
        /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
        pub fn not_ip_ranges(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_ip_ranges(input.into());
            self
        }
        /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
        pub fn set_not_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_ip_ranges(input);
            self
        }
        /// Appends an item to `Actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn actions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.actions(input.into());
            self
        }
        /// <p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// Appends an item to `NotActions`.
        ///
        /// To override the contents of this collection use [`set_not_actions`](Self::set_not_actions).
        ///
        /// <p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn not_actions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_actions(input.into());
            self
        }
        /// <p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_not_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_actions(input);
            self
        }
        /// Appends an item to `UserIds`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>User IDs to include in the rule.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_ids(input.into());
            self
        }
        /// <p>User IDs to include in the rule.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_ids(input);
            self
        }
        /// Appends an item to `NotUserIds`.
        ///
        /// To override the contents of this collection use [`set_not_user_ids`](Self::set_not_user_ids).
        ///
        /// <p>User IDs to exclude from the rule.</p>
        pub fn not_user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_user_ids(input.into());
            self
        }
        /// <p>User IDs to exclude from the rule.</p>
        pub fn set_not_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_user_ids(input);
            self
        }
        /// <p>The identifier of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailMonitoringConfiguration`.
    ///
    /// <p>Creates or updates the email monitoring configuration for a specified organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEmailMonitoringConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_email_monitoring_configuration_input::Builder,
    }
    impl PutEmailMonitoringConfiguration {
        /// Creates a new `PutEmailMonitoringConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailMonitoringConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEmailMonitoringConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the organization for which the email monitoring configuration is set.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization for which the email monitoring configuration is set.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.</p>
        pub fn log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.</p>
        pub fn set_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutInboundDmarcSettings`.
    ///
    /// <p>Enables or disables a DMARC policy for a given organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutInboundDmarcSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_inbound_dmarc_settings_input::Builder,
    }
    impl PutInboundDmarcSettings {
        /// Creates a new `PutInboundDmarcSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutInboundDmarcSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutInboundDmarcSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the organization that you are applying the DMARC policy to. </p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization that you are applying the DMARC policy to. </p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>Enforces or suspends a policy after it's applied.</p>
        pub fn enforced(mut self, input: bool) -> Self {
            self.inner = self.inner.enforced(input);
            self
        }
        /// <p>Enforces or suspends a policy after it's applied.</p>
        pub fn set_enforced(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enforced(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMailboxPermissions`.
    ///
    /// <p>Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutMailboxPermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_mailbox_permissions_input::Builder,
    }
    impl PutMailboxPermissions {
        /// Creates a new `PutMailboxPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMailboxPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMailboxPermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the user, group, or resource for which to update mailbox permissions.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The identifier of the user, group, or resource for which to update mailbox permissions.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The identifier of the user, group, or resource to which to grant the permissions.</p>
        pub fn grantee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grantee_id(input.into());
            self
        }
        /// <p>The identifier of the user, group, or resource to which to grant the permissions.</p>
        pub fn set_grantee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grantee_id(input);
            self
        }
        /// Appends an item to `PermissionValues`.
        ///
        /// To override the contents of this collection use [`set_permission_values`](Self::set_permission_values).
        ///
        /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>
        pub fn permission_values(mut self, input: crate::model::PermissionType) -> Self {
            self.inner = self.inner.permission_values(input);
            self
        }
        /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>
        pub fn set_permission_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
        ) -> Self {
            self.inner = self.inner.set_permission_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMobileDeviceAccessOverride`.
    ///
    /// <p>Creates or updates a mobile device access override for the given WorkMail organization, user, and device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutMobileDeviceAccessOverride {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_mobile_device_access_override_input::Builder,
    }
    impl PutMobileDeviceAccessOverride {
        /// Creates a new `PutMobileDeviceAccessOverride`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMobileDeviceAccessOverrideOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMobileDeviceAccessOverrideError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the Amazon WorkMail organization for which you create the override.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>Identifies the Amazon WorkMail organization for which you create the override.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The WorkMail user for which you create the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The WorkMail user for which you create the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The mobile device for which you create the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The mobile device for which you create the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, input: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.inner = self.inner.effect(input);
            self
        }
        /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.inner = self.inner.set_effect(input);
            self
        }
        /// <p>A description of the override.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the override.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRetentionPolicy`.
    ///
    /// <p>Puts a retention policy to the specified organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRetentionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_retention_policy_input::Builder,
    }
    impl PutRetentionPolicy {
        /// Creates a new `PutRetentionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRetentionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRetentionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The retention policy name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The retention policy name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The retention policy description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The retention policy description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `FolderConfigurations`.
        ///
        /// To override the contents of this collection use [`set_folder_configurations`](Self::set_folder_configurations).
        ///
        /// <p>The retention policy folder configurations.</p>
        pub fn folder_configurations(mut self, input: crate::model::FolderConfiguration) -> Self {
            self.inner = self.inner.folder_configurations(input);
            self
        }
        /// <p>The retention policy folder configurations.</p>
        pub fn set_folder_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_folder_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterMailDomain`.
    ///
    /// <p>Registers a new domain in Amazon WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use the specified domain for sending your users' emails.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterMailDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_mail_domain_input::Builder,
    }
    impl RegisterMailDomain {
        /// Creates a new `RegisterMailDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterMailDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterMailDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Idempotency token used when retrying requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Idempotency token used when retrying requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon WorkMail organization under which you're creating the domain.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization under which you're creating the domain.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The name of the mail domain to create in Amazon WorkMail and SES.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the mail domain to create in Amazon WorkMail and SES.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterToWorkMail`.
    ///
    /// <p>Registers an existing and disabled user, group, or resource for Amazon WorkMail use by associating a mailbox and calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user, group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console functionality for this operation is <i>Enable</i>. </p>
    /// <p>Users can either be created by calling the <code>CreateUser</code> API operation or they can be synchronized from your directory. For more information, see <code>DeregisterFromWorkMail</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterToWorkMail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_to_work_mail_input::Builder,
    }
    impl RegisterToWorkMail {
        /// Creates a new `RegisterToWorkMail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterToWorkMailOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterToWorkMailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the user, group, or resource exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization under which the user, group, or resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the user, group, or resource to be updated.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The identifier for the user, group, or resource to be updated.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The email for the user, group, or resource to be updated.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email for the user, group, or resource to be updated.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetPassword`.
    ///
    /// <p>Allows the administrator to reset the password for a user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetPassword {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reset_password_input::Builder,
    }
    impl ResetPassword {
        /// Creates a new `ResetPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetPasswordError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the organization that contains the user for which the password is reset.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier of the organization that contains the user for which the password is reset.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the user for whom the password is reset.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user for whom the password is reset.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The new password for the user.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The new password for the user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMailboxExportJob`.
    ///
    /// <p>Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content</a> in the <i>Amazon WorkMail Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartMailboxExportJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_mailbox_export_job_input::Builder,
    }
    impl StartMailboxExportJob {
        /// Creates a new `StartMailboxExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMailboxExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMailboxExportJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The identifier associated with the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier associated with the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the user or resource associated with the mailbox.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The identifier of the user or resource associated with the mailbox.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The mailbox export job description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The mailbox export job description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3 bucket.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3 bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(input.into());
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>The S3 bucket prefix.</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_prefix(input.into());
            self
        }
        /// <p>The S3 bucket prefix.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies the specified tags to the specified Amazon WorkMail organization resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Untags the specified tags from the specified Amazon WorkMail organization resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDefaultMailDomain`.
    ///
    /// <p>Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console to suggest an email address when enabling a mail user. You can only have one default domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDefaultMailDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_default_mail_domain_input::Builder,
    }
    impl UpdateDefaultMailDomain {
        /// Creates a new `UpdateDefaultMailDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDefaultMailDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDefaultMailDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The domain name that will become the default domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name that will become the default domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMailboxQuota`.
    ///
    /// <p>Updates a user's current mailbox quota for a specified organization and user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMailboxQuota {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_mailbox_quota_input::Builder,
    }
    impl UpdateMailboxQuota {
        /// Creates a new `UpdateMailboxQuota`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMailboxQuotaOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMailboxQuotaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization that contains the user for whom to update the mailbox quota.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier for the organization that contains the user for whom to update the mailbox quota.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifer for the user for whom to update the mailbox quota.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifer for the user for whom to update the mailbox quota.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The updated mailbox quota, in MB, for the specified user.</p>
        pub fn mailbox_quota(mut self, input: i32) -> Self {
            self.inner = self.inner.mailbox_quota(input);
            self
        }
        /// <p>The updated mailbox quota, in MB, for the specified user.</p>
        pub fn set_mailbox_quota(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_mailbox_quota(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMobileDeviceAccessRule`.
    ///
    /// <p>Updates a mobile device access rule for the specified Amazon WorkMail organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMobileDeviceAccessRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_mobile_device_access_rule_input::Builder,
    }
    impl UpdateMobileDeviceAccessRule {
        /// Creates a new `UpdateMobileDeviceAccessRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMobileDeviceAccessRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMobileDeviceAccessRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization under which the rule will be updated.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization under which the rule will be updated.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the rule to be updated.</p>
        pub fn mobile_device_access_rule_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.mobile_device_access_rule_id(input.into());
            self
        }
        /// <p>The identifier of the rule to be updated.</p>
        pub fn set_mobile_device_access_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mobile_device_access_rule_id(input);
            self
        }
        /// <p>The updated rule name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The updated rule name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The updated rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, input: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.inner = self.inner.effect(input);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.inner = self.inner.set_effect(input);
            self
        }
        /// Appends an item to `DeviceTypes`.
        ///
        /// To override the contents of this collection use [`set_device_types`](Self::set_device_types).
        ///
        /// <p>Device types that the updated rule will match.</p>
        pub fn device_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_types(input.into());
            self
        }
        /// <p>Device types that the updated rule will match.</p>
        pub fn set_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_types(input);
            self
        }
        /// Appends an item to `NotDeviceTypes`.
        ///
        /// To override the contents of this collection use [`set_not_device_types`](Self::set_not_device_types).
        ///
        /// <p>Device types that the updated rule <b>will not</b> match. All other device types will match.</p>
        pub fn not_device_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_types(input.into());
            self
        }
        /// <p>Device types that the updated rule <b>will not</b> match. All other device types will match.</p>
        pub fn set_not_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_types(input);
            self
        }
        /// Appends an item to `DeviceModels`.
        ///
        /// To override the contents of this collection use [`set_device_models`](Self::set_device_models).
        ///
        /// <p>Device models that the updated rule will match.</p>
        pub fn device_models(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_models(input.into());
            self
        }
        /// <p>Device models that the updated rule will match.</p>
        pub fn set_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_models(input);
            self
        }
        /// Appends an item to `NotDeviceModels`.
        ///
        /// To override the contents of this collection use [`set_not_device_models`](Self::set_not_device_models).
        ///
        /// <p>Device models that the updated rule <b>will not</b> match. All other device models will match.</p>
        pub fn not_device_models(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_models(input.into());
            self
        }
        /// <p>Device models that the updated rule <b>will not</b> match. All other device models will match.</p>
        pub fn set_not_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_models(input);
            self
        }
        /// Appends an item to `DeviceOperatingSystems`.
        ///
        /// To override the contents of this collection use [`set_device_operating_systems`](Self::set_device_operating_systems).
        ///
        /// <p>Device operating systems that the updated rule will match.</p>
        pub fn device_operating_systems(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_operating_systems(input.into());
            self
        }
        /// <p>Device operating systems that the updated rule will match.</p>
        pub fn set_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_operating_systems(input);
            self
        }
        /// Appends an item to `NotDeviceOperatingSystems`.
        ///
        /// To override the contents of this collection use [`set_not_device_operating_systems`](Self::set_not_device_operating_systems).
        ///
        /// <p>Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn not_device_operating_systems(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.not_device_operating_systems(input.into());
            self
        }
        /// <p>Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn set_not_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_operating_systems(input);
            self
        }
        /// Appends an item to `DeviceUserAgents`.
        ///
        /// To override the contents of this collection use [`set_device_user_agents`](Self::set_device_user_agents).
        ///
        /// <p>User agents that the updated rule will match.</p>
        pub fn device_user_agents(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_user_agents(input.into());
            self
        }
        /// <p>User agents that the updated rule will match.</p>
        pub fn set_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_user_agents(input);
            self
        }
        /// Appends an item to `NotDeviceUserAgents`.
        ///
        /// To override the contents of this collection use [`set_not_device_user_agents`](Self::set_not_device_user_agents).
        ///
        /// <p>User agents that the updated rule <b>will not</b> match. All other user agents will match.</p>
        pub fn not_device_user_agents(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_user_agents(input.into());
            self
        }
        /// <p>User agents that the updated rule <b>will not</b> match. All other user agents will match.</p>
        pub fn set_not_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_user_agents(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePrimaryEmailAddress`.
    ///
    /// <p>Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or swapped between an existing alias and the current primary email), and the email provided in the input is promoted as the primary.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePrimaryEmailAddress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_primary_email_address_input::Builder,
    }
    impl UpdatePrimaryEmailAddress {
        /// Creates a new `UpdatePrimaryEmailAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePrimaryEmailAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePrimaryEmailAddressError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization that contains the user, group, or resource to update.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The organization that contains the user, group, or resource to update.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The user, group, or resource to update.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The user, group, or resource to update.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The value of the email to be updated as primary.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The value of the email to be updated as primary.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResource`.
    ///
    /// <p>Updates data for the resource. To have the latest information, it must be preceded by a <code>DescribeResource</code> call. The dataset in the request should be the one expected when performing another <code>DescribeResource</code> call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resource_input::Builder,
    }
    impl UpdateResource {
        /// Creates a new `UpdateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the organization for which the resource is updated.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The identifier associated with the organization for which the resource is updated.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the resource to be updated.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The identifier of the resource to be updated.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The name of the resource to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the resource to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The resource's booking options to be updated.</p>
        pub fn booking_options(mut self, input: crate::model::BookingOptions) -> Self {
            self.inner = self.inner.booking_options(input);
            self
        }
        /// <p>The resource's booking options to be updated.</p>
        pub fn set_booking_options(
            mut self,
            input: std::option::Option<crate::model::BookingOptions>,
        ) -> Self {
            self.inner = self.inner.set_booking_options(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
