// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateDelegateToResourceInput`](crate::input::AssociateDelegateToResourceInput)
pub mod associate_delegate_to_resource_input {
    /// A builder for [`AssociateDelegateToResourceInput`](crate::input::AssociateDelegateToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The organization under which the resource exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization under which the resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The resource for which members (users or groups) are associated.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource for which members (users or groups) are associated.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The member (user or group) to associate to the resource.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The member (user or group) to associate to the resource.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateDelegateToResourceInput`](crate::input::AssociateDelegateToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateDelegateToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateDelegateToResourceInput {
                organization_id: self.organization_id,
                resource_id: self.resource_id,
                entity_id: self.entity_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateDelegateToResourceInputOperationOutputAlias =
    crate::operation::AssociateDelegateToResource;
#[doc(hidden)]
pub type AssociateDelegateToResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateDelegateToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AssociateDelegateToResource`](crate::operation::AssociateDelegateToResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateDelegateToResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateDelegateToResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateDelegateToResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.AssociateDelegateToResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_delegate_to_resource(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateDelegateToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateDelegateToResource",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateDelegateToResourceInput`](crate::input::AssociateDelegateToResourceInput)
    pub fn builder() -> crate::input::associate_delegate_to_resource_input::Builder {
        crate::input::associate_delegate_to_resource_input::Builder::default()
    }
}

/// See [`AssociateMemberToGroupInput`](crate::input::AssociateMemberToGroupInput)
pub mod associate_member_to_group_input {
    /// A builder for [`AssociateMemberToGroupInput`](crate::input::AssociateMemberToGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The organization under which the group exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The group to which the member (user or group) is associated.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The group to which the member (user or group) is associated.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The member (user or group) to associate to the group.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The member (user or group) to associate to the group.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateMemberToGroupInput`](crate::input::AssociateMemberToGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateMemberToGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateMemberToGroupInput {
                organization_id: self.organization_id,
                group_id: self.group_id,
                member_id: self.member_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateMemberToGroupInputOperationOutputAlias = crate::operation::AssociateMemberToGroup;
#[doc(hidden)]
pub type AssociateMemberToGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateMemberToGroupInput {
    /// Consumes the builder and constructs an Operation<[`AssociateMemberToGroup`](crate::operation::AssociateMemberToGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateMemberToGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateMemberToGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateMemberToGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.AssociateMemberToGroup",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_member_to_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateMemberToGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateMemberToGroup",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateMemberToGroupInput`](crate::input::AssociateMemberToGroupInput)
    pub fn builder() -> crate::input::associate_member_to_group_input::Builder {
        crate::input::associate_member_to_group_input::Builder::default()
    }
}

/// See [`CancelMailboxExportJobInput`](crate::input::CancelMailboxExportJobInput)
pub mod cancel_mailbox_export_job_input {
    /// A builder for [`CancelMailboxExportJobInput`](crate::input::CancelMailboxExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The idempotency token for the client request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelMailboxExportJobInput`](crate::input::CancelMailboxExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelMailboxExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelMailboxExportJobInput {
                client_token: self.client_token,
                job_id: self.job_id,
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelMailboxExportJobInputOperationOutputAlias = crate::operation::CancelMailboxExportJob;
#[doc(hidden)]
pub type CancelMailboxExportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelMailboxExportJobInput {
    /// Consumes the builder and constructs an Operation<[`CancelMailboxExportJob`](crate::operation::CancelMailboxExportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelMailboxExportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelMailboxExportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelMailboxExportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.CancelMailboxExportJob",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_mailbox_export_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelMailboxExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelMailboxExportJob",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelMailboxExportJobInput`](crate::input::CancelMailboxExportJobInput)
    pub fn builder() -> crate::input::cancel_mailbox_export_job_input::Builder {
        crate::input::cancel_mailbox_export_job_input::Builder::default()
    }
}

/// See [`CreateAliasInput`](crate::input::CreateAliasInput)
pub mod create_alias_input {
    /// A builder for [`CreateAliasInput`](crate::input::CreateAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The organization under which the member (user or group) exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization under which the member (user or group) exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The member (user or group) to which this alias is added.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The member (user or group) to which this alias is added.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The alias to add to the member set.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias to add to the member set.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAliasInput`](crate::input::CreateAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAliasInput {
                organization_id: self.organization_id,
                entity_id: self.entity_id,
                alias: self.alias,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAliasInputOperationOutputAlias = crate::operation::CreateAlias;
#[doc(hidden)]
pub type CreateAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAliasInput {
    /// Consumes the builder and constructs an Operation<[`CreateAlias`](crate::operation::CreateAlias)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAliasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAliasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.CreateAlias",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_alias(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAlias",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAliasInput`](crate::input::CreateAliasInput)
    pub fn builder() -> crate::input::create_alias_input::Builder {
        crate::input::create_alias_input::Builder::default()
    }
}

/// See [`CreateGroupInput`](crate::input::CreateGroupInput)
pub mod create_group_input {
    /// A builder for [`CreateGroupInput`](crate::input::CreateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The organization under which the group is to be created.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization under which the group is to be created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The name of the group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupInput`](crate::input::CreateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGroupInput {
                organization_id: self.organization_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGroupInputOperationOutputAlias = crate::operation::CreateGroup;
#[doc(hidden)]
pub type CreateGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateGroup`](crate::operation::CreateGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.CreateGroup",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGroup",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
}

/// See [`CreateMobileDeviceAccessRuleInput`](crate::input::CreateMobileDeviceAccessRuleInput)
pub mod create_mobile_device_access_rule_input {
    /// A builder for [`CreateMobileDeviceAccessRuleInput`](crate::input::CreateMobileDeviceAccessRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) effect: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        pub(crate) device_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_models: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_models: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_operating_systems:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_operating_systems:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization under which the rule will be created.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization under which the rule will be created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The rule name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The rule name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, input: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.effect = Some(input);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.effect = input;
            self
        }
        /// Appends an item to `device_types`.
        ///
        /// To override the contents of this collection use [`set_device_types`](Self::set_device_types).
        ///
        /// <p>Device types that the rule will match.</p>
        pub fn device_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_types.unwrap_or_default();
            v.push(input.into());
            self.device_types = Some(v);
            self
        }
        /// <p>Device types that the rule will match.</p>
        pub fn set_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_types = input;
            self
        }
        /// Appends an item to `not_device_types`.
        ///
        /// To override the contents of this collection use [`set_not_device_types`](Self::set_not_device_types).
        ///
        /// <p>Device types that the rule <b>will not</b> match. All other device types will match.</p>
        pub fn not_device_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_device_types.unwrap_or_default();
            v.push(input.into());
            self.not_device_types = Some(v);
            self
        }
        /// <p>Device types that the rule <b>will not</b> match. All other device types will match.</p>
        pub fn set_not_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_types = input;
            self
        }
        /// Appends an item to `device_models`.
        ///
        /// To override the contents of this collection use [`set_device_models`](Self::set_device_models).
        ///
        /// <p>Device models that the rule will match.</p>
        pub fn device_models(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_models.unwrap_or_default();
            v.push(input.into());
            self.device_models = Some(v);
            self
        }
        /// <p>Device models that the rule will match.</p>
        pub fn set_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_models = input;
            self
        }
        /// Appends an item to `not_device_models`.
        ///
        /// To override the contents of this collection use [`set_not_device_models`](Self::set_not_device_models).
        ///
        /// <p>Device models that the rule <b>will not</b> match. All other device models will match.</p>
        pub fn not_device_models(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_device_models.unwrap_or_default();
            v.push(input.into());
            self.not_device_models = Some(v);
            self
        }
        /// <p>Device models that the rule <b>will not</b> match. All other device models will match.</p>
        pub fn set_not_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_models = input;
            self
        }
        /// Appends an item to `device_operating_systems`.
        ///
        /// To override the contents of this collection use [`set_device_operating_systems`](Self::set_device_operating_systems).
        ///
        /// <p>Device operating systems that the rule will match.</p>
        pub fn device_operating_systems(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_operating_systems.unwrap_or_default();
            v.push(input.into());
            self.device_operating_systems = Some(v);
            self
        }
        /// <p>Device operating systems that the rule will match.</p>
        pub fn set_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_operating_systems = input;
            self
        }
        /// Appends an item to `not_device_operating_systems`.
        ///
        /// To override the contents of this collection use [`set_not_device_operating_systems`](Self::set_not_device_operating_systems).
        ///
        /// <p>Device operating systems that the rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn not_device_operating_systems(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.not_device_operating_systems.unwrap_or_default();
            v.push(input.into());
            self.not_device_operating_systems = Some(v);
            self
        }
        /// <p>Device operating systems that the rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn set_not_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_operating_systems = input;
            self
        }
        /// Appends an item to `device_user_agents`.
        ///
        /// To override the contents of this collection use [`set_device_user_agents`](Self::set_device_user_agents).
        ///
        /// <p>Device user agents that the rule will match.</p>
        pub fn device_user_agents(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_user_agents.unwrap_or_default();
            v.push(input.into());
            self.device_user_agents = Some(v);
            self
        }
        /// <p>Device user agents that the rule will match.</p>
        pub fn set_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_user_agents = input;
            self
        }
        /// Appends an item to `not_device_user_agents`.
        ///
        /// To override the contents of this collection use [`set_not_device_user_agents`](Self::set_not_device_user_agents).
        ///
        /// <p>Device user agents that the rule <b>will not</b> match. All other device user agents will match.</p>
        pub fn not_device_user_agents(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_device_user_agents.unwrap_or_default();
            v.push(input.into());
            self.not_device_user_agents = Some(v);
            self
        }
        /// <p>Device user agents that the rule <b>will not</b> match. All other device user agents will match.</p>
        pub fn set_not_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_user_agents = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMobileDeviceAccessRuleInput`](crate::input::CreateMobileDeviceAccessRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMobileDeviceAccessRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMobileDeviceAccessRuleInput {
                organization_id: self.organization_id,
                client_token: self.client_token,
                name: self.name,
                description: self.description,
                effect: self.effect,
                device_types: self.device_types,
                not_device_types: self.not_device_types,
                device_models: self.device_models,
                not_device_models: self.not_device_models,
                device_operating_systems: self.device_operating_systems,
                not_device_operating_systems: self.not_device_operating_systems,
                device_user_agents: self.device_user_agents,
                not_device_user_agents: self.not_device_user_agents,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMobileDeviceAccessRuleInputOperationOutputAlias =
    crate::operation::CreateMobileDeviceAccessRule;
#[doc(hidden)]
pub type CreateMobileDeviceAccessRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateMobileDeviceAccessRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateMobileDeviceAccessRule`](crate::operation::CreateMobileDeviceAccessRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMobileDeviceAccessRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateMobileDeviceAccessRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateMobileDeviceAccessRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.CreateMobileDeviceAccessRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_mobile_device_access_rule(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMobileDeviceAccessRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMobileDeviceAccessRule",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateMobileDeviceAccessRuleInput`](crate::input::CreateMobileDeviceAccessRuleInput)
    pub fn builder() -> crate::input::create_mobile_device_access_rule_input::Builder {
        crate::input::create_mobile_device_access_rule_input::Builder::default()
    }
}

/// See [`CreateOrganizationInput`](crate::input::CreateOrganizationInput)
pub mod create_organization_input {
    /// A builder for [`CreateOrganizationInput`](crate::input::CreateOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) domains: std::option::Option<std::vec::Vec<crate::model::Domain>>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) enable_interoperability: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The AWS Directory Service directory ID.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The AWS Directory Service directory ID.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The organization alias.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The organization alias.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>The email domains to associate with the organization.</p>
        pub fn domains(mut self, input: crate::model::Domain) -> Self {
            let mut v = self.domains.unwrap_or_default();
            v.push(input);
            self.domains = Some(v);
            self
        }
        /// <p>The email domains to associate with the organization.</p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Domain>>,
        ) -> Self {
            self.domains = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the request.</p>
        pub fn enable_interoperability(mut self, input: bool) -> Self {
            self.enable_interoperability = Some(input);
            self
        }
        /// <p>When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the request.</p>
        pub fn set_enable_interoperability(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_interoperability = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOrganizationInput`](crate::input::CreateOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOrganizationInput {
                directory_id: self.directory_id,
                alias: self.alias,
                client_token: self.client_token,
                domains: self.domains,
                kms_key_arn: self.kms_key_arn,
                enable_interoperability: self.enable_interoperability.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOrganizationInputOperationOutputAlias = crate::operation::CreateOrganization;
#[doc(hidden)]
pub type CreateOrganizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`CreateOrganization`](crate::operation::CreateOrganization)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOrganization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateOrganizationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateOrganizationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.CreateOrganization",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_organization(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOrganization",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateOrganizationInput`](crate::input::CreateOrganizationInput)
    pub fn builder() -> crate::input::create_organization_input::Builder {
        crate::input::create_organization_input::Builder::default()
    }
}

/// See [`CreateResourceInput`](crate::input::CreateResourceInput)
pub mod create_resource_input {
    /// A builder for [`CreateResourceInput`](crate::input::CreateResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        /// <p>The identifier associated with the organization for which the resource is created.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier associated with the organization for which the resource is created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the new resource. The available types are <code>equipment</code> and <code>room</code>.</p>
        pub fn r#type(mut self, input: crate::model::ResourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the new resource. The available types are <code>equipment</code> and <code>room</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ResourceType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceInput`](crate::input::CreateResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourceInput {
                organization_id: self.organization_id,
                name: self.name,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourceInputOperationOutputAlias = crate::operation::CreateResource;
#[doc(hidden)]
pub type CreateResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateResourceInput {
    /// Consumes the builder and constructs an Operation<[`CreateResource`](crate::operation::CreateResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.CreateResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResource",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateResourceInput`](crate::input::CreateResourceInput)
    pub fn builder() -> crate::input::create_resource_input::Builder {
        crate::input::create_resource_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the organization for which the user is created.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier of the organization for which the user is created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The display name for the new user.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name for the new user.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The password for the new user.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password for the new user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                organization_id: self.organization_id,
                name: self.name,
                display_name: self.display_name,
                password: self.password,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.CreateUser",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`DeleteAccessControlRuleInput`](crate::input::DeleteAccessControlRuleInput)
pub mod delete_access_control_rule_input {
    /// A builder for [`DeleteAccessControlRuleInput`](crate::input::DeleteAccessControlRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The name of the access control rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the access control rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccessControlRuleInput`](crate::input::DeleteAccessControlRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccessControlRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccessControlRuleInput {
                organization_id: self.organization_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccessControlRuleInputOperationOutputAlias =
    crate::operation::DeleteAccessControlRule;
#[doc(hidden)]
pub type DeleteAccessControlRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAccessControlRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccessControlRule`](crate::operation::DeleteAccessControlRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccessControlRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAccessControlRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAccessControlRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteAccessControlRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_access_control_rule(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccessControlRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccessControlRule",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccessControlRuleInput`](crate::input::DeleteAccessControlRuleInput)
    pub fn builder() -> crate::input::delete_access_control_rule_input::Builder {
        crate::input::delete_access_control_rule_input::Builder::default()
    }
}

/// See [`DeleteAliasInput`](crate::input::DeleteAliasInput)
pub mod delete_alias_input {
    /// A builder for [`DeleteAliasInput`](crate::input::DeleteAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier for the member (user or group) from which to have the aliases removed.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The identifier for the member (user or group) from which to have the aliases removed.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed into single entries (the list is transformed into a set).</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed into single entries (the list is transformed into a set).</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAliasInput`](crate::input::DeleteAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAliasInput {
                organization_id: self.organization_id,
                entity_id: self.entity_id,
                alias: self.alias,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAliasInputOperationOutputAlias = crate::operation::DeleteAlias;
#[doc(hidden)]
pub type DeleteAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAliasInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAlias`](crate::operation::DeleteAlias)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAliasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAliasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteAlias",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_alias(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAlias",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAliasInput`](crate::input::DeleteAliasInput)
    pub fn builder() -> crate::input::delete_alias_input::Builder {
        crate::input::delete_alias_input::Builder::default()
    }
}

/// See [`DeleteEmailMonitoringConfigurationInput`](crate::input::DeleteEmailMonitoringConfigurationInput)
pub mod delete_email_monitoring_configuration_input {
    /// A builder for [`DeleteEmailMonitoringConfigurationInput`](crate::input::DeleteEmailMonitoringConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the organization from which the email monitoring configuration is deleted.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization from which the email monitoring configuration is deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEmailMonitoringConfigurationInput`](crate::input::DeleteEmailMonitoringConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEmailMonitoringConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEmailMonitoringConfigurationInput {
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEmailMonitoringConfigurationInputOperationOutputAlias =
    crate::operation::DeleteEmailMonitoringConfiguration;
#[doc(hidden)]
pub type DeleteEmailMonitoringConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEmailMonitoringConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEmailMonitoringConfiguration`](crate::operation::DeleteEmailMonitoringConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEmailMonitoringConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEmailMonitoringConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEmailMonitoringConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteEmailMonitoringConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_email_monitoring_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEmailMonitoringConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEmailMonitoringConfiguration",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEmailMonitoringConfigurationInput`](crate::input::DeleteEmailMonitoringConfigurationInput)
    pub fn builder() -> crate::input::delete_email_monitoring_configuration_input::Builder {
        crate::input::delete_email_monitoring_configuration_input::Builder::default()
    }
}

/// See [`DeleteGroupInput`](crate::input::DeleteGroupInput)
pub mod delete_group_input {
    /// A builder for [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The organization that contains the group.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization that contains the group.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the group to be deleted.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the group to be deleted.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupInput`](crate::input::DeleteGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGroupInput {
                organization_id: self.organization_id,
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGroupInputOperationOutputAlias = crate::operation::DeleteGroup;
#[doc(hidden)]
pub type DeleteGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGroup`](crate::operation::DeleteGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteGroup",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGroup",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
}

/// See [`DeleteMailboxPermissionsInput`](crate::input::DeleteMailboxPermissionsInput)
pub mod delete_mailbox_permissions_input {
    /// A builder for [`DeleteMailboxPermissionsInput`](crate::input::DeleteMailboxPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) grantee_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the organization under which the member (user or group) exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier of the organization under which the member (user or group) exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the member (user or group) that owns the mailbox.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The identifier of the member (user or group) that owns the mailbox.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The identifier of the member (user or group) for which to delete granted permissions.</p>
        pub fn grantee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee_id = Some(input.into());
            self
        }
        /// <p>The identifier of the member (user or group) for which to delete granted permissions.</p>
        pub fn set_grantee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantee_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMailboxPermissionsInput`](crate::input::DeleteMailboxPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMailboxPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMailboxPermissionsInput {
                organization_id: self.organization_id,
                entity_id: self.entity_id,
                grantee_id: self.grantee_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMailboxPermissionsInputOperationOutputAlias =
    crate::operation::DeleteMailboxPermissions;
#[doc(hidden)]
pub type DeleteMailboxPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMailboxPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMailboxPermissions`](crate::operation::DeleteMailboxPermissions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMailboxPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteMailboxPermissionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteMailboxPermissionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteMailboxPermissions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_mailbox_permissions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMailboxPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMailboxPermissions",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteMailboxPermissionsInput`](crate::input::DeleteMailboxPermissionsInput)
    pub fn builder() -> crate::input::delete_mailbox_permissions_input::Builder {
        crate::input::delete_mailbox_permissions_input::Builder::default()
    }
}

/// See [`DeleteMobileDeviceAccessOverrideInput`](crate::input::DeleteMobileDeviceAccessOverrideInput)
pub mod delete_mobile_device_access_override_input {
    /// A builder for [`DeleteMobileDeviceAccessOverrideInput`](crate::input::DeleteMobileDeviceAccessOverrideInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization for which the access override will be deleted.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which the access override will be deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The WorkMail user for which you want to delete the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The WorkMail user for which you want to delete the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMobileDeviceAccessOverrideInput`](crate::input::DeleteMobileDeviceAccessOverrideInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMobileDeviceAccessOverrideInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMobileDeviceAccessOverrideInput {
                organization_id: self.organization_id,
                user_id: self.user_id,
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMobileDeviceAccessOverrideInputOperationOutputAlias =
    crate::operation::DeleteMobileDeviceAccessOverride;
#[doc(hidden)]
pub type DeleteMobileDeviceAccessOverrideInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMobileDeviceAccessOverrideInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMobileDeviceAccessOverride`](crate::operation::DeleteMobileDeviceAccessOverride)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMobileDeviceAccessOverride,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteMobileDeviceAccessOverrideInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteMobileDeviceAccessOverrideInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteMobileDeviceAccessOverride",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_mobile_device_access_override(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMobileDeviceAccessOverride::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMobileDeviceAccessOverride",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteMobileDeviceAccessOverrideInput`](crate::input::DeleteMobileDeviceAccessOverrideInput)
    pub fn builder() -> crate::input::delete_mobile_device_access_override_input::Builder {
        crate::input::delete_mobile_device_access_override_input::Builder::default()
    }
}

/// See [`DeleteMobileDeviceAccessRuleInput`](crate::input::DeleteMobileDeviceAccessRuleInput)
pub mod delete_mobile_device_access_rule_input {
    /// A builder for [`DeleteMobileDeviceAccessRuleInput`](crate::input::DeleteMobileDeviceAccessRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) mobile_device_access_rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization under which the rule will be deleted.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization under which the rule will be deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the rule to be deleted.</p>
        pub fn mobile_device_access_rule_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.mobile_device_access_rule_id = Some(input.into());
            self
        }
        /// <p>The identifier of the rule to be deleted.</p>
        pub fn set_mobile_device_access_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mobile_device_access_rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMobileDeviceAccessRuleInput`](crate::input::DeleteMobileDeviceAccessRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMobileDeviceAccessRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMobileDeviceAccessRuleInput {
                organization_id: self.organization_id,
                mobile_device_access_rule_id: self.mobile_device_access_rule_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMobileDeviceAccessRuleInputOperationOutputAlias =
    crate::operation::DeleteMobileDeviceAccessRule;
#[doc(hidden)]
pub type DeleteMobileDeviceAccessRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMobileDeviceAccessRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMobileDeviceAccessRule`](crate::operation::DeleteMobileDeviceAccessRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMobileDeviceAccessRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteMobileDeviceAccessRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteMobileDeviceAccessRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteMobileDeviceAccessRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_mobile_device_access_rule(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMobileDeviceAccessRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMobileDeviceAccessRule",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteMobileDeviceAccessRuleInput`](crate::input::DeleteMobileDeviceAccessRuleInput)
    pub fn builder() -> crate::input::delete_mobile_device_access_rule_input::Builder {
        crate::input::delete_mobile_device_access_rule_input::Builder::default()
    }
}

/// See [`DeleteOrganizationInput`](crate::input::DeleteOrganizationInput)
pub mod delete_organization_input {
    /// A builder for [`DeleteOrganizationInput`](crate::input::DeleteOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) delete_directory: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The idempotency token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>If true, deletes the AWS Directory Service directory associated with the organization.</p>
        pub fn delete_directory(mut self, input: bool) -> Self {
            self.delete_directory = Some(input);
            self
        }
        /// <p>If true, deletes the AWS Directory Service directory associated with the organization.</p>
        pub fn set_delete_directory(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_directory = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOrganizationInput`](crate::input::DeleteOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOrganizationInput {
                client_token: self.client_token,
                organization_id: self.organization_id,
                delete_directory: self.delete_directory.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOrganizationInputOperationOutputAlias = crate::operation::DeleteOrganization;
#[doc(hidden)]
pub type DeleteOrganizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOrganization`](crate::operation::DeleteOrganization)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOrganization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOrganizationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOrganizationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteOrganization",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_organization(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOrganization",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationInput`](crate::input::DeleteOrganizationInput)
    pub fn builder() -> crate::input::delete_organization_input::Builder {
        crate::input::delete_organization_input::Builder::default()
    }
}

/// See [`DeleteResourceInput`](crate::input::DeleteResourceInput)
pub mod delete_resource_input {
    /// A builder for [`DeleteResourceInput`](crate::input::DeleteResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the organization from which the resource is deleted.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier associated with the organization from which the resource is deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the resource to be deleted.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource to be deleted.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourceInput`](crate::input::DeleteResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourceInput {
                organization_id: self.organization_id,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourceInputOperationOutputAlias = crate::operation::DeleteResource;
#[doc(hidden)]
pub type DeleteResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteResourceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResource`](crate::operation::DeleteResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResource",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourceInput`](crate::input::DeleteResourceInput)
    pub fn builder() -> crate::input::delete_resource_input::Builder {
        crate::input::delete_resource_input::Builder::default()
    }
}

/// See [`DeleteRetentionPolicyInput`](crate::input::DeleteRetentionPolicyInput)
pub mod delete_retention_policy_input {
    /// A builder for [`DeleteRetentionPolicyInput`](crate::input::DeleteRetentionPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRetentionPolicyInput`](crate::input::DeleteRetentionPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRetentionPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRetentionPolicyInput {
                organization_id: self.organization_id,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRetentionPolicyInputOperationOutputAlias = crate::operation::DeleteRetentionPolicy;
#[doc(hidden)]
pub type DeleteRetentionPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRetentionPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRetentionPolicy`](crate::operation::DeleteRetentionPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRetentionPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRetentionPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRetentionPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteRetentionPolicy",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_retention_policy(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRetentionPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRetentionPolicy",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRetentionPolicyInput`](crate::input::DeleteRetentionPolicyInput)
    pub fn builder() -> crate::input::delete_retention_policy_input::Builder {
        crate::input::delete_retention_policy_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The organization that contains the user to be deleted.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization that contains the user to be deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the user to be deleted.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user to be deleted.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                organization_id: self.organization_id,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeleteUser",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DeregisterFromWorkMailInput`](crate::input::DeregisterFromWorkMailInput)
pub mod deregister_from_work_mail_input {
    /// A builder for [`DeregisterFromWorkMailInput`](crate::input::DeregisterFromWorkMailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the Amazon WorkMail entity exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the Amazon WorkMail entity exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier for the member (user or group) to be updated.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The identifier for the member (user or group) to be updated.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterFromWorkMailInput`](crate::input::DeregisterFromWorkMailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterFromWorkMailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterFromWorkMailInput {
                organization_id: self.organization_id,
                entity_id: self.entity_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterFromWorkMailInputOperationOutputAlias = crate::operation::DeregisterFromWorkMail;
#[doc(hidden)]
pub type DeregisterFromWorkMailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterFromWorkMailInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterFromWorkMail`](crate::operation::DeregisterFromWorkMail)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterFromWorkMail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeregisterFromWorkMailInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeregisterFromWorkMailInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeregisterFromWorkMail",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_deregister_from_work_mail(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterFromWorkMail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterFromWorkMail",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeregisterFromWorkMailInput`](crate::input::DeregisterFromWorkMailInput)
    pub fn builder() -> crate::input::deregister_from_work_mail_input::Builder {
        crate::input::deregister_from_work_mail_input::Builder::default()
    }
}

/// See [`DeregisterMailDomainInput`](crate::input::DeregisterMailDomainInput)
pub mod deregister_mail_domain_input {
    /// A builder for [`DeregisterMailDomainInput`](crate::input::DeregisterMailDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization for which the domain will be deregistered.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which the domain will be deregistered.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The domain to deregister in WorkMail and SES. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain to deregister in WorkMail and SES. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterMailDomainInput`](crate::input::DeregisterMailDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterMailDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterMailDomainInput {
                organization_id: self.organization_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterMailDomainInputOperationOutputAlias = crate::operation::DeregisterMailDomain;
#[doc(hidden)]
pub type DeregisterMailDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterMailDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterMailDomain`](crate::operation::DeregisterMailDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterMailDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeregisterMailDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeregisterMailDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DeregisterMailDomain",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_deregister_mail_domain(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterMailDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterMailDomain",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeregisterMailDomainInput`](crate::input::DeregisterMailDomainInput)
    pub fn builder() -> crate::input::deregister_mail_domain_input::Builder {
        crate::input::deregister_mail_domain_input::Builder::default()
    }
}

/// See [`DescribeEmailMonitoringConfigurationInput`](crate::input::DescribeEmailMonitoringConfigurationInput)
pub mod describe_email_monitoring_configuration_input {
    /// A builder for [`DescribeEmailMonitoringConfigurationInput`](crate::input::DescribeEmailMonitoringConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the organization for which the email monitoring configuration is described.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization for which the email monitoring configuration is described.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEmailMonitoringConfigurationInput`](crate::input::DescribeEmailMonitoringConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEmailMonitoringConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEmailMonitoringConfigurationInput {
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEmailMonitoringConfigurationInputOperationOutputAlias =
    crate::operation::DescribeEmailMonitoringConfiguration;
#[doc(hidden)]
pub type DescribeEmailMonitoringConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEmailMonitoringConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEmailMonitoringConfiguration`](crate::operation::DescribeEmailMonitoringConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEmailMonitoringConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEmailMonitoringConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEmailMonitoringConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DescribeEmailMonitoringConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_email_monitoring_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEmailMonitoringConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEmailMonitoringConfiguration",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEmailMonitoringConfigurationInput`](crate::input::DescribeEmailMonitoringConfigurationInput)
    pub fn builder() -> crate::input::describe_email_monitoring_configuration_input::Builder {
        crate::input::describe_email_monitoring_configuration_input::Builder::default()
    }
}

/// See [`DescribeGroupInput`](crate::input::DescribeGroupInput)
pub mod describe_group_input {
    /// A builder for [`DescribeGroupInput`](crate::input::DescribeGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier for the group to be described.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier for the group to be described.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGroupInput`](crate::input::DescribeGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGroupInput {
                organization_id: self.organization_id,
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGroupInputOperationOutputAlias = crate::operation::DescribeGroup;
#[doc(hidden)]
pub type DescribeGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGroup`](crate::operation::DescribeGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DescribeGroup",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGroup",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeGroupInput`](crate::input::DescribeGroupInput)
    pub fn builder() -> crate::input::describe_group_input::Builder {
        crate::input::describe_group_input::Builder::default()
    }
}

/// See [`DescribeInboundDmarcSettingsInput`](crate::input::DescribeInboundDmarcSettingsInput)
pub mod describe_inbound_dmarc_settings_input {
    /// A builder for [`DescribeInboundDmarcSettingsInput`](crate::input::DescribeInboundDmarcSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Lists the ID of the given organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>Lists the ID of the given organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInboundDmarcSettingsInput`](crate::input::DescribeInboundDmarcSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInboundDmarcSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInboundDmarcSettingsInput {
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInboundDmarcSettingsInputOperationOutputAlias =
    crate::operation::DescribeInboundDmarcSettings;
#[doc(hidden)]
pub type DescribeInboundDmarcSettingsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInboundDmarcSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInboundDmarcSettings`](crate::operation::DescribeInboundDmarcSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInboundDmarcSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeInboundDmarcSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeInboundDmarcSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DescribeInboundDmarcSettings",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_inbound_dmarc_settings(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInboundDmarcSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInboundDmarcSettings",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeInboundDmarcSettingsInput`](crate::input::DescribeInboundDmarcSettingsInput)
    pub fn builder() -> crate::input::describe_inbound_dmarc_settings_input::Builder {
        crate::input::describe_inbound_dmarc_settings_input::Builder::default()
    }
}

/// See [`DescribeMailboxExportJobInput`](crate::input::DescribeMailboxExportJobInput)
pub mod describe_mailbox_export_job_input {
    /// A builder for [`DescribeMailboxExportJobInput`](crate::input::DescribeMailboxExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The mailbox export job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The mailbox export job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMailboxExportJobInput`](crate::input::DescribeMailboxExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMailboxExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMailboxExportJobInput {
                job_id: self.job_id,
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMailboxExportJobInputOperationOutputAlias =
    crate::operation::DescribeMailboxExportJob;
#[doc(hidden)]
pub type DescribeMailboxExportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMailboxExportJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMailboxExportJob`](crate::operation::DescribeMailboxExportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMailboxExportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeMailboxExportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeMailboxExportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DescribeMailboxExportJob",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_mailbox_export_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMailboxExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMailboxExportJob",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeMailboxExportJobInput`](crate::input::DescribeMailboxExportJobInput)
    pub fn builder() -> crate::input::describe_mailbox_export_job_input::Builder {
        crate::input::describe_mailbox_export_job_input::Builder::default()
    }
}

/// See [`DescribeOrganizationInput`](crate::input::DescribeOrganizationInput)
pub mod describe_organization_input {
    /// A builder for [`DescribeOrganizationInput`](crate::input::DescribeOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization to be described.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization to be described.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationInput`](crate::input::DescribeOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationInput {
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationInputOperationOutputAlias = crate::operation::DescribeOrganization;
#[doc(hidden)]
pub type DescribeOrganizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganization`](crate::operation::DescribeOrganization)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOrganizationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOrganizationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DescribeOrganization",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_organization(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganization",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationInput`](crate::input::DescribeOrganizationInput)
    pub fn builder() -> crate::input::describe_organization_input::Builder {
        crate::input::describe_organization_input::Builder::default()
    }
}

/// See [`DescribeResourceInput`](crate::input::DescribeResourceInput)
pub mod describe_resource_input {
    /// A builder for [`DescribeResourceInput`](crate::input::DescribeResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the organization for which the resource is described.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier associated with the organization for which the resource is described.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the resource to be described.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource to be described.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourceInput`](crate::input::DescribeResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeResourceInput {
                organization_id: self.organization_id,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeResourceInputOperationOutputAlias = crate::operation::DescribeResource;
#[doc(hidden)]
pub type DescribeResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeResourceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeResource`](crate::operation::DescribeResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DescribeResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeResource",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeResourceInput`](crate::input::DescribeResourceInput)
    pub fn builder() -> crate::input::describe_resource_input::Builder {
        crate::input::describe_resource_input::Builder::default()
    }
}

/// See [`DescribeUserInput`](crate::input::DescribeUserInput)
pub mod describe_user_input {
    /// A builder for [`DescribeUserInput`](crate::input::DescribeUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier for the user to be described.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier for the user to be described.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserInput`](crate::input::DescribeUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserInput {
                organization_id: self.organization_id,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserInputOperationOutputAlias = crate::operation::DescribeUser;
#[doc(hidden)]
pub type DescribeUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUser`](crate::operation::DescribeUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DescribeUser",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUser",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserInput`](crate::input::DescribeUserInput)
    pub fn builder() -> crate::input::describe_user_input::Builder {
        crate::input::describe_user_input::Builder::default()
    }
}

/// See [`DisassociateDelegateFromResourceInput`](crate::input::DisassociateDelegateFromResourceInput)
pub mod disassociate_delegate_from_resource_input {
    /// A builder for [`DisassociateDelegateFromResourceInput`](crate::input::DisassociateDelegateFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the resource exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the resource from which delegates' set members are removed. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource from which delegates' set members are removed. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The identifier for the member (user, group) to be removed from the resource's delegates.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The identifier for the member (user, group) to be removed from the resource's delegates.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateDelegateFromResourceInput`](crate::input::DisassociateDelegateFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateDelegateFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateDelegateFromResourceInput {
                organization_id: self.organization_id,
                resource_id: self.resource_id,
                entity_id: self.entity_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateDelegateFromResourceInputOperationOutputAlias =
    crate::operation::DisassociateDelegateFromResource;
#[doc(hidden)]
pub type DisassociateDelegateFromResourceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateDelegateFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateDelegateFromResource`](crate::operation::DisassociateDelegateFromResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateDelegateFromResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociateDelegateFromResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociateDelegateFromResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DisassociateDelegateFromResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_delegate_from_resource(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateDelegateFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateDelegateFromResource",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociateDelegateFromResourceInput`](crate::input::DisassociateDelegateFromResourceInput)
    pub fn builder() -> crate::input::disassociate_delegate_from_resource_input::Builder {
        crate::input::disassociate_delegate_from_resource_input::Builder::default()
    }
}

/// See [`DisassociateMemberFromGroupInput`](crate::input::DisassociateMemberFromGroupInput)
pub mod disassociate_member_from_group_input {
    /// A builder for [`DisassociateMemberFromGroupInput`](crate::input::DisassociateMemberFromGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier for the group from which members are removed.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier for the group from which members are removed.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The identifier for the member to be removed to the group.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The identifier for the member to be removed to the group.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateMemberFromGroupInput`](crate::input::DisassociateMemberFromGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateMemberFromGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateMemberFromGroupInput {
                organization_id: self.organization_id,
                group_id: self.group_id,
                member_id: self.member_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateMemberFromGroupInputOperationOutputAlias =
    crate::operation::DisassociateMemberFromGroup;
#[doc(hidden)]
pub type DisassociateMemberFromGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateMemberFromGroupInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateMemberFromGroup`](crate::operation::DisassociateMemberFromGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateMemberFromGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociateMemberFromGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociateMemberFromGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.DisassociateMemberFromGroup",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_member_from_group(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateMemberFromGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateMemberFromGroup",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociateMemberFromGroupInput`](crate::input::DisassociateMemberFromGroupInput)
    pub fn builder() -> crate::input::disassociate_member_from_group_input::Builder {
        crate::input::disassociate_member_from_group_input::Builder::default()
    }
}

/// See [`GetAccessControlEffectInput`](crate::input::GetAccessControlEffectInput)
pub mod get_access_control_effect_input {
    /// A builder for [`GetAccessControlEffectInput`](crate::input::GetAccessControlEffectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The IPv4 address.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IPv4 address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The access protocol action. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The access protocol action. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessControlEffectInput`](crate::input::GetAccessControlEffectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessControlEffectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccessControlEffectInput {
                organization_id: self.organization_id,
                ip_address: self.ip_address,
                action: self.action,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccessControlEffectInputOperationOutputAlias = crate::operation::GetAccessControlEffect;
#[doc(hidden)]
pub type GetAccessControlEffectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccessControlEffectInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessControlEffect`](crate::operation::GetAccessControlEffect)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessControlEffect,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAccessControlEffectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAccessControlEffectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.GetAccessControlEffect",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_access_control_effect(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessControlEffect::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessControlEffect",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAccessControlEffectInput`](crate::input::GetAccessControlEffectInput)
    pub fn builder() -> crate::input::get_access_control_effect_input::Builder {
        crate::input::get_access_control_effect_input::Builder::default()
    }
}

/// See [`GetDefaultRetentionPolicyInput`](crate::input::GetDefaultRetentionPolicyInput)
pub mod get_default_retention_policy_input {
    /// A builder for [`GetDefaultRetentionPolicyInput`](crate::input::GetDefaultRetentionPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDefaultRetentionPolicyInput`](crate::input::GetDefaultRetentionPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDefaultRetentionPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDefaultRetentionPolicyInput {
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDefaultRetentionPolicyInputOperationOutputAlias =
    crate::operation::GetDefaultRetentionPolicy;
#[doc(hidden)]
pub type GetDefaultRetentionPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDefaultRetentionPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetDefaultRetentionPolicy`](crate::operation::GetDefaultRetentionPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDefaultRetentionPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDefaultRetentionPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDefaultRetentionPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.GetDefaultRetentionPolicy",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_default_retention_policy(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDefaultRetentionPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDefaultRetentionPolicy",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDefaultRetentionPolicyInput`](crate::input::GetDefaultRetentionPolicyInput)
    pub fn builder() -> crate::input::get_default_retention_policy_input::Builder {
        crate::input::get_default_retention_policy_input::Builder::default()
    }
}

/// See [`GetMailboxDetailsInput`](crate::input::GetMailboxDetailsInput)
pub mod get_mailbox_details_input {
    /// A builder for [`GetMailboxDetailsInput`](crate::input::GetMailboxDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization that contains the user whose mailbox details are being requested.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization that contains the user whose mailbox details are being requested.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier for the user whose mailbox details are being requested.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier for the user whose mailbox details are being requested.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMailboxDetailsInput`](crate::input::GetMailboxDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMailboxDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMailboxDetailsInput {
                organization_id: self.organization_id,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMailboxDetailsInputOperationOutputAlias = crate::operation::GetMailboxDetails;
#[doc(hidden)]
pub type GetMailboxDetailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMailboxDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetMailboxDetails`](crate::operation::GetMailboxDetails)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMailboxDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMailboxDetailsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMailboxDetailsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.GetMailboxDetails",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_mailbox_details(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMailboxDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMailboxDetails",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMailboxDetailsInput`](crate::input::GetMailboxDetailsInput)
    pub fn builder() -> crate::input::get_mailbox_details_input::Builder {
        crate::input::get_mailbox_details_input::Builder::default()
    }
}

/// See [`GetMailDomainInput`](crate::input::GetMailDomainInput)
pub mod get_mail_domain_input {
    /// A builder for [`GetMailDomainInput`](crate::input::GetMailDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization for which the domain is retrieved.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which the domain is retrieved.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The domain from which you want to retrieve details.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain from which you want to retrieve details.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMailDomainInput`](crate::input::GetMailDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMailDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMailDomainInput {
                organization_id: self.organization_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMailDomainInputOperationOutputAlias = crate::operation::GetMailDomain;
#[doc(hidden)]
pub type GetMailDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMailDomainInput {
    /// Consumes the builder and constructs an Operation<[`GetMailDomain`](crate::operation::GetMailDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMailDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMailDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMailDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.GetMailDomain",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_mail_domain(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMailDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMailDomain",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMailDomainInput`](crate::input::GetMailDomainInput)
    pub fn builder() -> crate::input::get_mail_domain_input::Builder {
        crate::input::get_mail_domain_input::Builder::default()
    }
}

/// See [`GetMobileDeviceAccessEffectInput`](crate::input::GetMobileDeviceAccessEffectInput)
pub mod get_mobile_device_access_effect_input {
    /// A builder for [`GetMobileDeviceAccessEffectInput`](crate::input::GetMobileDeviceAccessEffectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) device_type: std::option::Option<std::string::String>,
        pub(crate) device_model: std::option::Option<std::string::String>,
        pub(crate) device_operating_system: std::option::Option<std::string::String>,
        pub(crate) device_user_agent: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization to simulate the access effect for.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization to simulate the access effect for.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>Device type the simulated user will report.</p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_type = Some(input.into());
            self
        }
        /// <p>Device type the simulated user will report.</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_type = input;
            self
        }
        /// <p>Device model the simulated user will report.</p>
        pub fn device_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_model = Some(input.into());
            self
        }
        /// <p>Device model the simulated user will report.</p>
        pub fn set_device_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_model = input;
            self
        }
        /// <p>Device operating system the simulated user will report.</p>
        pub fn device_operating_system(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_operating_system = Some(input.into());
            self
        }
        /// <p>Device operating system the simulated user will report.</p>
        pub fn set_device_operating_system(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_operating_system = input;
            self
        }
        /// <p>Device user agent the simulated user will report.</p>
        pub fn device_user_agent(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_user_agent = Some(input.into());
            self
        }
        /// <p>Device user agent the simulated user will report.</p>
        pub fn set_device_user_agent(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_user_agent = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMobileDeviceAccessEffectInput`](crate::input::GetMobileDeviceAccessEffectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMobileDeviceAccessEffectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMobileDeviceAccessEffectInput {
                organization_id: self.organization_id,
                device_type: self.device_type,
                device_model: self.device_model,
                device_operating_system: self.device_operating_system,
                device_user_agent: self.device_user_agent,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMobileDeviceAccessEffectInputOperationOutputAlias =
    crate::operation::GetMobileDeviceAccessEffect;
#[doc(hidden)]
pub type GetMobileDeviceAccessEffectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMobileDeviceAccessEffectInput {
    /// Consumes the builder and constructs an Operation<[`GetMobileDeviceAccessEffect`](crate::operation::GetMobileDeviceAccessEffect)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMobileDeviceAccessEffect,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMobileDeviceAccessEffectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMobileDeviceAccessEffectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.GetMobileDeviceAccessEffect",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_mobile_device_access_effect(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMobileDeviceAccessEffect::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMobileDeviceAccessEffect",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMobileDeviceAccessEffectInput`](crate::input::GetMobileDeviceAccessEffectInput)
    pub fn builder() -> crate::input::get_mobile_device_access_effect_input::Builder {
        crate::input::get_mobile_device_access_effect_input::Builder::default()
    }
}

/// See [`GetMobileDeviceAccessOverrideInput`](crate::input::GetMobileDeviceAccessOverrideInput)
pub mod get_mobile_device_access_override_input {
    /// A builder for [`GetMobileDeviceAccessOverrideInput`](crate::input::GetMobileDeviceAccessOverrideInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization to which you want to apply the override.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization to which you want to apply the override.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>Identifies the WorkMail user for the override. Accepts the following types of user identities: </p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>Identifies the WorkMail user for the override. Accepts the following types of user identities: </p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The mobile device to which the override applies. <code>DeviceId</code> is case insensitive.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The mobile device to which the override applies. <code>DeviceId</code> is case insensitive.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMobileDeviceAccessOverrideInput`](crate::input::GetMobileDeviceAccessOverrideInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMobileDeviceAccessOverrideInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMobileDeviceAccessOverrideInput {
                organization_id: self.organization_id,
                user_id: self.user_id,
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMobileDeviceAccessOverrideInputOperationOutputAlias =
    crate::operation::GetMobileDeviceAccessOverride;
#[doc(hidden)]
pub type GetMobileDeviceAccessOverrideInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetMobileDeviceAccessOverrideInput {
    /// Consumes the builder and constructs an Operation<[`GetMobileDeviceAccessOverride`](crate::operation::GetMobileDeviceAccessOverride)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMobileDeviceAccessOverride,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMobileDeviceAccessOverrideInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMobileDeviceAccessOverrideInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.GetMobileDeviceAccessOverride",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_mobile_device_access_override(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMobileDeviceAccessOverride::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMobileDeviceAccessOverride",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMobileDeviceAccessOverrideInput`](crate::input::GetMobileDeviceAccessOverrideInput)
    pub fn builder() -> crate::input::get_mobile_device_access_override_input::Builder {
        crate::input::get_mobile_device_access_override_input::Builder::default()
    }
}

/// See [`ListAccessControlRulesInput`](crate::input::ListAccessControlRulesInput)
pub mod list_access_control_rules_input {
    /// A builder for [`ListAccessControlRulesInput`](crate::input::ListAccessControlRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessControlRulesInput`](crate::input::ListAccessControlRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccessControlRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccessControlRulesInput {
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccessControlRulesInputOperationOutputAlias = crate::operation::ListAccessControlRules;
#[doc(hidden)]
pub type ListAccessControlRulesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAccessControlRulesInput {
    /// Consumes the builder and constructs an Operation<[`ListAccessControlRules`](crate::operation::ListAccessControlRules)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccessControlRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAccessControlRulesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAccessControlRulesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListAccessControlRules",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_access_control_rules(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccessControlRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccessControlRules",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAccessControlRulesInput`](crate::input::ListAccessControlRulesInput)
    pub fn builder() -> crate::input::list_access_control_rules_input::Builder {
        crate::input::list_access_control_rules_input::Builder::default()
    }
}

/// See [`ListAliasesInput`](crate::input::ListAliasesInput)
pub mod list_aliases_input {
    /// A builder for [`ListAliasesInput`](crate::input::ListAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the entity exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the entity exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier for the entity for which to list the aliases.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The identifier for the entity for which to list the aliases.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAliasesInput`](crate::input::ListAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAliasesInput {
                organization_id: self.organization_id,
                entity_id: self.entity_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAliasesInputOperationOutputAlias = crate::operation::ListAliases;
#[doc(hidden)]
pub type ListAliasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAliasesInput {
    /// Consumes the builder and constructs an Operation<[`ListAliases`](crate::operation::ListAliases)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAliases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAliasesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAliasesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListAliases",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_aliases(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAliases",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAliasesInput`](crate::input::ListAliasesInput)
    pub fn builder() -> crate::input::list_aliases_input::Builder {
        crate::input::list_aliases_input::Builder::default()
    }
}

/// See [`ListGroupMembersInput`](crate::input::ListGroupMembersInput)
pub mod list_group_members_input {
    /// A builder for [`ListGroupMembersInput`](crate::input::ListGroupMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier for the group to which the members (users or groups) are associated.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier for the group to which the members (users or groups) are associated.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p> The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupMembersInput`](crate::input::ListGroupMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupMembersInput {
                organization_id: self.organization_id,
                group_id: self.group_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupMembersInputOperationOutputAlias = crate::operation::ListGroupMembers;
#[doc(hidden)]
pub type ListGroupMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGroupMembersInput {
    /// Consumes the builder and constructs an Operation<[`ListGroupMembers`](crate::operation::ListGroupMembers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroupMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListGroupMembersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListGroupMembersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListGroupMembers",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_group_members(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroupMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroupMembers",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListGroupMembersInput`](crate::input::ListGroupMembersInput)
    pub fn builder() -> crate::input::list_group_members_input::Builder {
        crate::input::list_group_members_input::Builder::default()
    }
}

/// See [`ListGroupsInput`](crate::input::ListGroupsInput)
pub mod list_groups_input {
    /// A builder for [`ListGroupsInput`](crate::input::ListGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the groups exist.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the groups exist.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsInput`](crate::input::ListGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupsInput {
                organization_id: self.organization_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupsInputOperationOutputAlias = crate::operation::ListGroups;
#[doc(hidden)]
pub type ListGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListGroups`](crate::operation::ListGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListGroups",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_groups(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroups",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListGroupsInput`](crate::input::ListGroupsInput)
    pub fn builder() -> crate::input::list_groups_input::Builder {
        crate::input::list_groups_input::Builder::default()
    }
}

/// See [`ListMailboxExportJobsInput`](crate::input::ListMailboxExportJobsInput)
pub mod list_mailbox_export_jobs_input {
    /// A builder for [`ListMailboxExportJobsInput`](crate::input::ListMailboxExportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMailboxExportJobsInput`](crate::input::ListMailboxExportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMailboxExportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMailboxExportJobsInput {
                organization_id: self.organization_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMailboxExportJobsInputOperationOutputAlias = crate::operation::ListMailboxExportJobs;
#[doc(hidden)]
pub type ListMailboxExportJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMailboxExportJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListMailboxExportJobs`](crate::operation::ListMailboxExportJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMailboxExportJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListMailboxExportJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListMailboxExportJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListMailboxExportJobs",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_mailbox_export_jobs(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMailboxExportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMailboxExportJobs",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListMailboxExportJobsInput`](crate::input::ListMailboxExportJobsInput)
    pub fn builder() -> crate::input::list_mailbox_export_jobs_input::Builder {
        crate::input::list_mailbox_export_jobs_input::Builder::default()
    }
}

/// See [`ListMailboxPermissionsInput`](crate::input::ListMailboxPermissionsInput)
pub mod list_mailbox_permissions_input {
    /// A builder for [`ListMailboxPermissionsInput`](crate::input::ListMailboxPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the user, group, or resource for which to list mailbox permissions.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user, group, or resource for which to list mailbox permissions.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMailboxPermissionsInput`](crate::input::ListMailboxPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMailboxPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMailboxPermissionsInput {
                organization_id: self.organization_id,
                entity_id: self.entity_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMailboxPermissionsInputOperationOutputAlias = crate::operation::ListMailboxPermissions;
#[doc(hidden)]
pub type ListMailboxPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMailboxPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`ListMailboxPermissions`](crate::operation::ListMailboxPermissions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMailboxPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListMailboxPermissionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListMailboxPermissionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListMailboxPermissions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_mailbox_permissions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMailboxPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMailboxPermissions",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListMailboxPermissionsInput`](crate::input::ListMailboxPermissionsInput)
    pub fn builder() -> crate::input::list_mailbox_permissions_input::Builder {
        crate::input::list_mailbox_permissions_input::Builder::default()
    }
}

/// See [`ListMailDomainsInput`](crate::input::ListMailDomainsInput)
pub mod list_mail_domains_input {
    /// A builder for [`ListMailDomainsInput`](crate::input::ListMailDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMailDomainsInput`](crate::input::ListMailDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMailDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMailDomainsInput {
                organization_id: self.organization_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMailDomainsInputOperationOutputAlias = crate::operation::ListMailDomains;
#[doc(hidden)]
pub type ListMailDomainsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMailDomainsInput {
    /// Consumes the builder and constructs an Operation<[`ListMailDomains`](crate::operation::ListMailDomains)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMailDomains,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListMailDomainsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListMailDomainsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListMailDomains",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_mail_domains(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMailDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMailDomains",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListMailDomainsInput`](crate::input::ListMailDomainsInput)
    pub fn builder() -> crate::input::list_mail_domains_input::Builder {
        crate::input::list_mail_domains_input::Builder::default()
    }
}

/// See [`ListMobileDeviceAccessOverridesInput`](crate::input::ListMobileDeviceAccessOverridesInput)
pub mod list_mobile_device_access_overrides_input {
    /// A builder for [`ListMobileDeviceAccessOverridesInput`](crate::input::ListMobileDeviceAccessOverridesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization under which to list mobile device access overrides.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization under which to list mobile device access overrides.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The mobile device to which the access override applies.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The mobile device to which the access override applies.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMobileDeviceAccessOverridesInput`](crate::input::ListMobileDeviceAccessOverridesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMobileDeviceAccessOverridesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMobileDeviceAccessOverridesInput {
                organization_id: self.organization_id,
                user_id: self.user_id,
                device_id: self.device_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMobileDeviceAccessOverridesInputOperationOutputAlias =
    crate::operation::ListMobileDeviceAccessOverrides;
#[doc(hidden)]
pub type ListMobileDeviceAccessOverridesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListMobileDeviceAccessOverridesInput {
    /// Consumes the builder and constructs an Operation<[`ListMobileDeviceAccessOverrides`](crate::operation::ListMobileDeviceAccessOverrides)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMobileDeviceAccessOverrides,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListMobileDeviceAccessOverridesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListMobileDeviceAccessOverridesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListMobileDeviceAccessOverrides",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_mobile_device_access_overrides(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMobileDeviceAccessOverrides::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMobileDeviceAccessOverrides",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListMobileDeviceAccessOverridesInput`](crate::input::ListMobileDeviceAccessOverridesInput)
    pub fn builder() -> crate::input::list_mobile_device_access_overrides_input::Builder {
        crate::input::list_mobile_device_access_overrides_input::Builder::default()
    }
}

/// See [`ListMobileDeviceAccessRulesInput`](crate::input::ListMobileDeviceAccessRulesInput)
pub mod list_mobile_device_access_rules_input {
    /// A builder for [`ListMobileDeviceAccessRulesInput`](crate::input::ListMobileDeviceAccessRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization for which to list the rules.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which to list the rules.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMobileDeviceAccessRulesInput`](crate::input::ListMobileDeviceAccessRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMobileDeviceAccessRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMobileDeviceAccessRulesInput {
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMobileDeviceAccessRulesInputOperationOutputAlias =
    crate::operation::ListMobileDeviceAccessRules;
#[doc(hidden)]
pub type ListMobileDeviceAccessRulesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMobileDeviceAccessRulesInput {
    /// Consumes the builder and constructs an Operation<[`ListMobileDeviceAccessRules`](crate::operation::ListMobileDeviceAccessRules)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMobileDeviceAccessRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListMobileDeviceAccessRulesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListMobileDeviceAccessRulesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListMobileDeviceAccessRules",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_mobile_device_access_rules(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMobileDeviceAccessRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMobileDeviceAccessRules",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListMobileDeviceAccessRulesInput`](crate::input::ListMobileDeviceAccessRulesInput)
    pub fn builder() -> crate::input::list_mobile_device_access_rules_input::Builder {
        crate::input::list_mobile_device_access_rules_input::Builder::default()
    }
}

/// See [`ListOrganizationsInput`](crate::input::ListOrganizationsInput)
pub mod list_organizations_input {
    /// A builder for [`ListOrganizationsInput`](crate::input::ListOrganizationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOrganizationsInput`](crate::input::ListOrganizationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOrganizationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOrganizationsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOrganizationsInputOperationOutputAlias = crate::operation::ListOrganizations;
#[doc(hidden)]
pub type ListOrganizationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOrganizationsInput {
    /// Consumes the builder and constructs an Operation<[`ListOrganizations`](crate::operation::ListOrganizations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOrganizations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListOrganizationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListOrganizationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListOrganizations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_organizations(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOrganizations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOrganizations",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListOrganizationsInput`](crate::input::ListOrganizationsInput)
    pub fn builder() -> crate::input::list_organizations_input::Builder {
        crate::input::list_organizations_input::Builder::default()
    }
}

/// See [`ListResourceDelegatesInput`](crate::input::ListResourceDelegatesInput)
pub mod list_resource_delegates_input {
    /// A builder for [`ListResourceDelegatesInput`](crate::input::ListResourceDelegatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the organization that contains the resource for which delegates are listed.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization that contains the resource for which delegates are listed.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier for the resource whose delegates are listed.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier for the resource whose delegates are listed.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The token used to paginate through the delegates associated with a resource.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used to paginate through the delegates associated with a resource.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of maximum results in a page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of maximum results in a page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceDelegatesInput`](crate::input::ListResourceDelegatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceDelegatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceDelegatesInput {
                organization_id: self.organization_id,
                resource_id: self.resource_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceDelegatesInputOperationOutputAlias = crate::operation::ListResourceDelegates;
#[doc(hidden)]
pub type ListResourceDelegatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListResourceDelegatesInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceDelegates`](crate::operation::ListResourceDelegates)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceDelegates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListResourceDelegatesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListResourceDelegatesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListResourceDelegates",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_resource_delegates(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceDelegates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceDelegates",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListResourceDelegatesInput`](crate::input::ListResourceDelegatesInput)
    pub fn builder() -> crate::input::list_resource_delegates_input::Builder {
        crate::input::list_resource_delegates_input::Builder::default()
    }
}

/// See [`ListResourcesInput`](crate::input::ListResourcesInput)
pub mod list_resources_input {
    /// A builder for [`ListResourcesInput`](crate::input::ListResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the resources exist.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the resources exist.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesInput`](crate::input::ListResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourcesInput {
                organization_id: self.organization_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourcesInputOperationOutputAlias = crate::operation::ListResources;
#[doc(hidden)]
pub type ListResourcesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListResources`](crate::operation::ListResources)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListResourcesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListResourcesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListResources",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_resources(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResources",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListResourcesInput`](crate::input::ListResourcesInput)
    pub fn builder() -> crate::input::list_resources_input::Builder {
        crate::input::list_resources_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListTagsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListUsersInput`](crate::input::ListUsersInput)
pub mod list_users_input {
    /// A builder for [`ListUsersInput`](crate::input::ListUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the users exist.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the users exist.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersInput`](crate::input::ListUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListUsersInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListUsersInput {
                organization_id: self.organization_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUsersInputOperationOutputAlias = crate::operation::ListUsers;
#[doc(hidden)]
pub type ListUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUsersInput {
    /// Consumes the builder and constructs an Operation<[`ListUsers`](crate::operation::ListUsers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListUsersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListUsersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ListUsers",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_users(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListUsers::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListUsers",
                    "workmail",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
}

/// See [`PutAccessControlRuleInput`](crate::input::PutAccessControlRuleInput)
pub mod put_access_control_rule_input {
    /// A builder for [`PutAccessControlRuleInput`](crate::input::PutAccessControlRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) effect: std::option::Option<crate::model::AccessControlRuleEffect>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ip_ranges: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_ip_ranges: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The rule name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The rule name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The rule effect.</p>
        pub fn effect(mut self, input: crate::model::AccessControlRuleEffect) -> Self {
            self.effect = Some(input);
            self
        }
        /// <p>The rule effect.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::AccessControlRuleEffect>,
        ) -> Self {
            self.effect = input;
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ip_ranges`.
        ///
        /// To override the contents of this collection use [`set_ip_ranges`](Self::set_ip_ranges).
        ///
        /// <p>IPv4 CIDR ranges to include in the rule.</p>
        pub fn ip_ranges(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_ranges.unwrap_or_default();
            v.push(input.into());
            self.ip_ranges = Some(v);
            self
        }
        /// <p>IPv4 CIDR ranges to include in the rule.</p>
        pub fn set_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_ranges = input;
            self
        }
        /// Appends an item to `not_ip_ranges`.
        ///
        /// To override the contents of this collection use [`set_not_ip_ranges`](Self::set_not_ip_ranges).
        ///
        /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
        pub fn not_ip_ranges(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_ip_ranges.unwrap_or_default();
            v.push(input.into());
            self.not_ip_ranges = Some(v);
            self
        }
        /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
        pub fn set_not_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_ip_ranges = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Appends an item to `not_actions`.
        ///
        /// To override the contents of this collection use [`set_not_actions`](Self::set_not_actions).
        ///
        /// <p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn not_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_actions.unwrap_or_default();
            v.push(input.into());
            self.not_actions = Some(v);
            self
        }
        /// <p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_not_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_actions = input;
            self
        }
        /// Appends an item to `user_ids`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>User IDs to include in the rule.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids.unwrap_or_default();
            v.push(input.into());
            self.user_ids = Some(v);
            self
        }
        /// <p>User IDs to include in the rule.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids = input;
            self
        }
        /// Appends an item to `not_user_ids`.
        ///
        /// To override the contents of this collection use [`set_not_user_ids`](Self::set_not_user_ids).
        ///
        /// <p>User IDs to exclude from the rule.</p>
        pub fn not_user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_user_ids.unwrap_or_default();
            v.push(input.into());
            self.not_user_ids = Some(v);
            self
        }
        /// <p>User IDs to exclude from the rule.</p>
        pub fn set_not_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_user_ids = input;
            self
        }
        /// <p>The identifier of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccessControlRuleInput`](crate::input::PutAccessControlRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccessControlRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAccessControlRuleInput {
                name: self.name,
                effect: self.effect,
                description: self.description,
                ip_ranges: self.ip_ranges,
                not_ip_ranges: self.not_ip_ranges,
                actions: self.actions,
                not_actions: self.not_actions,
                user_ids: self.user_ids,
                not_user_ids: self.not_user_ids,
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAccessControlRuleInputOperationOutputAlias = crate::operation::PutAccessControlRule;
#[doc(hidden)]
pub type PutAccessControlRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutAccessControlRuleInput {
    /// Consumes the builder and constructs an Operation<[`PutAccessControlRule`](crate::operation::PutAccessControlRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccessControlRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutAccessControlRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutAccessControlRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.PutAccessControlRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_access_control_rule(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccessControlRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccessControlRule",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutAccessControlRuleInput`](crate::input::PutAccessControlRuleInput)
    pub fn builder() -> crate::input::put_access_control_rule_input::Builder {
        crate::input::put_access_control_rule_input::Builder::default()
    }
}

/// See [`PutEmailMonitoringConfigurationInput`](crate::input::PutEmailMonitoringConfigurationInput)
pub mod put_email_monitoring_configuration_input {
    /// A builder for [`PutEmailMonitoringConfigurationInput`](crate::input::PutEmailMonitoringConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) log_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the organization for which the email monitoring configuration is set.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization for which the email monitoring configuration is set.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.</p>
        pub fn log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.</p>
        pub fn set_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEmailMonitoringConfigurationInput`](crate::input::PutEmailMonitoringConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEmailMonitoringConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEmailMonitoringConfigurationInput {
                organization_id: self.organization_id,
                role_arn: self.role_arn,
                log_group_arn: self.log_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEmailMonitoringConfigurationInputOperationOutputAlias =
    crate::operation::PutEmailMonitoringConfiguration;
#[doc(hidden)]
pub type PutEmailMonitoringConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutEmailMonitoringConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutEmailMonitoringConfiguration`](crate::operation::PutEmailMonitoringConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEmailMonitoringConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutEmailMonitoringConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutEmailMonitoringConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.PutEmailMonitoringConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_email_monitoring_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEmailMonitoringConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEmailMonitoringConfiguration",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutEmailMonitoringConfigurationInput`](crate::input::PutEmailMonitoringConfigurationInput)
    pub fn builder() -> crate::input::put_email_monitoring_configuration_input::Builder {
        crate::input::put_email_monitoring_configuration_input::Builder::default()
    }
}

/// See [`PutInboundDmarcSettingsInput`](crate::input::PutInboundDmarcSettingsInput)
pub mod put_inbound_dmarc_settings_input {
    /// A builder for [`PutInboundDmarcSettingsInput`](crate::input::PutInboundDmarcSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) enforced: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the organization that you are applying the DMARC policy to. </p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization that you are applying the DMARC policy to. </p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>Enforces or suspends a policy after it's applied.</p>
        pub fn enforced(mut self, input: bool) -> Self {
            self.enforced = Some(input);
            self
        }
        /// <p>Enforces or suspends a policy after it's applied.</p>
        pub fn set_enforced(mut self, input: std::option::Option<bool>) -> Self {
            self.enforced = input;
            self
        }
        /// Consumes the builder and constructs a [`PutInboundDmarcSettingsInput`](crate::input::PutInboundDmarcSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutInboundDmarcSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutInboundDmarcSettingsInput {
                organization_id: self.organization_id,
                enforced: self.enforced,
            })
        }
    }
}
#[doc(hidden)]
pub type PutInboundDmarcSettingsInputOperationOutputAlias =
    crate::operation::PutInboundDmarcSettings;
#[doc(hidden)]
pub type PutInboundDmarcSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutInboundDmarcSettingsInput {
    /// Consumes the builder and constructs an Operation<[`PutInboundDmarcSettings`](crate::operation::PutInboundDmarcSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutInboundDmarcSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutInboundDmarcSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutInboundDmarcSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.PutInboundDmarcSettings",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_inbound_dmarc_settings(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutInboundDmarcSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutInboundDmarcSettings",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutInboundDmarcSettingsInput`](crate::input::PutInboundDmarcSettingsInput)
    pub fn builder() -> crate::input::put_inbound_dmarc_settings_input::Builder {
        crate::input::put_inbound_dmarc_settings_input::Builder::default()
    }
}

/// See [`PutMailboxPermissionsInput`](crate::input::PutMailboxPermissionsInput)
pub mod put_mailbox_permissions_input {
    /// A builder for [`PutMailboxPermissionsInput`](crate::input::PutMailboxPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) grantee_id: std::option::Option<std::string::String>,
        pub(crate) permission_values:
            std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
    }
    impl Builder {
        /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the user, group, or resource for which to update mailbox permissions.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user, group, or resource for which to update mailbox permissions.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The identifier of the user, group, or resource to which to grant the permissions.</p>
        pub fn grantee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user, group, or resource to which to grant the permissions.</p>
        pub fn set_grantee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantee_id = input;
            self
        }
        /// Appends an item to `permission_values`.
        ///
        /// To override the contents of this collection use [`set_permission_values`](Self::set_permission_values).
        ///
        /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>
        pub fn permission_values(mut self, input: crate::model::PermissionType) -> Self {
            let mut v = self.permission_values.unwrap_or_default();
            v.push(input);
            self.permission_values = Some(v);
            self
        }
        /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>
        pub fn set_permission_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
        ) -> Self {
            self.permission_values = input;
            self
        }
        /// Consumes the builder and constructs a [`PutMailboxPermissionsInput`](crate::input::PutMailboxPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutMailboxPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutMailboxPermissionsInput {
                organization_id: self.organization_id,
                entity_id: self.entity_id,
                grantee_id: self.grantee_id,
                permission_values: self.permission_values,
            })
        }
    }
}
#[doc(hidden)]
pub type PutMailboxPermissionsInputOperationOutputAlias = crate::operation::PutMailboxPermissions;
#[doc(hidden)]
pub type PutMailboxPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutMailboxPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`PutMailboxPermissions`](crate::operation::PutMailboxPermissions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutMailboxPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutMailboxPermissionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutMailboxPermissionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.PutMailboxPermissions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_mailbox_permissions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutMailboxPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutMailboxPermissions",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutMailboxPermissionsInput`](crate::input::PutMailboxPermissionsInput)
    pub fn builder() -> crate::input::put_mailbox_permissions_input::Builder {
        crate::input::put_mailbox_permissions_input::Builder::default()
    }
}

/// See [`PutMobileDeviceAccessOverrideInput`](crate::input::PutMobileDeviceAccessOverrideInput)
pub mod put_mobile_device_access_override_input {
    /// A builder for [`PutMobileDeviceAccessOverrideInput`](crate::input::PutMobileDeviceAccessOverrideInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) effect: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifies the Amazon WorkMail organization for which you create the override.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>Identifies the Amazon WorkMail organization for which you create the override.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The WorkMail user for which you create the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The WorkMail user for which you create the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
        /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
        /// <li> <p>User name: <code>user</code> </p> </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The mobile device for which you create the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The mobile device for which you create the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, input: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.effect = Some(input);
            self
        }
        /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.effect = input;
            self
        }
        /// <p>A description of the override.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the override.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`PutMobileDeviceAccessOverrideInput`](crate::input::PutMobileDeviceAccessOverrideInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutMobileDeviceAccessOverrideInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutMobileDeviceAccessOverrideInput {
                organization_id: self.organization_id,
                user_id: self.user_id,
                device_id: self.device_id,
                effect: self.effect,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type PutMobileDeviceAccessOverrideInputOperationOutputAlias =
    crate::operation::PutMobileDeviceAccessOverride;
#[doc(hidden)]
pub type PutMobileDeviceAccessOverrideInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutMobileDeviceAccessOverrideInput {
    /// Consumes the builder and constructs an Operation<[`PutMobileDeviceAccessOverride`](crate::operation::PutMobileDeviceAccessOverride)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutMobileDeviceAccessOverride,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutMobileDeviceAccessOverrideInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutMobileDeviceAccessOverrideInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.PutMobileDeviceAccessOverride",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_mobile_device_access_override(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutMobileDeviceAccessOverride::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutMobileDeviceAccessOverride",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutMobileDeviceAccessOverrideInput`](crate::input::PutMobileDeviceAccessOverrideInput)
    pub fn builder() -> crate::input::put_mobile_device_access_override_input::Builder {
        crate::input::put_mobile_device_access_override_input::Builder::default()
    }
}

/// See [`PutRetentionPolicyInput`](crate::input::PutRetentionPolicyInput)
pub mod put_retention_policy_input {
    /// A builder for [`PutRetentionPolicyInput`](crate::input::PutRetentionPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) folder_configurations:
            std::option::Option<std::vec::Vec<crate::model::FolderConfiguration>>,
    }
    impl Builder {
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The retention policy name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The retention policy name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The retention policy description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The retention policy description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `folder_configurations`.
        ///
        /// To override the contents of this collection use [`set_folder_configurations`](Self::set_folder_configurations).
        ///
        /// <p>The retention policy folder configurations.</p>
        pub fn folder_configurations(mut self, input: crate::model::FolderConfiguration) -> Self {
            let mut v = self.folder_configurations.unwrap_or_default();
            v.push(input);
            self.folder_configurations = Some(v);
            self
        }
        /// <p>The retention policy folder configurations.</p>
        pub fn set_folder_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderConfiguration>>,
        ) -> Self {
            self.folder_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRetentionPolicyInput`](crate::input::PutRetentionPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRetentionPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRetentionPolicyInput {
                organization_id: self.organization_id,
                id: self.id,
                name: self.name,
                description: self.description,
                folder_configurations: self.folder_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRetentionPolicyInputOperationOutputAlias = crate::operation::PutRetentionPolicy;
#[doc(hidden)]
pub type PutRetentionPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutRetentionPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutRetentionPolicy`](crate::operation::PutRetentionPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRetentionPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutRetentionPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutRetentionPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.PutRetentionPolicy",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_retention_policy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRetentionPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRetentionPolicy",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutRetentionPolicyInput`](crate::input::PutRetentionPolicyInput)
    pub fn builder() -> crate::input::put_retention_policy_input::Builder {
        crate::input::put_retention_policy_input::Builder::default()
    }
}

/// See [`RegisterMailDomainInput`](crate::input::RegisterMailDomainInput)
pub mod register_mail_domain_input {
    /// A builder for [`RegisterMailDomainInput`](crate::input::RegisterMailDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Idempotency token used when retrying requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Idempotency token used when retrying requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon WorkMail organization under which you're creating the domain.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization under which you're creating the domain.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The name of the mail domain to create in Amazon WorkMail and SES.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the mail domain to create in Amazon WorkMail and SES.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterMailDomainInput`](crate::input::RegisterMailDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterMailDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterMailDomainInput {
                client_token: self.client_token,
                organization_id: self.organization_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterMailDomainInputOperationOutputAlias = crate::operation::RegisterMailDomain;
#[doc(hidden)]
pub type RegisterMailDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterMailDomainInput {
    /// Consumes the builder and constructs an Operation<[`RegisterMailDomain`](crate::operation::RegisterMailDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterMailDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::RegisterMailDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RegisterMailDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.RegisterMailDomain",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_register_mail_domain(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterMailDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterMailDomain",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RegisterMailDomainInput`](crate::input::RegisterMailDomainInput)
    pub fn builder() -> crate::input::register_mail_domain_input::Builder {
        crate::input::register_mail_domain_input::Builder::default()
    }
}

/// See [`RegisterToWorkMailInput`](crate::input::RegisterToWorkMailInput)
pub mod register_to_work_mail_input {
    /// A builder for [`RegisterToWorkMailInput`](crate::input::RegisterToWorkMailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the organization under which the user, group, or resource exists.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization under which the user, group, or resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier for the user, group, or resource to be updated.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The identifier for the user, group, or resource to be updated.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The email for the user, group, or resource to be updated.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email for the user, group, or resource to be updated.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterToWorkMailInput`](crate::input::RegisterToWorkMailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterToWorkMailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterToWorkMailInput {
                organization_id: self.organization_id,
                entity_id: self.entity_id,
                email: self.email,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterToWorkMailInputOperationOutputAlias = crate::operation::RegisterToWorkMail;
#[doc(hidden)]
pub type RegisterToWorkMailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterToWorkMailInput {
    /// Consumes the builder and constructs an Operation<[`RegisterToWorkMail`](crate::operation::RegisterToWorkMail)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterToWorkMail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RegisterToWorkMailInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RegisterToWorkMailInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.RegisterToWorkMail",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_register_to_work_mail(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterToWorkMail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterToWorkMail",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RegisterToWorkMailInput`](crate::input::RegisterToWorkMailInput)
    pub fn builder() -> crate::input::register_to_work_mail_input::Builder {
        crate::input::register_to_work_mail_input::Builder::default()
    }
}

/// See [`ResetPasswordInput`](crate::input::ResetPasswordInput)
pub mod reset_password_input {
    /// A builder for [`ResetPasswordInput`](crate::input::ResetPasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the organization that contains the user for which the password is reset.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier of the organization that contains the user for which the password is reset.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the user for whom the password is reset.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user for whom the password is reset.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The new password for the user.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The new password for the user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetPasswordInput`](crate::input::ResetPasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetPasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetPasswordInput {
                organization_id: self.organization_id,
                user_id: self.user_id,
                password: self.password,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetPasswordInputOperationOutputAlias = crate::operation::ResetPassword;
#[doc(hidden)]
pub type ResetPasswordInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResetPasswordInput {
    /// Consumes the builder and constructs an Operation<[`ResetPassword`](crate::operation::ResetPassword)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetPassword,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ResetPasswordInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ResetPasswordInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.ResetPassword",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_reset_password(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetPassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetPassword",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ResetPasswordInput`](crate::input::ResetPasswordInput)
    pub fn builder() -> crate::input::reset_password_input::Builder {
        crate::input::reset_password_input::Builder::default()
    }
}

/// See [`StartMailboxExportJobInput`](crate::input::StartMailboxExportJobInput)
pub mod start_mailbox_export_job_input {
    /// A builder for [`StartMailboxExportJobInput`](crate::input::StartMailboxExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The idempotency token for the client request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The identifier associated with the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier associated with the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the user or resource associated with the mailbox.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user or resource associated with the mailbox.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The mailbox export job description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The mailbox export job description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3 bucket.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3 bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The S3 bucket prefix.</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_prefix = Some(input.into());
            self
        }
        /// <p>The S3 bucket prefix.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMailboxExportJobInput`](crate::input::StartMailboxExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartMailboxExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartMailboxExportJobInput {
                client_token: self.client_token,
                organization_id: self.organization_id,
                entity_id: self.entity_id,
                description: self.description,
                role_arn: self.role_arn,
                kms_key_arn: self.kms_key_arn,
                s3_bucket_name: self.s3_bucket_name,
                s3_prefix: self.s3_prefix,
            })
        }
    }
}
#[doc(hidden)]
pub type StartMailboxExportJobInputOperationOutputAlias = crate::operation::StartMailboxExportJob;
#[doc(hidden)]
pub type StartMailboxExportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartMailboxExportJobInput {
    /// Consumes the builder and constructs an Operation<[`StartMailboxExportJob`](crate::operation::StartMailboxExportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartMailboxExportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartMailboxExportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartMailboxExportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.StartMailboxExportJob",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_mailbox_export_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartMailboxExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartMailboxExportJob",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartMailboxExportJobInput`](crate::input::StartMailboxExportJobInput)
    pub fn builder() -> crate::input::start_mailbox_export_job_input::Builder {
        crate::input::start_mailbox_export_job_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.TagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.UntagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDefaultMailDomainInput`](crate::input::UpdateDefaultMailDomainInput)
pub mod update_default_mail_domain_input {
    /// A builder for [`UpdateDefaultMailDomainInput`](crate::input::UpdateDefaultMailDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The domain name that will become the default domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name that will become the default domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDefaultMailDomainInput`](crate::input::UpdateDefaultMailDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDefaultMailDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDefaultMailDomainInput {
                organization_id: self.organization_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDefaultMailDomainInputOperationOutputAlias =
    crate::operation::UpdateDefaultMailDomain;
#[doc(hidden)]
pub type UpdateDefaultMailDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDefaultMailDomainInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDefaultMailDomain`](crate::operation::UpdateDefaultMailDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDefaultMailDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDefaultMailDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDefaultMailDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.UpdateDefaultMailDomain",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_default_mail_domain(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDefaultMailDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDefaultMailDomain",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDefaultMailDomainInput`](crate::input::UpdateDefaultMailDomainInput)
    pub fn builder() -> crate::input::update_default_mail_domain_input::Builder {
        crate::input::update_default_mail_domain_input::Builder::default()
    }
}

/// See [`UpdateMailboxQuotaInput`](crate::input::UpdateMailboxQuotaInput)
pub mod update_mailbox_quota_input {
    /// A builder for [`UpdateMailboxQuotaInput`](crate::input::UpdateMailboxQuotaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) mailbox_quota: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the organization that contains the user for whom to update the mailbox quota.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier for the organization that contains the user for whom to update the mailbox quota.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifer for the user for whom to update the mailbox quota.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifer for the user for whom to update the mailbox quota.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The updated mailbox quota, in MB, for the specified user.</p>
        pub fn mailbox_quota(mut self, input: i32) -> Self {
            self.mailbox_quota = Some(input);
            self
        }
        /// <p>The updated mailbox quota, in MB, for the specified user.</p>
        pub fn set_mailbox_quota(mut self, input: std::option::Option<i32>) -> Self {
            self.mailbox_quota = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMailboxQuotaInput`](crate::input::UpdateMailboxQuotaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMailboxQuotaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMailboxQuotaInput {
                organization_id: self.organization_id,
                user_id: self.user_id,
                mailbox_quota: self.mailbox_quota,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMailboxQuotaInputOperationOutputAlias = crate::operation::UpdateMailboxQuota;
#[doc(hidden)]
pub type UpdateMailboxQuotaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMailboxQuotaInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMailboxQuota`](crate::operation::UpdateMailboxQuota)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMailboxQuota,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateMailboxQuotaInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateMailboxQuotaInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.UpdateMailboxQuota",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_mailbox_quota(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMailboxQuota::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMailboxQuota",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateMailboxQuotaInput`](crate::input::UpdateMailboxQuotaInput)
    pub fn builder() -> crate::input::update_mailbox_quota_input::Builder {
        crate::input::update_mailbox_quota_input::Builder::default()
    }
}

/// See [`UpdateMobileDeviceAccessRuleInput`](crate::input::UpdateMobileDeviceAccessRuleInput)
pub mod update_mobile_device_access_rule_input {
    /// A builder for [`UpdateMobileDeviceAccessRuleInput`](crate::input::UpdateMobileDeviceAccessRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) mobile_device_access_rule_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) effect: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        pub(crate) device_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_models: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_models: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_operating_systems:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_operating_systems:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon WorkMail organization under which the rule will be updated.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The Amazon WorkMail organization under which the rule will be updated.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the rule to be updated.</p>
        pub fn mobile_device_access_rule_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.mobile_device_access_rule_id = Some(input.into());
            self
        }
        /// <p>The identifier of the rule to be updated.</p>
        pub fn set_mobile_device_access_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mobile_device_access_rule_id = input;
            self
        }
        /// <p>The updated rule name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated rule name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, input: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.effect = Some(input);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.effect = input;
            self
        }
        /// Appends an item to `device_types`.
        ///
        /// To override the contents of this collection use [`set_device_types`](Self::set_device_types).
        ///
        /// <p>Device types that the updated rule will match.</p>
        pub fn device_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_types.unwrap_or_default();
            v.push(input.into());
            self.device_types = Some(v);
            self
        }
        /// <p>Device types that the updated rule will match.</p>
        pub fn set_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_types = input;
            self
        }
        /// Appends an item to `not_device_types`.
        ///
        /// To override the contents of this collection use [`set_not_device_types`](Self::set_not_device_types).
        ///
        /// <p>Device types that the updated rule <b>will not</b> match. All other device types will match.</p>
        pub fn not_device_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_device_types.unwrap_or_default();
            v.push(input.into());
            self.not_device_types = Some(v);
            self
        }
        /// <p>Device types that the updated rule <b>will not</b> match. All other device types will match.</p>
        pub fn set_not_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_types = input;
            self
        }
        /// Appends an item to `device_models`.
        ///
        /// To override the contents of this collection use [`set_device_models`](Self::set_device_models).
        ///
        /// <p>Device models that the updated rule will match.</p>
        pub fn device_models(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_models.unwrap_or_default();
            v.push(input.into());
            self.device_models = Some(v);
            self
        }
        /// <p>Device models that the updated rule will match.</p>
        pub fn set_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_models = input;
            self
        }
        /// Appends an item to `not_device_models`.
        ///
        /// To override the contents of this collection use [`set_not_device_models`](Self::set_not_device_models).
        ///
        /// <p>Device models that the updated rule <b>will not</b> match. All other device models will match.</p>
        pub fn not_device_models(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_device_models.unwrap_or_default();
            v.push(input.into());
            self.not_device_models = Some(v);
            self
        }
        /// <p>Device models that the updated rule <b>will not</b> match. All other device models will match.</p>
        pub fn set_not_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_models = input;
            self
        }
        /// Appends an item to `device_operating_systems`.
        ///
        /// To override the contents of this collection use [`set_device_operating_systems`](Self::set_device_operating_systems).
        ///
        /// <p>Device operating systems that the updated rule will match.</p>
        pub fn device_operating_systems(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_operating_systems.unwrap_or_default();
            v.push(input.into());
            self.device_operating_systems = Some(v);
            self
        }
        /// <p>Device operating systems that the updated rule will match.</p>
        pub fn set_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_operating_systems = input;
            self
        }
        /// Appends an item to `not_device_operating_systems`.
        ///
        /// To override the contents of this collection use [`set_not_device_operating_systems`](Self::set_not_device_operating_systems).
        ///
        /// <p>Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn not_device_operating_systems(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.not_device_operating_systems.unwrap_or_default();
            v.push(input.into());
            self.not_device_operating_systems = Some(v);
            self
        }
        /// <p>Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn set_not_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_operating_systems = input;
            self
        }
        /// Appends an item to `device_user_agents`.
        ///
        /// To override the contents of this collection use [`set_device_user_agents`](Self::set_device_user_agents).
        ///
        /// <p>User agents that the updated rule will match.</p>
        pub fn device_user_agents(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_user_agents.unwrap_or_default();
            v.push(input.into());
            self.device_user_agents = Some(v);
            self
        }
        /// <p>User agents that the updated rule will match.</p>
        pub fn set_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_user_agents = input;
            self
        }
        /// Appends an item to `not_device_user_agents`.
        ///
        /// To override the contents of this collection use [`set_not_device_user_agents`](Self::set_not_device_user_agents).
        ///
        /// <p>User agents that the updated rule <b>will not</b> match. All other user agents will match.</p>
        pub fn not_device_user_agents(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_device_user_agents.unwrap_or_default();
            v.push(input.into());
            self.not_device_user_agents = Some(v);
            self
        }
        /// <p>User agents that the updated rule <b>will not</b> match. All other user agents will match.</p>
        pub fn set_not_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_user_agents = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMobileDeviceAccessRuleInput`](crate::input::UpdateMobileDeviceAccessRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMobileDeviceAccessRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMobileDeviceAccessRuleInput {
                organization_id: self.organization_id,
                mobile_device_access_rule_id: self.mobile_device_access_rule_id,
                name: self.name,
                description: self.description,
                effect: self.effect,
                device_types: self.device_types,
                not_device_types: self.not_device_types,
                device_models: self.device_models,
                not_device_models: self.not_device_models,
                device_operating_systems: self.device_operating_systems,
                not_device_operating_systems: self.not_device_operating_systems,
                device_user_agents: self.device_user_agents,
                not_device_user_agents: self.not_device_user_agents,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMobileDeviceAccessRuleInputOperationOutputAlias =
    crate::operation::UpdateMobileDeviceAccessRule;
#[doc(hidden)]
pub type UpdateMobileDeviceAccessRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMobileDeviceAccessRuleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMobileDeviceAccessRule`](crate::operation::UpdateMobileDeviceAccessRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMobileDeviceAccessRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateMobileDeviceAccessRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateMobileDeviceAccessRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.UpdateMobileDeviceAccessRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_mobile_device_access_rule(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMobileDeviceAccessRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMobileDeviceAccessRule",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateMobileDeviceAccessRuleInput`](crate::input::UpdateMobileDeviceAccessRuleInput)
    pub fn builder() -> crate::input::update_mobile_device_access_rule_input::Builder {
        crate::input::update_mobile_device_access_rule_input::Builder::default()
    }
}

/// See [`UpdatePrimaryEmailAddressInput`](crate::input::UpdatePrimaryEmailAddressInput)
pub mod update_primary_email_address_input {
    /// A builder for [`UpdatePrimaryEmailAddressInput`](crate::input::UpdatePrimaryEmailAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The organization that contains the user, group, or resource to update.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The organization that contains the user, group, or resource to update.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The user, group, or resource to update.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The user, group, or resource to update.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The value of the email to be updated as primary.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The value of the email to be updated as primary.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePrimaryEmailAddressInput`](crate::input::UpdatePrimaryEmailAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePrimaryEmailAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePrimaryEmailAddressInput {
                organization_id: self.organization_id,
                entity_id: self.entity_id,
                email: self.email,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePrimaryEmailAddressInputOperationOutputAlias =
    crate::operation::UpdatePrimaryEmailAddress;
#[doc(hidden)]
pub type UpdatePrimaryEmailAddressInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePrimaryEmailAddressInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePrimaryEmailAddress`](crate::operation::UpdatePrimaryEmailAddress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePrimaryEmailAddress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePrimaryEmailAddressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePrimaryEmailAddressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.UpdatePrimaryEmailAddress",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_primary_email_address(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePrimaryEmailAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePrimaryEmailAddress",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePrimaryEmailAddressInput`](crate::input::UpdatePrimaryEmailAddressInput)
    pub fn builder() -> crate::input::update_primary_email_address_input::Builder {
        crate::input::update_primary_email_address_input::Builder::default()
    }
}

/// See [`UpdateResourceInput`](crate::input::UpdateResourceInput)
pub mod update_resource_input {
    /// A builder for [`UpdateResourceInput`](crate::input::UpdateResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) booking_options: std::option::Option<crate::model::BookingOptions>,
    }
    impl Builder {
        /// <p>The identifier associated with the organization for which the resource is updated.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier associated with the organization for which the resource is updated.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The identifier of the resource to be updated.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource to be updated.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The name of the resource to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The resource's booking options to be updated.</p>
        pub fn booking_options(mut self, input: crate::model::BookingOptions) -> Self {
            self.booking_options = Some(input);
            self
        }
        /// <p>The resource's booking options to be updated.</p>
        pub fn set_booking_options(
            mut self,
            input: std::option::Option<crate::model::BookingOptions>,
        ) -> Self {
            self.booking_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceInput`](crate::input::UpdateResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResourceInput {
                organization_id: self.organization_id,
                resource_id: self.resource_id,
                name: self.name,
                booking_options: self.booking_options,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResourceInputOperationOutputAlias = crate::operation::UpdateResource;
#[doc(hidden)]
pub type UpdateResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateResourceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResource`](crate::operation::UpdateResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "WorkMailService.UpdateResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResource",
            "workmail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateResourceInput`](crate::input::UpdateResourceInput)
    pub fn builder() -> crate::input::update_resource_input::Builder {
        crate::input::update_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceInput {
    /// <p>The identifier associated with the organization for which the resource is updated.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the resource to be updated.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The name of the resource to be updated.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The resource's booking options to be updated.</p>
    pub booking_options: std::option::Option<crate::model::BookingOptions>,
}
impl UpdateResourceInput {
    /// <p>The identifier associated with the organization for which the resource is updated.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the resource to be updated.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The name of the resource to be updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The resource's booking options to be updated.</p>
    pub fn booking_options(&self) -> std::option::Option<&crate::model::BookingOptions> {
        self.booking_options.as_ref()
    }
}
impl std::fmt::Debug for UpdateResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("name", &self.name);
        formatter.field("booking_options", &self.booking_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePrimaryEmailAddressInput {
    /// <p>The organization that contains the user, group, or resource to update.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The user, group, or resource to update.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The value of the email to be updated as primary.</p>
    pub email: std::option::Option<std::string::String>,
}
impl UpdatePrimaryEmailAddressInput {
    /// <p>The organization that contains the user, group, or resource to update.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The user, group, or resource to update.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The value of the email to be updated as primary.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
}
impl std::fmt::Debug for UpdatePrimaryEmailAddressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePrimaryEmailAddressInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("email", &self.email);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMobileDeviceAccessRuleInput {
    /// <p>The Amazon WorkMail organization under which the rule will be updated.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the rule to be updated.</p>
    pub mobile_device_access_rule_id: std::option::Option<std::string::String>,
    /// <p>The updated rule name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated rule description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
    pub effect: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
    /// <p>Device types that the updated rule will match.</p>
    pub device_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device types that the updated rule <b>will not</b> match. All other device types will match.</p>
    pub not_device_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device models that the updated rule will match.</p>
    pub device_models: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device models that the updated rule <b>will not</b> match. All other device models will match.</p>
    pub not_device_models: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device operating systems that the updated rule will match.</p>
    pub device_operating_systems: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will match.</p>
    pub not_device_operating_systems: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>User agents that the updated rule will match.</p>
    pub device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>User agents that the updated rule <b>will not</b> match. All other user agents will match.</p>
    pub not_device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateMobileDeviceAccessRuleInput {
    /// <p>The Amazon WorkMail organization under which the rule will be updated.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the rule to be updated.</p>
    pub fn mobile_device_access_rule_id(&self) -> std::option::Option<&str> {
        self.mobile_device_access_rule_id.as_deref()
    }
    /// <p>The updated rule name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The updated rule description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
    pub fn effect(&self) -> std::option::Option<&crate::model::MobileDeviceAccessRuleEffect> {
        self.effect.as_ref()
    }
    /// <p>Device types that the updated rule will match.</p>
    pub fn device_types(&self) -> std::option::Option<&[std::string::String]> {
        self.device_types.as_deref()
    }
    /// <p>Device types that the updated rule <b>will not</b> match. All other device types will match.</p>
    pub fn not_device_types(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_types.as_deref()
    }
    /// <p>Device models that the updated rule will match.</p>
    pub fn device_models(&self) -> std::option::Option<&[std::string::String]> {
        self.device_models.as_deref()
    }
    /// <p>Device models that the updated rule <b>will not</b> match. All other device models will match.</p>
    pub fn not_device_models(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_models.as_deref()
    }
    /// <p>Device operating systems that the updated rule will match.</p>
    pub fn device_operating_systems(&self) -> std::option::Option<&[std::string::String]> {
        self.device_operating_systems.as_deref()
    }
    /// <p>Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will match.</p>
    pub fn not_device_operating_systems(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_operating_systems.as_deref()
    }
    /// <p>User agents that the updated rule will match.</p>
    pub fn device_user_agents(&self) -> std::option::Option<&[std::string::String]> {
        self.device_user_agents.as_deref()
    }
    /// <p>User agents that the updated rule <b>will not</b> match. All other user agents will match.</p>
    pub fn not_device_user_agents(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_user_agents.as_deref()
    }
}
impl std::fmt::Debug for UpdateMobileDeviceAccessRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMobileDeviceAccessRuleInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field(
            "mobile_device_access_rule_id",
            &self.mobile_device_access_rule_id,
        );
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("effect", &self.effect);
        formatter.field("device_types", &self.device_types);
        formatter.field("not_device_types", &self.not_device_types);
        formatter.field("device_models", &self.device_models);
        formatter.field("not_device_models", &self.not_device_models);
        formatter.field("device_operating_systems", &self.device_operating_systems);
        formatter.field(
            "not_device_operating_systems",
            &self.not_device_operating_systems,
        );
        formatter.field("device_user_agents", &self.device_user_agents);
        formatter.field("not_device_user_agents", &self.not_device_user_agents);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMailboxQuotaInput {
    /// <p>The identifier for the organization that contains the user for whom to update the mailbox quota.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifer for the user for whom to update the mailbox quota.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The updated mailbox quota, in MB, for the specified user.</p>
    pub mailbox_quota: std::option::Option<i32>,
}
impl UpdateMailboxQuotaInput {
    /// <p>The identifier for the organization that contains the user for whom to update the mailbox quota.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifer for the user for whom to update the mailbox quota.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The updated mailbox quota, in MB, for the specified user.</p>
    pub fn mailbox_quota(&self) -> std::option::Option<i32> {
        self.mailbox_quota
    }
}
impl std::fmt::Debug for UpdateMailboxQuotaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMailboxQuotaInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_id", &self.user_id);
        formatter.field("mailbox_quota", &self.mailbox_quota);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDefaultMailDomainInput {
    /// <p>The Amazon WorkMail organization for which to list domains.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The domain name that will become the default domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl UpdateDefaultMailDomainInput {
    /// <p>The Amazon WorkMail organization for which to list domains.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The domain name that will become the default domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateDefaultMailDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDefaultMailDomainInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The resource ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag key-value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The resource ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag key-value pairs.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMailboxExportJobInput {
    /// <p>The idempotency token for the client request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The identifier associated with the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the user or resource associated with the mailbox.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The mailbox export job description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3 bucket.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The name of the S3 bucket.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The S3 bucket prefix.</p>
    pub s3_prefix: std::option::Option<std::string::String>,
}
impl StartMailboxExportJobInput {
    /// <p>The idempotency token for the client request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The identifier associated with the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the user or resource associated with the mailbox.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The mailbox export job description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3 bucket.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The name of the S3 bucket.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>The S3 bucket prefix.</p>
    pub fn s3_prefix(&self) -> std::option::Option<&str> {
        self.s3_prefix.as_deref()
    }
}
impl std::fmt::Debug for StartMailboxExportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMailboxExportJobInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("organization_id", &self.organization_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_prefix", &self.s3_prefix);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetPasswordInput {
    /// <p>The identifier of the organization that contains the user for which the password is reset.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the user for whom the password is reset.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The new password for the user.</p>
    pub password: std::option::Option<std::string::String>,
}
impl ResetPasswordInput {
    /// <p>The identifier of the organization that contains the user for which the password is reset.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the user for whom the password is reset.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The new password for the user.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for ResetPasswordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetPasswordInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_id", &self.user_id);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterToWorkMailInput {
    /// <p>The identifier for the organization under which the user, group, or resource exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the user, group, or resource to be updated.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The email for the user, group, or resource to be updated.</p>
    pub email: std::option::Option<std::string::String>,
}
impl RegisterToWorkMailInput {
    /// <p>The identifier for the organization under which the user, group, or resource exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier for the user, group, or resource to be updated.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The email for the user, group, or resource to be updated.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
}
impl std::fmt::Debug for RegisterToWorkMailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterToWorkMailInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("email", &self.email);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterMailDomainInput {
    /// <p>Idempotency token used when retrying requests.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon WorkMail organization under which you're creating the domain.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The name of the mail domain to create in Amazon WorkMail and SES.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl RegisterMailDomainInput {
    /// <p>Idempotency token used when retrying requests.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The Amazon WorkMail organization under which you're creating the domain.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The name of the mail domain to create in Amazon WorkMail and SES.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for RegisterMailDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterMailDomainInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("organization_id", &self.organization_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRetentionPolicyInput {
    /// <p>The organization ID.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The retention policy ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The retention policy name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The retention policy description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The retention policy folder configurations.</p>
    pub folder_configurations:
        std::option::Option<std::vec::Vec<crate::model::FolderConfiguration>>,
}
impl PutRetentionPolicyInput {
    /// <p>The organization ID.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The retention policy ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The retention policy name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The retention policy description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The retention policy folder configurations.</p>
    pub fn folder_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::FolderConfiguration]> {
        self.folder_configurations.as_deref()
    }
}
impl std::fmt::Debug for PutRetentionPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRetentionPolicyInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_configurations", &self.folder_configurations);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutMobileDeviceAccessOverrideInput {
    /// <p>Identifies the Amazon WorkMail organization for which you create the override.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The WorkMail user for which you create the override. Accepts the following types of user identities:</p>
    /// <ul>
    /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
    /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
    /// <li> <p>User name: <code>user</code> </p> </li>
    /// </ul>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The mobile device for which you create the override. <code>DeviceId</code> is case insensitive.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
    pub effect: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
    /// <p>A description of the override.</p>
    pub description: std::option::Option<std::string::String>,
}
impl PutMobileDeviceAccessOverrideInput {
    /// <p>Identifies the Amazon WorkMail organization for which you create the override.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The WorkMail user for which you create the override. Accepts the following types of user identities:</p>
    /// <ul>
    /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
    /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
    /// <li> <p>User name: <code>user</code> </p> </li>
    /// </ul>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The mobile device for which you create the override. <code>DeviceId</code> is case insensitive.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
    pub fn effect(&self) -> std::option::Option<&crate::model::MobileDeviceAccessRuleEffect> {
        self.effect.as_ref()
    }
    /// <p>A description of the override.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for PutMobileDeviceAccessOverrideInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutMobileDeviceAccessOverrideInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_id", &self.user_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("effect", &self.effect);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutMailboxPermissionsInput {
    /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the user, group, or resource for which to update mailbox permissions.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the user, group, or resource to which to grant the permissions.</p>
    pub grantee_id: std::option::Option<std::string::String>,
    /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>
    pub permission_values: std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
}
impl PutMailboxPermissionsInput {
    /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the user, group, or resource for which to update mailbox permissions.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The identifier of the user, group, or resource to which to grant the permissions.</p>
    pub fn grantee_id(&self) -> std::option::Option<&str> {
        self.grantee_id.as_deref()
    }
    /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>
    pub fn permission_values(&self) -> std::option::Option<&[crate::model::PermissionType]> {
        self.permission_values.as_deref()
    }
}
impl std::fmt::Debug for PutMailboxPermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutMailboxPermissionsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("grantee_id", &self.grantee_id);
        formatter.field("permission_values", &self.permission_values);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutInboundDmarcSettingsInput {
    /// <p>The ID of the organization that you are applying the DMARC policy to. </p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>Enforces or suspends a policy after it's applied.</p>
    pub enforced: std::option::Option<bool>,
}
impl PutInboundDmarcSettingsInput {
    /// <p>The ID of the organization that you are applying the DMARC policy to. </p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>Enforces or suspends a policy after it's applied.</p>
    pub fn enforced(&self) -> std::option::Option<bool> {
        self.enforced
    }
}
impl std::fmt::Debug for PutInboundDmarcSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutInboundDmarcSettingsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("enforced", &self.enforced);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEmailMonitoringConfigurationInput {
    /// <p>The ID of the organization for which the email monitoring configuration is set.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.</p>
    pub log_group_arn: std::option::Option<std::string::String>,
}
impl PutEmailMonitoringConfigurationInput {
    /// <p>The ID of the organization for which the email monitoring configuration is set.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.</p>
    pub fn log_group_arn(&self) -> std::option::Option<&str> {
        self.log_group_arn.as_deref()
    }
}
impl std::fmt::Debug for PutEmailMonitoringConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEmailMonitoringConfigurationInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("log_group_arn", &self.log_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccessControlRuleInput {
    /// <p>The rule name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The rule effect.</p>
    pub effect: std::option::Option<crate::model::AccessControlRuleEffect>,
    /// <p>The rule description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>IPv4 CIDR ranges to include in the rule.</p>
    pub ip_ranges: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
    pub not_ip_ranges: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    pub actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    pub not_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>User IDs to include in the rule.</p>
    pub user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>User IDs to exclude from the rule.</p>
    pub not_user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The identifier of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl PutAccessControlRuleInput {
    /// <p>The rule name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The rule effect.</p>
    pub fn effect(&self) -> std::option::Option<&crate::model::AccessControlRuleEffect> {
        self.effect.as_ref()
    }
    /// <p>The rule description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>IPv4 CIDR ranges to include in the rule.</p>
    pub fn ip_ranges(&self) -> std::option::Option<&[std::string::String]> {
        self.ip_ranges.as_deref()
    }
    /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
    pub fn not_ip_ranges(&self) -> std::option::Option<&[std::string::String]> {
        self.not_ip_ranges.as_deref()
    }
    /// <p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    pub fn actions(&self) -> std::option::Option<&[std::string::String]> {
        self.actions.as_deref()
    }
    /// <p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    pub fn not_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.not_actions.as_deref()
    }
    /// <p>User IDs to include in the rule.</p>
    pub fn user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids.as_deref()
    }
    /// <p>User IDs to exclude from the rule.</p>
    pub fn not_user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.not_user_ids.as_deref()
    }
    /// <p>The identifier of the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for PutAccessControlRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccessControlRuleInput");
        formatter.field("name", &self.name);
        formatter.field("effect", &self.effect);
        formatter.field("description", &self.description);
        formatter.field("ip_ranges", &self.ip_ranges);
        formatter.field("not_ip_ranges", &self.not_ip_ranges);
        formatter.field("actions", &self.actions);
        formatter.field("not_actions", &self.not_actions);
        formatter.field("user_ids", &self.user_ids);
        formatter.field("not_user_ids", &self.not_user_ids);
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersInput {
    /// <p>The identifier for the organization under which the users exist.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListUsersInput {
    /// <p>The identifier for the organization under which the users exist.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The resource ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesInput {
    /// <p>The identifier for the organization under which the resources exist.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListResourcesInput {
    /// <p>The identifier for the organization under which the resources exist.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourcesInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceDelegatesInput {
    /// <p>The identifier for the organization that contains the resource for which delegates are listed.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the resource whose delegates are listed.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The token used to paginate through the delegates associated with a resource.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of maximum results in a page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListResourceDelegatesInput {
    /// <p>The identifier for the organization that contains the resource for which delegates are listed.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier for the resource whose delegates are listed.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The token used to paginate through the delegates associated with a resource.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of maximum results in a page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListResourceDelegatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceDelegatesInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOrganizationsInput {
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListOrganizationsInput {
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListOrganizationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOrganizationsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMobileDeviceAccessRulesInput {
    /// <p>The Amazon WorkMail organization for which to list the rules.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl ListMobileDeviceAccessRulesInput {
    /// <p>The Amazon WorkMail organization for which to list the rules.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for ListMobileDeviceAccessRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMobileDeviceAccessRulesInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMobileDeviceAccessOverridesInput {
    /// <p>The Amazon WorkMail organization under which to list mobile device access overrides.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:</p>
    /// <ul>
    /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
    /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
    /// <li> <p>User name: <code>user</code> </p> </li>
    /// </ul>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The mobile device to which the access override applies.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListMobileDeviceAccessOverridesInput {
    /// <p>The Amazon WorkMail organization under which to list mobile device access overrides.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:</p>
    /// <ul>
    /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
    /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
    /// <li> <p>User name: <code>user</code> </p> </li>
    /// </ul>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The mobile device to which the access override applies.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListMobileDeviceAccessOverridesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMobileDeviceAccessOverridesInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_id", &self.user_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMailDomainsInput {
    /// <p>The Amazon WorkMail organization for which to list domains.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMailDomainsInput {
    /// <p>The Amazon WorkMail organization for which to list domains.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMailDomainsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMailDomainsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMailboxPermissionsInput {
    /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the user, group, or resource for which to list mailbox permissions.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListMailboxPermissionsInput {
    /// <p>The identifier of the organization under which the user, group, or resource exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the user, group, or resource for which to list mailbox permissions.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListMailboxPermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMailboxPermissionsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMailboxExportJobsInput {
    /// <p>The organization ID.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListMailboxExportJobsInput {
    /// <p>The organization ID.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListMailboxExportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMailboxExportJobsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupsInput {
    /// <p>The identifier for the organization under which the groups exist.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListGroupsInput {
    /// <p>The identifier for the organization under which the groups exist.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupMembersInput {
    /// <p>The identifier for the organization under which the group exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the group to which the members (users or groups) are associated.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p> The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListGroupMembersInput {
    /// <p>The identifier for the organization under which the group exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier for the group to which the members (users or groups) are associated.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p> The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListGroupMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupMembersInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("group_id", &self.group_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAliasesInput {
    /// <p>The identifier for the organization under which the entity exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the entity for which to list the aliases.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAliasesInput {
    /// <p>The identifier for the organization under which the entity exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier for the entity for which to list the aliases.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAliasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAliasesInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessControlRulesInput {
    /// <p>The identifier for the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl ListAccessControlRulesInput {
    /// <p>The identifier for the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for ListAccessControlRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessControlRulesInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMobileDeviceAccessOverrideInput {
    /// <p>The Amazon WorkMail organization to which you want to apply the override.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>Identifies the WorkMail user for the override. Accepts the following types of user identities: </p>
    /// <ul>
    /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
    /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
    /// <li> <p>User name: <code>user</code> </p> </li>
    /// </ul>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The mobile device to which the override applies. <code>DeviceId</code> is case insensitive.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl GetMobileDeviceAccessOverrideInput {
    /// <p>The Amazon WorkMail organization to which you want to apply the override.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>Identifies the WorkMail user for the override. Accepts the following types of user identities: </p>
    /// <ul>
    /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
    /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
    /// <li> <p>User name: <code>user</code> </p> </li>
    /// </ul>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The mobile device to which the override applies. <code>DeviceId</code> is case insensitive.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
}
impl std::fmt::Debug for GetMobileDeviceAccessOverrideInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMobileDeviceAccessOverrideInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_id", &self.user_id);
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMobileDeviceAccessEffectInput {
    /// <p>The Amazon WorkMail organization to simulate the access effect for.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>Device type the simulated user will report.</p>
    pub device_type: std::option::Option<std::string::String>,
    /// <p>Device model the simulated user will report.</p>
    pub device_model: std::option::Option<std::string::String>,
    /// <p>Device operating system the simulated user will report.</p>
    pub device_operating_system: std::option::Option<std::string::String>,
    /// <p>Device user agent the simulated user will report.</p>
    pub device_user_agent: std::option::Option<std::string::String>,
}
impl GetMobileDeviceAccessEffectInput {
    /// <p>The Amazon WorkMail organization to simulate the access effect for.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>Device type the simulated user will report.</p>
    pub fn device_type(&self) -> std::option::Option<&str> {
        self.device_type.as_deref()
    }
    /// <p>Device model the simulated user will report.</p>
    pub fn device_model(&self) -> std::option::Option<&str> {
        self.device_model.as_deref()
    }
    /// <p>Device operating system the simulated user will report.</p>
    pub fn device_operating_system(&self) -> std::option::Option<&str> {
        self.device_operating_system.as_deref()
    }
    /// <p>Device user agent the simulated user will report.</p>
    pub fn device_user_agent(&self) -> std::option::Option<&str> {
        self.device_user_agent.as_deref()
    }
}
impl std::fmt::Debug for GetMobileDeviceAccessEffectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMobileDeviceAccessEffectInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("device_type", &self.device_type);
        formatter.field("device_model", &self.device_model);
        formatter.field("device_operating_system", &self.device_operating_system);
        formatter.field("device_user_agent", &self.device_user_agent);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMailDomainInput {
    /// <p>The Amazon WorkMail organization for which the domain is retrieved.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The domain from which you want to retrieve details.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetMailDomainInput {
    /// <p>The Amazon WorkMail organization for which the domain is retrieved.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The domain from which you want to retrieve details.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetMailDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMailDomainInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMailboxDetailsInput {
    /// <p>The identifier for the organization that contains the user whose mailbox details are being requested.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the user whose mailbox details are being requested.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl GetMailboxDetailsInput {
    /// <p>The identifier for the organization that contains the user whose mailbox details are being requested.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier for the user whose mailbox details are being requested.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for GetMailboxDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMailboxDetailsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDefaultRetentionPolicyInput {
    /// <p>The organization ID.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl GetDefaultRetentionPolicyInput {
    /// <p>The organization ID.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for GetDefaultRetentionPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDefaultRetentionPolicyInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessControlEffectInput {
    /// <p>The identifier for the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The IPv4 address.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The access protocol action. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The user ID.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl GetAccessControlEffectInput {
    /// <p>The identifier for the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The IPv4 address.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The access protocol action. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>The user ID.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for GetAccessControlEffectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessControlEffectInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("action", &self.action);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateMemberFromGroupInput {
    /// <p>The identifier for the organization under which the group exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the group from which members are removed.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the member to be removed to the group.</p>
    pub member_id: std::option::Option<std::string::String>,
}
impl DisassociateMemberFromGroupInput {
    /// <p>The identifier for the organization under which the group exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier for the group from which members are removed.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The identifier for the member to be removed to the group.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateMemberFromGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateMemberFromGroupInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("group_id", &self.group_id);
        formatter.field("member_id", &self.member_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateDelegateFromResourceInput {
    /// <p>The identifier for the organization under which the resource exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the resource from which delegates' set members are removed. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the member (user, group) to be removed from the resource's delegates.</p>
    pub entity_id: std::option::Option<std::string::String>,
}
impl DisassociateDelegateFromResourceInput {
    /// <p>The identifier for the organization under which the resource exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the resource from which delegates' set members are removed. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The identifier for the member (user, group) to be removed from the resource's delegates.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateDelegateFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateDelegateFromResourceInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserInput {
    /// <p>The identifier for the organization under which the user exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the user to be described.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl DescribeUserInput {
    /// <p>The identifier for the organization under which the user exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier for the user to be described.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourceInput {
    /// <p>The identifier associated with the organization for which the resource is described.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the resource to be described.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl DescribeResourceInput {
    /// <p>The identifier associated with the organization for which the resource is described.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the resource to be described.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourceInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationInput {
    /// <p>The identifier for the organization to be described.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl DescribeOrganizationInput {
    /// <p>The identifier for the organization to be described.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMailboxExportJobInput {
    /// <p>The mailbox export job ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The organization ID.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl DescribeMailboxExportJobInput {
    /// <p>The mailbox export job ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The organization ID.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeMailboxExportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMailboxExportJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInboundDmarcSettingsInput {
    /// <p>Lists the ID of the given organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl DescribeInboundDmarcSettingsInput {
    /// <p>Lists the ID of the given organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeInboundDmarcSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInboundDmarcSettingsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGroupInput {
    /// <p>The identifier for the organization under which the group exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the group to be described.</p>
    pub group_id: std::option::Option<std::string::String>,
}
impl DescribeGroupInput {
    /// <p>The identifier for the organization under which the group exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier for the group to be described.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGroupInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEmailMonitoringConfigurationInput {
    /// <p>The ID of the organization for which the email monitoring configuration is described.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl DescribeEmailMonitoringConfigurationInput {
    /// <p>The ID of the organization for which the email monitoring configuration is described.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeEmailMonitoringConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEmailMonitoringConfigurationInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterMailDomainInput {
    /// <p>The Amazon WorkMail organization for which the domain will be deregistered.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The domain to deregister in WorkMail and SES. </p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeregisterMailDomainInput {
    /// <p>The Amazon WorkMail organization for which the domain will be deregistered.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The domain to deregister in WorkMail and SES. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeregisterMailDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterMailDomainInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterFromWorkMailInput {
    /// <p>The identifier for the organization under which the Amazon WorkMail entity exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the member (user or group) to be updated.</p>
    pub entity_id: std::option::Option<std::string::String>,
}
impl DeregisterFromWorkMailInput {
    /// <p>The identifier for the organization under which the Amazon WorkMail entity exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier for the member (user or group) to be updated.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
}
impl std::fmt::Debug for DeregisterFromWorkMailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterFromWorkMailInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserInput {
    /// <p>The organization that contains the user to be deleted.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the user to be deleted.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl DeleteUserInput {
    /// <p>The organization that contains the user to be deleted.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the user to be deleted.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRetentionPolicyInput {
    /// <p>The organization ID.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The retention policy ID.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteRetentionPolicyInput {
    /// <p>The organization ID.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The retention policy ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteRetentionPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRetentionPolicyInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourceInput {
    /// <p>The identifier associated with the organization from which the resource is deleted.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the resource to be deleted.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl DeleteResourceInput {
    /// <p>The identifier associated with the organization from which the resource is deleted.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the resource to be deleted.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourceInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOrganizationInput {
    /// <p>The idempotency token associated with the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The organization ID.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>If true, deletes the AWS Directory Service directory associated with the organization.</p>
    pub delete_directory: bool,
}
impl DeleteOrganizationInput {
    /// <p>The idempotency token associated with the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The organization ID.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>If true, deletes the AWS Directory Service directory associated with the organization.</p>
    pub fn delete_directory(&self) -> bool {
        self.delete_directory
    }
}
impl std::fmt::Debug for DeleteOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOrganizationInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("organization_id", &self.organization_id);
        formatter.field("delete_directory", &self.delete_directory);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMobileDeviceAccessRuleInput {
    /// <p>The Amazon WorkMail organization under which the rule will be deleted.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the rule to be deleted.</p>
    pub mobile_device_access_rule_id: std::option::Option<std::string::String>,
}
impl DeleteMobileDeviceAccessRuleInput {
    /// <p>The Amazon WorkMail organization under which the rule will be deleted.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the rule to be deleted.</p>
    pub fn mobile_device_access_rule_id(&self) -> std::option::Option<&str> {
        self.mobile_device_access_rule_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMobileDeviceAccessRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMobileDeviceAccessRuleInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field(
            "mobile_device_access_rule_id",
            &self.mobile_device_access_rule_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMobileDeviceAccessOverrideInput {
    /// <p>The Amazon WorkMail organization for which the access override will be deleted.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The WorkMail user for which you want to delete the override. Accepts the following types of user identities:</p>
    /// <ul>
    /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
    /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
    /// <li> <p>User name: <code>user</code> </p> </li>
    /// </ul>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl DeleteMobileDeviceAccessOverrideInput {
    /// <p>The Amazon WorkMail organization for which the access override will be deleted.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The WorkMail user for which you want to delete the override. Accepts the following types of user identities:</p>
    /// <ul>
    /// <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li>
    /// <li> <p>Email address: <code>user@domain.tld</code> </p> </li>
    /// <li> <p>User name: <code>user</code> </p> </li>
    /// </ul>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMobileDeviceAccessOverrideInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMobileDeviceAccessOverrideInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_id", &self.user_id);
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMailboxPermissionsInput {
    /// <p>The identifier of the organization under which the member (user or group) exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the member (user or group) that owns the mailbox.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the member (user or group) for which to delete granted permissions.</p>
    pub grantee_id: std::option::Option<std::string::String>,
}
impl DeleteMailboxPermissionsInput {
    /// <p>The identifier of the organization under which the member (user or group) exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the member (user or group) that owns the mailbox.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The identifier of the member (user or group) for which to delete granted permissions.</p>
    pub fn grantee_id(&self) -> std::option::Option<&str> {
        self.grantee_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMailboxPermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMailboxPermissionsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("grantee_id", &self.grantee_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupInput {
    /// <p>The organization that contains the group.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the group to be deleted.</p>
    pub group_id: std::option::Option<std::string::String>,
}
impl DeleteGroupInput {
    /// <p>The organization that contains the group.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier of the group to be deleted.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEmailMonitoringConfigurationInput {
    /// <p>The ID of the organization from which the email monitoring configuration is deleted.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl DeleteEmailMonitoringConfigurationInput {
    /// <p>The ID of the organization from which the email monitoring configuration is deleted.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteEmailMonitoringConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEmailMonitoringConfigurationInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAliasInput {
    /// <p>The identifier for the organization under which the user exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the member (user or group) from which to have the aliases removed.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed into single entries (the list is transformed into a set).</p>
    pub alias: std::option::Option<std::string::String>,
}
impl DeleteAliasInput {
    /// <p>The identifier for the organization under which the user exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The identifier for the member (user or group) from which to have the aliases removed.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed into single entries (the list is transformed into a set).</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
}
impl std::fmt::Debug for DeleteAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAliasInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessControlRuleInput {
    /// <p>The identifier for the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The name of the access control rule.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteAccessControlRuleInput {
    /// <p>The identifier for the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The name of the access control rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteAccessControlRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessControlRuleInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserInput {
    /// <p>The identifier of the organization for which the user is created.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The display name for the new user.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The password for the new user.</p>
    pub password: std::option::Option<std::string::String>,
}
impl CreateUserInput {
    /// <p>The identifier of the organization for which the user is created.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The display name for the new user.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The password for the new user.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for CreateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourceInput {
    /// <p>The identifier associated with the organization for which the resource is created.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The name of the new resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the new resource. The available types are <code>equipment</code> and <code>room</code>.</p>
    pub r#type: std::option::Option<crate::model::ResourceType>,
}
impl CreateResourceInput {
    /// <p>The identifier associated with the organization for which the resource is created.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The name of the new resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the new resource. The available types are <code>equipment</code> and <code>room</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for CreateResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourceInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOrganizationInput {
    /// <p>The AWS Directory Service directory ID.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The organization alias.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The idempotency token associated with the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The email domains to associate with the organization.</p>
    pub domains: std::option::Option<std::vec::Vec<crate::model::Domain>>,
    /// <p>The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the request.</p>
    pub enable_interoperability: bool,
}
impl CreateOrganizationInput {
    /// <p>The AWS Directory Service directory ID.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The organization alias.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The idempotency token associated with the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The email domains to associate with the organization.</p>
    pub fn domains(&self) -> std::option::Option<&[crate::model::Domain]> {
        self.domains.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the request.</p>
    pub fn enable_interoperability(&self) -> bool {
        self.enable_interoperability
    }
}
impl std::fmt::Debug for CreateOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOrganizationInput");
        formatter.field("directory_id", &self.directory_id);
        formatter.field("alias", &self.alias);
        formatter.field("client_token", &self.client_token);
        formatter.field("domains", &self.domains);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("enable_interoperability", &self.enable_interoperability);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMobileDeviceAccessRuleInput {
    /// <p>The Amazon WorkMail organization under which the rule will be created.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The idempotency token for the client request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The rule name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The rule description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
    pub effect: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
    /// <p>Device types that the rule will match.</p>
    pub device_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device types that the rule <b>will not</b> match. All other device types will match.</p>
    pub not_device_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device models that the rule will match.</p>
    pub device_models: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device models that the rule <b>will not</b> match. All other device models will match.</p>
    pub not_device_models: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device operating systems that the rule will match.</p>
    pub device_operating_systems: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device operating systems that the rule <b>will not</b> match. All other device operating systems will match.</p>
    pub not_device_operating_systems: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device user agents that the rule will match.</p>
    pub device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device user agents that the rule <b>will not</b> match. All other device user agents will match.</p>
    pub not_device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateMobileDeviceAccessRuleInput {
    /// <p>The Amazon WorkMail organization under which the rule will be created.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The idempotency token for the client request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The rule name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The rule description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
    pub fn effect(&self) -> std::option::Option<&crate::model::MobileDeviceAccessRuleEffect> {
        self.effect.as_ref()
    }
    /// <p>Device types that the rule will match.</p>
    pub fn device_types(&self) -> std::option::Option<&[std::string::String]> {
        self.device_types.as_deref()
    }
    /// <p>Device types that the rule <b>will not</b> match. All other device types will match.</p>
    pub fn not_device_types(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_types.as_deref()
    }
    /// <p>Device models that the rule will match.</p>
    pub fn device_models(&self) -> std::option::Option<&[std::string::String]> {
        self.device_models.as_deref()
    }
    /// <p>Device models that the rule <b>will not</b> match. All other device models will match.</p>
    pub fn not_device_models(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_models.as_deref()
    }
    /// <p>Device operating systems that the rule will match.</p>
    pub fn device_operating_systems(&self) -> std::option::Option<&[std::string::String]> {
        self.device_operating_systems.as_deref()
    }
    /// <p>Device operating systems that the rule <b>will not</b> match. All other device operating systems will match.</p>
    pub fn not_device_operating_systems(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_operating_systems.as_deref()
    }
    /// <p>Device user agents that the rule will match.</p>
    pub fn device_user_agents(&self) -> std::option::Option<&[std::string::String]> {
        self.device_user_agents.as_deref()
    }
    /// <p>Device user agents that the rule <b>will not</b> match. All other device user agents will match.</p>
    pub fn not_device_user_agents(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_user_agents.as_deref()
    }
}
impl std::fmt::Debug for CreateMobileDeviceAccessRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMobileDeviceAccessRuleInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("effect", &self.effect);
        formatter.field("device_types", &self.device_types);
        formatter.field("not_device_types", &self.not_device_types);
        formatter.field("device_models", &self.device_models);
        formatter.field("not_device_models", &self.not_device_models);
        formatter.field("device_operating_systems", &self.device_operating_systems);
        formatter.field(
            "not_device_operating_systems",
            &self.not_device_operating_systems,
        );
        formatter.field("device_user_agents", &self.device_user_agents);
        formatter.field("not_device_user_agents", &self.not_device_user_agents);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupInput {
    /// <p>The organization under which the group is to be created.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The name of the group.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateGroupInput {
    /// <p>The organization under which the group is to be created.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The name of the group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAliasInput {
    /// <p>The organization under which the member (user or group) exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The member (user or group) to which this alias is added.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The alias to add to the member set.</p>
    pub alias: std::option::Option<std::string::String>,
}
impl CreateAliasInput {
    /// <p>The organization under which the member (user or group) exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The member (user or group) to which this alias is added.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The alias to add to the member set.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
}
impl std::fmt::Debug for CreateAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAliasInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelMailboxExportJobInput {
    /// <p>The idempotency token for the client request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The job ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The organization ID.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl CancelMailboxExportJobInput {
    /// <p>The idempotency token for the client request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The job ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The organization ID.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for CancelMailboxExportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelMailboxExportJobInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("job_id", &self.job_id);
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateMemberToGroupInput {
    /// <p>The organization under which the group exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The group to which the member (user or group) is associated.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The member (user or group) to associate to the group.</p>
    pub member_id: std::option::Option<std::string::String>,
}
impl AssociateMemberToGroupInput {
    /// <p>The organization under which the group exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The group to which the member (user or group) is associated.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The member (user or group) to associate to the group.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateMemberToGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateMemberToGroupInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("group_id", &self.group_id);
        formatter.field("member_id", &self.member_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateDelegateToResourceInput {
    /// <p>The organization under which the resource exists.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The resource for which members (users or groups) are associated.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The member (user or group) to associate to the resource.</p>
    pub entity_id: std::option::Option<std::string::String>,
}
impl AssociateDelegateToResourceInput {
    /// <p>The organization under which the resource exists.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The resource for which members (users or groups) are associated.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The member (user or group) to associate to the resource.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateDelegateToResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateDelegateToResourceInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.finish()
    }
}
