// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>At least one delegate must be associated to the resource to disable automatic replies
/// from the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BookingOptions {
    /// <p>The resource's ability to automatically reply to requests. If disabled, delegates
    /// must be associated to the resource.</p>
    pub auto_accept_requests: bool,
    /// <p>The resource's ability to automatically decline any recurring requests.</p>
    pub auto_decline_recurring_requests: bool,
    /// <p>The resource's ability to automatically decline any conflicting requests.</p>
    pub auto_decline_conflicting_requests: bool,
}
impl BookingOptions {
    /// <p>The resource's ability to automatically reply to requests. If disabled, delegates
    /// must be associated to the resource.</p>
    pub fn auto_accept_requests(&self) -> bool {
        self.auto_accept_requests
    }
    /// <p>The resource's ability to automatically decline any recurring requests.</p>
    pub fn auto_decline_recurring_requests(&self) -> bool {
        self.auto_decline_recurring_requests
    }
    /// <p>The resource's ability to automatically decline any conflicting requests.</p>
    pub fn auto_decline_conflicting_requests(&self) -> bool {
        self.auto_decline_conflicting_requests
    }
}
impl std::fmt::Debug for BookingOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BookingOptions");
        formatter.field("auto_accept_requests", &self.auto_accept_requests);
        formatter.field(
            "auto_decline_recurring_requests",
            &self.auto_decline_recurring_requests,
        );
        formatter.field(
            "auto_decline_conflicting_requests",
            &self.auto_decline_conflicting_requests,
        );
        formatter.finish()
    }
}
/// See [`BookingOptions`](crate::model::BookingOptions)
pub mod booking_options {
    /// A builder for [`BookingOptions`](crate::model::BookingOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_accept_requests: std::option::Option<bool>,
        pub(crate) auto_decline_recurring_requests: std::option::Option<bool>,
        pub(crate) auto_decline_conflicting_requests: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The resource's ability to automatically reply to requests. If disabled, delegates
        /// must be associated to the resource.</p>
        pub fn auto_accept_requests(mut self, input: bool) -> Self {
            self.auto_accept_requests = Some(input);
            self
        }
        /// <p>The resource's ability to automatically reply to requests. If disabled, delegates
        /// must be associated to the resource.</p>
        pub fn set_auto_accept_requests(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_accept_requests = input;
            self
        }
        /// <p>The resource's ability to automatically decline any recurring requests.</p>
        pub fn auto_decline_recurring_requests(mut self, input: bool) -> Self {
            self.auto_decline_recurring_requests = Some(input);
            self
        }
        /// <p>The resource's ability to automatically decline any recurring requests.</p>
        pub fn set_auto_decline_recurring_requests(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.auto_decline_recurring_requests = input;
            self
        }
        /// <p>The resource's ability to automatically decline any conflicting requests.</p>
        pub fn auto_decline_conflicting_requests(mut self, input: bool) -> Self {
            self.auto_decline_conflicting_requests = Some(input);
            self
        }
        /// <p>The resource's ability to automatically decline any conflicting requests.</p>
        pub fn set_auto_decline_conflicting_requests(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.auto_decline_conflicting_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`BookingOptions`](crate::model::BookingOptions)
        pub fn build(self) -> crate::model::BookingOptions {
            crate::model::BookingOptions {
                auto_accept_requests: self.auto_accept_requests.unwrap_or_default(),
                auto_decline_recurring_requests: self
                    .auto_decline_recurring_requests
                    .unwrap_or_default(),
                auto_decline_conflicting_requests: self
                    .auto_decline_conflicting_requests
                    .unwrap_or_default(),
            }
        }
    }
}
impl BookingOptions {
    /// Creates a new builder-style object to manufacture [`BookingOptions`](crate::model::BookingOptions)
    pub fn builder() -> crate::model::booking_options::Builder {
        crate::model::booking_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MobileDeviceAccessRuleEffect {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MobileDeviceAccessRuleEffect {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW" => MobileDeviceAccessRuleEffect::Allow,
            "DENY" => MobileDeviceAccessRuleEffect::Deny,
            other => MobileDeviceAccessRuleEffect::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MobileDeviceAccessRuleEffect {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MobileDeviceAccessRuleEffect::from(s))
    }
}
impl MobileDeviceAccessRuleEffect {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MobileDeviceAccessRuleEffect::Allow => "ALLOW",
            MobileDeviceAccessRuleEffect::Deny => "DENY",
            MobileDeviceAccessRuleEffect::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW", "DENY"]
    }
}
impl AsRef<str> for MobileDeviceAccessRuleEffect {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a tag applied to a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The configuration applied to an organization's folders by its retention
/// policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FolderConfiguration {
    /// <p>The folder name.</p>
    pub name: std::option::Option<crate::model::FolderName>,
    /// <p>The action to take on the folder contents at the end of the folder configuration
    /// period.</p>
    pub action: std::option::Option<crate::model::RetentionAction>,
    /// <p>The number of days for which the folder-configuration action applies.</p>
    pub period: std::option::Option<i32>,
}
impl FolderConfiguration {
    /// <p>The folder name.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::FolderName> {
        self.name.as_ref()
    }
    /// <p>The action to take on the folder contents at the end of the folder configuration
    /// period.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::RetentionAction> {
        self.action.as_ref()
    }
    /// <p>The number of days for which the folder-configuration action applies.</p>
    pub fn period(&self) -> std::option::Option<i32> {
        self.period
    }
}
impl std::fmt::Debug for FolderConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FolderConfiguration");
        formatter.field("name", &self.name);
        formatter.field("action", &self.action);
        formatter.field("period", &self.period);
        formatter.finish()
    }
}
/// See [`FolderConfiguration`](crate::model::FolderConfiguration)
pub mod folder_configuration {
    /// A builder for [`FolderConfiguration`](crate::model::FolderConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::FolderName>,
        pub(crate) action: std::option::Option<crate::model::RetentionAction>,
        pub(crate) period: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The folder name.</p>
        pub fn name(mut self, input: crate::model::FolderName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The folder name.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::FolderName>) -> Self {
            self.name = input;
            self
        }
        /// <p>The action to take on the folder contents at the end of the folder configuration
        /// period.</p>
        pub fn action(mut self, input: crate::model::RetentionAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to take on the folder contents at the end of the folder configuration
        /// period.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::RetentionAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The number of days for which the folder-configuration action applies.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The number of days for which the folder-configuration action applies.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// Consumes the builder and constructs a [`FolderConfiguration`](crate::model::FolderConfiguration)
        pub fn build(self) -> crate::model::FolderConfiguration {
            crate::model::FolderConfiguration {
                name: self.name,
                action: self.action,
                period: self.period,
            }
        }
    }
}
impl FolderConfiguration {
    /// Creates a new builder-style object to manufacture [`FolderConfiguration`](crate::model::FolderConfiguration)
    pub fn builder() -> crate::model::folder_configuration::Builder {
        crate::model::folder_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RetentionAction {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    PermanentlyDelete,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RetentionAction {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => RetentionAction::Delete,
            "NONE" => RetentionAction::None,
            "PERMANENTLY_DELETE" => RetentionAction::PermanentlyDelete,
            other => RetentionAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RetentionAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RetentionAction::from(s))
    }
}
impl RetentionAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RetentionAction::Delete => "DELETE",
            RetentionAction::None => "NONE",
            RetentionAction::PermanentlyDelete => "PERMANENTLY_DELETE",
            RetentionAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "NONE", "PERMANENTLY_DELETE"]
    }
}
impl AsRef<str> for RetentionAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FolderName {
    #[allow(missing_docs)] // documentation missing in model
    DeletedItems,
    #[allow(missing_docs)] // documentation missing in model
    Drafts,
    #[allow(missing_docs)] // documentation missing in model
    Inbox,
    #[allow(missing_docs)] // documentation missing in model
    JunkEmail,
    #[allow(missing_docs)] // documentation missing in model
    SentItems,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FolderName {
    fn from(s: &str) -> Self {
        match s {
            "DELETED_ITEMS" => FolderName::DeletedItems,
            "DRAFTS" => FolderName::Drafts,
            "INBOX" => FolderName::Inbox,
            "JUNK_EMAIL" => FolderName::JunkEmail,
            "SENT_ITEMS" => FolderName::SentItems,
            other => FolderName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FolderName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FolderName::from(s))
    }
}
impl FolderName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FolderName::DeletedItems => "DELETED_ITEMS",
            FolderName::Drafts => "DRAFTS",
            FolderName::Inbox => "INBOX",
            FolderName::JunkEmail => "JUNK_EMAIL",
            FolderName::SentItems => "SENT_ITEMS",
            FolderName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETED_ITEMS",
            "DRAFTS",
            "INBOX",
            "JUNK_EMAIL",
            "SENT_ITEMS",
        ]
    }
}
impl AsRef<str> for FolderName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PermissionType {
    #[allow(missing_docs)] // documentation missing in model
    FullAccess,
    #[allow(missing_docs)] // documentation missing in model
    SendAs,
    #[allow(missing_docs)] // documentation missing in model
    SendOnBehalf,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PermissionType {
    fn from(s: &str) -> Self {
        match s {
            "FULL_ACCESS" => PermissionType::FullAccess,
            "SEND_AS" => PermissionType::SendAs,
            "SEND_ON_BEHALF" => PermissionType::SendOnBehalf,
            other => PermissionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PermissionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PermissionType::from(s))
    }
}
impl PermissionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PermissionType::FullAccess => "FULL_ACCESS",
            PermissionType::SendAs => "SEND_AS",
            PermissionType::SendOnBehalf => "SEND_ON_BEHALF",
            PermissionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL_ACCESS", "SEND_AS", "SEND_ON_BEHALF"]
    }
}
impl AsRef<str> for PermissionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessControlRuleEffect {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessControlRuleEffect {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW" => AccessControlRuleEffect::Allow,
            "DENY" => AccessControlRuleEffect::Deny,
            other => AccessControlRuleEffect::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessControlRuleEffect {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessControlRuleEffect::from(s))
    }
}
impl AccessControlRuleEffect {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessControlRuleEffect::Allow => "ALLOW",
            AccessControlRuleEffect::Deny => "DENY",
            AccessControlRuleEffect::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW", "DENY"]
    }
}
impl AsRef<str> for AccessControlRuleEffect {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The representation of an Amazon WorkMail user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>The identifier of the user.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The email of the user.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The name of the user.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The display name of the user.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The state of the user, which can be ENABLED, DISABLED, or DELETED.</p>
    pub state: std::option::Option<crate::model::EntityState>,
    /// <p>The role of the user.</p>
    pub user_role: std::option::Option<crate::model::UserRole>,
    /// <p>The date indicating when the user was enabled for Amazon WorkMail use.</p>
    pub enabled_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date indicating when the user was disabled from Amazon WorkMail use.</p>
    pub disabled_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl User {
    /// <p>The identifier of the user.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The email of the user.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The name of the user.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The display name of the user.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The state of the user, which can be ENABLED, DISABLED, or DELETED.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::EntityState> {
        self.state.as_ref()
    }
    /// <p>The role of the user.</p>
    pub fn user_role(&self) -> std::option::Option<&crate::model::UserRole> {
        self.user_role.as_ref()
    }
    /// <p>The date indicating when the user was enabled for Amazon WorkMail use.</p>
    pub fn enabled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.enabled_date.as_ref()
    }
    /// <p>The date indicating when the user was disabled from Amazon WorkMail use.</p>
    pub fn disabled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.disabled_date.as_ref()
    }
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("id", &self.id);
        formatter.field("email", &self.email);
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.field("state", &self.state);
        formatter.field("user_role", &self.user_role);
        formatter.field("enabled_date", &self.enabled_date);
        formatter.field("disabled_date", &self.disabled_date);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EntityState>,
        pub(crate) user_role: std::option::Option<crate::model::UserRole>,
        pub(crate) enabled_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) disabled_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the user.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The email of the user.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email of the user.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The name of the user.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The display name of the user.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of the user.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The state of the user, which can be ENABLED, DISABLED, or DELETED.</p>
        pub fn state(mut self, input: crate::model::EntityState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the user, which can be ENABLED, DISABLED, or DELETED.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::EntityState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The role of the user.</p>
        pub fn user_role(mut self, input: crate::model::UserRole) -> Self {
            self.user_role = Some(input);
            self
        }
        /// <p>The role of the user.</p>
        pub fn set_user_role(mut self, input: std::option::Option<crate::model::UserRole>) -> Self {
            self.user_role = input;
            self
        }
        /// <p>The date indicating when the user was enabled for Amazon WorkMail use.</p>
        pub fn enabled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.enabled_date = Some(input);
            self
        }
        /// <p>The date indicating when the user was enabled for Amazon WorkMail use.</p>
        pub fn set_enabled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.enabled_date = input;
            self
        }
        /// <p>The date indicating when the user was disabled from Amazon WorkMail use.</p>
        pub fn disabled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.disabled_date = Some(input);
            self
        }
        /// <p>The date indicating when the user was disabled from Amazon WorkMail use.</p>
        pub fn set_disabled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.disabled_date = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                id: self.id,
                email: self.email,
                name: self.name,
                display_name: self.display_name,
                state: self.state,
                user_role: self.user_role,
                enabled_date: self.enabled_date,
                disabled_date: self.disabled_date,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserRole {
    #[allow(missing_docs)] // documentation missing in model
    Resource,
    #[allow(missing_docs)] // documentation missing in model
    SystemUser,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserRole {
    fn from(s: &str) -> Self {
        match s {
            "RESOURCE" => UserRole::Resource,
            "SYSTEM_USER" => UserRole::SystemUser,
            "USER" => UserRole::User,
            other => UserRole::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserRole {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserRole::from(s))
    }
}
impl UserRole {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserRole::Resource => "RESOURCE",
            UserRole::SystemUser => "SYSTEM_USER",
            UserRole::User => "USER",
            UserRole::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RESOURCE", "SYSTEM_USER", "USER"]
    }
}
impl AsRef<str> for UserRole {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntityState {
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntityState {
    fn from(s: &str) -> Self {
        match s {
            "DELETED" => EntityState::Deleted,
            "DISABLED" => EntityState::Disabled,
            "ENABLED" => EntityState::Enabled,
            other => EntityState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntityState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntityState::from(s))
    }
}
impl EntityState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntityState::Deleted => "DELETED",
            EntityState::Disabled => "DISABLED",
            EntityState::Enabled => "ENABLED",
            EntityState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETED", "DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for EntityState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The representation of a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The identifier of the resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The email of the resource.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the resource: equipment or room.</p>
    pub r#type: std::option::Option<crate::model::ResourceType>,
    /// <p>The state of the resource, which can be ENABLED, DISABLED, or DELETED.</p>
    pub state: std::option::Option<crate::model::EntityState>,
    /// <p>The date indicating when the resource was enabled for Amazon WorkMail use.</p>
    pub enabled_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date indicating when the resource was disabled from Amazon WorkMail use.</p>
    pub disabled_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl Resource {
    /// <p>The identifier of the resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The email of the resource.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The name of the resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the resource: equipment or room.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.r#type.as_ref()
    }
    /// <p>The state of the resource, which can be ENABLED, DISABLED, or DELETED.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::EntityState> {
        self.state.as_ref()
    }
    /// <p>The date indicating when the resource was enabled for Amazon WorkMail use.</p>
    pub fn enabled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.enabled_date.as_ref()
    }
    /// <p>The date indicating when the resource was disabled from Amazon WorkMail use.</p>
    pub fn disabled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.disabled_date.as_ref()
    }
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("id", &self.id);
        formatter.field("email", &self.email);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("state", &self.state);
        formatter.field("enabled_date", &self.enabled_date);
        formatter.field("disabled_date", &self.disabled_date);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ResourceType>,
        pub(crate) state: std::option::Option<crate::model::EntityState>,
        pub(crate) enabled_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) disabled_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The email of the resource.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email of the resource.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the resource: equipment or room.</p>
        pub fn r#type(mut self, input: crate::model::ResourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the resource: equipment or room.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ResourceType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The state of the resource, which can be ENABLED, DISABLED, or DELETED.</p>
        pub fn state(mut self, input: crate::model::EntityState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the resource, which can be ENABLED, DISABLED, or DELETED.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::EntityState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The date indicating when the resource was enabled for Amazon WorkMail use.</p>
        pub fn enabled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.enabled_date = Some(input);
            self
        }
        /// <p>The date indicating when the resource was enabled for Amazon WorkMail use.</p>
        pub fn set_enabled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.enabled_date = input;
            self
        }
        /// <p>The date indicating when the resource was disabled from Amazon WorkMail use.</p>
        pub fn disabled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.disabled_date = Some(input);
            self
        }
        /// <p>The date indicating when the resource was disabled from Amazon WorkMail use.</p>
        pub fn set_disabled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.disabled_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                id: self.id,
                email: self.email,
                name: self.name,
                r#type: self.r#type,
                state: self.state,
                enabled_date: self.enabled_date,
                disabled_date: self.disabled_date,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Equipment,
    #[allow(missing_docs)] // documentation missing in model
    Room,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "EQUIPMENT" => ResourceType::Equipment,
            "ROOM" => ResourceType::Room,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Equipment => "EQUIPMENT",
            ResourceType::Room => "ROOM",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUIPMENT", "ROOM"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The name of the attribute, which is one of the values defined in the UserAttribute
/// enumeration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Delegate {
    /// <p>The identifier for the user or group associated as the resource's delegate.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of the delegate: user or group.</p>
    pub r#type: std::option::Option<crate::model::MemberType>,
}
impl Delegate {
    /// <p>The identifier for the user or group associated as the resource's delegate.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of the delegate: user or group.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::MemberType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Delegate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Delegate");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Delegate`](crate::model::Delegate)
pub mod delegate {
    /// A builder for [`Delegate`](crate::model::Delegate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::MemberType>,
    }
    impl Builder {
        /// <p>The identifier for the user or group associated as the resource's delegate.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the user or group associated as the resource's delegate.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of the delegate: user or group.</p>
        pub fn r#type(mut self, input: crate::model::MemberType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the delegate: user or group.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::MemberType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Delegate`](crate::model::Delegate)
        pub fn build(self) -> crate::model::Delegate {
            crate::model::Delegate {
                id: self.id,
                r#type: self.r#type,
            }
        }
    }
}
impl Delegate {
    /// Creates a new builder-style object to manufacture [`Delegate`](crate::model::Delegate)
    pub fn builder() -> crate::model::delegate::Builder {
        crate::model::delegate::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MemberType {
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MemberType {
    fn from(s: &str) -> Self {
        match s {
            "GROUP" => MemberType::Group,
            "USER" => MemberType::User,
            other => MemberType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MemberType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MemberType::from(s))
    }
}
impl MemberType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MemberType::Group => "GROUP",
            MemberType::User => "USER",
            MemberType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GROUP", "USER"]
    }
}
impl AsRef<str> for MemberType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The representation of an organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationSummary {
    /// <p>The identifier associated with the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The alias associated with the organization.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The default email domain associated with the organization.</p>
    pub default_mail_domain: std::option::Option<std::string::String>,
    /// <p>The error message associated with the organization. It is only present if unexpected
    /// behavior has occurred with regards to the organization. It provides insight or solutions
    /// regarding unexpected behavior.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The state associated with the organization.</p>
    pub state: std::option::Option<std::string::String>,
}
impl OrganizationSummary {
    /// <p>The identifier associated with the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The alias associated with the organization.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The default email domain associated with the organization.</p>
    pub fn default_mail_domain(&self) -> std::option::Option<&str> {
        self.default_mail_domain.as_deref()
    }
    /// <p>The error message associated with the organization. It is only present if unexpected
    /// behavior has occurred with regards to the organization. It provides insight or solutions
    /// regarding unexpected behavior.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The state associated with the organization.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
}
impl std::fmt::Debug for OrganizationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationSummary");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("alias", &self.alias);
        formatter.field("default_mail_domain", &self.default_mail_domain);
        formatter.field("error_message", &self.error_message);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`OrganizationSummary`](crate::model::OrganizationSummary)
pub mod organization_summary {
    /// A builder for [`OrganizationSummary`](crate::model::OrganizationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) default_mail_domain: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier associated with the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The alias associated with the organization.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias associated with the organization.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The default email domain associated with the organization.</p>
        pub fn default_mail_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_mail_domain = Some(input.into());
            self
        }
        /// <p>The default email domain associated with the organization.</p>
        pub fn set_default_mail_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_mail_domain = input;
            self
        }
        /// <p>The error message associated with the organization. It is only present if unexpected
        /// behavior has occurred with regards to the organization. It provides insight or solutions
        /// regarding unexpected behavior.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message associated with the organization. It is only present if unexpected
        /// behavior has occurred with regards to the organization. It provides insight or solutions
        /// regarding unexpected behavior.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The state associated with the organization.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state associated with the organization.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationSummary`](crate::model::OrganizationSummary)
        pub fn build(self) -> crate::model::OrganizationSummary {
            crate::model::OrganizationSummary {
                organization_id: self.organization_id,
                alias: self.alias,
                default_mail_domain: self.default_mail_domain,
                error_message: self.error_message,
                state: self.state,
            }
        }
    }
}
impl OrganizationSummary {
    /// Creates a new builder-style object to manufacture [`OrganizationSummary`](crate::model::OrganizationSummary)
    pub fn builder() -> crate::model::organization_summary::Builder {
        crate::model::organization_summary::Builder::default()
    }
}

/// <p>A rule that controls access to mobile devices for an Amazon WorkMail group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MobileDeviceAccessRule {
    /// <p>The ID assigned to a mobile access rule. </p>
    pub mobile_device_access_rule_id: std::option::Option<std::string::String>,
    /// <p>The name of a mobile access rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of a mobile access rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
    pub effect: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
    /// <p>Device types that a rule will match. </p>
    pub device_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device types that a rule <b>will not</b> match. All other device types will match.</p>
    pub not_device_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device models that a rule will match.</p>
    pub device_models: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device models that a rule <b>will not</b> match. All other device models will match.</p>
    pub not_device_models: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device operating systems that a rule will match.</p>
    pub device_operating_systems: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device operating systems that a rule <b>will not</b> match. All other device types will match.</p>
    pub not_device_operating_systems: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device user agents that a rule will match.</p>
    pub device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Device user agents that a rule <b>will not</b> match. All other device user agents will match.</p>
    pub not_device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date and time at which an access rule was created.</p>
    pub date_created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time at which an access rule was modified.</p>
    pub date_modified: std::option::Option<aws_smithy_types::DateTime>,
}
impl MobileDeviceAccessRule {
    /// <p>The ID assigned to a mobile access rule. </p>
    pub fn mobile_device_access_rule_id(&self) -> std::option::Option<&str> {
        self.mobile_device_access_rule_id.as_deref()
    }
    /// <p>The name of a mobile access rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of a mobile access rule.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
    pub fn effect(&self) -> std::option::Option<&crate::model::MobileDeviceAccessRuleEffect> {
        self.effect.as_ref()
    }
    /// <p>Device types that a rule will match. </p>
    pub fn device_types(&self) -> std::option::Option<&[std::string::String]> {
        self.device_types.as_deref()
    }
    /// <p>Device types that a rule <b>will not</b> match. All other device types will match.</p>
    pub fn not_device_types(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_types.as_deref()
    }
    /// <p>Device models that a rule will match.</p>
    pub fn device_models(&self) -> std::option::Option<&[std::string::String]> {
        self.device_models.as_deref()
    }
    /// <p>Device models that a rule <b>will not</b> match. All other device models will match.</p>
    pub fn not_device_models(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_models.as_deref()
    }
    /// <p>Device operating systems that a rule will match.</p>
    pub fn device_operating_systems(&self) -> std::option::Option<&[std::string::String]> {
        self.device_operating_systems.as_deref()
    }
    /// <p>Device operating systems that a rule <b>will not</b> match. All other device types will match.</p>
    pub fn not_device_operating_systems(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_operating_systems.as_deref()
    }
    /// <p>Device user agents that a rule will match.</p>
    pub fn device_user_agents(&self) -> std::option::Option<&[std::string::String]> {
        self.device_user_agents.as_deref()
    }
    /// <p>Device user agents that a rule <b>will not</b> match. All other device user agents will match.</p>
    pub fn not_device_user_agents(&self) -> std::option::Option<&[std::string::String]> {
        self.not_device_user_agents.as_deref()
    }
    /// <p>The date and time at which an access rule was created.</p>
    pub fn date_created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_created.as_ref()
    }
    /// <p>The date and time at which an access rule was modified.</p>
    pub fn date_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_modified.as_ref()
    }
}
impl std::fmt::Debug for MobileDeviceAccessRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MobileDeviceAccessRule");
        formatter.field(
            "mobile_device_access_rule_id",
            &self.mobile_device_access_rule_id,
        );
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("effect", &self.effect);
        formatter.field("device_types", &self.device_types);
        formatter.field("not_device_types", &self.not_device_types);
        formatter.field("device_models", &self.device_models);
        formatter.field("not_device_models", &self.not_device_models);
        formatter.field("device_operating_systems", &self.device_operating_systems);
        formatter.field(
            "not_device_operating_systems",
            &self.not_device_operating_systems,
        );
        formatter.field("device_user_agents", &self.device_user_agents);
        formatter.field("not_device_user_agents", &self.not_device_user_agents);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_modified", &self.date_modified);
        formatter.finish()
    }
}
/// See [`MobileDeviceAccessRule`](crate::model::MobileDeviceAccessRule)
pub mod mobile_device_access_rule {
    /// A builder for [`MobileDeviceAccessRule`](crate::model::MobileDeviceAccessRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mobile_device_access_rule_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) effect: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        pub(crate) device_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_models: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_models: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_operating_systems:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_operating_systems:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_device_user_agents: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) date_modified: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID assigned to a mobile access rule. </p>
        pub fn mobile_device_access_rule_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.mobile_device_access_rule_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to a mobile access rule. </p>
        pub fn set_mobile_device_access_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mobile_device_access_rule_id = input;
            self
        }
        /// <p>The name of a mobile access rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a mobile access rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of a mobile access rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a mobile access rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, input: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.effect = Some(input);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.effect = input;
            self
        }
        /// Appends an item to `device_types`.
        ///
        /// To override the contents of this collection use [`set_device_types`](Self::set_device_types).
        ///
        /// <p>Device types that a rule will match. </p>
        pub fn device_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_types.unwrap_or_default();
            v.push(input.into());
            self.device_types = Some(v);
            self
        }
        /// <p>Device types that a rule will match. </p>
        pub fn set_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_types = input;
            self
        }
        /// Appends an item to `not_device_types`.
        ///
        /// To override the contents of this collection use [`set_not_device_types`](Self::set_not_device_types).
        ///
        /// <p>Device types that a rule <b>will not</b> match. All other device types will match.</p>
        pub fn not_device_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_device_types.unwrap_or_default();
            v.push(input.into());
            self.not_device_types = Some(v);
            self
        }
        /// <p>Device types that a rule <b>will not</b> match. All other device types will match.</p>
        pub fn set_not_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_types = input;
            self
        }
        /// Appends an item to `device_models`.
        ///
        /// To override the contents of this collection use [`set_device_models`](Self::set_device_models).
        ///
        /// <p>Device models that a rule will match.</p>
        pub fn device_models(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_models.unwrap_or_default();
            v.push(input.into());
            self.device_models = Some(v);
            self
        }
        /// <p>Device models that a rule will match.</p>
        pub fn set_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_models = input;
            self
        }
        /// Appends an item to `not_device_models`.
        ///
        /// To override the contents of this collection use [`set_not_device_models`](Self::set_not_device_models).
        ///
        /// <p>Device models that a rule <b>will not</b> match. All other device models will match.</p>
        pub fn not_device_models(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_device_models.unwrap_or_default();
            v.push(input.into());
            self.not_device_models = Some(v);
            self
        }
        /// <p>Device models that a rule <b>will not</b> match. All other device models will match.</p>
        pub fn set_not_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_models = input;
            self
        }
        /// Appends an item to `device_operating_systems`.
        ///
        /// To override the contents of this collection use [`set_device_operating_systems`](Self::set_device_operating_systems).
        ///
        /// <p>Device operating systems that a rule will match.</p>
        pub fn device_operating_systems(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_operating_systems.unwrap_or_default();
            v.push(input.into());
            self.device_operating_systems = Some(v);
            self
        }
        /// <p>Device operating systems that a rule will match.</p>
        pub fn set_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_operating_systems = input;
            self
        }
        /// Appends an item to `not_device_operating_systems`.
        ///
        /// To override the contents of this collection use [`set_not_device_operating_systems`](Self::set_not_device_operating_systems).
        ///
        /// <p>Device operating systems that a rule <b>will not</b> match. All other device types will match.</p>
        pub fn not_device_operating_systems(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.not_device_operating_systems.unwrap_or_default();
            v.push(input.into());
            self.not_device_operating_systems = Some(v);
            self
        }
        /// <p>Device operating systems that a rule <b>will not</b> match. All other device types will match.</p>
        pub fn set_not_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_operating_systems = input;
            self
        }
        /// Appends an item to `device_user_agents`.
        ///
        /// To override the contents of this collection use [`set_device_user_agents`](Self::set_device_user_agents).
        ///
        /// <p>Device user agents that a rule will match.</p>
        pub fn device_user_agents(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_user_agents.unwrap_or_default();
            v.push(input.into());
            self.device_user_agents = Some(v);
            self
        }
        /// <p>Device user agents that a rule will match.</p>
        pub fn set_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_user_agents = input;
            self
        }
        /// Appends an item to `not_device_user_agents`.
        ///
        /// To override the contents of this collection use [`set_not_device_user_agents`](Self::set_not_device_user_agents).
        ///
        /// <p>Device user agents that a rule <b>will not</b> match. All other device user agents will match.</p>
        pub fn not_device_user_agents(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_device_user_agents.unwrap_or_default();
            v.push(input.into());
            self.not_device_user_agents = Some(v);
            self
        }
        /// <p>Device user agents that a rule <b>will not</b> match. All other device user agents will match.</p>
        pub fn set_not_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_device_user_agents = input;
            self
        }
        /// <p>The date and time at which an access rule was created.</p>
        pub fn date_created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The date and time at which an access rule was created.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date and time at which an access rule was modified.</p>
        pub fn date_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_modified = Some(input);
            self
        }
        /// <p>The date and time at which an access rule was modified.</p>
        pub fn set_date_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`MobileDeviceAccessRule`](crate::model::MobileDeviceAccessRule)
        pub fn build(self) -> crate::model::MobileDeviceAccessRule {
            crate::model::MobileDeviceAccessRule {
                mobile_device_access_rule_id: self.mobile_device_access_rule_id,
                name: self.name,
                description: self.description,
                effect: self.effect,
                device_types: self.device_types,
                not_device_types: self.not_device_types,
                device_models: self.device_models,
                not_device_models: self.not_device_models,
                device_operating_systems: self.device_operating_systems,
                not_device_operating_systems: self.not_device_operating_systems,
                device_user_agents: self.device_user_agents,
                not_device_user_agents: self.not_device_user_agents,
                date_created: self.date_created,
                date_modified: self.date_modified,
            }
        }
    }
}
impl MobileDeviceAccessRule {
    /// Creates a new builder-style object to manufacture [`MobileDeviceAccessRule`](crate::model::MobileDeviceAccessRule)
    pub fn builder() -> crate::model::mobile_device_access_rule::Builder {
        crate::model::mobile_device_access_rule::Builder::default()
    }
}

/// <p>The override object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MobileDeviceAccessOverride {
    /// <p>The WorkMail user to which the access override applies.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The device to which the override applies.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
    pub effect: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
    /// <p>A description of the override.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date the override was first created.</p>
    pub date_created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the override was last modified.</p>
    pub date_modified: std::option::Option<aws_smithy_types::DateTime>,
}
impl MobileDeviceAccessOverride {
    /// <p>The WorkMail user to which the access override applies.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The device to which the override applies.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
    pub fn effect(&self) -> std::option::Option<&crate::model::MobileDeviceAccessRuleEffect> {
        self.effect.as_ref()
    }
    /// <p>A description of the override.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date the override was first created.</p>
    pub fn date_created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_created.as_ref()
    }
    /// <p>The date the override was last modified.</p>
    pub fn date_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_modified.as_ref()
    }
}
impl std::fmt::Debug for MobileDeviceAccessOverride {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MobileDeviceAccessOverride");
        formatter.field("user_id", &self.user_id);
        formatter.field("device_id", &self.device_id);
        formatter.field("effect", &self.effect);
        formatter.field("description", &self.description);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_modified", &self.date_modified);
        formatter.finish()
    }
}
/// See [`MobileDeviceAccessOverride`](crate::model::MobileDeviceAccessOverride)
pub mod mobile_device_access_override {
    /// A builder for [`MobileDeviceAccessOverride`](crate::model::MobileDeviceAccessOverride)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) effect: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) date_modified: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The WorkMail user to which the access override applies.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The WorkMail user to which the access override applies.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The device to which the override applies.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device to which the override applies.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, input: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.effect = Some(input);
            self
        }
        /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.effect = input;
            self
        }
        /// <p>A description of the override.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the override.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date the override was first created.</p>
        pub fn date_created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The date the override was first created.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date the override was last modified.</p>
        pub fn date_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_modified = Some(input);
            self
        }
        /// <p>The date the override was last modified.</p>
        pub fn set_date_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`MobileDeviceAccessOverride`](crate::model::MobileDeviceAccessOverride)
        pub fn build(self) -> crate::model::MobileDeviceAccessOverride {
            crate::model::MobileDeviceAccessOverride {
                user_id: self.user_id,
                device_id: self.device_id,
                effect: self.effect,
                description: self.description,
                date_created: self.date_created,
                date_modified: self.date_modified,
            }
        }
    }
}
impl MobileDeviceAccessOverride {
    /// Creates a new builder-style object to manufacture [`MobileDeviceAccessOverride`](crate::model::MobileDeviceAccessOverride)
    pub fn builder() -> crate::model::mobile_device_access_override::Builder {
        crate::model::mobile_device_access_override::Builder::default()
    }
}

/// <p>The data for a given domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MailDomainSummary {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Whether the domain is default or not.</p>
    pub default_domain: bool,
}
impl MailDomainSummary {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Whether the domain is default or not.</p>
    pub fn default_domain(&self) -> bool {
        self.default_domain
    }
}
impl std::fmt::Debug for MailDomainSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MailDomainSummary");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("default_domain", &self.default_domain);
        formatter.finish()
    }
}
/// See [`MailDomainSummary`](crate::model::MailDomainSummary)
pub mod mail_domain_summary {
    /// A builder for [`MailDomainSummary`](crate::model::MailDomainSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) default_domain: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Whether the domain is default or not.</p>
        pub fn default_domain(mut self, input: bool) -> Self {
            self.default_domain = Some(input);
            self
        }
        /// <p>Whether the domain is default or not.</p>
        pub fn set_default_domain(mut self, input: std::option::Option<bool>) -> Self {
            self.default_domain = input;
            self
        }
        /// Consumes the builder and constructs a [`MailDomainSummary`](crate::model::MailDomainSummary)
        pub fn build(self) -> crate::model::MailDomainSummary {
            crate::model::MailDomainSummary {
                domain_name: self.domain_name,
                default_domain: self.default_domain.unwrap_or_default(),
            }
        }
    }
}
impl MailDomainSummary {
    /// Creates a new builder-style object to manufacture [`MailDomainSummary`](crate::model::MailDomainSummary)
    pub fn builder() -> crate::model::mail_domain_summary::Builder {
        crate::model::mail_domain_summary::Builder::default()
    }
}

/// <p>Permission granted to a user, group, or resource to access a certain aspect of
/// another user, group, or resource mailbox.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Permission {
    /// <p>The identifier of the user, group, or resource to which the permissions are
    /// granted.</p>
    pub grantee_id: std::option::Option<std::string::String>,
    /// <p>The type of user, group, or resource referred to in GranteeId.</p>
    pub grantee_type: std::option::Option<crate::model::MemberType>,
    /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as
    /// the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
    /// allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
    /// mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
    /// access to the mailbox, irrespective of other folder-level permissions set on the
    /// mailbox.</p>
    pub permission_values: std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
}
impl Permission {
    /// <p>The identifier of the user, group, or resource to which the permissions are
    /// granted.</p>
    pub fn grantee_id(&self) -> std::option::Option<&str> {
        self.grantee_id.as_deref()
    }
    /// <p>The type of user, group, or resource referred to in GranteeId.</p>
    pub fn grantee_type(&self) -> std::option::Option<&crate::model::MemberType> {
        self.grantee_type.as_ref()
    }
    /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as
    /// the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
    /// allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
    /// mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
    /// access to the mailbox, irrespective of other folder-level permissions set on the
    /// mailbox.</p>
    pub fn permission_values(&self) -> std::option::Option<&[crate::model::PermissionType]> {
        self.permission_values.as_deref()
    }
}
impl std::fmt::Debug for Permission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Permission");
        formatter.field("grantee_id", &self.grantee_id);
        formatter.field("grantee_type", &self.grantee_type);
        formatter.field("permission_values", &self.permission_values);
        formatter.finish()
    }
}
/// See [`Permission`](crate::model::Permission)
pub mod permission {
    /// A builder for [`Permission`](crate::model::Permission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grantee_id: std::option::Option<std::string::String>,
        pub(crate) grantee_type: std::option::Option<crate::model::MemberType>,
        pub(crate) permission_values:
            std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
    }
    impl Builder {
        /// <p>The identifier of the user, group, or resource to which the permissions are
        /// granted.</p>
        pub fn grantee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user, group, or resource to which the permissions are
        /// granted.</p>
        pub fn set_grantee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantee_id = input;
            self
        }
        /// <p>The type of user, group, or resource referred to in GranteeId.</p>
        pub fn grantee_type(mut self, input: crate::model::MemberType) -> Self {
            self.grantee_type = Some(input);
            self
        }
        /// <p>The type of user, group, or resource referred to in GranteeId.</p>
        pub fn set_grantee_type(
            mut self,
            input: std::option::Option<crate::model::MemberType>,
        ) -> Self {
            self.grantee_type = input;
            self
        }
        /// Appends an item to `permission_values`.
        ///
        /// To override the contents of this collection use [`set_permission_values`](Self::set_permission_values).
        ///
        /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as
        /// the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
        /// allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
        /// mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
        /// access to the mailbox, irrespective of other folder-level permissions set on the
        /// mailbox.</p>
        pub fn permission_values(mut self, input: impl Into<crate::model::PermissionType>) -> Self {
            let mut v = self.permission_values.unwrap_or_default();
            v.push(input.into());
            self.permission_values = Some(v);
            self
        }
        /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as
        /// the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
        /// allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
        /// mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
        /// access to the mailbox, irrespective of other folder-level permissions set on the
        /// mailbox.</p>
        pub fn set_permission_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
        ) -> Self {
            self.permission_values = input;
            self
        }
        /// Consumes the builder and constructs a [`Permission`](crate::model::Permission)
        pub fn build(self) -> crate::model::Permission {
            crate::model::Permission {
                grantee_id: self.grantee_id,
                grantee_type: self.grantee_type,
                permission_values: self.permission_values,
            }
        }
    }
}
impl Permission {
    /// Creates a new builder-style object to manufacture [`Permission`](crate::model::Permission)
    pub fn builder() -> crate::model::permission::Builder {
        crate::model::permission::Builder::default()
    }
}

/// <p>The details of a mailbox export job, including the user or resource ID associated
/// with the mailbox and the S3 bucket that the mailbox contents are exported to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MailboxExportJob {
    /// <p>The identifier of the mailbox export job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the user or resource associated with the mailbox.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The mailbox export job description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the S3 bucket.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The path to the S3 bucket and file that the mailbox export job exports to.</p>
    pub s3_path: std::option::Option<std::string::String>,
    /// <p>The estimated progress of the mailbox export job, in percentage points.</p>
    pub estimated_progress: i32,
    /// <p>The state of the mailbox export job.</p>
    pub state: std::option::Option<crate::model::MailboxExportJobState>,
    /// <p>The mailbox export job start timestamp.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The mailbox export job end timestamp.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl MailboxExportJob {
    /// <p>The identifier of the mailbox export job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The identifier of the user or resource associated with the mailbox.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The mailbox export job description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the S3 bucket.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>The path to the S3 bucket and file that the mailbox export job exports to.</p>
    pub fn s3_path(&self) -> std::option::Option<&str> {
        self.s3_path.as_deref()
    }
    /// <p>The estimated progress of the mailbox export job, in percentage points.</p>
    pub fn estimated_progress(&self) -> i32 {
        self.estimated_progress
    }
    /// <p>The state of the mailbox export job.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::MailboxExportJobState> {
        self.state.as_ref()
    }
    /// <p>The mailbox export job start timestamp.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The mailbox export job end timestamp.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for MailboxExportJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MailboxExportJob");
        formatter.field("job_id", &self.job_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("description", &self.description);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_path", &self.s3_path);
        formatter.field("estimated_progress", &self.estimated_progress);
        formatter.field("state", &self.state);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`MailboxExportJob`](crate::model::MailboxExportJob)
pub mod mailbox_export_job {
    /// A builder for [`MailboxExportJob`](crate::model::MailboxExportJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_path: std::option::Option<std::string::String>,
        pub(crate) estimated_progress: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::MailboxExportJobState>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the mailbox export job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the mailbox export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The identifier of the user or resource associated with the mailbox.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user or resource associated with the mailbox.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The mailbox export job description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The mailbox export job description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The path to the S3 bucket and file that the mailbox export job exports to.</p>
        pub fn s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_path = Some(input.into());
            self
        }
        /// <p>The path to the S3 bucket and file that the mailbox export job exports to.</p>
        pub fn set_s3_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_path = input;
            self
        }
        /// <p>The estimated progress of the mailbox export job, in percentage points.</p>
        pub fn estimated_progress(mut self, input: i32) -> Self {
            self.estimated_progress = Some(input);
            self
        }
        /// <p>The estimated progress of the mailbox export job, in percentage points.</p>
        pub fn set_estimated_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.estimated_progress = input;
            self
        }
        /// <p>The state of the mailbox export job.</p>
        pub fn state(mut self, input: crate::model::MailboxExportJobState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the mailbox export job.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::MailboxExportJobState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The mailbox export job start timestamp.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The mailbox export job start timestamp.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The mailbox export job end timestamp.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The mailbox export job end timestamp.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`MailboxExportJob`](crate::model::MailboxExportJob)
        pub fn build(self) -> crate::model::MailboxExportJob {
            crate::model::MailboxExportJob {
                job_id: self.job_id,
                entity_id: self.entity_id,
                description: self.description,
                s3_bucket_name: self.s3_bucket_name,
                s3_path: self.s3_path,
                estimated_progress: self.estimated_progress.unwrap_or_default(),
                state: self.state,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl MailboxExportJob {
    /// Creates a new builder-style object to manufacture [`MailboxExportJob`](crate::model::MailboxExportJob)
    pub fn builder() -> crate::model::mailbox_export_job::Builder {
        crate::model::mailbox_export_job::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MailboxExportJobState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MailboxExportJobState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => MailboxExportJobState::Cancelled,
            "COMPLETED" => MailboxExportJobState::Completed,
            "FAILED" => MailboxExportJobState::Failed,
            "RUNNING" => MailboxExportJobState::Running,
            other => MailboxExportJobState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MailboxExportJobState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MailboxExportJobState::from(s))
    }
}
impl MailboxExportJobState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MailboxExportJobState::Cancelled => "CANCELLED",
            MailboxExportJobState::Completed => "COMPLETED",
            MailboxExportJobState::Failed => "FAILED",
            MailboxExportJobState::Running => "RUNNING",
            MailboxExportJobState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "COMPLETED", "FAILED", "RUNNING"]
    }
}
impl AsRef<str> for MailboxExportJobState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The representation of an Amazon WorkMail group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Group {
    /// <p>The identifier of the group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The email of the group.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The name of the group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The state of the group, which can be ENABLED, DISABLED, or DELETED.</p>
    pub state: std::option::Option<crate::model::EntityState>,
    /// <p>The date indicating when the group was enabled for Amazon WorkMail use.</p>
    pub enabled_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date indicating when the group was disabled from Amazon WorkMail use.</p>
    pub disabled_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl Group {
    /// <p>The identifier of the group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The email of the group.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The name of the group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The state of the group, which can be ENABLED, DISABLED, or DELETED.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::EntityState> {
        self.state.as_ref()
    }
    /// <p>The date indicating when the group was enabled for Amazon WorkMail use.</p>
    pub fn enabled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.enabled_date.as_ref()
    }
    /// <p>The date indicating when the group was disabled from Amazon WorkMail use.</p>
    pub fn disabled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.disabled_date.as_ref()
    }
}
impl std::fmt::Debug for Group {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Group");
        formatter.field("id", &self.id);
        formatter.field("email", &self.email);
        formatter.field("name", &self.name);
        formatter.field("state", &self.state);
        formatter.field("enabled_date", &self.enabled_date);
        formatter.field("disabled_date", &self.disabled_date);
        formatter.finish()
    }
}
/// See [`Group`](crate::model::Group)
pub mod group {
    /// A builder for [`Group`](crate::model::Group)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EntityState>,
        pub(crate) enabled_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) disabled_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The email of the group.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email of the group.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The name of the group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The state of the group, which can be ENABLED, DISABLED, or DELETED.</p>
        pub fn state(mut self, input: crate::model::EntityState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the group, which can be ENABLED, DISABLED, or DELETED.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::EntityState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The date indicating when the group was enabled for Amazon WorkMail use.</p>
        pub fn enabled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.enabled_date = Some(input);
            self
        }
        /// <p>The date indicating when the group was enabled for Amazon WorkMail use.</p>
        pub fn set_enabled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.enabled_date = input;
            self
        }
        /// <p>The date indicating when the group was disabled from Amazon WorkMail use.</p>
        pub fn disabled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.disabled_date = Some(input);
            self
        }
        /// <p>The date indicating when the group was disabled from Amazon WorkMail use.</p>
        pub fn set_disabled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.disabled_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Group`](crate::model::Group)
        pub fn build(self) -> crate::model::Group {
            crate::model::Group {
                id: self.id,
                email: self.email,
                name: self.name,
                state: self.state,
                enabled_date: self.enabled_date,
                disabled_date: self.disabled_date,
            }
        }
    }
}
impl Group {
    /// Creates a new builder-style object to manufacture [`Group`](crate::model::Group)
    pub fn builder() -> crate::model::group::Builder {
        crate::model::group::Builder::default()
    }
}

/// <p>The representation of a user or group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Member {
    /// <p>The identifier of the member.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the member.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A member can be a user or group.</p>
    pub r#type: std::option::Option<crate::model::MemberType>,
    /// <p>The state of the member, which can be ENABLED, DISABLED, or DELETED.</p>
    pub state: std::option::Option<crate::model::EntityState>,
    /// <p>The date indicating when the member was enabled for Amazon WorkMail use.</p>
    pub enabled_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date indicating when the member was disabled from Amazon WorkMail use.</p>
    pub disabled_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl Member {
    /// <p>The identifier of the member.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the member.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A member can be a user or group.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::MemberType> {
        self.r#type.as_ref()
    }
    /// <p>The state of the member, which can be ENABLED, DISABLED, or DELETED.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::EntityState> {
        self.state.as_ref()
    }
    /// <p>The date indicating when the member was enabled for Amazon WorkMail use.</p>
    pub fn enabled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.enabled_date.as_ref()
    }
    /// <p>The date indicating when the member was disabled from Amazon WorkMail use.</p>
    pub fn disabled_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.disabled_date.as_ref()
    }
}
impl std::fmt::Debug for Member {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Member");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("state", &self.state);
        formatter.field("enabled_date", &self.enabled_date);
        formatter.field("disabled_date", &self.disabled_date);
        formatter.finish()
    }
}
/// See [`Member`](crate::model::Member)
pub mod member {
    /// A builder for [`Member`](crate::model::Member)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::MemberType>,
        pub(crate) state: std::option::Option<crate::model::EntityState>,
        pub(crate) enabled_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) disabled_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the member.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the member.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the member.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the member.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A member can be a user or group.</p>
        pub fn r#type(mut self, input: crate::model::MemberType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>A member can be a user or group.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::MemberType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The state of the member, which can be ENABLED, DISABLED, or DELETED.</p>
        pub fn state(mut self, input: crate::model::EntityState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the member, which can be ENABLED, DISABLED, or DELETED.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::EntityState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The date indicating when the member was enabled for Amazon WorkMail use.</p>
        pub fn enabled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.enabled_date = Some(input);
            self
        }
        /// <p>The date indicating when the member was enabled for Amazon WorkMail use.</p>
        pub fn set_enabled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.enabled_date = input;
            self
        }
        /// <p>The date indicating when the member was disabled from Amazon WorkMail use.</p>
        pub fn disabled_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.disabled_date = Some(input);
            self
        }
        /// <p>The date indicating when the member was disabled from Amazon WorkMail use.</p>
        pub fn set_disabled_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.disabled_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Member`](crate::model::Member)
        pub fn build(self) -> crate::model::Member {
            crate::model::Member {
                id: self.id,
                name: self.name,
                r#type: self.r#type,
                state: self.state,
                enabled_date: self.enabled_date,
                disabled_date: self.disabled_date,
            }
        }
    }
}
impl Member {
    /// Creates a new builder-style object to manufacture [`Member`](crate::model::Member)
    pub fn builder() -> crate::model::member::Builder {
        crate::model::member::Builder::default()
    }
}

/// <p>A rule that controls access to an Amazon WorkMail organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessControlRule {
    /// <p>The rule name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The rule effect.</p>
    pub effect: std::option::Option<crate::model::AccessControlRuleEffect>,
    /// <p>The rule description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>IPv4 CIDR ranges to include in the rule.</p>
    pub ip_ranges: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
    pub not_ip_ranges: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Access protocol actions to include in the rule. Valid values include
    /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
    /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    pub actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Access protocol actions to exclude from the rule. Valid values include
    /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
    /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    pub not_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>User IDs to include in the rule.</p>
    pub user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>User IDs to exclude from the rule.</p>
    pub not_user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date that the rule was created.</p>
    pub date_created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date that the rule was modified.</p>
    pub date_modified: std::option::Option<aws_smithy_types::DateTime>,
}
impl AccessControlRule {
    /// <p>The rule name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The rule effect.</p>
    pub fn effect(&self) -> std::option::Option<&crate::model::AccessControlRuleEffect> {
        self.effect.as_ref()
    }
    /// <p>The rule description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>IPv4 CIDR ranges to include in the rule.</p>
    pub fn ip_ranges(&self) -> std::option::Option<&[std::string::String]> {
        self.ip_ranges.as_deref()
    }
    /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
    pub fn not_ip_ranges(&self) -> std::option::Option<&[std::string::String]> {
        self.not_ip_ranges.as_deref()
    }
    /// <p>Access protocol actions to include in the rule. Valid values include
    /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
    /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    pub fn actions(&self) -> std::option::Option<&[std::string::String]> {
        self.actions.as_deref()
    }
    /// <p>Access protocol actions to exclude from the rule. Valid values include
    /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
    /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
    pub fn not_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.not_actions.as_deref()
    }
    /// <p>User IDs to include in the rule.</p>
    pub fn user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.user_ids.as_deref()
    }
    /// <p>User IDs to exclude from the rule.</p>
    pub fn not_user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.not_user_ids.as_deref()
    }
    /// <p>The date that the rule was created.</p>
    pub fn date_created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_created.as_ref()
    }
    /// <p>The date that the rule was modified.</p>
    pub fn date_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_modified.as_ref()
    }
}
impl std::fmt::Debug for AccessControlRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessControlRule");
        formatter.field("name", &self.name);
        formatter.field("effect", &self.effect);
        formatter.field("description", &self.description);
        formatter.field("ip_ranges", &self.ip_ranges);
        formatter.field("not_ip_ranges", &self.not_ip_ranges);
        formatter.field("actions", &self.actions);
        formatter.field("not_actions", &self.not_actions);
        formatter.field("user_ids", &self.user_ids);
        formatter.field("not_user_ids", &self.not_user_ids);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_modified", &self.date_modified);
        formatter.finish()
    }
}
/// See [`AccessControlRule`](crate::model::AccessControlRule)
pub mod access_control_rule {
    /// A builder for [`AccessControlRule`](crate::model::AccessControlRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) effect: std::option::Option<crate::model::AccessControlRuleEffect>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ip_ranges: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_ip_ranges: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) date_created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) date_modified: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The rule name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The rule name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The rule effect.</p>
        pub fn effect(mut self, input: crate::model::AccessControlRuleEffect) -> Self {
            self.effect = Some(input);
            self
        }
        /// <p>The rule effect.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::AccessControlRuleEffect>,
        ) -> Self {
            self.effect = input;
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ip_ranges`.
        ///
        /// To override the contents of this collection use [`set_ip_ranges`](Self::set_ip_ranges).
        ///
        /// <p>IPv4 CIDR ranges to include in the rule.</p>
        pub fn ip_ranges(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_ranges.unwrap_or_default();
            v.push(input.into());
            self.ip_ranges = Some(v);
            self
        }
        /// <p>IPv4 CIDR ranges to include in the rule.</p>
        pub fn set_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_ranges = input;
            self
        }
        /// Appends an item to `not_ip_ranges`.
        ///
        /// To override the contents of this collection use [`set_not_ip_ranges`](Self::set_not_ip_ranges).
        ///
        /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
        pub fn not_ip_ranges(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_ip_ranges.unwrap_or_default();
            v.push(input.into());
            self.not_ip_ranges = Some(v);
            self
        }
        /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
        pub fn set_not_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_ip_ranges = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>Access protocol actions to include in the rule. Valid values include
        /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
        /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>Access protocol actions to include in the rule. Valid values include
        /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
        /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Appends an item to `not_actions`.
        ///
        /// To override the contents of this collection use [`set_not_actions`](Self::set_not_actions).
        ///
        /// <p>Access protocol actions to exclude from the rule. Valid values include
        /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
        /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn not_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_actions.unwrap_or_default();
            v.push(input.into());
            self.not_actions = Some(v);
            self
        }
        /// <p>Access protocol actions to exclude from the rule. Valid values include
        /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
        /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_not_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_actions = input;
            self
        }
        /// Appends an item to `user_ids`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>User IDs to include in the rule.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids.unwrap_or_default();
            v.push(input.into());
            self.user_ids = Some(v);
            self
        }
        /// <p>User IDs to include in the rule.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids = input;
            self
        }
        /// Appends an item to `not_user_ids`.
        ///
        /// To override the contents of this collection use [`set_not_user_ids`](Self::set_not_user_ids).
        ///
        /// <p>User IDs to exclude from the rule.</p>
        pub fn not_user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_user_ids.unwrap_or_default();
            v.push(input.into());
            self.not_user_ids = Some(v);
            self
        }
        /// <p>User IDs to exclude from the rule.</p>
        pub fn set_not_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_user_ids = input;
            self
        }
        /// <p>The date that the rule was created.</p>
        pub fn date_created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_created = Some(input);
            self
        }
        /// <p>The date that the rule was created.</p>
        pub fn set_date_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date that the rule was modified.</p>
        pub fn date_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_modified = Some(input);
            self
        }
        /// <p>The date that the rule was modified.</p>
        pub fn set_date_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessControlRule`](crate::model::AccessControlRule)
        pub fn build(self) -> crate::model::AccessControlRule {
            crate::model::AccessControlRule {
                name: self.name,
                effect: self.effect,
                description: self.description,
                ip_ranges: self.ip_ranges,
                not_ip_ranges: self.not_ip_ranges,
                actions: self.actions,
                not_actions: self.not_actions,
                user_ids: self.user_ids,
                not_user_ids: self.not_user_ids,
                date_created: self.date_created,
                date_modified: self.date_modified,
            }
        }
    }
}
impl AccessControlRule {
    /// Creates a new builder-style object to manufacture [`AccessControlRule`](crate::model::AccessControlRule)
    pub fn builder() -> crate::model::access_control_rule::Builder {
        crate::model::access_control_rule::Builder::default()
    }
}

/// <p>The rule that a simulated user matches.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MobileDeviceAccessMatchedRule {
    /// <p>Identifier of the rule that a simulated user matches.</p>
    pub mobile_device_access_rule_id: std::option::Option<std::string::String>,
    /// <p>Name of a rule that a simulated user matches.</p>
    pub name: std::option::Option<std::string::String>,
}
impl MobileDeviceAccessMatchedRule {
    /// <p>Identifier of the rule that a simulated user matches.</p>
    pub fn mobile_device_access_rule_id(&self) -> std::option::Option<&str> {
        self.mobile_device_access_rule_id.as_deref()
    }
    /// <p>Name of a rule that a simulated user matches.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for MobileDeviceAccessMatchedRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MobileDeviceAccessMatchedRule");
        formatter.field(
            "mobile_device_access_rule_id",
            &self.mobile_device_access_rule_id,
        );
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`MobileDeviceAccessMatchedRule`](crate::model::MobileDeviceAccessMatchedRule)
pub mod mobile_device_access_matched_rule {
    /// A builder for [`MobileDeviceAccessMatchedRule`](crate::model::MobileDeviceAccessMatchedRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mobile_device_access_rule_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the rule that a simulated user matches.</p>
        pub fn mobile_device_access_rule_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.mobile_device_access_rule_id = Some(input.into());
            self
        }
        /// <p>Identifier of the rule that a simulated user matches.</p>
        pub fn set_mobile_device_access_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mobile_device_access_rule_id = input;
            self
        }
        /// <p>Name of a rule that a simulated user matches.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a rule that a simulated user matches.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`MobileDeviceAccessMatchedRule`](crate::model::MobileDeviceAccessMatchedRule)
        pub fn build(self) -> crate::model::MobileDeviceAccessMatchedRule {
            crate::model::MobileDeviceAccessMatchedRule {
                mobile_device_access_rule_id: self.mobile_device_access_rule_id,
                name: self.name,
            }
        }
    }
}
impl MobileDeviceAccessMatchedRule {
    /// Creates a new builder-style object to manufacture [`MobileDeviceAccessMatchedRule`](crate::model::MobileDeviceAccessMatchedRule)
    pub fn builder() -> crate::model::mobile_device_access_matched_rule::Builder {
        crate::model::mobile_device_access_matched_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DnsRecordVerificationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Verified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DnsRecordVerificationStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => DnsRecordVerificationStatus::Failed,
            "PENDING" => DnsRecordVerificationStatus::Pending,
            "VERIFIED" => DnsRecordVerificationStatus::Verified,
            other => DnsRecordVerificationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DnsRecordVerificationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DnsRecordVerificationStatus::from(s))
    }
}
impl DnsRecordVerificationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DnsRecordVerificationStatus::Failed => "FAILED",
            DnsRecordVerificationStatus::Pending => "PENDING",
            DnsRecordVerificationStatus::Verified => "VERIFIED",
            DnsRecordVerificationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING", "VERIFIED"]
    }
}
impl AsRef<str> for DnsRecordVerificationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A DNS record uploaded to your DNS provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsRecord {
    /// <p>The RFC 1035 record type. Possible values: <code>CNAME</code>, <code>A</code>, <code>MX</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The DNS hostname.- For example, <code>domain.example.com</code>.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>The value returned by the DNS for a query to that hostname and record type.</p>
    pub value: std::option::Option<std::string::String>,
}
impl DnsRecord {
    /// <p>The RFC 1035 record type. Possible values: <code>CNAME</code>, <code>A</code>, <code>MX</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The DNS hostname.- For example, <code>domain.example.com</code>.</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>The value returned by the DNS for a query to that hostname and record type.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for DnsRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsRecord");
        formatter.field("r#type", &self.r#type);
        formatter.field("hostname", &self.hostname);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`DnsRecord`](crate::model::DnsRecord)
pub mod dns_record {
    /// A builder for [`DnsRecord`](crate::model::DnsRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The RFC 1035 record type. Possible values: <code>CNAME</code>, <code>A</code>, <code>MX</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The RFC 1035 record type. Possible values: <code>CNAME</code>, <code>A</code>, <code>MX</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The DNS hostname.- For example, <code>domain.example.com</code>.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The DNS hostname.- For example, <code>domain.example.com</code>.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>The value returned by the DNS for a query to that hostname and record type.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value returned by the DNS for a query to that hostname and record type.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsRecord`](crate::model::DnsRecord)
        pub fn build(self) -> crate::model::DnsRecord {
            crate::model::DnsRecord {
                r#type: self.r#type,
                hostname: self.hostname,
                value: self.value,
            }
        }
    }
}
impl DnsRecord {
    /// Creates a new builder-style object to manufacture [`DnsRecord`](crate::model::DnsRecord)
    pub fn builder() -> crate::model::dns_record::Builder {
        crate::model::dns_record::Builder::default()
    }
}

/// <p>The domain to associate with an Amazon WorkMail organization.</p>
/// <p>When you configure a domain hosted in Amazon Route 53 (Route 53), all recommended DNS records are added to the organization when you create it. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a domain</a> in the <i>Amazon WorkMail Administrator Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Domain {
    /// <p>The fully qualified domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The hosted zone ID for a domain hosted in Route 53. Required when configuring a domain hosted in Route 53.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
}
impl Domain {
    /// <p>The fully qualified domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The hosted zone ID for a domain hosted in Route 53. Required when configuring a domain hosted in Route 53.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
}
impl std::fmt::Debug for Domain {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Domain");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.finish()
    }
}
/// See [`Domain`](crate::model::Domain)
pub mod domain {
    /// A builder for [`Domain`](crate::model::Domain)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The fully qualified domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The hosted zone ID for a domain hosted in Route 53. Required when configuring a domain hosted in Route 53.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The hosted zone ID for a domain hosted in Route 53. Required when configuring a domain hosted in Route 53.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Domain`](crate::model::Domain)
        pub fn build(self) -> crate::model::Domain {
            crate::model::Domain {
                domain_name: self.domain_name,
                hosted_zone_id: self.hosted_zone_id,
            }
        }
    }
}
impl Domain {
    /// Creates a new builder-style object to manufacture [`Domain`](crate::model::Domain)
    pub fn builder() -> crate::model::domain::Builder {
        crate::model::domain::Builder::default()
    }
}
