// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateDelegateToResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_delegate_to_resource`](crate::client::Client::associate_delegate_to_resource).
///
/// See [`crate::client::fluent_builders::AssociateDelegateToResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateDelegateToResource {
    _private: (),
}
impl AssociateDelegateToResource {
    /// Creates a new builder-style object to manufacture [`AssociateDelegateToResourceInput`](crate::input::AssociateDelegateToResourceInput)
    pub fn builder() -> crate::input::associate_delegate_to_resource_input::Builder {
        crate::input::associate_delegate_to_resource_input::Builder::default()
    }
    /// Creates a new `AssociateDelegateToResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateDelegateToResource {
    type Output = std::result::Result<
        crate::output::AssociateDelegateToResourceOutput,
        crate::error::AssociateDelegateToResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_delegate_to_resource_error(response)
        } else {
            crate::operation_deser::parse_associate_delegate_to_resource_response(response)
        }
    }
}

/// Operation shape for `AssociateMemberToGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_member_to_group`](crate::client::Client::associate_member_to_group).
///
/// See [`crate::client::fluent_builders::AssociateMemberToGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateMemberToGroup {
    _private: (),
}
impl AssociateMemberToGroup {
    /// Creates a new builder-style object to manufacture [`AssociateMemberToGroupInput`](crate::input::AssociateMemberToGroupInput)
    pub fn builder() -> crate::input::associate_member_to_group_input::Builder {
        crate::input::associate_member_to_group_input::Builder::default()
    }
    /// Creates a new `AssociateMemberToGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateMemberToGroup {
    type Output = std::result::Result<
        crate::output::AssociateMemberToGroupOutput,
        crate::error::AssociateMemberToGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_member_to_group_error(response)
        } else {
            crate::operation_deser::parse_associate_member_to_group_response(response)
        }
    }
}

/// Operation shape for `CancelMailboxExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_mailbox_export_job`](crate::client::Client::cancel_mailbox_export_job).
///
/// See [`crate::client::fluent_builders::CancelMailboxExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelMailboxExportJob {
    _private: (),
}
impl CancelMailboxExportJob {
    /// Creates a new builder-style object to manufacture [`CancelMailboxExportJobInput`](crate::input::CancelMailboxExportJobInput)
    pub fn builder() -> crate::input::cancel_mailbox_export_job_input::Builder {
        crate::input::cancel_mailbox_export_job_input::Builder::default()
    }
    /// Creates a new `CancelMailboxExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelMailboxExportJob {
    type Output = std::result::Result<
        crate::output::CancelMailboxExportJobOutput,
        crate::error::CancelMailboxExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_mailbox_export_job_error(response)
        } else {
            crate::operation_deser::parse_cancel_mailbox_export_job_response(response)
        }
    }
}

/// Operation shape for `CreateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_alias`](crate::client::Client::create_alias).
///
/// See [`crate::client::fluent_builders::CreateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAlias {
    _private: (),
}
impl CreateAlias {
    /// Creates a new builder-style object to manufacture [`CreateAliasInput`](crate::input::CreateAliasInput)
    pub fn builder() -> crate::input::create_alias_input::Builder {
        crate::input::create_alias_input::Builder::default()
    }
    /// Creates a new `CreateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAlias {
    type Output =
        std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_alias_error(response)
        } else {
            crate::operation_deser::parse_create_alias_response(response)
        }
    }
}

/// Operation shape for `CreateGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_group`](crate::client::Client::create_group).
///
/// See [`crate::client::fluent_builders::CreateGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGroup {
    _private: (),
}
impl CreateGroup {
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
    /// Creates a new `CreateGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGroup {
    type Output =
        std::result::Result<crate::output::CreateGroupOutput, crate::error::CreateGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_group_error(response)
        } else {
            crate::operation_deser::parse_create_group_response(response)
        }
    }
}

/// Operation shape for `CreateMobileDeviceAccessRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_mobile_device_access_rule`](crate::client::Client::create_mobile_device_access_rule).
///
/// See [`crate::client::fluent_builders::CreateMobileDeviceAccessRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMobileDeviceAccessRule {
    _private: (),
}
impl CreateMobileDeviceAccessRule {
    /// Creates a new builder-style object to manufacture [`CreateMobileDeviceAccessRuleInput`](crate::input::CreateMobileDeviceAccessRuleInput)
    pub fn builder() -> crate::input::create_mobile_device_access_rule_input::Builder {
        crate::input::create_mobile_device_access_rule_input::Builder::default()
    }
    /// Creates a new `CreateMobileDeviceAccessRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMobileDeviceAccessRule {
    type Output = std::result::Result<
        crate::output::CreateMobileDeviceAccessRuleOutput,
        crate::error::CreateMobileDeviceAccessRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_mobile_device_access_rule_error(response)
        } else {
            crate::operation_deser::parse_create_mobile_device_access_rule_response(response)
        }
    }
}

/// Operation shape for `CreateOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_organization`](crate::client::Client::create_organization).
///
/// See [`crate::client::fluent_builders::CreateOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOrganization {
    _private: (),
}
impl CreateOrganization {
    /// Creates a new builder-style object to manufacture [`CreateOrganizationInput`](crate::input::CreateOrganizationInput)
    pub fn builder() -> crate::input::create_organization_input::Builder {
        crate::input::create_organization_input::Builder::default()
    }
    /// Creates a new `CreateOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOrganization {
    type Output = std::result::Result<
        crate::output::CreateOrganizationOutput,
        crate::error::CreateOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_organization_error(response)
        } else {
            crate::operation_deser::parse_create_organization_response(response)
        }
    }
}

/// Operation shape for `CreateResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resource`](crate::client::Client::create_resource).
///
/// See [`crate::client::fluent_builders::CreateResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResource {
    _private: (),
}
impl CreateResource {
    /// Creates a new builder-style object to manufacture [`CreateResourceInput`](crate::input::CreateResourceInput)
    pub fn builder() -> crate::input::create_resource_input::Builder {
        crate::input::create_resource_input::Builder::default()
    }
    /// Creates a new `CreateResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResource {
    type Output =
        std::result::Result<crate::output::CreateResourceOutput, crate::error::CreateResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resource_error(response)
        } else {
            crate::operation_deser::parse_create_resource_response(response)
        }
    }
}

/// Operation shape for `CreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user`](crate::client::Client::create_user).
///
/// See [`crate::client::fluent_builders::CreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUser {
    _private: (),
}
impl CreateUser {
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
    /// Creates a new `CreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUser {
    type Output =
        std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_error(response)
        } else {
            crate::operation_deser::parse_create_user_response(response)
        }
    }
}

/// Operation shape for `DeleteAccessControlRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_access_control_rule`](crate::client::Client::delete_access_control_rule).
///
/// See [`crate::client::fluent_builders::DeleteAccessControlRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccessControlRule {
    _private: (),
}
impl DeleteAccessControlRule {
    /// Creates a new builder-style object to manufacture [`DeleteAccessControlRuleInput`](crate::input::DeleteAccessControlRuleInput)
    pub fn builder() -> crate::input::delete_access_control_rule_input::Builder {
        crate::input::delete_access_control_rule_input::Builder::default()
    }
    /// Creates a new `DeleteAccessControlRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccessControlRule {
    type Output = std::result::Result<
        crate::output::DeleteAccessControlRuleOutput,
        crate::error::DeleteAccessControlRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_access_control_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_access_control_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_alias`](crate::client::Client::delete_alias).
///
/// See [`crate::client::fluent_builders::DeleteAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAlias {
    _private: (),
}
impl DeleteAlias {
    /// Creates a new builder-style object to manufacture [`DeleteAliasInput`](crate::input::DeleteAliasInput)
    pub fn builder() -> crate::input::delete_alias_input::Builder {
        crate::input::delete_alias_input::Builder::default()
    }
    /// Creates a new `DeleteAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAlias {
    type Output =
        std::result::Result<crate::output::DeleteAliasOutput, crate::error::DeleteAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_alias_error(response)
        } else {
            crate::operation_deser::parse_delete_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_group`](crate::client::Client::delete_group).
///
/// See [`crate::client::fluent_builders::DeleteGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGroup {
    _private: (),
}
impl DeleteGroup {
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
    /// Creates a new `DeleteGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGroup {
    type Output =
        std::result::Result<crate::output::DeleteGroupOutput, crate::error::DeleteGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_group_error(response)
        } else {
            crate::operation_deser::parse_delete_group_response(response)
        }
    }
}

/// Operation shape for `DeleteMailboxPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_mailbox_permissions`](crate::client::Client::delete_mailbox_permissions).
///
/// See [`crate::client::fluent_builders::DeleteMailboxPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMailboxPermissions {
    _private: (),
}
impl DeleteMailboxPermissions {
    /// Creates a new builder-style object to manufacture [`DeleteMailboxPermissionsInput`](crate::input::DeleteMailboxPermissionsInput)
    pub fn builder() -> crate::input::delete_mailbox_permissions_input::Builder {
        crate::input::delete_mailbox_permissions_input::Builder::default()
    }
    /// Creates a new `DeleteMailboxPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMailboxPermissions {
    type Output = std::result::Result<
        crate::output::DeleteMailboxPermissionsOutput,
        crate::error::DeleteMailboxPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_mailbox_permissions_error(response)
        } else {
            crate::operation_deser::parse_delete_mailbox_permissions_response(response)
        }
    }
}

/// Operation shape for `DeleteMobileDeviceAccessOverride`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_mobile_device_access_override`](crate::client::Client::delete_mobile_device_access_override).
///
/// See [`crate::client::fluent_builders::DeleteMobileDeviceAccessOverride`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMobileDeviceAccessOverride {
    _private: (),
}
impl DeleteMobileDeviceAccessOverride {
    /// Creates a new builder-style object to manufacture [`DeleteMobileDeviceAccessOverrideInput`](crate::input::DeleteMobileDeviceAccessOverrideInput)
    pub fn builder() -> crate::input::delete_mobile_device_access_override_input::Builder {
        crate::input::delete_mobile_device_access_override_input::Builder::default()
    }
    /// Creates a new `DeleteMobileDeviceAccessOverride` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMobileDeviceAccessOverride {
    type Output = std::result::Result<
        crate::output::DeleteMobileDeviceAccessOverrideOutput,
        crate::error::DeleteMobileDeviceAccessOverrideError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_mobile_device_access_override_error(response)
        } else {
            crate::operation_deser::parse_delete_mobile_device_access_override_response(response)
        }
    }
}

/// Operation shape for `DeleteMobileDeviceAccessRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_mobile_device_access_rule`](crate::client::Client::delete_mobile_device_access_rule).
///
/// See [`crate::client::fluent_builders::DeleteMobileDeviceAccessRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMobileDeviceAccessRule {
    _private: (),
}
impl DeleteMobileDeviceAccessRule {
    /// Creates a new builder-style object to manufacture [`DeleteMobileDeviceAccessRuleInput`](crate::input::DeleteMobileDeviceAccessRuleInput)
    pub fn builder() -> crate::input::delete_mobile_device_access_rule_input::Builder {
        crate::input::delete_mobile_device_access_rule_input::Builder::default()
    }
    /// Creates a new `DeleteMobileDeviceAccessRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMobileDeviceAccessRule {
    type Output = std::result::Result<
        crate::output::DeleteMobileDeviceAccessRuleOutput,
        crate::error::DeleteMobileDeviceAccessRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_mobile_device_access_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_mobile_device_access_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_organization`](crate::client::Client::delete_organization).
///
/// See [`crate::client::fluent_builders::DeleteOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOrganization {
    _private: (),
}
impl DeleteOrganization {
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationInput`](crate::input::DeleteOrganizationInput)
    pub fn builder() -> crate::input::delete_organization_input::Builder {
        crate::input::delete_organization_input::Builder::default()
    }
    /// Creates a new `DeleteOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOrganization {
    type Output = std::result::Result<
        crate::output::DeleteOrganizationOutput,
        crate::error::DeleteOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_organization_error(response)
        } else {
            crate::operation_deser::parse_delete_organization_response(response)
        }
    }
}

/// Operation shape for `DeleteResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource`](crate::client::Client::delete_resource).
///
/// See [`crate::client::fluent_builders::DeleteResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResource {
    _private: (),
}
impl DeleteResource {
    /// Creates a new builder-style object to manufacture [`DeleteResourceInput`](crate::input::DeleteResourceInput)
    pub fn builder() -> crate::input::delete_resource_input::Builder {
        crate::input::delete_resource_input::Builder::default()
    }
    /// Creates a new `DeleteResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResource {
    type Output =
        std::result::Result<crate::output::DeleteResourceOutput, crate::error::DeleteResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_response(response)
        }
    }
}

/// Operation shape for `DeleteRetentionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_retention_policy`](crate::client::Client::delete_retention_policy).
///
/// See [`crate::client::fluent_builders::DeleteRetentionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRetentionPolicy {
    _private: (),
}
impl DeleteRetentionPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteRetentionPolicyInput`](crate::input::DeleteRetentionPolicyInput)
    pub fn builder() -> crate::input::delete_retention_policy_input::Builder {
        crate::input::delete_retention_policy_input::Builder::default()
    }
    /// Creates a new `DeleteRetentionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRetentionPolicy {
    type Output = std::result::Result<
        crate::output::DeleteRetentionPolicyOutput,
        crate::error::DeleteRetentionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_retention_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_retention_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user`](crate::client::Client::delete_user).
///
/// See [`crate::client::fluent_builders::DeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUser {
    _private: (),
}
impl DeleteUser {
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
    /// Creates a new `DeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUser {
    type Output =
        std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_error(response)
        } else {
            crate::operation_deser::parse_delete_user_response(response)
        }
    }
}

/// Operation shape for `DeregisterFromWorkMail`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_from_work_mail`](crate::client::Client::deregister_from_work_mail).
///
/// See [`crate::client::fluent_builders::DeregisterFromWorkMail`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterFromWorkMail {
    _private: (),
}
impl DeregisterFromWorkMail {
    /// Creates a new builder-style object to manufacture [`DeregisterFromWorkMailInput`](crate::input::DeregisterFromWorkMailInput)
    pub fn builder() -> crate::input::deregister_from_work_mail_input::Builder {
        crate::input::deregister_from_work_mail_input::Builder::default()
    }
    /// Creates a new `DeregisterFromWorkMail` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterFromWorkMail {
    type Output = std::result::Result<
        crate::output::DeregisterFromWorkMailOutput,
        crate::error::DeregisterFromWorkMailError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_from_work_mail_error(response)
        } else {
            crate::operation_deser::parse_deregister_from_work_mail_response(response)
        }
    }
}

/// Operation shape for `DeregisterMailDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_mail_domain`](crate::client::Client::deregister_mail_domain).
///
/// See [`crate::client::fluent_builders::DeregisterMailDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterMailDomain {
    _private: (),
}
impl DeregisterMailDomain {
    /// Creates a new builder-style object to manufacture [`DeregisterMailDomainInput`](crate::input::DeregisterMailDomainInput)
    pub fn builder() -> crate::input::deregister_mail_domain_input::Builder {
        crate::input::deregister_mail_domain_input::Builder::default()
    }
    /// Creates a new `DeregisterMailDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterMailDomain {
    type Output = std::result::Result<
        crate::output::DeregisterMailDomainOutput,
        crate::error::DeregisterMailDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_mail_domain_error(response)
        } else {
            crate::operation_deser::parse_deregister_mail_domain_response(response)
        }
    }
}

/// Operation shape for `DescribeGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_group`](crate::client::Client::describe_group).
///
/// See [`crate::client::fluent_builders::DescribeGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGroup {
    _private: (),
}
impl DescribeGroup {
    /// Creates a new builder-style object to manufacture [`DescribeGroupInput`](crate::input::DescribeGroupInput)
    pub fn builder() -> crate::input::describe_group_input::Builder {
        crate::input::describe_group_input::Builder::default()
    }
    /// Creates a new `DescribeGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGroup {
    type Output =
        std::result::Result<crate::output::DescribeGroupOutput, crate::error::DescribeGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_group_error(response)
        } else {
            crate::operation_deser::parse_describe_group_response(response)
        }
    }
}

/// Operation shape for `DescribeInboundDmarcSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_inbound_dmarc_settings`](crate::client::Client::describe_inbound_dmarc_settings).
///
/// See [`crate::client::fluent_builders::DescribeInboundDmarcSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInboundDmarcSettings {
    _private: (),
}
impl DescribeInboundDmarcSettings {
    /// Creates a new builder-style object to manufacture [`DescribeInboundDmarcSettingsInput`](crate::input::DescribeInboundDmarcSettingsInput)
    pub fn builder() -> crate::input::describe_inbound_dmarc_settings_input::Builder {
        crate::input::describe_inbound_dmarc_settings_input::Builder::default()
    }
    /// Creates a new `DescribeInboundDmarcSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInboundDmarcSettings {
    type Output = std::result::Result<
        crate::output::DescribeInboundDmarcSettingsOutput,
        crate::error::DescribeInboundDmarcSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_inbound_dmarc_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_inbound_dmarc_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeMailboxExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_mailbox_export_job`](crate::client::Client::describe_mailbox_export_job).
///
/// See [`crate::client::fluent_builders::DescribeMailboxExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMailboxExportJob {
    _private: (),
}
impl DescribeMailboxExportJob {
    /// Creates a new builder-style object to manufacture [`DescribeMailboxExportJobInput`](crate::input::DescribeMailboxExportJobInput)
    pub fn builder() -> crate::input::describe_mailbox_export_job_input::Builder {
        crate::input::describe_mailbox_export_job_input::Builder::default()
    }
    /// Creates a new `DescribeMailboxExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMailboxExportJob {
    type Output = std::result::Result<
        crate::output::DescribeMailboxExportJobOutput,
        crate::error::DescribeMailboxExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_mailbox_export_job_error(response)
        } else {
            crate::operation_deser::parse_describe_mailbox_export_job_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization`](crate::client::Client::describe_organization).
///
/// See [`crate::client::fluent_builders::DescribeOrganization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganization {
    _private: (),
}
impl DescribeOrganization {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationInput`](crate::input::DescribeOrganizationInput)
    pub fn builder() -> crate::input::describe_organization_input::Builder {
        crate::input::describe_organization_input::Builder::default()
    }
    /// Creates a new `DescribeOrganization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganization {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationOutput,
        crate::error::DescribeOrganizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_error(response)
        } else {
            crate::operation_deser::parse_describe_organization_response(response)
        }
    }
}

/// Operation shape for `DescribeResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_resource`](crate::client::Client::describe_resource).
///
/// See [`crate::client::fluent_builders::DescribeResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeResource {
    _private: (),
}
impl DescribeResource {
    /// Creates a new builder-style object to manufacture [`DescribeResourceInput`](crate::input::DescribeResourceInput)
    pub fn builder() -> crate::input::describe_resource_input::Builder {
        crate::input::describe_resource_input::Builder::default()
    }
    /// Creates a new `DescribeResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeResource {
    type Output = std::result::Result<
        crate::output::DescribeResourceOutput,
        crate::error::DescribeResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_resource_error(response)
        } else {
            crate::operation_deser::parse_describe_resource_response(response)
        }
    }
}

/// Operation shape for `DescribeUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user`](crate::client::Client::describe_user).
///
/// See [`crate::client::fluent_builders::DescribeUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUser {
    _private: (),
}
impl DescribeUser {
    /// Creates a new builder-style object to manufacture [`DescribeUserInput`](crate::input::DescribeUserInput)
    pub fn builder() -> crate::input::describe_user_input::Builder {
        crate::input::describe_user_input::Builder::default()
    }
    /// Creates a new `DescribeUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUser {
    type Output =
        std::result::Result<crate::output::DescribeUserOutput, crate::error::DescribeUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_error(response)
        } else {
            crate::operation_deser::parse_describe_user_response(response)
        }
    }
}

/// Operation shape for `DisassociateDelegateFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_delegate_from_resource`](crate::client::Client::disassociate_delegate_from_resource).
///
/// See [`crate::client::fluent_builders::DisassociateDelegateFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateDelegateFromResource {
    _private: (),
}
impl DisassociateDelegateFromResource {
    /// Creates a new builder-style object to manufacture [`DisassociateDelegateFromResourceInput`](crate::input::DisassociateDelegateFromResourceInput)
    pub fn builder() -> crate::input::disassociate_delegate_from_resource_input::Builder {
        crate::input::disassociate_delegate_from_resource_input::Builder::default()
    }
    /// Creates a new `DisassociateDelegateFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateDelegateFromResource {
    type Output = std::result::Result<
        crate::output::DisassociateDelegateFromResourceOutput,
        crate::error::DisassociateDelegateFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_delegate_from_resource_error(response)
        } else {
            crate::operation_deser::parse_disassociate_delegate_from_resource_response(response)
        }
    }
}

/// Operation shape for `DisassociateMemberFromGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_member_from_group`](crate::client::Client::disassociate_member_from_group).
///
/// See [`crate::client::fluent_builders::DisassociateMemberFromGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateMemberFromGroup {
    _private: (),
}
impl DisassociateMemberFromGroup {
    /// Creates a new builder-style object to manufacture [`DisassociateMemberFromGroupInput`](crate::input::DisassociateMemberFromGroupInput)
    pub fn builder() -> crate::input::disassociate_member_from_group_input::Builder {
        crate::input::disassociate_member_from_group_input::Builder::default()
    }
    /// Creates a new `DisassociateMemberFromGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateMemberFromGroup {
    type Output = std::result::Result<
        crate::output::DisassociateMemberFromGroupOutput,
        crate::error::DisassociateMemberFromGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_member_from_group_error(response)
        } else {
            crate::operation_deser::parse_disassociate_member_from_group_response(response)
        }
    }
}

/// Operation shape for `GetAccessControlEffect`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_access_control_effect`](crate::client::Client::get_access_control_effect).
///
/// See [`crate::client::fluent_builders::GetAccessControlEffect`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccessControlEffect {
    _private: (),
}
impl GetAccessControlEffect {
    /// Creates a new builder-style object to manufacture [`GetAccessControlEffectInput`](crate::input::GetAccessControlEffectInput)
    pub fn builder() -> crate::input::get_access_control_effect_input::Builder {
        crate::input::get_access_control_effect_input::Builder::default()
    }
    /// Creates a new `GetAccessControlEffect` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccessControlEffect {
    type Output = std::result::Result<
        crate::output::GetAccessControlEffectOutput,
        crate::error::GetAccessControlEffectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_access_control_effect_error(response)
        } else {
            crate::operation_deser::parse_get_access_control_effect_response(response)
        }
    }
}

/// Operation shape for `GetDefaultRetentionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_default_retention_policy`](crate::client::Client::get_default_retention_policy).
///
/// See [`crate::client::fluent_builders::GetDefaultRetentionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDefaultRetentionPolicy {
    _private: (),
}
impl GetDefaultRetentionPolicy {
    /// Creates a new builder-style object to manufacture [`GetDefaultRetentionPolicyInput`](crate::input::GetDefaultRetentionPolicyInput)
    pub fn builder() -> crate::input::get_default_retention_policy_input::Builder {
        crate::input::get_default_retention_policy_input::Builder::default()
    }
    /// Creates a new `GetDefaultRetentionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDefaultRetentionPolicy {
    type Output = std::result::Result<
        crate::output::GetDefaultRetentionPolicyOutput,
        crate::error::GetDefaultRetentionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_default_retention_policy_error(response)
        } else {
            crate::operation_deser::parse_get_default_retention_policy_response(response)
        }
    }
}

/// Operation shape for `GetMailboxDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_mailbox_details`](crate::client::Client::get_mailbox_details).
///
/// See [`crate::client::fluent_builders::GetMailboxDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMailboxDetails {
    _private: (),
}
impl GetMailboxDetails {
    /// Creates a new builder-style object to manufacture [`GetMailboxDetailsInput`](crate::input::GetMailboxDetailsInput)
    pub fn builder() -> crate::input::get_mailbox_details_input::Builder {
        crate::input::get_mailbox_details_input::Builder::default()
    }
    /// Creates a new `GetMailboxDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMailboxDetails {
    type Output = std::result::Result<
        crate::output::GetMailboxDetailsOutput,
        crate::error::GetMailboxDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_mailbox_details_error(response)
        } else {
            crate::operation_deser::parse_get_mailbox_details_response(response)
        }
    }
}

/// Operation shape for `GetMailDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_mail_domain`](crate::client::Client::get_mail_domain).
///
/// See [`crate::client::fluent_builders::GetMailDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMailDomain {
    _private: (),
}
impl GetMailDomain {
    /// Creates a new builder-style object to manufacture [`GetMailDomainInput`](crate::input::GetMailDomainInput)
    pub fn builder() -> crate::input::get_mail_domain_input::Builder {
        crate::input::get_mail_domain_input::Builder::default()
    }
    /// Creates a new `GetMailDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMailDomain {
    type Output =
        std::result::Result<crate::output::GetMailDomainOutput, crate::error::GetMailDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_mail_domain_error(response)
        } else {
            crate::operation_deser::parse_get_mail_domain_response(response)
        }
    }
}

/// Operation shape for `GetMobileDeviceAccessEffect`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_mobile_device_access_effect`](crate::client::Client::get_mobile_device_access_effect).
///
/// See [`crate::client::fluent_builders::GetMobileDeviceAccessEffect`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMobileDeviceAccessEffect {
    _private: (),
}
impl GetMobileDeviceAccessEffect {
    /// Creates a new builder-style object to manufacture [`GetMobileDeviceAccessEffectInput`](crate::input::GetMobileDeviceAccessEffectInput)
    pub fn builder() -> crate::input::get_mobile_device_access_effect_input::Builder {
        crate::input::get_mobile_device_access_effect_input::Builder::default()
    }
    /// Creates a new `GetMobileDeviceAccessEffect` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMobileDeviceAccessEffect {
    type Output = std::result::Result<
        crate::output::GetMobileDeviceAccessEffectOutput,
        crate::error::GetMobileDeviceAccessEffectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_mobile_device_access_effect_error(response)
        } else {
            crate::operation_deser::parse_get_mobile_device_access_effect_response(response)
        }
    }
}

/// Operation shape for `GetMobileDeviceAccessOverride`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_mobile_device_access_override`](crate::client::Client::get_mobile_device_access_override).
///
/// See [`crate::client::fluent_builders::GetMobileDeviceAccessOverride`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMobileDeviceAccessOverride {
    _private: (),
}
impl GetMobileDeviceAccessOverride {
    /// Creates a new builder-style object to manufacture [`GetMobileDeviceAccessOverrideInput`](crate::input::GetMobileDeviceAccessOverrideInput)
    pub fn builder() -> crate::input::get_mobile_device_access_override_input::Builder {
        crate::input::get_mobile_device_access_override_input::Builder::default()
    }
    /// Creates a new `GetMobileDeviceAccessOverride` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMobileDeviceAccessOverride {
    type Output = std::result::Result<
        crate::output::GetMobileDeviceAccessOverrideOutput,
        crate::error::GetMobileDeviceAccessOverrideError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_mobile_device_access_override_error(response)
        } else {
            crate::operation_deser::parse_get_mobile_device_access_override_response(response)
        }
    }
}

/// Operation shape for `ListAccessControlRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_access_control_rules`](crate::client::Client::list_access_control_rules).
///
/// See [`crate::client::fluent_builders::ListAccessControlRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccessControlRules {
    _private: (),
}
impl ListAccessControlRules {
    /// Creates a new builder-style object to manufacture [`ListAccessControlRulesInput`](crate::input::ListAccessControlRulesInput)
    pub fn builder() -> crate::input::list_access_control_rules_input::Builder {
        crate::input::list_access_control_rules_input::Builder::default()
    }
    /// Creates a new `ListAccessControlRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccessControlRules {
    type Output = std::result::Result<
        crate::output::ListAccessControlRulesOutput,
        crate::error::ListAccessControlRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_access_control_rules_error(response)
        } else {
            crate::operation_deser::parse_list_access_control_rules_response(response)
        }
    }
}

/// Operation shape for `ListAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_aliases`](crate::client::Client::list_aliases).
///
/// See [`crate::client::fluent_builders::ListAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAliases {
    _private: (),
}
impl ListAliases {
    /// Creates a new builder-style object to manufacture [`ListAliasesInput`](crate::input::ListAliasesInput)
    pub fn builder() -> crate::input::list_aliases_input::Builder {
        crate::input::list_aliases_input::Builder::default()
    }
    /// Creates a new `ListAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAliases {
    type Output =
        std::result::Result<crate::output::ListAliasesOutput, crate::error::ListAliasesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_aliases_error(response)
        } else {
            crate::operation_deser::parse_list_aliases_response(response)
        }
    }
}

/// Operation shape for `ListGroupMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_group_members`](crate::client::Client::list_group_members).
///
/// See [`crate::client::fluent_builders::ListGroupMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGroupMembers {
    _private: (),
}
impl ListGroupMembers {
    /// Creates a new builder-style object to manufacture [`ListGroupMembersInput`](crate::input::ListGroupMembersInput)
    pub fn builder() -> crate::input::list_group_members_input::Builder {
        crate::input::list_group_members_input::Builder::default()
    }
    /// Creates a new `ListGroupMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGroupMembers {
    type Output = std::result::Result<
        crate::output::ListGroupMembersOutput,
        crate::error::ListGroupMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_group_members_error(response)
        } else {
            crate::operation_deser::parse_list_group_members_response(response)
        }
    }
}

/// Operation shape for `ListGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_groups`](crate::client::Client::list_groups).
///
/// See [`crate::client::fluent_builders::ListGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGroups {
    _private: (),
}
impl ListGroups {
    /// Creates a new builder-style object to manufacture [`ListGroupsInput`](crate::input::ListGroupsInput)
    pub fn builder() -> crate::input::list_groups_input::Builder {
        crate::input::list_groups_input::Builder::default()
    }
    /// Creates a new `ListGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGroups {
    type Output =
        std::result::Result<crate::output::ListGroupsOutput, crate::error::ListGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_groups_error(response)
        } else {
            crate::operation_deser::parse_list_groups_response(response)
        }
    }
}

/// Operation shape for `ListMailboxExportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_mailbox_export_jobs`](crate::client::Client::list_mailbox_export_jobs).
///
/// See [`crate::client::fluent_builders::ListMailboxExportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMailboxExportJobs {
    _private: (),
}
impl ListMailboxExportJobs {
    /// Creates a new builder-style object to manufacture [`ListMailboxExportJobsInput`](crate::input::ListMailboxExportJobsInput)
    pub fn builder() -> crate::input::list_mailbox_export_jobs_input::Builder {
        crate::input::list_mailbox_export_jobs_input::Builder::default()
    }
    /// Creates a new `ListMailboxExportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMailboxExportJobs {
    type Output = std::result::Result<
        crate::output::ListMailboxExportJobsOutput,
        crate::error::ListMailboxExportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_mailbox_export_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_mailbox_export_jobs_response(response)
        }
    }
}

/// Operation shape for `ListMailboxPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_mailbox_permissions`](crate::client::Client::list_mailbox_permissions).
///
/// See [`crate::client::fluent_builders::ListMailboxPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMailboxPermissions {
    _private: (),
}
impl ListMailboxPermissions {
    /// Creates a new builder-style object to manufacture [`ListMailboxPermissionsInput`](crate::input::ListMailboxPermissionsInput)
    pub fn builder() -> crate::input::list_mailbox_permissions_input::Builder {
        crate::input::list_mailbox_permissions_input::Builder::default()
    }
    /// Creates a new `ListMailboxPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMailboxPermissions {
    type Output = std::result::Result<
        crate::output::ListMailboxPermissionsOutput,
        crate::error::ListMailboxPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_mailbox_permissions_error(response)
        } else {
            crate::operation_deser::parse_list_mailbox_permissions_response(response)
        }
    }
}

/// Operation shape for `ListMailDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_mail_domains`](crate::client::Client::list_mail_domains).
///
/// See [`crate::client::fluent_builders::ListMailDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMailDomains {
    _private: (),
}
impl ListMailDomains {
    /// Creates a new builder-style object to manufacture [`ListMailDomainsInput`](crate::input::ListMailDomainsInput)
    pub fn builder() -> crate::input::list_mail_domains_input::Builder {
        crate::input::list_mail_domains_input::Builder::default()
    }
    /// Creates a new `ListMailDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMailDomains {
    type Output = std::result::Result<
        crate::output::ListMailDomainsOutput,
        crate::error::ListMailDomainsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_mail_domains_error(response)
        } else {
            crate::operation_deser::parse_list_mail_domains_response(response)
        }
    }
}

/// Operation shape for `ListMobileDeviceAccessOverrides`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_mobile_device_access_overrides`](crate::client::Client::list_mobile_device_access_overrides).
///
/// See [`crate::client::fluent_builders::ListMobileDeviceAccessOverrides`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMobileDeviceAccessOverrides {
    _private: (),
}
impl ListMobileDeviceAccessOverrides {
    /// Creates a new builder-style object to manufacture [`ListMobileDeviceAccessOverridesInput`](crate::input::ListMobileDeviceAccessOverridesInput)
    pub fn builder() -> crate::input::list_mobile_device_access_overrides_input::Builder {
        crate::input::list_mobile_device_access_overrides_input::Builder::default()
    }
    /// Creates a new `ListMobileDeviceAccessOverrides` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMobileDeviceAccessOverrides {
    type Output = std::result::Result<
        crate::output::ListMobileDeviceAccessOverridesOutput,
        crate::error::ListMobileDeviceAccessOverridesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_mobile_device_access_overrides_error(response)
        } else {
            crate::operation_deser::parse_list_mobile_device_access_overrides_response(response)
        }
    }
}

/// Operation shape for `ListMobileDeviceAccessRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_mobile_device_access_rules`](crate::client::Client::list_mobile_device_access_rules).
///
/// See [`crate::client::fluent_builders::ListMobileDeviceAccessRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMobileDeviceAccessRules {
    _private: (),
}
impl ListMobileDeviceAccessRules {
    /// Creates a new builder-style object to manufacture [`ListMobileDeviceAccessRulesInput`](crate::input::ListMobileDeviceAccessRulesInput)
    pub fn builder() -> crate::input::list_mobile_device_access_rules_input::Builder {
        crate::input::list_mobile_device_access_rules_input::Builder::default()
    }
    /// Creates a new `ListMobileDeviceAccessRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMobileDeviceAccessRules {
    type Output = std::result::Result<
        crate::output::ListMobileDeviceAccessRulesOutput,
        crate::error::ListMobileDeviceAccessRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_mobile_device_access_rules_error(response)
        } else {
            crate::operation_deser::parse_list_mobile_device_access_rules_response(response)
        }
    }
}

/// Operation shape for `ListOrganizations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_organizations`](crate::client::Client::list_organizations).
///
/// See [`crate::client::fluent_builders::ListOrganizations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOrganizations {
    _private: (),
}
impl ListOrganizations {
    /// Creates a new builder-style object to manufacture [`ListOrganizationsInput`](crate::input::ListOrganizationsInput)
    pub fn builder() -> crate::input::list_organizations_input::Builder {
        crate::input::list_organizations_input::Builder::default()
    }
    /// Creates a new `ListOrganizations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOrganizations {
    type Output = std::result::Result<
        crate::output::ListOrganizationsOutput,
        crate::error::ListOrganizationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_organizations_error(response)
        } else {
            crate::operation_deser::parse_list_organizations_response(response)
        }
    }
}

/// Operation shape for `ListResourceDelegates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resource_delegates`](crate::client::Client::list_resource_delegates).
///
/// See [`crate::client::fluent_builders::ListResourceDelegates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourceDelegates {
    _private: (),
}
impl ListResourceDelegates {
    /// Creates a new builder-style object to manufacture [`ListResourceDelegatesInput`](crate::input::ListResourceDelegatesInput)
    pub fn builder() -> crate::input::list_resource_delegates_input::Builder {
        crate::input::list_resource_delegates_input::Builder::default()
    }
    /// Creates a new `ListResourceDelegates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourceDelegates {
    type Output = std::result::Result<
        crate::output::ListResourceDelegatesOutput,
        crate::error::ListResourceDelegatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resource_delegates_error(response)
        } else {
            crate::operation_deser::parse_list_resource_delegates_response(response)
        }
    }
}

/// Operation shape for `ListResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resources`](crate::client::Client::list_resources).
///
/// See [`crate::client::fluent_builders::ListResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResources {
    _private: (),
}
impl ListResources {
    /// Creates a new builder-style object to manufacture [`ListResourcesInput`](crate::input::ListResourcesInput)
    pub fn builder() -> crate::input::list_resources_input::Builder {
        crate::input::list_resources_input::Builder::default()
    }
    /// Creates a new `ListResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResources {
    type Output =
        std::result::Result<crate::output::ListResourcesOutput, crate::error::ListResourcesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resources_error(response)
        } else {
            crate::operation_deser::parse_list_resources_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_users`](crate::client::Client::list_users).
///
/// See [`crate::client::fluent_builders::ListUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUsers {
    _private: (),
}
impl ListUsers {
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
    /// Creates a new `ListUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUsers {
    type Output = std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_users_error(response)
        } else {
            crate::operation_deser::parse_list_users_response(response)
        }
    }
}

/// Operation shape for `PutAccessControlRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_access_control_rule`](crate::client::Client::put_access_control_rule).
///
/// See [`crate::client::fluent_builders::PutAccessControlRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAccessControlRule {
    _private: (),
}
impl PutAccessControlRule {
    /// Creates a new builder-style object to manufacture [`PutAccessControlRuleInput`](crate::input::PutAccessControlRuleInput)
    pub fn builder() -> crate::input::put_access_control_rule_input::Builder {
        crate::input::put_access_control_rule_input::Builder::default()
    }
    /// Creates a new `PutAccessControlRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAccessControlRule {
    type Output = std::result::Result<
        crate::output::PutAccessControlRuleOutput,
        crate::error::PutAccessControlRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_access_control_rule_error(response)
        } else {
            crate::operation_deser::parse_put_access_control_rule_response(response)
        }
    }
}

/// Operation shape for `PutInboundDmarcSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_inbound_dmarc_settings`](crate::client::Client::put_inbound_dmarc_settings).
///
/// See [`crate::client::fluent_builders::PutInboundDmarcSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutInboundDmarcSettings {
    _private: (),
}
impl PutInboundDmarcSettings {
    /// Creates a new builder-style object to manufacture [`PutInboundDmarcSettingsInput`](crate::input::PutInboundDmarcSettingsInput)
    pub fn builder() -> crate::input::put_inbound_dmarc_settings_input::Builder {
        crate::input::put_inbound_dmarc_settings_input::Builder::default()
    }
    /// Creates a new `PutInboundDmarcSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutInboundDmarcSettings {
    type Output = std::result::Result<
        crate::output::PutInboundDmarcSettingsOutput,
        crate::error::PutInboundDmarcSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_inbound_dmarc_settings_error(response)
        } else {
            crate::operation_deser::parse_put_inbound_dmarc_settings_response(response)
        }
    }
}

/// Operation shape for `PutMailboxPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_mailbox_permissions`](crate::client::Client::put_mailbox_permissions).
///
/// See [`crate::client::fluent_builders::PutMailboxPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutMailboxPermissions {
    _private: (),
}
impl PutMailboxPermissions {
    /// Creates a new builder-style object to manufacture [`PutMailboxPermissionsInput`](crate::input::PutMailboxPermissionsInput)
    pub fn builder() -> crate::input::put_mailbox_permissions_input::Builder {
        crate::input::put_mailbox_permissions_input::Builder::default()
    }
    /// Creates a new `PutMailboxPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutMailboxPermissions {
    type Output = std::result::Result<
        crate::output::PutMailboxPermissionsOutput,
        crate::error::PutMailboxPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_mailbox_permissions_error(response)
        } else {
            crate::operation_deser::parse_put_mailbox_permissions_response(response)
        }
    }
}

/// Operation shape for `PutMobileDeviceAccessOverride`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_mobile_device_access_override`](crate::client::Client::put_mobile_device_access_override).
///
/// See [`crate::client::fluent_builders::PutMobileDeviceAccessOverride`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutMobileDeviceAccessOverride {
    _private: (),
}
impl PutMobileDeviceAccessOverride {
    /// Creates a new builder-style object to manufacture [`PutMobileDeviceAccessOverrideInput`](crate::input::PutMobileDeviceAccessOverrideInput)
    pub fn builder() -> crate::input::put_mobile_device_access_override_input::Builder {
        crate::input::put_mobile_device_access_override_input::Builder::default()
    }
    /// Creates a new `PutMobileDeviceAccessOverride` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutMobileDeviceAccessOverride {
    type Output = std::result::Result<
        crate::output::PutMobileDeviceAccessOverrideOutput,
        crate::error::PutMobileDeviceAccessOverrideError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_mobile_device_access_override_error(response)
        } else {
            crate::operation_deser::parse_put_mobile_device_access_override_response(response)
        }
    }
}

/// Operation shape for `PutRetentionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_retention_policy`](crate::client::Client::put_retention_policy).
///
/// See [`crate::client::fluent_builders::PutRetentionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRetentionPolicy {
    _private: (),
}
impl PutRetentionPolicy {
    /// Creates a new builder-style object to manufacture [`PutRetentionPolicyInput`](crate::input::PutRetentionPolicyInput)
    pub fn builder() -> crate::input::put_retention_policy_input::Builder {
        crate::input::put_retention_policy_input::Builder::default()
    }
    /// Creates a new `PutRetentionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRetentionPolicy {
    type Output = std::result::Result<
        crate::output::PutRetentionPolicyOutput,
        crate::error::PutRetentionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_retention_policy_error(response)
        } else {
            crate::operation_deser::parse_put_retention_policy_response(response)
        }
    }
}

/// Operation shape for `RegisterMailDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_mail_domain`](crate::client::Client::register_mail_domain).
///
/// See [`crate::client::fluent_builders::RegisterMailDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterMailDomain {
    _private: (),
}
impl RegisterMailDomain {
    /// Creates a new builder-style object to manufacture [`RegisterMailDomainInput`](crate::input::RegisterMailDomainInput)
    pub fn builder() -> crate::input::register_mail_domain_input::Builder {
        crate::input::register_mail_domain_input::Builder::default()
    }
    /// Creates a new `RegisterMailDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterMailDomain {
    type Output = std::result::Result<
        crate::output::RegisterMailDomainOutput,
        crate::error::RegisterMailDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_mail_domain_error(response)
        } else {
            crate::operation_deser::parse_register_mail_domain_response(response)
        }
    }
}

/// Operation shape for `RegisterToWorkMail`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_to_work_mail`](crate::client::Client::register_to_work_mail).
///
/// See [`crate::client::fluent_builders::RegisterToWorkMail`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterToWorkMail {
    _private: (),
}
impl RegisterToWorkMail {
    /// Creates a new builder-style object to manufacture [`RegisterToWorkMailInput`](crate::input::RegisterToWorkMailInput)
    pub fn builder() -> crate::input::register_to_work_mail_input::Builder {
        crate::input::register_to_work_mail_input::Builder::default()
    }
    /// Creates a new `RegisterToWorkMail` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterToWorkMail {
    type Output = std::result::Result<
        crate::output::RegisterToWorkMailOutput,
        crate::error::RegisterToWorkMailError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_to_work_mail_error(response)
        } else {
            crate::operation_deser::parse_register_to_work_mail_response(response)
        }
    }
}

/// Operation shape for `ResetPassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_password`](crate::client::Client::reset_password).
///
/// See [`crate::client::fluent_builders::ResetPassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetPassword {
    _private: (),
}
impl ResetPassword {
    /// Creates a new builder-style object to manufacture [`ResetPasswordInput`](crate::input::ResetPasswordInput)
    pub fn builder() -> crate::input::reset_password_input::Builder {
        crate::input::reset_password_input::Builder::default()
    }
    /// Creates a new `ResetPassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetPassword {
    type Output =
        std::result::Result<crate::output::ResetPasswordOutput, crate::error::ResetPasswordError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_password_error(response)
        } else {
            crate::operation_deser::parse_reset_password_response(response)
        }
    }
}

/// Operation shape for `StartMailboxExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_mailbox_export_job`](crate::client::Client::start_mailbox_export_job).
///
/// See [`crate::client::fluent_builders::StartMailboxExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMailboxExportJob {
    _private: (),
}
impl StartMailboxExportJob {
    /// Creates a new builder-style object to manufacture [`StartMailboxExportJobInput`](crate::input::StartMailboxExportJobInput)
    pub fn builder() -> crate::input::start_mailbox_export_job_input::Builder {
        crate::input::start_mailbox_export_job_input::Builder::default()
    }
    /// Creates a new `StartMailboxExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMailboxExportJob {
    type Output = std::result::Result<
        crate::output::StartMailboxExportJobOutput,
        crate::error::StartMailboxExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_mailbox_export_job_error(response)
        } else {
            crate::operation_deser::parse_start_mailbox_export_job_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDefaultMailDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_default_mail_domain`](crate::client::Client::update_default_mail_domain).
///
/// See [`crate::client::fluent_builders::UpdateDefaultMailDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDefaultMailDomain {
    _private: (),
}
impl UpdateDefaultMailDomain {
    /// Creates a new builder-style object to manufacture [`UpdateDefaultMailDomainInput`](crate::input::UpdateDefaultMailDomainInput)
    pub fn builder() -> crate::input::update_default_mail_domain_input::Builder {
        crate::input::update_default_mail_domain_input::Builder::default()
    }
    /// Creates a new `UpdateDefaultMailDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDefaultMailDomain {
    type Output = std::result::Result<
        crate::output::UpdateDefaultMailDomainOutput,
        crate::error::UpdateDefaultMailDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_default_mail_domain_error(response)
        } else {
            crate::operation_deser::parse_update_default_mail_domain_response(response)
        }
    }
}

/// Operation shape for `UpdateMailboxQuota`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_mailbox_quota`](crate::client::Client::update_mailbox_quota).
///
/// See [`crate::client::fluent_builders::UpdateMailboxQuota`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMailboxQuota {
    _private: (),
}
impl UpdateMailboxQuota {
    /// Creates a new builder-style object to manufacture [`UpdateMailboxQuotaInput`](crate::input::UpdateMailboxQuotaInput)
    pub fn builder() -> crate::input::update_mailbox_quota_input::Builder {
        crate::input::update_mailbox_quota_input::Builder::default()
    }
    /// Creates a new `UpdateMailboxQuota` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMailboxQuota {
    type Output = std::result::Result<
        crate::output::UpdateMailboxQuotaOutput,
        crate::error::UpdateMailboxQuotaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_mailbox_quota_error(response)
        } else {
            crate::operation_deser::parse_update_mailbox_quota_response(response)
        }
    }
}

/// Operation shape for `UpdateMobileDeviceAccessRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_mobile_device_access_rule`](crate::client::Client::update_mobile_device_access_rule).
///
/// See [`crate::client::fluent_builders::UpdateMobileDeviceAccessRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMobileDeviceAccessRule {
    _private: (),
}
impl UpdateMobileDeviceAccessRule {
    /// Creates a new builder-style object to manufacture [`UpdateMobileDeviceAccessRuleInput`](crate::input::UpdateMobileDeviceAccessRuleInput)
    pub fn builder() -> crate::input::update_mobile_device_access_rule_input::Builder {
        crate::input::update_mobile_device_access_rule_input::Builder::default()
    }
    /// Creates a new `UpdateMobileDeviceAccessRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMobileDeviceAccessRule {
    type Output = std::result::Result<
        crate::output::UpdateMobileDeviceAccessRuleOutput,
        crate::error::UpdateMobileDeviceAccessRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_mobile_device_access_rule_error(response)
        } else {
            crate::operation_deser::parse_update_mobile_device_access_rule_response(response)
        }
    }
}

/// Operation shape for `UpdatePrimaryEmailAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_primary_email_address`](crate::client::Client::update_primary_email_address).
///
/// See [`crate::client::fluent_builders::UpdatePrimaryEmailAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePrimaryEmailAddress {
    _private: (),
}
impl UpdatePrimaryEmailAddress {
    /// Creates a new builder-style object to manufacture [`UpdatePrimaryEmailAddressInput`](crate::input::UpdatePrimaryEmailAddressInput)
    pub fn builder() -> crate::input::update_primary_email_address_input::Builder {
        crate::input::update_primary_email_address_input::Builder::default()
    }
    /// Creates a new `UpdatePrimaryEmailAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePrimaryEmailAddress {
    type Output = std::result::Result<
        crate::output::UpdatePrimaryEmailAddressOutput,
        crate::error::UpdatePrimaryEmailAddressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_primary_email_address_error(response)
        } else {
            crate::operation_deser::parse_update_primary_email_address_response(response)
        }
    }
}

/// Operation shape for `UpdateResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resource`](crate::client::Client::update_resource).
///
/// See [`crate::client::fluent_builders::UpdateResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResource {
    _private: (),
}
impl UpdateResource {
    /// Creates a new builder-style object to manufacture [`UpdateResourceInput`](crate::input::UpdateResourceInput)
    pub fn builder() -> crate::input::update_resource_input::Builder {
        crate::input::update_resource_input::Builder::default()
    }
    /// Creates a new `UpdateResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResource {
    type Output =
        std::result::Result<crate::output::UpdateResourceOutput, crate::error::UpdateResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resource_error(response)
        } else {
            crate::operation_deser::parse_update_resource_response(response)
        }
    }
}
