// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The directory is already in use by another WorkMail organization in the same account and Region.</p>
    DirectoryInUseException(crate::error::DirectoryInUseException),
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The email address that you're trying to assign is already created for a different
    /// user, group, or resource.</p>
    EmailAddressInUseException(crate::error::EmailAddressInUseException),
    /// <p>The user, group, or resource that you're trying to register is already
    /// registered.</p>
    EntityAlreadyRegisteredException(crate::error::EntityAlreadyRegisteredException),
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>The configuration for a resource isn't valid. A resource must either be able to
    /// auto-respond to requests or have at least one delegate associated that can do so on its
    /// behalf.</p>
    InvalidConfigurationException(crate::error::InvalidConfigurationException),
    /// <p>You SES configuration has customizations that Amazon WorkMail cannot save. The error message lists the invalid setting. For examples of invalid settings, refer to
    /// <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html">CreateReceiptRule</a>.</p>
    InvalidCustomSesConfigurationException(crate::error::InvalidCustomSesConfigurationException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The supplied password doesn't match the minimum security constraints, such as length
    /// or use of special characters.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>The request exceeds the limit of the resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The domain you're trying to change is in use by another user or organization in your account. See the error message for details.</p>
    MailDomainInUseException(crate::error::MailDomainInUseException),
    /// <p>The domain specified is not found in your organization.</p>
    MailDomainNotFoundException(crate::error::MailDomainNotFoundException),
    /// <p>After a domain has been added to the organization, it must be verified. The domain is
    /// not yet verified.</p>
    MailDomainStateException(crate::error::MailDomainStateException),
    /// <p>The user, group, or resource name isn't unique in Amazon WorkMail.</p>
    NameAvailabilityException(crate::error::NameAvailabilityException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>This user, group, or resource name is not allowed in Amazon WorkMail.</p>
    ReservedNameException(crate::error::ReservedNameException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The resource can have up to 50 user-applied tags.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>You can't perform a write operation against a read-only directory.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::DirectoryInUseException(inner) => inner.fmt(f),
            Error::DirectoryServiceAuthenticationFailedException(inner) => inner.fmt(f),
            Error::DirectoryUnavailableException(inner) => inner.fmt(f),
            Error::EmailAddressInUseException(inner) => inner.fmt(f),
            Error::EntityAlreadyRegisteredException(inner) => inner.fmt(f),
            Error::EntityNotFoundException(inner) => inner.fmt(f),
            Error::EntityStateException(inner) => inner.fmt(f),
            Error::InvalidConfigurationException(inner) => inner.fmt(f),
            Error::InvalidCustomSesConfigurationException(inner) => inner.fmt(f),
            Error::InvalidParameterException(inner) => inner.fmt(f),
            Error::InvalidPasswordException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::MailDomainInUseException(inner) => inner.fmt(f),
            Error::MailDomainNotFoundException(inner) => inner.fmt(f),
            Error::MailDomainStateException(inner) => inner.fmt(f),
            Error::NameAvailabilityException(inner) => inner.fmt(f),
            Error::OrganizationNotFoundException(inner) => inner.fmt(f),
            Error::OrganizationStateException(inner) => inner.fmt(f),
            Error::ReservedNameException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::TooManyTagsException(inner) => inner.fmt(f),
            Error::UnsupportedOperationException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateDelegateToResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateDelegateToResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateDelegateToResourceErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::AssociateDelegateToResourceErrorKind::EntityStateException(inner) => Error::EntityStateException(inner),
                crate::error::AssociateDelegateToResourceErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::AssociateDelegateToResourceErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::AssociateDelegateToResourceErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::AssociateDelegateToResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateMemberToGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateMemberToGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateMemberToGroupErrorKind::DirectoryServiceAuthenticationFailedException(inner) => Error::DirectoryServiceAuthenticationFailedException(inner),
                crate::error::AssociateMemberToGroupErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::AssociateMemberToGroupErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::AssociateMemberToGroupErrorKind::EntityStateException(inner) => Error::EntityStateException(inner),
                crate::error::AssociateMemberToGroupErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::AssociateMemberToGroupErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::AssociateMemberToGroupErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::AssociateMemberToGroupErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::AssociateMemberToGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelMailboxExportJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CancelMailboxExportJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelMailboxExportJobErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::CancelMailboxExportJobErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CancelMailboxExportJobErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::CancelMailboxExportJobErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::CancelMailboxExportJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateAliasError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateAliasErrorKind::EmailAddressInUseException(inner) => {
                    Error::EmailAddressInUseException(inner)
                }
                crate::error::CreateAliasErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::CreateAliasErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::CreateAliasErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateAliasErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateAliasErrorKind::MailDomainNotFoundException(inner) => {
                    Error::MailDomainNotFoundException(inner)
                }
                crate::error::CreateAliasErrorKind::MailDomainStateException(inner) => {
                    Error::MailDomainStateException(inner)
                }
                crate::error::CreateAliasErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::CreateAliasErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::CreateAliasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateGroupErrorKind::DirectoryServiceAuthenticationFailedException(inner) => Error::DirectoryServiceAuthenticationFailedException(inner),
                crate::error::CreateGroupErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::CreateGroupErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateGroupErrorKind::NameAvailabilityException(inner) => Error::NameAvailabilityException(inner),
                crate::error::CreateGroupErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::CreateGroupErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::CreateGroupErrorKind::ReservedNameException(inner) => Error::ReservedNameException(inner),
                crate::error::CreateGroupErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::CreateGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateMobileDeviceAccessRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateMobileDeviceAccessRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateMobileDeviceAccessRuleErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateMobileDeviceAccessRuleErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::CreateMobileDeviceAccessRuleErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::CreateMobileDeviceAccessRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateOrganizationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateOrganizationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateOrganizationErrorKind::DirectoryInUseException(inner) => {
                    Error::DirectoryInUseException(inner)
                }
                crate::error::CreateOrganizationErrorKind::DirectoryUnavailableException(inner) => {
                    Error::DirectoryUnavailableException(inner)
                }
                crate::error::CreateOrganizationErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateOrganizationErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateOrganizationErrorKind::NameAvailabilityException(inner) => {
                    Error::NameAvailabilityException(inner)
                }
                crate::error::CreateOrganizationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateResourceErrorKind::DirectoryServiceAuthenticationFailedException(inner) => Error::DirectoryServiceAuthenticationFailedException(inner),
                crate::error::CreateResourceErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::CreateResourceErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateResourceErrorKind::NameAvailabilityException(inner) => Error::NameAvailabilityException(inner),
                crate::error::CreateResourceErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::CreateResourceErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::CreateResourceErrorKind::ReservedNameException(inner) => Error::ReservedNameException(inner),
                crate::error::CreateResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateUserErrorKind::DirectoryServiceAuthenticationFailedException(inner) => Error::DirectoryServiceAuthenticationFailedException(inner),
                crate::error::CreateUserErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::CreateUserErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateUserErrorKind::InvalidPasswordException(inner) => Error::InvalidPasswordException(inner),
                crate::error::CreateUserErrorKind::NameAvailabilityException(inner) => Error::NameAvailabilityException(inner),
                crate::error::CreateUserErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::CreateUserErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::CreateUserErrorKind::ReservedNameException(inner) => Error::ReservedNameException(inner),
                crate::error::CreateUserErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::CreateUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAccessControlRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAccessControlRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAccessControlRuleErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::DeleteAccessControlRuleErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::DeleteAccessControlRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteAliasError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAliasErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteAliasErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::DeleteAliasErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteAliasErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::DeleteAliasErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::DeleteAliasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteGroupErrorKind::DirectoryServiceAuthenticationFailedException(inner) => Error::DirectoryServiceAuthenticationFailedException(inner),
                crate::error::DeleteGroupErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::DeleteGroupErrorKind::EntityStateException(inner) => Error::EntityStateException(inner),
                crate::error::DeleteGroupErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteGroupErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::DeleteGroupErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::DeleteGroupErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::DeleteGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteMailboxPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteMailboxPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteMailboxPermissionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteMailboxPermissionsErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::DeleteMailboxPermissionsErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DeleteMailboxPermissionsErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::DeleteMailboxPermissionsErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::DeleteMailboxPermissionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteMobileDeviceAccessOverrideError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteMobileDeviceAccessOverrideError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::DeleteMobileDeviceAccessOverrideErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::DeleteMobileDeviceAccessOverrideErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::DeleteMobileDeviceAccessOverrideErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteMobileDeviceAccessRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteMobileDeviceAccessRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteMobileDeviceAccessRuleErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::DeleteMobileDeviceAccessRuleErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::DeleteMobileDeviceAccessRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteOrganizationErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteOrganizationErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::DeleteOrganizationErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::DeleteOrganizationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteResourceErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::DeleteResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteResourceErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::DeleteResourceErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::DeleteResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteRetentionPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteRetentionPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteRetentionPolicyErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteRetentionPolicyErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::DeleteRetentionPolicyErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::DeleteRetentionPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteUserErrorKind::DirectoryServiceAuthenticationFailedException(inner) => Error::DirectoryServiceAuthenticationFailedException(inner),
                crate::error::DeleteUserErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::DeleteUserErrorKind::EntityStateException(inner) => Error::EntityStateException(inner),
                crate::error::DeleteUserErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteUserErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::DeleteUserErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::DeleteUserErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::DeleteUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterFromWorkMailError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterFromWorkMailError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeregisterFromWorkMailErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeregisterFromWorkMailErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::DeregisterFromWorkMailErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeregisterFromWorkMailErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::DeregisterFromWorkMailErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::DeregisterFromWorkMailErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterMailDomainError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterMailDomainError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeregisterMailDomainErrorKind::InvalidCustomSesConfigurationException(inner) => Error::InvalidCustomSesConfigurationException(inner),
                crate::error::DeregisterMailDomainErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeregisterMailDomainErrorKind::MailDomainInUseException(inner) => Error::MailDomainInUseException(inner),
                crate::error::DeregisterMailDomainErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::DeregisterMailDomainErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::DeregisterMailDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeGroupErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DescribeGroupErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeGroupErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::DescribeGroupErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::DescribeGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeInboundDmarcSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeInboundDmarcSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeInboundDmarcSettingsErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::DescribeInboundDmarcSettingsErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::DescribeInboundDmarcSettingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeMailboxExportJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeMailboxExportJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeMailboxExportJobErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DescribeMailboxExportJobErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DescribeMailboxExportJobErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::DescribeMailboxExportJobErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::DescribeMailboxExportJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeOrganizationErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeOrganizationErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::DescribeOrganizationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeResourceErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DescribeResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeResourceErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::DescribeResourceErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::DescribeResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeUserErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DescribeUserErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeUserErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::DescribeUserErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::DescribeUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DisassociateDelegateFromResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DisassociateDelegateFromResourceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateDelegateFromResourceErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::DisassociateDelegateFromResourceErrorKind::EntityStateException(inner) => Error::EntityStateException(inner),
                crate::error::DisassociateDelegateFromResourceErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DisassociateDelegateFromResourceErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::DisassociateDelegateFromResourceErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::DisassociateDelegateFromResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateMemberFromGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateMemberFromGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateMemberFromGroupErrorKind::DirectoryServiceAuthenticationFailedException(inner) => Error::DirectoryServiceAuthenticationFailedException(inner),
                crate::error::DisassociateMemberFromGroupErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::DisassociateMemberFromGroupErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::DisassociateMemberFromGroupErrorKind::EntityStateException(inner) => Error::EntityStateException(inner),
                crate::error::DisassociateMemberFromGroupErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DisassociateMemberFromGroupErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::DisassociateMemberFromGroupErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::DisassociateMemberFromGroupErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::DisassociateMemberFromGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAccessControlEffectError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetAccessControlEffectError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetAccessControlEffectErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetAccessControlEffectErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetAccessControlEffectErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::GetAccessControlEffectErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::GetAccessControlEffectErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDefaultRetentionPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDefaultRetentionPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDefaultRetentionPolicyErrorKind::EntityNotFoundException(
                    inner,
                ) => Error::EntityNotFoundException(inner),
                crate::error::GetDefaultRetentionPolicyErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::GetDefaultRetentionPolicyErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::GetDefaultRetentionPolicyErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::GetDefaultRetentionPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMailboxDetailsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetMailboxDetailsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMailboxDetailsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetMailboxDetailsErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::GetMailboxDetailsErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::GetMailboxDetailsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMailDomainError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetMailDomainError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMailDomainErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetMailDomainErrorKind::MailDomainNotFoundException(inner) => {
                    Error::MailDomainNotFoundException(inner)
                }
                crate::error::GetMailDomainErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::GetMailDomainErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::GetMailDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMobileDeviceAccessEffectError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetMobileDeviceAccessEffectError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetMobileDeviceAccessEffectErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetMobileDeviceAccessEffectErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::GetMobileDeviceAccessEffectErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::GetMobileDeviceAccessEffectErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMobileDeviceAccessOverrideError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetMobileDeviceAccessOverrideError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::GetMobileDeviceAccessOverrideErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::GetMobileDeviceAccessOverrideErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::GetMobileDeviceAccessOverrideErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetMobileDeviceAccessOverrideErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAccessControlRulesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListAccessControlRulesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAccessControlRulesErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::ListAccessControlRulesErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::ListAccessControlRulesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAliasesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListAliasesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAliasesErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListAliasesErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::ListAliasesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListAliasesErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::ListAliasesErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::ListAliasesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListGroupMembersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListGroupMembersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListGroupMembersErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListGroupMembersErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::ListGroupMembersErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListGroupMembersErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::ListGroupMembersErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::ListGroupMembersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListGroupsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListGroupsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListGroupsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListGroupsErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::ListGroupsErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::ListGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListMailboxExportJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListMailboxExportJobsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListMailboxExportJobsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListMailboxExportJobsErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::ListMailboxExportJobsErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::ListMailboxExportJobsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListMailboxPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListMailboxPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListMailboxPermissionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListMailboxPermissionsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListMailboxPermissionsErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::ListMailboxPermissionsErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::ListMailboxPermissionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListMailDomainsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListMailDomainsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListMailDomainsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListMailDomainsErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::ListMailDomainsErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::ListMailDomainsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListMobileDeviceAccessOverridesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListMobileDeviceAccessOverridesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListMobileDeviceAccessOverridesErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::ListMobileDeviceAccessOverridesErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListMobileDeviceAccessOverridesErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::ListMobileDeviceAccessOverridesErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::ListMobileDeviceAccessOverridesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListMobileDeviceAccessRulesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListMobileDeviceAccessRulesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListMobileDeviceAccessRulesErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListMobileDeviceAccessRulesErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::ListMobileDeviceAccessRulesErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::ListMobileDeviceAccessRulesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListOrganizationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListOrganizationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListOrganizationsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListOrganizationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResourceDelegatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResourceDelegatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResourceDelegatesErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListResourceDelegatesErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::ListResourceDelegatesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListResourceDelegatesErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::ListResourceDelegatesErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::ListResourceDelegatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResourcesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListResourcesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResourcesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListResourcesErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::ListResourcesErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::ListResourcesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListUsersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListUsersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListUsersErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListUsersErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::ListUsersErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::ListUsersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutAccessControlRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutAccessControlRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutAccessControlRuleErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::PutAccessControlRuleErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::PutAccessControlRuleErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::PutAccessControlRuleErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::PutAccessControlRuleErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::PutAccessControlRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutInboundDmarcSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutInboundDmarcSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutInboundDmarcSettingsErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::PutInboundDmarcSettingsErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::PutInboundDmarcSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutMailboxPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutMailboxPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutMailboxPermissionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::PutMailboxPermissionsErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::PutMailboxPermissionsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::PutMailboxPermissionsErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::PutMailboxPermissionsErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::PutMailboxPermissionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutMobileDeviceAccessOverrideError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutMobileDeviceAccessOverrideError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::PutMobileDeviceAccessOverrideErrorKind::EntityStateException(inner) => Error::EntityStateException(inner),
                crate::error::PutMobileDeviceAccessOverrideErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::PutMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::PutMobileDeviceAccessOverrideErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::PutMobileDeviceAccessOverrideErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutRetentionPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutRetentionPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutRetentionPolicyErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::PutRetentionPolicyErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::PutRetentionPolicyErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::PutRetentionPolicyErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::PutRetentionPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterMailDomainError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterMailDomainError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterMailDomainErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::RegisterMailDomainErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::RegisterMailDomainErrorKind::MailDomainInUseException(inner) => {
                    Error::MailDomainInUseException(inner)
                }
                crate::error::RegisterMailDomainErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::RegisterMailDomainErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::RegisterMailDomainErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterToWorkMailError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterToWorkMailError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterToWorkMailErrorKind::DirectoryServiceAuthenticationFailedException(inner) => Error::DirectoryServiceAuthenticationFailedException(inner),
                crate::error::RegisterToWorkMailErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::RegisterToWorkMailErrorKind::EmailAddressInUseException(inner) => Error::EmailAddressInUseException(inner),
                crate::error::RegisterToWorkMailErrorKind::EntityAlreadyRegisteredException(inner) => Error::EntityAlreadyRegisteredException(inner),
                crate::error::RegisterToWorkMailErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::RegisterToWorkMailErrorKind::EntityStateException(inner) => Error::EntityStateException(inner),
                crate::error::RegisterToWorkMailErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::RegisterToWorkMailErrorKind::MailDomainNotFoundException(inner) => Error::MailDomainNotFoundException(inner),
                crate::error::RegisterToWorkMailErrorKind::MailDomainStateException(inner) => Error::MailDomainStateException(inner),
                crate::error::RegisterToWorkMailErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::RegisterToWorkMailErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::RegisterToWorkMailErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetPasswordError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ResetPasswordError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ResetPasswordErrorKind::DirectoryServiceAuthenticationFailedException(inner) => Error::DirectoryServiceAuthenticationFailedException(inner),
                crate::error::ResetPasswordErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::ResetPasswordErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::ResetPasswordErrorKind::EntityStateException(inner) => Error::EntityStateException(inner),
                crate::error::ResetPasswordErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ResetPasswordErrorKind::InvalidPasswordException(inner) => Error::InvalidPasswordException(inner),
                crate::error::ResetPasswordErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::ResetPasswordErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::ResetPasswordErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::ResetPasswordErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartMailboxExportJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartMailboxExportJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartMailboxExportJobErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StartMailboxExportJobErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StartMailboxExportJobErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::StartMailboxExportJobErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::StartMailboxExportJobErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::StartMailboxExportJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDefaultMailDomainError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDefaultMailDomainError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDefaultMailDomainErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::UpdateDefaultMailDomainErrorKind::MailDomainNotFoundException(
                    inner,
                ) => Error::MailDomainNotFoundException(inner),
                crate::error::UpdateDefaultMailDomainErrorKind::MailDomainStateException(inner) => {
                    Error::MailDomainStateException(inner)
                }
                crate::error::UpdateDefaultMailDomainErrorKind::OrganizationNotFoundException(
                    inner,
                ) => Error::OrganizationNotFoundException(inner),
                crate::error::UpdateDefaultMailDomainErrorKind::OrganizationStateException(
                    inner,
                ) => Error::OrganizationStateException(inner),
                crate::error::UpdateDefaultMailDomainErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateMailboxQuotaError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateMailboxQuotaError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateMailboxQuotaErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateMailboxQuotaErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::UpdateMailboxQuotaErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateMailboxQuotaErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::UpdateMailboxQuotaErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::UpdateMailboxQuotaErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateMobileDeviceAccessRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateMobileDeviceAccessRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateMobileDeviceAccessRuleErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::UpdateMobileDeviceAccessRuleErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::UpdateMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::UpdateMobileDeviceAccessRuleErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::UpdateMobileDeviceAccessRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePrimaryEmailAddressError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdatePrimaryEmailAddressError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdatePrimaryEmailAddressErrorKind::DirectoryServiceAuthenticationFailedException(inner) => Error::DirectoryServiceAuthenticationFailedException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::DirectoryUnavailableException(inner) => Error::DirectoryUnavailableException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::EmailAddressInUseException(inner) => Error::EmailAddressInUseException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::EntityStateException(inner) => Error::EntityStateException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::MailDomainNotFoundException(inner) => Error::MailDomainNotFoundException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::MailDomainStateException(inner) => Error::MailDomainStateException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::OrganizationNotFoundException(inner) => Error::OrganizationNotFoundException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::OrganizationStateException(inner) => Error::OrganizationStateException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::UpdatePrimaryEmailAddressErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateResourceErrorKind::DirectoryUnavailableException(inner) => {
                    Error::DirectoryUnavailableException(inner)
                }
                crate::error::UpdateResourceErrorKind::EmailAddressInUseException(inner) => {
                    Error::EmailAddressInUseException(inner)
                }
                crate::error::UpdateResourceErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateResourceErrorKind::EntityStateException(inner) => {
                    Error::EntityStateException(inner)
                }
                crate::error::UpdateResourceErrorKind::InvalidConfigurationException(inner) => {
                    Error::InvalidConfigurationException(inner)
                }
                crate::error::UpdateResourceErrorKind::MailDomainNotFoundException(inner) => {
                    Error::MailDomainNotFoundException(inner)
                }
                crate::error::UpdateResourceErrorKind::MailDomainStateException(inner) => {
                    Error::MailDomainStateException(inner)
                }
                crate::error::UpdateResourceErrorKind::NameAvailabilityException(inner) => {
                    Error::NameAvailabilityException(inner)
                }
                crate::error::UpdateResourceErrorKind::OrganizationNotFoundException(inner) => {
                    Error::OrganizationNotFoundException(inner)
                }
                crate::error::UpdateResourceErrorKind::OrganizationStateException(inner) => {
                    Error::OrganizationStateException(inner)
                }
                crate::error::UpdateResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
