// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateDelegateToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateDelegateToResourceError {
    /// Kind of error that occurred.
    pub kind: AssociateDelegateToResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateDelegateToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateDelegateToResourceErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateDelegateToResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateDelegateToResourceErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            AssociateDelegateToResourceErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            AssociateDelegateToResourceErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AssociateDelegateToResourceErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateDelegateToResourceErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            AssociateDelegateToResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateDelegateToResourceError {
    fn code(&self) -> Option<&str> {
        AssociateDelegateToResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateDelegateToResourceError {
    /// Creates a new `AssociateDelegateToResourceError`.
    pub fn new(kind: AssociateDelegateToResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateDelegateToResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateDelegateToResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateDelegateToResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateDelegateToResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateDelegateToResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDelegateToResourceErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDelegateToResourceErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDelegateToResourceErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDelegateToResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDelegateToResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDelegateToResourceErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDelegateToResourceErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDelegateToResourceErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDelegateToResourceErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for AssociateDelegateToResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateDelegateToResourceErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            AssociateDelegateToResourceErrorKind::EntityStateException(_inner) => Some(_inner),
            AssociateDelegateToResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateDelegateToResourceErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateDelegateToResourceErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            AssociateDelegateToResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateMemberToGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateMemberToGroupError {
    /// Kind of error that occurred.
    pub kind: AssociateMemberToGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateMemberToGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateMemberToGroupErrorKind {
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>You can't perform a write operation against a read-only directory.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateMemberToGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateMemberToGroupErrorKind::DirectoryServiceAuthenticationFailedException(
                _inner,
            ) => _inner.fmt(f),
            AssociateMemberToGroupErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            AssociateMemberToGroupErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            AssociateMemberToGroupErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            AssociateMemberToGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateMemberToGroupErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            AssociateMemberToGroupErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            AssociateMemberToGroupErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            AssociateMemberToGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateMemberToGroupError {
    fn code(&self) -> Option<&str> {
        AssociateMemberToGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateMemberToGroupError {
    /// Creates a new `AssociateMemberToGroupError`.
    pub fn new(kind: AssociateMemberToGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateMemberToGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateMemberToGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateMemberToGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateMemberToGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateMemberToGroupErrorKind::DirectoryServiceAuthenticationFailedException`.
    pub fn is_directory_service_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMemberToGroupErrorKind::DirectoryServiceAuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMemberToGroupErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMemberToGroupErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMemberToGroupErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMemberToGroupErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMemberToGroupErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMemberToGroupErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMemberToGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMemberToGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMemberToGroupErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMemberToGroupErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMemberToGroupErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMemberToGroupErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMemberToGroupErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMemberToGroupErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for AssociateMemberToGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateMemberToGroupErrorKind::DirectoryServiceAuthenticationFailedException(
                _inner,
            ) => Some(_inner),
            AssociateMemberToGroupErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            AssociateMemberToGroupErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            AssociateMemberToGroupErrorKind::EntityStateException(_inner) => Some(_inner),
            AssociateMemberToGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateMemberToGroupErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            AssociateMemberToGroupErrorKind::OrganizationStateException(_inner) => Some(_inner),
            AssociateMemberToGroupErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            AssociateMemberToGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelMailboxExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelMailboxExportJobError {
    /// Kind of error that occurred.
    pub kind: CancelMailboxExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelMailboxExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelMailboxExportJobErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelMailboxExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelMailboxExportJobErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            CancelMailboxExportJobErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CancelMailboxExportJobErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            CancelMailboxExportJobErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            CancelMailboxExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelMailboxExportJobError {
    fn code(&self) -> Option<&str> {
        CancelMailboxExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelMailboxExportJobError {
    /// Creates a new `CancelMailboxExportJobError`.
    pub fn new(kind: CancelMailboxExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelMailboxExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelMailboxExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelMailboxExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelMailboxExportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelMailboxExportJobErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMailboxExportJobErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMailboxExportJobErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMailboxExportJobErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMailboxExportJobErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMailboxExportJobErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMailboxExportJobErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMailboxExportJobErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for CancelMailboxExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelMailboxExportJobErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            CancelMailboxExportJobErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CancelMailboxExportJobErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            CancelMailboxExportJobErrorKind::OrganizationStateException(_inner) => Some(_inner),
            CancelMailboxExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAliasError {
    /// Kind of error that occurred.
    pub kind: CreateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAliasErrorKind {
    /// <p>The email address that you're trying to assign is already created for a different
    /// user, group, or resource.</p>
    EmailAddressInUseException(crate::error::EmailAddressInUseException),
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request exceeds the limit of the resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The domain specified is not found in your organization.</p>
    MailDomainNotFoundException(crate::error::MailDomainNotFoundException),
    /// <p>After a domain has been added to the organization, it must be verified. The domain is
    /// not yet verified.</p>
    MailDomainStateException(crate::error::MailDomainStateException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAliasErrorKind::EmailAddressInUseException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::MailDomainNotFoundException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::MailDomainStateException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAliasError {
    fn code(&self) -> Option<&str> {
        CreateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAliasError {
    /// Creates a new `CreateAliasError`.
    pub fn new(kind: CreateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::EmailAddressInUseException`.
    pub fn is_email_address_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::EmailAddressInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::EntityStateException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::MailDomainNotFoundException`.
    pub fn is_mail_domain_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::MailDomainNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::MailDomainStateException`.
    pub fn is_mail_domain_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::MailDomainStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for CreateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAliasErrorKind::EmailAddressInUseException(_inner) => Some(_inner),
            CreateAliasErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            CreateAliasErrorKind::EntityStateException(_inner) => Some(_inner),
            CreateAliasErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAliasErrorKind::MailDomainNotFoundException(_inner) => Some(_inner),
            CreateAliasErrorKind::MailDomainStateException(_inner) => Some(_inner),
            CreateAliasErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            CreateAliasErrorKind::OrganizationStateException(_inner) => Some(_inner),
            CreateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGroupError {
    /// Kind of error that occurred.
    pub kind: CreateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGroupErrorKind {
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The user, group, or resource name isn't unique in Amazon WorkMail.</p>
    NameAvailabilityException(crate::error::NameAvailabilityException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>This user, group, or resource name is not allowed in Amazon WorkMail.</p>
    ReservedNameException(crate::error::ReservedNameException),
    /// <p>You can't perform a write operation against a read-only directory.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGroupErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreateGroupErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::NameAvailabilityException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::ReservedNameException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGroupError {
    fn code(&self) -> Option<&str> {
        CreateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGroupError {
    /// Creates a new `CreateGroupError`.
    pub fn new(kind: CreateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::DirectoryServiceAuthenticationFailedException`.
    pub fn is_directory_service_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::DirectoryServiceAuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::NameAvailabilityException`.
    pub fn is_name_availability_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::NameAvailabilityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::ReservedNameException`.
    pub fn is_reserved_name_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::ReservedNameException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CreateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGroupErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                Some(_inner)
            }
            CreateGroupErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            CreateGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateGroupErrorKind::NameAvailabilityException(_inner) => Some(_inner),
            CreateGroupErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            CreateGroupErrorKind::OrganizationStateException(_inner) => Some(_inner),
            CreateGroupErrorKind::ReservedNameException(_inner) => Some(_inner),
            CreateGroupErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            CreateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMobileDeviceAccessRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMobileDeviceAccessRuleError {
    /// Kind of error that occurred.
    pub kind: CreateMobileDeviceAccessRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMobileDeviceAccessRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMobileDeviceAccessRuleErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request exceeds the limit of the resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMobileDeviceAccessRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMobileDeviceAccessRuleErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            CreateMobileDeviceAccessRuleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateMobileDeviceAccessRuleErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            CreateMobileDeviceAccessRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMobileDeviceAccessRuleError {
    fn code(&self) -> Option<&str> {
        CreateMobileDeviceAccessRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMobileDeviceAccessRuleError {
    /// Creates a new `CreateMobileDeviceAccessRuleError`.
    pub fn new(kind: CreateMobileDeviceAccessRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMobileDeviceAccessRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMobileDeviceAccessRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMobileDeviceAccessRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMobileDeviceAccessRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMobileDeviceAccessRuleErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMobileDeviceAccessRuleErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMobileDeviceAccessRuleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMobileDeviceAccessRuleErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMobileDeviceAccessRuleErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMobileDeviceAccessRuleErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for CreateMobileDeviceAccessRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMobileDeviceAccessRuleErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            CreateMobileDeviceAccessRuleErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateMobileDeviceAccessRuleErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            CreateMobileDeviceAccessRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOrganizationError {
    /// Kind of error that occurred.
    pub kind: CreateOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOrganizationErrorKind {
    /// <p>The directory is already in use by another WorkMail organization in the same account and Region.</p>
    DirectoryInUseException(crate::error::DirectoryInUseException),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request exceeds the limit of the resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The user, group, or resource name isn't unique in Amazon WorkMail.</p>
    NameAvailabilityException(crate::error::NameAvailabilityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOrganizationErrorKind::DirectoryInUseException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::NameAvailabilityException(_inner) => _inner.fmt(f),
            CreateOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOrganizationError {
    fn code(&self) -> Option<&str> {
        CreateOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOrganizationError {
    /// Creates a new `CreateOrganizationError`.
    pub fn new(kind: CreateOrganizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::DirectoryInUseException`.
    pub fn is_directory_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::DirectoryInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrganizationErrorKind::NameAvailabilityException`.
    pub fn is_name_availability_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrganizationErrorKind::NameAvailabilityException(_)
        )
    }
}
impl std::error::Error for CreateOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOrganizationErrorKind::DirectoryInUseException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::NameAvailabilityException(_inner) => Some(_inner),
            CreateOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResourceError {
    /// Kind of error that occurred.
    pub kind: CreateResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResourceErrorKind {
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The user, group, or resource name isn't unique in Amazon WorkMail.</p>
    NameAvailabilityException(crate::error::NameAvailabilityException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>This user, group, or resource name is not allowed in Amazon WorkMail.</p>
    ReservedNameException(crate::error::ReservedNameException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResourceErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreateResourceErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::NameAvailabilityException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::ReservedNameException(_inner) => _inner.fmt(f),
            CreateResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResourceError {
    fn code(&self) -> Option<&str> {
        CreateResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResourceError {
    /// Creates a new `CreateResourceError`.
    pub fn new(kind: CreateResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::DirectoryServiceAuthenticationFailedException`.
    pub fn is_directory_service_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::DirectoryServiceAuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::NameAvailabilityException`.
    pub fn is_name_availability_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::NameAvailabilityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceErrorKind::ReservedNameException`.
    pub fn is_reserved_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceErrorKind::ReservedNameException(_)
        )
    }
}
impl std::error::Error for CreateResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResourceErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                Some(_inner)
            }
            CreateResourceErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            CreateResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateResourceErrorKind::NameAvailabilityException(_inner) => Some(_inner),
            CreateResourceErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            CreateResourceErrorKind::OrganizationStateException(_inner) => Some(_inner),
            CreateResourceErrorKind::ReservedNameException(_inner) => Some(_inner),
            CreateResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserError {
    /// Kind of error that occurred.
    pub kind: CreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserErrorKind {
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The supplied password doesn't match the minimum security constraints, such as length
    /// or use of special characters.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>The user, group, or resource name isn't unique in Amazon WorkMail.</p>
    NameAvailabilityException(crate::error::NameAvailabilityException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>This user, group, or resource name is not allowed in Amazon WorkMail.</p>
    ReservedNameException(crate::error::ReservedNameException),
    /// <p>You can't perform a write operation against a read-only directory.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreateUserErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::NameAvailabilityException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ReservedNameException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserError {
    fn code(&self) -> Option<&str> {
        CreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserError {
    /// Creates a new `CreateUserError`.
    pub fn new(kind: CreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::DirectoryServiceAuthenticationFailedException`.
    pub fn is_directory_service_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::DirectoryServiceAuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::InvalidPasswordException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::NameAvailabilityException`.
    pub fn is_name_availability_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::NameAvailabilityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ReservedNameException`.
    pub fn is_reserved_name_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ReservedNameException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                Some(_inner)
            }
            CreateUserErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            CreateUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateUserErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            CreateUserErrorKind::NameAvailabilityException(_inner) => Some(_inner),
            CreateUserErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            CreateUserErrorKind::OrganizationStateException(_inner) => Some(_inner),
            CreateUserErrorKind::ReservedNameException(_inner) => Some(_inner),
            CreateUserErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            CreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccessControlRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccessControlRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteAccessControlRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccessControlRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccessControlRuleErrorKind {
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccessControlRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccessControlRuleErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAccessControlRuleErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DeleteAccessControlRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccessControlRuleError {
    fn code(&self) -> Option<&str> {
        DeleteAccessControlRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccessControlRuleError {
    /// Creates a new `DeleteAccessControlRuleError`.
    pub fn new(kind: DeleteAccessControlRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccessControlRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccessControlRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccessControlRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccessControlRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccessControlRuleErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessControlRuleErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccessControlRuleErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessControlRuleErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DeleteAccessControlRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccessControlRuleErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DeleteAccessControlRuleErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DeleteAccessControlRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAliasErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAliasErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAliasError {
    fn code(&self) -> Option<&str> {
        DeleteAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAliasError {
    /// Creates a new `DeleteAliasError`.
    pub fn new(kind: DeleteAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAliasErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(&self.kind, DeleteAliasErrorKind::EntityStateException(_))
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAliasErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAliasErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAliasErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DeleteAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAliasErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteAliasErrorKind::EntityStateException(_inner) => Some(_inner),
            DeleteAliasErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteAliasErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DeleteAliasErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DeleteAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGroupErrorKind {
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>You can't perform a write operation against a read-only directory.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGroupErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteGroupErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGroupError {
    fn code(&self) -> Option<&str> {
        DeleteGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGroupError {
    /// Creates a new `DeleteGroupError`.
    pub fn new(kind: DeleteGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::DirectoryServiceAuthenticationFailedException`.
    pub fn is_directory_service_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::DirectoryServiceAuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::EntityStateException(_))
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGroupErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                Some(_inner)
            }
            DeleteGroupErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            DeleteGroupErrorKind::EntityStateException(_inner) => Some(_inner),
            DeleteGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteGroupErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DeleteGroupErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DeleteGroupErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DeleteGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMailboxPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMailboxPermissionsError {
    /// Kind of error that occurred.
    pub kind: DeleteMailboxPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMailboxPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMailboxPermissionsErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMailboxPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMailboxPermissionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteMailboxPermissionsErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            DeleteMailboxPermissionsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteMailboxPermissionsErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMailboxPermissionsErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DeleteMailboxPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMailboxPermissionsError {
    fn code(&self) -> Option<&str> {
        DeleteMailboxPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMailboxPermissionsError {
    /// Creates a new `DeleteMailboxPermissionsError`.
    pub fn new(kind: DeleteMailboxPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMailboxPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMailboxPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMailboxPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMailboxPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMailboxPermissionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMailboxPermissionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMailboxPermissionsErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMailboxPermissionsErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMailboxPermissionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMailboxPermissionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMailboxPermissionsErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMailboxPermissionsErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMailboxPermissionsErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMailboxPermissionsErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DeleteMailboxPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMailboxPermissionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteMailboxPermissionsErrorKind::EntityStateException(_inner) => Some(_inner),
            DeleteMailboxPermissionsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteMailboxPermissionsErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteMailboxPermissionsErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DeleteMailboxPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMobileDeviceAccessOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMobileDeviceAccessOverrideError {
    /// Kind of error that occurred.
    pub kind: DeleteMobileDeviceAccessOverrideErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMobileDeviceAccessOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMobileDeviceAccessOverrideErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMobileDeviceAccessOverrideError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMobileDeviceAccessOverrideErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMobileDeviceAccessOverrideErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMobileDeviceAccessOverrideErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMobileDeviceAccessOverrideError {
    fn code(&self) -> Option<&str> {
        DeleteMobileDeviceAccessOverrideError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMobileDeviceAccessOverrideError {
    /// Creates a new `DeleteMobileDeviceAccessOverrideError`.
    pub fn new(
        kind: DeleteMobileDeviceAccessOverrideErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMobileDeviceAccessOverrideError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMobileDeviceAccessOverrideErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMobileDeviceAccessOverrideError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMobileDeviceAccessOverrideErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMobileDeviceAccessOverrideErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMobileDeviceAccessOverrideErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMobileDeviceAccessOverrideErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMobileDeviceAccessOverrideErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMobileDeviceAccessOverrideErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DeleteMobileDeviceAccessOverrideError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteMobileDeviceAccessOverrideErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DeleteMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteMobileDeviceAccessOverrideErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            DeleteMobileDeviceAccessOverrideErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMobileDeviceAccessRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMobileDeviceAccessRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteMobileDeviceAccessRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMobileDeviceAccessRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMobileDeviceAccessRuleErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMobileDeviceAccessRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMobileDeviceAccessRuleErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMobileDeviceAccessRuleErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMobileDeviceAccessRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMobileDeviceAccessRuleError {
    fn code(&self) -> Option<&str> {
        DeleteMobileDeviceAccessRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMobileDeviceAccessRuleError {
    /// Creates a new `DeleteMobileDeviceAccessRuleError`.
    pub fn new(kind: DeleteMobileDeviceAccessRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMobileDeviceAccessRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMobileDeviceAccessRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMobileDeviceAccessRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMobileDeviceAccessRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMobileDeviceAccessRuleErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMobileDeviceAccessRuleErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMobileDeviceAccessRuleErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMobileDeviceAccessRuleErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DeleteMobileDeviceAccessRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMobileDeviceAccessRuleErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DeleteMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteMobileDeviceAccessRuleErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            DeleteMobileDeviceAccessRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOrganizationError {
    /// Kind of error that occurred.
    pub kind: DeleteOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOrganizationErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOrganizationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteOrganizationErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DeleteOrganizationErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DeleteOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOrganizationError {
    fn code(&self) -> Option<&str> {
        DeleteOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOrganizationError {
    /// Creates a new `DeleteOrganizationError`.
    pub fn new(kind: DeleteOrganizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOrganizationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DeleteOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOrganizationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteOrganizationErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DeleteOrganizationErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DeleteOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourceError {
    /// Kind of error that occurred.
    pub kind: DeleteResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourceErrorKind {
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourceErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DeleteResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourceError {
    fn code(&self) -> Option<&str> {
        DeleteResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourceError {
    /// Creates a new `DeleteResourceError`.
    pub fn new(kind: DeleteResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(&self.kind, DeleteResourceErrorKind::EntityStateException(_))
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DeleteResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourceErrorKind::EntityStateException(_inner) => Some(_inner),
            DeleteResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteResourceErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DeleteResourceErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DeleteResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRetentionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRetentionPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteRetentionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRetentionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRetentionPolicyErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRetentionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRetentionPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteRetentionPolicyErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DeleteRetentionPolicyErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DeleteRetentionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRetentionPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteRetentionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRetentionPolicyError {
    /// Creates a new `DeleteRetentionPolicyError`.
    pub fn new(kind: DeleteRetentionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRetentionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRetentionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRetentionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRetentionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRetentionPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRetentionPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRetentionPolicyErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRetentionPolicyErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRetentionPolicyErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRetentionPolicyErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DeleteRetentionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRetentionPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteRetentionPolicyErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DeleteRetentionPolicyErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DeleteRetentionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserError {
    /// Kind of error that occurred.
    pub kind: DeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserErrorKind {
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>You can't perform a write operation against a read-only directory.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteUserErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserError {
    fn code(&self) -> Option<&str> {
        DeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserError {
    /// Creates a new `DeleteUserError`.
    pub fn new(kind: DeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::DirectoryServiceAuthenticationFailedException`.
    pub fn is_directory_service_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::DirectoryServiceAuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::EntityStateException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                Some(_inner)
            }
            DeleteUserErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            DeleteUserErrorKind::EntityStateException(_inner) => Some(_inner),
            DeleteUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteUserErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DeleteUserErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DeleteUserErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterFromWorkMail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterFromWorkMailError {
    /// Kind of error that occurred.
    pub kind: DeregisterFromWorkMailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterFromWorkMail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterFromWorkMailErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterFromWorkMailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterFromWorkMailErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeregisterFromWorkMailErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            DeregisterFromWorkMailErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeregisterFromWorkMailErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DeregisterFromWorkMailErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DeregisterFromWorkMailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterFromWorkMailError {
    fn code(&self) -> Option<&str> {
        DeregisterFromWorkMailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterFromWorkMailError {
    /// Creates a new `DeregisterFromWorkMailError`.
    pub fn new(kind: DeregisterFromWorkMailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterFromWorkMailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterFromWorkMailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterFromWorkMailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterFromWorkMailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterFromWorkMailErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterFromWorkMailErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterFromWorkMailErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterFromWorkMailErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterFromWorkMailErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterFromWorkMailErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterFromWorkMailErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterFromWorkMailErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterFromWorkMailErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterFromWorkMailErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DeregisterFromWorkMailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterFromWorkMailErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeregisterFromWorkMailErrorKind::EntityStateException(_inner) => Some(_inner),
            DeregisterFromWorkMailErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeregisterFromWorkMailErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DeregisterFromWorkMailErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DeregisterFromWorkMailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterMailDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterMailDomainError {
    /// Kind of error that occurred.
    pub kind: DeregisterMailDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterMailDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterMailDomainErrorKind {
    /// <p>You SES configuration has customizations that Amazon WorkMail cannot save. The error message lists the invalid setting. For examples of invalid settings, refer to
    /// <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html">CreateReceiptRule</a>.</p>
    InvalidCustomSesConfigurationException(crate::error::InvalidCustomSesConfigurationException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The domain you're trying to change is in use by another user or organization in your account. See the error message for details.</p>
    MailDomainInUseException(crate::error::MailDomainInUseException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterMailDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterMailDomainErrorKind::InvalidCustomSesConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterMailDomainErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeregisterMailDomainErrorKind::MailDomainInUseException(_inner) => _inner.fmt(f),
            DeregisterMailDomainErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DeregisterMailDomainErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DeregisterMailDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterMailDomainError {
    fn code(&self) -> Option<&str> {
        DeregisterMailDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterMailDomainError {
    /// Creates a new `DeregisterMailDomainError`.
    pub fn new(kind: DeregisterMailDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterMailDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterMailDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterMailDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterMailDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterMailDomainErrorKind::InvalidCustomSesConfigurationException`.
    pub fn is_invalid_custom_ses_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterMailDomainErrorKind::InvalidCustomSesConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterMailDomainErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterMailDomainErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterMailDomainErrorKind::MailDomainInUseException`.
    pub fn is_mail_domain_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterMailDomainErrorKind::MailDomainInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterMailDomainErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterMailDomainErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterMailDomainErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterMailDomainErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DeregisterMailDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterMailDomainErrorKind::InvalidCustomSesConfigurationException(_inner) => {
                Some(_inner)
            }
            DeregisterMailDomainErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeregisterMailDomainErrorKind::MailDomainInUseException(_inner) => Some(_inner),
            DeregisterMailDomainErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DeregisterMailDomainErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DeregisterMailDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGroupErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGroupErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGroupError {
    fn code(&self) -> Option<&str> {
        DescribeGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGroupError {
    /// Creates a new `DescribeGroupError`.
    pub fn new(kind: DescribeGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGroupErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGroupErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGroupErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DescribeGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGroupErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DescribeGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeGroupErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DescribeGroupErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DescribeGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInboundDmarcSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInboundDmarcSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeInboundDmarcSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInboundDmarcSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInboundDmarcSettingsErrorKind {
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInboundDmarcSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInboundDmarcSettingsErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInboundDmarcSettingsErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInboundDmarcSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInboundDmarcSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeInboundDmarcSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInboundDmarcSettingsError {
    /// Creates a new `DescribeInboundDmarcSettingsError`.
    pub fn new(kind: DescribeInboundDmarcSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInboundDmarcSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInboundDmarcSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInboundDmarcSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInboundDmarcSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInboundDmarcSettingsErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInboundDmarcSettingsErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInboundDmarcSettingsErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInboundDmarcSettingsErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DescribeInboundDmarcSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInboundDmarcSettingsErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeInboundDmarcSettingsErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            DescribeInboundDmarcSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMailboxExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMailboxExportJobError {
    /// Kind of error that occurred.
    pub kind: DescribeMailboxExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMailboxExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMailboxExportJobErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMailboxExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMailboxExportJobErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DescribeMailboxExportJobErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeMailboxExportJobErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMailboxExportJobErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DescribeMailboxExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMailboxExportJobError {
    fn code(&self) -> Option<&str> {
        DescribeMailboxExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMailboxExportJobError {
    /// Creates a new `DescribeMailboxExportJobError`.
    pub fn new(kind: DescribeMailboxExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMailboxExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMailboxExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMailboxExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMailboxExportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMailboxExportJobErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMailboxExportJobErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMailboxExportJobErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMailboxExportJobErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMailboxExportJobErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMailboxExportJobErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMailboxExportJobErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMailboxExportJobErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DescribeMailboxExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMailboxExportJobErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DescribeMailboxExportJobErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeMailboxExportJobErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeMailboxExportJobErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DescribeMailboxExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrganizationError {
    /// Kind of error that occurred.
    pub kind: DescribeOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrganizationErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrganizationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeOrganizationErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DescribeOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrganizationError {
    fn code(&self) -> Option<&str> {
        DescribeOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrganizationError {
    /// Creates a new `DescribeOrganizationError`.
    pub fn new(kind: DescribeOrganizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOrganizationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationErrorKind::OrganizationNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrganizationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeOrganizationErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DescribeOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeResourceError {
    /// Kind of error that occurred.
    pub kind: DescribeResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeResourceErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeResourceErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DescribeResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeResourceErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DescribeResourceErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DescribeResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeResourceError {
    fn code(&self) -> Option<&str> {
        DescribeResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeResourceError {
    /// Creates a new `DescribeResourceError`.
    pub fn new(kind: DescribeResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DescribeResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeResourceErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DescribeResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeResourceErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DescribeResourceErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DescribeResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserError {
    /// Kind of error that occurred.
    pub kind: DescribeUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserError {
    fn code(&self) -> Option<&str> {
        DescribeUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserError {
    /// Creates a new `DescribeUserError`.
    pub fn new(kind: DescribeUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DescribeUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DescribeUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeUserErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            DescribeUserErrorKind::OrganizationStateException(_inner) => Some(_inner),
            DescribeUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateDelegateFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateDelegateFromResourceError {
    /// Kind of error that occurred.
    pub kind: DisassociateDelegateFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateDelegateFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateDelegateFromResourceErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateDelegateFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateDelegateFromResourceErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDelegateFromResourceErrorKind::EntityStateException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDelegateFromResourceErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDelegateFromResourceErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDelegateFromResourceErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDelegateFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateDelegateFromResourceError {
    fn code(&self) -> Option<&str> {
        DisassociateDelegateFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateDelegateFromResourceError {
    /// Creates a new `DisassociateDelegateFromResourceError`.
    pub fn new(
        kind: DisassociateDelegateFromResourceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateDelegateFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateDelegateFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateDelegateFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateDelegateFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateDelegateFromResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDelegateFromResourceErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDelegateFromResourceErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDelegateFromResourceErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDelegateFromResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDelegateFromResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDelegateFromResourceErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDelegateFromResourceErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDelegateFromResourceErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDelegateFromResourceErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for DisassociateDelegateFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateDelegateFromResourceErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateDelegateFromResourceErrorKind::EntityStateException(_inner) => Some(_inner),
            DisassociateDelegateFromResourceErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DisassociateDelegateFromResourceErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateDelegateFromResourceErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            DisassociateDelegateFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateMemberFromGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateMemberFromGroupError {
    /// Kind of error that occurred.
    pub kind: DisassociateMemberFromGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateMemberFromGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateMemberFromGroupErrorKind {
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>You can't perform a write operation against a read-only directory.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateMemberFromGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateMemberFromGroupErrorKind::DirectoryServiceAuthenticationFailedException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateMemberFromGroupErrorKind::DirectoryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateMemberFromGroupErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DisassociateMemberFromGroupErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            DisassociateMemberFromGroupErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateMemberFromGroupErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateMemberFromGroupErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateMemberFromGroupErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateMemberFromGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateMemberFromGroupError {
    fn code(&self) -> Option<&str> {
        DisassociateMemberFromGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateMemberFromGroupError {
    /// Creates a new `DisassociateMemberFromGroupError`.
    pub fn new(kind: DisassociateMemberFromGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateMemberFromGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateMemberFromGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateMemberFromGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateMemberFromGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateMemberFromGroupErrorKind::DirectoryServiceAuthenticationFailedException`.
    pub fn is_directory_service_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberFromGroupErrorKind::DirectoryServiceAuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberFromGroupErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberFromGroupErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberFromGroupErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberFromGroupErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberFromGroupErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberFromGroupErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberFromGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberFromGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberFromGroupErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberFromGroupErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberFromGroupErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberFromGroupErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberFromGroupErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberFromGroupErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DisassociateMemberFromGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateMemberFromGroupErrorKind::DirectoryServiceAuthenticationFailedException(
                _inner,
            ) => Some(_inner),
            DisassociateMemberFromGroupErrorKind::DirectoryUnavailableException(_inner) => {
                Some(_inner)
            }
            DisassociateMemberFromGroupErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DisassociateMemberFromGroupErrorKind::EntityStateException(_inner) => Some(_inner),
            DisassociateMemberFromGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisassociateMemberFromGroupErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateMemberFromGroupErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            DisassociateMemberFromGroupErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            DisassociateMemberFromGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccessControlEffect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccessControlEffectError {
    /// Kind of error that occurred.
    pub kind: GetAccessControlEffectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccessControlEffect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccessControlEffectErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccessControlEffectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccessControlEffectErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetAccessControlEffectErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetAccessControlEffectErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            GetAccessControlEffectErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            GetAccessControlEffectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccessControlEffectError {
    fn code(&self) -> Option<&str> {
        GetAccessControlEffectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccessControlEffectError {
    /// Creates a new `GetAccessControlEffectError`.
    pub fn new(kind: GetAccessControlEffectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccessControlEffectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccessControlEffectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccessControlEffectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccessControlEffectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccessControlEffectErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccessControlEffectErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccessControlEffectErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccessControlEffectErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccessControlEffectErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccessControlEffectErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccessControlEffectErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccessControlEffectErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for GetAccessControlEffectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccessControlEffectErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetAccessControlEffectErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetAccessControlEffectErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            GetAccessControlEffectErrorKind::OrganizationStateException(_inner) => Some(_inner),
            GetAccessControlEffectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDefaultRetentionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDefaultRetentionPolicyError {
    /// Kind of error that occurred.
    pub kind: GetDefaultRetentionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDefaultRetentionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDefaultRetentionPolicyErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDefaultRetentionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDefaultRetentionPolicyErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetDefaultRetentionPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetDefaultRetentionPolicyErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetDefaultRetentionPolicyErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            GetDefaultRetentionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDefaultRetentionPolicyError {
    fn code(&self) -> Option<&str> {
        GetDefaultRetentionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDefaultRetentionPolicyError {
    /// Creates a new `GetDefaultRetentionPolicyError`.
    pub fn new(kind: GetDefaultRetentionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDefaultRetentionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDefaultRetentionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDefaultRetentionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDefaultRetentionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDefaultRetentionPolicyErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDefaultRetentionPolicyErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDefaultRetentionPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDefaultRetentionPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDefaultRetentionPolicyErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDefaultRetentionPolicyErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDefaultRetentionPolicyErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDefaultRetentionPolicyErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for GetDefaultRetentionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDefaultRetentionPolicyErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetDefaultRetentionPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetDefaultRetentionPolicyErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            GetDefaultRetentionPolicyErrorKind::OrganizationStateException(_inner) => Some(_inner),
            GetDefaultRetentionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMailboxDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMailboxDetailsError {
    /// Kind of error that occurred.
    pub kind: GetMailboxDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMailboxDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMailboxDetailsErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMailboxDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMailboxDetailsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetMailboxDetailsErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            GetMailboxDetailsErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            GetMailboxDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMailboxDetailsError {
    fn code(&self) -> Option<&str> {
        GetMailboxDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMailboxDetailsError {
    /// Creates a new `GetMailboxDetailsError`.
    pub fn new(kind: GetMailboxDetailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMailboxDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMailboxDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMailboxDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMailboxDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMailboxDetailsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMailboxDetailsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMailboxDetailsErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMailboxDetailsErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMailboxDetailsErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMailboxDetailsErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for GetMailboxDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMailboxDetailsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetMailboxDetailsErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            GetMailboxDetailsErrorKind::OrganizationStateException(_inner) => Some(_inner),
            GetMailboxDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMailDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMailDomainError {
    /// Kind of error that occurred.
    pub kind: GetMailDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMailDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMailDomainErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The domain specified is not found in your organization.</p>
    MailDomainNotFoundException(crate::error::MailDomainNotFoundException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMailDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMailDomainErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetMailDomainErrorKind::MailDomainNotFoundException(_inner) => _inner.fmt(f),
            GetMailDomainErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            GetMailDomainErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            GetMailDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMailDomainError {
    fn code(&self) -> Option<&str> {
        GetMailDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMailDomainError {
    /// Creates a new `GetMailDomainError`.
    pub fn new(kind: GetMailDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMailDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMailDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMailDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMailDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMailDomainErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMailDomainErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMailDomainErrorKind::MailDomainNotFoundException`.
    pub fn is_mail_domain_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMailDomainErrorKind::MailDomainNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMailDomainErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMailDomainErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMailDomainErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMailDomainErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for GetMailDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMailDomainErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetMailDomainErrorKind::MailDomainNotFoundException(_inner) => Some(_inner),
            GetMailDomainErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            GetMailDomainErrorKind::OrganizationStateException(_inner) => Some(_inner),
            GetMailDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMobileDeviceAccessEffect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMobileDeviceAccessEffectError {
    /// Kind of error that occurred.
    pub kind: GetMobileDeviceAccessEffectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMobileDeviceAccessEffect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMobileDeviceAccessEffectErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMobileDeviceAccessEffectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMobileDeviceAccessEffectErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetMobileDeviceAccessEffectErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetMobileDeviceAccessEffectErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            GetMobileDeviceAccessEffectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMobileDeviceAccessEffectError {
    fn code(&self) -> Option<&str> {
        GetMobileDeviceAccessEffectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMobileDeviceAccessEffectError {
    /// Creates a new `GetMobileDeviceAccessEffectError`.
    pub fn new(kind: GetMobileDeviceAccessEffectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMobileDeviceAccessEffectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMobileDeviceAccessEffectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMobileDeviceAccessEffectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMobileDeviceAccessEffectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMobileDeviceAccessEffectErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileDeviceAccessEffectErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMobileDeviceAccessEffectErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileDeviceAccessEffectErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMobileDeviceAccessEffectErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileDeviceAccessEffectErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for GetMobileDeviceAccessEffectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMobileDeviceAccessEffectErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetMobileDeviceAccessEffectErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            GetMobileDeviceAccessEffectErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            GetMobileDeviceAccessEffectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMobileDeviceAccessOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMobileDeviceAccessOverrideError {
    /// Kind of error that occurred.
    pub kind: GetMobileDeviceAccessOverrideErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMobileDeviceAccessOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMobileDeviceAccessOverrideErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMobileDeviceAccessOverrideError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetMobileDeviceAccessOverrideErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetMobileDeviceAccessOverrideErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            GetMobileDeviceAccessOverrideErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetMobileDeviceAccessOverrideErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMobileDeviceAccessOverrideError {
    fn code(&self) -> Option<&str> {
        GetMobileDeviceAccessOverrideError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMobileDeviceAccessOverrideError {
    /// Creates a new `GetMobileDeviceAccessOverrideError`.
    pub fn new(
        kind: GetMobileDeviceAccessOverrideErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMobileDeviceAccessOverrideError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMobileDeviceAccessOverrideErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMobileDeviceAccessOverrideError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMobileDeviceAccessOverrideErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMobileDeviceAccessOverrideErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMobileDeviceAccessOverrideErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileDeviceAccessOverrideErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMobileDeviceAccessOverrideErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileDeviceAccessOverrideErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMobileDeviceAccessOverrideErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileDeviceAccessOverrideErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetMobileDeviceAccessOverrideError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetMobileDeviceAccessOverrideErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            GetMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            GetMobileDeviceAccessOverrideErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            GetMobileDeviceAccessOverrideErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetMobileDeviceAccessOverrideErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccessControlRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccessControlRulesError {
    /// Kind of error that occurred.
    pub kind: ListAccessControlRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccessControlRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccessControlRulesErrorKind {
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccessControlRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccessControlRulesErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ListAccessControlRulesErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ListAccessControlRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccessControlRulesError {
    fn code(&self) -> Option<&str> {
        ListAccessControlRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccessControlRulesError {
    /// Creates a new `ListAccessControlRulesError`.
    pub fn new(kind: ListAccessControlRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccessControlRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccessControlRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccessControlRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccessControlRulesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccessControlRulesErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessControlRulesErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccessControlRulesErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessControlRulesErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListAccessControlRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccessControlRulesErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ListAccessControlRulesErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ListAccessControlRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAliasesError {
    /// Kind of error that occurred.
    pub kind: ListAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAliasesErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAliasesErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAliasesError {
    fn code(&self) -> Option<&str> {
        ListAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAliasesError {
    /// Creates a new `ListAliasesError`.
    pub fn new(kind: ListAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAliasesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListAliasesErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(&self.kind, ListAliasesErrorKind::EntityStateException(_))
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAliasesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAliasesErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAliasesErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAliasesErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListAliasesErrorKind::EntityStateException(_inner) => Some(_inner),
            ListAliasesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListAliasesErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ListAliasesErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ListAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroupMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupMembersError {
    /// Kind of error that occurred.
    pub kind: ListGroupMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroupMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupMembersErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupMembersErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListGroupMembersErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            ListGroupMembersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListGroupMembersErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ListGroupMembersErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ListGroupMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupMembersError {
    fn code(&self) -> Option<&str> {
        ListGroupMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupMembersError {
    /// Creates a new `ListGroupMembersError`.
    pub fn new(kind: ListGroupMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGroupMembersErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembersErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembersErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembersErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembersErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembersErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembersErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembersErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListGroupMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupMembersErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListGroupMembersErrorKind::EntityStateException(_inner) => Some(_inner),
            ListGroupMembersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListGroupMembersErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ListGroupMembersErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ListGroupMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupsError {
    /// Kind of error that occurred.
    pub kind: ListGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupsErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupsError {
    fn code(&self) -> Option<&str> {
        ListGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupsError {
    /// Creates a new `ListGroupsError`.
    pub fn new(kind: ListGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListGroupsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListGroupsErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ListGroupsErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ListGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMailboxExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMailboxExportJobsError {
    /// Kind of error that occurred.
    pub kind: ListMailboxExportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMailboxExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMailboxExportJobsErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMailboxExportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMailboxExportJobsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListMailboxExportJobsErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ListMailboxExportJobsErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ListMailboxExportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMailboxExportJobsError {
    fn code(&self) -> Option<&str> {
        ListMailboxExportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMailboxExportJobsError {
    /// Creates a new `ListMailboxExportJobsError`.
    pub fn new(kind: ListMailboxExportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMailboxExportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMailboxExportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMailboxExportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMailboxExportJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMailboxExportJobsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMailboxExportJobsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMailboxExportJobsErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMailboxExportJobsErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMailboxExportJobsErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMailboxExportJobsErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListMailboxExportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMailboxExportJobsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListMailboxExportJobsErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ListMailboxExportJobsErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ListMailboxExportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMailboxPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMailboxPermissionsError {
    /// Kind of error that occurred.
    pub kind: ListMailboxPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMailboxPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMailboxPermissionsErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMailboxPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMailboxPermissionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListMailboxPermissionsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListMailboxPermissionsErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ListMailboxPermissionsErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ListMailboxPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMailboxPermissionsError {
    fn code(&self) -> Option<&str> {
        ListMailboxPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMailboxPermissionsError {
    /// Creates a new `ListMailboxPermissionsError`.
    pub fn new(kind: ListMailboxPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMailboxPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMailboxPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMailboxPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMailboxPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMailboxPermissionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMailboxPermissionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMailboxPermissionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMailboxPermissionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMailboxPermissionsErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMailboxPermissionsErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMailboxPermissionsErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMailboxPermissionsErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListMailboxPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMailboxPermissionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListMailboxPermissionsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListMailboxPermissionsErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ListMailboxPermissionsErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ListMailboxPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMailDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMailDomainsError {
    /// Kind of error that occurred.
    pub kind: ListMailDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMailDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMailDomainsErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMailDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMailDomainsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListMailDomainsErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ListMailDomainsErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ListMailDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMailDomainsError {
    fn code(&self) -> Option<&str> {
        ListMailDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMailDomainsError {
    /// Creates a new `ListMailDomainsError`.
    pub fn new(kind: ListMailDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMailDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMailDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMailDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMailDomainsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMailDomainsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMailDomainsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMailDomainsErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMailDomainsErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMailDomainsErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMailDomainsErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListMailDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMailDomainsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListMailDomainsErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ListMailDomainsErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ListMailDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMobileDeviceAccessOverrides` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMobileDeviceAccessOverridesError {
    /// Kind of error that occurred.
    pub kind: ListMobileDeviceAccessOverridesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMobileDeviceAccessOverrides` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMobileDeviceAccessOverridesErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMobileDeviceAccessOverridesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMobileDeviceAccessOverridesErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListMobileDeviceAccessOverridesErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListMobileDeviceAccessOverridesErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListMobileDeviceAccessOverridesErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            ListMobileDeviceAccessOverridesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMobileDeviceAccessOverridesError {
    fn code(&self) -> Option<&str> {
        ListMobileDeviceAccessOverridesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMobileDeviceAccessOverridesError {
    /// Creates a new `ListMobileDeviceAccessOverridesError`.
    pub fn new(
        kind: ListMobileDeviceAccessOverridesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMobileDeviceAccessOverridesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMobileDeviceAccessOverridesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMobileDeviceAccessOverridesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMobileDeviceAccessOverridesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMobileDeviceAccessOverridesErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMobileDeviceAccessOverridesErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMobileDeviceAccessOverridesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMobileDeviceAccessOverridesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMobileDeviceAccessOverridesErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMobileDeviceAccessOverridesErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMobileDeviceAccessOverridesErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMobileDeviceAccessOverridesErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListMobileDeviceAccessOverridesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMobileDeviceAccessOverridesErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            ListMobileDeviceAccessOverridesErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            ListMobileDeviceAccessOverridesErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            ListMobileDeviceAccessOverridesErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            ListMobileDeviceAccessOverridesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMobileDeviceAccessRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMobileDeviceAccessRulesError {
    /// Kind of error that occurred.
    pub kind: ListMobileDeviceAccessRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMobileDeviceAccessRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMobileDeviceAccessRulesErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMobileDeviceAccessRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMobileDeviceAccessRulesErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListMobileDeviceAccessRulesErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListMobileDeviceAccessRulesErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            ListMobileDeviceAccessRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMobileDeviceAccessRulesError {
    fn code(&self) -> Option<&str> {
        ListMobileDeviceAccessRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMobileDeviceAccessRulesError {
    /// Creates a new `ListMobileDeviceAccessRulesError`.
    pub fn new(kind: ListMobileDeviceAccessRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMobileDeviceAccessRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMobileDeviceAccessRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMobileDeviceAccessRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMobileDeviceAccessRulesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMobileDeviceAccessRulesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMobileDeviceAccessRulesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMobileDeviceAccessRulesErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMobileDeviceAccessRulesErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMobileDeviceAccessRulesErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMobileDeviceAccessRulesErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListMobileDeviceAccessRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMobileDeviceAccessRulesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListMobileDeviceAccessRulesErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            ListMobileDeviceAccessRulesErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            ListMobileDeviceAccessRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOrganizations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOrganizationsError {
    /// Kind of error that occurred.
    pub kind: ListOrganizationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOrganizations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOrganizationsErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOrganizationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOrganizationsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListOrganizationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOrganizationsError {
    fn code(&self) -> Option<&str> {
        ListOrganizationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOrganizationsError {
    /// Creates a new `ListOrganizationsError`.
    pub fn new(kind: ListOrganizationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOrganizationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOrganizationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOrganizationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOrganizationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOrganizationsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationsErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListOrganizationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOrganizationsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListOrganizationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceDelegates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceDelegatesError {
    /// Kind of error that occurred.
    pub kind: ListResourceDelegatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceDelegates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceDelegatesErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceDelegatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceDelegatesErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListResourceDelegatesErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            ListResourceDelegatesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListResourceDelegatesErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ListResourceDelegatesErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ListResourceDelegatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceDelegatesError {
    fn code(&self) -> Option<&str> {
        ListResourceDelegatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceDelegatesError {
    /// Creates a new `ListResourceDelegatesError`.
    pub fn new(kind: ListResourceDelegatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceDelegatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceDelegatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceDelegatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceDelegatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourceDelegatesErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceDelegatesErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceDelegatesErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceDelegatesErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceDelegatesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceDelegatesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceDelegatesErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceDelegatesErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceDelegatesErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceDelegatesErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListResourceDelegatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceDelegatesErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListResourceDelegatesErrorKind::EntityStateException(_inner) => Some(_inner),
            ListResourceDelegatesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListResourceDelegatesErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ListResourceDelegatesErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ListResourceDelegatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourcesError {
    /// Kind of error that occurred.
    pub kind: ListResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourcesErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourcesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourcesError {
    fn code(&self) -> Option<&str> {
        ListResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourcesError {
    /// Creates a new `ListResourcesError`.
    pub fn new(kind: ListResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourcesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListResourcesErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ListResourcesErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ListResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsersError {
    /// Kind of error that occurred.
    pub kind: ListUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsersErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsersError {
    fn code(&self) -> Option<&str> {
        ListUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsersError {
    /// Creates a new `ListUsersError`.
    pub fn new(kind: ListUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for ListUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListUsersErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ListUsersErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ListUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAccessControlRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAccessControlRuleError {
    /// Kind of error that occurred.
    pub kind: PutAccessControlRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAccessControlRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAccessControlRuleErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request exceeds the limit of the resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAccessControlRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAccessControlRuleErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            PutAccessControlRuleErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutAccessControlRuleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutAccessControlRuleErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            PutAccessControlRuleErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            PutAccessControlRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAccessControlRuleError {
    fn code(&self) -> Option<&str> {
        PutAccessControlRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAccessControlRuleError {
    /// Creates a new `PutAccessControlRuleError`.
    pub fn new(kind: PutAccessControlRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAccessControlRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAccessControlRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAccessControlRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAccessControlRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAccessControlRuleErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccessControlRuleErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAccessControlRuleErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccessControlRuleErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAccessControlRuleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccessControlRuleErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAccessControlRuleErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccessControlRuleErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAccessControlRuleErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccessControlRuleErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for PutAccessControlRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAccessControlRuleErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            PutAccessControlRuleErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutAccessControlRuleErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutAccessControlRuleErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            PutAccessControlRuleErrorKind::OrganizationStateException(_inner) => Some(_inner),
            PutAccessControlRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutInboundDmarcSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutInboundDmarcSettingsError {
    /// Kind of error that occurred.
    pub kind: PutInboundDmarcSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutInboundDmarcSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutInboundDmarcSettingsErrorKind {
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutInboundDmarcSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutInboundDmarcSettingsErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutInboundDmarcSettingsErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            PutInboundDmarcSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutInboundDmarcSettingsError {
    fn code(&self) -> Option<&str> {
        PutInboundDmarcSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutInboundDmarcSettingsError {
    /// Creates a new `PutInboundDmarcSettingsError`.
    pub fn new(kind: PutInboundDmarcSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutInboundDmarcSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutInboundDmarcSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutInboundDmarcSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutInboundDmarcSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutInboundDmarcSettingsErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInboundDmarcSettingsErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInboundDmarcSettingsErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInboundDmarcSettingsErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for PutInboundDmarcSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutInboundDmarcSettingsErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            PutInboundDmarcSettingsErrorKind::OrganizationStateException(_inner) => Some(_inner),
            PutInboundDmarcSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutMailboxPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutMailboxPermissionsError {
    /// Kind of error that occurred.
    pub kind: PutMailboxPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutMailboxPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutMailboxPermissionsErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutMailboxPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutMailboxPermissionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            PutMailboxPermissionsErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            PutMailboxPermissionsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutMailboxPermissionsErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            PutMailboxPermissionsErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            PutMailboxPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutMailboxPermissionsError {
    fn code(&self) -> Option<&str> {
        PutMailboxPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutMailboxPermissionsError {
    /// Creates a new `PutMailboxPermissionsError`.
    pub fn new(kind: PutMailboxPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutMailboxPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutMailboxPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutMailboxPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutMailboxPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutMailboxPermissionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMailboxPermissionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMailboxPermissionsErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMailboxPermissionsErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMailboxPermissionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMailboxPermissionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMailboxPermissionsErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMailboxPermissionsErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMailboxPermissionsErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMailboxPermissionsErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for PutMailboxPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutMailboxPermissionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            PutMailboxPermissionsErrorKind::EntityStateException(_inner) => Some(_inner),
            PutMailboxPermissionsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutMailboxPermissionsErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            PutMailboxPermissionsErrorKind::OrganizationStateException(_inner) => Some(_inner),
            PutMailboxPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutMobileDeviceAccessOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutMobileDeviceAccessOverrideError {
    /// Kind of error that occurred.
    pub kind: PutMobileDeviceAccessOverrideErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutMobileDeviceAccessOverride` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutMobileDeviceAccessOverrideErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutMobileDeviceAccessOverrideError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutMobileDeviceAccessOverrideErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            PutMobileDeviceAccessOverrideErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutMobileDeviceAccessOverrideErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            PutMobileDeviceAccessOverrideErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutMobileDeviceAccessOverrideError {
    fn code(&self) -> Option<&str> {
        PutMobileDeviceAccessOverrideError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutMobileDeviceAccessOverrideError {
    /// Creates a new `PutMobileDeviceAccessOverrideError`.
    pub fn new(
        kind: PutMobileDeviceAccessOverrideErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutMobileDeviceAccessOverrideError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutMobileDeviceAccessOverrideErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutMobileDeviceAccessOverrideError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutMobileDeviceAccessOverrideErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutMobileDeviceAccessOverrideErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMobileDeviceAccessOverrideErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMobileDeviceAccessOverrideErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMobileDeviceAccessOverrideErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMobileDeviceAccessOverrideErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMobileDeviceAccessOverrideErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMobileDeviceAccessOverrideErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for PutMobileDeviceAccessOverrideError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutMobileDeviceAccessOverrideErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            PutMobileDeviceAccessOverrideErrorKind::EntityStateException(_inner) => Some(_inner),
            PutMobileDeviceAccessOverrideErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            PutMobileDeviceAccessOverrideErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            PutMobileDeviceAccessOverrideErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            PutMobileDeviceAccessOverrideErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRetentionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRetentionPolicyError {
    /// Kind of error that occurred.
    pub kind: PutRetentionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRetentionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRetentionPolicyErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request exceeds the limit of the resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRetentionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRetentionPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutRetentionPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutRetentionPolicyErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            PutRetentionPolicyErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            PutRetentionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRetentionPolicyError {
    fn code(&self) -> Option<&str> {
        PutRetentionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRetentionPolicyError {
    /// Creates a new `PutRetentionPolicyError`.
    pub fn new(kind: PutRetentionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRetentionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRetentionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRetentionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRetentionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRetentionPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRetentionPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRetentionPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRetentionPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRetentionPolicyErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRetentionPolicyErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRetentionPolicyErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRetentionPolicyErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for PutRetentionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRetentionPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutRetentionPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutRetentionPolicyErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            PutRetentionPolicyErrorKind::OrganizationStateException(_inner) => Some(_inner),
            PutRetentionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterMailDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterMailDomainError {
    /// Kind of error that occurred.
    pub kind: RegisterMailDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterMailDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterMailDomainErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request exceeds the limit of the resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The domain you're trying to change is in use by another user or organization in your account. See the error message for details.</p>
    MailDomainInUseException(crate::error::MailDomainInUseException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterMailDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterMailDomainErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RegisterMailDomainErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RegisterMailDomainErrorKind::MailDomainInUseException(_inner) => _inner.fmt(f),
            RegisterMailDomainErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            RegisterMailDomainErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            RegisterMailDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterMailDomainError {
    fn code(&self) -> Option<&str> {
        RegisterMailDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterMailDomainError {
    /// Creates a new `RegisterMailDomainError`.
    pub fn new(kind: RegisterMailDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterMailDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterMailDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterMailDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterMailDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterMailDomainErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterMailDomainErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterMailDomainErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterMailDomainErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterMailDomainErrorKind::MailDomainInUseException`.
    pub fn is_mail_domain_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterMailDomainErrorKind::MailDomainInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterMailDomainErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterMailDomainErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterMailDomainErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterMailDomainErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for RegisterMailDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterMailDomainErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RegisterMailDomainErrorKind::LimitExceededException(_inner) => Some(_inner),
            RegisterMailDomainErrorKind::MailDomainInUseException(_inner) => Some(_inner),
            RegisterMailDomainErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            RegisterMailDomainErrorKind::OrganizationStateException(_inner) => Some(_inner),
            RegisterMailDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterToWorkMail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterToWorkMailError {
    /// Kind of error that occurred.
    pub kind: RegisterToWorkMailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterToWorkMail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterToWorkMailErrorKind {
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The email address that you're trying to assign is already created for a different
    /// user, group, or resource.</p>
    EmailAddressInUseException(crate::error::EmailAddressInUseException),
    /// <p>The user, group, or resource that you're trying to register is already
    /// registered.</p>
    EntityAlreadyRegisteredException(crate::error::EntityAlreadyRegisteredException),
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The domain specified is not found in your organization.</p>
    MailDomainNotFoundException(crate::error::MailDomainNotFoundException),
    /// <p>After a domain has been added to the organization, it must be verified. The domain is
    /// not yet verified.</p>
    MailDomainStateException(crate::error::MailDomainStateException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterToWorkMailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterToWorkMailErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                _inner.fmt(f)
            }
            RegisterToWorkMailErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            RegisterToWorkMailErrorKind::EmailAddressInUseException(_inner) => _inner.fmt(f),
            RegisterToWorkMailErrorKind::EntityAlreadyRegisteredException(_inner) => _inner.fmt(f),
            RegisterToWorkMailErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            RegisterToWorkMailErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            RegisterToWorkMailErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RegisterToWorkMailErrorKind::MailDomainNotFoundException(_inner) => _inner.fmt(f),
            RegisterToWorkMailErrorKind::MailDomainStateException(_inner) => _inner.fmt(f),
            RegisterToWorkMailErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            RegisterToWorkMailErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            RegisterToWorkMailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterToWorkMailError {
    fn code(&self) -> Option<&str> {
        RegisterToWorkMailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterToWorkMailError {
    /// Creates a new `RegisterToWorkMailError`.
    pub fn new(kind: RegisterToWorkMailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterToWorkMailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterToWorkMailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterToWorkMailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterToWorkMailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::DirectoryServiceAuthenticationFailedException`.
    pub fn is_directory_service_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::DirectoryServiceAuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::EmailAddressInUseException`.
    pub fn is_email_address_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::EmailAddressInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::EntityAlreadyRegisteredException`.
    pub fn is_entity_already_registered_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::EntityAlreadyRegisteredException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::MailDomainNotFoundException`.
    pub fn is_mail_domain_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::MailDomainNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::MailDomainStateException`.
    pub fn is_mail_domain_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::MailDomainStateException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterToWorkMailErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterToWorkMailErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for RegisterToWorkMailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterToWorkMailErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                Some(_inner)
            }
            RegisterToWorkMailErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            RegisterToWorkMailErrorKind::EmailAddressInUseException(_inner) => Some(_inner),
            RegisterToWorkMailErrorKind::EntityAlreadyRegisteredException(_inner) => Some(_inner),
            RegisterToWorkMailErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            RegisterToWorkMailErrorKind::EntityStateException(_inner) => Some(_inner),
            RegisterToWorkMailErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RegisterToWorkMailErrorKind::MailDomainNotFoundException(_inner) => Some(_inner),
            RegisterToWorkMailErrorKind::MailDomainStateException(_inner) => Some(_inner),
            RegisterToWorkMailErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            RegisterToWorkMailErrorKind::OrganizationStateException(_inner) => Some(_inner),
            RegisterToWorkMailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetPasswordError {
    /// Kind of error that occurred.
    pub kind: ResetPasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetPasswordErrorKind {
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The supplied password doesn't match the minimum security constraints, such as length
    /// or use of special characters.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>You can't perform a write operation against a read-only directory.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetPasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetPasswordErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                _inner.fmt(f)
            }
            ResetPasswordErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            ResetPasswordErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ResetPasswordErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            ResetPasswordErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ResetPasswordErrorKind::InvalidPasswordException(_inner) => _inner.fmt(f),
            ResetPasswordErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            ResetPasswordErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            ResetPasswordErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ResetPasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetPasswordError {
    fn code(&self) -> Option<&str> {
        ResetPasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetPasswordError {
    /// Creates a new `ResetPasswordError`.
    pub fn new(kind: ResetPasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetPasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetPasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetPasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetPasswordErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetPasswordErrorKind::DirectoryServiceAuthenticationFailedException`.
    pub fn is_directory_service_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetPasswordErrorKind::DirectoryServiceAuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetPasswordErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetPasswordErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetPasswordErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetPasswordErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetPasswordErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(&self.kind, ResetPasswordErrorKind::EntityStateException(_))
    }
    /// Returns `true` if the error kind is `ResetPasswordErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetPasswordErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetPasswordErrorKind::InvalidPasswordException`.
    pub fn is_invalid_password_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetPasswordErrorKind::InvalidPasswordException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetPasswordErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetPasswordErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetPasswordErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetPasswordErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetPasswordErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetPasswordErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for ResetPasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetPasswordErrorKind::DirectoryServiceAuthenticationFailedException(_inner) => {
                Some(_inner)
            }
            ResetPasswordErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            ResetPasswordErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ResetPasswordErrorKind::EntityStateException(_inner) => Some(_inner),
            ResetPasswordErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ResetPasswordErrorKind::InvalidPasswordException(_inner) => Some(_inner),
            ResetPasswordErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            ResetPasswordErrorKind::OrganizationStateException(_inner) => Some(_inner),
            ResetPasswordErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ResetPasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMailboxExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMailboxExportJobError {
    /// Kind of error that occurred.
    pub kind: StartMailboxExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMailboxExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMailboxExportJobErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request exceeds the limit of the resource.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMailboxExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMailboxExportJobErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StartMailboxExportJobErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartMailboxExportJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartMailboxExportJobErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            StartMailboxExportJobErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            StartMailboxExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMailboxExportJobError {
    fn code(&self) -> Option<&str> {
        StartMailboxExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMailboxExportJobError {
    /// Creates a new `StartMailboxExportJobError`.
    pub fn new(kind: StartMailboxExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMailboxExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMailboxExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMailboxExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMailboxExportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMailboxExportJobErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMailboxExportJobErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMailboxExportJobErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMailboxExportJobErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMailboxExportJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMailboxExportJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMailboxExportJobErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMailboxExportJobErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMailboxExportJobErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMailboxExportJobErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for StartMailboxExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMailboxExportJobErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StartMailboxExportJobErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartMailboxExportJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartMailboxExportJobErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            StartMailboxExportJobErrorKind::OrganizationStateException(_inner) => Some(_inner),
            StartMailboxExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The resource can have up to 50 user-applied tags.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::OrganizationStateException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDefaultMailDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDefaultMailDomainError {
    /// Kind of error that occurred.
    pub kind: UpdateDefaultMailDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDefaultMailDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDefaultMailDomainErrorKind {
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The domain specified is not found in your organization.</p>
    MailDomainNotFoundException(crate::error::MailDomainNotFoundException),
    /// <p>After a domain has been added to the organization, it must be verified. The domain is
    /// not yet verified.</p>
    MailDomainStateException(crate::error::MailDomainStateException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDefaultMailDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDefaultMailDomainErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateDefaultMailDomainErrorKind::MailDomainNotFoundException(_inner) => _inner.fmt(f),
            UpdateDefaultMailDomainErrorKind::MailDomainStateException(_inner) => _inner.fmt(f),
            UpdateDefaultMailDomainErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDefaultMailDomainErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            UpdateDefaultMailDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDefaultMailDomainError {
    fn code(&self) -> Option<&str> {
        UpdateDefaultMailDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDefaultMailDomainError {
    /// Creates a new `UpdateDefaultMailDomainError`.
    pub fn new(kind: UpdateDefaultMailDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDefaultMailDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDefaultMailDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDefaultMailDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDefaultMailDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDefaultMailDomainErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultMailDomainErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultMailDomainErrorKind::MailDomainNotFoundException`.
    pub fn is_mail_domain_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultMailDomainErrorKind::MailDomainNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultMailDomainErrorKind::MailDomainStateException`.
    pub fn is_mail_domain_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultMailDomainErrorKind::MailDomainStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultMailDomainErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultMailDomainErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultMailDomainErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultMailDomainErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for UpdateDefaultMailDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDefaultMailDomainErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateDefaultMailDomainErrorKind::MailDomainNotFoundException(_inner) => Some(_inner),
            UpdateDefaultMailDomainErrorKind::MailDomainStateException(_inner) => Some(_inner),
            UpdateDefaultMailDomainErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            UpdateDefaultMailDomainErrorKind::OrganizationStateException(_inner) => Some(_inner),
            UpdateDefaultMailDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMailboxQuota` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMailboxQuotaError {
    /// Kind of error that occurred.
    pub kind: UpdateMailboxQuotaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMailboxQuota` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMailboxQuotaErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMailboxQuotaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMailboxQuotaErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateMailboxQuotaErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            UpdateMailboxQuotaErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateMailboxQuotaErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            UpdateMailboxQuotaErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            UpdateMailboxQuotaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMailboxQuotaError {
    fn code(&self) -> Option<&str> {
        UpdateMailboxQuotaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMailboxQuotaError {
    /// Creates a new `UpdateMailboxQuotaError`.
    pub fn new(kind: UpdateMailboxQuotaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMailboxQuotaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMailboxQuotaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMailboxQuotaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMailboxQuotaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMailboxQuotaErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMailboxQuotaErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMailboxQuotaErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMailboxQuotaErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMailboxQuotaErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMailboxQuotaErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMailboxQuotaErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMailboxQuotaErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMailboxQuotaErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMailboxQuotaErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for UpdateMailboxQuotaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMailboxQuotaErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateMailboxQuotaErrorKind::EntityStateException(_inner) => Some(_inner),
            UpdateMailboxQuotaErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateMailboxQuotaErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            UpdateMailboxQuotaErrorKind::OrganizationStateException(_inner) => Some(_inner),
            UpdateMailboxQuotaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMobileDeviceAccessRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMobileDeviceAccessRuleError {
    /// Kind of error that occurred.
    pub kind: UpdateMobileDeviceAccessRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMobileDeviceAccessRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMobileDeviceAccessRuleErrorKind {
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMobileDeviceAccessRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMobileDeviceAccessRuleErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateMobileDeviceAccessRuleErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateMobileDeviceAccessRuleErrorKind::OrganizationStateException(_inner) => {
                _inner.fmt(f)
            }
            UpdateMobileDeviceAccessRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMobileDeviceAccessRuleError {
    fn code(&self) -> Option<&str> {
        UpdateMobileDeviceAccessRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMobileDeviceAccessRuleError {
    /// Creates a new `UpdateMobileDeviceAccessRuleError`.
    pub fn new(kind: UpdateMobileDeviceAccessRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMobileDeviceAccessRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMobileDeviceAccessRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMobileDeviceAccessRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMobileDeviceAccessRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMobileDeviceAccessRuleErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMobileDeviceAccessRuleErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMobileDeviceAccessRuleErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMobileDeviceAccessRuleErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMobileDeviceAccessRuleErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMobileDeviceAccessRuleErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for UpdateMobileDeviceAccessRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMobileDeviceAccessRuleErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateMobileDeviceAccessRuleErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            UpdateMobileDeviceAccessRuleErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateMobileDeviceAccessRuleErrorKind::OrganizationStateException(_inner) => {
                Some(_inner)
            }
            UpdateMobileDeviceAccessRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePrimaryEmailAddress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePrimaryEmailAddressError {
    /// Kind of error that occurred.
    pub kind: UpdatePrimaryEmailAddressErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePrimaryEmailAddress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePrimaryEmailAddressErrorKind {
    /// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
    DirectoryServiceAuthenticationFailedException(
        crate::error::DirectoryServiceAuthenticationFailedException,
    ),
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The email address that you're trying to assign is already created for a different
    /// user, group, or resource.</p>
    EmailAddressInUseException(crate::error::EmailAddressInUseException),
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>One or more of the input parameters don't match the service's restrictions.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The domain specified is not found in your organization.</p>
    MailDomainNotFoundException(crate::error::MailDomainNotFoundException),
    /// <p>After a domain has been added to the organization, it must be verified. The domain is
    /// not yet verified.</p>
    MailDomainStateException(crate::error::MailDomainStateException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// <p>You can't perform a write operation against a read-only directory.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePrimaryEmailAddressError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePrimaryEmailAddressErrorKind::DirectoryServiceAuthenticationFailedException(
                _inner,
            ) => _inner.fmt(f),
            UpdatePrimaryEmailAddressErrorKind::DirectoryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdatePrimaryEmailAddressErrorKind::EmailAddressInUseException(_inner) => _inner.fmt(f),
            UpdatePrimaryEmailAddressErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdatePrimaryEmailAddressErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            UpdatePrimaryEmailAddressErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdatePrimaryEmailAddressErrorKind::MailDomainNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdatePrimaryEmailAddressErrorKind::MailDomainStateException(_inner) => _inner.fmt(f),
            UpdatePrimaryEmailAddressErrorKind::OrganizationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdatePrimaryEmailAddressErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            UpdatePrimaryEmailAddressErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            UpdatePrimaryEmailAddressErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePrimaryEmailAddressError {
    fn code(&self) -> Option<&str> {
        UpdatePrimaryEmailAddressError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePrimaryEmailAddressError {
    /// Creates a new `UpdatePrimaryEmailAddressError`.
    pub fn new(kind: UpdatePrimaryEmailAddressErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePrimaryEmailAddressError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePrimaryEmailAddressErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePrimaryEmailAddressError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePrimaryEmailAddressErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::DirectoryServiceAuthenticationFailedException`.
    pub fn is_directory_service_authentication_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::DirectoryServiceAuthenticationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::EmailAddressInUseException`.
    pub fn is_email_address_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::EmailAddressInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::EntityStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::MailDomainNotFoundException`.
    pub fn is_mail_domain_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::MailDomainNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::MailDomainStateException`.
    pub fn is_mail_domain_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::MailDomainStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::OrganizationStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryEmailAddressErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryEmailAddressErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for UpdatePrimaryEmailAddressError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePrimaryEmailAddressErrorKind::DirectoryServiceAuthenticationFailedException(
                _inner,
            ) => Some(_inner),
            UpdatePrimaryEmailAddressErrorKind::DirectoryUnavailableException(_inner) => {
                Some(_inner)
            }
            UpdatePrimaryEmailAddressErrorKind::EmailAddressInUseException(_inner) => Some(_inner),
            UpdatePrimaryEmailAddressErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdatePrimaryEmailAddressErrorKind::EntityStateException(_inner) => Some(_inner),
            UpdatePrimaryEmailAddressErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdatePrimaryEmailAddressErrorKind::MailDomainNotFoundException(_inner) => Some(_inner),
            UpdatePrimaryEmailAddressErrorKind::MailDomainStateException(_inner) => Some(_inner),
            UpdatePrimaryEmailAddressErrorKind::OrganizationNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdatePrimaryEmailAddressErrorKind::OrganizationStateException(_inner) => Some(_inner),
            UpdatePrimaryEmailAddressErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            UpdatePrimaryEmailAddressErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourceError {
    /// Kind of error that occurred.
    pub kind: UpdateResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourceErrorKind {
    /// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
    DirectoryUnavailableException(crate::error::DirectoryUnavailableException),
    /// <p>The email address that you're trying to assign is already created for a different
    /// user, group, or resource.</p>
    EmailAddressInUseException(crate::error::EmailAddressInUseException),
    /// <p>The identifier supplied for the user, group, or resource does not exist in your
    /// organization.</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>You are performing an operation on a user, group, or resource that isn't in the
    /// expected state, such as trying to delete an active user.</p>
    EntityStateException(crate::error::EntityStateException),
    /// <p>The configuration for a resource isn't valid. A resource must either be able to
    /// auto-respond to requests or have at least one delegate associated that can do so on its
    /// behalf.</p>
    InvalidConfigurationException(crate::error::InvalidConfigurationException),
    /// <p>The domain specified is not found in your organization.</p>
    MailDomainNotFoundException(crate::error::MailDomainNotFoundException),
    /// <p>After a domain has been added to the organization, it must be verified. The domain is
    /// not yet verified.</p>
    MailDomainStateException(crate::error::MailDomainStateException),
    /// <p>The user, group, or resource name isn't unique in Amazon WorkMail.</p>
    NameAvailabilityException(crate::error::NameAvailabilityException),
    /// <p>An operation received a valid organization identifier that either doesn't belong or
    /// exist in the system.</p>
    OrganizationNotFoundException(crate::error::OrganizationNotFoundException),
    /// <p>The organization must have a valid state to perform certain
    /// operations on the organization or its members.</p>
    OrganizationStateException(crate::error::OrganizationStateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourceErrorKind::DirectoryUnavailableException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::EmailAddressInUseException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::EntityStateException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::InvalidConfigurationException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::MailDomainNotFoundException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::MailDomainStateException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::NameAvailabilityException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::OrganizationNotFoundException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::OrganizationStateException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourceError {
    fn code(&self) -> Option<&str> {
        UpdateResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourceError {
    /// Creates a new `UpdateResourceError`.
    pub fn new(kind: UpdateResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::DirectoryUnavailableException`.
    pub fn is_directory_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::DirectoryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::EmailAddressInUseException`.
    pub fn is_email_address_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::EmailAddressInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::EntityStateException`.
    pub fn is_entity_state_exception(&self) -> bool {
        matches!(&self.kind, UpdateResourceErrorKind::EntityStateException(_))
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::InvalidConfigurationException`.
    pub fn is_invalid_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::InvalidConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::MailDomainNotFoundException`.
    pub fn is_mail_domain_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::MailDomainNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::MailDomainStateException`.
    pub fn is_mail_domain_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::MailDomainStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::NameAvailabilityException`.
    pub fn is_name_availability_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::NameAvailabilityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::OrganizationNotFoundException`.
    pub fn is_organization_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::OrganizationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceErrorKind::OrganizationStateException`.
    pub fn is_organization_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::OrganizationStateException(_)
        )
    }
}
impl std::error::Error for UpdateResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourceErrorKind::DirectoryUnavailableException(_inner) => Some(_inner),
            UpdateResourceErrorKind::EmailAddressInUseException(_inner) => Some(_inner),
            UpdateResourceErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateResourceErrorKind::EntityStateException(_inner) => Some(_inner),
            UpdateResourceErrorKind::InvalidConfigurationException(_inner) => Some(_inner),
            UpdateResourceErrorKind::MailDomainNotFoundException(_inner) => Some(_inner),
            UpdateResourceErrorKind::MailDomainStateException(_inner) => Some(_inner),
            UpdateResourceErrorKind::NameAvailabilityException(_inner) => Some(_inner),
            UpdateResourceErrorKind::OrganizationNotFoundException(_inner) => Some(_inner),
            UpdateResourceErrorKind::OrganizationStateException(_inner) => Some(_inner),
            UpdateResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The organization must have a valid state to perform certain
/// operations on the organization or its members.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationStateException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationStateException {}
/// See [`OrganizationStateException`](crate::error::OrganizationStateException)
pub mod organization_state_exception {
    /// A builder for [`OrganizationStateException`](crate::error::OrganizationStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationStateException`](crate::error::OrganizationStateException)
        pub fn build(self) -> crate::error::OrganizationStateException {
            crate::error::OrganizationStateException {
                message: self.message,
            }
        }
    }
}
impl OrganizationStateException {
    /// Creates a new builder-style object to manufacture [`OrganizationStateException`](crate::error::OrganizationStateException)
    pub fn builder() -> crate::error::organization_state_exception::Builder {
        crate::error::organization_state_exception::Builder::default()
    }
}

/// <p>An operation received a valid organization identifier that either doesn't belong or
/// exist in the system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationNotFoundException {}
/// See [`OrganizationNotFoundException`](crate::error::OrganizationNotFoundException)
pub mod organization_not_found_exception {
    /// A builder for [`OrganizationNotFoundException`](crate::error::OrganizationNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationNotFoundException`](crate::error::OrganizationNotFoundException)
        pub fn build(self) -> crate::error::OrganizationNotFoundException {
            crate::error::OrganizationNotFoundException {
                message: self.message,
            }
        }
    }
}
impl OrganizationNotFoundException {
    /// Creates a new builder-style object to manufacture [`OrganizationNotFoundException`](crate::error::OrganizationNotFoundException)
    pub fn builder() -> crate::error::organization_not_found_exception::Builder {
        crate::error::organization_not_found_exception::Builder::default()
    }
}

/// <p>The user, group, or resource name isn't unique in Amazon WorkMail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NameAvailabilityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NameAvailabilityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NameAvailabilityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NameAvailabilityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NameAvailabilityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NameAvailabilityException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for NameAvailabilityException {}
/// See [`NameAvailabilityException`](crate::error::NameAvailabilityException)
pub mod name_availability_exception {
    /// A builder for [`NameAvailabilityException`](crate::error::NameAvailabilityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NameAvailabilityException`](crate::error::NameAvailabilityException)
        pub fn build(self) -> crate::error::NameAvailabilityException {
            crate::error::NameAvailabilityException {
                message: self.message,
            }
        }
    }
}
impl NameAvailabilityException {
    /// Creates a new builder-style object to manufacture [`NameAvailabilityException`](crate::error::NameAvailabilityException)
    pub fn builder() -> crate::error::name_availability_exception::Builder {
        crate::error::name_availability_exception::Builder::default()
    }
}

/// <p>After a domain has been added to the organization, it must be verified. The domain is
/// not yet verified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MailDomainStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MailDomainStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MailDomainStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MailDomainStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MailDomainStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MailDomainStateException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for MailDomainStateException {}
/// See [`MailDomainStateException`](crate::error::MailDomainStateException)
pub mod mail_domain_state_exception {
    /// A builder for [`MailDomainStateException`](crate::error::MailDomainStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MailDomainStateException`](crate::error::MailDomainStateException)
        pub fn build(self) -> crate::error::MailDomainStateException {
            crate::error::MailDomainStateException {
                message: self.message,
            }
        }
    }
}
impl MailDomainStateException {
    /// Creates a new builder-style object to manufacture [`MailDomainStateException`](crate::error::MailDomainStateException)
    pub fn builder() -> crate::error::mail_domain_state_exception::Builder {
        crate::error::mail_domain_state_exception::Builder::default()
    }
}

/// <p>The domain specified is not found in your organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MailDomainNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MailDomainNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MailDomainNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MailDomainNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MailDomainNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MailDomainNotFoundException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for MailDomainNotFoundException {}
/// See [`MailDomainNotFoundException`](crate::error::MailDomainNotFoundException)
pub mod mail_domain_not_found_exception {
    /// A builder for [`MailDomainNotFoundException`](crate::error::MailDomainNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MailDomainNotFoundException`](crate::error::MailDomainNotFoundException)
        pub fn build(self) -> crate::error::MailDomainNotFoundException {
            crate::error::MailDomainNotFoundException {
                message: self.message,
            }
        }
    }
}
impl MailDomainNotFoundException {
    /// Creates a new builder-style object to manufacture [`MailDomainNotFoundException`](crate::error::MailDomainNotFoundException)
    pub fn builder() -> crate::error::mail_domain_not_found_exception::Builder {
        crate::error::mail_domain_not_found_exception::Builder::default()
    }
}

/// <p>The configuration for a resource isn't valid. A resource must either be able to
/// auto-respond to requests or have at least one delegate associated that can do so on its
/// behalf.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidConfigurationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidConfigurationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidConfigurationException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidConfigurationException {}
/// See [`InvalidConfigurationException`](crate::error::InvalidConfigurationException)
pub mod invalid_configuration_exception {
    /// A builder for [`InvalidConfigurationException`](crate::error::InvalidConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidConfigurationException`](crate::error::InvalidConfigurationException)
        pub fn build(self) -> crate::error::InvalidConfigurationException {
            crate::error::InvalidConfigurationException {
                message: self.message,
            }
        }
    }
}
impl InvalidConfigurationException {
    /// Creates a new builder-style object to manufacture [`InvalidConfigurationException`](crate::error::InvalidConfigurationException)
    pub fn builder() -> crate::error::invalid_configuration_exception::Builder {
        crate::error::invalid_configuration_exception::Builder::default()
    }
}

/// <p>You are performing an operation on a user, group, or resource that isn't in the
/// expected state, such as trying to delete an active user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EntityStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EntityStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EntityStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EntityStateException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for EntityStateException {}
/// See [`EntityStateException`](crate::error::EntityStateException)
pub mod entity_state_exception {
    /// A builder for [`EntityStateException`](crate::error::EntityStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityStateException`](crate::error::EntityStateException)
        pub fn build(self) -> crate::error::EntityStateException {
            crate::error::EntityStateException {
                message: self.message,
            }
        }
    }
}
impl EntityStateException {
    /// Creates a new builder-style object to manufacture [`EntityStateException`](crate::error::EntityStateException)
    pub fn builder() -> crate::error::entity_state_exception::Builder {
        crate::error::entity_state_exception::Builder::default()
    }
}

/// <p>The identifier supplied for the user, group, or resource does not exist in your
/// organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EntityNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EntityNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EntityNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EntityNotFoundException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for EntityNotFoundException {}
/// See [`EntityNotFoundException`](crate::error::EntityNotFoundException)
pub mod entity_not_found_exception {
    /// A builder for [`EntityNotFoundException`](crate::error::EntityNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityNotFoundException`](crate::error::EntityNotFoundException)
        pub fn build(self) -> crate::error::EntityNotFoundException {
            crate::error::EntityNotFoundException {
                message: self.message,
            }
        }
    }
}
impl EntityNotFoundException {
    /// Creates a new builder-style object to manufacture [`EntityNotFoundException`](crate::error::EntityNotFoundException)
    pub fn builder() -> crate::error::entity_not_found_exception::Builder {
        crate::error::entity_not_found_exception::Builder::default()
    }
}

/// <p>The email address that you're trying to assign is already created for a different
/// user, group, or resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailAddressInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EmailAddressInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailAddressInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EmailAddressInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EmailAddressInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EmailAddressInUseException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for EmailAddressInUseException {}
/// See [`EmailAddressInUseException`](crate::error::EmailAddressInUseException)
pub mod email_address_in_use_exception {
    /// A builder for [`EmailAddressInUseException`](crate::error::EmailAddressInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailAddressInUseException`](crate::error::EmailAddressInUseException)
        pub fn build(self) -> crate::error::EmailAddressInUseException {
            crate::error::EmailAddressInUseException {
                message: self.message,
            }
        }
    }
}
impl EmailAddressInUseException {
    /// Creates a new builder-style object to manufacture [`EmailAddressInUseException`](crate::error::EmailAddressInUseException)
    pub fn builder() -> crate::error::email_address_in_use_exception::Builder {
        crate::error::email_address_in_use_exception::Builder::default()
    }
}

/// <p>The directory is unavailable. It might be located in another Region or deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DirectoryUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DirectoryUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryUnavailableException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryUnavailableException {}
/// See [`DirectoryUnavailableException`](crate::error::DirectoryUnavailableException)
pub mod directory_unavailable_exception {
    /// A builder for [`DirectoryUnavailableException`](crate::error::DirectoryUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryUnavailableException`](crate::error::DirectoryUnavailableException)
        pub fn build(self) -> crate::error::DirectoryUnavailableException {
            crate::error::DirectoryUnavailableException {
                message: self.message,
            }
        }
    }
}
impl DirectoryUnavailableException {
    /// Creates a new builder-style object to manufacture [`DirectoryUnavailableException`](crate::error::DirectoryUnavailableException)
    pub fn builder() -> crate::error::directory_unavailable_exception::Builder {
        crate::error::directory_unavailable_exception::Builder::default()
    }
}

/// <p>You can't perform a write operation against a read-only directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperationException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperationException {}
/// See [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
pub mod unsupported_operation_exception {
    /// A builder for [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
        pub fn build(self) -> crate::error::UnsupportedOperationException {
            crate::error::UnsupportedOperationException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOperationException {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    pub fn builder() -> crate::error::unsupported_operation_exception::Builder {
        crate::error::unsupported_operation_exception::Builder::default()
    }
}

/// <p>One or more of the input parameters don't match the service's restrictions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>The directory service doesn't recognize the credentials supplied by WorkMail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryServiceAuthenticationFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DirectoryServiceAuthenticationFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryServiceAuthenticationFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DirectoryServiceAuthenticationFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryServiceAuthenticationFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryServiceAuthenticationFailedException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryServiceAuthenticationFailedException {}
/// See [`DirectoryServiceAuthenticationFailedException`](crate::error::DirectoryServiceAuthenticationFailedException)
pub mod directory_service_authentication_failed_exception {
    /// A builder for [`DirectoryServiceAuthenticationFailedException`](crate::error::DirectoryServiceAuthenticationFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryServiceAuthenticationFailedException`](crate::error::DirectoryServiceAuthenticationFailedException)
        pub fn build(self) -> crate::error::DirectoryServiceAuthenticationFailedException {
            crate::error::DirectoryServiceAuthenticationFailedException {
                message: self.message,
            }
        }
    }
}
impl DirectoryServiceAuthenticationFailedException {
    /// Creates a new builder-style object to manufacture [`DirectoryServiceAuthenticationFailedException`](crate::error::DirectoryServiceAuthenticationFailedException)
    pub fn builder() -> crate::error::directory_service_authentication_failed_exception::Builder {
        crate::error::directory_service_authentication_failed_exception::Builder::default()
    }
}

/// <p>The resource cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The resource can have up to 50 user-applied tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The request exceeds the limit of the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The supplied password doesn't match the minimum security constraints, such as length
/// or use of special characters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPasswordException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPasswordException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPasswordException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPasswordException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPasswordException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPasswordException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPasswordException {}
/// See [`InvalidPasswordException`](crate::error::InvalidPasswordException)
pub mod invalid_password_exception {
    /// A builder for [`InvalidPasswordException`](crate::error::InvalidPasswordException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPasswordException`](crate::error::InvalidPasswordException)
        pub fn build(self) -> crate::error::InvalidPasswordException {
            crate::error::InvalidPasswordException {
                message: self.message,
            }
        }
    }
}
impl InvalidPasswordException {
    /// Creates a new builder-style object to manufacture [`InvalidPasswordException`](crate::error::InvalidPasswordException)
    pub fn builder() -> crate::error::invalid_password_exception::Builder {
        crate::error::invalid_password_exception::Builder::default()
    }
}

/// <p>The user, group, or resource that you're trying to register is already
/// registered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityAlreadyRegisteredException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EntityAlreadyRegisteredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityAlreadyRegisteredException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EntityAlreadyRegisteredException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EntityAlreadyRegisteredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EntityAlreadyRegisteredException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for EntityAlreadyRegisteredException {}
/// See [`EntityAlreadyRegisteredException`](crate::error::EntityAlreadyRegisteredException)
pub mod entity_already_registered_exception {
    /// A builder for [`EntityAlreadyRegisteredException`](crate::error::EntityAlreadyRegisteredException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityAlreadyRegisteredException`](crate::error::EntityAlreadyRegisteredException)
        pub fn build(self) -> crate::error::EntityAlreadyRegisteredException {
            crate::error::EntityAlreadyRegisteredException {
                message: self.message,
            }
        }
    }
}
impl EntityAlreadyRegisteredException {
    /// Creates a new builder-style object to manufacture [`EntityAlreadyRegisteredException`](crate::error::EntityAlreadyRegisteredException)
    pub fn builder() -> crate::error::entity_already_registered_exception::Builder {
        crate::error::entity_already_registered_exception::Builder::default()
    }
}

/// <p>The domain you're trying to change is in use by another user or organization in your account. See the error message for details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MailDomainInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MailDomainInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MailDomainInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MailDomainInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MailDomainInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MailDomainInUseException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for MailDomainInUseException {}
/// See [`MailDomainInUseException`](crate::error::MailDomainInUseException)
pub mod mail_domain_in_use_exception {
    /// A builder for [`MailDomainInUseException`](crate::error::MailDomainInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MailDomainInUseException`](crate::error::MailDomainInUseException)
        pub fn build(self) -> crate::error::MailDomainInUseException {
            crate::error::MailDomainInUseException {
                message: self.message,
            }
        }
    }
}
impl MailDomainInUseException {
    /// Creates a new builder-style object to manufacture [`MailDomainInUseException`](crate::error::MailDomainInUseException)
    pub fn builder() -> crate::error::mail_domain_in_use_exception::Builder {
        crate::error::mail_domain_in_use_exception::Builder::default()
    }
}

/// <p>You SES configuration has customizations that Amazon WorkMail cannot save. The error message lists the invalid setting. For examples of invalid settings, refer to
/// <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html">CreateReceiptRule</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCustomSesConfigurationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidCustomSesConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCustomSesConfigurationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCustomSesConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCustomSesConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCustomSesConfigurationException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCustomSesConfigurationException {}
/// See [`InvalidCustomSesConfigurationException`](crate::error::InvalidCustomSesConfigurationException)
pub mod invalid_custom_ses_configuration_exception {
    /// A builder for [`InvalidCustomSesConfigurationException`](crate::error::InvalidCustomSesConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCustomSesConfigurationException`](crate::error::InvalidCustomSesConfigurationException)
        pub fn build(self) -> crate::error::InvalidCustomSesConfigurationException {
            crate::error::InvalidCustomSesConfigurationException {
                message: self.message,
            }
        }
    }
}
impl InvalidCustomSesConfigurationException {
    /// Creates a new builder-style object to manufacture [`InvalidCustomSesConfigurationException`](crate::error::InvalidCustomSesConfigurationException)
    pub fn builder() -> crate::error::invalid_custom_ses_configuration_exception::Builder {
        crate::error::invalid_custom_ses_configuration_exception::Builder::default()
    }
}

/// <p>This user, group, or resource name is not allowed in Amazon WorkMail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedNameException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReservedNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReservedNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReservedNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReservedNameException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReservedNameException {}
/// See [`ReservedNameException`](crate::error::ReservedNameException)
pub mod reserved_name_exception {
    /// A builder for [`ReservedNameException`](crate::error::ReservedNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedNameException`](crate::error::ReservedNameException)
        pub fn build(self) -> crate::error::ReservedNameException {
            crate::error::ReservedNameException {
                message: self.message,
            }
        }
    }
}
impl ReservedNameException {
    /// Creates a new builder-style object to manufacture [`ReservedNameException`](crate::error::ReservedNameException)
    pub fn builder() -> crate::error::reserved_name_exception::Builder {
        crate::error::reserved_name_exception::Builder::default()
    }
}

/// <p>The directory is already in use by another WorkMail organization in the same account and Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DirectoryInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DirectoryInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DirectoryInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DirectoryInUseException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for DirectoryInUseException {}
/// See [`DirectoryInUseException`](crate::error::DirectoryInUseException)
pub mod directory_in_use_exception {
    /// A builder for [`DirectoryInUseException`](crate::error::DirectoryInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryInUseException`](crate::error::DirectoryInUseException)
        pub fn build(self) -> crate::error::DirectoryInUseException {
            crate::error::DirectoryInUseException {
                message: self.message,
            }
        }
    }
}
impl DirectoryInUseException {
    /// Creates a new builder-style object to manufacture [`DirectoryInUseException`](crate::error::DirectoryInUseException)
    pub fn builder() -> crate::error::directory_in_use_exception::Builder {
        crate::error::directory_in_use_exception::Builder::default()
    }
}
