// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `WorkMailService`.
///
/// This client allows ergonomic access to a `WorkMailService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateDelegateToResource` operation.
    ///
    /// See [`AssociateDelegateToResource`](crate::client::fluent_builders::AssociateDelegateToResource) for more information about the
    /// operation and its arguments.
    pub fn associate_delegate_to_resource(
        &self,
    ) -> fluent_builders::AssociateDelegateToResource<C, M, R> {
        fluent_builders::AssociateDelegateToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateMemberToGroup` operation.
    ///
    /// See [`AssociateMemberToGroup`](crate::client::fluent_builders::AssociateMemberToGroup) for more information about the
    /// operation and its arguments.
    pub fn associate_member_to_group(&self) -> fluent_builders::AssociateMemberToGroup<C, M, R> {
        fluent_builders::AssociateMemberToGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelMailboxExportJob` operation.
    ///
    /// See [`CancelMailboxExportJob`](crate::client::fluent_builders::CancelMailboxExportJob) for more information about the
    /// operation and its arguments.
    pub fn cancel_mailbox_export_job(&self) -> fluent_builders::CancelMailboxExportJob<C, M, R> {
        fluent_builders::CancelMailboxExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAlias` operation.
    ///
    /// See [`CreateAlias`](crate::client::fluent_builders::CreateAlias) for more information about the
    /// operation and its arguments.
    pub fn create_alias(&self) -> fluent_builders::CreateAlias<C, M, R> {
        fluent_builders::CreateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGroup` operation.
    ///
    /// See [`CreateGroup`](crate::client::fluent_builders::CreateGroup) for more information about the
    /// operation and its arguments.
    pub fn create_group(&self) -> fluent_builders::CreateGroup<C, M, R> {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMobileDeviceAccessRule` operation.
    ///
    /// See [`CreateMobileDeviceAccessRule`](crate::client::fluent_builders::CreateMobileDeviceAccessRule) for more information about the
    /// operation and its arguments.
    pub fn create_mobile_device_access_rule(
        &self,
    ) -> fluent_builders::CreateMobileDeviceAccessRule<C, M, R> {
        fluent_builders::CreateMobileDeviceAccessRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOrganization` operation.
    ///
    /// See [`CreateOrganization`](crate::client::fluent_builders::CreateOrganization) for more information about the
    /// operation and its arguments.
    pub fn create_organization(&self) -> fluent_builders::CreateOrganization<C, M, R> {
        fluent_builders::CreateOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResource` operation.
    ///
    /// See [`CreateResource`](crate::client::fluent_builders::CreateResource) for more information about the
    /// operation and its arguments.
    pub fn create_resource(&self) -> fluent_builders::CreateResource<C, M, R> {
        fluent_builders::CreateResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUser` operation.
    ///
    /// See [`CreateUser`](crate::client::fluent_builders::CreateUser) for more information about the
    /// operation and its arguments.
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccessControlRule` operation.
    ///
    /// See [`DeleteAccessControlRule`](crate::client::fluent_builders::DeleteAccessControlRule) for more information about the
    /// operation and its arguments.
    pub fn delete_access_control_rule(&self) -> fluent_builders::DeleteAccessControlRule<C, M, R> {
        fluent_builders::DeleteAccessControlRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAlias` operation.
    ///
    /// See [`DeleteAlias`](crate::client::fluent_builders::DeleteAlias) for more information about the
    /// operation and its arguments.
    pub fn delete_alias(&self) -> fluent_builders::DeleteAlias<C, M, R> {
        fluent_builders::DeleteAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGroup` operation.
    ///
    /// See [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup<C, M, R> {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMailboxPermissions` operation.
    ///
    /// See [`DeleteMailboxPermissions`](crate::client::fluent_builders::DeleteMailboxPermissions) for more information about the
    /// operation and its arguments.
    pub fn delete_mailbox_permissions(&self) -> fluent_builders::DeleteMailboxPermissions<C, M, R> {
        fluent_builders::DeleteMailboxPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMobileDeviceAccessOverride` operation.
    ///
    /// See [`DeleteMobileDeviceAccessOverride`](crate::client::fluent_builders::DeleteMobileDeviceAccessOverride) for more information about the
    /// operation and its arguments.
    pub fn delete_mobile_device_access_override(
        &self,
    ) -> fluent_builders::DeleteMobileDeviceAccessOverride<C, M, R> {
        fluent_builders::DeleteMobileDeviceAccessOverride::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMobileDeviceAccessRule` operation.
    ///
    /// See [`DeleteMobileDeviceAccessRule`](crate::client::fluent_builders::DeleteMobileDeviceAccessRule) for more information about the
    /// operation and its arguments.
    pub fn delete_mobile_device_access_rule(
        &self,
    ) -> fluent_builders::DeleteMobileDeviceAccessRule<C, M, R> {
        fluent_builders::DeleteMobileDeviceAccessRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOrganization` operation.
    ///
    /// See [`DeleteOrganization`](crate::client::fluent_builders::DeleteOrganization) for more information about the
    /// operation and its arguments.
    pub fn delete_organization(&self) -> fluent_builders::DeleteOrganization<C, M, R> {
        fluent_builders::DeleteOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResource` operation.
    ///
    /// See [`DeleteResource`](crate::client::fluent_builders::DeleteResource) for more information about the
    /// operation and its arguments.
    pub fn delete_resource(&self) -> fluent_builders::DeleteResource<C, M, R> {
        fluent_builders::DeleteResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRetentionPolicy` operation.
    ///
    /// See [`DeleteRetentionPolicy`](crate::client::fluent_builders::DeleteRetentionPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_retention_policy(&self) -> fluent_builders::DeleteRetentionPolicy<C, M, R> {
        fluent_builders::DeleteRetentionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUser` operation.
    ///
    /// See [`DeleteUser`](crate::client::fluent_builders::DeleteUser) for more information about the
    /// operation and its arguments.
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterFromWorkMail` operation.
    ///
    /// See [`DeregisterFromWorkMail`](crate::client::fluent_builders::DeregisterFromWorkMail) for more information about the
    /// operation and its arguments.
    pub fn deregister_from_work_mail(&self) -> fluent_builders::DeregisterFromWorkMail<C, M, R> {
        fluent_builders::DeregisterFromWorkMail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterMailDomain` operation.
    ///
    /// See [`DeregisterMailDomain`](crate::client::fluent_builders::DeregisterMailDomain) for more information about the
    /// operation and its arguments.
    pub fn deregister_mail_domain(&self) -> fluent_builders::DeregisterMailDomain<C, M, R> {
        fluent_builders::DeregisterMailDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGroup` operation.
    ///
    /// See [`DescribeGroup`](crate::client::fluent_builders::DescribeGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_group(&self) -> fluent_builders::DescribeGroup<C, M, R> {
        fluent_builders::DescribeGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInboundDmarcSettings` operation.
    ///
    /// See [`DescribeInboundDmarcSettings`](crate::client::fluent_builders::DescribeInboundDmarcSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_inbound_dmarc_settings(
        &self,
    ) -> fluent_builders::DescribeInboundDmarcSettings<C, M, R> {
        fluent_builders::DescribeInboundDmarcSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMailboxExportJob` operation.
    ///
    /// See [`DescribeMailboxExportJob`](crate::client::fluent_builders::DescribeMailboxExportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_mailbox_export_job(
        &self,
    ) -> fluent_builders::DescribeMailboxExportJob<C, M, R> {
        fluent_builders::DescribeMailboxExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganization` operation.
    ///
    /// See [`DescribeOrganization`](crate::client::fluent_builders::DescribeOrganization) for more information about the
    /// operation and its arguments.
    pub fn describe_organization(&self) -> fluent_builders::DescribeOrganization<C, M, R> {
        fluent_builders::DescribeOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeResource` operation.
    ///
    /// See [`DescribeResource`](crate::client::fluent_builders::DescribeResource) for more information about the
    /// operation and its arguments.
    pub fn describe_resource(&self) -> fluent_builders::DescribeResource<C, M, R> {
        fluent_builders::DescribeResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUser` operation.
    ///
    /// See [`DescribeUser`](crate::client::fluent_builders::DescribeUser) for more information about the
    /// operation and its arguments.
    pub fn describe_user(&self) -> fluent_builders::DescribeUser<C, M, R> {
        fluent_builders::DescribeUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateDelegateFromResource` operation.
    ///
    /// See [`DisassociateDelegateFromResource`](crate::client::fluent_builders::DisassociateDelegateFromResource) for more information about the
    /// operation and its arguments.
    pub fn disassociate_delegate_from_resource(
        &self,
    ) -> fluent_builders::DisassociateDelegateFromResource<C, M, R> {
        fluent_builders::DisassociateDelegateFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateMemberFromGroup` operation.
    ///
    /// See [`DisassociateMemberFromGroup`](crate::client::fluent_builders::DisassociateMemberFromGroup) for more information about the
    /// operation and its arguments.
    pub fn disassociate_member_from_group(
        &self,
    ) -> fluent_builders::DisassociateMemberFromGroup<C, M, R> {
        fluent_builders::DisassociateMemberFromGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessControlEffect` operation.
    ///
    /// See [`GetAccessControlEffect`](crate::client::fluent_builders::GetAccessControlEffect) for more information about the
    /// operation and its arguments.
    pub fn get_access_control_effect(&self) -> fluent_builders::GetAccessControlEffect<C, M, R> {
        fluent_builders::GetAccessControlEffect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDefaultRetentionPolicy` operation.
    ///
    /// See [`GetDefaultRetentionPolicy`](crate::client::fluent_builders::GetDefaultRetentionPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_default_retention_policy(
        &self,
    ) -> fluent_builders::GetDefaultRetentionPolicy<C, M, R> {
        fluent_builders::GetDefaultRetentionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMailboxDetails` operation.
    ///
    /// See [`GetMailboxDetails`](crate::client::fluent_builders::GetMailboxDetails) for more information about the
    /// operation and its arguments.
    pub fn get_mailbox_details(&self) -> fluent_builders::GetMailboxDetails<C, M, R> {
        fluent_builders::GetMailboxDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMailDomain` operation.
    ///
    /// See [`GetMailDomain`](crate::client::fluent_builders::GetMailDomain) for more information about the
    /// operation and its arguments.
    pub fn get_mail_domain(&self) -> fluent_builders::GetMailDomain<C, M, R> {
        fluent_builders::GetMailDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMobileDeviceAccessEffect` operation.
    ///
    /// See [`GetMobileDeviceAccessEffect`](crate::client::fluent_builders::GetMobileDeviceAccessEffect) for more information about the
    /// operation and its arguments.
    pub fn get_mobile_device_access_effect(
        &self,
    ) -> fluent_builders::GetMobileDeviceAccessEffect<C, M, R> {
        fluent_builders::GetMobileDeviceAccessEffect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMobileDeviceAccessOverride` operation.
    ///
    /// See [`GetMobileDeviceAccessOverride`](crate::client::fluent_builders::GetMobileDeviceAccessOverride) for more information about the
    /// operation and its arguments.
    pub fn get_mobile_device_access_override(
        &self,
    ) -> fluent_builders::GetMobileDeviceAccessOverride<C, M, R> {
        fluent_builders::GetMobileDeviceAccessOverride::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccessControlRules` operation.
    ///
    /// See [`ListAccessControlRules`](crate::client::fluent_builders::ListAccessControlRules) for more information about the
    /// operation and its arguments.
    pub fn list_access_control_rules(&self) -> fluent_builders::ListAccessControlRules<C, M, R> {
        fluent_builders::ListAccessControlRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAliases` operation.
    ///
    /// See [`ListAliases`](crate::client::fluent_builders::ListAliases) for more information about the
    /// operation and its arguments.
    pub fn list_aliases(&self) -> fluent_builders::ListAliases<C, M, R> {
        fluent_builders::ListAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroupMembers` operation.
    ///
    /// See [`ListGroupMembers`](crate::client::fluent_builders::ListGroupMembers) for more information about the
    /// operation and its arguments.
    pub fn list_group_members(&self) -> fluent_builders::ListGroupMembers<C, M, R> {
        fluent_builders::ListGroupMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroups` operation.
    ///
    /// See [`ListGroups`](crate::client::fluent_builders::ListGroups) for more information about the
    /// operation and its arguments.
    pub fn list_groups(&self) -> fluent_builders::ListGroups<C, M, R> {
        fluent_builders::ListGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMailboxExportJobs` operation.
    ///
    /// See [`ListMailboxExportJobs`](crate::client::fluent_builders::ListMailboxExportJobs) for more information about the
    /// operation and its arguments.
    pub fn list_mailbox_export_jobs(&self) -> fluent_builders::ListMailboxExportJobs<C, M, R> {
        fluent_builders::ListMailboxExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMailboxPermissions` operation.
    ///
    /// See [`ListMailboxPermissions`](crate::client::fluent_builders::ListMailboxPermissions) for more information about the
    /// operation and its arguments.
    pub fn list_mailbox_permissions(&self) -> fluent_builders::ListMailboxPermissions<C, M, R> {
        fluent_builders::ListMailboxPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMailDomains` operation.
    ///
    /// See [`ListMailDomains`](crate::client::fluent_builders::ListMailDomains) for more information about the
    /// operation and its arguments.
    pub fn list_mail_domains(&self) -> fluent_builders::ListMailDomains<C, M, R> {
        fluent_builders::ListMailDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMobileDeviceAccessOverrides` operation.
    ///
    /// See [`ListMobileDeviceAccessOverrides`](crate::client::fluent_builders::ListMobileDeviceAccessOverrides) for more information about the
    /// operation and its arguments.
    pub fn list_mobile_device_access_overrides(
        &self,
    ) -> fluent_builders::ListMobileDeviceAccessOverrides<C, M, R> {
        fluent_builders::ListMobileDeviceAccessOverrides::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMobileDeviceAccessRules` operation.
    ///
    /// See [`ListMobileDeviceAccessRules`](crate::client::fluent_builders::ListMobileDeviceAccessRules) for more information about the
    /// operation and its arguments.
    pub fn list_mobile_device_access_rules(
        &self,
    ) -> fluent_builders::ListMobileDeviceAccessRules<C, M, R> {
        fluent_builders::ListMobileDeviceAccessRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOrganizations` operation.
    ///
    /// See [`ListOrganizations`](crate::client::fluent_builders::ListOrganizations) for more information about the
    /// operation and its arguments.
    pub fn list_organizations(&self) -> fluent_builders::ListOrganizations<C, M, R> {
        fluent_builders::ListOrganizations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourceDelegates` operation.
    ///
    /// See [`ListResourceDelegates`](crate::client::fluent_builders::ListResourceDelegates) for more information about the
    /// operation and its arguments.
    pub fn list_resource_delegates(&self) -> fluent_builders::ListResourceDelegates<C, M, R> {
        fluent_builders::ListResourceDelegates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResources` operation.
    ///
    /// See [`ListResources`](crate::client::fluent_builders::ListResources) for more information about the
    /// operation and its arguments.
    pub fn list_resources(&self) -> fluent_builders::ListResources<C, M, R> {
        fluent_builders::ListResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUsers` operation.
    ///
    /// See [`ListUsers`](crate::client::fluent_builders::ListUsers) for more information about the
    /// operation and its arguments.
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAccessControlRule` operation.
    ///
    /// See [`PutAccessControlRule`](crate::client::fluent_builders::PutAccessControlRule) for more information about the
    /// operation and its arguments.
    pub fn put_access_control_rule(&self) -> fluent_builders::PutAccessControlRule<C, M, R> {
        fluent_builders::PutAccessControlRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutInboundDmarcSettings` operation.
    ///
    /// See [`PutInboundDmarcSettings`](crate::client::fluent_builders::PutInboundDmarcSettings) for more information about the
    /// operation and its arguments.
    pub fn put_inbound_dmarc_settings(&self) -> fluent_builders::PutInboundDmarcSettings<C, M, R> {
        fluent_builders::PutInboundDmarcSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutMailboxPermissions` operation.
    ///
    /// See [`PutMailboxPermissions`](crate::client::fluent_builders::PutMailboxPermissions) for more information about the
    /// operation and its arguments.
    pub fn put_mailbox_permissions(&self) -> fluent_builders::PutMailboxPermissions<C, M, R> {
        fluent_builders::PutMailboxPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutMobileDeviceAccessOverride` operation.
    ///
    /// See [`PutMobileDeviceAccessOverride`](crate::client::fluent_builders::PutMobileDeviceAccessOverride) for more information about the
    /// operation and its arguments.
    pub fn put_mobile_device_access_override(
        &self,
    ) -> fluent_builders::PutMobileDeviceAccessOverride<C, M, R> {
        fluent_builders::PutMobileDeviceAccessOverride::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRetentionPolicy` operation.
    ///
    /// See [`PutRetentionPolicy`](crate::client::fluent_builders::PutRetentionPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_retention_policy(&self) -> fluent_builders::PutRetentionPolicy<C, M, R> {
        fluent_builders::PutRetentionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterMailDomain` operation.
    ///
    /// See [`RegisterMailDomain`](crate::client::fluent_builders::RegisterMailDomain) for more information about the
    /// operation and its arguments.
    pub fn register_mail_domain(&self) -> fluent_builders::RegisterMailDomain<C, M, R> {
        fluent_builders::RegisterMailDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterToWorkMail` operation.
    ///
    /// See [`RegisterToWorkMail`](crate::client::fluent_builders::RegisterToWorkMail) for more information about the
    /// operation and its arguments.
    pub fn register_to_work_mail(&self) -> fluent_builders::RegisterToWorkMail<C, M, R> {
        fluent_builders::RegisterToWorkMail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetPassword` operation.
    ///
    /// See [`ResetPassword`](crate::client::fluent_builders::ResetPassword) for more information about the
    /// operation and its arguments.
    pub fn reset_password(&self) -> fluent_builders::ResetPassword<C, M, R> {
        fluent_builders::ResetPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartMailboxExportJob` operation.
    ///
    /// See [`StartMailboxExportJob`](crate::client::fluent_builders::StartMailboxExportJob) for more information about the
    /// operation and its arguments.
    pub fn start_mailbox_export_job(&self) -> fluent_builders::StartMailboxExportJob<C, M, R> {
        fluent_builders::StartMailboxExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDefaultMailDomain` operation.
    ///
    /// See [`UpdateDefaultMailDomain`](crate::client::fluent_builders::UpdateDefaultMailDomain) for more information about the
    /// operation and its arguments.
    pub fn update_default_mail_domain(&self) -> fluent_builders::UpdateDefaultMailDomain<C, M, R> {
        fluent_builders::UpdateDefaultMailDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMailboxQuota` operation.
    ///
    /// See [`UpdateMailboxQuota`](crate::client::fluent_builders::UpdateMailboxQuota) for more information about the
    /// operation and its arguments.
    pub fn update_mailbox_quota(&self) -> fluent_builders::UpdateMailboxQuota<C, M, R> {
        fluent_builders::UpdateMailboxQuota::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMobileDeviceAccessRule` operation.
    ///
    /// See [`UpdateMobileDeviceAccessRule`](crate::client::fluent_builders::UpdateMobileDeviceAccessRule) for more information about the
    /// operation and its arguments.
    pub fn update_mobile_device_access_rule(
        &self,
    ) -> fluent_builders::UpdateMobileDeviceAccessRule<C, M, R> {
        fluent_builders::UpdateMobileDeviceAccessRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePrimaryEmailAddress` operation.
    ///
    /// See [`UpdatePrimaryEmailAddress`](crate::client::fluent_builders::UpdatePrimaryEmailAddress) for more information about the
    /// operation and its arguments.
    pub fn update_primary_email_address(
        &self,
    ) -> fluent_builders::UpdatePrimaryEmailAddress<C, M, R> {
        fluent_builders::UpdatePrimaryEmailAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResource` operation.
    ///
    /// See [`UpdateResource`](crate::client::fluent_builders::UpdateResource) for more information about the
    /// operation and its arguments.
    pub fn update_resource(&self) -> fluent_builders::UpdateResource<C, M, R> {
        fluent_builders::UpdateResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateDelegateToResource`.
    ///
    /// <p>Adds a member (user or group) to the resource's set of delegates.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateDelegateToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_delegate_to_resource_input::Builder,
    }
    impl<C, M, R> AssociateDelegateToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateDelegateToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDelegateToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDelegateToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateDelegateToResourceInputOperationOutputAlias,
                crate::output::AssociateDelegateToResourceOutput,
                crate::error::AssociateDelegateToResourceError,
                crate::input::AssociateDelegateToResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization under which the resource exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization under which the resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The resource for which members (users or groups) are associated.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The resource for which members (users or groups) are associated.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The member (user or group) to associate to the resource.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The member (user or group) to associate to the resource.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateMemberToGroup`.
    ///
    /// <p>Adds a member (user or group) to the group's set.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateMemberToGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_member_to_group_input::Builder,
    }
    impl<C, M, R> AssociateMemberToGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateMemberToGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateMemberToGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateMemberToGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateMemberToGroupInputOperationOutputAlias,
                crate::output::AssociateMemberToGroupOutput,
                crate::error::AssociateMemberToGroupError,
                crate::input::AssociateMemberToGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization under which the group exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The group to which the member (user or group) is associated.</p>
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// <p>The group to which the member (user or group) is associated.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p>The member (user or group) to associate to the group.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The member (user or group) to associate to the group.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelMailboxExportJob`.
    ///
    /// <p>Cancels a mailbox export job.</p>
    /// <note>
    /// <p>If the mailbox export job is near completion, it might not be possible to cancel
    /// it.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CancelMailboxExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_mailbox_export_job_input::Builder,
    }
    impl<C, M, R> CancelMailboxExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelMailboxExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelMailboxExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelMailboxExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelMailboxExportJobInputOperationOutputAlias,
                crate::output::CancelMailboxExportJobOutput,
                crate::error::CancelMailboxExportJobError,
                crate::input::CancelMailboxExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The job ID.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAlias`.
    ///
    /// <p>Adds an alias to the set of a given member (user or group) of Amazon WorkMail.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_alias_input::Builder,
    }
    impl<C, M, R> CreateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAliasInputOperationOutputAlias,
                crate::output::CreateAliasOutput,
                crate::error::CreateAliasError,
                crate::input::CreateAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization under which the member (user or group) exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization under which the member (user or group) exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The member (user or group) to which this alias is added.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The member (user or group) to which this alias is added.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The alias to add to the member set.</p>
        pub fn alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(inp);
            self
        }
        /// <p>The alias to add to the member set.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// <p>Creates a group that can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_input::Builder,
    }
    impl<C, M, R> CreateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupInputOperationOutputAlias,
                crate::output::CreateGroupOutput,
                crate::error::CreateGroupError,
                crate::input::CreateGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization under which the group is to be created.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization under which the group is to be created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The name of the group.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMobileDeviceAccessRule`.
    ///
    /// <p>Creates a new mobile device access rule for the specified Amazon WorkMail organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMobileDeviceAccessRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_mobile_device_access_rule_input::Builder,
    }
    impl<C, M, R> CreateMobileDeviceAccessRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMobileDeviceAccessRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMobileDeviceAccessRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMobileDeviceAccessRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMobileDeviceAccessRuleInputOperationOutputAlias,
                crate::output::CreateMobileDeviceAccessRuleOutput,
                crate::error::CreateMobileDeviceAccessRuleError,
                crate::input::CreateMobileDeviceAccessRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization under which the rule will be created.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization under which the rule will be created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The rule name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The rule name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, inp: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.inner = self.inner.effect(inp);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.inner = self.inner.set_effect(input);
            self
        }
        /// Appends an item to `DeviceTypes`.
        ///
        /// To override the contents of this collection use [`set_device_types`](Self::set_device_types).
        ///
        /// <p>Device types that the rule will match.</p>
        pub fn device_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_types(inp);
            self
        }
        /// <p>Device types that the rule will match.</p>
        pub fn set_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_types(input);
            self
        }
        /// Appends an item to `NotDeviceTypes`.
        ///
        /// To override the contents of this collection use [`set_not_device_types`](Self::set_not_device_types).
        ///
        /// <p>Device types that the rule <b>will not</b> match. All other device types will match.</p>
        pub fn not_device_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_types(inp);
            self
        }
        /// <p>Device types that the rule <b>will not</b> match. All other device types will match.</p>
        pub fn set_not_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_types(input);
            self
        }
        /// Appends an item to `DeviceModels`.
        ///
        /// To override the contents of this collection use [`set_device_models`](Self::set_device_models).
        ///
        /// <p>Device models that the rule will match.</p>
        pub fn device_models(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_models(inp);
            self
        }
        /// <p>Device models that the rule will match.</p>
        pub fn set_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_models(input);
            self
        }
        /// Appends an item to `NotDeviceModels`.
        ///
        /// To override the contents of this collection use [`set_not_device_models`](Self::set_not_device_models).
        ///
        /// <p>Device models that the rule <b>will not</b> match. All other device models will match.</p>
        pub fn not_device_models(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_models(inp);
            self
        }
        /// <p>Device models that the rule <b>will not</b> match. All other device models will match.</p>
        pub fn set_not_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_models(input);
            self
        }
        /// Appends an item to `DeviceOperatingSystems`.
        ///
        /// To override the contents of this collection use [`set_device_operating_systems`](Self::set_device_operating_systems).
        ///
        /// <p>Device operating systems that the rule will match.</p>
        pub fn device_operating_systems(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_operating_systems(inp);
            self
        }
        /// <p>Device operating systems that the rule will match.</p>
        pub fn set_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_operating_systems(input);
            self
        }
        /// Appends an item to `NotDeviceOperatingSystems`.
        ///
        /// To override the contents of this collection use [`set_not_device_operating_systems`](Self::set_not_device_operating_systems).
        ///
        /// <p>Device operating systems that the rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn not_device_operating_systems(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_operating_systems(inp);
            self
        }
        /// <p>Device operating systems that the rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn set_not_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_operating_systems(input);
            self
        }
        /// Appends an item to `DeviceUserAgents`.
        ///
        /// To override the contents of this collection use [`set_device_user_agents`](Self::set_device_user_agents).
        ///
        /// <p>Device user agents that the rule will match.</p>
        pub fn device_user_agents(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_user_agents(inp);
            self
        }
        /// <p>Device user agents that the rule will match.</p>
        pub fn set_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_user_agents(input);
            self
        }
        /// Appends an item to `NotDeviceUserAgents`.
        ///
        /// To override the contents of this collection use [`set_not_device_user_agents`](Self::set_not_device_user_agents).
        ///
        /// <p>Device user agents that the rule <b>will not</b> match. All other device user agents will match.</p>
        pub fn not_device_user_agents(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_user_agents(inp);
            self
        }
        /// <p>Device user agents that the rule <b>will not</b> match. All other device user agents will match.</p>
        pub fn set_not_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_user_agents(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOrganization`.
    ///
    /// <p>Creates a new Amazon WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias must match the directory alias. If you choose not to associate an existing directory with your organization, then we create a new Amazon WorkMail directory for you. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an organization</a> in the <i>Amazon WorkMail Administrator Guide</i>.</p>
    /// <p>You can associate multiple email domains with an organization, then set your default email domain from the Amazon WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a domain</a> and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the default domain</a> in the <i>Amazon WorkMail Administrator Guide</i>.</p>
    /// <p>Optionally, you can use a customer managed master key from AWS Key Management Service
    /// (AWS KMS) to encrypt email for your organization. If you don't associate an AWS KMS key, Amazon WorkMail creates a
    /// default AWS managed master key for you.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_organization_input::Builder,
    }
    impl<C, M, R> CreateOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOrganizationInputOperationOutputAlias,
                crate::output::CreateOrganizationOutput,
                crate::error::CreateOrganizationError,
                crate::input::CreateOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Directory Service directory ID.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The AWS Directory Service directory ID.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>The organization alias.</p>
        pub fn alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(inp);
            self
        }
        /// <p>The organization alias.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>The email domains to associate with the organization.</p>
        pub fn domains(mut self, inp: impl Into<crate::model::Domain>) -> Self {
            self.inner = self.inner.domains(inp);
            self
        }
        /// <p>The email domains to associate with the organization.</p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Domain>>,
        ) -> Self {
            self.inner = self.inner.set_domains(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a customer managed master key from AWS
        /// KMS.</p>
        pub fn kms_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a customer managed master key from AWS
        /// KMS.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the request.</p>
        pub fn enable_interoperability(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_interoperability(inp);
            self
        }
        /// <p>When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the request.</p>
        pub fn set_enable_interoperability(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_interoperability(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResource`.
    ///
    /// <p>Creates a new Amazon WorkMail resource. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_input::Builder,
    }
    impl<C, M, R> CreateResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceInputOperationOutputAlias,
                crate::output::CreateResourceOutput,
                crate::error::CreateResourceError,
                crate::input::CreateResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the organization for which the resource is
        /// created.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier associated with the organization for which the resource is
        /// created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of the new resource. The available types are <code>equipment</code> and
        /// <code>room</code>.</p>
        pub fn r#type(mut self, inp: crate::model::ResourceType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the new resource. The available types are <code>equipment</code> and
        /// <code>room</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ResourceType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a user who can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the organization for which the user is created.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier of the organization for which the user is created.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The display name for the new user.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The display name for the new user.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The password for the new user.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password for the new user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessControlRule`.
    ///
    /// <p>Deletes an access control rule for the specified WorkMail organization.</p>
    /// <note>
    /// <p>Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccessControlRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_access_control_rule_input::Builder,
    }
    impl<C, M, R> DeleteAccessControlRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccessControlRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessControlRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessControlRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccessControlRuleInputOperationOutputAlias,
                crate::output::DeleteAccessControlRuleOutput,
                crate::error::DeleteAccessControlRuleError,
                crate::input::DeleteAccessControlRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The name of the access control rule.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the access control rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlias`.
    ///
    /// <p>Remove one or more specified aliases from a set of aliases for a given
    /// user.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_alias_input::Builder,
    }
    impl<C, M, R> DeleteAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAliasInputOperationOutputAlias,
                crate::output::DeleteAliasOutput,
                crate::error::DeleteAliasError,
                crate::input::DeleteAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the member (user or group) from which to have the aliases
        /// removed.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The identifier for the member (user or group) from which to have the aliases
        /// removed.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The aliases to be removed from the user's set of aliases. Duplicate entries in the
        /// list are collapsed into single entries (the list is transformed into a set).</p>
        pub fn alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(inp);
            self
        }
        /// <p>The aliases to be removed from the user's set of aliases. Duplicate entries in the
        /// list are collapsed into single entries (the list is transformed into a set).</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// <p>Deletes a group from Amazon WorkMail.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl<C, M, R> DeleteGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupInputOperationOutputAlias,
                crate::output::DeleteGroupOutput,
                crate::error::DeleteGroupError,
                crate::input::DeleteGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization that contains the group.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization that contains the group.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the group to be deleted.</p>
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// <p>The identifier of the group to be deleted.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMailboxPermissions`.
    ///
    /// <p>Deletes permissions granted to a member (user or group).</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMailboxPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_mailbox_permissions_input::Builder,
    }
    impl<C, M, R> DeleteMailboxPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMailboxPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMailboxPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMailboxPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMailboxPermissionsInputOperationOutputAlias,
                crate::output::DeleteMailboxPermissionsOutput,
                crate::error::DeleteMailboxPermissionsError,
                crate::input::DeleteMailboxPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the organization under which the member (user or group)
        /// exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier of the organization under which the member (user or group)
        /// exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the member (user or group) that owns the mailbox.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The identifier of the member (user or group) that owns the mailbox.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The identifier of the member (user or group) for which to delete granted
        /// permissions.</p>
        pub fn grantee_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grantee_id(inp);
            self
        }
        /// <p>The identifier of the member (user or group) for which to delete granted
        /// permissions.</p>
        pub fn set_grantee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grantee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMobileDeviceAccessOverride`.
    ///
    /// <p>Deletes the mobile device access override for the given WorkMail organization, user, and device.</p>
    /// <note>
    /// <p>Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMobileDeviceAccessOverride<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_mobile_device_access_override_input::Builder,
    }
    impl<C, M, R> DeleteMobileDeviceAccessOverride<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMobileDeviceAccessOverride`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMobileDeviceAccessOverrideOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMobileDeviceAccessOverrideError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMobileDeviceAccessOverrideInputOperationOutputAlias,
                crate::output::DeleteMobileDeviceAccessOverrideOutput,
                crate::error::DeleteMobileDeviceAccessOverrideError,
                crate::input::DeleteMobileDeviceAccessOverrideInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which the access override will be deleted.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization for which the access override will be deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The WorkMail user for which you want to delete the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li>
        /// <p>User ID:  <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Email address: <code>user@domain.tld</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>User name: <code>user</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The WorkMail user for which you want to delete the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li>
        /// <p>User ID:  <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Email address: <code>user@domain.tld</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>User name: <code>user</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(inp);
            self
        }
        /// <p>The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMobileDeviceAccessRule`.
    ///
    /// <p>Deletes a mobile device access rule for the specified Amazon WorkMail organization.</p>
    /// <note>
    /// <p>Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMobileDeviceAccessRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_mobile_device_access_rule_input::Builder,
    }
    impl<C, M, R> DeleteMobileDeviceAccessRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMobileDeviceAccessRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMobileDeviceAccessRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMobileDeviceAccessRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMobileDeviceAccessRuleInputOperationOutputAlias,
                crate::output::DeleteMobileDeviceAccessRuleOutput,
                crate::error::DeleteMobileDeviceAccessRuleError,
                crate::input::DeleteMobileDeviceAccessRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization under which the rule will be deleted.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization under which the rule will be deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the rule to be deleted.</p>
        pub fn mobile_device_access_rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mobile_device_access_rule_id(inp);
            self
        }
        /// <p>The identifier of the rule to be deleted.</p>
        pub fn set_mobile_device_access_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mobile_device_access_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOrganization`.
    ///
    /// <p>Deletes an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of the organization. You can choose whether to delete the associated directory. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an organization</a> in the <i>Amazon WorkMail Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_organization_input::Builder,
    }
    impl<C, M, R> DeleteOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOrganizationInputOperationOutputAlias,
                crate::output::DeleteOrganizationOutput,
                crate::error::DeleteOrganizationError,
                crate::input::DeleteOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>If true, deletes the AWS Directory Service directory associated with the organization.</p>
        pub fn delete_directory(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_directory(inp);
            self
        }
        /// <p>If true, deletes the AWS Directory Service directory associated with the organization.</p>
        pub fn set_delete_directory(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_directory(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResource`.
    ///
    /// <p>Deletes the specified resource. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_input::Builder,
    }
    impl<C, M, R> DeleteResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceInputOperationOutputAlias,
                crate::output::DeleteResourceOutput,
                crate::error::DeleteResourceError,
                crate::input::DeleteResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the organization from which the resource is
        /// deleted.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier associated with the organization from which the resource is
        /// deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the resource to be deleted.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The identifier of the resource to be deleted.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRetentionPolicy`.
    ///
    /// <p>Deletes the specified retention policy from the specified organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRetentionPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_retention_policy_input::Builder,
    }
    impl<C, M, R> DeleteRetentionPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRetentionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRetentionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRetentionPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRetentionPolicyInputOperationOutputAlias,
                crate::output::DeleteRetentionPolicyOutput,
                crate::error::DeleteRetentionPolicyError,
                crate::input::DeleteRetentionPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a
    /// user, the user state must be <code>DISABLED</code>. Use the <a>DescribeUser</a>
    /// action to confirm the user state.</p>
    /// <p>Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for
    /// 30 days before they are permanently removed.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization that contains the user to be deleted.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization that contains the user to be deleted.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the user to be deleted.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier of the user to be deleted.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterFromWorkMail`.
    ///
    /// <p>Mark a user, group, or resource as no longer used in Amazon WorkMail. This action
    /// disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days
    /// before they are permanently removed. The functionality in the console is
    /// <i>Disable</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterFromWorkMail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_from_work_mail_input::Builder,
    }
    impl<C, M, R> DeregisterFromWorkMail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterFromWorkMail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterFromWorkMailOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterFromWorkMailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterFromWorkMailInputOperationOutputAlias,
                crate::output::DeregisterFromWorkMailOutput,
                crate::error::DeregisterFromWorkMailError,
                crate::input::DeregisterFromWorkMailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the Amazon WorkMail entity exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the Amazon WorkMail entity exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the member (user or group) to be updated.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The identifier for the member (user or group) to be updated.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterMailDomain`.
    ///
    /// <p>Removes a domain from Amazon WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail use. SES keeps the domain because other applications may use it. You must first
    /// remove any email address used by WorkMail entities before you remove the domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterMailDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_mail_domain_input::Builder,
    }
    impl<C, M, R> DeregisterMailDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterMailDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterMailDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterMailDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterMailDomainInputOperationOutputAlias,
                crate::output::DeregisterMailDomainOutput,
                crate::error::DeregisterMailDomainError,
                crate::input::DeregisterMailDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which the domain will be deregistered.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization for which the domain will be deregistered.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The domain to deregister in WorkMail and SES. </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain to deregister in WorkMail and SES. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGroup`.
    ///
    /// <p>Returns the data available for the group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_group_input::Builder,
    }
    impl<C, M, R> DescribeGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGroupInputOperationOutputAlias,
                crate::output::DescribeGroupOutput,
                crate::error::DescribeGroupError,
                crate::input::DescribeGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the group to be described.</p>
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// <p>The identifier for the group to be described.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInboundDmarcSettings`.
    ///
    /// <p>Lists the settings in a DMARC policy for a specified organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInboundDmarcSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_inbound_dmarc_settings_input::Builder,
    }
    impl<C, M, R> DescribeInboundDmarcSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInboundDmarcSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInboundDmarcSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInboundDmarcSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInboundDmarcSettingsInputOperationOutputAlias,
                crate::output::DescribeInboundDmarcSettingsOutput,
                crate::error::DescribeInboundDmarcSettingsError,
                crate::input::DescribeInboundDmarcSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Lists the ID of the given organization.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>Lists the ID of the given organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMailboxExportJob`.
    ///
    /// <p>Describes the current status of a mailbox export job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMailboxExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_mailbox_export_job_input::Builder,
    }
    impl<C, M, R> DescribeMailboxExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMailboxExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMailboxExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMailboxExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMailboxExportJobInputOperationOutputAlias,
                crate::output::DescribeMailboxExportJobOutput,
                crate::error::DescribeMailboxExportJobError,
                crate::input::DescribeMailboxExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The mailbox export job ID.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The mailbox export job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganization`.
    ///
    /// <p>Provides more information regarding a given organization based on its
    /// identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_input::Builder,
    }
    impl<C, M, R> DescribeOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationInputOperationOutputAlias,
                crate::output::DescribeOrganizationOutput,
                crate::error::DescribeOrganizationError,
                crate::input::DescribeOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization to be described.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization to be described.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResource`.
    ///
    /// <p>Returns the data available for the resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resource_input::Builder,
    }
    impl<C, M, R> DescribeResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResourceInputOperationOutputAlias,
                crate::output::DescribeResourceOutput,
                crate::error::DescribeResourceError,
                crate::input::DescribeResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the organization for which the resource is
        /// described.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier associated with the organization for which the resource is
        /// described.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the resource to be described.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The identifier of the resource to be described.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUser`.
    ///
    /// <p>Provides information regarding the user.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_input::Builder,
    }
    impl<C, M, R> DescribeUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserInputOperationOutputAlias,
                crate::output::DescribeUserOutput,
                crate::error::DescribeUserError,
                crate::input::DescribeUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the user exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the user to be described.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier for the user to be described.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateDelegateFromResource`.
    ///
    /// <p>Removes a member from the resource's set of delegates.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateDelegateFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_delegate_from_resource_input::Builder,
    }
    impl<C, M, R> DisassociateDelegateFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateDelegateFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDelegateFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDelegateFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateDelegateFromResourceInputOperationOutputAlias,
                crate::output::DisassociateDelegateFromResourceOutput,
                crate::error::DisassociateDelegateFromResourceError,
                crate::input::DisassociateDelegateFromResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the resource exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the resource exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the resource from which delegates' set members are removed.
        /// </p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The identifier of the resource from which delegates' set members are removed.
        /// </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The identifier for the member (user, group) to be removed from the resource's
        /// delegates.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The identifier for the member (user, group) to be removed from the resource's
        /// delegates.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateMemberFromGroup`.
    ///
    /// <p>Removes a member from a group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateMemberFromGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_member_from_group_input::Builder,
    }
    impl<C, M, R> DisassociateMemberFromGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateMemberFromGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMemberFromGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMemberFromGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateMemberFromGroupInputOperationOutputAlias,
                crate::output::DisassociateMemberFromGroupOutput,
                crate::error::DisassociateMemberFromGroupError,
                crate::input::DisassociateMemberFromGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the group from which members are removed.</p>
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// <p>The identifier for the group from which members are removed.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p>The identifier for the member to be removed to the group.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The identifier for the member to be removed to the group.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessControlEffect`.
    ///
    /// <p>Gets the effects of an organization's access control rules as they apply to a
    /// specified IPv4 address, access protocol action, or user ID. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessControlEffect<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_control_effect_input::Builder,
    }
    impl<C, M, R> GetAccessControlEffect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessControlEffect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessControlEffectOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessControlEffectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessControlEffectInputOperationOutputAlias,
                crate::output::GetAccessControlEffectOutput,
                crate::error::GetAccessControlEffectError,
                crate::input::GetAccessControlEffectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The IPv4 address.</p>
        pub fn ip_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_address(inp);
            self
        }
        /// <p>The IPv4 address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
        /// <p>The access protocol action. Valid values include <code>ActiveSync</code>,
        /// <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
        /// <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn action(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>The access protocol action. Valid values include <code>ActiveSync</code>,
        /// <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>,
        /// <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDefaultRetentionPolicy`.
    ///
    /// <p>Gets the default retention policy details for the specified organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDefaultRetentionPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_default_retention_policy_input::Builder,
    }
    impl<C, M, R> GetDefaultRetentionPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDefaultRetentionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDefaultRetentionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDefaultRetentionPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDefaultRetentionPolicyInputOperationOutputAlias,
                crate::output::GetDefaultRetentionPolicyOutput,
                crate::error::GetDefaultRetentionPolicyError,
                crate::input::GetDefaultRetentionPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMailboxDetails`.
    ///
    /// <p>Requests a user's mailbox details for a specified organization and user.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMailboxDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_mailbox_details_input::Builder,
    }
    impl<C, M, R> GetMailboxDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMailboxDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMailboxDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMailboxDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMailboxDetailsInputOperationOutputAlias,
                crate::output::GetMailboxDetailsOutput,
                crate::error::GetMailboxDetailsError,
                crate::input::GetMailboxDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization that contains the user whose mailbox details are
        /// being requested.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization that contains the user whose mailbox details are
        /// being requested.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the user whose mailbox details are being requested.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier for the user whose mailbox details are being requested.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMailDomain`.
    ///
    /// <p>Gets details for a mail domain, including domain records required to configure your domain with recommended security.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMailDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_mail_domain_input::Builder,
    }
    impl<C, M, R> GetMailDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMailDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMailDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMailDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMailDomainInputOperationOutputAlias,
                crate::output::GetMailDomainOutput,
                crate::error::GetMailDomainError,
                crate::input::GetMailDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which the domain is retrieved.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization for which the domain is retrieved.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The domain from which you want to retrieve details.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain from which you want to retrieve details.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMobileDeviceAccessEffect`.
    ///
    /// <p>Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access
    /// rules for the Amazon WorkMail organization for a particular user's attributes.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMobileDeviceAccessEffect<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_mobile_device_access_effect_input::Builder,
    }
    impl<C, M, R> GetMobileDeviceAccessEffect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMobileDeviceAccessEffect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMobileDeviceAccessEffectOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMobileDeviceAccessEffectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMobileDeviceAccessEffectInputOperationOutputAlias,
                crate::output::GetMobileDeviceAccessEffectOutput,
                crate::error::GetMobileDeviceAccessEffectError,
                crate::input::GetMobileDeviceAccessEffectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization to simulate the access effect for.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization to simulate the access effect for.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>Device type the simulated user will report.</p>
        pub fn device_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_type(inp);
            self
        }
        /// <p>Device type the simulated user will report.</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_type(input);
            self
        }
        /// <p>Device model the simulated user will report.</p>
        pub fn device_model(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_model(inp);
            self
        }
        /// <p>Device model the simulated user will report.</p>
        pub fn set_device_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_model(input);
            self
        }
        /// <p>Device operating system the simulated user will report.</p>
        pub fn device_operating_system(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_operating_system(inp);
            self
        }
        /// <p>Device operating system the simulated user will report.</p>
        pub fn set_device_operating_system(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_operating_system(input);
            self
        }
        /// <p>Device user agent the simulated user will report.</p>
        pub fn device_user_agent(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_user_agent(inp);
            self
        }
        /// <p>Device user agent the simulated user will report.</p>
        pub fn set_device_user_agent(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_user_agent(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMobileDeviceAccessOverride`.
    ///
    /// <p>Gets the mobile device access override for the given WorkMail organization, user, and device.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMobileDeviceAccessOverride<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_mobile_device_access_override_input::Builder,
    }
    impl<C, M, R> GetMobileDeviceAccessOverride<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMobileDeviceAccessOverride`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMobileDeviceAccessOverrideOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMobileDeviceAccessOverrideError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMobileDeviceAccessOverrideInputOperationOutputAlias,
                crate::output::GetMobileDeviceAccessOverrideOutput,
                crate::error::GetMobileDeviceAccessOverrideError,
                crate::input::GetMobileDeviceAccessOverrideInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization to which you want to apply the override.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization to which you want to apply the override.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>Identifies the WorkMail user for the override. Accepts the following types of user identities: </p>
        /// <ul>
        /// <li>
        /// <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Email address: <code>user@domain.tld</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>User name: <code>user</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>Identifies the WorkMail user for the override. Accepts the following types of user identities: </p>
        /// <ul>
        /// <li>
        /// <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Email address: <code>user@domain.tld</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>User name: <code>user</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The mobile device to which the override applies. <code>DeviceId</code> is case insensitive.</p>
        pub fn device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(inp);
            self
        }
        /// <p>The mobile device to which the override applies. <code>DeviceId</code> is case insensitive.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessControlRules`.
    ///
    /// <p>Lists the access control rules for the specified organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccessControlRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_access_control_rules_input::Builder,
    }
    impl<C, M, R> ListAccessControlRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccessControlRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessControlRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessControlRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccessControlRulesInputOperationOutputAlias,
                crate::output::ListAccessControlRulesOutput,
                crate::error::ListAccessControlRulesError,
                crate::input::ListAccessControlRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAliases`.
    ///
    /// <p>Creates a paginated call to list the aliases associated with a given
    /// entity.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_aliases_input::Builder,
    }
    impl<C, M, R> ListAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAliasesInputOperationOutputAlias,
                crate::output::ListAliasesOutput,
                crate::error::ListAliasesError,
                crate::input::ListAliasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the entity exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the entity exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the entity for which to list the aliases.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The identifier for the entity for which to list the aliases.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupMembers`.
    ///
    /// <p>Returns an overview of the members of a group. Users and groups can be members of a
    /// group.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGroupMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_group_members_input::Builder,
    }
    impl<C, M, R> ListGroupMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroupMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupMembersInputOperationOutputAlias,
                crate::output::ListGroupMembersOutput,
                crate::error::ListGroupMembersError,
                crate::input::ListGroupMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the group exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the group to which the members (users or groups) are
        /// associated.</p>
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// <p>The identifier for the group to which the members (users or groups) are
        /// associated.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p> The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroups`.
    ///
    /// <p>Returns summaries of the organization's groups.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_groups_input::Builder,
    }
    impl<C, M, R> ListGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupsInputOperationOutputAlias,
                crate::output::ListGroupsOutput,
                crate::error::ListGroupsError,
                crate::input::ListGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the groups exist.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the groups exist.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMailboxExportJobs`.
    ///
    /// <p>Lists the mailbox export jobs started for the specified organization within the last
    /// seven days.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMailboxExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_mailbox_export_jobs_input::Builder,
    }
    impl<C, M, R> ListMailboxExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMailboxExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMailboxExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMailboxExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMailboxExportJobsInputOperationOutputAlias,
                crate::output::ListMailboxExportJobsOutput,
                crate::error::ListMailboxExportJobsError,
                crate::input::ListMailboxExportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMailboxPermissions`.
    ///
    /// <p>Lists the mailbox permissions associated with a user, group, or resource
    /// mailbox.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMailboxPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_mailbox_permissions_input::Builder,
    }
    impl<C, M, R> ListMailboxPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMailboxPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMailboxPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMailboxPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMailboxPermissionsInputOperationOutputAlias,
                crate::output::ListMailboxPermissionsOutput,
                crate::error::ListMailboxPermissionsError,
                crate::input::ListMailboxPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the organization under which the user, group, or resource
        /// exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier of the organization under which the user, group, or resource
        /// exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the user, group, or resource for which to list mailbox
        /// permissions.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The identifier of the user, group, or resource for which to list mailbox
        /// permissions.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMailDomains`.
    ///
    /// <p>Lists the mail domains in a given Amazon WorkMail organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMailDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_mail_domains_input::Builder,
    }
    impl<C, M, R> ListMailDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMailDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMailDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMailDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMailDomainsInputOperationOutputAlias,
                crate::output::ListMailDomainsOutput,
                crate::error::ListMailDomainsError,
                crate::input::ListMailDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMobileDeviceAccessOverrides`.
    ///
    /// <p>Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMobileDeviceAccessOverrides<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_mobile_device_access_overrides_input::Builder,
    }
    impl<C, M, R> ListMobileDeviceAccessOverrides<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMobileDeviceAccessOverrides`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMobileDeviceAccessOverridesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMobileDeviceAccessOverridesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMobileDeviceAccessOverridesInputOperationOutputAlias,
                crate::output::ListMobileDeviceAccessOverridesOutput,
                crate::error::ListMobileDeviceAccessOverridesError,
                crate::input::ListMobileDeviceAccessOverridesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization under which to list mobile device access overrides.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization under which to list mobile device access overrides.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li>
        /// <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Email address: <code>user@domain.tld</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>User name: <code>user</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li>
        /// <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Email address: <code>user@domain.tld</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>User name: <code>user</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The mobile device to which the access override applies.</p>
        pub fn device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(inp);
            self
        }
        /// <p>The mobile device to which the access override applies.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not require a token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMobileDeviceAccessRules`.
    ///
    /// <p>Lists the mobile device access rules for the specified Amazon WorkMail organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMobileDeviceAccessRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_mobile_device_access_rules_input::Builder,
    }
    impl<C, M, R> ListMobileDeviceAccessRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMobileDeviceAccessRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMobileDeviceAccessRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMobileDeviceAccessRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMobileDeviceAccessRulesInputOperationOutputAlias,
                crate::output::ListMobileDeviceAccessRulesOutput,
                crate::error::ListMobileDeviceAccessRulesError,
                crate::input::ListMobileDeviceAccessRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which to list the rules.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization for which to list the rules.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizations`.
    ///
    /// <p>Returns summaries of the customer's organizations.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOrganizations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_organizations_input::Builder,
    }
    impl<C, M, R> ListOrganizations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOrganizations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOrganizationsInputOperationOutputAlias,
                crate::output::ListOrganizationsOutput,
                crate::error::ListOrganizationsError,
                crate::input::ListOrganizationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceDelegates`.
    ///
    /// <p>Lists the delegates associated with a resource. Users and groups can be resource
    /// delegates and answer requests on behalf of the resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResourceDelegates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_delegates_input::Builder,
    }
    impl<C, M, R> ListResourceDelegates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceDelegates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceDelegatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceDelegatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceDelegatesInputOperationOutputAlias,
                crate::output::ListResourceDelegatesOutput,
                crate::error::ListResourceDelegatesError,
                crate::input::ListResourceDelegatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization that contains the resource for which delegates
        /// are listed.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization that contains the resource for which delegates
        /// are listed.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the resource whose delegates are listed.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The identifier for the resource whose delegates are listed.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The token used to paginate through the delegates associated with a
        /// resource.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token used to paginate through the delegates associated with a
        /// resource.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of maximum results in a page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of maximum results in a page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResources`.
    ///
    /// <p>Returns summaries of the organization's resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resources_input::Builder,
    }
    impl<C, M, R> ListResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourcesInputOperationOutputAlias,
                crate::output::ListResourcesOutput,
                crate::error::ListResourcesError,
                crate::input::ListResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the resources exist.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the resources exist.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags applied to an Amazon WorkMail organization resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Returns summaries of the organization's users.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the users exist.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the users exist.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results. The first call does not
        /// contain any tokens.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccessControlRule`.
    ///
    /// <p>Adds a new access control rule for the specified organization. The rule allows or
    /// denies access to the organization for the specified IPv4 addresses, access protocol
    /// actions, and user IDs. Adding a new rule with the same name as an existing rule replaces
    /// the older rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAccessControlRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_access_control_rule_input::Builder,
    }
    impl<C, M, R> PutAccessControlRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAccessControlRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccessControlRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccessControlRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAccessControlRuleInputOperationOutputAlias,
                crate::output::PutAccessControlRuleOutput,
                crate::error::PutAccessControlRuleError,
                crate::input::PutAccessControlRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The rule name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The rule effect.</p>
        pub fn effect(mut self, inp: crate::model::AccessControlRuleEffect) -> Self {
            self.inner = self.inner.effect(inp);
            self
        }
        /// <p>The rule effect.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::AccessControlRuleEffect>,
        ) -> Self {
            self.inner = self.inner.set_effect(input);
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `IpRanges`.
        ///
        /// To override the contents of this collection use [`set_ip_ranges`](Self::set_ip_ranges).
        ///
        /// <p>IPv4 CIDR ranges to include in the rule.</p>
        pub fn ip_ranges(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_ranges(inp);
            self
        }
        /// <p>IPv4 CIDR ranges to include in the rule.</p>
        pub fn set_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ip_ranges(input);
            self
        }
        /// Appends an item to `NotIpRanges`.
        ///
        /// To override the contents of this collection use [`set_not_ip_ranges`](Self::set_not_ip_ranges).
        ///
        /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
        pub fn not_ip_ranges(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_ip_ranges(inp);
            self
        }
        /// <p>IPv4 CIDR ranges to exclude from the rule.</p>
        pub fn set_not_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_ip_ranges(input);
            self
        }
        /// Appends an item to `Actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>Access protocol actions to include in the rule. Valid values include
        /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
        /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn actions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.actions(inp);
            self
        }
        /// <p>Access protocol actions to include in the rule. Valid values include
        /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
        /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// Appends an item to `NotActions`.
        ///
        /// To override the contents of this collection use [`set_not_actions`](Self::set_not_actions).
        ///
        /// <p>Access protocol actions to exclude from the rule. Valid values include
        /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
        /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn not_actions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_actions(inp);
            self
        }
        /// <p>Access protocol actions to exclude from the rule. Valid values include
        /// <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>,
        /// <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>
        pub fn set_not_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_actions(input);
            self
        }
        /// Appends an item to `UserIds`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>User IDs to include in the rule.</p>
        pub fn user_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_ids(inp);
            self
        }
        /// <p>User IDs to include in the rule.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_ids(input);
            self
        }
        /// Appends an item to `NotUserIds`.
        ///
        /// To override the contents of this collection use [`set_not_user_ids`](Self::set_not_user_ids).
        ///
        /// <p>User IDs to exclude from the rule.</p>
        pub fn not_user_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_user_ids(inp);
            self
        }
        /// <p>User IDs to exclude from the rule.</p>
        pub fn set_not_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_user_ids(input);
            self
        }
        /// <p>The identifier of the organization.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutInboundDmarcSettings`.
    ///
    /// <p>Enables or disables a DMARC policy for a given organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutInboundDmarcSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_inbound_dmarc_settings_input::Builder,
    }
    impl<C, M, R> PutInboundDmarcSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutInboundDmarcSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutInboundDmarcSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutInboundDmarcSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutInboundDmarcSettingsInputOperationOutputAlias,
                crate::output::PutInboundDmarcSettingsOutput,
                crate::error::PutInboundDmarcSettingsError,
                crate::input::PutInboundDmarcSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the organization that you are applying the DMARC policy to. </p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The ID of the organization that you are applying the DMARC policy to. </p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>Enforces or suspends a policy after it's applied.</p>
        pub fn enforced(mut self, inp: bool) -> Self {
            self.inner = self.inner.enforced(inp);
            self
        }
        /// <p>Enforces or suspends a policy after it's applied.</p>
        pub fn set_enforced(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enforced(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMailboxPermissions`.
    ///
    /// <p>Sets permissions for a user, group, or resource. This replaces any pre-existing
    /// permissions.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutMailboxPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_mailbox_permissions_input::Builder,
    }
    impl<C, M, R> PutMailboxPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutMailboxPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMailboxPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMailboxPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutMailboxPermissionsInputOperationOutputAlias,
                crate::output::PutMailboxPermissionsOutput,
                crate::error::PutMailboxPermissionsError,
                crate::input::PutMailboxPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the organization under which the user, group, or resource
        /// exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier of the organization under which the user, group, or resource
        /// exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the user, group, or resource for which to update mailbox
        /// permissions.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The identifier of the user, group, or resource for which to update mailbox
        /// permissions.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The identifier of the user, group, or resource to which to grant the
        /// permissions.</p>
        pub fn grantee_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grantee_id(inp);
            self
        }
        /// <p>The identifier of the user, group, or resource to which to grant the
        /// permissions.</p>
        pub fn set_grantee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grantee_id(input);
            self
        }
        /// Appends an item to `PermissionValues`.
        ///
        /// To override the contents of this collection use [`set_permission_values`](Self::set_permission_values).
        ///
        /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as
        /// the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
        /// allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
        /// mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
        /// access to the mailbox, irrespective of other folder-level permissions set on the
        /// mailbox.</p>
        pub fn permission_values(mut self, inp: impl Into<crate::model::PermissionType>) -> Self {
            self.inner = self.inner.permission_values(inp);
            self
        }
        /// <p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as
        /// the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
        /// allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
        /// mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
        /// access to the mailbox, irrespective of other folder-level permissions set on the
        /// mailbox.</p>
        pub fn set_permission_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
        ) -> Self {
            self.inner = self.inner.set_permission_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMobileDeviceAccessOverride`.
    ///
    /// <p>Creates or updates a mobile device access override for the given WorkMail organization, user, and device.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutMobileDeviceAccessOverride<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_mobile_device_access_override_input::Builder,
    }
    impl<C, M, R> PutMobileDeviceAccessOverride<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutMobileDeviceAccessOverride`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMobileDeviceAccessOverrideOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMobileDeviceAccessOverrideError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutMobileDeviceAccessOverrideInputOperationOutputAlias,
                crate::output::PutMobileDeviceAccessOverrideOutput,
                crate::error::PutMobileDeviceAccessOverrideError,
                crate::input::PutMobileDeviceAccessOverrideInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the Amazon WorkMail organization for which you create the override.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>Identifies the Amazon WorkMail organization for which you create the override.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The WorkMail user for which you create the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li>
        /// <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Email address: <code>user@domain.tld</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>User name: <code>user</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The WorkMail user for which you create the override. Accepts the following types of user identities:</p>
        /// <ul>
        /// <li>
        /// <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Email address: <code>user@domain.tld</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>User name: <code>user</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The mobile device for which you create the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(inp);
            self
        }
        /// <p>The mobile device for which you create the override. <code>DeviceId</code> is case insensitive.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, inp: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.inner = self.inner.effect(inp);
            self
        }
        /// <p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.inner = self.inner.set_effect(input);
            self
        }
        /// <p>A description of the override.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the override.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRetentionPolicy`.
    ///
    /// <p>Puts a retention policy to the specified organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutRetentionPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_retention_policy_input::Builder,
    }
    impl<C, M, R> PutRetentionPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRetentionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRetentionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRetentionPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRetentionPolicyInputOperationOutputAlias,
                crate::output::PutRetentionPolicyOutput,
                crate::error::PutRetentionPolicyError,
                crate::input::PutRetentionPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization ID.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization ID.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The retention policy ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The retention policy name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The retention policy name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The retention policy description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The retention policy description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `FolderConfigurations`.
        ///
        /// To override the contents of this collection use [`set_folder_configurations`](Self::set_folder_configurations).
        ///
        /// <p>The retention policy folder configurations.</p>
        pub fn folder_configurations(
            mut self,
            inp: impl Into<crate::model::FolderConfiguration>,
        ) -> Self {
            self.inner = self.inner.folder_configurations(inp);
            self
        }
        /// <p>The retention policy folder configurations.</p>
        pub fn set_folder_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_folder_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterMailDomain`.
    ///
    /// <p>Registers a new domain in Amazon WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for this domain are routed to the specified WorkMail organization, and WorkMail has
    /// permanent permission to use the specified domain for sending your users' emails.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterMailDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_mail_domain_input::Builder,
    }
    impl<C, M, R> RegisterMailDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterMailDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterMailDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterMailDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterMailDomainInputOperationOutputAlias,
                crate::output::RegisterMailDomainOutput,
                crate::error::RegisterMailDomainError,
                crate::input::RegisterMailDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Idempotency token used when retrying requests.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Idempotency token used when retrying requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon WorkMail organization under which you're creating the domain.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization under which you're creating the domain.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The name of the mail domain to create in Amazon WorkMail and SES.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the mail domain to create in Amazon WorkMail and SES.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterToWorkMail`.
    ///
    /// <p>Registers an existing and disabled user, group, or resource for Amazon WorkMail use by
    /// associating a mailbox and calendaring capabilities. It performs no change if the user,
    /// group, or resource is enabled and fails if the user, group, or resource is deleted. This
    /// operation results in the accumulation of costs. For more information, see <a href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console
    /// functionality for this operation is <i>Enable</i>. </p>
    /// <p>Users can either be created by calling the <a>CreateUser</a> API operation
    /// or they can be synchronized from your directory. For more information, see <a>DeregisterFromWorkMail</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterToWorkMail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_to_work_mail_input::Builder,
    }
    impl<C, M, R> RegisterToWorkMail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterToWorkMail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterToWorkMailOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterToWorkMailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterToWorkMailInputOperationOutputAlias,
                crate::output::RegisterToWorkMailOutput,
                crate::error::RegisterToWorkMailError,
                crate::input::RegisterToWorkMailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization under which the user, group, or resource
        /// exists.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization under which the user, group, or resource
        /// exists.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier for the user, group, or resource to be updated.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The identifier for the user, group, or resource to be updated.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The email for the user, group, or resource to be updated.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email for the user, group, or resource to be updated.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetPassword`.
    ///
    /// <p>Allows the administrator to reset the password for a user.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetPassword<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_password_input::Builder,
    }
    impl<C, M, R> ResetPassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetPasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetPasswordInputOperationOutputAlias,
                crate::output::ResetPasswordOutput,
                crate::error::ResetPasswordError,
                crate::input::ResetPasswordInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the organization that contains the user for which the password is
        /// reset.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier of the organization that contains the user for which the password is
        /// reset.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the user for whom the password is reset.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier of the user for whom the password is reset.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The new password for the user.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The new password for the user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMailboxExportJob`.
    ///
    /// <p>Starts a mailbox export job to export MIME-format email messages and calendar items
    /// from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3)
    /// bucket. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content</a> in
    /// the <i>Amazon WorkMail Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartMailboxExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_mailbox_export_job_input::Builder,
    }
    impl<C, M, R> StartMailboxExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartMailboxExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMailboxExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMailboxExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartMailboxExportJobInputOperationOutputAlias,
                crate::output::StartMailboxExportJobOutput,
                crate::error::StartMailboxExportJobError,
                crate::input::StartMailboxExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for the client request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The identifier associated with the organization.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier associated with the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the user or resource associated with the mailbox.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The identifier of the user or resource associated with the mailbox.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The mailbox export job description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The mailbox export job description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3
        /// bucket.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3
        /// bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS)
        /// key that encrypts the exported mailbox content.</p>
        pub fn kms_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS)
        /// key that encrypts the exported mailbox content.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn s3_bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(inp);
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>The S3 bucket prefix.</p>
        pub fn s3_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_prefix(inp);
            self
        }
        /// <p>The S3 bucket prefix.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies the specified tags to the specified Amazon WorkMail organization
    /// resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Untags the specified tags from the specified Amazon WorkMail organization
    /// resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDefaultMailDomain`.
    ///
    /// <p>Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console to suggest an email address when enabling a mail user. You can only have one default domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDefaultMailDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_default_mail_domain_input::Builder,
    }
    impl<C, M, R> UpdateDefaultMailDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDefaultMailDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDefaultMailDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDefaultMailDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDefaultMailDomainInputOperationOutputAlias,
                crate::output::UpdateDefaultMailDomainOutput,
                crate::error::UpdateDefaultMailDomainError,
                crate::input::UpdateDefaultMailDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization for which to list domains.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The domain name that will become the default domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain name that will become the default domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMailboxQuota`.
    ///
    /// <p>Updates a user's current mailbox quota for a specified organization and
    /// user.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMailboxQuota<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_mailbox_quota_input::Builder,
    }
    impl<C, M, R> UpdateMailboxQuota<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMailboxQuota`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMailboxQuotaOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMailboxQuotaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMailboxQuotaInputOperationOutputAlias,
                crate::output::UpdateMailboxQuotaOutput,
                crate::error::UpdateMailboxQuotaError,
                crate::input::UpdateMailboxQuotaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the organization that contains the user for whom to update the
        /// mailbox quota.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier for the organization that contains the user for whom to update the
        /// mailbox quota.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifer for the user for whom to update the mailbox quota.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifer for the user for whom to update the mailbox quota.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The updated mailbox quota, in MB, for the specified user.</p>
        pub fn mailbox_quota(mut self, inp: i32) -> Self {
            self.inner = self.inner.mailbox_quota(inp);
            self
        }
        /// <p>The updated mailbox quota, in MB, for the specified user.</p>
        pub fn set_mailbox_quota(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_mailbox_quota(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMobileDeviceAccessRule`.
    ///
    /// <p>Updates a mobile device access rule for the specified Amazon WorkMail organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMobileDeviceAccessRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_mobile_device_access_rule_input::Builder,
    }
    impl<C, M, R> UpdateMobileDeviceAccessRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMobileDeviceAccessRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMobileDeviceAccessRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMobileDeviceAccessRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMobileDeviceAccessRuleInputOperationOutputAlias,
                crate::output::UpdateMobileDeviceAccessRuleOutput,
                crate::error::UpdateMobileDeviceAccessRuleError,
                crate::input::UpdateMobileDeviceAccessRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkMail organization under which the rule will be updated.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The Amazon WorkMail organization under which the rule will be updated.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the rule to be updated.</p>
        pub fn mobile_device_access_rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mobile_device_access_rule_id(inp);
            self
        }
        /// <p>The identifier of the rule to be updated.</p>
        pub fn set_mobile_device_access_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mobile_device_access_rule_id(input);
            self
        }
        /// <p>The updated rule name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The updated rule name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated rule description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn effect(mut self, inp: crate::model::MobileDeviceAccessRuleEffect) -> Self {
            self.inner = self.inner.effect(inp);
            self
        }
        /// <p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>
        pub fn set_effect(
            mut self,
            input: std::option::Option<crate::model::MobileDeviceAccessRuleEffect>,
        ) -> Self {
            self.inner = self.inner.set_effect(input);
            self
        }
        /// Appends an item to `DeviceTypes`.
        ///
        /// To override the contents of this collection use [`set_device_types`](Self::set_device_types).
        ///
        /// <p>Device types that the updated rule will match.</p>
        pub fn device_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_types(inp);
            self
        }
        /// <p>Device types that the updated rule will match.</p>
        pub fn set_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_types(input);
            self
        }
        /// Appends an item to `NotDeviceTypes`.
        ///
        /// To override the contents of this collection use [`set_not_device_types`](Self::set_not_device_types).
        ///
        /// <p>Device types that the updated rule <b>will not</b> match. All other device types will match.</p>
        pub fn not_device_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_types(inp);
            self
        }
        /// <p>Device types that the updated rule <b>will not</b> match. All other device types will match.</p>
        pub fn set_not_device_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_types(input);
            self
        }
        /// Appends an item to `DeviceModels`.
        ///
        /// To override the contents of this collection use [`set_device_models`](Self::set_device_models).
        ///
        /// <p>Device models that the updated rule will match.</p>
        pub fn device_models(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_models(inp);
            self
        }
        /// <p>Device models that the updated rule will match.</p>
        pub fn set_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_models(input);
            self
        }
        /// Appends an item to `NotDeviceModels`.
        ///
        /// To override the contents of this collection use [`set_not_device_models`](Self::set_not_device_models).
        ///
        /// <p>Device models that the updated rule <b>will not</b> match. All other device models will match.</p>
        pub fn not_device_models(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_models(inp);
            self
        }
        /// <p>Device models that the updated rule <b>will not</b> match. All other device models will match.</p>
        pub fn set_not_device_models(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_models(input);
            self
        }
        /// Appends an item to `DeviceOperatingSystems`.
        ///
        /// To override the contents of this collection use [`set_device_operating_systems`](Self::set_device_operating_systems).
        ///
        /// <p>Device operating systems that the updated rule will match.</p>
        pub fn device_operating_systems(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_operating_systems(inp);
            self
        }
        /// <p>Device operating systems that the updated rule will match.</p>
        pub fn set_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_operating_systems(input);
            self
        }
        /// Appends an item to `NotDeviceOperatingSystems`.
        ///
        /// To override the contents of this collection use [`set_not_device_operating_systems`](Self::set_not_device_operating_systems).
        ///
        /// <p>Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn not_device_operating_systems(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_operating_systems(inp);
            self
        }
        /// <p>Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will match.</p>
        pub fn set_not_device_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_operating_systems(input);
            self
        }
        /// Appends an item to `DeviceUserAgents`.
        ///
        /// To override the contents of this collection use [`set_device_user_agents`](Self::set_device_user_agents).
        ///
        /// <p>User agents that the updated rule will match.</p>
        pub fn device_user_agents(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_user_agents(inp);
            self
        }
        /// <p>User agents that the updated rule will match.</p>
        pub fn set_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_user_agents(input);
            self
        }
        /// Appends an item to `NotDeviceUserAgents`.
        ///
        /// To override the contents of this collection use [`set_not_device_user_agents`](Self::set_not_device_user_agents).
        ///
        /// <p>User agents that the updated rule <b>will not</b> match. All other user agents will match.</p>
        pub fn not_device_user_agents(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.not_device_user_agents(inp);
            self
        }
        /// <p>User agents that the updated rule <b>will not</b> match. All other user agents will match.</p>
        pub fn set_not_device_user_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_not_device_user_agents(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePrimaryEmailAddress`.
    ///
    /// <p>Updates the primary email for a user, group, or resource. The current email is moved
    /// into the list of aliases (or swapped between an existing alias and the current primary
    /// email), and the email provided in the input is promoted as the primary.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePrimaryEmailAddress<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_primary_email_address_input::Builder,
    }
    impl<C, M, R> UpdatePrimaryEmailAddress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePrimaryEmailAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePrimaryEmailAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePrimaryEmailAddressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePrimaryEmailAddressInputOperationOutputAlias,
                crate::output::UpdatePrimaryEmailAddressOutput,
                crate::error::UpdatePrimaryEmailAddressError,
                crate::input::UpdatePrimaryEmailAddressInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The organization that contains the user, group, or resource to update.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The organization that contains the user, group, or resource to update.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The user, group, or resource to update.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>The user, group, or resource to update.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The value of the email to be updated as primary.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The value of the email to be updated as primary.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResource`.
    ///
    /// <p>Updates data for the resource. To have the latest information, it must be preceded by
    /// a <a>DescribeResource</a> call. The dataset in the request should be the one
    /// expected when performing another <code>DescribeResource</code> call.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_input::Builder,
    }
    impl<C, M, R> UpdateResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceInputOperationOutputAlias,
                crate::output::UpdateResourceOutput,
                crate::error::UpdateResourceError,
                crate::input::UpdateResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the organization for which the resource is
        /// updated.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The identifier associated with the organization for which the resource is
        /// updated.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The identifier of the resource to be updated.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The identifier of the resource to be updated.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The name of the resource to be updated.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the resource to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The resource's booking options to be updated.</p>
        pub fn booking_options(mut self, inp: crate::model::BookingOptions) -> Self {
            self.inner = self.inner.booking_options(inp);
            self
        }
        /// <p>The resource's booking options to be updated.</p>
        pub fn set_booking_options(
            mut self,
            input: std::option::Option<crate::model::BookingOptions>,
        ) -> Self {
            self.inner = self.inner.set_booking_options(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
