// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon WorkLink
///
/// Client for invoking operations on Amazon WorkLink. Each operation on Amazon WorkLink is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_worklink::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_worklink::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_worklink::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateDomain`](crate::client::fluent_builders::AssociateDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateDomain::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::AssociateDomain::set_fleet_arn): <p>The Amazon Resource Name (ARN) of the fleet.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::AssociateDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::AssociateDomain::set_domain_name): <p>The fully qualified domain name (FQDN).</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::AssociateDomain::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::AssociateDomain::set_display_name): <p>The name to display.</p>
    ///   - [`acm_certificate_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateDomain::acm_certificate_arn) / [`set_acm_certificate_arn(Option<String>)`](crate::client::fluent_builders::AssociateDomain::set_acm_certificate_arn): <p>The ARN of an issued ACM certificate that is valid for the domain being associated.</p>
    /// - On success, responds with [`AssociateDomainOutput`](crate::output::AssociateDomainOutput)

    /// - On failure, responds with [`SdkError<AssociateDomainError>`](crate::error::AssociateDomainError)
    pub fn associate_domain(&self) -> fluent_builders::AssociateDomain {
        fluent_builders::AssociateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateWebsiteAuthorizationProvider`](crate::client::fluent_builders::AssociateWebsiteAuthorizationProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateWebsiteAuthorizationProvider::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::AssociateWebsiteAuthorizationProvider::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`authorization_provider_type(AuthorizationProviderType)`](crate::client::fluent_builders::AssociateWebsiteAuthorizationProvider::authorization_provider_type) / [`set_authorization_provider_type(Option<AuthorizationProviderType>)`](crate::client::fluent_builders::AssociateWebsiteAuthorizationProvider::set_authorization_provider_type): <p>The authorization provider type.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::AssociateWebsiteAuthorizationProvider::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::AssociateWebsiteAuthorizationProvider::set_domain_name): <p>The domain name of the authorization provider. This applies only to SAML-based authorization providers.</p>
    /// - On success, responds with [`AssociateWebsiteAuthorizationProviderOutput`](crate::output::AssociateWebsiteAuthorizationProviderOutput) with field(s):
    ///   - [`authorization_provider_id(Option<String>)`](crate::output::AssociateWebsiteAuthorizationProviderOutput::authorization_provider_id): <p>A unique identifier for the authorization provider.</p>
    /// - On failure, responds with [`SdkError<AssociateWebsiteAuthorizationProviderError>`](crate::error::AssociateWebsiteAuthorizationProviderError)
    pub fn associate_website_authorization_provider(
        &self,
    ) -> fluent_builders::AssociateWebsiteAuthorizationProvider {
        fluent_builders::AssociateWebsiteAuthorizationProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateWebsiteCertificateAuthority`](crate::client::fluent_builders::AssociateWebsiteCertificateAuthority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateWebsiteCertificateAuthority::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::AssociateWebsiteCertificateAuthority::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`certificate(impl Into<String>)`](crate::client::fluent_builders::AssociateWebsiteCertificateAuthority::certificate) / [`set_certificate(Option<String>)`](crate::client::fluent_builders::AssociateWebsiteCertificateAuthority::set_certificate): <p>The root certificate of the CA.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::AssociateWebsiteCertificateAuthority::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::AssociateWebsiteCertificateAuthority::set_display_name): <p>The certificate name to display.</p>
    /// - On success, responds with [`AssociateWebsiteCertificateAuthorityOutput`](crate::output::AssociateWebsiteCertificateAuthorityOutput) with field(s):
    ///   - [`website_ca_id(Option<String>)`](crate::output::AssociateWebsiteCertificateAuthorityOutput::website_ca_id): <p>A unique identifier for the CA.</p>
    /// - On failure, responds with [`SdkError<AssociateWebsiteCertificateAuthorityError>`](crate::error::AssociateWebsiteCertificateAuthorityError)
    pub fn associate_website_certificate_authority(
        &self,
    ) -> fluent_builders::AssociateWebsiteCertificateAuthority {
        fluent_builders::AssociateWebsiteCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFleet`](crate::client::fluent_builders::CreateFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_name(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::fleet_name) / [`set_fleet_name(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_fleet_name): <p>A unique name for the fleet.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_display_name): <p>The fleet name to display.</p>
    ///   - [`optimize_for_end_user_location(bool)`](crate::client::fluent_builders::CreateFleet::optimize_for_end_user_location) / [`set_optimize_for_end_user_location(Option<bool>)`](crate::client::fluent_builders::CreateFleet::set_optimize_for_end_user_location): <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateFleet::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateFleet::set_tags): <p> The tags to add to the resource. A tag is a key-value pair.</p>
    /// - On success, responds with [`CreateFleetOutput`](crate::output::CreateFleetOutput) with field(s):
    ///   - [`fleet_arn(Option<String>)`](crate::output::CreateFleetOutput::fleet_arn): <p>The Amazon Resource Name (ARN) of the fleet.</p>
    /// - On failure, responds with [`SdkError<CreateFleetError>`](crate::error::CreateFleetError)
    pub fn create_fleet(&self) -> fluent_builders::CreateFleet {
        fluent_builders::CreateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFleet`](crate::client::fluent_builders::DeleteFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteFleet::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DeleteFleet::set_fleet_arn): <p>The ARN of the fleet.</p>
    /// - On success, responds with [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)

    /// - On failure, responds with [`SdkError<DeleteFleetError>`](crate::error::DeleteFleetError)
    pub fn delete_fleet(&self) -> fluent_builders::DeleteFleet {
        fluent_builders::DeleteFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAuditStreamConfiguration`](crate::client::fluent_builders::DescribeAuditStreamConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAuditStreamConfiguration::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DescribeAuditStreamConfiguration::set_fleet_arn): <p>The ARN of the fleet.</p>
    /// - On success, responds with [`DescribeAuditStreamConfigurationOutput`](crate::output::DescribeAuditStreamConfigurationOutput) with field(s):
    ///   - [`audit_stream_arn(Option<String>)`](crate::output::DescribeAuditStreamConfigurationOutput::audit_stream_arn): <p>The ARN of the Amazon Kinesis data stream that will receive the audit events.</p>
    /// - On failure, responds with [`SdkError<DescribeAuditStreamConfigurationError>`](crate::error::DescribeAuditStreamConfigurationError)
    pub fn describe_audit_stream_configuration(
        &self,
    ) -> fluent_builders::DescribeAuditStreamConfiguration {
        fluent_builders::DescribeAuditStreamConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCompanyNetworkConfiguration`](crate::client::fluent_builders::DescribeCompanyNetworkConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeCompanyNetworkConfiguration::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DescribeCompanyNetworkConfiguration::set_fleet_arn): <p>The ARN of the fleet.</p>
    /// - On success, responds with [`DescribeCompanyNetworkConfigurationOutput`](crate::output::DescribeCompanyNetworkConfigurationOutput) with field(s):
    ///   - [`vpc_id(Option<String>)`](crate::output::DescribeCompanyNetworkConfigurationOutput::vpc_id): <p>The VPC with connectivity to associated websites.</p>
    ///   - [`subnet_ids(Option<Vec<String>>)`](crate::output::DescribeCompanyNetworkConfigurationOutput::subnet_ids): <p>The subnets used for X-ENI connections from Amazon WorkLink rendering containers.</p>
    ///   - [`security_group_ids(Option<Vec<String>>)`](crate::output::DescribeCompanyNetworkConfigurationOutput::security_group_ids): <p>The security groups associated with access to the provided subnets.</p>
    /// - On failure, responds with [`SdkError<DescribeCompanyNetworkConfigurationError>`](crate::error::DescribeCompanyNetworkConfigurationError)
    pub fn describe_company_network_configuration(
        &self,
    ) -> fluent_builders::DescribeCompanyNetworkConfiguration {
        fluent_builders::DescribeCompanyNetworkConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDevice`](crate::client::fluent_builders::DescribeDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeDevice::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DescribeDevice::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDevice::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::DescribeDevice::set_device_id): <p>A unique identifier for a registered user's device.</p>
    /// - On success, responds with [`DescribeDeviceOutput`](crate::output::DescribeDeviceOutput) with field(s):
    ///   - [`status(Option<DeviceStatus>)`](crate::output::DescribeDeviceOutput::status): <p>The current state of the device.</p>
    ///   - [`model(Option<String>)`](crate::output::DescribeDeviceOutput::model): <p>The model of the device.</p>
    ///   - [`manufacturer(Option<String>)`](crate::output::DescribeDeviceOutput::manufacturer): <p>The manufacturer of the device.</p>
    ///   - [`operating_system(Option<String>)`](crate::output::DescribeDeviceOutput::operating_system): <p>The operating system of the device.</p>
    ///   - [`operating_system_version(Option<String>)`](crate::output::DescribeDeviceOutput::operating_system_version): <p>The operating system version of the device.</p>
    ///   - [`patch_level(Option<String>)`](crate::output::DescribeDeviceOutput::patch_level): <p>The operating system patch level of the device.</p>
    ///   - [`first_accessed_time(Option<DateTime>)`](crate::output::DescribeDeviceOutput::first_accessed_time): <p>The date that the device first signed in to Amazon WorkLink.</p>
    ///   - [`last_accessed_time(Option<DateTime>)`](crate::output::DescribeDeviceOutput::last_accessed_time): <p>The date that the device last accessed Amazon WorkLink.</p>
    ///   - [`username(Option<String>)`](crate::output::DescribeDeviceOutput::username): <p>The user name associated with the device.</p>
    /// - On failure, responds with [`SdkError<DescribeDeviceError>`](crate::error::DescribeDeviceError)
    pub fn describe_device(&self) -> fluent_builders::DescribeDevice {
        fluent_builders::DescribeDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDevicePolicyConfiguration`](crate::client::fluent_builders::DescribeDevicePolicyConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeDevicePolicyConfiguration::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DescribeDevicePolicyConfiguration::set_fleet_arn): <p>The ARN of the fleet.</p>
    /// - On success, responds with [`DescribeDevicePolicyConfigurationOutput`](crate::output::DescribeDevicePolicyConfigurationOutput) with field(s):
    ///   - [`device_ca_certificate(Option<String>)`](crate::output::DescribeDevicePolicyConfigurationOutput::device_ca_certificate): <p>The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.</p>
    /// - On failure, responds with [`SdkError<DescribeDevicePolicyConfigurationError>`](crate::error::DescribeDevicePolicyConfigurationError)
    pub fn describe_device_policy_configuration(
        &self,
    ) -> fluent_builders::DescribeDevicePolicyConfiguration {
        fluent_builders::DescribeDevicePolicyConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeDomain::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DescribeDomain::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DescribeDomain::set_domain_name): <p>The name of the domain.</p>
    /// - On success, responds with [`DescribeDomainOutput`](crate::output::DescribeDomainOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::DescribeDomainOutput::domain_name): <p>The name of the domain.</p>
    ///   - [`display_name(Option<String>)`](crate::output::DescribeDomainOutput::display_name): <p>The name to display.</p>
    ///   - [`created_time(Option<DateTime>)`](crate::output::DescribeDomainOutput::created_time): <p>The time that the domain was added.</p>
    ///   - [`domain_status(Option<DomainStatus>)`](crate::output::DescribeDomainOutput::domain_status): <p>The current state for the domain.</p>
    ///   - [`acm_certificate_arn(Option<String>)`](crate::output::DescribeDomainOutput::acm_certificate_arn): <p>The ARN of an issued ACM certificate that is valid for the domain being associated.</p>
    /// - On failure, responds with [`SdkError<DescribeDomainError>`](crate::error::DescribeDomainError)
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFleetMetadata`](crate::client::fluent_builders::DescribeFleetMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeFleetMetadata::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DescribeFleetMetadata::set_fleet_arn): <p>The Amazon Resource Name (ARN) of the fleet.</p>
    /// - On success, responds with [`DescribeFleetMetadataOutput`](crate::output::DescribeFleetMetadataOutput) with field(s):
    ///   - [`created_time(Option<DateTime>)`](crate::output::DescribeFleetMetadataOutput::created_time): <p>The time that the fleet was created.</p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::DescribeFleetMetadataOutput::last_updated_time): <p>The time that the fleet was last updated.</p>
    ///   - [`fleet_name(Option<String>)`](crate::output::DescribeFleetMetadataOutput::fleet_name): <p>The name of the fleet.</p>
    ///   - [`display_name(Option<String>)`](crate::output::DescribeFleetMetadataOutput::display_name): <p>The name to display.</p>
    ///   - [`optimize_for_end_user_location(Option<bool>)`](crate::output::DescribeFleetMetadataOutput::optimize_for_end_user_location): <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
    ///   - [`company_code(Option<String>)`](crate::output::DescribeFleetMetadataOutput::company_code): <p>The identifier used by users to sign in to the Amazon WorkLink app.</p>
    ///   - [`fleet_status(Option<FleetStatus>)`](crate::output::DescribeFleetMetadataOutput::fleet_status): <p>The current state of the fleet.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeFleetMetadataOutput::tags): <p>The tags attached to the resource. A tag is a key-value pair.</p>
    /// - On failure, responds with [`SdkError<DescribeFleetMetadataError>`](crate::error::DescribeFleetMetadataError)
    pub fn describe_fleet_metadata(&self) -> fluent_builders::DescribeFleetMetadata {
        fluent_builders::DescribeFleetMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIdentityProviderConfiguration`](crate::client::fluent_builders::DescribeIdentityProviderConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentityProviderConfiguration::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DescribeIdentityProviderConfiguration::set_fleet_arn): <p>The ARN of the fleet.</p>
    /// - On success, responds with [`DescribeIdentityProviderConfigurationOutput`](crate::output::DescribeIdentityProviderConfigurationOutput) with field(s):
    ///   - [`identity_provider_type(Option<IdentityProviderType>)`](crate::output::DescribeIdentityProviderConfigurationOutput::identity_provider_type): <p>The type of identity provider.</p>
    ///   - [`service_provider_saml_metadata(Option<String>)`](crate::output::DescribeIdentityProviderConfigurationOutput::service_provider_saml_metadata): <p>The SAML metadata document uploaded to the user’s identity provider.</p>
    ///   - [`identity_provider_saml_metadata(Option<String>)`](crate::output::DescribeIdentityProviderConfigurationOutput::identity_provider_saml_metadata): <p>The SAML metadata document provided by the user’s identity provider.</p>
    /// - On failure, responds with [`SdkError<DescribeIdentityProviderConfigurationError>`](crate::error::DescribeIdentityProviderConfigurationError)
    pub fn describe_identity_provider_configuration(
        &self,
    ) -> fluent_builders::DescribeIdentityProviderConfiguration {
        fluent_builders::DescribeIdentityProviderConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWebsiteCertificateAuthority`](crate::client::fluent_builders::DescribeWebsiteCertificateAuthority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeWebsiteCertificateAuthority::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DescribeWebsiteCertificateAuthority::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`website_ca_id(impl Into<String>)`](crate::client::fluent_builders::DescribeWebsiteCertificateAuthority::website_ca_id) / [`set_website_ca_id(Option<String>)`](crate::client::fluent_builders::DescribeWebsiteCertificateAuthority::set_website_ca_id): <p>A unique identifier for the certificate authority.</p>
    /// - On success, responds with [`DescribeWebsiteCertificateAuthorityOutput`](crate::output::DescribeWebsiteCertificateAuthorityOutput) with field(s):
    ///   - [`certificate(Option<String>)`](crate::output::DescribeWebsiteCertificateAuthorityOutput::certificate): <p>The root certificate of the certificate authority.</p>
    ///   - [`created_time(Option<DateTime>)`](crate::output::DescribeWebsiteCertificateAuthorityOutput::created_time): <p>The time that the certificate authority was added.</p>
    ///   - [`display_name(Option<String>)`](crate::output::DescribeWebsiteCertificateAuthorityOutput::display_name): <p>The certificate name to display.</p>
    /// - On failure, responds with [`SdkError<DescribeWebsiteCertificateAuthorityError>`](crate::error::DescribeWebsiteCertificateAuthorityError)
    pub fn describe_website_certificate_authority(
        &self,
    ) -> fluent_builders::DescribeWebsiteCertificateAuthority {
        fluent_builders::DescribeWebsiteCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateDomain`](crate::client::fluent_builders::DisassociateDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateDomain::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DisassociateDomain::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DisassociateDomain::set_domain_name): <p>The name of the domain.</p>
    /// - On success, responds with [`DisassociateDomainOutput`](crate::output::DisassociateDomainOutput)

    /// - On failure, responds with [`SdkError<DisassociateDomainError>`](crate::error::DisassociateDomainError)
    pub fn disassociate_domain(&self) -> fluent_builders::DisassociateDomain {
        fluent_builders::DisassociateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateWebsiteAuthorizationProvider`](crate::client::fluent_builders::DisassociateWebsiteAuthorizationProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateWebsiteAuthorizationProvider::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DisassociateWebsiteAuthorizationProvider::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`authorization_provider_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateWebsiteAuthorizationProvider::authorization_provider_id) / [`set_authorization_provider_id(Option<String>)`](crate::client::fluent_builders::DisassociateWebsiteAuthorizationProvider::set_authorization_provider_id): <p>A unique identifier for the authorization provider.</p>
    /// - On success, responds with [`DisassociateWebsiteAuthorizationProviderOutput`](crate::output::DisassociateWebsiteAuthorizationProviderOutput)

    /// - On failure, responds with [`SdkError<DisassociateWebsiteAuthorizationProviderError>`](crate::error::DisassociateWebsiteAuthorizationProviderError)
    pub fn disassociate_website_authorization_provider(
        &self,
    ) -> fluent_builders::DisassociateWebsiteAuthorizationProvider {
        fluent_builders::DisassociateWebsiteAuthorizationProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateWebsiteCertificateAuthority`](crate::client::fluent_builders::DisassociateWebsiteCertificateAuthority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateWebsiteCertificateAuthority::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::DisassociateWebsiteCertificateAuthority::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`website_ca_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateWebsiteCertificateAuthority::website_ca_id) / [`set_website_ca_id(Option<String>)`](crate::client::fluent_builders::DisassociateWebsiteCertificateAuthority::set_website_ca_id): <p>A unique identifier for the CA.</p>
    /// - On success, responds with [`DisassociateWebsiteCertificateAuthorityOutput`](crate::output::DisassociateWebsiteCertificateAuthorityOutput)

    /// - On failure, responds with [`SdkError<DisassociateWebsiteCertificateAuthorityError>`](crate::error::DisassociateWebsiteCertificateAuthorityError)
    pub fn disassociate_website_certificate_authority(
        &self,
    ) -> fluent_builders::DisassociateWebsiteCertificateAuthority {
        fluent_builders::DisassociateWebsiteCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDevices`](crate::client::fluent_builders::ListDevices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDevices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::ListDevices::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::ListDevices::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDevices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDevices::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDevices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDevices::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    /// - On success, responds with [`ListDevicesOutput`](crate::output::ListDevicesOutput) with field(s):
    ///   - [`devices(Option<Vec<DeviceSummary>>)`](crate::output::ListDevicesOutput::devices): <p>Information about the devices.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDevicesOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListDevicesError>`](crate::error::ListDevicesError)
    pub fn list_devices(&self) -> fluent_builders::ListDevices {
        fluent_builders::ListDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomains`](crate::client::fluent_builders::ListDomains) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDomains::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::ListDomains::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::ListDomains::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDomains::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDomains::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDomains::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDomains::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    /// - On success, responds with [`ListDomainsOutput`](crate::output::ListDomainsOutput) with field(s):
    ///   - [`domains(Option<Vec<DomainSummary>>)`](crate::output::ListDomainsOutput::domains): <p>Information about the domains.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDomainsOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListDomainsError>`](crate::error::ListDomainsError)
    pub fn list_domains(&self) -> fluent_builders::ListDomains {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFleets`](crate::client::fluent_builders::ListFleets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFleets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFleets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFleets::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFleets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFleets::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    /// - On success, responds with [`ListFleetsOutput`](crate::output::ListFleetsOutput) with field(s):
    ///   - [`fleet_summary_list(Option<Vec<FleetSummary>>)`](crate::output::ListFleetsOutput::fleet_summary_list): <p>The summary list of the fleets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFleetsOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListFleetsError>`](crate::error::ListFleetsError)
    pub fn list_fleets(&self) -> fluent_builders::ListFleets {
        fluent_builders::ListFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the fleet.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags attached to the resource. A tag is a key-value pair.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWebsiteAuthorizationProviders`](crate::client::fluent_builders::ListWebsiteAuthorizationProviders) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWebsiteAuthorizationProviders::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::ListWebsiteAuthorizationProviders::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::ListWebsiteAuthorizationProviders::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWebsiteAuthorizationProviders::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWebsiteAuthorizationProviders::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWebsiteAuthorizationProviders::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListWebsiteAuthorizationProviders::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    /// - On success, responds with [`ListWebsiteAuthorizationProvidersOutput`](crate::output::ListWebsiteAuthorizationProvidersOutput) with field(s):
    ///   - [`website_authorization_providers(Option<Vec<WebsiteAuthorizationProviderSummary>>)`](crate::output::ListWebsiteAuthorizationProvidersOutput::website_authorization_providers): <p>The website authorization providers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListWebsiteAuthorizationProvidersOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On failure, responds with [`SdkError<ListWebsiteAuthorizationProvidersError>`](crate::error::ListWebsiteAuthorizationProvidersError)
    pub fn list_website_authorization_providers(
        &self,
    ) -> fluent_builders::ListWebsiteAuthorizationProviders {
        fluent_builders::ListWebsiteAuthorizationProviders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWebsiteCertificateAuthorities`](crate::client::fluent_builders::ListWebsiteCertificateAuthorities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWebsiteCertificateAuthorities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::ListWebsiteCertificateAuthorities::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::ListWebsiteCertificateAuthorities::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWebsiteCertificateAuthorities::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListWebsiteCertificateAuthorities::set_max_results): <p>The maximum number of results to be included in the next page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWebsiteCertificateAuthorities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWebsiteCertificateAuthorities::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`ListWebsiteCertificateAuthoritiesOutput`](crate::output::ListWebsiteCertificateAuthoritiesOutput) with field(s):
    ///   - [`website_certificate_authorities(Option<Vec<WebsiteCaSummary>>)`](crate::output::ListWebsiteCertificateAuthoritiesOutput::website_certificate_authorities): <p>Information about the certificates.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListWebsiteCertificateAuthoritiesOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListWebsiteCertificateAuthoritiesError>`](crate::error::ListWebsiteCertificateAuthoritiesError)
    pub fn list_website_certificate_authorities(
        &self,
    ) -> fluent_builders::ListWebsiteCertificateAuthorities {
        fluent_builders::ListWebsiteCertificateAuthorities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreDomainAccess`](crate::client::fluent_builders::RestoreDomainAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreDomainAccess::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::RestoreDomainAccess::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDomainAccess::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::RestoreDomainAccess::set_domain_name): <p>The name of the domain.</p>
    /// - On success, responds with [`RestoreDomainAccessOutput`](crate::output::RestoreDomainAccessOutput)

    /// - On failure, responds with [`SdkError<RestoreDomainAccessError>`](crate::error::RestoreDomainAccessError)
    pub fn restore_domain_access(&self) -> fluent_builders::RestoreDomainAccess {
        fluent_builders::RestoreDomainAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeDomainAccess`](crate::client::fluent_builders::RevokeDomainAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::RevokeDomainAccess::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::RevokeDomainAccess::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::RevokeDomainAccess::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::RevokeDomainAccess::set_domain_name): <p>The name of the domain.</p>
    /// - On success, responds with [`RevokeDomainAccessOutput`](crate::output::RevokeDomainAccessOutput)

    /// - On failure, responds with [`SdkError<RevokeDomainAccessError>`](crate::error::RevokeDomainAccessError)
    pub fn revoke_domain_access(&self) -> fluent_builders::RevokeDomainAccess {
        fluent_builders::RevokeDomainAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SignOutUser`](crate::client::fluent_builders::SignOutUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::SignOutUser::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::SignOutUser::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::SignOutUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::SignOutUser::set_username): <p>The name of the user.</p>
    /// - On success, responds with [`SignOutUserOutput`](crate::output::SignOutUserOutput)

    /// - On failure, responds with [`SdkError<SignOutUserError>`](crate::error::SignOutUserError)
    pub fn sign_out_user(&self) -> fluent_builders::SignOutUser {
        fluent_builders::SignOutUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the fleet.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to the resource. A tag is a key-value pair.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the fleet.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tag keys to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAuditStreamConfiguration`](crate::client::fluent_builders::UpdateAuditStreamConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAuditStreamConfiguration::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::UpdateAuditStreamConfiguration::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`audit_stream_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAuditStreamConfiguration::audit_stream_arn) / [`set_audit_stream_arn(Option<String>)`](crate::client::fluent_builders::UpdateAuditStreamConfiguration::set_audit_stream_arn): <p>The ARN of the Amazon Kinesis data stream that receives the audit events.</p>
    /// - On success, responds with [`UpdateAuditStreamConfigurationOutput`](crate::output::UpdateAuditStreamConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateAuditStreamConfigurationError>`](crate::error::UpdateAuditStreamConfigurationError)
    pub fn update_audit_stream_configuration(
        &self,
    ) -> fluent_builders::UpdateAuditStreamConfiguration {
        fluent_builders::UpdateAuditStreamConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCompanyNetworkConfiguration`](crate::client::fluent_builders::UpdateCompanyNetworkConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateCompanyNetworkConfiguration::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::UpdateCompanyNetworkConfiguration::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCompanyNetworkConfiguration::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::UpdateCompanyNetworkConfiguration::set_vpc_id): <p>The VPC with connectivity to associated websites.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::UpdateCompanyNetworkConfiguration::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateCompanyNetworkConfiguration::set_subnet_ids): <p>The subnets used for X-ENI connections from Amazon WorkLink rendering containers.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::UpdateCompanyNetworkConfiguration::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateCompanyNetworkConfiguration::set_security_group_ids): <p>The security groups associated with access to the provided subnets.</p>
    /// - On success, responds with [`UpdateCompanyNetworkConfigurationOutput`](crate::output::UpdateCompanyNetworkConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateCompanyNetworkConfigurationError>`](crate::error::UpdateCompanyNetworkConfigurationError)
    pub fn update_company_network_configuration(
        &self,
    ) -> fluent_builders::UpdateCompanyNetworkConfiguration {
        fluent_builders::UpdateCompanyNetworkConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDevicePolicyConfiguration`](crate::client::fluent_builders::UpdateDevicePolicyConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateDevicePolicyConfiguration::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::UpdateDevicePolicyConfiguration::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`device_ca_certificate(impl Into<String>)`](crate::client::fluent_builders::UpdateDevicePolicyConfiguration::device_ca_certificate) / [`set_device_ca_certificate(Option<String>)`](crate::client::fluent_builders::UpdateDevicePolicyConfiguration::set_device_ca_certificate): <p>The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.</p>
    /// - On success, responds with [`UpdateDevicePolicyConfigurationOutput`](crate::output::UpdateDevicePolicyConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateDevicePolicyConfigurationError>`](crate::error::UpdateDevicePolicyConfigurationError)
    pub fn update_device_policy_configuration(
        &self,
    ) -> fluent_builders::UpdateDevicePolicyConfiguration {
        fluent_builders::UpdateDevicePolicyConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomainMetadata`](crate::client::fluent_builders::UpdateDomainMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainMetadata::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::UpdateDomainMetadata::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainMetadata::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainMetadata::set_domain_name): <p>The name of the domain.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainMetadata::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainMetadata::set_display_name): <p>The name to display.</p>
    /// - On success, responds with [`UpdateDomainMetadataOutput`](crate::output::UpdateDomainMetadataOutput)

    /// - On failure, responds with [`SdkError<UpdateDomainMetadataError>`](crate::error::UpdateDomainMetadataError)
    pub fn update_domain_metadata(&self) -> fluent_builders::UpdateDomainMetadata {
        fluent_builders::UpdateDomainMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFleetMetadata`](crate::client::fluent_builders::UpdateFleetMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFleetMetadata::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::UpdateFleetMetadata::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFleetMetadata::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateFleetMetadata::set_display_name): <p>The fleet name to display. The existing DisplayName is unset if null is passed.</p>
    ///   - [`optimize_for_end_user_location(bool)`](crate::client::fluent_builders::UpdateFleetMetadata::optimize_for_end_user_location) / [`set_optimize_for_end_user_location(Option<bool>)`](crate::client::fluent_builders::UpdateFleetMetadata::set_optimize_for_end_user_location): <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
    /// - On success, responds with [`UpdateFleetMetadataOutput`](crate::output::UpdateFleetMetadataOutput)

    /// - On failure, responds with [`SdkError<UpdateFleetMetadataError>`](crate::error::UpdateFleetMetadataError)
    pub fn update_fleet_metadata(&self) -> fluent_builders::UpdateFleetMetadata {
        fluent_builders::UpdateFleetMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIdentityProviderConfiguration`](crate::client::fluent_builders::UpdateIdentityProviderConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateIdentityProviderConfiguration::fleet_arn) / [`set_fleet_arn(Option<String>)`](crate::client::fluent_builders::UpdateIdentityProviderConfiguration::set_fleet_arn): <p>The ARN of the fleet.</p>
    ///   - [`identity_provider_type(IdentityProviderType)`](crate::client::fluent_builders::UpdateIdentityProviderConfiguration::identity_provider_type) / [`set_identity_provider_type(Option<IdentityProviderType>)`](crate::client::fluent_builders::UpdateIdentityProviderConfiguration::set_identity_provider_type): <p>The type of identity provider.</p>
    ///   - [`identity_provider_saml_metadata(impl Into<String>)`](crate::client::fluent_builders::UpdateIdentityProviderConfiguration::identity_provider_saml_metadata) / [`set_identity_provider_saml_metadata(Option<String>)`](crate::client::fluent_builders::UpdateIdentityProviderConfiguration::set_identity_provider_saml_metadata): <p>The SAML metadata document provided by the customer’s identity provider. The existing IdentityProviderSamlMetadata is unset if null is passed.</p>
    /// - On success, responds with [`UpdateIdentityProviderConfigurationOutput`](crate::output::UpdateIdentityProviderConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateIdentityProviderConfigurationError>`](crate::error::UpdateIdentityProviderConfigurationError)
    pub fn update_identity_provider_configuration(
        &self,
    ) -> fluent_builders::UpdateIdentityProviderConfiguration {
        fluent_builders::UpdateIdentityProviderConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateDomain`.
    ///
    /// <p>Specifies a domain to be associated to Amazon WorkLink.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_domain_input::Builder,
    }
    impl AssociateDomain {
        /// Creates a new `AssociateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The fully qualified domain name (FQDN).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The fully qualified domain name (FQDN).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The ARN of an issued ACM certificate that is valid for the domain being associated.</p>
        pub fn acm_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acm_certificate_arn(input.into());
            self
        }
        /// <p>The ARN of an issued ACM certificate that is valid for the domain being associated.</p>
        pub fn set_acm_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_acm_certificate_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWebsiteAuthorizationProvider`.
    ///
    /// <p>Associates a website authorization provider with a specified fleet. This is used to authorize users against associated websites in the company network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWebsiteAuthorizationProvider {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_website_authorization_provider_input::Builder,
    }
    impl AssociateWebsiteAuthorizationProvider {
        /// Creates a new `AssociateWebsiteAuthorizationProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWebsiteAuthorizationProviderOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateWebsiteAuthorizationProviderError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The authorization provider type.</p>
        pub fn authorization_provider_type(
            mut self,
            input: crate::model::AuthorizationProviderType,
        ) -> Self {
            self.inner = self.inner.authorization_provider_type(input);
            self
        }
        /// <p>The authorization provider type.</p>
        pub fn set_authorization_provider_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationProviderType>,
        ) -> Self {
            self.inner = self.inner.set_authorization_provider_type(input);
            self
        }
        /// <p>The domain name of the authorization provider. This applies only to SAML-based authorization providers.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name of the authorization provider. This applies only to SAML-based authorization providers.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWebsiteCertificateAuthority`.
    ///
    /// <p>Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated websites within the company network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWebsiteCertificateAuthority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_website_certificate_authority_input::Builder,
    }
    impl AssociateWebsiteCertificateAuthority {
        /// Creates a new `AssociateWebsiteCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWebsiteCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateWebsiteCertificateAuthorityError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The root certificate of the CA.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate(input.into());
            self
        }
        /// <p>The root certificate of the CA.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_certificate(input);
            self
        }
        /// <p>The certificate name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The certificate name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFleet`.
    ///
    /// <p>Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to authorized users who download and set up the Amazon WorkLink app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFleet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_fleet_input::Builder,
    }
    impl CreateFleet {
        /// Creates a new `CreateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFleetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name for the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(input.into());
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
        pub fn optimize_for_end_user_location(mut self, input: bool) -> Self {
            self.inner = self.inner.optimize_for_end_user_location(input);
            self
        }
        /// <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
        pub fn set_optimize_for_end_user_location(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_optimize_for_end_user_location(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags to add to the resource. A tag is a key-value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags to add to the resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFleet`.
    ///
    /// <p>Deletes a fleet. Prevents users from accessing previously associated websites. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFleet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_fleet_input::Builder,
    }
    impl DeleteFleet {
        /// Creates a new `DeleteFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFleetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuditStreamConfiguration`.
    ///
    /// <p>Describes the configuration for delivering audit streams to the customer account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuditStreamConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_audit_stream_configuration_input::Builder,
    }
    impl DescribeAuditStreamConfiguration {
        /// Creates a new `DescribeAuditStreamConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuditStreamConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuditStreamConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCompanyNetworkConfiguration`.
    ///
    /// <p>Describes the networking configuration to access the internal websites associated with the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCompanyNetworkConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_company_network_configuration_input::Builder,
    }
    impl DescribeCompanyNetworkConfiguration {
        /// Creates a new `DescribeCompanyNetworkConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCompanyNetworkConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeCompanyNetworkConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDevice`.
    ///
    /// <p>Provides information about a user's device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDevice {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_device_input::Builder,
    }
    impl DescribeDevice {
        /// Creates a new `DescribeDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeviceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>A unique identifier for a registered user's device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>A unique identifier for a registered user's device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDevicePolicyConfiguration`.
    ///
    /// <p>Describes the device policy configuration for the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDevicePolicyConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_device_policy_configuration_input::Builder,
    }
    impl DescribeDevicePolicyConfiguration {
        /// Creates a new `DescribeDevicePolicyConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDevicePolicyConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDevicePolicyConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p>Provides information about the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl DescribeDomain {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFleetMetadata`.
    ///
    /// <p>Provides basic information for the specified fleet, excluding identity provider, networking, and device configuration details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFleetMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_fleet_metadata_input::Builder,
    }
    impl DescribeFleetMetadata {
        /// Creates a new `DescribeFleetMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFleetMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFleetMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentityProviderConfiguration`.
    ///
    /// <p>Describes the identity provider configuration of the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIdentityProviderConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_identity_provider_configuration_input::Builder,
    }
    impl DescribeIdentityProviderConfiguration {
        /// Creates a new `DescribeIdentityProviderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityProviderConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeIdentityProviderConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWebsiteCertificateAuthority`.
    ///
    /// <p>Provides information about the certificate authority.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWebsiteCertificateAuthority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_website_certificate_authority_input::Builder,
    }
    impl DescribeWebsiteCertificateAuthority {
        /// Creates a new `DescribeWebsiteCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWebsiteCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeWebsiteCertificateAuthorityError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>A unique identifier for the certificate authority.</p>
        pub fn website_ca_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.website_ca_id(input.into());
            self
        }
        /// <p>A unique identifier for the certificate authority.</p>
        pub fn set_website_ca_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_website_ca_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateDomain`.
    ///
    /// <p>Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon WorkLink. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_domain_input::Builder,
    }
    impl DisassociateDomain {
        /// Creates a new `DisassociateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWebsiteAuthorizationProvider`.
    ///
    /// <p>Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load any associated websites that require this authorization provider.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWebsiteAuthorizationProvider {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_website_authorization_provider_input::Builder,
    }
    impl DisassociateWebsiteAuthorizationProvider {
        /// Creates a new `DisassociateWebsiteAuthorizationProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWebsiteAuthorizationProviderOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWebsiteAuthorizationProviderError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>A unique identifier for the authorization provider.</p>
        pub fn authorization_provider_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorization_provider_id(input.into());
            self
        }
        /// <p>A unique identifier for the authorization provider.</p>
        pub fn set_authorization_provider_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorization_provider_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWebsiteCertificateAuthority`.
    ///
    /// <p>Removes a certificate authority (CA).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWebsiteCertificateAuthority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_website_certificate_authority_input::Builder,
    }
    impl DisassociateWebsiteCertificateAuthority {
        /// Creates a new `DisassociateWebsiteCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWebsiteCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWebsiteCertificateAuthorityError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>A unique identifier for the CA.</p>
        pub fn website_ca_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.website_ca_id(input.into());
            self
        }
        /// <p>A unique identifier for the CA.</p>
        pub fn set_website_ca_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_website_ca_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevices`.
    ///
    /// <p>Retrieves a list of devices registered with the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDevices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_devices_input::Builder,
    }
    impl ListDevices {
        /// Creates a new `ListDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDevicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDevicesPaginator {
            crate::paginator::ListDevicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p>Retrieves a list of domains associated to a specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomains {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl ListDomains {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDomainsPaginator {
            crate::paginator::ListDomainsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFleets`.
    ///
    /// <p>Retrieves a list of fleets for the current account and Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFleets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_fleets_input::Builder,
    }
    impl ListFleets {
        /// Creates a new `ListFleets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFleetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFleetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFleetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFleetsPaginator {
            crate::paginator::ListFleetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves a list of tags for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebsiteAuthorizationProviders`.
    ///
    /// <p>Retrieves a list of website authorization providers associated with a specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWebsiteAuthorizationProviders {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_website_authorization_providers_input::Builder,
    }
    impl ListWebsiteAuthorizationProviders {
        /// Creates a new `ListWebsiteAuthorizationProviders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebsiteAuthorizationProvidersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebsiteAuthorizationProvidersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWebsiteAuthorizationProvidersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListWebsiteAuthorizationProvidersPaginator {
            crate::paginator::ListWebsiteAuthorizationProvidersPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebsiteCertificateAuthorities`.
    ///
    /// <p>Retrieves a list of certificate authorities added for the current account and Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWebsiteCertificateAuthorities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_website_certificate_authorities_input::Builder,
    }
    impl ListWebsiteCertificateAuthorities {
        /// Creates a new `ListWebsiteCertificateAuthorities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebsiteCertificateAuthoritiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebsiteCertificateAuthoritiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWebsiteCertificateAuthoritiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListWebsiteCertificateAuthoritiesPaginator {
            crate::paginator::ListWebsiteCertificateAuthoritiesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreDomainAccess`.
    ///
    /// <p>Moves a domain to ACTIVE status if it was in the INACTIVE status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreDomainAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_domain_access_input::Builder,
    }
    impl RestoreDomainAccess {
        /// Creates a new `RestoreDomainAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreDomainAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreDomainAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeDomainAccess`.
    ///
    /// <p>Moves a domain to INACTIVE status if it was in the ACTIVE status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeDomainAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::revoke_domain_access_input::Builder,
    }
    impl RevokeDomainAccess {
        /// Creates a new `RevokeDomainAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeDomainAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeDomainAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SignOutUser`.
    ///
    /// <p>Signs the user out from all of their devices. The user can sign in again if they have valid credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SignOutUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::sign_out_user_input::Builder,
    }
    impl SignOutUser {
        /// Creates a new `SignOutUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SignOutUserOutput,
            aws_smithy_http::result::SdkError<crate::error::SignOutUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is a key-value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to add to the resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAuditStreamConfiguration`.
    ///
    /// <p>Updates the audit stream configuration for the fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAuditStreamConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_audit_stream_configuration_input::Builder,
    }
    impl UpdateAuditStreamConfiguration {
        /// Creates a new `UpdateAuditStreamConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAuditStreamConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAuditStreamConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The ARN of the Amazon Kinesis data stream that receives the audit events.</p>
        pub fn audit_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_stream_arn(input.into());
            self
        }
        /// <p>The ARN of the Amazon Kinesis data stream that receives the audit events.</p>
        pub fn set_audit_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_stream_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCompanyNetworkConfiguration`.
    ///
    /// <p>Updates the company network configuration for the fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCompanyNetworkConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_company_network_configuration_input::Builder,
    }
    impl UpdateCompanyNetworkConfiguration {
        /// Creates a new `UpdateCompanyNetworkConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCompanyNetworkConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCompanyNetworkConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The VPC with connectivity to associated websites.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The VPC with connectivity to associated websites.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets used for X-ENI connections from Amazon WorkLink rendering containers.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The subnets used for X-ENI connections from Amazon WorkLink rendering containers.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security groups associated with access to the provided subnets.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>The security groups associated with access to the provided subnets.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDevicePolicyConfiguration`.
    ///
    /// <p>Updates the device policy configuration for the fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDevicePolicyConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_device_policy_configuration_input::Builder,
    }
    impl UpdateDevicePolicyConfiguration {
        /// Creates a new `UpdateDevicePolicyConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDevicePolicyConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDevicePolicyConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.</p>
        pub fn device_ca_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_ca_certificate(input.into());
            self
        }
        /// <p>The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.</p>
        pub fn set_device_ca_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_ca_certificate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainMetadata`.
    ///
    /// <p>Updates domain metadata, such as DisplayName.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_domain_metadata_input::Builder,
    }
    impl UpdateDomainMetadata {
        /// Creates a new `UpdateDomainMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFleetMetadata`.
    ///
    /// <p>Updates fleet metadata, such as DisplayName.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFleetMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_fleet_metadata_input::Builder,
    }
    impl UpdateFleetMetadata {
        /// Creates a new `UpdateFleetMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFleetMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFleetMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The fleet name to display. The existing DisplayName is unset if null is passed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The fleet name to display. The existing DisplayName is unset if null is passed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
        pub fn optimize_for_end_user_location(mut self, input: bool) -> Self {
            self.inner = self.inner.optimize_for_end_user_location(input);
            self
        }
        /// <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
        pub fn set_optimize_for_end_user_location(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_optimize_for_end_user_location(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIdentityProviderConfiguration`.
    ///
    /// <p>Updates the identity provider configuration for the fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIdentityProviderConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_identity_provider_configuration_input::Builder,
    }
    impl UpdateIdentityProviderConfiguration {
        /// Creates a new `UpdateIdentityProviderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIdentityProviderConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateIdentityProviderConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The type of identity provider.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.inner = self.inner.identity_provider_type(input);
            self
        }
        /// <p>The type of identity provider.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_type(input);
            self
        }
        /// <p>The SAML metadata document provided by the customer’s identity provider. The existing IdentityProviderSamlMetadata is unset if null is passed.</p>
        pub fn identity_provider_saml_metadata(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_provider_saml_metadata(input.into());
            self
        }
        /// <p>The SAML metadata document provided by the customer’s identity provider. The existing IdentityProviderSamlMetadata is unset if null is passed.</p>
        pub fn set_identity_provider_saml_metadata(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_saml_metadata(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
