// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_domain`](crate::client::Client::associate_domain).
///
/// See [`crate::client::fluent_builders::AssociateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateDomain {
    _private: (),
}
impl AssociateDomain {
    /// Creates a new builder-style object to manufacture [`AssociateDomainInput`](crate::input::AssociateDomainInput)
    pub fn builder() -> crate::input::associate_domain_input::Builder {
        crate::input::associate_domain_input::Builder::default()
    }
    /// Creates a new `AssociateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateDomain {
    type Output = std::result::Result<
        crate::output::AssociateDomainOutput,
        crate::error::AssociateDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_domain_error(response)
        } else {
            crate::operation_deser::parse_associate_domain_response(response)
        }
    }
}

/// Operation shape for `AssociateWebsiteAuthorizationProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_website_authorization_provider`](crate::client::Client::associate_website_authorization_provider).
///
/// See [`crate::client::fluent_builders::AssociateWebsiteAuthorizationProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateWebsiteAuthorizationProvider {
    _private: (),
}
impl AssociateWebsiteAuthorizationProvider {
    /// Creates a new builder-style object to manufacture [`AssociateWebsiteAuthorizationProviderInput`](crate::input::AssociateWebsiteAuthorizationProviderInput)
    pub fn builder() -> crate::input::associate_website_authorization_provider_input::Builder {
        crate::input::associate_website_authorization_provider_input::Builder::default()
    }
    /// Creates a new `AssociateWebsiteAuthorizationProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateWebsiteAuthorizationProvider {
    type Output = std::result::Result<
        crate::output::AssociateWebsiteAuthorizationProviderOutput,
        crate::error::AssociateWebsiteAuthorizationProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_website_authorization_provider_error(response)
        } else {
            crate::operation_deser::parse_associate_website_authorization_provider_response(
                response,
            )
        }
    }
}

/// Operation shape for `AssociateWebsiteCertificateAuthority`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_website_certificate_authority`](crate::client::Client::associate_website_certificate_authority).
///
/// See [`crate::client::fluent_builders::AssociateWebsiteCertificateAuthority`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateWebsiteCertificateAuthority {
    _private: (),
}
impl AssociateWebsiteCertificateAuthority {
    /// Creates a new builder-style object to manufacture [`AssociateWebsiteCertificateAuthorityInput`](crate::input::AssociateWebsiteCertificateAuthorityInput)
    pub fn builder() -> crate::input::associate_website_certificate_authority_input::Builder {
        crate::input::associate_website_certificate_authority_input::Builder::default()
    }
    /// Creates a new `AssociateWebsiteCertificateAuthority` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateWebsiteCertificateAuthority {
    type Output = std::result::Result<
        crate::output::AssociateWebsiteCertificateAuthorityOutput,
        crate::error::AssociateWebsiteCertificateAuthorityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_website_certificate_authority_error(response)
        } else {
            crate::operation_deser::parse_associate_website_certificate_authority_response(response)
        }
    }
}

/// Operation shape for `CreateFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_fleet`](crate::client::Client::create_fleet).
///
/// See [`crate::client::fluent_builders::CreateFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFleet {
    _private: (),
}
impl CreateFleet {
    /// Creates a new builder-style object to manufacture [`CreateFleetInput`](crate::input::CreateFleetInput)
    pub fn builder() -> crate::input::create_fleet_input::Builder {
        crate::input::create_fleet_input::Builder::default()
    }
    /// Creates a new `CreateFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFleet {
    type Output =
        std::result::Result<crate::output::CreateFleetOutput, crate::error::CreateFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_fleet_error(response)
        } else {
            crate::operation_deser::parse_create_fleet_response(response)
        }
    }
}

/// Operation shape for `DeleteFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_fleet`](crate::client::Client::delete_fleet).
///
/// See [`crate::client::fluent_builders::DeleteFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFleet {
    _private: (),
}
impl DeleteFleet {
    /// Creates a new builder-style object to manufacture [`DeleteFleetInput`](crate::input::DeleteFleetInput)
    pub fn builder() -> crate::input::delete_fleet_input::Builder {
        crate::input::delete_fleet_input::Builder::default()
    }
    /// Creates a new `DeleteFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFleet {
    type Output =
        std::result::Result<crate::output::DeleteFleetOutput, crate::error::DeleteFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_fleet_error(response)
        } else {
            crate::operation_deser::parse_delete_fleet_response(response)
        }
    }
}

/// Operation shape for `DescribeAuditStreamConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_audit_stream_configuration`](crate::client::Client::describe_audit_stream_configuration).
///
/// See [`crate::client::fluent_builders::DescribeAuditStreamConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAuditStreamConfiguration {
    _private: (),
}
impl DescribeAuditStreamConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeAuditStreamConfigurationInput`](crate::input::DescribeAuditStreamConfigurationInput)
    pub fn builder() -> crate::input::describe_audit_stream_configuration_input::Builder {
        crate::input::describe_audit_stream_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeAuditStreamConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAuditStreamConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeAuditStreamConfigurationOutput,
        crate::error::DescribeAuditStreamConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_audit_stream_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_audit_stream_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeCompanyNetworkConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_company_network_configuration`](crate::client::Client::describe_company_network_configuration).
///
/// See [`crate::client::fluent_builders::DescribeCompanyNetworkConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCompanyNetworkConfiguration {
    _private: (),
}
impl DescribeCompanyNetworkConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeCompanyNetworkConfigurationInput`](crate::input::DescribeCompanyNetworkConfigurationInput)
    pub fn builder() -> crate::input::describe_company_network_configuration_input::Builder {
        crate::input::describe_company_network_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeCompanyNetworkConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCompanyNetworkConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeCompanyNetworkConfigurationOutput,
        crate::error::DescribeCompanyNetworkConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_company_network_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_company_network_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_device`](crate::client::Client::describe_device).
///
/// See [`crate::client::fluent_builders::DescribeDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDevice {
    _private: (),
}
impl DescribeDevice {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    pub fn builder() -> crate::input::describe_device_input::Builder {
        crate::input::describe_device_input::Builder::default()
    }
    /// Creates a new `DescribeDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDevice {
    type Output =
        std::result::Result<crate::output::DescribeDeviceOutput, crate::error::DescribeDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_device_error(response)
        } else {
            crate::operation_deser::parse_describe_device_response(response)
        }
    }
}

/// Operation shape for `DescribeDevicePolicyConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_device_policy_configuration`](crate::client::Client::describe_device_policy_configuration).
///
/// See [`crate::client::fluent_builders::DescribeDevicePolicyConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDevicePolicyConfiguration {
    _private: (),
}
impl DescribeDevicePolicyConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeDevicePolicyConfigurationInput`](crate::input::DescribeDevicePolicyConfigurationInput)
    pub fn builder() -> crate::input::describe_device_policy_configuration_input::Builder {
        crate::input::describe_device_policy_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeDevicePolicyConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDevicePolicyConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeDevicePolicyConfigurationOutput,
        crate::error::DescribeDevicePolicyConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_device_policy_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_device_policy_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domain`](crate::client::Client::describe_domain).
///
/// See [`crate::client::fluent_builders::DescribeDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomain {
    _private: (),
}
impl DescribeDomain {
    /// Creates a new builder-style object to manufacture [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    pub fn builder() -> crate::input::describe_domain_input::Builder {
        crate::input::describe_domain_input::Builder::default()
    }
    /// Creates a new `DescribeDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomain {
    type Output =
        std::result::Result<crate::output::DescribeDomainOutput, crate::error::DescribeDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domain_error(response)
        } else {
            crate::operation_deser::parse_describe_domain_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_metadata`](crate::client::Client::describe_fleet_metadata).
///
/// See [`crate::client::fluent_builders::DescribeFleetMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetMetadata {
    _private: (),
}
impl DescribeFleetMetadata {
    /// Creates a new builder-style object to manufacture [`DescribeFleetMetadataInput`](crate::input::DescribeFleetMetadataInput)
    pub fn builder() -> crate::input::describe_fleet_metadata_input::Builder {
        crate::input::describe_fleet_metadata_input::Builder::default()
    }
    /// Creates a new `DescribeFleetMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetMetadata {
    type Output = std::result::Result<
        crate::output::DescribeFleetMetadataOutput,
        crate::error::DescribeFleetMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_metadata_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_metadata_response(response)
        }
    }
}

/// Operation shape for `DescribeIdentityProviderConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_identity_provider_configuration`](crate::client::Client::describe_identity_provider_configuration).
///
/// See [`crate::client::fluent_builders::DescribeIdentityProviderConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIdentityProviderConfiguration {
    _private: (),
}
impl DescribeIdentityProviderConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeIdentityProviderConfigurationInput`](crate::input::DescribeIdentityProviderConfigurationInput)
    pub fn builder() -> crate::input::describe_identity_provider_configuration_input::Builder {
        crate::input::describe_identity_provider_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeIdentityProviderConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIdentityProviderConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeIdentityProviderConfigurationOutput,
        crate::error::DescribeIdentityProviderConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_identity_provider_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_identity_provider_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeWebsiteCertificateAuthority`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_website_certificate_authority`](crate::client::Client::describe_website_certificate_authority).
///
/// See [`crate::client::fluent_builders::DescribeWebsiteCertificateAuthority`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWebsiteCertificateAuthority {
    _private: (),
}
impl DescribeWebsiteCertificateAuthority {
    /// Creates a new builder-style object to manufacture [`DescribeWebsiteCertificateAuthorityInput`](crate::input::DescribeWebsiteCertificateAuthorityInput)
    pub fn builder() -> crate::input::describe_website_certificate_authority_input::Builder {
        crate::input::describe_website_certificate_authority_input::Builder::default()
    }
    /// Creates a new `DescribeWebsiteCertificateAuthority` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWebsiteCertificateAuthority {
    type Output = std::result::Result<
        crate::output::DescribeWebsiteCertificateAuthorityOutput,
        crate::error::DescribeWebsiteCertificateAuthorityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_website_certificate_authority_error(response)
        } else {
            crate::operation_deser::parse_describe_website_certificate_authority_response(response)
        }
    }
}

/// Operation shape for `DisassociateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_domain`](crate::client::Client::disassociate_domain).
///
/// See [`crate::client::fluent_builders::DisassociateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateDomain {
    _private: (),
}
impl DisassociateDomain {
    /// Creates a new builder-style object to manufacture [`DisassociateDomainInput`](crate::input::DisassociateDomainInput)
    pub fn builder() -> crate::input::disassociate_domain_input::Builder {
        crate::input::disassociate_domain_input::Builder::default()
    }
    /// Creates a new `DisassociateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateDomain {
    type Output = std::result::Result<
        crate::output::DisassociateDomainOutput,
        crate::error::DisassociateDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_domain_error(response)
        } else {
            crate::operation_deser::parse_disassociate_domain_response(response)
        }
    }
}

/// Operation shape for `DisassociateWebsiteAuthorizationProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_website_authorization_provider`](crate::client::Client::disassociate_website_authorization_provider).
///
/// See [`crate::client::fluent_builders::DisassociateWebsiteAuthorizationProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateWebsiteAuthorizationProvider {
    _private: (),
}
impl DisassociateWebsiteAuthorizationProvider {
    /// Creates a new builder-style object to manufacture [`DisassociateWebsiteAuthorizationProviderInput`](crate::input::DisassociateWebsiteAuthorizationProviderInput)
    pub fn builder() -> crate::input::disassociate_website_authorization_provider_input::Builder {
        crate::input::disassociate_website_authorization_provider_input::Builder::default()
    }
    /// Creates a new `DisassociateWebsiteAuthorizationProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateWebsiteAuthorizationProvider {
    type Output = std::result::Result<
        crate::output::DisassociateWebsiteAuthorizationProviderOutput,
        crate::error::DisassociateWebsiteAuthorizationProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_website_authorization_provider_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_website_authorization_provider_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateWebsiteCertificateAuthority`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_website_certificate_authority`](crate::client::Client::disassociate_website_certificate_authority).
///
/// See [`crate::client::fluent_builders::DisassociateWebsiteCertificateAuthority`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateWebsiteCertificateAuthority {
    _private: (),
}
impl DisassociateWebsiteCertificateAuthority {
    /// Creates a new builder-style object to manufacture [`DisassociateWebsiteCertificateAuthorityInput`](crate::input::DisassociateWebsiteCertificateAuthorityInput)
    pub fn builder() -> crate::input::disassociate_website_certificate_authority_input::Builder {
        crate::input::disassociate_website_certificate_authority_input::Builder::default()
    }
    /// Creates a new `DisassociateWebsiteCertificateAuthority` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateWebsiteCertificateAuthority {
    type Output = std::result::Result<
        crate::output::DisassociateWebsiteCertificateAuthorityOutput,
        crate::error::DisassociateWebsiteCertificateAuthorityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_website_certificate_authority_error(response)
        } else {
            crate::operation_deser::parse_disassociate_website_certificate_authority_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_devices`](crate::client::Client::list_devices).
///
/// See [`crate::client::fluent_builders::ListDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevices {
    _private: (),
}
impl ListDevices {
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
    /// Creates a new `ListDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevices {
    type Output =
        std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_devices_error(response)
        } else {
            crate::operation_deser::parse_list_devices_response(response)
        }
    }
}

/// Operation shape for `ListDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domains`](crate::client::Client::list_domains).
///
/// See [`crate::client::fluent_builders::ListDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomains {
    _private: (),
}
impl ListDomains {
    /// Creates a new builder-style object to manufacture [`ListDomainsInput`](crate::input::ListDomainsInput)
    pub fn builder() -> crate::input::list_domains_input::Builder {
        crate::input::list_domains_input::Builder::default()
    }
    /// Creates a new `ListDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomains {
    type Output =
        std::result::Result<crate::output::ListDomainsOutput, crate::error::ListDomainsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domains_error(response)
        } else {
            crate::operation_deser::parse_list_domains_response(response)
        }
    }
}

/// Operation shape for `ListFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_fleets`](crate::client::Client::list_fleets).
///
/// See [`crate::client::fluent_builders::ListFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFleets {
    _private: (),
}
impl ListFleets {
    /// Creates a new builder-style object to manufacture [`ListFleetsInput`](crate::input::ListFleetsInput)
    pub fn builder() -> crate::input::list_fleets_input::Builder {
        crate::input::list_fleets_input::Builder::default()
    }
    /// Creates a new `ListFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFleets {
    type Output =
        std::result::Result<crate::output::ListFleetsOutput, crate::error::ListFleetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_fleets_error(response)
        } else {
            crate::operation_deser::parse_list_fleets_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWebsiteAuthorizationProviders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_website_authorization_providers`](crate::client::Client::list_website_authorization_providers).
///
/// See [`crate::client::fluent_builders::ListWebsiteAuthorizationProviders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWebsiteAuthorizationProviders {
    _private: (),
}
impl ListWebsiteAuthorizationProviders {
    /// Creates a new builder-style object to manufacture [`ListWebsiteAuthorizationProvidersInput`](crate::input::ListWebsiteAuthorizationProvidersInput)
    pub fn builder() -> crate::input::list_website_authorization_providers_input::Builder {
        crate::input::list_website_authorization_providers_input::Builder::default()
    }
    /// Creates a new `ListWebsiteAuthorizationProviders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWebsiteAuthorizationProviders {
    type Output = std::result::Result<
        crate::output::ListWebsiteAuthorizationProvidersOutput,
        crate::error::ListWebsiteAuthorizationProvidersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_website_authorization_providers_error(response)
        } else {
            crate::operation_deser::parse_list_website_authorization_providers_response(response)
        }
    }
}

/// Operation shape for `ListWebsiteCertificateAuthorities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_website_certificate_authorities`](crate::client::Client::list_website_certificate_authorities).
///
/// See [`crate::client::fluent_builders::ListWebsiteCertificateAuthorities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWebsiteCertificateAuthorities {
    _private: (),
}
impl ListWebsiteCertificateAuthorities {
    /// Creates a new builder-style object to manufacture [`ListWebsiteCertificateAuthoritiesInput`](crate::input::ListWebsiteCertificateAuthoritiesInput)
    pub fn builder() -> crate::input::list_website_certificate_authorities_input::Builder {
        crate::input::list_website_certificate_authorities_input::Builder::default()
    }
    /// Creates a new `ListWebsiteCertificateAuthorities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWebsiteCertificateAuthorities {
    type Output = std::result::Result<
        crate::output::ListWebsiteCertificateAuthoritiesOutput,
        crate::error::ListWebsiteCertificateAuthoritiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_website_certificate_authorities_error(response)
        } else {
            crate::operation_deser::parse_list_website_certificate_authorities_response(response)
        }
    }
}

/// Operation shape for `RestoreDomainAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_domain_access`](crate::client::Client::restore_domain_access).
///
/// See [`crate::client::fluent_builders::RestoreDomainAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreDomainAccess {
    _private: (),
}
impl RestoreDomainAccess {
    /// Creates a new builder-style object to manufacture [`RestoreDomainAccessInput`](crate::input::RestoreDomainAccessInput)
    pub fn builder() -> crate::input::restore_domain_access_input::Builder {
        crate::input::restore_domain_access_input::Builder::default()
    }
    /// Creates a new `RestoreDomainAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreDomainAccess {
    type Output = std::result::Result<
        crate::output::RestoreDomainAccessOutput,
        crate::error::RestoreDomainAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_domain_access_error(response)
        } else {
            crate::operation_deser::parse_restore_domain_access_response(response)
        }
    }
}

/// Operation shape for `RevokeDomainAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_domain_access`](crate::client::Client::revoke_domain_access).
///
/// See [`crate::client::fluent_builders::RevokeDomainAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeDomainAccess {
    _private: (),
}
impl RevokeDomainAccess {
    /// Creates a new builder-style object to manufacture [`RevokeDomainAccessInput`](crate::input::RevokeDomainAccessInput)
    pub fn builder() -> crate::input::revoke_domain_access_input::Builder {
        crate::input::revoke_domain_access_input::Builder::default()
    }
    /// Creates a new `RevokeDomainAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeDomainAccess {
    type Output = std::result::Result<
        crate::output::RevokeDomainAccessOutput,
        crate::error::RevokeDomainAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_domain_access_error(response)
        } else {
            crate::operation_deser::parse_revoke_domain_access_response(response)
        }
    }
}

/// Operation shape for `SignOutUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`sign_out_user`](crate::client::Client::sign_out_user).
///
/// See [`crate::client::fluent_builders::SignOutUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SignOutUser {
    _private: (),
}
impl SignOutUser {
    /// Creates a new builder-style object to manufacture [`SignOutUserInput`](crate::input::SignOutUserInput)
    pub fn builder() -> crate::input::sign_out_user_input::Builder {
        crate::input::sign_out_user_input::Builder::default()
    }
    /// Creates a new `SignOutUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SignOutUser {
    type Output =
        std::result::Result<crate::output::SignOutUserOutput, crate::error::SignOutUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_sign_out_user_error(response)
        } else {
            crate::operation_deser::parse_sign_out_user_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAuditStreamConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_audit_stream_configuration`](crate::client::Client::update_audit_stream_configuration).
///
/// See [`crate::client::fluent_builders::UpdateAuditStreamConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAuditStreamConfiguration {
    _private: (),
}
impl UpdateAuditStreamConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateAuditStreamConfigurationInput`](crate::input::UpdateAuditStreamConfigurationInput)
    pub fn builder() -> crate::input::update_audit_stream_configuration_input::Builder {
        crate::input::update_audit_stream_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateAuditStreamConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAuditStreamConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateAuditStreamConfigurationOutput,
        crate::error::UpdateAuditStreamConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_audit_stream_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_audit_stream_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateCompanyNetworkConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_company_network_configuration`](crate::client::Client::update_company_network_configuration).
///
/// See [`crate::client::fluent_builders::UpdateCompanyNetworkConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCompanyNetworkConfiguration {
    _private: (),
}
impl UpdateCompanyNetworkConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateCompanyNetworkConfigurationInput`](crate::input::UpdateCompanyNetworkConfigurationInput)
    pub fn builder() -> crate::input::update_company_network_configuration_input::Builder {
        crate::input::update_company_network_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateCompanyNetworkConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCompanyNetworkConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateCompanyNetworkConfigurationOutput,
        crate::error::UpdateCompanyNetworkConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_company_network_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_company_network_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateDevicePolicyConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device_policy_configuration`](crate::client::Client::update_device_policy_configuration).
///
/// See [`crate::client::fluent_builders::UpdateDevicePolicyConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDevicePolicyConfiguration {
    _private: (),
}
impl UpdateDevicePolicyConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateDevicePolicyConfigurationInput`](crate::input::UpdateDevicePolicyConfigurationInput)
    pub fn builder() -> crate::input::update_device_policy_configuration_input::Builder {
        crate::input::update_device_policy_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateDevicePolicyConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDevicePolicyConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateDevicePolicyConfigurationOutput,
        crate::error::UpdateDevicePolicyConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_policy_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_device_policy_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateDomainMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_domain_metadata`](crate::client::Client::update_domain_metadata).
///
/// See [`crate::client::fluent_builders::UpdateDomainMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDomainMetadata {
    _private: (),
}
impl UpdateDomainMetadata {
    /// Creates a new builder-style object to manufacture [`UpdateDomainMetadataInput`](crate::input::UpdateDomainMetadataInput)
    pub fn builder() -> crate::input::update_domain_metadata_input::Builder {
        crate::input::update_domain_metadata_input::Builder::default()
    }
    /// Creates a new `UpdateDomainMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDomainMetadata {
    type Output = std::result::Result<
        crate::output::UpdateDomainMetadataOutput,
        crate::error::UpdateDomainMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_domain_metadata_error(response)
        } else {
            crate::operation_deser::parse_update_domain_metadata_response(response)
        }
    }
}

/// Operation shape for `UpdateFleetMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_fleet_metadata`](crate::client::Client::update_fleet_metadata).
///
/// See [`crate::client::fluent_builders::UpdateFleetMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFleetMetadata {
    _private: (),
}
impl UpdateFleetMetadata {
    /// Creates a new builder-style object to manufacture [`UpdateFleetMetadataInput`](crate::input::UpdateFleetMetadataInput)
    pub fn builder() -> crate::input::update_fleet_metadata_input::Builder {
        crate::input::update_fleet_metadata_input::Builder::default()
    }
    /// Creates a new `UpdateFleetMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFleetMetadata {
    type Output = std::result::Result<
        crate::output::UpdateFleetMetadataOutput,
        crate::error::UpdateFleetMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_fleet_metadata_error(response)
        } else {
            crate::operation_deser::parse_update_fleet_metadata_response(response)
        }
    }
}

/// Operation shape for `UpdateIdentityProviderConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_identity_provider_configuration`](crate::client::Client::update_identity_provider_configuration).
///
/// See [`crate::client::fluent_builders::UpdateIdentityProviderConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIdentityProviderConfiguration {
    _private: (),
}
impl UpdateIdentityProviderConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateIdentityProviderConfigurationInput`](crate::input::UpdateIdentityProviderConfigurationInput)
    pub fn builder() -> crate::input::update_identity_provider_configuration_input::Builder {
        crate::input::update_identity_provider_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateIdentityProviderConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIdentityProviderConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateIdentityProviderConfigurationOutput,
        crate::error::UpdateIdentityProviderConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_identity_provider_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_identity_provider_configuration_response(response)
        }
    }
}
