// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon WorkLink
///
/// Client for invoking operations on Amazon WorkLink. Each operation on Amazon WorkLink is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_worklink::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_worklink::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_worklink::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateDomain` operation.
    ///
    /// See [`AssociateDomain`](crate::client::fluent_builders::AssociateDomain) for more information about the
    /// operation and its arguments.
    pub fn associate_domain(&self) -> fluent_builders::AssociateDomain<C, M, R> {
        fluent_builders::AssociateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateWebsiteAuthorizationProvider` operation.
    ///
    /// See [`AssociateWebsiteAuthorizationProvider`](crate::client::fluent_builders::AssociateWebsiteAuthorizationProvider) for more information about the
    /// operation and its arguments.
    pub fn associate_website_authorization_provider(
        &self,
    ) -> fluent_builders::AssociateWebsiteAuthorizationProvider<C, M, R> {
        fluent_builders::AssociateWebsiteAuthorizationProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateWebsiteCertificateAuthority` operation.
    ///
    /// See [`AssociateWebsiteCertificateAuthority`](crate::client::fluent_builders::AssociateWebsiteCertificateAuthority) for more information about the
    /// operation and its arguments.
    pub fn associate_website_certificate_authority(
        &self,
    ) -> fluent_builders::AssociateWebsiteCertificateAuthority<C, M, R> {
        fluent_builders::AssociateWebsiteCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFleet` operation.
    ///
    /// See [`CreateFleet`](crate::client::fluent_builders::CreateFleet) for more information about the
    /// operation and its arguments.
    pub fn create_fleet(&self) -> fluent_builders::CreateFleet<C, M, R> {
        fluent_builders::CreateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFleet` operation.
    ///
    /// See [`DeleteFleet`](crate::client::fluent_builders::DeleteFleet) for more information about the
    /// operation and its arguments.
    pub fn delete_fleet(&self) -> fluent_builders::DeleteFleet<C, M, R> {
        fluent_builders::DeleteFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAuditStreamConfiguration` operation.
    ///
    /// See [`DescribeAuditStreamConfiguration`](crate::client::fluent_builders::DescribeAuditStreamConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_audit_stream_configuration(
        &self,
    ) -> fluent_builders::DescribeAuditStreamConfiguration<C, M, R> {
        fluent_builders::DescribeAuditStreamConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCompanyNetworkConfiguration` operation.
    ///
    /// See [`DescribeCompanyNetworkConfiguration`](crate::client::fluent_builders::DescribeCompanyNetworkConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_company_network_configuration(
        &self,
    ) -> fluent_builders::DescribeCompanyNetworkConfiguration<C, M, R> {
        fluent_builders::DescribeCompanyNetworkConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDevice` operation.
    ///
    /// See [`DescribeDevice`](crate::client::fluent_builders::DescribeDevice) for more information about the
    /// operation and its arguments.
    pub fn describe_device(&self) -> fluent_builders::DescribeDevice<C, M, R> {
        fluent_builders::DescribeDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDevicePolicyConfiguration` operation.
    ///
    /// See [`DescribeDevicePolicyConfiguration`](crate::client::fluent_builders::DescribeDevicePolicyConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_device_policy_configuration(
        &self,
    ) -> fluent_builders::DescribeDevicePolicyConfiguration<C, M, R> {
        fluent_builders::DescribeDevicePolicyConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomain` operation.
    ///
    /// See [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) for more information about the
    /// operation and its arguments.
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain<C, M, R> {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFleetMetadata` operation.
    ///
    /// See [`DescribeFleetMetadata`](crate::client::fluent_builders::DescribeFleetMetadata) for more information about the
    /// operation and its arguments.
    pub fn describe_fleet_metadata(&self) -> fluent_builders::DescribeFleetMetadata<C, M, R> {
        fluent_builders::DescribeFleetMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIdentityProviderConfiguration` operation.
    ///
    /// See [`DescribeIdentityProviderConfiguration`](crate::client::fluent_builders::DescribeIdentityProviderConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_identity_provider_configuration(
        &self,
    ) -> fluent_builders::DescribeIdentityProviderConfiguration<C, M, R> {
        fluent_builders::DescribeIdentityProviderConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWebsiteCertificateAuthority` operation.
    ///
    /// See [`DescribeWebsiteCertificateAuthority`](crate::client::fluent_builders::DescribeWebsiteCertificateAuthority) for more information about the
    /// operation and its arguments.
    pub fn describe_website_certificate_authority(
        &self,
    ) -> fluent_builders::DescribeWebsiteCertificateAuthority<C, M, R> {
        fluent_builders::DescribeWebsiteCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateDomain` operation.
    ///
    /// See [`DisassociateDomain`](crate::client::fluent_builders::DisassociateDomain) for more information about the
    /// operation and its arguments.
    pub fn disassociate_domain(&self) -> fluent_builders::DisassociateDomain<C, M, R> {
        fluent_builders::DisassociateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateWebsiteAuthorizationProvider` operation.
    ///
    /// See [`DisassociateWebsiteAuthorizationProvider`](crate::client::fluent_builders::DisassociateWebsiteAuthorizationProvider) for more information about the
    /// operation and its arguments.
    pub fn disassociate_website_authorization_provider(
        &self,
    ) -> fluent_builders::DisassociateWebsiteAuthorizationProvider<C, M, R> {
        fluent_builders::DisassociateWebsiteAuthorizationProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateWebsiteCertificateAuthority` operation.
    ///
    /// See [`DisassociateWebsiteCertificateAuthority`](crate::client::fluent_builders::DisassociateWebsiteCertificateAuthority) for more information about the
    /// operation and its arguments.
    pub fn disassociate_website_certificate_authority(
        &self,
    ) -> fluent_builders::DisassociateWebsiteCertificateAuthority<C, M, R> {
        fluent_builders::DisassociateWebsiteCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDevices` operation.
    ///
    /// See [`ListDevices`](crate::client::fluent_builders::ListDevices) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDevices::into_paginator).
    pub fn list_devices(&self) -> fluent_builders::ListDevices<C, M, R> {
        fluent_builders::ListDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomains` operation.
    ///
    /// See [`ListDomains`](crate::client::fluent_builders::ListDomains) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDomains::into_paginator).
    pub fn list_domains(&self) -> fluent_builders::ListDomains<C, M, R> {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFleets` operation.
    ///
    /// See [`ListFleets`](crate::client::fluent_builders::ListFleets) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListFleets::into_paginator).
    pub fn list_fleets(&self) -> fluent_builders::ListFleets<C, M, R> {
        fluent_builders::ListFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWebsiteAuthorizationProviders` operation.
    ///
    /// See [`ListWebsiteAuthorizationProviders`](crate::client::fluent_builders::ListWebsiteAuthorizationProviders) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWebsiteAuthorizationProviders::into_paginator).
    pub fn list_website_authorization_providers(
        &self,
    ) -> fluent_builders::ListWebsiteAuthorizationProviders<C, M, R> {
        fluent_builders::ListWebsiteAuthorizationProviders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWebsiteCertificateAuthorities` operation.
    ///
    /// See [`ListWebsiteCertificateAuthorities`](crate::client::fluent_builders::ListWebsiteCertificateAuthorities) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWebsiteCertificateAuthorities::into_paginator).
    pub fn list_website_certificate_authorities(
        &self,
    ) -> fluent_builders::ListWebsiteCertificateAuthorities<C, M, R> {
        fluent_builders::ListWebsiteCertificateAuthorities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDomainAccess` operation.
    ///
    /// See [`RestoreDomainAccess`](crate::client::fluent_builders::RestoreDomainAccess) for more information about the
    /// operation and its arguments.
    pub fn restore_domain_access(&self) -> fluent_builders::RestoreDomainAccess<C, M, R> {
        fluent_builders::RestoreDomainAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeDomainAccess` operation.
    ///
    /// See [`RevokeDomainAccess`](crate::client::fluent_builders::RevokeDomainAccess) for more information about the
    /// operation and its arguments.
    pub fn revoke_domain_access(&self) -> fluent_builders::RevokeDomainAccess<C, M, R> {
        fluent_builders::RevokeDomainAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SignOutUser` operation.
    ///
    /// See [`SignOutUser`](crate::client::fluent_builders::SignOutUser) for more information about the
    /// operation and its arguments.
    pub fn sign_out_user(&self) -> fluent_builders::SignOutUser<C, M, R> {
        fluent_builders::SignOutUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAuditStreamConfiguration` operation.
    ///
    /// See [`UpdateAuditStreamConfiguration`](crate::client::fluent_builders::UpdateAuditStreamConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_audit_stream_configuration(
        &self,
    ) -> fluent_builders::UpdateAuditStreamConfiguration<C, M, R> {
        fluent_builders::UpdateAuditStreamConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCompanyNetworkConfiguration` operation.
    ///
    /// See [`UpdateCompanyNetworkConfiguration`](crate::client::fluent_builders::UpdateCompanyNetworkConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_company_network_configuration(
        &self,
    ) -> fluent_builders::UpdateCompanyNetworkConfiguration<C, M, R> {
        fluent_builders::UpdateCompanyNetworkConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDevicePolicyConfiguration` operation.
    ///
    /// See [`UpdateDevicePolicyConfiguration`](crate::client::fluent_builders::UpdateDevicePolicyConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_device_policy_configuration(
        &self,
    ) -> fluent_builders::UpdateDevicePolicyConfiguration<C, M, R> {
        fluent_builders::UpdateDevicePolicyConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomainMetadata` operation.
    ///
    /// See [`UpdateDomainMetadata`](crate::client::fluent_builders::UpdateDomainMetadata) for more information about the
    /// operation and its arguments.
    pub fn update_domain_metadata(&self) -> fluent_builders::UpdateDomainMetadata<C, M, R> {
        fluent_builders::UpdateDomainMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFleetMetadata` operation.
    ///
    /// See [`UpdateFleetMetadata`](crate::client::fluent_builders::UpdateFleetMetadata) for more information about the
    /// operation and its arguments.
    pub fn update_fleet_metadata(&self) -> fluent_builders::UpdateFleetMetadata<C, M, R> {
        fluent_builders::UpdateFleetMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIdentityProviderConfiguration` operation.
    ///
    /// See [`UpdateIdentityProviderConfiguration`](crate::client::fluent_builders::UpdateIdentityProviderConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_identity_provider_configuration(
        &self,
    ) -> fluent_builders::UpdateIdentityProviderConfiguration<C, M, R> {
        fluent_builders::UpdateIdentityProviderConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateDomain`.
    ///
    /// <p>Specifies a domain to be associated to Amazon WorkLink.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_domain_input::Builder,
    }
    impl<C, M, R> AssociateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateDomainInputOperationOutputAlias,
                crate::output::AssociateDomainOutput,
                crate::error::AssociateDomainError,
                crate::input::AssociateDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The fully qualified domain name (FQDN).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The fully qualified domain name (FQDN).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The ARN of an issued ACM certificate that is valid for the domain being associated.</p>
        pub fn acm_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acm_certificate_arn(input.into());
            self
        }
        /// <p>The ARN of an issued ACM certificate that is valid for the domain being associated.</p>
        pub fn set_acm_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_acm_certificate_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWebsiteAuthorizationProvider`.
    ///
    /// <p>Associates a website authorization provider with a specified fleet. This is used to authorize users against associated websites in the company network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWebsiteAuthorizationProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_website_authorization_provider_input::Builder,
    }
    impl<C, M, R> AssociateWebsiteAuthorizationProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWebsiteAuthorizationProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWebsiteAuthorizationProviderOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateWebsiteAuthorizationProviderError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWebsiteAuthorizationProviderInputOperationOutputAlias,
                crate::output::AssociateWebsiteAuthorizationProviderOutput,
                crate::error::AssociateWebsiteAuthorizationProviderError,
                crate::input::AssociateWebsiteAuthorizationProviderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The authorization provider type.</p>
        pub fn authorization_provider_type(
            mut self,
            input: crate::model::AuthorizationProviderType,
        ) -> Self {
            self.inner = self.inner.authorization_provider_type(input);
            self
        }
        /// <p>The authorization provider type.</p>
        pub fn set_authorization_provider_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationProviderType>,
        ) -> Self {
            self.inner = self.inner.set_authorization_provider_type(input);
            self
        }
        /// <p>The domain name of the authorization provider. This applies only to SAML-based authorization providers.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name of the authorization provider. This applies only to SAML-based authorization providers.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWebsiteCertificateAuthority`.
    ///
    /// <p>Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated websites within the company network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWebsiteCertificateAuthority<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_website_certificate_authority_input::Builder,
    }
    impl<C, M, R> AssociateWebsiteCertificateAuthority<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWebsiteCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWebsiteCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateWebsiteCertificateAuthorityError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWebsiteCertificateAuthorityInputOperationOutputAlias,
                crate::output::AssociateWebsiteCertificateAuthorityOutput,
                crate::error::AssociateWebsiteCertificateAuthorityError,
                crate::input::AssociateWebsiteCertificateAuthorityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The root certificate of the CA.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate(input.into());
            self
        }
        /// <p>The root certificate of the CA.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_certificate(input);
            self
        }
        /// <p>The certificate name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The certificate name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFleet`.
    ///
    /// <p>Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to authorized users who download and set up the Amazon WorkLink app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fleet_input::Builder,
    }
    impl<C, M, R> CreateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFleetInputOperationOutputAlias,
                crate::output::CreateFleetOutput,
                crate::error::CreateFleetError,
                crate::input::CreateFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name for the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(input.into());
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
        pub fn optimize_for_end_user_location(mut self, input: bool) -> Self {
            self.inner = self.inner.optimize_for_end_user_location(input);
            self
        }
        /// <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
        pub fn set_optimize_for_end_user_location(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_optimize_for_end_user_location(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags to add to the resource. A tag is a key-value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags to add to the resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFleet`.
    ///
    /// <p>Deletes a fleet. Prevents users from accessing previously associated websites. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fleet_input::Builder,
    }
    impl<C, M, R> DeleteFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFleetInputOperationOutputAlias,
                crate::output::DeleteFleetOutput,
                crate::error::DeleteFleetError,
                crate::input::DeleteFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuditStreamConfiguration`.
    ///
    /// <p>Describes the configuration for delivering audit streams to the customer account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuditStreamConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_audit_stream_configuration_input::Builder,
    }
    impl<C, M, R> DescribeAuditStreamConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuditStreamConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuditStreamConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuditStreamConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuditStreamConfigurationInputOperationOutputAlias,
                crate::output::DescribeAuditStreamConfigurationOutput,
                crate::error::DescribeAuditStreamConfigurationError,
                crate::input::DescribeAuditStreamConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCompanyNetworkConfiguration`.
    ///
    /// <p>Describes the networking configuration to access the internal websites associated with the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCompanyNetworkConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_company_network_configuration_input::Builder,
    }
    impl<C, M, R> DescribeCompanyNetworkConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCompanyNetworkConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCompanyNetworkConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeCompanyNetworkConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCompanyNetworkConfigurationInputOperationOutputAlias,
                crate::output::DescribeCompanyNetworkConfigurationOutput,
                crate::error::DescribeCompanyNetworkConfigurationError,
                crate::input::DescribeCompanyNetworkConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDevice`.
    ///
    /// <p>Provides information about a user's device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_device_input::Builder,
    }
    impl<C, M, R> DescribeDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeviceInputOperationOutputAlias,
                crate::output::DescribeDeviceOutput,
                crate::error::DescribeDeviceError,
                crate::input::DescribeDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>A unique identifier for a registered user's device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>A unique identifier for a registered user's device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDevicePolicyConfiguration`.
    ///
    /// <p>Describes the device policy configuration for the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDevicePolicyConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_device_policy_configuration_input::Builder,
    }
    impl<C, M, R> DescribeDevicePolicyConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDevicePolicyConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDevicePolicyConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDevicePolicyConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDevicePolicyConfigurationInputOperationOutputAlias,
                crate::output::DescribeDevicePolicyConfigurationOutput,
                crate::error::DescribeDevicePolicyConfigurationError,
                crate::input::DescribeDevicePolicyConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p>Provides information about the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl<C, M, R> DescribeDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainInputOperationOutputAlias,
                crate::output::DescribeDomainOutput,
                crate::error::DescribeDomainError,
                crate::input::DescribeDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFleetMetadata`.
    ///
    /// <p>Provides basic information for the specified fleet, excluding identity provider, networking, and device configuration details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFleetMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fleet_metadata_input::Builder,
    }
    impl<C, M, R> DescribeFleetMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFleetMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFleetMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFleetMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFleetMetadataInputOperationOutputAlias,
                crate::output::DescribeFleetMetadataOutput,
                crate::error::DescribeFleetMetadataError,
                crate::input::DescribeFleetMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentityProviderConfiguration`.
    ///
    /// <p>Describes the identity provider configuration of the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIdentityProviderConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_identity_provider_configuration_input::Builder,
    }
    impl<C, M, R> DescribeIdentityProviderConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIdentityProviderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityProviderConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeIdentityProviderConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIdentityProviderConfigurationInputOperationOutputAlias,
                crate::output::DescribeIdentityProviderConfigurationOutput,
                crate::error::DescribeIdentityProviderConfigurationError,
                crate::input::DescribeIdentityProviderConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWebsiteCertificateAuthority`.
    ///
    /// <p>Provides information about the certificate authority.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWebsiteCertificateAuthority<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_website_certificate_authority_input::Builder,
    }
    impl<C, M, R> DescribeWebsiteCertificateAuthority<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWebsiteCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWebsiteCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeWebsiteCertificateAuthorityError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWebsiteCertificateAuthorityInputOperationOutputAlias,
                crate::output::DescribeWebsiteCertificateAuthorityOutput,
                crate::error::DescribeWebsiteCertificateAuthorityError,
                crate::input::DescribeWebsiteCertificateAuthorityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>A unique identifier for the certificate authority.</p>
        pub fn website_ca_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.website_ca_id(input.into());
            self
        }
        /// <p>A unique identifier for the certificate authority.</p>
        pub fn set_website_ca_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_website_ca_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateDomain`.
    ///
    /// <p>Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon WorkLink. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_domain_input::Builder,
    }
    impl<C, M, R> DisassociateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateDomainInputOperationOutputAlias,
                crate::output::DisassociateDomainOutput,
                crate::error::DisassociateDomainError,
                crate::input::DisassociateDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWebsiteAuthorizationProvider`.
    ///
    /// <p>Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load any associated websites that require this authorization provider.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWebsiteAuthorizationProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_website_authorization_provider_input::Builder,
    }
    impl<C, M, R> DisassociateWebsiteAuthorizationProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWebsiteAuthorizationProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWebsiteAuthorizationProviderOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWebsiteAuthorizationProviderError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWebsiteAuthorizationProviderInputOperationOutputAlias,
                crate::output::DisassociateWebsiteAuthorizationProviderOutput,
                crate::error::DisassociateWebsiteAuthorizationProviderError,
                crate::input::DisassociateWebsiteAuthorizationProviderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>A unique identifier for the authorization provider.</p>
        pub fn authorization_provider_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorization_provider_id(input.into());
            self
        }
        /// <p>A unique identifier for the authorization provider.</p>
        pub fn set_authorization_provider_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorization_provider_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWebsiteCertificateAuthority`.
    ///
    /// <p>Removes a certificate authority (CA).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWebsiteCertificateAuthority<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_website_certificate_authority_input::Builder,
    }
    impl<C, M, R> DisassociateWebsiteCertificateAuthority<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWebsiteCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWebsiteCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWebsiteCertificateAuthorityError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWebsiteCertificateAuthorityInputOperationOutputAlias,
                crate::output::DisassociateWebsiteCertificateAuthorityOutput,
                crate::error::DisassociateWebsiteCertificateAuthorityError,
                crate::input::DisassociateWebsiteCertificateAuthorityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>A unique identifier for the CA.</p>
        pub fn website_ca_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.website_ca_id(input.into());
            self
        }
        /// <p>A unique identifier for the CA.</p>
        pub fn set_website_ca_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_website_ca_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevices`.
    ///
    /// <p>Retrieves a list of devices registered with the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_devices_input::Builder,
    }
    impl<C, M, R> ListDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDevicesInputOperationOutputAlias,
                crate::output::ListDevicesOutput,
                crate::error::ListDevicesError,
                crate::input::ListDevicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDevicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDevicesPaginator<C, M, R> {
            crate::paginator::ListDevicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p>Retrieves a list of domains associated to a specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl<C, M, R> ListDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainsInputOperationOutputAlias,
                crate::output::ListDomainsOutput,
                crate::error::ListDomainsError,
                crate::input::ListDomainsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDomainsPaginator<C, M, R> {
            crate::paginator::ListDomainsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFleets`.
    ///
    /// <p>Retrieves a list of fleets for the current account and Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFleets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fleets_input::Builder,
    }
    impl<C, M, R> ListFleets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFleets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFleetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFleetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFleetsInputOperationOutputAlias,
                crate::output::ListFleetsOutput,
                crate::error::ListFleetsError,
                crate::input::ListFleetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFleetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFleetsPaginator<C, M, R> {
            crate::paginator::ListFleetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves a list of tags for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebsiteAuthorizationProviders`.
    ///
    /// <p>Retrieves a list of website authorization providers associated with a specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWebsiteAuthorizationProviders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_website_authorization_providers_input::Builder,
    }
    impl<C, M, R> ListWebsiteAuthorizationProviders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWebsiteAuthorizationProviders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebsiteAuthorizationProvidersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebsiteAuthorizationProvidersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWebsiteAuthorizationProvidersInputOperationOutputAlias,
                crate::output::ListWebsiteAuthorizationProvidersOutput,
                crate::error::ListWebsiteAuthorizationProvidersError,
                crate::input::ListWebsiteAuthorizationProvidersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWebsiteAuthorizationProvidersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListWebsiteAuthorizationProvidersPaginator<C, M, R> {
            crate::paginator::ListWebsiteAuthorizationProvidersPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebsiteCertificateAuthorities`.
    ///
    /// <p>Retrieves a list of certificate authorities added for the current account and Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWebsiteCertificateAuthorities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_website_certificate_authorities_input::Builder,
    }
    impl<C, M, R> ListWebsiteCertificateAuthorities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWebsiteCertificateAuthorities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebsiteCertificateAuthoritiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebsiteCertificateAuthoritiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWebsiteCertificateAuthoritiesInputOperationOutputAlias,
                crate::output::ListWebsiteCertificateAuthoritiesOutput,
                crate::error::ListWebsiteCertificateAuthoritiesError,
                crate::input::ListWebsiteCertificateAuthoritiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWebsiteCertificateAuthoritiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListWebsiteCertificateAuthoritiesPaginator<C, M, R> {
            crate::paginator::ListWebsiteCertificateAuthoritiesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be included in the next page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreDomainAccess`.
    ///
    /// <p>Moves a domain to ACTIVE status if it was in the INACTIVE status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreDomainAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_domain_access_input::Builder,
    }
    impl<C, M, R> RestoreDomainAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreDomainAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreDomainAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreDomainAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreDomainAccessInputOperationOutputAlias,
                crate::output::RestoreDomainAccessOutput,
                crate::error::RestoreDomainAccessError,
                crate::input::RestoreDomainAccessInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeDomainAccess`.
    ///
    /// <p>Moves a domain to INACTIVE status if it was in the ACTIVE status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeDomainAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_domain_access_input::Builder,
    }
    impl<C, M, R> RevokeDomainAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokeDomainAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeDomainAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeDomainAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokeDomainAccessInputOperationOutputAlias,
                crate::output::RevokeDomainAccessOutput,
                crate::error::RevokeDomainAccessError,
                crate::input::RevokeDomainAccessInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SignOutUser`.
    ///
    /// <p>Signs the user out from all of their devices. The user can sign in again if they have valid credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SignOutUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::sign_out_user_input::Builder,
    }
    impl<C, M, R> SignOutUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SignOutUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SignOutUserOutput,
            aws_smithy_http::result::SdkError<crate::error::SignOutUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SignOutUserInputOperationOutputAlias,
                crate::output::SignOutUserOutput,
                crate::error::SignOutUserError,
                crate::input::SignOutUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is a key-value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to add to the resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAuditStreamConfiguration`.
    ///
    /// <p>Updates the audit stream configuration for the fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAuditStreamConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_audit_stream_configuration_input::Builder,
    }
    impl<C, M, R> UpdateAuditStreamConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAuditStreamConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAuditStreamConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAuditStreamConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAuditStreamConfigurationInputOperationOutputAlias,
                crate::output::UpdateAuditStreamConfigurationOutput,
                crate::error::UpdateAuditStreamConfigurationError,
                crate::input::UpdateAuditStreamConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The ARN of the Amazon Kinesis data stream that receives the audit events.</p>
        pub fn audit_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_stream_arn(input.into());
            self
        }
        /// <p>The ARN of the Amazon Kinesis data stream that receives the audit events.</p>
        pub fn set_audit_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_stream_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCompanyNetworkConfiguration`.
    ///
    /// <p>Updates the company network configuration for the fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCompanyNetworkConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_company_network_configuration_input::Builder,
    }
    impl<C, M, R> UpdateCompanyNetworkConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCompanyNetworkConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCompanyNetworkConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCompanyNetworkConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCompanyNetworkConfigurationInputOperationOutputAlias,
                crate::output::UpdateCompanyNetworkConfigurationOutput,
                crate::error::UpdateCompanyNetworkConfigurationError,
                crate::input::UpdateCompanyNetworkConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The VPC with connectivity to associated websites.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The VPC with connectivity to associated websites.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets used for X-ENI connections from Amazon WorkLink rendering containers.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The subnets used for X-ENI connections from Amazon WorkLink rendering containers.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security groups associated with access to the provided subnets.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>The security groups associated with access to the provided subnets.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDevicePolicyConfiguration`.
    ///
    /// <p>Updates the device policy configuration for the fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDevicePolicyConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_device_policy_configuration_input::Builder,
    }
    impl<C, M, R> UpdateDevicePolicyConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDevicePolicyConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDevicePolicyConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDevicePolicyConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDevicePolicyConfigurationInputOperationOutputAlias,
                crate::output::UpdateDevicePolicyConfigurationOutput,
                crate::error::UpdateDevicePolicyConfigurationError,
                crate::input::UpdateDevicePolicyConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.</p>
        pub fn device_ca_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_ca_certificate(input.into());
            self
        }
        /// <p>The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.</p>
        pub fn set_device_ca_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_ca_certificate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainMetadata`.
    ///
    /// <p>Updates domain metadata, such as DisplayName.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_metadata_input::Builder,
    }
    impl<C, M, R> UpdateDomainMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomainMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainMetadataInputOperationOutputAlias,
                crate::output::UpdateDomainMetadataOutput,
                crate::error::UpdateDomainMetadataError,
                crate::input::UpdateDomainMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFleetMetadata`.
    ///
    /// <p>Updates fleet metadata, such as DisplayName.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFleetMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_fleet_metadata_input::Builder,
    }
    impl<C, M, R> UpdateFleetMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFleetMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFleetMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFleetMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFleetMetadataInputOperationOutputAlias,
                crate::output::UpdateFleetMetadataOutput,
                crate::error::UpdateFleetMetadataError,
                crate::input::UpdateFleetMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The fleet name to display. The existing DisplayName is unset if null is passed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The fleet name to display. The existing DisplayName is unset if null is passed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
        pub fn optimize_for_end_user_location(mut self, input: bool) -> Self {
            self.inner = self.inner.optimize_for_end_user_location(input);
            self
        }
        /// <p>The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region.</p>
        pub fn set_optimize_for_end_user_location(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_optimize_for_end_user_location(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIdentityProviderConfiguration`.
    ///
    /// <p>Updates the identity provider configuration for the fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIdentityProviderConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_identity_provider_configuration_input::Builder,
    }
    impl<C, M, R> UpdateIdentityProviderConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIdentityProviderConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIdentityProviderConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateIdentityProviderConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIdentityProviderConfigurationInputOperationOutputAlias,
                crate::output::UpdateIdentityProviderConfigurationOutput,
                crate::error::UpdateIdentityProviderConfigurationError,
                crate::input::UpdateIdentityProviderConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_arn(input.into());
            self
        }
        /// <p>The ARN of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_arn(input);
            self
        }
        /// <p>The type of identity provider.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.inner = self.inner.identity_provider_type(input);
            self
        }
        /// <p>The type of identity provider.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_type(input);
            self
        }
        /// <p>The SAML metadata document provided by the customer’s identity provider. The existing IdentityProviderSamlMetadata is unset if null is passed.</p>
        pub fn identity_provider_saml_metadata(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identity_provider_saml_metadata(input.into());
            self
        }
        /// <p>The SAML metadata document provided by the customer’s identity provider. The existing IdentityProviderSamlMetadata is unset if null is passed.</p>
        pub fn set_identity_provider_saml_metadata(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_saml_metadata(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
