// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateDomainError {
    /// Kind of error that occurred.
    pub kind: AssociateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateDomainErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateDomainErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            AssociateDomainErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateDomainErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            AssociateDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateDomainErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AssociateDomainErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            AssociateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateDomainError {
    fn code(&self) -> Option<&str> {
        AssociateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateDomainError {
    /// Creates a new `AssociateDomainError`.
    pub fn new(kind: AssociateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateDomainErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDomainErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDomainErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDomainErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDomainErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDomainErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDomainErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDomainErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDomainErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDomainErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for AssociateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateDomainErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            AssociateDomainErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateDomainErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            AssociateDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateDomainErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AssociateDomainErrorKind::UnauthorizedException(_inner) => Some(_inner),
            AssociateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateWebsiteAuthorizationProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateWebsiteAuthorizationProviderError {
    /// Kind of error that occurred.
    pub kind: AssociateWebsiteAuthorizationProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateWebsiteAuthorizationProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateWebsiteAuthorizationProviderErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateWebsiteAuthorizationProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateWebsiteAuthorizationProviderErrorKind::InternalServerErrorException(
                _inner,
            ) => _inner.fmt(f),
            AssociateWebsiteAuthorizationProviderErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWebsiteAuthorizationProviderErrorKind::ResourceAlreadyExistsException(
                _inner,
            ) => _inner.fmt(f),
            AssociateWebsiteAuthorizationProviderErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWebsiteAuthorizationProviderErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWebsiteAuthorizationProviderErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWebsiteAuthorizationProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateWebsiteAuthorizationProviderError {
    fn code(&self) -> Option<&str> {
        AssociateWebsiteAuthorizationProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateWebsiteAuthorizationProviderError {
    /// Creates a new `AssociateWebsiteAuthorizationProviderError`.
    pub fn new(
        kind: AssociateWebsiteAuthorizationProviderErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateWebsiteAuthorizationProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateWebsiteAuthorizationProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateWebsiteAuthorizationProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateWebsiteAuthorizationProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateWebsiteAuthorizationProviderErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteAuthorizationProviderErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebsiteAuthorizationProviderErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteAuthorizationProviderErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebsiteAuthorizationProviderErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteAuthorizationProviderErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebsiteAuthorizationProviderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteAuthorizationProviderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebsiteAuthorizationProviderErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteAuthorizationProviderErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebsiteAuthorizationProviderErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteAuthorizationProviderErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for AssociateWebsiteAuthorizationProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateWebsiteAuthorizationProviderErrorKind::InternalServerErrorException(
                _inner,
            ) => Some(_inner),
            AssociateWebsiteAuthorizationProviderErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            AssociateWebsiteAuthorizationProviderErrorKind::ResourceAlreadyExistsException(
                _inner,
            ) => Some(_inner),
            AssociateWebsiteAuthorizationProviderErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateWebsiteAuthorizationProviderErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            AssociateWebsiteAuthorizationProviderErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            AssociateWebsiteAuthorizationProviderErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AssociateWebsiteCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateWebsiteCertificateAuthorityError {
    /// Kind of error that occurred.
    pub kind: AssociateWebsiteCertificateAuthorityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateWebsiteCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateWebsiteCertificateAuthorityErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateWebsiteCertificateAuthorityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateWebsiteCertificateAuthorityErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWebsiteCertificateAuthorityErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWebsiteCertificateAuthorityErrorKind::ResourceAlreadyExistsException(
                _inner,
            ) => _inner.fmt(f),
            AssociateWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWebsiteCertificateAuthorityErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWebsiteCertificateAuthorityErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWebsiteCertificateAuthorityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateWebsiteCertificateAuthorityError {
    fn code(&self) -> Option<&str> {
        AssociateWebsiteCertificateAuthorityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateWebsiteCertificateAuthorityError {
    /// Creates a new `AssociateWebsiteCertificateAuthorityError`.
    pub fn new(
        kind: AssociateWebsiteCertificateAuthorityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateWebsiteCertificateAuthorityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateWebsiteCertificateAuthorityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateWebsiteCertificateAuthorityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateWebsiteCertificateAuthorityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateWebsiteCertificateAuthorityErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteCertificateAuthorityErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebsiteCertificateAuthorityErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteCertificateAuthorityErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebsiteCertificateAuthorityErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteCertificateAuthorityErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebsiteCertificateAuthorityErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteCertificateAuthorityErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebsiteCertificateAuthorityErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebsiteCertificateAuthorityErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for AssociateWebsiteCertificateAuthorityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateWebsiteCertificateAuthorityErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            AssociateWebsiteCertificateAuthorityErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            AssociateWebsiteCertificateAuthorityErrorKind::ResourceAlreadyExistsException(
                _inner,
            ) => Some(_inner),
            AssociateWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateWebsiteCertificateAuthorityErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            AssociateWebsiteCertificateAuthorityErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            AssociateWebsiteCertificateAuthorityErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFleetError {
    /// Kind of error that occurred.
    pub kind: CreateFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFleetErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFleetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFleetError {
    fn code(&self) -> Option<&str> {
        CreateFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFleetError {
    /// Creates a new `CreateFleetError`.
    pub fn new(kind: CreateFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateFleetErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateFleetErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFleetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateFleetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateFleetErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateFleetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFleetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateFleetErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFleetError {
    /// Kind of error that occurred.
    pub kind: DeleteFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFleetErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFleetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFleetError {
    fn code(&self) -> Option<&str> {
        DeleteFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFleetError {
    /// Creates a new `DeleteFleetError`.
    pub fn new(kind: DeleteFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteFleetErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteFleetErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFleetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteFleetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteFleetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFleetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteFleetErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAuditStreamConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAuditStreamConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeAuditStreamConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAuditStreamConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAuditStreamConfigurationErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAuditStreamConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAuditStreamConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAuditStreamConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAuditStreamConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAuditStreamConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAuditStreamConfigurationErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAuditStreamConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAuditStreamConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeAuditStreamConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAuditStreamConfigurationError {
    /// Creates a new `DescribeAuditStreamConfigurationError`.
    pub fn new(
        kind: DescribeAuditStreamConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAuditStreamConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAuditStreamConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAuditStreamConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAuditStreamConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAuditStreamConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditStreamConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditStreamConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditStreamConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditStreamConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditStreamConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditStreamConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditStreamConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditStreamConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditStreamConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeAuditStreamConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAuditStreamConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeAuditStreamConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeAuditStreamConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeAuditStreamConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeAuditStreamConfigurationErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DescribeAuditStreamConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCompanyNetworkConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCompanyNetworkConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeCompanyNetworkConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCompanyNetworkConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCompanyNetworkConfigurationErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCompanyNetworkConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCompanyNetworkConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCompanyNetworkConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCompanyNetworkConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCompanyNetworkConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCompanyNetworkConfigurationErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCompanyNetworkConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCompanyNetworkConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeCompanyNetworkConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCompanyNetworkConfigurationError {
    /// Creates a new `DescribeCompanyNetworkConfigurationError`.
    pub fn new(
        kind: DescribeCompanyNetworkConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCompanyNetworkConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCompanyNetworkConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCompanyNetworkConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCompanyNetworkConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCompanyNetworkConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCompanyNetworkConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCompanyNetworkConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCompanyNetworkConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCompanyNetworkConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCompanyNetworkConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCompanyNetworkConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCompanyNetworkConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCompanyNetworkConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCompanyNetworkConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeCompanyNetworkConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCompanyNetworkConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeCompanyNetworkConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeCompanyNetworkConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeCompanyNetworkConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeCompanyNetworkConfigurationErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DescribeCompanyNetworkConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDeviceError {
    /// Kind of error that occurred.
    pub kind: DescribeDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDeviceErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDeviceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDeviceError {
    fn code(&self) -> Option<&str> {
        DescribeDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDeviceError {
    /// Creates a new `DescribeDeviceError`.
    pub fn new(kind: DescribeDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDeviceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDevicePolicyConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDevicePolicyConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeDevicePolicyConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDevicePolicyConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDevicePolicyConfigurationErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDevicePolicyConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDevicePolicyConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDevicePolicyConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDevicePolicyConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDevicePolicyConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDevicePolicyConfigurationErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDevicePolicyConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDevicePolicyConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeDevicePolicyConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDevicePolicyConfigurationError {
    /// Creates a new `DescribeDevicePolicyConfigurationError`.
    pub fn new(
        kind: DescribeDevicePolicyConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDevicePolicyConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDevicePolicyConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDevicePolicyConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDevicePolicyConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDevicePolicyConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDevicePolicyConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDevicePolicyConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDevicePolicyConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDevicePolicyConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDevicePolicyConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDevicePolicyConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDevicePolicyConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDevicePolicyConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDevicePolicyConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeDevicePolicyConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDevicePolicyConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeDevicePolicyConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeDevicePolicyConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeDevicePolicyConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeDevicePolicyConfigurationErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DescribeDevicePolicyConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainError {
    fn code(&self) -> Option<&str> {
        DescribeDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainError {
    /// Creates a new `DescribeDomainError`.
    pub fn new(kind: DescribeDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeDomainErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDomainErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeDomainErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleetMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetMetadataError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleetMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetMetadataErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetMetadataErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeFleetMetadataErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeFleetMetadataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetMetadataErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeFleetMetadataErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeFleetMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetMetadataError {
    fn code(&self) -> Option<&str> {
        DescribeFleetMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetMetadataError {
    /// Creates a new `DescribeFleetMetadataError`.
    pub fn new(kind: DescribeFleetMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetMetadataErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetadataErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetMetadataErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetadataErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetMetadataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetadataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetMetadataErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetadataErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetMetadataErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetadataErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeFleetMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetMetadataErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeFleetMetadataErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeFleetMetadataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFleetMetadataErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeFleetMetadataErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeFleetMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIdentityProviderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIdentityProviderConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeIdentityProviderConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIdentityProviderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIdentityProviderConfigurationErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIdentityProviderConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIdentityProviderConfigurationErrorKind::InternalServerErrorException(
                _inner,
            ) => _inner.fmt(f),
            DescribeIdentityProviderConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeIdentityProviderConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeIdentityProviderConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeIdentityProviderConfigurationErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeIdentityProviderConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIdentityProviderConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeIdentityProviderConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIdentityProviderConfigurationError {
    /// Creates a new `DescribeIdentityProviderConfigurationError`.
    pub fn new(
        kind: DescribeIdentityProviderConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIdentityProviderConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIdentityProviderConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIdentityProviderConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIdentityProviderConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeIdentityProviderConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIdentityProviderConfigurationErrorKind::InternalServerErrorException(
                _inner,
            ) => Some(_inner),
            DescribeIdentityProviderConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeIdentityProviderConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeIdentityProviderConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeIdentityProviderConfigurationErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DescribeIdentityProviderConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeWebsiteCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWebsiteCertificateAuthorityError {
    /// Kind of error that occurred.
    pub kind: DescribeWebsiteCertificateAuthorityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWebsiteCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWebsiteCertificateAuthorityErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWebsiteCertificateAuthorityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWebsiteCertificateAuthorityErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWebsiteCertificateAuthorityErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWebsiteCertificateAuthorityErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWebsiteCertificateAuthorityErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWebsiteCertificateAuthorityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWebsiteCertificateAuthorityError {
    fn code(&self) -> Option<&str> {
        DescribeWebsiteCertificateAuthorityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWebsiteCertificateAuthorityError {
    /// Creates a new `DescribeWebsiteCertificateAuthorityError`.
    pub fn new(
        kind: DescribeWebsiteCertificateAuthorityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWebsiteCertificateAuthorityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWebsiteCertificateAuthorityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWebsiteCertificateAuthorityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWebsiteCertificateAuthorityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWebsiteCertificateAuthorityErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWebsiteCertificateAuthorityErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWebsiteCertificateAuthorityErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWebsiteCertificateAuthorityErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWebsiteCertificateAuthorityErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWebsiteCertificateAuthorityErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWebsiteCertificateAuthorityErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWebsiteCertificateAuthorityErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeWebsiteCertificateAuthorityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWebsiteCertificateAuthorityErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeWebsiteCertificateAuthorityErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeWebsiteCertificateAuthorityErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeWebsiteCertificateAuthorityErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DescribeWebsiteCertificateAuthorityErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateDomainError {
    /// Kind of error that occurred.
    pub kind: DisassociateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateDomainErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateDomainErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DisassociateDomainErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisassociateDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateDomainErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DisassociateDomainErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DisassociateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateDomainError {
    fn code(&self) -> Option<&str> {
        DisassociateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateDomainError {
    /// Creates a new `DisassociateDomainError`.
    pub fn new(kind: DisassociateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateDomainErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDomainErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDomainErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDomainErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDomainErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDomainErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDomainErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDomainErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DisassociateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateDomainErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DisassociateDomainErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisassociateDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateDomainErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DisassociateDomainErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DisassociateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateWebsiteAuthorizationProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateWebsiteAuthorizationProviderError {
    /// Kind of error that occurred.
    pub kind: DisassociateWebsiteAuthorizationProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateWebsiteAuthorizationProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateWebsiteAuthorizationProviderErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateWebsiteAuthorizationProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateWebsiteAuthorizationProviderErrorKind::InternalServerErrorException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateWebsiteAuthorizationProviderErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWebsiteAuthorizationProviderErrorKind::ResourceAlreadyExistsException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateWebsiteAuthorizationProviderErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateWebsiteAuthorizationProviderErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWebsiteAuthorizationProviderErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWebsiteAuthorizationProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateWebsiteAuthorizationProviderError {
    fn code(&self) -> Option<&str> {
        DisassociateWebsiteAuthorizationProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateWebsiteAuthorizationProviderError {
    /// Creates a new `DisassociateWebsiteAuthorizationProviderError`.
    pub fn new(
        kind: DisassociateWebsiteAuthorizationProviderErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateWebsiteAuthorizationProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateWebsiteAuthorizationProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateWebsiteAuthorizationProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateWebsiteAuthorizationProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteAuthorizationProviderErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteAuthorizationProviderErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteAuthorizationProviderErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteAuthorizationProviderErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteAuthorizationProviderErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteAuthorizationProviderErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteAuthorizationProviderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteAuthorizationProviderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteAuthorizationProviderErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteAuthorizationProviderErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteAuthorizationProviderErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteAuthorizationProviderErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DisassociateWebsiteAuthorizationProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateWebsiteAuthorizationProviderErrorKind::InternalServerErrorException(
                _inner,
            ) => Some(_inner),
            DisassociateWebsiteAuthorizationProviderErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DisassociateWebsiteAuthorizationProviderErrorKind::ResourceAlreadyExistsException(
                _inner,
            ) => Some(_inner),
            DisassociateWebsiteAuthorizationProviderErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DisassociateWebsiteAuthorizationProviderErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DisassociateWebsiteAuthorizationProviderErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DisassociateWebsiteAuthorizationProviderErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateWebsiteCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateWebsiteCertificateAuthorityError {
    /// Kind of error that occurred.
    pub kind: DisassociateWebsiteCertificateAuthorityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateWebsiteCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateWebsiteCertificateAuthorityErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateWebsiteCertificateAuthorityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateWebsiteCertificateAuthorityErrorKind::InternalServerErrorException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateWebsiteCertificateAuthorityErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWebsiteCertificateAuthorityErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWebsiteCertificateAuthorityErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWebsiteCertificateAuthorityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateWebsiteCertificateAuthorityError {
    fn code(&self) -> Option<&str> {
        DisassociateWebsiteCertificateAuthorityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateWebsiteCertificateAuthorityError {
    /// Creates a new `DisassociateWebsiteCertificateAuthorityError`.
    pub fn new(
        kind: DisassociateWebsiteCertificateAuthorityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateWebsiteCertificateAuthorityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateWebsiteCertificateAuthorityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateWebsiteCertificateAuthorityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateWebsiteCertificateAuthorityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteCertificateAuthorityErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteCertificateAuthorityErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteCertificateAuthorityErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteCertificateAuthorityErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteCertificateAuthorityErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteCertificateAuthorityErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebsiteCertificateAuthorityErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebsiteCertificateAuthorityErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DisassociateWebsiteCertificateAuthorityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateWebsiteCertificateAuthorityErrorKind::InternalServerErrorException(
                _inner,
            ) => Some(_inner),
            DisassociateWebsiteCertificateAuthorityErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DisassociateWebsiteCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateWebsiteCertificateAuthorityErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DisassociateWebsiteCertificateAuthorityErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DisassociateWebsiteCertificateAuthorityErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDevicesError {
    /// Kind of error that occurred.
    pub kind: ListDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDevicesErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDevicesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDevicesError {
    fn code(&self) -> Option<&str> {
        ListDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDevicesError {
    /// Creates a new `ListDevicesError`.
    pub fn new(kind: ListDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDevicesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListDevicesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDevicesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDevicesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListDevicesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainsError {
    /// Kind of error that occurred.
    pub kind: ListDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainsErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainsError {
    fn code(&self) -> Option<&str> {
        ListDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainsError {
    /// Creates a new `ListDomainsError`.
    pub fn new(kind: ListDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListDomainsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDomainsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDomainsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListDomainsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFleets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFleetsError {
    /// Kind of error that occurred.
    pub kind: ListFleetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFleets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFleetsErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFleetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFleetsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListFleetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListFleetsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListFleetsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListFleetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFleetsError {
    fn code(&self) -> Option<&str> {
        ListFleetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFleetsError {
    /// Creates a new `ListFleetsError`.
    pub fn new(kind: ListFleetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFleetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFleetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFleetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFleetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFleetsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFleetsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFleetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListFleetsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListFleetsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListFleetsErrorKind::TooManyRequestsException(_))
    }
    /// Returns `true` if the error kind is `ListFleetsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListFleetsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListFleetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFleetsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListFleetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListFleetsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListFleetsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListFleetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWebsiteAuthorizationProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWebsiteAuthorizationProvidersError {
    /// Kind of error that occurred.
    pub kind: ListWebsiteAuthorizationProvidersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWebsiteAuthorizationProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWebsiteAuthorizationProvidersErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWebsiteAuthorizationProvidersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWebsiteAuthorizationProvidersErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListWebsiteAuthorizationProvidersErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListWebsiteAuthorizationProvidersErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListWebsiteAuthorizationProvidersErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListWebsiteAuthorizationProvidersErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            ListWebsiteAuthorizationProvidersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWebsiteAuthorizationProvidersError {
    fn code(&self) -> Option<&str> {
        ListWebsiteAuthorizationProvidersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWebsiteAuthorizationProvidersError {
    /// Creates a new `ListWebsiteAuthorizationProvidersError`.
    pub fn new(
        kind: ListWebsiteAuthorizationProvidersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWebsiteAuthorizationProvidersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWebsiteAuthorizationProvidersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWebsiteAuthorizationProvidersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWebsiteAuthorizationProvidersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWebsiteAuthorizationProvidersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebsiteAuthorizationProvidersErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebsiteAuthorizationProvidersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebsiteAuthorizationProvidersErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebsiteAuthorizationProvidersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebsiteAuthorizationProvidersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebsiteAuthorizationProvidersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebsiteAuthorizationProvidersErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebsiteAuthorizationProvidersErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebsiteAuthorizationProvidersErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListWebsiteAuthorizationProvidersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWebsiteAuthorizationProvidersErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            ListWebsiteAuthorizationProvidersErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListWebsiteAuthorizationProvidersErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListWebsiteAuthorizationProvidersErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListWebsiteAuthorizationProvidersErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            ListWebsiteAuthorizationProvidersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWebsiteCertificateAuthorities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWebsiteCertificateAuthoritiesError {
    /// Kind of error that occurred.
    pub kind: ListWebsiteCertificateAuthoritiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWebsiteCertificateAuthorities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWebsiteCertificateAuthoritiesErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWebsiteCertificateAuthoritiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWebsiteCertificateAuthoritiesErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListWebsiteCertificateAuthoritiesErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListWebsiteCertificateAuthoritiesErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListWebsiteCertificateAuthoritiesErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            ListWebsiteCertificateAuthoritiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWebsiteCertificateAuthoritiesError {
    fn code(&self) -> Option<&str> {
        ListWebsiteCertificateAuthoritiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWebsiteCertificateAuthoritiesError {
    /// Creates a new `ListWebsiteCertificateAuthoritiesError`.
    pub fn new(
        kind: ListWebsiteCertificateAuthoritiesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWebsiteCertificateAuthoritiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWebsiteCertificateAuthoritiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWebsiteCertificateAuthoritiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWebsiteCertificateAuthoritiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWebsiteCertificateAuthoritiesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebsiteCertificateAuthoritiesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebsiteCertificateAuthoritiesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebsiteCertificateAuthoritiesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebsiteCertificateAuthoritiesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebsiteCertificateAuthoritiesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebsiteCertificateAuthoritiesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebsiteCertificateAuthoritiesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListWebsiteCertificateAuthoritiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWebsiteCertificateAuthoritiesErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            ListWebsiteCertificateAuthoritiesErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListWebsiteCertificateAuthoritiesErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListWebsiteCertificateAuthoritiesErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            ListWebsiteCertificateAuthoritiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreDomainAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreDomainAccessError {
    /// Kind of error that occurred.
    pub kind: RestoreDomainAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreDomainAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreDomainAccessErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreDomainAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreDomainAccessErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            RestoreDomainAccessErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            RestoreDomainAccessErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RestoreDomainAccessErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RestoreDomainAccessErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            RestoreDomainAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreDomainAccessError {
    fn code(&self) -> Option<&str> {
        RestoreDomainAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreDomainAccessError {
    /// Creates a new `RestoreDomainAccessError`.
    pub fn new(kind: RestoreDomainAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreDomainAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreDomainAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreDomainAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreDomainAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreDomainAccessErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDomainAccessErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDomainAccessErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDomainAccessErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDomainAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDomainAccessErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDomainAccessErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDomainAccessErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDomainAccessErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDomainAccessErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for RestoreDomainAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreDomainAccessErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            RestoreDomainAccessErrorKind::InvalidRequestException(_inner) => Some(_inner),
            RestoreDomainAccessErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RestoreDomainAccessErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RestoreDomainAccessErrorKind::UnauthorizedException(_inner) => Some(_inner),
            RestoreDomainAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeDomainAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeDomainAccessError {
    /// Kind of error that occurred.
    pub kind: RevokeDomainAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeDomainAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeDomainAccessErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeDomainAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeDomainAccessErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            RevokeDomainAccessErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            RevokeDomainAccessErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RevokeDomainAccessErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RevokeDomainAccessErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            RevokeDomainAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeDomainAccessError {
    fn code(&self) -> Option<&str> {
        RevokeDomainAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeDomainAccessError {
    /// Creates a new `RevokeDomainAccessError`.
    pub fn new(kind: RevokeDomainAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeDomainAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeDomainAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeDomainAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeDomainAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RevokeDomainAccessErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeDomainAccessErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeDomainAccessErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeDomainAccessErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeDomainAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeDomainAccessErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeDomainAccessErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeDomainAccessErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeDomainAccessErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeDomainAccessErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for RevokeDomainAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeDomainAccessErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            RevokeDomainAccessErrorKind::InvalidRequestException(_inner) => Some(_inner),
            RevokeDomainAccessErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RevokeDomainAccessErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RevokeDomainAccessErrorKind::UnauthorizedException(_inner) => Some(_inner),
            RevokeDomainAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SignOutUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SignOutUserError {
    /// Kind of error that occurred.
    pub kind: SignOutUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SignOutUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SignOutUserErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SignOutUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SignOutUserErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            SignOutUserErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            SignOutUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SignOutUserErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            SignOutUserErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            SignOutUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SignOutUserError {
    fn code(&self) -> Option<&str> {
        SignOutUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SignOutUserError {
    /// Creates a new `SignOutUserError`.
    pub fn new(kind: SignOutUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SignOutUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SignOutUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SignOutUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SignOutUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SignOutUserErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SignOutUserErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `SignOutUserErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, SignOutUserErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `SignOutUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SignOutUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SignOutUserErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            SignOutUserErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `SignOutUserErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, SignOutUserErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for SignOutUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SignOutUserErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            SignOutUserErrorKind::InvalidRequestException(_inner) => Some(_inner),
            SignOutUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SignOutUserErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            SignOutUserErrorKind::UnauthorizedException(_inner) => Some(_inner),
            SignOutUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAuditStreamConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAuditStreamConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateAuditStreamConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAuditStreamConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAuditStreamConfigurationErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAuditStreamConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAuditStreamConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAuditStreamConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAuditStreamConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAuditStreamConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAuditStreamConfigurationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateAuditStreamConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAuditStreamConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateAuditStreamConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAuditStreamConfigurationError {
    /// Creates a new `UpdateAuditStreamConfigurationError`.
    pub fn new(
        kind: UpdateAuditStreamConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAuditStreamConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAuditStreamConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAuditStreamConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAuditStreamConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAuditStreamConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuditStreamConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAuditStreamConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuditStreamConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAuditStreamConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuditStreamConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAuditStreamConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuditStreamConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAuditStreamConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAuditStreamConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateAuditStreamConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAuditStreamConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateAuditStreamConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateAuditStreamConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateAuditStreamConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            UpdateAuditStreamConfigurationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateAuditStreamConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCompanyNetworkConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCompanyNetworkConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateCompanyNetworkConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCompanyNetworkConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCompanyNetworkConfigurationErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCompanyNetworkConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCompanyNetworkConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCompanyNetworkConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCompanyNetworkConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCompanyNetworkConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCompanyNetworkConfigurationErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCompanyNetworkConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCompanyNetworkConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateCompanyNetworkConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCompanyNetworkConfigurationError {
    /// Creates a new `UpdateCompanyNetworkConfigurationError`.
    pub fn new(
        kind: UpdateCompanyNetworkConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCompanyNetworkConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCompanyNetworkConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCompanyNetworkConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCompanyNetworkConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCompanyNetworkConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCompanyNetworkConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCompanyNetworkConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCompanyNetworkConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCompanyNetworkConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCompanyNetworkConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCompanyNetworkConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCompanyNetworkConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCompanyNetworkConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCompanyNetworkConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateCompanyNetworkConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCompanyNetworkConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateCompanyNetworkConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateCompanyNetworkConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateCompanyNetworkConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            UpdateCompanyNetworkConfigurationErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            UpdateCompanyNetworkConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDevicePolicyConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDevicePolicyConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateDevicePolicyConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDevicePolicyConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDevicePolicyConfigurationErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDevicePolicyConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDevicePolicyConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDevicePolicyConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDevicePolicyConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDevicePolicyConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDevicePolicyConfigurationErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDevicePolicyConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDevicePolicyConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateDevicePolicyConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDevicePolicyConfigurationError {
    /// Creates a new `UpdateDevicePolicyConfigurationError`.
    pub fn new(
        kind: UpdateDevicePolicyConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDevicePolicyConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDevicePolicyConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDevicePolicyConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDevicePolicyConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDevicePolicyConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevicePolicyConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDevicePolicyConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevicePolicyConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDevicePolicyConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevicePolicyConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDevicePolicyConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevicePolicyConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDevicePolicyConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevicePolicyConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateDevicePolicyConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDevicePolicyConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateDevicePolicyConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateDevicePolicyConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateDevicePolicyConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            UpdateDevicePolicyConfigurationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateDevicePolicyConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomainMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainMetadataError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomainMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainMetadataErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainMetadataErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateDomainMetadataErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateDomainMetadataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDomainMetadataErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateDomainMetadataErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateDomainMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainMetadataError {
    fn code(&self) -> Option<&str> {
        UpdateDomainMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainMetadataError {
    /// Creates a new `UpdateDomainMetadataError`.
    pub fn new(kind: UpdateDomainMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDomainMetadataErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainMetadataErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainMetadataErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainMetadataErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainMetadataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainMetadataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainMetadataErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainMetadataErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainMetadataErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainMetadataErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateDomainMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainMetadataErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateDomainMetadataErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateDomainMetadataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDomainMetadataErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateDomainMetadataErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateDomainMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFleetMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFleetMetadataError {
    /// Kind of error that occurred.
    pub kind: UpdateFleetMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFleetMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFleetMetadataErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFleetMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFleetMetadataErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateFleetMetadataErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateFleetMetadataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFleetMetadataErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateFleetMetadataErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateFleetMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFleetMetadataError {
    fn code(&self) -> Option<&str> {
        UpdateFleetMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFleetMetadataError {
    /// Creates a new `UpdateFleetMetadataError`.
    pub fn new(kind: UpdateFleetMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFleetMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFleetMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFleetMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFleetMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFleetMetadataErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetMetadataErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetMetadataErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetMetadataErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetMetadataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetMetadataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetMetadataErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetMetadataErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetMetadataErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetMetadataErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateFleetMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFleetMetadataErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateFleetMetadataErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateFleetMetadataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFleetMetadataErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateFleetMetadataErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateFleetMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIdentityProviderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIdentityProviderConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateIdentityProviderConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIdentityProviderConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIdentityProviderConfigurationErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You are not authorized to perform this action.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIdentityProviderConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIdentityProviderConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateIdentityProviderConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateIdentityProviderConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateIdentityProviderConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            UpdateIdentityProviderConfigurationErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateIdentityProviderConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIdentityProviderConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateIdentityProviderConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIdentityProviderConfigurationError {
    /// Creates a new `UpdateIdentityProviderConfigurationError`.
    pub fn new(
        kind: UpdateIdentityProviderConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIdentityProviderConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIdentityProviderConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIdentityProviderConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIdentityProviderConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIdentityProviderConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIdentityProviderConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateIdentityProviderConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIdentityProviderConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateIdentityProviderConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateIdentityProviderConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateIdentityProviderConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            UpdateIdentityProviderConfigurationErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            UpdateIdentityProviderConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// <p>You are not authorized to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>The number of requests exceeds the limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The requested resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>The service is temporarily unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// <p>The resource already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}
