// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AbortDocumentVersionUploadInput`](crate::input::AbortDocumentVersionUploadInput)
pub mod abort_document_version_upload_input {
    /// A builder for [`AbortDocumentVersionUploadInput`](crate::input::AbortDocumentVersionUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The ID of the version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortDocumentVersionUploadInput`](crate::input::AbortDocumentVersionUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AbortDocumentVersionUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AbortDocumentVersionUploadInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AbortDocumentVersionUploadInputOperationOutputAlias =
    crate::operation::AbortDocumentVersionUpload;
#[doc(hidden)]
pub type AbortDocumentVersionUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AbortDocumentVersionUploadInput {
    /// Consumes the builder and constructs an Operation<[`AbortDocumentVersionUpload`](crate::operation::AbortDocumentVersionUpload)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AbortDocumentVersionUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AbortDocumentVersionUploadInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.document_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_1, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_2 = &_input.version_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let version_id = aws_smithy_http::label::fmt_string(input_2, false);
                if version_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}/versions/{VersionId}",
                    DocumentId = document_id,
                    VersionId = version_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AbortDocumentVersionUploadInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_abort_document_version_upload(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AbortDocumentVersionUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AbortDocumentVersionUpload",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AbortDocumentVersionUploadInput`](crate::input::AbortDocumentVersionUploadInput)
    pub fn builder() -> crate::input::abort_document_version_upload_input::Builder {
        crate::input::abort_document_version_upload_input::Builder::default()
    }
}

/// See [`ActivateUserInput`](crate::input::ActivateUserInput)
pub mod activate_user_input {
    /// A builder for [`ActivateUserInput`](crate::input::ActivateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) authentication_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateUserInput`](crate::input::ActivateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ActivateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ActivateUserInput {
                user_id: self.user_id,
                authentication_token: self.authentication_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ActivateUserInputOperationOutputAlias = crate::operation::ActivateUser;
#[doc(hidden)]
pub type ActivateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ActivateUserInput {
    /// Consumes the builder and constructs an Operation<[`ActivateUser`](crate::operation::ActivateUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ActivateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ActivateUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.user_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_3, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/users/{UserId}/activation",
                    UserId = user_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ActivateUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_activate_user(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ActivateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ActivateUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ActivateUserInput`](crate::input::ActivateUserInput)
    pub fn builder() -> crate::input::activate_user_input::Builder {
        crate::input::activate_user_input::Builder::default()
    }
}

/// See [`AddResourcePermissionsInput`](crate::input::AddResourcePermissionsInput)
pub mod add_resource_permissions_input {
    /// A builder for [`AddResourcePermissionsInput`](crate::input::AddResourcePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) principals: std::option::Option<std::vec::Vec<crate::model::SharePrincipal>>,
        pub(crate) notification_options: std::option::Option<crate::model::NotificationOptions>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The users, groups, or organization being granted permission.</p>
        pub fn principals(mut self, input: crate::model::SharePrincipal) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input);
            self.principals = Some(v);
            self
        }
        /// <p>The users, groups, or organization being granted permission.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SharePrincipal>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>The notification options.</p>
        pub fn notification_options(mut self, input: crate::model::NotificationOptions) -> Self {
            self.notification_options = Some(input);
            self
        }
        /// <p>The notification options.</p>
        pub fn set_notification_options(
            mut self,
            input: std::option::Option<crate::model::NotificationOptions>,
        ) -> Self {
            self.notification_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AddResourcePermissionsInput`](crate::input::AddResourcePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddResourcePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddResourcePermissionsInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
                principals: self.principals,
                notification_options: self.notification_options,
            })
        }
    }
}
#[doc(hidden)]
pub type AddResourcePermissionsInputOperationOutputAlias = crate::operation::AddResourcePermissions;
#[doc(hidden)]
pub type AddResourcePermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddResourcePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`AddResourcePermissions`](crate::operation::AddResourcePermissions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddResourcePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddResourcePermissionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.resource_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_id = aws_smithy_http::label::fmt_string(input_4, false);
                if resource_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/resources/{ResourceId}/permissions",
                    ResourceId = resource_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddResourcePermissionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_add_resource_permissions(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_resource_permissions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddResourcePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddResourcePermissions",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddResourcePermissionsInput`](crate::input::AddResourcePermissionsInput)
    pub fn builder() -> crate::input::add_resource_permissions_input::Builder {
        crate::input::add_resource_permissions_input::Builder::default()
    }
}

/// See [`CreateCommentInput`](crate::input::CreateCommentInput)
pub mod create_comment_input {
    /// A builder for [`CreateCommentInput`](crate::input::CreateCommentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) thread_id: std::option::Option<std::string::String>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) visibility: std::option::Option<crate::model::CommentVisibilityType>,
        pub(crate) notify_collaborators: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The ID of the parent comment.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent comment.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The ID of the root comment in the thread.</p>
        pub fn thread_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thread_id = Some(input.into());
            self
        }
        /// <p>The ID of the root comment in the thread.</p>
        pub fn set_thread_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thread_id = input;
            self
        }
        /// <p>The text of the comment.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text of the comment.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners, and contributors.</p>
        pub fn visibility(mut self, input: crate::model::CommentVisibilityType) -> Self {
            self.visibility = Some(input);
            self
        }
        /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners, and contributors.</p>
        pub fn set_visibility(
            mut self,
            input: std::option::Option<crate::model::CommentVisibilityType>,
        ) -> Self {
            self.visibility = input;
            self
        }
        /// <p>Set this parameter to TRUE to send an email out to the document collaborators after the comment is created.</p>
        pub fn notify_collaborators(mut self, input: bool) -> Self {
            self.notify_collaborators = Some(input);
            self
        }
        /// <p>Set this parameter to TRUE to send an email out to the document collaborators after the comment is created.</p>
        pub fn set_notify_collaborators(mut self, input: std::option::Option<bool>) -> Self {
            self.notify_collaborators = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCommentInput`](crate::input::CreateCommentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCommentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCommentInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
                parent_id: self.parent_id,
                thread_id: self.thread_id,
                text: self.text,
                visibility: self.visibility,
                notify_collaborators: self.notify_collaborators.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCommentInputOperationOutputAlias = crate::operation::CreateComment;
#[doc(hidden)]
pub type CreateCommentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCommentInput {
    /// Consumes the builder and constructs an Operation<[`CreateComment`](crate::operation::CreateComment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateComment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCommentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.document_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_5, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_6 = &_input.version_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let version_id = aws_smithy_http::label::fmt_string(input_6, false);
                if version_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}/versions/{VersionId}/comment",
                    DocumentId = document_id,
                    VersionId = version_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCommentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_comment(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_comment(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateComment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateComment",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCommentInput`](crate::input::CreateCommentInput)
    pub fn builder() -> crate::input::create_comment_input::Builder {
        crate::input::create_comment_input::Builder::default()
    }
}

/// See [`CreateCustomMetadataInput`](crate::input::CreateCustomMetadataInput)
pub mod create_custom_metadata_input {
    /// A builder for [`CreateCustomMetadataInput`](crate::input::CreateCustomMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) custom_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ID of the version, if the custom metadata is being added to a document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the version, if the custom metadata is being added to a document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Adds a key-value pair to `custom_metadata`.
        ///
        /// To override the contents of this collection use [`set_custom_metadata`](Self::set_custom_metadata).
        ///
        /// <p>Custom metadata in the form of name-value pairs.</p>
        pub fn custom_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.custom_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.custom_metadata = Some(hash_map);
            self
        }
        /// <p>Custom metadata in the form of name-value pairs.</p>
        pub fn set_custom_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomMetadataInput`](crate::input::CreateCustomMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomMetadataInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
                version_id: self.version_id,
                custom_metadata: self.custom_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomMetadataInputOperationOutputAlias = crate::operation::CreateCustomMetadata;
#[doc(hidden)]
pub type CreateCustomMetadataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCustomMetadataInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomMetadata`](crate::operation::CreateCustomMetadata)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomMetadata,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCustomMetadataInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.resource_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_id = aws_smithy_http::label::fmt_string(input_7, false);
                if resource_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/resources/{ResourceId}/customMetadata",
                    ResourceId = resource_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateCustomMetadataInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_8) = &_input.version_id {
                    query.push_kv("versionid", &aws_smithy_http::query::fmt_string(&inner_8));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCustomMetadataInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_create_custom_metadata(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_custom_metadata(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomMetadata",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomMetadataInput`](crate::input::CreateCustomMetadataInput)
    pub fn builder() -> crate::input::create_custom_metadata_input::Builder {
        crate::input::create_custom_metadata_input::Builder::default()
    }
}

/// See [`CreateFolderInput`](crate::input::CreateFolderInput)
pub mod create_folder_input {
    /// A builder for [`CreateFolderInput`](crate::input::CreateFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parent_folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The name of the new folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFolderInput`](crate::input::CreateFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFolderInput {
                authentication_token: self.authentication_token,
                name: self.name,
                parent_folder_id: self.parent_folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFolderInputOperationOutputAlias = crate::operation::CreateFolder;
#[doc(hidden)]
pub type CreateFolderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFolderInput {
    /// Consumes the builder and constructs an Operation<[`CreateFolder`](crate::operation::CreateFolder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFolder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFolderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/api/v1/folders").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFolderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_folder(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_folder(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFolder",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFolderInput`](crate::input::CreateFolderInput)
    pub fn builder() -> crate::input::create_folder_input::Builder {
        crate::input::create_folder_input::Builder::default()
    }
}

/// See [`CreateLabelsInput`](crate::input::CreateLabelsInput)
pub mod create_labels_input {
    /// A builder for [`CreateLabelsInput`](crate::input::CreateLabelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authentication_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>List of labels to add to the resource.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>List of labels to add to the resource.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLabelsInput`](crate::input::CreateLabelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLabelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLabelsInput {
                resource_id: self.resource_id,
                labels: self.labels,
                authentication_token: self.authentication_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLabelsInputOperationOutputAlias = crate::operation::CreateLabels;
#[doc(hidden)]
pub type CreateLabelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLabelsInput {
    /// Consumes the builder and constructs an Operation<[`CreateLabels`](crate::operation::CreateLabels)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLabels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLabelsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.resource_id;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_id = aws_smithy_http::label::fmt_string(input_9, false);
                if resource_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/resources/{ResourceId}/labels",
                    ResourceId = resource_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLabelsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_labels(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_labels(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLabels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLabels",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLabelsInput`](crate::input::CreateLabelsInput)
    pub fn builder() -> crate::input::create_labels_input::Builder {
        crate::input::create_labels_input::Builder::default()
    }
}

/// See [`CreateNotificationSubscriptionInput`](crate::input::CreateNotificationSubscriptionInput)
pub mod create_notification_subscription_input {
    /// A builder for [`CreateNotificationSubscriptionInput`](crate::input::CreateNotificationSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::SubscriptionProtocolType>,
        pub(crate) subscription_type: std::option::Option<crate::model::SubscriptionType>,
    }
    impl Builder {
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins with <code>https</code>.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins with <code>https</code>.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.</p>
        pub fn protocol(mut self, input: crate::model::SubscriptionProtocolType) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::SubscriptionProtocolType>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The notification type.</p>
        pub fn subscription_type(mut self, input: crate::model::SubscriptionType) -> Self {
            self.subscription_type = Some(input);
            self
        }
        /// <p>The notification type.</p>
        pub fn set_subscription_type(
            mut self,
            input: std::option::Option<crate::model::SubscriptionType>,
        ) -> Self {
            self.subscription_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNotificationSubscriptionInput`](crate::input::CreateNotificationSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNotificationSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNotificationSubscriptionInput {
                organization_id: self.organization_id,
                endpoint: self.endpoint,
                protocol: self.protocol,
                subscription_type: self.subscription_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNotificationSubscriptionInputOperationOutputAlias =
    crate::operation::CreateNotificationSubscription;
#[doc(hidden)]
pub type CreateNotificationSubscriptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateNotificationSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateNotificationSubscription`](crate::operation::CreateNotificationSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNotificationSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateNotificationSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.organization_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "organization_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let organization_id = aws_smithy_http::label::fmt_string(input_10, false);
                if organization_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "organization_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/organizations/{OrganizationId}/subscriptions",
                    OrganizationId = organization_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateNotificationSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_notification_subscription(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNotificationSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNotificationSubscription",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateNotificationSubscriptionInput`](crate::input::CreateNotificationSubscriptionInput)
    pub fn builder() -> crate::input::create_notification_subscription_input::Builder {
        crate::input::create_notification_subscription_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) given_name: std::option::Option<std::string::String>,
        pub(crate) surname: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) time_zone_id: std::option::Option<std::string::String>,
        pub(crate) storage_rule: std::option::Option<crate::model::StorageRuleType>,
        pub(crate) authentication_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The login name of the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The login name of the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The email address of the user.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address of the user.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The given name of the user.</p>
        pub fn given_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.given_name = Some(input.into());
            self
        }
        /// <p>The given name of the user.</p>
        pub fn set_given_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.given_name = input;
            self
        }
        /// <p>The surname of the user.</p>
        pub fn surname(mut self, input: impl Into<std::string::String>) -> Self {
            self.surname = Some(input.into());
            self
        }
        /// <p>The surname of the user.</p>
        pub fn set_surname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.surname = input;
            self
        }
        /// <p>The password of the user.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password of the user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn time_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone_id = Some(input.into());
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn set_time_zone_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone_id = input;
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn storage_rule(mut self, input: crate::model::StorageRuleType) -> Self {
            self.storage_rule = Some(input);
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn set_storage_rule(
            mut self,
            input: std::option::Option<crate::model::StorageRuleType>,
        ) -> Self {
            self.storage_rule = input;
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                organization_id: self.organization_id,
                username: self.username,
                email_address: self.email_address,
                given_name: self.given_name,
                surname: self.surname,
                password: self.password,
                time_zone_id: self.time_zone_id,
                storage_rule: self.storage_rule,
                authentication_token: self.authentication_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/api/v1/users").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_user(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`DeactivateUserInput`](crate::input::DeactivateUserInput)
pub mod deactivate_user_input {
    /// A builder for [`DeactivateUserInput`](crate::input::DeactivateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) authentication_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeactivateUserInput`](crate::input::DeactivateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeactivateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeactivateUserInput {
                user_id: self.user_id,
                authentication_token: self.authentication_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeactivateUserInputOperationOutputAlias = crate::operation::DeactivateUser;
#[doc(hidden)]
pub type DeactivateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeactivateUserInput {
    /// Consumes the builder and constructs an Operation<[`DeactivateUser`](crate::operation::DeactivateUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeactivateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeactivateUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.user_id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_11, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/users/{UserId}/activation",
                    UserId = user_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeactivateUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_deactivate_user(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeactivateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeactivateUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeactivateUserInput`](crate::input::DeactivateUserInput)
    pub fn builder() -> crate::input::deactivate_user_input::Builder {
        crate::input::deactivate_user_input::Builder::default()
    }
}

/// See [`DeleteCommentInput`](crate::input::DeleteCommentInput)
pub mod delete_comment_input {
    /// A builder for [`DeleteCommentInput`](crate::input::DeleteCommentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) comment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The ID of the comment.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_id = Some(input.into());
            self
        }
        /// <p>The ID of the comment.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCommentInput`](crate::input::DeleteCommentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCommentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCommentInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
                comment_id: self.comment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCommentInputOperationOutputAlias = crate::operation::DeleteComment;
#[doc(hidden)]
pub type DeleteCommentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCommentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteComment`](crate::operation::DeleteComment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteComment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCommentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.document_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_12, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_13 = &_input.version_id;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let version_id = aws_smithy_http::label::fmt_string(input_13, false);
                if version_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_14 = &_input.comment_id;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "comment_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let comment_id = aws_smithy_http::label::fmt_string(input_14, false);
                if comment_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "comment_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}/versions/{VersionId}/comment/{CommentId}",
                    DocumentId = document_id,
                    VersionId = version_id,
                    CommentId = comment_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCommentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_comment(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteComment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteComment",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCommentInput`](crate::input::DeleteCommentInput)
    pub fn builder() -> crate::input::delete_comment_input::Builder {
        crate::input::delete_comment_input::Builder::default()
    }
}

/// See [`DeleteCustomMetadataInput`](crate::input::DeleteCustomMetadataInput)
pub mod delete_custom_metadata_input {
    /// A builder for [`DeleteCustomMetadataInput`](crate::input::DeleteCustomMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) delete_all: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource, either a document or folder.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource, either a document or folder.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ID of the version, if the custom metadata is being deleted from a document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the version, if the custom metadata is being deleted from a document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Appends an item to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>List of properties to remove.</p>
        pub fn keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.keys.unwrap_or_default();
            v.push(input.into());
            self.keys = Some(v);
            self
        }
        /// <p>List of properties to remove.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.keys = input;
            self
        }
        /// <p>Flag to indicate removal of all custom metadata properties from the specified resource.</p>
        pub fn delete_all(mut self, input: bool) -> Self {
            self.delete_all = Some(input);
            self
        }
        /// <p>Flag to indicate removal of all custom metadata properties from the specified resource.</p>
        pub fn set_delete_all(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_all = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomMetadataInput`](crate::input::DeleteCustomMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomMetadataInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
                version_id: self.version_id,
                keys: self.keys,
                delete_all: self.delete_all.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomMetadataInputOperationOutputAlias = crate::operation::DeleteCustomMetadata;
#[doc(hidden)]
pub type DeleteCustomMetadataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCustomMetadataInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomMetadata`](crate::operation::DeleteCustomMetadata)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomMetadata,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCustomMetadataInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.resource_id;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_id = aws_smithy_http::label::fmt_string(input_15, false);
                if resource_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/resources/{ResourceId}/customMetadata",
                    ResourceId = resource_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteCustomMetadataInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_16) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_16));
                }
                if let Some(inner_17) = &_input.keys {
                    for inner_18 in inner_17 {
                        query.push_kv("keys", &aws_smithy_http::query::fmt_string(&inner_18));
                    }
                }
                if _input.delete_all {
                    query.push_kv(
                        "deleteAll",
                        aws_smithy_types::primitive::Encoder::from(_input.delete_all).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCustomMetadataInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_custom_metadata(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomMetadata",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomMetadataInput`](crate::input::DeleteCustomMetadataInput)
    pub fn builder() -> crate::input::delete_custom_metadata_input::Builder {
        crate::input::delete_custom_metadata_input::Builder::default()
    }
}

/// See [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
pub mod delete_document_input {
    /// A builder for [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDocumentInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDocumentInputOperationOutputAlias = crate::operation::DeleteDocument;
#[doc(hidden)]
pub type DeleteDocumentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDocumentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDocument`](crate::operation::DeleteDocument)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDocument,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDocumentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.document_id;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_19, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}",
                    DocumentId = document_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDocumentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_document(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDocument",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
    pub fn builder() -> crate::input::delete_document_input::Builder {
        crate::input::delete_document_input::Builder::default()
    }
}

/// See [`DeleteFolderInput`](crate::input::DeleteFolderInput)
pub mod delete_folder_input {
    /// A builder for [`DeleteFolderInput`](crate::input::DeleteFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFolderInput`](crate::input::DeleteFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFolderInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFolderInputOperationOutputAlias = crate::operation::DeleteFolder;
#[doc(hidden)]
pub type DeleteFolderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFolderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFolder`](crate::operation::DeleteFolder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFolder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFolderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.folder_id;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let folder_id = aws_smithy_http::label::fmt_string(input_20, false);
                if folder_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/api/v1/folders/{FolderId}", FolderId = folder_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFolderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_folder(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFolder",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFolderInput`](crate::input::DeleteFolderInput)
    pub fn builder() -> crate::input::delete_folder_input::Builder {
        crate::input::delete_folder_input::Builder::default()
    }
}

/// See [`DeleteFolderContentsInput`](crate::input::DeleteFolderContentsInput)
pub mod delete_folder_contents_input {
    /// A builder for [`DeleteFolderContentsInput`](crate::input::DeleteFolderContentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFolderContentsInput`](crate::input::DeleteFolderContentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFolderContentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFolderContentsInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFolderContentsInputOperationOutputAlias = crate::operation::DeleteFolderContents;
#[doc(hidden)]
pub type DeleteFolderContentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFolderContentsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFolderContents`](crate::operation::DeleteFolderContents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFolderContents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFolderContentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.folder_id;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let folder_id = aws_smithy_http::label::fmt_string(input_21, false);
                if folder_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/folders/{FolderId}/contents",
                    FolderId = folder_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFolderContentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_folder_contents(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFolderContents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFolderContents",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFolderContentsInput`](crate::input::DeleteFolderContentsInput)
    pub fn builder() -> crate::input::delete_folder_contents_input::Builder {
        crate::input::delete_folder_contents_input::Builder::default()
    }
}

/// See [`DeleteLabelsInput`](crate::input::DeleteLabelsInput)
pub mod delete_labels_input {
    /// A builder for [`DeleteLabelsInput`](crate::input::DeleteLabelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) delete_all: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>List of labels to delete from the resource.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>List of labels to delete from the resource.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>Flag to request removal of all labels from the specified resource.</p>
        pub fn delete_all(mut self, input: bool) -> Self {
            self.delete_all = Some(input);
            self
        }
        /// <p>Flag to request removal of all labels from the specified resource.</p>
        pub fn set_delete_all(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_all = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLabelsInput`](crate::input::DeleteLabelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLabelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLabelsInput {
                resource_id: self.resource_id,
                authentication_token: self.authentication_token,
                labels: self.labels,
                delete_all: self.delete_all.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLabelsInputOperationOutputAlias = crate::operation::DeleteLabels;
#[doc(hidden)]
pub type DeleteLabelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLabelsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLabels`](crate::operation::DeleteLabels)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLabels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLabelsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_22 = &_input.resource_id;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_id = aws_smithy_http::label::fmt_string(input_22, false);
                if resource_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/resources/{ResourceId}/labels",
                    ResourceId = resource_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteLabelsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_23) = &_input.labels {
                    for inner_24 in inner_23 {
                        query.push_kv("labels", &aws_smithy_http::query::fmt_string(&inner_24));
                    }
                }
                if _input.delete_all {
                    query.push_kv(
                        "deleteAll",
                        aws_smithy_types::primitive::Encoder::from(_input.delete_all).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLabelsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_labels(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLabels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLabels",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLabelsInput`](crate::input::DeleteLabelsInput)
    pub fn builder() -> crate::input::delete_labels_input::Builder {
        crate::input::delete_labels_input::Builder::default()
    }
}

/// See [`DeleteNotificationSubscriptionInput`](crate::input::DeleteNotificationSubscriptionInput)
pub mod delete_notification_subscription_input {
    /// A builder for [`DeleteNotificationSubscriptionInput`](crate::input::DeleteNotificationSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_id: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the subscription.</p>
        pub fn subscription_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_id = Some(input.into());
            self
        }
        /// <p>The ID of the subscription.</p>
        pub fn set_subscription_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_id = input;
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNotificationSubscriptionInput`](crate::input::DeleteNotificationSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNotificationSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNotificationSubscriptionInput {
                subscription_id: self.subscription_id,
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNotificationSubscriptionInputOperationOutputAlias =
    crate::operation::DeleteNotificationSubscription;
#[doc(hidden)]
pub type DeleteNotificationSubscriptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteNotificationSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNotificationSubscription`](crate::operation::DeleteNotificationSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNotificationSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteNotificationSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.organization_id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "organization_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let organization_id = aws_smithy_http::label::fmt_string(input_25, false);
                if organization_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "organization_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_26 = &_input.subscription_id;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscription_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let subscription_id = aws_smithy_http::label::fmt_string(input_26, false);
                if subscription_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscription_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/organizations/{OrganizationId}/subscriptions/{SubscriptionId}",
                    OrganizationId = organization_id,
                    SubscriptionId = subscription_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteNotificationSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNotificationSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNotificationSubscription",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteNotificationSubscriptionInput`](crate::input::DeleteNotificationSubscriptionInput)
    pub fn builder() -> crate::input::delete_notification_subscription_input::Builder {
        crate::input::delete_notification_subscription_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as in accessing the API using AWS credentials.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as in accessing the API using AWS credentials.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                authentication_token: self.authentication_token,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.user_id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_27, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/api/v1/users/{UserId}", UserId = user_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_user(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DescribeActivitiesInput`](crate::input::DescribeActivitiesInput)
pub mod describe_activities_input {
    /// A builder for [`DescribeActivitiesInput`](crate::input::DescribeActivitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) activity_types: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) include_indirect_activities: std::option::Option<bool>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The timestamp that determines the starting time of the activities. The response includes the activities performed after the specified timestamp.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The timestamp that determines the starting time of the activities. The response includes the activities performed after the specified timestamp.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The timestamp that determines the end time of the activities. The response includes the activities performed before the specified timestamp.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The timestamp that determines the end time of the activities. The response includes the activities performed before the specified timestamp.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>Specifies which activity types to include in the response. If this field is left empty, all activity types are returned.</p>
        pub fn activity_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_types = Some(input.into());
            self
        }
        /// <p>Specifies which activity types to include in the response. If this field is left empty, all activity types are returned.</p>
        pub fn set_activity_types(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activity_types = input;
            self
        }
        /// <p>The document or folder ID for which to describe activity types.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The document or folder ID for which to describe activity types.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ID of the user who performed the action. The response includes activities pertaining to this user. This is an optional parameter and is only applicable for administrative API (SigV4) requests.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user who performed the action. The response includes activities pertaining to this user. This is an optional parameter and is only applicable for administrative API (SigV4) requests.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>Includes indirect activities. An indirect activity results from a direct activity performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of the subfolders and documents within the parent folder (the indirect activity).</p>
        pub fn include_indirect_activities(mut self, input: bool) -> Self {
            self.include_indirect_activities = Some(input);
            self
        }
        /// <p>Includes indirect activities. An indirect activity results from a direct activity performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of the subfolders and documents within the parent folder (the indirect activity).</p>
        pub fn set_include_indirect_activities(mut self, input: std::option::Option<bool>) -> Self {
            self.include_indirect_activities = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActivitiesInput`](crate::input::DescribeActivitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeActivitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeActivitiesInput {
                authentication_token: self.authentication_token,
                start_time: self.start_time,
                end_time: self.end_time,
                organization_id: self.organization_id,
                activity_types: self.activity_types,
                resource_id: self.resource_id,
                user_id: self.user_id,
                include_indirect_activities: self.include_indirect_activities.unwrap_or_default(),
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeActivitiesInputOperationOutputAlias = crate::operation::DescribeActivities;
#[doc(hidden)]
pub type DescribeActivitiesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeActivitiesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeActivities`](crate::operation::DescribeActivities)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeActivities,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeActivitiesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/api/v1/activities").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeActivitiesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_28) = &_input.start_time {
                    query.push_kv(
                        "startTime",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_28,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_29) = &_input.end_time {
                    query.push_kv(
                        "endTime",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_29,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_30) = &_input.organization_id {
                    query.push_kv(
                        "organizationId",
                        &aws_smithy_http::query::fmt_string(&inner_30),
                    );
                }
                if let Some(inner_31) = &_input.activity_types {
                    query.push_kv(
                        "activityTypes",
                        &aws_smithy_http::query::fmt_string(&inner_31),
                    );
                }
                if let Some(inner_32) = &_input.resource_id {
                    query.push_kv("resourceId", &aws_smithy_http::query::fmt_string(&inner_32));
                }
                if let Some(inner_33) = &_input.user_id {
                    query.push_kv("userId", &aws_smithy_http::query::fmt_string(&inner_33));
                }
                if _input.include_indirect_activities {
                    query.push_kv(
                        "includeIndirectActivities",
                        aws_smithy_types::primitive::Encoder::from(
                            _input.include_indirect_activities,
                        )
                        .encode(),
                    );
                }
                if let Some(inner_34) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_34).encode(),
                    );
                }
                if let Some(inner_35) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_35));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeActivitiesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_describe_activities(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeActivities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeActivities",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeActivitiesInput`](crate::input::DescribeActivitiesInput)
    pub fn builder() -> crate::input::describe_activities_input::Builder {
        crate::input::describe_activities_input::Builder::default()
    }
}

/// See [`DescribeCommentsInput`](crate::input::DescribeCommentsInput)
pub mod describe_comments_input {
    /// A builder for [`DescribeCommentsInput`](crate::input::DescribeCommentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCommentsInput`](crate::input::DescribeCommentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCommentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCommentsInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCommentsInputOperationOutputAlias = crate::operation::DescribeComments;
#[doc(hidden)]
pub type DescribeCommentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCommentsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeComments`](crate::operation::DescribeComments)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeComments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeCommentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.document_id;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_36, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_37 = &_input.version_id;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let version_id = aws_smithy_http::label::fmt_string(input_37, false);
                if version_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}/versions/{VersionId}/comments",
                    DocumentId = document_id,
                    VersionId = version_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeCommentsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_38) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_38).encode(),
                    );
                }
                if let Some(inner_39) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_39));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeCommentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_describe_comments(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeComments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeComments",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeCommentsInput`](crate::input::DescribeCommentsInput)
    pub fn builder() -> crate::input::describe_comments_input::Builder {
        crate::input::describe_comments_input::Builder::default()
    }
}

/// See [`DescribeDocumentVersionsInput`](crate::input::DescribeDocumentVersionsInput)
pub mod describe_document_versions_input {
    /// A builder for [`DescribeDocumentVersionsInput`](crate::input::DescribeDocumentVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) include: std::option::Option<std::string::String>,
        pub(crate) fields: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of versions to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of versions to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.</p>
        pub fn include(mut self, input: impl Into<std::string::String>) -> Self {
            self.include = Some(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.</p>
        pub fn set_include(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.include = input;
            self
        }
        /// <p>Specify "SOURCE" to include initialized versions and a URL for the source document.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.fields = Some(input.into());
            self
        }
        /// <p>Specify "SOURCE" to include initialized versions and a URL for the source document.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDocumentVersionsInput`](crate::input::DescribeDocumentVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDocumentVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDocumentVersionsInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                marker: self.marker,
                limit: self.limit,
                include: self.include,
                fields: self.fields,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDocumentVersionsInputOperationOutputAlias =
    crate::operation::DescribeDocumentVersions;
#[doc(hidden)]
pub type DescribeDocumentVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDocumentVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDocumentVersions`](crate::operation::DescribeDocumentVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDocumentVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDocumentVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.document_id;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_40, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}/versions",
                    DocumentId = document_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeDocumentVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_41) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_41));
                }
                if let Some(inner_42) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_42).encode(),
                    );
                }
                if let Some(inner_43) = &_input.include {
                    query.push_kv("include", &aws_smithy_http::query::fmt_string(&inner_43));
                }
                if let Some(inner_44) = &_input.fields {
                    query.push_kv("fields", &aws_smithy_http::query::fmt_string(&inner_44));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDocumentVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_describe_document_versions(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDocumentVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDocumentVersions",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDocumentVersionsInput`](crate::input::DescribeDocumentVersionsInput)
    pub fn builder() -> crate::input::describe_document_versions_input::Builder {
        crate::input::describe_document_versions_input::Builder::default()
    }
}

/// See [`DescribeFolderContentsInput`](crate::input::DescribeFolderContentsInput)
pub mod describe_folder_contents_input {
    /// A builder for [`DescribeFolderContentsInput`](crate::input::DescribeFolderContentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) sort: std::option::Option<crate::model::ResourceSortType>,
        pub(crate) order: std::option::Option<crate::model::OrderType>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::FolderContentType>,
        pub(crate) include: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn sort(mut self, input: crate::model::ResourceSortType) -> Self {
            self.sort = Some(input);
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn set_sort(
            mut self,
            input: std::option::Option<crate::model::ResourceSortType>,
        ) -> Self {
            self.sort = input;
            self
        }
        /// <p>The order for the contents of the folder.</p>
        pub fn order(mut self, input: crate::model::OrderType) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order for the contents of the folder.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::OrderType>) -> Self {
            self.order = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The type of items.</p>
        pub fn r#type(mut self, input: crate::model::FolderContentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of items.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::FolderContentType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The contents to include. Specify "INITIALIZED" to include initialized documents.</p>
        pub fn include(mut self, input: impl Into<std::string::String>) -> Self {
            self.include = Some(input.into());
            self
        }
        /// <p>The contents to include. Specify "INITIALIZED" to include initialized documents.</p>
        pub fn set_include(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.include = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFolderContentsInput`](crate::input::DescribeFolderContentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFolderContentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFolderContentsInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
                sort: self.sort,
                order: self.order,
                limit: self.limit,
                marker: self.marker,
                r#type: self.r#type,
                include: self.include,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFolderContentsInputOperationOutputAlias = crate::operation::DescribeFolderContents;
#[doc(hidden)]
pub type DescribeFolderContentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFolderContentsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFolderContents`](crate::operation::DescribeFolderContents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFolderContents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeFolderContentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_45 = &_input.folder_id;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let folder_id = aws_smithy_http::label::fmt_string(input_45, false);
                if folder_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/folders/{FolderId}/contents",
                    FolderId = folder_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeFolderContentsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_46) = &_input.sort {
                    query.push_kv("sort", &aws_smithy_http::query::fmt_string(&inner_46));
                }
                if let Some(inner_47) = &_input.order {
                    query.push_kv("order", &aws_smithy_http::query::fmt_string(&inner_47));
                }
                if let Some(inner_48) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_48).encode(),
                    );
                }
                if let Some(inner_49) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_49));
                }
                if let Some(inner_50) = &_input.r#type {
                    query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_50));
                }
                if let Some(inner_51) = &_input.include {
                    query.push_kv("include", &aws_smithy_http::query::fmt_string(&inner_51));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeFolderContentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_describe_folder_contents(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFolderContents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFolderContents",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeFolderContentsInput`](crate::input::DescribeFolderContentsInput)
    pub fn builder() -> crate::input::describe_folder_contents_input::Builder {
        crate::input::describe_folder_contents_input::Builder::default()
    }
}

/// See [`DescribeGroupsInput`](crate::input::DescribeGroupsInput)
pub mod describe_groups_input {
    /// A builder for [`DescribeGroupsInput`](crate::input::DescribeGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) search_query: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>A query to describe groups by group name.</p>
        pub fn search_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.search_query = Some(input.into());
            self
        }
        /// <p>A query to describe groups by group name.</p>
        pub fn set_search_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.search_query = input;
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGroupsInput`](crate::input::DescribeGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGroupsInput {
                authentication_token: self.authentication_token,
                search_query: self.search_query,
                organization_id: self.organization_id,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGroupsInputOperationOutputAlias = crate::operation::DescribeGroups;
#[doc(hidden)]
pub type DescribeGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGroups`](crate::operation::DescribeGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/api/v1/groups").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeGroupsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_52) = &_input.search_query {
                    query.push_kv(
                        "searchQuery",
                        &aws_smithy_http::query::fmt_string(&inner_52),
                    );
                }
                if let Some(inner_53) = &_input.organization_id {
                    query.push_kv(
                        "organizationId",
                        &aws_smithy_http::query::fmt_string(&inner_53),
                    );
                }
                if let Some(inner_54) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_54));
                }
                if let Some(inner_55) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_55).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_describe_groups(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGroups",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeGroupsInput`](crate::input::DescribeGroupsInput)
    pub fn builder() -> crate::input::describe_groups_input::Builder {
        crate::input::describe_groups_input::Builder::default()
    }
}

/// See [`DescribeNotificationSubscriptionsInput`](crate::input::DescribeNotificationSubscriptionsInput)
pub mod describe_notification_subscriptions_input {
    /// A builder for [`DescribeNotificationSubscriptionsInput`](crate::input::DescribeNotificationSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotificationSubscriptionsInput`](crate::input::DescribeNotificationSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNotificationSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNotificationSubscriptionsInput {
                organization_id: self.organization_id,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNotificationSubscriptionsInputOperationOutputAlias =
    crate::operation::DescribeNotificationSubscriptions;
#[doc(hidden)]
pub type DescribeNotificationSubscriptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeNotificationSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNotificationSubscriptions`](crate::operation::DescribeNotificationSubscriptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNotificationSubscriptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeNotificationSubscriptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_56 = &_input.organization_id;
                let input_56 = input_56.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "organization_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let organization_id = aws_smithy_http::label::fmt_string(input_56, false);
                if organization_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "organization_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/organizations/{OrganizationId}/subscriptions",
                    OrganizationId = organization_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeNotificationSubscriptionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_57) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_57));
                }
                if let Some(inner_58) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_58).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeNotificationSubscriptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNotificationSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNotificationSubscriptions",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeNotificationSubscriptionsInput`](crate::input::DescribeNotificationSubscriptionsInput)
    pub fn builder() -> crate::input::describe_notification_subscriptions_input::Builder {
        crate::input::describe_notification_subscriptions_input::Builder::default()
    }
}

/// See [`DescribeResourcePermissionsInput`](crate::input::DescribeResourcePermissionsInput)
pub mod describe_resource_permissions_input {
    /// A builder for [`DescribeResourcePermissionsInput`](crate::input::DescribeResourcePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ID of the principal to filter permissions by.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The ID of the principal to filter permissions by.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourcePermissionsInput`](crate::input::DescribeResourcePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeResourcePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeResourcePermissionsInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
                principal_id: self.principal_id,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeResourcePermissionsInputOperationOutputAlias =
    crate::operation::DescribeResourcePermissions;
#[doc(hidden)]
pub type DescribeResourcePermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeResourcePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeResourcePermissions`](crate::operation::DescribeResourcePermissions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeResourcePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeResourcePermissionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_59 = &_input.resource_id;
                let input_59 = input_59.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_id = aws_smithy_http::label::fmt_string(input_59, false);
                if resource_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/resources/{ResourceId}/permissions",
                    ResourceId = resource_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeResourcePermissionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_60) = &_input.principal_id {
                    query.push_kv(
                        "principalId",
                        &aws_smithy_http::query::fmt_string(&inner_60),
                    );
                }
                if let Some(inner_61) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_61).encode(),
                    );
                }
                if let Some(inner_62) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_62));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeResourcePermissionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_describe_resource_permissions(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeResourcePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeResourcePermissions",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeResourcePermissionsInput`](crate::input::DescribeResourcePermissionsInput)
    pub fn builder() -> crate::input::describe_resource_permissions_input::Builder {
        crate::input::describe_resource_permissions_input::Builder::default()
    }
}

/// See [`DescribeRootFoldersInput`](crate::input::DescribeRootFoldersInput)
pub mod describe_root_folders_input {
    /// A builder for [`DescribeRootFoldersInput`](crate::input::DescribeRootFoldersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRootFoldersInput`](crate::input::DescribeRootFoldersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRootFoldersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRootFoldersInput {
                authentication_token: self.authentication_token,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRootFoldersInputOperationOutputAlias = crate::operation::DescribeRootFolders;
#[doc(hidden)]
pub type DescribeRootFoldersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRootFoldersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRootFolders`](crate::operation::DescribeRootFolders)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRootFolders,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRootFoldersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/api/v1/me/root").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeRootFoldersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_63) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_63).encode(),
                    );
                }
                if let Some(inner_64) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_64));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRootFoldersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_describe_root_folders(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRootFolders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRootFolders",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRootFoldersInput`](crate::input::DescribeRootFoldersInput)
    pub fn builder() -> crate::input::describe_root_folders_input::Builder {
        crate::input::describe_root_folders_input::Builder::default()
    }
}

/// See [`DescribeUsersInput`](crate::input::DescribeUsersInput)
pub mod describe_users_input {
    /// A builder for [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_ids: std::option::Option<std::string::String>,
        pub(crate) query: std::option::Option<std::string::String>,
        pub(crate) include: std::option::Option<crate::model::UserFilterType>,
        pub(crate) order: std::option::Option<crate::model::OrderType>,
        pub(crate) sort: std::option::Option<crate::model::UserSortType>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) fields: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The IDs of the users.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_ids = Some(input.into());
            self
        }
        /// <p>The IDs of the users.</p>
        pub fn set_user_ids(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_ids = input;
            self
        }
        /// <p>A query to filter users by user name.</p>
        pub fn query(mut self, input: impl Into<std::string::String>) -> Self {
            self.query = Some(input.into());
            self
        }
        /// <p>A query to filter users by user name.</p>
        pub fn set_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query = input;
            self
        }
        /// <p>The state of the users. Specify "ALL" to include inactive users.</p>
        pub fn include(mut self, input: crate::model::UserFilterType) -> Self {
            self.include = Some(input);
            self
        }
        /// <p>The state of the users. Specify "ALL" to include inactive users.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<crate::model::UserFilterType>,
        ) -> Self {
            self.include = input;
            self
        }
        /// <p>The order for the results.</p>
        pub fn order(mut self, input: crate::model::OrderType) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order for the results.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::OrderType>) -> Self {
            self.order = input;
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn sort(mut self, input: crate::model::UserSortType) -> Self {
            self.sort = Some(input);
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::UserSortType>) -> Self {
            self.sort = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A comma-separated list of values. Specify "STORAGE_METADATA" to include the user storage quota and utilization information.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.fields = Some(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "STORAGE_METADATA" to include the user storage quota and utilization information.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsersInput`](crate::input::DescribeUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUsersInput {
                authentication_token: self.authentication_token,
                organization_id: self.organization_id,
                user_ids: self.user_ids,
                query: self.query,
                include: self.include,
                order: self.order,
                sort: self.sort,
                marker: self.marker,
                limit: self.limit,
                fields: self.fields,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUsersInputOperationOutputAlias = crate::operation::DescribeUsers;
#[doc(hidden)]
pub type DescribeUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUsersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUsers`](crate::operation::DescribeUsers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeUsersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/api/v1/users").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeUsersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_65) = &_input.organization_id {
                    query.push_kv(
                        "organizationId",
                        &aws_smithy_http::query::fmt_string(&inner_65),
                    );
                }
                if let Some(inner_66) = &_input.user_ids {
                    query.push_kv("userIds", &aws_smithy_http::query::fmt_string(&inner_66));
                }
                if let Some(inner_67) = &_input.query {
                    query.push_kv("query", &aws_smithy_http::query::fmt_string(&inner_67));
                }
                if let Some(inner_68) = &_input.include {
                    query.push_kv("include", &aws_smithy_http::query::fmt_string(&inner_68));
                }
                if let Some(inner_69) = &_input.order {
                    query.push_kv("order", &aws_smithy_http::query::fmt_string(&inner_69));
                }
                if let Some(inner_70) = &_input.sort {
                    query.push_kv("sort", &aws_smithy_http::query::fmt_string(&inner_70));
                }
                if let Some(inner_71) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_71));
                }
                if let Some(inner_72) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_72).encode(),
                    );
                }
                if let Some(inner_73) = &_input.fields {
                    query.push_kv("fields", &aws_smithy_http::query::fmt_string(&inner_73));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeUsersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_describe_users(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUsers",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    pub fn builder() -> crate::input::describe_users_input::Builder {
        crate::input::describe_users_input::Builder::default()
    }
}

/// See [`GetCurrentUserInput`](crate::input::GetCurrentUserInput)
pub mod get_current_user_input {
    /// A builder for [`GetCurrentUserInput`](crate::input::GetCurrentUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCurrentUserInput`](crate::input::GetCurrentUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCurrentUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCurrentUserInput {
                authentication_token: self.authentication_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCurrentUserInputOperationOutputAlias = crate::operation::GetCurrentUser;
#[doc(hidden)]
pub type GetCurrentUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCurrentUserInput {
    /// Consumes the builder and constructs an Operation<[`GetCurrentUser`](crate::operation::GetCurrentUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCurrentUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCurrentUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/api/v1/me").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCurrentUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_current_user(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCurrentUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCurrentUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCurrentUserInput`](crate::input::GetCurrentUserInput)
    pub fn builder() -> crate::input::get_current_user_input::Builder {
        crate::input::get_current_user_input::Builder::default()
    }
}

/// See [`GetDocumentInput`](crate::input::GetDocumentInput)
pub mod get_document_input {
    /// A builder for [`GetDocumentInput`](crate::input::GetDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) include_custom_metadata: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>Set this to <code>TRUE</code> to include custom metadata in the response.</p>
        pub fn include_custom_metadata(mut self, input: bool) -> Self {
            self.include_custom_metadata = Some(input);
            self
        }
        /// <p>Set this to <code>TRUE</code> to include custom metadata in the response.</p>
        pub fn set_include_custom_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.include_custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentInput`](crate::input::GetDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                include_custom_metadata: self.include_custom_metadata.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentInputOperationOutputAlias = crate::operation::GetDocument;
#[doc(hidden)]
pub type GetDocumentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDocumentInput {
    /// Consumes the builder and constructs an Operation<[`GetDocument`](crate::operation::GetDocument)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocument,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDocumentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_74 = &_input.document_id;
                let input_74 = input_74.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_74, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}",
                    DocumentId = document_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetDocumentInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.include_custom_metadata {
                    query.push_kv(
                        "includeCustomMetadata",
                        aws_smithy_types::primitive::Encoder::from(_input.include_custom_metadata)
                            .encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDocumentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_document(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocument",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentInput`](crate::input::GetDocumentInput)
    pub fn builder() -> crate::input::get_document_input::Builder {
        crate::input::get_document_input::Builder::default()
    }
}

/// See [`GetDocumentPathInput`](crate::input::GetDocumentPathInput)
pub mod get_document_path_input {
    /// A builder for [`GetDocumentPathInput`](crate::input::GetDocumentPathInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) fields: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A comma-separated list of values. Specify <code>NAME</code> to include the names of the parent folders.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.fields = Some(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify <code>NAME</code> to include the names of the parent folders.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fields = input;
            self
        }
        /// <p>This value is not supported.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>This value is not supported.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentPathInput`](crate::input::GetDocumentPathInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentPathInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentPathInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                limit: self.limit,
                fields: self.fields,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentPathInputOperationOutputAlias = crate::operation::GetDocumentPath;
#[doc(hidden)]
pub type GetDocumentPathInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDocumentPathInput {
    /// Consumes the builder and constructs an Operation<[`GetDocumentPath`](crate::operation::GetDocumentPath)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocumentPath,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDocumentPathInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_75 = &_input.document_id;
                let input_75 = input_75.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_75, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}/path",
                    DocumentId = document_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetDocumentPathInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_76) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_76).encode(),
                    );
                }
                if let Some(inner_77) = &_input.fields {
                    query.push_kv("fields", &aws_smithy_http::query::fmt_string(&inner_77));
                }
                if let Some(inner_78) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_78));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDocumentPathInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_document_path(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocumentPath::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocumentPath",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentPathInput`](crate::input::GetDocumentPathInput)
    pub fn builder() -> crate::input::get_document_path_input::Builder {
        crate::input::get_document_path_input::Builder::default()
    }
}

/// See [`GetDocumentVersionInput`](crate::input::GetDocumentVersionInput)
pub mod get_document_version_input {
    /// A builder for [`GetDocumentVersionInput`](crate::input::GetDocumentVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) fields: std::option::Option<std::string::String>,
        pub(crate) include_custom_metadata: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.fields = Some(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fields = input;
            self
        }
        /// <p>Set this to TRUE to include custom metadata in the response.</p>
        pub fn include_custom_metadata(mut self, input: bool) -> Self {
            self.include_custom_metadata = Some(input);
            self
        }
        /// <p>Set this to TRUE to include custom metadata in the response.</p>
        pub fn set_include_custom_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.include_custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentVersionInput`](crate::input::GetDocumentVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentVersionInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
                fields: self.fields,
                include_custom_metadata: self.include_custom_metadata.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentVersionInputOperationOutputAlias = crate::operation::GetDocumentVersion;
#[doc(hidden)]
pub type GetDocumentVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDocumentVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetDocumentVersion`](crate::operation::GetDocumentVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocumentVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDocumentVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_79 = &_input.document_id;
                let input_79 = input_79.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_79, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_80 = &_input.version_id;
                let input_80 = input_80.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let version_id = aws_smithy_http::label::fmt_string(input_80, false);
                if version_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}/versions/{VersionId}",
                    DocumentId = document_id,
                    VersionId = version_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetDocumentVersionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_81) = &_input.fields {
                    query.push_kv("fields", &aws_smithy_http::query::fmt_string(&inner_81));
                }
                if _input.include_custom_metadata {
                    query.push_kv(
                        "includeCustomMetadata",
                        aws_smithy_types::primitive::Encoder::from(_input.include_custom_metadata)
                            .encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDocumentVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_document_version(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocumentVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocumentVersion",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentVersionInput`](crate::input::GetDocumentVersionInput)
    pub fn builder() -> crate::input::get_document_version_input::Builder {
        crate::input::get_document_version_input::Builder::default()
    }
}

/// See [`GetFolderInput`](crate::input::GetFolderInput)
pub mod get_folder_input {
    /// A builder for [`GetFolderInput`](crate::input::GetFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) include_custom_metadata: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>Set to TRUE to include custom metadata in the response.</p>
        pub fn include_custom_metadata(mut self, input: bool) -> Self {
            self.include_custom_metadata = Some(input);
            self
        }
        /// <p>Set to TRUE to include custom metadata in the response.</p>
        pub fn set_include_custom_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.include_custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFolderInput`](crate::input::GetFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetFolderInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetFolderInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
                include_custom_metadata: self.include_custom_metadata.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetFolderInputOperationOutputAlias = crate::operation::GetFolder;
#[doc(hidden)]
pub type GetFolderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFolderInput {
    /// Consumes the builder and constructs an Operation<[`GetFolder`](crate::operation::GetFolder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFolder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFolderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_82 = &_input.folder_id;
                let input_82 = input_82.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let folder_id = aws_smithy_http::label::fmt_string(input_82, false);
                if folder_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/api/v1/folders/{FolderId}", FolderId = folder_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetFolderInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.include_custom_metadata {
                    query.push_kv(
                        "includeCustomMetadata",
                        aws_smithy_types::primitive::Encoder::from(_input.include_custom_metadata)
                            .encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFolderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_folder(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetFolder::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetFolder",
                    "workdocs",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFolderInput`](crate::input::GetFolderInput)
    pub fn builder() -> crate::input::get_folder_input::Builder {
        crate::input::get_folder_input::Builder::default()
    }
}

/// See [`GetFolderPathInput`](crate::input::GetFolderPathInput)
pub mod get_folder_path_input {
    /// A builder for [`GetFolderPathInput`](crate::input::GetFolderPathInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) fields: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A comma-separated list of values. Specify "NAME" to include the names of the parent folders.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.fields = Some(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "NAME" to include the names of the parent folders.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fields = input;
            self
        }
        /// <p>This value is not supported.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>This value is not supported.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFolderPathInput`](crate::input::GetFolderPathInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFolderPathInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFolderPathInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
                limit: self.limit,
                fields: self.fields,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFolderPathInputOperationOutputAlias = crate::operation::GetFolderPath;
#[doc(hidden)]
pub type GetFolderPathInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFolderPathInput {
    /// Consumes the builder and constructs an Operation<[`GetFolderPath`](crate::operation::GetFolderPath)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFolderPath,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFolderPathInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_83 = &_input.folder_id;
                let input_83 = input_83.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let folder_id = aws_smithy_http::label::fmt_string(input_83, false);
                if folder_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/folders/{FolderId}/path",
                    FolderId = folder_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetFolderPathInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_84) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_84).encode(),
                    );
                }
                if let Some(inner_85) = &_input.fields {
                    query.push_kv("fields", &aws_smithy_http::query::fmt_string(&inner_85));
                }
                if let Some(inner_86) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_86));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFolderPathInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_folder_path(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFolderPath::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFolderPath",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFolderPathInput`](crate::input::GetFolderPathInput)
    pub fn builder() -> crate::input::get_folder_path_input::Builder {
        crate::input::get_folder_path_input::Builder::default()
    }
}

/// See [`GetResourcesInput`](crate::input::GetResourcesInput)
pub mod get_resources_input {
    /// A builder for [`GetResourcesInput`](crate::input::GetResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) collection_type: std::option::Option<crate::model::ResourceCollectionType>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The user ID for the resource collection. This is a required field for accessing the API operation using IAM credentials.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID for the resource collection. This is a required field for accessing the API operation using IAM credentials.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The collection type.</p>
        pub fn collection_type(mut self, input: crate::model::ResourceCollectionType) -> Self {
            self.collection_type = Some(input);
            self
        }
        /// <p>The collection type.</p>
        pub fn set_collection_type(
            mut self,
            input: std::option::Option<crate::model::ResourceCollectionType>,
        ) -> Self {
            self.collection_type = input;
            self
        }
        /// <p>The maximum number of resources to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of resources to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcesInput`](crate::input::GetResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourcesInput {
                authentication_token: self.authentication_token,
                user_id: self.user_id,
                collection_type: self.collection_type,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourcesInputOperationOutputAlias = crate::operation::GetResources;
#[doc(hidden)]
pub type GetResourcesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetResourcesInput {
    /// Consumes the builder and constructs an Operation<[`GetResources`](crate::operation::GetResources)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetResourcesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/api/v1/resources").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetResourcesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_87) = &_input.user_id {
                    query.push_kv("userId", &aws_smithy_http::query::fmt_string(&inner_87));
                }
                if let Some(inner_88) = &_input.collection_type {
                    query.push_kv(
                        "collectionType",
                        &aws_smithy_http::query::fmt_string(&inner_88),
                    );
                }
                if let Some(inner_89) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_89).encode(),
                    );
                }
                if let Some(inner_90) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_90));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetResourcesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_resources(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResources",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetResourcesInput`](crate::input::GetResourcesInput)
    pub fn builder() -> crate::input::get_resources_input::Builder {
        crate::input::get_resources_input::Builder::default()
    }
}

/// See [`InitiateDocumentVersionUploadInput`](crate::input::InitiateDocumentVersionUploadInput)
pub mod initiate_document_version_upload_input {
    /// A builder for [`InitiateDocumentVersionUploadInput`](crate::input::InitiateDocumentVersionUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) content_created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) content_modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) document_size_in_bytes: std::option::Option<i64>,
        pub(crate) parent_folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The timestamp when the content of the document was originally created.</p>
        pub fn content_created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.content_created_timestamp = Some(input);
            self
        }
        /// <p>The timestamp when the content of the document was originally created.</p>
        pub fn set_content_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.content_created_timestamp = input;
            self
        }
        /// <p>The timestamp when the content of the document was modified.</p>
        pub fn content_modified_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.content_modified_timestamp = Some(input);
            self
        }
        /// <p>The timestamp when the content of the document was modified.</p>
        pub fn set_content_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.content_modified_timestamp = input;
            self
        }
        /// <p>The content type of the document.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content type of the document.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The size of the document, in bytes.</p>
        pub fn document_size_in_bytes(mut self, input: i64) -> Self {
            self.document_size_in_bytes = Some(input);
            self
        }
        /// <p>The size of the document, in bytes.</p>
        pub fn set_document_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.document_size_in_bytes = input;
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateDocumentVersionUploadInput`](crate::input::InitiateDocumentVersionUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InitiateDocumentVersionUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InitiateDocumentVersionUploadInput {
                authentication_token: self.authentication_token,
                id: self.id,
                name: self.name,
                content_created_timestamp: self.content_created_timestamp,
                content_modified_timestamp: self.content_modified_timestamp,
                content_type: self.content_type,
                document_size_in_bytes: self.document_size_in_bytes,
                parent_folder_id: self.parent_folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type InitiateDocumentVersionUploadInputOperationOutputAlias =
    crate::operation::InitiateDocumentVersionUpload;
#[doc(hidden)]
pub type InitiateDocumentVersionUploadInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl InitiateDocumentVersionUploadInput {
    /// Consumes the builder and constructs an Operation<[`InitiateDocumentVersionUpload`](crate::operation::InitiateDocumentVersionUpload)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InitiateDocumentVersionUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::InitiateDocumentVersionUploadInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/api/v1/documents").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::InitiateDocumentVersionUploadInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_initiate_document_version_upload(
                    input, builder,
                )?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_initiate_document_version_upload(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InitiateDocumentVersionUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InitiateDocumentVersionUpload",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`InitiateDocumentVersionUploadInput`](crate::input::InitiateDocumentVersionUploadInput)
    pub fn builder() -> crate::input::initiate_document_version_upload_input::Builder {
        crate::input::initiate_document_version_upload_input::Builder::default()
    }
}

/// See [`RemoveAllResourcePermissionsInput`](crate::input::RemoveAllResourcePermissionsInput)
pub mod remove_all_resource_permissions_input {
    /// A builder for [`RemoveAllResourcePermissionsInput`](crate::input::RemoveAllResourcePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAllResourcePermissionsInput`](crate::input::RemoveAllResourcePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveAllResourcePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveAllResourcePermissionsInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveAllResourcePermissionsInputOperationOutputAlias =
    crate::operation::RemoveAllResourcePermissions;
#[doc(hidden)]
pub type RemoveAllResourcePermissionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl RemoveAllResourcePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveAllResourcePermissions`](crate::operation::RemoveAllResourcePermissions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveAllResourcePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemoveAllResourcePermissionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_91 = &_input.resource_id;
                let input_91 = input_91.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_id = aws_smithy_http::label::fmt_string(input_91, false);
                if resource_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/resources/{ResourceId}/permissions",
                    ResourceId = resource_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemoveAllResourcePermissionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_remove_all_resource_permissions(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveAllResourcePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveAllResourcePermissions",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemoveAllResourcePermissionsInput`](crate::input::RemoveAllResourcePermissionsInput)
    pub fn builder() -> crate::input::remove_all_resource_permissions_input::Builder {
        crate::input::remove_all_resource_permissions_input::Builder::default()
    }
}

/// See [`RemoveResourcePermissionInput`](crate::input::RemoveResourcePermissionInput)
pub mod remove_resource_permission_input {
    /// A builder for [`RemoveResourcePermissionInput`](crate::input::RemoveResourcePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) principal_type: std::option::Option<crate::model::PrincipalType>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The principal ID of the resource.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID of the resource.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The principal type of the resource.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.principal_type = Some(input);
            self
        }
        /// <p>The principal type of the resource.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.principal_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveResourcePermissionInput`](crate::input::RemoveResourcePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveResourcePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveResourcePermissionInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
                principal_id: self.principal_id,
                principal_type: self.principal_type,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveResourcePermissionInputOperationOutputAlias =
    crate::operation::RemoveResourcePermission;
#[doc(hidden)]
pub type RemoveResourcePermissionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveResourcePermissionInput {
    /// Consumes the builder and constructs an Operation<[`RemoveResourcePermission`](crate::operation::RemoveResourcePermission)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveResourcePermission,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemoveResourcePermissionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_92 = &_input.resource_id;
                let input_92 = input_92.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_id = aws_smithy_http::label::fmt_string(input_92, false);
                if resource_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_93 = &_input.principal_id;
                let input_93 = input_93.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let principal_id = aws_smithy_http::label::fmt_string(input_93, false);
                if principal_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/resources/{ResourceId}/permissions/{PrincipalId}",
                    ResourceId = resource_id,
                    PrincipalId = principal_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::RemoveResourcePermissionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_94) = &_input.principal_type {
                    query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_94));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemoveResourcePermissionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_remove_resource_permission(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveResourcePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveResourcePermission",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemoveResourcePermissionInput`](crate::input::RemoveResourcePermissionInput)
    pub fn builder() -> crate::input::remove_resource_permission_input::Builder {
        crate::input::remove_resource_permission_input::Builder::default()
    }
}

/// See [`UpdateDocumentInput`](crate::input::UpdateDocumentInput)
pub mod update_document_input {
    /// A builder for [`UpdateDocumentInput`](crate::input::UpdateDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parent_folder_id: std::option::Option<std::string::String>,
        pub(crate) resource_state: std::option::Option<crate::model::ResourceStateType>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The name of the document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_id = input;
            self
        }
        /// <p>The resource state of the document. Only ACTIVE and RECYCLED are supported.</p>
        pub fn resource_state(mut self, input: crate::model::ResourceStateType) -> Self {
            self.resource_state = Some(input);
            self
        }
        /// <p>The resource state of the document. Only ACTIVE and RECYCLED are supported.</p>
        pub fn set_resource_state(
            mut self,
            input: std::option::Option<crate::model::ResourceStateType>,
        ) -> Self {
            self.resource_state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDocumentInput`](crate::input::UpdateDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDocumentInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                name: self.name,
                parent_folder_id: self.parent_folder_id,
                resource_state: self.resource_state,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDocumentInputOperationOutputAlias = crate::operation::UpdateDocument;
#[doc(hidden)]
pub type UpdateDocumentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDocumentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDocument`](crate::operation::UpdateDocument)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDocument,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDocumentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_95 = &_input.document_id;
                let input_95 = input_95.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_95, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}",
                    DocumentId = document_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDocumentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_document(input, builder)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_document(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDocument",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDocumentInput`](crate::input::UpdateDocumentInput)
    pub fn builder() -> crate::input::update_document_input::Builder {
        crate::input::update_document_input::Builder::default()
    }
}

/// See [`UpdateDocumentVersionInput`](crate::input::UpdateDocumentVersionInput)
pub mod update_document_version_input {
    /// A builder for [`UpdateDocumentVersionInput`](crate::input::UpdateDocumentVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) version_status: std::option::Option<crate::model::DocumentVersionStatus>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The status of the version.</p>
        pub fn version_status(mut self, input: crate::model::DocumentVersionStatus) -> Self {
            self.version_status = Some(input);
            self
        }
        /// <p>The status of the version.</p>
        pub fn set_version_status(
            mut self,
            input: std::option::Option<crate::model::DocumentVersionStatus>,
        ) -> Self {
            self.version_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDocumentVersionInput`](crate::input::UpdateDocumentVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDocumentVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDocumentVersionInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
                version_status: self.version_status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDocumentVersionInputOperationOutputAlias = crate::operation::UpdateDocumentVersion;
#[doc(hidden)]
pub type UpdateDocumentVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDocumentVersionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDocumentVersion`](crate::operation::UpdateDocumentVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDocumentVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDocumentVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_96 = &_input.document_id;
                let input_96 = input_96.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let document_id = aws_smithy_http::label::fmt_string(input_96, false);
                if document_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_97 = &_input.version_id;
                let input_97 = input_97.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let version_id = aws_smithy_http::label::fmt_string(input_97, false);
                if version_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/api/v1/documents/{DocumentId}/versions/{VersionId}",
                    DocumentId = document_id,
                    VersionId = version_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDocumentVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_update_document_version(input, builder)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_document_version(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDocumentVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDocumentVersion",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDocumentVersionInput`](crate::input::UpdateDocumentVersionInput)
    pub fn builder() -> crate::input::update_document_version_input::Builder {
        crate::input::update_document_version_input::Builder::default()
    }
}

/// See [`UpdateFolderInput`](crate::input::UpdateFolderInput)
pub mod update_folder_input {
    /// A builder for [`UpdateFolderInput`](crate::input::UpdateFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parent_folder_id: std::option::Option<std::string::String>,
        pub(crate) resource_state: std::option::Option<crate::model::ResourceStateType>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The name of the folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_id = input;
            self
        }
        /// <p>The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.</p>
        pub fn resource_state(mut self, input: crate::model::ResourceStateType) -> Self {
            self.resource_state = Some(input);
            self
        }
        /// <p>The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.</p>
        pub fn set_resource_state(
            mut self,
            input: std::option::Option<crate::model::ResourceStateType>,
        ) -> Self {
            self.resource_state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFolderInput`](crate::input::UpdateFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFolderInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
                name: self.name,
                parent_folder_id: self.parent_folder_id,
                resource_state: self.resource_state,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFolderInputOperationOutputAlias = crate::operation::UpdateFolder;
#[doc(hidden)]
pub type UpdateFolderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFolderInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFolder`](crate::operation::UpdateFolder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFolder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFolderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_98 = &_input.folder_id;
                let input_98 = input_98.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let folder_id = aws_smithy_http::label::fmt_string(input_98, false);
                if folder_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/api/v1/folders/{FolderId}", FolderId = folder_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFolderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_folder(input, builder)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_folder(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFolder",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFolderInput`](crate::input::UpdateFolderInput)
    pub fn builder() -> crate::input::update_folder_input::Builder {
        crate::input::update_folder_input::Builder::default()
    }
}

/// See [`UpdateUserInput`](crate::input::UpdateUserInput)
pub mod update_user_input {
    /// A builder for [`UpdateUserInput`](crate::input::UpdateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) given_name: std::option::Option<std::string::String>,
        pub(crate) surname: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::UserType>,
        pub(crate) storage_rule: std::option::Option<crate::model::StorageRuleType>,
        pub(crate) time_zone_id: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<crate::model::LocaleType>,
        pub(crate) grant_poweruser_privileges: std::option::Option<crate::model::BooleanEnumType>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The given name of the user.</p>
        pub fn given_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.given_name = Some(input.into());
            self
        }
        /// <p>The given name of the user.</p>
        pub fn set_given_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.given_name = input;
            self
        }
        /// <p>The surname of the user.</p>
        pub fn surname(mut self, input: impl Into<std::string::String>) -> Self {
            self.surname = Some(input.into());
            self
        }
        /// <p>The surname of the user.</p>
        pub fn set_surname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.surname = input;
            self
        }
        /// <p>The type of the user.</p>
        pub fn r#type(mut self, input: crate::model::UserType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the user.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn storage_rule(mut self, input: crate::model::StorageRuleType) -> Self {
            self.storage_rule = Some(input);
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn set_storage_rule(
            mut self,
            input: std::option::Option<crate::model::StorageRuleType>,
        ) -> Self {
            self.storage_rule = input;
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn time_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone_id = Some(input.into());
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn set_time_zone_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone_id = input;
            self
        }
        /// <p>The locale of the user.</p>
        pub fn locale(mut self, input: crate::model::LocaleType) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale of the user.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::LocaleType>) -> Self {
            self.locale = input;
            self
        }
        /// <p>Boolean value to determine whether the user is granted Poweruser privileges.</p>
        pub fn grant_poweruser_privileges(mut self, input: crate::model::BooleanEnumType) -> Self {
            self.grant_poweruser_privileges = Some(input);
            self
        }
        /// <p>Boolean value to determine whether the user is granted Poweruser privileges.</p>
        pub fn set_grant_poweruser_privileges(
            mut self,
            input: std::option::Option<crate::model::BooleanEnumType>,
        ) -> Self {
            self.grant_poweruser_privileges = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserInput`](crate::input::UpdateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserInput {
                authentication_token: self.authentication_token,
                user_id: self.user_id,
                given_name: self.given_name,
                surname: self.surname,
                r#type: self.r#type,
                storage_rule: self.storage_rule,
                time_zone_id: self.time_zone_id,
                locale: self.locale,
                grant_poweruser_privileges: self.grant_poweruser_privileges,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserInputOperationOutputAlias = crate::operation::UpdateUser;
#[doc(hidden)]
pub type UpdateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateUserInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUser`](crate::operation::UpdateUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_99 = &_input.user_id;
                let input_99 = input_99.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let user_id = aws_smithy_http::label::fmt_string(input_99, false);
                if user_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/api/v1/users/{UserId}", UserId = user_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_user(input, builder)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The given name of the user.</p>
    pub given_name: std::option::Option<std::string::String>,
    /// <p>The surname of the user.</p>
    pub surname: std::option::Option<std::string::String>,
    /// <p>The type of the user.</p>
    pub r#type: std::option::Option<crate::model::UserType>,
    /// <p>The amount of storage for the user.</p>
    pub storage_rule: std::option::Option<crate::model::StorageRuleType>,
    /// <p>The time zone ID of the user.</p>
    pub time_zone_id: std::option::Option<std::string::String>,
    /// <p>The locale of the user.</p>
    pub locale: std::option::Option<crate::model::LocaleType>,
    /// <p>Boolean value to determine whether the user is granted Poweruser privileges.</p>
    pub grant_poweruser_privileges: std::option::Option<crate::model::BooleanEnumType>,
}
impl UpdateUserInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The given name of the user.</p>
    pub fn given_name(&self) -> std::option::Option<&str> {
        self.given_name.as_deref()
    }
    /// <p>The surname of the user.</p>
    pub fn surname(&self) -> std::option::Option<&str> {
        self.surname.as_deref()
    }
    /// <p>The type of the user.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UserType> {
        self.r#type.as_ref()
    }
    /// <p>The amount of storage for the user.</p>
    pub fn storage_rule(&self) -> std::option::Option<&crate::model::StorageRuleType> {
        self.storage_rule.as_ref()
    }
    /// <p>The time zone ID of the user.</p>
    pub fn time_zone_id(&self) -> std::option::Option<&str> {
        self.time_zone_id.as_deref()
    }
    /// <p>The locale of the user.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::LocaleType> {
        self.locale.as_ref()
    }
    /// <p>Boolean value to determine whether the user is granted Poweruser privileges.</p>
    pub fn grant_poweruser_privileges(
        &self,
    ) -> std::option::Option<&crate::model::BooleanEnumType> {
        self.grant_poweruser_privileges.as_ref()
    }
}
impl std::fmt::Debug for UpdateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("user_id", &self.user_id);
        formatter.field("given_name", &self.given_name);
        formatter.field("surname", &self.surname);
        formatter.field("r#type", &self.r#type);
        formatter.field("storage_rule", &self.storage_rule);
        formatter.field("time_zone_id", &self.time_zone_id);
        formatter.field("locale", &self.locale);
        formatter.field(
            "grant_poweruser_privileges",
            &self.grant_poweruser_privileges,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The name of the folder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the parent folder.</p>
    pub parent_folder_id: std::option::Option<std::string::String>,
    /// <p>The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.</p>
    pub resource_state: std::option::Option<crate::model::ResourceStateType>,
}
impl UpdateFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>The name of the folder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the parent folder.</p>
    pub fn parent_folder_id(&self) -> std::option::Option<&str> {
        self.parent_folder_id.as_deref()
    }
    /// <p>The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.</p>
    pub fn resource_state(&self) -> std::option::Option<&crate::model::ResourceStateType> {
        self.resource_state.as_ref()
    }
}
impl std::fmt::Debug for UpdateFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFolderInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.field("name", &self.name);
        formatter.field("parent_folder_id", &self.parent_folder_id);
        formatter.field("resource_state", &self.resource_state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentVersionInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The version ID of the document.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The status of the version.</p>
    pub version_status: std::option::Option<crate::model::DocumentVersionStatus>,
}
impl UpdateDocumentVersionInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The version ID of the document.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The status of the version.</p>
    pub fn version_status(&self) -> std::option::Option<&crate::model::DocumentVersionStatus> {
        self.version_status.as_ref()
    }
}
impl std::fmt::Debug for UpdateDocumentVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentVersionInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("version_status", &self.version_status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The name of the document.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the parent folder.</p>
    pub parent_folder_id: std::option::Option<std::string::String>,
    /// <p>The resource state of the document. Only ACTIVE and RECYCLED are supported.</p>
    pub resource_state: std::option::Option<crate::model::ResourceStateType>,
}
impl UpdateDocumentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The name of the document.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the parent folder.</p>
    pub fn parent_folder_id(&self) -> std::option::Option<&str> {
        self.parent_folder_id.as_deref()
    }
    /// <p>The resource state of the document. Only ACTIVE and RECYCLED are supported.</p>
    pub fn resource_state(&self) -> std::option::Option<&crate::model::ResourceStateType> {
        self.resource_state.as_ref()
    }
}
impl std::fmt::Debug for UpdateDocumentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("name", &self.name);
        formatter.field("parent_folder_id", &self.parent_folder_id);
        formatter.field("resource_state", &self.resource_state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveResourcePermissionInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The principal ID of the resource.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The principal type of the resource.</p>
    pub principal_type: std::option::Option<crate::model::PrincipalType>,
}
impl RemoveResourcePermissionInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The principal ID of the resource.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The principal type of the resource.</p>
    pub fn principal_type(&self) -> std::option::Option<&crate::model::PrincipalType> {
        self.principal_type.as_ref()
    }
}
impl std::fmt::Debug for RemoveResourcePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveResourcePermissionInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("principal_type", &self.principal_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAllResourcePermissionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl RemoveAllResourcePermissionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for RemoveAllResourcePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAllResourcePermissionsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateDocumentVersionUploadInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the document.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The timestamp when the content of the document was originally created.</p>
    pub content_created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when the content of the document was modified.</p>
    pub content_modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The content type of the document.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The size of the document, in bytes.</p>
    pub document_size_in_bytes: std::option::Option<i64>,
    /// <p>The ID of the parent folder.</p>
    pub parent_folder_id: std::option::Option<std::string::String>,
}
impl InitiateDocumentVersionUploadInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the document.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The timestamp when the content of the document was originally created.</p>
    pub fn content_created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.content_created_timestamp.as_ref()
    }
    /// <p>The timestamp when the content of the document was modified.</p>
    pub fn content_modified_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.content_modified_timestamp.as_ref()
    }
    /// <p>The content type of the document.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The size of the document, in bytes.</p>
    pub fn document_size_in_bytes(&self) -> std::option::Option<i64> {
        self.document_size_in_bytes
    }
    /// <p>The ID of the parent folder.</p>
    pub fn parent_folder_id(&self) -> std::option::Option<&str> {
        self.parent_folder_id.as_deref()
    }
}
impl std::fmt::Debug for InitiateDocumentVersionUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateDocumentVersionUploadInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("content_created_timestamp", &self.content_created_timestamp);
        formatter.field(
            "content_modified_timestamp",
            &self.content_modified_timestamp,
        );
        formatter.field("content_type", &self.content_type);
        formatter.field("document_size_in_bytes", &self.document_size_in_bytes);
        formatter.field("parent_folder_id", &self.parent_folder_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcesInput {
    /// <p>The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The user ID for the resource collection. This is a required field for accessing the API operation using IAM credentials.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The collection type.</p>
    pub collection_type: std::option::Option<crate::model::ResourceCollectionType>,
    /// <p>The maximum number of resources to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl GetResourcesInput {
    /// <p>The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The user ID for the resource collection. This is a required field for accessing the API operation using IAM credentials.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The collection type.</p>
    pub fn collection_type(&self) -> std::option::Option<&crate::model::ResourceCollectionType> {
        self.collection_type.as_ref()
    }
    /// <p>The maximum number of resources to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for GetResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcesInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("user_id", &self.user_id);
        formatter.field("collection_type", &self.collection_type);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFolderPathInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of levels in the hierarchy to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>A comma-separated list of values. Specify "NAME" to include the names of the parent folders.</p>
    pub fields: std::option::Option<std::string::String>,
    /// <p>This value is not supported.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl GetFolderPathInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>The maximum number of levels in the hierarchy to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>A comma-separated list of values. Specify "NAME" to include the names of the parent folders.</p>
    pub fn fields(&self) -> std::option::Option<&str> {
        self.fields.as_deref()
    }
    /// <p>This value is not supported.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for GetFolderPathInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFolderPathInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.field("limit", &self.limit);
        formatter.field("fields", &self.fields);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>Set to TRUE to include custom metadata in the response.</p>
    pub include_custom_metadata: bool,
}
impl GetFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>Set to TRUE to include custom metadata in the response.</p>
    pub fn include_custom_metadata(&self) -> bool {
        self.include_custom_metadata
    }
}
impl std::fmt::Debug for GetFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFolderInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.field("include_custom_metadata", &self.include_custom_metadata);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentVersionInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The version ID of the document.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.</p>
    pub fields: std::option::Option<std::string::String>,
    /// <p>Set this to TRUE to include custom metadata in the response.</p>
    pub include_custom_metadata: bool,
}
impl GetDocumentVersionInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The version ID of the document.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.</p>
    pub fn fields(&self) -> std::option::Option<&str> {
        self.fields.as_deref()
    }
    /// <p>Set this to TRUE to include custom metadata in the response.</p>
    pub fn include_custom_metadata(&self) -> bool {
        self.include_custom_metadata
    }
}
impl std::fmt::Debug for GetDocumentVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentVersionInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("fields", &self.fields);
        formatter.field("include_custom_metadata", &self.include_custom_metadata);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentPathInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of levels in the hierarchy to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>A comma-separated list of values. Specify <code>NAME</code> to include the names of the parent folders.</p>
    pub fields: std::option::Option<std::string::String>,
    /// <p>This value is not supported.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl GetDocumentPathInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The maximum number of levels in the hierarchy to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>A comma-separated list of values. Specify <code>NAME</code> to include the names of the parent folders.</p>
    pub fn fields(&self) -> std::option::Option<&str> {
        self.fields.as_deref()
    }
    /// <p>This value is not supported.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for GetDocumentPathInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentPathInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("limit", &self.limit);
        formatter.field("fields", &self.fields);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>Set this to <code>TRUE</code> to include custom metadata in the response.</p>
    pub include_custom_metadata: bool,
}
impl GetDocumentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>Set this to <code>TRUE</code> to include custom metadata in the response.</p>
    pub fn include_custom_metadata(&self) -> bool {
        self.include_custom_metadata
    }
}
impl std::fmt::Debug for GetDocumentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("include_custom_metadata", &self.include_custom_metadata);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCurrentUserInput {
    /// <p>Amazon WorkDocs authentication token.</p>
    pub authentication_token: std::option::Option<std::string::String>,
}
impl GetCurrentUserInput {
    /// <p>Amazon WorkDocs authentication token.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
}
impl std::fmt::Debug for GetCurrentUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCurrentUserInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsersInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the users.</p>
    pub user_ids: std::option::Option<std::string::String>,
    /// <p>A query to filter users by user name.</p>
    pub query: std::option::Option<std::string::String>,
    /// <p>The state of the users. Specify "ALL" to include inactive users.</p>
    pub include: std::option::Option<crate::model::UserFilterType>,
    /// <p>The order for the results.</p>
    pub order: std::option::Option<crate::model::OrderType>,
    /// <p>The sorting criteria.</p>
    pub sort: std::option::Option<crate::model::UserSortType>,
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>A comma-separated list of values. Specify "STORAGE_METADATA" to include the user storage quota and utilization information.</p>
    pub fields: std::option::Option<std::string::String>,
}
impl DescribeUsersInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The IDs of the users.</p>
    pub fn user_ids(&self) -> std::option::Option<&str> {
        self.user_ids.as_deref()
    }
    /// <p>A query to filter users by user name.</p>
    pub fn query(&self) -> std::option::Option<&str> {
        self.query.as_deref()
    }
    /// <p>The state of the users. Specify "ALL" to include inactive users.</p>
    pub fn include(&self) -> std::option::Option<&crate::model::UserFilterType> {
        self.include.as_ref()
    }
    /// <p>The order for the results.</p>
    pub fn order(&self) -> std::option::Option<&crate::model::OrderType> {
        self.order.as_ref()
    }
    /// <p>The sorting criteria.</p>
    pub fn sort(&self) -> std::option::Option<&crate::model::UserSortType> {
        self.sort.as_ref()
    }
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of items to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>A comma-separated list of values. Specify "STORAGE_METADATA" to include the user storage quota and utilization information.</p>
    pub fn fields(&self) -> std::option::Option<&str> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for DescribeUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsersInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_ids", &self.user_ids);
        formatter.field("query", &"*** Sensitive Data Redacted ***");
        formatter.field("include", &self.include);
        formatter.field("order", &self.order);
        formatter.field("sort", &self.sort);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRootFoldersInput {
    /// <p>Amazon WorkDocs authentication token.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeRootFoldersInput {
    /// <p>Amazon WorkDocs authentication token.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The maximum number of items to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeRootFoldersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRootFoldersInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourcePermissionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ID of the principal to filter permissions by.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results. (You received this marker from a previous call)</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeResourcePermissionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The ID of the principal to filter permissions by.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The marker for the next set of results. (You received this marker from a previous call)</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeResourcePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourcePermissionsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotificationSubscriptionsInput {
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeNotificationSubscriptionsInput {
    /// <p>The ID of the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeNotificationSubscriptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotificationSubscriptionsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGroupsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>A query to describe groups by group name.</p>
    pub search_query: std::option::Option<std::string::String>,
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeGroupsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>A query to describe groups by group name.</p>
    pub fn search_query(&self) -> std::option::Option<&str> {
        self.search_query.as_deref()
    }
    /// <p>The ID of the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGroupsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("search_query", &"*** Sensitive Data Redacted ***");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFolderContentsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The sorting criteria.</p>
    pub sort: std::option::Option<crate::model::ResourceSortType>,
    /// <p>The order for the contents of the folder.</p>
    pub order: std::option::Option<crate::model::OrderType>,
    /// <p>The maximum number of items to return with this call.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The type of items.</p>
    pub r#type: std::option::Option<crate::model::FolderContentType>,
    /// <p>The contents to include. Specify "INITIALIZED" to include initialized documents.</p>
    pub include: std::option::Option<std::string::String>,
}
impl DescribeFolderContentsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>The sorting criteria.</p>
    pub fn sort(&self) -> std::option::Option<&crate::model::ResourceSortType> {
        self.sort.as_ref()
    }
    /// <p>The order for the contents of the folder.</p>
    pub fn order(&self) -> std::option::Option<&crate::model::OrderType> {
        self.order.as_ref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The type of items.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FolderContentType> {
        self.r#type.as_ref()
    }
    /// <p>The contents to include. Specify "INITIALIZED" to include initialized documents.</p>
    pub fn include(&self) -> std::option::Option<&str> {
        self.include.as_deref()
    }
}
impl std::fmt::Debug for DescribeFolderContentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFolderContentsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.field("sort", &self.sort);
        formatter.field("order", &self.order);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.field("r#type", &self.r#type);
        formatter.field("include", &self.include);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDocumentVersionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of versions to return with this call.</p>
    pub limit: std::option::Option<i32>,
    /// <p>A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.</p>
    pub include: std::option::Option<std::string::String>,
    /// <p>Specify "SOURCE" to include initialized versions and a URL for the source document.</p>
    pub fields: std::option::Option<std::string::String>,
}
impl DescribeDocumentVersionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of versions to return with this call.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.</p>
    pub fn include(&self) -> std::option::Option<&str> {
        self.include.as_deref()
    }
    /// <p>Specify "SOURCE" to include initialized versions and a URL for the source document.</p>
    pub fn fields(&self) -> std::option::Option<&str> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for DescribeDocumentVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDocumentVersionsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.field("include", &self.include);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCommentsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The ID of the document version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeCommentsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The ID of the document version.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The maximum number of items to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeCommentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCommentsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeActivitiesInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The timestamp that determines the starting time of the activities. The response includes the activities performed after the specified timestamp.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp that determines the end time of the activities. The response includes the activities performed before the specified timestamp.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>Specifies which activity types to include in the response. If this field is left empty, all activity types are returned.</p>
    pub activity_types: std::option::Option<std::string::String>,
    /// <p>The document or folder ID for which to describe activity types.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ID of the user who performed the action. The response includes activities pertaining to this user. This is an optional parameter and is only applicable for administrative API (SigV4) requests.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Includes indirect activities. An indirect activity results from a direct activity performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of the subfolders and documents within the parent folder (the indirect activity).</p>
    pub include_indirect_activities: bool,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeActivitiesInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The timestamp that determines the starting time of the activities. The response includes the activities performed after the specified timestamp.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The timestamp that determines the end time of the activities. The response includes the activities performed before the specified timestamp.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>Specifies which activity types to include in the response. If this field is left empty, all activity types are returned.</p>
    pub fn activity_types(&self) -> std::option::Option<&str> {
        self.activity_types.as_deref()
    }
    /// <p>The document or folder ID for which to describe activity types.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The ID of the user who performed the action. The response includes activities pertaining to this user. This is an optional parameter and is only applicable for administrative API (SigV4) requests.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>Includes indirect activities. An indirect activity results from a direct activity performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of the subfolders and documents within the parent folder (the indirect activity).</p>
    pub fn include_indirect_activities(&self) -> bool {
        self.include_indirect_activities
    }
    /// <p>The maximum number of items to return.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The marker for the next set of results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeActivitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeActivitiesInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("organization_id", &self.organization_id);
        formatter.field("activity_types", &self.activity_types);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("user_id", &self.user_id);
        formatter.field(
            "include_indirect_activities",
            &self.include_indirect_activities,
        );
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserInput {
    /// <p>Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as in accessing the API using AWS credentials.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl DeleteUserInput {
    /// <p>Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as in accessing the API using AWS credentials.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNotificationSubscriptionInput {
    /// <p>The ID of the subscription.</p>
    pub subscription_id: std::option::Option<std::string::String>,
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl DeleteNotificationSubscriptionInput {
    /// <p>The ID of the subscription.</p>
    pub fn subscription_id(&self) -> std::option::Option<&str> {
        self.subscription_id.as_deref()
    }
    /// <p>The ID of the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteNotificationSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNotificationSubscriptionInput");
        formatter.field("subscription_id", &self.subscription_id);
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLabelsInput {
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>List of labels to delete from the resource.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Flag to request removal of all labels from the specified resource.</p>
    pub delete_all: bool,
}
impl DeleteLabelsInput {
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>List of labels to delete from the resource.</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
    /// <p>Flag to request removal of all labels from the specified resource.</p>
    pub fn delete_all(&self) -> bool {
        self.delete_all
    }
}
impl std::fmt::Debug for DeleteLabelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLabelsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("labels", &self.labels);
        formatter.field("delete_all", &self.delete_all);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFolderContentsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
}
impl DeleteFolderContentsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFolderContentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFolderContentsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
}
impl DeleteFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFolderInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDocumentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
}
impl DeleteDocumentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDocumentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDocumentInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomMetadataInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource, either a document or folder.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ID of the version, if the custom metadata is being deleted from a document version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>List of properties to remove.</p>
    pub keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Flag to indicate removal of all custom metadata properties from the specified resource.</p>
    pub delete_all: bool,
}
impl DeleteCustomMetadataInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the resource, either a document or folder.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The ID of the version, if the custom metadata is being deleted from a document version.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>List of properties to remove.</p>
    pub fn keys(&self) -> std::option::Option<&[std::string::String]> {
        self.keys.as_deref()
    }
    /// <p>Flag to indicate removal of all custom metadata properties from the specified resource.</p>
    pub fn delete_all(&self) -> bool {
        self.delete_all
    }
}
impl std::fmt::Debug for DeleteCustomMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomMetadataInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("keys", &self.keys);
        formatter.field("delete_all", &self.delete_all);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCommentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The ID of the document version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The ID of the comment.</p>
    pub comment_id: std::option::Option<std::string::String>,
}
impl DeleteCommentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The ID of the document version.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The ID of the comment.</p>
    pub fn comment_id(&self) -> std::option::Option<&str> {
        self.comment_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteCommentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCommentInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("comment_id", &self.comment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateUserInput {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
}
impl DeactivateUserInput {
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
}
impl std::fmt::Debug for DeactivateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserInput {
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The login name of the user.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The email address of the user.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The given name of the user.</p>
    pub given_name: std::option::Option<std::string::String>,
    /// <p>The surname of the user.</p>
    pub surname: std::option::Option<std::string::String>,
    /// <p>The password of the user.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The time zone ID of the user.</p>
    pub time_zone_id: std::option::Option<std::string::String>,
    /// <p>The amount of storage for the user.</p>
    pub storage_rule: std::option::Option<crate::model::StorageRuleType>,
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
}
impl CreateUserInput {
    /// <p>The ID of the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The login name of the user.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The email address of the user.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The given name of the user.</p>
    pub fn given_name(&self) -> std::option::Option<&str> {
        self.given_name.as_deref()
    }
    /// <p>The surname of the user.</p>
    pub fn surname(&self) -> std::option::Option<&str> {
        self.surname.as_deref()
    }
    /// <p>The password of the user.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>The time zone ID of the user.</p>
    pub fn time_zone_id(&self) -> std::option::Option<&str> {
        self.time_zone_id.as_deref()
    }
    /// <p>The amount of storage for the user.</p>
    pub fn storage_rule(&self) -> std::option::Option<&crate::model::StorageRuleType> {
        self.storage_rule.as_ref()
    }
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
}
impl std::fmt::Debug for CreateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("username", &self.username);
        formatter.field("email_address", &self.email_address);
        formatter.field("given_name", &self.given_name);
        formatter.field("surname", &self.surname);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("time_zone_id", &self.time_zone_id);
        formatter.field("storage_rule", &self.storage_rule);
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNotificationSubscriptionInput {
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins with <code>https</code>.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.</p>
    pub protocol: std::option::Option<crate::model::SubscriptionProtocolType>,
    /// <p>The notification type.</p>
    pub subscription_type: std::option::Option<crate::model::SubscriptionType>,
}
impl CreateNotificationSubscriptionInput {
    /// <p>The ID of the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins with <code>https</code>.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::SubscriptionProtocolType> {
        self.protocol.as_ref()
    }
    /// <p>The notification type.</p>
    pub fn subscription_type(&self) -> std::option::Option<&crate::model::SubscriptionType> {
        self.subscription_type.as_ref()
    }
}
impl std::fmt::Debug for CreateNotificationSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNotificationSubscriptionInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("protocol", &self.protocol);
        formatter.field("subscription_type", &self.subscription_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLabelsInput {
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>List of labels to add to the resource.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
}
impl CreateLabelsInput {
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>List of labels to add to the resource.</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
}
impl std::fmt::Debug for CreateLabelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLabelsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("labels", &self.labels);
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The name of the new folder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the parent folder.</p>
    pub parent_folder_id: std::option::Option<std::string::String>,
}
impl CreateFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The name of the new folder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the parent folder.</p>
    pub fn parent_folder_id(&self) -> std::option::Option<&str> {
        self.parent_folder_id.as_deref()
    }
}
impl std::fmt::Debug for CreateFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFolderInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &self.name);
        formatter.field("parent_folder_id", &self.parent_folder_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomMetadataInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ID of the version, if the custom metadata is being added to a document version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Custom metadata in the form of name-value pairs.</p>
    pub custom_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateCustomMetadataInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The ID of the version, if the custom metadata is being added to a document version.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Custom metadata in the form of name-value pairs.</p>
    pub fn custom_metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.custom_metadata.as_ref()
    }
}
impl std::fmt::Debug for CreateCustomMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomMetadataInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("custom_metadata", &self.custom_metadata);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCommentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The ID of the document version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The ID of the parent comment.</p>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>The ID of the root comment in the thread.</p>
    pub thread_id: std::option::Option<std::string::String>,
    /// <p>The text of the comment.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners, and contributors.</p>
    pub visibility: std::option::Option<crate::model::CommentVisibilityType>,
    /// <p>Set this parameter to TRUE to send an email out to the document collaborators after the comment is created.</p>
    pub notify_collaborators: bool,
}
impl CreateCommentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The ID of the document version.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The ID of the parent comment.</p>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>The ID of the root comment in the thread.</p>
    pub fn thread_id(&self) -> std::option::Option<&str> {
        self.thread_id.as_deref()
    }
    /// <p>The text of the comment.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners, and contributors.</p>
    pub fn visibility(&self) -> std::option::Option<&crate::model::CommentVisibilityType> {
        self.visibility.as_ref()
    }
    /// <p>Set this parameter to TRUE to send an email out to the document collaborators after the comment is created.</p>
    pub fn notify_collaborators(&self) -> bool {
        self.notify_collaborators
    }
}
impl std::fmt::Debug for CreateCommentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCommentInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("parent_id", &self.parent_id);
        formatter.field("thread_id", &self.thread_id);
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("visibility", &self.visibility);
        formatter.field("notify_collaborators", &self.notify_collaborators);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddResourcePermissionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The users, groups, or organization being granted permission.</p>
    pub principals: std::option::Option<std::vec::Vec<crate::model::SharePrincipal>>,
    /// <p>The notification options.</p>
    pub notification_options: std::option::Option<crate::model::NotificationOptions>,
}
impl AddResourcePermissionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The users, groups, or organization being granted permission.</p>
    pub fn principals(&self) -> std::option::Option<&[crate::model::SharePrincipal]> {
        self.principals.as_deref()
    }
    /// <p>The notification options.</p>
    pub fn notification_options(&self) -> std::option::Option<&crate::model::NotificationOptions> {
        self.notification_options.as_ref()
    }
}
impl std::fmt::Debug for AddResourcePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddResourcePermissionsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("principals", &self.principals);
        formatter.field("notification_options", &self.notification_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateUserInput {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
}
impl ActivateUserInput {
    /// <p>The ID of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
}
impl std::fmt::Debug for ActivateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortDocumentVersionUploadInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The ID of the version.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl AbortDocumentVersionUploadInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub fn authentication_token(&self) -> std::option::Option<&str> {
        self.authentication_token.as_deref()
    }
    /// <p>The ID of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The ID of the version.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
}
impl std::fmt::Debug for AbortDocumentVersionUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortDocumentVersionUploadInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
