// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AbortDocumentVersionUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`abort_document_version_upload`](crate::client::Client::abort_document_version_upload).
///
/// See [`crate::client::fluent_builders::AbortDocumentVersionUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AbortDocumentVersionUpload {
    _private: (),
}
impl AbortDocumentVersionUpload {
    /// Creates a new builder-style object to manufacture [`AbortDocumentVersionUploadInput`](crate::input::AbortDocumentVersionUploadInput)
    pub fn builder() -> crate::input::abort_document_version_upload_input::Builder {
        crate::input::abort_document_version_upload_input::Builder::default()
    }
    /// Creates a new `AbortDocumentVersionUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AbortDocumentVersionUpload {
    type Output = std::result::Result<
        crate::output::AbortDocumentVersionUploadOutput,
        crate::error::AbortDocumentVersionUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_abort_document_version_upload_error(response)
        } else {
            crate::operation_deser::parse_abort_document_version_upload_response(response)
        }
    }
}

/// Operation shape for `ActivateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`activate_user`](crate::client::Client::activate_user).
///
/// See [`crate::client::fluent_builders::ActivateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ActivateUser {
    _private: (),
}
impl ActivateUser {
    /// Creates a new builder-style object to manufacture [`ActivateUserInput`](crate::input::ActivateUserInput)
    pub fn builder() -> crate::input::activate_user_input::Builder {
        crate::input::activate_user_input::Builder::default()
    }
    /// Creates a new `ActivateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ActivateUser {
    type Output =
        std::result::Result<crate::output::ActivateUserOutput, crate::error::ActivateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_activate_user_error(response)
        } else {
            crate::operation_deser::parse_activate_user_response(response)
        }
    }
}

/// Operation shape for `AddResourcePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_resource_permissions`](crate::client::Client::add_resource_permissions).
///
/// See [`crate::client::fluent_builders::AddResourcePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddResourcePermissions {
    _private: (),
}
impl AddResourcePermissions {
    /// Creates a new builder-style object to manufacture [`AddResourcePermissionsInput`](crate::input::AddResourcePermissionsInput)
    pub fn builder() -> crate::input::add_resource_permissions_input::Builder {
        crate::input::add_resource_permissions_input::Builder::default()
    }
    /// Creates a new `AddResourcePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddResourcePermissions {
    type Output = std::result::Result<
        crate::output::AddResourcePermissionsOutput,
        crate::error::AddResourcePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_add_resource_permissions_error(response)
        } else {
            crate::operation_deser::parse_add_resource_permissions_response(response)
        }
    }
}

/// Operation shape for `CreateComment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_comment`](crate::client::Client::create_comment).
///
/// See [`crate::client::fluent_builders::CreateComment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateComment {
    _private: (),
}
impl CreateComment {
    /// Creates a new builder-style object to manufacture [`CreateCommentInput`](crate::input::CreateCommentInput)
    pub fn builder() -> crate::input::create_comment_input::Builder {
        crate::input::create_comment_input::Builder::default()
    }
    /// Creates a new `CreateComment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateComment {
    type Output =
        std::result::Result<crate::output::CreateCommentOutput, crate::error::CreateCommentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_comment_error(response)
        } else {
            crate::operation_deser::parse_create_comment_response(response)
        }
    }
}

/// Operation shape for `CreateCustomMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_metadata`](crate::client::Client::create_custom_metadata).
///
/// See [`crate::client::fluent_builders::CreateCustomMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomMetadata {
    _private: (),
}
impl CreateCustomMetadata {
    /// Creates a new builder-style object to manufacture [`CreateCustomMetadataInput`](crate::input::CreateCustomMetadataInput)
    pub fn builder() -> crate::input::create_custom_metadata_input::Builder {
        crate::input::create_custom_metadata_input::Builder::default()
    }
    /// Creates a new `CreateCustomMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomMetadata {
    type Output = std::result::Result<
        crate::output::CreateCustomMetadataOutput,
        crate::error::CreateCustomMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_metadata_error(response)
        } else {
            crate::operation_deser::parse_create_custom_metadata_response(response)
        }
    }
}

/// Operation shape for `CreateFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_folder`](crate::client::Client::create_folder).
///
/// See [`crate::client::fluent_builders::CreateFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFolder {
    _private: (),
}
impl CreateFolder {
    /// Creates a new builder-style object to manufacture [`CreateFolderInput`](crate::input::CreateFolderInput)
    pub fn builder() -> crate::input::create_folder_input::Builder {
        crate::input::create_folder_input::Builder::default()
    }
    /// Creates a new `CreateFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFolder {
    type Output =
        std::result::Result<crate::output::CreateFolderOutput, crate::error::CreateFolderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_folder_error(response)
        } else {
            crate::operation_deser::parse_create_folder_response(response)
        }
    }
}

/// Operation shape for `CreateLabels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_labels`](crate::client::Client::create_labels).
///
/// See [`crate::client::fluent_builders::CreateLabels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLabels {
    _private: (),
}
impl CreateLabels {
    /// Creates a new builder-style object to manufacture [`CreateLabelsInput`](crate::input::CreateLabelsInput)
    pub fn builder() -> crate::input::create_labels_input::Builder {
        crate::input::create_labels_input::Builder::default()
    }
    /// Creates a new `CreateLabels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLabels {
    type Output =
        std::result::Result<crate::output::CreateLabelsOutput, crate::error::CreateLabelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_labels_error(response)
        } else {
            crate::operation_deser::parse_create_labels_response(response)
        }
    }
}

/// Operation shape for `CreateNotificationSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_notification_subscription`](crate::client::Client::create_notification_subscription).
///
/// See [`crate::client::fluent_builders::CreateNotificationSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNotificationSubscription {
    _private: (),
}
impl CreateNotificationSubscription {
    /// Creates a new builder-style object to manufacture [`CreateNotificationSubscriptionInput`](crate::input::CreateNotificationSubscriptionInput)
    pub fn builder() -> crate::input::create_notification_subscription_input::Builder {
        crate::input::create_notification_subscription_input::Builder::default()
    }
    /// Creates a new `CreateNotificationSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNotificationSubscription {
    type Output = std::result::Result<
        crate::output::CreateNotificationSubscriptionOutput,
        crate::error::CreateNotificationSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_notification_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_notification_subscription_response(response)
        }
    }
}

/// Operation shape for `CreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user`](crate::client::Client::create_user).
///
/// See [`crate::client::fluent_builders::CreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUser {
    _private: (),
}
impl CreateUser {
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
    /// Creates a new `CreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUser {
    type Output =
        std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_user_error(response)
        } else {
            crate::operation_deser::parse_create_user_response(response)
        }
    }
}

/// Operation shape for `DeactivateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deactivate_user`](crate::client::Client::deactivate_user).
///
/// See [`crate::client::fluent_builders::DeactivateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeactivateUser {
    _private: (),
}
impl DeactivateUser {
    /// Creates a new builder-style object to manufacture [`DeactivateUserInput`](crate::input::DeactivateUserInput)
    pub fn builder() -> crate::input::deactivate_user_input::Builder {
        crate::input::deactivate_user_input::Builder::default()
    }
    /// Creates a new `DeactivateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeactivateUser {
    type Output =
        std::result::Result<crate::output::DeactivateUserOutput, crate::error::DeactivateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_deactivate_user_error(response)
        } else {
            crate::operation_deser::parse_deactivate_user_response(response)
        }
    }
}

/// Operation shape for `DeleteComment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_comment`](crate::client::Client::delete_comment).
///
/// See [`crate::client::fluent_builders::DeleteComment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteComment {
    _private: (),
}
impl DeleteComment {
    /// Creates a new builder-style object to manufacture [`DeleteCommentInput`](crate::input::DeleteCommentInput)
    pub fn builder() -> crate::input::delete_comment_input::Builder {
        crate::input::delete_comment_input::Builder::default()
    }
    /// Creates a new `DeleteComment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteComment {
    type Output =
        std::result::Result<crate::output::DeleteCommentOutput, crate::error::DeleteCommentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_comment_error(response)
        } else {
            crate::operation_deser::parse_delete_comment_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_metadata`](crate::client::Client::delete_custom_metadata).
///
/// See [`crate::client::fluent_builders::DeleteCustomMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomMetadata {
    _private: (),
}
impl DeleteCustomMetadata {
    /// Creates a new builder-style object to manufacture [`DeleteCustomMetadataInput`](crate::input::DeleteCustomMetadataInput)
    pub fn builder() -> crate::input::delete_custom_metadata_input::Builder {
        crate::input::delete_custom_metadata_input::Builder::default()
    }
    /// Creates a new `DeleteCustomMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomMetadata {
    type Output = std::result::Result<
        crate::output::DeleteCustomMetadataOutput,
        crate::error::DeleteCustomMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_metadata_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_metadata_response(response)
        }
    }
}

/// Operation shape for `DeleteDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_document`](crate::client::Client::delete_document).
///
/// See [`crate::client::fluent_builders::DeleteDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDocument {
    _private: (),
}
impl DeleteDocument {
    /// Creates a new builder-style object to manufacture [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
    pub fn builder() -> crate::input::delete_document_input::Builder {
        crate::input::delete_document_input::Builder::default()
    }
    /// Creates a new `DeleteDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDocument {
    type Output =
        std::result::Result<crate::output::DeleteDocumentOutput, crate::error::DeleteDocumentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_document_error(response)
        } else {
            crate::operation_deser::parse_delete_document_response(response)
        }
    }
}

/// Operation shape for `DeleteFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_folder`](crate::client::Client::delete_folder).
///
/// See [`crate::client::fluent_builders::DeleteFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFolder {
    _private: (),
}
impl DeleteFolder {
    /// Creates a new builder-style object to manufacture [`DeleteFolderInput`](crate::input::DeleteFolderInput)
    pub fn builder() -> crate::input::delete_folder_input::Builder {
        crate::input::delete_folder_input::Builder::default()
    }
    /// Creates a new `DeleteFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFolder {
    type Output =
        std::result::Result<crate::output::DeleteFolderOutput, crate::error::DeleteFolderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_folder_error(response)
        } else {
            crate::operation_deser::parse_delete_folder_response(response)
        }
    }
}

/// Operation shape for `DeleteFolderContents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_folder_contents`](crate::client::Client::delete_folder_contents).
///
/// See [`crate::client::fluent_builders::DeleteFolderContents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFolderContents {
    _private: (),
}
impl DeleteFolderContents {
    /// Creates a new builder-style object to manufacture [`DeleteFolderContentsInput`](crate::input::DeleteFolderContentsInput)
    pub fn builder() -> crate::input::delete_folder_contents_input::Builder {
        crate::input::delete_folder_contents_input::Builder::default()
    }
    /// Creates a new `DeleteFolderContents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFolderContents {
    type Output = std::result::Result<
        crate::output::DeleteFolderContentsOutput,
        crate::error::DeleteFolderContentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_folder_contents_error(response)
        } else {
            crate::operation_deser::parse_delete_folder_contents_response(response)
        }
    }
}

/// Operation shape for `DeleteLabels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_labels`](crate::client::Client::delete_labels).
///
/// See [`crate::client::fluent_builders::DeleteLabels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLabels {
    _private: (),
}
impl DeleteLabels {
    /// Creates a new builder-style object to manufacture [`DeleteLabelsInput`](crate::input::DeleteLabelsInput)
    pub fn builder() -> crate::input::delete_labels_input::Builder {
        crate::input::delete_labels_input::Builder::default()
    }
    /// Creates a new `DeleteLabels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLabels {
    type Output =
        std::result::Result<crate::output::DeleteLabelsOutput, crate::error::DeleteLabelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_labels_error(response)
        } else {
            crate::operation_deser::parse_delete_labels_response(response)
        }
    }
}

/// Operation shape for `DeleteNotificationSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_notification_subscription`](crate::client::Client::delete_notification_subscription).
///
/// See [`crate::client::fluent_builders::DeleteNotificationSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNotificationSubscription {
    _private: (),
}
impl DeleteNotificationSubscription {
    /// Creates a new builder-style object to manufacture [`DeleteNotificationSubscriptionInput`](crate::input::DeleteNotificationSubscriptionInput)
    pub fn builder() -> crate::input::delete_notification_subscription_input::Builder {
        crate::input::delete_notification_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteNotificationSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNotificationSubscription {
    type Output = std::result::Result<
        crate::output::DeleteNotificationSubscriptionOutput,
        crate::error::DeleteNotificationSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_notification_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_notification_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user`](crate::client::Client::delete_user).
///
/// See [`crate::client::fluent_builders::DeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUser {
    _private: (),
}
impl DeleteUser {
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
    /// Creates a new `DeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUser {
    type Output =
        std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_user_error(response)
        } else {
            crate::operation_deser::parse_delete_user_response(response)
        }
    }
}

/// Operation shape for `DescribeActivities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_activities`](crate::client::Client::describe_activities).
///
/// See [`crate::client::fluent_builders::DescribeActivities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeActivities {
    _private: (),
}
impl DescribeActivities {
    /// Creates a new builder-style object to manufacture [`DescribeActivitiesInput`](crate::input::DescribeActivitiesInput)
    pub fn builder() -> crate::input::describe_activities_input::Builder {
        crate::input::describe_activities_input::Builder::default()
    }
    /// Creates a new `DescribeActivities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeActivities {
    type Output = std::result::Result<
        crate::output::DescribeActivitiesOutput,
        crate::error::DescribeActivitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_activities_error(response)
        } else {
            crate::operation_deser::parse_describe_activities_response(response)
        }
    }
}

/// Operation shape for `DescribeComments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_comments`](crate::client::Client::describe_comments).
///
/// See [`crate::client::fluent_builders::DescribeComments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeComments {
    _private: (),
}
impl DescribeComments {
    /// Creates a new builder-style object to manufacture [`DescribeCommentsInput`](crate::input::DescribeCommentsInput)
    pub fn builder() -> crate::input::describe_comments_input::Builder {
        crate::input::describe_comments_input::Builder::default()
    }
    /// Creates a new `DescribeComments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeComments {
    type Output = std::result::Result<
        crate::output::DescribeCommentsOutput,
        crate::error::DescribeCommentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_comments_error(response)
        } else {
            crate::operation_deser::parse_describe_comments_response(response)
        }
    }
}

/// Operation shape for `DescribeDocumentVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_document_versions`](crate::client::Client::describe_document_versions).
///
/// See [`crate::client::fluent_builders::DescribeDocumentVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDocumentVersions {
    _private: (),
}
impl DescribeDocumentVersions {
    /// Creates a new builder-style object to manufacture [`DescribeDocumentVersionsInput`](crate::input::DescribeDocumentVersionsInput)
    pub fn builder() -> crate::input::describe_document_versions_input::Builder {
        crate::input::describe_document_versions_input::Builder::default()
    }
    /// Creates a new `DescribeDocumentVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDocumentVersions {
    type Output = std::result::Result<
        crate::output::DescribeDocumentVersionsOutput,
        crate::error::DescribeDocumentVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_document_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_document_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeFolderContents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_folder_contents`](crate::client::Client::describe_folder_contents).
///
/// See [`crate::client::fluent_builders::DescribeFolderContents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFolderContents {
    _private: (),
}
impl DescribeFolderContents {
    /// Creates a new builder-style object to manufacture [`DescribeFolderContentsInput`](crate::input::DescribeFolderContentsInput)
    pub fn builder() -> crate::input::describe_folder_contents_input::Builder {
        crate::input::describe_folder_contents_input::Builder::default()
    }
    /// Creates a new `DescribeFolderContents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFolderContents {
    type Output = std::result::Result<
        crate::output::DescribeFolderContentsOutput,
        crate::error::DescribeFolderContentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_folder_contents_error(response)
        } else {
            crate::operation_deser::parse_describe_folder_contents_response(response)
        }
    }
}

/// Operation shape for `DescribeGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_groups`](crate::client::Client::describe_groups).
///
/// See [`crate::client::fluent_builders::DescribeGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGroups {
    _private: (),
}
impl DescribeGroups {
    /// Creates a new builder-style object to manufacture [`DescribeGroupsInput`](crate::input::DescribeGroupsInput)
    pub fn builder() -> crate::input::describe_groups_input::Builder {
        crate::input::describe_groups_input::Builder::default()
    }
    /// Creates a new `DescribeGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGroups {
    type Output =
        std::result::Result<crate::output::DescribeGroupsOutput, crate::error::DescribeGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeNotificationSubscriptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_notification_subscriptions`](crate::client::Client::describe_notification_subscriptions).
///
/// See [`crate::client::fluent_builders::DescribeNotificationSubscriptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNotificationSubscriptions {
    _private: (),
}
impl DescribeNotificationSubscriptions {
    /// Creates a new builder-style object to manufacture [`DescribeNotificationSubscriptionsInput`](crate::input::DescribeNotificationSubscriptionsInput)
    pub fn builder() -> crate::input::describe_notification_subscriptions_input::Builder {
        crate::input::describe_notification_subscriptions_input::Builder::default()
    }
    /// Creates a new `DescribeNotificationSubscriptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNotificationSubscriptions {
    type Output = std::result::Result<
        crate::output::DescribeNotificationSubscriptionsOutput,
        crate::error::DescribeNotificationSubscriptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_notification_subscriptions_error(response)
        } else {
            crate::operation_deser::parse_describe_notification_subscriptions_response(response)
        }
    }
}

/// Operation shape for `DescribeResourcePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_resource_permissions`](crate::client::Client::describe_resource_permissions).
///
/// See [`crate::client::fluent_builders::DescribeResourcePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeResourcePermissions {
    _private: (),
}
impl DescribeResourcePermissions {
    /// Creates a new builder-style object to manufacture [`DescribeResourcePermissionsInput`](crate::input::DescribeResourcePermissionsInput)
    pub fn builder() -> crate::input::describe_resource_permissions_input::Builder {
        crate::input::describe_resource_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeResourcePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeResourcePermissions {
    type Output = std::result::Result<
        crate::output::DescribeResourcePermissionsOutput,
        crate::error::DescribeResourcePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_resource_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_resource_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeRootFolders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_root_folders`](crate::client::Client::describe_root_folders).
///
/// See [`crate::client::fluent_builders::DescribeRootFolders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRootFolders {
    _private: (),
}
impl DescribeRootFolders {
    /// Creates a new builder-style object to manufacture [`DescribeRootFoldersInput`](crate::input::DescribeRootFoldersInput)
    pub fn builder() -> crate::input::describe_root_folders_input::Builder {
        crate::input::describe_root_folders_input::Builder::default()
    }
    /// Creates a new `DescribeRootFolders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRootFolders {
    type Output = std::result::Result<
        crate::output::DescribeRootFoldersOutput,
        crate::error::DescribeRootFoldersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_root_folders_error(response)
        } else {
            crate::operation_deser::parse_describe_root_folders_response(response)
        }
    }
}

/// Operation shape for `DescribeUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_users`](crate::client::Client::describe_users).
///
/// See [`crate::client::fluent_builders::DescribeUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUsers {
    _private: (),
}
impl DescribeUsers {
    /// Creates a new builder-style object to manufacture [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    pub fn builder() -> crate::input::describe_users_input::Builder {
        crate::input::describe_users_input::Builder::default()
    }
    /// Creates a new `DescribeUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUsers {
    type Output =
        std::result::Result<crate::output::DescribeUsersOutput, crate::error::DescribeUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_users_error(response)
        } else {
            crate::operation_deser::parse_describe_users_response(response)
        }
    }
}

/// Operation shape for `GetCurrentUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_current_user`](crate::client::Client::get_current_user).
///
/// See [`crate::client::fluent_builders::GetCurrentUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCurrentUser {
    _private: (),
}
impl GetCurrentUser {
    /// Creates a new builder-style object to manufacture [`GetCurrentUserInput`](crate::input::GetCurrentUserInput)
    pub fn builder() -> crate::input::get_current_user_input::Builder {
        crate::input::get_current_user_input::Builder::default()
    }
    /// Creates a new `GetCurrentUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCurrentUser {
    type Output =
        std::result::Result<crate::output::GetCurrentUserOutput, crate::error::GetCurrentUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_current_user_error(response)
        } else {
            crate::operation_deser::parse_get_current_user_response(response)
        }
    }
}

/// Operation shape for `GetDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_document`](crate::client::Client::get_document).
///
/// See [`crate::client::fluent_builders::GetDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDocument {
    _private: (),
}
impl GetDocument {
    /// Creates a new builder-style object to manufacture [`GetDocumentInput`](crate::input::GetDocumentInput)
    pub fn builder() -> crate::input::get_document_input::Builder {
        crate::input::get_document_input::Builder::default()
    }
    /// Creates a new `GetDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDocument {
    type Output =
        std::result::Result<crate::output::GetDocumentOutput, crate::error::GetDocumentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_document_error(response)
        } else {
            crate::operation_deser::parse_get_document_response(response)
        }
    }
}

/// Operation shape for `GetDocumentPath`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_document_path`](crate::client::Client::get_document_path).
///
/// See [`crate::client::fluent_builders::GetDocumentPath`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDocumentPath {
    _private: (),
}
impl GetDocumentPath {
    /// Creates a new builder-style object to manufacture [`GetDocumentPathInput`](crate::input::GetDocumentPathInput)
    pub fn builder() -> crate::input::get_document_path_input::Builder {
        crate::input::get_document_path_input::Builder::default()
    }
    /// Creates a new `GetDocumentPath` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDocumentPath {
    type Output = std::result::Result<
        crate::output::GetDocumentPathOutput,
        crate::error::GetDocumentPathError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_document_path_error(response)
        } else {
            crate::operation_deser::parse_get_document_path_response(response)
        }
    }
}

/// Operation shape for `GetDocumentVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_document_version`](crate::client::Client::get_document_version).
///
/// See [`crate::client::fluent_builders::GetDocumentVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDocumentVersion {
    _private: (),
}
impl GetDocumentVersion {
    /// Creates a new builder-style object to manufacture [`GetDocumentVersionInput`](crate::input::GetDocumentVersionInput)
    pub fn builder() -> crate::input::get_document_version_input::Builder {
        crate::input::get_document_version_input::Builder::default()
    }
    /// Creates a new `GetDocumentVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDocumentVersion {
    type Output = std::result::Result<
        crate::output::GetDocumentVersionOutput,
        crate::error::GetDocumentVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_document_version_error(response)
        } else {
            crate::operation_deser::parse_get_document_version_response(response)
        }
    }
}

/// Operation shape for `GetFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_folder`](crate::client::Client::get_folder).
///
/// See [`crate::client::fluent_builders::GetFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFolder {
    _private: (),
}
impl GetFolder {
    /// Creates a new builder-style object to manufacture [`GetFolderInput`](crate::input::GetFolderInput)
    pub fn builder() -> crate::input::get_folder_input::Builder {
        crate::input::get_folder_input::Builder::default()
    }
    /// Creates a new `GetFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFolder {
    type Output = std::result::Result<crate::output::GetFolderOutput, crate::error::GetFolderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_folder_error(response)
        } else {
            crate::operation_deser::parse_get_folder_response(response)
        }
    }
}

/// Operation shape for `GetFolderPath`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_folder_path`](crate::client::Client::get_folder_path).
///
/// See [`crate::client::fluent_builders::GetFolderPath`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFolderPath {
    _private: (),
}
impl GetFolderPath {
    /// Creates a new builder-style object to manufacture [`GetFolderPathInput`](crate::input::GetFolderPathInput)
    pub fn builder() -> crate::input::get_folder_path_input::Builder {
        crate::input::get_folder_path_input::Builder::default()
    }
    /// Creates a new `GetFolderPath` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFolderPath {
    type Output =
        std::result::Result<crate::output::GetFolderPathOutput, crate::error::GetFolderPathError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_folder_path_error(response)
        } else {
            crate::operation_deser::parse_get_folder_path_response(response)
        }
    }
}

/// Operation shape for `GetResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resources`](crate::client::Client::get_resources).
///
/// See [`crate::client::fluent_builders::GetResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResources {
    _private: (),
}
impl GetResources {
    /// Creates a new builder-style object to manufacture [`GetResourcesInput`](crate::input::GetResourcesInput)
    pub fn builder() -> crate::input::get_resources_input::Builder {
        crate::input::get_resources_input::Builder::default()
    }
    /// Creates a new `GetResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResources {
    type Output =
        std::result::Result<crate::output::GetResourcesOutput, crate::error::GetResourcesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resources_error(response)
        } else {
            crate::operation_deser::parse_get_resources_response(response)
        }
    }
}

/// Operation shape for `InitiateDocumentVersionUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`initiate_document_version_upload`](crate::client::Client::initiate_document_version_upload).
///
/// See [`crate::client::fluent_builders::InitiateDocumentVersionUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InitiateDocumentVersionUpload {
    _private: (),
}
impl InitiateDocumentVersionUpload {
    /// Creates a new builder-style object to manufacture [`InitiateDocumentVersionUploadInput`](crate::input::InitiateDocumentVersionUploadInput)
    pub fn builder() -> crate::input::initiate_document_version_upload_input::Builder {
        crate::input::initiate_document_version_upload_input::Builder::default()
    }
    /// Creates a new `InitiateDocumentVersionUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InitiateDocumentVersionUpload {
    type Output = std::result::Result<
        crate::output::InitiateDocumentVersionUploadOutput,
        crate::error::InitiateDocumentVersionUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_initiate_document_version_upload_error(response)
        } else {
            crate::operation_deser::parse_initiate_document_version_upload_response(response)
        }
    }
}

/// Operation shape for `RemoveAllResourcePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_all_resource_permissions`](crate::client::Client::remove_all_resource_permissions).
///
/// See [`crate::client::fluent_builders::RemoveAllResourcePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveAllResourcePermissions {
    _private: (),
}
impl RemoveAllResourcePermissions {
    /// Creates a new builder-style object to manufacture [`RemoveAllResourcePermissionsInput`](crate::input::RemoveAllResourcePermissionsInput)
    pub fn builder() -> crate::input::remove_all_resource_permissions_input::Builder {
        crate::input::remove_all_resource_permissions_input::Builder::default()
    }
    /// Creates a new `RemoveAllResourcePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveAllResourcePermissions {
    type Output = std::result::Result<
        crate::output::RemoveAllResourcePermissionsOutput,
        crate::error::RemoveAllResourcePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_remove_all_resource_permissions_error(response)
        } else {
            crate::operation_deser::parse_remove_all_resource_permissions_response(response)
        }
    }
}

/// Operation shape for `RemoveResourcePermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_resource_permission`](crate::client::Client::remove_resource_permission).
///
/// See [`crate::client::fluent_builders::RemoveResourcePermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveResourcePermission {
    _private: (),
}
impl RemoveResourcePermission {
    /// Creates a new builder-style object to manufacture [`RemoveResourcePermissionInput`](crate::input::RemoveResourcePermissionInput)
    pub fn builder() -> crate::input::remove_resource_permission_input::Builder {
        crate::input::remove_resource_permission_input::Builder::default()
    }
    /// Creates a new `RemoveResourcePermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveResourcePermission {
    type Output = std::result::Result<
        crate::output::RemoveResourcePermissionOutput,
        crate::error::RemoveResourcePermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_remove_resource_permission_error(response)
        } else {
            crate::operation_deser::parse_remove_resource_permission_response(response)
        }
    }
}

/// Operation shape for `UpdateDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_document`](crate::client::Client::update_document).
///
/// See [`crate::client::fluent_builders::UpdateDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDocument {
    _private: (),
}
impl UpdateDocument {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentInput`](crate::input::UpdateDocumentInput)
    pub fn builder() -> crate::input::update_document_input::Builder {
        crate::input::update_document_input::Builder::default()
    }
    /// Creates a new `UpdateDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDocument {
    type Output =
        std::result::Result<crate::output::UpdateDocumentOutput, crate::error::UpdateDocumentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_document_error(response)
        } else {
            crate::operation_deser::parse_update_document_response(response)
        }
    }
}

/// Operation shape for `UpdateDocumentVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_document_version`](crate::client::Client::update_document_version).
///
/// See [`crate::client::fluent_builders::UpdateDocumentVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDocumentVersion {
    _private: (),
}
impl UpdateDocumentVersion {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentVersionInput`](crate::input::UpdateDocumentVersionInput)
    pub fn builder() -> crate::input::update_document_version_input::Builder {
        crate::input::update_document_version_input::Builder::default()
    }
    /// Creates a new `UpdateDocumentVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDocumentVersion {
    type Output = std::result::Result<
        crate::output::UpdateDocumentVersionOutput,
        crate::error::UpdateDocumentVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_document_version_error(response)
        } else {
            crate::operation_deser::parse_update_document_version_response(response)
        }
    }
}

/// Operation shape for `UpdateFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_folder`](crate::client::Client::update_folder).
///
/// See [`crate::client::fluent_builders::UpdateFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFolder {
    _private: (),
}
impl UpdateFolder {
    /// Creates a new builder-style object to manufacture [`UpdateFolderInput`](crate::input::UpdateFolderInput)
    pub fn builder() -> crate::input::update_folder_input::Builder {
        crate::input::update_folder_input::Builder::default()
    }
    /// Creates a new `UpdateFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFolder {
    type Output =
        std::result::Result<crate::output::UpdateFolderOutput, crate::error::UpdateFolderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_folder_error(response)
        } else {
            crate::operation_deser::parse_update_folder_response(response)
        }
    }
}

/// Operation shape for `UpdateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user`](crate::client::Client::update_user).
///
/// See [`crate::client::fluent_builders::UpdateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUser {
    _private: (),
}
impl UpdateUser {
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
    /// Creates a new `UpdateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUser {
    type Output =
        std::result::Result<crate::output::UpdateUserOutput, crate::error::UpdateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_error(response)
        } else {
            crate::operation_deser::parse_update_user_response(response)
        }
    }
}
