// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon WorkDocs
///
/// Client for invoking operations on Amazon WorkDocs. Each operation on Amazon WorkDocs is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_workdocs::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_workdocs::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_workdocs::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AbortDocumentVersionUpload`](crate::client::fluent_builders::AbortDocumentVersionUpload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::AbortDocumentVersionUpload::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::AbortDocumentVersionUpload::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::AbortDocumentVersionUpload::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::AbortDocumentVersionUpload::set_document_id): <p>The ID of the document.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::AbortDocumentVersionUpload::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::AbortDocumentVersionUpload::set_version_id): <p>The ID of the version.</p>
    /// - On success, responds with [`AbortDocumentVersionUploadOutput`](crate::output::AbortDocumentVersionUploadOutput)

    /// - On failure, responds with [`SdkError<AbortDocumentVersionUploadError>`](crate::error::AbortDocumentVersionUploadError)
    pub fn abort_document_version_upload(
        &self,
    ) -> fluent_builders::AbortDocumentVersionUpload<C, M, R> {
        fluent_builders::AbortDocumentVersionUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ActivateUser`](crate::client::fluent_builders::ActivateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::ActivateUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::ActivateUser::set_user_id): <p>The ID of the user.</p>
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::ActivateUser::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::ActivateUser::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    /// - On success, responds with [`ActivateUserOutput`](crate::output::ActivateUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::ActivateUserOutput::user): <p>The user information.</p>
    /// - On failure, responds with [`SdkError<ActivateUserError>`](crate::error::ActivateUserError)
    pub fn activate_user(&self) -> fluent_builders::ActivateUser<C, M, R> {
        fluent_builders::ActivateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddResourcePermissions`](crate::client::fluent_builders::AddResourcePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::AddResourcePermissions::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::AddResourcePermissions::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::AddResourcePermissions::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::AddResourcePermissions::set_resource_id): <p>The ID of the resource.</p>
    ///   - [`principals(Vec<SharePrincipal>)`](crate::client::fluent_builders::AddResourcePermissions::principals) / [`set_principals(Option<Vec<SharePrincipal>>)`](crate::client::fluent_builders::AddResourcePermissions::set_principals): <p>The users, groups, or organization being granted permission.</p>
    ///   - [`notification_options(NotificationOptions)`](crate::client::fluent_builders::AddResourcePermissions::notification_options) / [`set_notification_options(Option<NotificationOptions>)`](crate::client::fluent_builders::AddResourcePermissions::set_notification_options): <p>The notification options.</p>
    /// - On success, responds with [`AddResourcePermissionsOutput`](crate::output::AddResourcePermissionsOutput) with field(s):
    ///   - [`share_results(Option<Vec<ShareResult>>)`](crate::output::AddResourcePermissionsOutput::share_results): <p>The share results.</p>
    /// - On failure, responds with [`SdkError<AddResourcePermissionsError>`](crate::error::AddResourcePermissionsError)
    pub fn add_resource_permissions(&self) -> fluent_builders::AddResourcePermissions<C, M, R> {
        fluent_builders::AddResourcePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateComment`](crate::client::fluent_builders::CreateComment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::CreateComment::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::CreateComment::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::CreateComment::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::CreateComment::set_document_id): <p>The ID of the document.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::CreateComment::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::CreateComment::set_version_id): <p>The ID of the document version.</p>
    ///   - [`parent_id(impl Into<String>)`](crate::client::fluent_builders::CreateComment::parent_id) / [`set_parent_id(Option<String>)`](crate::client::fluent_builders::CreateComment::set_parent_id): <p>The ID of the parent comment.</p>
    ///   - [`thread_id(impl Into<String>)`](crate::client::fluent_builders::CreateComment::thread_id) / [`set_thread_id(Option<String>)`](crate::client::fluent_builders::CreateComment::set_thread_id): <p>The ID of the root comment in the thread.</p>
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::CreateComment::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::CreateComment::set_text): <p>The text of the comment.</p>
    ///   - [`visibility(CommentVisibilityType)`](crate::client::fluent_builders::CreateComment::visibility) / [`set_visibility(Option<CommentVisibilityType>)`](crate::client::fluent_builders::CreateComment::set_visibility): <p>The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners, and contributors.</p>
    ///   - [`notify_collaborators(bool)`](crate::client::fluent_builders::CreateComment::notify_collaborators) / [`set_notify_collaborators(bool)`](crate::client::fluent_builders::CreateComment::set_notify_collaborators): <p>Set this parameter to TRUE to send an email out to the document collaborators after the comment is created.</p>
    /// - On success, responds with [`CreateCommentOutput`](crate::output::CreateCommentOutput) with field(s):
    ///   - [`comment(Option<Comment>)`](crate::output::CreateCommentOutput::comment): <p>The comment that has been created.</p>
    /// - On failure, responds with [`SdkError<CreateCommentError>`](crate::error::CreateCommentError)
    pub fn create_comment(&self) -> fluent_builders::CreateComment<C, M, R> {
        fluent_builders::CreateComment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomMetadata`](crate::client::fluent_builders::CreateCustomMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::CreateCustomMetadata::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::CreateCustomMetadata::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::CreateCustomMetadata::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::CreateCustomMetadata::set_resource_id): <p>The ID of the resource.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::CreateCustomMetadata::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::CreateCustomMetadata::set_version_id): <p>The ID of the version, if the custom metadata is being added to a document version.</p>
    ///   - [`custom_metadata(HashMap<String, String>)`](crate::client::fluent_builders::CreateCustomMetadata::custom_metadata) / [`set_custom_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateCustomMetadata::set_custom_metadata): <p>Custom metadata in the form of name-value pairs.</p>
    /// - On success, responds with [`CreateCustomMetadataOutput`](crate::output::CreateCustomMetadataOutput)

    /// - On failure, responds with [`SdkError<CreateCustomMetadataError>`](crate::error::CreateCustomMetadataError)
    pub fn create_custom_metadata(&self) -> fluent_builders::CreateCustomMetadata<C, M, R> {
        fluent_builders::CreateCustomMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFolder`](crate::client::fluent_builders::CreateFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::CreateFolder::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::CreateFolder::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFolder::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFolder::set_name): <p>The name of the new folder.</p>
    ///   - [`parent_folder_id(impl Into<String>)`](crate::client::fluent_builders::CreateFolder::parent_folder_id) / [`set_parent_folder_id(Option<String>)`](crate::client::fluent_builders::CreateFolder::set_parent_folder_id): <p>The ID of the parent folder.</p>
    /// - On success, responds with [`CreateFolderOutput`](crate::output::CreateFolderOutput) with field(s):
    ///   - [`metadata(Option<FolderMetadata>)`](crate::output::CreateFolderOutput::metadata): <p>The metadata of the folder.</p>
    /// - On failure, responds with [`SdkError<CreateFolderError>`](crate::error::CreateFolderError)
    pub fn create_folder(&self) -> fluent_builders::CreateFolder<C, M, R> {
        fluent_builders::CreateFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLabels`](crate::client::fluent_builders::CreateLabels) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::CreateLabels::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::CreateLabels::set_resource_id): <p>The ID of the resource.</p>
    ///   - [`labels(Vec<String>)`](crate::client::fluent_builders::CreateLabels::labels) / [`set_labels(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLabels::set_labels): <p>List of labels to add to the resource.</p>
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::CreateLabels::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::CreateLabels::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    /// - On success, responds with [`CreateLabelsOutput`](crate::output::CreateLabelsOutput)

    /// - On failure, responds with [`SdkError<CreateLabelsError>`](crate::error::CreateLabelsError)
    pub fn create_labels(&self) -> fluent_builders::CreateLabels<C, M, R> {
        fluent_builders::CreateLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNotificationSubscription`](crate::client::fluent_builders::CreateNotificationSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::CreateNotificationSubscription::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::CreateNotificationSubscription::set_organization_id): <p>The ID of the organization.</p>
    ///   - [`endpoint(impl Into<String>)`](crate::client::fluent_builders::CreateNotificationSubscription::endpoint) / [`set_endpoint(Option<String>)`](crate::client::fluent_builders::CreateNotificationSubscription::set_endpoint): <p>The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins with <code>https</code>.</p>
    ///   - [`protocol(SubscriptionProtocolType)`](crate::client::fluent_builders::CreateNotificationSubscription::protocol) / [`set_protocol(Option<SubscriptionProtocolType>)`](crate::client::fluent_builders::CreateNotificationSubscription::set_protocol): <p>The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.</p>
    ///   - [`subscription_type(SubscriptionType)`](crate::client::fluent_builders::CreateNotificationSubscription::subscription_type) / [`set_subscription_type(Option<SubscriptionType>)`](crate::client::fluent_builders::CreateNotificationSubscription::set_subscription_type): <p>The notification type.</p>
    /// - On success, responds with [`CreateNotificationSubscriptionOutput`](crate::output::CreateNotificationSubscriptionOutput) with field(s):
    ///   - [`subscription(Option<Subscription>)`](crate::output::CreateNotificationSubscriptionOutput::subscription): <p>The subscription.</p>
    /// - On failure, responds with [`SdkError<CreateNotificationSubscriptionError>`](crate::error::CreateNotificationSubscriptionError)
    pub fn create_notification_subscription(
        &self,
    ) -> fluent_builders::CreateNotificationSubscription<C, M, R> {
        fluent_builders::CreateNotificationSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUser`](crate::client::fluent_builders::CreateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_organization_id): <p>The ID of the organization.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::CreateUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::CreateUser::set_username): <p>The login name of the user.</p>
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::CreateUser::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::CreateUser::set_email_address): <p>The email address of the user.</p>
    ///   - [`given_name(impl Into<String>)`](crate::client::fluent_builders::CreateUser::given_name) / [`set_given_name(Option<String>)`](crate::client::fluent_builders::CreateUser::set_given_name): <p>The given name of the user.</p>
    ///   - [`surname(impl Into<String>)`](crate::client::fluent_builders::CreateUser::surname) / [`set_surname(Option<String>)`](crate::client::fluent_builders::CreateUser::set_surname): <p>The surname of the user.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::CreateUser::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::CreateUser::set_password): <p>The password of the user.</p>
    ///   - [`time_zone_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::time_zone_id) / [`set_time_zone_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_time_zone_id): <p>The time zone ID of the user.</p>
    ///   - [`storage_rule(StorageRuleType)`](crate::client::fluent_builders::CreateUser::storage_rule) / [`set_storage_rule(Option<StorageRuleType>)`](crate::client::fluent_builders::CreateUser::set_storage_rule): <p>The amount of storage for the user.</p>
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::CreateUser::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::CreateUser::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    /// - On success, responds with [`CreateUserOutput`](crate::output::CreateUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::CreateUserOutput::user): <p>The user information.</p>
    /// - On failure, responds with [`SdkError<CreateUserError>`](crate::error::CreateUserError)
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeactivateUser`](crate::client::fluent_builders::DeactivateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DeactivateUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DeactivateUser::set_user_id): <p>The ID of the user.</p>
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DeactivateUser::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DeactivateUser::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    /// - On success, responds with [`DeactivateUserOutput`](crate::output::DeactivateUserOutput)

    /// - On failure, responds with [`SdkError<DeactivateUserError>`](crate::error::DeactivateUserError)
    pub fn deactivate_user(&self) -> fluent_builders::DeactivateUser<C, M, R> {
        fluent_builders::DeactivateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteComment`](crate::client::fluent_builders::DeleteComment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DeleteComment::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DeleteComment::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::DeleteComment::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::DeleteComment::set_document_id): <p>The ID of the document.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::DeleteComment::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::DeleteComment::set_version_id): <p>The ID of the document version.</p>
    ///   - [`comment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteComment::comment_id) / [`set_comment_id(Option<String>)`](crate::client::fluent_builders::DeleteComment::set_comment_id): <p>The ID of the comment.</p>
    /// - On success, responds with [`DeleteCommentOutput`](crate::output::DeleteCommentOutput)

    /// - On failure, responds with [`SdkError<DeleteCommentError>`](crate::error::DeleteCommentError)
    pub fn delete_comment(&self) -> fluent_builders::DeleteComment<C, M, R> {
        fluent_builders::DeleteComment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomMetadata`](crate::client::fluent_builders::DeleteCustomMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomMetadata::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DeleteCustomMetadata::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomMetadata::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteCustomMetadata::set_resource_id): <p>The ID of the resource, either a document or folder.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomMetadata::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::DeleteCustomMetadata::set_version_id): <p>The ID of the version, if the custom metadata is being deleted from a document version.</p>
    ///   - [`keys(Vec<String>)`](crate::client::fluent_builders::DeleteCustomMetadata::keys) / [`set_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteCustomMetadata::set_keys): <p>List of properties to remove.</p>
    ///   - [`delete_all(bool)`](crate::client::fluent_builders::DeleteCustomMetadata::delete_all) / [`set_delete_all(bool)`](crate::client::fluent_builders::DeleteCustomMetadata::set_delete_all): <p>Flag to indicate removal of all custom metadata properties from the specified resource.</p>
    /// - On success, responds with [`DeleteCustomMetadataOutput`](crate::output::DeleteCustomMetadataOutput)

    /// - On failure, responds with [`SdkError<DeleteCustomMetadataError>`](crate::error::DeleteCustomMetadataError)
    pub fn delete_custom_metadata(&self) -> fluent_builders::DeleteCustomMetadata<C, M, R> {
        fluent_builders::DeleteCustomMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDocument`](crate::client::fluent_builders::DeleteDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DeleteDocument::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DeleteDocument::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDocument::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::DeleteDocument::set_document_id): <p>The ID of the document.</p>
    /// - On success, responds with [`DeleteDocumentOutput`](crate::output::DeleteDocumentOutput)

    /// - On failure, responds with [`SdkError<DeleteDocumentError>`](crate::error::DeleteDocumentError)
    pub fn delete_document(&self) -> fluent_builders::DeleteDocument<C, M, R> {
        fluent_builders::DeleteDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFolder`](crate::client::fluent_builders::DeleteFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DeleteFolder::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DeleteFolder::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFolder::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::DeleteFolder::set_folder_id): <p>The ID of the folder.</p>
    /// - On success, responds with [`DeleteFolderOutput`](crate::output::DeleteFolderOutput)

    /// - On failure, responds with [`SdkError<DeleteFolderError>`](crate::error::DeleteFolderError)
    pub fn delete_folder(&self) -> fluent_builders::DeleteFolder<C, M, R> {
        fluent_builders::DeleteFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFolderContents`](crate::client::fluent_builders::DeleteFolderContents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DeleteFolderContents::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DeleteFolderContents::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFolderContents::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::DeleteFolderContents::set_folder_id): <p>The ID of the folder.</p>
    /// - On success, responds with [`DeleteFolderContentsOutput`](crate::output::DeleteFolderContentsOutput)

    /// - On failure, responds with [`SdkError<DeleteFolderContentsError>`](crate::error::DeleteFolderContentsError)
    pub fn delete_folder_contents(&self) -> fluent_builders::DeleteFolderContents<C, M, R> {
        fluent_builders::DeleteFolderContents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLabels`](crate::client::fluent_builders::DeleteLabels) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLabels::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteLabels::set_resource_id): <p>The ID of the resource.</p>
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DeleteLabels::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DeleteLabels::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`labels(Vec<String>)`](crate::client::fluent_builders::DeleteLabels::labels) / [`set_labels(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteLabels::set_labels): <p>List of labels to delete from the resource.</p>
    ///   - [`delete_all(bool)`](crate::client::fluent_builders::DeleteLabels::delete_all) / [`set_delete_all(bool)`](crate::client::fluent_builders::DeleteLabels::set_delete_all): <p>Flag to request removal of all labels from the specified resource.</p>
    /// - On success, responds with [`DeleteLabelsOutput`](crate::output::DeleteLabelsOutput)

    /// - On failure, responds with [`SdkError<DeleteLabelsError>`](crate::error::DeleteLabelsError)
    pub fn delete_labels(&self) -> fluent_builders::DeleteLabels<C, M, R> {
        fluent_builders::DeleteLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNotificationSubscription`](crate::client::fluent_builders::DeleteNotificationSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNotificationSubscription::subscription_id) / [`set_subscription_id(Option<String>)`](crate::client::fluent_builders::DeleteNotificationSubscription::set_subscription_id): <p>The ID of the subscription.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNotificationSubscription::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DeleteNotificationSubscription::set_organization_id): <p>The ID of the organization.</p>
    /// - On success, responds with [`DeleteNotificationSubscriptionOutput`](crate::output::DeleteNotificationSubscriptionOutput)

    /// - On failure, responds with [`SdkError<DeleteNotificationSubscriptionError>`](crate::error::DeleteNotificationSubscriptionError)
    pub fn delete_notification_subscription(
        &self,
    ) -> fluent_builders::DeleteNotificationSubscription<C, M, R> {
        fluent_builders::DeleteNotificationSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUser`](crate::client::fluent_builders::DeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_authentication_token): <p>Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as in accessing the API using AWS credentials.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_user_id): <p>The ID of the user.</p>
    /// - On success, responds with [`DeleteUserOutput`](crate::output::DeleteUserOutput)

    /// - On failure, responds with [`SdkError<DeleteUserError>`](crate::error::DeleteUserError)
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeActivities`](crate::client::fluent_builders::DescribeActivities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DescribeActivities::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DescribeActivities::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeActivities::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeActivities::set_start_time): <p>The timestamp that determines the starting time of the activities. The response includes the activities performed after the specified timestamp.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeActivities::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeActivities::set_end_time): <p>The timestamp that determines the end time of the activities. The response includes the activities performed before the specified timestamp.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeActivities::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeActivities::set_organization_id): <p>The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests.</p>
    ///   - [`activity_types(impl Into<String>)`](crate::client::fluent_builders::DescribeActivities::activity_types) / [`set_activity_types(Option<String>)`](crate::client::fluent_builders::DescribeActivities::set_activity_types): <p>Specifies which activity types to include in the response. If this field is left empty, all activity types are returned.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DescribeActivities::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DescribeActivities::set_resource_id): <p>The document or folder ID for which to describe activity types.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DescribeActivities::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DescribeActivities::set_user_id): <p>The ID of the user who performed the action. The response includes activities pertaining to this user. This is an optional parameter and is only applicable for administrative API (SigV4) requests.</p>
    ///   - [`include_indirect_activities(bool)`](crate::client::fluent_builders::DescribeActivities::include_indirect_activities) / [`set_include_indirect_activities(bool)`](crate::client::fluent_builders::DescribeActivities::set_include_indirect_activities): <p>Includes indirect activities. An indirect activity results from a direct activity performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of the subfolders and documents within the parent folder (the indirect activity).</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeActivities::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeActivities::set_limit): <p>The maximum number of items to return.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeActivities::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeActivities::set_marker): <p>The marker for the next set of results.</p>
    /// - On success, responds with [`DescribeActivitiesOutput`](crate::output::DescribeActivitiesOutput) with field(s):
    ///   - [`user_activities(Option<Vec<Activity>>)`](crate::output::DescribeActivitiesOutput::user_activities): <p>The list of activities for the specified user and time period.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeActivitiesOutput::marker): <p>The marker for the next set of results.</p>
    /// - On failure, responds with [`SdkError<DescribeActivitiesError>`](crate::error::DescribeActivitiesError)
    pub fn describe_activities(&self) -> fluent_builders::DescribeActivities<C, M, R> {
        fluent_builders::DescribeActivities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeComments`](crate::client::fluent_builders::DescribeComments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DescribeComments::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DescribeComments::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::DescribeComments::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::DescribeComments::set_document_id): <p>The ID of the document.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::DescribeComments::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::DescribeComments::set_version_id): <p>The ID of the document version.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeComments::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeComments::set_limit): <p>The maximum number of items to return.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeComments::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeComments::set_marker): <p>The marker for the next set of results. This marker was received from a previous call.</p>
    /// - On success, responds with [`DescribeCommentsOutput`](crate::output::DescribeCommentsOutput) with field(s):
    ///   - [`comments(Option<Vec<Comment>>)`](crate::output::DescribeCommentsOutput::comments): <p>The list of comments for the specified document version.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeCommentsOutput::marker): <p>The marker for the next set of results. This marker was received from a previous call.</p>
    /// - On failure, responds with [`SdkError<DescribeCommentsError>`](crate::error::DescribeCommentsError)
    pub fn describe_comments(&self) -> fluent_builders::DescribeComments<C, M, R> {
        fluent_builders::DescribeComments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDocumentVersions`](crate::client::fluent_builders::DescribeDocumentVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDocumentVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDocumentVersions::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DescribeDocumentVersions::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDocumentVersions::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::DescribeDocumentVersions::set_document_id): <p>The ID of the document.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDocumentVersions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDocumentVersions::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeDocumentVersions::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeDocumentVersions::set_limit): <p>The maximum number of versions to return with this call.</p>
    ///   - [`include(impl Into<String>)`](crate::client::fluent_builders::DescribeDocumentVersions::include) / [`set_include(Option<String>)`](crate::client::fluent_builders::DescribeDocumentVersions::set_include): <p>A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.</p>
    ///   - [`fields(impl Into<String>)`](crate::client::fluent_builders::DescribeDocumentVersions::fields) / [`set_fields(Option<String>)`](crate::client::fluent_builders::DescribeDocumentVersions::set_fields): <p>Specify "SOURCE" to include initialized versions and a URL for the source document.</p>
    /// - On success, responds with [`DescribeDocumentVersionsOutput`](crate::output::DescribeDocumentVersionsOutput) with field(s):
    ///   - [`document_versions(Option<Vec<DocumentVersionMetadata>>)`](crate::output::DescribeDocumentVersionsOutput::document_versions): <p>The document versions.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDocumentVersionsOutput::marker): <p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeDocumentVersionsError>`](crate::error::DescribeDocumentVersionsError)
    pub fn describe_document_versions(&self) -> fluent_builders::DescribeDocumentVersions<C, M, R> {
        fluent_builders::DescribeDocumentVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFolderContents`](crate::client::fluent_builders::DescribeFolderContents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeFolderContents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFolderContents::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DescribeFolderContents::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFolderContents::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::DescribeFolderContents::set_folder_id): <p>The ID of the folder.</p>
    ///   - [`sort(ResourceSortType)`](crate::client::fluent_builders::DescribeFolderContents::sort) / [`set_sort(Option<ResourceSortType>)`](crate::client::fluent_builders::DescribeFolderContents::set_sort): <p>The sorting criteria.</p>
    ///   - [`order(OrderType)`](crate::client::fluent_builders::DescribeFolderContents::order) / [`set_order(Option<OrderType>)`](crate::client::fluent_builders::DescribeFolderContents::set_order): <p>The order for the contents of the folder.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeFolderContents::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeFolderContents::set_limit): <p>The maximum number of items to return with this call.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeFolderContents::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeFolderContents::set_marker): <p>The marker for the next set of results. This marker was received from a previous call.</p>
    ///   - [`r#type(FolderContentType)`](crate::client::fluent_builders::DescribeFolderContents::r#type) / [`set_type(Option<FolderContentType>)`](crate::client::fluent_builders::DescribeFolderContents::set_type): <p>The type of items.</p>
    ///   - [`include(impl Into<String>)`](crate::client::fluent_builders::DescribeFolderContents::include) / [`set_include(Option<String>)`](crate::client::fluent_builders::DescribeFolderContents::set_include): <p>The contents to include. Specify "INITIALIZED" to include initialized documents.</p>
    /// - On success, responds with [`DescribeFolderContentsOutput`](crate::output::DescribeFolderContentsOutput) with field(s):
    ///   - [`folders(Option<Vec<FolderMetadata>>)`](crate::output::DescribeFolderContentsOutput::folders): <p>The subfolders in the specified folder.</p>
    ///   - [`documents(Option<Vec<DocumentMetadata>>)`](crate::output::DescribeFolderContentsOutput::documents): <p>The documents in the specified folder.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeFolderContentsOutput::marker): <p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeFolderContentsError>`](crate::error::DescribeFolderContentsError)
    pub fn describe_folder_contents(&self) -> fluent_builders::DescribeFolderContents<C, M, R> {
        fluent_builders::DescribeFolderContents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGroups`](crate::client::fluent_builders::DescribeGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DescribeGroups::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DescribeGroups::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`search_query(impl Into<String>)`](crate::client::fluent_builders::DescribeGroups::search_query) / [`set_search_query(Option<String>)`](crate::client::fluent_builders::DescribeGroups::set_search_query): <p>A query to describe groups by group name.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeGroups::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeGroups::set_organization_id): <p>The ID of the organization.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeGroups::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeGroups::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeGroups::set_limit): <p>The maximum number of items to return with this call.</p>
    /// - On success, responds with [`DescribeGroupsOutput`](crate::output::DescribeGroupsOutput) with field(s):
    ///   - [`groups(Option<Vec<GroupMetadata>>)`](crate::output::DescribeGroupsOutput::groups): <p>The list of groups.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeGroupsOutput::marker): <p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeGroupsError>`](crate::error::DescribeGroupsError)
    pub fn describe_groups(&self) -> fluent_builders::DescribeGroups<C, M, R> {
        fluent_builders::DescribeGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNotificationSubscriptions`](crate::client::fluent_builders::DescribeNotificationSubscriptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeNotificationSubscriptions::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeNotificationSubscriptions::set_organization_id): <p>The ID of the organization.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeNotificationSubscriptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeNotificationSubscriptions::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeNotificationSubscriptions::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeNotificationSubscriptions::set_limit): <p>The maximum number of items to return with this call.</p>
    /// - On success, responds with [`DescribeNotificationSubscriptionsOutput`](crate::output::DescribeNotificationSubscriptionsOutput) with field(s):
    ///   - [`subscriptions(Option<Vec<Subscription>>)`](crate::output::DescribeNotificationSubscriptionsOutput::subscriptions): <p>The subscriptions.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeNotificationSubscriptionsOutput::marker): <p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeNotificationSubscriptionsError>`](crate::error::DescribeNotificationSubscriptionsError)
    pub fn describe_notification_subscriptions(
        &self,
    ) -> fluent_builders::DescribeNotificationSubscriptions<C, M, R> {
        fluent_builders::DescribeNotificationSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResourcePermissions`](crate::client::fluent_builders::DescribeResourcePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DescribeResourcePermissions::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DescribeResourcePermissions::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DescribeResourcePermissions::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DescribeResourcePermissions::set_resource_id): <p>The ID of the resource.</p>
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::DescribeResourcePermissions::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::DescribeResourcePermissions::set_principal_id): <p>The ID of the principal to filter permissions by.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeResourcePermissions::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeResourcePermissions::set_limit): <p>The maximum number of items to return with this call.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeResourcePermissions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeResourcePermissions::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call)</p>
    /// - On success, responds with [`DescribeResourcePermissionsOutput`](crate::output::DescribeResourcePermissionsOutput) with field(s):
    ///   - [`principals(Option<Vec<Principal>>)`](crate::output::DescribeResourcePermissionsOutput::principals): <p>The principals.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeResourcePermissionsOutput::marker): <p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeResourcePermissionsError>`](crate::error::DescribeResourcePermissionsError)
    pub fn describe_resource_permissions(
        &self,
    ) -> fluent_builders::DescribeResourcePermissions<C, M, R> {
        fluent_builders::DescribeResourcePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRootFolders`](crate::client::fluent_builders::DescribeRootFolders) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DescribeRootFolders::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DescribeRootFolders::set_authentication_token): <p>Amazon WorkDocs authentication token.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeRootFolders::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeRootFolders::set_limit): <p>The maximum number of items to return.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeRootFolders::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeRootFolders::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    /// - On success, responds with [`DescribeRootFoldersOutput`](crate::output::DescribeRootFoldersOutput) with field(s):
    ///   - [`folders(Option<Vec<FolderMetadata>>)`](crate::output::DescribeRootFoldersOutput::folders): <p>The user's special folders.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeRootFoldersOutput::marker): <p>The marker for the next set of results.</p>
    /// - On failure, responds with [`SdkError<DescribeRootFoldersError>`](crate::error::DescribeRootFoldersError)
    pub fn describe_root_folders(&self) -> fluent_builders::DescribeRootFolders<C, M, R> {
        fluent_builders::DescribeRootFolders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUsers`](crate::client::fluent_builders::DescribeUsers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeUsers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_organization_id): <p>The ID of the organization.</p>
    ///   - [`user_ids(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::user_ids) / [`set_user_ids(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_user_ids): <p>The IDs of the users.</p>
    ///   - [`query(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::query) / [`set_query(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_query): <p>A query to filter users by user name.</p>
    ///   - [`include(UserFilterType)`](crate::client::fluent_builders::DescribeUsers::include) / [`set_include(Option<UserFilterType>)`](crate::client::fluent_builders::DescribeUsers::set_include): <p>The state of the users. Specify "ALL" to include inactive users.</p>
    ///   - [`order(OrderType)`](crate::client::fluent_builders::DescribeUsers::order) / [`set_order(Option<OrderType>)`](crate::client::fluent_builders::DescribeUsers::set_order): <p>The order for the results.</p>
    ///   - [`sort(UserSortType)`](crate::client::fluent_builders::DescribeUsers::sort) / [`set_sort(Option<UserSortType>)`](crate::client::fluent_builders::DescribeUsers::set_sort): <p>The sorting criteria.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_marker): <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeUsers::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeUsers::set_limit): <p>The maximum number of items to return.</p>
    ///   - [`fields(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::fields) / [`set_fields(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_fields): <p>A comma-separated list of values. Specify "STORAGE_METADATA" to include the user storage quota and utilization information.</p>
    /// - On success, responds with [`DescribeUsersOutput`](crate::output::DescribeUsersOutput) with field(s):
    ///   - [`users(Option<Vec<User>>)`](crate::output::DescribeUsersOutput::users): <p>The users.</p>
    ///   - [`total_number_of_users(Option<i64>)`](crate::output::DescribeUsersOutput::total_number_of_users): <p>The total number of users included in the results.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeUsersOutput::marker): <p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeUsersError>`](crate::error::DescribeUsersError)
    pub fn describe_users(&self) -> fluent_builders::DescribeUsers<C, M, R> {
        fluent_builders::DescribeUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCurrentUser`](crate::client::fluent_builders::GetCurrentUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::GetCurrentUser::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::GetCurrentUser::set_authentication_token): <p>Amazon WorkDocs authentication token.</p>
    /// - On success, responds with [`GetCurrentUserOutput`](crate::output::GetCurrentUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::GetCurrentUserOutput::user): <p>Metadata of the user.</p>
    /// - On failure, responds with [`SdkError<GetCurrentUserError>`](crate::error::GetCurrentUserError)
    pub fn get_current_user(&self) -> fluent_builders::GetCurrentUser<C, M, R> {
        fluent_builders::GetCurrentUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDocument`](crate::client::fluent_builders::GetDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::GetDocument::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::GetDocument::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::GetDocument::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::GetDocument::set_document_id): <p>The ID of the document.</p>
    ///   - [`include_custom_metadata(bool)`](crate::client::fluent_builders::GetDocument::include_custom_metadata) / [`set_include_custom_metadata(bool)`](crate::client::fluent_builders::GetDocument::set_include_custom_metadata): <p>Set this to <code>TRUE</code> to include custom metadata in the response.</p>
    /// - On success, responds with [`GetDocumentOutput`](crate::output::GetDocumentOutput) with field(s):
    ///   - [`metadata(Option<DocumentMetadata>)`](crate::output::GetDocumentOutput::metadata): <p>The metadata details of the document.</p>
    ///   - [`custom_metadata(Option<HashMap<String, String>>)`](crate::output::GetDocumentOutput::custom_metadata): <p>The custom metadata on the document.</p>
    /// - On failure, responds with [`SdkError<GetDocumentError>`](crate::error::GetDocumentError)
    pub fn get_document(&self) -> fluent_builders::GetDocument<C, M, R> {
        fluent_builders::GetDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDocumentPath`](crate::client::fluent_builders::GetDocumentPath) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::GetDocumentPath::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::GetDocumentPath::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::GetDocumentPath::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::GetDocumentPath::set_document_id): <p>The ID of the document.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetDocumentPath::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetDocumentPath::set_limit): <p>The maximum number of levels in the hierarchy to return.</p>
    ///   - [`fields(impl Into<String>)`](crate::client::fluent_builders::GetDocumentPath::fields) / [`set_fields(Option<String>)`](crate::client::fluent_builders::GetDocumentPath::set_fields): <p>A comma-separated list of values. Specify <code>NAME</code> to include the names of the parent folders.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::GetDocumentPath::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::GetDocumentPath::set_marker): <p>This value is not supported.</p>
    /// - On success, responds with [`GetDocumentPathOutput`](crate::output::GetDocumentPathOutput) with field(s):
    ///   - [`path(Option<ResourcePath>)`](crate::output::GetDocumentPathOutput::path): <p>The path information.</p>
    /// - On failure, responds with [`SdkError<GetDocumentPathError>`](crate::error::GetDocumentPathError)
    pub fn get_document_path(&self) -> fluent_builders::GetDocumentPath<C, M, R> {
        fluent_builders::GetDocumentPath::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDocumentVersion`](crate::client::fluent_builders::GetDocumentVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::GetDocumentVersion::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::GetDocumentVersion::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::GetDocumentVersion::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::GetDocumentVersion::set_document_id): <p>The ID of the document.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::GetDocumentVersion::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::GetDocumentVersion::set_version_id): <p>The version ID of the document.</p>
    ///   - [`fields(impl Into<String>)`](crate::client::fluent_builders::GetDocumentVersion::fields) / [`set_fields(Option<String>)`](crate::client::fluent_builders::GetDocumentVersion::set_fields): <p>A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.</p>
    ///   - [`include_custom_metadata(bool)`](crate::client::fluent_builders::GetDocumentVersion::include_custom_metadata) / [`set_include_custom_metadata(bool)`](crate::client::fluent_builders::GetDocumentVersion::set_include_custom_metadata): <p>Set this to TRUE to include custom metadata in the response.</p>
    /// - On success, responds with [`GetDocumentVersionOutput`](crate::output::GetDocumentVersionOutput) with field(s):
    ///   - [`metadata(Option<DocumentVersionMetadata>)`](crate::output::GetDocumentVersionOutput::metadata): <p>The version metadata.</p>
    ///   - [`custom_metadata(Option<HashMap<String, String>>)`](crate::output::GetDocumentVersionOutput::custom_metadata): <p>The custom metadata on the document version.</p>
    /// - On failure, responds with [`SdkError<GetDocumentVersionError>`](crate::error::GetDocumentVersionError)
    pub fn get_document_version(&self) -> fluent_builders::GetDocumentVersion<C, M, R> {
        fluent_builders::GetDocumentVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFolder`](crate::client::fluent_builders::GetFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::GetFolder::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::GetFolder::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::GetFolder::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::GetFolder::set_folder_id): <p>The ID of the folder.</p>
    ///   - [`include_custom_metadata(bool)`](crate::client::fluent_builders::GetFolder::include_custom_metadata) / [`set_include_custom_metadata(bool)`](crate::client::fluent_builders::GetFolder::set_include_custom_metadata): <p>Set to TRUE to include custom metadata in the response.</p>
    /// - On success, responds with [`GetFolderOutput`](crate::output::GetFolderOutput) with field(s):
    ///   - [`metadata(Option<FolderMetadata>)`](crate::output::GetFolderOutput::metadata): <p>The metadata of the folder.</p>
    ///   - [`custom_metadata(Option<HashMap<String, String>>)`](crate::output::GetFolderOutput::custom_metadata): <p>The custom metadata on the folder.</p>
    /// - On failure, responds with [`SdkError<GetFolderError>`](crate::error::GetFolderError)
    pub fn get_folder(&self) -> fluent_builders::GetFolder<C, M, R> {
        fluent_builders::GetFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFolderPath`](crate::client::fluent_builders::GetFolderPath) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::GetFolderPath::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::GetFolderPath::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::GetFolderPath::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::GetFolderPath::set_folder_id): <p>The ID of the folder.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetFolderPath::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetFolderPath::set_limit): <p>The maximum number of levels in the hierarchy to return.</p>
    ///   - [`fields(impl Into<String>)`](crate::client::fluent_builders::GetFolderPath::fields) / [`set_fields(Option<String>)`](crate::client::fluent_builders::GetFolderPath::set_fields): <p>A comma-separated list of values. Specify "NAME" to include the names of the parent folders.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::GetFolderPath::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::GetFolderPath::set_marker): <p>This value is not supported.</p>
    /// - On success, responds with [`GetFolderPathOutput`](crate::output::GetFolderPathOutput) with field(s):
    ///   - [`path(Option<ResourcePath>)`](crate::output::GetFolderPathOutput::path): <p>The path information.</p>
    /// - On failure, responds with [`SdkError<GetFolderPathError>`](crate::error::GetFolderPathError)
    pub fn get_folder_path(&self) -> fluent_builders::GetFolderPath<C, M, R> {
        fluent_builders::GetFolderPath::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResources`](crate::client::fluent_builders::GetResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::GetResources::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::GetResources::set_authentication_token): <p>The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::GetResources::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::GetResources::set_user_id): <p>The user ID for the resource collection. This is a required field for accessing the API operation using IAM credentials.</p>
    ///   - [`collection_type(ResourceCollectionType)`](crate::client::fluent_builders::GetResources::collection_type) / [`set_collection_type(Option<ResourceCollectionType>)`](crate::client::fluent_builders::GetResources::set_collection_type): <p>The collection type.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetResources::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetResources::set_limit): <p>The maximum number of resources to return.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::GetResources::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::GetResources::set_marker): <p>The marker for the next set of results. This marker was received from a previous call.</p>
    /// - On success, responds with [`GetResourcesOutput`](crate::output::GetResourcesOutput) with field(s):
    ///   - [`folders(Option<Vec<FolderMetadata>>)`](crate::output::GetResourcesOutput::folders): <p>The folders in the specified folder.</p>
    ///   - [`documents(Option<Vec<DocumentMetadata>>)`](crate::output::GetResourcesOutput::documents): <p>The documents in the specified collection.</p>
    ///   - [`marker(Option<String>)`](crate::output::GetResourcesOutput::marker): <p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>
    /// - On failure, responds with [`SdkError<GetResourcesError>`](crate::error::GetResourcesError)
    pub fn get_resources(&self) -> fluent_builders::GetResources<C, M, R> {
        fluent_builders::GetResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InitiateDocumentVersionUpload`](crate::client::fluent_builders::InitiateDocumentVersionUpload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::set_id): <p>The ID of the document.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::set_name): <p>The name of the document.</p>
    ///   - [`content_created_timestamp(DateTime)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::content_created_timestamp) / [`set_content_created_timestamp(Option<DateTime>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::set_content_created_timestamp): <p>The timestamp when the content of the document was originally created.</p>
    ///   - [`content_modified_timestamp(DateTime)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::content_modified_timestamp) / [`set_content_modified_timestamp(Option<DateTime>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::set_content_modified_timestamp): <p>The timestamp when the content of the document was modified.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::set_content_type): <p>The content type of the document.</p>
    ///   - [`document_size_in_bytes(i64)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::document_size_in_bytes) / [`set_document_size_in_bytes(Option<i64>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::set_document_size_in_bytes): <p>The size of the document, in bytes.</p>
    ///   - [`parent_folder_id(impl Into<String>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::parent_folder_id) / [`set_parent_folder_id(Option<String>)`](crate::client::fluent_builders::InitiateDocumentVersionUpload::set_parent_folder_id): <p>The ID of the parent folder.</p>
    /// - On success, responds with [`InitiateDocumentVersionUploadOutput`](crate::output::InitiateDocumentVersionUploadOutput) with field(s):
    ///   - [`metadata(Option<DocumentMetadata>)`](crate::output::InitiateDocumentVersionUploadOutput::metadata): <p>The document metadata.</p>
    ///   - [`upload_metadata(Option<UploadMetadata>)`](crate::output::InitiateDocumentVersionUploadOutput::upload_metadata): <p>The upload metadata.</p>
    /// - On failure, responds with [`SdkError<InitiateDocumentVersionUploadError>`](crate::error::InitiateDocumentVersionUploadError)
    pub fn initiate_document_version_upload(
        &self,
    ) -> fluent_builders::InitiateDocumentVersionUpload<C, M, R> {
        fluent_builders::InitiateDocumentVersionUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveAllResourcePermissions`](crate::client::fluent_builders::RemoveAllResourcePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::RemoveAllResourcePermissions::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::RemoveAllResourcePermissions::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::RemoveAllResourcePermissions::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::RemoveAllResourcePermissions::set_resource_id): <p>The ID of the resource.</p>
    /// - On success, responds with [`RemoveAllResourcePermissionsOutput`](crate::output::RemoveAllResourcePermissionsOutput)

    /// - On failure, responds with [`SdkError<RemoveAllResourcePermissionsError>`](crate::error::RemoveAllResourcePermissionsError)
    pub fn remove_all_resource_permissions(
        &self,
    ) -> fluent_builders::RemoveAllResourcePermissions<C, M, R> {
        fluent_builders::RemoveAllResourcePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveResourcePermission`](crate::client::fluent_builders::RemoveResourcePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::RemoveResourcePermission::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::RemoveResourcePermission::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::RemoveResourcePermission::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::RemoveResourcePermission::set_resource_id): <p>The ID of the resource.</p>
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::RemoveResourcePermission::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::RemoveResourcePermission::set_principal_id): <p>The principal ID of the resource.</p>
    ///   - [`principal_type(PrincipalType)`](crate::client::fluent_builders::RemoveResourcePermission::principal_type) / [`set_principal_type(Option<PrincipalType>)`](crate::client::fluent_builders::RemoveResourcePermission::set_principal_type): <p>The principal type of the resource.</p>
    /// - On success, responds with [`RemoveResourcePermissionOutput`](crate::output::RemoveResourcePermissionOutput)

    /// - On failure, responds with [`SdkError<RemoveResourcePermissionError>`](crate::error::RemoveResourcePermissionError)
    pub fn remove_resource_permission(&self) -> fluent_builders::RemoveResourcePermission<C, M, R> {
        fluent_builders::RemoveResourcePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDocument`](crate::client::fluent_builders::UpdateDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::UpdateDocument::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::UpdateDocument::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDocument::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::UpdateDocument::set_document_id): <p>The ID of the document.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDocument::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDocument::set_name): <p>The name of the document.</p>
    ///   - [`parent_folder_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDocument::parent_folder_id) / [`set_parent_folder_id(Option<String>)`](crate::client::fluent_builders::UpdateDocument::set_parent_folder_id): <p>The ID of the parent folder.</p>
    ///   - [`resource_state(ResourceStateType)`](crate::client::fluent_builders::UpdateDocument::resource_state) / [`set_resource_state(Option<ResourceStateType>)`](crate::client::fluent_builders::UpdateDocument::set_resource_state): <p>The resource state of the document. Only ACTIVE and RECYCLED are supported.</p>
    /// - On success, responds with [`UpdateDocumentOutput`](crate::output::UpdateDocumentOutput)

    /// - On failure, responds with [`SdkError<UpdateDocumentError>`](crate::error::UpdateDocumentError)
    pub fn update_document(&self) -> fluent_builders::UpdateDocument<C, M, R> {
        fluent_builders::UpdateDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDocumentVersion`](crate::client::fluent_builders::UpdateDocumentVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentVersion::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::UpdateDocumentVersion::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentVersion::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::UpdateDocumentVersion::set_document_id): <p>The ID of the document.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentVersion::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::UpdateDocumentVersion::set_version_id): <p>The version ID of the document.</p>
    ///   - [`version_status(DocumentVersionStatus)`](crate::client::fluent_builders::UpdateDocumentVersion::version_status) / [`set_version_status(Option<DocumentVersionStatus>)`](crate::client::fluent_builders::UpdateDocumentVersion::set_version_status): <p>The status of the version.</p>
    /// - On success, responds with [`UpdateDocumentVersionOutput`](crate::output::UpdateDocumentVersionOutput)

    /// - On failure, responds with [`SdkError<UpdateDocumentVersionError>`](crate::error::UpdateDocumentVersionError)
    pub fn update_document_version(&self) -> fluent_builders::UpdateDocumentVersion<C, M, R> {
        fluent_builders::UpdateDocumentVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFolder`](crate::client::fluent_builders::UpdateFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::UpdateFolder::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::UpdateFolder::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFolder::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::UpdateFolder::set_folder_id): <p>The ID of the folder.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFolder::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFolder::set_name): <p>The name of the folder.</p>
    ///   - [`parent_folder_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFolder::parent_folder_id) / [`set_parent_folder_id(Option<String>)`](crate::client::fluent_builders::UpdateFolder::set_parent_folder_id): <p>The ID of the parent folder.</p>
    ///   - [`resource_state(ResourceStateType)`](crate::client::fluent_builders::UpdateFolder::resource_state) / [`set_resource_state(Option<ResourceStateType>)`](crate::client::fluent_builders::UpdateFolder::set_resource_state): <p>The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.</p>
    /// - On success, responds with [`UpdateFolderOutput`](crate::output::UpdateFolderOutput)

    /// - On failure, responds with [`SdkError<UpdateFolderError>`](crate::error::UpdateFolderError)
    pub fn update_folder(&self) -> fluent_builders::UpdateFolder<C, M, R> {
        fluent_builders::UpdateFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUser`](crate::client::fluent_builders::UpdateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_token(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::authentication_token) / [`set_authentication_token(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_authentication_token): <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_user_id): <p>The ID of the user.</p>
    ///   - [`given_name(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::given_name) / [`set_given_name(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_given_name): <p>The given name of the user.</p>
    ///   - [`surname(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::surname) / [`set_surname(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_surname): <p>The surname of the user.</p>
    ///   - [`r#type(UserType)`](crate::client::fluent_builders::UpdateUser::r#type) / [`set_type(Option<UserType>)`](crate::client::fluent_builders::UpdateUser::set_type): <p>The type of the user.</p>
    ///   - [`storage_rule(StorageRuleType)`](crate::client::fluent_builders::UpdateUser::storage_rule) / [`set_storage_rule(Option<StorageRuleType>)`](crate::client::fluent_builders::UpdateUser::set_storage_rule): <p>The amount of storage for the user.</p>
    ///   - [`time_zone_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::time_zone_id) / [`set_time_zone_id(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_time_zone_id): <p>The time zone ID of the user.</p>
    ///   - [`locale(LocaleType)`](crate::client::fluent_builders::UpdateUser::locale) / [`set_locale(Option<LocaleType>)`](crate::client::fluent_builders::UpdateUser::set_locale): <p>The locale of the user.</p>
    ///   - [`grant_poweruser_privileges(BooleanEnumType)`](crate::client::fluent_builders::UpdateUser::grant_poweruser_privileges) / [`set_grant_poweruser_privileges(Option<BooleanEnumType>)`](crate::client::fluent_builders::UpdateUser::set_grant_poweruser_privileges): <p>Boolean value to determine whether the user is granted Poweruser privileges.</p>
    /// - On success, responds with [`UpdateUserOutput`](crate::output::UpdateUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::UpdateUserOutput::user): <p>The user information.</p>
    /// - On failure, responds with [`SdkError<UpdateUserError>`](crate::error::UpdateUserError)
    pub fn update_user(&self) -> fluent_builders::UpdateUser<C, M, R> {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AbortDocumentVersionUpload`.
    ///
    /// <p>Aborts the upload of the specified document version that was previously initiated by <code>InitiateDocumentVersionUpload</code>. The client should make this call only when it no longer intends to upload the document version, or fails to do so.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AbortDocumentVersionUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::abort_document_version_upload_input::Builder,
    }
    impl<C, M, R> AbortDocumentVersionUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AbortDocumentVersionUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AbortDocumentVersionUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::AbortDocumentVersionUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AbortDocumentVersionUploadInputOperationOutputAlias,
                crate::output::AbortDocumentVersionUploadOutput,
                crate::error::AbortDocumentVersionUploadError,
                crate::input::AbortDocumentVersionUploadInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The ID of the version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The ID of the version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ActivateUser`.
    ///
    /// <p>Activates the specified user. Only active users can access Amazon WorkDocs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ActivateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::activate_user_input::Builder,
    }
    impl<C, M, R> ActivateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ActivateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ActivateUserInputOperationOutputAlias,
                crate::output::ActivateUserOutput,
                crate::error::ActivateUserError,
                crate::input::ActivateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddResourcePermissions`.
    ///
    /// <p>Creates a set of permissions for the specified folder or document. The resource permissions are overwritten if the principals already have different permissions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddResourcePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_resource_permissions_input::Builder,
    }
    impl<C, M, R> AddResourcePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddResourcePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddResourcePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddResourcePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddResourcePermissionsInputOperationOutputAlias,
                crate::output::AddResourcePermissionsOutput,
                crate::error::AddResourcePermissionsError,
                crate::input::AddResourcePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The users, groups, or organization being granted permission.</p>
        pub fn principals(mut self, input: crate::model::SharePrincipal) -> Self {
            self.inner = self.inner.principals(input);
            self
        }
        /// <p>The users, groups, or organization being granted permission.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SharePrincipal>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// <p>The notification options.</p>
        pub fn notification_options(mut self, input: crate::model::NotificationOptions) -> Self {
            self.inner = self.inner.notification_options(input);
            self
        }
        /// <p>The notification options.</p>
        pub fn set_notification_options(
            mut self,
            input: std::option::Option<crate::model::NotificationOptions>,
        ) -> Self {
            self.inner = self.inner.set_notification_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateComment`.
    ///
    /// <p>Adds a new comment to the specified document version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateComment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_comment_input::Builder,
    }
    impl<C, M, R> CreateComment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateComment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCommentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCommentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCommentInputOperationOutputAlias,
                crate::output::CreateCommentOutput,
                crate::error::CreateCommentError,
                crate::input::CreateCommentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>The ID of the parent comment.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_id(input.into());
            self
        }
        /// <p>The ID of the parent comment.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_id(input);
            self
        }
        /// <p>The ID of the root comment in the thread.</p>
        pub fn thread_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thread_id(input.into());
            self
        }
        /// <p>The ID of the root comment in the thread.</p>
        pub fn set_thread_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thread_id(input);
            self
        }
        /// <p>The text of the comment.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>The text of the comment.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners, and contributors.</p>
        pub fn visibility(mut self, input: crate::model::CommentVisibilityType) -> Self {
            self.inner = self.inner.visibility(input);
            self
        }
        /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners, and contributors.</p>
        pub fn set_visibility(
            mut self,
            input: std::option::Option<crate::model::CommentVisibilityType>,
        ) -> Self {
            self.inner = self.inner.set_visibility(input);
            self
        }
        /// <p>Set this parameter to TRUE to send an email out to the document collaborators after the comment is created.</p>
        pub fn notify_collaborators(mut self, input: bool) -> Self {
            self.inner = self.inner.notify_collaborators(input);
            self
        }
        /// <p>Set this parameter to TRUE to send an email out to the document collaborators after the comment is created.</p>
        pub fn set_notify_collaborators(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_notify_collaborators(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomMetadata`.
    ///
    /// <p>Adds one or more custom properties to the specified resource (a folder, document, or version).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_metadata_input::Builder,
    }
    impl<C, M, R> CreateCustomMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomMetadataInputOperationOutputAlias,
                crate::output::CreateCustomMetadataOutput,
                crate::error::CreateCustomMetadataError,
                crate::input::CreateCustomMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The ID of the version, if the custom metadata is being added to a document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The ID of the version, if the custom metadata is being added to a document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// Adds a key-value pair to `CustomMetadata`.
        ///
        /// To override the contents of this collection use [`set_custom_metadata`](Self::set_custom_metadata).
        ///
        /// <p>Custom metadata in the form of name-value pairs.</p>
        pub fn custom_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.custom_metadata(k.into(), v.into());
            self
        }
        /// <p>Custom metadata in the form of name-value pairs.</p>
        pub fn set_custom_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_custom_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFolder`.
    ///
    /// <p>Creates a folder with the specified name and parent folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_folder_input::Builder,
    }
    impl<C, M, R> CreateFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFolderInputOperationOutputAlias,
                crate::output::CreateFolderOutput,
                crate::error::CreateFolderError,
                crate::input::CreateFolderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The name of the new folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_folder_id(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLabels`.
    ///
    /// <p>Adds the specified list of labels to the given resource (a document or folder)</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLabels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_labels_input::Builder,
    }
    impl<C, M, R> CreateLabels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLabelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLabelsInputOperationOutputAlias,
                crate::output::CreateLabelsOutput,
                crate::error::CreateLabelsError,
                crate::input::CreateLabelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>List of labels to add to the resource.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(input.into());
            self
        }
        /// <p>List of labels to add to the resource.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNotificationSubscription`.
    ///
    /// <p>Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a confirmation message, and must confirm the subscription.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/subscribe-notifications.html">Subscribe to Notifications</a> in the <i>Amazon WorkDocs Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNotificationSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_notification_subscription_input::Builder,
    }
    impl<C, M, R> CreateNotificationSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNotificationSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNotificationSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNotificationSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNotificationSubscriptionInputOperationOutputAlias,
                crate::output::CreateNotificationSubscriptionOutput,
                crate::error::CreateNotificationSubscriptionError,
                crate::input::CreateNotificationSubscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins with <code>https</code>.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint(input.into());
            self
        }
        /// <p>The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins with <code>https</code>.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint(input);
            self
        }
        /// <p>The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.</p>
        pub fn protocol(mut self, input: crate::model::SubscriptionProtocolType) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::SubscriptionProtocolType>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>The notification type.</p>
        pub fn subscription_type(mut self, input: crate::model::SubscriptionType) -> Self {
            self.inner = self.inner.subscription_type(input);
            self
        }
        /// <p>The notification type.</p>
        pub fn set_subscription_type(
            mut self,
            input: std::option::Option<crate::model::SubscriptionType>,
        ) -> Self {
            self.inner = self.inner.set_subscription_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New users can access Amazon WorkDocs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The login name of the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The login name of the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The email address of the user.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The email address of the user.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The given name of the user.</p>
        pub fn given_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.given_name(input.into());
            self
        }
        /// <p>The given name of the user.</p>
        pub fn set_given_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_given_name(input);
            self
        }
        /// <p>The surname of the user.</p>
        pub fn surname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.surname(input.into());
            self
        }
        /// <p>The surname of the user.</p>
        pub fn set_surname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_surname(input);
            self
        }
        /// <p>The password of the user.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password of the user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn time_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.time_zone_id(input.into());
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn set_time_zone_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_time_zone_id(input);
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn storage_rule(mut self, input: crate::model::StorageRuleType) -> Self {
            self.inner = self.inner.storage_rule(input);
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn set_storage_rule(
            mut self,
            input: std::option::Option<crate::model::StorageRuleType>,
        ) -> Self {
            self.inner = self.inner.set_storage_rule(input);
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeactivateUser`.
    ///
    /// <p>Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeactivateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deactivate_user_input::Builder,
    }
    impl<C, M, R> DeactivateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeactivateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeactivateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeactivateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeactivateUserInputOperationOutputAlias,
                crate::output::DeactivateUserOutput,
                crate::error::DeactivateUserError,
                crate::input::DeactivateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteComment`.
    ///
    /// <p>Deletes the specified comment from the document version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteComment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_comment_input::Builder,
    }
    impl<C, M, R> DeleteComment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteComment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCommentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCommentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCommentInputOperationOutputAlias,
                crate::output::DeleteCommentOutput,
                crate::error::DeleteCommentError,
                crate::input::DeleteCommentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>The ID of the comment.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(input.into());
            self
        }
        /// <p>The ID of the comment.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomMetadata`.
    ///
    /// <p>Deletes custom metadata from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_metadata_input::Builder,
    }
    impl<C, M, R> DeleteCustomMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomMetadataInputOperationOutputAlias,
                crate::output::DeleteCustomMetadataOutput,
                crate::error::DeleteCustomMetadataError,
                crate::input::DeleteCustomMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the resource, either a document or folder.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource, either a document or folder.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The ID of the version, if the custom metadata is being deleted from a document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The ID of the version, if the custom metadata is being deleted from a document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// Appends an item to `Keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>List of properties to remove.</p>
        pub fn keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keys(input.into());
            self
        }
        /// <p>List of properties to remove.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keys(input);
            self
        }
        /// <p>Flag to indicate removal of all custom metadata properties from the specified resource.</p>
        pub fn delete_all(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_all(input);
            self
        }
        /// <p>Flag to indicate removal of all custom metadata properties from the specified resource.</p>
        pub fn set_delete_all(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_all(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDocument`.
    ///
    /// <p>Permanently deletes the specified document and its associated metadata.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_document_input::Builder,
    }
    impl<C, M, R> DeleteDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDocumentInputOperationOutputAlias,
                crate::output::DeleteDocumentOutput,
                crate::error::DeleteDocumentError,
                crate::input::DeleteDocumentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFolder`.
    ///
    /// <p>Permanently deletes the specified folder and its contents.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_folder_input::Builder,
    }
    impl<C, M, R> DeleteFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFolderInputOperationOutputAlias,
                crate::output::DeleteFolderOutput,
                crate::error::DeleteFolderError,
                crate::input::DeleteFolderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFolderContents`.
    ///
    /// <p>Deletes the contents of the specified folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFolderContents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_folder_contents_input::Builder,
    }
    impl<C, M, R> DeleteFolderContents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFolderContents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFolderContentsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFolderContentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFolderContentsInputOperationOutputAlias,
                crate::output::DeleteFolderContentsOutput,
                crate::error::DeleteFolderContentsError,
                crate::input::DeleteFolderContentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLabels`.
    ///
    /// <p>Deletes the specified list of labels from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLabels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_labels_input::Builder,
    }
    impl<C, M, R> DeleteLabels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLabelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLabelsInputOperationOutputAlias,
                crate::output::DeleteLabelsOutput,
                crate::error::DeleteLabelsError,
                crate::input::DeleteLabelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// Appends an item to `Labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>List of labels to delete from the resource.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(input.into());
            self
        }
        /// <p>List of labels to delete from the resource.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
        /// <p>Flag to request removal of all labels from the specified resource.</p>
        pub fn delete_all(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_all(input);
            self
        }
        /// <p>Flag to request removal of all labels from the specified resource.</p>
        pub fn set_delete_all(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_all(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNotificationSubscription`.
    ///
    /// <p>Deletes the specified subscription from the specified organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNotificationSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_notification_subscription_input::Builder,
    }
    impl<C, M, R> DeleteNotificationSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNotificationSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNotificationSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNotificationSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNotificationSubscriptionInputOperationOutputAlias,
                crate::output::DeleteNotificationSubscriptionOutput,
                crate::error::DeleteNotificationSubscriptionError,
                crate::input::DeleteNotificationSubscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the subscription.</p>
        pub fn subscription_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_id(input.into());
            self
        }
        /// <p>The ID of the subscription.</p>
        pub fn set_subscription_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_id(input);
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes the specified user from a Simple AD or Microsoft AD directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as in accessing the API using AWS credentials.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as in accessing the API using AWS credentials.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeActivities`.
    ///
    /// <p>Describes the user activities in a specified time period.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeActivities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_activities_input::Builder,
    }
    impl<C, M, R> DescribeActivities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeActivities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActivitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActivitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeActivitiesInputOperationOutputAlias,
                crate::output::DescribeActivitiesOutput,
                crate::error::DescribeActivitiesError,
                crate::input::DescribeActivitiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The timestamp that determines the starting time of the activities. The response includes the activities performed after the specified timestamp.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The timestamp that determines the starting time of the activities. The response includes the activities performed after the specified timestamp.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The timestamp that determines the end time of the activities. The response includes the activities performed before the specified timestamp.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The timestamp that determines the end time of the activities. The response includes the activities performed before the specified timestamp.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>Specifies which activity types to include in the response. If this field is left empty, all activity types are returned.</p>
        pub fn activity_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activity_types(input.into());
            self
        }
        /// <p>Specifies which activity types to include in the response. If this field is left empty, all activity types are returned.</p>
        pub fn set_activity_types(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_activity_types(input);
            self
        }
        /// <p>The document or folder ID for which to describe activity types.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The document or folder ID for which to describe activity types.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The ID of the user who performed the action. The response includes activities pertaining to this user. This is an optional parameter and is only applicable for administrative API (SigV4) requests.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the user who performed the action. The response includes activities pertaining to this user. This is an optional parameter and is only applicable for administrative API (SigV4) requests.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>Includes indirect activities. An indirect activity results from a direct activity performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of the subfolders and documents within the parent folder (the indirect activity).</p>
        pub fn include_indirect_activities(mut self, input: bool) -> Self {
            self.inner = self.inner.include_indirect_activities(input);
            self
        }
        /// <p>Includes indirect activities. An indirect activity results from a direct activity performed on a parent resource. For example, sharing a parent folder (the direct activity) shares all of the subfolders and documents within the parent folder (the indirect activity).</p>
        pub fn set_include_indirect_activities(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_indirect_activities(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeComments`.
    ///
    /// <p>List all the comments for the specified document version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeComments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_comments_input::Builder,
    }
    impl<C, M, R> DescribeComments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeComments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCommentsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCommentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCommentsInputOperationOutputAlias,
                crate::output::DescribeCommentsOutput,
                crate::error::DescribeCommentsError,
                crate::input::DescribeCommentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDocumentVersions`.
    ///
    /// <p>Retrieves the document versions for the specified document.</p>
    /// <p>By default, only active versions are returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDocumentVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_document_versions_input::Builder,
    }
    impl<C, M, R> DescribeDocumentVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDocumentVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDocumentVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDocumentVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDocumentVersionsInputOperationOutputAlias,
                crate::output::DescribeDocumentVersionsOutput,
                crate::error::DescribeDocumentVersionsError,
                crate::input::DescribeDocumentVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDocumentVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeDocumentVersionsPaginator<C, M, R> {
            crate::paginator::DescribeDocumentVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of versions to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of versions to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.</p>
        pub fn include(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.include(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.</p>
        pub fn set_include(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
        /// <p>Specify "SOURCE" to include initialized versions and a URL for the source document.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fields(input.into());
            self
        }
        /// <p>Specify "SOURCE" to include initialized versions and a URL for the source document.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFolderContents`.
    ///
    /// <p>Describes the contents of the specified folder, including its documents and subfolders.</p>
    /// <p>By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more results, the response includes a marker that you can use to request the next set of results. You can also request initialized documents.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFolderContents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_folder_contents_input::Builder,
    }
    impl<C, M, R> DescribeFolderContents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFolderContents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFolderContentsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFolderContentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFolderContentsInputOperationOutputAlias,
                crate::output::DescribeFolderContentsOutput,
                crate::error::DescribeFolderContentsError,
                crate::input::DescribeFolderContentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeFolderContentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeFolderContentsPaginator<C, M, R> {
            crate::paginator::DescribeFolderContentsPaginator::new(self.handle, self.inner)
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn sort(mut self, input: crate::model::ResourceSortType) -> Self {
            self.inner = self.inner.sort(input);
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn set_sort(
            mut self,
            input: std::option::Option<crate::model::ResourceSortType>,
        ) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// <p>The order for the contents of the folder.</p>
        pub fn order(mut self, input: crate::model::OrderType) -> Self {
            self.inner = self.inner.order(input);
            self
        }
        /// <p>The order for the contents of the folder.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::OrderType>) -> Self {
            self.inner = self.inner.set_order(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The type of items.</p>
        pub fn r#type(mut self, input: crate::model::FolderContentType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of items.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::FolderContentType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The contents to include. Specify "INITIALIZED" to include initialized documents.</p>
        pub fn include(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.include(input.into());
            self
        }
        /// <p>The contents to include. Specify "INITIALIZED" to include initialized documents.</p>
        pub fn set_include(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGroups`.
    ///
    /// <p>Describes the groups specified by the query. Groups are defined by the underlying Active Directory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_groups_input::Builder,
    }
    impl<C, M, R> DescribeGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGroupsInputOperationOutputAlias,
                crate::output::DescribeGroupsOutput,
                crate::error::DescribeGroupsError,
                crate::input::DescribeGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>A query to describe groups by group name.</p>
        pub fn search_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.search_query(input.into());
            self
        }
        /// <p>A query to describe groups by group name.</p>
        pub fn set_search_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_search_query(input);
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNotificationSubscriptions`.
    ///
    /// <p>Lists the specified notification subscriptions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNotificationSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_notification_subscriptions_input::Builder,
    }
    impl<C, M, R> DescribeNotificationSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNotificationSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNotificationSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNotificationSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNotificationSubscriptionsInputOperationOutputAlias,
                crate::output::DescribeNotificationSubscriptionsOutput,
                crate::error::DescribeNotificationSubscriptionsError,
                crate::input::DescribeNotificationSubscriptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourcePermissions`.
    ///
    /// <p>Describes the permissions of a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResourcePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resource_permissions_input::Builder,
    }
    impl<C, M, R> DescribeResourcePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResourcePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourcePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourcePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResourcePermissionsInputOperationOutputAlias,
                crate::output::DescribeResourcePermissionsOutput,
                crate::error::DescribeResourcePermissionsError,
                crate::input::DescribeResourcePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The ID of the principal to filter permissions by.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>The ID of the principal to filter permissions by.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRootFolders`.
    ///
    /// <p>Describes the current user's special folders; the <code>RootFolder</code> and the <code>RecycleBin</code>. <code>RootFolder</code> is the root of user's files and folders and <code>RecycleBin</code> is the root of recycled items. This is not a valid action for SigV4 (administrative API) clients.</p>
    /// <p>This action requires an authentication token. To get an authentication token, register an application with Amazon WorkDocs. For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRootFolders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_root_folders_input::Builder,
    }
    impl<C, M, R> DescribeRootFolders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRootFolders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRootFoldersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRootFoldersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRootFoldersInputOperationOutputAlias,
                crate::output::DescribeRootFoldersOutput,
                crate::error::DescribeRootFoldersError,
                crate::input::DescribeRootFoldersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUsers`.
    ///
    /// <p>Describes the specified users. You can describe all users or filter the results (for example, by status or organization).</p>
    /// <p>By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response includes a marker that you can use to request the next set of results.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_users_input::Builder,
    }
    impl<C, M, R> DescribeUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUsersInputOperationOutputAlias,
                crate::output::DescribeUsersOutput,
                crate::error::DescribeUsersError,
                crate::input::DescribeUsersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeUsersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeUsersPaginator<C, M, R> {
            crate::paginator::DescribeUsersPaginator::new(self.handle, self.inner)
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>The IDs of the users.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_ids(input.into());
            self
        }
        /// <p>The IDs of the users.</p>
        pub fn set_user_ids(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_ids(input);
            self
        }
        /// <p>A query to filter users by user name.</p>
        pub fn query(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query(input.into());
            self
        }
        /// <p>A query to filter users by user name.</p>
        pub fn set_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query(input);
            self
        }
        /// <p>The state of the users. Specify "ALL" to include inactive users.</p>
        pub fn include(mut self, input: crate::model::UserFilterType) -> Self {
            self.inner = self.inner.include(input);
            self
        }
        /// <p>The state of the users. Specify "ALL" to include inactive users.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<crate::model::UserFilterType>,
        ) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
        /// <p>The order for the results.</p>
        pub fn order(mut self, input: crate::model::OrderType) -> Self {
            self.inner = self.inner.order(input);
            self
        }
        /// <p>The order for the results.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::OrderType>) -> Self {
            self.inner = self.inner.set_order(input);
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn sort(mut self, input: crate::model::UserSortType) -> Self {
            self.inner = self.inner.sort(input);
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::UserSortType>) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>A comma-separated list of values. Specify "STORAGE_METADATA" to include the user storage quota and utilization information.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fields(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "STORAGE_METADATA" to include the user storage quota and utilization information.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCurrentUser`.
    ///
    /// <p>Retrieves details of the current user for whom the authentication token was generated. This is not a valid action for SigV4 (administrative API) clients.</p>
    /// <p>This action requires an authentication token. To get an authentication token, register an application with Amazon WorkDocs. For more information, see <a href="https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html">Authentication and Access Control for User Applications</a> in the <i>Amazon WorkDocs Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCurrentUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_current_user_input::Builder,
    }
    impl<C, M, R> GetCurrentUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCurrentUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCurrentUserOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCurrentUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCurrentUserInputOperationOutputAlias,
                crate::output::GetCurrentUserOutput,
                crate::error::GetCurrentUserError,
                crate::input::GetCurrentUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocument`.
    ///
    /// <p>Retrieves details of a document.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_document_input::Builder,
    }
    impl<C, M, R> GetDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentInputOperationOutputAlias,
                crate::output::GetDocumentOutput,
                crate::error::GetDocumentError,
                crate::input::GetDocumentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>Set this to <code>TRUE</code> to include custom metadata in the response.</p>
        pub fn include_custom_metadata(mut self, input: bool) -> Self {
            self.inner = self.inner.include_custom_metadata(input);
            self
        }
        /// <p>Set this to <code>TRUE</code> to include custom metadata in the response.</p>
        pub fn set_include_custom_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_custom_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentPath`.
    ///
    /// <p>Retrieves the path information (the hierarchy from the root folder) for the requested document.</p>
    /// <p>By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested document and only includes the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the names of the parent folders.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDocumentPath<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_document_path_input::Builder,
    }
    impl<C, M, R> GetDocumentPath<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentPath`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentPathOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentPathError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentPathInputOperationOutputAlias,
                crate::output::GetDocumentPathOutput,
                crate::error::GetDocumentPathError,
                crate::input::GetDocumentPathInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>A comma-separated list of values. Specify <code>NAME</code> to include the names of the parent folders.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fields(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify <code>NAME</code> to include the names of the parent folders.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
        /// <p>This value is not supported.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>This value is not supported.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentVersion`.
    ///
    /// <p>Retrieves version metadata for the specified document.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDocumentVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_document_version_input::Builder,
    }
    impl<C, M, R> GetDocumentVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocumentVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentVersionInputOperationOutputAlias,
                crate::output::GetDocumentVersionOutput,
                crate::error::GetDocumentVersionError,
                crate::input::GetDocumentVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fields(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
        /// <p>Set this to TRUE to include custom metadata in the response.</p>
        pub fn include_custom_metadata(mut self, input: bool) -> Self {
            self.inner = self.inner.include_custom_metadata(input);
            self
        }
        /// <p>Set this to TRUE to include custom metadata in the response.</p>
        pub fn set_include_custom_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_custom_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFolder`.
    ///
    /// <p>Retrieves the metadata of the specified folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_folder_input::Builder,
    }
    impl<C, M, R> GetFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFolderInputOperationOutputAlias,
                crate::output::GetFolderOutput,
                crate::error::GetFolderError,
                crate::input::GetFolderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>Set to TRUE to include custom metadata in the response.</p>
        pub fn include_custom_metadata(mut self, input: bool) -> Self {
            self.inner = self.inner.include_custom_metadata(input);
            self
        }
        /// <p>Set to TRUE to include custom metadata in the response.</p>
        pub fn set_include_custom_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_custom_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFolderPath`.
    ///
    /// <p>Retrieves the path information (the hierarchy from the root folder) for the specified folder.</p>
    /// <p>By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested folder and only includes the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the parent folder names.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFolderPath<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_folder_path_input::Builder,
    }
    impl<C, M, R> GetFolderPath<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFolderPath`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFolderPathOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFolderPathError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFolderPathInputOperationOutputAlias,
                crate::output::GetFolderPathOutput,
                crate::error::GetFolderPathError,
                crate::input::GetFolderPathInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>A comma-separated list of values. Specify "NAME" to include the names of the parent folders.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fields(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "NAME" to include the names of the parent folders.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
        /// <p>This value is not supported.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>This value is not supported.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResources`.
    ///
    /// <p>Retrieves a collection of resources, including folders and documents. The only <code>CollectionType</code> supported is <code>SHARED_WITH_ME</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resources_input::Builder,
    }
    impl<C, M, R> GetResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcesInputOperationOutputAlias,
                crate::output::GetResourcesOutput,
                crate::error::GetResourcesError,
                crate::input::GetResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The user ID for the resource collection. This is a required field for accessing the API operation using IAM credentials.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The user ID for the resource collection. This is a required field for accessing the API operation using IAM credentials.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The collection type.</p>
        pub fn collection_type(mut self, input: crate::model::ResourceCollectionType) -> Self {
            self.inner = self.inner.collection_type(input);
            self
        }
        /// <p>The collection type.</p>
        pub fn set_collection_type(
            mut self,
            input: std::option::Option<crate::model::ResourceCollectionType>,
        ) -> Self {
            self.inner = self.inner.set_collection_type(input);
            self
        }
        /// <p>The maximum number of resources to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of resources to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitiateDocumentVersionUpload`.
    ///
    /// <p>Creates a new document object and version object.</p>
    /// <p>The client specifies the parent folder ID and name of the document to upload. The ID is optionally specified when creating a new version of an existing document. This is the first step to upload a document. Next, upload the document to the URL returned from the call, and then call <code>UpdateDocumentVersion</code>.</p>
    /// <p>To cancel the document upload, call <code>AbortDocumentVersionUpload</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InitiateDocumentVersionUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::initiate_document_version_upload_input::Builder,
    }
    impl<C, M, R> InitiateDocumentVersionUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InitiateDocumentVersionUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitiateDocumentVersionUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::InitiateDocumentVersionUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InitiateDocumentVersionUploadInputOperationOutputAlias,
                crate::output::InitiateDocumentVersionUploadOutput,
                crate::error::InitiateDocumentVersionUploadError,
                crate::input::InitiateDocumentVersionUploadInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The timestamp when the content of the document was originally created.</p>
        pub fn content_created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.content_created_timestamp(input);
            self
        }
        /// <p>The timestamp when the content of the document was originally created.</p>
        pub fn set_content_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_content_created_timestamp(input);
            self
        }
        /// <p>The timestamp when the content of the document was modified.</p>
        pub fn content_modified_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.content_modified_timestamp(input);
            self
        }
        /// <p>The timestamp when the content of the document was modified.</p>
        pub fn set_content_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_content_modified_timestamp(input);
            self
        }
        /// <p>The content type of the document.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>The content type of the document.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>The size of the document, in bytes.</p>
        pub fn document_size_in_bytes(mut self, input: i64) -> Self {
            self.inner = self.inner.document_size_in_bytes(input);
            self
        }
        /// <p>The size of the document, in bytes.</p>
        pub fn set_document_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_document_size_in_bytes(input);
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_folder_id(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveAllResourcePermissions`.
    ///
    /// <p>Removes all the permissions from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveAllResourcePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_all_resource_permissions_input::Builder,
    }
    impl<C, M, R> RemoveAllResourcePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveAllResourcePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveAllResourcePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveAllResourcePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveAllResourcePermissionsInputOperationOutputAlias,
                crate::output::RemoveAllResourcePermissionsOutput,
                crate::error::RemoveAllResourcePermissionsError,
                crate::input::RemoveAllResourcePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveResourcePermission`.
    ///
    /// <p>Removes the permission for the specified principal from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveResourcePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_resource_permission_input::Builder,
    }
    impl<C, M, R> RemoveResourcePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveResourcePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveResourcePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveResourcePermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveResourcePermissionInputOperationOutputAlias,
                crate::output::RemoveResourcePermissionOutput,
                crate::error::RemoveResourcePermissionError,
                crate::input::RemoveResourcePermissionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The principal ID of the resource.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>The principal ID of the resource.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The principal type of the resource.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.inner = self.inner.principal_type(input);
            self
        }
        /// <p>The principal type of the resource.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.inner = self.inner.set_principal_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDocument`.
    ///
    /// <p>Updates the specified attributes of a document. The user must have access to both the document and its parent folder, if applicable.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_document_input::Builder,
    }
    impl<C, M, R> UpdateDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDocumentInputOperationOutputAlias,
                crate::output::UpdateDocumentOutput,
                crate::error::UpdateDocumentError,
                crate::input::UpdateDocumentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The name of the document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_folder_id(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_folder_id(input);
            self
        }
        /// <p>The resource state of the document. Only ACTIVE and RECYCLED are supported.</p>
        pub fn resource_state(mut self, input: crate::model::ResourceStateType) -> Self {
            self.inner = self.inner.resource_state(input);
            self
        }
        /// <p>The resource state of the document. Only ACTIVE and RECYCLED are supported.</p>
        pub fn set_resource_state(
            mut self,
            input: std::option::Option<crate::model::ResourceStateType>,
        ) -> Self {
            self.inner = self.inner.set_resource_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDocumentVersion`.
    ///
    /// <p>Changes the status of the document version to ACTIVE. </p>
    /// <p>Amazon WorkDocs also sets its document container to ACTIVE. This is the last step in a document upload, after the client uploads the document to an S3-presigned URL returned by <code>InitiateDocumentVersionUpload</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDocumentVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_document_version_input::Builder,
    }
    impl<C, M, R> UpdateDocumentVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDocumentVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDocumentVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDocumentVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDocumentVersionInputOperationOutputAlias,
                crate::output::UpdateDocumentVersionOutput,
                crate::error::UpdateDocumentVersionError,
                crate::input::UpdateDocumentVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>The status of the version.</p>
        pub fn version_status(mut self, input: crate::model::DocumentVersionStatus) -> Self {
            self.inner = self.inner.version_status(input);
            self
        }
        /// <p>The status of the version.</p>
        pub fn set_version_status(
            mut self,
            input: std::option::Option<crate::model::DocumentVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_version_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFolder`.
    ///
    /// <p>Updates the specified attributes of the specified folder. The user must have access to both the folder and its parent folder, if applicable.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_folder_input::Builder,
    }
    impl<C, M, R> UpdateFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFolderInputOperationOutputAlias,
                crate::output::UpdateFolderOutput,
                crate::error::UpdateFolderError,
                crate::input::UpdateFolderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The name of the folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_folder_id(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_folder_id(input);
            self
        }
        /// <p>The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.</p>
        pub fn resource_state(mut self, input: crate::model::ResourceStateType) -> Self {
            self.inner = self.inner.resource_state(input);
            self
        }
        /// <p>The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.</p>
        pub fn set_resource_state(
            mut self,
            input: std::option::Option<crate::model::ResourceStateType>,
        ) -> Self {
            self.inner = self.inner.set_resource_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUser`.
    ///
    /// <p>Updates the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_input::Builder,
    }
    impl<C, M, R> UpdateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserInputOperationOutputAlias,
                crate::output::UpdateUserOutput,
                crate::error::UpdateUserError,
                crate::input::UpdateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_token(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_token(input);
            self
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The given name of the user.</p>
        pub fn given_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.given_name(input.into());
            self
        }
        /// <p>The given name of the user.</p>
        pub fn set_given_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_given_name(input);
            self
        }
        /// <p>The surname of the user.</p>
        pub fn surname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.surname(input.into());
            self
        }
        /// <p>The surname of the user.</p>
        pub fn set_surname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_surname(input);
            self
        }
        /// <p>The type of the user.</p>
        pub fn r#type(mut self, input: crate::model::UserType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of the user.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn storage_rule(mut self, input: crate::model::StorageRuleType) -> Self {
            self.inner = self.inner.storage_rule(input);
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn set_storage_rule(
            mut self,
            input: std::option::Option<crate::model::StorageRuleType>,
        ) -> Self {
            self.inner = self.inner.set_storage_rule(input);
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn time_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.time_zone_id(input.into());
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn set_time_zone_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_time_zone_id(input);
            self
        }
        /// <p>The locale of the user.</p>
        pub fn locale(mut self, input: crate::model::LocaleType) -> Self {
            self.inner = self.inner.locale(input);
            self
        }
        /// <p>The locale of the user.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::LocaleType>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>Boolean value to determine whether the user is granted Poweruser privileges.</p>
        pub fn grant_poweruser_privileges(mut self, input: crate::model::BooleanEnumType) -> Self {
            self.inner = self.inner.grant_poweruser_privileges(input);
            self
        }
        /// <p>Boolean value to determine whether the user is granted Poweruser privileges.</p>
        pub fn set_grant_poweruser_privileges(
            mut self,
            input: std::option::Option<crate::model::BooleanEnumType>,
        ) -> Self {
            self.inner = self.inner.set_grant_poweruser_privileges(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
