// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The resource hierarchy is changing.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Another operation is in progress on the resource that conflicts with the current operation.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>The limit has been reached on the number of custom properties for the specified resource.</p>
    CustomMetadataLimitExceededException(crate::error::CustomMetadataLimitExceededException),
    /// <p>The last user in the organization is being deactivated.</p>
    DeactivatingLastSystemUserException(crate::error::DeactivatingLastSystemUserException),
    /// <p>This exception is thrown when the document is locked for comments and user tries to create or delete a comment on that document.</p>
    DocumentLockedForCommentsException(crate::error::DocumentLockedForCommentsException),
    /// <p>This exception is thrown when a valid checkout ID is not presented on document version upload calls for a document that has been checked out from Web client.</p>
    DraftUploadOutOfSyncException(crate::error::DraftUploadOutOfSyncException),
    /// <p>The resource already exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The resource does not exist.</p>
    EntityNotExistsException(crate::error::EntityNotExistsException),
    /// <p>The AWS Directory Service cannot reach an on-premises instance. Or a dependency under the control of the organization is failing, such as a connected Active Directory.</p>
    FailedDependencyException(crate::error::FailedDependencyException),
    /// <p>The user is undergoing transfer of ownership.</p>
    IllegalUserStateException(crate::error::IllegalUserStateException),
    /// <p>The pagination marker or limit fields are not valid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The requested operation is not allowed on the specified comment object.</p>
    InvalidCommentOperationException(crate::error::InvalidCommentOperationException),
    /// <p>The operation is invalid.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The password is invalid.</p>
    InvalidPasswordException(crate::error::InvalidPasswordException),
    /// <p>The maximum of 100,000 folders under the parent folder has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified document version is not in the INITIALIZED state.</p>
    ProhibitedStateException(crate::error::ProhibitedStateException),
    /// <p>The response is too large to return. The request must include a filter to reduce the size of the response.</p>
    RequestedEntityTooLargeException(crate::error::RequestedEntityTooLargeException),
    /// <p>The resource is already checked out.</p>
    ResourceAlreadyCheckedOutException(crate::error::ResourceAlreadyCheckedOutException),
    /// <p>One or more of the dependencies is unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The storage limit has been exceeded.</p>
    StorageLimitExceededException(crate::error::StorageLimitExceededException),
    /// <p>The storage limit will be exceeded.</p>
    StorageLimitWillExceedException(crate::error::StorageLimitWillExceedException),
    /// <p>The limit has been reached on the number of labels for the specified resource.</p>
    TooManyLabelsException(crate::error::TooManyLabelsException),
    /// <p>You've reached the limit on the number of subscriptions for the WorkDocs instance.</p>
    TooManySubscriptionsException(crate::error::TooManySubscriptionsException),
    /// <p>The operation is not permitted.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// <p>The caller does not have access to perform the action on the resource.</p>
    UnauthorizedResourceAccessException(crate::error::UnauthorizedResourceAccessException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ConcurrentModificationException(inner) => inner.fmt(f),
            Error::ConflictingOperationException(inner) => inner.fmt(f),
            Error::CustomMetadataLimitExceededException(inner) => inner.fmt(f),
            Error::DeactivatingLastSystemUserException(inner) => inner.fmt(f),
            Error::DocumentLockedForCommentsException(inner) => inner.fmt(f),
            Error::DraftUploadOutOfSyncException(inner) => inner.fmt(f),
            Error::EntityAlreadyExistsException(inner) => inner.fmt(f),
            Error::EntityNotExistsException(inner) => inner.fmt(f),
            Error::FailedDependencyException(inner) => inner.fmt(f),
            Error::IllegalUserStateException(inner) => inner.fmt(f),
            Error::InvalidArgumentException(inner) => inner.fmt(f),
            Error::InvalidCommentOperationException(inner) => inner.fmt(f),
            Error::InvalidOperationException(inner) => inner.fmt(f),
            Error::InvalidPasswordException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::ProhibitedStateException(inner) => inner.fmt(f),
            Error::RequestedEntityTooLargeException(inner) => inner.fmt(f),
            Error::ResourceAlreadyCheckedOutException(inner) => inner.fmt(f),
            Error::ServiceUnavailableException(inner) => inner.fmt(f),
            Error::StorageLimitExceededException(inner) => inner.fmt(f),
            Error::StorageLimitWillExceedException(inner) => inner.fmt(f),
            Error::TooManyLabelsException(inner) => inner.fmt(f),
            Error::TooManySubscriptionsException(inner) => inner.fmt(f),
            Error::UnauthorizedOperationException(inner) => inner.fmt(f),
            Error::UnauthorizedResourceAccessException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AbortDocumentVersionUploadError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AbortDocumentVersionUploadError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AbortDocumentVersionUploadErrorKind::EntityNotExistsException(inner) => Error::EntityNotExistsException(inner),
                crate::error::AbortDocumentVersionUploadErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::AbortDocumentVersionUploadErrorKind::ProhibitedStateException(inner) => Error::ProhibitedStateException(inner),
                crate::error::AbortDocumentVersionUploadErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::AbortDocumentVersionUploadErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::AbortDocumentVersionUploadErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::AbortDocumentVersionUploadErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ActivateUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ActivateUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ActivateUserErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::ActivateUserErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::ActivateUserErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ActivateUserErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::ActivateUserErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::ActivateUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddResourcePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddResourcePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AddResourcePermissionsErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::AddResourcePermissionsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::AddResourcePermissionsErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::AddResourcePermissionsErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::AddResourcePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCommentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateCommentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateCommentErrorKind::DocumentLockedForCommentsException(inner) => {
                    Error::DocumentLockedForCommentsException(inner)
                }
                crate::error::CreateCommentErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::CreateCommentErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::CreateCommentErrorKind::InvalidCommentOperationException(inner) => {
                    Error::InvalidCommentOperationException(inner)
                }
                crate::error::CreateCommentErrorKind::ProhibitedStateException(inner) => {
                    Error::ProhibitedStateException(inner)
                }
                crate::error::CreateCommentErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::CreateCommentErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::CreateCommentErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::CreateCommentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCustomMetadataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCustomMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCustomMetadataErrorKind::CustomMetadataLimitExceededException(inner) => Error::CustomMetadataLimitExceededException(inner),
                crate::error::CreateCustomMetadataErrorKind::EntityNotExistsException(inner) => Error::EntityNotExistsException(inner),
                crate::error::CreateCustomMetadataErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::CreateCustomMetadataErrorKind::ProhibitedStateException(inner) => Error::ProhibitedStateException(inner),
                crate::error::CreateCustomMetadataErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::CreateCustomMetadataErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::CreateCustomMetadataErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::CreateCustomMetadataErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateFolderError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateFolderError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateFolderErrorKind::ConflictingOperationException(inner) => {
                    Error::ConflictingOperationException(inner)
                }
                crate::error::CreateFolderErrorKind::EntityAlreadyExistsException(inner) => {
                    Error::EntityAlreadyExistsException(inner)
                }
                crate::error::CreateFolderErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::CreateFolderErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::CreateFolderErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateFolderErrorKind::ProhibitedStateException(inner) => {
                    Error::ProhibitedStateException(inner)
                }
                crate::error::CreateFolderErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::CreateFolderErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::CreateFolderErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::CreateFolderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateLabelsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateLabelsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateLabelsErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::CreateLabelsErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::CreateLabelsErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::CreateLabelsErrorKind::TooManyLabelsException(inner) => {
                    Error::TooManyLabelsException(inner)
                }
                crate::error::CreateLabelsErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::CreateLabelsErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::CreateLabelsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateNotificationSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateNotificationSubscriptionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateNotificationSubscriptionErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::CreateNotificationSubscriptionErrorKind::TooManySubscriptionsException(inner) => Error::TooManySubscriptionsException(inner),
                crate::error::CreateNotificationSubscriptionErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::CreateNotificationSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateUserErrorKind::EntityAlreadyExistsException(inner) => {
                    Error::EntityAlreadyExistsException(inner)
                }
                crate::error::CreateUserErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::CreateUserErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::CreateUserErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::CreateUserErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::CreateUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeactivateUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeactivateUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeactivateUserErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::DeactivateUserErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DeactivateUserErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeactivateUserErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::DeactivateUserErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DeactivateUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCommentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteCommentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCommentErrorKind::DocumentLockedForCommentsException(inner) => {
                    Error::DocumentLockedForCommentsException(inner)
                }
                crate::error::DeleteCommentErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::DeleteCommentErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DeleteCommentErrorKind::ProhibitedStateException(inner) => {
                    Error::ProhibitedStateException(inner)
                }
                crate::error::DeleteCommentErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteCommentErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::DeleteCommentErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DeleteCommentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCustomMetadataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCustomMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCustomMetadataErrorKind::EntityNotExistsException(inner) => Error::EntityNotExistsException(inner),
                crate::error::DeleteCustomMetadataErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::DeleteCustomMetadataErrorKind::ProhibitedStateException(inner) => Error::ProhibitedStateException(inner),
                crate::error::DeleteCustomMetadataErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DeleteCustomMetadataErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::DeleteCustomMetadataErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DeleteCustomMetadataErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDocumentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDocumentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDocumentErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeleteDocumentErrorKind::ConflictingOperationException(inner) => {
                    Error::ConflictingOperationException(inner)
                }
                crate::error::DeleteDocumentErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::DeleteDocumentErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DeleteDocumentErrorKind::ProhibitedStateException(inner) => {
                    Error::ProhibitedStateException(inner)
                }
                crate::error::DeleteDocumentErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteDocumentErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::DeleteDocumentErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DeleteDocumentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFolderError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteFolderError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFolderErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeleteFolderErrorKind::ConflictingOperationException(inner) => {
                    Error::ConflictingOperationException(inner)
                }
                crate::error::DeleteFolderErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::DeleteFolderErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DeleteFolderErrorKind::ProhibitedStateException(inner) => {
                    Error::ProhibitedStateException(inner)
                }
                crate::error::DeleteFolderErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteFolderErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::DeleteFolderErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::DeleteFolderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFolderContentsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteFolderContentsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteFolderContentsErrorKind::ConflictingOperationException(inner) => Error::ConflictingOperationException(inner),
                crate::error::DeleteFolderContentsErrorKind::EntityNotExistsException(inner) => Error::EntityNotExistsException(inner),
                crate::error::DeleteFolderContentsErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::DeleteFolderContentsErrorKind::ProhibitedStateException(inner) => Error::ProhibitedStateException(inner),
                crate::error::DeleteFolderContentsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DeleteFolderContentsErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::DeleteFolderContentsErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DeleteFolderContentsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLabelsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteLabelsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteLabelsErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::DeleteLabelsErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DeleteLabelsErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteLabelsErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::DeleteLabelsErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::DeleteLabelsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteNotificationSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteNotificationSubscriptionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteNotificationSubscriptionErrorKind::EntityNotExistsException(inner) => Error::EntityNotExistsException(inner),
                crate::error::DeleteNotificationSubscriptionErrorKind::ProhibitedStateException(inner) => Error::ProhibitedStateException(inner),
                crate::error::DeleteNotificationSubscriptionErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DeleteNotificationSubscriptionErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DeleteNotificationSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteUserErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::DeleteUserErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DeleteUserErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteUserErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::DeleteUserErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::DeleteUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeActivitiesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeActivitiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeActivitiesErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DescribeActivitiesErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::DescribeActivitiesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DescribeActivitiesErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::DescribeActivitiesErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DescribeActivitiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCommentsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCommentsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCommentsErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::DescribeCommentsErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DescribeCommentsErrorKind::ProhibitedStateException(inner) => {
                    Error::ProhibitedStateException(inner)
                }
                crate::error::DescribeCommentsErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DescribeCommentsErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::DescribeCommentsErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DescribeCommentsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDocumentVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDocumentVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDocumentVersionsErrorKind::EntityNotExistsException(inner) => Error::EntityNotExistsException(inner),
                crate::error::DescribeDocumentVersionsErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::DescribeDocumentVersionsErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::DescribeDocumentVersionsErrorKind::ProhibitedStateException(inner) => Error::ProhibitedStateException(inner),
                crate::error::DescribeDocumentVersionsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DescribeDocumentVersionsErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::DescribeDocumentVersionsErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DescribeDocumentVersionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeFolderContentsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeFolderContentsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeFolderContentsErrorKind::EntityNotExistsException(inner) => Error::EntityNotExistsException(inner),
                crate::error::DescribeFolderContentsErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::DescribeFolderContentsErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::DescribeFolderContentsErrorKind::ProhibitedStateException(inner) => Error::ProhibitedStateException(inner),
                crate::error::DescribeFolderContentsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DescribeFolderContentsErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DescribeFolderContentsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeGroupsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeGroupsErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DescribeGroupsErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DescribeGroupsErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::DescribeGroupsErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DescribeGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeNotificationSubscriptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeNotificationSubscriptionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeNotificationSubscriptionsErrorKind::EntityNotExistsException(inner) => Error::EntityNotExistsException(inner),
                crate::error::DescribeNotificationSubscriptionsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DescribeNotificationSubscriptionsErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DescribeNotificationSubscriptionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeResourcePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeResourcePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeResourcePermissionsErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::DescribeResourcePermissionsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DescribeResourcePermissionsErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::DescribeResourcePermissionsErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DescribeResourcePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeRootFoldersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeRootFoldersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeRootFoldersErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DescribeRootFoldersErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::DescribeRootFoldersErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DescribeRootFoldersErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::DescribeRootFoldersErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DescribeRootFoldersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeUsersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeUsersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeUsersErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::DescribeUsersErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::DescribeUsersErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::DescribeUsersErrorKind::RequestedEntityTooLargeException(inner) => {
                    Error::RequestedEntityTooLargeException(inner)
                }
                crate::error::DescribeUsersErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DescribeUsersErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::DescribeUsersErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::DescribeUsersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCurrentUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetCurrentUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCurrentUserErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::GetCurrentUserErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::GetCurrentUserErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetCurrentUserErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GetCurrentUserErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::GetCurrentUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDocumentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDocumentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDocumentErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::GetDocumentErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::GetDocumentErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::GetDocumentErrorKind::InvalidPasswordException(inner) => {
                    Error::InvalidPasswordException(inner)
                }
                crate::error::GetDocumentErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetDocumentErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GetDocumentErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::GetDocumentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDocumentPathError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDocumentPathError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDocumentPathErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::GetDocumentPathErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::GetDocumentPathErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetDocumentPathErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GetDocumentPathErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::GetDocumentPathErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDocumentVersionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDocumentVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDocumentVersionErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::GetDocumentVersionErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::GetDocumentVersionErrorKind::InvalidPasswordException(inner) => {
                    Error::InvalidPasswordException(inner)
                }
                crate::error::GetDocumentVersionErrorKind::ProhibitedStateException(inner) => {
                    Error::ProhibitedStateException(inner)
                }
                crate::error::GetDocumentVersionErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetDocumentVersionErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::GetDocumentVersionErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::GetDocumentVersionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFolderError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetFolderError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetFolderErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::GetFolderErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::GetFolderErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::GetFolderErrorKind::ProhibitedStateException(inner) => {
                    Error::ProhibitedStateException(inner)
                }
                crate::error::GetFolderErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetFolderErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GetFolderErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::GetFolderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFolderPathError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetFolderPathError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetFolderPathErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::GetFolderPathErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::GetFolderPathErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetFolderPathErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GetFolderPathErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::GetFolderPathErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResourcesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetResourcesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResourcesErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::GetResourcesErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::GetResourcesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetResourcesErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GetResourcesErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::GetResourcesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::InitiateDocumentVersionUploadError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::InitiateDocumentVersionUploadError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::InitiateDocumentVersionUploadErrorKind::DraftUploadOutOfSyncException(inner) => Error::DraftUploadOutOfSyncException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::EntityAlreadyExistsException(inner) => Error::EntityAlreadyExistsException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::EntityNotExistsException(inner) => Error::EntityNotExistsException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::ProhibitedStateException(inner) => Error::ProhibitedStateException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::ResourceAlreadyCheckedOutException(inner) => Error::ResourceAlreadyCheckedOutException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::StorageLimitExceededException(inner) => Error::StorageLimitExceededException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::StorageLimitWillExceedException(inner) => Error::StorageLimitWillExceedException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::InitiateDocumentVersionUploadErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveAllResourcePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveAllResourcePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveAllResourcePermissionsErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::RemoveAllResourcePermissionsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::RemoveAllResourcePermissionsErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::RemoveAllResourcePermissionsErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::RemoveAllResourcePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveResourcePermissionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveResourcePermissionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveResourcePermissionErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::RemoveResourcePermissionErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::RemoveResourcePermissionErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::RemoveResourcePermissionErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::RemoveResourcePermissionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDocumentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateDocumentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDocumentErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateDocumentErrorKind::ConflictingOperationException(inner) => {
                    Error::ConflictingOperationException(inner)
                }
                crate::error::UpdateDocumentErrorKind::EntityAlreadyExistsException(inner) => {
                    Error::EntityAlreadyExistsException(inner)
                }
                crate::error::UpdateDocumentErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::UpdateDocumentErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::UpdateDocumentErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateDocumentErrorKind::ProhibitedStateException(inner) => {
                    Error::ProhibitedStateException(inner)
                }
                crate::error::UpdateDocumentErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::UpdateDocumentErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::UpdateDocumentErrorKind::UnauthorizedResourceAccessException(
                    inner,
                ) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::UpdateDocumentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDocumentVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDocumentVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateDocumentVersionErrorKind::ConcurrentModificationException(inner) => Error::ConcurrentModificationException(inner),
                crate::error::UpdateDocumentVersionErrorKind::EntityNotExistsException(inner) => Error::EntityNotExistsException(inner),
                crate::error::UpdateDocumentVersionErrorKind::FailedDependencyException(inner) => Error::FailedDependencyException(inner),
                crate::error::UpdateDocumentVersionErrorKind::InvalidOperationException(inner) => Error::InvalidOperationException(inner),
                crate::error::UpdateDocumentVersionErrorKind::ProhibitedStateException(inner) => Error::ProhibitedStateException(inner),
                crate::error::UpdateDocumentVersionErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::UpdateDocumentVersionErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::UpdateDocumentVersionErrorKind::UnauthorizedResourceAccessException(inner) => Error::UnauthorizedResourceAccessException(inner),
                crate::error::UpdateDocumentVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateFolderError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateFolderError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateFolderErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateFolderErrorKind::ConflictingOperationException(inner) => {
                    Error::ConflictingOperationException(inner)
                }
                crate::error::UpdateFolderErrorKind::EntityAlreadyExistsException(inner) => {
                    Error::EntityAlreadyExistsException(inner)
                }
                crate::error::UpdateFolderErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::UpdateFolderErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::UpdateFolderErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateFolderErrorKind::ProhibitedStateException(inner) => {
                    Error::ProhibitedStateException(inner)
                }
                crate::error::UpdateFolderErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::UpdateFolderErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::UpdateFolderErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::UpdateFolderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateUserErrorKind::DeactivatingLastSystemUserException(inner) => {
                    Error::DeactivatingLastSystemUserException(inner)
                }
                crate::error::UpdateUserErrorKind::EntityNotExistsException(inner) => {
                    Error::EntityNotExistsException(inner)
                }
                crate::error::UpdateUserErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::UpdateUserErrorKind::IllegalUserStateException(inner) => {
                    Error::IllegalUserStateException(inner)
                }
                crate::error::UpdateUserErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::UpdateUserErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::UpdateUserErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::UpdateUserErrorKind::UnauthorizedResourceAccessException(inner) => {
                    Error::UnauthorizedResourceAccessException(inner)
                }
                crate::error::UpdateUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
