// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>The ID of the user.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The login name of the user.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The email address of the user.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The given name of the user.</p>
    pub given_name: std::option::Option<std::string::String>,
    /// <p>The surname of the user.</p>
    pub surname: std::option::Option<std::string::String>,
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The ID of the root folder.</p>
    pub root_folder_id: std::option::Option<std::string::String>,
    /// <p>The ID of the recycle bin folder.</p>
    pub recycle_bin_folder_id: std::option::Option<std::string::String>,
    /// <p>The status of the user.</p>
    pub status: std::option::Option<crate::model::UserStatusType>,
    /// <p>The type of user.</p>
    pub r#type: std::option::Option<crate::model::UserType>,
    /// <p>The time when the user was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the user was modified.</p>
    pub modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time zone ID of the user.</p>
    pub time_zone_id: std::option::Option<std::string::String>,
    /// <p>The locale of the user.</p>
    pub locale: std::option::Option<crate::model::LocaleType>,
    /// <p>The storage for the user.</p>
    pub storage: std::option::Option<crate::model::UserStorageMetadata>,
}
impl User {
    /// <p>The ID of the user.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The login name of the user.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The email address of the user.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The given name of the user.</p>
    pub fn given_name(&self) -> std::option::Option<&str> {
        self.given_name.as_deref()
    }
    /// <p>The surname of the user.</p>
    pub fn surname(&self) -> std::option::Option<&str> {
        self.surname.as_deref()
    }
    /// <p>The ID of the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The ID of the root folder.</p>
    pub fn root_folder_id(&self) -> std::option::Option<&str> {
        self.root_folder_id.as_deref()
    }
    /// <p>The ID of the recycle bin folder.</p>
    pub fn recycle_bin_folder_id(&self) -> std::option::Option<&str> {
        self.recycle_bin_folder_id.as_deref()
    }
    /// <p>The status of the user.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::UserStatusType> {
        self.status.as_ref()
    }
    /// <p>The type of user.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UserType> {
        self.r#type.as_ref()
    }
    /// <p>The time when the user was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time when the user was modified.</p>
    pub fn modified_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified_timestamp.as_ref()
    }
    /// <p>The time zone ID of the user.</p>
    pub fn time_zone_id(&self) -> std::option::Option<&str> {
        self.time_zone_id.as_deref()
    }
    /// <p>The locale of the user.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::LocaleType> {
        self.locale.as_ref()
    }
    /// <p>The storage for the user.</p>
    pub fn storage(&self) -> std::option::Option<&crate::model::UserStorageMetadata> {
        self.storage.as_ref()
    }
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("id", &self.id);
        formatter.field("username", &self.username);
        formatter.field("email_address", &self.email_address);
        formatter.field("given_name", &self.given_name);
        formatter.field("surname", &self.surname);
        formatter.field("organization_id", &self.organization_id);
        formatter.field("root_folder_id", &self.root_folder_id);
        formatter.field("recycle_bin_folder_id", &self.recycle_bin_folder_id);
        formatter.field("status", &self.status);
        formatter.field("r#type", &self.r#type);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("modified_timestamp", &self.modified_timestamp);
        formatter.field("time_zone_id", &self.time_zone_id);
        formatter.field("locale", &self.locale);
        formatter.field("storage", &self.storage);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) given_name: std::option::Option<std::string::String>,
        pub(crate) surname: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) root_folder_id: std::option::Option<std::string::String>,
        pub(crate) recycle_bin_folder_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::UserStatusType>,
        pub(crate) r#type: std::option::Option<crate::model::UserType>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) time_zone_id: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<crate::model::LocaleType>,
        pub(crate) storage: std::option::Option<crate::model::UserStorageMetadata>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The login name of the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The login name of the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The email address of the user.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address of the user.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The given name of the user.</p>
        pub fn given_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.given_name = Some(input.into());
            self
        }
        /// <p>The given name of the user.</p>
        pub fn set_given_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.given_name = input;
            self
        }
        /// <p>The surname of the user.</p>
        pub fn surname(mut self, input: impl Into<std::string::String>) -> Self {
            self.surname = Some(input.into());
            self
        }
        /// <p>The surname of the user.</p>
        pub fn set_surname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.surname = input;
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The ID of the root folder.</p>
        pub fn root_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the root folder.</p>
        pub fn set_root_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.root_folder_id = input;
            self
        }
        /// <p>The ID of the recycle bin folder.</p>
        pub fn recycle_bin_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recycle_bin_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the recycle bin folder.</p>
        pub fn set_recycle_bin_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recycle_bin_folder_id = input;
            self
        }
        /// <p>The status of the user.</p>
        pub fn status(mut self, input: crate::model::UserStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the user.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::UserStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of user.</p>
        pub fn r#type(mut self, input: crate::model::UserType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of user.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The time when the user was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the user was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time when the user was modified.</p>
        pub fn modified_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified_timestamp = Some(input);
            self
        }
        /// <p>The time when the user was modified.</p>
        pub fn set_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified_timestamp = input;
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn time_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone_id = Some(input.into());
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn set_time_zone_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone_id = input;
            self
        }
        /// <p>The locale of the user.</p>
        pub fn locale(mut self, input: crate::model::LocaleType) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale of the user.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::LocaleType>) -> Self {
            self.locale = input;
            self
        }
        /// <p>The storage for the user.</p>
        pub fn storage(mut self, input: crate::model::UserStorageMetadata) -> Self {
            self.storage = Some(input);
            self
        }
        /// <p>The storage for the user.</p>
        pub fn set_storage(
            mut self,
            input: std::option::Option<crate::model::UserStorageMetadata>,
        ) -> Self {
            self.storage = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                id: self.id,
                username: self.username,
                email_address: self.email_address,
                given_name: self.given_name,
                surname: self.surname,
                organization_id: self.organization_id,
                root_folder_id: self.root_folder_id,
                recycle_bin_folder_id: self.recycle_bin_folder_id,
                status: self.status,
                r#type: self.r#type,
                created_timestamp: self.created_timestamp,
                modified_timestamp: self.modified_timestamp,
                time_zone_id: self.time_zone_id,
                locale: self.locale,
                storage: self.storage,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}

/// <p>Describes the storage for a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserStorageMetadata {
    /// <p>The amount of storage used, in bytes.</p>
    pub storage_utilized_in_bytes: std::option::Option<i64>,
    /// <p>The storage for a user.</p>
    pub storage_rule: std::option::Option<crate::model::StorageRuleType>,
}
impl UserStorageMetadata {
    /// <p>The amount of storage used, in bytes.</p>
    pub fn storage_utilized_in_bytes(&self) -> std::option::Option<i64> {
        self.storage_utilized_in_bytes
    }
    /// <p>The storage for a user.</p>
    pub fn storage_rule(&self) -> std::option::Option<&crate::model::StorageRuleType> {
        self.storage_rule.as_ref()
    }
}
impl std::fmt::Debug for UserStorageMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserStorageMetadata");
        formatter.field("storage_utilized_in_bytes", &self.storage_utilized_in_bytes);
        formatter.field("storage_rule", &self.storage_rule);
        formatter.finish()
    }
}
/// See [`UserStorageMetadata`](crate::model::UserStorageMetadata)
pub mod user_storage_metadata {
    /// A builder for [`UserStorageMetadata`](crate::model::UserStorageMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_utilized_in_bytes: std::option::Option<i64>,
        pub(crate) storage_rule: std::option::Option<crate::model::StorageRuleType>,
    }
    impl Builder {
        /// <p>The amount of storage used, in bytes.</p>
        pub fn storage_utilized_in_bytes(mut self, input: i64) -> Self {
            self.storage_utilized_in_bytes = Some(input);
            self
        }
        /// <p>The amount of storage used, in bytes.</p>
        pub fn set_storage_utilized_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.storage_utilized_in_bytes = input;
            self
        }
        /// <p>The storage for a user.</p>
        pub fn storage_rule(mut self, input: crate::model::StorageRuleType) -> Self {
            self.storage_rule = Some(input);
            self
        }
        /// <p>The storage for a user.</p>
        pub fn set_storage_rule(
            mut self,
            input: std::option::Option<crate::model::StorageRuleType>,
        ) -> Self {
            self.storage_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`UserStorageMetadata`](crate::model::UserStorageMetadata)
        pub fn build(self) -> crate::model::UserStorageMetadata {
            crate::model::UserStorageMetadata {
                storage_utilized_in_bytes: self.storage_utilized_in_bytes,
                storage_rule: self.storage_rule,
            }
        }
    }
}
impl UserStorageMetadata {
    /// Creates a new builder-style object to manufacture [`UserStorageMetadata`](crate::model::UserStorageMetadata)
    pub fn builder() -> crate::model::user_storage_metadata::Builder {
        crate::model::user_storage_metadata::Builder::default()
    }
}

/// <p>Describes the storage for a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageRuleType {
    /// <p>The amount of storage allocated, in bytes.</p>
    pub storage_allocated_in_bytes: std::option::Option<i64>,
    /// <p>The type of storage.</p>
    pub storage_type: std::option::Option<crate::model::StorageType>,
}
impl StorageRuleType {
    /// <p>The amount of storage allocated, in bytes.</p>
    pub fn storage_allocated_in_bytes(&self) -> std::option::Option<i64> {
        self.storage_allocated_in_bytes
    }
    /// <p>The type of storage.</p>
    pub fn storage_type(&self) -> std::option::Option<&crate::model::StorageType> {
        self.storage_type.as_ref()
    }
}
impl std::fmt::Debug for StorageRuleType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageRuleType");
        formatter.field(
            "storage_allocated_in_bytes",
            &self.storage_allocated_in_bytes,
        );
        formatter.field("storage_type", &self.storage_type);
        formatter.finish()
    }
}
/// See [`StorageRuleType`](crate::model::StorageRuleType)
pub mod storage_rule_type {
    /// A builder for [`StorageRuleType`](crate::model::StorageRuleType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_allocated_in_bytes: std::option::Option<i64>,
        pub(crate) storage_type: std::option::Option<crate::model::StorageType>,
    }
    impl Builder {
        /// <p>The amount of storage allocated, in bytes.</p>
        pub fn storage_allocated_in_bytes(mut self, input: i64) -> Self {
            self.storage_allocated_in_bytes = Some(input);
            self
        }
        /// <p>The amount of storage allocated, in bytes.</p>
        pub fn set_storage_allocated_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.storage_allocated_in_bytes = input;
            self
        }
        /// <p>The type of storage.</p>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>The type of storage.</p>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageRuleType`](crate::model::StorageRuleType)
        pub fn build(self) -> crate::model::StorageRuleType {
            crate::model::StorageRuleType {
                storage_allocated_in_bytes: self.storage_allocated_in_bytes,
                storage_type: self.storage_type,
            }
        }
    }
}
impl StorageRuleType {
    /// Creates a new builder-style object to manufacture [`StorageRuleType`](crate::model::StorageRuleType)
    pub fn builder() -> crate::model::storage_rule_type::Builder {
        crate::model::storage_rule_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageType {
    #[allow(missing_docs)] // documentation missing in model
    Quota,
    #[allow(missing_docs)] // documentation missing in model
    Unlimited,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageType {
    fn from(s: &str) -> Self {
        match s {
            "QUOTA" => StorageType::Quota,
            "UNLIMITED" => StorageType::Unlimited,
            other => StorageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageType::from(s))
    }
}
impl StorageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageType::Quota => "QUOTA",
            StorageType::Unlimited => "UNLIMITED",
            StorageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["QUOTA", "UNLIMITED"]
    }
}
impl AsRef<str> for StorageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocaleType {
    #[allow(missing_docs)] // documentation missing in model
    De,
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    En,
    #[allow(missing_docs)] // documentation missing in model
    Es,
    #[allow(missing_docs)] // documentation missing in model
    Fr,
    #[allow(missing_docs)] // documentation missing in model
    Ja,
    #[allow(missing_docs)] // documentation missing in model
    Ko,
    #[allow(missing_docs)] // documentation missing in model
    PtBr,
    #[allow(missing_docs)] // documentation missing in model
    Ru,
    #[allow(missing_docs)] // documentation missing in model
    ZhCn,
    #[allow(missing_docs)] // documentation missing in model
    ZhTw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocaleType {
    fn from(s: &str) -> Self {
        match s {
            "de" => LocaleType::De,
            "default" => LocaleType::Default,
            "en" => LocaleType::En,
            "es" => LocaleType::Es,
            "fr" => LocaleType::Fr,
            "ja" => LocaleType::Ja,
            "ko" => LocaleType::Ko,
            "pt_BR" => LocaleType::PtBr,
            "ru" => LocaleType::Ru,
            "zh_CN" => LocaleType::ZhCn,
            "zh_TW" => LocaleType::ZhTw,
            other => LocaleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocaleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocaleType::from(s))
    }
}
impl LocaleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocaleType::De => "de",
            LocaleType::Default => "default",
            LocaleType::En => "en",
            LocaleType::Es => "es",
            LocaleType::Fr => "fr",
            LocaleType::Ja => "ja",
            LocaleType::Ko => "ko",
            LocaleType::PtBr => "pt_BR",
            LocaleType::Ru => "ru",
            LocaleType::ZhCn => "zh_CN",
            LocaleType::ZhTw => "zh_TW",
            LocaleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "de", "default", "en", "es", "fr", "ja", "ko", "pt_BR", "ru", "zh_CN", "zh_TW",
        ]
    }
}
impl AsRef<str> for LocaleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserType {
    #[allow(missing_docs)] // documentation missing in model
    Admin,
    #[allow(missing_docs)] // documentation missing in model
    Minimaluser,
    #[allow(missing_docs)] // documentation missing in model
    Poweruser,
    #[allow(missing_docs)] // documentation missing in model
    User,
    #[allow(missing_docs)] // documentation missing in model
    Workspacesuser,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserType {
    fn from(s: &str) -> Self {
        match s {
            "ADMIN" => UserType::Admin,
            "MINIMALUSER" => UserType::Minimaluser,
            "POWERUSER" => UserType::Poweruser,
            "USER" => UserType::User,
            "WORKSPACESUSER" => UserType::Workspacesuser,
            other => UserType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserType::from(s))
    }
}
impl UserType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserType::Admin => "ADMIN",
            UserType::Minimaluser => "MINIMALUSER",
            UserType::Poweruser => "POWERUSER",
            UserType::User => "USER",
            UserType::Workspacesuser => "WORKSPACESUSER",
            UserType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADMIN",
            "MINIMALUSER",
            "POWERUSER",
            "USER",
            "WORKSPACESUSER",
        ]
    }
}
impl AsRef<str> for UserType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserStatusType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => UserStatusType::Active,
            "INACTIVE" => UserStatusType::Inactive,
            "PENDING" => UserStatusType::Pending,
            other => UserStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserStatusType::from(s))
    }
}
impl UserStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserStatusType::Active => "ACTIVE",
            UserStatusType::Inactive => "INACTIVE",
            UserStatusType::Pending => "PENDING",
            UserStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE", "PENDING"]
    }
}
impl AsRef<str> for UserStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BooleanEnumType {
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    True,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BooleanEnumType {
    fn from(s: &str) -> Self {
        match s {
            "FALSE" => BooleanEnumType::False,
            "TRUE" => BooleanEnumType::True,
            other => BooleanEnumType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BooleanEnumType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BooleanEnumType::from(s))
    }
}
impl BooleanEnumType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BooleanEnumType::False => "FALSE",
            BooleanEnumType::True => "TRUE",
            BooleanEnumType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FALSE", "TRUE"]
    }
}
impl AsRef<str> for BooleanEnumType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceStateType {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Recycled,
    #[allow(missing_docs)] // documentation missing in model
    Recycling,
    #[allow(missing_docs)] // documentation missing in model
    Restoring,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceStateType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ResourceStateType::Active,
            "RECYCLED" => ResourceStateType::Recycled,
            "RECYCLING" => ResourceStateType::Recycling,
            "RESTORING" => ResourceStateType::Restoring,
            other => ResourceStateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceStateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceStateType::from(s))
    }
}
impl ResourceStateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceStateType::Active => "ACTIVE",
            ResourceStateType::Recycled => "RECYCLED",
            ResourceStateType::Recycling => "RECYCLING",
            ResourceStateType::Restoring => "RESTORING",
            ResourceStateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "RECYCLED", "RECYCLING", "RESTORING"]
    }
}
impl AsRef<str> for ResourceStateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DocumentVersionStatus::Active,
            other => DocumentVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentVersionStatus::from(s))
    }
}
impl DocumentVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentVersionStatus::Active => "ACTIVE",
            DocumentVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE"]
    }
}
impl AsRef<str> for DocumentVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrincipalType {
    #[allow(missing_docs)] // documentation missing in model
    Anonymous,
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    Invite,
    #[allow(missing_docs)] // documentation missing in model
    Organization,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrincipalType {
    fn from(s: &str) -> Self {
        match s {
            "ANONYMOUS" => PrincipalType::Anonymous,
            "GROUP" => PrincipalType::Group,
            "INVITE" => PrincipalType::Invite,
            "ORGANIZATION" => PrincipalType::Organization,
            "USER" => PrincipalType::User,
            other => PrincipalType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrincipalType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrincipalType::from(s))
    }
}
impl PrincipalType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrincipalType::Anonymous => "ANONYMOUS",
            PrincipalType::Group => "GROUP",
            PrincipalType::Invite => "INVITE",
            PrincipalType::Organization => "ORGANIZATION",
            PrincipalType::User => "USER",
            PrincipalType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ANONYMOUS", "GROUP", "INVITE", "ORGANIZATION", "USER"]
    }
}
impl AsRef<str> for PrincipalType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the upload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadMetadata {
    /// <p>The URL of the upload.</p>
    pub upload_url: std::option::Option<std::string::String>,
    /// <p>The signed headers.</p>
    pub signed_headers:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UploadMetadata {
    /// <p>The URL of the upload.</p>
    pub fn upload_url(&self) -> std::option::Option<&str> {
        self.upload_url.as_deref()
    }
    /// <p>The signed headers.</p>
    pub fn signed_headers(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.signed_headers.as_ref()
    }
}
impl std::fmt::Debug for UploadMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadMetadata");
        formatter.field("upload_url", &"*** Sensitive Data Redacted ***");
        formatter.field("signed_headers", &self.signed_headers);
        formatter.finish()
    }
}
/// See [`UploadMetadata`](crate::model::UploadMetadata)
pub mod upload_metadata {
    /// A builder for [`UploadMetadata`](crate::model::UploadMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_url: std::option::Option<std::string::String>,
        pub(crate) signed_headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The URL of the upload.</p>
        pub fn upload_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_url = Some(input.into());
            self
        }
        /// <p>The URL of the upload.</p>
        pub fn set_upload_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_url = input;
            self
        }
        /// Adds a key-value pair to `signed_headers`.
        ///
        /// To override the contents of this collection use [`set_signed_headers`](Self::set_signed_headers).
        ///
        /// <p>The signed headers.</p>
        pub fn signed_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.signed_headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.signed_headers = Some(hash_map);
            self
        }
        /// <p>The signed headers.</p>
        pub fn set_signed_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.signed_headers = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadMetadata`](crate::model::UploadMetadata)
        pub fn build(self) -> crate::model::UploadMetadata {
            crate::model::UploadMetadata {
                upload_url: self.upload_url,
                signed_headers: self.signed_headers,
            }
        }
    }
}
impl UploadMetadata {
    /// Creates a new builder-style object to manufacture [`UploadMetadata`](crate::model::UploadMetadata)
    pub fn builder() -> crate::model::upload_metadata::Builder {
        crate::model::upload_metadata::Builder::default()
    }
}

/// <p>Describes the document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentMetadata {
    /// <p>The ID of the document.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the creator.</p>
    pub creator_id: std::option::Option<std::string::String>,
    /// <p>The ID of the parent folder.</p>
    pub parent_folder_id: std::option::Option<std::string::String>,
    /// <p>The time when the document was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the document was updated.</p>
    pub modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The latest version of the document.</p>
    pub latest_version_metadata: std::option::Option<crate::model::DocumentVersionMetadata>,
    /// <p>The resource state.</p>
    pub resource_state: std::option::Option<crate::model::ResourceStateType>,
    /// <p>List of labels on the document.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DocumentMetadata {
    /// <p>The ID of the document.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the creator.</p>
    pub fn creator_id(&self) -> std::option::Option<&str> {
        self.creator_id.as_deref()
    }
    /// <p>The ID of the parent folder.</p>
    pub fn parent_folder_id(&self) -> std::option::Option<&str> {
        self.parent_folder_id.as_deref()
    }
    /// <p>The time when the document was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time when the document was updated.</p>
    pub fn modified_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified_timestamp.as_ref()
    }
    /// <p>The latest version of the document.</p>
    pub fn latest_version_metadata(
        &self,
    ) -> std::option::Option<&crate::model::DocumentVersionMetadata> {
        self.latest_version_metadata.as_ref()
    }
    /// <p>The resource state.</p>
    pub fn resource_state(&self) -> std::option::Option<&crate::model::ResourceStateType> {
        self.resource_state.as_ref()
    }
    /// <p>List of labels on the document.</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
}
impl std::fmt::Debug for DocumentMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentMetadata");
        formatter.field("id", &self.id);
        formatter.field("creator_id", &self.creator_id);
        formatter.field("parent_folder_id", &self.parent_folder_id);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("modified_timestamp", &self.modified_timestamp);
        formatter.field("latest_version_metadata", &self.latest_version_metadata);
        formatter.field("resource_state", &self.resource_state);
        formatter.field("labels", &self.labels);
        formatter.finish()
    }
}
/// See [`DocumentMetadata`](crate::model::DocumentMetadata)
pub mod document_metadata {
    /// A builder for [`DocumentMetadata`](crate::model::DocumentMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) creator_id: std::option::Option<std::string::String>,
        pub(crate) parent_folder_id: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_version_metadata:
            std::option::Option<crate::model::DocumentVersionMetadata>,
        pub(crate) resource_state: std::option::Option<crate::model::ResourceStateType>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the document.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the creator.</p>
        pub fn creator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_id = Some(input.into());
            self
        }
        /// <p>The ID of the creator.</p>
        pub fn set_creator_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.creator_id = input;
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_id = input;
            self
        }
        /// <p>The time when the document was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the document was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time when the document was updated.</p>
        pub fn modified_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified_timestamp = Some(input);
            self
        }
        /// <p>The time when the document was updated.</p>
        pub fn set_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified_timestamp = input;
            self
        }
        /// <p>The latest version of the document.</p>
        pub fn latest_version_metadata(
            mut self,
            input: crate::model::DocumentVersionMetadata,
        ) -> Self {
            self.latest_version_metadata = Some(input);
            self
        }
        /// <p>The latest version of the document.</p>
        pub fn set_latest_version_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentVersionMetadata>,
        ) -> Self {
            self.latest_version_metadata = input;
            self
        }
        /// <p>The resource state.</p>
        pub fn resource_state(mut self, input: crate::model::ResourceStateType) -> Self {
            self.resource_state = Some(input);
            self
        }
        /// <p>The resource state.</p>
        pub fn set_resource_state(
            mut self,
            input: std::option::Option<crate::model::ResourceStateType>,
        ) -> Self {
            self.resource_state = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>List of labels on the document.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>List of labels on the document.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentMetadata`](crate::model::DocumentMetadata)
        pub fn build(self) -> crate::model::DocumentMetadata {
            crate::model::DocumentMetadata {
                id: self.id,
                creator_id: self.creator_id,
                parent_folder_id: self.parent_folder_id,
                created_timestamp: self.created_timestamp,
                modified_timestamp: self.modified_timestamp,
                latest_version_metadata: self.latest_version_metadata,
                resource_state: self.resource_state,
                labels: self.labels,
            }
        }
    }
}
impl DocumentMetadata {
    /// Creates a new builder-style object to manufacture [`DocumentMetadata`](crate::model::DocumentMetadata)
    pub fn builder() -> crate::model::document_metadata::Builder {
        crate::model::document_metadata::Builder::default()
    }
}

/// <p>Describes a version of a document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentVersionMetadata {
    /// <p>The ID of the version.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the version.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The content type of the document.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The size of the document, in bytes.</p>
    pub size: std::option::Option<i64>,
    /// <p>The signature of the document.</p>
    pub signature: std::option::Option<std::string::String>,
    /// <p>The status of the document.</p>
    pub status: std::option::Option<crate::model::DocumentStatusType>,
    /// <p>The timestamp when the document was first uploaded.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when the document was last uploaded.</p>
    pub modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when the content of the document was originally created.</p>
    pub content_created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when the content of the document was modified.</p>
    pub content_modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ID of the creator.</p>
    pub creator_id: std::option::Option<std::string::String>,
    /// <p>The thumbnail of the document.</p>
    pub thumbnail: std::option::Option<
        std::collections::HashMap<crate::model::DocumentThumbnailType, std::string::String>,
    >,
    /// <p>The source of the document.</p>
    pub source: std::option::Option<
        std::collections::HashMap<crate::model::DocumentSourceType, std::string::String>,
    >,
}
impl DocumentVersionMetadata {
    /// <p>The ID of the version.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the version.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The content type of the document.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The size of the document, in bytes.</p>
    pub fn size(&self) -> std::option::Option<i64> {
        self.size
    }
    /// <p>The signature of the document.</p>
    pub fn signature(&self) -> std::option::Option<&str> {
        self.signature.as_deref()
    }
    /// <p>The status of the document.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DocumentStatusType> {
        self.status.as_ref()
    }
    /// <p>The timestamp when the document was first uploaded.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The timestamp when the document was last uploaded.</p>
    pub fn modified_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified_timestamp.as_ref()
    }
    /// <p>The timestamp when the content of the document was originally created.</p>
    pub fn content_created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.content_created_timestamp.as_ref()
    }
    /// <p>The timestamp when the content of the document was modified.</p>
    pub fn content_modified_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.content_modified_timestamp.as_ref()
    }
    /// <p>The ID of the creator.</p>
    pub fn creator_id(&self) -> std::option::Option<&str> {
        self.creator_id.as_deref()
    }
    /// <p>The thumbnail of the document.</p>
    pub fn thumbnail(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::DocumentThumbnailType, std::string::String>,
    > {
        self.thumbnail.as_ref()
    }
    /// <p>The source of the document.</p>
    pub fn source(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::DocumentSourceType, std::string::String>,
    > {
        self.source.as_ref()
    }
}
impl std::fmt::Debug for DocumentVersionMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentVersionMetadata");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("content_type", &self.content_type);
        formatter.field("size", &self.size);
        formatter.field("signature", &self.signature);
        formatter.field("status", &self.status);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("modified_timestamp", &self.modified_timestamp);
        formatter.field("content_created_timestamp", &self.content_created_timestamp);
        formatter.field(
            "content_modified_timestamp",
            &self.content_modified_timestamp,
        );
        formatter.field("creator_id", &self.creator_id);
        formatter.field("thumbnail", &self.thumbnail);
        formatter.field("source", &self.source);
        formatter.finish()
    }
}
/// See [`DocumentVersionMetadata`](crate::model::DocumentVersionMetadata)
pub mod document_version_metadata {
    /// A builder for [`DocumentVersionMetadata`](crate::model::DocumentVersionMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) signature: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DocumentStatusType>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) content_created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) content_modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creator_id: std::option::Option<std::string::String>,
        pub(crate) thumbnail: std::option::Option<
            std::collections::HashMap<crate::model::DocumentThumbnailType, std::string::String>,
        >,
        pub(crate) source: std::option::Option<
            std::collections::HashMap<crate::model::DocumentSourceType, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the version.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the version.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the version.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the version.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The content type of the document.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content type of the document.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The size of the document, in bytes.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size of the document, in bytes.</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// <p>The signature of the document.</p>
        pub fn signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature = Some(input.into());
            self
        }
        /// <p>The signature of the document.</p>
        pub fn set_signature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signature = input;
            self
        }
        /// <p>The status of the document.</p>
        pub fn status(mut self, input: crate::model::DocumentStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the document.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DocumentStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp when the document was first uploaded.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The timestamp when the document was first uploaded.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The timestamp when the document was last uploaded.</p>
        pub fn modified_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified_timestamp = Some(input);
            self
        }
        /// <p>The timestamp when the document was last uploaded.</p>
        pub fn set_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified_timestamp = input;
            self
        }
        /// <p>The timestamp when the content of the document was originally created.</p>
        pub fn content_created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.content_created_timestamp = Some(input);
            self
        }
        /// <p>The timestamp when the content of the document was originally created.</p>
        pub fn set_content_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.content_created_timestamp = input;
            self
        }
        /// <p>The timestamp when the content of the document was modified.</p>
        pub fn content_modified_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.content_modified_timestamp = Some(input);
            self
        }
        /// <p>The timestamp when the content of the document was modified.</p>
        pub fn set_content_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.content_modified_timestamp = input;
            self
        }
        /// <p>The ID of the creator.</p>
        pub fn creator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_id = Some(input.into());
            self
        }
        /// <p>The ID of the creator.</p>
        pub fn set_creator_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.creator_id = input;
            self
        }
        /// Adds a key-value pair to `thumbnail`.
        ///
        /// To override the contents of this collection use [`set_thumbnail`](Self::set_thumbnail).
        ///
        /// <p>The thumbnail of the document.</p>
        pub fn thumbnail(
            mut self,
            k: impl Into<crate::model::DocumentThumbnailType>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.thumbnail.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.thumbnail = Some(hash_map);
            self
        }
        /// <p>The thumbnail of the document.</p>
        pub fn set_thumbnail(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::DocumentThumbnailType, std::string::String>,
            >,
        ) -> Self {
            self.thumbnail = input;
            self
        }
        /// Adds a key-value pair to `source`.
        ///
        /// To override the contents of this collection use [`set_source`](Self::set_source).
        ///
        /// <p>The source of the document.</p>
        pub fn source(
            mut self,
            k: impl Into<crate::model::DocumentSourceType>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.source.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.source = Some(hash_map);
            self
        }
        /// <p>The source of the document.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::DocumentSourceType, std::string::String>,
            >,
        ) -> Self {
            self.source = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentVersionMetadata`](crate::model::DocumentVersionMetadata)
        pub fn build(self) -> crate::model::DocumentVersionMetadata {
            crate::model::DocumentVersionMetadata {
                id: self.id,
                name: self.name,
                content_type: self.content_type,
                size: self.size,
                signature: self.signature,
                status: self.status,
                created_timestamp: self.created_timestamp,
                modified_timestamp: self.modified_timestamp,
                content_created_timestamp: self.content_created_timestamp,
                content_modified_timestamp: self.content_modified_timestamp,
                creator_id: self.creator_id,
                thumbnail: self.thumbnail,
                source: self.source,
            }
        }
    }
}
impl DocumentVersionMetadata {
    /// Creates a new builder-style object to manufacture [`DocumentVersionMetadata`](crate::model::DocumentVersionMetadata)
    pub fn builder() -> crate::model::document_version_metadata::Builder {
        crate::model::document_version_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentSourceType {
    #[allow(missing_docs)] // documentation missing in model
    Original,
    #[allow(missing_docs)] // documentation missing in model
    WithComments,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentSourceType {
    fn from(s: &str) -> Self {
        match s {
            "ORIGINAL" => DocumentSourceType::Original,
            "WITH_COMMENTS" => DocumentSourceType::WithComments,
            other => DocumentSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentSourceType::from(s))
    }
}
impl DocumentSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentSourceType::Original => "ORIGINAL",
            DocumentSourceType::WithComments => "WITH_COMMENTS",
            DocumentSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ORIGINAL", "WITH_COMMENTS"]
    }
}
impl AsRef<str> for DocumentSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentThumbnailType {
    #[allow(missing_docs)] // documentation missing in model
    Large,
    #[allow(missing_docs)] // documentation missing in model
    Small,
    #[allow(missing_docs)] // documentation missing in model
    SmallHq,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentThumbnailType {
    fn from(s: &str) -> Self {
        match s {
            "LARGE" => DocumentThumbnailType::Large,
            "SMALL" => DocumentThumbnailType::Small,
            "SMALL_HQ" => DocumentThumbnailType::SmallHq,
            other => DocumentThumbnailType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentThumbnailType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentThumbnailType::from(s))
    }
}
impl DocumentThumbnailType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentThumbnailType::Large => "LARGE",
            DocumentThumbnailType::Small => "SMALL",
            DocumentThumbnailType::SmallHq => "SMALL_HQ",
            DocumentThumbnailType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LARGE", "SMALL", "SMALL_HQ"]
    }
}
impl AsRef<str> for DocumentThumbnailType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Initialized,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentStatusType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DocumentStatusType::Active,
            "INITIALIZED" => DocumentStatusType::Initialized,
            other => DocumentStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentStatusType::from(s))
    }
}
impl DocumentStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentStatusType::Active => "ACTIVE",
            DocumentStatusType::Initialized => "INITIALIZED",
            DocumentStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INITIALIZED"]
    }
}
impl AsRef<str> for DocumentStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a folder.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FolderMetadata {
    /// <p>The ID of the folder.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the folder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the creator.</p>
    pub creator_id: std::option::Option<std::string::String>,
    /// <p>The ID of the parent folder.</p>
    pub parent_folder_id: std::option::Option<std::string::String>,
    /// <p>The time when the folder was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the folder was updated.</p>
    pub modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The resource state of the folder.</p>
    pub resource_state: std::option::Option<crate::model::ResourceStateType>,
    /// <p>The unique identifier created from the subfolders and documents of the
    /// folder.</p>
    pub signature: std::option::Option<std::string::String>,
    /// <p>List of labels on the folder.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The size of the folder metadata.</p>
    pub size: std::option::Option<i64>,
    /// <p>The size of the latest version of the folder metadata.</p>
    pub latest_version_size: std::option::Option<i64>,
}
impl FolderMetadata {
    /// <p>The ID of the folder.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the folder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the creator.</p>
    pub fn creator_id(&self) -> std::option::Option<&str> {
        self.creator_id.as_deref()
    }
    /// <p>The ID of the parent folder.</p>
    pub fn parent_folder_id(&self) -> std::option::Option<&str> {
        self.parent_folder_id.as_deref()
    }
    /// <p>The time when the folder was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time when the folder was updated.</p>
    pub fn modified_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified_timestamp.as_ref()
    }
    /// <p>The resource state of the folder.</p>
    pub fn resource_state(&self) -> std::option::Option<&crate::model::ResourceStateType> {
        self.resource_state.as_ref()
    }
    /// <p>The unique identifier created from the subfolders and documents of the
    /// folder.</p>
    pub fn signature(&self) -> std::option::Option<&str> {
        self.signature.as_deref()
    }
    /// <p>List of labels on the folder.</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
    /// <p>The size of the folder metadata.</p>
    pub fn size(&self) -> std::option::Option<i64> {
        self.size
    }
    /// <p>The size of the latest version of the folder metadata.</p>
    pub fn latest_version_size(&self) -> std::option::Option<i64> {
        self.latest_version_size
    }
}
impl std::fmt::Debug for FolderMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FolderMetadata");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("creator_id", &self.creator_id);
        formatter.field("parent_folder_id", &self.parent_folder_id);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("modified_timestamp", &self.modified_timestamp);
        formatter.field("resource_state", &self.resource_state);
        formatter.field("signature", &self.signature);
        formatter.field("labels", &self.labels);
        formatter.field("size", &self.size);
        formatter.field("latest_version_size", &self.latest_version_size);
        formatter.finish()
    }
}
/// See [`FolderMetadata`](crate::model::FolderMetadata)
pub mod folder_metadata {
    /// A builder for [`FolderMetadata`](crate::model::FolderMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) creator_id: std::option::Option<std::string::String>,
        pub(crate) parent_folder_id: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) modified_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resource_state: std::option::Option<crate::model::ResourceStateType>,
        pub(crate) signature: std::option::Option<std::string::String>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) latest_version_size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the folder.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the creator.</p>
        pub fn creator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_id = Some(input.into());
            self
        }
        /// <p>The ID of the creator.</p>
        pub fn set_creator_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.creator_id = input;
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_id = input;
            self
        }
        /// <p>The time when the folder was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time when the folder was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time when the folder was updated.</p>
        pub fn modified_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified_timestamp = Some(input);
            self
        }
        /// <p>The time when the folder was updated.</p>
        pub fn set_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified_timestamp = input;
            self
        }
        /// <p>The resource state of the folder.</p>
        pub fn resource_state(mut self, input: crate::model::ResourceStateType) -> Self {
            self.resource_state = Some(input);
            self
        }
        /// <p>The resource state of the folder.</p>
        pub fn set_resource_state(
            mut self,
            input: std::option::Option<crate::model::ResourceStateType>,
        ) -> Self {
            self.resource_state = input;
            self
        }
        /// <p>The unique identifier created from the subfolders and documents of the
        /// folder.</p>
        pub fn signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature = Some(input.into());
            self
        }
        /// <p>The unique identifier created from the subfolders and documents of the
        /// folder.</p>
        pub fn set_signature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signature = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>List of labels on the folder.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>List of labels on the folder.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>The size of the folder metadata.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size of the folder metadata.</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// <p>The size of the latest version of the folder metadata.</p>
        pub fn latest_version_size(mut self, input: i64) -> Self {
            self.latest_version_size = Some(input);
            self
        }
        /// <p>The size of the latest version of the folder metadata.</p>
        pub fn set_latest_version_size(mut self, input: std::option::Option<i64>) -> Self {
            self.latest_version_size = input;
            self
        }
        /// Consumes the builder and constructs a [`FolderMetadata`](crate::model::FolderMetadata)
        pub fn build(self) -> crate::model::FolderMetadata {
            crate::model::FolderMetadata {
                id: self.id,
                name: self.name,
                creator_id: self.creator_id,
                parent_folder_id: self.parent_folder_id,
                created_timestamp: self.created_timestamp,
                modified_timestamp: self.modified_timestamp,
                resource_state: self.resource_state,
                signature: self.signature,
                labels: self.labels,
                size: self.size,
                latest_version_size: self.latest_version_size,
            }
        }
    }
}
impl FolderMetadata {
    /// Creates a new builder-style object to manufacture [`FolderMetadata`](crate::model::FolderMetadata)
    pub fn builder() -> crate::model::folder_metadata::Builder {
        crate::model::folder_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceCollectionType {
    #[allow(missing_docs)] // documentation missing in model
    SharedWithMe,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceCollectionType {
    fn from(s: &str) -> Self {
        match s {
            "SHARED_WITH_ME" => ResourceCollectionType::SharedWithMe,
            other => ResourceCollectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceCollectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceCollectionType::from(s))
    }
}
impl ResourceCollectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceCollectionType::SharedWithMe => "SHARED_WITH_ME",
            ResourceCollectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SHARED_WITH_ME"]
    }
}
impl AsRef<str> for ResourceCollectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the path information of a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePath {
    /// <p>The components of the resource path.</p>
    pub components: std::option::Option<std::vec::Vec<crate::model::ResourcePathComponent>>,
}
impl ResourcePath {
    /// <p>The components of the resource path.</p>
    pub fn components(&self) -> std::option::Option<&[crate::model::ResourcePathComponent]> {
        self.components.as_deref()
    }
}
impl std::fmt::Debug for ResourcePath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePath");
        formatter.field("components", &self.components);
        formatter.finish()
    }
}
/// See [`ResourcePath`](crate::model::ResourcePath)
pub mod resource_path {
    /// A builder for [`ResourcePath`](crate::model::ResourcePath)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) components:
            std::option::Option<std::vec::Vec<crate::model::ResourcePathComponent>>,
    }
    impl Builder {
        /// Appends an item to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>The components of the resource path.</p>
        pub fn components(mut self, input: impl Into<crate::model::ResourcePathComponent>) -> Self {
            let mut v = self.components.unwrap_or_default();
            v.push(input.into());
            self.components = Some(v);
            self
        }
        /// <p>The components of the resource path.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePathComponent>>,
        ) -> Self {
            self.components = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePath`](crate::model::ResourcePath)
        pub fn build(self) -> crate::model::ResourcePath {
            crate::model::ResourcePath {
                components: self.components,
            }
        }
    }
}
impl ResourcePath {
    /// Creates a new builder-style object to manufacture [`ResourcePath`](crate::model::ResourcePath)
    pub fn builder() -> crate::model::resource_path::Builder {
        crate::model::resource_path::Builder::default()
    }
}

/// <p>Describes the resource path.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePathComponent {
    /// <p>The ID of the resource path.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the resource path.</p>
    pub name: std::option::Option<std::string::String>,
}
impl ResourcePathComponent {
    /// <p>The ID of the resource path.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the resource path.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ResourcePathComponent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePathComponent");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ResourcePathComponent`](crate::model::ResourcePathComponent)
pub mod resource_path_component {
    /// A builder for [`ResourcePathComponent`](crate::model::ResourcePathComponent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource path.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource path.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the resource path.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource path.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePathComponent`](crate::model::ResourcePathComponent)
        pub fn build(self) -> crate::model::ResourcePathComponent {
            crate::model::ResourcePathComponent {
                id: self.id,
                name: self.name,
            }
        }
    }
}
impl ResourcePathComponent {
    /// Creates a new builder-style object to manufacture [`ResourcePathComponent`](crate::model::ResourcePathComponent)
    pub fn builder() -> crate::model::resource_path_component::Builder {
        crate::model::resource_path_component::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserSortType {
    #[allow(missing_docs)] // documentation missing in model
    FullName,
    #[allow(missing_docs)] // documentation missing in model
    StorageLimit,
    #[allow(missing_docs)] // documentation missing in model
    StorageUsed,
    #[allow(missing_docs)] // documentation missing in model
    UserName,
    #[allow(missing_docs)] // documentation missing in model
    UserStatus,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserSortType {
    fn from(s: &str) -> Self {
        match s {
            "FULL_NAME" => UserSortType::FullName,
            "STORAGE_LIMIT" => UserSortType::StorageLimit,
            "STORAGE_USED" => UserSortType::StorageUsed,
            "USER_NAME" => UserSortType::UserName,
            "USER_STATUS" => UserSortType::UserStatus,
            other => UserSortType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserSortType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserSortType::from(s))
    }
}
impl UserSortType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserSortType::FullName => "FULL_NAME",
            UserSortType::StorageLimit => "STORAGE_LIMIT",
            UserSortType::StorageUsed => "STORAGE_USED",
            UserSortType::UserName => "USER_NAME",
            UserSortType::UserStatus => "USER_STATUS",
            UserSortType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FULL_NAME",
            "STORAGE_LIMIT",
            "STORAGE_USED",
            "USER_NAME",
            "USER_STATUS",
        ]
    }
}
impl AsRef<str> for UserSortType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderType {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderType {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => OrderType::Ascending,
            "DESCENDING" => OrderType::Descending,
            other => OrderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderType::from(s))
    }
}
impl OrderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderType::Ascending => "ASCENDING",
            OrderType::Descending => "DESCENDING",
            OrderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for OrderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserFilterType {
    #[allow(missing_docs)] // documentation missing in model
    ActivePending,
    #[allow(missing_docs)] // documentation missing in model
    All,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserFilterType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE_PENDING" => UserFilterType::ActivePending,
            "ALL" => UserFilterType::All,
            other => UserFilterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserFilterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserFilterType::from(s))
    }
}
impl UserFilterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserFilterType::ActivePending => "ACTIVE_PENDING",
            UserFilterType::All => "ALL",
            UserFilterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE_PENDING", "ALL"]
    }
}
impl AsRef<str> for UserFilterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Principal {
    /// <p>The ID of the resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of resource.</p>
    pub r#type: std::option::Option<crate::model::PrincipalType>,
    /// <p>The permission information for the resource.</p>
    pub roles: std::option::Option<std::vec::Vec<crate::model::PermissionInfo>>,
}
impl Principal {
    /// <p>The ID of the resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of resource.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PrincipalType> {
        self.r#type.as_ref()
    }
    /// <p>The permission information for the resource.</p>
    pub fn roles(&self) -> std::option::Option<&[crate::model::PermissionInfo]> {
        self.roles.as_deref()
    }
}
impl std::fmt::Debug for Principal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Principal");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("roles", &self.roles);
        formatter.finish()
    }
}
/// See [`Principal`](crate::model::Principal)
pub mod principal {
    /// A builder for [`Principal`](crate::model::Principal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PrincipalType>,
        pub(crate) roles: std::option::Option<std::vec::Vec<crate::model::PermissionInfo>>,
    }
    impl Builder {
        /// <p>The ID of the resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of resource.</p>
        pub fn r#type(mut self, input: crate::model::PrincipalType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PrincipalType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p>The permission information for the resource.</p>
        pub fn roles(mut self, input: impl Into<crate::model::PermissionInfo>) -> Self {
            let mut v = self.roles.unwrap_or_default();
            v.push(input.into());
            self.roles = Some(v);
            self
        }
        /// <p>The permission information for the resource.</p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionInfo>>,
        ) -> Self {
            self.roles = input;
            self
        }
        /// Consumes the builder and constructs a [`Principal`](crate::model::Principal)
        pub fn build(self) -> crate::model::Principal {
            crate::model::Principal {
                id: self.id,
                r#type: self.r#type,
                roles: self.roles,
            }
        }
    }
}
impl Principal {
    /// Creates a new builder-style object to manufacture [`Principal`](crate::model::Principal)
    pub fn builder() -> crate::model::principal::Builder {
        crate::model::principal::Builder::default()
    }
}

/// <p>Describes the permissions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PermissionInfo {
    /// <p>The role of the user.</p>
    pub role: std::option::Option<crate::model::RoleType>,
    /// <p>The type of permissions.</p>
    pub r#type: std::option::Option<crate::model::RolePermissionType>,
}
impl PermissionInfo {
    /// <p>The role of the user.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::RoleType> {
        self.role.as_ref()
    }
    /// <p>The type of permissions.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RolePermissionType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for PermissionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PermissionInfo");
        formatter.field("role", &self.role);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`PermissionInfo`](crate::model::PermissionInfo)
pub mod permission_info {
    /// A builder for [`PermissionInfo`](crate::model::PermissionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role: std::option::Option<crate::model::RoleType>,
        pub(crate) r#type: std::option::Option<crate::model::RolePermissionType>,
    }
    impl Builder {
        /// <p>The role of the user.</p>
        pub fn role(mut self, input: crate::model::RoleType) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>The role of the user.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::RoleType>) -> Self {
            self.role = input;
            self
        }
        /// <p>The type of permissions.</p>
        pub fn r#type(mut self, input: crate::model::RolePermissionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of permissions.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::RolePermissionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`PermissionInfo`](crate::model::PermissionInfo)
        pub fn build(self) -> crate::model::PermissionInfo {
            crate::model::PermissionInfo {
                role: self.role,
                r#type: self.r#type,
            }
        }
    }
}
impl PermissionInfo {
    /// Creates a new builder-style object to manufacture [`PermissionInfo`](crate::model::PermissionInfo)
    pub fn builder() -> crate::model::permission_info::Builder {
        crate::model::permission_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RolePermissionType {
    #[allow(missing_docs)] // documentation missing in model
    Direct,
    #[allow(missing_docs)] // documentation missing in model
    Inherited,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RolePermissionType {
    fn from(s: &str) -> Self {
        match s {
            "DIRECT" => RolePermissionType::Direct,
            "INHERITED" => RolePermissionType::Inherited,
            other => RolePermissionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RolePermissionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RolePermissionType::from(s))
    }
}
impl RolePermissionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RolePermissionType::Direct => "DIRECT",
            RolePermissionType::Inherited => "INHERITED",
            RolePermissionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DIRECT", "INHERITED"]
    }
}
impl AsRef<str> for RolePermissionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RoleType {
    #[allow(missing_docs)] // documentation missing in model
    Contributor,
    #[allow(missing_docs)] // documentation missing in model
    Coowner,
    #[allow(missing_docs)] // documentation missing in model
    Owner,
    #[allow(missing_docs)] // documentation missing in model
    Viewer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RoleType {
    fn from(s: &str) -> Self {
        match s {
            "CONTRIBUTOR" => RoleType::Contributor,
            "COOWNER" => RoleType::Coowner,
            "OWNER" => RoleType::Owner,
            "VIEWER" => RoleType::Viewer,
            other => RoleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RoleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RoleType::from(s))
    }
}
impl RoleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RoleType::Contributor => "CONTRIBUTOR",
            RoleType::Coowner => "COOWNER",
            RoleType::Owner => "OWNER",
            RoleType::Viewer => "VIEWER",
            RoleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTRIBUTOR", "COOWNER", "OWNER", "VIEWER"]
    }
}
impl AsRef<str> for RoleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a subscription.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subscription {
    /// <p>The ID of the subscription.</p>
    pub subscription_id: std::option::Option<std::string::String>,
    /// <p>The endpoint of the subscription.</p>
    pub end_point: std::option::Option<std::string::String>,
    /// <p>The protocol of the subscription.</p>
    pub protocol: std::option::Option<crate::model::SubscriptionProtocolType>,
}
impl Subscription {
    /// <p>The ID of the subscription.</p>
    pub fn subscription_id(&self) -> std::option::Option<&str> {
        self.subscription_id.as_deref()
    }
    /// <p>The endpoint of the subscription.</p>
    pub fn end_point(&self) -> std::option::Option<&str> {
        self.end_point.as_deref()
    }
    /// <p>The protocol of the subscription.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::SubscriptionProtocolType> {
        self.protocol.as_ref()
    }
}
impl std::fmt::Debug for Subscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subscription");
        formatter.field("subscription_id", &self.subscription_id);
        formatter.field("end_point", &self.end_point);
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`Subscription`](crate::model::Subscription)
pub mod subscription {
    /// A builder for [`Subscription`](crate::model::Subscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_id: std::option::Option<std::string::String>,
        pub(crate) end_point: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::SubscriptionProtocolType>,
    }
    impl Builder {
        /// <p>The ID of the subscription.</p>
        pub fn subscription_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_id = Some(input.into());
            self
        }
        /// <p>The ID of the subscription.</p>
        pub fn set_subscription_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_id = input;
            self
        }
        /// <p>The endpoint of the subscription.</p>
        pub fn end_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_point = Some(input.into());
            self
        }
        /// <p>The endpoint of the subscription.</p>
        pub fn set_end_point(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_point = input;
            self
        }
        /// <p>The protocol of the subscription.</p>
        pub fn protocol(mut self, input: crate::model::SubscriptionProtocolType) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol of the subscription.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::SubscriptionProtocolType>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`Subscription`](crate::model::Subscription)
        pub fn build(self) -> crate::model::Subscription {
            crate::model::Subscription {
                subscription_id: self.subscription_id,
                end_point: self.end_point,
                protocol: self.protocol,
            }
        }
    }
}
impl Subscription {
    /// Creates a new builder-style object to manufacture [`Subscription`](crate::model::Subscription)
    pub fn builder() -> crate::model::subscription::Builder {
        crate::model::subscription::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SubscriptionProtocolType {
    #[allow(missing_docs)] // documentation missing in model
    Https,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SubscriptionProtocolType {
    fn from(s: &str) -> Self {
        match s {
            "HTTPS" => SubscriptionProtocolType::Https,
            other => SubscriptionProtocolType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SubscriptionProtocolType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SubscriptionProtocolType::from(s))
    }
}
impl SubscriptionProtocolType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SubscriptionProtocolType::Https => "HTTPS",
            SubscriptionProtocolType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTPS"]
    }
}
impl AsRef<str> for SubscriptionProtocolType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the metadata of a user group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupMetadata {
    /// <p>The ID of the user group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the group.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GroupMetadata {
    /// <p>The ID of the user group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GroupMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupMetadata");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`GroupMetadata`](crate::model::GroupMetadata)
pub mod group_metadata {
    /// A builder for [`GroupMetadata`](crate::model::GroupMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupMetadata`](crate::model::GroupMetadata)
        pub fn build(self) -> crate::model::GroupMetadata {
            crate::model::GroupMetadata {
                id: self.id,
                name: self.name,
            }
        }
    }
}
impl GroupMetadata {
    /// Creates a new builder-style object to manufacture [`GroupMetadata`](crate::model::GroupMetadata)
    pub fn builder() -> crate::model::group_metadata::Builder {
        crate::model::group_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FolderContentType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Document,
    #[allow(missing_docs)] // documentation missing in model
    Folder,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FolderContentType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => FolderContentType::All,
            "DOCUMENT" => FolderContentType::Document,
            "FOLDER" => FolderContentType::Folder,
            other => FolderContentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FolderContentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FolderContentType::from(s))
    }
}
impl FolderContentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FolderContentType::All => "ALL",
            FolderContentType::Document => "DOCUMENT",
            FolderContentType::Folder => "FOLDER",
            FolderContentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "DOCUMENT", "FOLDER"]
    }
}
impl AsRef<str> for FolderContentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceSortType {
    #[allow(missing_docs)] // documentation missing in model
    Date,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceSortType {
    fn from(s: &str) -> Self {
        match s {
            "DATE" => ResourceSortType::Date,
            "NAME" => ResourceSortType::Name,
            other => ResourceSortType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceSortType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceSortType::from(s))
    }
}
impl ResourceSortType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceSortType::Date => "DATE",
            ResourceSortType::Name => "NAME",
            ResourceSortType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DATE", "NAME"]
    }
}
impl AsRef<str> for ResourceSortType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a comment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Comment {
    /// <p>The ID of the comment.</p>
    pub comment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the parent comment.</p>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>The ID of the root comment in the thread.</p>
    pub thread_id: std::option::Option<std::string::String>,
    /// <p>The text of the comment.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The details of the user who made the comment.</p>
    pub contributor: std::option::Option<crate::model::User>,
    /// <p>The time that the comment was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the comment.</p>
    pub status: std::option::Option<crate::model::CommentStatusType>,
    /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is
    /// visible only to the comment author and document owner and co-owners, or PUBLIC, where
    /// the comment is visible to document owners, co-owners, and contributors.</p>
    pub visibility: std::option::Option<crate::model::CommentVisibilityType>,
    /// <p>If the comment is a reply to another user's comment, this field contains the user
    /// ID of the user being replied to.</p>
    pub recipient_id: std::option::Option<std::string::String>,
}
impl Comment {
    /// <p>The ID of the comment.</p>
    pub fn comment_id(&self) -> std::option::Option<&str> {
        self.comment_id.as_deref()
    }
    /// <p>The ID of the parent comment.</p>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>The ID of the root comment in the thread.</p>
    pub fn thread_id(&self) -> std::option::Option<&str> {
        self.thread_id.as_deref()
    }
    /// <p>The text of the comment.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The details of the user who made the comment.</p>
    pub fn contributor(&self) -> std::option::Option<&crate::model::User> {
        self.contributor.as_ref()
    }
    /// <p>The time that the comment was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The status of the comment.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CommentStatusType> {
        self.status.as_ref()
    }
    /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is
    /// visible only to the comment author and document owner and co-owners, or PUBLIC, where
    /// the comment is visible to document owners, co-owners, and contributors.</p>
    pub fn visibility(&self) -> std::option::Option<&crate::model::CommentVisibilityType> {
        self.visibility.as_ref()
    }
    /// <p>If the comment is a reply to another user's comment, this field contains the user
    /// ID of the user being replied to.</p>
    pub fn recipient_id(&self) -> std::option::Option<&str> {
        self.recipient_id.as_deref()
    }
}
impl std::fmt::Debug for Comment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Comment");
        formatter.field("comment_id", &self.comment_id);
        formatter.field("parent_id", &self.parent_id);
        formatter.field("thread_id", &self.thread_id);
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("contributor", &self.contributor);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("status", &self.status);
        formatter.field("visibility", &self.visibility);
        formatter.field("recipient_id", &self.recipient_id);
        formatter.finish()
    }
}
/// See [`Comment`](crate::model::Comment)
pub mod comment {
    /// A builder for [`Comment`](crate::model::Comment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment_id: std::option::Option<std::string::String>,
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) thread_id: std::option::Option<std::string::String>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) contributor: std::option::Option<crate::model::User>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::CommentStatusType>,
        pub(crate) visibility: std::option::Option<crate::model::CommentVisibilityType>,
        pub(crate) recipient_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the comment.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_id = Some(input.into());
            self
        }
        /// <p>The ID of the comment.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_id = input;
            self
        }
        /// <p>The ID of the parent comment.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent comment.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The ID of the root comment in the thread.</p>
        pub fn thread_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thread_id = Some(input.into());
            self
        }
        /// <p>The ID of the root comment in the thread.</p>
        pub fn set_thread_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thread_id = input;
            self
        }
        /// <p>The text of the comment.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text of the comment.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The details of the user who made the comment.</p>
        pub fn contributor(mut self, input: crate::model::User) -> Self {
            self.contributor = Some(input);
            self
        }
        /// <p>The details of the user who made the comment.</p>
        pub fn set_contributor(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.contributor = input;
            self
        }
        /// <p>The time that the comment was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time that the comment was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The status of the comment.</p>
        pub fn status(mut self, input: crate::model::CommentStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the comment.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CommentStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is
        /// visible only to the comment author and document owner and co-owners, or PUBLIC, where
        /// the comment is visible to document owners, co-owners, and contributors.</p>
        pub fn visibility(mut self, input: crate::model::CommentVisibilityType) -> Self {
            self.visibility = Some(input);
            self
        }
        /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is
        /// visible only to the comment author and document owner and co-owners, or PUBLIC, where
        /// the comment is visible to document owners, co-owners, and contributors.</p>
        pub fn set_visibility(
            mut self,
            input: std::option::Option<crate::model::CommentVisibilityType>,
        ) -> Self {
            self.visibility = input;
            self
        }
        /// <p>If the comment is a reply to another user's comment, this field contains the user
        /// ID of the user being replied to.</p>
        pub fn recipient_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipient_id = Some(input.into());
            self
        }
        /// <p>If the comment is a reply to another user's comment, this field contains the user
        /// ID of the user being replied to.</p>
        pub fn set_recipient_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipient_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Comment`](crate::model::Comment)
        pub fn build(self) -> crate::model::Comment {
            crate::model::Comment {
                comment_id: self.comment_id,
                parent_id: self.parent_id,
                thread_id: self.thread_id,
                text: self.text,
                contributor: self.contributor,
                created_timestamp: self.created_timestamp,
                status: self.status,
                visibility: self.visibility,
                recipient_id: self.recipient_id,
            }
        }
    }
}
impl Comment {
    /// Creates a new builder-style object to manufacture [`Comment`](crate::model::Comment)
    pub fn builder() -> crate::model::comment::Builder {
        crate::model::comment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CommentVisibilityType {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CommentVisibilityType {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE" => CommentVisibilityType::Private,
            "PUBLIC" => CommentVisibilityType::Public,
            other => CommentVisibilityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CommentVisibilityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CommentVisibilityType::from(s))
    }
}
impl CommentVisibilityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CommentVisibilityType::Private => "PRIVATE",
            CommentVisibilityType::Public => "PUBLIC",
            CommentVisibilityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE", "PUBLIC"]
    }
}
impl AsRef<str> for CommentVisibilityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CommentStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Draft,
    #[allow(missing_docs)] // documentation missing in model
    Published,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CommentStatusType {
    fn from(s: &str) -> Self {
        match s {
            "DELETED" => CommentStatusType::Deleted,
            "DRAFT" => CommentStatusType::Draft,
            "PUBLISHED" => CommentStatusType::Published,
            other => CommentStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CommentStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CommentStatusType::from(s))
    }
}
impl CommentStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CommentStatusType::Deleted => "DELETED",
            CommentStatusType::Draft => "DRAFT",
            CommentStatusType::Published => "PUBLISHED",
            CommentStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETED", "DRAFT", "PUBLISHED"]
    }
}
impl AsRef<str> for CommentStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the activity information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Activity {
    /// <p>The activity type.</p>
    pub r#type: std::option::Option<crate::model::ActivityType>,
    /// <p>The timestamp when the action was performed.</p>
    pub time_stamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates whether an activity is indirect or direct. An indirect activity results
    /// from a direct activity performed on a parent resource. For example, sharing a parent
    /// folder (the direct activity) shares all of the subfolders and documents within the
    /// parent folder (the indirect activity).</p>
    pub is_indirect_activity: bool,
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The user who performed the action.</p>
    pub initiator: std::option::Option<crate::model::UserMetadata>,
    /// <p>The list of users or groups impacted by this action. This is an optional field and
    /// is filled for the following sharing activities: DOCUMENT_SHARED, DOCUMENT_SHARED,
    /// DOCUMENT_UNSHARED, FOLDER_SHARED, FOLDER_UNSHARED.</p>
    pub participants: std::option::Option<crate::model::Participants>,
    /// <p>The metadata of the resource involved in the user action.</p>
    pub resource_metadata: std::option::Option<crate::model::ResourceMetadata>,
    /// <p>The original parent of the resource. This is an optional field and is filled for
    /// move activities.</p>
    pub original_parent: std::option::Option<crate::model::ResourceMetadata>,
    /// <p>Metadata of the commenting activity. This is an optional field and is filled for
    /// commenting activities.</p>
    pub comment_metadata: std::option::Option<crate::model::CommentMetadata>,
}
impl Activity {
    /// <p>The activity type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ActivityType> {
        self.r#type.as_ref()
    }
    /// <p>The timestamp when the action was performed.</p>
    pub fn time_stamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time_stamp.as_ref()
    }
    /// <p>Indicates whether an activity is indirect or direct. An indirect activity results
    /// from a direct activity performed on a parent resource. For example, sharing a parent
    /// folder (the direct activity) shares all of the subfolders and documents within the
    /// parent folder (the indirect activity).</p>
    pub fn is_indirect_activity(&self) -> bool {
        self.is_indirect_activity
    }
    /// <p>The ID of the organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>The user who performed the action.</p>
    pub fn initiator(&self) -> std::option::Option<&crate::model::UserMetadata> {
        self.initiator.as_ref()
    }
    /// <p>The list of users or groups impacted by this action. This is an optional field and
    /// is filled for the following sharing activities: DOCUMENT_SHARED, DOCUMENT_SHARED,
    /// DOCUMENT_UNSHARED, FOLDER_SHARED, FOLDER_UNSHARED.</p>
    pub fn participants(&self) -> std::option::Option<&crate::model::Participants> {
        self.participants.as_ref()
    }
    /// <p>The metadata of the resource involved in the user action.</p>
    pub fn resource_metadata(&self) -> std::option::Option<&crate::model::ResourceMetadata> {
        self.resource_metadata.as_ref()
    }
    /// <p>The original parent of the resource. This is an optional field and is filled for
    /// move activities.</p>
    pub fn original_parent(&self) -> std::option::Option<&crate::model::ResourceMetadata> {
        self.original_parent.as_ref()
    }
    /// <p>Metadata of the commenting activity. This is an optional field and is filled for
    /// commenting activities.</p>
    pub fn comment_metadata(&self) -> std::option::Option<&crate::model::CommentMetadata> {
        self.comment_metadata.as_ref()
    }
}
impl std::fmt::Debug for Activity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Activity");
        formatter.field("r#type", &self.r#type);
        formatter.field("time_stamp", &self.time_stamp);
        formatter.field("is_indirect_activity", &self.is_indirect_activity);
        formatter.field("organization_id", &self.organization_id);
        formatter.field("initiator", &self.initiator);
        formatter.field("participants", &self.participants);
        formatter.field("resource_metadata", &self.resource_metadata);
        formatter.field("original_parent", &self.original_parent);
        formatter.field("comment_metadata", &self.comment_metadata);
        formatter.finish()
    }
}
/// See [`Activity`](crate::model::Activity)
pub mod activity {
    /// A builder for [`Activity`](crate::model::Activity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ActivityType>,
        pub(crate) time_stamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) is_indirect_activity: std::option::Option<bool>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) initiator: std::option::Option<crate::model::UserMetadata>,
        pub(crate) participants: std::option::Option<crate::model::Participants>,
        pub(crate) resource_metadata: std::option::Option<crate::model::ResourceMetadata>,
        pub(crate) original_parent: std::option::Option<crate::model::ResourceMetadata>,
        pub(crate) comment_metadata: std::option::Option<crate::model::CommentMetadata>,
    }
    impl Builder {
        /// <p>The activity type.</p>
        pub fn r#type(mut self, input: crate::model::ActivityType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The activity type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ActivityType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The timestamp when the action was performed.</p>
        pub fn time_stamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time_stamp = Some(input);
            self
        }
        /// <p>The timestamp when the action was performed.</p>
        pub fn set_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.time_stamp = input;
            self
        }
        /// <p>Indicates whether an activity is indirect or direct. An indirect activity results
        /// from a direct activity performed on a parent resource. For example, sharing a parent
        /// folder (the direct activity) shares all of the subfolders and documents within the
        /// parent folder (the indirect activity).</p>
        pub fn is_indirect_activity(mut self, input: bool) -> Self {
            self.is_indirect_activity = Some(input);
            self
        }
        /// <p>Indicates whether an activity is indirect or direct. An indirect activity results
        /// from a direct activity performed on a parent resource. For example, sharing a parent
        /// folder (the direct activity) shares all of the subfolders and documents within the
        /// parent folder (the indirect activity).</p>
        pub fn set_is_indirect_activity(mut self, input: std::option::Option<bool>) -> Self {
            self.is_indirect_activity = input;
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The user who performed the action.</p>
        pub fn initiator(mut self, input: crate::model::UserMetadata) -> Self {
            self.initiator = Some(input);
            self
        }
        /// <p>The user who performed the action.</p>
        pub fn set_initiator(
            mut self,
            input: std::option::Option<crate::model::UserMetadata>,
        ) -> Self {
            self.initiator = input;
            self
        }
        /// <p>The list of users or groups impacted by this action. This is an optional field and
        /// is filled for the following sharing activities: DOCUMENT_SHARED, DOCUMENT_SHARED,
        /// DOCUMENT_UNSHARED, FOLDER_SHARED, FOLDER_UNSHARED.</p>
        pub fn participants(mut self, input: crate::model::Participants) -> Self {
            self.participants = Some(input);
            self
        }
        /// <p>The list of users or groups impacted by this action. This is an optional field and
        /// is filled for the following sharing activities: DOCUMENT_SHARED, DOCUMENT_SHARED,
        /// DOCUMENT_UNSHARED, FOLDER_SHARED, FOLDER_UNSHARED.</p>
        pub fn set_participants(
            mut self,
            input: std::option::Option<crate::model::Participants>,
        ) -> Self {
            self.participants = input;
            self
        }
        /// <p>The metadata of the resource involved in the user action.</p>
        pub fn resource_metadata(mut self, input: crate::model::ResourceMetadata) -> Self {
            self.resource_metadata = Some(input);
            self
        }
        /// <p>The metadata of the resource involved in the user action.</p>
        pub fn set_resource_metadata(
            mut self,
            input: std::option::Option<crate::model::ResourceMetadata>,
        ) -> Self {
            self.resource_metadata = input;
            self
        }
        /// <p>The original parent of the resource. This is an optional field and is filled for
        /// move activities.</p>
        pub fn original_parent(mut self, input: crate::model::ResourceMetadata) -> Self {
            self.original_parent = Some(input);
            self
        }
        /// <p>The original parent of the resource. This is an optional field and is filled for
        /// move activities.</p>
        pub fn set_original_parent(
            mut self,
            input: std::option::Option<crate::model::ResourceMetadata>,
        ) -> Self {
            self.original_parent = input;
            self
        }
        /// <p>Metadata of the commenting activity. This is an optional field and is filled for
        /// commenting activities.</p>
        pub fn comment_metadata(mut self, input: crate::model::CommentMetadata) -> Self {
            self.comment_metadata = Some(input);
            self
        }
        /// <p>Metadata of the commenting activity. This is an optional field and is filled for
        /// commenting activities.</p>
        pub fn set_comment_metadata(
            mut self,
            input: std::option::Option<crate::model::CommentMetadata>,
        ) -> Self {
            self.comment_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`Activity`](crate::model::Activity)
        pub fn build(self) -> crate::model::Activity {
            crate::model::Activity {
                r#type: self.r#type,
                time_stamp: self.time_stamp,
                is_indirect_activity: self.is_indirect_activity.unwrap_or_default(),
                organization_id: self.organization_id,
                initiator: self.initiator,
                participants: self.participants,
                resource_metadata: self.resource_metadata,
                original_parent: self.original_parent,
                comment_metadata: self.comment_metadata,
            }
        }
    }
}
impl Activity {
    /// Creates a new builder-style object to manufacture [`Activity`](crate::model::Activity)
    pub fn builder() -> crate::model::activity::Builder {
        crate::model::activity::Builder::default()
    }
}

/// <p>Describes the metadata of a comment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommentMetadata {
    /// <p>The ID of the comment.</p>
    pub comment_id: std::option::Option<std::string::String>,
    /// <p>The user who made the comment.</p>
    pub contributor: std::option::Option<crate::model::User>,
    /// <p>The timestamp that the comment was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the comment.</p>
    pub comment_status: std::option::Option<crate::model::CommentStatusType>,
    /// <p>The ID of the user being replied to.</p>
    pub recipient_id: std::option::Option<std::string::String>,
}
impl CommentMetadata {
    /// <p>The ID of the comment.</p>
    pub fn comment_id(&self) -> std::option::Option<&str> {
        self.comment_id.as_deref()
    }
    /// <p>The user who made the comment.</p>
    pub fn contributor(&self) -> std::option::Option<&crate::model::User> {
        self.contributor.as_ref()
    }
    /// <p>The timestamp that the comment was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The status of the comment.</p>
    pub fn comment_status(&self) -> std::option::Option<&crate::model::CommentStatusType> {
        self.comment_status.as_ref()
    }
    /// <p>The ID of the user being replied to.</p>
    pub fn recipient_id(&self) -> std::option::Option<&str> {
        self.recipient_id.as_deref()
    }
}
impl std::fmt::Debug for CommentMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommentMetadata");
        formatter.field("comment_id", &self.comment_id);
        formatter.field("contributor", &self.contributor);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("comment_status", &self.comment_status);
        formatter.field("recipient_id", &self.recipient_id);
        formatter.finish()
    }
}
/// See [`CommentMetadata`](crate::model::CommentMetadata)
pub mod comment_metadata {
    /// A builder for [`CommentMetadata`](crate::model::CommentMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment_id: std::option::Option<std::string::String>,
        pub(crate) contributor: std::option::Option<crate::model::User>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) comment_status: std::option::Option<crate::model::CommentStatusType>,
        pub(crate) recipient_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the comment.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_id = Some(input.into());
            self
        }
        /// <p>The ID of the comment.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_id = input;
            self
        }
        /// <p>The user who made the comment.</p>
        pub fn contributor(mut self, input: crate::model::User) -> Self {
            self.contributor = Some(input);
            self
        }
        /// <p>The user who made the comment.</p>
        pub fn set_contributor(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.contributor = input;
            self
        }
        /// <p>The timestamp that the comment was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The timestamp that the comment was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The status of the comment.</p>
        pub fn comment_status(mut self, input: crate::model::CommentStatusType) -> Self {
            self.comment_status = Some(input);
            self
        }
        /// <p>The status of the comment.</p>
        pub fn set_comment_status(
            mut self,
            input: std::option::Option<crate::model::CommentStatusType>,
        ) -> Self {
            self.comment_status = input;
            self
        }
        /// <p>The ID of the user being replied to.</p>
        pub fn recipient_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipient_id = Some(input.into());
            self
        }
        /// <p>The ID of the user being replied to.</p>
        pub fn set_recipient_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipient_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CommentMetadata`](crate::model::CommentMetadata)
        pub fn build(self) -> crate::model::CommentMetadata {
            crate::model::CommentMetadata {
                comment_id: self.comment_id,
                contributor: self.contributor,
                created_timestamp: self.created_timestamp,
                comment_status: self.comment_status,
                recipient_id: self.recipient_id,
            }
        }
    }
}
impl CommentMetadata {
    /// Creates a new builder-style object to manufacture [`CommentMetadata`](crate::model::CommentMetadata)
    pub fn builder() -> crate::model::comment_metadata::Builder {
        crate::model::comment_metadata::Builder::default()
    }
}

/// <p>Describes the metadata of a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceMetadata {
    /// <p>The type of resource.</p>
    pub r#type: std::option::Option<crate::model::ResourceType>,
    /// <p>The name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The original name of the resource before a rename operation.</p>
    pub original_name: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version ID of the resource. This is an optional field and is filled for action
    /// on document version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The owner of the resource.</p>
    pub owner: std::option::Option<crate::model::UserMetadata>,
    /// <p>The parent ID of the resource before a rename operation.</p>
    pub parent_id: std::option::Option<std::string::String>,
}
impl ResourceMetadata {
    /// <p>The type of resource.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The original name of the resource before a rename operation.</p>
    pub fn original_name(&self) -> std::option::Option<&str> {
        self.original_name.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version ID of the resource. This is an optional field and is filled for action
    /// on document version.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The owner of the resource.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::UserMetadata> {
        self.owner.as_ref()
    }
    /// <p>The parent ID of the resource before a rename operation.</p>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceMetadata");
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("original_name", &self.original_name);
        formatter.field("id", &self.id);
        formatter.field("version_id", &self.version_id);
        formatter.field("owner", &self.owner);
        formatter.field("parent_id", &self.parent_id);
        formatter.finish()
    }
}
/// See [`ResourceMetadata`](crate::model::ResourceMetadata)
pub mod resource_metadata {
    /// A builder for [`ResourceMetadata`](crate::model::ResourceMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ResourceType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) original_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<crate::model::UserMetadata>,
        pub(crate) parent_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of resource.</p>
        pub fn r#type(mut self, input: crate::model::ResourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ResourceType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The original name of the resource before a rename operation.</p>
        pub fn original_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.original_name = Some(input.into());
            self
        }
        /// <p>The original name of the resource before a rename operation.</p>
        pub fn set_original_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.original_name = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version ID of the resource. This is an optional field and is filled for action
        /// on document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the resource. This is an optional field and is filled for action
        /// on document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The owner of the resource.</p>
        pub fn owner(mut self, input: crate::model::UserMetadata) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>The owner of the resource.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::UserMetadata>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The parent ID of the resource before a rename operation.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The parent ID of the resource before a rename operation.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceMetadata`](crate::model::ResourceMetadata)
        pub fn build(self) -> crate::model::ResourceMetadata {
            crate::model::ResourceMetadata {
                r#type: self.r#type,
                name: self.name,
                original_name: self.original_name,
                id: self.id,
                version_id: self.version_id,
                owner: self.owner,
                parent_id: self.parent_id,
            }
        }
    }
}
impl ResourceMetadata {
    /// Creates a new builder-style object to manufacture [`ResourceMetadata`](crate::model::ResourceMetadata)
    pub fn builder() -> crate::model::resource_metadata::Builder {
        crate::model::resource_metadata::Builder::default()
    }
}

/// <p>Describes the metadata of the user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserMetadata {
    /// <p>The ID of the user.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the user.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The given name of the user before a rename operation.</p>
    pub given_name: std::option::Option<std::string::String>,
    /// <p>The surname of the user.</p>
    pub surname: std::option::Option<std::string::String>,
    /// <p>The email address of the user.</p>
    pub email_address: std::option::Option<std::string::String>,
}
impl UserMetadata {
    /// <p>The ID of the user.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the user.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The given name of the user before a rename operation.</p>
    pub fn given_name(&self) -> std::option::Option<&str> {
        self.given_name.as_deref()
    }
    /// <p>The surname of the user.</p>
    pub fn surname(&self) -> std::option::Option<&str> {
        self.surname.as_deref()
    }
    /// <p>The email address of the user.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl std::fmt::Debug for UserMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserMetadata");
        formatter.field("id", &self.id);
        formatter.field("username", &self.username);
        formatter.field("given_name", &self.given_name);
        formatter.field("surname", &self.surname);
        formatter.field("email_address", &self.email_address);
        formatter.finish()
    }
}
/// See [`UserMetadata`](crate::model::UserMetadata)
pub mod user_metadata {
    /// A builder for [`UserMetadata`](crate::model::UserMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) given_name: std::option::Option<std::string::String>,
        pub(crate) surname: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The given name of the user before a rename operation.</p>
        pub fn given_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.given_name = Some(input.into());
            self
        }
        /// <p>The given name of the user before a rename operation.</p>
        pub fn set_given_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.given_name = input;
            self
        }
        /// <p>The surname of the user.</p>
        pub fn surname(mut self, input: impl Into<std::string::String>) -> Self {
            self.surname = Some(input.into());
            self
        }
        /// <p>The surname of the user.</p>
        pub fn set_surname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.surname = input;
            self
        }
        /// <p>The email address of the user.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address of the user.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Consumes the builder and constructs a [`UserMetadata`](crate::model::UserMetadata)
        pub fn build(self) -> crate::model::UserMetadata {
            crate::model::UserMetadata {
                id: self.id,
                username: self.username,
                given_name: self.given_name,
                surname: self.surname,
                email_address: self.email_address,
            }
        }
    }
}
impl UserMetadata {
    /// Creates a new builder-style object to manufacture [`UserMetadata`](crate::model::UserMetadata)
    pub fn builder() -> crate::model::user_metadata::Builder {
        crate::model::user_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Document,
    #[allow(missing_docs)] // documentation missing in model
    Folder,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "DOCUMENT" => ResourceType::Document,
            "FOLDER" => ResourceType::Folder,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Document => "DOCUMENT",
            ResourceType::Folder => "FOLDER",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DOCUMENT", "FOLDER"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the users or user groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Participants {
    /// <p>The list of users.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::UserMetadata>>,
    /// <p>The list of user groups.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::GroupMetadata>>,
}
impl Participants {
    /// <p>The list of users.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::UserMetadata]> {
        self.users.as_deref()
    }
    /// <p>The list of user groups.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::GroupMetadata]> {
        self.groups.as_deref()
    }
}
impl std::fmt::Debug for Participants {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Participants");
        formatter.field("users", &self.users);
        formatter.field("groups", &self.groups);
        formatter.finish()
    }
}
/// See [`Participants`](crate::model::Participants)
pub mod participants {
    /// A builder for [`Participants`](crate::model::Participants)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::UserMetadata>>,
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::GroupMetadata>>,
    }
    impl Builder {
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>The list of users.</p>
        pub fn users(mut self, input: impl Into<crate::model::UserMetadata>) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input.into());
            self.users = Some(v);
            self
        }
        /// <p>The list of users.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserMetadata>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of user groups.</p>
        pub fn groups(mut self, input: impl Into<crate::model::GroupMetadata>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The list of user groups.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupMetadata>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// Consumes the builder and constructs a [`Participants`](crate::model::Participants)
        pub fn build(self) -> crate::model::Participants {
            crate::model::Participants {
                users: self.users,
                groups: self.groups,
            }
        }
    }
}
impl Participants {
    /// Creates a new builder-style object to manufacture [`Participants`](crate::model::Participants)
    pub fn builder() -> crate::model::participants::Builder {
        crate::model::participants::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActivityType {
    #[allow(missing_docs)] // documentation missing in model
    DocumentAnnotationAdded,
    #[allow(missing_docs)] // documentation missing in model
    DocumentAnnotationDeleted,
    #[allow(missing_docs)] // documentation missing in model
    DocumentCheckedIn,
    #[allow(missing_docs)] // documentation missing in model
    DocumentCheckedOut,
    #[allow(missing_docs)] // documentation missing in model
    DocumentCommentAdded,
    #[allow(missing_docs)] // documentation missing in model
    DocumentCommentDeleted,
    #[allow(missing_docs)] // documentation missing in model
    DocumentMoved,
    #[allow(missing_docs)] // documentation missing in model
    DocumentRecycled,
    #[allow(missing_docs)] // documentation missing in model
    DocumentRenamed,
    #[allow(missing_docs)] // documentation missing in model
    DocumentRestored,
    #[allow(missing_docs)] // documentation missing in model
    DocumentReverted,
    #[allow(missing_docs)] // documentation missing in model
    DocumentShareableLinkCreated,
    #[allow(missing_docs)] // documentation missing in model
    DocumentShareableLinkPermissionChanged,
    #[allow(missing_docs)] // documentation missing in model
    DocumentShareableLinkRemoved,
    #[allow(missing_docs)] // documentation missing in model
    DocumentShared,
    #[allow(missing_docs)] // documentation missing in model
    DocumentSharePermissionChanged,
    #[allow(missing_docs)] // documentation missing in model
    DocumentUnshared,
    #[allow(missing_docs)] // documentation missing in model
    DocumentVersionDeleted,
    #[allow(missing_docs)] // documentation missing in model
    DocumentVersionDownloaded,
    #[allow(missing_docs)] // documentation missing in model
    DocumentVersionUploaded,
    #[allow(missing_docs)] // documentation missing in model
    DocumentVersionViewed,
    #[allow(missing_docs)] // documentation missing in model
    FolderCreated,
    #[allow(missing_docs)] // documentation missing in model
    FolderDeleted,
    #[allow(missing_docs)] // documentation missing in model
    FolderMoved,
    #[allow(missing_docs)] // documentation missing in model
    FolderRecycled,
    #[allow(missing_docs)] // documentation missing in model
    FolderRenamed,
    #[allow(missing_docs)] // documentation missing in model
    FolderRestored,
    #[allow(missing_docs)] // documentation missing in model
    FolderShareableLinkCreated,
    #[allow(missing_docs)] // documentation missing in model
    FolderShareableLinkPermissionChanged,
    #[allow(missing_docs)] // documentation missing in model
    FolderShareableLinkRemoved,
    #[allow(missing_docs)] // documentation missing in model
    FolderShared,
    #[allow(missing_docs)] // documentation missing in model
    FolderSharePermissionChanged,
    #[allow(missing_docs)] // documentation missing in model
    FolderUnshared,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActivityType {
    fn from(s: &str) -> Self {
        match s {
            "DOCUMENT_ANNOTATION_ADDED" => ActivityType::DocumentAnnotationAdded,
            "DOCUMENT_ANNOTATION_DELETED" => ActivityType::DocumentAnnotationDeleted,
            "DOCUMENT_CHECKED_IN" => ActivityType::DocumentCheckedIn,
            "DOCUMENT_CHECKED_OUT" => ActivityType::DocumentCheckedOut,
            "DOCUMENT_COMMENT_ADDED" => ActivityType::DocumentCommentAdded,
            "DOCUMENT_COMMENT_DELETED" => ActivityType::DocumentCommentDeleted,
            "DOCUMENT_MOVED" => ActivityType::DocumentMoved,
            "DOCUMENT_RECYCLED" => ActivityType::DocumentRecycled,
            "DOCUMENT_RENAMED" => ActivityType::DocumentRenamed,
            "DOCUMENT_RESTORED" => ActivityType::DocumentRestored,
            "DOCUMENT_REVERTED" => ActivityType::DocumentReverted,
            "DOCUMENT_SHAREABLE_LINK_CREATED" => ActivityType::DocumentShareableLinkCreated,
            "DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED" => {
                ActivityType::DocumentShareableLinkPermissionChanged
            }
            "DOCUMENT_SHAREABLE_LINK_REMOVED" => ActivityType::DocumentShareableLinkRemoved,
            "DOCUMENT_SHARED" => ActivityType::DocumentShared,
            "DOCUMENT_SHARE_PERMISSION_CHANGED" => ActivityType::DocumentSharePermissionChanged,
            "DOCUMENT_UNSHARED" => ActivityType::DocumentUnshared,
            "DOCUMENT_VERSION_DELETED" => ActivityType::DocumentVersionDeleted,
            "DOCUMENT_VERSION_DOWNLOADED" => ActivityType::DocumentVersionDownloaded,
            "DOCUMENT_VERSION_UPLOADED" => ActivityType::DocumentVersionUploaded,
            "DOCUMENT_VERSION_VIEWED" => ActivityType::DocumentVersionViewed,
            "FOLDER_CREATED" => ActivityType::FolderCreated,
            "FOLDER_DELETED" => ActivityType::FolderDeleted,
            "FOLDER_MOVED" => ActivityType::FolderMoved,
            "FOLDER_RECYCLED" => ActivityType::FolderRecycled,
            "FOLDER_RENAMED" => ActivityType::FolderRenamed,
            "FOLDER_RESTORED" => ActivityType::FolderRestored,
            "FOLDER_SHAREABLE_LINK_CREATED" => ActivityType::FolderShareableLinkCreated,
            "FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED" => {
                ActivityType::FolderShareableLinkPermissionChanged
            }
            "FOLDER_SHAREABLE_LINK_REMOVED" => ActivityType::FolderShareableLinkRemoved,
            "FOLDER_SHARED" => ActivityType::FolderShared,
            "FOLDER_SHARE_PERMISSION_CHANGED" => ActivityType::FolderSharePermissionChanged,
            "FOLDER_UNSHARED" => ActivityType::FolderUnshared,
            other => ActivityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActivityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActivityType::from(s))
    }
}
impl ActivityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActivityType::DocumentAnnotationAdded => "DOCUMENT_ANNOTATION_ADDED",
            ActivityType::DocumentAnnotationDeleted => "DOCUMENT_ANNOTATION_DELETED",
            ActivityType::DocumentCheckedIn => "DOCUMENT_CHECKED_IN",
            ActivityType::DocumentCheckedOut => "DOCUMENT_CHECKED_OUT",
            ActivityType::DocumentCommentAdded => "DOCUMENT_COMMENT_ADDED",
            ActivityType::DocumentCommentDeleted => "DOCUMENT_COMMENT_DELETED",
            ActivityType::DocumentMoved => "DOCUMENT_MOVED",
            ActivityType::DocumentRecycled => "DOCUMENT_RECYCLED",
            ActivityType::DocumentRenamed => "DOCUMENT_RENAMED",
            ActivityType::DocumentRestored => "DOCUMENT_RESTORED",
            ActivityType::DocumentReverted => "DOCUMENT_REVERTED",
            ActivityType::DocumentShareableLinkCreated => "DOCUMENT_SHAREABLE_LINK_CREATED",
            ActivityType::DocumentShareableLinkPermissionChanged => {
                "DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED"
            }
            ActivityType::DocumentShareableLinkRemoved => "DOCUMENT_SHAREABLE_LINK_REMOVED",
            ActivityType::DocumentShared => "DOCUMENT_SHARED",
            ActivityType::DocumentSharePermissionChanged => "DOCUMENT_SHARE_PERMISSION_CHANGED",
            ActivityType::DocumentUnshared => "DOCUMENT_UNSHARED",
            ActivityType::DocumentVersionDeleted => "DOCUMENT_VERSION_DELETED",
            ActivityType::DocumentVersionDownloaded => "DOCUMENT_VERSION_DOWNLOADED",
            ActivityType::DocumentVersionUploaded => "DOCUMENT_VERSION_UPLOADED",
            ActivityType::DocumentVersionViewed => "DOCUMENT_VERSION_VIEWED",
            ActivityType::FolderCreated => "FOLDER_CREATED",
            ActivityType::FolderDeleted => "FOLDER_DELETED",
            ActivityType::FolderMoved => "FOLDER_MOVED",
            ActivityType::FolderRecycled => "FOLDER_RECYCLED",
            ActivityType::FolderRenamed => "FOLDER_RENAMED",
            ActivityType::FolderRestored => "FOLDER_RESTORED",
            ActivityType::FolderShareableLinkCreated => "FOLDER_SHAREABLE_LINK_CREATED",
            ActivityType::FolderShareableLinkPermissionChanged => {
                "FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED"
            }
            ActivityType::FolderShareableLinkRemoved => "FOLDER_SHAREABLE_LINK_REMOVED",
            ActivityType::FolderShared => "FOLDER_SHARED",
            ActivityType::FolderSharePermissionChanged => "FOLDER_SHARE_PERMISSION_CHANGED",
            ActivityType::FolderUnshared => "FOLDER_UNSHARED",
            ActivityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DOCUMENT_ANNOTATION_ADDED",
            "DOCUMENT_ANNOTATION_DELETED",
            "DOCUMENT_CHECKED_IN",
            "DOCUMENT_CHECKED_OUT",
            "DOCUMENT_COMMENT_ADDED",
            "DOCUMENT_COMMENT_DELETED",
            "DOCUMENT_MOVED",
            "DOCUMENT_RECYCLED",
            "DOCUMENT_RENAMED",
            "DOCUMENT_RESTORED",
            "DOCUMENT_REVERTED",
            "DOCUMENT_SHAREABLE_LINK_CREATED",
            "DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED",
            "DOCUMENT_SHAREABLE_LINK_REMOVED",
            "DOCUMENT_SHARED",
            "DOCUMENT_SHARE_PERMISSION_CHANGED",
            "DOCUMENT_UNSHARED",
            "DOCUMENT_VERSION_DELETED",
            "DOCUMENT_VERSION_DOWNLOADED",
            "DOCUMENT_VERSION_UPLOADED",
            "DOCUMENT_VERSION_VIEWED",
            "FOLDER_CREATED",
            "FOLDER_DELETED",
            "FOLDER_MOVED",
            "FOLDER_RECYCLED",
            "FOLDER_RENAMED",
            "FOLDER_RESTORED",
            "FOLDER_SHAREABLE_LINK_CREATED",
            "FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED",
            "FOLDER_SHAREABLE_LINK_REMOVED",
            "FOLDER_SHARED",
            "FOLDER_SHARE_PERMISSION_CHANGED",
            "FOLDER_UNSHARED",
        ]
    }
}
impl AsRef<str> for ActivityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SubscriptionType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SubscriptionType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => SubscriptionType::All,
            other => SubscriptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SubscriptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SubscriptionType::from(s))
    }
}
impl SubscriptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SubscriptionType::All => "ALL",
            SubscriptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL"]
    }
}
impl AsRef<str> for SubscriptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the share results of a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShareResult {
    /// <p>The ID of the principal.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The ID of the invited user.</p>
    pub invitee_principal_id: std::option::Option<std::string::String>,
    /// <p>The role.</p>
    pub role: std::option::Option<crate::model::RoleType>,
    /// <p>The status.</p>
    pub status: std::option::Option<crate::model::ShareStatusType>,
    /// <p>The ID of the resource that was shared.</p>
    pub share_id: std::option::Option<std::string::String>,
    /// <p>The status message.</p>
    pub status_message: std::option::Option<std::string::String>,
}
impl ShareResult {
    /// <p>The ID of the principal.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The ID of the invited user.</p>
    pub fn invitee_principal_id(&self) -> std::option::Option<&str> {
        self.invitee_principal_id.as_deref()
    }
    /// <p>The role.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::RoleType> {
        self.role.as_ref()
    }
    /// <p>The status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ShareStatusType> {
        self.status.as_ref()
    }
    /// <p>The ID of the resource that was shared.</p>
    pub fn share_id(&self) -> std::option::Option<&str> {
        self.share_id.as_deref()
    }
    /// <p>The status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
}
impl std::fmt::Debug for ShareResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShareResult");
        formatter.field("principal_id", &self.principal_id);
        formatter.field("invitee_principal_id", &self.invitee_principal_id);
        formatter.field("role", &self.role);
        formatter.field("status", &self.status);
        formatter.field("share_id", &self.share_id);
        formatter.field("status_message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ShareResult`](crate::model::ShareResult)
pub mod share_result {
    /// A builder for [`ShareResult`](crate::model::ShareResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) invitee_principal_id: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<crate::model::RoleType>,
        pub(crate) status: std::option::Option<crate::model::ShareStatusType>,
        pub(crate) share_id: std::option::Option<std::string::String>,
        pub(crate) status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the principal.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The ID of the principal.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The ID of the invited user.</p>
        pub fn invitee_principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitee_principal_id = Some(input.into());
            self
        }
        /// <p>The ID of the invited user.</p>
        pub fn set_invitee_principal_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitee_principal_id = input;
            self
        }
        /// <p>The role.</p>
        pub fn role(mut self, input: crate::model::RoleType) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>The role.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::RoleType>) -> Self {
            self.role = input;
            self
        }
        /// <p>The status.</p>
        pub fn status(mut self, input: crate::model::ShareStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ShareStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of the resource that was shared.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that was shared.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_id = input;
            self
        }
        /// <p>The status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ShareResult`](crate::model::ShareResult)
        pub fn build(self) -> crate::model::ShareResult {
            crate::model::ShareResult {
                principal_id: self.principal_id,
                invitee_principal_id: self.invitee_principal_id,
                role: self.role,
                status: self.status,
                share_id: self.share_id,
                status_message: self.status_message,
            }
        }
    }
}
impl ShareResult {
    /// Creates a new builder-style object to manufacture [`ShareResult`](crate::model::ShareResult)
    pub fn builder() -> crate::model::share_result::Builder {
        crate::model::share_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Failure,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareStatusType {
    fn from(s: &str) -> Self {
        match s {
            "FAILURE" => ShareStatusType::Failure,
            "SUCCESS" => ShareStatusType::Success,
            other => ShareStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareStatusType::from(s))
    }
}
impl ShareStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareStatusType::Failure => "FAILURE",
            ShareStatusType::Success => "SUCCESS",
            ShareStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILURE", "SUCCESS"]
    }
}
impl AsRef<str> for ShareStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Set of options which defines notification preferences of given action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationOptions {
    /// <p>Boolean value to indicate an email notification should be sent to the
    /// receipients.</p>
    pub send_email: bool,
    /// <p>Text value to be included in the email body.</p>
    pub email_message: std::option::Option<std::string::String>,
}
impl NotificationOptions {
    /// <p>Boolean value to indicate an email notification should be sent to the
    /// receipients.</p>
    pub fn send_email(&self) -> bool {
        self.send_email
    }
    /// <p>Text value to be included in the email body.</p>
    pub fn email_message(&self) -> std::option::Option<&str> {
        self.email_message.as_deref()
    }
}
impl std::fmt::Debug for NotificationOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationOptions");
        formatter.field("send_email", &self.send_email);
        formatter.field("email_message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`NotificationOptions`](crate::model::NotificationOptions)
pub mod notification_options {
    /// A builder for [`NotificationOptions`](crate::model::NotificationOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) send_email: std::option::Option<bool>,
        pub(crate) email_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Boolean value to indicate an email notification should be sent to the
        /// receipients.</p>
        pub fn send_email(mut self, input: bool) -> Self {
            self.send_email = Some(input);
            self
        }
        /// <p>Boolean value to indicate an email notification should be sent to the
        /// receipients.</p>
        pub fn set_send_email(mut self, input: std::option::Option<bool>) -> Self {
            self.send_email = input;
            self
        }
        /// <p>Text value to be included in the email body.</p>
        pub fn email_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_message = Some(input.into());
            self
        }
        /// <p>Text value to be included in the email body.</p>
        pub fn set_email_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationOptions`](crate::model::NotificationOptions)
        pub fn build(self) -> crate::model::NotificationOptions {
            crate::model::NotificationOptions {
                send_email: self.send_email.unwrap_or_default(),
                email_message: self.email_message,
            }
        }
    }
}
impl NotificationOptions {
    /// Creates a new builder-style object to manufacture [`NotificationOptions`](crate::model::NotificationOptions)
    pub fn builder() -> crate::model::notification_options::Builder {
        crate::model::notification_options::Builder::default()
    }
}

/// <p>Describes the recipient type and ID, if available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SharePrincipal {
    /// <p>The ID of the recipient.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of the recipient.</p>
    pub r#type: std::option::Option<crate::model::PrincipalType>,
    /// <p>The role of the recipient.</p>
    pub role: std::option::Option<crate::model::RoleType>,
}
impl SharePrincipal {
    /// <p>The ID of the recipient.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of the recipient.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PrincipalType> {
        self.r#type.as_ref()
    }
    /// <p>The role of the recipient.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::RoleType> {
        self.role.as_ref()
    }
}
impl std::fmt::Debug for SharePrincipal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SharePrincipal");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("role", &self.role);
        formatter.finish()
    }
}
/// See [`SharePrincipal`](crate::model::SharePrincipal)
pub mod share_principal {
    /// A builder for [`SharePrincipal`](crate::model::SharePrincipal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PrincipalType>,
        pub(crate) role: std::option::Option<crate::model::RoleType>,
    }
    impl Builder {
        /// <p>The ID of the recipient.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the recipient.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of the recipient.</p>
        pub fn r#type(mut self, input: crate::model::PrincipalType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the recipient.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PrincipalType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The role of the recipient.</p>
        pub fn role(mut self, input: crate::model::RoleType) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>The role of the recipient.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::RoleType>) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`SharePrincipal`](crate::model::SharePrincipal)
        pub fn build(self) -> crate::model::SharePrincipal {
            crate::model::SharePrincipal {
                id: self.id,
                r#type: self.r#type,
                role: self.role,
            }
        }
    }
}
impl SharePrincipal {
    /// Creates a new builder-style object to manufacture [`SharePrincipal`](crate::model::SharePrincipal)
    pub fn builder() -> crate::model::share_principal::Builder {
        crate::model::share_principal::Builder::default()
    }
}
