// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserOutput {
    /// <p>The user information.</p>
    pub user: std::option::Option<crate::model::User>,
}
impl std::fmt::Debug for UpdateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserOutput");
        formatter.field("user", &self.user);
        formatter.finish()
    }
}
/// See [`UpdateUserOutput`](crate::output::UpdateUserOutput)
pub mod update_user_output {
    /// A builder for [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::User>,
    }
    impl Builder {
        /// <p>The user information.</p>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>The user information.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserOutput`](crate::output::UpdateUserOutput)
        pub fn build(self) -> crate::output::UpdateUserOutput {
            crate::output::UpdateUserOutput { user: self.user }
        }
    }
}
impl UpdateUserOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    pub fn builder() -> crate::output::update_user_output::Builder {
        crate::output::update_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFolderOutput {}
impl std::fmt::Debug for UpdateFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFolderOutput");
        formatter.finish()
    }
}
/// See [`UpdateFolderOutput`](crate::output::UpdateFolderOutput)
pub mod update_folder_output {
    /// A builder for [`UpdateFolderOutput`](crate::output::UpdateFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateFolderOutput`](crate::output::UpdateFolderOutput)
        pub fn build(self) -> crate::output::UpdateFolderOutput {
            crate::output::UpdateFolderOutput {}
        }
    }
}
impl UpdateFolderOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFolderOutput`](crate::output::UpdateFolderOutput)
    pub fn builder() -> crate::output::update_folder_output::Builder {
        crate::output::update_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentVersionOutput {}
impl std::fmt::Debug for UpdateDocumentVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentVersionOutput");
        formatter.finish()
    }
}
/// See [`UpdateDocumentVersionOutput`](crate::output::UpdateDocumentVersionOutput)
pub mod update_document_version_output {
    /// A builder for [`UpdateDocumentVersionOutput`](crate::output::UpdateDocumentVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDocumentVersionOutput`](crate::output::UpdateDocumentVersionOutput)
        pub fn build(self) -> crate::output::UpdateDocumentVersionOutput {
            crate::output::UpdateDocumentVersionOutput {}
        }
    }
}
impl UpdateDocumentVersionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentVersionOutput`](crate::output::UpdateDocumentVersionOutput)
    pub fn builder() -> crate::output::update_document_version_output::Builder {
        crate::output::update_document_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentOutput {}
impl std::fmt::Debug for UpdateDocumentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentOutput");
        formatter.finish()
    }
}
/// See [`UpdateDocumentOutput`](crate::output::UpdateDocumentOutput)
pub mod update_document_output {
    /// A builder for [`UpdateDocumentOutput`](crate::output::UpdateDocumentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDocumentOutput`](crate::output::UpdateDocumentOutput)
        pub fn build(self) -> crate::output::UpdateDocumentOutput {
            crate::output::UpdateDocumentOutput {}
        }
    }
}
impl UpdateDocumentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentOutput`](crate::output::UpdateDocumentOutput)
    pub fn builder() -> crate::output::update_document_output::Builder {
        crate::output::update_document_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveResourcePermissionOutput {}
impl std::fmt::Debug for RemoveResourcePermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveResourcePermissionOutput");
        formatter.finish()
    }
}
/// See [`RemoveResourcePermissionOutput`](crate::output::RemoveResourcePermissionOutput)
pub mod remove_resource_permission_output {
    /// A builder for [`RemoveResourcePermissionOutput`](crate::output::RemoveResourcePermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveResourcePermissionOutput`](crate::output::RemoveResourcePermissionOutput)
        pub fn build(self) -> crate::output::RemoveResourcePermissionOutput {
            crate::output::RemoveResourcePermissionOutput {}
        }
    }
}
impl RemoveResourcePermissionOutput {
    /// Creates a new builder-style object to manufacture [`RemoveResourcePermissionOutput`](crate::output::RemoveResourcePermissionOutput)
    pub fn builder() -> crate::output::remove_resource_permission_output::Builder {
        crate::output::remove_resource_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAllResourcePermissionsOutput {}
impl std::fmt::Debug for RemoveAllResourcePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAllResourcePermissionsOutput");
        formatter.finish()
    }
}
/// See [`RemoveAllResourcePermissionsOutput`](crate::output::RemoveAllResourcePermissionsOutput)
pub mod remove_all_resource_permissions_output {
    /// A builder for [`RemoveAllResourcePermissionsOutput`](crate::output::RemoveAllResourcePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveAllResourcePermissionsOutput`](crate::output::RemoveAllResourcePermissionsOutput)
        pub fn build(self) -> crate::output::RemoveAllResourcePermissionsOutput {
            crate::output::RemoveAllResourcePermissionsOutput {}
        }
    }
}
impl RemoveAllResourcePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`RemoveAllResourcePermissionsOutput`](crate::output::RemoveAllResourcePermissionsOutput)
    pub fn builder() -> crate::output::remove_all_resource_permissions_output::Builder {
        crate::output::remove_all_resource_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateDocumentVersionUploadOutput {
    /// <p>The document metadata.</p>
    pub metadata: std::option::Option<crate::model::DocumentMetadata>,
    /// <p>The upload metadata.</p>
    pub upload_metadata: std::option::Option<crate::model::UploadMetadata>,
}
impl std::fmt::Debug for InitiateDocumentVersionUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateDocumentVersionUploadOutput");
        formatter.field("metadata", &self.metadata);
        formatter.field("upload_metadata", &self.upload_metadata);
        formatter.finish()
    }
}
/// See [`InitiateDocumentVersionUploadOutput`](crate::output::InitiateDocumentVersionUploadOutput)
pub mod initiate_document_version_upload_output {
    /// A builder for [`InitiateDocumentVersionUploadOutput`](crate::output::InitiateDocumentVersionUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata: std::option::Option<crate::model::DocumentMetadata>,
        pub(crate) upload_metadata: std::option::Option<crate::model::UploadMetadata>,
    }
    impl Builder {
        /// <p>The document metadata.</p>
        pub fn metadata(mut self, input: crate::model::DocumentMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The document metadata.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The upload metadata.</p>
        pub fn upload_metadata(mut self, input: crate::model::UploadMetadata) -> Self {
            self.upload_metadata = Some(input);
            self
        }
        /// <p>The upload metadata.</p>
        pub fn set_upload_metadata(
            mut self,
            input: std::option::Option<crate::model::UploadMetadata>,
        ) -> Self {
            self.upload_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateDocumentVersionUploadOutput`](crate::output::InitiateDocumentVersionUploadOutput)
        pub fn build(self) -> crate::output::InitiateDocumentVersionUploadOutput {
            crate::output::InitiateDocumentVersionUploadOutput {
                metadata: self.metadata,
                upload_metadata: self.upload_metadata,
            }
        }
    }
}
impl InitiateDocumentVersionUploadOutput {
    /// Creates a new builder-style object to manufacture [`InitiateDocumentVersionUploadOutput`](crate::output::InitiateDocumentVersionUploadOutput)
    pub fn builder() -> crate::output::initiate_document_version_upload_output::Builder {
        crate::output::initiate_document_version_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcesOutput {
    /// <p>The folders in the specified folder.</p>
    pub folders: std::option::Option<std::vec::Vec<crate::model::FolderMetadata>>,
    /// <p>The documents in the specified collection.</p>
    pub documents: std::option::Option<std::vec::Vec<crate::model::DocumentMetadata>>,
    /// <p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcesOutput");
        formatter.field("folders", &self.folders);
        formatter.field("documents", &self.documents);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`GetResourcesOutput`](crate::output::GetResourcesOutput)
pub mod get_resources_output {
    /// A builder for [`GetResourcesOutput`](crate::output::GetResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) folders: std::option::Option<std::vec::Vec<crate::model::FolderMetadata>>,
        pub(crate) documents: std::option::Option<std::vec::Vec<crate::model::DocumentMetadata>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `folders`.
        ///
        /// To override the contents of this collection use [`set_folders`](Self::set_folders).
        ///
        /// <p>The folders in the specified folder.</p>
        pub fn folders(mut self, input: impl Into<crate::model::FolderMetadata>) -> Self {
            let mut v = self.folders.unwrap_or_default();
            v.push(input.into());
            self.folders = Some(v);
            self
        }
        /// <p>The folders in the specified folder.</p>
        pub fn set_folders(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderMetadata>>,
        ) -> Self {
            self.folders = input;
            self
        }
        /// Appends an item to `documents`.
        ///
        /// To override the contents of this collection use [`set_documents`](Self::set_documents).
        ///
        /// <p>The documents in the specified collection.</p>
        pub fn documents(mut self, input: impl Into<crate::model::DocumentMetadata>) -> Self {
            let mut v = self.documents.unwrap_or_default();
            v.push(input.into());
            self.documents = Some(v);
            self
        }
        /// <p>The documents in the specified collection.</p>
        pub fn set_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentMetadata>>,
        ) -> Self {
            self.documents = input;
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcesOutput`](crate::output::GetResourcesOutput)
        pub fn build(self) -> crate::output::GetResourcesOutput {
            crate::output::GetResourcesOutput {
                folders: self.folders,
                documents: self.documents,
                marker: self.marker,
            }
        }
    }
}
impl GetResourcesOutput {
    /// Creates a new builder-style object to manufacture [`GetResourcesOutput`](crate::output::GetResourcesOutput)
    pub fn builder() -> crate::output::get_resources_output::Builder {
        crate::output::get_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFolderPathOutput {
    /// <p>The path information.</p>
    pub path: std::option::Option<crate::model::ResourcePath>,
}
impl std::fmt::Debug for GetFolderPathOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFolderPathOutput");
        formatter.field("path", &self.path);
        formatter.finish()
    }
}
/// See [`GetFolderPathOutput`](crate::output::GetFolderPathOutput)
pub mod get_folder_path_output {
    /// A builder for [`GetFolderPathOutput`](crate::output::GetFolderPathOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<crate::model::ResourcePath>,
    }
    impl Builder {
        /// <p>The path information.</p>
        pub fn path(mut self, input: crate::model::ResourcePath) -> Self {
            self.path = Some(input);
            self
        }
        /// <p>The path information.</p>
        pub fn set_path(mut self, input: std::option::Option<crate::model::ResourcePath>) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFolderPathOutput`](crate::output::GetFolderPathOutput)
        pub fn build(self) -> crate::output::GetFolderPathOutput {
            crate::output::GetFolderPathOutput { path: self.path }
        }
    }
}
impl GetFolderPathOutput {
    /// Creates a new builder-style object to manufacture [`GetFolderPathOutput`](crate::output::GetFolderPathOutput)
    pub fn builder() -> crate::output::get_folder_path_output::Builder {
        crate::output::get_folder_path_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFolderOutput {
    /// <p>The metadata of the folder.</p>
    pub metadata: std::option::Option<crate::model::FolderMetadata>,
    /// <p>The custom metadata on the folder.</p>
    pub custom_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFolderOutput");
        formatter.field("metadata", &self.metadata);
        formatter.field("custom_metadata", &self.custom_metadata);
        formatter.finish()
    }
}
/// See [`GetFolderOutput`](crate::output::GetFolderOutput)
pub mod get_folder_output {
    /// A builder for [`GetFolderOutput`](crate::output::GetFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata: std::option::Option<crate::model::FolderMetadata>,
        pub(crate) custom_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The metadata of the folder.</p>
        pub fn metadata(mut self, input: crate::model::FolderMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The metadata of the folder.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::FolderMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Adds a key-value pair to `custom_metadata`.
        ///
        /// To override the contents of this collection use [`set_custom_metadata`](Self::set_custom_metadata).
        ///
        /// <p>The custom metadata on the folder.</p>
        pub fn custom_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.custom_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.custom_metadata = Some(hash_map);
            self
        }
        /// <p>The custom metadata on the folder.</p>
        pub fn set_custom_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFolderOutput`](crate::output::GetFolderOutput)
        pub fn build(self) -> crate::output::GetFolderOutput {
            crate::output::GetFolderOutput {
                metadata: self.metadata,
                custom_metadata: self.custom_metadata,
            }
        }
    }
}
impl GetFolderOutput {
    /// Creates a new builder-style object to manufacture [`GetFolderOutput`](crate::output::GetFolderOutput)
    pub fn builder() -> crate::output::get_folder_output::Builder {
        crate::output::get_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentVersionOutput {
    /// <p>The version metadata.</p>
    pub metadata: std::option::Option<crate::model::DocumentVersionMetadata>,
    /// <p>The custom metadata on the document version.</p>
    pub custom_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetDocumentVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentVersionOutput");
        formatter.field("metadata", &self.metadata);
        formatter.field("custom_metadata", &self.custom_metadata);
        formatter.finish()
    }
}
/// See [`GetDocumentVersionOutput`](crate::output::GetDocumentVersionOutput)
pub mod get_document_version_output {
    /// A builder for [`GetDocumentVersionOutput`](crate::output::GetDocumentVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata: std::option::Option<crate::model::DocumentVersionMetadata>,
        pub(crate) custom_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The version metadata.</p>
        pub fn metadata(mut self, input: crate::model::DocumentVersionMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The version metadata.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentVersionMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Adds a key-value pair to `custom_metadata`.
        ///
        /// To override the contents of this collection use [`set_custom_metadata`](Self::set_custom_metadata).
        ///
        /// <p>The custom metadata on the document version.</p>
        pub fn custom_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.custom_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.custom_metadata = Some(hash_map);
            self
        }
        /// <p>The custom metadata on the document version.</p>
        pub fn set_custom_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentVersionOutput`](crate::output::GetDocumentVersionOutput)
        pub fn build(self) -> crate::output::GetDocumentVersionOutput {
            crate::output::GetDocumentVersionOutput {
                metadata: self.metadata,
                custom_metadata: self.custom_metadata,
            }
        }
    }
}
impl GetDocumentVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetDocumentVersionOutput`](crate::output::GetDocumentVersionOutput)
    pub fn builder() -> crate::output::get_document_version_output::Builder {
        crate::output::get_document_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentPathOutput {
    /// <p>The path information.</p>
    pub path: std::option::Option<crate::model::ResourcePath>,
}
impl std::fmt::Debug for GetDocumentPathOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentPathOutput");
        formatter.field("path", &self.path);
        formatter.finish()
    }
}
/// See [`GetDocumentPathOutput`](crate::output::GetDocumentPathOutput)
pub mod get_document_path_output {
    /// A builder for [`GetDocumentPathOutput`](crate::output::GetDocumentPathOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<crate::model::ResourcePath>,
    }
    impl Builder {
        /// <p>The path information.</p>
        pub fn path(mut self, input: crate::model::ResourcePath) -> Self {
            self.path = Some(input);
            self
        }
        /// <p>The path information.</p>
        pub fn set_path(mut self, input: std::option::Option<crate::model::ResourcePath>) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentPathOutput`](crate::output::GetDocumentPathOutput)
        pub fn build(self) -> crate::output::GetDocumentPathOutput {
            crate::output::GetDocumentPathOutput { path: self.path }
        }
    }
}
impl GetDocumentPathOutput {
    /// Creates a new builder-style object to manufacture [`GetDocumentPathOutput`](crate::output::GetDocumentPathOutput)
    pub fn builder() -> crate::output::get_document_path_output::Builder {
        crate::output::get_document_path_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentOutput {
    /// <p>The metadata details of the document.</p>
    pub metadata: std::option::Option<crate::model::DocumentMetadata>,
    /// <p>The custom metadata on the document.</p>
    pub custom_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetDocumentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentOutput");
        formatter.field("metadata", &self.metadata);
        formatter.field("custom_metadata", &self.custom_metadata);
        formatter.finish()
    }
}
/// See [`GetDocumentOutput`](crate::output::GetDocumentOutput)
pub mod get_document_output {
    /// A builder for [`GetDocumentOutput`](crate::output::GetDocumentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata: std::option::Option<crate::model::DocumentMetadata>,
        pub(crate) custom_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The metadata details of the document.</p>
        pub fn metadata(mut self, input: crate::model::DocumentMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The metadata details of the document.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Adds a key-value pair to `custom_metadata`.
        ///
        /// To override the contents of this collection use [`set_custom_metadata`](Self::set_custom_metadata).
        ///
        /// <p>The custom metadata on the document.</p>
        pub fn custom_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.custom_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.custom_metadata = Some(hash_map);
            self
        }
        /// <p>The custom metadata on the document.</p>
        pub fn set_custom_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentOutput`](crate::output::GetDocumentOutput)
        pub fn build(self) -> crate::output::GetDocumentOutput {
            crate::output::GetDocumentOutput {
                metadata: self.metadata,
                custom_metadata: self.custom_metadata,
            }
        }
    }
}
impl GetDocumentOutput {
    /// Creates a new builder-style object to manufacture [`GetDocumentOutput`](crate::output::GetDocumentOutput)
    pub fn builder() -> crate::output::get_document_output::Builder {
        crate::output::get_document_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCurrentUserOutput {
    /// <p>Metadata of the user.</p>
    pub user: std::option::Option<crate::model::User>,
}
impl std::fmt::Debug for GetCurrentUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCurrentUserOutput");
        formatter.field("user", &self.user);
        formatter.finish()
    }
}
/// See [`GetCurrentUserOutput`](crate::output::GetCurrentUserOutput)
pub mod get_current_user_output {
    /// A builder for [`GetCurrentUserOutput`](crate::output::GetCurrentUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::User>,
    }
    impl Builder {
        /// <p>Metadata of the user.</p>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>Metadata of the user.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCurrentUserOutput`](crate::output::GetCurrentUserOutput)
        pub fn build(self) -> crate::output::GetCurrentUserOutput {
            crate::output::GetCurrentUserOutput { user: self.user }
        }
    }
}
impl GetCurrentUserOutput {
    /// Creates a new builder-style object to manufacture [`GetCurrentUserOutput`](crate::output::GetCurrentUserOutput)
    pub fn builder() -> crate::output::get_current_user_output::Builder {
        crate::output::get_current_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsersOutput {
    /// <p>The users.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::User>>,
    /// <p>The total number of users included in the results.</p>
    pub total_number_of_users: std::option::Option<i64>,
    /// <p>The marker to use when requesting the next set of results. If there are no
    /// additional results, the string is empty.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeUsersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsersOutput");
        formatter.field("users", &self.users);
        formatter.field("total_number_of_users", &self.total_number_of_users);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
pub mod describe_users_output {
    /// A builder for [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::User>>,
        pub(crate) total_number_of_users: std::option::Option<i64>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>The users.</p>
        pub fn users(mut self, input: impl Into<crate::model::User>) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input.into());
            self.users = Some(v);
            self
        }
        /// <p>The users.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// <p>The total number of users included in the results.</p>
        pub fn total_number_of_users(mut self, input: i64) -> Self {
            self.total_number_of_users = Some(input);
            self
        }
        /// <p>The total number of users included in the results.</p>
        pub fn set_total_number_of_users(mut self, input: std::option::Option<i64>) -> Self {
            self.total_number_of_users = input;
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no
        /// additional results, the string is empty.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no
        /// additional results, the string is empty.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
        pub fn build(self) -> crate::output::DescribeUsersOutput {
            crate::output::DescribeUsersOutput {
                users: self.users,
                total_number_of_users: self.total_number_of_users,
                marker: self.marker,
            }
        }
    }
}
impl DescribeUsersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
    pub fn builder() -> crate::output::describe_users_output::Builder {
        crate::output::describe_users_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRootFoldersOutput {
    /// <p>The user's special folders.</p>
    pub folders: std::option::Option<std::vec::Vec<crate::model::FolderMetadata>>,
    /// <p>The marker for the next set of results.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeRootFoldersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRootFoldersOutput");
        formatter.field("folders", &self.folders);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeRootFoldersOutput`](crate::output::DescribeRootFoldersOutput)
pub mod describe_root_folders_output {
    /// A builder for [`DescribeRootFoldersOutput`](crate::output::DescribeRootFoldersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) folders: std::option::Option<std::vec::Vec<crate::model::FolderMetadata>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `folders`.
        ///
        /// To override the contents of this collection use [`set_folders`](Self::set_folders).
        ///
        /// <p>The user's special folders.</p>
        pub fn folders(mut self, input: impl Into<crate::model::FolderMetadata>) -> Self {
            let mut v = self.folders.unwrap_or_default();
            v.push(input.into());
            self.folders = Some(v);
            self
        }
        /// <p>The user's special folders.</p>
        pub fn set_folders(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderMetadata>>,
        ) -> Self {
            self.folders = input;
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRootFoldersOutput`](crate::output::DescribeRootFoldersOutput)
        pub fn build(self) -> crate::output::DescribeRootFoldersOutput {
            crate::output::DescribeRootFoldersOutput {
                folders: self.folders,
                marker: self.marker,
            }
        }
    }
}
impl DescribeRootFoldersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRootFoldersOutput`](crate::output::DescribeRootFoldersOutput)
    pub fn builder() -> crate::output::describe_root_folders_output::Builder {
        crate::output::describe_root_folders_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourcePermissionsOutput {
    /// <p>The principals.</p>
    pub principals: std::option::Option<std::vec::Vec<crate::model::Principal>>,
    /// <p>The marker to use when requesting the next set of results. If there are no
    /// additional results, the string is empty.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeResourcePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourcePermissionsOutput");
        formatter.field("principals", &self.principals);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeResourcePermissionsOutput`](crate::output::DescribeResourcePermissionsOutput)
pub mod describe_resource_permissions_output {
    /// A builder for [`DescribeResourcePermissionsOutput`](crate::output::DescribeResourcePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principals: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals.</p>
        pub fn principals(mut self, input: impl Into<crate::model::Principal>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The principals.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no
        /// additional results, the string is empty.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no
        /// additional results, the string is empty.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourcePermissionsOutput`](crate::output::DescribeResourcePermissionsOutput)
        pub fn build(self) -> crate::output::DescribeResourcePermissionsOutput {
            crate::output::DescribeResourcePermissionsOutput {
                principals: self.principals,
                marker: self.marker,
            }
        }
    }
}
impl DescribeResourcePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeResourcePermissionsOutput`](crate::output::DescribeResourcePermissionsOutput)
    pub fn builder() -> crate::output::describe_resource_permissions_output::Builder {
        crate::output::describe_resource_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotificationSubscriptionsOutput {
    /// <p>The subscriptions.</p>
    pub subscriptions: std::option::Option<std::vec::Vec<crate::model::Subscription>>,
    /// <p>The marker to use when requesting the next set of results. If there are no
    /// additional results, the string is empty.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeNotificationSubscriptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotificationSubscriptionsOutput");
        formatter.field("subscriptions", &self.subscriptions);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeNotificationSubscriptionsOutput`](crate::output::DescribeNotificationSubscriptionsOutput)
pub mod describe_notification_subscriptions_output {
    /// A builder for [`DescribeNotificationSubscriptionsOutput`](crate::output::DescribeNotificationSubscriptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscriptions: std::option::Option<std::vec::Vec<crate::model::Subscription>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `subscriptions`.
        ///
        /// To override the contents of this collection use [`set_subscriptions`](Self::set_subscriptions).
        ///
        /// <p>The subscriptions.</p>
        pub fn subscriptions(mut self, input: impl Into<crate::model::Subscription>) -> Self {
            let mut v = self.subscriptions.unwrap_or_default();
            v.push(input.into());
            self.subscriptions = Some(v);
            self
        }
        /// <p>The subscriptions.</p>
        pub fn set_subscriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscription>>,
        ) -> Self {
            self.subscriptions = input;
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no
        /// additional results, the string is empty.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no
        /// additional results, the string is empty.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotificationSubscriptionsOutput`](crate::output::DescribeNotificationSubscriptionsOutput)
        pub fn build(self) -> crate::output::DescribeNotificationSubscriptionsOutput {
            crate::output::DescribeNotificationSubscriptionsOutput {
                subscriptions: self.subscriptions,
                marker: self.marker,
            }
        }
    }
}
impl DescribeNotificationSubscriptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNotificationSubscriptionsOutput`](crate::output::DescribeNotificationSubscriptionsOutput)
    pub fn builder() -> crate::output::describe_notification_subscriptions_output::Builder {
        crate::output::describe_notification_subscriptions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGroupsOutput {
    /// <p>The list of groups.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::GroupMetadata>>,
    /// <p>The marker to use when requesting the next set of results. If there are no additional
    /// results, the string is empty.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGroupsOutput");
        formatter.field("groups", &self.groups);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeGroupsOutput`](crate::output::DescribeGroupsOutput)
pub mod describe_groups_output {
    /// A builder for [`DescribeGroupsOutput`](crate::output::DescribeGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::GroupMetadata>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups.</p>
        pub fn groups(mut self, input: impl Into<crate::model::GroupMetadata>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The list of groups.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupMetadata>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no additional
        /// results, the string is empty.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no additional
        /// results, the string is empty.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGroupsOutput`](crate::output::DescribeGroupsOutput)
        pub fn build(self) -> crate::output::DescribeGroupsOutput {
            crate::output::DescribeGroupsOutput {
                groups: self.groups,
                marker: self.marker,
            }
        }
    }
}
impl DescribeGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGroupsOutput`](crate::output::DescribeGroupsOutput)
    pub fn builder() -> crate::output::describe_groups_output::Builder {
        crate::output::describe_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFolderContentsOutput {
    /// <p>The subfolders in the specified folder.</p>
    pub folders: std::option::Option<std::vec::Vec<crate::model::FolderMetadata>>,
    /// <p>The documents in the specified folder.</p>
    pub documents: std::option::Option<std::vec::Vec<crate::model::DocumentMetadata>>,
    /// <p>The marker to use when requesting the next set of results. If there are no
    /// additional results, the string is empty.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeFolderContentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFolderContentsOutput");
        formatter.field("folders", &self.folders);
        formatter.field("documents", &self.documents);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeFolderContentsOutput`](crate::output::DescribeFolderContentsOutput)
pub mod describe_folder_contents_output {
    /// A builder for [`DescribeFolderContentsOutput`](crate::output::DescribeFolderContentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) folders: std::option::Option<std::vec::Vec<crate::model::FolderMetadata>>,
        pub(crate) documents: std::option::Option<std::vec::Vec<crate::model::DocumentMetadata>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `folders`.
        ///
        /// To override the contents of this collection use [`set_folders`](Self::set_folders).
        ///
        /// <p>The subfolders in the specified folder.</p>
        pub fn folders(mut self, input: impl Into<crate::model::FolderMetadata>) -> Self {
            let mut v = self.folders.unwrap_or_default();
            v.push(input.into());
            self.folders = Some(v);
            self
        }
        /// <p>The subfolders in the specified folder.</p>
        pub fn set_folders(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderMetadata>>,
        ) -> Self {
            self.folders = input;
            self
        }
        /// Appends an item to `documents`.
        ///
        /// To override the contents of this collection use [`set_documents`](Self::set_documents).
        ///
        /// <p>The documents in the specified folder.</p>
        pub fn documents(mut self, input: impl Into<crate::model::DocumentMetadata>) -> Self {
            let mut v = self.documents.unwrap_or_default();
            v.push(input.into());
            self.documents = Some(v);
            self
        }
        /// <p>The documents in the specified folder.</p>
        pub fn set_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentMetadata>>,
        ) -> Self {
            self.documents = input;
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no
        /// additional results, the string is empty.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no
        /// additional results, the string is empty.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFolderContentsOutput`](crate::output::DescribeFolderContentsOutput)
        pub fn build(self) -> crate::output::DescribeFolderContentsOutput {
            crate::output::DescribeFolderContentsOutput {
                folders: self.folders,
                documents: self.documents,
                marker: self.marker,
            }
        }
    }
}
impl DescribeFolderContentsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFolderContentsOutput`](crate::output::DescribeFolderContentsOutput)
    pub fn builder() -> crate::output::describe_folder_contents_output::Builder {
        crate::output::describe_folder_contents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDocumentVersionsOutput {
    /// <p>The document versions.</p>
    pub document_versions:
        std::option::Option<std::vec::Vec<crate::model::DocumentVersionMetadata>>,
    /// <p>The marker to use when requesting the next set of results. If there are no
    /// additional results, the string is empty.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDocumentVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDocumentVersionsOutput");
        formatter.field("document_versions", &self.document_versions);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDocumentVersionsOutput`](crate::output::DescribeDocumentVersionsOutput)
pub mod describe_document_versions_output {
    /// A builder for [`DescribeDocumentVersionsOutput`](crate::output::DescribeDocumentVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_versions:
            std::option::Option<std::vec::Vec<crate::model::DocumentVersionMetadata>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `document_versions`.
        ///
        /// To override the contents of this collection use [`set_document_versions`](Self::set_document_versions).
        ///
        /// <p>The document versions.</p>
        pub fn document_versions(
            mut self,
            input: impl Into<crate::model::DocumentVersionMetadata>,
        ) -> Self {
            let mut v = self.document_versions.unwrap_or_default();
            v.push(input.into());
            self.document_versions = Some(v);
            self
        }
        /// <p>The document versions.</p>
        pub fn set_document_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentVersionMetadata>>,
        ) -> Self {
            self.document_versions = input;
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no
        /// additional results, the string is empty.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker to use when requesting the next set of results. If there are no
        /// additional results, the string is empty.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDocumentVersionsOutput`](crate::output::DescribeDocumentVersionsOutput)
        pub fn build(self) -> crate::output::DescribeDocumentVersionsOutput {
            crate::output::DescribeDocumentVersionsOutput {
                document_versions: self.document_versions,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDocumentVersionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDocumentVersionsOutput`](crate::output::DescribeDocumentVersionsOutput)
    pub fn builder() -> crate::output::describe_document_versions_output::Builder {
        crate::output::describe_document_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCommentsOutput {
    /// <p>The list of comments for the specified document version.</p>
    pub comments: std::option::Option<std::vec::Vec<crate::model::Comment>>,
    /// <p>The marker for the next set of results. This marker was received from a previous
    /// call.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeCommentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCommentsOutput");
        formatter.field("comments", &self.comments);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeCommentsOutput`](crate::output::DescribeCommentsOutput)
pub mod describe_comments_output {
    /// A builder for [`DescribeCommentsOutput`](crate::output::DescribeCommentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comments: std::option::Option<std::vec::Vec<crate::model::Comment>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `comments`.
        ///
        /// To override the contents of this collection use [`set_comments`](Self::set_comments).
        ///
        /// <p>The list of comments for the specified document version.</p>
        pub fn comments(mut self, input: impl Into<crate::model::Comment>) -> Self {
            let mut v = self.comments.unwrap_or_default();
            v.push(input.into());
            self.comments = Some(v);
            self
        }
        /// <p>The list of comments for the specified document version.</p>
        pub fn set_comments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Comment>>,
        ) -> Self {
            self.comments = input;
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous
        /// call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous
        /// call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCommentsOutput`](crate::output::DescribeCommentsOutput)
        pub fn build(self) -> crate::output::DescribeCommentsOutput {
            crate::output::DescribeCommentsOutput {
                comments: self.comments,
                marker: self.marker,
            }
        }
    }
}
impl DescribeCommentsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCommentsOutput`](crate::output::DescribeCommentsOutput)
    pub fn builder() -> crate::output::describe_comments_output::Builder {
        crate::output::describe_comments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeActivitiesOutput {
    /// <p>The list of activities for the specified user and time period.</p>
    pub user_activities: std::option::Option<std::vec::Vec<crate::model::Activity>>,
    /// <p>The marker for the next set of results.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeActivitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeActivitiesOutput");
        formatter.field("user_activities", &self.user_activities);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeActivitiesOutput`](crate::output::DescribeActivitiesOutput)
pub mod describe_activities_output {
    /// A builder for [`DescribeActivitiesOutput`](crate::output::DescribeActivitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_activities: std::option::Option<std::vec::Vec<crate::model::Activity>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_activities`.
        ///
        /// To override the contents of this collection use [`set_user_activities`](Self::set_user_activities).
        ///
        /// <p>The list of activities for the specified user and time period.</p>
        pub fn user_activities(mut self, input: impl Into<crate::model::Activity>) -> Self {
            let mut v = self.user_activities.unwrap_or_default();
            v.push(input.into());
            self.user_activities = Some(v);
            self
        }
        /// <p>The list of activities for the specified user and time period.</p>
        pub fn set_user_activities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Activity>>,
        ) -> Self {
            self.user_activities = input;
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActivitiesOutput`](crate::output::DescribeActivitiesOutput)
        pub fn build(self) -> crate::output::DescribeActivitiesOutput {
            crate::output::DescribeActivitiesOutput {
                user_activities: self.user_activities,
                marker: self.marker,
            }
        }
    }
}
impl DescribeActivitiesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeActivitiesOutput`](crate::output::DescribeActivitiesOutput)
    pub fn builder() -> crate::output::describe_activities_output::Builder {
        crate::output::describe_activities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserOutput {}
impl std::fmt::Debug for DeleteUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserOutput`](crate::output::DeleteUserOutput)
pub mod delete_user_output {
    /// A builder for [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserOutput`](crate::output::DeleteUserOutput)
        pub fn build(self) -> crate::output::DeleteUserOutput {
            crate::output::DeleteUserOutput {}
        }
    }
}
impl DeleteUserOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    pub fn builder() -> crate::output::delete_user_output::Builder {
        crate::output::delete_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNotificationSubscriptionOutput {}
impl std::fmt::Debug for DeleteNotificationSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNotificationSubscriptionOutput");
        formatter.finish()
    }
}
/// See [`DeleteNotificationSubscriptionOutput`](crate::output::DeleteNotificationSubscriptionOutput)
pub mod delete_notification_subscription_output {
    /// A builder for [`DeleteNotificationSubscriptionOutput`](crate::output::DeleteNotificationSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteNotificationSubscriptionOutput`](crate::output::DeleteNotificationSubscriptionOutput)
        pub fn build(self) -> crate::output::DeleteNotificationSubscriptionOutput {
            crate::output::DeleteNotificationSubscriptionOutput {}
        }
    }
}
impl DeleteNotificationSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteNotificationSubscriptionOutput`](crate::output::DeleteNotificationSubscriptionOutput)
    pub fn builder() -> crate::output::delete_notification_subscription_output::Builder {
        crate::output::delete_notification_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLabelsOutput {}
impl std::fmt::Debug for DeleteLabelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLabelsOutput");
        formatter.finish()
    }
}
/// See [`DeleteLabelsOutput`](crate::output::DeleteLabelsOutput)
pub mod delete_labels_output {
    /// A builder for [`DeleteLabelsOutput`](crate::output::DeleteLabelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteLabelsOutput`](crate::output::DeleteLabelsOutput)
        pub fn build(self) -> crate::output::DeleteLabelsOutput {
            crate::output::DeleteLabelsOutput {}
        }
    }
}
impl DeleteLabelsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLabelsOutput`](crate::output::DeleteLabelsOutput)
    pub fn builder() -> crate::output::delete_labels_output::Builder {
        crate::output::delete_labels_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFolderContentsOutput {}
impl std::fmt::Debug for DeleteFolderContentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFolderContentsOutput");
        formatter.finish()
    }
}
/// See [`DeleteFolderContentsOutput`](crate::output::DeleteFolderContentsOutput)
pub mod delete_folder_contents_output {
    /// A builder for [`DeleteFolderContentsOutput`](crate::output::DeleteFolderContentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFolderContentsOutput`](crate::output::DeleteFolderContentsOutput)
        pub fn build(self) -> crate::output::DeleteFolderContentsOutput {
            crate::output::DeleteFolderContentsOutput {}
        }
    }
}
impl DeleteFolderContentsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFolderContentsOutput`](crate::output::DeleteFolderContentsOutput)
    pub fn builder() -> crate::output::delete_folder_contents_output::Builder {
        crate::output::delete_folder_contents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFolderOutput {}
impl std::fmt::Debug for DeleteFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFolderOutput");
        formatter.finish()
    }
}
/// See [`DeleteFolderOutput`](crate::output::DeleteFolderOutput)
pub mod delete_folder_output {
    /// A builder for [`DeleteFolderOutput`](crate::output::DeleteFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFolderOutput`](crate::output::DeleteFolderOutput)
        pub fn build(self) -> crate::output::DeleteFolderOutput {
            crate::output::DeleteFolderOutput {}
        }
    }
}
impl DeleteFolderOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFolderOutput`](crate::output::DeleteFolderOutput)
    pub fn builder() -> crate::output::delete_folder_output::Builder {
        crate::output::delete_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDocumentOutput {}
impl std::fmt::Debug for DeleteDocumentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDocumentOutput");
        formatter.finish()
    }
}
/// See [`DeleteDocumentOutput`](crate::output::DeleteDocumentOutput)
pub mod delete_document_output {
    /// A builder for [`DeleteDocumentOutput`](crate::output::DeleteDocumentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDocumentOutput`](crate::output::DeleteDocumentOutput)
        pub fn build(self) -> crate::output::DeleteDocumentOutput {
            crate::output::DeleteDocumentOutput {}
        }
    }
}
impl DeleteDocumentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDocumentOutput`](crate::output::DeleteDocumentOutput)
    pub fn builder() -> crate::output::delete_document_output::Builder {
        crate::output::delete_document_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomMetadataOutput {}
impl std::fmt::Debug for DeleteCustomMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomMetadataOutput");
        formatter.finish()
    }
}
/// See [`DeleteCustomMetadataOutput`](crate::output::DeleteCustomMetadataOutput)
pub mod delete_custom_metadata_output {
    /// A builder for [`DeleteCustomMetadataOutput`](crate::output::DeleteCustomMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCustomMetadataOutput`](crate::output::DeleteCustomMetadataOutput)
        pub fn build(self) -> crate::output::DeleteCustomMetadataOutput {
            crate::output::DeleteCustomMetadataOutput {}
        }
    }
}
impl DeleteCustomMetadataOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCustomMetadataOutput`](crate::output::DeleteCustomMetadataOutput)
    pub fn builder() -> crate::output::delete_custom_metadata_output::Builder {
        crate::output::delete_custom_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCommentOutput {}
impl std::fmt::Debug for DeleteCommentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCommentOutput");
        formatter.finish()
    }
}
/// See [`DeleteCommentOutput`](crate::output::DeleteCommentOutput)
pub mod delete_comment_output {
    /// A builder for [`DeleteCommentOutput`](crate::output::DeleteCommentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCommentOutput`](crate::output::DeleteCommentOutput)
        pub fn build(self) -> crate::output::DeleteCommentOutput {
            crate::output::DeleteCommentOutput {}
        }
    }
}
impl DeleteCommentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCommentOutput`](crate::output::DeleteCommentOutput)
    pub fn builder() -> crate::output::delete_comment_output::Builder {
        crate::output::delete_comment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateUserOutput {}
impl std::fmt::Debug for DeactivateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateUserOutput");
        formatter.finish()
    }
}
/// See [`DeactivateUserOutput`](crate::output::DeactivateUserOutput)
pub mod deactivate_user_output {
    /// A builder for [`DeactivateUserOutput`](crate::output::DeactivateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeactivateUserOutput`](crate::output::DeactivateUserOutput)
        pub fn build(self) -> crate::output::DeactivateUserOutput {
            crate::output::DeactivateUserOutput {}
        }
    }
}
impl DeactivateUserOutput {
    /// Creates a new builder-style object to manufacture [`DeactivateUserOutput`](crate::output::DeactivateUserOutput)
    pub fn builder() -> crate::output::deactivate_user_output::Builder {
        crate::output::deactivate_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserOutput {
    /// <p>The user information.</p>
    pub user: std::option::Option<crate::model::User>,
}
impl std::fmt::Debug for CreateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserOutput");
        formatter.field("user", &self.user);
        formatter.finish()
    }
}
/// See [`CreateUserOutput`](crate::output::CreateUserOutput)
pub mod create_user_output {
    /// A builder for [`CreateUserOutput`](crate::output::CreateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::User>,
    }
    impl Builder {
        /// <p>The user information.</p>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>The user information.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserOutput`](crate::output::CreateUserOutput)
        pub fn build(self) -> crate::output::CreateUserOutput {
            crate::output::CreateUserOutput { user: self.user }
        }
    }
}
impl CreateUserOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserOutput`](crate::output::CreateUserOutput)
    pub fn builder() -> crate::output::create_user_output::Builder {
        crate::output::create_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNotificationSubscriptionOutput {
    /// <p>The subscription.</p>
    pub subscription: std::option::Option<crate::model::Subscription>,
}
impl std::fmt::Debug for CreateNotificationSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNotificationSubscriptionOutput");
        formatter.field("subscription", &self.subscription);
        formatter.finish()
    }
}
/// See [`CreateNotificationSubscriptionOutput`](crate::output::CreateNotificationSubscriptionOutput)
pub mod create_notification_subscription_output {
    /// A builder for [`CreateNotificationSubscriptionOutput`](crate::output::CreateNotificationSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription: std::option::Option<crate::model::Subscription>,
    }
    impl Builder {
        /// <p>The subscription.</p>
        pub fn subscription(mut self, input: crate::model::Subscription) -> Self {
            self.subscription = Some(input);
            self
        }
        /// <p>The subscription.</p>
        pub fn set_subscription(
            mut self,
            input: std::option::Option<crate::model::Subscription>,
        ) -> Self {
            self.subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNotificationSubscriptionOutput`](crate::output::CreateNotificationSubscriptionOutput)
        pub fn build(self) -> crate::output::CreateNotificationSubscriptionOutput {
            crate::output::CreateNotificationSubscriptionOutput {
                subscription: self.subscription,
            }
        }
    }
}
impl CreateNotificationSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`CreateNotificationSubscriptionOutput`](crate::output::CreateNotificationSubscriptionOutput)
    pub fn builder() -> crate::output::create_notification_subscription_output::Builder {
        crate::output::create_notification_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLabelsOutput {}
impl std::fmt::Debug for CreateLabelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLabelsOutput");
        formatter.finish()
    }
}
/// See [`CreateLabelsOutput`](crate::output::CreateLabelsOutput)
pub mod create_labels_output {
    /// A builder for [`CreateLabelsOutput`](crate::output::CreateLabelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateLabelsOutput`](crate::output::CreateLabelsOutput)
        pub fn build(self) -> crate::output::CreateLabelsOutput {
            crate::output::CreateLabelsOutput {}
        }
    }
}
impl CreateLabelsOutput {
    /// Creates a new builder-style object to manufacture [`CreateLabelsOutput`](crate::output::CreateLabelsOutput)
    pub fn builder() -> crate::output::create_labels_output::Builder {
        crate::output::create_labels_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFolderOutput {
    /// <p>The metadata of the folder.</p>
    pub metadata: std::option::Option<crate::model::FolderMetadata>,
}
impl std::fmt::Debug for CreateFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFolderOutput");
        formatter.field("metadata", &self.metadata);
        formatter.finish()
    }
}
/// See [`CreateFolderOutput`](crate::output::CreateFolderOutput)
pub mod create_folder_output {
    /// A builder for [`CreateFolderOutput`](crate::output::CreateFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata: std::option::Option<crate::model::FolderMetadata>,
    }
    impl Builder {
        /// <p>The metadata of the folder.</p>
        pub fn metadata(mut self, input: crate::model::FolderMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The metadata of the folder.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::FolderMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFolderOutput`](crate::output::CreateFolderOutput)
        pub fn build(self) -> crate::output::CreateFolderOutput {
            crate::output::CreateFolderOutput {
                metadata: self.metadata,
            }
        }
    }
}
impl CreateFolderOutput {
    /// Creates a new builder-style object to manufacture [`CreateFolderOutput`](crate::output::CreateFolderOutput)
    pub fn builder() -> crate::output::create_folder_output::Builder {
        crate::output::create_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomMetadataOutput {}
impl std::fmt::Debug for CreateCustomMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomMetadataOutput");
        formatter.finish()
    }
}
/// See [`CreateCustomMetadataOutput`](crate::output::CreateCustomMetadataOutput)
pub mod create_custom_metadata_output {
    /// A builder for [`CreateCustomMetadataOutput`](crate::output::CreateCustomMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateCustomMetadataOutput`](crate::output::CreateCustomMetadataOutput)
        pub fn build(self) -> crate::output::CreateCustomMetadataOutput {
            crate::output::CreateCustomMetadataOutput {}
        }
    }
}
impl CreateCustomMetadataOutput {
    /// Creates a new builder-style object to manufacture [`CreateCustomMetadataOutput`](crate::output::CreateCustomMetadataOutput)
    pub fn builder() -> crate::output::create_custom_metadata_output::Builder {
        crate::output::create_custom_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCommentOutput {
    /// <p>The comment that has been created.</p>
    pub comment: std::option::Option<crate::model::Comment>,
}
impl std::fmt::Debug for CreateCommentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCommentOutput");
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`CreateCommentOutput`](crate::output::CreateCommentOutput)
pub mod create_comment_output {
    /// A builder for [`CreateCommentOutput`](crate::output::CreateCommentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<crate::model::Comment>,
    }
    impl Builder {
        /// <p>The comment that has been created.</p>
        pub fn comment(mut self, input: crate::model::Comment) -> Self {
            self.comment = Some(input);
            self
        }
        /// <p>The comment that has been created.</p>
        pub fn set_comment(mut self, input: std::option::Option<crate::model::Comment>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCommentOutput`](crate::output::CreateCommentOutput)
        pub fn build(self) -> crate::output::CreateCommentOutput {
            crate::output::CreateCommentOutput {
                comment: self.comment,
            }
        }
    }
}
impl CreateCommentOutput {
    /// Creates a new builder-style object to manufacture [`CreateCommentOutput`](crate::output::CreateCommentOutput)
    pub fn builder() -> crate::output::create_comment_output::Builder {
        crate::output::create_comment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddResourcePermissionsOutput {
    /// <p>The share results.</p>
    pub share_results: std::option::Option<std::vec::Vec<crate::model::ShareResult>>,
}
impl std::fmt::Debug for AddResourcePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddResourcePermissionsOutput");
        formatter.field("share_results", &self.share_results);
        formatter.finish()
    }
}
/// See [`AddResourcePermissionsOutput`](crate::output::AddResourcePermissionsOutput)
pub mod add_resource_permissions_output {
    /// A builder for [`AddResourcePermissionsOutput`](crate::output::AddResourcePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_results: std::option::Option<std::vec::Vec<crate::model::ShareResult>>,
    }
    impl Builder {
        /// Appends an item to `share_results`.
        ///
        /// To override the contents of this collection use [`set_share_results`](Self::set_share_results).
        ///
        /// <p>The share results.</p>
        pub fn share_results(mut self, input: impl Into<crate::model::ShareResult>) -> Self {
            let mut v = self.share_results.unwrap_or_default();
            v.push(input.into());
            self.share_results = Some(v);
            self
        }
        /// <p>The share results.</p>
        pub fn set_share_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ShareResult>>,
        ) -> Self {
            self.share_results = input;
            self
        }
        /// Consumes the builder and constructs a [`AddResourcePermissionsOutput`](crate::output::AddResourcePermissionsOutput)
        pub fn build(self) -> crate::output::AddResourcePermissionsOutput {
            crate::output::AddResourcePermissionsOutput {
                share_results: self.share_results,
            }
        }
    }
}
impl AddResourcePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`AddResourcePermissionsOutput`](crate::output::AddResourcePermissionsOutput)
    pub fn builder() -> crate::output::add_resource_permissions_output::Builder {
        crate::output::add_resource_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateUserOutput {
    /// <p>The user information.</p>
    pub user: std::option::Option<crate::model::User>,
}
impl std::fmt::Debug for ActivateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateUserOutput");
        formatter.field("user", &self.user);
        formatter.finish()
    }
}
/// See [`ActivateUserOutput`](crate::output::ActivateUserOutput)
pub mod activate_user_output {
    /// A builder for [`ActivateUserOutput`](crate::output::ActivateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::User>,
    }
    impl Builder {
        /// <p>The user information.</p>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>The user information.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateUserOutput`](crate::output::ActivateUserOutput)
        pub fn build(self) -> crate::output::ActivateUserOutput {
            crate::output::ActivateUserOutput { user: self.user }
        }
    }
}
impl ActivateUserOutput {
    /// Creates a new builder-style object to manufacture [`ActivateUserOutput`](crate::output::ActivateUserOutput)
    pub fn builder() -> crate::output::activate_user_output::Builder {
        crate::output::activate_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortDocumentVersionUploadOutput {}
impl std::fmt::Debug for AbortDocumentVersionUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortDocumentVersionUploadOutput");
        formatter.finish()
    }
}
/// See [`AbortDocumentVersionUploadOutput`](crate::output::AbortDocumentVersionUploadOutput)
pub mod abort_document_version_upload_output {
    /// A builder for [`AbortDocumentVersionUploadOutput`](crate::output::AbortDocumentVersionUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AbortDocumentVersionUploadOutput`](crate::output::AbortDocumentVersionUploadOutput)
        pub fn build(self) -> crate::output::AbortDocumentVersionUploadOutput {
            crate::output::AbortDocumentVersionUploadOutput {}
        }
    }
}
impl AbortDocumentVersionUploadOutput {
    /// Creates a new builder-style object to manufacture [`AbortDocumentVersionUploadOutput`](crate::output::AbortDocumentVersionUploadOutput)
    pub fn builder() -> crate::output::abort_document_version_upload_output::Builder {
        crate::output::abort_document_version_upload_output::Builder::default()
    }
}
