// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AbortDocumentVersionUploadInput`](crate::input::AbortDocumentVersionUploadInput)
pub mod abort_document_version_upload_input {
    /// A builder for [`AbortDocumentVersionUploadInput`](crate::input::AbortDocumentVersionUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The ID of the version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortDocumentVersionUploadInput`](crate::input::AbortDocumentVersionUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AbortDocumentVersionUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AbortDocumentVersionUploadInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AbortDocumentVersionUploadInputOperationOutputAlias =
    crate::operation::AbortDocumentVersionUpload;
#[doc(hidden)]
pub type AbortDocumentVersionUploadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AbortDocumentVersionUploadInput {
    /// Consumes the builder and constructs an Operation<[`AbortDocumentVersionUpload`](crate::operation::AbortDocumentVersionUpload)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AbortDocumentVersionUpload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AbortDocumentVersionUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.document_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_1, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.version_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    })?;
            let version_id = aws_smithy_http::label::fmt_string(input_2, false);
            if version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}/versions/{VersionId}",
                DocumentId = document_id,
                VersionId = version_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::AbortDocumentVersionUploadInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_3) = &_input.authentication_token {
                let formatted_4 = AsRef::<str>::as_ref(inner_3);
                if !formatted_4.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_4;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AbortDocumentVersionUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AbortDocumentVersionUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AbortDocumentVersionUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AbortDocumentVersionUpload",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AbortDocumentVersionUploadInput`](crate::input::AbortDocumentVersionUploadInput)
    pub fn builder() -> crate::input::abort_document_version_upload_input::Builder {
        crate::input::abort_document_version_upload_input::Builder::default()
    }
}

/// See [`ActivateUserInput`](crate::input::ActivateUserInput)
pub mod activate_user_input {
    /// A builder for [`ActivateUserInput`](crate::input::ActivateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) authentication_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateUserInput`](crate::input::ActivateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ActivateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ActivateUserInput {
                user_id: self.user_id,
                authentication_token: self.authentication_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ActivateUserInputOperationOutputAlias = crate::operation::ActivateUser;
#[doc(hidden)]
pub type ActivateUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ActivateUserInput {
    /// Consumes the builder and constructs an Operation<[`ActivateUser`](crate::operation::ActivateUser)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ActivateUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ActivateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.user_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_5, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/users/{UserId}/activation",
                UserId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ActivateUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_6) = &_input.authentication_token {
                let formatted_7 = AsRef::<str>::as_ref(inner_6);
                if !formatted_7.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_7;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ActivateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ActivateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ActivateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ActivateUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ActivateUserInput`](crate::input::ActivateUserInput)
    pub fn builder() -> crate::input::activate_user_input::Builder {
        crate::input::activate_user_input::Builder::default()
    }
}

/// See [`AddResourcePermissionsInput`](crate::input::AddResourcePermissionsInput)
pub mod add_resource_permissions_input {
    /// A builder for [`AddResourcePermissionsInput`](crate::input::AddResourcePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) principals: std::option::Option<std::vec::Vec<crate::model::SharePrincipal>>,
        pub(crate) notification_options: std::option::Option<crate::model::NotificationOptions>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The users, groups, or organization being granted permission.</p>
        pub fn principals(mut self, input: impl Into<crate::model::SharePrincipal>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The users, groups, or organization being granted permission.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SharePrincipal>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>The notification options.</p>
        pub fn notification_options(mut self, input: crate::model::NotificationOptions) -> Self {
            self.notification_options = Some(input);
            self
        }
        /// <p>The notification options.</p>
        pub fn set_notification_options(
            mut self,
            input: std::option::Option<crate::model::NotificationOptions>,
        ) -> Self {
            self.notification_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AddResourcePermissionsInput`](crate::input::AddResourcePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddResourcePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddResourcePermissionsInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
                principals: self.principals,
                notification_options: self.notification_options,
            })
        }
    }
}
#[doc(hidden)]
pub type AddResourcePermissionsInputOperationOutputAlias = crate::operation::AddResourcePermissions;
#[doc(hidden)]
pub type AddResourcePermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddResourcePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`AddResourcePermissions`](crate::operation::AddResourcePermissions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddResourcePermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddResourcePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.resource_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_8, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/resources/{ResourceId}/permissions",
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::AddResourcePermissionsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_9) = &_input.authentication_token {
                let formatted_10 = AsRef::<str>::as_ref(inner_9);
                if !formatted_10.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_10;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddResourcePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddResourcePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_resource_permissions(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddResourcePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddResourcePermissions",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddResourcePermissionsInput`](crate::input::AddResourcePermissionsInput)
    pub fn builder() -> crate::input::add_resource_permissions_input::Builder {
        crate::input::add_resource_permissions_input::Builder::default()
    }
}

/// See [`CreateCommentInput`](crate::input::CreateCommentInput)
pub mod create_comment_input {
    /// A builder for [`CreateCommentInput`](crate::input::CreateCommentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) thread_id: std::option::Option<std::string::String>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) visibility: std::option::Option<crate::model::CommentVisibilityType>,
        pub(crate) notify_collaborators: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The ID of the parent comment.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent comment.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The ID of the root comment in the thread.</p>
        pub fn thread_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thread_id = Some(input.into());
            self
        }
        /// <p>The ID of the root comment in the thread.</p>
        pub fn set_thread_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thread_id = input;
            self
        }
        /// <p>The text of the comment.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text of the comment.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is
        /// visible only to the comment author and document owner and co-owners, or PUBLIC, where
        /// the comment is visible to document owners, co-owners, and contributors.</p>
        pub fn visibility(mut self, input: crate::model::CommentVisibilityType) -> Self {
            self.visibility = Some(input);
            self
        }
        /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is
        /// visible only to the comment author and document owner and co-owners, or PUBLIC, where
        /// the comment is visible to document owners, co-owners, and contributors.</p>
        pub fn set_visibility(
            mut self,
            input: std::option::Option<crate::model::CommentVisibilityType>,
        ) -> Self {
            self.visibility = input;
            self
        }
        /// <p>Set this parameter to TRUE to send an email out to the document collaborators after
        /// the comment is created.</p>
        pub fn notify_collaborators(mut self, input: bool) -> Self {
            self.notify_collaborators = Some(input);
            self
        }
        /// <p>Set this parameter to TRUE to send an email out to the document collaborators after
        /// the comment is created.</p>
        pub fn set_notify_collaborators(mut self, input: std::option::Option<bool>) -> Self {
            self.notify_collaborators = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCommentInput`](crate::input::CreateCommentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCommentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCommentInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
                parent_id: self.parent_id,
                thread_id: self.thread_id,
                text: self.text,
                visibility: self.visibility,
                notify_collaborators: self.notify_collaborators.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCommentInputOperationOutputAlias = crate::operation::CreateComment;
#[doc(hidden)]
pub type CreateCommentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCommentInput {
    /// Consumes the builder and constructs an Operation<[`CreateComment`](crate::operation::CreateComment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateComment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCommentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.document_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_11, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.version_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    })?;
            let version_id = aws_smithy_http::label::fmt_string(input_12, false);
            if version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}/versions/{VersionId}/comment",
                DocumentId = document_id,
                VersionId = version_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateCommentInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_13) = &_input.authentication_token {
                let formatted_14 = AsRef::<str>::as_ref(inner_13);
                if !formatted_14.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_14;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCommentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCommentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_comment(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateComment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateComment",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCommentInput`](crate::input::CreateCommentInput)
    pub fn builder() -> crate::input::create_comment_input::Builder {
        crate::input::create_comment_input::Builder::default()
    }
}

/// See [`CreateCustomMetadataInput`](crate::input::CreateCustomMetadataInput)
pub mod create_custom_metadata_input {
    /// A builder for [`CreateCustomMetadataInput`](crate::input::CreateCustomMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) custom_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ID of the version, if the custom metadata is being added to a document
        /// version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the version, if the custom metadata is being added to a document
        /// version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Adds a key-value pair to `custom_metadata`.
        ///
        /// To override the contents of this collection use [`set_custom_metadata`](Self::set_custom_metadata).
        ///
        /// <p>Custom metadata in the form of name-value pairs.</p>
        pub fn custom_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.custom_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.custom_metadata = Some(hash_map);
            self
        }
        /// <p>Custom metadata in the form of name-value pairs.</p>
        pub fn set_custom_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomMetadataInput`](crate::input::CreateCustomMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomMetadataInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
                version_id: self.version_id,
                custom_metadata: self.custom_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomMetadataInputOperationOutputAlias = crate::operation::CreateCustomMetadata;
#[doc(hidden)]
pub type CreateCustomMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCustomMetadataInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomMetadata`](crate::operation::CreateCustomMetadata)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCustomMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.resource_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_15, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/resources/{ResourceId}/customMetadata",
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateCustomMetadataInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_16) = &_input.authentication_token {
                let formatted_17 = AsRef::<str>::as_ref(inner_16);
                if !formatted_17.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_17;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::CreateCustomMetadataInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_18) = &_input.version_id {
                query.push_kv("versionid", &aws_smithy_http::query::fmt_string(&inner_18));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCustomMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCustomMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_custom_metadata(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomMetadata",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomMetadataInput`](crate::input::CreateCustomMetadataInput)
    pub fn builder() -> crate::input::create_custom_metadata_input::Builder {
        crate::input::create_custom_metadata_input::Builder::default()
    }
}

/// See [`CreateFolderInput`](crate::input::CreateFolderInput)
pub mod create_folder_input {
    /// A builder for [`CreateFolderInput`](crate::input::CreateFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parent_folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The name of the new folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFolderInput`](crate::input::CreateFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFolderInput {
                authentication_token: self.authentication_token,
                name: self.name,
                parent_folder_id: self.parent_folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFolderInputOperationOutputAlias = crate::operation::CreateFolder;
#[doc(hidden)]
pub type CreateFolderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFolderInput {
    /// Consumes the builder and constructs an Operation<[`CreateFolder`](crate::operation::CreateFolder)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFolder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/api/v1/folders").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateFolderInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_19) = &_input.authentication_token {
                let formatted_20 = AsRef::<str>::as_ref(inner_19);
                if !formatted_20.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_20;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_folder(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFolder",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFolderInput`](crate::input::CreateFolderInput)
    pub fn builder() -> crate::input::create_folder_input::Builder {
        crate::input::create_folder_input::Builder::default()
    }
}

/// See [`CreateLabelsInput`](crate::input::CreateLabelsInput)
pub mod create_labels_input {
    /// A builder for [`CreateLabelsInput`](crate::input::CreateLabelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) authentication_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>List of labels to add to the resource.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>List of labels to add to the resource.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLabelsInput`](crate::input::CreateLabelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLabelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLabelsInput {
                resource_id: self.resource_id,
                labels: self.labels,
                authentication_token: self.authentication_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLabelsInputOperationOutputAlias = crate::operation::CreateLabels;
#[doc(hidden)]
pub type CreateLabelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLabelsInput {
    /// Consumes the builder and constructs an Operation<[`CreateLabels`](crate::operation::CreateLabels)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLabels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLabelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.resource_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_21, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/resources/{ResourceId}/labels",
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateLabelsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_22) = &_input.authentication_token {
                let formatted_23 = AsRef::<str>::as_ref(inner_22);
                if !formatted_23.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_23;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLabelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLabelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_labels(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLabels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLabels",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLabelsInput`](crate::input::CreateLabelsInput)
    pub fn builder() -> crate::input::create_labels_input::Builder {
        crate::input::create_labels_input::Builder::default()
    }
}

/// See [`CreateNotificationSubscriptionInput`](crate::input::CreateNotificationSubscriptionInput)
pub mod create_notification_subscription_input {
    /// A builder for [`CreateNotificationSubscriptionInput`](crate::input::CreateNotificationSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::SubscriptionProtocolType>,
        pub(crate) subscription_type: std::option::Option<crate::model::SubscriptionType>,
    }
    impl Builder {
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint
        /// is a URL that begins with <code>https</code>.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint
        /// is a URL that begins with <code>https</code>.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The protocol to use. The supported value is https, which delivers JSON-encoded
        /// messages using HTTPS POST.</p>
        pub fn protocol(mut self, input: crate::model::SubscriptionProtocolType) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol to use. The supported value is https, which delivers JSON-encoded
        /// messages using HTTPS POST.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::SubscriptionProtocolType>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The notification type.</p>
        pub fn subscription_type(mut self, input: crate::model::SubscriptionType) -> Self {
            self.subscription_type = Some(input);
            self
        }
        /// <p>The notification type.</p>
        pub fn set_subscription_type(
            mut self,
            input: std::option::Option<crate::model::SubscriptionType>,
        ) -> Self {
            self.subscription_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNotificationSubscriptionInput`](crate::input::CreateNotificationSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNotificationSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNotificationSubscriptionInput {
                organization_id: self.organization_id,
                endpoint: self.endpoint,
                protocol: self.protocol,
                subscription_type: self.subscription_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNotificationSubscriptionInputOperationOutputAlias =
    crate::operation::CreateNotificationSubscription;
#[doc(hidden)]
pub type CreateNotificationSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateNotificationSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateNotificationSubscription`](crate::operation::CreateNotificationSubscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNotificationSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNotificationSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.organization_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "organization_id",
                        details: "cannot be empty or unset",
                    })?;
            let organization_id = aws_smithy_http::label::fmt_string(input_24, false);
            if organization_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "organization_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/organizations/{OrganizationId}/subscriptions",
                OrganizationId = organization_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNotificationSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNotificationSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_notification_subscription(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNotificationSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNotificationSubscription",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNotificationSubscriptionInput`](crate::input::CreateNotificationSubscriptionInput)
    pub fn builder() -> crate::input::create_notification_subscription_input::Builder {
        crate::input::create_notification_subscription_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) given_name: std::option::Option<std::string::String>,
        pub(crate) surname: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) time_zone_id: std::option::Option<std::string::String>,
        pub(crate) storage_rule: std::option::Option<crate::model::StorageRuleType>,
        pub(crate) authentication_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The login name of the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The login name of the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The email address of the user.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address of the user.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The given name of the user.</p>
        pub fn given_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.given_name = Some(input.into());
            self
        }
        /// <p>The given name of the user.</p>
        pub fn set_given_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.given_name = input;
            self
        }
        /// <p>The surname of the user.</p>
        pub fn surname(mut self, input: impl Into<std::string::String>) -> Self {
            self.surname = Some(input.into());
            self
        }
        /// <p>The surname of the user.</p>
        pub fn set_surname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.surname = input;
            self
        }
        /// <p>The password of the user.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password of the user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn time_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone_id = Some(input.into());
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn set_time_zone_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone_id = input;
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn storage_rule(mut self, input: crate::model::StorageRuleType) -> Self {
            self.storage_rule = Some(input);
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn set_storage_rule(
            mut self,
            input: std::option::Option<crate::model::StorageRuleType>,
        ) -> Self {
            self.storage_rule = input;
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                organization_id: self.organization_id,
                username: self.username,
                email_address: self.email_address,
                given_name: self.given_name,
                surname: self.surname,
                password: self.password,
                time_zone_id: self.time_zone_id,
                storage_rule: self.storage_rule,
                authentication_token: self.authentication_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/api/v1/users").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_25) = &_input.authentication_token {
                let formatted_26 = AsRef::<str>::as_ref(inner_25);
                if !formatted_26.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_26;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_user(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`DeactivateUserInput`](crate::input::DeactivateUserInput)
pub mod deactivate_user_input {
    /// A builder for [`DeactivateUserInput`](crate::input::DeactivateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) authentication_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeactivateUserInput`](crate::input::DeactivateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeactivateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeactivateUserInput {
                user_id: self.user_id,
                authentication_token: self.authentication_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeactivateUserInputOperationOutputAlias = crate::operation::DeactivateUser;
#[doc(hidden)]
pub type DeactivateUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeactivateUserInput {
    /// Consumes the builder and constructs an Operation<[`DeactivateUser`](crate::operation::DeactivateUser)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeactivateUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeactivateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.user_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_27, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/users/{UserId}/activation",
                UserId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeactivateUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_28) = &_input.authentication_token {
                let formatted_29 = AsRef::<str>::as_ref(inner_28);
                if !formatted_29.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_29;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeactivateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeactivateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeactivateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeactivateUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeactivateUserInput`](crate::input::DeactivateUserInput)
    pub fn builder() -> crate::input::deactivate_user_input::Builder {
        crate::input::deactivate_user_input::Builder::default()
    }
}

/// See [`DeleteCommentInput`](crate::input::DeleteCommentInput)
pub mod delete_comment_input {
    /// A builder for [`DeleteCommentInput`](crate::input::DeleteCommentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) comment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The ID of the comment.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_id = Some(input.into());
            self
        }
        /// <p>The ID of the comment.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCommentInput`](crate::input::DeleteCommentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCommentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCommentInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
                comment_id: self.comment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCommentInputOperationOutputAlias = crate::operation::DeleteComment;
#[doc(hidden)]
pub type DeleteCommentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCommentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteComment`](crate::operation::DeleteComment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteComment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCommentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.document_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_30, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_31 = &_input.version_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    })?;
            let version_id = aws_smithy_http::label::fmt_string(input_31, false);
            if version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_32 = &_input.comment_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "comment_id",
                        details: "cannot be empty or unset",
                    })?;
            let comment_id = aws_smithy_http::label::fmt_string(input_32, false);
            if comment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "comment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}/versions/{VersionId}/comment/{CommentId}",
                DocumentId = document_id,
                VersionId = version_id,
                CommentId = comment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteCommentInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_33) = &_input.authentication_token {
                let formatted_34 = AsRef::<str>::as_ref(inner_33);
                if !formatted_34.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_34;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCommentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCommentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteComment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteComment",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCommentInput`](crate::input::DeleteCommentInput)
    pub fn builder() -> crate::input::delete_comment_input::Builder {
        crate::input::delete_comment_input::Builder::default()
    }
}

/// See [`DeleteCustomMetadataInput`](crate::input::DeleteCustomMetadataInput)
pub mod delete_custom_metadata_input {
    /// A builder for [`DeleteCustomMetadataInput`](crate::input::DeleteCustomMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) delete_all: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource, either a document or folder.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource, either a document or folder.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ID of the version, if the custom metadata is being deleted from a document
        /// version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the version, if the custom metadata is being deleted from a document
        /// version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Appends an item to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>List of properties to remove.</p>
        pub fn keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.keys.unwrap_or_default();
            v.push(input.into());
            self.keys = Some(v);
            self
        }
        /// <p>List of properties to remove.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.keys = input;
            self
        }
        /// <p>Flag to indicate removal of all custom metadata properties from the specified
        /// resource.</p>
        pub fn delete_all(mut self, input: bool) -> Self {
            self.delete_all = Some(input);
            self
        }
        /// <p>Flag to indicate removal of all custom metadata properties from the specified
        /// resource.</p>
        pub fn set_delete_all(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_all = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomMetadataInput`](crate::input::DeleteCustomMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomMetadataInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
                version_id: self.version_id,
                keys: self.keys,
                delete_all: self.delete_all.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomMetadataInputOperationOutputAlias = crate::operation::DeleteCustomMetadata;
#[doc(hidden)]
pub type DeleteCustomMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCustomMetadataInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomMetadata`](crate::operation::DeleteCustomMetadata)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCustomMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.resource_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_35, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/resources/{ResourceId}/customMetadata",
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteCustomMetadataInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_36) = &_input.authentication_token {
                let formatted_37 = AsRef::<str>::as_ref(inner_36);
                if !formatted_37.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_37;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::DeleteCustomMetadataInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_38) = &_input.version_id {
                query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_38));
            }
            if let Some(inner_39) = &_input.keys {
                for inner_40 in inner_39 {
                    query.push_kv("keys", &aws_smithy_http::query::fmt_string(&inner_40));
                }
            }
            if _input.delete_all {
                query.push_kv(
                    "deleteAll",
                    &aws_smithy_types::primitive::Encoder::from(_input.delete_all).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCustomMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCustomMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomMetadata",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomMetadataInput`](crate::input::DeleteCustomMetadataInput)
    pub fn builder() -> crate::input::delete_custom_metadata_input::Builder {
        crate::input::delete_custom_metadata_input::Builder::default()
    }
}

/// See [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
pub mod delete_document_input {
    /// A builder for [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDocumentInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDocumentInputOperationOutputAlias = crate::operation::DeleteDocument;
#[doc(hidden)]
pub type DeleteDocumentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDocumentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDocument`](crate::operation::DeleteDocument)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDocument,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_41 = &_input.document_id;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_41, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}",
                DocumentId = document_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteDocumentInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_42) = &_input.authentication_token {
                let formatted_43 = AsRef::<str>::as_ref(inner_42);
                if !formatted_43.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_43;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDocument",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
    pub fn builder() -> crate::input::delete_document_input::Builder {
        crate::input::delete_document_input::Builder::default()
    }
}

/// See [`DeleteFolderInput`](crate::input::DeleteFolderInput)
pub mod delete_folder_input {
    /// A builder for [`DeleteFolderInput`](crate::input::DeleteFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFolderInput`](crate::input::DeleteFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFolderInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFolderInputOperationOutputAlias = crate::operation::DeleteFolder;
#[doc(hidden)]
pub type DeleteFolderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFolderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFolder`](crate::operation::DeleteFolder)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFolder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_44 = &_input.folder_id;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_44, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/api/v1/folders/{FolderId}", FolderId = folder_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteFolderInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_45) = &_input.authentication_token {
                let formatted_46 = AsRef::<str>::as_ref(inner_45);
                if !formatted_46.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_46;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFolder",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFolderInput`](crate::input::DeleteFolderInput)
    pub fn builder() -> crate::input::delete_folder_input::Builder {
        crate::input::delete_folder_input::Builder::default()
    }
}

/// See [`DeleteFolderContentsInput`](crate::input::DeleteFolderContentsInput)
pub mod delete_folder_contents_input {
    /// A builder for [`DeleteFolderContentsInput`](crate::input::DeleteFolderContentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFolderContentsInput`](crate::input::DeleteFolderContentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFolderContentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFolderContentsInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFolderContentsInputOperationOutputAlias = crate::operation::DeleteFolderContents;
#[doc(hidden)]
pub type DeleteFolderContentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFolderContentsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFolderContents`](crate::operation::DeleteFolderContents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFolderContents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFolderContentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.folder_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_47, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/folders/{FolderId}/contents",
                FolderId = folder_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteFolderContentsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_48) = &_input.authentication_token {
                let formatted_49 = AsRef::<str>::as_ref(inner_48);
                if !formatted_49.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_49;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFolderContentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFolderContentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFolderContents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFolderContents",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFolderContentsInput`](crate::input::DeleteFolderContentsInput)
    pub fn builder() -> crate::input::delete_folder_contents_input::Builder {
        crate::input::delete_folder_contents_input::Builder::default()
    }
}

/// See [`DeleteLabelsInput`](crate::input::DeleteLabelsInput)
pub mod delete_labels_input {
    /// A builder for [`DeleteLabelsInput`](crate::input::DeleteLabelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) delete_all: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>List of labels to delete from the resource.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>List of labels to delete from the resource.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>Flag to request removal of all labels from the specified resource.</p>
        pub fn delete_all(mut self, input: bool) -> Self {
            self.delete_all = Some(input);
            self
        }
        /// <p>Flag to request removal of all labels from the specified resource.</p>
        pub fn set_delete_all(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_all = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLabelsInput`](crate::input::DeleteLabelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLabelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLabelsInput {
                resource_id: self.resource_id,
                authentication_token: self.authentication_token,
                labels: self.labels,
                delete_all: self.delete_all.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLabelsInputOperationOutputAlias = crate::operation::DeleteLabels;
#[doc(hidden)]
pub type DeleteLabelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLabelsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLabels`](crate::operation::DeleteLabels)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLabels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLabelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.resource_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_50, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/resources/{ResourceId}/labels",
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteLabelsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_51) = &_input.authentication_token {
                let formatted_52 = AsRef::<str>::as_ref(inner_51);
                if !formatted_52.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_52;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::DeleteLabelsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_53) = &_input.labels {
                for inner_54 in inner_53 {
                    query.push_kv("labels", &aws_smithy_http::query::fmt_string(&inner_54));
                }
            }
            if _input.delete_all {
                query.push_kv(
                    "deleteAll",
                    &aws_smithy_types::primitive::Encoder::from(_input.delete_all).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLabelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLabelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLabels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLabels",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLabelsInput`](crate::input::DeleteLabelsInput)
    pub fn builder() -> crate::input::delete_labels_input::Builder {
        crate::input::delete_labels_input::Builder::default()
    }
}

/// See [`DeleteNotificationSubscriptionInput`](crate::input::DeleteNotificationSubscriptionInput)
pub mod delete_notification_subscription_input {
    /// A builder for [`DeleteNotificationSubscriptionInput`](crate::input::DeleteNotificationSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_id: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the subscription.</p>
        pub fn subscription_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_id = Some(input.into());
            self
        }
        /// <p>The ID of the subscription.</p>
        pub fn set_subscription_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_id = input;
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNotificationSubscriptionInput`](crate::input::DeleteNotificationSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNotificationSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNotificationSubscriptionInput {
                subscription_id: self.subscription_id,
                organization_id: self.organization_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNotificationSubscriptionInputOperationOutputAlias =
    crate::operation::DeleteNotificationSubscription;
#[doc(hidden)]
pub type DeleteNotificationSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteNotificationSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNotificationSubscription`](crate::operation::DeleteNotificationSubscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNotificationSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNotificationSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.organization_id;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "organization_id",
                        details: "cannot be empty or unset",
                    })?;
            let organization_id = aws_smithy_http::label::fmt_string(input_55, false);
            if organization_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "organization_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_56 = &_input.subscription_id;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscription_id",
                        details: "cannot be empty or unset",
                    })?;
            let subscription_id = aws_smithy_http::label::fmt_string(input_56, false);
            if subscription_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "subscription_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/organizations/{OrganizationId}/subscriptions/{SubscriptionId}",
                OrganizationId = organization_id,
                SubscriptionId = subscription_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNotificationSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNotificationSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNotificationSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNotificationSubscription",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNotificationSubscriptionInput`](crate::input::DeleteNotificationSubscriptionInput)
    pub fn builder() -> crate::input::delete_notification_subscription_input::Builder {
        crate::input::delete_notification_subscription_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Do not set this field when using
        /// administrative API actions, as in accessing the API using AWS credentials.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Do not set this field when using
        /// administrative API actions, as in accessing the API using AWS credentials.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                authentication_token: self.authentication_token,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_57 = &_input.user_id;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_57, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/api/v1/users/{UserId}", UserId = user_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_58) = &_input.authentication_token {
                let formatted_59 = AsRef::<str>::as_ref(inner_58);
                if !formatted_59.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_59;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DescribeActivitiesInput`](crate::input::DescribeActivitiesInput)
pub mod describe_activities_input {
    /// A builder for [`DescribeActivitiesInput`](crate::input::DescribeActivitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) activity_types: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) include_indirect_activities: std::option::Option<bool>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The timestamp that determines the starting time of the activities. The response
        /// includes the activities performed after the specified timestamp.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The timestamp that determines the starting time of the activities. The response
        /// includes the activities performed after the specified timestamp.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The timestamp that determines the end time of the activities. The response includes
        /// the activities performed before the specified timestamp.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The timestamp that determines the end time of the activities. The response includes
        /// the activities performed before the specified timestamp.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The ID of the organization. This is a mandatory parameter when using administrative
        /// API (SigV4) requests.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization. This is a mandatory parameter when using administrative
        /// API (SigV4) requests.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>Specifies which activity types to include in the response. If this field is left
        /// empty, all activity types are returned.</p>
        pub fn activity_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_types = Some(input.into());
            self
        }
        /// <p>Specifies which activity types to include in the response. If this field is left
        /// empty, all activity types are returned.</p>
        pub fn set_activity_types(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activity_types = input;
            self
        }
        /// <p>The document or folder ID for which to describe activity types.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The document or folder ID for which to describe activity types.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ID of the user who performed the action. The response includes activities
        /// pertaining to this user. This is an optional parameter and is only applicable for
        /// administrative API (SigV4) requests.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user who performed the action. The response includes activities
        /// pertaining to this user. This is an optional parameter and is only applicable for
        /// administrative API (SigV4) requests.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>Includes indirect activities. An indirect activity results from a direct activity
        /// performed on a parent resource. For example, sharing a parent folder (the direct
        /// activity) shares all of the subfolders and documents within the parent folder (the
        /// indirect activity).</p>
        pub fn include_indirect_activities(mut self, input: bool) -> Self {
            self.include_indirect_activities = Some(input);
            self
        }
        /// <p>Includes indirect activities. An indirect activity results from a direct activity
        /// performed on a parent resource. For example, sharing a parent folder (the direct
        /// activity) shares all of the subfolders and documents within the parent folder (the
        /// indirect activity).</p>
        pub fn set_include_indirect_activities(mut self, input: std::option::Option<bool>) -> Self {
            self.include_indirect_activities = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActivitiesInput`](crate::input::DescribeActivitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeActivitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeActivitiesInput {
                authentication_token: self.authentication_token,
                start_time: self.start_time,
                end_time: self.end_time,
                organization_id: self.organization_id,
                activity_types: self.activity_types,
                resource_id: self.resource_id,
                user_id: self.user_id,
                include_indirect_activities: self.include_indirect_activities.unwrap_or_default(),
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeActivitiesInputOperationOutputAlias = crate::operation::DescribeActivities;
#[doc(hidden)]
pub type DescribeActivitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeActivitiesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeActivities`](crate::operation::DescribeActivities)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeActivities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeActivitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/api/v1/activities").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeActivitiesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_60) = &_input.authentication_token {
                let formatted_61 = AsRef::<str>::as_ref(inner_60);
                if !formatted_61.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_61;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::DescribeActivitiesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_62) = &_input.start_time {
                query.push_kv(
                    "startTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_62,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_63) = &_input.end_time {
                query.push_kv(
                    "endTime",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_63,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_64) = &_input.organization_id {
                query.push_kv(
                    "organizationId",
                    &aws_smithy_http::query::fmt_string(&inner_64),
                );
            }
            if let Some(inner_65) = &_input.activity_types {
                query.push_kv(
                    "activityTypes",
                    &aws_smithy_http::query::fmt_string(&inner_65),
                );
            }
            if let Some(inner_66) = &_input.resource_id {
                query.push_kv("resourceId", &aws_smithy_http::query::fmt_string(&inner_66));
            }
            if let Some(inner_67) = &_input.user_id {
                query.push_kv("userId", &aws_smithy_http::query::fmt_string(&inner_67));
            }
            if _input.include_indirect_activities {
                query.push_kv(
                    "includeIndirectActivities",
                    &aws_smithy_types::primitive::Encoder::from(_input.include_indirect_activities)
                        .encode(),
                );
            }
            if let Some(inner_68) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_68).encode(),
                );
            }
            if let Some(inner_69) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_69));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeActivitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeActivitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeActivities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeActivities",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeActivitiesInput`](crate::input::DescribeActivitiesInput)
    pub fn builder() -> crate::input::describe_activities_input::Builder {
        crate::input::describe_activities_input::Builder::default()
    }
}

/// See [`DescribeCommentsInput`](crate::input::DescribeCommentsInput)
pub mod describe_comments_input {
    /// A builder for [`DescribeCommentsInput`](crate::input::DescribeCommentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the document version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous
        /// call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous
        /// call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCommentsInput`](crate::input::DescribeCommentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCommentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCommentsInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCommentsInputOperationOutputAlias = crate::operation::DescribeComments;
#[doc(hidden)]
pub type DescribeCommentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCommentsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeComments`](crate::operation::DescribeComments)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeComments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCommentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_70 = &_input.document_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_70, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_71 = &_input.version_id;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    })?;
            let version_id = aws_smithy_http::label::fmt_string(input_71, false);
            if version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}/versions/{VersionId}/comments",
                DocumentId = document_id,
                VersionId = version_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeCommentsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_72) = &_input.authentication_token {
                let formatted_73 = AsRef::<str>::as_ref(inner_72);
                if !formatted_73.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_73;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::DescribeCommentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_74) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_74).encode(),
                );
            }
            if let Some(inner_75) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_75));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCommentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCommentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeComments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeComments",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCommentsInput`](crate::input::DescribeCommentsInput)
    pub fn builder() -> crate::input::describe_comments_input::Builder {
        crate::input::describe_comments_input::Builder::default()
    }
}

/// See [`DescribeDocumentVersionsInput`](crate::input::DescribeDocumentVersionsInput)
pub mod describe_document_versions_input {
    /// A builder for [`DescribeDocumentVersionsInput`](crate::input::DescribeDocumentVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) include: std::option::Option<std::string::String>,
        pub(crate) fields: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of versions to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of versions to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A comma-separated list of values. Specify "INITIALIZED" to include incomplete
        /// versions.</p>
        pub fn include(mut self, input: impl Into<std::string::String>) -> Self {
            self.include = Some(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "INITIALIZED" to include incomplete
        /// versions.</p>
        pub fn set_include(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.include = input;
            self
        }
        /// <p>Specify "SOURCE" to include initialized versions and a URL for the source
        /// document.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.fields = Some(input.into());
            self
        }
        /// <p>Specify "SOURCE" to include initialized versions and a URL for the source
        /// document.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDocumentVersionsInput`](crate::input::DescribeDocumentVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDocumentVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDocumentVersionsInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                marker: self.marker,
                limit: self.limit,
                include: self.include,
                fields: self.fields,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDocumentVersionsInputOperationOutputAlias =
    crate::operation::DescribeDocumentVersions;
#[doc(hidden)]
pub type DescribeDocumentVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDocumentVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDocumentVersions`](crate::operation::DescribeDocumentVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDocumentVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDocumentVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_76 = &_input.document_id;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_76, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}/versions",
                DocumentId = document_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeDocumentVersionsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_77) = &_input.authentication_token {
                let formatted_78 = AsRef::<str>::as_ref(inner_77);
                if !formatted_78.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_78;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DescribeDocumentVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_79) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_79));
            }
            if let Some(inner_80) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_80).encode(),
                );
            }
            if let Some(inner_81) = &_input.include {
                query.push_kv("include", &aws_smithy_http::query::fmt_string(&inner_81));
            }
            if let Some(inner_82) = &_input.fields {
                query.push_kv("fields", &aws_smithy_http::query::fmt_string(&inner_82));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDocumentVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDocumentVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDocumentVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDocumentVersions",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDocumentVersionsInput`](crate::input::DescribeDocumentVersionsInput)
    pub fn builder() -> crate::input::describe_document_versions_input::Builder {
        crate::input::describe_document_versions_input::Builder::default()
    }
}

/// See [`DescribeFolderContentsInput`](crate::input::DescribeFolderContentsInput)
pub mod describe_folder_contents_input {
    /// A builder for [`DescribeFolderContentsInput`](crate::input::DescribeFolderContentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) sort: std::option::Option<crate::model::ResourceSortType>,
        pub(crate) order: std::option::Option<crate::model::OrderType>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::FolderContentType>,
        pub(crate) include: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn sort(mut self, input: crate::model::ResourceSortType) -> Self {
            self.sort = Some(input);
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn set_sort(
            mut self,
            input: std::option::Option<crate::model::ResourceSortType>,
        ) -> Self {
            self.sort = input;
            self
        }
        /// <p>The order for the contents of the folder.</p>
        pub fn order(mut self, input: crate::model::OrderType) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order for the contents of the folder.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::OrderType>) -> Self {
            self.order = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous
        /// call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous
        /// call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The type of items.</p>
        pub fn r#type(mut self, input: crate::model::FolderContentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of items.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::FolderContentType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The contents to include. Specify "INITIALIZED" to include initialized
        /// documents.</p>
        pub fn include(mut self, input: impl Into<std::string::String>) -> Self {
            self.include = Some(input.into());
            self
        }
        /// <p>The contents to include. Specify "INITIALIZED" to include initialized
        /// documents.</p>
        pub fn set_include(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.include = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFolderContentsInput`](crate::input::DescribeFolderContentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFolderContentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFolderContentsInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
                sort: self.sort,
                order: self.order,
                limit: self.limit,
                marker: self.marker,
                r#type: self.r#type,
                include: self.include,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFolderContentsInputOperationOutputAlias = crate::operation::DescribeFolderContents;
#[doc(hidden)]
pub type DescribeFolderContentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFolderContentsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFolderContents`](crate::operation::DescribeFolderContents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFolderContents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFolderContentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_83 = &_input.folder_id;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_83, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/folders/{FolderId}/contents",
                FolderId = folder_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeFolderContentsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_84) = &_input.authentication_token {
                let formatted_85 = AsRef::<str>::as_ref(inner_84);
                if !formatted_85.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_85;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::DescribeFolderContentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_86) = &_input.sort {
                query.push_kv("sort", &aws_smithy_http::query::fmt_string(&inner_86));
            }
            if let Some(inner_87) = &_input.order {
                query.push_kv("order", &aws_smithy_http::query::fmt_string(&inner_87));
            }
            if let Some(inner_88) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_88).encode(),
                );
            }
            if let Some(inner_89) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_89));
            }
            if let Some(inner_90) = &_input.r#type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_90));
            }
            if let Some(inner_91) = &_input.include {
                query.push_kv("include", &aws_smithy_http::query::fmt_string(&inner_91));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFolderContentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFolderContentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFolderContents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFolderContents",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFolderContentsInput`](crate::input::DescribeFolderContentsInput)
    pub fn builder() -> crate::input::describe_folder_contents_input::Builder {
        crate::input::describe_folder_contents_input::Builder::default()
    }
}

/// See [`DescribeGroupsInput`](crate::input::DescribeGroupsInput)
pub mod describe_groups_input {
    /// A builder for [`DescribeGroupsInput`](crate::input::DescribeGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) search_query: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>A query to describe groups by group name.</p>
        pub fn search_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.search_query = Some(input.into());
            self
        }
        /// <p>A query to describe groups by group name.</p>
        pub fn set_search_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.search_query = input;
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGroupsInput`](crate::input::DescribeGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGroupsInput {
                authentication_token: self.authentication_token,
                search_query: self.search_query,
                organization_id: self.organization_id,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGroupsInputOperationOutputAlias = crate::operation::DescribeGroups;
#[doc(hidden)]
pub type DescribeGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGroups`](crate::operation::DescribeGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/api/v1/groups").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeGroupsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_92) = &_input.authentication_token {
                let formatted_93 = AsRef::<str>::as_ref(inner_92);
                if !formatted_93.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_93;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::DescribeGroupsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_94) = &_input.search_query {
                query.push_kv(
                    "searchQuery",
                    &aws_smithy_http::query::fmt_string(&inner_94),
                );
            }
            if let Some(inner_95) = &_input.organization_id {
                query.push_kv(
                    "organizationId",
                    &aws_smithy_http::query::fmt_string(&inner_95),
                );
            }
            if let Some(inner_96) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_96));
            }
            if let Some(inner_97) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_97).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGroups",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGroupsInput`](crate::input::DescribeGroupsInput)
    pub fn builder() -> crate::input::describe_groups_input::Builder {
        crate::input::describe_groups_input::Builder::default()
    }
}

/// See [`DescribeNotificationSubscriptionsInput`](crate::input::DescribeNotificationSubscriptionsInput)
pub mod describe_notification_subscriptions_input {
    /// A builder for [`DescribeNotificationSubscriptionsInput`](crate::input::DescribeNotificationSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotificationSubscriptionsInput`](crate::input::DescribeNotificationSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNotificationSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNotificationSubscriptionsInput {
                organization_id: self.organization_id,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNotificationSubscriptionsInputOperationOutputAlias =
    crate::operation::DescribeNotificationSubscriptions;
#[doc(hidden)]
pub type DescribeNotificationSubscriptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeNotificationSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNotificationSubscriptions`](crate::operation::DescribeNotificationSubscriptions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNotificationSubscriptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeNotificationSubscriptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_98 = &_input.organization_id;
            let input_98 =
                input_98
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "organization_id",
                        details: "cannot be empty or unset",
                    })?;
            let organization_id = aws_smithy_http::label::fmt_string(input_98, false);
            if organization_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "organization_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/organizations/{OrganizationId}/subscriptions",
                OrganizationId = organization_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeNotificationSubscriptionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_99) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_99));
            }
            if let Some(inner_100) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_100).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeNotificationSubscriptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeNotificationSubscriptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNotificationSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNotificationSubscriptions",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeNotificationSubscriptionsInput`](crate::input::DescribeNotificationSubscriptionsInput)
    pub fn builder() -> crate::input::describe_notification_subscriptions_input::Builder {
        crate::input::describe_notification_subscriptions_input::Builder::default()
    }
}

/// See [`DescribeResourcePermissionsInput`](crate::input::DescribeResourcePermissionsInput)
pub mod describe_resource_permissions_input {
    /// A builder for [`DescribeResourcePermissionsInput`](crate::input::DescribeResourcePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ID of the principal to filter permissions by.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The ID of the principal to filter permissions by.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourcePermissionsInput`](crate::input::DescribeResourcePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeResourcePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeResourcePermissionsInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
                principal_id: self.principal_id,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeResourcePermissionsInputOperationOutputAlias =
    crate::operation::DescribeResourcePermissions;
#[doc(hidden)]
pub type DescribeResourcePermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeResourcePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeResourcePermissions`](crate::operation::DescribeResourcePermissions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeResourcePermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeResourcePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_101 = &_input.resource_id;
            let input_101 =
                input_101
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_101, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/resources/{ResourceId}/permissions",
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeResourcePermissionsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_102) = &_input.authentication_token {
                let formatted_103 = AsRef::<str>::as_ref(inner_102);
                if !formatted_103.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_103;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DescribeResourcePermissionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_104) = &_input.principal_id {
                query.push_kv(
                    "principalId",
                    &aws_smithy_http::query::fmt_string(&inner_104),
                );
            }
            if let Some(inner_105) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_105).encode(),
                );
            }
            if let Some(inner_106) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_106));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeResourcePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeResourcePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeResourcePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeResourcePermissions",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeResourcePermissionsInput`](crate::input::DescribeResourcePermissionsInput)
    pub fn builder() -> crate::input::describe_resource_permissions_input::Builder {
        crate::input::describe_resource_permissions_input::Builder::default()
    }
}

/// See [`DescribeRootFoldersInput`](crate::input::DescribeRootFoldersInput)
pub mod describe_root_folders_input {
    /// A builder for [`DescribeRootFoldersInput`](crate::input::DescribeRootFoldersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRootFoldersInput`](crate::input::DescribeRootFoldersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRootFoldersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRootFoldersInput {
                authentication_token: self.authentication_token,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRootFoldersInputOperationOutputAlias = crate::operation::DescribeRootFolders;
#[doc(hidden)]
pub type DescribeRootFoldersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRootFoldersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRootFolders`](crate::operation::DescribeRootFolders)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRootFolders,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRootFoldersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/api/v1/me/root").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeRootFoldersInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_107) = &_input.authentication_token {
                let formatted_108 = AsRef::<str>::as_ref(inner_107);
                if !formatted_108.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_108;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::DescribeRootFoldersInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_109) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_109).encode(),
                );
            }
            if let Some(inner_110) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_110));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRootFoldersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRootFoldersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRootFolders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRootFolders",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRootFoldersInput`](crate::input::DescribeRootFoldersInput)
    pub fn builder() -> crate::input::describe_root_folders_input::Builder {
        crate::input::describe_root_folders_input::Builder::default()
    }
}

/// See [`DescribeUsersInput`](crate::input::DescribeUsersInput)
pub mod describe_users_input {
    /// A builder for [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) user_ids: std::option::Option<std::string::String>,
        pub(crate) query: std::option::Option<std::string::String>,
        pub(crate) include: std::option::Option<crate::model::UserFilterType>,
        pub(crate) order: std::option::Option<crate::model::OrderType>,
        pub(crate) sort: std::option::Option<crate::model::UserSortType>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) fields: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The ID of the organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>The IDs of the users.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_ids = Some(input.into());
            self
        }
        /// <p>The IDs of the users.</p>
        pub fn set_user_ids(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_ids = input;
            self
        }
        /// <p>A query to filter users by user name.</p>
        pub fn query(mut self, input: impl Into<std::string::String>) -> Self {
            self.query = Some(input.into());
            self
        }
        /// <p>A query to filter users by user name.</p>
        pub fn set_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query = input;
            self
        }
        /// <p>The state of the users. Specify "ALL" to include inactive users.</p>
        pub fn include(mut self, input: crate::model::UserFilterType) -> Self {
            self.include = Some(input);
            self
        }
        /// <p>The state of the users. Specify "ALL" to include inactive users.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<crate::model::UserFilterType>,
        ) -> Self {
            self.include = input;
            self
        }
        /// <p>The order for the results.</p>
        pub fn order(mut self, input: crate::model::OrderType) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order for the results.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::OrderType>) -> Self {
            self.order = input;
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn sort(mut self, input: crate::model::UserSortType) -> Self {
            self.sort = Some(input);
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::UserSortType>) -> Self {
            self.sort = input;
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. (You received this marker from a previous
        /// call.)</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A comma-separated list of values. Specify "STORAGE_METADATA" to include the user
        /// storage quota and utilization information.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.fields = Some(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "STORAGE_METADATA" to include the user
        /// storage quota and utilization information.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsersInput`](crate::input::DescribeUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUsersInput {
                authentication_token: self.authentication_token,
                organization_id: self.organization_id,
                user_ids: self.user_ids,
                query: self.query,
                include: self.include,
                order: self.order,
                sort: self.sort,
                marker: self.marker,
                limit: self.limit,
                fields: self.fields,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUsersInputOperationOutputAlias = crate::operation::DescribeUsers;
#[doc(hidden)]
pub type DescribeUsersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeUsersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUsers`](crate::operation::DescribeUsers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUsers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/api/v1/users").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeUsersInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_111) = &_input.authentication_token {
                let formatted_112 = AsRef::<str>::as_ref(inner_111);
                if !formatted_112.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_112;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::DescribeUsersInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_113) = &_input.organization_id {
                query.push_kv(
                    "organizationId",
                    &aws_smithy_http::query::fmt_string(&inner_113),
                );
            }
            if let Some(inner_114) = &_input.user_ids {
                query.push_kv("userIds", &aws_smithy_http::query::fmt_string(&inner_114));
            }
            if let Some(inner_115) = &_input.query {
                query.push_kv("query", &aws_smithy_http::query::fmt_string(&inner_115));
            }
            if let Some(inner_116) = &_input.include {
                query.push_kv("include", &aws_smithy_http::query::fmt_string(&inner_116));
            }
            if let Some(inner_117) = &_input.order {
                query.push_kv("order", &aws_smithy_http::query::fmt_string(&inner_117));
            }
            if let Some(inner_118) = &_input.sort {
                query.push_kv("sort", &aws_smithy_http::query::fmt_string(&inner_118));
            }
            if let Some(inner_119) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_119));
            }
            if let Some(inner_120) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_120).encode(),
                );
            }
            if let Some(inner_121) = &_input.fields {
                query.push_kv("fields", &aws_smithy_http::query::fmt_string(&inner_121));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUsers",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    pub fn builder() -> crate::input::describe_users_input::Builder {
        crate::input::describe_users_input::Builder::default()
    }
}

/// See [`GetCurrentUserInput`](crate::input::GetCurrentUserInput)
pub mod get_current_user_input {
    /// A builder for [`GetCurrentUserInput`](crate::input::GetCurrentUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCurrentUserInput`](crate::input::GetCurrentUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCurrentUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCurrentUserInput {
                authentication_token: self.authentication_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCurrentUserInputOperationOutputAlias = crate::operation::GetCurrentUser;
#[doc(hidden)]
pub type GetCurrentUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCurrentUserInput {
    /// Consumes the builder and constructs an Operation<[`GetCurrentUser`](crate::operation::GetCurrentUser)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCurrentUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCurrentUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/api/v1/me").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetCurrentUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_122) = &_input.authentication_token {
                let formatted_123 = AsRef::<str>::as_ref(inner_122);
                if !formatted_123.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_123;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCurrentUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCurrentUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCurrentUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCurrentUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCurrentUserInput`](crate::input::GetCurrentUserInput)
    pub fn builder() -> crate::input::get_current_user_input::Builder {
        crate::input::get_current_user_input::Builder::default()
    }
}

/// See [`GetDocumentInput`](crate::input::GetDocumentInput)
pub mod get_document_input {
    /// A builder for [`GetDocumentInput`](crate::input::GetDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) include_custom_metadata: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>Set this to <code>TRUE</code> to include custom metadata in the response.</p>
        pub fn include_custom_metadata(mut self, input: bool) -> Self {
            self.include_custom_metadata = Some(input);
            self
        }
        /// <p>Set this to <code>TRUE</code> to include custom metadata in the response.</p>
        pub fn set_include_custom_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.include_custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentInput`](crate::input::GetDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                include_custom_metadata: self.include_custom_metadata.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentInputOperationOutputAlias = crate::operation::GetDocument;
#[doc(hidden)]
pub type GetDocumentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDocumentInput {
    /// Consumes the builder and constructs an Operation<[`GetDocument`](crate::operation::GetDocument)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocument,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_124 = &_input.document_id;
            let input_124 =
                input_124
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_124, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}",
                DocumentId = document_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetDocumentInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_125) = &_input.authentication_token {
                let formatted_126 = AsRef::<str>::as_ref(inner_125);
                if !formatted_126.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_126;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::GetDocumentInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.include_custom_metadata {
                query.push_kv(
                    "includeCustomMetadata",
                    &aws_smithy_types::primitive::Encoder::from(_input.include_custom_metadata)
                        .encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocument",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentInput`](crate::input::GetDocumentInput)
    pub fn builder() -> crate::input::get_document_input::Builder {
        crate::input::get_document_input::Builder::default()
    }
}

/// See [`GetDocumentPathInput`](crate::input::GetDocumentPathInput)
pub mod get_document_path_input {
    /// A builder for [`GetDocumentPathInput`](crate::input::GetDocumentPathInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) fields: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A comma-separated list of values. Specify <code>NAME</code> to include the names of
        /// the parent folders.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.fields = Some(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify <code>NAME</code> to include the names of
        /// the parent folders.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fields = input;
            self
        }
        /// <p>This value is not supported.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>This value is not supported.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentPathInput`](crate::input::GetDocumentPathInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentPathInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentPathInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                limit: self.limit,
                fields: self.fields,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentPathInputOperationOutputAlias = crate::operation::GetDocumentPath;
#[doc(hidden)]
pub type GetDocumentPathInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDocumentPathInput {
    /// Consumes the builder and constructs an Operation<[`GetDocumentPath`](crate::operation::GetDocumentPath)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocumentPath,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDocumentPathInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_127 = &_input.document_id;
            let input_127 =
                input_127
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_127, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}/path",
                DocumentId = document_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetDocumentPathInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_128) = &_input.authentication_token {
                let formatted_129 = AsRef::<str>::as_ref(inner_128);
                if !formatted_129.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_129;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::GetDocumentPathInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_130) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_130).encode(),
                );
            }
            if let Some(inner_131) = &_input.fields {
                query.push_kv("fields", &aws_smithy_http::query::fmt_string(&inner_131));
            }
            if let Some(inner_132) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_132));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDocumentPathInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDocumentPathInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocumentPath::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocumentPath",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentPathInput`](crate::input::GetDocumentPathInput)
    pub fn builder() -> crate::input::get_document_path_input::Builder {
        crate::input::get_document_path_input::Builder::default()
    }
}

/// See [`GetDocumentVersionInput`](crate::input::GetDocumentVersionInput)
pub mod get_document_version_input {
    /// A builder for [`GetDocumentVersionInput`](crate::input::GetDocumentVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) fields: std::option::Option<std::string::String>,
        pub(crate) include_custom_metadata: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>A comma-separated list of values. Specify "SOURCE" to include a URL for the source
        /// document.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.fields = Some(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "SOURCE" to include a URL for the source
        /// document.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fields = input;
            self
        }
        /// <p>Set this to TRUE to include custom metadata in the response.</p>
        pub fn include_custom_metadata(mut self, input: bool) -> Self {
            self.include_custom_metadata = Some(input);
            self
        }
        /// <p>Set this to TRUE to include custom metadata in the response.</p>
        pub fn set_include_custom_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.include_custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentVersionInput`](crate::input::GetDocumentVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentVersionInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
                fields: self.fields,
                include_custom_metadata: self.include_custom_metadata.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentVersionInputOperationOutputAlias = crate::operation::GetDocumentVersion;
#[doc(hidden)]
pub type GetDocumentVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDocumentVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetDocumentVersion`](crate::operation::GetDocumentVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocumentVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDocumentVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_133 = &_input.document_id;
            let input_133 =
                input_133
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_133, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_134 = &_input.version_id;
            let input_134 =
                input_134
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    })?;
            let version_id = aws_smithy_http::label::fmt_string(input_134, false);
            if version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}/versions/{VersionId}",
                DocumentId = document_id,
                VersionId = version_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetDocumentVersionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_135) = &_input.authentication_token {
                let formatted_136 = AsRef::<str>::as_ref(inner_135);
                if !formatted_136.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_136;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::GetDocumentVersionInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_137) = &_input.fields {
                query.push_kv("fields", &aws_smithy_http::query::fmt_string(&inner_137));
            }
            if _input.include_custom_metadata {
                query.push_kv(
                    "includeCustomMetadata",
                    &aws_smithy_types::primitive::Encoder::from(_input.include_custom_metadata)
                        .encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDocumentVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDocumentVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocumentVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocumentVersion",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentVersionInput`](crate::input::GetDocumentVersionInput)
    pub fn builder() -> crate::input::get_document_version_input::Builder {
        crate::input::get_document_version_input::Builder::default()
    }
}

/// See [`GetFolderInput`](crate::input::GetFolderInput)
pub mod get_folder_input {
    /// A builder for [`GetFolderInput`](crate::input::GetFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) include_custom_metadata: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>Set to TRUE to include custom metadata in the response.</p>
        pub fn include_custom_metadata(mut self, input: bool) -> Self {
            self.include_custom_metadata = Some(input);
            self
        }
        /// <p>Set to TRUE to include custom metadata in the response.</p>
        pub fn set_include_custom_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.include_custom_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFolderInput`](crate::input::GetFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetFolderInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetFolderInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
                include_custom_metadata: self.include_custom_metadata.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetFolderInputOperationOutputAlias = crate::operation::GetFolder;
#[doc(hidden)]
pub type GetFolderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFolderInput {
    /// Consumes the builder and constructs an Operation<[`GetFolder`](crate::operation::GetFolder)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFolder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_138 = &_input.folder_id;
            let input_138 =
                input_138
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_138, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/api/v1/folders/{FolderId}", FolderId = folder_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetFolderInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_139) = &_input.authentication_token {
                let formatted_140 = AsRef::<str>::as_ref(inner_139);
                if !formatted_140.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_140;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::GetFolderInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.include_custom_metadata {
                query.push_kv(
                    "includeCustomMetadata",
                    &aws_smithy_types::primitive::Encoder::from(_input.include_custom_metadata)
                        .encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetFolder::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetFolder",
                    "workdocs",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFolderInput`](crate::input::GetFolderInput)
    pub fn builder() -> crate::input::get_folder_input::Builder {
        crate::input::get_folder_input::Builder::default()
    }
}

/// See [`GetFolderPathInput`](crate::input::GetFolderPathInput)
pub mod get_folder_path_input {
    /// A builder for [`GetFolderPathInput`](crate::input::GetFolderPathInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) fields: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of levels in the hierarchy to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A comma-separated list of values. Specify "NAME" to include the names of the parent
        /// folders.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.fields = Some(input.into());
            self
        }
        /// <p>A comma-separated list of values. Specify "NAME" to include the names of the parent
        /// folders.</p>
        pub fn set_fields(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fields = input;
            self
        }
        /// <p>This value is not supported.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>This value is not supported.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFolderPathInput`](crate::input::GetFolderPathInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFolderPathInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFolderPathInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
                limit: self.limit,
                fields: self.fields,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFolderPathInputOperationOutputAlias = crate::operation::GetFolderPath;
#[doc(hidden)]
pub type GetFolderPathInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFolderPathInput {
    /// Consumes the builder and constructs an Operation<[`GetFolderPath`](crate::operation::GetFolderPath)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFolderPath,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFolderPathInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_141 = &_input.folder_id;
            let input_141 =
                input_141
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_141, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/folders/{FolderId}/path",
                FolderId = folder_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetFolderPathInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_142) = &_input.authentication_token {
                let formatted_143 = AsRef::<str>::as_ref(inner_142);
                if !formatted_143.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_143;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::GetFolderPathInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_144) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_144).encode(),
                );
            }
            if let Some(inner_145) = &_input.fields {
                query.push_kv("fields", &aws_smithy_http::query::fmt_string(&inner_145));
            }
            if let Some(inner_146) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_146));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFolderPathInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFolderPathInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFolderPath::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFolderPath",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFolderPathInput`](crate::input::GetFolderPathInput)
    pub fn builder() -> crate::input::get_folder_path_input::Builder {
        crate::input::get_folder_path_input::Builder::default()
    }
}

/// See [`GetResourcesInput`](crate::input::GetResourcesInput)
pub mod get_resources_input {
    /// A builder for [`GetResourcesInput`](crate::input::GetResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) collection_type: std::option::Option<crate::model::ResourceCollectionType>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The user ID for the resource collection. This is a required field for accessing the
        /// API operation using IAM credentials.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID for the resource collection. This is a required field for accessing the
        /// API operation using IAM credentials.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The collection type.</p>
        pub fn collection_type(mut self, input: crate::model::ResourceCollectionType) -> Self {
            self.collection_type = Some(input);
            self
        }
        /// <p>The collection type.</p>
        pub fn set_collection_type(
            mut self,
            input: std::option::Option<crate::model::ResourceCollectionType>,
        ) -> Self {
            self.collection_type = input;
            self
        }
        /// <p>The maximum number of resources to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of resources to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcesInput`](crate::input::GetResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourcesInput {
                authentication_token: self.authentication_token,
                user_id: self.user_id,
                collection_type: self.collection_type,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourcesInputOperationOutputAlias = crate::operation::GetResources;
#[doc(hidden)]
pub type GetResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourcesInput {
    /// Consumes the builder and constructs an Operation<[`GetResources`](crate::operation::GetResources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/api/v1/resources").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetResourcesInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_147) = &_input.authentication_token {
                let formatted_148 = AsRef::<str>::as_ref(inner_147);
                if !formatted_148.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_148;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(_input: &crate::input::GetResourcesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_149) = &_input.user_id {
                query.push_kv("userId", &aws_smithy_http::query::fmt_string(&inner_149));
            }
            if let Some(inner_150) = &_input.collection_type {
                query.push_kv(
                    "collectionType",
                    &aws_smithy_http::query::fmt_string(&inner_150),
                );
            }
            if let Some(inner_151) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_151).encode(),
                );
            }
            if let Some(inner_152) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_152));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResources",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourcesInput`](crate::input::GetResourcesInput)
    pub fn builder() -> crate::input::get_resources_input::Builder {
        crate::input::get_resources_input::Builder::default()
    }
}

/// See [`InitiateDocumentVersionUploadInput`](crate::input::InitiateDocumentVersionUploadInput)
pub mod initiate_document_version_upload_input {
    /// A builder for [`InitiateDocumentVersionUploadInput`](crate::input::InitiateDocumentVersionUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) content_created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) content_modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) document_size_in_bytes: std::option::Option<i64>,
        pub(crate) parent_folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The timestamp when the content of the document was originally created.</p>
        pub fn content_created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.content_created_timestamp = Some(input);
            self
        }
        /// <p>The timestamp when the content of the document was originally created.</p>
        pub fn set_content_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.content_created_timestamp = input;
            self
        }
        /// <p>The timestamp when the content of the document was modified.</p>
        pub fn content_modified_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.content_modified_timestamp = Some(input);
            self
        }
        /// <p>The timestamp when the content of the document was modified.</p>
        pub fn set_content_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.content_modified_timestamp = input;
            self
        }
        /// <p>The content type of the document.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content type of the document.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The size of the document, in bytes.</p>
        pub fn document_size_in_bytes(mut self, input: i64) -> Self {
            self.document_size_in_bytes = Some(input);
            self
        }
        /// <p>The size of the document, in bytes.</p>
        pub fn set_document_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.document_size_in_bytes = input;
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateDocumentVersionUploadInput`](crate::input::InitiateDocumentVersionUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InitiateDocumentVersionUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InitiateDocumentVersionUploadInput {
                authentication_token: self.authentication_token,
                id: self.id,
                name: self.name,
                content_created_timestamp: self.content_created_timestamp,
                content_modified_timestamp: self.content_modified_timestamp,
                content_type: self.content_type,
                document_size_in_bytes: self.document_size_in_bytes,
                parent_folder_id: self.parent_folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type InitiateDocumentVersionUploadInputOperationOutputAlias =
    crate::operation::InitiateDocumentVersionUpload;
#[doc(hidden)]
pub type InitiateDocumentVersionUploadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl InitiateDocumentVersionUploadInput {
    /// Consumes the builder and constructs an Operation<[`InitiateDocumentVersionUpload`](crate::operation::InitiateDocumentVersionUpload)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InitiateDocumentVersionUpload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InitiateDocumentVersionUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/api/v1/documents").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::InitiateDocumentVersionUploadInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_153) = &_input.authentication_token {
                let formatted_154 = AsRef::<str>::as_ref(inner_153);
                if !formatted_154.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_154;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InitiateDocumentVersionUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InitiateDocumentVersionUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_initiate_document_version_upload(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InitiateDocumentVersionUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InitiateDocumentVersionUpload",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InitiateDocumentVersionUploadInput`](crate::input::InitiateDocumentVersionUploadInput)
    pub fn builder() -> crate::input::initiate_document_version_upload_input::Builder {
        crate::input::initiate_document_version_upload_input::Builder::default()
    }
}

/// See [`RemoveAllResourcePermissionsInput`](crate::input::RemoveAllResourcePermissionsInput)
pub mod remove_all_resource_permissions_input {
    /// A builder for [`RemoveAllResourcePermissionsInput`](crate::input::RemoveAllResourcePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAllResourcePermissionsInput`](crate::input::RemoveAllResourcePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveAllResourcePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveAllResourcePermissionsInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveAllResourcePermissionsInputOperationOutputAlias =
    crate::operation::RemoveAllResourcePermissions;
#[doc(hidden)]
pub type RemoveAllResourcePermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveAllResourcePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveAllResourcePermissions`](crate::operation::RemoveAllResourcePermissions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveAllResourcePermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveAllResourcePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_155 = &_input.resource_id;
            let input_155 =
                input_155
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_155, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/resources/{ResourceId}/permissions",
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::RemoveAllResourcePermissionsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_156) = &_input.authentication_token {
                let formatted_157 = AsRef::<str>::as_ref(inner_156);
                if !formatted_157.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_157;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveAllResourcePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveAllResourcePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveAllResourcePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveAllResourcePermissions",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveAllResourcePermissionsInput`](crate::input::RemoveAllResourcePermissionsInput)
    pub fn builder() -> crate::input::remove_all_resource_permissions_input::Builder {
        crate::input::remove_all_resource_permissions_input::Builder::default()
    }
}

/// See [`RemoveResourcePermissionInput`](crate::input::RemoveResourcePermissionInput)
pub mod remove_resource_permission_input {
    /// A builder for [`RemoveResourcePermissionInput`](crate::input::RemoveResourcePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) principal_type: std::option::Option<crate::model::PrincipalType>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The principal ID of the resource.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID of the resource.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The principal type of the resource.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.principal_type = Some(input);
            self
        }
        /// <p>The principal type of the resource.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.principal_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveResourcePermissionInput`](crate::input::RemoveResourcePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveResourcePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveResourcePermissionInput {
                authentication_token: self.authentication_token,
                resource_id: self.resource_id,
                principal_id: self.principal_id,
                principal_type: self.principal_type,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveResourcePermissionInputOperationOutputAlias =
    crate::operation::RemoveResourcePermission;
#[doc(hidden)]
pub type RemoveResourcePermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveResourcePermissionInput {
    /// Consumes the builder and constructs an Operation<[`RemoveResourcePermission`](crate::operation::RemoveResourcePermission)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveResourcePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveResourcePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_158 = &_input.resource_id;
            let input_158 =
                input_158
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_158, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_159 = &_input.principal_id;
            let input_159 =
                input_159
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    })?;
            let principal_id = aws_smithy_http::label::fmt_string(input_159, false);
            if principal_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "principal_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/resources/{ResourceId}/permissions/{PrincipalId}",
                ResourceId = resource_id,
                PrincipalId = principal_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::RemoveResourcePermissionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_160) = &_input.authentication_token {
                let formatted_161 = AsRef::<str>::as_ref(inner_160);
                if !formatted_161.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_161;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::RemoveResourcePermissionInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_162) = &_input.principal_type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_162));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveResourcePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveResourcePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveResourcePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveResourcePermission",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveResourcePermissionInput`](crate::input::RemoveResourcePermissionInput)
    pub fn builder() -> crate::input::remove_resource_permission_input::Builder {
        crate::input::remove_resource_permission_input::Builder::default()
    }
}

/// See [`UpdateDocumentInput`](crate::input::UpdateDocumentInput)
pub mod update_document_input {
    /// A builder for [`UpdateDocumentInput`](crate::input::UpdateDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parent_folder_id: std::option::Option<std::string::String>,
        pub(crate) resource_state: std::option::Option<crate::model::ResourceStateType>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The name of the document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_id = input;
            self
        }
        /// <p>The resource state of the document. Only ACTIVE and RECYCLED are
        /// supported.</p>
        pub fn resource_state(mut self, input: crate::model::ResourceStateType) -> Self {
            self.resource_state = Some(input);
            self
        }
        /// <p>The resource state of the document. Only ACTIVE and RECYCLED are
        /// supported.</p>
        pub fn set_resource_state(
            mut self,
            input: std::option::Option<crate::model::ResourceStateType>,
        ) -> Self {
            self.resource_state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDocumentInput`](crate::input::UpdateDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDocumentInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                name: self.name,
                parent_folder_id: self.parent_folder_id,
                resource_state: self.resource_state,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDocumentInputOperationOutputAlias = crate::operation::UpdateDocument;
#[doc(hidden)]
pub type UpdateDocumentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDocumentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDocument`](crate::operation::UpdateDocument)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDocument,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_163 = &_input.document_id;
            let input_163 =
                input_163
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_163, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}",
                DocumentId = document_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateDocumentInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_164) = &_input.authentication_token {
                let formatted_165 = AsRef::<str>::as_ref(inner_164);
                if !formatted_165.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_165;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_document(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDocument",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDocumentInput`](crate::input::UpdateDocumentInput)
    pub fn builder() -> crate::input::update_document_input::Builder {
        crate::input::update_document_input::Builder::default()
    }
}

/// See [`UpdateDocumentVersionInput`](crate::input::UpdateDocumentVersionInput)
pub mod update_document_version_input {
    /// A builder for [`UpdateDocumentVersionInput`](crate::input::UpdateDocumentVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) version_status: std::option::Option<crate::model::DocumentVersionStatus>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The ID of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the document.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The status of the version.</p>
        pub fn version_status(mut self, input: crate::model::DocumentVersionStatus) -> Self {
            self.version_status = Some(input);
            self
        }
        /// <p>The status of the version.</p>
        pub fn set_version_status(
            mut self,
            input: std::option::Option<crate::model::DocumentVersionStatus>,
        ) -> Self {
            self.version_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDocumentVersionInput`](crate::input::UpdateDocumentVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDocumentVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDocumentVersionInput {
                authentication_token: self.authentication_token,
                document_id: self.document_id,
                version_id: self.version_id,
                version_status: self.version_status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDocumentVersionInputOperationOutputAlias = crate::operation::UpdateDocumentVersion;
#[doc(hidden)]
pub type UpdateDocumentVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDocumentVersionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDocumentVersion`](crate::operation::UpdateDocumentVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDocumentVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDocumentVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_166 = &_input.document_id;
            let input_166 =
                input_166
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "document_id",
                        details: "cannot be empty or unset",
                    })?;
            let document_id = aws_smithy_http::label::fmt_string(input_166, false);
            if document_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "document_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_167 = &_input.version_id;
            let input_167 =
                input_167
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    })?;
            let version_id = aws_smithy_http::label::fmt_string(input_167, false);
            if version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/api/v1/documents/{DocumentId}/versions/{VersionId}",
                DocumentId = document_id,
                VersionId = version_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateDocumentVersionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_168) = &_input.authentication_token {
                let formatted_169 = AsRef::<str>::as_ref(inner_168);
                if !formatted_169.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_169;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDocumentVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDocumentVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_document_version(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDocumentVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDocumentVersion",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDocumentVersionInput`](crate::input::UpdateDocumentVersionInput)
    pub fn builder() -> crate::input::update_document_version_input::Builder {
        crate::input::update_document_version_input::Builder::default()
    }
}

/// See [`UpdateFolderInput`](crate::input::UpdateFolderInput)
pub mod update_folder_input {
    /// A builder for [`UpdateFolderInput`](crate::input::UpdateFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parent_folder_id: std::option::Option<std::string::String>,
        pub(crate) resource_state: std::option::Option<crate::model::ResourceStateType>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The name of the folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn parent_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent folder.</p>
        pub fn set_parent_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_id = input;
            self
        }
        /// <p>The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from
        /// the API.</p>
        pub fn resource_state(mut self, input: crate::model::ResourceStateType) -> Self {
            self.resource_state = Some(input);
            self
        }
        /// <p>The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from
        /// the API.</p>
        pub fn set_resource_state(
            mut self,
            input: std::option::Option<crate::model::ResourceStateType>,
        ) -> Self {
            self.resource_state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFolderInput`](crate::input::UpdateFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFolderInput {
                authentication_token: self.authentication_token,
                folder_id: self.folder_id,
                name: self.name,
                parent_folder_id: self.parent_folder_id,
                resource_state: self.resource_state,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFolderInputOperationOutputAlias = crate::operation::UpdateFolder;
#[doc(hidden)]
pub type UpdateFolderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFolderInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFolder`](crate::operation::UpdateFolder)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFolder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_170 = &_input.folder_id;
            let input_170 =
                input_170
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_170, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/api/v1/folders/{FolderId}", FolderId = folder_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateFolderInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_171) = &_input.authentication_token {
                let formatted_172 = AsRef::<str>::as_ref(inner_171);
                if !formatted_172.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_172;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_folder(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFolder",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFolderInput`](crate::input::UpdateFolderInput)
    pub fn builder() -> crate::input::update_folder_input::Builder {
        crate::input::update_folder_input::Builder::default()
    }
}

/// See [`UpdateUserInput`](crate::input::UpdateUserInput)
pub mod update_user_input {
    /// A builder for [`UpdateUserInput`](crate::input::UpdateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_token: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) given_name: std::option::Option<std::string::String>,
        pub(crate) surname: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::UserType>,
        pub(crate) storage_rule: std::option::Option<crate::model::StorageRuleType>,
        pub(crate) time_zone_id: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<crate::model::LocaleType>,
        pub(crate) grant_poweruser_privileges: std::option::Option<crate::model::BooleanEnumType>,
    }
    impl Builder {
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn authentication_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_token = Some(input.into());
            self
        }
        /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
        pub fn set_authentication_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_token = input;
            self
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The given name of the user.</p>
        pub fn given_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.given_name = Some(input.into());
            self
        }
        /// <p>The given name of the user.</p>
        pub fn set_given_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.given_name = input;
            self
        }
        /// <p>The surname of the user.</p>
        pub fn surname(mut self, input: impl Into<std::string::String>) -> Self {
            self.surname = Some(input.into());
            self
        }
        /// <p>The surname of the user.</p>
        pub fn set_surname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.surname = input;
            self
        }
        /// <p>The type of the user.</p>
        pub fn r#type(mut self, input: crate::model::UserType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the user.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn storage_rule(mut self, input: crate::model::StorageRuleType) -> Self {
            self.storage_rule = Some(input);
            self
        }
        /// <p>The amount of storage for the user.</p>
        pub fn set_storage_rule(
            mut self,
            input: std::option::Option<crate::model::StorageRuleType>,
        ) -> Self {
            self.storage_rule = input;
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn time_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone_id = Some(input.into());
            self
        }
        /// <p>The time zone ID of the user.</p>
        pub fn set_time_zone_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone_id = input;
            self
        }
        /// <p>The locale of the user.</p>
        pub fn locale(mut self, input: crate::model::LocaleType) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale of the user.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::LocaleType>) -> Self {
            self.locale = input;
            self
        }
        /// <p>Boolean value to determine whether the user is granted Poweruser privileges.</p>
        pub fn grant_poweruser_privileges(mut self, input: crate::model::BooleanEnumType) -> Self {
            self.grant_poweruser_privileges = Some(input);
            self
        }
        /// <p>Boolean value to determine whether the user is granted Poweruser privileges.</p>
        pub fn set_grant_poweruser_privileges(
            mut self,
            input: std::option::Option<crate::model::BooleanEnumType>,
        ) -> Self {
            self.grant_poweruser_privileges = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserInput`](crate::input::UpdateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserInput {
                authentication_token: self.authentication_token,
                user_id: self.user_id,
                given_name: self.given_name,
                surname: self.surname,
                r#type: self.r#type,
                storage_rule: self.storage_rule,
                time_zone_id: self.time_zone_id,
                locale: self.locale,
                grant_poweruser_privileges: self.grant_poweruser_privileges,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserInputOperationOutputAlias = crate::operation::UpdateUser;
#[doc(hidden)]
pub type UpdateUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateUserInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUser`](crate::operation::UpdateUser)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_173 = &_input.user_id;
            let input_173 =
                input_173
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_173, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/api/v1/users/{UserId}", UserId = user_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateUserInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_174) = &_input.authentication_token {
                let formatted_175 = AsRef::<str>::as_ref(inner_174);
                if !formatted_175.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_175;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "authentication_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("Authentication", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_user(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUser",
            "workdocs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The given name of the user.</p>
    pub given_name: std::option::Option<std::string::String>,
    /// <p>The surname of the user.</p>
    pub surname: std::option::Option<std::string::String>,
    /// <p>The type of the user.</p>
    pub r#type: std::option::Option<crate::model::UserType>,
    /// <p>The amount of storage for the user.</p>
    pub storage_rule: std::option::Option<crate::model::StorageRuleType>,
    /// <p>The time zone ID of the user.</p>
    pub time_zone_id: std::option::Option<std::string::String>,
    /// <p>The locale of the user.</p>
    pub locale: std::option::Option<crate::model::LocaleType>,
    /// <p>Boolean value to determine whether the user is granted Poweruser privileges.</p>
    pub grant_poweruser_privileges: std::option::Option<crate::model::BooleanEnumType>,
}
impl std::fmt::Debug for UpdateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("user_id", &self.user_id);
        formatter.field("given_name", &self.given_name);
        formatter.field("surname", &self.surname);
        formatter.field("r#type", &self.r#type);
        formatter.field("storage_rule", &self.storage_rule);
        formatter.field("time_zone_id", &self.time_zone_id);
        formatter.field("locale", &self.locale);
        formatter.field(
            "grant_poweruser_privileges",
            &self.grant_poweruser_privileges,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The name of the folder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the parent folder.</p>
    pub parent_folder_id: std::option::Option<std::string::String>,
    /// <p>The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from
    /// the API.</p>
    pub resource_state: std::option::Option<crate::model::ResourceStateType>,
}
impl std::fmt::Debug for UpdateFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFolderInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.field("name", &self.name);
        formatter.field("parent_folder_id", &self.parent_folder_id);
        formatter.field("resource_state", &self.resource_state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentVersionInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The version ID of the document.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The status of the version.</p>
    pub version_status: std::option::Option<crate::model::DocumentVersionStatus>,
}
impl std::fmt::Debug for UpdateDocumentVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentVersionInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("version_status", &self.version_status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The name of the document.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the parent folder.</p>
    pub parent_folder_id: std::option::Option<std::string::String>,
    /// <p>The resource state of the document. Only ACTIVE and RECYCLED are
    /// supported.</p>
    pub resource_state: std::option::Option<crate::model::ResourceStateType>,
}
impl std::fmt::Debug for UpdateDocumentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("name", &self.name);
        formatter.field("parent_folder_id", &self.parent_folder_id);
        formatter.field("resource_state", &self.resource_state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveResourcePermissionInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The principal ID of the resource.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The principal type of the resource.</p>
    pub principal_type: std::option::Option<crate::model::PrincipalType>,
}
impl std::fmt::Debug for RemoveResourcePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveResourcePermissionInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("principal_type", &self.principal_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAllResourcePermissionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveAllResourcePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAllResourcePermissionsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateDocumentVersionUploadInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the document.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The timestamp when the content of the document was originally created.</p>
    pub content_created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp when the content of the document was modified.</p>
    pub content_modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The content type of the document.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The size of the document, in bytes.</p>
    pub document_size_in_bytes: std::option::Option<i64>,
    /// <p>The ID of the parent folder.</p>
    pub parent_folder_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InitiateDocumentVersionUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateDocumentVersionUploadInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("content_created_timestamp", &self.content_created_timestamp);
        formatter.field(
            "content_modified_timestamp",
            &self.content_modified_timestamp,
        );
        formatter.field("content_type", &self.content_type);
        formatter.field("document_size_in_bytes", &self.document_size_in_bytes);
        formatter.field("parent_folder_id", &self.parent_folder_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcesInput {
    /// <p>The Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The user ID for the resource collection. This is a required field for accessing the
    /// API operation using IAM credentials.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The collection type.</p>
    pub collection_type: std::option::Option<crate::model::ResourceCollectionType>,
    /// <p>The maximum number of resources to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results. This marker was received from a previous call.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcesInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("user_id", &self.user_id);
        formatter.field("collection_type", &self.collection_type);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFolderPathInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of levels in the hierarchy to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>A comma-separated list of values. Specify "NAME" to include the names of the parent
    /// folders.</p>
    pub fields: std::option::Option<std::string::String>,
    /// <p>This value is not supported.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetFolderPathInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFolderPathInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.field("limit", &self.limit);
        formatter.field("fields", &self.fields);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>Set to TRUE to include custom metadata in the response.</p>
    pub include_custom_metadata: bool,
}
impl std::fmt::Debug for GetFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFolderInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.field("include_custom_metadata", &self.include_custom_metadata);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentVersionInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The version ID of the document.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>A comma-separated list of values. Specify "SOURCE" to include a URL for the source
    /// document.</p>
    pub fields: std::option::Option<std::string::String>,
    /// <p>Set this to TRUE to include custom metadata in the response.</p>
    pub include_custom_metadata: bool,
}
impl std::fmt::Debug for GetDocumentVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentVersionInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("fields", &self.fields);
        formatter.field("include_custom_metadata", &self.include_custom_metadata);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentPathInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of levels in the hierarchy to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>A comma-separated list of values. Specify <code>NAME</code> to include the names of
    /// the parent folders.</p>
    pub fields: std::option::Option<std::string::String>,
    /// <p>This value is not supported.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDocumentPathInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentPathInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("limit", &self.limit);
        formatter.field("fields", &self.fields);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>Set this to <code>TRUE</code> to include custom metadata in the response.</p>
    pub include_custom_metadata: bool,
}
impl std::fmt::Debug for GetDocumentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("include_custom_metadata", &self.include_custom_metadata);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCurrentUserInput {
    /// <p>Amazon WorkDocs authentication token.</p>
    pub authentication_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCurrentUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCurrentUserInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsersInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the users.</p>
    pub user_ids: std::option::Option<std::string::String>,
    /// <p>A query to filter users by user name.</p>
    pub query: std::option::Option<std::string::String>,
    /// <p>The state of the users. Specify "ALL" to include inactive users.</p>
    pub include: std::option::Option<crate::model::UserFilterType>,
    /// <p>The order for the results.</p>
    pub order: std::option::Option<crate::model::OrderType>,
    /// <p>The sorting criteria.</p>
    pub sort: std::option::Option<crate::model::UserSortType>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>A comma-separated list of values. Specify "STORAGE_METADATA" to include the user
    /// storage quota and utilization information.</p>
    pub fields: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsersInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("user_ids", &self.user_ids);
        formatter.field("query", &"*** Sensitive Data Redacted ***");
        formatter.field("include", &self.include);
        formatter.field("order", &self.order);
        formatter.field("sort", &self.sort);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRootFoldersInput {
    /// <p>Amazon WorkDocs authentication token.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeRootFoldersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRootFoldersInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourcePermissionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ID of the principal to filter permissions by.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call)</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeResourcePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourcePermissionsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotificationSubscriptionsInput {
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub limit: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeNotificationSubscriptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotificationSubscriptionsInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGroupsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>A query to describe groups by group name.</p>
    pub search_query: std::option::Option<std::string::String>,
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub limit: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGroupsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("search_query", &"*** Sensitive Data Redacted ***");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFolderContentsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The sorting criteria.</p>
    pub sort: std::option::Option<crate::model::ResourceSortType>,
    /// <p>The order for the contents of the folder.</p>
    pub order: std::option::Option<crate::model::OrderType>,
    /// <p>The maximum number of items to return with this call.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results. This marker was received from a previous
    /// call.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The type of items.</p>
    pub r#type: std::option::Option<crate::model::FolderContentType>,
    /// <p>The contents to include. Specify "INITIALIZED" to include initialized
    /// documents.</p>
    pub include: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeFolderContentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFolderContentsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.field("sort", &self.sort);
        formatter.field("order", &self.order);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.field("r#type", &self.r#type);
        formatter.field("include", &self.include);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDocumentVersionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The marker for the next set of results. (You received this marker from a previous
    /// call.)</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of versions to return with this call.</p>
    pub limit: std::option::Option<i32>,
    /// <p>A comma-separated list of values. Specify "INITIALIZED" to include incomplete
    /// versions.</p>
    pub include: std::option::Option<std::string::String>,
    /// <p>Specify "SOURCE" to include initialized versions and a URL for the source
    /// document.</p>
    pub fields: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDocumentVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDocumentVersionsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.field("include", &self.include);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCommentsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The ID of the document version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results. This marker was received from a previous
    /// call.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeCommentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCommentsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeActivitiesInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The timestamp that determines the starting time of the activities. The response
    /// includes the activities performed after the specified timestamp.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp that determines the end time of the activities. The response includes
    /// the activities performed before the specified timestamp.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the organization. This is a mandatory parameter when using administrative
    /// API (SigV4) requests.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>Specifies which activity types to include in the response. If this field is left
    /// empty, all activity types are returned.</p>
    pub activity_types: std::option::Option<std::string::String>,
    /// <p>The document or folder ID for which to describe activity types.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ID of the user who performed the action. The response includes activities
    /// pertaining to this user. This is an optional parameter and is only applicable for
    /// administrative API (SigV4) requests.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Includes indirect activities. An indirect activity results from a direct activity
    /// performed on a parent resource. For example, sharing a parent folder (the direct
    /// activity) shares all of the subfolders and documents within the parent folder (the
    /// indirect activity).</p>
    pub include_indirect_activities: bool,
    /// <p>The maximum number of items to return.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The marker for the next set of results.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeActivitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeActivitiesInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("organization_id", &self.organization_id);
        formatter.field("activity_types", &self.activity_types);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("user_id", &self.user_id);
        formatter.field(
            "include_indirect_activities",
            &self.include_indirect_activities,
        );
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserInput {
    /// <p>Amazon WorkDocs authentication token. Do not set this field when using
    /// administrative API actions, as in accessing the API using AWS credentials.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNotificationSubscriptionInput {
    /// <p>The ID of the subscription.</p>
    pub subscription_id: std::option::Option<std::string::String>,
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteNotificationSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNotificationSubscriptionInput");
        formatter.field("subscription_id", &self.subscription_id);
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLabelsInput {
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>List of labels to delete from the resource.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Flag to request removal of all labels from the specified resource.</p>
    pub delete_all: bool,
}
impl std::fmt::Debug for DeleteLabelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLabelsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("labels", &self.labels);
        formatter.field("delete_all", &self.delete_all);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFolderContentsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteFolderContentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFolderContentsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFolderInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("folder_id", &self.folder_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDocumentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDocumentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDocumentInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomMetadataInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource, either a document or folder.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ID of the version, if the custom metadata is being deleted from a document
    /// version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>List of properties to remove.</p>
    pub keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Flag to indicate removal of all custom metadata properties from the specified
    /// resource.</p>
    pub delete_all: bool,
}
impl std::fmt::Debug for DeleteCustomMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomMetadataInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("keys", &self.keys);
        formatter.field("delete_all", &self.delete_all);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCommentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The ID of the document version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The ID of the comment.</p>
    pub comment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteCommentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCommentInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("comment_id", &self.comment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateUserInput {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeactivateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserInput {
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The login name of the user.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The email address of the user.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The given name of the user.</p>
    pub given_name: std::option::Option<std::string::String>,
    /// <p>The surname of the user.</p>
    pub surname: std::option::Option<std::string::String>,
    /// <p>The password of the user.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The time zone ID of the user.</p>
    pub time_zone_id: std::option::Option<std::string::String>,
    /// <p>The amount of storage for the user.</p>
    pub storage_rule: std::option::Option<crate::model::StorageRuleType>,
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("username", &self.username);
        formatter.field("email_address", &self.email_address);
        formatter.field("given_name", &self.given_name);
        formatter.field("surname", &self.surname);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("time_zone_id", &self.time_zone_id);
        formatter.field("storage_rule", &self.storage_rule);
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNotificationSubscriptionInput {
    /// <p>The ID of the organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint
    /// is a URL that begins with <code>https</code>.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The protocol to use. The supported value is https, which delivers JSON-encoded
    /// messages using HTTPS POST.</p>
    pub protocol: std::option::Option<crate::model::SubscriptionProtocolType>,
    /// <p>The notification type.</p>
    pub subscription_type: std::option::Option<crate::model::SubscriptionType>,
}
impl std::fmt::Debug for CreateNotificationSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNotificationSubscriptionInput");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("protocol", &self.protocol);
        formatter.field("subscription_type", &self.subscription_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLabelsInput {
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>List of labels to add to the resource.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateLabelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLabelsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("labels", &self.labels);
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFolderInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The name of the new folder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the parent folder.</p>
    pub parent_folder_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFolderInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &self.name);
        formatter.field("parent_folder_id", &self.parent_folder_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomMetadataInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ID of the version, if the custom metadata is being added to a document
    /// version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Custom metadata in the form of name-value pairs.</p>
    pub custom_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateCustomMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomMetadataInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("custom_metadata", &self.custom_metadata);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCommentInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The ID of the document version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The ID of the parent comment.</p>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>The ID of the root comment in the thread.</p>
    pub thread_id: std::option::Option<std::string::String>,
    /// <p>The text of the comment.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The visibility of the comment. Options are either PRIVATE, where the comment is
    /// visible only to the comment author and document owner and co-owners, or PUBLIC, where
    /// the comment is visible to document owners, co-owners, and contributors.</p>
    pub visibility: std::option::Option<crate::model::CommentVisibilityType>,
    /// <p>Set this parameter to TRUE to send an email out to the document collaborators after
    /// the comment is created.</p>
    pub notify_collaborators: bool,
}
impl std::fmt::Debug for CreateCommentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCommentInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("parent_id", &self.parent_id);
        formatter.field("thread_id", &self.thread_id);
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("visibility", &self.visibility);
        formatter.field("notify_collaborators", &self.notify_collaborators);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddResourcePermissionsInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The users, groups, or organization being granted permission.</p>
    pub principals: std::option::Option<std::vec::Vec<crate::model::SharePrincipal>>,
    /// <p>The notification options.</p>
    pub notification_options: std::option::Option<crate::model::NotificationOptions>,
}
impl std::fmt::Debug for AddResourcePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddResourcePermissionsInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("principals", &self.principals);
        formatter.field("notification_options", &self.notification_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateUserInput {
    /// <p>The ID of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActivateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateUserInput");
        formatter.field("user_id", &self.user_id);
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortDocumentVersionUploadInput {
    /// <p>Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.</p>
    pub authentication_token: std::option::Option<std::string::String>,
    /// <p>The ID of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The ID of the version.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AbortDocumentVersionUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortDocumentVersionUploadInput");
        formatter.field("authentication_token", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
