// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateAssistantInput`](crate::input::CreateAssistantInput)
pub mod create_assistant_input {
    /// A builder for [`CreateAssistantInput`](crate::input::CreateAssistantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AssistantType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
    }
    impl Builder {
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The name of the assistant.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the assistant.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of assistant.</p>
        pub fn r#type(mut self, input: crate::model::AssistantType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of assistant.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::AssistantType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description of the assistant.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the assistant.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssistantInput`](crate::input::CreateAssistantInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssistantInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssistantInput {
                client_token: self.client_token,
                name: self.name,
                r#type: self.r#type,
                description: self.description,
                tags: self.tags,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssistantInputOperationOutputAlias = crate::operation::CreateAssistant;
#[doc(hidden)]
pub type CreateAssistantInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAssistantInput {
    /// Consumes the builder and constructs an Operation<[`CreateAssistant`](crate::operation::CreateAssistant)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAssistant,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssistantInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assistants").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssistantInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssistantInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_assistant(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAssistant::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAssistant",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssistantInput`](crate::input::CreateAssistantInput)
    pub fn builder() -> crate::input::create_assistant_input::Builder {
        crate::input::create_assistant_input::Builder::default()
    }
}

/// See [`CreateAssistantAssociationInput`](crate::input::CreateAssistantAssociationInput)
pub mod create_assistant_association_input {
    /// A builder for [`CreateAssistantAssociationInput`](crate::input::CreateAssistantAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) association_type: std::option::Option<crate::model::AssociationType>,
        pub(crate) association: std::option::Option<crate::model::AssistantAssociationInputData>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The type of association.</p>
        pub fn association_type(mut self, input: crate::model::AssociationType) -> Self {
            self.association_type = Some(input);
            self
        }
        /// <p>The type of association.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::AssociationType>,
        ) -> Self {
            self.association_type = input;
            self
        }
        /// <p>The identifier of the associated resource.</p>
        pub fn association(mut self, input: crate::model::AssistantAssociationInputData) -> Self {
            self.association = Some(input);
            self
        }
        /// <p>The identifier of the associated resource.</p>
        pub fn set_association(
            mut self,
            input: std::option::Option<crate::model::AssistantAssociationInputData>,
        ) -> Self {
            self.association = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssistantAssociationInput`](crate::input::CreateAssistantAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssistantAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssistantAssociationInput {
                assistant_id: self.assistant_id,
                association_type: self.association_type,
                association: self.association,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssistantAssociationInputOperationOutputAlias =
    crate::operation::CreateAssistantAssociation;
#[doc(hidden)]
pub type CreateAssistantAssociationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAssistantAssociationInput {
    /// Consumes the builder and constructs an Operation<[`CreateAssistantAssociation`](crate::operation::CreateAssistantAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAssistantAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssistantAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.assistant_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_1, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}/associations",
                assistantId = assistant_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssistantAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssistantAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_assistant_association(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAssistantAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAssistantAssociation",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssistantAssociationInput`](crate::input::CreateAssistantAssociationInput)
    pub fn builder() -> crate::input::create_assistant_association_input::Builder {
        crate::input::create_assistant_association_input::Builder::default()
    }
}

/// See [`CreateContentInput`](crate::input::CreateContentInput)
pub mod create_content_input {
    /// A builder for [`CreateContentInput`](crate::input::CreateContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) override_link_out_uri: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The name of the content. Each piece of content in a knowledge base must have a unique name. You can retrieve a piece of content using only its knowledge base and its name with the <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html">SearchContent</a> API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the content. Each piece of content in a knowledge base must have a unique name. You can retrieve a piece of content using only its knowledge base and its name with the <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html">SearchContent</a> API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The title of the content. If not set, the title is equal to the name.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the content. If not set, the title is equal to the name.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The URI you want to use for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content.</p>
        pub fn override_link_out_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.override_link_out_uri = Some(input.into());
            self
        }
        /// <p>The URI you want to use for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content.</p>
        pub fn set_override_link_out_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.override_link_out_uri = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContentInput`](crate::input::CreateContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContentInput {
                knowledge_base_id: self.knowledge_base_id,
                name: self.name,
                title: self.title,
                override_link_out_uri: self.override_link_out_uri,
                metadata: self.metadata,
                upload_id: self.upload_id,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContentInputOperationOutputAlias = crate::operation::CreateContent;
#[doc(hidden)]
pub type CreateContentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateContentInput {
    /// Consumes the builder and constructs an Operation<[`CreateContent`](crate::operation::CreateContent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.knowledge_base_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_2, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}/contents",
                knowledgeBaseId = knowledge_base_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_content(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContent",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateContentInput`](crate::input::CreateContentInput)
    pub fn builder() -> crate::input::create_content_input::Builder {
        crate::input::create_content_input::Builder::default()
    }
}

/// See [`CreateKnowledgeBaseInput`](crate::input::CreateKnowledgeBaseInput)
pub mod create_knowledge_base_input {
    /// A builder for [`CreateKnowledgeBaseInput`](crate::input::CreateKnowledgeBaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_type: std::option::Option<crate::model::KnowledgeBaseType>,
        pub(crate) source_configuration: std::option::Option<crate::model::SourceConfiguration>,
        pub(crate) rendering_configuration:
            std::option::Option<crate::model::RenderingConfiguration>,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The name of the knowledge base.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the knowledge base.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically. </p>
        pub fn knowledge_base_type(mut self, input: crate::model::KnowledgeBaseType) -> Self {
            self.knowledge_base_type = Some(input);
            self
        }
        /// <p>The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically. </p>
        pub fn set_knowledge_base_type(
            mut self,
            input: std::option::Option<crate::model::KnowledgeBaseType>,
        ) -> Self {
            self.knowledge_base_type = input;
            self
        }
        /// <p>The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.</p>
        pub fn source_configuration(mut self, input: crate::model::SourceConfiguration) -> Self {
            self.source_configuration = Some(input);
            self
        }
        /// <p>The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.source_configuration = input;
            self
        }
        /// <p>Information about how to render the content.</p>
        pub fn rendering_configuration(
            mut self,
            input: crate::model::RenderingConfiguration,
        ) -> Self {
            self.rendering_configuration = Some(input);
            self
        }
        /// <p>Information about how to render the content.</p>
        pub fn set_rendering_configuration(
            mut self,
            input: std::option::Option<crate::model::RenderingConfiguration>,
        ) -> Self {
            self.rendering_configuration = input;
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKnowledgeBaseInput`](crate::input::CreateKnowledgeBaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateKnowledgeBaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateKnowledgeBaseInput {
                client_token: self.client_token,
                name: self.name,
                knowledge_base_type: self.knowledge_base_type,
                source_configuration: self.source_configuration,
                rendering_configuration: self.rendering_configuration,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateKnowledgeBaseInputOperationOutputAlias = crate::operation::CreateKnowledgeBase;
#[doc(hidden)]
pub type CreateKnowledgeBaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateKnowledgeBaseInput {
    /// Consumes the builder and constructs an Operation<[`CreateKnowledgeBase`](crate::operation::CreateKnowledgeBase)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateKnowledgeBase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateKnowledgeBaseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/knowledgeBases").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateKnowledgeBaseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateKnowledgeBaseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_knowledge_base(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateKnowledgeBase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateKnowledgeBase",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateKnowledgeBaseInput`](crate::input::CreateKnowledgeBaseInput)
    pub fn builder() -> crate::input::create_knowledge_base_input::Builder {
        crate::input::create_knowledge_base_input::Builder::default()
    }
}

/// See [`CreateSessionInput`](crate::input::CreateSessionInput)
pub mod create_session_input {
    /// A builder for [`CreateSessionInput`](crate::input::CreateSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The name of the session.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the session.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSessionInput`](crate::input::CreateSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSessionInput {
                client_token: self.client_token,
                assistant_id: self.assistant_id,
                name: self.name,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSessionInputOperationOutputAlias = crate::operation::CreateSession;
#[doc(hidden)]
pub type CreateSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSessionInput {
    /// Consumes the builder and constructs an Operation<[`CreateSession`](crate::operation::CreateSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.assistant_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_3, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}/sessions",
                assistantId = assistant_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_session(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSession",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSessionInput`](crate::input::CreateSessionInput)
    pub fn builder() -> crate::input::create_session_input::Builder {
        crate::input::create_session_input::Builder::default()
    }
}

/// See [`DeleteAssistantInput`](crate::input::DeleteAssistantInput)
pub mod delete_assistant_input {
    /// A builder for [`DeleteAssistantInput`](crate::input::DeleteAssistantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssistantInput`](crate::input::DeleteAssistantInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssistantInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssistantInput {
                assistant_id: self.assistant_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssistantInputOperationOutputAlias = crate::operation::DeleteAssistant;
#[doc(hidden)]
pub type DeleteAssistantInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAssistantInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssistant`](crate::operation::DeleteAssistant)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssistant,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssistantInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.assistant_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_4, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}",
                assistantId = assistant_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssistantInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssistantInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssistant::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssistant",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssistantInput`](crate::input::DeleteAssistantInput)
    pub fn builder() -> crate::input::delete_assistant_input::Builder {
        crate::input::delete_assistant_input::Builder::default()
    }
}

/// See [`DeleteAssistantAssociationInput`](crate::input::DeleteAssistantAssociationInput)
pub mod delete_assistant_association_input {
    /// A builder for [`DeleteAssistantAssociationInput`](crate::input::DeleteAssistantAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_association_id: std::option::Option<std::string::String>,
        pub(crate) assistant_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_association_id = Some(input.into());
            self
        }
        /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_association_id = input;
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssistantAssociationInput`](crate::input::DeleteAssistantAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssistantAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssistantAssociationInput {
                assistant_association_id: self.assistant_association_id,
                assistant_id: self.assistant_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssistantAssociationInputOperationOutputAlias =
    crate::operation::DeleteAssistantAssociation;
#[doc(hidden)]
pub type DeleteAssistantAssociationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAssistantAssociationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssistantAssociation`](crate::operation::DeleteAssistantAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssistantAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssistantAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.assistant_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_5, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.assistant_association_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_association_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_association_id = aws_smithy_http::label::fmt_string(input_6, false);
            if assistant_association_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_association_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}/associations/{assistantAssociationId}",
                assistantId = assistant_id,
                assistantAssociationId = assistant_association_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssistantAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssistantAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssistantAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssistantAssociation",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssistantAssociationInput`](crate::input::DeleteAssistantAssociationInput)
    pub fn builder() -> crate::input::delete_assistant_association_input::Builder {
        crate::input::delete_assistant_association_input::Builder::default()
    }
}

/// See [`DeleteContentInput`](crate::input::DeleteContentInput)
pub mod delete_content_input {
    /// A builder for [`DeleteContentInput`](crate::input::DeleteContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) content_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_id = Some(input.into());
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContentInput`](crate::input::DeleteContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContentInput {
                knowledge_base_id: self.knowledge_base_id,
                content_id: self.content_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContentInputOperationOutputAlias = crate::operation::DeleteContent;
#[doc(hidden)]
pub type DeleteContentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContent`](crate::operation::DeleteContent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.knowledge_base_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_7, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_8 = &_input.content_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "content_id",
                        details: "cannot be empty or unset",
                    })?;
            let content_id = aws_smithy_http::label::fmt_string(input_8, false);
            if content_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "content_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}",
                knowledgeBaseId = knowledge_base_id,
                contentId = content_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContent",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteContentInput`](crate::input::DeleteContentInput)
    pub fn builder() -> crate::input::delete_content_input::Builder {
        crate::input::delete_content_input::Builder::default()
    }
}

/// See [`DeleteKnowledgeBaseInput`](crate::input::DeleteKnowledgeBaseInput)
pub mod delete_knowledge_base_input {
    /// A builder for [`DeleteKnowledgeBaseInput`](crate::input::DeleteKnowledgeBaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The knowledge base to delete content from. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The knowledge base to delete content from. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteKnowledgeBaseInput`](crate::input::DeleteKnowledgeBaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteKnowledgeBaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteKnowledgeBaseInput {
                knowledge_base_id: self.knowledge_base_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteKnowledgeBaseInputOperationOutputAlias = crate::operation::DeleteKnowledgeBase;
#[doc(hidden)]
pub type DeleteKnowledgeBaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteKnowledgeBaseInput {
    /// Consumes the builder and constructs an Operation<[`DeleteKnowledgeBase`](crate::operation::DeleteKnowledgeBase)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteKnowledgeBase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteKnowledgeBaseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.knowledge_base_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_9, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}",
                knowledgeBaseId = knowledge_base_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteKnowledgeBaseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteKnowledgeBaseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteKnowledgeBase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteKnowledgeBase",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteKnowledgeBaseInput`](crate::input::DeleteKnowledgeBaseInput)
    pub fn builder() -> crate::input::delete_knowledge_base_input::Builder {
        crate::input::delete_knowledge_base_input::Builder::default()
    }
}

/// See [`GetAssistantInput`](crate::input::GetAssistantInput)
pub mod get_assistant_input {
    /// A builder for [`GetAssistantInput`](crate::input::GetAssistantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssistantInput`](crate::input::GetAssistantInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssistantInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssistantInput {
                assistant_id: self.assistant_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssistantInputOperationOutputAlias = crate::operation::GetAssistant;
#[doc(hidden)]
pub type GetAssistantInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAssistantInput {
    /// Consumes the builder and constructs an Operation<[`GetAssistant`](crate::operation::GetAssistant)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssistant,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssistantInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.assistant_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_10, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}",
                assistantId = assistant_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssistantInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssistantInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssistant::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssistant",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssistantInput`](crate::input::GetAssistantInput)
    pub fn builder() -> crate::input::get_assistant_input::Builder {
        crate::input::get_assistant_input::Builder::default()
    }
}

/// See [`GetAssistantAssociationInput`](crate::input::GetAssistantAssociationInput)
pub mod get_assistant_association_input {
    /// A builder for [`GetAssistantAssociationInput`](crate::input::GetAssistantAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_association_id: std::option::Option<std::string::String>,
        pub(crate) assistant_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_association_id = Some(input.into());
            self
        }
        /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_association_id = input;
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssistantAssociationInput`](crate::input::GetAssistantAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssistantAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssistantAssociationInput {
                assistant_association_id: self.assistant_association_id,
                assistant_id: self.assistant_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssistantAssociationInputOperationOutputAlias =
    crate::operation::GetAssistantAssociation;
#[doc(hidden)]
pub type GetAssistantAssociationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAssistantAssociationInput {
    /// Consumes the builder and constructs an Operation<[`GetAssistantAssociation`](crate::operation::GetAssistantAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssistantAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssistantAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.assistant_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_11, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.assistant_association_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_association_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_association_id = aws_smithy_http::label::fmt_string(input_12, false);
            if assistant_association_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_association_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}/associations/{assistantAssociationId}",
                assistantId = assistant_id,
                assistantAssociationId = assistant_association_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssistantAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssistantAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssistantAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssistantAssociation",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssistantAssociationInput`](crate::input::GetAssistantAssociationInput)
    pub fn builder() -> crate::input::get_assistant_association_input::Builder {
        crate::input::get_assistant_association_input::Builder::default()
    }
}

/// See [`GetContentInput`](crate::input::GetContentInput)
pub mod get_content_input {
    /// A builder for [`GetContentInput`](crate::input::GetContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_id: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_id = Some(input.into());
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_id = input;
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContentInput`](crate::input::GetContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContentInput {
                content_id: self.content_id,
                knowledge_base_id: self.knowledge_base_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContentInputOperationOutputAlias = crate::operation::GetContent;
#[doc(hidden)]
pub type GetContentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContentInput {
    /// Consumes the builder and constructs an Operation<[`GetContent`](crate::operation::GetContent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.knowledge_base_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_13, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_14 = &_input.content_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "content_id",
                        details: "cannot be empty or unset",
                    })?;
            let content_id = aws_smithy_http::label::fmt_string(input_14, false);
            if content_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "content_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}",
                knowledgeBaseId = knowledge_base_id,
                contentId = content_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContent",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetContentInput`](crate::input::GetContentInput)
    pub fn builder() -> crate::input::get_content_input::Builder {
        crate::input::get_content_input::Builder::default()
    }
}

/// See [`GetContentSummaryInput`](crate::input::GetContentSummaryInput)
pub mod get_content_summary_input {
    /// A builder for [`GetContentSummaryInput`](crate::input::GetContentSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_id: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_id = Some(input.into());
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_id = input;
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContentSummaryInput`](crate::input::GetContentSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContentSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContentSummaryInput {
                content_id: self.content_id,
                knowledge_base_id: self.knowledge_base_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContentSummaryInputOperationOutputAlias = crate::operation::GetContentSummary;
#[doc(hidden)]
pub type GetContentSummaryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContentSummaryInput {
    /// Consumes the builder and constructs an Operation<[`GetContentSummary`](crate::operation::GetContentSummary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContentSummary,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetContentSummaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.knowledge_base_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_15, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.content_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "content_id",
                        details: "cannot be empty or unset",
                    })?;
            let content_id = aws_smithy_http::label::fmt_string(input_16, false);
            if content_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "content_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}/summary",
                knowledgeBaseId = knowledge_base_id,
                contentId = content_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetContentSummaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetContentSummaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContentSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContentSummary",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetContentSummaryInput`](crate::input::GetContentSummaryInput)
    pub fn builder() -> crate::input::get_content_summary_input::Builder {
        crate::input::get_content_summary_input::Builder::default()
    }
}

/// See [`GetKnowledgeBaseInput`](crate::input::GetKnowledgeBaseInput)
pub mod get_knowledge_base_input {
    /// A builder for [`GetKnowledgeBaseInput`](crate::input::GetKnowledgeBaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKnowledgeBaseInput`](crate::input::GetKnowledgeBaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetKnowledgeBaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetKnowledgeBaseInput {
                knowledge_base_id: self.knowledge_base_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetKnowledgeBaseInputOperationOutputAlias = crate::operation::GetKnowledgeBase;
#[doc(hidden)]
pub type GetKnowledgeBaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetKnowledgeBaseInput {
    /// Consumes the builder and constructs an Operation<[`GetKnowledgeBase`](crate::operation::GetKnowledgeBase)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetKnowledgeBase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetKnowledgeBaseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.knowledge_base_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_17, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}",
                knowledgeBaseId = knowledge_base_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetKnowledgeBaseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetKnowledgeBaseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetKnowledgeBase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetKnowledgeBase",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetKnowledgeBaseInput`](crate::input::GetKnowledgeBaseInput)
    pub fn builder() -> crate::input::get_knowledge_base_input::Builder {
        crate::input::get_knowledge_base_input::Builder::default()
    }
}

/// See [`GetRecommendationsInput`](crate::input::GetRecommendationsInput)
pub mod get_recommendations_input {
    /// A builder for [`GetRecommendationsInput`](crate::input::GetRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) wait_time_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>. If no messages are available and the wait time expires, the call returns successfully with an empty list.</p>
        pub fn wait_time_seconds(mut self, input: i32) -> Self {
            self.wait_time_seconds = Some(input);
            self
        }
        /// <p>The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>. If no messages are available and the wait time expires, the call returns successfully with an empty list.</p>
        pub fn set_wait_time_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.wait_time_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecommendationsInput`](crate::input::GetRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRecommendationsInput {
                assistant_id: self.assistant_id,
                session_id: self.session_id,
                max_results: self.max_results,
                wait_time_seconds: self.wait_time_seconds.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetRecommendationsInputOperationOutputAlias = crate::operation::GetRecommendations;
#[doc(hidden)]
pub type GetRecommendationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`GetRecommendations`](crate::operation::GetRecommendations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRecommendations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.assistant_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_18, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.session_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    })?;
            let session_id = aws_smithy_http::label::fmt_string(input_19, false);
            if session_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "session_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}/sessions/{sessionId}/recommendations",
                assistantId = assistant_id,
                sessionId = session_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetRecommendationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_20) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_20).encode(),
                );
            }
            if _input.wait_time_seconds != 0 {
                query.push_kv(
                    "waitTimeSeconds",
                    aws_smithy_types::primitive::Encoder::from(_input.wait_time_seconds).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRecommendations",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRecommendationsInput`](crate::input::GetRecommendationsInput)
    pub fn builder() -> crate::input::get_recommendations_input::Builder {
        crate::input::get_recommendations_input::Builder::default()
    }
}

/// See [`GetSessionInput`](crate::input::GetSessionInput)
pub mod get_session_input {
    /// A builder for [`GetSessionInput`](crate::input::GetSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSessionInput`](crate::input::GetSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSessionInput {
                assistant_id: self.assistant_id,
                session_id: self.session_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSessionInputOperationOutputAlias = crate::operation::GetSession;
#[doc(hidden)]
pub type GetSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSessionInput {
    /// Consumes the builder and constructs an Operation<[`GetSession`](crate::operation::GetSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.assistant_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_21, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_22 = &_input.session_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    })?;
            let session_id = aws_smithy_http::label::fmt_string(input_22, false);
            if session_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "session_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}/sessions/{sessionId}",
                assistantId = assistant_id,
                sessionId = session_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSession",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSessionInput`](crate::input::GetSessionInput)
    pub fn builder() -> crate::input::get_session_input::Builder {
        crate::input::get_session_input::Builder::default()
    }
}

/// See [`ListAssistantAssociationsInput`](crate::input::ListAssistantAssociationsInput)
pub mod list_assistant_associations_input {
    /// A builder for [`ListAssistantAssociationsInput`](crate::input::ListAssistantAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) assistant_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssistantAssociationsInput`](crate::input::ListAssistantAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssistantAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssistantAssociationsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                assistant_id: self.assistant_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssistantAssociationsInputOperationOutputAlias =
    crate::operation::ListAssistantAssociations;
#[doc(hidden)]
pub type ListAssistantAssociationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAssistantAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssistantAssociations`](crate::operation::ListAssistantAssociations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssistantAssociations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssistantAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.assistant_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_23, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}/associations",
                assistantId = assistant_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAssistantAssociationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_24) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_24));
            }
            if let Some(inner_25) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_25).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssistantAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssistantAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssistantAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssistantAssociations",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssistantAssociationsInput`](crate::input::ListAssistantAssociationsInput)
    pub fn builder() -> crate::input::list_assistant_associations_input::Builder {
        crate::input::list_assistant_associations_input::Builder::default()
    }
}

/// See [`ListAssistantsInput`](crate::input::ListAssistantsInput)
pub mod list_assistants_input {
    /// A builder for [`ListAssistantsInput`](crate::input::ListAssistantsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssistantsInput`](crate::input::ListAssistantsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssistantsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssistantsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssistantsInputOperationOutputAlias = crate::operation::ListAssistants;
#[doc(hidden)]
pub type ListAssistantsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAssistantsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssistants`](crate::operation::ListAssistants)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssistants,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssistantsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assistants").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAssistantsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_26) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_26));
            }
            if let Some(inner_27) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_27).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssistantsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssistantsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssistants::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssistants",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssistantsInput`](crate::input::ListAssistantsInput)
    pub fn builder() -> crate::input::list_assistants_input::Builder {
        crate::input::list_assistants_input::Builder::default()
    }
}

/// See [`ListContentsInput`](crate::input::ListContentsInput)
pub mod list_contents_input {
    /// A builder for [`ListContentsInput`](crate::input::ListContentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContentsInput`](crate::input::ListContentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContentsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                knowledge_base_id: self.knowledge_base_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListContentsInputOperationOutputAlias = crate::operation::ListContents;
#[doc(hidden)]
pub type ListContentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListContentsInput {
    /// Consumes the builder and constructs an Operation<[`ListContents`](crate::operation::ListContents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListContentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.knowledge_base_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_28, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}/contents",
                knowledgeBaseId = knowledge_base_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListContentsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_29) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_29));
            }
            if let Some(inner_30) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_30).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListContentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListContentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContents",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListContentsInput`](crate::input::ListContentsInput)
    pub fn builder() -> crate::input::list_contents_input::Builder {
        crate::input::list_contents_input::Builder::default()
    }
}

/// See [`ListKnowledgeBasesInput`](crate::input::ListKnowledgeBasesInput)
pub mod list_knowledge_bases_input {
    /// A builder for [`ListKnowledgeBasesInput`](crate::input::ListKnowledgeBasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKnowledgeBasesInput`](crate::input::ListKnowledgeBasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListKnowledgeBasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListKnowledgeBasesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListKnowledgeBasesInputOperationOutputAlias = crate::operation::ListKnowledgeBases;
#[doc(hidden)]
pub type ListKnowledgeBasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListKnowledgeBasesInput {
    /// Consumes the builder and constructs an Operation<[`ListKnowledgeBases`](crate::operation::ListKnowledgeBases)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListKnowledgeBases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListKnowledgeBasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/knowledgeBases").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListKnowledgeBasesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_31) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_31));
            }
            if let Some(inner_32) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_32).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListKnowledgeBasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListKnowledgeBasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListKnowledgeBases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListKnowledgeBases",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListKnowledgeBasesInput`](crate::input::ListKnowledgeBasesInput)
    pub fn builder() -> crate::input::list_knowledge_bases_input::Builder {
        crate::input::list_knowledge_bases_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.resource_arn;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_33, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`NotifyRecommendationsReceivedInput`](crate::input::NotifyRecommendationsReceivedInput)
pub mod notify_recommendations_received_input {
    /// A builder for [`NotifyRecommendationsReceivedInput`](crate::input::NotifyRecommendationsReceivedInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Appends an item to `recommendation_ids`.
        ///
        /// To override the contents of this collection use [`set_recommendation_ids`](Self::set_recommendation_ids).
        ///
        /// <p>The identifiers of the recommendations.</p>
        pub fn recommendation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recommendation_ids.unwrap_or_default();
            v.push(input.into());
            self.recommendation_ids = Some(v);
            self
        }
        /// <p>The identifiers of the recommendations.</p>
        pub fn set_recommendation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recommendation_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyRecommendationsReceivedInput`](crate::input::NotifyRecommendationsReceivedInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::NotifyRecommendationsReceivedInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::NotifyRecommendationsReceivedInput {
                assistant_id: self.assistant_id,
                session_id: self.session_id,
                recommendation_ids: self.recommendation_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type NotifyRecommendationsReceivedInputOperationOutputAlias =
    crate::operation::NotifyRecommendationsReceived;
#[doc(hidden)]
pub type NotifyRecommendationsReceivedInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl NotifyRecommendationsReceivedInput {
    /// Consumes the builder and constructs an Operation<[`NotifyRecommendationsReceived`](crate::operation::NotifyRecommendationsReceived)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::NotifyRecommendationsReceived,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::NotifyRecommendationsReceivedInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.assistant_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_34, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.session_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    })?;
            let session_id = aws_smithy_http::label::fmt_string(input_35, false);
            if session_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "session_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}/sessions/{sessionId}/recommendations/notify",
                assistantId = assistant_id,
                sessionId = session_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::NotifyRecommendationsReceivedInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::NotifyRecommendationsReceivedInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_notify_recommendations_received(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::NotifyRecommendationsReceived::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "NotifyRecommendationsReceived",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`NotifyRecommendationsReceivedInput`](crate::input::NotifyRecommendationsReceivedInput)
    pub fn builder() -> crate::input::notify_recommendations_received_input::Builder {
        crate::input::notify_recommendations_received_input::Builder::default()
    }
}

/// See [`QueryAssistantInput`](crate::input::QueryAssistantInput)
pub mod query_assistant_input {
    /// A builder for [`QueryAssistantInput`](crate::input::QueryAssistantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) query_text: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The text to search for.</p>
        pub fn query_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_text = Some(input.into());
            self
        }
        /// <p>The text to search for.</p>
        pub fn set_query_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_text = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryAssistantInput`](crate::input::QueryAssistantInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::QueryAssistantInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::QueryAssistantInput {
                assistant_id: self.assistant_id,
                query_text: self.query_text,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type QueryAssistantInputOperationOutputAlias = crate::operation::QueryAssistant;
#[doc(hidden)]
pub type QueryAssistantInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl QueryAssistantInput {
    /// Consumes the builder and constructs an Operation<[`QueryAssistant`](crate::operation::QueryAssistant)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::QueryAssistant,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::QueryAssistantInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.assistant_id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_36, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}/query",
                assistantId = assistant_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::QueryAssistantInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::QueryAssistantInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_query_assistant(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::QueryAssistant::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "QueryAssistant",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`QueryAssistantInput`](crate::input::QueryAssistantInput)
    pub fn builder() -> crate::input::query_assistant_input::Builder {
        crate::input::query_assistant_input::Builder::default()
    }
}

/// See [`RemoveKnowledgeBaseTemplateUriInput`](crate::input::RemoveKnowledgeBaseTemplateUriInput)
pub mod remove_knowledge_base_template_uri_input {
    /// A builder for [`RemoveKnowledgeBaseTemplateUriInput`](crate::input::RemoveKnowledgeBaseTemplateUriInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveKnowledgeBaseTemplateUriInput`](crate::input::RemoveKnowledgeBaseTemplateUriInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveKnowledgeBaseTemplateUriInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveKnowledgeBaseTemplateUriInput {
                knowledge_base_id: self.knowledge_base_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveKnowledgeBaseTemplateUriInputOperationOutputAlias =
    crate::operation::RemoveKnowledgeBaseTemplateUri;
#[doc(hidden)]
pub type RemoveKnowledgeBaseTemplateUriInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl RemoveKnowledgeBaseTemplateUriInput {
    /// Consumes the builder and constructs an Operation<[`RemoveKnowledgeBaseTemplateUri`](crate::operation::RemoveKnowledgeBaseTemplateUri)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveKnowledgeBaseTemplateUri,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveKnowledgeBaseTemplateUriInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.knowledge_base_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_37, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}/templateUri",
                knowledgeBaseId = knowledge_base_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveKnowledgeBaseTemplateUriInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveKnowledgeBaseTemplateUriInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveKnowledgeBaseTemplateUri::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveKnowledgeBaseTemplateUri",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveKnowledgeBaseTemplateUriInput`](crate::input::RemoveKnowledgeBaseTemplateUriInput)
    pub fn builder() -> crate::input::remove_knowledge_base_template_uri_input::Builder {
        crate::input::remove_knowledge_base_template_uri_input::Builder::default()
    }
}

/// See [`SearchContentInput`](crate::input::SearchContentInput)
pub mod search_content_input {
    /// A builder for [`SearchContentInput`](crate::input::SearchContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) search_expression: std::option::Option<crate::model::SearchExpression>,
    }
    impl Builder {
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The search expression to filter results.</p>
        pub fn search_expression(mut self, input: crate::model::SearchExpression) -> Self {
            self.search_expression = Some(input);
            self
        }
        /// <p>The search expression to filter results.</p>
        pub fn set_search_expression(
            mut self,
            input: std::option::Option<crate::model::SearchExpression>,
        ) -> Self {
            self.search_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchContentInput`](crate::input::SearchContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchContentInput {
                next_token: self.next_token,
                max_results: self.max_results,
                knowledge_base_id: self.knowledge_base_id,
                search_expression: self.search_expression,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchContentInputOperationOutputAlias = crate::operation::SearchContent;
#[doc(hidden)]
pub type SearchContentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchContentInput {
    /// Consumes the builder and constructs an Operation<[`SearchContent`](crate::operation::SearchContent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchContent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.knowledge_base_id;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_38, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}/search",
                knowledgeBaseId = knowledge_base_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::SearchContentInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_39) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_39));
            }
            if let Some(inner_40) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_40).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_search_content(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchContent",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchContentInput`](crate::input::SearchContentInput)
    pub fn builder() -> crate::input::search_content_input::Builder {
        crate::input::search_content_input::Builder::default()
    }
}

/// See [`SearchSessionsInput`](crate::input::SearchSessionsInput)
pub mod search_sessions_input {
    /// A builder for [`SearchSessionsInput`](crate::input::SearchSessionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) search_expression: std::option::Option<crate::model::SearchExpression>,
    }
    impl Builder {
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The search expression to filter results.</p>
        pub fn search_expression(mut self, input: crate::model::SearchExpression) -> Self {
            self.search_expression = Some(input);
            self
        }
        /// <p>The search expression to filter results.</p>
        pub fn set_search_expression(
            mut self,
            input: std::option::Option<crate::model::SearchExpression>,
        ) -> Self {
            self.search_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchSessionsInput`](crate::input::SearchSessionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchSessionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchSessionsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                assistant_id: self.assistant_id,
                search_expression: self.search_expression,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchSessionsInputOperationOutputAlias = crate::operation::SearchSessions;
#[doc(hidden)]
pub type SearchSessionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchSessionsInput {
    /// Consumes the builder and constructs an Operation<[`SearchSessions`](crate::operation::SearchSessions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchSessions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchSessionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_41 = &_input.assistant_id;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assistant_id",
                        details: "cannot be empty or unset",
                    })?;
            let assistant_id = aws_smithy_http::label::fmt_string(input_41, false);
            if assistant_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assistant_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assistants/{assistantId}/searchSessions",
                assistantId = assistant_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::SearchSessionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_42) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_42));
            }
            if let Some(inner_43) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_43).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchSessionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchSessionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_sessions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchSessions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchSessions",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchSessionsInput`](crate::input::SearchSessionsInput)
    pub fn builder() -> crate::input::search_sessions_input::Builder {
        crate::input::search_sessions_input::Builder::default()
    }
}

/// See [`StartContentUploadInput`](crate::input::StartContentUploadInput)
pub mod start_content_upload_input {
    /// A builder for [`StartContentUploadInput`](crate::input::StartContentUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The type of content to upload.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The type of content to upload.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StartContentUploadInput`](crate::input::StartContentUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartContentUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartContentUploadInput {
                knowledge_base_id: self.knowledge_base_id,
                content_type: self.content_type,
            })
        }
    }
}
#[doc(hidden)]
pub type StartContentUploadInputOperationOutputAlias = crate::operation::StartContentUpload;
#[doc(hidden)]
pub type StartContentUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartContentUploadInput {
    /// Consumes the builder and constructs an Operation<[`StartContentUpload`](crate::operation::StartContentUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartContentUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartContentUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_44 = &_input.knowledge_base_id;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_44, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}/upload",
                knowledgeBaseId = knowledge_base_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartContentUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartContentUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_content_upload(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartContentUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartContentUpload",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartContentUploadInput`](crate::input::StartContentUploadInput)
    pub fn builder() -> crate::input::start_content_upload_input::Builder {
        crate::input::start_content_upload_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_45 = &_input.resource_arn;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_45, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_46 = &_input.resource_arn;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_46, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_47) = &_input.tag_keys {
                for inner_48 in inner_47 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_48));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateContentInput`](crate::input::UpdateContentInput)
pub mod update_content_input {
    /// A builder for [`UpdateContentInput`](crate::input::UpdateContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) content_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) override_link_out_uri: std::option::Option<std::string::String>,
        pub(crate) remove_override_link_out_uri: std::option::Option<bool>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) upload_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_id = Some(input.into());
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_id = input;
            self
        }
        /// <p>The <code>revisionId</code> of the content resource to update, taken from an earlier call to <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was not modified since it was last read. If it has been modified, this API throws a <code>PreconditionFailedException</code>.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The <code>revisionId</code> of the content resource to update, taken from an earlier call to <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was not modified since it was last read. If it has been modified, this API throws a <code>PreconditionFailedException</code>.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The title of the content.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the content.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and set <code>removeOverrideLinkOutUri</code> to true.</p>
        pub fn override_link_out_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.override_link_out_uri = Some(input.into());
            self
        }
        /// <p>The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and set <code>removeOverrideLinkOutUri</code> to true.</p>
        pub fn set_override_link_out_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.override_link_out_uri = input;
            self
        }
        /// <p>Unset the existing <code>overrideLinkOutUri</code> if it exists.</p>
        pub fn remove_override_link_out_uri(mut self, input: bool) -> Self {
            self.remove_override_link_out_uri = Some(input);
            self
        }
        /// <p>Unset the existing <code>overrideLinkOutUri</code> if it exists.</p>
        pub fn set_remove_override_link_out_uri(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.remove_override_link_out_uri = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>. </p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>. </p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContentInput`](crate::input::UpdateContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContentInput {
                knowledge_base_id: self.knowledge_base_id,
                content_id: self.content_id,
                revision_id: self.revision_id,
                title: self.title,
                override_link_out_uri: self.override_link_out_uri,
                remove_override_link_out_uri: self.remove_override_link_out_uri,
                metadata: self.metadata,
                upload_id: self.upload_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContentInputOperationOutputAlias = crate::operation::UpdateContent;
#[doc(hidden)]
pub type UpdateContentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateContentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContent`](crate::operation::UpdateContent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_49 = &_input.knowledge_base_id;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_49, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_50 = &_input.content_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "content_id",
                        details: "cannot be empty or unset",
                    })?;
            let content_id = aws_smithy_http::label::fmt_string(input_50, false);
            if content_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "content_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}",
                knowledgeBaseId = knowledge_base_id,
                contentId = content_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_content(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContent",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateContentInput`](crate::input::UpdateContentInput)
    pub fn builder() -> crate::input::update_content_input::Builder {
        crate::input::update_content_input::Builder::default()
    }
}

/// See [`UpdateKnowledgeBaseTemplateUriInput`](crate::input::UpdateKnowledgeBaseTemplateUriInput)
pub mod update_knowledge_base_template_uri_input {
    /// A builder for [`UpdateKnowledgeBaseTemplateUriInput`](crate::input::UpdateKnowledgeBaseTemplateUriInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) template_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The template URI to update.</p>
        pub fn template_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_uri = Some(input.into());
            self
        }
        /// <p>The template URI to update.</p>
        pub fn set_template_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateKnowledgeBaseTemplateUriInput`](crate::input::UpdateKnowledgeBaseTemplateUriInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateKnowledgeBaseTemplateUriInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateKnowledgeBaseTemplateUriInput {
                knowledge_base_id: self.knowledge_base_id,
                template_uri: self.template_uri,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateKnowledgeBaseTemplateUriInputOperationOutputAlias =
    crate::operation::UpdateKnowledgeBaseTemplateUri;
#[doc(hidden)]
pub type UpdateKnowledgeBaseTemplateUriInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateKnowledgeBaseTemplateUriInput {
    /// Consumes the builder and constructs an Operation<[`UpdateKnowledgeBaseTemplateUri`](crate::operation::UpdateKnowledgeBaseTemplateUri)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateKnowledgeBaseTemplateUri,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateKnowledgeBaseTemplateUriInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.knowledge_base_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "knowledge_base_id",
                        details: "cannot be empty or unset",
                    })?;
            let knowledge_base_id = aws_smithy_http::label::fmt_string(input_51, false);
            if knowledge_base_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "knowledge_base_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/knowledgeBases/{knowledgeBaseId}/templateUri",
                knowledgeBaseId = knowledge_base_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateKnowledgeBaseTemplateUriInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateKnowledgeBaseTemplateUriInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_knowledge_base_template_uri(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateKnowledgeBaseTemplateUri::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateKnowledgeBaseTemplateUri",
            "wisdom",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateKnowledgeBaseTemplateUriInput`](crate::input::UpdateKnowledgeBaseTemplateUriInput)
    pub fn builder() -> crate::input::update_knowledge_base_template_uri_input::Builder {
        crate::input::update_knowledge_base_template_uri_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateKnowledgeBaseTemplateUriInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The template URI to update.</p>
    pub template_uri: std::option::Option<std::string::String>,
}
impl UpdateKnowledgeBaseTemplateUriInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The template URI to update.</p>
    pub fn template_uri(&self) -> std::option::Option<&str> {
        self.template_uri.as_deref()
    }
}
impl std::fmt::Debug for UpdateKnowledgeBaseTemplateUriInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateKnowledgeBaseTemplateUriInput");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("template_uri", &self.template_uri);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartContentUploadInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The type of content to upload.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl StartContentUploadInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The type of content to upload.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for StartContentUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartContentUploadInput");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchContentInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The search expression to filter results.</p>
    pub search_expression: std::option::Option<crate::model::SearchExpression>,
}
impl SearchContentInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The search expression to filter results.</p>
    pub fn search_expression(&self) -> std::option::Option<&crate::model::SearchExpression> {
        self.search_expression.as_ref()
    }
}
impl std::fmt::Debug for SearchContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchContentInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("search_expression", &self.search_expression);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveKnowledgeBaseTemplateUriInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
}
impl RemoveKnowledgeBaseTemplateUriInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
}
impl std::fmt::Debug for RemoveKnowledgeBaseTemplateUriInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveKnowledgeBaseTemplateUriInput");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKnowledgeBasesInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListKnowledgeBasesInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListKnowledgeBasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKnowledgeBasesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateKnowledgeBaseInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The name of the knowledge base.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically. </p>
    pub knowledge_base_type: std::option::Option<crate::model::KnowledgeBaseType>,
    /// <p>The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.</p>
    pub source_configuration: std::option::Option<crate::model::SourceConfiguration>,
    /// <p>Information about how to render the content.</p>
    pub rendering_configuration: std::option::Option<crate::model::RenderingConfiguration>,
    /// <p>The KMS key used for encryption.</p>
    pub server_side_encryption_configuration:
        std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateKnowledgeBaseInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The name of the knowledge base.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically. </p>
    pub fn knowledge_base_type(&self) -> std::option::Option<&crate::model::KnowledgeBaseType> {
        self.knowledge_base_type.as_ref()
    }
    /// <p>The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.</p>
    pub fn source_configuration(&self) -> std::option::Option<&crate::model::SourceConfiguration> {
        self.source_configuration.as_ref()
    }
    /// <p>Information about how to render the content.</p>
    pub fn rendering_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RenderingConfiguration> {
        self.rendering_configuration.as_ref()
    }
    /// <p>The KMS key used for encryption.</p>
    pub fn server_side_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryptionConfiguration> {
        self.server_side_encryption_configuration.as_ref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateKnowledgeBaseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateKnowledgeBaseInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("name", &self.name);
        formatter.field("knowledge_base_type", &self.knowledge_base_type);
        formatter.field("source_configuration", &self.source_configuration);
        formatter.field("rendering_configuration", &self.rendering_configuration);
        formatter.field(
            "server_side_encryption_configuration",
            &self.server_side_encryption_configuration,
        );
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteKnowledgeBaseInput {
    /// <p>The knowledge base to delete content from. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
}
impl DeleteKnowledgeBaseInput {
    /// <p>The knowledge base to delete content from. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteKnowledgeBaseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteKnowledgeBaseInput");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKnowledgeBaseInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
}
impl GetKnowledgeBaseInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
}
impl std::fmt::Debug for GetKnowledgeBaseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKnowledgeBaseInput");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContentSummaryInput {
    /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub content_id: std::option::Option<std::string::String>,
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
}
impl GetContentSummaryInput {
    /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn content_id(&self) -> std::option::Option<&str> {
        self.content_id.as_deref()
    }
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
}
impl std::fmt::Debug for GetContentSummaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContentSummaryInput");
        formatter.field("content_id", &self.content_id);
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContentsInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
}
impl ListContentsInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
}
impl std::fmt::Debug for ListContentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContentsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContentInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The name of the content. Each piece of content in a knowledge base must have a unique name. You can retrieve a piece of content using only its knowledge base and its name with the <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html">SearchContent</a> API.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The title of the content. If not set, the title is equal to the name.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The URI you want to use for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content.</p>
    pub override_link_out_uri: std::option::Option<std::string::String>,
    /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
    pub metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateContentInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The name of the content. Each piece of content in a knowledge base must have a unique name. You can retrieve a piece of content using only its knowledge base and its name with the <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html">SearchContent</a> API.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The title of the content. If not set, the title is equal to the name.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The URI you want to use for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content.</p>
    pub fn override_link_out_uri(&self) -> std::option::Option<&str> {
        self.override_link_out_uri.as_deref()
    }
    /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
    pub fn metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metadata.as_ref()
    }
    /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContentInput");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("name", &self.name);
        formatter.field("title", &self.title);
        formatter.field("override_link_out_uri", &self.override_link_out_uri);
        formatter.field("metadata", &self.metadata);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContentInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub content_id: std::option::Option<std::string::String>,
}
impl DeleteContentInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn content_id(&self) -> std::option::Option<&str> {
        self.content_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContentInput");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("content_id", &self.content_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContentInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub content_id: std::option::Option<std::string::String>,
    /// <p>The <code>revisionId</code> of the content resource to update, taken from an earlier call to <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was not modified since it was last read. If it has been modified, this API throws a <code>PreconditionFailedException</code>.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The title of the content.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and set <code>removeOverrideLinkOutUri</code> to true.</p>
    pub override_link_out_uri: std::option::Option<std::string::String>,
    /// <p>Unset the existing <code>overrideLinkOutUri</code> if it exists.</p>
    pub remove_override_link_out_uri: std::option::Option<bool>,
    /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
    pub metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>. </p>
    pub upload_id: std::option::Option<std::string::String>,
}
impl UpdateContentInput {
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn content_id(&self) -> std::option::Option<&str> {
        self.content_id.as_deref()
    }
    /// <p>The <code>revisionId</code> of the content resource to update, taken from an earlier call to <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was not modified since it was last read. If it has been modified, this API throws a <code>PreconditionFailedException</code>.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The title of the content.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and set <code>removeOverrideLinkOutUri</code> to true.</p>
    pub fn override_link_out_uri(&self) -> std::option::Option<&str> {
        self.override_link_out_uri.as_deref()
    }
    /// <p>Unset the existing <code>overrideLinkOutUri</code> if it exists.</p>
    pub fn remove_override_link_out_uri(&self) -> std::option::Option<bool> {
        self.remove_override_link_out_uri
    }
    /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
    pub fn metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metadata.as_ref()
    }
    /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>. </p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContentInput");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("content_id", &self.content_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("title", &self.title);
        formatter.field("override_link_out_uri", &self.override_link_out_uri);
        formatter.field(
            "remove_override_link_out_uri",
            &self.remove_override_link_out_uri,
        );
        formatter.field("metadata", &self.metadata);
        formatter.field("upload_id", &self.upload_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContentInput {
    /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub content_id: std::option::Option<std::string::String>,
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
}
impl GetContentInput {
    /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn content_id(&self) -> std::option::Option<&str> {
        self.content_id.as_deref()
    }
    /// <p>The the identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
}
impl std::fmt::Debug for GetContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContentInput");
        formatter.field("content_id", &self.content_id);
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchSessionsInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The search expression to filter results.</p>
    pub search_expression: std::option::Option<crate::model::SearchExpression>,
}
impl SearchSessionsInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The search expression to filter results.</p>
    pub fn search_expression(&self) -> std::option::Option<&crate::model::SearchExpression> {
        self.search_expression.as_ref()
    }
}
impl std::fmt::Debug for SearchSessionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchSessionsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("search_expression", &self.search_expression);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryAssistantInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The text to search for.</p>
    pub query_text: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl QueryAssistantInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The text to search for.</p>
    pub fn query_text(&self) -> std::option::Option<&str> {
        self.query_text.as_deref()
    }
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for QueryAssistantInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryAssistantInput");
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("query_text", &"*** Sensitive Data Redacted ***");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyRecommendationsReceivedInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The identifiers of the recommendations.</p>
    pub recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl NotifyRecommendationsReceivedInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The identifiers of the recommendations.</p>
    pub fn recommendation_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.recommendation_ids.as_deref()
    }
}
impl std::fmt::Debug for NotifyRecommendationsReceivedInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyRecommendationsReceivedInput");
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("session_id", &self.session_id);
        formatter.field("recommendation_ids", &self.recommendation_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecommendationsInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>. If no messages are available and the wait time expires, the call returns successfully with an empty list.</p>
    pub wait_time_seconds: i32,
}
impl GetRecommendationsInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>. If no messages are available and the wait time expires, the call returns successfully with an empty list.</p>
    pub fn wait_time_seconds(&self) -> i32 {
        self.wait_time_seconds
    }
}
impl std::fmt::Debug for GetRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecommendationsInput");
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("session_id", &self.session_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("wait_time_seconds", &self.wait_time_seconds);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssistantsInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAssistantsInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAssistantsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssistantsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssistantInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The name of the assistant.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of assistant.</p>
    pub r#type: std::option::Option<crate::model::AssistantType>,
    /// <p>The description of the assistant.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The KMS key used for encryption.</p>
    pub server_side_encryption_configuration:
        std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
}
impl CreateAssistantInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The name of the assistant.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of assistant.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AssistantType> {
        self.r#type.as_ref()
    }
    /// <p>The description of the assistant.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The KMS key used for encryption.</p>
    pub fn server_side_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryptionConfiguration> {
        self.server_side_encryption_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateAssistantInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssistantInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field(
            "server_side_encryption_configuration",
            &self.server_side_encryption_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssistantInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
}
impl DeleteAssistantInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAssistantInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssistantInput");
        formatter.field("assistant_id", &self.assistant_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssistantInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
}
impl GetAssistantInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
}
impl std::fmt::Debug for GetAssistantInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssistantInput");
        formatter.field("assistant_id", &self.assistant_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSessionInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The name of the session.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateSessionInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The name of the session.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSessionInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSessionInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl GetSessionInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
}
impl std::fmt::Debug for GetSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSessionInput");
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssistantAssociationsInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
}
impl ListAssistantAssociationsInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
}
impl std::fmt::Debug for ListAssistantAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssistantAssociationsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("assistant_id", &self.assistant_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssistantAssociationInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The type of association.</p>
    pub association_type: std::option::Option<crate::model::AssociationType>,
    /// <p>The identifier of the associated resource.</p>
    pub association: std::option::Option<crate::model::AssistantAssociationInputData>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateAssistantAssociationInput {
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The type of association.</p>
    pub fn association_type(&self) -> std::option::Option<&crate::model::AssociationType> {
        self.association_type.as_ref()
    }
    /// <p>The identifier of the associated resource.</p>
    pub fn association(&self) -> std::option::Option<&crate::model::AssistantAssociationInputData> {
        self.association.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateAssistantAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssistantAssociationInput");
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("association_type", &self.association_type);
        formatter.field("association", &self.association);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssistantAssociationInput {
    /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_association_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
}
impl DeleteAssistantAssociationInput {
    /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_association_id(&self) -> std::option::Option<&str> {
        self.assistant_association_id.as_deref()
    }
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAssistantAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssistantAssociationInput");
        formatter.field("assistant_association_id", &self.assistant_association_id);
        formatter.field("assistant_id", &self.assistant_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssistantAssociationInput {
    /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_association_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub assistant_id: std::option::Option<std::string::String>,
}
impl GetAssistantAssociationInput {
    /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_association_id(&self) -> std::option::Option<&str> {
        self.assistant_association_id.as_deref()
    }
    /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
}
impl std::fmt::Debug for GetAssistantAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssistantAssociationInput");
        formatter.field("assistant_association_id", &self.assistant_association_id);
        formatter.field("assistant_id", &self.assistant_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
