// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateKnowledgeBaseTemplateUriOutput {
    /// <p>The knowledge base to update.</p>
    pub knowledge_base: std::option::Option<crate::model::KnowledgeBaseData>,
}
impl UpdateKnowledgeBaseTemplateUriOutput {
    /// <p>The knowledge base to update.</p>
    pub fn knowledge_base(&self) -> std::option::Option<&crate::model::KnowledgeBaseData> {
        self.knowledge_base.as_ref()
    }
}
impl std::fmt::Debug for UpdateKnowledgeBaseTemplateUriOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateKnowledgeBaseTemplateUriOutput");
        formatter.field("knowledge_base", &self.knowledge_base);
        formatter.finish()
    }
}
/// See [`UpdateKnowledgeBaseTemplateUriOutput`](crate::output::UpdateKnowledgeBaseTemplateUriOutput)
pub mod update_knowledge_base_template_uri_output {
    /// A builder for [`UpdateKnowledgeBaseTemplateUriOutput`](crate::output::UpdateKnowledgeBaseTemplateUriOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base: std::option::Option<crate::model::KnowledgeBaseData>,
    }
    impl Builder {
        /// <p>The knowledge base to update.</p>
        pub fn knowledge_base(mut self, input: crate::model::KnowledgeBaseData) -> Self {
            self.knowledge_base = Some(input);
            self
        }
        /// <p>The knowledge base to update.</p>
        pub fn set_knowledge_base(
            mut self,
            input: std::option::Option<crate::model::KnowledgeBaseData>,
        ) -> Self {
            self.knowledge_base = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateKnowledgeBaseTemplateUriOutput`](crate::output::UpdateKnowledgeBaseTemplateUriOutput)
        pub fn build(self) -> crate::output::UpdateKnowledgeBaseTemplateUriOutput {
            crate::output::UpdateKnowledgeBaseTemplateUriOutput {
                knowledge_base: self.knowledge_base,
            }
        }
    }
}
impl UpdateKnowledgeBaseTemplateUriOutput {
    /// Creates a new builder-style object to manufacture [`UpdateKnowledgeBaseTemplateUriOutput`](crate::output::UpdateKnowledgeBaseTemplateUriOutput)
    pub fn builder() -> crate::output::update_knowledge_base_template_uri_output::Builder {
        crate::output::update_knowledge_base_template_uri_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartContentUploadOutput {
    /// <p>The identifier of the upload.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The URL of the upload.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The expiration time of the URL as an epoch timestamp.</p>
    pub url_expiry: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The headers to include in the upload.</p>
    pub headers_to_include:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartContentUploadOutput {
    /// <p>The identifier of the upload.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The URL of the upload.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The expiration time of the URL as an epoch timestamp.</p>
    pub fn url_expiry(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.url_expiry.as_ref()
    }
    /// <p>The headers to include in the upload.</p>
    pub fn headers_to_include(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.headers_to_include.as_ref()
    }
}
impl std::fmt::Debug for StartContentUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartContentUploadOutput");
        formatter.field("upload_id", &self.upload_id);
        formatter.field("url", &"*** Sensitive Data Redacted ***");
        formatter.field("url_expiry", &self.url_expiry);
        formatter.field("headers_to_include", &self.headers_to_include);
        formatter.finish()
    }
}
/// See [`StartContentUploadOutput`](crate::output::StartContentUploadOutput)
pub mod start_content_upload_output {
    /// A builder for [`StartContentUploadOutput`](crate::output::StartContentUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) url_expiry: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) headers_to_include: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The identifier of the upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The URL of the upload.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL of the upload.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The expiration time of the URL as an epoch timestamp.</p>
        pub fn url_expiry(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.url_expiry = Some(input);
            self
        }
        /// <p>The expiration time of the URL as an epoch timestamp.</p>
        pub fn set_url_expiry(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.url_expiry = input;
            self
        }
        /// Adds a key-value pair to `headers_to_include`.
        ///
        /// To override the contents of this collection use [`set_headers_to_include`](Self::set_headers_to_include).
        ///
        /// <p>The headers to include in the upload.</p>
        pub fn headers_to_include(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.headers_to_include.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.headers_to_include = Some(hash_map);
            self
        }
        /// <p>The headers to include in the upload.</p>
        pub fn set_headers_to_include(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.headers_to_include = input;
            self
        }
        /// Consumes the builder and constructs a [`StartContentUploadOutput`](crate::output::StartContentUploadOutput)
        pub fn build(self) -> crate::output::StartContentUploadOutput {
            crate::output::StartContentUploadOutput {
                upload_id: self.upload_id,
                url: self.url,
                url_expiry: self.url_expiry,
                headers_to_include: self.headers_to_include,
            }
        }
    }
}
impl StartContentUploadOutput {
    /// Creates a new builder-style object to manufacture [`StartContentUploadOutput`](crate::output::StartContentUploadOutput)
    pub fn builder() -> crate::output::start_content_upload_output::Builder {
        crate::output::start_content_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchContentOutput {
    /// <p>Summary information about the content.</p>
    pub content_summaries: std::option::Option<std::vec::Vec<crate::model::ContentSummary>>,
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchContentOutput {
    /// <p>Summary information about the content.</p>
    pub fn content_summaries(&self) -> std::option::Option<&[crate::model::ContentSummary]> {
        self.content_summaries.as_deref()
    }
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchContentOutput");
        formatter.field("content_summaries", &self.content_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchContentOutput`](crate::output::SearchContentOutput)
pub mod search_content_output {
    /// A builder for [`SearchContentOutput`](crate::output::SearchContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_summaries:
            std::option::Option<std::vec::Vec<crate::model::ContentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `content_summaries`.
        ///
        /// To override the contents of this collection use [`set_content_summaries`](Self::set_content_summaries).
        ///
        /// <p>Summary information about the content.</p>
        pub fn content_summaries(mut self, input: impl Into<crate::model::ContentSummary>) -> Self {
            let mut v = self.content_summaries.unwrap_or_default();
            v.push(input.into());
            self.content_summaries = Some(v);
            self
        }
        /// <p>Summary information about the content.</p>
        pub fn set_content_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContentSummary>>,
        ) -> Self {
            self.content_summaries = input;
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchContentOutput`](crate::output::SearchContentOutput)
        pub fn build(self) -> crate::output::SearchContentOutput {
            crate::output::SearchContentOutput {
                content_summaries: self.content_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchContentOutput {
    /// Creates a new builder-style object to manufacture [`SearchContentOutput`](crate::output::SearchContentOutput)
    pub fn builder() -> crate::output::search_content_output::Builder {
        crate::output::search_content_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveKnowledgeBaseTemplateUriOutput {}
impl std::fmt::Debug for RemoveKnowledgeBaseTemplateUriOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveKnowledgeBaseTemplateUriOutput");
        formatter.finish()
    }
}
/// See [`RemoveKnowledgeBaseTemplateUriOutput`](crate::output::RemoveKnowledgeBaseTemplateUriOutput)
pub mod remove_knowledge_base_template_uri_output {
    /// A builder for [`RemoveKnowledgeBaseTemplateUriOutput`](crate::output::RemoveKnowledgeBaseTemplateUriOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveKnowledgeBaseTemplateUriOutput`](crate::output::RemoveKnowledgeBaseTemplateUriOutput)
        pub fn build(self) -> crate::output::RemoveKnowledgeBaseTemplateUriOutput {
            crate::output::RemoveKnowledgeBaseTemplateUriOutput {}
        }
    }
}
impl RemoveKnowledgeBaseTemplateUriOutput {
    /// Creates a new builder-style object to manufacture [`RemoveKnowledgeBaseTemplateUriOutput`](crate::output::RemoveKnowledgeBaseTemplateUriOutput)
    pub fn builder() -> crate::output::remove_knowledge_base_template_uri_output::Builder {
        crate::output::remove_knowledge_base_template_uri_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKnowledgeBasesOutput {
    /// <p>Information about the knowledge bases.</p>
    pub knowledge_base_summaries:
        std::option::Option<std::vec::Vec<crate::model::KnowledgeBaseSummary>>,
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListKnowledgeBasesOutput {
    /// <p>Information about the knowledge bases.</p>
    pub fn knowledge_base_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::KnowledgeBaseSummary]> {
        self.knowledge_base_summaries.as_deref()
    }
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListKnowledgeBasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKnowledgeBasesOutput");
        formatter.field("knowledge_base_summaries", &self.knowledge_base_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListKnowledgeBasesOutput`](crate::output::ListKnowledgeBasesOutput)
pub mod list_knowledge_bases_output {
    /// A builder for [`ListKnowledgeBasesOutput`](crate::output::ListKnowledgeBasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_summaries:
            std::option::Option<std::vec::Vec<crate::model::KnowledgeBaseSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `knowledge_base_summaries`.
        ///
        /// To override the contents of this collection use [`set_knowledge_base_summaries`](Self::set_knowledge_base_summaries).
        ///
        /// <p>Information about the knowledge bases.</p>
        pub fn knowledge_base_summaries(
            mut self,
            input: impl Into<crate::model::KnowledgeBaseSummary>,
        ) -> Self {
            let mut v = self.knowledge_base_summaries.unwrap_or_default();
            v.push(input.into());
            self.knowledge_base_summaries = Some(v);
            self
        }
        /// <p>Information about the knowledge bases.</p>
        pub fn set_knowledge_base_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KnowledgeBaseSummary>>,
        ) -> Self {
            self.knowledge_base_summaries = input;
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKnowledgeBasesOutput`](crate::output::ListKnowledgeBasesOutput)
        pub fn build(self) -> crate::output::ListKnowledgeBasesOutput {
            crate::output::ListKnowledgeBasesOutput {
                knowledge_base_summaries: self.knowledge_base_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListKnowledgeBasesOutput {
    /// Creates a new builder-style object to manufacture [`ListKnowledgeBasesOutput`](crate::output::ListKnowledgeBasesOutput)
    pub fn builder() -> crate::output::list_knowledge_bases_output::Builder {
        crate::output::list_knowledge_bases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateKnowledgeBaseOutput {
    /// <p>The knowledge base.</p>
    pub knowledge_base: std::option::Option<crate::model::KnowledgeBaseData>,
}
impl CreateKnowledgeBaseOutput {
    /// <p>The knowledge base.</p>
    pub fn knowledge_base(&self) -> std::option::Option<&crate::model::KnowledgeBaseData> {
        self.knowledge_base.as_ref()
    }
}
impl std::fmt::Debug for CreateKnowledgeBaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateKnowledgeBaseOutput");
        formatter.field("knowledge_base", &self.knowledge_base);
        formatter.finish()
    }
}
/// See [`CreateKnowledgeBaseOutput`](crate::output::CreateKnowledgeBaseOutput)
pub mod create_knowledge_base_output {
    /// A builder for [`CreateKnowledgeBaseOutput`](crate::output::CreateKnowledgeBaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base: std::option::Option<crate::model::KnowledgeBaseData>,
    }
    impl Builder {
        /// <p>The knowledge base.</p>
        pub fn knowledge_base(mut self, input: crate::model::KnowledgeBaseData) -> Self {
            self.knowledge_base = Some(input);
            self
        }
        /// <p>The knowledge base.</p>
        pub fn set_knowledge_base(
            mut self,
            input: std::option::Option<crate::model::KnowledgeBaseData>,
        ) -> Self {
            self.knowledge_base = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKnowledgeBaseOutput`](crate::output::CreateKnowledgeBaseOutput)
        pub fn build(self) -> crate::output::CreateKnowledgeBaseOutput {
            crate::output::CreateKnowledgeBaseOutput {
                knowledge_base: self.knowledge_base,
            }
        }
    }
}
impl CreateKnowledgeBaseOutput {
    /// Creates a new builder-style object to manufacture [`CreateKnowledgeBaseOutput`](crate::output::CreateKnowledgeBaseOutput)
    pub fn builder() -> crate::output::create_knowledge_base_output::Builder {
        crate::output::create_knowledge_base_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteKnowledgeBaseOutput {}
impl std::fmt::Debug for DeleteKnowledgeBaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteKnowledgeBaseOutput");
        formatter.finish()
    }
}
/// See [`DeleteKnowledgeBaseOutput`](crate::output::DeleteKnowledgeBaseOutput)
pub mod delete_knowledge_base_output {
    /// A builder for [`DeleteKnowledgeBaseOutput`](crate::output::DeleteKnowledgeBaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteKnowledgeBaseOutput`](crate::output::DeleteKnowledgeBaseOutput)
        pub fn build(self) -> crate::output::DeleteKnowledgeBaseOutput {
            crate::output::DeleteKnowledgeBaseOutput {}
        }
    }
}
impl DeleteKnowledgeBaseOutput {
    /// Creates a new builder-style object to manufacture [`DeleteKnowledgeBaseOutput`](crate::output::DeleteKnowledgeBaseOutput)
    pub fn builder() -> crate::output::delete_knowledge_base_output::Builder {
        crate::output::delete_knowledge_base_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKnowledgeBaseOutput {
    /// <p>The knowledge base.</p>
    pub knowledge_base: std::option::Option<crate::model::KnowledgeBaseData>,
}
impl GetKnowledgeBaseOutput {
    /// <p>The knowledge base.</p>
    pub fn knowledge_base(&self) -> std::option::Option<&crate::model::KnowledgeBaseData> {
        self.knowledge_base.as_ref()
    }
}
impl std::fmt::Debug for GetKnowledgeBaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKnowledgeBaseOutput");
        formatter.field("knowledge_base", &self.knowledge_base);
        formatter.finish()
    }
}
/// See [`GetKnowledgeBaseOutput`](crate::output::GetKnowledgeBaseOutput)
pub mod get_knowledge_base_output {
    /// A builder for [`GetKnowledgeBaseOutput`](crate::output::GetKnowledgeBaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base: std::option::Option<crate::model::KnowledgeBaseData>,
    }
    impl Builder {
        /// <p>The knowledge base.</p>
        pub fn knowledge_base(mut self, input: crate::model::KnowledgeBaseData) -> Self {
            self.knowledge_base = Some(input);
            self
        }
        /// <p>The knowledge base.</p>
        pub fn set_knowledge_base(
            mut self,
            input: std::option::Option<crate::model::KnowledgeBaseData>,
        ) -> Self {
            self.knowledge_base = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKnowledgeBaseOutput`](crate::output::GetKnowledgeBaseOutput)
        pub fn build(self) -> crate::output::GetKnowledgeBaseOutput {
            crate::output::GetKnowledgeBaseOutput {
                knowledge_base: self.knowledge_base,
            }
        }
    }
}
impl GetKnowledgeBaseOutput {
    /// Creates a new builder-style object to manufacture [`GetKnowledgeBaseOutput`](crate::output::GetKnowledgeBaseOutput)
    pub fn builder() -> crate::output::get_knowledge_base_output::Builder {
        crate::output::get_knowledge_base_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContentSummaryOutput {
    /// <p>The content summary.</p>
    pub content_summary: std::option::Option<crate::model::ContentSummary>,
}
impl GetContentSummaryOutput {
    /// <p>The content summary.</p>
    pub fn content_summary(&self) -> std::option::Option<&crate::model::ContentSummary> {
        self.content_summary.as_ref()
    }
}
impl std::fmt::Debug for GetContentSummaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContentSummaryOutput");
        formatter.field("content_summary", &self.content_summary);
        formatter.finish()
    }
}
/// See [`GetContentSummaryOutput`](crate::output::GetContentSummaryOutput)
pub mod get_content_summary_output {
    /// A builder for [`GetContentSummaryOutput`](crate::output::GetContentSummaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_summary: std::option::Option<crate::model::ContentSummary>,
    }
    impl Builder {
        /// <p>The content summary.</p>
        pub fn content_summary(mut self, input: crate::model::ContentSummary) -> Self {
            self.content_summary = Some(input);
            self
        }
        /// <p>The content summary.</p>
        pub fn set_content_summary(
            mut self,
            input: std::option::Option<crate::model::ContentSummary>,
        ) -> Self {
            self.content_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContentSummaryOutput`](crate::output::GetContentSummaryOutput)
        pub fn build(self) -> crate::output::GetContentSummaryOutput {
            crate::output::GetContentSummaryOutput {
                content_summary: self.content_summary,
            }
        }
    }
}
impl GetContentSummaryOutput {
    /// Creates a new builder-style object to manufacture [`GetContentSummaryOutput`](crate::output::GetContentSummaryOutput)
    pub fn builder() -> crate::output::get_content_summary_output::Builder {
        crate::output::get_content_summary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContentsOutput {
    /// <p>Information about the content.</p>
    pub content_summaries: std::option::Option<std::vec::Vec<crate::model::ContentSummary>>,
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListContentsOutput {
    /// <p>Information about the content.</p>
    pub fn content_summaries(&self) -> std::option::Option<&[crate::model::ContentSummary]> {
        self.content_summaries.as_deref()
    }
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListContentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContentsOutput");
        formatter.field("content_summaries", &self.content_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListContentsOutput`](crate::output::ListContentsOutput)
pub mod list_contents_output {
    /// A builder for [`ListContentsOutput`](crate::output::ListContentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_summaries:
            std::option::Option<std::vec::Vec<crate::model::ContentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `content_summaries`.
        ///
        /// To override the contents of this collection use [`set_content_summaries`](Self::set_content_summaries).
        ///
        /// <p>Information about the content.</p>
        pub fn content_summaries(mut self, input: impl Into<crate::model::ContentSummary>) -> Self {
            let mut v = self.content_summaries.unwrap_or_default();
            v.push(input.into());
            self.content_summaries = Some(v);
            self
        }
        /// <p>Information about the content.</p>
        pub fn set_content_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContentSummary>>,
        ) -> Self {
            self.content_summaries = input;
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContentsOutput`](crate::output::ListContentsOutput)
        pub fn build(self) -> crate::output::ListContentsOutput {
            crate::output::ListContentsOutput {
                content_summaries: self.content_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListContentsOutput {
    /// Creates a new builder-style object to manufacture [`ListContentsOutput`](crate::output::ListContentsOutput)
    pub fn builder() -> crate::output::list_contents_output::Builder {
        crate::output::list_contents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContentOutput {
    /// <p>The content.</p>
    pub content: std::option::Option<crate::model::ContentData>,
}
impl CreateContentOutput {
    /// <p>The content.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::ContentData> {
        self.content.as_ref()
    }
}
impl std::fmt::Debug for CreateContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContentOutput");
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`CreateContentOutput`](crate::output::CreateContentOutput)
pub mod create_content_output {
    /// A builder for [`CreateContentOutput`](crate::output::CreateContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<crate::model::ContentData>,
    }
    impl Builder {
        /// <p>The content.</p>
        pub fn content(mut self, input: crate::model::ContentData) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The content.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::ContentData>,
        ) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContentOutput`](crate::output::CreateContentOutput)
        pub fn build(self) -> crate::output::CreateContentOutput {
            crate::output::CreateContentOutput {
                content: self.content,
            }
        }
    }
}
impl CreateContentOutput {
    /// Creates a new builder-style object to manufacture [`CreateContentOutput`](crate::output::CreateContentOutput)
    pub fn builder() -> crate::output::create_content_output::Builder {
        crate::output::create_content_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContentOutput {}
impl std::fmt::Debug for DeleteContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContentOutput");
        formatter.finish()
    }
}
/// See [`DeleteContentOutput`](crate::output::DeleteContentOutput)
pub mod delete_content_output {
    /// A builder for [`DeleteContentOutput`](crate::output::DeleteContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteContentOutput`](crate::output::DeleteContentOutput)
        pub fn build(self) -> crate::output::DeleteContentOutput {
            crate::output::DeleteContentOutput {}
        }
    }
}
impl DeleteContentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteContentOutput`](crate::output::DeleteContentOutput)
    pub fn builder() -> crate::output::delete_content_output::Builder {
        crate::output::delete_content_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContentOutput {
    /// <p>The content.</p>
    pub content: std::option::Option<crate::model::ContentData>,
}
impl UpdateContentOutput {
    /// <p>The content.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::ContentData> {
        self.content.as_ref()
    }
}
impl std::fmt::Debug for UpdateContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContentOutput");
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`UpdateContentOutput`](crate::output::UpdateContentOutput)
pub mod update_content_output {
    /// A builder for [`UpdateContentOutput`](crate::output::UpdateContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<crate::model::ContentData>,
    }
    impl Builder {
        /// <p>The content.</p>
        pub fn content(mut self, input: crate::model::ContentData) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The content.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::ContentData>,
        ) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContentOutput`](crate::output::UpdateContentOutput)
        pub fn build(self) -> crate::output::UpdateContentOutput {
            crate::output::UpdateContentOutput {
                content: self.content,
            }
        }
    }
}
impl UpdateContentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateContentOutput`](crate::output::UpdateContentOutput)
    pub fn builder() -> crate::output::update_content_output::Builder {
        crate::output::update_content_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContentOutput {
    /// <p>The content.</p>
    pub content: std::option::Option<crate::model::ContentData>,
}
impl GetContentOutput {
    /// <p>The content.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::ContentData> {
        self.content.as_ref()
    }
}
impl std::fmt::Debug for GetContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContentOutput");
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`GetContentOutput`](crate::output::GetContentOutput)
pub mod get_content_output {
    /// A builder for [`GetContentOutput`](crate::output::GetContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<crate::model::ContentData>,
    }
    impl Builder {
        /// <p>The content.</p>
        pub fn content(mut self, input: crate::model::ContentData) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The content.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::ContentData>,
        ) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContentOutput`](crate::output::GetContentOutput)
        pub fn build(self) -> crate::output::GetContentOutput {
            crate::output::GetContentOutput {
                content: self.content,
            }
        }
    }
}
impl GetContentOutput {
    /// Creates a new builder-style object to manufacture [`GetContentOutput`](crate::output::GetContentOutput)
    pub fn builder() -> crate::output::get_content_output::Builder {
        crate::output::get_content_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchSessionsOutput {
    /// <p>Summary information about the sessions.</p>
    pub session_summaries: std::option::Option<std::vec::Vec<crate::model::SessionSummary>>,
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchSessionsOutput {
    /// <p>Summary information about the sessions.</p>
    pub fn session_summaries(&self) -> std::option::Option<&[crate::model::SessionSummary]> {
        self.session_summaries.as_deref()
    }
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchSessionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchSessionsOutput");
        formatter.field("session_summaries", &self.session_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchSessionsOutput`](crate::output::SearchSessionsOutput)
pub mod search_sessions_output {
    /// A builder for [`SearchSessionsOutput`](crate::output::SearchSessionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_summaries:
            std::option::Option<std::vec::Vec<crate::model::SessionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `session_summaries`.
        ///
        /// To override the contents of this collection use [`set_session_summaries`](Self::set_session_summaries).
        ///
        /// <p>Summary information about the sessions.</p>
        pub fn session_summaries(mut self, input: impl Into<crate::model::SessionSummary>) -> Self {
            let mut v = self.session_summaries.unwrap_or_default();
            v.push(input.into());
            self.session_summaries = Some(v);
            self
        }
        /// <p>Summary information about the sessions.</p>
        pub fn set_session_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SessionSummary>>,
        ) -> Self {
            self.session_summaries = input;
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchSessionsOutput`](crate::output::SearchSessionsOutput)
        pub fn build(self) -> crate::output::SearchSessionsOutput {
            crate::output::SearchSessionsOutput {
                session_summaries: self.session_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchSessionsOutput {
    /// Creates a new builder-style object to manufacture [`SearchSessionsOutput`](crate::output::SearchSessionsOutput)
    pub fn builder() -> crate::output::search_sessions_output::Builder {
        crate::output::search_sessions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryAssistantOutput {
    /// <p>The results of the query.</p>
    pub results: std::option::Option<std::vec::Vec<crate::model::ResultData>>,
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl QueryAssistantOutput {
    /// <p>The results of the query.</p>
    pub fn results(&self) -> std::option::Option<&[crate::model::ResultData]> {
        self.results.as_deref()
    }
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for QueryAssistantOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryAssistantOutput");
        formatter.field("results", &self.results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`QueryAssistantOutput`](crate::output::QueryAssistantOutput)
pub mod query_assistant_output {
    /// A builder for [`QueryAssistantOutput`](crate::output::QueryAssistantOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::ResultData>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>The results of the query.</p>
        pub fn results(mut self, input: impl Into<crate::model::ResultData>) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input.into());
            self.results = Some(v);
            self
        }
        /// <p>The results of the query.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResultData>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryAssistantOutput`](crate::output::QueryAssistantOutput)
        pub fn build(self) -> crate::output::QueryAssistantOutput {
            crate::output::QueryAssistantOutput {
                results: self.results,
                next_token: self.next_token,
            }
        }
    }
}
impl QueryAssistantOutput {
    /// Creates a new builder-style object to manufacture [`QueryAssistantOutput`](crate::output::QueryAssistantOutput)
    pub fn builder() -> crate::output::query_assistant_output::Builder {
        crate::output::query_assistant_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyRecommendationsReceivedOutput {
    /// <p>The identifiers of the recommendations.</p>
    pub recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The identifiers of recommendations that are causing errors.</p>
    pub errors:
        std::option::Option<std::vec::Vec<crate::model::NotifyRecommendationsReceivedError>>,
}
impl NotifyRecommendationsReceivedOutput {
    /// <p>The identifiers of the recommendations.</p>
    pub fn recommendation_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.recommendation_ids.as_deref()
    }
    /// <p>The identifiers of recommendations that are causing errors.</p>
    pub fn errors(
        &self,
    ) -> std::option::Option<&[crate::model::NotifyRecommendationsReceivedError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for NotifyRecommendationsReceivedOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyRecommendationsReceivedOutput");
        formatter.field("recommendation_ids", &self.recommendation_ids);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`NotifyRecommendationsReceivedOutput`](crate::output::NotifyRecommendationsReceivedOutput)
pub mod notify_recommendations_received_output {
    /// A builder for [`NotifyRecommendationsReceivedOutput`](crate::output::NotifyRecommendationsReceivedOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::NotifyRecommendationsReceivedError>>,
    }
    impl Builder {
        /// Appends an item to `recommendation_ids`.
        ///
        /// To override the contents of this collection use [`set_recommendation_ids`](Self::set_recommendation_ids).
        ///
        /// <p>The identifiers of the recommendations.</p>
        pub fn recommendation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recommendation_ids.unwrap_or_default();
            v.push(input.into());
            self.recommendation_ids = Some(v);
            self
        }
        /// <p>The identifiers of the recommendations.</p>
        pub fn set_recommendation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recommendation_ids = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>The identifiers of recommendations that are causing errors.</p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::NotifyRecommendationsReceivedError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>The identifiers of recommendations that are causing errors.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::NotifyRecommendationsReceivedError>,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyRecommendationsReceivedOutput`](crate::output::NotifyRecommendationsReceivedOutput)
        pub fn build(self) -> crate::output::NotifyRecommendationsReceivedOutput {
            crate::output::NotifyRecommendationsReceivedOutput {
                recommendation_ids: self.recommendation_ids,
                errors: self.errors,
            }
        }
    }
}
impl NotifyRecommendationsReceivedOutput {
    /// Creates a new builder-style object to manufacture [`NotifyRecommendationsReceivedOutput`](crate::output::NotifyRecommendationsReceivedOutput)
    pub fn builder() -> crate::output::notify_recommendations_received_output::Builder {
        crate::output::notify_recommendations_received_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecommendationsOutput {
    /// <p>The recommendations.</p>
    pub recommendations: std::option::Option<std::vec::Vec<crate::model::RecommendationData>>,
}
impl GetRecommendationsOutput {
    /// <p>The recommendations.</p>
    pub fn recommendations(&self) -> std::option::Option<&[crate::model::RecommendationData]> {
        self.recommendations.as_deref()
    }
}
impl std::fmt::Debug for GetRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecommendationsOutput");
        formatter.field("recommendations", &self.recommendations);
        formatter.finish()
    }
}
/// See [`GetRecommendationsOutput`](crate::output::GetRecommendationsOutput)
pub mod get_recommendations_output {
    /// A builder for [`GetRecommendationsOutput`](crate::output::GetRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendations:
            std::option::Option<std::vec::Vec<crate::model::RecommendationData>>,
    }
    impl Builder {
        /// Appends an item to `recommendations`.
        ///
        /// To override the contents of this collection use [`set_recommendations`](Self::set_recommendations).
        ///
        /// <p>The recommendations.</p>
        pub fn recommendations(
            mut self,
            input: impl Into<crate::model::RecommendationData>,
        ) -> Self {
            let mut v = self.recommendations.unwrap_or_default();
            v.push(input.into());
            self.recommendations = Some(v);
            self
        }
        /// <p>The recommendations.</p>
        pub fn set_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationData>>,
        ) -> Self {
            self.recommendations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecommendationsOutput`](crate::output::GetRecommendationsOutput)
        pub fn build(self) -> crate::output::GetRecommendationsOutput {
            crate::output::GetRecommendationsOutput {
                recommendations: self.recommendations,
            }
        }
    }
}
impl GetRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`GetRecommendationsOutput`](crate::output::GetRecommendationsOutput)
    pub fn builder() -> crate::output::get_recommendations_output::Builder {
        crate::output::get_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssistantsOutput {
    /// <p>Information about the assistants.</p>
    pub assistant_summaries: std::option::Option<std::vec::Vec<crate::model::AssistantSummary>>,
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssistantsOutput {
    /// <p>Information about the assistants.</p>
    pub fn assistant_summaries(&self) -> std::option::Option<&[crate::model::AssistantSummary]> {
        self.assistant_summaries.as_deref()
    }
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssistantsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssistantsOutput");
        formatter.field("assistant_summaries", &self.assistant_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssistantsOutput`](crate::output::ListAssistantsOutput)
pub mod list_assistants_output {
    /// A builder for [`ListAssistantsOutput`](crate::output::ListAssistantsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_summaries:
            std::option::Option<std::vec::Vec<crate::model::AssistantSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `assistant_summaries`.
        ///
        /// To override the contents of this collection use [`set_assistant_summaries`](Self::set_assistant_summaries).
        ///
        /// <p>Information about the assistants.</p>
        pub fn assistant_summaries(
            mut self,
            input: impl Into<crate::model::AssistantSummary>,
        ) -> Self {
            let mut v = self.assistant_summaries.unwrap_or_default();
            v.push(input.into());
            self.assistant_summaries = Some(v);
            self
        }
        /// <p>Information about the assistants.</p>
        pub fn set_assistant_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssistantSummary>>,
        ) -> Self {
            self.assistant_summaries = input;
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssistantsOutput`](crate::output::ListAssistantsOutput)
        pub fn build(self) -> crate::output::ListAssistantsOutput {
            crate::output::ListAssistantsOutput {
                assistant_summaries: self.assistant_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssistantsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssistantsOutput`](crate::output::ListAssistantsOutput)
    pub fn builder() -> crate::output::list_assistants_output::Builder {
        crate::output::list_assistants_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssistantOutput {
    /// <p>Information about the assistant.</p>
    pub assistant: std::option::Option<crate::model::AssistantData>,
}
impl CreateAssistantOutput {
    /// <p>Information about the assistant.</p>
    pub fn assistant(&self) -> std::option::Option<&crate::model::AssistantData> {
        self.assistant.as_ref()
    }
}
impl std::fmt::Debug for CreateAssistantOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssistantOutput");
        formatter.field("assistant", &self.assistant);
        formatter.finish()
    }
}
/// See [`CreateAssistantOutput`](crate::output::CreateAssistantOutput)
pub mod create_assistant_output {
    /// A builder for [`CreateAssistantOutput`](crate::output::CreateAssistantOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant: std::option::Option<crate::model::AssistantData>,
    }
    impl Builder {
        /// <p>Information about the assistant.</p>
        pub fn assistant(mut self, input: crate::model::AssistantData) -> Self {
            self.assistant = Some(input);
            self
        }
        /// <p>Information about the assistant.</p>
        pub fn set_assistant(
            mut self,
            input: std::option::Option<crate::model::AssistantData>,
        ) -> Self {
            self.assistant = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssistantOutput`](crate::output::CreateAssistantOutput)
        pub fn build(self) -> crate::output::CreateAssistantOutput {
            crate::output::CreateAssistantOutput {
                assistant: self.assistant,
            }
        }
    }
}
impl CreateAssistantOutput {
    /// Creates a new builder-style object to manufacture [`CreateAssistantOutput`](crate::output::CreateAssistantOutput)
    pub fn builder() -> crate::output::create_assistant_output::Builder {
        crate::output::create_assistant_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssistantOutput {}
impl std::fmt::Debug for DeleteAssistantOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssistantOutput");
        formatter.finish()
    }
}
/// See [`DeleteAssistantOutput`](crate::output::DeleteAssistantOutput)
pub mod delete_assistant_output {
    /// A builder for [`DeleteAssistantOutput`](crate::output::DeleteAssistantOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAssistantOutput`](crate::output::DeleteAssistantOutput)
        pub fn build(self) -> crate::output::DeleteAssistantOutput {
            crate::output::DeleteAssistantOutput {}
        }
    }
}
impl DeleteAssistantOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssistantOutput`](crate::output::DeleteAssistantOutput)
    pub fn builder() -> crate::output::delete_assistant_output::Builder {
        crate::output::delete_assistant_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssistantOutput {
    /// <p>Information about the assistant.</p>
    pub assistant: std::option::Option<crate::model::AssistantData>,
}
impl GetAssistantOutput {
    /// <p>Information about the assistant.</p>
    pub fn assistant(&self) -> std::option::Option<&crate::model::AssistantData> {
        self.assistant.as_ref()
    }
}
impl std::fmt::Debug for GetAssistantOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssistantOutput");
        formatter.field("assistant", &self.assistant);
        formatter.finish()
    }
}
/// See [`GetAssistantOutput`](crate::output::GetAssistantOutput)
pub mod get_assistant_output {
    /// A builder for [`GetAssistantOutput`](crate::output::GetAssistantOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant: std::option::Option<crate::model::AssistantData>,
    }
    impl Builder {
        /// <p>Information about the assistant.</p>
        pub fn assistant(mut self, input: crate::model::AssistantData) -> Self {
            self.assistant = Some(input);
            self
        }
        /// <p>Information about the assistant.</p>
        pub fn set_assistant(
            mut self,
            input: std::option::Option<crate::model::AssistantData>,
        ) -> Self {
            self.assistant = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssistantOutput`](crate::output::GetAssistantOutput)
        pub fn build(self) -> crate::output::GetAssistantOutput {
            crate::output::GetAssistantOutput {
                assistant: self.assistant,
            }
        }
    }
}
impl GetAssistantOutput {
    /// Creates a new builder-style object to manufacture [`GetAssistantOutput`](crate::output::GetAssistantOutput)
    pub fn builder() -> crate::output::get_assistant_output::Builder {
        crate::output::get_assistant_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSessionOutput {
    /// <p>The session.</p>
    pub session: std::option::Option<crate::model::SessionData>,
}
impl CreateSessionOutput {
    /// <p>The session.</p>
    pub fn session(&self) -> std::option::Option<&crate::model::SessionData> {
        self.session.as_ref()
    }
}
impl std::fmt::Debug for CreateSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSessionOutput");
        formatter.field("session", &self.session);
        formatter.finish()
    }
}
/// See [`CreateSessionOutput`](crate::output::CreateSessionOutput)
pub mod create_session_output {
    /// A builder for [`CreateSessionOutput`](crate::output::CreateSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session: std::option::Option<crate::model::SessionData>,
    }
    impl Builder {
        /// <p>The session.</p>
        pub fn session(mut self, input: crate::model::SessionData) -> Self {
            self.session = Some(input);
            self
        }
        /// <p>The session.</p>
        pub fn set_session(
            mut self,
            input: std::option::Option<crate::model::SessionData>,
        ) -> Self {
            self.session = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSessionOutput`](crate::output::CreateSessionOutput)
        pub fn build(self) -> crate::output::CreateSessionOutput {
            crate::output::CreateSessionOutput {
                session: self.session,
            }
        }
    }
}
impl CreateSessionOutput {
    /// Creates a new builder-style object to manufacture [`CreateSessionOutput`](crate::output::CreateSessionOutput)
    pub fn builder() -> crate::output::create_session_output::Builder {
        crate::output::create_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSessionOutput {
    /// <p>The session.</p>
    pub session: std::option::Option<crate::model::SessionData>,
}
impl GetSessionOutput {
    /// <p>The session.</p>
    pub fn session(&self) -> std::option::Option<&crate::model::SessionData> {
        self.session.as_ref()
    }
}
impl std::fmt::Debug for GetSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSessionOutput");
        formatter.field("session", &self.session);
        formatter.finish()
    }
}
/// See [`GetSessionOutput`](crate::output::GetSessionOutput)
pub mod get_session_output {
    /// A builder for [`GetSessionOutput`](crate::output::GetSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session: std::option::Option<crate::model::SessionData>,
    }
    impl Builder {
        /// <p>The session.</p>
        pub fn session(mut self, input: crate::model::SessionData) -> Self {
            self.session = Some(input);
            self
        }
        /// <p>The session.</p>
        pub fn set_session(
            mut self,
            input: std::option::Option<crate::model::SessionData>,
        ) -> Self {
            self.session = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSessionOutput`](crate::output::GetSessionOutput)
        pub fn build(self) -> crate::output::GetSessionOutput {
            crate::output::GetSessionOutput {
                session: self.session,
            }
        }
    }
}
impl GetSessionOutput {
    /// Creates a new builder-style object to manufacture [`GetSessionOutput`](crate::output::GetSessionOutput)
    pub fn builder() -> crate::output::get_session_output::Builder {
        crate::output::get_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssistantAssociationsOutput {
    /// <p>Summary information about assistant associations.</p>
    pub assistant_association_summaries:
        std::option::Option<std::vec::Vec<crate::model::AssistantAssociationSummary>>,
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssistantAssociationsOutput {
    /// <p>Summary information about assistant associations.</p>
    pub fn assistant_association_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::AssistantAssociationSummary]> {
        self.assistant_association_summaries.as_deref()
    }
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssistantAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssistantAssociationsOutput");
        formatter.field(
            "assistant_association_summaries",
            &self.assistant_association_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssistantAssociationsOutput`](crate::output::ListAssistantAssociationsOutput)
pub mod list_assistant_associations_output {
    /// A builder for [`ListAssistantAssociationsOutput`](crate::output::ListAssistantAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_association_summaries:
            std::option::Option<std::vec::Vec<crate::model::AssistantAssociationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `assistant_association_summaries`.
        ///
        /// To override the contents of this collection use [`set_assistant_association_summaries`](Self::set_assistant_association_summaries).
        ///
        /// <p>Summary information about assistant associations.</p>
        pub fn assistant_association_summaries(
            mut self,
            input: impl Into<crate::model::AssistantAssociationSummary>,
        ) -> Self {
            let mut v = self.assistant_association_summaries.unwrap_or_default();
            v.push(input.into());
            self.assistant_association_summaries = Some(v);
            self
        }
        /// <p>Summary information about assistant associations.</p>
        pub fn set_assistant_association_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssistantAssociationSummary>>,
        ) -> Self {
            self.assistant_association_summaries = input;
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssistantAssociationsOutput`](crate::output::ListAssistantAssociationsOutput)
        pub fn build(self) -> crate::output::ListAssistantAssociationsOutput {
            crate::output::ListAssistantAssociationsOutput {
                assistant_association_summaries: self.assistant_association_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssistantAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssistantAssociationsOutput`](crate::output::ListAssistantAssociationsOutput)
    pub fn builder() -> crate::output::list_assistant_associations_output::Builder {
        crate::output::list_assistant_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssistantAssociationOutput {
    /// <p>The assistant association.</p>
    pub assistant_association: std::option::Option<crate::model::AssistantAssociationData>,
}
impl CreateAssistantAssociationOutput {
    /// <p>The assistant association.</p>
    pub fn assistant_association(
        &self,
    ) -> std::option::Option<&crate::model::AssistantAssociationData> {
        self.assistant_association.as_ref()
    }
}
impl std::fmt::Debug for CreateAssistantAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssistantAssociationOutput");
        formatter.field("assistant_association", &self.assistant_association);
        formatter.finish()
    }
}
/// See [`CreateAssistantAssociationOutput`](crate::output::CreateAssistantAssociationOutput)
pub mod create_assistant_association_output {
    /// A builder for [`CreateAssistantAssociationOutput`](crate::output::CreateAssistantAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_association:
            std::option::Option<crate::model::AssistantAssociationData>,
    }
    impl Builder {
        /// <p>The assistant association.</p>
        pub fn assistant_association(
            mut self,
            input: crate::model::AssistantAssociationData,
        ) -> Self {
            self.assistant_association = Some(input);
            self
        }
        /// <p>The assistant association.</p>
        pub fn set_assistant_association(
            mut self,
            input: std::option::Option<crate::model::AssistantAssociationData>,
        ) -> Self {
            self.assistant_association = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssistantAssociationOutput`](crate::output::CreateAssistantAssociationOutput)
        pub fn build(self) -> crate::output::CreateAssistantAssociationOutput {
            crate::output::CreateAssistantAssociationOutput {
                assistant_association: self.assistant_association,
            }
        }
    }
}
impl CreateAssistantAssociationOutput {
    /// Creates a new builder-style object to manufacture [`CreateAssistantAssociationOutput`](crate::output::CreateAssistantAssociationOutput)
    pub fn builder() -> crate::output::create_assistant_association_output::Builder {
        crate::output::create_assistant_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssistantAssociationOutput {}
impl std::fmt::Debug for DeleteAssistantAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssistantAssociationOutput");
        formatter.finish()
    }
}
/// See [`DeleteAssistantAssociationOutput`](crate::output::DeleteAssistantAssociationOutput)
pub mod delete_assistant_association_output {
    /// A builder for [`DeleteAssistantAssociationOutput`](crate::output::DeleteAssistantAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAssistantAssociationOutput`](crate::output::DeleteAssistantAssociationOutput)
        pub fn build(self) -> crate::output::DeleteAssistantAssociationOutput {
            crate::output::DeleteAssistantAssociationOutput {}
        }
    }
}
impl DeleteAssistantAssociationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssistantAssociationOutput`](crate::output::DeleteAssistantAssociationOutput)
    pub fn builder() -> crate::output::delete_assistant_association_output::Builder {
        crate::output::delete_assistant_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssistantAssociationOutput {
    /// <p>The assistant association.</p>
    pub assistant_association: std::option::Option<crate::model::AssistantAssociationData>,
}
impl GetAssistantAssociationOutput {
    /// <p>The assistant association.</p>
    pub fn assistant_association(
        &self,
    ) -> std::option::Option<&crate::model::AssistantAssociationData> {
        self.assistant_association.as_ref()
    }
}
impl std::fmt::Debug for GetAssistantAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssistantAssociationOutput");
        formatter.field("assistant_association", &self.assistant_association);
        formatter.finish()
    }
}
/// See [`GetAssistantAssociationOutput`](crate::output::GetAssistantAssociationOutput)
pub mod get_assistant_association_output {
    /// A builder for [`GetAssistantAssociationOutput`](crate::output::GetAssistantAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_association:
            std::option::Option<crate::model::AssistantAssociationData>,
    }
    impl Builder {
        /// <p>The assistant association.</p>
        pub fn assistant_association(
            mut self,
            input: crate::model::AssistantAssociationData,
        ) -> Self {
            self.assistant_association = Some(input);
            self
        }
        /// <p>The assistant association.</p>
        pub fn set_assistant_association(
            mut self,
            input: std::option::Option<crate::model::AssistantAssociationData>,
        ) -> Self {
            self.assistant_association = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssistantAssociationOutput`](crate::output::GetAssistantAssociationOutput)
        pub fn build(self) -> crate::output::GetAssistantAssociationOutput {
            crate::output::GetAssistantAssociationOutput {
                assistant_association: self.assistant_association,
            }
        }
    }
}
impl GetAssistantAssociationOutput {
    /// Creates a new builder-style object to manufacture [`GetAssistantAssociationOutput`](crate::output::GetAssistantAssociationOutput)
    pub fn builder() -> crate::output::get_assistant_association_output::Builder {
        crate::output::get_assistant_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}
