// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateAssistant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_assistant`](crate::client::Client::create_assistant).
///
/// See [`crate::client::fluent_builders::CreateAssistant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAssistant {
    _private: (),
}
impl CreateAssistant {
    /// Creates a new builder-style object to manufacture [`CreateAssistantInput`](crate::input::CreateAssistantInput)
    pub fn builder() -> crate::input::create_assistant_input::Builder {
        crate::input::create_assistant_input::Builder::default()
    }
    /// Creates a new `CreateAssistant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAssistant {
    type Output = std::result::Result<
        crate::output::CreateAssistantOutput,
        crate::error::CreateAssistantError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_assistant_error(response)
        } else {
            crate::operation_deser::parse_create_assistant_response(response)
        }
    }
}

/// Operation shape for `CreateAssistantAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_assistant_association`](crate::client::Client::create_assistant_association).
///
/// See [`crate::client::fluent_builders::CreateAssistantAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAssistantAssociation {
    _private: (),
}
impl CreateAssistantAssociation {
    /// Creates a new builder-style object to manufacture [`CreateAssistantAssociationInput`](crate::input::CreateAssistantAssociationInput)
    pub fn builder() -> crate::input::create_assistant_association_input::Builder {
        crate::input::create_assistant_association_input::Builder::default()
    }
    /// Creates a new `CreateAssistantAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAssistantAssociation {
    type Output = std::result::Result<
        crate::output::CreateAssistantAssociationOutput,
        crate::error::CreateAssistantAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_assistant_association_error(response)
        } else {
            crate::operation_deser::parse_create_assistant_association_response(response)
        }
    }
}

/// Operation shape for `CreateContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_content`](crate::client::Client::create_content).
///
/// See [`crate::client::fluent_builders::CreateContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateContent {
    _private: (),
}
impl CreateContent {
    /// Creates a new builder-style object to manufacture [`CreateContentInput`](crate::input::CreateContentInput)
    pub fn builder() -> crate::input::create_content_input::Builder {
        crate::input::create_content_input::Builder::default()
    }
    /// Creates a new `CreateContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateContent {
    type Output =
        std::result::Result<crate::output::CreateContentOutput, crate::error::CreateContentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_content_error(response)
        } else {
            crate::operation_deser::parse_create_content_response(response)
        }
    }
}

/// Operation shape for `CreateKnowledgeBase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_knowledge_base`](crate::client::Client::create_knowledge_base).
///
/// See [`crate::client::fluent_builders::CreateKnowledgeBase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateKnowledgeBase {
    _private: (),
}
impl CreateKnowledgeBase {
    /// Creates a new builder-style object to manufacture [`CreateKnowledgeBaseInput`](crate::input::CreateKnowledgeBaseInput)
    pub fn builder() -> crate::input::create_knowledge_base_input::Builder {
        crate::input::create_knowledge_base_input::Builder::default()
    }
    /// Creates a new `CreateKnowledgeBase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateKnowledgeBase {
    type Output = std::result::Result<
        crate::output::CreateKnowledgeBaseOutput,
        crate::error::CreateKnowledgeBaseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_knowledge_base_error(response)
        } else {
            crate::operation_deser::parse_create_knowledge_base_response(response)
        }
    }
}

/// Operation shape for `CreateSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_session`](crate::client::Client::create_session).
///
/// See [`crate::client::fluent_builders::CreateSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSession {
    _private: (),
}
impl CreateSession {
    /// Creates a new builder-style object to manufacture [`CreateSessionInput`](crate::input::CreateSessionInput)
    pub fn builder() -> crate::input::create_session_input::Builder {
        crate::input::create_session_input::Builder::default()
    }
    /// Creates a new `CreateSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSession {
    type Output =
        std::result::Result<crate::output::CreateSessionOutput, crate::error::CreateSessionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_session_error(response)
        } else {
            crate::operation_deser::parse_create_session_response(response)
        }
    }
}

/// Operation shape for `DeleteAssistant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_assistant`](crate::client::Client::delete_assistant).
///
/// See [`crate::client::fluent_builders::DeleteAssistant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssistant {
    _private: (),
}
impl DeleteAssistant {
    /// Creates a new builder-style object to manufacture [`DeleteAssistantInput`](crate::input::DeleteAssistantInput)
    pub fn builder() -> crate::input::delete_assistant_input::Builder {
        crate::input::delete_assistant_input::Builder::default()
    }
    /// Creates a new `DeleteAssistant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssistant {
    type Output = std::result::Result<
        crate::output::DeleteAssistantOutput,
        crate::error::DeleteAssistantError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_assistant_error(response)
        } else {
            crate::operation_deser::parse_delete_assistant_response(response)
        }
    }
}

/// Operation shape for `DeleteAssistantAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_assistant_association`](crate::client::Client::delete_assistant_association).
///
/// See [`crate::client::fluent_builders::DeleteAssistantAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssistantAssociation {
    _private: (),
}
impl DeleteAssistantAssociation {
    /// Creates a new builder-style object to manufacture [`DeleteAssistantAssociationInput`](crate::input::DeleteAssistantAssociationInput)
    pub fn builder() -> crate::input::delete_assistant_association_input::Builder {
        crate::input::delete_assistant_association_input::Builder::default()
    }
    /// Creates a new `DeleteAssistantAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssistantAssociation {
    type Output = std::result::Result<
        crate::output::DeleteAssistantAssociationOutput,
        crate::error::DeleteAssistantAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_assistant_association_error(response)
        } else {
            crate::operation_deser::parse_delete_assistant_association_response(response)
        }
    }
}

/// Operation shape for `DeleteContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_content`](crate::client::Client::delete_content).
///
/// See [`crate::client::fluent_builders::DeleteContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteContent {
    _private: (),
}
impl DeleteContent {
    /// Creates a new builder-style object to manufacture [`DeleteContentInput`](crate::input::DeleteContentInput)
    pub fn builder() -> crate::input::delete_content_input::Builder {
        crate::input::delete_content_input::Builder::default()
    }
    /// Creates a new `DeleteContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteContent {
    type Output =
        std::result::Result<crate::output::DeleteContentOutput, crate::error::DeleteContentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_content_error(response)
        } else {
            crate::operation_deser::parse_delete_content_response(response)
        }
    }
}

/// Operation shape for `DeleteKnowledgeBase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_knowledge_base`](crate::client::Client::delete_knowledge_base).
///
/// See [`crate::client::fluent_builders::DeleteKnowledgeBase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteKnowledgeBase {
    _private: (),
}
impl DeleteKnowledgeBase {
    /// Creates a new builder-style object to manufacture [`DeleteKnowledgeBaseInput`](crate::input::DeleteKnowledgeBaseInput)
    pub fn builder() -> crate::input::delete_knowledge_base_input::Builder {
        crate::input::delete_knowledge_base_input::Builder::default()
    }
    /// Creates a new `DeleteKnowledgeBase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteKnowledgeBase {
    type Output = std::result::Result<
        crate::output::DeleteKnowledgeBaseOutput,
        crate::error::DeleteKnowledgeBaseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_knowledge_base_error(response)
        } else {
            crate::operation_deser::parse_delete_knowledge_base_response(response)
        }
    }
}

/// Operation shape for `GetAssistant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_assistant`](crate::client::Client::get_assistant).
///
/// See [`crate::client::fluent_builders::GetAssistant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssistant {
    _private: (),
}
impl GetAssistant {
    /// Creates a new builder-style object to manufacture [`GetAssistantInput`](crate::input::GetAssistantInput)
    pub fn builder() -> crate::input::get_assistant_input::Builder {
        crate::input::get_assistant_input::Builder::default()
    }
    /// Creates a new `GetAssistant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssistant {
    type Output =
        std::result::Result<crate::output::GetAssistantOutput, crate::error::GetAssistantError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_assistant_error(response)
        } else {
            crate::operation_deser::parse_get_assistant_response(response)
        }
    }
}

/// Operation shape for `GetAssistantAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_assistant_association`](crate::client::Client::get_assistant_association).
///
/// See [`crate::client::fluent_builders::GetAssistantAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssistantAssociation {
    _private: (),
}
impl GetAssistantAssociation {
    /// Creates a new builder-style object to manufacture [`GetAssistantAssociationInput`](crate::input::GetAssistantAssociationInput)
    pub fn builder() -> crate::input::get_assistant_association_input::Builder {
        crate::input::get_assistant_association_input::Builder::default()
    }
    /// Creates a new `GetAssistantAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssistantAssociation {
    type Output = std::result::Result<
        crate::output::GetAssistantAssociationOutput,
        crate::error::GetAssistantAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_assistant_association_error(response)
        } else {
            crate::operation_deser::parse_get_assistant_association_response(response)
        }
    }
}

/// Operation shape for `GetContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_content`](crate::client::Client::get_content).
///
/// See [`crate::client::fluent_builders::GetContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContent {
    _private: (),
}
impl GetContent {
    /// Creates a new builder-style object to manufacture [`GetContentInput`](crate::input::GetContentInput)
    pub fn builder() -> crate::input::get_content_input::Builder {
        crate::input::get_content_input::Builder::default()
    }
    /// Creates a new `GetContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContent {
    type Output =
        std::result::Result<crate::output::GetContentOutput, crate::error::GetContentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_content_error(response)
        } else {
            crate::operation_deser::parse_get_content_response(response)
        }
    }
}

/// Operation shape for `GetContentSummary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_content_summary`](crate::client::Client::get_content_summary).
///
/// See [`crate::client::fluent_builders::GetContentSummary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContentSummary {
    _private: (),
}
impl GetContentSummary {
    /// Creates a new builder-style object to manufacture [`GetContentSummaryInput`](crate::input::GetContentSummaryInput)
    pub fn builder() -> crate::input::get_content_summary_input::Builder {
        crate::input::get_content_summary_input::Builder::default()
    }
    /// Creates a new `GetContentSummary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContentSummary {
    type Output = std::result::Result<
        crate::output::GetContentSummaryOutput,
        crate::error::GetContentSummaryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_content_summary_error(response)
        } else {
            crate::operation_deser::parse_get_content_summary_response(response)
        }
    }
}

/// Operation shape for `GetKnowledgeBase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_knowledge_base`](crate::client::Client::get_knowledge_base).
///
/// See [`crate::client::fluent_builders::GetKnowledgeBase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetKnowledgeBase {
    _private: (),
}
impl GetKnowledgeBase {
    /// Creates a new builder-style object to manufacture [`GetKnowledgeBaseInput`](crate::input::GetKnowledgeBaseInput)
    pub fn builder() -> crate::input::get_knowledge_base_input::Builder {
        crate::input::get_knowledge_base_input::Builder::default()
    }
    /// Creates a new `GetKnowledgeBase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetKnowledgeBase {
    type Output = std::result::Result<
        crate::output::GetKnowledgeBaseOutput,
        crate::error::GetKnowledgeBaseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_knowledge_base_error(response)
        } else {
            crate::operation_deser::parse_get_knowledge_base_response(response)
        }
    }
}

/// Operation shape for `GetRecommendations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_recommendations`](crate::client::Client::get_recommendations).
///
/// See [`crate::client::fluent_builders::GetRecommendations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRecommendations {
    _private: (),
}
impl GetRecommendations {
    /// Creates a new builder-style object to manufacture [`GetRecommendationsInput`](crate::input::GetRecommendationsInput)
    pub fn builder() -> crate::input::get_recommendations_input::Builder {
        crate::input::get_recommendations_input::Builder::default()
    }
    /// Creates a new `GetRecommendations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRecommendations {
    type Output = std::result::Result<
        crate::output::GetRecommendationsOutput,
        crate::error::GetRecommendationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_recommendations_error(response)
        } else {
            crate::operation_deser::parse_get_recommendations_response(response)
        }
    }
}

/// Operation shape for `GetSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_session`](crate::client::Client::get_session).
///
/// See [`crate::client::fluent_builders::GetSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSession {
    _private: (),
}
impl GetSession {
    /// Creates a new builder-style object to manufacture [`GetSessionInput`](crate::input::GetSessionInput)
    pub fn builder() -> crate::input::get_session_input::Builder {
        crate::input::get_session_input::Builder::default()
    }
    /// Creates a new `GetSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSession {
    type Output =
        std::result::Result<crate::output::GetSessionOutput, crate::error::GetSessionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_session_error(response)
        } else {
            crate::operation_deser::parse_get_session_response(response)
        }
    }
}

/// Operation shape for `ListAssistantAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assistant_associations`](crate::client::Client::list_assistant_associations).
///
/// See [`crate::client::fluent_builders::ListAssistantAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssistantAssociations {
    _private: (),
}
impl ListAssistantAssociations {
    /// Creates a new builder-style object to manufacture [`ListAssistantAssociationsInput`](crate::input::ListAssistantAssociationsInput)
    pub fn builder() -> crate::input::list_assistant_associations_input::Builder {
        crate::input::list_assistant_associations_input::Builder::default()
    }
    /// Creates a new `ListAssistantAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssistantAssociations {
    type Output = std::result::Result<
        crate::output::ListAssistantAssociationsOutput,
        crate::error::ListAssistantAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assistant_associations_error(response)
        } else {
            crate::operation_deser::parse_list_assistant_associations_response(response)
        }
    }
}

/// Operation shape for `ListAssistants`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assistants`](crate::client::Client::list_assistants).
///
/// See [`crate::client::fluent_builders::ListAssistants`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssistants {
    _private: (),
}
impl ListAssistants {
    /// Creates a new builder-style object to manufacture [`ListAssistantsInput`](crate::input::ListAssistantsInput)
    pub fn builder() -> crate::input::list_assistants_input::Builder {
        crate::input::list_assistants_input::Builder::default()
    }
    /// Creates a new `ListAssistants` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssistants {
    type Output =
        std::result::Result<crate::output::ListAssistantsOutput, crate::error::ListAssistantsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assistants_error(response)
        } else {
            crate::operation_deser::parse_list_assistants_response(response)
        }
    }
}

/// Operation shape for `ListContents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_contents`](crate::client::Client::list_contents).
///
/// See [`crate::client::fluent_builders::ListContents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListContents {
    _private: (),
}
impl ListContents {
    /// Creates a new builder-style object to manufacture [`ListContentsInput`](crate::input::ListContentsInput)
    pub fn builder() -> crate::input::list_contents_input::Builder {
        crate::input::list_contents_input::Builder::default()
    }
    /// Creates a new `ListContents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListContents {
    type Output =
        std::result::Result<crate::output::ListContentsOutput, crate::error::ListContentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_contents_error(response)
        } else {
            crate::operation_deser::parse_list_contents_response(response)
        }
    }
}

/// Operation shape for `ListKnowledgeBases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_knowledge_bases`](crate::client::Client::list_knowledge_bases).
///
/// See [`crate::client::fluent_builders::ListKnowledgeBases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListKnowledgeBases {
    _private: (),
}
impl ListKnowledgeBases {
    /// Creates a new builder-style object to manufacture [`ListKnowledgeBasesInput`](crate::input::ListKnowledgeBasesInput)
    pub fn builder() -> crate::input::list_knowledge_bases_input::Builder {
        crate::input::list_knowledge_bases_input::Builder::default()
    }
    /// Creates a new `ListKnowledgeBases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListKnowledgeBases {
    type Output = std::result::Result<
        crate::output::ListKnowledgeBasesOutput,
        crate::error::ListKnowledgeBasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_knowledge_bases_error(response)
        } else {
            crate::operation_deser::parse_list_knowledge_bases_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `NotifyRecommendationsReceived`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`notify_recommendations_received`](crate::client::Client::notify_recommendations_received).
///
/// See [`crate::client::fluent_builders::NotifyRecommendationsReceived`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct NotifyRecommendationsReceived {
    _private: (),
}
impl NotifyRecommendationsReceived {
    /// Creates a new builder-style object to manufacture [`NotifyRecommendationsReceivedInput`](crate::input::NotifyRecommendationsReceivedInput)
    pub fn builder() -> crate::input::notify_recommendations_received_input::Builder {
        crate::input::notify_recommendations_received_input::Builder::default()
    }
    /// Creates a new `NotifyRecommendationsReceived` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for NotifyRecommendationsReceived {
    type Output = std::result::Result<
        crate::output::NotifyRecommendationsReceivedOutput,
        crate::error::NotifyRecommendationsReceivedError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_notify_recommendations_received_error(response)
        } else {
            crate::operation_deser::parse_notify_recommendations_received_response(response)
        }
    }
}

/// Operation shape for `QueryAssistant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`query_assistant`](crate::client::Client::query_assistant).
///
/// See [`crate::client::fluent_builders::QueryAssistant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct QueryAssistant {
    _private: (),
}
impl QueryAssistant {
    /// Creates a new builder-style object to manufacture [`QueryAssistantInput`](crate::input::QueryAssistantInput)
    pub fn builder() -> crate::input::query_assistant_input::Builder {
        crate::input::query_assistant_input::Builder::default()
    }
    /// Creates a new `QueryAssistant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for QueryAssistant {
    type Output =
        std::result::Result<crate::output::QueryAssistantOutput, crate::error::QueryAssistantError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_query_assistant_error(response)
        } else {
            crate::operation_deser::parse_query_assistant_response(response)
        }
    }
}

/// Operation shape for `RemoveKnowledgeBaseTemplateUri`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_knowledge_base_template_uri`](crate::client::Client::remove_knowledge_base_template_uri).
///
/// See [`crate::client::fluent_builders::RemoveKnowledgeBaseTemplateUri`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveKnowledgeBaseTemplateUri {
    _private: (),
}
impl RemoveKnowledgeBaseTemplateUri {
    /// Creates a new builder-style object to manufacture [`RemoveKnowledgeBaseTemplateUriInput`](crate::input::RemoveKnowledgeBaseTemplateUriInput)
    pub fn builder() -> crate::input::remove_knowledge_base_template_uri_input::Builder {
        crate::input::remove_knowledge_base_template_uri_input::Builder::default()
    }
    /// Creates a new `RemoveKnowledgeBaseTemplateUri` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveKnowledgeBaseTemplateUri {
    type Output = std::result::Result<
        crate::output::RemoveKnowledgeBaseTemplateUriOutput,
        crate::error::RemoveKnowledgeBaseTemplateUriError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_remove_knowledge_base_template_uri_error(response)
        } else {
            crate::operation_deser::parse_remove_knowledge_base_template_uri_response(response)
        }
    }
}

/// Operation shape for `SearchContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_content`](crate::client::Client::search_content).
///
/// See [`crate::client::fluent_builders::SearchContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchContent {
    _private: (),
}
impl SearchContent {
    /// Creates a new builder-style object to manufacture [`SearchContentInput`](crate::input::SearchContentInput)
    pub fn builder() -> crate::input::search_content_input::Builder {
        crate::input::search_content_input::Builder::default()
    }
    /// Creates a new `SearchContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchContent {
    type Output =
        std::result::Result<crate::output::SearchContentOutput, crate::error::SearchContentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_content_error(response)
        } else {
            crate::operation_deser::parse_search_content_response(response)
        }
    }
}

/// Operation shape for `SearchSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_sessions`](crate::client::Client::search_sessions).
///
/// See [`crate::client::fluent_builders::SearchSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchSessions {
    _private: (),
}
impl SearchSessions {
    /// Creates a new builder-style object to manufacture [`SearchSessionsInput`](crate::input::SearchSessionsInput)
    pub fn builder() -> crate::input::search_sessions_input::Builder {
        crate::input::search_sessions_input::Builder::default()
    }
    /// Creates a new `SearchSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchSessions {
    type Output =
        std::result::Result<crate::output::SearchSessionsOutput, crate::error::SearchSessionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_sessions_error(response)
        } else {
            crate::operation_deser::parse_search_sessions_response(response)
        }
    }
}

/// Operation shape for `StartContentUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_content_upload`](crate::client::Client::start_content_upload).
///
/// See [`crate::client::fluent_builders::StartContentUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartContentUpload {
    _private: (),
}
impl StartContentUpload {
    /// Creates a new builder-style object to manufacture [`StartContentUploadInput`](crate::input::StartContentUploadInput)
    pub fn builder() -> crate::input::start_content_upload_input::Builder {
        crate::input::start_content_upload_input::Builder::default()
    }
    /// Creates a new `StartContentUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartContentUpload {
    type Output = std::result::Result<
        crate::output::StartContentUploadOutput,
        crate::error::StartContentUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_content_upload_error(response)
        } else {
            crate::operation_deser::parse_start_content_upload_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_content`](crate::client::Client::update_content).
///
/// See [`crate::client::fluent_builders::UpdateContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContent {
    _private: (),
}
impl UpdateContent {
    /// Creates a new builder-style object to manufacture [`UpdateContentInput`](crate::input::UpdateContentInput)
    pub fn builder() -> crate::input::update_content_input::Builder {
        crate::input::update_content_input::Builder::default()
    }
    /// Creates a new `UpdateContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContent {
    type Output =
        std::result::Result<crate::output::UpdateContentOutput, crate::error::UpdateContentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_content_error(response)
        } else {
            crate::operation_deser::parse_update_content_response(response)
        }
    }
}

/// Operation shape for `UpdateKnowledgeBaseTemplateUri`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_knowledge_base_template_uri`](crate::client::Client::update_knowledge_base_template_uri).
///
/// See [`crate::client::fluent_builders::UpdateKnowledgeBaseTemplateUri`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateKnowledgeBaseTemplateUri {
    _private: (),
}
impl UpdateKnowledgeBaseTemplateUri {
    /// Creates a new builder-style object to manufacture [`UpdateKnowledgeBaseTemplateUriInput`](crate::input::UpdateKnowledgeBaseTemplateUriInput)
    pub fn builder() -> crate::input::update_knowledge_base_template_uri_input::Builder {
        crate::input::update_knowledge_base_template_uri_input::Builder::default()
    }
    /// Creates a new `UpdateKnowledgeBaseTemplateUri` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateKnowledgeBaseTemplateUri {
    type Output = std::result::Result<
        crate::output::UpdateKnowledgeBaseTemplateUriOutput,
        crate::error::UpdateKnowledgeBaseTemplateUriError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_knowledge_base_template_uri_error(response)
        } else {
            crate::operation_deser::parse_update_knowledge_base_template_uri_response(response)
        }
    }
}
